(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[     19286,        527]
NotebookOptionsPosition[     17050,        449]
NotebookOutlinePosition[     17602,        469]
CellTagsIndexPosition[     17559,        466]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[" Tutorial", "Title",
 CellChangeTimes->{{3.539317450114971*^9, 3.5393174577917767`*^9}, 
   3.5559442666324883`*^9}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.5393174647226133`*^9, 3.5393174655928297`*^9}}],

Cell[CellGroupData[{

Cell["Loading FeynRules", "Section",
 CellChangeTimes->{{3.539317474608481*^9, 3.5393174784154987`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"$FeynRulesPath", " ", "=", " ", 
   RowBox[{
   "SetDirectory", "[", "\"\<< your feynrules-2.1 directory >\>\"", "]"}]}], 
  ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"<<", "FeynRules`"}]], "Input",
 CellChangeTimes->{{3.5393174792335243`*^9, 3.539317505486512*^9}, {
   3.5780999932057743`*^9, 3.578099993939001*^9}, {3.578100105316533*^9, 
   3.5781001104184732`*^9}, {3.579349162263041*^9, 3.5793491976568537`*^9}, {
   3.579349302055018*^9, 3.57934930213306*^9}, 3.608633940451391*^9, {
   3.608963477981021*^9, 3.608963544325245*^9}, {3.608963582948419*^9, 
   3.608963585036875*^9}, {3.608963753273656*^9, 3.608963760744379*^9}, {
   3.609237378328511*^9, 3.609237385453416*^9}, {3.609239709315632*^9, 
   3.609239745232215*^9}, {3.6094560306999083`*^9, 3.6094560314986877`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Loading the model", "Section",
 CellChangeTimes->{{3.539317514565621*^9, 3.539317517827942*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<<your Tutorial directory>\>\"", "]"}], 
  ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadModel", "[", " ", 
   RowBox[{
    RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/SM.fr\>\""}], ",", 
    "\"\<Tutorial.fr\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"LoadRestriction", "[", 
  RowBox[{
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/DiagonalCKM.rst\>\""}], 
   ",", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/Massless.rst\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.539317608005052*^9, 3.539317616212493*^9}, {
  3.555944290574006*^9, 3.555944292699313*^9}, {3.57737340515932*^9, 
  3.577373409019948*^9}, {3.579349400449449*^9, 3.579349402253819*^9}, {
  3.6086339962269583`*^9, 3.60863402018679*^9}, {3.608638181654768*^9, 
  3.6086381846615877`*^9}, {3.608893380281384*^9, 3.608893383852631*^9}, {
  3.60896361128345*^9, 3.6089636605825577`*^9}, {3.608963737687084*^9, 
  3.608963747292469*^9}, {3.609237410163652*^9, 3.6092374193769007`*^9}, {
  3.609237467438333*^9, 3.609237474678268*^9}, {3.609239769912367*^9, 
  3.609239807067588*^9}, {3.609456085173746*^9, 3.609456142895612*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Lagrangian", "Section",
 CellChangeTimes->{{3.539317863455777*^9, 3.5393178650954237`*^9}}],

Cell[BoxData[
 RowBox[{"LScalarKin", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "2"}], 
    RowBox[{"del", "[", 
     RowBox[{"pi1", ",", "mu"}], "]"}], 
    RowBox[{"del", "[", 
     RowBox[{"pi1", ",", "mu"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"1", "/", "2"}], 
    RowBox[{"del", "[", 
     RowBox[{"pi2", ",", "mu"}], "]"}], 
    RowBox[{"del", "[", 
     RowBox[{"pi2", ",", "mu"}], "]"}]}], "-", 
   RowBox[{
    RowBox[{
     RowBox[{"MM1", "^", "2"}], "/", "2"}], 
    RowBox[{"pi1", "^", "2"}]}], "-", 
   RowBox[{
    RowBox[{
     RowBox[{"MM2", "^", "2"}], "/", "2"}], 
    RowBox[{"pi2", "^", "2"}]}], "-", 
   RowBox[{
    RowBox[{"MM12", "^", "2"}], "pi1", " ", "pi2"}]}]}]], "Input",
 CellChangeTimes->{{3.5393178657972727`*^9, 3.539317921175536*^9}, {
  3.539318477867846*^9, 3.539318481606659*^9}, {3.5393189015055037`*^9, 
  3.539318908479196*^9}, {3.5793591059670963`*^9, 3.5793591107344847`*^9}}],

Cell[BoxData[
 RowBox[{"LFermionKin", "=", 
  RowBox[{
   RowBox[{"I", " ", 
    RowBox[{"uvbar", ".", 
     RowBox[{"Ga", "[", "mu", "]"}], ".", 
     RowBox[{"DC", "[", 
      RowBox[{"uv", ",", "mu"}], "]"}]}]}], "-", 
   RowBox[{"Muv", " ", 
    RowBox[{"uvbar", ".", "uv"}]}], "+", 
   RowBox[{"I", " ", 
    RowBox[{"evbar", ".", 
     RowBox[{"Ga", "[", "mu", "]"}], ".", 
     RowBox[{"DC", "[", 
      RowBox[{"ev", ",", "mu"}], "]"}]}]}], "-", 
   RowBox[{"Mev", " ", 
    RowBox[{"evbar", ".", "ev"}]}]}]}]], "Input",
 CellChangeTimes->{{3.53931793307228*^9, 3.539317979893841*^9}}],

Cell[BoxData[{
 RowBox[{"LDecays", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"lam1", "[", "ff", "]"}], " ", "pi1", " ", 
    RowBox[{
     RowBox[{"uvbar", "[", 
      RowBox[{"ss1", ",", "ii"}], "]"}], ".", 
     RowBox[{"uq", "[", 
      RowBox[{"ss2", ",", "ff", ",", "ii"}], "]"}]}], 
    RowBox[{"ProjP", "[", 
     RowBox[{"ss1", ",", "ss2"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"lam2", "[", "ff", "]"}], " ", "pi2", " ", 
    RowBox[{
     RowBox[{"uvbar", "[", 
      RowBox[{"ss1", ",", "ii"}], "]"}], ".", 
     RowBox[{"uq", "[", 
      RowBox[{"ss2", ",", "ff", ",", "ii"}], "]"}]}], 
    RowBox[{"ProjP", "[", 
     RowBox[{"ss1", ",", "ss2"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"lam1p", "[", "ff", "]"}], " ", "pi1", " ", 
    RowBox[{
     RowBox[{"evbar", "[", "ss1", "]"}], ".", 
     RowBox[{"l", "[", 
      RowBox[{"ss2", ",", "ff"}], "]"}]}], 
    RowBox[{"ProjP", "[", 
     RowBox[{"ss1", ",", "ss2"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"lam2p", "[", "ff", "]"}], " ", "pi2", " ", 
    RowBox[{
     RowBox[{"evbar", "[", "ss1", "]"}], ".", 
     RowBox[{"l", "[", 
      RowBox[{"ss2", ",", "ff"}], "]"}]}], 
    RowBox[{"ProjP", "[", 
     RowBox[{"ss1", ",", "ss2"}], "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"LDecays", "=", 
  RowBox[{"LDecays", "+", 
   RowBox[{"HC", "[", "LDecays", "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.5393179924355803`*^9, 3.5393180812160053`*^9}, {
  3.539318112141931*^9, 3.5393181200908337`*^9}, {3.555944392672977*^9, 
  3.555944544909051*^9}, {3.5798827743589373`*^9, 3.5798828027591953`*^9}, {
  3.579955834704596*^9, 3.579955838470811*^9}, {3.609229047032443*^9, 
  3.609229099058508*^9}}],

Cell[BoxData[
 RowBox[{"LNew", "=", 
  RowBox[{"LScalarKin", "+", "LFermionKin", "+", "LDecays"}]}]], "Input",
 CellChangeTimes->{{3.5393180928264513`*^9, 3.539318101951029*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Checking the hermiticity of the model", "Section",
 CellChangeTimes->{{3.5393178553626547`*^9, 3.539317857239614*^9}, {
  3.539318951729939*^9, 3.539318953814794*^9}}],

Cell[BoxData[
 RowBox[{"CheckMassSpectrum", "[", "LNew", "]"}]], "Input",
 CellChangeTimes->{{3.579350411293748*^9, 3.579350415283794*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["The Feynman rules", "Section",
 CellChangeTimes->{{3.5393189582943993`*^9, 3.5393189603102827`*^9}, 
   3.577374302527355*^9, 3.609456165723715*^9}],

Cell[BoxData[
 RowBox[{"vertices", "=", 
  RowBox[{"FeynmanRules", "[", "LNew", "]"}]}]], "Input",
 CellChangeTimes->{{3.5393189611068983`*^9, 3.539318966823897*^9}, {
  3.578100172014543*^9, 3.578100173567128*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing decays", "Section",
 CellChangeTimes->{{3.5781006310351267`*^9, 3.578100633256648*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"decays", "=", 
   RowBox[{"ComputeWidths", "[", "vertices", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.578100182561545*^9, 3.57810020224467*^9}, 
   3.5781019603591213`*^9}],

Cell[BoxData[{
 RowBox[{"x1", "=", 
  RowBox[{"PartialWidth", "[", 
   RowBox[{"{", 
    RowBox[{"uv", ",", "t", ",", "p1"}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"x2", "=", 
  RowBox[{"PartialWidth", "[", 
   RowBox[{"{", 
    RowBox[{"uv", ",", "t", ",", "p2"}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"x3", "=", 
  RowBox[{"PartialWidth", "[", 
   RowBox[{"{", 
    RowBox[{"p2", ",", "e", ",", "evbar"}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"x4", "=", 
  RowBox[{"PartialWidth", "[", 
   RowBox[{"{", 
    RowBox[{"ev", ",", "e", ",", "p1"}], "}"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.578100256478664*^9, 3.578100389458416*^9}, {
  3.578100496453477*^9, 3.578100496643045*^9}, {3.5781006406864853`*^9, 
  3.578100657875001*^9}, {3.578101047163535*^9, 3.578101063202585*^9}, {
  3.578101099217561*^9, 3.578101110441593*^9}, {3.579955894464841*^9, 
  3.579955895661914*^9}}],

Cell[BoxData[{
 RowBox[{"NumericalValue", "[", "x1", "]"}], "\[IndentingNewLine]", 
 RowBox[{"NumericalValue", "[", "x2", "]"}], "\[IndentingNewLine]", 
 RowBox[{"NumericalValue", "[", "x3", "]"}], "\[IndentingNewLine]", 
 RowBox[{"NumericalValue", "[", "x4", "]"}]}], "Input",
 CellChangeTimes->{{3.5781006598477917`*^9, 3.5781006665443563`*^9}, {
  3.578101066979349*^9, 3.5781010707919703`*^9}, {3.578101188434381*^9, 
  3.57810118966578*^9}}],

Cell[BoxData[
 RowBox[{"NumericalValue", "[", "E", "]"}]], "Input",
 CellChangeTimes->{{3.579955947947734*^9, 3.579955967217898*^9}, {
  3.579956021258586*^9, 3.579956035036762*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["UFO", "Section",
 CellChangeTimes->{{3.539319024076879*^9, 3.53931903003391*^9}, {
  3.578100803596233*^9, 3.578100804390173*^9}, {3.579359706634882*^9, 
  3.579359708801149*^9}}],

Cell[BoxData[{
 RowBox[{"SetDirectory", "[", "\"\<~/TASI2013/magdraph5/models\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"WriteUFO", "[", 
  RowBox[{"LSM", "+", "LNew"}], "]"}]}], "Input",
 CellChangeTimes->{{3.539319031354458*^9, 3.53931903608384*^9}, {
  3.579359719778757*^9, 3.579359744234468*^9}, {3.579361601368628*^9, 
  3.579361603527499*^9}, {3.579883038689376*^9, 3.579883070017232*^9}, {
  3.5798833617114*^9, 3.5798833680620728`*^9}, {3.579956090474226*^9, 
  3.5799561181857033`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["LO", "Subsubtitle",
 CellChangeTimes->{{3.6086340917530117`*^9, 3.608634092134266*^9}, 
   3.60945619871621*^9}],

Cell[BoxData[
 RowBox[{"WriteUFO", "[", 
  RowBox[{"LSM", "+", "LNew"}], "]"}]], "Input",
 CellChangeTimes->{{3.609456229975019*^9, 3.60945623834945*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["NLO", "Subsubtitle",
 CellChangeTimes->{{3.6086340917530117`*^9, 3.608634092134266*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Lren", "=", 
    RowBox[{"OnShellRenormalization", "[", 
     RowBox[{
      RowBox[{"LSM", "+", "LNew"}], ",", 
      RowBox[{"QCDOnly", "\[Rule]", "True"}]}], "]"}]}], ";"}], "//", 
  "Timing"}]], "Input",
 CellChangeTimes->{{3.60863409692767*^9, 3.608634170503137*^9}, {
  3.608634548983*^9, 3.608634587262005*^9}, {3.608638198292348*^9, 
  3.6086382008917627`*^9}, {3.6088934501371193`*^9, 3.6088934529187107`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\<<your FeynArts directory>/Models\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteFeynArtsOutput", "[", 
   RowBox[{"Lren", ",", 
    RowBox[{"Output", "\[Rule]", "\"\<Tutorial\>\""}], ",", 
    RowBox[{"GenericFile", "\[Rule]", "False"}], ",", 
    RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellChangeTimes->{{3.608634199296795*^9, 3.608634207383206*^9}, {
  3.6092398244979553`*^9, 3.609239835054557*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "FeynRules", " ", "and", " ", "FeynArts", " ", "cannot", " ", "be", " ", 
    "run", " ", "on", " ", "the", " ", "same", " ", "kernel"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Quit", "[", "]"}]}]], "Input",
 CellChangeTimes->{{3.5396224656943293`*^9, 3.5396224675263987`*^9}, {
   3.540920165454506*^9, 3.5409201672602177`*^9}, {3.5411735887243433`*^9, 
   3.54117358995798*^9}, 3.5672551259042807`*^9, {3.5765170031454678`*^9, 
   3.576517004067768*^9}, {3.578226416056175*^9, 3.578226417613206*^9}, 
   3.586791508822785*^9, {3.599199826343371*^9, 3.599199827363346*^9}, {
   3.608963790150378*^9, 3.6089638150226517`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<< your feynArts directory >\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "FeynArts`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\<< your feynrules-2.1 directory >\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "NLOCT`", " "}]}], "Input",
 CellChangeTimes->{{3.538316196319078*^9, 3.538316239931663*^9}, {
   3.539622432148899*^9, 3.5396224391996117`*^9}, {3.5396244602103443`*^9, 
   3.539624472819489*^9}, 3.541266039634444*^9, {3.55828177341271*^9, 
   3.5582817913223753`*^9}, {3.558716873498768*^9, 3.55871687452986*^9}, {
   3.563203524007196*^9, 3.5632035281723967`*^9}, 3.567255126111224*^9, {
   3.586266336159663*^9, 3.586266337517817*^9}, 3.58679150882474*^9, {
   3.5869836446500483`*^9, 3.586983647665903*^9}, {3.589710530467063*^9, 
   3.589710531323284*^9}, {3.608962970652274*^9, 3.608963033530613*^9}, {
   3.6089637828358793`*^9, 3.60896378744799*^9}, {3.6092376741012697`*^9, 
   3.6092376854927607`*^9}, {3.609239841579628*^9, 3.60923985475394*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteCT", "[", 
   RowBox[{"\"\<Tutorial/Tutorial\>\"", ",", 
    RowBox[{"(*", 
     RowBox[{"Lorentz", ",", 
      RowBox[{"Output", "->", "\"\<Tutorial\>\""}], ","}], "*)"}], 
    RowBox[{"ZeroMom", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"aS", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"F", "[", "7", "]"}], ",", 
          RowBox[{"V", "[", "4", "]"}], ",", 
          RowBox[{"-", 
           RowBox[{"F", "[", "7", "]"}]}]}], "}"}]}], "}"}], "}"}]}], ",", 
    RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"MB", ">=", "0"}], ",", 
       RowBox[{"MT", "!=", "0"}], ",", 
       RowBox[{"Muv", "\[NotEqual]", "0"}]}], "}"}]}]}], "]"}], "//", 
  "Timing", " "}]], "Input",
 CellChangeTimes->{{3.5429908380573463`*^9, 3.542990852968924*^9}, {
   3.546019242922225*^9, 3.546019248087441*^9}, 3.567255127756894*^9, 
   3.586791512975443*^9, 3.591273227343647*^9, {3.5940448978917503`*^9, 
   3.5940449489466*^9}, {3.594044984737791*^9, 3.5940449857199917`*^9}, {
   3.59429828497252*^9, 3.594298442816975*^9}, {3.59436277678543*^9, 
   3.594362865618352*^9}, {3.598933349343251*^9, 3.598933350155467*^9}, {
   3.599279025707528*^9, 3.599279062018343*^9}, {3.5992804806881037`*^9, 
   3.5992805207794867`*^9}, {3.599282665726796*^9, 3.59928269192461*^9}, {
   3.599283125998775*^9, 3.599283179547114*^9}, {3.599327804552535*^9, 
   3.599327808966741*^9}, {3.599327968924601*^9, 3.599327978153811*^9}, {
   3.599328020117506*^9, 3.599328121306513*^9}, {3.599365343099621*^9, 
   3.5993653683764753`*^9}, {3.599365561994275*^9, 3.599365565333577*^9}, {
   3.599387144801704*^9, 3.59938715346115*^9}, 3.600849997364355*^9, {
   3.6012941239195967`*^9, 3.601294126899929*^9}, {3.60309027247163*^9, 
   3.6030902809158297`*^9}, {3.6040631594740143`*^9, 3.604063166706565*^9}, {
   3.604063232093589*^9, 3.604063240771006*^9}, {3.6086342663526697`*^9, 
   3.608634313429428*^9}, 3.608634866646411*^9, {3.608635515499292*^9, 
   3.608635518601149*^9}, {3.60889446661064*^9, 3.6088944897924137`*^9}, {
   3.608896370886236*^9, 3.608896371911961*^9}, {3.608897380688074*^9, 
   3.608897387711965*^9}, 3.609160814290598*^9, {3.609224873774807*^9, 
   3.609224886276362*^9}, {3.609226402546694*^9, 3.609226426663886*^9}, {
   3.609231034515636*^9, 3.609231037787662*^9}, {3.609237613901999*^9, 
   3.60923761754937*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Quit", ",", " ", 
    RowBox[{
    "reload", " ", "FR", " ", "and", " ", "the", " ", "model", " ", 
     "then"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
    "SetDirectory", "[", "\"\<< your feynrules-2.1 directory >\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Get", "[", "\"\<Tutorial.nlo\>\"", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.608636248193049*^9, 3.608636249895192*^9}, {
   3.60896385451575*^9, 3.6089638800483723`*^9}, {3.609235355058819*^9, 
   3.6092353585605173`*^9}, {3.6092376429817457`*^9, 3.609237665117955*^9}, 
   3.609239865588791*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<<your mg5_amc>/models\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{
    RowBox[{"LNew", "+", "LSM"}], ",", 
    RowBox[{"UVCounterterms", "\[Rule]", "UV$vertlist"}], ",", 
    RowBox[{"R2Vertices", "\[Rule]", "R2$vertlist"}], ",", 
    RowBox[{"Output", "\[Rule]", "\"\<Tutorial\>\""}]}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellChangeTimes->{{3.6086363376663*^9, 3.60863636303941*^9}, {
   3.608638993440543*^9, 3.608638996155736*^9}, {3.6088983558164167`*^9, 
   3.608898358307691*^9}, 3.6092289654126253`*^9, 3.609235423495871*^9, {
   3.6092399084339046`*^9, 3.609239918760147*^9}}]
}, Closed]]
}, Open  ]]
},
WindowSize->{1276, 756},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> True}},
ShowSelection->True,
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[422, 15, 122, 2, 115, "Title"],
Cell[547, 19, 122, 2, 40, "Input"],
Cell[CellGroupData[{
Cell[694, 25, 104, 1, 101, "Section"],
Cell[801, 28, 176, 5, 40, "Input"],
Cell[980, 35, 641, 9, 40, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1658, 49, 102, 1, 101, "Section"],
Cell[1763, 52, 118, 3, 40, "Input"],
Cell[1884, 57, 1081, 20, 87, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3002, 82, 101, 1, 101, "Section"],
Cell[3106, 85, 930, 27, 64, "Input"],
Cell[4039, 114, 593, 17, 40, "Input"],
Cell[4635, 133, 1669, 44, 110, "Input"],
Cell[6307, 179, 178, 3, 40, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[6522, 187, 173, 2, 54, "Section"],
Cell[6698, 191, 139, 2, 40, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[6874, 198, 154, 2, 54, "Section"],
Cell[7031, 202, 215, 4, 40, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[7283, 211, 103, 1, 54, "Section"],
Cell[7389, 214, 213, 5, 40, "Input"],
Cell[7605, 221, 930, 24, 110, "Input"],
Cell[8538, 247, 446, 7, 110, "Input"],
Cell[8987, 256, 182, 3, 40, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9206, 264, 185, 3, 101, "Section"],
Cell[9394, 269, 503, 9, 216, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[9934, 283, 118, 2, 40, "Subsubtitle"],
Cell[10055, 287, 154, 3, 40, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[10246, 295, 94, 1, 40, "Subsubtitle"],
Cell[10343, 298, 466, 11, 40, "Input"],
Cell[10812, 311, 540, 13, 76, "Input"],
Cell[11355, 326, 689, 13, 53, "Input"],
Cell[12047, 341, 1102, 19, 110, "Input"],
Cell[13152, 362, 2482, 47, 53, "Input"],
Cell[15637, 411, 680, 17, 76, "Input"],
Cell[16320, 430, 702, 15, 88, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)

