#include <math.h>
#include "clooptools.h"

static int inited = 0;

double psq(double p[4])
{
    return p[0] * p[0] - p[1] * p[1] - p[2] * p[2] - p[3]*p[3];
}
double p_sum_sq(double p1[4], double p2[4])
{
    double p3[4];
    for (int i = 0; i < 4; ++i)
    {
        p3[i] = p1[i] + p2[i];
    }
    return psq(p3);
}

void clearltcache()
{
    static int i = 0;
    ++i;
    if (i == 100000)
    {
        clearcache();
        i = 0;
    }
}

extern "C" double hvvcoef1_(double p1[4], double p2[4], double& mv, double& mh)
{
    if (inited == 0)
    {
        ltini();
        inited = 1;
    }
    clearltcache();
    double p1sq = psq(p1);
    double p2sq = psq(p2);
    double p3sq = p_sum_sq(p1,p2);
    double coef_b0 = real(B0i(bb0, p3sq, mh*mh, mh*mh));
    double coef_c0 = real(C0i(cc0, p1sq, p3sq, p2sq, mv*mv, mh*mh, mh*mh));
    double coef_c00 = real(C0i(cc00, p1sq, p3sq, p2sq, mv*mv, mh*mh, mh*mh));
    double res = -6*coef_b0-24*coef_c0*mv*mv+24*coef_c00;
    //printf("p3sq=%lf res=\n", p3sq,res);
    //printf("coef1=%lfp1sq=%lfp2sq=%lfmv=%lf\n", res, p1sq, p2sq, mv);
    return res;
}

extern "C" double hvvcoef2_(double p1[4], double p2[4], double& mv, double& mh)
{
    if (inited == 0)
    {
        ltini();
        inited = 1;
    }
    clearltcache();
    double p1sq = psq(p1);
    double p2sq = psq(p2);
    double p3sq = p_sum_sq(p1,p2);
    double coef_c12 = real(C0i(cc12, p1sq, p3sq, p2sq, mv*mv, mh*mh, mh*mh));
    double res = -24*coef_c12;
    //printf("coef2=%lfp1sq=%lfp2sq=%lfmv=%lf\n", res, p1sq, p2sq, mv);
    return res;
}
