# This file was automatically created by FeynRules $Revision: 535 $
# Mathematica version: 7.0 for Mac OS X x86 (64-bit) (November 11, 2008)
# Date: Fri 18 Mar 2011 18:40:51

from object_library import all_CTparameters, CTParameter

from function_library import complexconjugate, re, im, csc, sec, acsc, asec, arg, reglog,reglogp,reglogm,recms

################
# R2 vertices  #
################

# ========= #
# Pure QCD  #
# ========= #

RGR2 = CTParameter(name = 'RGR2',
              type = 'real',
              value = {0:'-(3.0/2.0)*G**4/(96.0*cmath.pi**2)'},
              texname = 'RGR2')

# ============== #
# Mixed QCD-QED  #
# ============== #

R2MixedFactor = CTParameter(name = 'R2MixedFactor',
              type = 'real',
              value = {0:'-(G**2*(1.0+lhv)*(Ncol**2-1.0))/(2.0*Ncol*16.0*cmath.pi**2)'},
              texname = 'R2MixedFactor')

# ============== #
# Pure QED       #
# ============== #

R2SS = CTParameter(name = 'R2SS',
        type = 'real',
        value = {0:'ee**2/(16.0*cmath.pi**2*sw**2)'},
        texname = 'R2SS')

R2VV = CTParameter(name = 'R2VV',
                   type = 'real',
                   value = {0:'ee**2/cmath.pi**2'},
                   texname = 'R2VV')

R2SFF = CTParameter(name = 'R2SFF',
                    type = 'real',
                    value = {0:'ee**3/cmath.pi**2'},
                    texname = 'R2SFF')

R24S = CTParameter(name = 'R24S',
                     type = 'real',
                     value = {0:'ee**4/cmath.pi**2'},
                     texname = 'R24S')

# ============== #
# Mixed QED-QCD  #
# ============== #

R2GQQ2 = CTParameter(name = 'R2GQQ2',
                     type = 'real',
                     value = {0:'-G*ee**2/cmath.pi**2'},
                     texname = 'R2GQQ2')

################
# UV vertices  #
################

# ========= #
# Pure QCD  #
# ========= #

G_UVg = CTParameter(name = 'G_UVg',
                    type = 'real',
                    value = {-1:'-((G**2)/(2.0*48.0*cmath.pi**2))*11.0*CA'},
                    texname = '\delta Gg')

G_UVq = CTParameter(name = 'G_UVq',
                    type = 'real',
                    value = {-1:'((G**2)/(2.0*48.0*cmath.pi**2))*4.0*TF'},
                    texname = '\delta Gq')

G_UVc = CTParameter(name = 'G_UVc',
                    type = 'real',
                    value = {-1:'((G**2)/(2.0*48.0*cmath.pi**2))*4.0*TF',
                    0:'cond(MC,0.0,-((G**2)/(2.0*48.0*cmath.pi**2))*4.0*TF*reglog(MC**2/MU_R**2))'},
                    texname = '\delta Gc')

G_UVb = CTParameter(name = 'G_UVb',
                    type = 'real',
                    value = {-1:'((G**2)/(2.0*48.0*cmath.pi**2))*4.0*TF',
                    0:'cond(MB,0.0,-((G**2)/(2.0*48.0*cmath.pi**2))*4.0*TF*reglog(MB**2/MU_R**2))'},
                    texname = '\delta Gb')

G_UVt = CTParameter(name = 'G_UVt',
                    type = 'real',
                    value = {-1:'((G**2)/(2.0*48.0*cmath.pi**2))*4.0*TF',
                    0:'cond(MT,0.0,-((G**2)/(2.0*48.0*cmath.pi**2))*4.0*TF*reglog(MT**2/MU_R**2))'},
                    texname = '\delta Gt')

GWcft_UV_c = CTParameter(name = 'GWcft_UV_c',
                         type = 'real',
                         value = {-1:'cond(MC,0.0,-((G**2)/(2.0*48.0*cmath.pi**2))*4.0*TF)',
                         0:'cond(MC,0.0,((G**2)/(2.0*48.0*cmath.pi**2))*4.0*TF*reglog(MC**2/MU_R**2))'
                         },
                         texname = '\delta G_{wfct\_c}')

GWcft_UV_b = CTParameter(name = 'GWcft_UV_b',
                         type = 'real',
                         value = {-1:'cond(MB,0.0,-((G**2)/(2.0*48.0*cmath.pi**2))*4.0*TF)',
                         0:'cond(MB,0.0,((G**2)/(2.0*48.0*cmath.pi**2))*4.0*TF*reglog(MB**2/MU_R**2))'
                         },
                         texname = '\delta G_{wfct\_b}')

GWcft_UV_t = CTParameter(name = 'GWcft_UV_t',
                         type = 'real',
                         value = {-1:'cond(MT,0.0,-((G**2)/(2.0*48.0*cmath.pi**2))*4.0*TF)',
                         0:'cond(MT,0.0,((G**2)/(2.0*48.0*cmath.pi**2))*4.0*TF*reglog(MT**2/MU_R**2))'
                         },
                         texname = '\delta G_{wfct\_t}')

cWcft_UV = CTParameter(name = 'cWcft_UV',
                       type = 'real',
                       value = {-1:'cond(MC,0.0,-((G**2)/(2.0*16.0*cmath.pi**2))*3.0*CF)',
                       0:'cond(MC,0.0,-((G**2)/(2.0*16.0*cmath.pi**2))*CF*(4.0-3.0*reglog(MC**2/MU_R**2)))'
                       },
                       texname = '\delta Z_c')

bWcft_UV = CTParameter(name = 'bWcft_UV',
                       type = 'real',
                       value = {-1:'cond(MB,0.0,-((G**2)/(2.0*16.0*cmath.pi**2))*3.0*CF)',
                       0:'cond(MB,0.0,-((G**2)/(2.0*16.0*cmath.pi**2))*CF*(4.0-3.0*reglog(MB**2/MU_R**2)))'
                       },
                       texname = '\delta Z_b')

tWcft_UV = CTParameter(name = 'tWcft_UV',
                       type = 'real',
                       value = {-1:'cond(MT,0.0,-((G**2)/(2.0*16.0*cmath.pi**2))*3.0*CF)',
                       0:'cond(MT,0.0,-((G**2)/(2.0*16.0*cmath.pi**2))*CF*(4.0-3.0*reglog(MT**2/MU_R**2)))'
                       },
                       texname = '\delta Z_t')

bMass_UV = CTParameter(name = 'bMass_UV',
                       type = 'complex',
                       value = {-1:'cond(MB,0.0,complex(0,1)*((G**2)/(16.0*cmath.pi**2))*(3.0*CF)*MB)',
                       0:'cond(MB,0.0,complex(0,1)*((G**2)/(16.0*cmath.pi**2))*CF*(4.0-3.0*reglog(MB**2/MU_R**2))*MB)'
                       },
                       texname = '\delta m_b')

cMass_UV = CTParameter(name = 'cMass_UV',
                       type = 'complex',
                       value = {-1:'cond(MC,0.0,complex(0,1)*((G**2)/(16.0*cmath.pi**2))*(3.0*CF)*MC)',
                       0:'cond(MC,0.0,complex(0,1)*((G**2)/(16.0*cmath.pi**2))*CF*(4.0-3.0*reglog(MC**2/MU_R**2))*MC)'
                       },
                       texname = '\delta m_c')

tMass_UV = CTParameter(name = 'tMass_UV',
                       type = 'complex',
                       value = {-1:'cond(MT,0.0,complex(0,1)*((G**2)/(16.0*cmath.pi**2))*3.0*CF*MT)',
                       0:'cond(MT,0.0,complex(0,1)*((G**2)/(16.0*cmath.pi**2))*CF*(4.0-3.0*reglog(MT**2/MU_R**2))*MT)'
                       },
                       texname = '\delta m_t')



# ================================== #
# QED                                #
# Generate automatically by WriteUFO #
# ================================== #

# ================================================ #
# QED UV parameters                                #
# Following UV parameters should be added if MB!=0 #
# ================================================ #

dMB_HiggsTadpole_UV_EW = CTParameter(name = 'dMB_HiggsTadpole_UV_EW',
                                     type = 'complex',
                                     value = {-1:'( 0 if MB == 0 else recms(CMSParam==1.0,(ee*MB**4*Ncol)/(8.*MW*cmath.pi**2*sw)) )',
                                               0:'( 0 if MB == 0 else recms(CMSParam==1.0,(ee*MB**4*Ncol*(1 - reglog(MB**2/MU_R**2)))/(8.*MW*cmath.pi**2*sw)) )'},
                                     texname = '\delta ht^{EW,MB}')


dMB_tMass_UV_EW = CTParameter(name = 'dMB_tMass_UV_EW',
                              type = 'complex',
                              value = {-1:'( 0 if MB == 0 else recms(CMSParam==1.0 and WT != 0,(-3*ee**2*MB**2*MT)/(128.*MW**2*cmath.pi**2*sw**2)) )',
                                        0:'( 0 if MB == 0 else recms(CMSParam==1.0 and WT != 0,(ee**2*(9*cw**2*MB**4 - 45*cw**2*MB**2*MT**2 + 9*cw**2*MB**2*MW**2 - 9*cw**2*MT**4*reglog(16.) + 48*MT**2*MW**2*sw**2*reglog(16.) - 64*cw**2*MT**2*MW**2*sw**2*reglog(16.) - 64*MT**2*MW**2*sw**4*reglog(16.) - 45*cw**2*MT**4*reglog(cmath.pi) - 18*cw**2*MT**2*MW**2*reglog(cmath.pi) + 192*MT**2*MW**2*sw**2*reglog(cmath.pi) - 272*cw**2*MT**2*MW**2*sw**2*reglog(cmath.pi) - 256*MT**2*MW**2*sw**4*reglog(cmath.pi) + 54*cw**2*MT**4*reglog(2*cmath.pi) + 36*cw**2*MT**2*MW**2*reglog(2*cmath.pi) - 192*MT**2*MW**2*sw**2*reglog(2*cmath.pi) + 288*cw**2*MT**2*MW**2*sw**2*reglog(2*cmath.pi) + 256*MT**2*MW**2*sw**4*reglog(2*cmath.pi) - 9*cw**2*MT**4*reglog(4*cmath.pi) - 18*cw**2*MT**2*MW**2*reglog(4*cmath.pi) - 16*cw**2*MT**2*MW**2*sw**2*reglog(4*cmath.pi)))/(1152.*cw**2*MT*MW**2*cmath.pi**2*sw**2) - (ee**2*MB**2*(MB**2 + MT**2 + 2*MW**2)*(-reglog(MB**2/MU_R**2)))/(128.*MT*MW**2*cmath.pi**2*sw**2) - (ee**2*(MT**4 - MB**2*MW**2 + MT**2*MW**2 - 2*MW**4)*reglog(MU_R**2/MW**2))/(128.*MT*MW**2*cmath.pi**2*sw**2) - (ee**2*(MB**4 - 2*MB**2*MT**2 + MT**4 + MB**2*MW**2 + MT**2*MW**2 - 2*MW**4)*reglog((MT**2 + vep*complex(0,-1))/MU_R**2))/(128.*MT*MW**2*cmath.pi**2*sw**2) + (ee**2*(MT - MW)**2*(MT + MW)**2*(MT**2 + 2*MW**2)*reglogm((-MT**2 + MW**2 + vep*complex(0,-1))/MW**2))/(128.*MT**3*MW**2*cmath.pi**2*sw**2) - (ee**2*(MB**4 - 2*MB**2*MT**2 + MT**4 + MB**2*MW**2 + MT**2*MW**2 - 2*MW**4)*reglogm((MB**2 - MT**2 - MW**2 - cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MT**2*(MB**2 + vep*complex(0,-1))))/(2.*MT**2)))/(128.*MT*MW**2*cmath.pi**2*sw**2) - (ee**2*(MB**4 - 2*MB**2*MT**2 + MT**4 + MB**2*MW**2 + MT**2*MW**2 - 2*MW**4)*reglogm((MB**2 - MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MT**2*(MB**2 + vep*complex(0,-1))))/(2.*MT**2)))/(128.*MT*MW**2*cmath.pi**2*sw**2) + (ee**2*(MB**4 - 2*MB**2*MT**2 + MT**4 + MB**2*MW**2 + MT**2*MW**2 - 2*MW**4)*(MB**2 + MT**2 - MW**2 + cmath.sqrt(MB**4 - 2*MB**2*MT**2 + MT**4 - 2*MB**2*MW**2 - 2*MT**2*MW**2 + MW**4 + MT**2*vep*complex(0,4)))*reglogm((MB**2 - MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MT**2*(MB**2 + vep*complex(0,-1))))/(MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MT**2*(MB**2 + vep*complex(0,-1))))))/(256.*MT**3*MW**2*cmath.pi**2*sw**2) + (ee**2*(MB**4 - 2*MB**2*MT**2 + MT**4 + MB**2*MW**2 + MT**2*MW**2 - 2*MW**4)*(MB**2 + MT**2 - MW**2 - cmath.sqrt(MB**4 - 2*MB**2*MT**2 + MT**4 - 2*MB**2*MW**2 - 2*MT**2*MW**2 + MW**4 + MT**2*vep*complex(0,4)))*reglogm((-MB**2 + MT**2 + MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MT**2*(MB**2 + vep*complex(0,-1))))/(-MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MT**2*(MB**2 + vep*complex(0,-1))))))/(256.*MT**3*MW**2*cmath.pi**2*sw**2)) )'},
                              texname = '\delta m_t^{EW,MB}')


dMB_bMass_UV_EW = CTParameter(name = 'dMB_bMass_UV_EW',
                              type = 'complex',
                              value = {-1:'( 0 if MB == 0 else recms(CMSParam==1.0,(ee**2*MB*(MW**2*(3 + 12*sw**2 - 8*sw**4) + cw**2*(9*MB**2 - 9*MT**2 + 2*MW**2*(3 - 4*sw**2))))/(384.*cw**2*MW**2*cmath.pi**2*sw**2)) )',
                                        0:'( 0 if MB == 0 else recms(CMSParam==1.0,-(ee**2*(-72*cw**2*MB**4 + 9*cw**2*MB**2*MH**2 + 45*cw**2*MB**2*MT**2 - 9*cw**2*MT**4 - 18*MB**2*MW**2 - 9*cw**2*MB**2*MW**2 - 9*cw**2*MT**2*MW**2 + 18*cw**2*MW**4 + 9*cw**2*MB**2*MZ**2 + 9*MW**2*MZ**2 - 48*MB**2*MW**2*sw**2 + 32*cw**2*MB**2*MW**2*sw**2 - 12*MW**2*MZ**2*sw**2 + 32*MB**2*MW**2*sw**4 + 8*MW**2*MZ**2*sw**4 - 9*cw**2*MB**4*reglog(16.) - 24*MB**2*MW**2*sw**2*reglog(16.) + 16*cw**2*MB**2*MW**2*sw**2*reglog(16.) + 16*MB**2*MW**2*sw**4*reglog(16.) + 9*cw**2*MB**4*reglog(1/(4.*cmath.pi)) + 9*MB**2*MW**2*reglog(1/(4.*cmath.pi)) - 12*MB**2*MW**2*sw**2*reglog(1/(4.*cmath.pi)) + 4*MB**2*MW**2*sw**4*reglog(1/(4.*cmath.pi)) - 18*cw**2*MB**4*reglog(cmath.pi) + 18*cw**2*MB**2*MW**2*reglog(cmath.pi) - 48*MB**2*MW**2*sw**2*reglog(cmath.pi) + 40*cw**2*MB**2*MW**2*sw**2*reglog(cmath.pi) + 32*MB**2*MW**2*sw**4*reglog(cmath.pi) - 36*cw**2*MB**2*MW**2*reglog(2*cmath.pi) - 16*cw**2*MB**2*MW**2*sw**2*reglog(2*cmath.pi) + 27*cw**2*MB**4*reglog(4*cmath.pi) + 9*MB**2*MW**2*reglog(4*cmath.pi) + 18*cw**2*MB**2*MW**2*reglog(4*cmath.pi) + 36*MB**2*MW**2*sw**2*reglog(4*cmath.pi) - 24*cw**2*MB**2*MW**2*sw**2*reglog(4*cmath.pi) - 28*MB**2*MW**2*sw**4*reglog(4*cmath.pi)))/(1152.*cw**2*MB*MW**2*cmath.pi**2*sw**2) - (ee**2*MB*(18*cw**2*MB**2 + 9*MW**2 - 12*MW**2*sw**2 + 24*cw**2*MW**2*sw**2 + 8*MW**2*sw**4)*(-reglog(MB**2/MU_R**2)))/(1152.*cw**2*MW**2*cmath.pi**2*sw**2) + (ee**2*MB*MH**2*reglog(MU_R**2/MH**2))/(128.*MW**2*cmath.pi**2*sw**2) - (ee**2*MT**2*(MB**2 + MT**2 + 2*MW**2)*reglog(MU_R**2/MT**2))/(128.*MB*MW**2*cmath.pi**2*sw**2) + (ee**2*(MB**2 + MT**2 + 2*MW**2)*reglog(MU_R**2/MW**2))/(128.*MB*cmath.pi**2*sw**2) + (ee**2*MZ**2*(9*cw**2*MB**2 + 9*MW**2 - 12*MW**2*sw**2 + 8*MW**2*sw**4)*reglog(MU_R**2/MZ**2))/(1152.*cw**2*MB*MW**2*cmath.pi**2*sw**2) - (ee**2*(45*cw**2*MB**4 - 9*cw**2*MB**2*MH**2 - 18*cw**2*MB**2*MT**2 + 9*cw**2*MT**4 + 18*MB**2*MW**2 + 9*cw**2*MB**2*MW**2 + 9*cw**2*MT**2*MW**2 - 18*cw**2*MW**4 - 9*cw**2*MB**2*MZ**2 - 9*MW**2*MZ**2 + 24*MB**2*MW**2*sw**2 + 12*MW**2*MZ**2*sw**2 - 16*MB**2*MW**2*sw**4 - 8*MW**2*MZ**2*sw**4)*reglog((MB**2 + vep*complex(0,-1))/MU_R**2))/(1152.*cw**2*MB*MW**2*cmath.pi**2*sw**2) - (ee**2*MB*(2*MB - MH)*(2*MB + MH)*reglogm((-MH**2 - cmath.sqrt(MH**4 - 4*MB**2*(MH**2 + vep*complex(0,-1))))/(2.*MB**2)))/(128.*MW**2*cmath.pi**2*sw**2) - (ee**2*MB*(2*MB - MH)*(2*MB + MH)*reglogm((-MH**2 + cmath.sqrt(MH**4 - 4*MB**2*(MH**2 + vep*complex(0,-1))))/(2.*MB**2)))/(128.*MW**2*cmath.pi**2*sw**2) + (ee**2*(2*MB - MH)*(2*MB + MH)*(2*MB**2 - MH**2 + cmath.sqrt(-4*MB**2*MH**2 + MH**4 + MB**2*vep*complex(0,4)))*reglogm((-MH**2 + cmath.sqrt(MH**4 - 4*MB**2*(MH**2 + vep*complex(0,-1))))/(2*MB**2 - MH**2 + cmath.sqrt(MH**4 - 4*MB**2*(MH**2 + vep*complex(0,-1))))))/(256.*MB*MW**2*cmath.pi**2*sw**2) + (ee**2*(2*MB - MH)*(2*MB + MH)*(2*MB**2 - MH**2 - cmath.sqrt(-4*MB**2*MH**2 + MH**4 + MB**2*vep*complex(0,4)))*reglogm((MH**2 + cmath.sqrt(MH**4 - 4*MB**2*(MH**2 + vep*complex(0,-1))))/(-2*MB**2 + MH**2 + cmath.sqrt(MH**4 - 4*MB**2*(MH**2 + vep*complex(0,-1))))))/(256.*MB*MW**2*cmath.pi**2*sw**2) - (ee**2*(MB**4 - 2*MB**2*MT**2 + MT**4 + MB**2*MW**2 + MT**2*MW**2 - 2*MW**4)*reglogm((-MB**2 + MT**2 - MW**2 - cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))/(2.*MB**2)))/(128.*MB*MW**2*cmath.pi**2*sw**2) - (ee**2*(MB**4 - 2*MB**2*MT**2 + MT**4 + MB**2*MW**2 + MT**2*MW**2 - 2*MW**4)*reglogm((-MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))/(2.*MB**2)))/(128.*MB*MW**2*cmath.pi**2*sw**2) + (ee**2*(MB**4 - 2*MB**2*MT**2 + MT**4 + MB**2*MW**2 + MT**2*MW**2 - 2*MW**4)*(MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))*reglogm((-MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))/(MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))))/(256.*MB**3*MW**2*cmath.pi**2*sw**2) + (ee**2*(MB**4 - 2*MB**2*MT**2 + MT**4 + MB**2*MW**2 + MT**2*MW**2 - 2*MW**4)*(MB**2 + MT**2 - MW**2 - cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))*reglogm((MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))/(-MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))))/(256.*MB**3*MW**2*cmath.pi**2*sw**2) + (ee**2*(-18*MB**2*MW**2 + 9*cw**2*MB**2*MZ**2 + 9*MW**2*MZ**2 - 24*MB**2*MW**2*sw**2 - 12*MW**2*MZ**2*sw**2 + 16*MB**2*MW**2*sw**4 + 8*MW**2*MZ**2*sw**4)*reglogm((-MZ**2 - cmath.sqrt(MZ**4 - 4*MB**2*(MZ**2 + vep*complex(0,-1))))/(2.*MB**2)))/(1152.*cw**2*MB*MW**2*cmath.pi**2*sw**2) + (ee**2*(-18*MB**2*MW**2 + 9*cw**2*MB**2*MZ**2 + 9*MW**2*MZ**2 - 24*MB**2*MW**2*sw**2 - 12*MW**2*MZ**2*sw**2 + 16*MB**2*MW**2*sw**4 + 8*MW**2*MZ**2*sw**4)*reglogm((-MZ**2 + cmath.sqrt(MZ**4 - 4*MB**2*(MZ**2 + vep*complex(0,-1))))/(2.*MB**2)))/(1152.*cw**2*MB*MW**2*cmath.pi**2*sw**2) - (ee**2*(-18*MB**2*MW**2 + 9*cw**2*MB**2*MZ**2 + 9*MW**2*MZ**2 - 24*MB**2*MW**2*sw**2 - 12*MW**2*MZ**2*sw**2 + 16*MB**2*MW**2*sw**4 + 8*MW**2*MZ**2*sw**4)*(2*MB**2 - MZ**2 + cmath.sqrt(-4*MB**2*MZ**2 + MZ**4 + MB**2*vep*complex(0,4)))*reglogm((-MZ**2 + cmath.sqrt(MZ**4 - 4*MB**2*(MZ**2 + vep*complex(0,-1))))/(2*MB**2 - MZ**2 + cmath.sqrt(MZ**4 - 4*MB**2*(MZ**2 + vep*complex(0,-1))))))/(2304.*cw**2*MB**3*MW**2*cmath.pi**2*sw**2) - (ee**2*(-18*MB**2*MW**2 + 9*cw**2*MB**2*MZ**2 + 9*MW**2*MZ**2 - 24*MB**2*MW**2*sw**2 - 12*MW**2*MZ**2*sw**2 + 16*MB**2*MW**2*sw**4 + 8*MW**2*MZ**2*sw**4)*(2*MB**2 - MZ**2 - cmath.sqrt(-4*MB**2*MZ**2 + MZ**4 + MB**2*vep*complex(0,4)))*reglogm((MZ**2 + cmath.sqrt(MZ**4 - 4*MB**2*(MZ**2 + vep*complex(0,-1))))/(-2*MB**2 + MZ**2 + cmath.sqrt(MZ**4 - 4*MB**2*(MZ**2 + vep*complex(0,-1))))))/(2304.*cw**2*MB**3*MW**2*cmath.pi**2*sw**2)) )'},
                              texname = '\delta m_t^{EW,MB}')


dMB_HMass2_UV_EW = CTParameter(name = 'dMB_HMass2_UV_EW',
                               type = 'complex',
                               value = {-1:'( 0 if MB == 0 else recms(CMSParam==1.0 and WH != 0,-(ee**2*MB**2*(6*MB**2 - MH**2)*Ncol)/(32.*MW**2*cmath.pi**2*sw**2)) )',
                                         0:'( 0 if MB == 0 else recms(CMSParam==1.0 and WH != 0,(ee**2*MB**2*Ncol*(-40*MB**2 + 8*MH**2 + MH**2*reglog(256.) - MB**2*reglog(281474976710656.) - 24*MB**2*reglog(cmath.pi) + 4*MH**2*reglog(cmath.pi) + 4*(6*MB**2 - MH**2)*reglog(4*cmath.pi) - 8*MB**2*(-reglog(MB**2/MU_R**2)) + 4*(2*MB - MH)*(2*MB + MH)*reglog((MH**2 + vep*complex(0,-1))/MU_R**2) + 4*(2*MB - MH)*(2*MB + MH)*reglogm((-MH**2 + cmath.sqrt(MH**2*(-4*MB**2 + MH**2 + vep*complex(0,4))))/(2.*MH**2)) - (2*(2*MB - MH)*(2*MB + MH)*(MH**2 + cmath.sqrt(MH**2*(-4*MB**2 + MH**2 + vep*complex(0,4))))*reglogm((-MH**2 + cmath.sqrt(MH**2*(-4*MB**2 + MH**2 + vep*complex(0,4))))/(MH**2 + cmath.sqrt(MH**2*(-4*MB**2 + MH**2 + vep*complex(0,4))))))/MH**2 + 4*(2*MB - MH)*(2*MB + MH)*reglogm(-(MH**2 + cmath.sqrt(MH**2*(-4*MB**2 + MH**2 + vep*complex(0,4))))/(2.*MH**2)) + (2*(-2*MB + MH)*(2*MB + MH)*(MH**2 - cmath.sqrt(MH**2*(-4*MB**2 + MH**2 + vep*complex(0,4))))*reglogm((MH**2 + cmath.sqrt(MH**2*(-4*MB**2 + MH**2 + vep*complex(0,4))))/(-MH**2 + cmath.sqrt(MH**2*(-4*MB**2 + MH**2 + vep*complex(0,4))))))/MH**2))/(128.*MW**2*cmath.pi**2*sw**2)) )'},
                               texname = '\delta m2_H^{EW,MB}')


dMB_WMass2_UV_EW = CTParameter(name = 'dMB_WMass2_UV_EW',
                               type = 'complex',
                               value = {-1:'( 0 if MB == 0 else recms(CMSParam==1.0 and WW != 0,-(ee**2*MB**2*Ncol)/(32.*cmath.pi**2*sw**2)) )',
                                         0:'( 0 if MB == 0 else recms(CMSParam==1.0 and WW != 0,(ee**2*Ncol*(6*MB**2*reglog(4*cmath.pi) + (-2*MB**2*MW**2*(MB**2 - 2*MT**2 + MW**2*(2 + reglog(64.) + 3*reglog(cmath.pi))) + 2*MB**2*MW**2*(MB**2 - MT**2 - 2*MW**2)*(-reglog(MB**2/MU_R**2)) + 2*MW**2*(-(MB**2*MT**2) + MT**4 + MT**2*MW**2 - 2*MW**4)*reglog(MU_R**2/MT**2) + 2*(MT - MW)**2*(MT + MW)**2*(MT**2 + 2*MW**2)*reglogm((MT**2 - MW**2 + vep*complex(0,-1))/MT**2) - 2*MW**2*(-MB**4 - MT**4 - MT**2*MW**2 + 2*MW**4 + MB**2*(2*MT**2 - MW**2))*reglog((MW**2 + vep*complex(0,-1))/MU_R**2) - 2*MW**2*(-MB**4 - MT**4 - MT**2*MW**2 + 2*MW**4 + MB**2*(2*MT**2 - MW**2))*reglogm((MB**2 - MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(2.*MW**2)) - (MB**4 + MT**4 + MT**2*MW**2 - 2*MW**4 + MB**2*(-2*MT**2 + MW**2))*(MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))*reglogm((MB**2 - MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))) - 2*MW**2*(-MB**4 - MT**4 - MT**2*MW**2 + 2*MW**4 + MB**2*(2*MT**2 - MW**2))*reglogm(-(-MB**2 + MT**2 + MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(2.*MW**2)) + (MB**4 + MT**4 + MT**2*MW**2 - 2*MW**4 + MB**2*(-2*MT**2 + MW**2))*(-MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))*reglogm((-MB**2 + MT**2 + MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(-MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))))/MW**4))/(192.*cmath.pi**2*sw**2)) )'},
                               texname = '\delta m2_W^{EW,MB}')


dMB_ZMass2_UV_EW = CTParameter(name = 'dMB_ZMass2_UV_EW',
                               type = 'complex',
                               value = {-1:'( 0 if MB == 0 else recms(CMSParam==1.0 and WZ != 0,-(ee**2*MB**2*Ncol)/(32.*cw**2*cmath.pi**2*sw**2)) )',
                                         0:'( 0 if MB == 0 else recms(CMSParam==1.0 and WZ != 0,(ee**2*(2*MB**2*Ncol*(-48*sw**2 + 32*sw**4 - reglog(18014398509481984.) - 9*(2 + 3*reglog(cmath.pi))) + 54*MB**2*Ncol*reglog(4*cmath.pi) - 4*MB**2*Ncol*(9 - 12*sw**2 + 8*sw**4)*(-reglog(MB**2/MU_R**2)) - 2*Ncol*(MZ**2*(9 - 12*sw**2 + 8*sw**4) + MB**2*(-9 - 24*sw**2 + 16*sw**4))*reglog((MZ**2 + vep*complex(0,-1))/MU_R**2) + 4*MZ**2*(27*(1 - 2*sw**2 + 4*sw**4) + 2*Ncol*(9 - 18*sw**2 + 20*sw**4))*reglogp(-(MU_R**2/(MZ**2 + vep*complex(0,1)))) - 2*MZ**2*(54*(1 - 2*sw**2 + 4*sw**4) + Ncol*(45 - 84*sw**2 + 88*sw**4))*reglogp(-(MU_R**2/(MZ**2 + vep*complex(0,1)))) - 2*Ncol*(MZ**2*(9 - 12*sw**2 + 8*sw**4) + MB**2*(-9 - 24*sw**2 + 16*sw**4))*reglogm((-MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)) + (Ncol*(MZ**2*(9 - 12*sw**2 + 8*sw**4) + MB**2*(-9 - 24*sw**2 + 16*sw**4))*(MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))*reglogm((-MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))))/MZ**2 - 2*Ncol*(MZ**2*(9 - 12*sw**2 + 8*sw**4) + MB**2*(-9 - 24*sw**2 + 16*sw**4))*reglogm(-(MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)) + (Ncol*(MZ**2*(9 - 12*sw**2 + 8*sw**4) + MB**2*(-9 - 24*sw**2 + 16*sw**4))*(MZ**2 - cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))*reglogm((MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(-MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))))/MZ**2))/(1728.*cw**2*cmath.pi**2*sw**2)) )'},
                               texname = '\delta m2_Z^{EW,MB}')


dMB_tWcft_UV_EW_R = CTParameter(name = 'dMB_tWcft_UV_EW_R',
                                type = 'complex',
                                value = {                                          0:'( 0 if MB == 0 else recms(CMSParam==1.0 and WT !=0,(ee**2*(18*MB**4 - 18*MB**2*MT**2 + 18*MB**2*MW**2 + 9*MT**4*reglog(16.) - 32*MT**2*MW**2*sw**2*reglog(16.) + 16*MT**2*MW**2*sw**2*reglog(64.) + 36*MT**4*reglog(cmath.pi) - 32*MT**2*MW**2*sw**2*reglog(cmath.pi) - 36*MT**4*reglog(2*cmath.pi) + 32*MT**2*MW**2*sw**2*reglog(2*cmath.pi)))/(576.*MT**2*MW**2*cmath.pi**2*sw**2) - (ee**2*MB**2*(2*MB**6 - 5*MB**4*MT**2 + 4*MB**2*MT**4 - MT**6 - 4*MB**2*MT**2*MW**2 - 6*MB**2*MW**4 - 3*MT**2*MW**4 + 4*MW**6)*(-reglog(MB**2/MU_R**2)))/(64.*MT**2*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) + (ee**2*(MB**4*MT**4 - 2*MB**2*MT**6 + MT**8 + 2*MB**6*MW**2 - 3*MB**4*MT**2*MW**2 - 2*MB**2*MT**4*MW**2 - MT**6*MW**2 - 2*MB**2*MT**2*MW**4 + 3*MT**4*MW**4 - 6*MB**2*MW**6 - 7*MT**2*MW**6 + 4*MW**8)*reglog(MU_R**2/MW**2))/(64.*MT**2*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) - (ee**2*(2*MB**8 - 5*MB**6*MT**2 + 3*MB**4*MT**4 + MB**2*MT**6 - MT**8 - 2*MB**6*MW**2 - MB**4*MT**2*MW**2 + 2*MB**2*MT**4*MW**2 + MT**6*MW**2 - 6*MB**4*MW**4 - MB**2*MT**2*MW**4 - 3*MT**4*MW**4 + 10*MB**2*MW**6 + 7*MT**2*MW**6 - 4*MW**8)*reglog((MT**2 + vep*complex(0,-1))/MU_R**2))/(64.*MT**2*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) - (ee**2*(MT - MW)*(MT + MW)*(MT**4 + MT**2*MW**2 + 4*MW**4)*reglogm((-MT**2 + MW**2 + vep*complex(0,-1))/MW**2))/(64.*MT**4*MW**2*cmath.pi**2*sw**2) - (ee**2*(2*MB**8 - 5*MB**6*MT**2 + 3*MB**4*MT**4 + MB**2*MT**6 - MT**8 - 2*MB**6*MW**2 - MB**4*MT**2*MW**2 + 2*MB**2*MT**4*MW**2 + MT**6*MW**2 - 6*MB**4*MW**4 - MB**2*MT**2*MW**4 - 3*MT**4*MW**4 + 10*MB**2*MW**6 + 7*MT**2*MW**6 - 4*MW**8)*reglogm((MB**2 - MT**2 - MW**2 - cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MT**2*(MB**2 + vep*complex(0,-1))))/(2.*MT**2)))/(64.*MT**2*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) - (ee**2*(2*MB**8 - 5*MB**6*MT**2 + 3*MB**4*MT**4 + MB**2*MT**6 - MT**8 - 2*MB**6*MW**2 - MB**4*MT**2*MW**2 + 2*MB**2*MT**4*MW**2 + MT**6*MW**2 - 6*MB**4*MW**4 - MB**2*MT**2*MW**4 - 3*MT**4*MW**4 + 10*MB**2*MW**6 + 7*MT**2*MW**6 - 4*MW**8)*reglogm((MB**2 - MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MT**2*(MB**2 + vep*complex(0,-1))))/(2.*MT**2)))/(64.*MT**2*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) + (ee**2*(2*MB**8 - 5*MB**6*MT**2 + 3*MB**4*MT**4 + MB**2*MT**6 - MT**8 - 2*MB**6*MW**2 - MB**4*MT**2*MW**2 + 2*MB**2*MT**4*MW**2 + MT**6*MW**2 - 6*MB**4*MW**4 - MB**2*MT**2*MW**4 - 3*MT**4*MW**4 + 10*MB**2*MW**6 + 7*MT**2*MW**6 - 4*MW**8)*(MB**2 + MT**2 - MW**2 + cmath.sqrt(MB**4 - 2*MB**2*MT**2 + MT**4 - 2*MB**2*MW**2 - 2*MT**2*MW**2 + MW**4 + MT**2*vep*complex(0,4)))*reglogm((MB**2 - MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MT**2*(MB**2 + vep*complex(0,-1))))/(MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MT**2*(MB**2 + vep*complex(0,-1))))))/(128.*MT**4*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) - (ee**2*(2*MB**8 - 5*MB**6*MT**2 + 3*MB**4*MT**4 + MB**2*MT**6 - MT**8 - 2*MB**6*MW**2 - MB**4*MT**2*MW**2 + 2*MB**2*MT**4*MW**2 + MT**6*MW**2 - 6*MB**4*MW**4 - MB**2*MT**2*MW**4 - 3*MT**4*MW**4 + 10*MB**2*MW**6 + 7*MT**2*MW**6 - 4*MW**8)*(-MB**2 - MT**2 + MW**2 + cmath.sqrt(MB**4 - 2*MB**2*MT**2 + MT**4 - 2*MB**2*MW**2 - 2*MT**2*MW**2 + MW**4 + MT**2*vep*complex(0,4)))*reglogm((-MB**2 + MT**2 + MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MT**2*(MB**2 + vep*complex(0,-1))))/(-MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MT**2*(MB**2 + vep*complex(0,-1))))))/(128.*MT**4*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2)) )'},
                                texname = '\delta ZR_t^{EW,MB}')


dMB_bWcft_UV_EW_R = CTParameter(name = 'dMB_bWcft_UV_EW_R',
                                type = 'complex',
                                value = {-1:'( 0 if MB == 0 else recms(CMSParam==1.0,-(ee**2*(3*MB**2 + 2*MW**2*sw**2))/(96.*MW**2*cmath.pi**2*sw**2)) )',
                                          0:'( 0 if MB == 0 else recms(CMSParam==1.0,-(ee**2*(-36*cw**2*MB**4 + 27*cw**2*MB**2*MH**2 + 36*cw**2*MB**2*MT**2 - 36*cw**2*MT**4 - 54*MB**2*MW**2 - 18*cw**2*MB**2*MW**2 - 36*cw**2*MT**2*MW**2 + 72*cw**2*MW**4 + 27*cw**2*MB**2*MZ**2 + 36*MW**2*MZ**2 - 24*MB**2*MW**2*sw**2 + 32*cw**2*MB**2*MW**2*sw**2 - 48*MW**2*MZ**2*sw**2 + 36*MB**2*MW**2*sw**4 + 24*MW**2*MZ**2*sw**4 + 18*cw**2*MB**4*reglog(16.) + 16*cw**2*MB**2*MW**2*sw**2*reglog(16.) - 4*MB**2*MW**2*sw**4*reglog(16.) - 4*cw**2*MB**2*MW**2*sw**2*reglog(256.) + 36*cw**2*MB**4*reglog(cmath.pi) + 8*cw**2*MB**2*MW**2*sw**2*reglog(cmath.pi) - 8*MB**2*MW**2*sw**4*reglog(cmath.pi) + 16*cw**2*MB**2*MW**2*sw**2*reglog(2*cmath.pi) - 36*cw**2*MB**4*reglog(4*cmath.pi) - 24*cw**2*MB**2*MW**2*sw**2*reglog(4*cmath.pi) + 8*MB**2*MW**2*sw**4*reglog(4*cmath.pi)))/(1152.*cw**2*MB**2*MW**2*cmath.pi**2*sw**2) - (ee**2*(24*cw**2*MB**4 + 18*MB**2*MW**2 - 9*cw**2*MB**2*MZ**2 - 6*MW**2*MZ**2 - 8*MB**2*MW**2*sw**2 + 16*cw**2*MB**2*MW**2*sw**2 + 8*MW**2*MZ**2*sw**2 - 4*cw**2*MW**2*MZ**2*sw**2 - 4*MW**2*MZ**2*sw**4)*(-reglog(MB**2/MU_R**2)))/(192.*cw**2*MW**2*(2*MB - MZ)*(2*MB + MZ)*cmath.pi**2*sw**2) - (ee**2*(4*MB**2 - 3*MH**2)*reglog(MU_R**2/MH**2))/(128.*MW**2*cmath.pi**2*sw**2) + (ee**2*MT**2*(MB**6 - 4*MB**4*MT**2 + 5*MB**2*MT**4 - 2*MT**6 + 4*MB**2*MT**2*MW**2 + 3*MB**2*MW**4 + 6*MT**2*MW**4 - 4*MW**6)*reglog(MU_R**2/MT**2))/(64.*MB**2*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) + (ee**2*(MB**6 - 3*MB**2*MT**4 + 2*MT**6 + 2*MB**4*MW**2 - 2*MB**2*MT**2*MW**2 - 7*MB**2*MW**4 - 6*MT**2*MW**4 + 4*MW**6)*reglog(MU_R**2/MW**2))/(64.*MB**2*(MB - MT - MW)*(MB + MT - MW)*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) + (ee**2*(-24*MB**4*MW**2 + 24*cw**2*MB**4*MZ**2 + 48*MB**2*MW**2*MZ**2 - 9*cw**2*MB**2*MZ**4 - 12*MW**2*MZ**4 - 32*MB**4*MW**2*sw**2 - 32*MB**2*MW**2*MZ**2*sw**2 + 16*MW**2*MZ**4*sw**2 + 32*MB**4*MW**2*sw**4 + 8*MB**2*MW**2*MZ**2*sw**4 - 8*MW**2*MZ**4*sw**4)*reglog(MU_R**2/MZ**2))/(384.*cw**2*MB**2*MW**2*(2*MB - MZ)*(2*MB + MZ)*cmath.pi**2*sw**2) - (ee**2*(48*cw**2*MB**10 - 36*cw**2*MB**8*MH**2 - 120*cw**2*MB**8*MT**2 + 72*cw**2*MB**6*MH**2*MT**2 + 144*cw**2*MB**6*MT**4 - 36*cw**2*MB**4*MH**2*MT**4 - 120*cw**2*MB**4*MT**6 + 48*cw**2*MB**2*MT**8 + 60*MB**8*MW**2 - 120*cw**2*MB**8*MW**2 + 72*cw**2*MB**6*MH**2*MW**2 - 120*MB**6*MT**2*MW**2 - 96*cw**2*MB**6*MT**2*MW**2 + 72*cw**2*MB**4*MH**2*MT**2*MW**2 + 60*MB**4*MT**4*MW**2 - 24*cw**2*MB**4*MT**4*MW**2 - 48*cw**2*MB**2*MT**6*MW**2 - 120*MB**6*MW**4 - 36*cw**2*MB**4*MH**2*MW**4 - 120*MB**4*MT**2*MW**4 - 24*cw**2*MB**4*MT**2*MW**4 - 144*cw**2*MB**2*MT**4*MW**4 + 60*MB**4*MW**6 + 168*cw**2*MB**4*MW**6 + 240*cw**2*MB**2*MT**2*MW**6 - 96*cw**2*MB**2*MW**8 - 42*cw**2*MB**8*MZ**2 + 9*cw**2*MB**6*MH**2*MZ**2 + 90*cw**2*MB**6*MT**2*MZ**2 - 18*cw**2*MB**4*MH**2*MT**2*MZ**2 - 66*cw**2*MB**4*MT**4*MZ**2 + 9*cw**2*MB**2*MH**2*MT**4*MZ**2 + 30*cw**2*MB**2*MT**6*MZ**2 - 12*cw**2*MT**8*MZ**2 - 60*MB**6*MW**2*MZ**2 + 90*cw**2*MB**6*MW**2*MZ**2 - 18*cw**2*MB**4*MH**2*MW**2*MZ**2 + 120*MB**4*MT**2*MW**2*MZ**2 + 84*cw**2*MB**4*MT**2*MW**2*MZ**2 - 18*cw**2*MB**2*MH**2*MT**2*MW**2*MZ**2 - 60*MB**2*MT**4*MW**2*MZ**2 + 6*cw**2*MB**2*MT**4*MW**2*MZ**2 + 12*cw**2*MT**6*MW**2*MZ**2 + 120*MB**4*MW**4*MZ**2 - 30*cw**2*MB**4*MW**4*MZ**2 + 9*cw**2*MB**2*MH**2*MW**4*MZ**2 + 120*MB**2*MT**2*MW**4*MZ**2 + 6*cw**2*MB**2*MT**2*MW**4*MZ**2 + 36*cw**2*MT**4*MW**4*MZ**2 - 60*MB**2*MW**6*MZ**2 - 42*cw**2*MB**2*MW**6*MZ**2 - 60*cw**2*MT**2*MW**6*MZ**2 + 24*cw**2*MW**8*MZ**2 + 9*cw**2*MB**6*MZ**4 - 18*cw**2*MB**4*MT**2*MZ**4 + 9*cw**2*MB**2*MT**4*MZ**4 + 12*MB**4*MW**2*MZ**4 - 18*cw**2*MB**4*MW**2*MZ**4 - 24*MB**2*MT**2*MW**2*MZ**4 - 18*cw**2*MB**2*MT**2*MW**2*MZ**4 + 12*MT**4*MW**2*MZ**4 - 24*MB**2*MW**4*MZ**4 + 9*cw**2*MB**2*MW**4*MZ**4 - 24*MT**2*MW**4*MZ**4 + 12*MW**6*MZ**4 + 16*MB**8*MW**2*sw**2 - 32*MB**6*MT**2*MW**2*sw**2 + 16*MB**4*MT**4*MW**2*sw**2 - 32*MB**6*MW**4*sw**2 - 32*MB**4*MT**2*MW**4*sw**2 + 16*MB**4*MW**6*sw**2 + 48*MB**6*MW**2*MZ**2*sw**2 - 96*MB**4*MT**2*MW**2*MZ**2*sw**2 + 48*MB**2*MT**4*MW**2*MZ**2*sw**2 - 96*MB**4*MW**4*MZ**2*sw**2 - 96*MB**2*MT**2*MW**4*MZ**2*sw**2 + 48*MB**2*MW**6*MZ**2*sw**2 - 16*MB**4*MW**2*MZ**4*sw**2 + 32*MB**2*MT**2*MW**2*MZ**4*sw**2 - 16*MT**4*MW**2*MZ**4*sw**2 + 32*MB**2*MW**4*MZ**4*sw**2 + 32*MT**2*MW**4*MZ**4*sw**2 - 16*MW**6*MZ**4*sw**2 - 32*MB**8*MW**2*sw**4 + 64*MB**6*MT**2*MW**2*sw**4 - 32*MB**4*MT**4*MW**2*sw**4 + 64*MB**6*MW**4*sw**4 + 64*MB**4*MT**2*MW**4*sw**4 - 32*MB**4*MW**6*sw**4 - 16*MB**6*MW**2*MZ**2*sw**4 + 32*MB**4*MT**2*MW**2*MZ**2*sw**4 - 16*MB**2*MT**4*MW**2*MZ**2*sw**4 + 32*MB**4*MW**4*MZ**2*sw**4 + 32*MB**2*MT**2*MW**4*MZ**2*sw**4 - 16*MB**2*MW**6*MZ**2*sw**4 + 8*MB**4*MW**2*MZ**4*sw**4 - 16*MB**2*MT**2*MW**2*MZ**4*sw**4 + 8*MT**4*MW**2*MZ**4*sw**4 - 16*MB**2*MW**4*MZ**4*sw**4 - 16*MT**2*MW**4*MZ**4*sw**4 + 8*MW**6*MZ**4*sw**4)*reglogm((MB**2 + vep*complex(0,-1))/MU_R**2))/(384.*cw**2*MB**2*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*(2*MB - MZ)*(2*MB + MZ)*cmath.pi**2*sw**2) - (3*ee**2*(2*MB**2 - MH**2)*reglogm((-MH**2 - cmath.sqrt(MH**4 - 4*MB**2*(MH**2 + vep*complex(0,-1))))/(2.*MB**2)))/(128.*MW**2*cmath.pi**2*sw**2) - (3*ee**2*(2*MB**2 - MH**2)*reglogm((-MH**2 + cmath.sqrt(MH**4 - 4*MB**2*(MH**2 + vep*complex(0,-1))))/(2.*MB**2)))/(128.*MW**2*cmath.pi**2*sw**2) + (3*ee**2*(2*MB**2 - MH**2)*(2*MB**2 - MH**2 + cmath.sqrt(-4*MB**2*MH**2 + MH**4 + MB**2*vep*complex(0,4)))*reglogm((-MH**2 + cmath.sqrt(MH**4 - 4*MB**2*(MH**2 + vep*complex(0,-1))))/(2*MB**2 - MH**2 + cmath.sqrt(MH**4 - 4*MB**2*(MH**2 + vep*complex(0,-1))))))/(256.*MB**2*MW**2*cmath.pi**2*sw**2) - (3*ee**2*(2*MB**2 - MH**2)*(-2*MB**2 + MH**2 + cmath.sqrt(-4*MB**2*MH**2 + MH**4 + MB**2*vep*complex(0,4)))*reglogm((MH**2 + cmath.sqrt(MH**4 - 4*MB**2*(MH**2 + vep*complex(0,-1))))/(-2*MB**2 + MH**2 + cmath.sqrt(MH**4 - 4*MB**2*(MH**2 + vep*complex(0,-1))))))/(256.*MB**2*MW**2*cmath.pi**2*sw**2) + (ee**2*(MB**8 - MB**6*MT**2 - 3*MB**4*MT**4 + 5*MB**2*MT**6 - 2*MT**8 - MB**6*MW**2 - 2*MB**4*MT**2*MW**2 + MB**2*MT**4*MW**2 + 2*MT**6*MW**2 + 3*MB**4*MW**4 + MB**2*MT**2*MW**4 + 6*MT**4*MW**4 - 7*MB**2*MW**6 - 10*MT**2*MW**6 + 4*MW**8)*reglogm((-MB**2 + MT**2 - MW**2 - cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))/(2.*MB**2)))/(64.*MB**2*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) + (ee**2*(MB**8 - MB**6*MT**2 - 3*MB**4*MT**4 + 5*MB**2*MT**6 - 2*MT**8 - MB**6*MW**2 - 2*MB**4*MT**2*MW**2 + MB**2*MT**4*MW**2 + 2*MT**6*MW**2 + 3*MB**4*MW**4 + MB**2*MT**2*MW**4 + 6*MT**4*MW**4 - 7*MB**2*MW**6 - 10*MT**2*MW**6 + 4*MW**8)*reglogm((-MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))/(2.*MB**2)))/(64.*MB**2*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) - (ee**2*(MB**8 - MB**6*MT**2 - 3*MB**4*MT**4 + 5*MB**2*MT**6 - 2*MT**8 - MB**6*MW**2 - 2*MB**4*MT**2*MW**2 + MB**2*MT**4*MW**2 + 2*MT**6*MW**2 + 3*MB**4*MW**4 + MB**2*MT**2*MW**4 + 6*MT**4*MW**4 - 7*MB**2*MW**6 - 10*MT**2*MW**6 + 4*MW**8)*(MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))*reglogm((-MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))/(MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))))/(128.*MB**4*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) + (ee**2*(MB**8 - MB**6*MT**2 - 3*MB**4*MT**4 + 5*MB**2*MT**6 - 2*MT**8 - MB**6*MW**2 - 2*MB**4*MT**2*MW**2 + MB**2*MT**4*MW**2 + 2*MT**6*MW**2 + 3*MB**4*MW**4 + MB**2*MT**2*MW**4 + 6*MT**4*MW**4 - 7*MB**2*MW**6 - 10*MT**2*MW**6 + 4*MW**8)*(-MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))*reglogm((MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))/(-MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))))/(128.*MB**4*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) + (ee**2*(-60*MB**4*MW**2 + 30*cw**2*MB**4*MZ**2 + 60*MB**2*MW**2*MZ**2 - 9*cw**2*MB**2*MZ**4 - 12*MW**2*MZ**4 - 16*MB**4*MW**2*sw**2 - 48*MB**2*MW**2*MZ**2*sw**2 + 16*MW**2*MZ**4*sw**2 + 32*MB**4*MW**2*sw**4 + 16*MB**2*MW**2*MZ**2*sw**4 - 8*MW**2*MZ**4*sw**4)*reglogm((-MZ**2 - cmath.sqrt(MZ**4 - 4*MB**2*(MZ**2 + vep*complex(0,-1))))/(2.*MB**2)))/(384.*cw**2*MB**2*MW**2*(2*MB - MZ)*(2*MB + MZ)*cmath.pi**2*sw**2) + (ee**2*(-60*MB**4*MW**2 + 30*cw**2*MB**4*MZ**2 + 60*MB**2*MW**2*MZ**2 - 9*cw**2*MB**2*MZ**4 - 12*MW**2*MZ**4 - 16*MB**4*MW**2*sw**2 - 48*MB**2*MW**2*MZ**2*sw**2 + 16*MW**2*MZ**4*sw**2 + 32*MB**4*MW**2*sw**4 + 16*MB**2*MW**2*MZ**2*sw**4 - 8*MW**2*MZ**4*sw**4)*reglogm((-MZ**2 + cmath.sqrt(MZ**4 - 4*MB**2*(MZ**2 + vep*complex(0,-1))))/(2.*MB**2)))/(384.*cw**2*MB**2*MW**2*(2*MB - MZ)*(2*MB + MZ)*cmath.pi**2*sw**2) - (ee**2*(-60*MB**4*MW**2 + 30*cw**2*MB**4*MZ**2 + 60*MB**2*MW**2*MZ**2 - 9*cw**2*MB**2*MZ**4 - 12*MW**2*MZ**4 - 16*MB**4*MW**2*sw**2 - 48*MB**2*MW**2*MZ**2*sw**2 + 16*MW**2*MZ**4*sw**2 + 32*MB**4*MW**2*sw**4 + 16*MB**2*MW**2*MZ**2*sw**4 - 8*MW**2*MZ**4*sw**4)*(2*MB**2 - MZ**2 + cmath.sqrt(-4*MB**2*MZ**2 + MZ**4 + MB**2*vep*complex(0,4)))*reglogm((-MZ**2 + cmath.sqrt(MZ**4 - 4*MB**2*(MZ**2 + vep*complex(0,-1))))/(2*MB**2 - MZ**2 + cmath.sqrt(MZ**4 - 4*MB**2*(MZ**2 + vep*complex(0,-1))))))/(768.*cw**2*MB**4*MW**2*(2*MB - MZ)*(2*MB + MZ)*cmath.pi**2*sw**2) + (ee**2*(-60*MB**4*MW**2 + 30*cw**2*MB**4*MZ**2 + 60*MB**2*MW**2*MZ**2 - 9*cw**2*MB**2*MZ**4 - 12*MW**2*MZ**4 - 16*MB**4*MW**2*sw**2 - 48*MB**2*MW**2*MZ**2*sw**2 + 16*MW**2*MZ**4*sw**2 + 32*MB**4*MW**2*sw**4 + 16*MB**2*MW**2*MZ**2*sw**4 - 8*MW**2*MZ**4*sw**4)*(-2*MB**2 + MZ**2 + cmath.sqrt(-4*MB**2*MZ**2 + MZ**4 + MB**2*vep*complex(0,4)))*reglogm((MZ**2 + cmath.sqrt(MZ**4 - 4*MB**2*(MZ**2 + vep*complex(0,-1))))/(-2*MB**2 + MZ**2 + cmath.sqrt(MZ**4 - 4*MB**2*(MZ**2 + vep*complex(0,-1))))))/(768.*cw**2*MB**4*MW**2*(2*MB - MZ)*(2*MB + MZ)*cmath.pi**2*sw**2)) )'},
                                texname = '\delta ZR_b^{EW,MB}')

dMB_tWcft_UV_EW_L = CTParameter(name = 'dMB_tWcft_UV_EW_L',
                                type = 'complex',
                                value = {-1:'( 0 if MB == 0 else recms(CMSParam==1.0 and WT != 0,-(ee**2*MB**2)/(64.*MW**2*cmath.pi**2*sw**2)) )',
                                          0:'( 0 if MB == 0 else recms(CMSParam==1.0 and WT != 0,(ee**2*(9*MB**4 - 27*MB**2*MT**2 + 9*MB**2*MW**2 - 32*MT**2*MW**2*sw**2*reglog(16.) + 16*MT**2*MW**2*sw**2*reglog(64.) + 9*MT**4*reglog(cmath.pi) + 18*MT**2*MW**2*reglog(cmath.pi) - 32*MT**2*MW**2*sw**2*reglog(cmath.pi) - 18*MT**4*reglog(2*cmath.pi) - 36*MT**2*MW**2*reglog(2*cmath.pi) + 32*MT**2*MW**2*sw**2*reglog(2*cmath.pi) + 9*MT**4*reglog(4*cmath.pi) + 18*MT**2*MW**2*reglog(4*cmath.pi)))/(576.*MT**2*MW**2*cmath.pi**2*sw**2) - (ee**2*MB**2*(MB**6 - 2*MB**4*MT**2 + MB**2*MT**4 - 4*MT**4*MW**2 - 3*MB**2*MW**4 + 2*MT**2*MW**4 + 2*MW**6)*(-reglog(MB**2/MU_R**2)))/(64.*MT**2*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) + (ee**2*(MB**6 + 2*MB**4*MT**2 - 7*MB**2*MT**4 + 4*MT**6 - 2*MB**2*MT**2*MW**2 - 6*MT**4*MW**2 - 3*MB**2*MW**4 + 2*MW**6)*reglog(MU_R**2/MW**2))/(64.*MT**2*(MB - MT - MW)*(MB + MT - MW)*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) - (ee**2*(MB**8 - 3*MB**6*MT**2 + 3*MB**4*MT**4 - MB**2*MT**6 - MB**6*MW**2 + 5*MB**2*MT**4*MW**2 - 4*MT**6*MW**2 - 3*MB**4*MW**4 + 3*MB**2*MT**2*MW**4 + 6*MT**4*MW**4 + 5*MB**2*MW**6 - 2*MW**8)*reglog((MT**2 + vep*complex(0,-1))/MU_R**2))/(64.*MT**2*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) - (ee**2*(MT - MW)*(MT + MW)*(2*MT**2 + MW**2)*reglogm((-MT**2 + MW**2 + vep*complex(0,-1))/MW**2))/(32.*MT**4*cmath.pi**2*sw**2) - (ee**2*(MB**8 - 3*MB**6*MT**2 + 3*MB**4*MT**4 - MB**2*MT**6 - MB**6*MW**2 + 5*MB**2*MT**4*MW**2 - 4*MT**6*MW**2 - 3*MB**4*MW**4 + 3*MB**2*MT**2*MW**4 + 6*MT**4*MW**4 + 5*MB**2*MW**6 - 2*MW**8)*reglogm((MB**2 - MT**2 - MW**2 - cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MT**2*(MB**2 + vep*complex(0,-1))))/(2.*MT**2)))/(64.*MT**2*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) - (ee**2*(MB**8 - 3*MB**6*MT**2 + 3*MB**4*MT**4 - MB**2*MT**6 - MB**6*MW**2 + 5*MB**2*MT**4*MW**2 - 4*MT**6*MW**2 - 3*MB**4*MW**4 + 3*MB**2*MT**2*MW**4 + 6*MT**4*MW**4 + 5*MB**2*MW**6 - 2*MW**8)*reglogm((MB**2 - MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MT**2*(MB**2 + vep*complex(0,-1))))/(2.*MT**2)))/(64.*MT**2*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) + (ee**2*(MB**8 - 3*MB**6*MT**2 + 3*MB**4*MT**4 - MB**2*MT**6 - MB**6*MW**2 + 5*MB**2*MT**4*MW**2 - 4*MT**6*MW**2 - 3*MB**4*MW**4 + 3*MB**2*MT**2*MW**4 + 6*MT**4*MW**4 + 5*MB**2*MW**6 - 2*MW**8)*(MB**2 + MT**2 - MW**2 + cmath.sqrt(MB**4 - 2*MB**2*MT**2 + MT**4 - 2*MB**2*MW**2 - 2*MT**2*MW**2 + MW**4 + MT**2*vep*complex(0,4)))*reglogm((MB**2 - MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MT**2*(MB**2 + vep*complex(0,-1))))/(MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MT**2*(MB**2 + vep*complex(0,-1))))))/(128.*MT**4*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) - (ee**2*(MB**8 - 3*MB**6*MT**2 + 3*MB**4*MT**4 - MB**2*MT**6 - MB**6*MW**2 + 5*MB**2*MT**4*MW**2 - 4*MT**6*MW**2 - 3*MB**4*MW**4 + 3*MB**2*MT**2*MW**4 + 6*MT**4*MW**4 + 5*MB**2*MW**6 - 2*MW**8)*(-MB**2 - MT**2 + MW**2 + cmath.sqrt(MB**4 - 2*MB**2*MT**2 + MT**4 - 2*MB**2*MW**2 - 2*MT**2*MW**2 + MW**4 + MT**2*vep*complex(0,4)))*reglogm((-MB**2 + MT**2 + MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MT**2*(MB**2 + vep*complex(0,-1))))/(-MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MT**2*(MB**2 + vep*complex(0,-1))))))/(128.*MT**4*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2)) )'},
                                texname = '\delta ZL_t^{EW,MB}')

dMB_bWcft_UV_EW_L = CTParameter(name = 'dMB_bWcft_UV_EW_L',
                                type = 'complex',
                                value = {-1:'( 0 if MB == 0 else recms(CMSParam==1.0,-(ee**2*(3*MB**2 + 4*MW**2*sw**2))/(192.*MW**2*cmath.pi**2*sw**2)) )',
                                          0:'( 0 if MB == 0 else recms(CMSParam==1.0,(ee**2*(72*cw**2*MB**4*MT**2 - 27*cw**2*MB**2*MH**2*MT**2 - 27*cw**2*MB**2*MT**4 + 18*cw**2*MT**6 - 72*cw**2*MB**4*MW**2 + 27*cw**2*MB**2*MH**2*MW**2 + 9*MB**2*MT**2*MW**2 + 27*cw**2*MB**2*MT**2*MW**2 - 9*MB**2*MW**4 + 54*cw**2*MB**2*MW**4 - 54*cw**2*MT**2*MW**4 + 36*cw**2*MW**6 - 27*cw**2*MB**2*MT**2*MZ**2 + 27*cw**2*MB**2*MW**2*MZ**2 - 18*MT**2*MW**2*MZ**2 + 18*MW**4*MZ**2 + 84*MB**2*MT**2*MW**2*sw**2 - 32*cw**2*MB**2*MT**2*MW**2*sw**2 - 84*MB**2*MW**4*sw**2 + 32*cw**2*MB**2*MW**4*sw**2 + 24*MT**2*MW**2*MZ**2*sw**2 - 24*MW**4*MZ**2*sw**2 - 36*MB**2*MT**2*MW**2*sw**4 + 36*MB**2*MW**4*sw**4 - 24*MT**2*MW**2*MZ**2*sw**4 + 24*MW**4*MZ**2*sw**4 + 9*cw**2*MB**2*MT**4*reglog(16.) + 9*MB**2*MT**2*MW**2*reglog(16.) + 9*cw**2*MB**2*MT**2*MW**2*reglog(16.) - 9*MB**2*MW**4*reglog(16.) - 18*cw**2*MB**2*MW**4*reglog(16.) - 12*MB**2*MT**2*MW**2*sw**2*reglog(16.) - 16*cw**2*MB**2*MT**2*MW**2*sw**2*reglog(16.) + 12*MB**2*MW**4*sw**2*reglog(16.) + 16*cw**2*MB**2*MW**4*sw**2*reglog(16.) + 4*MB**2*MT**2*MW**2*sw**4*reglog(16.) - 4*MB**2*MW**4*sw**4*reglog(16.) + 4*cw**2*MB**2*MT**2*MW**2*sw**2*reglog(256.) - 4*cw**2*MB**2*MW**4*sw**2*reglog(256.) + 18*cw**2*MB**4*MT**2*reglog(1/(4.*cmath.pi)) - 18*cw**2*MB**4*MW**2*reglog(1/(4.*cmath.pi)) + 18*MB**2*MT**2*MW**2*reglog(1/(4.*cmath.pi)) - 18*MB**2*MW**4*reglog(1/(4.*cmath.pi)) - 24*MB**2*MT**2*MW**2*sw**2*reglog(1/(4.*cmath.pi)) + 24*MB**2*MW**4*sw**2*reglog(1/(4.*cmath.pi)) + 8*MB**2*MT**2*MW**2*sw**4*reglog(1/(4.*cmath.pi)) - 8*MB**2*MW**4*sw**4*reglog(1/(4.*cmath.pi)) + 18*cw**2*MB**2*MT**4*reglog(cmath.pi) + 18*MB**2*MT**2*MW**2*reglog(cmath.pi) + 54*cw**2*MB**2*MT**2*MW**2*reglog(cmath.pi) - 18*MB**2*MW**4*reglog(cmath.pi) - 72*cw**2*MB**2*MW**4*reglog(cmath.pi) - 24*MB**2*MT**2*MW**2*sw**2*reglog(cmath.pi) - 8*cw**2*MB**2*MT**2*MW**2*sw**2*reglog(cmath.pi) + 24*MB**2*MW**4*sw**2*reglog(cmath.pi) + 8*cw**2*MB**2*MW**4*sw**2*reglog(cmath.pi) + 8*MB**2*MT**2*MW**2*sw**4*reglog(cmath.pi) - 8*MB**2*MW**4*sw**4*reglog(cmath.pi) - 72*cw**2*MB**2*MT**2*MW**2*reglog(2*cmath.pi) + 72*cw**2*MB**2*MW**4*reglog(2*cmath.pi) - 16*cw**2*MB**2*MT**2*MW**2*sw**2*reglog(2*cmath.pi) + 16*cw**2*MB**2*MW**4*sw**2*reglog(2*cmath.pi) + 18*cw**2*MB**4*MT**2*reglog(4*cmath.pi) - 18*cw**2*MB**2*MT**4*reglog(4*cmath.pi) - 18*cw**2*MB**4*MW**2*reglog(4*cmath.pi) + 18*cw**2*MB**2*MT**2*MW**2*reglog(4*cmath.pi) + 24*cw**2*MB**2*MT**2*MW**2*sw**2*reglog(4*cmath.pi) - 24*cw**2*MB**2*MW**4*sw**2*reglog(4*cmath.pi)))/(1152.*cw**2*MB**2*(MT - MW)*MW**2*(MT + MW)*cmath.pi**2*sw**2) - (ee**2*(24*cw**2*MB**4 + 6*MB**2*MW**2 - 9*cw**2*MB**2*MZ**2 - 3*MW**2*MZ**2 + 8*MB**2*MW**2*sw**2 + 16*cw**2*MB**2*MW**2*sw**2 + 4*MW**2*MZ**2*sw**2 - 4*cw**2*MW**2*MZ**2*sw**2 - 4*MW**2*MZ**2*sw**4)*(-reglog(MB**2/MU_R**2)))/(192.*cw**2*MW**2*(2*MB - MZ)*(2*MB + MZ)*cmath.pi**2*sw**2) - (ee**2*(4*MB**2 - 3*MH**2)*reglog(MU_R**2/MH**2))/(128.*MW**2*cmath.pi**2*sw**2) + (ee**2*MT**2*(MB**6*MT**4 - 3*MB**4*MT**6 + 3*MB**2*MT**8 - MT**10 + 2*MB**6*MT**2*MW**2 - 4*MB**2*MT**6*MW**2 + 2*MT**8*MW**2 - 13*MB**4*MT**2*MW**4 - 3*MB**2*MT**4*MW**4 + 2*MT**6*MW**4 + 4*MB**4*MW**6 + 6*MB**2*MT**2*MW**6 - 8*MT**4*MW**6 - 2*MB**2*MW**8 + 7*MT**2*MW**8 - 2*MW**10)*reglog(MU_R**2/MT**2))/(64.*MB**2*(MB - MT - MW)*(MT - MW)**2*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MT + MW)**2*(MB + MT + MW)*cmath.pi**2*sw**2) - (ee**2*(-(MB**4*MT**6) + 2*MB**2*MT**8 - MT**10 + 7*MB**6*MT**2*MW**2 - 14*MB**4*MT**4*MW**2 - 3*MB**2*MT**6*MW**2 + 2*MT**8*MW**2 - 4*MB**6*MW**4 - 3*MB**4*MT**2*MW**4 + 2*MT**6*MW**4 + 6*MB**4*MW**6 + MB**2*MT**2*MW**6 - 8*MT**4*MW**6 + 7*MT**2*MW**8 - 2*MW**10)*reglog(MU_R**2/MW**2))/(64.*MB**2*(MB - MT - MW)*(MT - MW)**2*(MB + MT - MW)*(MB - MT + MW)*(MT + MW)**2*(MB + MT + MW)*cmath.pi**2*sw**2) + (ee**2*(24*cw**2*MB**4*MZ**2 + 18*MB**2*MW**2*MZ**2 - 9*cw**2*MB**2*MZ**4 - 6*MW**2*MZ**4 - 64*MB**4*MW**2*sw**2 + 8*MB**2*MW**2*MZ**2*sw**2 + 8*MW**2*MZ**4*sw**2 + 32*MB**4*MW**2*sw**4 + 8*MB**2*MW**2*MZ**2*sw**4 - 8*MW**2*MZ**4*sw**4)*reglog(MU_R**2/MZ**2))/(384.*cw**2*MB**2*MW**2*(2*MB - MZ)*(2*MB + MZ)*cmath.pi**2*sw**2) - (ee**2*(72*cw**2*MB**10 - 36*cw**2*MB**8*MH**2 - 168*cw**2*MB**8*MT**2 + 72*cw**2*MB**6*MH**2*MT**2 + 144*cw**2*MB**6*MT**4 - 36*cw**2*MB**4*MH**2*MT**4 - 72*cw**2*MB**4*MT**6 + 24*cw**2*MB**2*MT**8 + 12*MB**8*MW**2 - 240*cw**2*MB**8*MW**2 + 72*cw**2*MB**6*MH**2*MW**2 - 24*MB**6*MT**2*MW**2 - 24*cw**2*MB**6*MT**2*MW**2 + 72*cw**2*MB**4*MH**2*MT**2*MW**2 + 12*MB**4*MT**4*MW**2 - 24*cw**2*MB**2*MT**6*MW**2 - 24*MB**6*MW**4 + 216*cw**2*MB**6*MW**4 - 36*cw**2*MB**4*MH**2*MW**4 - 24*MB**4*MT**2*MW**4 + 72*cw**2*MB**4*MT**2*MW**4 - 72*cw**2*MB**2*MT**4*MW**4 + 12*MB**4*MW**6 + 120*cw**2*MB**2*MT**2*MW**6 - 48*cw**2*MB**2*MW**8 - 48*cw**2*MB**8*MZ**2 + 9*cw**2*MB**6*MH**2*MZ**2 + 102*cw**2*MB**6*MT**2*MZ**2 - 18*cw**2*MB**4*MH**2*MT**2*MZ**2 - 66*cw**2*MB**4*MT**4*MZ**2 + 9*cw**2*MB**2*MH**2*MT**4*MZ**2 + 18*cw**2*MB**2*MT**6*MZ**2 - 6*cw**2*MT**8*MZ**2 - 24*MB**6*MW**2*MZ**2 + 120*cw**2*MB**6*MW**2*MZ**2 - 18*cw**2*MB**4*MH**2*MW**2*MZ**2 + 48*MB**4*MT**2*MW**2*MZ**2 + 66*cw**2*MB**4*MT**2*MW**2*MZ**2 - 18*cw**2*MB**2*MH**2*MT**2*MW**2*MZ**2 - 24*MB**2*MT**4*MW**2*MZ**2 + 6*cw**2*MT**6*MW**2*MZ**2 + 48*MB**4*MW**4*MZ**2 - 84*cw**2*MB**4*MW**4*MZ**2 + 9*cw**2*MB**2*MH**2*MW**4*MZ**2 + 48*MB**2*MT**2*MW**4*MZ**2 - 18*cw**2*MB**2*MT**2*MW**4*MZ**2 + 18*cw**2*MT**4*MW**4*MZ**2 - 24*MB**2*MW**6*MZ**2 - 30*cw**2*MT**2*MW**6*MZ**2 + 12*cw**2*MW**8*MZ**2 + 9*cw**2*MB**6*MZ**4 - 18*cw**2*MB**4*MT**2*MZ**4 + 9*cw**2*MB**2*MT**4*MZ**4 + 6*MB**4*MW**2*MZ**4 - 18*cw**2*MB**4*MW**2*MZ**4 - 12*MB**2*MT**2*MW**2*MZ**4 - 18*cw**2*MB**2*MT**2*MW**2*MZ**4 + 6*MT**4*MW**2*MZ**4 - 12*MB**2*MW**4*MZ**4 + 9*cw**2*MB**2*MW**4*MZ**4 - 12*MT**2*MW**4*MZ**4 + 6*MW**6*MZ**4 + 80*MB**8*MW**2*sw**2 - 160*MB**6*MT**2*MW**2*sw**2 + 80*MB**4*MT**4*MW**2*sw**2 - 160*MB**6*MW**4*sw**2 - 160*MB**4*MT**2*MW**4*sw**2 + 80*MB**4*MW**6*sw**2 - 8*MB**4*MW**2*MZ**4*sw**2 + 16*MB**2*MT**2*MW**2*MZ**4*sw**2 - 8*MT**4*MW**2*MZ**4*sw**2 + 16*MB**2*MW**4*MZ**4*sw**2 + 16*MT**2*MW**4*MZ**4*sw**2 - 8*MW**6*MZ**4*sw**2 - 32*MB**8*MW**2*sw**4 + 64*MB**6*MT**2*MW**2*sw**4 - 32*MB**4*MT**4*MW**2*sw**4 + 64*MB**6*MW**4*sw**4 + 64*MB**4*MT**2*MW**4*sw**4 - 32*MB**4*MW**6*sw**4 - 16*MB**6*MW**2*MZ**2*sw**4 + 32*MB**4*MT**2*MW**2*MZ**2*sw**4 - 16*MB**2*MT**4*MW**2*MZ**2*sw**4 + 32*MB**4*MW**4*MZ**2*sw**4 + 32*MB**2*MT**2*MW**4*MZ**2*sw**4 - 16*MB**2*MW**6*MZ**2*sw**4 + 8*MB**4*MW**2*MZ**4*sw**4 - 16*MB**2*MT**2*MW**2*MZ**4*sw**4 + 8*MT**4*MW**2*MZ**4*sw**4 - 16*MB**2*MW**4*MZ**4*sw**4 - 16*MT**2*MW**4*MZ**4*sw**4 + 8*MW**6*MZ**4*sw**4)*reglog((MB**2 + vep*complex(0,-1))/MU_R**2))/(384.*cw**2*MB**2*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*(2*MB - MZ)*(2*MB + MZ)*cmath.pi**2*sw**2) - (3*ee**2*(2*MB**2 - MH**2)*reglogm((-MH**2 - cmath.sqrt(MH**4 - 4*MB**2*(MH**2 + vep*complex(0,-1))))/(2.*MB**2)))/(128.*MW**2*cmath.pi**2*sw**2) - (3*ee**2*(2*MB**2 - MH**2)*reglogm((-MH**2 + cmath.sqrt(MH**4 - 4*MB**2*(MH**2 + vep*complex(0,-1))))/(2.*MB**2)))/(128.*MW**2*cmath.pi**2*sw**2) + (3*ee**2*(2*MB**2 - MH**2)*(2*MB**2 - MH**2 + cmath.sqrt(-4*MB**2*MH**2 + MH**4 + MB**2*vep*complex(0,4)))*reglogm((-MH**2 + cmath.sqrt(MH**4 - 4*MB**2*(MH**2 + vep*complex(0,-1))))/(2*MB**2 - MH**2 + cmath.sqrt(MH**4 - 4*MB**2*(MH**2 + vep*complex(0,-1))))))/(256.*MB**2*MW**2*cmath.pi**2*sw**2) - (3*ee**2*(2*MB**2 - MH**2)*(-2*MB**2 + MH**2 + cmath.sqrt(-4*MB**2*MH**2 + MH**4 + MB**2*vep*complex(0,4)))*reglogm((MH**2 + cmath.sqrt(MH**4 - 4*MB**2*(MH**2 + vep*complex(0,-1))))/(-2*MB**2 + MH**2 + cmath.sqrt(MH**4 - 4*MB**2*(MH**2 + vep*complex(0,-1))))))/(256.*MB**2*MW**2*cmath.pi**2*sw**2) + (ee**2*(MB**6*MT**2 - 3*MB**4*MT**4 + 3*MB**2*MT**6 - MT**8 + 4*MB**6*MW**2 - 5*MB**4*MT**2*MW**2 + MT**6*MW**2 - 6*MB**4*MW**4 - 3*MB**2*MT**2*MW**4 + 3*MT**4*MW**4 - 5*MT**2*MW**6 + 2*MW**8)*reglogm((-MB**2 + MT**2 - MW**2 - cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))/(2.*MB**2)))/(64.*MB**2*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) + (ee**2*(MB**6*MT**2 - 3*MB**4*MT**4 + 3*MB**2*MT**6 - MT**8 + 4*MB**6*MW**2 - 5*MB**4*MT**2*MW**2 + MT**6*MW**2 - 6*MB**4*MW**4 - 3*MB**2*MT**2*MW**4 + 3*MT**4*MW**4 - 5*MT**2*MW**6 + 2*MW**8)*reglogm((-MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))/(2.*MB**2)))/(64.*MB**2*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) - (ee**2*(MB**6*MT**2 - 3*MB**4*MT**4 + 3*MB**2*MT**6 - MT**8 + 4*MB**6*MW**2 - 5*MB**4*MT**2*MW**2 + MT**6*MW**2 - 6*MB**4*MW**4 - 3*MB**2*MT**2*MW**4 + 3*MT**4*MW**4 - 5*MT**2*MW**6 + 2*MW**8)*(MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))*reglogm((-MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))/(MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))))/(128.*MB**4*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) + (ee**2*(MB**6*MT**2 - 3*MB**4*MT**4 + 3*MB**2*MT**6 - MT**8 + 4*MB**6*MW**2 - 5*MB**4*MT**2*MW**2 + MT**6*MW**2 - 6*MB**4*MW**4 - 3*MB**2*MT**2*MW**4 + 3*MT**4*MW**4 - 5*MT**2*MW**6 + 2*MW**8)*(-MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))*reglogm((MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))/(-MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 + MT**2 - MW**2)**2 - 4*MB**2*(MT**2 + vep*complex(0,-1))))))/(128.*MB**4*(MB - MT - MW)*(MB + MT - MW)*MW**2*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) + (ee**2*(-12*MB**4*MW**2 + 30*cw**2*MB**4*MZ**2 + 24*MB**2*MW**2*MZ**2 - 9*cw**2*MB**2*MZ**4 - 6*MW**2*MZ**4 - 80*MB**4*MW**2*sw**2 + 8*MW**2*MZ**4*sw**2 + 32*MB**4*MW**2*sw**4 + 16*MB**2*MW**2*MZ**2*sw**4 - 8*MW**2*MZ**4*sw**4)*reglogm((-MZ**2 - cmath.sqrt(MZ**4 - 4*MB**2*(MZ**2 + vep*complex(0,-1))))/(2.*MB**2)))/(384.*cw**2*MB**2*MW**2*(2*MB - MZ)*(2*MB + MZ)*cmath.pi**2*sw**2) + (ee**2*(-12*MB**4*MW**2 + 30*cw**2*MB**4*MZ**2 + 24*MB**2*MW**2*MZ**2 - 9*cw**2*MB**2*MZ**4 - 6*MW**2*MZ**4 - 80*MB**4*MW**2*sw**2 + 8*MW**2*MZ**4*sw**2 + 32*MB**4*MW**2*sw**4 + 16*MB**2*MW**2*MZ**2*sw**4 - 8*MW**2*MZ**4*sw**4)*reglogm((-MZ**2 + cmath.sqrt(MZ**4 - 4*MB**2*(MZ**2 + vep*complex(0,-1))))/(2.*MB**2)))/(384.*cw**2*MB**2*MW**2*(2*MB - MZ)*(2*MB + MZ)*cmath.pi**2*sw**2) - (ee**2*(-12*MB**4*MW**2 + 30*cw**2*MB**4*MZ**2 + 24*MB**2*MW**2*MZ**2 - 9*cw**2*MB**2*MZ**4 - 6*MW**2*MZ**4 - 80*MB**4*MW**2*sw**2 + 8*MW**2*MZ**4*sw**2 + 32*MB**4*MW**2*sw**4 + 16*MB**2*MW**2*MZ**2*sw**4 - 8*MW**2*MZ**4*sw**4)*(2*MB**2 - MZ**2 + cmath.sqrt(-4*MB**2*MZ**2 + MZ**4 + MB**2*vep*complex(0,4)))*reglogm((-MZ**2 + cmath.sqrt(MZ**4 - 4*MB**2*(MZ**2 + vep*complex(0,-1))))/(2*MB**2 - MZ**2 + cmath.sqrt(MZ**4 - 4*MB**2*(MZ**2 + vep*complex(0,-1))))))/(768.*cw**2*MB**4*MW**2*(2*MB - MZ)*(2*MB + MZ)*cmath.pi**2*sw**2) + (ee**2*(-12*MB**4*MW**2 + 30*cw**2*MB**4*MZ**2 + 24*MB**2*MW**2*MZ**2 - 9*cw**2*MB**2*MZ**4 - 6*MW**2*MZ**4 - 80*MB**4*MW**2*sw**2 + 8*MW**2*MZ**4*sw**2 + 32*MB**4*MW**2*sw**4 + 16*MB**2*MW**2*MZ**2*sw**4 - 8*MW**2*MZ**4*sw**4)*(-2*MB**2 + MZ**2 + cmath.sqrt(-4*MB**2*MZ**2 + MZ**4 + MB**2*vep*complex(0,4)))*reglogm((MZ**2 + cmath.sqrt(MZ**4 - 4*MB**2*(MZ**2 + vep*complex(0,-1))))/(-2*MB**2 + MZ**2 + cmath.sqrt(MZ**4 - 4*MB**2*(MZ**2 + vep*complex(0,-1))))))/(768.*cw**2*MB**4*MW**2*(2*MB - MZ)*(2*MB + MZ)*cmath.pi**2*sw**2)) )'},
                                texname = '\delta ZL_b^{EW,MB}')

dMB_HWcft_UV_EW = CTParameter(name = 'dMB_HWcft_UV_EW',
                              type = 'complex',
                              value = {-1:'( 0 if MB == 0 else recms(CMSParam==1.0 and WH != 0,-(ee**2*MB**2*Ncol)/(32.*MW**2*cmath.pi**2*sw**2)) )',
                                        0:'( 0 if MB == 0 else recms(CMSParam==1.0 and WH != 0,(ee**2*MB**2*Ncol*((-8*MB**2)/MH**2 + 2*reglog(4*cmath.pi) - 2*(1 + reglog(4*cmath.pi)) + (4*MB**2*(-reglog(MB**2/MU_R**2)))/MH**2 + (2*(2*MB**2 + MH**2)*reglog((MH**2 + vep*complex(0,-1))/MU_R**2))/MH**2 + (2*(2*MB**2 + MH**2)*reglogm((-MH**2 + cmath.sqrt(MH**2*(-4*MB**2 + MH**2 + vep*complex(0,4))))/(2.*MH**2)))/MH**2 - ((2*MB**2 + MH**2)*(MH**2 + cmath.sqrt(MH**2*(-4*MB**2 + MH**2 + vep*complex(0,4))))*reglogm((-MH**2 + cmath.sqrt(MH**2*(-4*MB**2 + MH**2 + vep*complex(0,4))))/(MH**2 + cmath.sqrt(MH**2*(-4*MB**2 + MH**2 + vep*complex(0,4))))))/MH**4 + (2*(2*MB**2 + MH**2)*reglogm(-(MH**2 + cmath.sqrt(MH**2*(-4*MB**2 + MH**2 + vep*complex(0,4))))/(2.*MH**2)))/MH**2 + ((2*MB**2 + MH**2)*(-MH**2 + cmath.sqrt(MH**2*(-4*MB**2 + MH**2 + vep*complex(0,4))))*reglogm((MH**2 + cmath.sqrt(MH**2*(-4*MB**2 + MH**2 + vep*complex(0,4))))/(-MH**2 + cmath.sqrt(MH**2*(-4*MB**2 + MH**2 + vep*complex(0,4))))))/MH**4))/(64.*MW**2*cmath.pi**2*sw**2)) )'},
                              texname = '\delta Z_{H}^{EW,MB}')


dMB_G0Wcft_UV_EW = CTParameter(name = 'dMB_G0Wcft_UV_EW',
                               type = 'complex',
                               value = {-1:'( 0 if MB == 0 else recms(CMSParam==1.0 and WZ != 0,-(ee**2*MB**2*Ncol)/(32.*MW**2*cmath.pi**2*sw**2)) )',
                                         0:'( 0 if MB == 0 else recms(CMSParam==1.0 and WZ != 0,(ee**2*MB**2*Ncol*(-reglog(16.) - 2*(1 + reglog(cmath.pi)) + 2*reglog(4*cmath.pi) - (4*MB**2*(-reglog(MB**2/MU_R**2)))/(4*MB**2 - MZ**2) + (2*(-2*MB**2 + MZ**2)*reglog((MZ**2 + vep*complex(0,-1))/MU_R**2))/(-4*MB**2 + MZ**2) + (2*(2*MB**2 - MZ**2)*reglogm((-MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)))/(4*MB**2 - MZ**2) + ((-2*MB**2 + MZ**2)*(MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))*reglogm((-MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))))/(4*MB**2*MZ**2 - MZ**4) + (2*(2*MB**2 - MZ**2)*reglogm(-(MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)))/(4*MB**2 - MZ**2) + ((-2*MB**2 + MZ**2)*(-MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))*reglogm((MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(-MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))))/(-4*MB**2*MZ**2 + MZ**4)))/(64.*MW**2*cmath.pi**2*sw**2)) )'},
                               texname = '\delta Z_{G0}^{EW,MB}')


dMB_GpWcft_UV_EW = CTParameter(name = 'dMB_GpWcft_UV_EW',
                               type = 'complex',
                               value = {-1:'( 0 if MB == 0 else recms(CMSParam==1.0 and WW != 0,-(ee**2*MB**2*Ncol)/(32.*MW**2*cmath.pi**2*sw**2)) )',
                                         0:'( 0 if MB == 0 else recms(CMSParam==1.0 and WW != 0,(ee**2*MB**2*Ncol*reglog(4*cmath.pi))/(32.*MW**2*cmath.pi**2*sw**2) + (ee**2*Ncol*(-(MB**2*MW**2*(2*MB**2 - 4*MT**2 + MW**2*(2 + reglog(16.) + 2*reglog(cmath.pi)))) + (2*MB**2*MW**2*(MB**2 - MT**2 - MW**2)*(MB**4 + MT**4 - MT**2*MW**2 - MB**2*(2*MT**2 + MW**2))*(-reglog(MB**2/MU_R**2)))/((MB - MT - MW)*(MB + MT - MW)*(MB - MT + MW)*(MB + MT + MW)) + (2*MT**2*MW**2*(-MB**2 + MT**2 + MW**2)*(MB**4 - 2*MB**2*MT**2 + (MT**2 - MW**2)**2)*reglog(MU_R**2/MT**2))/((MB - MT - MW)*(MB + MT - MW)*(MB - MT + MW)*(MB + MT + MW)) + 2*MT**2*(MT - MW)*(MT + MW)*(MT**2 + MW**2)*reglogm((MT**2 - MW**2 + vep*complex(0,-1))/MT**2) + (2*MW**2*(MB**8 - MB**6*(4*MT**2 + MW**2) + (MT**2 + MW**2)*(MT**3 - MT*MW**2)**2 + MB**4*(6*MT**4 + MT**2*MW**2 - MW**4) + MB**2*(-4*MT**6 + MT**4*MW**2 - 2*MT**2*MW**4 + MW**6))*reglog((MW**2 + vep*complex(0,-1))/MU_R**2))/((MB - MT - MW)*(MB + MT - MW)*(MB - MT + MW)*(MB + MT + MW)) + (2*MW**2*(MB**8 - MB**6*(4*MT**2 + MW**2) + (MT**2 + MW**2)*(MT**3 - MT*MW**2)**2 + MB**4*(6*MT**4 + MT**2*MW**2 - MW**4) + MB**2*(-4*MT**6 + MT**4*MW**2 - 2*MT**2*MW**4 + MW**6))*reglogm((MB**2 - MT**2 - MW**2 - cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(2.*MW**2)))/((MB - MT - MW)*(MB + MT - MW)*(MB - MT + MW)*(MB + MT + MW)) + (2*MW**2*(MB**8 - MB**6*(4*MT**2 + MW**2) + (MT**2 + MW**2)*(MT**3 - MT*MW**2)**2 + MB**4*(6*MT**4 + MT**2*MW**2 - MW**4) + MB**2*(-4*MT**6 + MT**4*MW**2 - 2*MT**2*MW**4 + MW**6))*reglogm((MB**2 - MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(2.*MW**2)))/((MB - MT - MW)*(MB + MT - MW)*(MB - MT + MW)*(MB + MT + MW)) - ((MB**8 - MB**6*(4*MT**2 + MW**2) + (MT**2 + MW**2)*(MT**3 - MT*MW**2)**2 + MB**4*(6*MT**4 + MT**2*MW**2 - MW**4) + MB**2*(-4*MT**6 + MT**4*MW**2 - 2*MT**2*MW**4 + MW**6))*(MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))*reglogm((MB**2 - MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))))/((MB - MT - MW)*(MB + MT - MW)*(MB - MT + MW)*(MB + MT + MW)) + ((MB**8 - MB**6*(4*MT**2 + MW**2) + (MT**2 + MW**2)*(MT**3 - MT*MW**2)**2 + MB**4*(6*MT**4 + MT**2*MW**2 - MW**4) + MB**2*(-4*MT**6 + MT**4*MW**2 - 2*MT**2*MW**4 + MW**6))*(-MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))*reglogm((-MB**2 + MT**2 + MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(-MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))))/((MB - MT - MW)*(MB + MT - MW)*(MB - MT + MW)*(MB + MT + MW))))/(64.*MW**6*cmath.pi**2*sw**2)) )'},
                               texname = '\delta Z_{Gp}^{EW,MB}')

dMB_WWcft_UV_EW = CTParameter(name = 'dMB_WWcft_UV_EW',
                              type = 'complex',
                              value = {0:'( 0 if MB == 0 else recms(CMSParam==1.0 and WW != 0,-(ee**2*MB**2*(2*MB**2 - 4*MT**2 + MW**2)*Ncol)/(96.*MW**4*cmath.pi**2*sw**2) + (ee**2*MB**2*(MB**2 - MT**2 - MT*MW - MW**2)*(MB**2 - MT**2 + MT*MW - MW**2)*(MB**2 - MT**2 + MW**2)*Ncol*(-reglog(MB**2/MU_R**2)))/(48.*(MB - MT - MW)*(MB + MT - MW)*MW**4*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) - (ee**2*(MB**6*MT**2 - 3*MB**4*MT**4 + 3*MB**2*MT**6 - MT**8 - MB**2*MT**4*MW**2 + MT**6*MW**2 - MB**4*MW**4 + 2*MB**2*MT**2*MW**4 + 2*MB**2*MW**6 + MT**2*MW**6 - MW**8)*Ncol*reglog(MU_R**2/MT**2))/(48.*(MB - MT - MW)*(MB + MT - MW)*MW**4*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) - (ee**2*(-MT + MW)*(MT + MW)*(MT**2 - MT*MW + MW**2)*(MT**2 + MT*MW + MW**2)*Ncol*reglogm((MT**2 - MW**2 + vep*complex(0,-1))/MT**2))/(48.*MW**6*cmath.pi**2*sw**2) + (ee**2*(MB**8 - 4*MB**6*MT**2 + 6*MB**4*MT**4 - 4*MB**2*MT**6 + MT**8 - MB**6*MW**2 + MB**4*MT**2*MW**2 + MB**2*MT**4*MW**2 - MT**6*MW**2 - 2*MB**2*MT**2*MW**4 - MB**2*MW**6 - MT**2*MW**6 + MW**8)*Ncol*reglog((MW**2 + vep*complex(0,-1))/MU_R**2))/(48.*(MB - MT - MW)*(MB + MT - MW)*MW**4*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) + (ee**2*(MB**8 - 4*MB**6*MT**2 + 6*MB**4*MT**4 - 4*MB**2*MT**6 + MT**8 - MB**6*MW**2 + MB**4*MT**2*MW**2 + MB**2*MT**4*MW**2 - MT**6*MW**2 - 2*MB**2*MT**2*MW**4 - MB**2*MW**6 - MT**2*MW**6 + MW**8)*Ncol*reglogm((MB**2 - MT**2 - MW**2 - cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(2.*MW**2)))/(48.*(MB - MT - MW)*(MB + MT - MW)*MW**4*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) + (ee**2*(MB**8 - 4*MB**6*MT**2 + 6*MB**4*MT**4 - 4*MB**2*MT**6 + MT**8 - MB**6*MW**2 + MB**4*MT**2*MW**2 + MB**2*MT**4*MW**2 - MT**6*MW**2 - 2*MB**2*MT**2*MW**4 - MB**2*MW**6 - MT**2*MW**6 + MW**8)*Ncol*reglogm((MB**2 - MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(2.*MW**2)))/(48.*(MB - MT - MW)*(MB + MT - MW)*MW**4*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) - (ee**2*(MB**8 - 4*MB**6*MT**2 + 6*MB**4*MT**4 - 4*MB**2*MT**6 + MT**8 - MB**6*MW**2 + MB**4*MT**2*MW**2 + MB**2*MT**4*MW**2 - MT**6*MW**2 - 2*MB**2*MT**2*MW**4 - MB**2*MW**6 - MT**2*MW**6 + MW**8)*Ncol*(MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))*reglogm((MB**2 - MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))))/(96.*(MB - MT - MW)*(MB + MT - MW)*MW**6*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2) - (ee**2*(MB**8 - 4*MB**6*MT**2 + 6*MB**4*MT**4 - 4*MB**2*MT**6 + MT**8 - MB**6*MW**2 + MB**4*MT**2*MW**2 + MB**2*MT**4*MW**2 - MT**6*MW**2 - 2*MB**2*MT**2*MW**4 - MB**2*MW**6 - MT**2*MW**6 + MW**8)*Ncol*(MB**2 - MT**2 + MW**2 - cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))*reglogm((-MB**2 + MT**2 + MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(-MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))))/(96.*(MB - MT - MW)*(MB + MT - MW)*MW**6*(MB - MT + MW)*(MB + MT + MW)*cmath.pi**2*sw**2)) )'},
                              texname = '\delta Z_{W}^{EW,MB}')

dMB_ZZWcft_UV_EW = CTParameter(name = 'dMB_ZZWcft_UV_EW',
                               type = 'complex',
                               value = {                                         0:'( 0 if MB == 0 else recms(CMSParam==1.0 and WZ != 0,(ee**2*Ncol*((2*MB**2*(-9 - 24*sw**2 + 16*sw**4))/MZ**2 - (4*MB**2*(MZ**2*(9 - 12*sw**2 + 8*sw**4) + MB**2*(-9 - 24*sw**2 + 16*sw**4))*(-reglog(MB**2/MU_R**2)))/(4*MB**2*MZ**2 - MZ**4) - (2*(-2*MB**2*MZ**2*(9 - 12*sw**2 + 8*sw**4) + MZ**4*(9 - 12*sw**2 + 8*sw**4) + 2*MB**4*(-9 - 24*sw**2 + 16*sw**4))*reglog((MZ**2 + vep*complex(0,-1))/MU_R**2))/(4*MB**2*MZ**2 - MZ**4) + 2*(9 - 12*sw**2 + 8*sw**4)*reglogp(-(MU_R**2/(MZ**2 + vep*complex(0,1)))) - (2*(-2*MB**2*MZ**2*(9 - 12*sw**2 + 8*sw**4) + MZ**4*(9 - 12*sw**2 + 8*sw**4) + 2*MB**4*(-9 - 24*sw**2 + 16*sw**4))*reglogm((-MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)))/(4*MB**2*MZ**2 - MZ**4) + ((-2*MB**2*MZ**2*(9 - 12*sw**2 + 8*sw**4) + MZ**4*(9 - 12*sw**2 + 8*sw**4) + 2*MB**4*(-9 - 24*sw**2 + 16*sw**4))*(MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))*reglogm((-MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))))/(4*MB**2*MZ**4 - MZ**6) - (2*(-2*MB**2*MZ**2*(9 - 12*sw**2 + 8*sw**4) + MZ**4*(9 - 12*sw**2 + 8*sw**4) + 2*MB**4*(-9 - 24*sw**2 + 16*sw**4))*reglogm(-(MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)))/(4*MB**2*MZ**2 - MZ**4) + ((-2*MB**2*MZ**2*(9 - 12*sw**2 + 8*sw**4) + MZ**4*(9 - 12*sw**2 + 8*sw**4) + 2*MB**4*(-9 - 24*sw**2 + 16*sw**4))*(MZ**2 - cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))*reglogm((MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(-MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))))/(4*MB**2*MZ**4 - MZ**6)))/(1728.*cw**2*cmath.pi**2*sw**2)) )'},
                               texname = '\delta Z_{ZZ}^{EW,MB}')


dMB_AZWcft_UV_EW = CTParameter(name = 'dMB_AZWcft_UV_EW',
                               type = 'complex',
                               value = {                                         0:'( 0 if MB == 0 else recms(CMSParam==1.0 and WZ != 0,(ee**2*((16*MB**2*Ncol*(3 - 4*sw**2))/MZ**2 + (8*MB**2*Ncol*(-3 + 4*sw**2)*(-reglog(MB**2/MU_R**2)))/MZ**2 + (4*(2*MB**2 + MZ**2)*Ncol*(-3 + 4*sw**2)*reglog((MZ**2 + vep*complex(0,-1))/MU_R**2))/MZ**2 - 4*(-27 - 18*Ncol + 108*sw**2 + 40*Ncol*sw**2)*reglogp(-(MU_R**2/(MZ**2 + vep*complex(0,1)))) + 4*(-27 - 21*Ncol + 108*sw**2 + 44*Ncol*sw**2)*reglogp(-(MU_R**2/(MZ**2 + vep*complex(0,1)))) + (4*(2*MB**2 + MZ**2)*Ncol*(-3 + 4*sw**2)*reglogm((-MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)))/MZ**2 - (2*(2*MB**2 + MZ**2)*Ncol*(-3 + 4*sw**2)*(MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))*reglogm((-MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))))/MZ**4 + (4*(2*MB**2 + MZ**2)*Ncol*(-3 + 4*sw**2)*reglogm(-(MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)))/MZ**2 - (2*(2*MB**2 + MZ**2)*Ncol*(-3 + 4*sw**2)*(MZ**2 - cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))*reglogm((MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(-MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))))/MZ**4))/(864.*cw*cmath.pi**2*sw)) )'},
                               texname = '\delta Z_{AZ}^{EW,MB}')


dMB_AAWcft_UV_EW = CTParameter(name = 'dMB_AAWcft_UV_EW',
                               type = 'complex',
                               value = {-1:'( 0 if MB == 0 else recms(CMSParam==1.0,-(ee**2*Ncol)/(108.*cmath.pi**2)) )',
                                         0:'( 0 if MB == 0 else recms(CMSParam==1.0,(ee**2*Ncol*(reglog(MB) - reglog(MU_R)))/(54.*cmath.pi**2)) )'},
                               texname = '\delta Z_{AA}^{EW,MB}')


dMB_eCoup_UV_EW = CTParameter(name = 'dMB_eCoup_UV_EW',
                              type = 'complex',
                              value = {                                        0:'( 0 if MB == 0 else recms(CMSParam==1.0,-(ee**2*Ncol*reglog(MB))/(108.*cmath.pi**2) + (ee**2*Ncol*(18*MB**4 - 36*MB**2*MT**2 - 36*MB**4*sw**2 + 72*MB**2*MT**2*sw**2 - 105*MB**2*MW**2*sw**2 + 160*MB**2*MW**2*sw**4 - 64*MB**2*MW**2*sw**6 + 4*MW**4*sw**4*reglog(256) + 32*MW**4*sw**4*reglog(cmath.pi) - 32*MW**4*sw**4*reglog(2*cmath.pi)))/(3456.*MW**4*cmath.pi**2*sw**4) + (ee**2*Ncol*reglog(MU_R))/(108.*cmath.pi**2) + (ee**2*Ncol*(-9*MB**6 + 18*MB**4*MT**2 - 9*MB**2*MT**4 + 18*MB**6*sw**2 - 36*MB**4*MT**2*sw**2 + 18*MB**2*MT**4*sw**2 + 33*MB**4*MW**2*sw**2 - 6*MB**2*MT**2*MW**2*sw**2 - 40*MB**4*MW**2*sw**4 + 40*MB**2*MT**2*MW**2*sw**4 - 8*MB**2*MW**4*sw**4 + 8*MT**2*MW**4*sw**4 + 16*MB**4*MW**2*sw**6 - 16*MB**2*MT**2*MW**2*sw**6)*reglog(MU_R**2/MB**2))/(1728.*(MB - MT)*(MB + MT)*MW**4*cmath.pi**2*sw**4) - (ee**2*Ncol*(-(MB**4*MT**2) + 2*MB**2*MT**4 - MT**6 + MB**2*MT**2*MW**2 - MT**4*MW**2 - 2*MB**2*MW**4 + 2*MT**2*MW**4 + 2*MB**4*MT**2*sw**2 - 4*MB**2*MT**4*sw**2 + 2*MT**6*sw**2 + MB**2*MT**2*MW**2*sw**2 + 2*MT**4*MW**2*sw**2 + 4*MB**2*MW**4*sw**2 - 4*MT**2*MW**4*sw**2)*reglog(MU_R**2/MT**2))/(192.*(MB - MT)*(MB + MT)*MW**4*cmath.pi**2*sw**4) - (ee**2*Ncol*(-9*MB**2 + 9*MW**2 - 15*MB**2*sw**2 - 12*MW**2*sw**2 + 40*MB**2*sw**4 + 8*MW**2*sw**4 - 16*MB**2*sw**6)*reglog((-MW**2 - (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2 + 4*MB**2*(-1 + sw**2) + (-1 + sw**2)*vep*complex(0,-4)))/(-1 + sw**2)**2))/(2.*MW**2)))/(1728.*MW**2*cmath.pi**2*sw**4) - (ee**2*Ncol*(-9*MB**2 + 9*MW**2 - 15*MB**2*sw**2 - 12*MW**2*sw**2 + 40*MB**2*sw**4 + 8*MW**2*sw**4 - 16*MB**2*sw**6)*reglog((-MW**2 + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2 + 4*MB**2*(-1 + sw**2) + (-1 + sw**2)*vep*complex(0,-4)))/(-1 + sw**2)**2))/(2.*MW**2)))/(1728.*MW**2*cmath.pi**2*sw**4) + (ee**2*Ncol*(-9*MB**2 + 9*MW**2 - 15*MB**2*sw**2 - 12*MW**2*sw**2 + 40*MB**2*sw**4 + 8*MW**2*sw**4 - 16*MB**2*sw**6)*(MW**2 - cmath.sqrt((MW**2*(-4*MB**2 + MW**2 + 4*MB**2*sw**2 + sw**2*vep*complex(0,-4) + vep*complex(0,4)))/(-1 + sw**2)**2) + sw**2*cmath.sqrt((MW**2*(-4*MB**2 + MW**2 + 4*MB**2*sw**2 + sw**2*vep*complex(0,-4) + vep*complex(0,4)))/(-1 + sw**2)**2))*reglog((-MW**2 + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2 + 4*MB**2*(-1 + sw**2) + (-1 + sw**2)*vep*complex(0,-4)))/(-1 + sw**2)**2))/(MW**2 + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2 + 4*MB**2*(-1 + sw**2) + (-1 + sw**2)*vep*complex(0,-4)))/(-1 + sw**2)**2))))/(3456.*MW**4*cmath.pi**2*sw**4) + (ee**2*Ncol*(-9*MB**2 + 9*MW**2 - 15*MB**2*sw**2 - 12*MW**2*sw**2 + 40*MB**2*sw**4 + 8*MW**2*sw**4 - 16*MB**2*sw**6)*(MW**2 + cmath.sqrt((MW**2*(-4*MB**2 + MW**2 + 4*MB**2*sw**2 + sw**2*vep*complex(0,-4) + vep*complex(0,4)))/(-1 + sw**2)**2) - sw**2*cmath.sqrt((MW**2*(-4*MB**2 + MW**2 + 4*MB**2*sw**2 + sw**2*vep*complex(0,-4) + vep*complex(0,4)))/(-1 + sw**2)**2))*reglog((MW**2 + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2 + 4*MB**2*(-1 + sw**2) + (-1 + sw**2)*vep*complex(0,-4)))/(-1 + sw**2)**2))/(-MW**2 + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2 + 4*MB**2*(-1 + sw**2) + (-1 + sw**2)*vep*complex(0,-4)))/(-1 + sw**2)**2))))/(3456.*MW**4*cmath.pi**2*sw**4) + (ee**2*(MT - MW)**2*(MT + MW)**2*(MT**2 + 2*MW**2)*Ncol*(-1 + 2*sw**2)*reglog((MT**2 - MW**2 + vep*complex(0,-1))/MT**2))/(192.*MW**6*cmath.pi**2*sw**4) - (ee**2*(-MB**4 + 2*MB**2*MT**2 - MT**4 - MB**2*MW**2 - MT**2*MW**2 + 2*MW**4)*Ncol*(-1 + 2*sw**2)*reglog((MW**2 + vep*complex(0,-1))/MU_R**2))/(192.*MW**4*cmath.pi**2*sw**4) - (ee**2*Ncol*(-9*MB**2 + 9*MW**2 - 15*MB**2*sw**2 - 12*MW**2*sw**2 + 40*MB**2*sw**4 + 8*MW**2*sw**4 - 16*MB**2*sw**6)*reglog((MW**2/(1 - sw**2) + vep*complex(0,-1))/MU_R**2))/(1728.*MW**2*cmath.pi**2*sw**4) - (ee**2*Ncol*(9 - 12*sw**2 + 8*sw**4)*reglog(((-1 + sw**2)*MU_R**2)/(MW**2 + (-1 + sw**2)*vep*complex(0,-1))))/(1728.*cmath.pi**2*sw**4) - (ee**2*(-MB**4 + 2*MB**2*MT**2 - MT**4 - MB**2*MW**2 - MT**2*MW**2 + 2*MW**4)*Ncol*(-1 + 2*sw**2)*reglog((MB**2 - MT**2 - MW**2 - cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(2.*MW**2)))/(192.*MW**4*cmath.pi**2*sw**4) - (ee**2*(-MB**4 + 2*MB**2*MT**2 - MT**4 - MB**2*MW**2 - MT**2*MW**2 + 2*MW**4)*Ncol*(-1 + 2*sw**2)*reglog((MB**2 - MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(2.*MW**2)))/(192.*MW**4*cmath.pi**2*sw**4) + (ee**2*(-MB**4 + 2*MB**2*MT**2 - MT**4 - MB**2*MW**2 - MT**2*MW**2 + 2*MW**4)*Ncol*(-1 + 2*sw**2)*(MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))*reglog((MB**2 - MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))))/(384.*MW**6*cmath.pi**2*sw**4) + (ee**2*(-MB**4 + 2*MB**2*MT**2 - MT**4 - MB**2*MW**2 - MT**2*MW**2 + 2*MW**4)*Ncol*(-1 + 2*sw**2)*(MB**2 - MT**2 + MW**2 - cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))*reglog((-MB**2 + MT**2 + MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(-MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))))/(384.*MW**6*cmath.pi**2*sw**4) - (ee**2*(-1 + 2*sw**2)*(-3 + 4*sw**2)*(33 - 44*sw**2 + 12*sw**4)*reglog((-(MW**2/(1 - sw**2)) - cmath.sqrt((MW**2*(MW**2*(-3 + 4*sw**2) + (-1 + sw**2)**2*vep*complex(0,4)))/(-1 + sw**2)**2))/(2.*MW**2)))/(384.*cmath.pi**2*(-1 + sw)**2*sw**4*(1 + sw)**2) + (ee**2*(-1 + 2*sw**2)*(-3 + 4*sw**2)*(33 - 44*sw**2 + 12*sw**4)*reglog((MW**2/(-1 + sw**2) - cmath.sqrt((MW**2*(MW**2*(-3 + 4*sw**2) + (-1 + sw**2)**2*vep*complex(0,4)))/(-1 + sw**2)**2))/(2.*MW**2)))/(384.*cmath.pi**2*(-1 + sw)**2*sw**4*(1 + sw)**2)) )'},
                              texname = '\delta e^{MB}')

dMB_SWCoup_UV_EW = CTParameter(name = 'dMB_SWCoup_UV_EW',
                               type = 'complex',
                               value = {-1:'( 0 if MB == 0 else recms(CMSParam==1.0 and (WW != 0 and WZ != 0),-(ee**2*MB**2*(MW - cw*MZ)*(MW + cw*MZ)*Ncol)/(64.*MW**2*MZ**2*cmath.pi**2*sw**3)) )',
                                         0:'( 0 if MB == 0 else recms(CMSParam==1.0 and (WW != 0 and WZ != 0),(ee**2*MB**2*(MW**2 - cw**2*MZ**2)*Ncol*reglog(4*cmath.pi))/(64.*MW**2*MZ**2*cmath.pi**2*sw**3) + (cw**2*(-(ee**2*Ncol*(-2*MB**2*MW**2*(MB**2 - 2*MT**2 + MW**2*(2 + reglog(64.) + 3*reglog(cmath.pi))) + 2*MB**2*MW**2*(MB**2 - MT**2 - 2*MW**2)*(-reglog(MB**2/MU_R**2)) + 2*MW**2*(-(MB**2*MT**2) + MT**4 + MT**2*MW**2 - 2*MW**4)*reglog(MU_R**2/MT**2) + 2*(MT - MW)**2*(MT + MW)**2*(MT**2 + 2*MW**2)*reglogm((MT**2 - MW**2 + vep*complex(0,-1))/MT**2) - 2*MW**2*(-MB**4 - MT**4 - MT**2*MW**2 + 2*MW**4 + MB**2*(2*MT**2 - MW**2))*reglog((MW**2 + vep*complex(0,-1))/MU_R**2) - 2*MW**2*(-MB**4 - MT**4 - MT**2*MW**2 + 2*MW**4 + MB**2*(2*MT**2 - MW**2))*reglogm((MB**2 - MT**2 - MW**2 - cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(2.*MW**2)) - 2*MW**2*(-MB**4 - MT**4 - MT**2*MW**2 + 2*MW**4 + MB**2*(2*MT**2 - MW**2))*reglogm((MB**2 - MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(2.*MW**2)) - (MB**4 + MT**4 + MT**2*MW**2 - 2*MW**4 + MB**2*(-2*MT**2 + MW**2))*(MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))*reglogm((MB**2 - MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))) + (MB**4 + MT**4 + MT**2*MW**2 - 2*MW**4 + MB**2*(-2*MT**2 + MW**2))*(-MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))*reglogm((-MB**2 + MT**2 + MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(-MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1)))))))/(192.*MW**6*cmath.pi**2*sw**2) + (ee**2*(2*MB**2*Ncol*(-18 - 48*sw**2 + 32*sw**4 - reglog(18014398509481984.) - 27*reglog(cmath.pi)) - 4*MB**2*Ncol*(9 - 12*sw**2 + 8*sw**4)*(-reglog(MB**2/MU_R**2)) - 2*Ncol*(MZ**2*(9 - 12*sw**2 + 8*sw**4) + MB**2*(-9 - 24*sw**2 + 16*sw**4))*reglog((MZ**2 + vep*complex(0,-1))/MU_R**2) + 4*MZ**2*(27*(1 - 2*sw**2 + 4*sw**4) + 2*Ncol*(9 - 18*sw**2 + 20*sw**4))*reglogp(-(MU_R**2/(MZ**2 + vep*complex(0,1)))) - 2*MZ**2*(54*(1 - 2*sw**2 + 4*sw**4) + Ncol*(45 - 84*sw**2 + 88*sw**4))*reglogp(-(MU_R**2/(MZ**2 + vep*complex(0,1)))) - 2*Ncol*(MZ**2*(9 - 12*sw**2 + 8*sw**4) + MB**2*(-9 - 24*sw**2 + 16*sw**4))*reglogm((-MZ**2 - cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)) - 2*Ncol*(MZ**2*(9 - 12*sw**2 + 8*sw**4) + MB**2*(-9 - 24*sw**2 + 16*sw**4))*reglogm((-MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)) + (Ncol*(MZ**2*(9 - 12*sw**2 + 8*sw**4) + MB**2*(-9 - 24*sw**2 + 16*sw**4))*(MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))*reglogm((-MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))))/MZ**2 + (Ncol*(MZ**2*(9 - 12*sw**2 + 8*sw**4) + MB**2*(-9 - 24*sw**2 + 16*sw**4))*(MZ**2 - cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))*reglogm((MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(-MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))))/MZ**2))/(1728.*cw**2*MZ**2*cmath.pi**2*sw**2)))/(2.*sw)) )'},
                               texname = '\delta SW^{MB}')


dMB_CWCoup_UV_EW = CTParameter(name = 'dMB_CWCoup_UV_EW',
                               type = 'complex',
                               value = {-1:'( 0 if MB == 0 else recms(CMSParam==1.0 and (WW != 0  or WZ != 0),(ee**2*MB**2*(MW**2 - cw**2*MZ**2)*Ncol)/(64.*cw*MW**2*MZ**2*cmath.pi**2*sw**2)) )',
                                         0:'( 0 if MB == 0 else recms(CMSParam==1.0 and (WW != 0 or WZ != 0),-(ee**2*MB**2*(MW**2 - cw**2*MZ**2)*Ncol*reglog(4*cmath.pi))/(64.*cw*MW**2*MZ**2*cmath.pi**2*sw**2) + (cw*((ee**2*Ncol*(-2*MB**2*MW**2*(MB**2 - 2*MT**2 + MW**2*(2 + reglog(64.) + 3*reglog(cmath.pi))) + 2*MB**2*MW**2*(MB**2 - MT**2 - 2*MW**2)*(-reglog(MB**2/MU_R**2)) + 2*MW**2*(-(MB**2*MT**2) + MT**4 + MT**2*MW**2 - 2*MW**4)*reglog(MU_R**2/MT**2) + 2*(MT - MW)**2*(MT + MW)**2*(MT**2 + 2*MW**2)*reglogm((MT**2 - MW**2 + vep*complex(0,-1))/MT**2) - 2*MW**2*(-MB**4 - MT**4 - MT**2*MW**2 + 2*MW**4 + MB**2*(2*MT**2 - MW**2))*reglog((MW**2 + vep*complex(0,-1))/MU_R**2) - 2*MW**2*(-MB**4 - MT**4 - MT**2*MW**2 + 2*MW**4 + MB**2*(2*MT**2 - MW**2))*reglogm((MB**2 - MT**2 - MW**2 - cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(2.*MW**2)) - 2*MW**2*(-MB**4 - MT**4 - MT**2*MW**2 + 2*MW**4 + MB**2*(2*MT**2 - MW**2))*reglogm((MB**2 - MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(2.*MW**2)) - (MB**4 + MT**4 + MT**2*MW**2 - 2*MW**4 + MB**2*(-2*MT**2 + MW**2))*(MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))*reglogm((MB**2 - MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(MB**2 - MT**2 + MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))) + (MB**4 + MT**4 + MT**2*MW**2 - 2*MW**4 + MB**2*(-2*MT**2 + MW**2))*(-MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))*reglogm((-MB**2 + MT**2 + MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1))))/(-MB**2 + MT**2 - MW**2 + cmath.sqrt((MB**2 - MT**2 + MW**2)**2 - 4*MW**2*(MB**2 + vep*complex(0,-1)))))))/(192.*MW**6*cmath.pi**2*sw**2) - (ee**2*(2*MB**2*Ncol*(-18 - 48*sw**2 + 32*sw**4 - reglog(18014398509481984.) - 27*reglog(cmath.pi)) - 4*MB**2*Ncol*(9 - 12*sw**2 + 8*sw**4)*(-reglog(MB**2/MU_R**2)) - 2*Ncol*(MZ**2*(9 - 12*sw**2 + 8*sw**4) + MB**2*(-9 - 24*sw**2 + 16*sw**4))*reglog((MZ**2 + vep*complex(0,-1))/MU_R**2) + 4*MZ**2*(27*(1 - 2*sw**2 + 4*sw**4) + 2*Ncol*(9 - 18*sw**2 + 20*sw**4))*reglogp(-(MU_R**2/(MZ**2 + vep*complex(0,1)))) - 2*MZ**2*(54*(1 - 2*sw**2 + 4*sw**4) + Ncol*(45 - 84*sw**2 + 88*sw**4))*reglogp(-(MU_R**2/(MZ**2 + vep*complex(0,1)))) - 2*Ncol*(MZ**2*(9 - 12*sw**2 + 8*sw**4) + MB**2*(-9 - 24*sw**2 + 16*sw**4))*reglogm((-MZ**2 - cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)) - 2*Ncol*(MZ**2*(9 - 12*sw**2 + 8*sw**4) + MB**2*(-9 - 24*sw**2 + 16*sw**4))*reglogm((-MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)) + (Ncol*(MZ**2*(9 - 12*sw**2 + 8*sw**4) + MB**2*(-9 - 24*sw**2 + 16*sw**4))*(MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))*reglogm((-MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))))/MZ**2 + (Ncol*(MZ**2*(9 - 12*sw**2 + 8*sw**4) + MB**2*(-9 - 24*sw**2 + 16*sw**4))*(MZ**2 - cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))*reglogm((MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))/(-MZ**2 + cmath.sqrt(MZ**2*(-4*MB**2 + MZ**2 + vep*complex(0,4))))))/MZ**2))/(1728.*cw**2*MZ**2*cmath.pi**2*sw**2)))/2.) )'},
                               texname = '\delta CW^{MB}')



# ================================================ #
# QED UV parameters                                #
# Following UV parameters are for MB == 0          #
# ================================================ #

HiggsTadpole_UV_EW = CTParameter(name = 'HiggsTadpole_UV_EW',
                                 type = 'complex',
                                 value = {-1:'-(ee*(8*MW**2*MZ**2 - 2*cw*MW*MZ**3 + cw**2*(3*MH**4 + 12*MW**4 + MH**2*(2*MW**2 + MZ**2) - 8*MT**4*Ncol)))/(64.*cw**2*MW*cmath.pi**2*sw)'+'+'+dMB_HiggsTadpole_UV_EW.value[-1],
                                           0:'-(ee*(3*cw**2*MH**4 + 2*cw**2*MH**2*MW**2 + 4*cw**2*MW**4 + cw**2*MH**2*MZ**2 + 4*MW**2*MZ**2 - 2*cw*MW*MZ**3 - 8*cw**2*MT**4*Ncol + 3*cw**2*MH**4*reglog(MU_R**2/MH**2) - 8*cw**2*MT**4*Ncol*reglog(MU_R**2/MT**2) + 2*cw**2*MH**2*MW**2*reglog(MU_R**2/MW**2) + 12*cw**2*MW**4*reglog(MU_R**2/MW**2) + cw**2*MH**2*MZ**2*reglog(MU_R**2/MZ**2) + 8*MW**2*MZ**2*reglog(MU_R**2/MZ**2) - 2*cw*MW*MZ**3*reglog(MU_R**2/MZ**2)))/(64.*cw**2*MW*cmath.pi**2*sw)'+'+'+dMB_HiggsTadpole_UV_EW.value[0]},
                                 texname = '\delta ht^{EW}')



tMass_UV_EW = CTParameter(name = 'tMass_UV_EW',
                          type = 'complex',
                          value = {-1:'recms(CMSParam==1.0 and WT != 0,(ee**2*MT*(MW**2*(3 + 24*sw**2 - 32*sw**4) + cw**2*(9*MT**2 + 2*MW**2*(3 - 16*sw**2))))/(384.*cw**2*MW**2*cmath.pi**2*sw**2))'+'+'+dMB_tMass_UV_EW.value[-1],
                          0:'recms(CMSParam==1.0 and WT != 0,-(ee**2*(9*cw**2*MH**2*MT**2 - 72*cw**2*MT**4 - 18*MT**2*MW**2 - 9*cw**2*MT**2*MW**2 + 18*cw**2*MW**4 + 9*cw**2*MT**2*MZ**2 + 9*MW**2*MZ**2 - 96*MT**2*MW**2*sw**2 + 128*cw**2*MT**2*MW**2*sw**2 - 24*MW**2*MZ**2*sw**2 + 128*MT**2*MW**2*sw**4 + 32*MW**2*MZ**2*sw**4 - 9*cw**2*MT**4*reglog(16) + 9*cw**2*MT**4*reglog(1/(4.*cmath.pi)) + 9*MT**2*MW**2*reglog(1/(4.*cmath.pi)) - 24*MT**2*MW**2*sw**2*reglog(1/(4.*cmath.pi)) + 16*MT**2*MW**2*sw**4*reglog(1/(4.*cmath.pi)) - 18*cw**2*MT**4*reglog(cmath.pi) + 96*MT**2*MW**2*sw**2*reglog(cmath.pi) - 112*cw**2*MT**2*MW**2*sw**2*reglog(cmath.pi) - 128*MT**2*MW**2*sw**4*reglog(cmath.pi) - 192*MT**2*MW**2*sw**2*reglog(2*cmath.pi) + 224*cw**2*MT**2*MW**2*sw**2*reglog(2*cmath.pi) + 256*MT**2*MW**2*sw**4*reglog(2*cmath.pi) + 27*cw**2*MT**4*reglog(4*cmath.pi) + 9*MT**2*MW**2*reglog(4*cmath.pi) + 72*MT**2*MW**2*sw**2*reglog(4*cmath.pi) - 112*cw**2*MT**2*MW**2*sw**2*reglog(4*cmath.pi) - 112*MT**2*MW**2*sw**4*reglog(4*cmath.pi)))/(1152.*cw**2*MT*MW**2*cmath.pi**2*sw**2) + (ee**2*MH**2*MT*reglog(MU_R**2/MH**2))/(128.*MW**2*cmath.pi**2*sw**2) - (ee**2*MT*(18*cw**2*MT**2 + 9*MW**2 - 24*MW**2*sw**2 + 96*cw**2*MW**2*sw**2 + 32*MW**2*sw**4)*reglog(MU_R**2/MT**2))/(1152.*cw**2*MW**2*cmath.pi**2*sw**2) + (ee**2*MT*(MT**2 + 2*MW**2)*reglog(MU_R**2/MW**2))/(128.*MW**2*cmath.pi**2*sw**2) + (ee**2*MZ**2*(9*cw**2*MT**2 + 9*MW**2 - 24*MW**2*sw**2 + 32*MW**2*sw**4)*reglog(MU_R**2/MZ**2))/(1152.*cw**2*MT*MW**2*cmath.pi**2*sw**2) - (ee**2*(-9*cw**2*MH**2*MT**2 + 36*cw**2*MT**4 + 18*MT**2*MW**2 - 9*cw**2*MT**2*MZ**2 - 9*MW**2*MZ**2 + 48*MT**2*MW**2*sw**2 + 24*MW**2*MZ**2*sw**2 - 64*MT**2*MW**2*sw**4 - 32*MW**2*MZ**2*sw**4)*reglog((MT**2 + vep*complex(0,-1))/MU_R**2))/(1152.*cw**2*MT*MW**2*cmath.pi**2*sw**2) - (ee**2*(MT - MW)**2*(MT + MW)**2*(MT**2 + 2*MW**2)*reglogm((-MT**2 + MW**2 + vep*complex(0,-1))/MW**2))/(128.*MT**3*MW**2*cmath.pi**2*sw**2) + (ee**2*(-18*MT**2*MW**2 + 9*cw**2*MT**2*MZ**2 + 9*MW**2*MZ**2 - 48*MT**2*MW**2*sw**2 - 24*MW**2*MZ**2*sw**2 + 64*MT**2*MW**2*sw**4 + 32*MW**2*MZ**2*sw**4)*reglog((-MZ**2 - cmath.sqrt(MZ**4 - 4*MT**2*(MZ**2 + vep*complex(0,-1))))/(2.*MT**2)))/(1152.*cw**2*MT*MW**2*cmath.pi**2*sw**2) + (ee**2*(-18*MT**2*MW**2 + 9*cw**2*MT**2*MZ**2 + 9*MW**2*MZ**2 - 48*MT**2*MW**2*sw**2 - 24*MW**2*MZ**2*sw**2 + 64*MT**2*MW**2*sw**4 + 32*MW**2*MZ**2*sw**4)*reglog((-MZ**2 + cmath.sqrt(MZ**4 - 4*MT**2*(MZ**2 + vep*complex(0,-1))))/(2.*MT**2)))/(1152.*cw**2*MT*MW**2*cmath.pi**2*sw**2) - (ee**2*(-18*MT**2*MW**2 + 9*cw**2*MT**2*MZ**2 + 9*MW**2*MZ**2 - 48*MT**2*MW**2*sw**2 - 24*MW**2*MZ**2*sw**2 + 64*MT**2*MW**2*sw**4 + 32*MW**2*MZ**2*sw**4)*(2*MT**2 - MZ**2 + cmath.sqrt(-4*MT**2*MZ**2 + MZ**4 + MT**2*vep*complex(0,4)))*reglog((-MZ**2 + cmath.sqrt(MZ**4 - 4*MT**2*(MZ**2 + vep*complex(0,-1))))/(2*MT**2 - MZ**2 + cmath.sqrt(MZ**4 - 4*MT**2*(MZ**2 + vep*complex(0,-1))))))/(2304.*cw**2*MT**3*MW**2*cmath.pi**2*sw**2) - (ee**2*(-18*MT**2*MW**2 + 9*cw**2*MT**2*MZ**2 + 9*MW**2*MZ**2 - 48*MT**2*MW**2*sw**2 - 24*MW**2*MZ**2*sw**2 + 64*MT**2*MW**2*sw**4 + 32*MW**2*MZ**2*sw**4)*(2*MT**2 - MZ**2 - cmath.sqrt(-4*MT**2*MZ**2 + MZ**4 + MT**2*vep*complex(0,4)))*reglog((MZ**2 + cmath.sqrt(MZ**4 - 4*MT**2*(MZ**2 + vep*complex(0,-1))))/(-2*MT**2 + MZ**2 + cmath.sqrt(MZ**4 - 4*MT**2*(MZ**2 + vep*complex(0,-1))))))/(2304.*cw**2*MT**3*MW**2*cmath.pi**2*sw**2) - (ee**2*MT*(-MH + 2*MT)*(MH + 2*MT)*reglog(-1 + (MH**2 - cmath.sqrt(MH**4 - 4*MT**2*(MH**2 + vep*complex(0,-1))))/(2.*MT**2)))/(128.*MW**2*cmath.pi**2*sw**2) - (ee**2*MT*(-MH + 2*MT)*(MH + 2*MT)*reglog(-1 + (MH**2 + cmath.sqrt(MH**4 - 4*MT**2*(MH**2 + vep*complex(0,-1))))/(2.*MT**2)))/(128.*MW**2*cmath.pi**2*sw**2) + (ee**2*(-MH + 2*MT)*(MH + 2*MT)*(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MT**2 + MT**2*vep*complex(0,4)))*reglog((MH**2 - 2*MT**2 + cmath.sqrt(MH**4 - 4*MH**2*MT**2 + MT**2*vep*complex(0,4)))/(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MT**2 + MT**2*vep*complex(0,4)))))/(256.*MT*MW**2*cmath.pi**2*sw**2) + (ee**2*(-MH + 2*MT)*(MH + 2*MT)*(MH**2 - cmath.sqrt(MH**4 - 4*MH**2*MT**2 + MT**2*vep*complex(0,4)))*reglog((-MH**2 + 2*MT**2 + cmath.sqrt(MH**4 - 4*MH**2*MT**2 + MT**2*vep*complex(0,4)))/(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MT**2 + MT**2*vep*complex(0,4)))))/(256.*MT*MW**2*cmath.pi**2*sw**2))'+'+'+dMB_tMass_UV_EW.value[0]},
                          texname = '\delta m_t^{EW}')

HMass2_UV_EW = CTParameter(name = 'HMass2_UV_EW',
                           type = 'complex',
                           value = {-1:'recms(CMSParam==1.0 and WH != 0,(ee**2*(16*MW**4 + 2*cw**2*MW**2*(-2*MH**2 + MZ**2) + cw**4*(15*MH**4 + 36*MW**4 - 24*MT**4*Ncol + MH**2*(-6*MW**2 + MZ**2 + 4*MT**2*Ncol))))/(128.*cw**4*MW**2*cmath.pi**2*sw**2))'+'+'+dMB_HMass2_UV_EW.value[-1],
                                    0:'recms(CMSParam==1.0 and WH != 0,-(ee**2*(16*MW**4 + 2*cw**2*MW**2*(-2*MH**2 + MZ**2) + cw**4*(15*MH**4 + 36*MW**4 - 24*MT**4*Ncol + MH**2*(-6*MW**2 + MZ**2 + 4*MT**2*Ncol)))*reglog(4*cmath.pi))/(128.*cw**4*MW**2*cmath.pi**2*sw**2) + (ee**2*((-2*(8*MW**4*(-3 - reglog(16) - 2*reglog(cmath.pi)) + 2*cw**2*MW**2*(MZ**2*(3 + reglog(1/(4.*cmath.pi))) + MH**2*(4 + reglog(16) + 2*reglog(cmath.pi))) + cw**4*(4*(9*MW**4*(-1 + reglog(1/(4.*cmath.pi))) + 2*MT**4*Ncol*(5 + reglog(64) + 3*reglog(cmath.pi))) + 3*MH**4*(-9 + 5*reglog(cmath.pi) - 10*reglog(2*cmath.pi)) - MH**2*(MW**2*(-14 - reglog(4096) - 6*reglog(cmath.pi)) + MT**2*Ncol*(8 + reglog(256) + 4*reglog(cmath.pi)) + MZ**2*(1 + reglog(4*cmath.pi))))))/(cw**4*MW**2) + (6*MH**4*reglog(MU_R**2/MH**2))/MW**2 - (16*MT**4*Ncol*reglog(MU_R**2/MT**2))/MW**2 + 4*(MH**2 + 6*MW**2)*reglog(MU_R**2/MW**2) + (2*(cw**2*MH**2 + 6*MW**2)*MZ**2*reglog(MU_R**2/MZ**2))/(cw**2*MW**2) - (8*(4*MW**4 - cw**2*MW**2*(MH**2 + MZ**2) + cw**4*(3*MH**4 + 6*MW**4 - 4*MT**4*Ncol + MH**2*(-2*MW**2 + MT**2*Ncol)))*reglog((MH**2 + vep*complex(0,-1))/MU_R**2))/(cw**4*MW**2) + (8*MT**2*(-MH + 2*MT)*(MH + 2*MT)*Ncol*reglog((-MH**2 - cmath.sqrt(MH**2*(MH**2 - 4*MT**2 + vep*complex(0,4))))/(2.*MH**2)))/MW**2 + (8*MT**2*(-MH + 2*MT)*(MH + 2*MT)*Ncol*reglog((-MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MT**2 + vep*complex(0,4))))/(2.*MH**2)))/MW**2 + (4*(MH - 2*MT)*MT**2*(MH + 2*MT)*Ncol*(MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MT**2 + vep*complex(0,4))))*reglog((-MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MT**2 + vep*complex(0,4))))/(MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MT**2 + vep*complex(0,4))))))/(MH**2*MW**2) + (4*(MH - 2*MT)*MT**2*(MH + 2*MT)*Ncol*(MH**2 - cmath.sqrt(MH**2*(MH**2 - 4*MT**2 + vep*complex(0,4))))*reglog((MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MT**2 + vep*complex(0,4))))/(-MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MT**2 + vep*complex(0,4))))))/(MH**2*MW**2) - (4*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*reglog((-MH**2 - cmath.sqrt(MH**2*(MH**2 - 4*MW**2 + vep*complex(0,4))))/(2.*MH**2)))/MW**2 - (4*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*reglog((-MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MW**2 + vep*complex(0,4))))/(2.*MH**2)))/MW**2 + (2*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*(MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MW**2 + vep*complex(0,4))))*reglog((-MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MW**2 + vep*complex(0,4))))/(MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MW**2 + vep*complex(0,4))))))/(MH**2*MW**2) + (2*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*(MH**2 - cmath.sqrt(MH**2*(MH**2 - 4*MW**2 + vep*complex(0,4))))*reglog((MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MW**2 + vep*complex(0,4))))/(-MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MW**2 + vep*complex(0,4))))))/(MH**2*MW**2) - (2*(cw**4*MH**4 + 16*MW**4 - 4*cw**2*MW**2*(MH**2 + MZ**2))*reglog((-MH**2 - cmath.sqrt(MH**2*(MH**2 - 4*MZ**2 + vep*complex(0,4))))/(2.*MH**2)))/(cw**4*MW**2) - (2*(cw**4*MH**4 + 16*MW**4 - 4*cw**2*MW**2*(MH**2 + MZ**2))*reglog((-MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MZ**2 + vep*complex(0,4))))/(2.*MH**2)))/(cw**4*MW**2) + ((cw**4*MH**4 + 16*MW**4 - 4*cw**2*MW**2*(MH**2 + MZ**2))*(MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MZ**2 + vep*complex(0,4))))*reglog((-MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MZ**2 + vep*complex(0,4))))/(MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MZ**2 + vep*complex(0,4))))))/(cw**4*MH**2*MW**2) + ((cw**4*MH**4 + 16*MW**4 - 4*cw**2*MW**2*(MH**2 + MZ**2))*(MH**2 - cmath.sqrt(MH**2*(MH**2 - 4*MZ**2 + vep*complex(0,4))))*reglog((MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MZ**2 + vep*complex(0,4))))/(-MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MZ**2 + vep*complex(0,4))))))/(cw**4*MH**2*MW**2) + (9*MH**2*(MH**2 + cmath.sqrt(-3*MH**4 + MH**2*vep*complex(0,4)))*reglog((-MH**2 + cmath.sqrt(-3*MH**4 + MH**2*vep*complex(0,4)))/(MH**2 + cmath.sqrt(-3*MH**4 + MH**2*vep*complex(0,4)))))/MW**2 + (9*MH**2*(MH**2 - cmath.sqrt(-3*MH**4 + MH**2*vep*complex(0,4)))*reglog((MH**2 + cmath.sqrt(-3*MH**4 + MH**2*vep*complex(0,4)))/(-MH**2 + cmath.sqrt(-3*MH**4 + MH**2*vep*complex(0,4)))))/MW**2 - (18*MH**4*reglog(-0.5 - cmath.sqrt(-3*MH**4 + MH**2*vep*complex(0,4))/(2.*MH**2)))/MW**2 - (18*MH**4*reglog(-0.5 + cmath.sqrt(-3*MH**4 + MH**2*vep*complex(0,4))/(2.*MH**2)))/MW**2))/(256.*cmath.pi**2*sw**2))'+'+'+dMB_HMass2_UV_EW.value[0]},
                           texname = '\delta m2_H^{EW}')

WMass2_UV_EW = CTParameter(name = 'WMass2_UV_EW',
                           type = 'complex',
                           value = {-1:'recms(CMSParam==1.0 and WW != 0,-(ee**2*(cw**4*(44*MW**2 + 6*MZ**2) - 6*MW**2*sw**4 + cw**2*(3*MT**2*Ncol + MW**2*(-31 - 6*Ncol + 38*sw**2))))/(96.*cw**2*cmath.pi**2*sw**2))'+'+'+dMB_WMass2_UV_EW.value[-1],
                           0:'recms(CMSParam==1.0 and WW != 0,(ee**2*(cw**4*(44*MW**2 + 6*MZ**2) - 6*MW**2*sw**4 + cw**2*(3*MT**2*Ncol + MW**2*(-31 - 6*Ncol + 38*sw**2)))*reglog(4*cmath.pi))/(96.*cw**2*cmath.pi**2*sw**2) + (ee**2*((2*(cw**2*(3*MH**4 - 18*MH**2*MW**2 + 3*(MZ**4 - 2*MT**4*Ncol) - 6*MW**2*(3*MZ**2 + MT**2*Ncol*(2 + reglog(64) + 3*reglog(cmath.pi))) - 2*MW**4*(-83 + 178*sw**2 + 93*reglog(cmath.pi) - 114*sw**2*reglog(cmath.pi) - 6*Ncol*(5 + reglog(64) + 3*reglog(cmath.pi)) - 186*reglog(2*cmath.pi) + 228*sw**2*reglog(2*cmath.pi))) + 4*cw**4*(6*MZ**4 + MW**4*(-107 + 66*reglog(cmath.pi) - 132*reglog(2*cmath.pi)) + 9*MW**2*MZ**2*(-6 - reglog(4*cmath.pi))) + 36*MW**4*sw**4*(2 + reglog(4*cmath.pi))))/(cw**2*MW**2) - (6*MH**2*(MH**2 - 3*MW**2)*reglog(MU_R**2/MH**2))/MW**2 - 12*(3*MT**2 - 2*MW**2)*Ncol*reglog(MU_R**2/MT**2) + 6*(MH**2 + (1 + 8*cw**2)*MZ**2 + MW**2*(38 - 28*cw**2 - 76*sw**2))*reglog(MU_R**2/MW**2) - (6*(1 + 8*cw**2)*MZ**2*(-3*MW**2 + MZ**2)*reglog(MU_R**2/MZ**2))/MW**2 - (12*(MT - MW)**2*(MT + MW)**2*(MT**2 + 2*MW**2)*Ncol*reglog((MT**2 - MW**2 + vep*complex(0,-1))/MT**2))/MW**4 + (6*(cw**4*(60*MW**4 + 44*MW**2*MZ**2 - 8*MZ**4) - cw**2*(MH**4 - 4*MH**2*MW**2 + 12*MW**4 - 4*MW**2*MZ**2 + MZ**4) - 12*MW**4*sw**4)*reglog((MW**2 + vep*complex(0,-1))/MU_R**2))/(cw**2*MW**2) + (6*(cw**4*(60*MW**4 + 44*MW**2*MZ**2 - 8*MZ**4) + cw**2*(4*MW**2*MZ**2 - MZ**4) - 12*MW**4*sw**4)*reglog((-MZ**2 - cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(2.*MW**2)))/(cw**2*MW**2) + (6*(cw**4*(60*MW**4 + 44*MW**2*MZ**2 - 8*MZ**4) + cw**2*(4*MW**2*MZ**2 - MZ**4) - 12*MW**4*sw**4)*reglog((-MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(2.*MW**2)))/(cw**2*MW**2) - (3*(cw**4*(60*MW**4 + 44*MW**2*MZ**2 - 8*MZ**4) + cw**2*(4*MW**2*MZ**2 - MZ**4) - 12*MW**4*sw**4)*(2*MW**2 - MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))*reglog((-MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(2*MW**2 - MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))))/(cw**2*MW**4) + (3*(cw**4*(60*MW**4 + 44*MW**2*MZ**2 - 8*MZ**4) + cw**2*(4*MW**2*MZ**2 - MZ**4) - 12*MW**4*sw**4)*(-2*MW**2 + MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))*reglog((MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(-2*MW**2 + MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))))/(cw**2*MW**4) - (6*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*reglog(-1 + (MH**2 - cmath.sqrt(MH**4 - 4*MW**2*(MH**2 + vep*complex(0,-1))))/(2.*MW**2)))/MW**2 - (6*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*reglog(-1 + (MH**2 + cmath.sqrt(MH**4 - 4*MW**2*(MH**2 + vep*complex(0,-1))))/(2.*MW**2)))/MW**2 + 24*MW**2*(3 + 2*Ncol)*reglogp(-(MU_R**2/(MW**2 + vep*complex(0,1)))) + (3*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))*reglog((MH**2 - 2*MW**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))/(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))))/MW**4 - (3*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))*reglog((-MH**2 + 2*MW**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))/(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))))/MW**4))/(1152.*cmath.pi**2*sw**2))'+'+'+dMB_WMass2_UV_EW.value[0]},
                           texname = '\delta m2_W^{EW}')

ZMass2_UV_EW = CTParameter(name = 'ZMass2_UV_EW',
                          type = 'complex',
                          value = {-1:'recms(CMSParam==1.0 and WZ != 0,-(ee**2*(36*MW**2*(-1 + 2*cw**6 - 2*cw**2*sw**4) + cw**2*(18*MT**2*Ncol + MZ**2*(-39 + 117*cw**4 + 72*sw**2 + 6*cw**2*sw**2 - 147*sw**4 - 4*Ncol*(9 - 18*sw**2 + 20*sw**4)))))/(576.*cw**4*cmath.pi**2*sw**2))'+'+'+dMB_ZMass2_UV_EW.value[-1],
                          0:'recms(CMSParam==1.0 and WZ != 0,(ee**2*(36*MW**2*(-1 + 2*cw**6 - 2*cw**2*sw**4) + cw**2*(18*MT**2*Ncol + MZ**2*(-39 + 117*cw**4 + 72*sw**2 + 6*cw**2*sw**2 - 147*sw**4 - 4*Ncol*(9 - 18*sw**2 + 20*sw**4))))*reglog(4*cmath.pi))/(576.*cw**4*cmath.pi**2*sw**2) + (ee**2*((2*(-108*MW**2*MZ**2*(-2 + reglog(1/(4.*cmath.pi))) + 6*cw**4*MZ**2*sw**2*(24*MW**2 + MZ**2*(-8 - reglog(64) - 3*reglog(cmath.pi))) + 9*cw**6*MZ**2*(24*MW**2*(-5 + reglog(1/(4.*cmath.pi))) + MZ**2*(-80 + 39*reglog(cmath.pi) - 78*reglog(2*cmath.pi))) + cw**2*(9*MH**4 - 54*MH**2*MZ**2 + MZ**2*(2*(-36*MW**2*sw**4*(-5 - reglog(64) - 3*reglog(cmath.pi)) + MT**2*Ncol*(-96*sw**2 + 128*sw**4 - 9*(2 + reglog(64) + 3*reglog(cmath.pi)))) + MZ**2*(4*Ncol*(9 - 18*sw**2 + 20*sw**4)*(5 + reglog(64) + 3*reglog(cmath.pi)) + 3*(59 - 39*reglog(cmath.pi) - 24*sw**2*(5 + reglog(64) + 3*reglog(cmath.pi)) + 78*reglog(2*cmath.pi) + sw**4*(248 - 147*reglog(cmath.pi) + 294*reglog(2*cmath.pi))))))))/MZ**2 - (18*cw**2*MH**2*(MH**2 - 3*MZ**2)*reglog(MU_R**2/MH**2))/MZ**2 - 8*cw**2*MT**2*Ncol*(9 - 24*sw**2 + 32*sw**4)*reglog(MU_R**2/MT**2) + 72*cw**2*MW**2*(9*cw**4 - 2*cw**2*sw**2 + sw**4)*reglog(MU_R**2/MW**2) + 18*cw**2*(MH**2 + MZ**2)*reglog(MU_R**2/MZ**2) + (2*(-108*MW**2*MZ**2 + 27*cw**6*(20*MW**2*MZ**2 + 13*MZ**4) + 18*cw**4*MZ**2*(-4*MW**2 + MZ**2)*sw**2 - cw**2*(9*MH**4 - 36*MH**2*MZ**2 + MZ**2*(180*MW**2*sw**4 + 2*MT**2*Ncol*(-9 - 48*sw**2 + 64*sw**4) + MZ**2*(9*sw**4 + 2*Ncol*(9 - 24*sw**2 + 32*sw**4)))))*reglog((MZ**2 + vep*complex(0,-1))/MU_R**2))/MZ**2 - (18*(12*MW**2*MZ**2 + cw**2*(MH**4 - 4*MH**2*MZ**2))*reglog(-1 + (MH**2 - cmath.sqrt(MH**4 - 4*MZ**2*(MH**2 + vep*complex(0,-1))))/(2.*MZ**2)))/MZ**2 - (18*(12*MW**2*MZ**2 + cw**2*(MH**4 - 4*MH**2*MZ**2))*reglog(-1 + (MH**2 + cmath.sqrt(MH**4 - 4*MZ**2*(MH**2 + vep*complex(0,-1))))/(2.*MZ**2)))/MZ**2 + 4*cw**2*MZ**2*(54*(1 - 2*sw**2 + 4*sw**4) + Ncol*(45 - 84*sw**2 + 88*sw**4))*reglogp(-(MU_R**2/(MZ**2 + vep*complex(0,1)))) - 4*cw**2*Ncol*(MZ**2*(9 - 24*sw**2 + 32*sw**4) + MT**2*(-9 - 48*sw**2 + 64*sw**4))*reglog((-MZ**2 - cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)) - 4*cw**2*Ncol*(MZ**2*(9 - 24*sw**2 + 32*sw**4) + MT**2*(-9 - 48*sw**2 + 64*sw**4))*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)) + (2*cw**2*Ncol*(MZ**2*(9 - 24*sw**2 + 32*sw**4) + MT**2*(-9 - 48*sw**2 + 64*sw**4))*(MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))))/MZ**2 + (2*cw**2*Ncol*(MZ**2*(9 - 24*sw**2 + 32*sw**4) + MT**2*(-9 - 48*sw**2 + 64*sw**4))*(MZ**2 - cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))*reglog((MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(-MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))))/MZ**2 + 18*cw**2*(cw**4*(60*MW**2 + 39*MZ**2) + 2*cw**2*(-4*MW**2 + MZ**2)*sw**2 - (20*MW**2 + MZ**2)*sw**4)*reglog((-MZ**2 - cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)) + 18*cw**2*(cw**4*(60*MW**2 + 39*MZ**2) + 2*cw**2*(-4*MW**2 + MZ**2)*sw**2 - (20*MW**2 + MZ**2)*sw**4)*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)) - (9*cw**2*(cw**4*(60*MW**2 + 39*MZ**2) + 2*cw**2*(-4*MW**2 + MZ**2)*sw**2 - (20*MW**2 + MZ**2)*sw**4)*(MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))))/MZ**2 - (9*cw**2*(cw**4*(60*MW**2 + 39*MZ**2) + 2*cw**2*(-4*MW**2 + MZ**2)*sw**2 - (20*MW**2 + MZ**2)*sw**4)*(MZ**2 - cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))*reglog((MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(-MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))))/MZ**2 + (9*(12*MW**2*MZ**2 + cw**2*(MH**4 - 4*MH**2*MZ**2))*(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))*reglog((MH**2 - 2*MZ**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))/(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))))/MZ**4 - (9*(12*MW**2*MZ**2 + cw**2*(MH**4 - 4*MH**2*MZ**2))*(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))*reglog((-MH**2 + 2*MZ**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))/(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))))/MZ**4))/(3456.*cw**4*cmath.pi**2*sw**2))'+'+'+dMB_ZMass2_UV_EW.value[0]},
                          texname = '\delta m2_Z^{EW}')


tWcft_UV_EW_R = CTParameter(name = 'tWcft_UV_EW_R',
                            type = 'complex',
                            value = {-1:'recms(CMSParam==1.0 and WT != 0,-(ee**2*(8*MW**2*sw**4 + 3*cw**2*(3*MT**2 + 8*MW**2*sw**2)))/(288.*cw**2*MW**2*cmath.pi**2*sw**2))',
                            0:'recms(CMSParam==1.0 and WT != 0,-(ee**2*(27*cw**2*MH**2*MT**2 - 36*cw**2*MT**4 - 54*MT**2*MW**2 - 18*cw**2*MT**2*MW**2 + 72*cw**2*MW**4 + 27*cw**2*MT**2*MZ**2 + 36*MW**2*MZ**2 - 48*MT**2*MW**2*sw**2 + 128*cw**2*MT**2*MW**2*sw**2 - 96*MW**2*MZ**2*sw**2 + 128*MT**2*MW**2*sw**4 + 96*MW**2*MZ**2*sw**4 + 18*cw**2*MT**4*reglog(16) + 64*cw**2*MT**2*MW**2*sw**2*reglog(16) + 36*cw**2*MT**4*reglog(cmath.pi) + 128*cw**2*MT**2*MW**2*sw**2*reglog(cmath.pi) - 36*cw**2*MT**4*reglog(4*cmath.pi) - 128*cw**2*MT**2*MW**2*sw**2*reglog(4*cmath.pi)))/(1152.*cw**2*MT**2*MW**2*cmath.pi**2*sw**2) + (ee**2*(3*MH**2 - 4*MT**2)*reglog(MU_R**2/MH**2))/(128.*MW**2*cmath.pi**2*sw**2) - (ee**2*(24*cw**2*MT**4 + 18*MT**2*MW**2 - 9*cw**2*MT**2*MZ**2 - 6*MW**2*MZ**2 - 16*MT**2*MW**2*sw**2 + 64*cw**2*MT**2*MW**2*sw**2 + 16*MW**2*MZ**2*sw**2 - 16*cw**2*MW**2*MZ**2*sw**2 - 16*MW**2*MZ**2*sw**4)*reglog(MU_R**2/MT**2))/(192.*cw**2*MW**2*(2*MT - MZ)*(2*MT + MZ)*cmath.pi**2*sw**2) - (ee**2*MT**2*reglog(MU_R**2/MW**2))/(64.*MW**2*cmath.pi**2*sw**2) + (ee**2*(-72*MT**4*MW**2 + 72*cw**2*MT**4*MZ**2 + 144*MT**2*MW**2*MZ**2 - 27*cw**2*MT**2*MZ**4 - 36*MW**2*MZ**4 - 192*MT**4*MW**2*sw**2 - 192*MT**2*MW**2*MZ**2*sw**2 + 96*MW**2*MZ**4*sw**2 + 256*MT**4*MW**2*sw**4 + 128*MT**2*MW**2*MZ**2*sw**4 - 96*MW**2*MZ**4*sw**4)*reglog(MU_R**2/MZ**2))/(1152.*cw**2*MT**2*MW**2*(2*MT - MZ)*(2*MT + MZ)*cmath.pi**2*sw**2) - (ee**2*(-36*cw**2*MH**2*MT**4 + 72*cw**2*MT**6 + 60*MT**4*MW**2 + 9*cw**2*MH**2*MT**2*MZ**2 - 48*cw**2*MT**4*MZ**2 - 60*MT**2*MW**2*MZ**2 + 9*cw**2*MT**2*MZ**4 + 12*MW**2*MZ**4 + 32*MT**4*MW**2*sw**2 + 96*MT**2*MW**2*MZ**2*sw**2 - 32*MW**2*MZ**4*sw**2 - 128*MT**4*MW**2*sw**4 - 64*MT**2*MW**2*MZ**2*sw**4 + 32*MW**2*MZ**4*sw**4)*reglog((MT**2 + vep*complex(0,-1))/MU_R**2))/(384.*cw**2*MT**2*MW**2*(2*MT - MZ)*(2*MT + MZ)*cmath.pi**2*sw**2) + (ee**2*(MT - MW)*(MT + MW)*(MT**4 + MT**2*MW**2 + 4*MW**4)*reglogm((-MT**2 + MW**2 + vep*complex(0,-1))/MW**2))/(64.*MT**4*MW**2*cmath.pi**2*sw**2) + (ee**2*(-60*MT**4*MW**2 + 30*cw**2*MT**4*MZ**2 + 60*MT**2*MW**2*MZ**2 - 9*cw**2*MT**2*MZ**4 - 12*MW**2*MZ**4 - 32*MT**4*MW**2*sw**2 - 96*MT**2*MW**2*MZ**2*sw**2 + 32*MW**2*MZ**4*sw**2 + 128*MT**4*MW**2*sw**4 + 64*MT**2*MW**2*MZ**2*sw**4 - 32*MW**2*MZ**4*sw**4)*reglog((-MZ**2 - cmath.sqrt(MZ**4 - 4*MT**2*(MZ**2 + vep*complex(0,-1))))/(2.*MT**2)))/(384.*cw**2*MT**2*MW**2*(2*MT - MZ)*(2*MT + MZ)*cmath.pi**2*sw**2) + (ee**2*(-60*MT**4*MW**2 + 30*cw**2*MT**4*MZ**2 + 60*MT**2*MW**2*MZ**2 - 9*cw**2*MT**2*MZ**4 - 12*MW**2*MZ**4 - 32*MT**4*MW**2*sw**2 - 96*MT**2*MW**2*MZ**2*sw**2 + 32*MW**2*MZ**4*sw**2 + 128*MT**4*MW**2*sw**4 + 64*MT**2*MW**2*MZ**2*sw**4 - 32*MW**2*MZ**4*sw**4)*reglog((-MZ**2 + cmath.sqrt(MZ**4 - 4*MT**2*(MZ**2 + vep*complex(0,-1))))/(2.*MT**2)))/(384.*cw**2*MT**2*MW**2*(2*MT - MZ)*(2*MT + MZ)*cmath.pi**2*sw**2) - (ee**2*(-60*MT**4*MW**2 + 30*cw**2*MT**4*MZ**2 + 60*MT**2*MW**2*MZ**2 - 9*cw**2*MT**2*MZ**4 - 12*MW**2*MZ**4 - 32*MT**4*MW**2*sw**2 - 96*MT**2*MW**2*MZ**2*sw**2 + 32*MW**2*MZ**4*sw**2 + 128*MT**4*MW**2*sw**4 + 64*MT**2*MW**2*MZ**2*sw**4 - 32*MW**2*MZ**4*sw**4)*(2*MT**2 - MZ**2 + cmath.sqrt(-4*MT**2*MZ**2 + MZ**4 + MT**2*vep*complex(0,4)))*reglog((-MZ**2 + cmath.sqrt(MZ**4 - 4*MT**2*(MZ**2 + vep*complex(0,-1))))/(2*MT**2 - MZ**2 + cmath.sqrt(MZ**4 - 4*MT**2*(MZ**2 + vep*complex(0,-1))))))/(768.*cw**2*MT**4*MW**2*(2*MT - MZ)*(2*MT + MZ)*cmath.pi**2*sw**2) + (ee**2*(-60*MT**4*MW**2 + 30*cw**2*MT**4*MZ**2 + 60*MT**2*MW**2*MZ**2 - 9*cw**2*MT**2*MZ**4 - 12*MW**2*MZ**4 - 32*MT**4*MW**2*sw**2 - 96*MT**2*MW**2*MZ**2*sw**2 + 32*MW**2*MZ**4*sw**2 + 128*MT**4*MW**2*sw**4 + 64*MT**2*MW**2*MZ**2*sw**4 - 32*MW**2*MZ**4*sw**4)*(-2*MT**2 + MZ**2 + cmath.sqrt(-4*MT**2*MZ**2 + MZ**4 + MT**2*vep*complex(0,4)))*reglog((MZ**2 + cmath.sqrt(MZ**4 - 4*MT**2*(MZ**2 + vep*complex(0,-1))))/(-2*MT**2 + MZ**2 + cmath.sqrt(MZ**4 - 4*MT**2*(MZ**2 + vep*complex(0,-1))))))/(768.*cw**2*MT**4*MW**2*(2*MT - MZ)*(2*MT + MZ)*cmath.pi**2*sw**2) + (3*ee**2*(MH**2 - 2*MT**2)*reglog(-1 + (MH**2 - cmath.sqrt(MH**4 - 4*MT**2*(MH**2 + vep*complex(0,-1))))/(2.*MT**2)))/(128.*MW**2*cmath.pi**2*sw**2) + (3*ee**2*(MH**2 - 2*MT**2)*reglog(-1 + (MH**2 + cmath.sqrt(MH**4 - 4*MT**2*(MH**2 + vep*complex(0,-1))))/(2.*MT**2)))/(128.*MW**2*cmath.pi**2*sw**2) - (3*ee**2*(MH**2 - 2*MT**2)*(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MT**2 + MT**2*vep*complex(0,4)))*reglog((MH**2 - 2*MT**2 + cmath.sqrt(MH**4 - 4*MH**2*MT**2 + MT**2*vep*complex(0,4)))/(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MT**2 + MT**2*vep*complex(0,4)))))/(256.*MT**2*MW**2*cmath.pi**2*sw**2) + (3*ee**2*(MH**2 - 2*MT**2)*(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MT**2 + MT**2*vep*complex(0,4)))*reglog((-MH**2 + 2*MT**2 + cmath.sqrt(MH**4 - 4*MH**2*MT**2 + MT**2*vep*complex(0,4)))/(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MT**2 + MT**2*vep*complex(0,4)))))/(256.*MT**2*MW**2*cmath.pi**2*sw**2))'+'+'+dMB_tWcft_UV_EW_R.value[0]},
                            texname = '\delta ZR_t^{EW}')




cWcft_UV_EW_R = CTParameter(name = 'cWcft_UV_EW_R',
                            type = 'complex',
                            value = {-1:'recms(CMSParam==1.0,-(ee**2*sw**2)/(36.*cw**2*cmath.pi**2))',
                                      0:'recms(CMSParam==1.0,-(ee**2*sw**2*(-1 + 2*reglog(MU_R**2/MZ**2)))/(72.*cw**2*cmath.pi**2))'},
                            texname = '\delta ZR_c^{EW}')


uWcft_UV_EW_R = CTParameter(name = 'uWcft_UV_EW_R',
                           type = 'complex',
                           value = {-1:'recms(CMSParam==1.0,-(ee**2*sw**2)/(36.*cw**2*cmath.pi**2))',
                                     0:'recms(CMSParam==1.0,-(ee**2*sw**2*(-1 + 2*reglog(MU_R**2/MZ**2)))/(72.*cw**2*cmath.pi**2))'},
                           texname = '\delta ZR_u^{EW}')



bWcft_UV_EW_R = CTParameter(name = 'bWcft_UV_EW_R',
                            type = 'complex',
                            value = {-1:'recms(CMSParam==1.0,-(ee**2*sw**2)/(144.*cw**2*cmath.pi**2))'+'+'+dMB_bWcft_UV_EW_R.value[-1],
                                      0:'recms(CMSParam==1.0,-(ee**2*sw**2*(-1 + 2*reglog(MU_R**2/MZ**2)))/(288.*cw**2*cmath.pi**2))'+'+'+dMB_bWcft_UV_EW_R.value[0]},
                            texname = '\delta ZR_b^{EW}')


sWcft_UV_EW_R = CTParameter(name = 'sWcft_UV_EW_R',
                            type = 'complex',
                            value = {-1:'recms(CMSParam==1.0,-(ee**2*sw**2)/(144.*cw**2*cmath.pi**2))',
                                      0:'recms(CMSParam==1.0,-(ee**2*sw**2*(-1 + 2*reglog(MU_R**2/MZ**2)))/(288.*cw**2*cmath.pi**2))'},
                            texname = '\delta ZR_s^{EW}')


dWcft_UV_EW_R = CTParameter(name = 'dWcft_UV_EW_R',
                            type = 'complex',
                            value = {-1:'recms(CMSParam==1.0,-(ee**2*sw**2)/(144.*cw**2*cmath.pi**2))',
                                      0:'recms(CMSParam==1.0,-(ee**2*sw**2*(-1 + 2*reglog(MU_R**2/MZ**2)))/(288.*cw**2*cmath.pi**2))'},
                            texname = '\delta ZR_d^{EW}')


tauWcft_UV_EW_R = CTParameter(name = 'tauWcft_UV_EW_R',
                              type = 'complex',
                              value = {-1:'recms(CMSParam==1.0,-(ee**2*sw**2)/(16.*cw**2*cmath.pi**2))',
                                        0:'recms(CMSParam==1.0,-(ee**2*sw**2*(-1 + 2*reglog(MU_R**2/MZ**2)))/(32.*cw**2*cmath.pi**2))'},
                              texname = '\delta ZR_tau^{EW}')


muWcft_UV_EW_R = CTParameter(name = 'muWcft_UV_EW_R',
                             type = 'complex',
                             value = {-1:'recms(CMSParam==1.0,-(ee**2*sw**2)/(16.*cw**2*cmath.pi**2))',
                                       0:'recms(CMSParam==1.0,-(ee**2*sw**2*(-1 + 2*reglog(MU_R**2/MZ**2)))/(32.*cw**2*cmath.pi**2))'},
                             texname = '\delta ZR_mu^{EW}')


eWcft_UV_EW_R = CTParameter(name = 'eWcft_UV_EW_R',
                            type = 'complex',
                            value = {-1:'recms(CMSParam==1.0,-(ee**2*sw**2)/(16.*cw**2*cmath.pi**2))',
                                      0:'recms(CMSParam==1.0,-(ee**2*sw**2*(-1 + 2*reglog(MU_R**2/MZ**2)))/(32.*cw**2*cmath.pi**2))'},
                            texname = '\delta ZR_e^{EW}')

tWcft_UV_EW_L = CTParameter(name = 'tWcft_UV_EW_L',
                            type = 'complex',
                            value = {-1:'recms(CMSParam==1.0 and WT != 0,-(ee**2*(MW**2*(3 - 4*sw**2)**2 + 3*cw**2*(3*MT**2 + 2*MW**2*(3 + 8*sw**2))))/(576.*cw**2*MW**2*cmath.pi**2*sw**2))'+'+'+dMB_tWcft_UV_EW_L.value[-1],
                            0:'recms(CMSParam==1.0 and WT != 0,(ee**2*(-27*cw**2*MH**2*MT**2 + 72*cw**2*MT**4 + 18*MT**2*MW**2 - 36*cw**2*MT**2*MW**2 - 36*cw**2*MW**4 - 27*cw**2*MT**2*MZ**2 - 18*MW**2*MZ**2 + 144*MT**2*MW**2*sw**2 - 128*cw**2*MT**2*MW**2*sw**2 + 48*MW**2*MZ**2*sw**2 - 128*MT**2*MW**2*sw**4 - 96*MW**2*MZ**2*sw**4 - 64*cw**2*MT**2*MW**2*sw**2*reglog(16) + 18*cw**2*MT**4*reglog(1/(4.*cmath.pi)) + 18*MT**2*MW**2*reglog(1/(4.*cmath.pi)) - 48*MT**2*MW**2*sw**2*reglog(1/(4.*cmath.pi)) + 32*MT**2*MW**2*sw**4*reglog(1/(4.*cmath.pi)) - 160*cw**2*MT**2*MW**2*sw**2*reglog(cmath.pi) + 64*cw**2*MT**2*MW**2*sw**2*reglog(2*cmath.pi) + 18*cw**2*MT**4*reglog(4*cmath.pi) + 18*MT**2*MW**2*reglog(4*cmath.pi) - 48*MT**2*MW**2*sw**2*reglog(4*cmath.pi) + 96*cw**2*MT**2*MW**2*sw**2*reglog(4*cmath.pi) + 32*MT**2*MW**2*sw**4*reglog(4*cmath.pi)))/(1152.*cw**2*MT**2*MW**2*cmath.pi**2*sw**2) + (ee**2*(3*MH**2 - 4*MT**2)*reglog(MU_R**2/MH**2))/(128.*MW**2*cmath.pi**2*sw**2) - (ee**2*(24*cw**2*MT**4 + 6*MT**2*MW**2 - 9*cw**2*MT**2*MZ**2 - 3*MW**2*MZ**2 + 16*MT**2*MW**2*sw**2 + 64*cw**2*MT**2*MW**2*sw**2 + 8*MW**2*MZ**2*sw**2 - 16*cw**2*MW**2*MZ**2*sw**2 - 16*MW**2*MZ**2*sw**4)*reglog(MU_R**2/MT**2))/(192.*cw**2*MW**2*(2*MT - MZ)*(2*MT + MZ)*cmath.pi**2*sw**2) - (ee**2*reglog(MU_R**2/MW**2))/(32.*cmath.pi**2*sw**2) + (ee**2*(-72*MT**4*MW**2 + 72*cw**2*MT**4*MZ**2 + 72*MT**2*MW**2*MZ**2 - 27*cw**2*MT**2*MZ**4 - 18*MW**2*MZ**4 - 192*MT**4*MW**2*sw**2 + 48*MW**2*MZ**4*sw**2 + 256*MT**4*MW**2*sw**4 + 128*MT**2*MW**2*MZ**2*sw**4 - 96*MW**2*MZ**4*sw**4)*reglog(MU_R**2/MZ**2))/(1152.*cw**2*MT**2*MW**2*(2*MT - MZ)*(2*MT + MZ)*cmath.pi**2*sw**2) - (ee**2*(-36*cw**2*MH**2*MT**4 + 72*cw**2*MT**6 + 12*MT**4*MW**2 + 9*cw**2*MH**2*MT**2*MZ**2 - 48*cw**2*MT**4*MZ**2 - 24*MT**2*MW**2*MZ**2 + 9*cw**2*MT**2*MZ**4 + 6*MW**2*MZ**4 + 160*MT**4*MW**2*sw**2 - 16*MW**2*MZ**4*sw**2 - 128*MT**4*MW**2*sw**4 - 64*MT**2*MW**2*MZ**2*sw**4 + 32*MW**2*MZ**4*sw**4)*reglog((MT**2 + vep*complex(0,-1))/MU_R**2))/(384.*cw**2*MT**2*MW**2*(2*MT - MZ)*(2*MT + MZ)*cmath.pi**2*sw**2) + (ee**2*(MT - MW)*(MT + MW)*(2*MT**2 + MW**2)*reglogm((-MT**2 + MW**2 + vep*complex(0,-1))/MW**2))/(32.*MT**4*cmath.pi**2*sw**2) + (ee**2*(-12*MT**4*MW**2 + 30*cw**2*MT**4*MZ**2 + 24*MT**2*MW**2*MZ**2 - 9*cw**2*MT**2*MZ**4 - 6*MW**2*MZ**4 - 160*MT**4*MW**2*sw**2 + 16*MW**2*MZ**4*sw**2 + 128*MT**4*MW**2*sw**4 + 64*MT**2*MW**2*MZ**2*sw**4 - 32*MW**2*MZ**4*sw**4)*reglog((-MZ**2 - cmath.sqrt(MZ**4 - 4*MT**2*(MZ**2 + vep*complex(0,-1))))/(2.*MT**2)))/(384.*cw**2*MT**2*MW**2*(2*MT - MZ)*(2*MT + MZ)*cmath.pi**2*sw**2) + (ee**2*(-12*MT**4*MW**2 + 30*cw**2*MT**4*MZ**2 + 24*MT**2*MW**2*MZ**2 - 9*cw**2*MT**2*MZ**4 - 6*MW**2*MZ**4 - 160*MT**4*MW**2*sw**2 + 16*MW**2*MZ**4*sw**2 + 128*MT**4*MW**2*sw**4 + 64*MT**2*MW**2*MZ**2*sw**4 - 32*MW**2*MZ**4*sw**4)*reglog((-MZ**2 + cmath.sqrt(MZ**4 - 4*MT**2*(MZ**2 + vep*complex(0,-1))))/(2.*MT**2)))/(384.*cw**2*MT**2*MW**2*(2*MT - MZ)*(2*MT + MZ)*cmath.pi**2*sw**2) - (ee**2*(-12*MT**4*MW**2 + 30*cw**2*MT**4*MZ**2 + 24*MT**2*MW**2*MZ**2 - 9*cw**2*MT**2*MZ**4 - 6*MW**2*MZ**4 - 160*MT**4*MW**2*sw**2 + 16*MW**2*MZ**4*sw**2 + 128*MT**4*MW**2*sw**4 + 64*MT**2*MW**2*MZ**2*sw**4 - 32*MW**2*MZ**4*sw**4)*(2*MT**2 - MZ**2 + cmath.sqrt(-4*MT**2*MZ**2 + MZ**4 + MT**2*vep*complex(0,4)))*reglog((-MZ**2 + cmath.sqrt(MZ**4 - 4*MT**2*(MZ**2 + vep*complex(0,-1))))/(2*MT**2 - MZ**2 + cmath.sqrt(MZ**4 - 4*MT**2*(MZ**2 + vep*complex(0,-1))))))/(768.*cw**2*MT**4*MW**2*(2*MT - MZ)*(2*MT + MZ)*cmath.pi**2*sw**2) + (ee**2*(-12*MT**4*MW**2 + 30*cw**2*MT**4*MZ**2 + 24*MT**2*MW**2*MZ**2 - 9*cw**2*MT**2*MZ**4 - 6*MW**2*MZ**4 - 160*MT**4*MW**2*sw**2 + 16*MW**2*MZ**4*sw**2 + 128*MT**4*MW**2*sw**4 + 64*MT**2*MW**2*MZ**2*sw**4 - 32*MW**2*MZ**4*sw**4)*(-2*MT**2 + MZ**2 + cmath.sqrt(-4*MT**2*MZ**2 + MZ**4 + MT**2*vep*complex(0,4)))*reglog((MZ**2 + cmath.sqrt(MZ**4 - 4*MT**2*(MZ**2 + vep*complex(0,-1))))/(-2*MT**2 + MZ**2 + cmath.sqrt(MZ**4 - 4*MT**2*(MZ**2 + vep*complex(0,-1))))))/(768.*cw**2*MT**4*MW**2*(2*MT - MZ)*(2*MT + MZ)*cmath.pi**2*sw**2) + (3*ee**2*(MH**2 - 2*MT**2)*reglog(-1 + (MH**2 - cmath.sqrt(MH**4 - 4*MT**2*(MH**2 + vep*complex(0,-1))))/(2.*MT**2)))/(128.*MW**2*cmath.pi**2*sw**2) + (3*ee**2*(MH**2 - 2*MT**2)*reglog(-1 + (MH**2 + cmath.sqrt(MH**4 - 4*MT**2*(MH**2 + vep*complex(0,-1))))/(2.*MT**2)))/(128.*MW**2*cmath.pi**2*sw**2) - (3*ee**2*(MH**2 - 2*MT**2)*(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MT**2 + MT**2*vep*complex(0,4)))*reglog((MH**2 - 2*MT**2 + cmath.sqrt(MH**4 - 4*MH**2*MT**2 + MT**2*vep*complex(0,4)))/(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MT**2 + MT**2*vep*complex(0,4)))))/(256.*MT**2*MW**2*cmath.pi**2*sw**2) + (3*ee**2*(MH**2 - 2*MT**2)*(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MT**2 + MT**2*vep*complex(0,4)))*reglog((-MH**2 + 2*MT**2 + cmath.sqrt(MH**4 - 4*MH**2*MT**2 + MT**2*vep*complex(0,4)))/(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MT**2 + MT**2*vep*complex(0,4)))))/(256.*MT**2*MW**2*cmath.pi**2*sw**2))'+'+'+dMB_tWcft_UV_EW_L.value[0]},
                            texname = '\delta ZL_t^{EW}')


cWcft_UV_EW_L = CTParameter(name = 'cWcft_UV_EW_L',
                            type = 'complex',
                            value = {-1:'recms(CMSParam==1.0,-(ee**2*(18*cw**2 + (3 - 4*sw**2)**2))/(576.*cw**2*cmath.pi**2*sw**2))',
                                      0:'recms(CMSParam==1.0,-(ee**2*(-9 - 18*cw**2 + 24*sw**2 - 16*sw**4 + 36*cw**2*reglog(MU_R**2/MW**2) + 2*(3 - 4*sw**2)**2*reglog(MU_R**2/MZ**2)))/(1152.*cw**2*cmath.pi**2*sw**2))'},
                            texname = '\delta ZL_c^{EW}')


uWcft_UV_EW_L = CTParameter(name = 'uWcft_UV_EW_L',
                            type = 'complex',
                            value = {-1:'recms(CMSParam==1.0,-(ee**2*(18*cw**2 + (3 - 4*sw**2)**2))/(576.*cw**2*cmath.pi**2*sw**2))',
                                      0:'recms(CMSParam==1.0,-(ee**2*(-9 - 18*cw**2 + 24*sw**2 - 16*sw**4 + 36*cw**2*reglog(MU_R**2/MW**2) + 2*(3 - 4*sw**2)**2*reglog(MU_R**2/MZ**2)))/(1152.*cw**2*cmath.pi**2*sw**2))'},
                            texname = '\delta ZL_u^{EW}')



bWcft_UV_EW_L = CTParameter(name = 'bWcft_UV_EW_L',
                            type = 'complex',
                            value = {-1:'recms(CMSParam==1.0,-(ee**2*(MW**2*(18*cw**2 + (3 - 2*sw**2)**2) + 9*cw**2*MT**2*CKM33*complexconjugate(CKM33)))/(576.*cw**2*MW**2*cmath.pi**2*sw**2))'+'+'+dMB_bWcft_UV_EW_L.value[-1],
                                      0:'recms(CMSParam==1.0,-(ee**2*(-9*MT**2*MW**2 - 18*cw**2*MT**2*MW**2 + 9*MW**4 + 18*cw**2*MW**4 + 12*MT**2*MW**2*sw**2 - 12*MW**4*sw**2 - 4*MT**2*MW**2*sw**4 + 4*MW**4*sw**4 + 27*cw**2*MT**4*CKM33*complexconjugate(CKM33) + 27*cw**2*MT**2*MW**2*CKM33*complexconjugate(CKM33) + 9*MT**2*MW**2*reglog(16) + 18*cw**2*MT**2*MW**2*reglog(16) - 9*MW**4*reglog(16) - 18*cw**2*MW**4*reglog(16) - 12*MT**2*MW**2*sw**2*reglog(16) + 12*MW**4*sw**2*reglog(16) + 4*MT**2*MW**2*sw**4*reglog(16) - 4*MW**4*sw**4*reglog(16) + 9*cw**2*MT**4*CKM33*complexconjugate(CKM33)*reglog(16) - 9*cw**2*MT**2*MW**2*CKM33*complexconjugate(CKM33)*reglog(16) + 18*MT**2*MW**2*reglog(cmath.pi) + 36*cw**2*MT**2*MW**2*reglog(cmath.pi) - 18*MW**4*reglog(cmath.pi) - 36*cw**2*MW**4*reglog(cmath.pi) - 24*MT**2*MW**2*sw**2*reglog(cmath.pi) + 24*MW**4*sw**2*reglog(cmath.pi) + 8*MT**2*MW**2*sw**4*reglog(cmath.pi) - 8*MW**4*sw**4*reglog(cmath.pi) + 18*cw**2*MT**4*CKM33*complexconjugate(CKM33)*reglog(cmath.pi) - 18*cw**2*MT**2*MW**2*CKM33*complexconjugate(CKM33)*reglog(cmath.pi) - 18*MT**2*MW**2*reglog(4*cmath.pi) - 36*cw**2*MT**2*MW**2*reglog(4*cmath.pi) + 18*MW**4*reglog(4*cmath.pi) + 36*cw**2*MW**4*reglog(4*cmath.pi) + 24*MT**2*MW**2*sw**2*reglog(4*cmath.pi) - 24*MW**4*sw**2*reglog(4*cmath.pi) - 8*MT**2*MW**2*sw**4*reglog(4*cmath.pi) + 8*MW**4*sw**4*reglog(4*cmath.pi) - 18*cw**2*MT**4*CKM33*complexconjugate(CKM33)*reglog(4*cmath.pi) + 18*cw**2*MT**2*MW**2*CKM33*complexconjugate(CKM33)*reglog(4*cmath.pi)))/(1152.*cw**2*(MT - MW)*MW**2*(MT + MW)*cmath.pi**2*sw**2) - (ee**2*MT**4*(MT**2 + 2*MW**2)*CKM33*complexconjugate(CKM33)*reglog(MU_R**2/MT**2))/(64.*(MT - MW)**2*MW**2*(MT + MW)**2*cmath.pi**2*sw**2) + (ee**2*(-2*MT**4 + 4*MT**2*MW**2 - 2*MW**4 + 4*MT**4*CKM33*complexconjugate(CKM33) - MT**2*MW**2*CKM33*complexconjugate(CKM33))*reglog(MU_R**2/MW**2))/(64.*(MT - MW)**2*(MT + MW)**2*cmath.pi**2*sw**2) - (ee**2*(-3 + 2*sw**2)**2*reglog(MU_R**2/MZ**2))/(576.*cw**2*cmath.pi**2*sw**2))'+'+'+dMB_bWcft_UV_EW_L.value[0]},
                            texname = '\delta ZL_b^{EW}')


sWcft_UV_EW_L = CTParameter(name = 'sWcft_UV_EW_L',
                            type = 'complex',
                            value = {-1:'recms(CMSParam==1.0,-(ee**2*(MW**2*(18*cw**2 + (3 - 2*sw**2)**2) + 9*cw**2*MT**2*CKM32*complexconjugate(CKM32)))/(576.*cw**2*MW**2*cmath.pi**2*sw**2))',
                                      0:'recms(CMSParam==1.0,-(ee**2*(-9*MT**2*MW**2 - 18*cw**2*MT**2*MW**2 + 9*MW**4 + 18*cw**2*MW**4 + 12*MT**2*MW**2*sw**2 - 12*MW**4*sw**2 - 4*MT**2*MW**2*sw**4 + 4*MW**4*sw**4 + 27*cw**2*MT**4*CKM32*complexconjugate(CKM32) + 27*cw**2*MT**2*MW**2*CKM32*complexconjugate(CKM32) + 9*MT**2*MW**2*reglog(16) + 18*cw**2*MT**2*MW**2*reglog(16) - 9*MW**4*reglog(16) - 18*cw**2*MW**4*reglog(16) - 12*MT**2*MW**2*sw**2*reglog(16) + 12*MW**4*sw**2*reglog(16) + 4*MT**2*MW**2*sw**4*reglog(16) - 4*MW**4*sw**4*reglog(16) + 9*cw**2*MT**4*CKM32*complexconjugate(CKM32)*reglog(16) - 9*cw**2*MT**2*MW**2*CKM32*complexconjugate(CKM32)*reglog(16) + 18*MT**2*MW**2*reglog(cmath.pi) + 36*cw**2*MT**2*MW**2*reglog(cmath.pi) - 18*MW**4*reglog(cmath.pi) - 36*cw**2*MW**4*reglog(cmath.pi) - 24*MT**2*MW**2*sw**2*reglog(cmath.pi) + 24*MW**4*sw**2*reglog(cmath.pi) + 8*MT**2*MW**2*sw**4*reglog(cmath.pi) - 8*MW**4*sw**4*reglog(cmath.pi) + 18*cw**2*MT**4*CKM32*complexconjugate(CKM32)*reglog(cmath.pi) - 18*cw**2*MT**2*MW**2*CKM32*complexconjugate(CKM32)*reglog(cmath.pi) - 18*MT**2*MW**2*reglog(4*cmath.pi) - 36*cw**2*MT**2*MW**2*reglog(4*cmath.pi) + 18*MW**4*reglog(4*cmath.pi) + 36*cw**2*MW**4*reglog(4*cmath.pi) + 24*MT**2*MW**2*sw**2*reglog(4*cmath.pi) - 24*MW**4*sw**2*reglog(4*cmath.pi) - 8*MT**2*MW**2*sw**4*reglog(4*cmath.pi) + 8*MW**4*sw**4*reglog(4*cmath.pi) - 18*cw**2*MT**4*CKM32*complexconjugate(CKM32)*reglog(4*cmath.pi) + 18*cw**2*MT**2*MW**2*CKM32*complexconjugate(CKM32)*reglog(4*cmath.pi)))/(1152.*cw**2*(MT - MW)*MW**2*(MT + MW)*cmath.pi**2*sw**2) - (ee**2*MT**4*(MT**2 + 2*MW**2)*CKM32*complexconjugate(CKM32)*reglog(MU_R**2/MT**2))/(64.*(MT - MW)**2*MW**2*(MT + MW)**2*cmath.pi**2*sw**2) + (ee**2*(-2*MT**4 + 4*MT**2*MW**2 - 2*MW**4 + 4*MT**4*CKM32*complexconjugate(CKM32) - MT**2*MW**2*CKM32*complexconjugate(CKM32))*reglog(MU_R**2/MW**2))/(64.*(MT - MW)**2*(MT + MW)**2*cmath.pi**2*sw**2) - (ee**2*(-3 + 2*sw**2)**2*reglog(MU_R**2/MZ**2))/(576.*cw**2*cmath.pi**2*sw**2))'},
                            texname = '\delta ZL_s^{EW}')


dWcft_UV_EW_L = CTParameter(name = 'dWcft_UV_EW_L',
                            type = 'complex',
                            value = {-1:'recms(CMSParam==1.0,-(ee**2*(MW**2*(18*cw**2 + (3 - 2*sw**2)**2) + 9*cw**2*MT**2*CKM31*complexconjugate(CKM31)))/(576.*cw**2*MW**2*cmath.pi**2*sw**2))',
                                      0:'recms(CMSParam==1.0,-(ee**2*(-9*MT**2*MW**2 - 18*cw**2*MT**2*MW**2 + 9*MW**4 + 18*cw**2*MW**4 + 12*MT**2*MW**2*sw**2 - 12*MW**4*sw**2 - 4*MT**2*MW**2*sw**4 + 4*MW**4*sw**4 + 27*cw**2*MT**4*CKM31*complexconjugate(CKM31) + 27*cw**2*MT**2*MW**2*CKM31*complexconjugate(CKM31) + 9*MT**2*MW**2*reglog(16) + 18*cw**2*MT**2*MW**2*reglog(16) - 9*MW**4*reglog(16) - 18*cw**2*MW**4*reglog(16) - 12*MT**2*MW**2*sw**2*reglog(16) + 12*MW**4*sw**2*reglog(16) + 4*MT**2*MW**2*sw**4*reglog(16) - 4*MW**4*sw**4*reglog(16) + 9*cw**2*MT**4*CKM31*complexconjugate(CKM31)*reglog(16) - 9*cw**2*MT**2*MW**2*CKM31*complexconjugate(CKM31)*reglog(16) + 18*MT**2*MW**2*reglog(cmath.pi) + 36*cw**2*MT**2*MW**2*reglog(cmath.pi) - 18*MW**4*reglog(cmath.pi) - 36*cw**2*MW**4*reglog(cmath.pi) - 24*MT**2*MW**2*sw**2*reglog(cmath.pi) + 24*MW**4*sw**2*reglog(cmath.pi) + 8*MT**2*MW**2*sw**4*reglog(cmath.pi) - 8*MW**4*sw**4*reglog(cmath.pi) + 18*cw**2*MT**4*CKM31*complexconjugate(CKM31)*reglog(cmath.pi) - 18*cw**2*MT**2*MW**2*CKM31*complexconjugate(CKM31)*reglog(cmath.pi) - 18*MT**2*MW**2*reglog(4*cmath.pi) - 36*cw**2*MT**2*MW**2*reglog(4*cmath.pi) + 18*MW**4*reglog(4*cmath.pi) + 36*cw**2*MW**4*reglog(4*cmath.pi) + 24*MT**2*MW**2*sw**2*reglog(4*cmath.pi) - 24*MW**4*sw**2*reglog(4*cmath.pi) - 8*MT**2*MW**2*sw**4*reglog(4*cmath.pi) + 8*MW**4*sw**4*reglog(4*cmath.pi) - 18*cw**2*MT**4*CKM31*complexconjugate(CKM31)*reglog(4*cmath.pi) + 18*cw**2*MT**2*MW**2*CKM31*complexconjugate(CKM31)*reglog(4*cmath.pi)))/(1152.*cw**2*(MT - MW)*MW**2*(MT + MW)*cmath.pi**2*sw**2) - (ee**2*MT**4*(MT**2 + 2*MW**2)*CKM31*complexconjugate(CKM31)*reglog(MU_R**2/MT**2))/(64.*(MT - MW)**2*MW**2*(MT + MW)**2*cmath.pi**2*sw**2) + (ee**2*(-2*MT**4 + 4*MT**2*MW**2 - 2*MW**4 + 4*MT**4*CKM31*complexconjugate(CKM31) - MT**2*MW**2*CKM31*complexconjugate(CKM31))*reglog(MU_R**2/MW**2))/(64.*(MT - MW)**2*(MT + MW)**2*cmath.pi**2*sw**2) - (ee**2*(-3 + 2*sw**2)**2*reglog(MU_R**2/MZ**2))/(576.*cw**2*cmath.pi**2*sw**2))'},
                            texname = '\delta ZL_d^{EW}')


tauWcft_UV_EW_L = CTParameter(name = 'tauWcft_UV_EW_L',
                              type = 'complex',
                              value = {-1:'recms(CMSParam==1.0,-(ee**2*(2*cw**2 + (1 - 2*sw**2)**2))/(64.*cw**2*cmath.pi**2*sw**2))',
                                        0:'recms(CMSParam==1.0,-(ee**2*(-1 - 2*cw**2 + 4*sw**2 - 4*sw**4 + 4*cw**2*reglog(MU_R**2/MW**2) + 2*(1 - 2*sw**2)**2*reglog(MU_R**2/MZ**2)))/(128.*cw**2*cmath.pi**2*sw**2))'},
                              texname = '\delta ZL_tau^{EW}')


muWcft_UV_EW_L = CTParameter(name = 'muWcft_UV_EW_L',
                             type = 'complex',
                             value = {-1:'recms(CMSParam==1.0,-(ee**2*(2*cw**2 + (1 - 2*sw**2)**2))/(64.*cw**2*cmath.pi**2*sw**2))',
                                       0:'recms(CMSParam==1.0,-(ee**2*(-1 - 2*cw**2 + 4*sw**2 - 4*sw**4 + 4*cw**2*reglog(MU_R**2/MW**2) + 2*(1 - 2*sw**2)**2*reglog(MU_R**2/MZ**2)))/(128.*cw**2*cmath.pi**2*sw**2))'},
                             texname = '\delta ZL_mu^{EW}')


eWcft_UV_EW_L = CTParameter(name = 'eWcft_UV_EW_L',
                            type = 'complex',
                            value = {-1:'recms(CMSParam==1.0,-(ee**2*(2*cw**2 + (1 - 2*sw**2)**2))/(64.*cw**2*cmath.pi**2*sw**2))',
                                      0:'recms(CMSParam==1.0,-(ee**2*(-1 - 2*cw**2 + 4*sw**2 - 4*sw**4 + 4*cw**2*reglog(MU_R**2/MW**2) + 2*(1 - 2*sw**2)**2*reglog(MU_R**2/MZ**2)))/(128.*cw**2*cmath.pi**2*sw**2))'},
                            texname = '\delta ZL_e^{EW}')


vtWcft_UV_EW_L = CTParameter(name = 'vtWcft_UV_EW_L',
                             type = 'complex',
                             value = {-1:'recms(CMSParam==1.0,-((1 + 2*cw**2)*ee**2)/(64.*cw**2*cmath.pi**2*sw**2))',
                                       0:'recms(CMSParam==1.0,-(ee**2*(-1 - 2*cw**2 + 4*cw**2*reglog(MU_R**2/MW**2) + 2*reglog(MU_R**2/MZ**2)))/(128.*cw**2*cmath.pi**2*sw**2))'},
                             texname = '\delta ZL_vt^{EW}')


vmWcft_UV_EW_L = CTParameter(name = 'vmWcft_UV_EW_L',
                             type = 'complex',
                             value = {-1:'recms(CMSParam==1.0,-((1 + 2*cw**2)*ee**2)/(64.*cw**2*cmath.pi**2*sw**2))',
                                       0:'recms(CMSParam==1.0,-(ee**2*(-1 - 2*cw**2 + 4*cw**2*reglog(MU_R**2/MW**2) + 2*reglog(MU_R**2/MZ**2)))/(128.*cw**2*cmath.pi**2*sw**2))'},
                             texname = '\delta ZL_vm^{EW}')


veWcft_UV_EW_L = CTParameter(name = 'veWcft_UV_EW_L',
                             type = 'complex',
                             value = {-1:'recms(CMSParam==1.0,-((1 + 2*cw**2)*ee**2)/(64.*cw**2*cmath.pi**2*sw**2))',
                                       0:'recms(CMSParam==1.0,-(ee**2*(-1 - 2*cw**2 + 4*cw**2*reglog(MU_R**2/MW**2) + 2*reglog(MU_R**2/MZ**2)))/(128.*cw**2*cmath.pi**2*sw**2))'},
                             texname = '\delta ZL_ve^{EW}')

HWcft_UV_EW = CTParameter(name = 'HWcft_UV_EW',
                          type = 'complex',
                          value = {-1:'recms(CMSParam==1.0 and WH != 0,(ee**2*((1 + 2*cw**2)*MW**2 - cw**2*MT**2*Ncol))/(32.*cw**2*MW**2*cmath.pi**2*sw**2))'+'+'+dMB_HWcft_UV_EW.value[-1],
                          0:'recms(CMSParam==1.0 and WH != 0,-(ee**2*((1 + 2*cw**2)*MW**2 - cw**2*MT**2*Ncol)*reglog(4*cmath.pi))/(32.*cw**2*MW**2*cmath.pi**2*sw**2) + (ee**2*((4*(4*MW**4 + cw**4*(3*MH**4 + 6*MW**4 - 4*MT**4*Ncol + MH**2*(MW**2*(2 + reglog(16) + 2*reglog(cmath.pi)) + MT**2*Ncol*(-1 - reglog(4*cmath.pi)))) + cw**2*MW**2*(-MZ**2 + MH**2*(1 + reglog(4*cmath.pi)))))/(cw**4*MH**2*MW**2) - (6*MH**2*reglog(MU_R**2/MH**2))/MW**2 + (8*MT**4*Ncol*reglog(MU_R**2/MT**2))/(MH**2*MW**2) + (4*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*reglog(MU_R**2/MW**2))/(MH**4 - 4*MH**2*MW**2) + (2*MZ**2*(cw**4*MH**4 + 16*MW**4 - 4*cw**2*MW**2*(MH**2 + MZ**2))*reglog(MU_R**2/MZ**2))/(cw**4*MH**2*MW**2*(MH**2 - 4*MZ**2)) - (2*(16*MW**4*(-MH**2 + 4*MW**2)*MZ**2 + 2*cw**2*MW**2*(MH**2 - 4*MW**2)*(MH**4 - 2*MH**2*MZ**2 + 2*MZ**4) + cw**4*(3*MH**8 - MH**6*(10*MW**2 + 13*MZ**2 + 2*MT**2*Ncol) + 32*MW**2*MZ**2*(3*MW**4 - 2*MT**4*Ncol) - 8*MH**2*(3*MW**6 - 4*MW**4*MZ**2 - 2*MT**4*MZ**2*Ncol - 2*MT**2*MW**2*(MT**2 - 2*MZ**2)*Ncol) + MH**4*(-8*MW**4 - 4*MT**2*(MT**2 - 2*MZ**2)*Ncol + MW**2*(44*MZ**2 + 8*MT**2*Ncol))))*reglog((MH**2 + vep*complex(0,-1))/MU_R**2))/(cw**4*MH**2*(MH - 2*MW)*MW**2*(MH + 2*MW)*(MH - 2*MZ)*(MH + 2*MZ)) + (4*MT**2*(MH**2 + 2*MT**2)*Ncol*reglog((-MH**2 - cmath.sqrt(MH**2*(MH**2 - 4*MT**2 + vep*complex(0,4))))/(2.*MH**2)))/(MH**2*MW**2) + (4*MT**2*(MH**2 + 2*MT**2)*Ncol*reglog((-MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MT**2 + vep*complex(0,4))))/(2.*MH**2)))/(MH**2*MW**2) - (2*MT**2*(MH**2 + 2*MT**2)*Ncol*(MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MT**2 + vep*complex(0,4))))*reglog((-MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MT**2 + vep*complex(0,4))))/(MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MT**2 + vep*complex(0,4))))))/(MH**4*MW**2) - (2*MT**2*(MH**2 + 2*MT**2)*Ncol*(MH**2 - cmath.sqrt(MH**2*(MH**2 - 4*MT**2 + vep*complex(0,4))))*reglog((MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MT**2 + vep*complex(0,4))))/(-MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MT**2 + vep*complex(0,4))))))/(MH**4*MW**2) - (4*(MH**2 - 6*MW**2)*(MH**2 + 2*MW**2)*reglog((-MH**2 - cmath.sqrt(MH**2*(MH**2 - 4*MW**2 + vep*complex(0,4))))/(2.*MH**2)))/(MH**4 - 4*MH**2*MW**2) - (4*(MH**2 - 6*MW**2)*(MH**2 + 2*MW**2)*reglog((-MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MW**2 + vep*complex(0,4))))/(2.*MH**2)))/(MH**4 - 4*MH**2*MW**2) + (2*(MH**2 - 6*MW**2)*(MH**2 + 2*MW**2)*(MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MW**2 + vep*complex(0,4))))*reglog((-MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MW**2 + vep*complex(0,4))))/(MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MW**2 + vep*complex(0,4))))))/(MH**6 - 4*MH**4*MW**2) + (2*(MH**2 - 6*MW**2)*(MH**2 + 2*MW**2)*(MH**2 - cmath.sqrt(MH**2*(MH**2 - 4*MW**2 + vep*complex(0,4))))*reglog((MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MW**2 + vep*complex(0,4))))/(-MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MW**2 + vep*complex(0,4))))))/(MH**6 - 4*MH**4*MW**2) + (2*(cw**4*MH**4*MZ**2 + 16*MW**4*MZ**2 - 2*cw**2*MW**2*(MH**4 - 2*MH**2*MZ**2 + 2*MZ**4))*reglog((-MH**2 - cmath.sqrt(MH**2*(MH**2 - 4*MZ**2 + vep*complex(0,4))))/(2.*MH**2)))/(cw**4*MH**2*MW**2*(MH**2 - 4*MZ**2)) + (2*(cw**4*MH**4*MZ**2 + 16*MW**4*MZ**2 - 2*cw**2*MW**2*(MH**4 - 2*MH**2*MZ**2 + 2*MZ**4))*reglog((-MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MZ**2 + vep*complex(0,4))))/(2.*MH**2)))/(cw**4*MH**2*MW**2*(MH**2 - 4*MZ**2)) - ((cw**4*MH**4*MZ**2 + 16*MW**4*MZ**2 - 2*cw**2*MW**2*(MH**4 - 2*MH**2*MZ**2 + 2*MZ**4))*(MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MZ**2 + vep*complex(0,4))))*reglog((-MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MZ**2 + vep*complex(0,4))))/(MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MZ**2 + vep*complex(0,4))))))/(cw**4*MH**4*MW**2*(MH**2 - 4*MZ**2)) + ((cw**4*MH**4*MZ**2 + 16*MW**4*MZ**2 - 2*cw**2*MW**2*(MH**4 - 2*MH**2*MZ**2 + 2*MZ**4))*(-MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MZ**2 + vep*complex(0,4))))*reglog((MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MZ**2 + vep*complex(0,4))))/(-MH**2 + cmath.sqrt(MH**2*(MH**2 - 4*MZ**2 + vep*complex(0,4))))))/(cw**4*MH**4*MW**2*(MH**2 - 4*MZ**2)) + (3*(MH**2 + cmath.sqrt(-3*MH**4 + MH**2*vep*complex(0,4)))*reglog((-MH**2 + cmath.sqrt(-3*MH**4 + MH**2*vep*complex(0,4)))/(MH**2 + cmath.sqrt(-3*MH**4 + MH**2*vep*complex(0,4)))))/MW**2 - (3*(-MH**2 + cmath.sqrt(-3*MH**4 + MH**2*vep*complex(0,4)))*reglog((MH**2 + cmath.sqrt(-3*MH**4 + MH**2*vep*complex(0,4)))/(-MH**2 + cmath.sqrt(-3*MH**4 + MH**2*vep*complex(0,4)))))/MW**2 - (6*MH**2*reglog(-0.5 - cmath.sqrt(-3*MH**4 + MH**2*vep*complex(0,4))/(2.*MH**2)))/MW**2 - (6*MH**2*reglog(-0.5 + cmath.sqrt(-3*MH**4 + MH**2*vep*complex(0,4))/(2.*MH**2)))/MW**2))/(128.*cmath.pi**2*sw**2))'+'+'+dMB_HWcft_UV_EW.value[0]},
                          texname = '\delta Z_{H}^{EW}')

G0Wcft_UV_EW = CTParameter(name = 'G0Wcft_UV_EW',
                           type = 'complex',
                           value = {-1:'recms(CMSParam==1.0 and WZ != 0,(ee**2*((1 + 2*cw**2)*MW**2 - cw**2*MT**2*Ncol))/(32.*cw**2*MW**2*cmath.pi**2*sw**2))'+'+'+dMB_G0Wcft_UV_EW.value[-1],
                           0:'recms(CMSParam==1.0 and WZ != 0,-(ee**2*((1 + 2*cw**2)*MW**2 - cw**2*MT**2*Ncol)*reglog(4*cmath.pi))/(32.*cw**2*MW**2*cmath.pi**2*sw**2) + (ee**2*((2*(MW**2*(-2*MH**2 + MZ**2*(3 + reglog(16) + 2*reglog(cmath.pi))) + cw**2*(MH**4 + MZ**2*(MT**2*Ncol*(-2 - reglog(16) - 2*reglog(cmath.pi)) + MW**2*(4 + reglog(256) + 4*reglog(cmath.pi))))))/(cw**2*MW**2*MZ**2) - (2*(MH**2 - 2*MZ**2)*(cw**2*MH**4 - MW**2*(2*MH**2 + MZ**2))*reglog(MU_R**2/MH**2))/(cw**2*MW**2*MZ**2*(MH**2 - 4*MZ**2)) - (8*MT**4*Ncol*reglog(MU_R**2/MT**2))/(MW**2*(4*MT**2 - MZ**2)) + (16*MW**2*reglog(MU_R**2/MW**2))/(4*MW**2 - MZ**2) + (2*(cw**2*MH**4 - MW**2*(2*MH**2 + MZ**2))*reglog(MU_R**2/MZ**2))/(cw**2*MW**2*(MH**2 - 4*MZ**2)) - (2*(MW**2*(4*MT**2 - MZ**2)*(-4*MW**2 + MZ**2)*(2*MH**4 - 7*MH**2*MZ**2 + 5*MZ**4) + cw**2*(-(MH**6*(4*MT**2 - MZ**2)*(-4*MW**2 + MZ**2)) - 3*MH**4*MZ**2*(-4*MT**2 + MZ**2)*(-4*MW**2 + MZ**2) - 2*MH**2*MZ**2*(4*MW**4*MZ**2 - 2*MW**2*MZ**4 + MT**4*(8*MW**2*Ncol - 2*MZ**2*Ncol) + MT**2*(-16*MW**4 - 4*MW**2*MZ**2*(-2 + Ncol) + MZ**4*Ncol)) + 8*MZ**4*(4*MW**4*MZ**2 - 2*MW**2*MZ**4 + MT**4*(8*MW**2*Ncol - 2*MZ**2*Ncol) + MT**2*(-16*MW**4 - 4*MW**2*MZ**2*(-2 + Ncol) + MZ**4*Ncol))))*reglog((MZ**2 + vep*complex(0,-1))/MU_R**2))/(cw**2*MW**2*(2*MW - MZ)*MZ**2*(-2*MT + MZ)*(2*MT + MZ)*(2*MW + MZ)*(-MH + 2*MZ)*(MH + 2*MZ)) + (2*(cw**2*(MH**6 - 3*MH**4*MZ**2) + MW**2*(-2*MH**4 + 7*MH**2*MZ**2 - 5*MZ**4))*reglog(-1 + (MH**2 - cmath.sqrt(MH**4 - 4*MZ**2*(MH**2 + vep*complex(0,-1))))/(2.*MZ**2)))/(cw**2*MW**2*MZ**2*(-MH**2 + 4*MZ**2)) + (2*(cw**2*(MH**6 - 3*MH**4*MZ**2) + MW**2*(-2*MH**4 + 7*MH**2*MZ**2 - 5*MZ**4))*reglog(-1 + (MH**2 + cmath.sqrt(MH**4 - 4*MZ**2*(MH**2 + vep*complex(0,-1))))/(2.*MZ**2)))/(cw**2*MW**2*MZ**2*(-MH**2 + 4*MZ**2)) + (4*MT**2*(2*MT**2 - MZ**2)*Ncol*reglog((-MZ**2 - cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)))/(MW**2*(4*MT**2 - MZ**2)) + (4*MT**2*(2*MT**2 - MZ**2)*Ncol*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)))/(MW**2*(4*MT**2 - MZ**2)) + (2*MT**2*(2*MT**2 - MZ**2)*Ncol*(MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))))/(MW**2*MZ**2*(-4*MT**2 + MZ**2)) + (2*MT**2*(2*MT**2 - MZ**2)*Ncol*(MZ**2 - cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))*reglog((MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(-MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))))/(MW**2*MZ**2*(-4*MT**2 + MZ**2)) - (8*(2*MW**2 - MZ**2)*reglog((-MZ**2 - cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)))/(4*MW**2 - MZ**2) - (8*(2*MW**2 - MZ**2)*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)))/(4*MW**2 - MZ**2) + (4*(-2*MW**2 + MZ**2)*(MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))))/(-4*MW**2*MZ**2 + MZ**4) + (4*(-2*MW**2 + MZ**2)*(MZ**2 - cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))*reglog((MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(-MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))))/(-4*MW**2*MZ**2 + MZ**4) + ((cw**2*(MH**6 - 3*MH**4*MZ**2) + MW**2*(-2*MH**4 + 7*MH**2*MZ**2 - 5*MZ**4))*(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))*reglog((MH**2 - 2*MZ**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))/(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))))/(cw**2*MW**2*MZ**4*(MH**2 - 4*MZ**2)) - ((cw**2*(MH**6 - 3*MH**4*MZ**2) + MW**2*(-2*MH**4 + 7*MH**2*MZ**2 - 5*MZ**4))*(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))*reglog((-MH**2 + 2*MZ**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))/(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))))/(cw**2*MW**2*MZ**4*(MH**2 - 4*MZ**2))))/(128.*cmath.pi**2*sw**2))'+'+'+dMB_G0Wcft_UV_EW.value[0]},
                           texname = '\delta Z_{G0}^{EW}')

GpWcft_UV_EW = CTParameter(name = 'GpWcft_UV_EW',
                           type = 'complex',
                           value = {-1:'recms(CMSParam==1.0 and WW != 0,(ee**2*(cw**4*MW**2 + MW**2*sw**4 + cw**2*(-(MT**2*Ncol) + 2*MW**2*(1 + sw**2))))/(32.*cw**2*MW**2*cmath.pi**2*sw**2))'+'+'+dMB_GpWcft_UV_EW.value[-1],
                           0:'recms(CMSParam==1.0 and WW != 0,-(ee**2*(cw**4*MW**2 + MW**2*sw**4 + cw**2*(-(MT**2*Ncol) + 2*MW**2*(1 + sw**2)))*reglog(4*cmath.pi))/(32.*cw**2*MW**2*cmath.pi**2*sw**2) + (ee**2*((2*MW**2*(2*cw**3*MW**3*MZ - 2*cw*MW**3*MZ*sw**2 + cw**4*MW**2*(MZ**2 + MW**2*(reglog(16) + 2*reglog(cmath.pi))) + MW**2*sw**4*(MZ**2 + MW**2*(16 + reglog(16) + 2*reglog(cmath.pi))) + cw**2*(MH**4 - 2*MH**2*MW**2 - 2*MT**4*Ncol - MW**2*(2*MZ**2*(1 + sw**2) + MT**2*Ncol*(2 + reglog(16) + 2*reglog(cmath.pi))) + MW**4*(6 + reglog(256) + 4*reglog(cmath.pi) + sw**2*(12 + reglog(256) + 4*reglog(cmath.pi))))))/cw**2 - (2*MW**2*(MH**2 - 2*MW**2)*(MH**4 - 2*MH**2*MW**2 - MW**4)*reglog(MU_R**2/MH**2))/(MH**2 - 4*MW**2) - 4*MT**2*MW**4*Ncol*reglog(MU_R**2/MT**2) - (2*MW**4*(2*cw**3*MW**3*(MH**2 - 4*MW**2)*MZ + cw**4*MW**2*(-MH**2 + 4*MW**2)*(4*MW**2 - MZ**2) + 2*cw*MW**3*(-MH**2 + 4*MW**2)*MZ*sw**2 + MW**2*(MH**2 - 4*MW**2)*(12*MW**2 + MZ**2)*sw**4 + cw**2*(MH**4*(-4*MW**2 + MZ**2) + MH**2*MW**2*(MW**2*(7 - 24*sw**2) + 2*MZ**2*(-2 + 3*sw**2)) + MW**4*(MZ**2*(7 - 24*sw**2) + MW**2*(8 + 96*sw**2))))*reglog(MU_R**2/MW**2))/(cw**2*(MH - 2*MW)*(MH + 2*MW)*(2*MW - MZ)*(2*MW + MZ)) + (2*MW**4*(2*MW**2 - MZ**2)*(-2*cw**3*MW*MZ + cw**4*(4*MW**2 - MZ**2) + 2*cw*MW*MZ*sw**2 - (12*MW**2 + MZ**2)*sw**4 + cw**2*(MW**2*(1 - 8*sw**2) + 2*MZ**2*(1 + sw**2)))*reglog(MU_R**2/MZ**2))/(cw**2*(4*MW**2 - MZ**2)) - 4*MT**2*(MT - MW)*(MT + MW)*(MT**2 + MW**2)*Ncol*reglog((MT**2 - MW**2 + vep*complex(0,-1))/MT**2) + (2*MW**2*(-2*cw**3*MW**3*(MH**2 - 4*MW**2)*(3*MW**2*MZ - MZ**3) + cw**4*MW**2*(MH**2 - 4*MW**2)*(4*MW**4 - 5*MW**2*MZ**2 + MZ**4) + 2*cw*MW**3*(MH**2 - 4*MW**2)*MZ*(3*MW**2 - MZ**2)*sw**2 + MW**2*(-MH**2 + 4*MW**2)*(44*MW**4 - 11*MW**2*MZ**2 - MZ**4)*sw**4 + cw**2*(MH**6*(-4*MW**2 + MZ**2) + 5*MH**4*(4*MW**4 - MW**2*MZ**2) - MH**2*MW**2*(2*MZ**4*(1 + sw**2) - 2*MW**2*MZ**2*(7 + 5*sw**2) + MW**4*(33 + 8*sw**2)) + MW**4*(8*MZ**4*(1 + sw**2) + 8*MW**4*(5 + 4*sw**2) - MW**2*MZ**2*(33 + 40*sw**2))))*reglog((MW**2 + vep*complex(0,-1))/MU_R**2))/(cw**2*(MH - 2*MW)*(MH + 2*MW)*(2*MW - MZ)*(2*MW + MZ)) + (2*MW**4*(cw**3*(-6*MW**3*MZ + 2*MW*MZ**3) + cw**4*(4*MW**4 - 5*MW**2*MZ**2 + MZ**4) + 2*cw*MW*MZ*(3*MW**2 - MZ**2)*sw**2 + (-44*MW**4 + 11*MW**2*MZ**2 + MZ**4)*sw**4 - cw**2*(MW**2 - MZ**2)*(-2*MZ**2*(1 + sw**2) + MW**2*(5 + 8*sw**2)))*reglog((-MZ**2 - cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(2.*MW**2)))/(cw**2*(4*MW**2 - MZ**2)) + (2*MW**4*(cw**3*(-6*MW**3*MZ + 2*MW*MZ**3) + cw**4*(4*MW**4 - 5*MW**2*MZ**2 + MZ**4) + 2*cw*MW*MZ*(3*MW**2 - MZ**2)*sw**2 + (-44*MW**4 + 11*MW**2*MZ**2 + MZ**4)*sw**4 - cw**2*(MW**2 - MZ**2)*(-2*MZ**2*(1 + sw**2) + MW**2*(5 + 8*sw**2)))*reglog((-MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(2.*MW**2)))/(cw**2*(4*MW**2 - MZ**2)) - (MW**2*(cw**3*(-6*MW**3*MZ + 2*MW*MZ**3) + cw**4*(4*MW**4 - 5*MW**2*MZ**2 + MZ**4) + 2*cw*MW*MZ*(3*MW**2 - MZ**2)*sw**2 + (-44*MW**4 + 11*MW**2*MZ**2 + MZ**4)*sw**4 - cw**2*(MW**2 - MZ**2)*(-2*MZ**2*(1 + sw**2) + MW**2*(5 + 8*sw**2)))*(2*MW**2 - MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))*reglog((-MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(2*MW**2 - MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))))/(cw**2*(4*MW**2 - MZ**2)) - (MW**2*(cw**3*(-6*MW**3*MZ + 2*MW*MZ**3) + cw**4*(4*MW**4 - 5*MW**2*MZ**2 + MZ**4) + 2*cw*MW*MZ*(3*MW**2 - MZ**2)*sw**2 + (-44*MW**4 + 11*MW**2*MZ**2 + MZ**4)*sw**4 - cw**2*(MW**2 - MZ**2)*(-2*MZ**2*(1 + sw**2) + MW**2*(5 + 8*sw**2)))*(2*MW**2 - MZ**2 - cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))*reglog((MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(-2*MW**2 + MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))))/(cw**2*(4*MW**2 - MZ**2)) - (2*MW**2*(-MH**6 + 5*MH**4*MW**2 - 7*MH**2*MW**4 + 5*MW**6)*reglog(-1 + (MH**2 - cmath.sqrt(MH**4 - 4*MW**2*(MH**2 + vep*complex(0,-1))))/(2.*MW**2)))/(-MH**2 + 4*MW**2) - (2*MW**2*(-MH**6 + 5*MH**4*MW**2 - 7*MH**2*MW**4 + 5*MW**6)*reglog(-1 + (MH**2 + cmath.sqrt(MH**4 - 4*MW**2*(MH**2 + vep*complex(0,-1))))/(2.*MW**2)))/(-MH**2 + 4*MW**2) + ((MH**6 - 5*MH**4*MW**2 + 7*MH**2*MW**4 - 5*MW**6)*(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))*reglog((MH**2 - 2*MW**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))/(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))))/(MH**2 - 4*MW**2) - ((MH**6 - 5*MH**4*MW**2 + 7*MH**2*MW**4 - 5*MW**6)*(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))*reglog((-MH**2 + 2*MW**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))/(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))))/(MH**2 - 4*MW**2)))/(128.*MW**6*cmath.pi**2*sw**2))'+'+'+dMB_GpWcft_UV_EW.value[0]},
                           texname = '\delta Z_{Gp}^{EW}')


WWcft_UV_EW = CTParameter(name = 'WWcft_UV_EW',
                          type = 'complex',
                          value = {-1:'recms(CMSParam==1.0 and WW != 0,(ee**2*(-7 + 20*cw**2 - 6*Ncol + 8*sw**2))/(96.*cmath.pi**2*sw**2))',
                          0:'recms(CMSParam==1.0 and WW != 0,-(ee**2*(-7 + 20*cw**2 - 6*Ncol + 8*sw**2)*reglog(4*cmath.pi))/(96.*cmath.pi**2*sw**2) + (ee**2*((-4*(-18*MW**4*sw**4 + 2*cw**4*(45*MW**2*MZ**2 - 12*MZ**4 + MW**4*(-23 + 30*reglog(cmath.pi) - 60*reglog(2*cmath.pi))) + cw**2*(-3*MH**4 + 9*MH**2*MW**2 - 3*MZ**4 + 6*MT**4*Ncol + 3*MW**2*(3*MZ**2 + MT**2*Ncol) + MW**4*(-1 - 64*sw**2 - 21*reglog(cmath.pi) + 24*sw**2*reglog(cmath.pi) + 6*Ncol*(2 + reglog(64) + 3*reglog(cmath.pi)) + 42*reglog(2*cmath.pi) - 48*sw**2*reglog(2*cmath.pi)))))/(cw**2*MW**4) - (6*(2*MH**6 - 11*MH**4*MW**2 + 24*MH**2*MW**4 - 24*MW**6)*reglog(MU_R**2/MH**2))/(MW**4*(MH**2 - 4*MW**2)) - 24*Ncol*reglog(MU_R**2/MT**2) + (12*(2*cw**4*(MH**2 - 4*MW**2)*(7*MW**4 + 21*MW**2*MZ**2 - 4*MZ**4) + 6*MW**4*(-MH**2 + 4*MW**2)*sw**4 + cw**2*(4*MW**2 - MZ**2)*(MH**4 - 4*MW**2*MZ**2 + MW**4*(10 - 32*sw**2) + MH**2*(MZ**2 + MW**2*(-5 + 8*sw**2))))*reglog(MU_R**2/MW**2))/(cw**2*(MH - 2*MW)*MW**2*(MH + 2*MW)*(2*MW - MZ)*(2*MW + MZ)) + (6*(cw**2*(12*MW**4*MZ**2 - 11*MW**2*MZ**4 + 2*MZ**6) + 4*cw**4*(30*MW**6 + 15*MW**4*MZ**2 - 25*MW**2*MZ**4 + 4*MZ**6) + 12*MW**4*(-2*MW**2 + MZ**2)*sw**4)*reglog(MU_R**2/MZ**2))/(cw**2*MW**4*(4*MW**2 - MZ**2)) + (24*(-MT + MW)*(MT + MW)*(MT**2 - MT*MW + MW**2)*(MT**2 + MT*MW + MW**2)*Ncol*reglog((MT**2 - MW**2 + vep*complex(0,-1))/MT**2))/MW**6 - (6*(4*cw**4*(MH**2 - 4*MW**2)*(3*MW**6 - 46*MW**4*MZ**2 + 29*MW**2*MZ**4 - 4*MZ**6) + cw**2*(4*MW**2 - MZ**2)*(2*MH**6 - 13*MH**4*MW**2 - 4*MW**2*(9*MW**4 - 5*MW**2*MZ**2 + 2*MZ**4) + MH**2*(32*MW**4 - 5*MW**2*MZ**2 + 2*MZ**4)) + 12*MW**4*(MH**2 - 4*MW**2)*(3*MW**2 - MZ**2)*sw**4)*reglog((MW**2 + vep*complex(0,-1))/MU_R**2))/(cw**2*(MH - 2*MW)*MW**4*(MH + 2*MW)*(2*MW - MZ)*(2*MW + MZ)) - (6*(4*cw**4*(3*MW**6 - 46*MW**4*MZ**2 + 29*MW**2*MZ**4 - 4*MZ**6) + cw**2*(-20*MW**4*MZ**2 + 13*MW**2*MZ**4 - 2*MZ**6) + 12*MW**4*(3*MW**2 - MZ**2)*sw**4)*reglog((-MZ**2 - cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(2.*MW**2)))/(cw**2*MW**4*(4*MW**2 - MZ**2)) - (6*(4*cw**4*(3*MW**6 - 46*MW**4*MZ**2 + 29*MW**2*MZ**4 - 4*MZ**6) + cw**2*(-20*MW**4*MZ**2 + 13*MW**2*MZ**4 - 2*MZ**6) + 12*MW**4*(3*MW**2 - MZ**2)*sw**4)*reglog((-MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(2.*MW**2)))/(cw**2*MW**4*(4*MW**2 - MZ**2)) + (3*(4*cw**4*(3*MW**6 - 46*MW**4*MZ**2 + 29*MW**2*MZ**4 - 4*MZ**6) + cw**2*(-20*MW**4*MZ**2 + 13*MW**2*MZ**4 - 2*MZ**6) + 12*MW**4*(3*MW**2 - MZ**2)*sw**4)*(2*MW**2 - MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))*reglog((-MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(2*MW**2 - MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))))/(cw**2*MW**6*(4*MW**2 - MZ**2)) - (3*(4*cw**4*(3*MW**6 - 46*MW**4*MZ**2 + 29*MW**2*MZ**4 - 4*MZ**6) + cw**2*(-20*MW**4*MZ**2 + 13*MW**2*MZ**4 - 2*MZ**6) + 12*MW**4*(3*MW**2 - MZ**2)*sw**4)*(-2*MW**2 + MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))*reglog((MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(-2*MW**2 + MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))))/(cw**2*MW**6*(4*MW**2 - MZ**2)) - (6*(2*MH**6 - 13*MH**4*MW**2 + 32*MH**2*MW**4 - 36*MW**6)*reglog(-1 + (MH**2 - cmath.sqrt(MH**4 - 4*MW**2*(MH**2 + vep*complex(0,-1))))/(2.*MW**2)))/(MW**4*(MH**2 - 4*MW**2)) - (6*(2*MH**6 - 13*MH**4*MW**2 + 32*MH**2*MW**4 - 36*MW**6)*reglog(-1 + (MH**2 + cmath.sqrt(MH**4 - 4*MW**2*(MH**2 + vep*complex(0,-1))))/(2.*MW**2)))/(MW**4*(MH**2 - 4*MW**2)) - 24*(3 + 2*Ncol)*reglogp(-(MU_R**2/(MW**2 + vep*complex(0,1)))) + (3*(2*MH**6 - 13*MH**4*MW**2 + 32*MH**2*MW**4 - 36*MW**6)*(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))*reglog((MH**2 - 2*MW**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))/(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))))/(MW**6*(MH**2 - 4*MW**2)) - (3*(2*MH**6 - 13*MH**4*MW**2 + 32*MH**2*MW**4 - 36*MW**6)*(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))*reglog((-MH**2 + 2*MW**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))/(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))))/(MW**6*(MH**2 - 4*MW**2))))/(1152.*cmath.pi**2*sw**2))'+'+'+dMB_WWcft_UV_EW.value[0]},
                          texname = '\delta Z_{W}^{EW}')


ZZWcft_UV_EW = CTParameter(name = 'ZZWcft_UV_EW',
                           type = 'complex',
                           value = {-1:'recms(CMSParam==1.0 and WZ != 0,(ee**2*(-39 + 117*cw**4 + 72*sw**2 + 6*cw**2*sw**2 - 147*sw**4 - 4*Ncol*(9 - 18*sw**2 + 20*sw**4)))/(576.*cw**2*cmath.pi**2*sw**2))',
                           0:'recms(CMSParam==1.0 and WZ != 0,-(ee**2*(-39 + 117*cw**4 + 72*sw**2 + 6*cw**2*sw**2 - 147*sw**4 - 4*Ncol*(9 - 18*sw**2 + 20*sw**4))*reglog(4*cmath.pi))/(576.*cw**2*cmath.pi**2*sw**2) + (ee**2*((-2*(-108*MW**2*MZ**2 - 6*cw**4*MZ**2*sw**2*(12*MW**2 + MZ**2*(5 + reglog(64) + 3*reglog(cmath.pi))) + 9*cw**6*(60*MW**2*MZ**2 + MZ**4*(-41 + 39*reglog(cmath.pi) - 78*reglog(2*cmath.pi))) + cw**2*(-18*MH**4 + 54*MH**2*MZ**2 + MZ**2*(2*(-90*MW**2*sw**4 + MT**2*Ncol*(9 + 48*sw**2 - 64*sw**4)) + MZ**2*(4*Ncol*(9 - 18*sw**2 + 20*sw**4)*(2 + reglog(64) + 3*reglog(cmath.pi)) + 3*(29 - 39*reglog(cmath.pi) - 24*sw**2*(2 + reglog(64) + 3*reglog(cmath.pi)) + 78*reglog(2*cmath.pi) + sw**4*(101 - 147*reglog(cmath.pi) + 294*reglog(2*cmath.pi))))))))/MZ**4 - (18*(12*MW**2*MZ**2*(MH**2 - 2*MZ**2) + cw**2*(2*MH**6 - 11*MH**4*MZ**2 + 12*MH**2*MZ**4))*reglog(MU_R**2/MH**2))/(MZ**4*(MH**2 - 4*MZ**2)) - (8*cw**2*MT**2*Ncol*(MZ**2*(9 - 24*sw**2 + 32*sw**4) + MT**2*(-9 - 48*sw**2 + 64*sw**4))*reglog(MU_R**2/MT**2))/(4*MT**2*MZ**2 - MZ**4) + (36*cw**2*MW**2*(cw**4*(60*MW**2 + 39*MZ**2) + 2*cw**2*(-4*MW**2 + MZ**2)*sw**2 - (20*MW**2 + MZ**2)*sw**4)*reglog(MU_R**2/MW**2))/(4*MW**2*MZ**2 - MZ**4) + (18*(12*MW**2*MZ**2 + cw**2*(2*MH**4 - 9*MH**2*MZ**2 + 4*MZ**4))*reglog(MU_R**2/MZ**2))/(MZ**2*(MH**2 - 4*MZ**2)) + (2*(-108*MW**2*MZ**2*(MH**2 - 3*MZ**2)*(-4*MT**2 + MZ**2)*(-4*MW**2 + MZ**2) + 27*cw**6*MZ**2*(-4*MT**2 + MZ**2)*(-MH**2 + 4*MZ**2)*(40*MW**4 - 26*MW**2*MZ**2 + 13*MZ**4) - 18*cw**4*MZ**2*(MH**2 - 4*MZ**2)*(-4*MT**2 + MZ**2)*(-8*MW**4 - 2*MW**2*MZ**2 + MZ**4)*sw**2 - cw**2*(MH**2 - 4*MZ**2)*(-18*MH**4*(4*MT**2 - MZ**2)*(-4*MW**2 + MZ**2) - 45*MH**2*MZ**2*(-4*MT**2 + MZ**2)*(-4*MW**2 + MZ**2) + MZ**2*(-360*MW**4*MZ**2*sw**4 + 4*MT**4*(4*MW**2 - MZ**2)*Ncol*(-9 - 48*sw**2 + 64*sw**4) - MZ**6*(9*sw**4 + 2*Ncol*(9 - 24*sw**2 + 32*sw**4)) + 2*MW**2*MZ**4*(9*sw**4 + 4*Ncol*(9 - 24*sw**2 + 32*sw**4)) + 4*MT**2*(360*MW**4*sw**4 + MZ**4*(9*sw**4 + Ncol*(9 - 24*sw**2 + 32*sw**4)) - 2*MW**2*MZ**2*(9*sw**4 + 2*Ncol*(9 - 24*sw**2 + 32*sw**4))))))*reglog((MZ**2 + vep*complex(0,-1))/MU_R**2))/((MH - 2*MZ)*MZ**4*(-2*MT + MZ)*(2*MT + MZ)*(-2*MW + MZ)*(2*MW + MZ)*(MH + 2*MZ)) - (18*(12*MW**2*MZ**2*(MH**2 - 3*MZ**2) + cw**2*(2*MH**6 - 13*MH**4*MZ**2 + 20*MH**2*MZ**4))*reglog(-1 + (MH**2 - cmath.sqrt(MH**4 - 4*MZ**2*(MH**2 + vep*complex(0,-1))))/(2.*MZ**2)))/(MZ**4*(MH**2 - 4*MZ**2)) - (18*(12*MW**2*MZ**2*(MH**2 - 3*MZ**2) + cw**2*(2*MH**6 - 13*MH**4*MZ**2 + 20*MH**2*MZ**4))*reglog(-1 + (MH**2 + cmath.sqrt(MH**4 - 4*MZ**2*(MH**2 + vep*complex(0,-1))))/(2.*MZ**2)))/(MZ**4*(MH**2 - 4*MZ**2)) - 4*cw**2*(54*(1 - 2*sw**2 + 4*sw**4) + Ncol*(45 - 84*sw**2 + 88*sw**4))*reglogp(-(MU_R**2/(MZ**2 + vep*complex(0,1)))) - (4*cw**2*Ncol*(-2*MT**2*MZ**2*(9 - 24*sw**2 + 32*sw**4) + MZ**4*(9 - 24*sw**2 + 32*sw**4) + 2*MT**4*(-9 - 48*sw**2 + 64*sw**4))*reglog((-MZ**2 - cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)))/(4*MT**2*MZ**2 - MZ**4) - (4*cw**2*Ncol*(-2*MT**2*MZ**2*(9 - 24*sw**2 + 32*sw**4) + MZ**4*(9 - 24*sw**2 + 32*sw**4) + 2*MT**4*(-9 - 48*sw**2 + 64*sw**4))*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)))/(4*MT**2*MZ**2 - MZ**4) + (2*cw**2*Ncol*(-2*MT**2*MZ**2*(9 - 24*sw**2 + 32*sw**4) + MZ**4*(9 - 24*sw**2 + 32*sw**4) + 2*MT**4*(-9 - 48*sw**2 + 64*sw**4))*(MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))))/(4*MT**2*MZ**4 - MZ**6) + (2*cw**2*Ncol*(-2*MT**2*MZ**2*(9 - 24*sw**2 + 32*sw**4) + MZ**4*(9 - 24*sw**2 + 32*sw**4) + 2*MT**4*(-9 - 48*sw**2 + 64*sw**4))*(MZ**2 - cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))*reglog((MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(-MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))))/(4*MT**2*MZ**4 - MZ**6) + (18*cw**2*(3*cw**4*(40*MW**4 - 26*MW**2*MZ**2 + 13*MZ**4) - 2*cw**2*(8*MW**4 + 2*MW**2*MZ**2 - MZ**4)*sw**2 - (40*MW**4 - 2*MW**2*MZ**2 + MZ**4)*sw**4)*reglog((-MZ**2 - cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)))/(4*MW**2*MZ**2 - MZ**4) + (18*cw**2*(3*cw**4*(40*MW**4 - 26*MW**2*MZ**2 + 13*MZ**4) - 2*cw**2*(8*MW**4 + 2*MW**2*MZ**2 - MZ**4)*sw**2 - (40*MW**4 - 2*MW**2*MZ**2 + MZ**4)*sw**4)*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)))/(4*MW**2*MZ**2 - MZ**4) - (9*cw**2*(3*cw**4*(40*MW**4 - 26*MW**2*MZ**2 + 13*MZ**4) - 2*cw**2*(8*MW**4 + 2*MW**2*MZ**2 - MZ**4)*sw**2 - (40*MW**4 - 2*MW**2*MZ**2 + MZ**4)*sw**4)*(MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))))/(4*MW**2*MZ**4 - MZ**6) + (9*cw**2*(3*cw**4*(40*MW**4 - 26*MW**2*MZ**2 + 13*MZ**4) - 2*cw**2*(8*MW**4 + 2*MW**2*MZ**2 - MZ**4)*sw**2 - (40*MW**4 - 2*MW**2*MZ**2 + MZ**4)*sw**4)*(-MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))*reglog((MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(-MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))))/(4*MW**2*MZ**4 - MZ**6) + (9*(12*MW**2*MZ**2*(MH**2 - 3*MZ**2) + cw**2*(2*MH**6 - 13*MH**4*MZ**2 + 20*MH**2*MZ**4))*(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))*reglog((MH**2 - 2*MZ**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))/(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))))/(MZ**6*(MH**2 - 4*MZ**2)) - (9*(12*MW**2*MZ**2*(MH**2 - 3*MZ**2) + cw**2*(2*MH**6 - 13*MH**4*MZ**2 + 20*MH**2*MZ**4))*(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))*reglog((-MH**2 + 2*MZ**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))/(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))))/(MZ**6*(MH**2 - 4*MZ**2))))/(3456.*cw**4*cmath.pi**2*sw**2))'+'+'+dMB_ZZWcft_UV_EW.value[0]},
                           texname = '\delta Z_{ZZ}^{EW}')


AZWcft_UV_EW = CTParameter(name = 'AZWcft_UV_EW',
                           type = 'complex',
                           value = {-1:'recms(CMSParam==1.0 and WZ != 0,-(ee**2*(cw**2*(36*MW**2 + 57*MZ**2) + 36*MW**2*sw**2 + MZ**2*(-18 - 18*Ncol + 75*sw**2 + 40*Ncol*sw**2)))/(144.*cw*MZ**2*cmath.pi**2*sw))',
                           0:'recms(CMSParam==1.0 and WZ != 0,(ee**2*(cw**2*(36*MW**2 + 57*MZ**2) + 36*MW**2*sw**2 + MZ**2*(-18 - 18*Ncol + 75*sw**2 + 40*Ncol*sw**2))*reglog(4*cmath.pi))/(144.*cw*MZ**2*cmath.pi**2*sw) + (ee**2*((2*(4*(-4*MT**2*Ncol*(-3 + 8*sw**2) + 9*MW**2*sw**2*(-4 - reglog(64) - 3*reglog(cmath.pi))) + MZ**2*(-2*Ncol*(-9 + 20*sw**2)*(5 + reglog(64) + 3*reglog(cmath.pi)) + 3*(6*(5 + reglog(64) + 3*reglog(cmath.pi)) + sw**2*(-128 + 75*reglog(cmath.pi) - 150*reglog(2*cmath.pi)))) + 3*cw**2*(12*MW**2*(-16 - reglog(64) - 3*reglog(cmath.pi)) + MZ**2*(-116 + 57*reglog(cmath.pi) - 114*reglog(2*cmath.pi)))))/MZ**2 + (16*MT**2*Ncol*(-3 + 8*sw**2)*reglog(MU_R**2/MT**2))/MZ**2 + (72*MW**2*(5*cw**2 - sw**2)*reglog(MU_R**2/MW**2))/MZ**2 + (2*(9*cw**2*(32*MW**2 + 19*MZ**2) - 12*MZ**2*Ncol + 72*MW**2*sw**2 + 9*MZ**2*sw**2 + 32*MZ**2*Ncol*sw**2 + 8*MT**2*Ncol*(-3 + 8*sw**2))*reglog((MZ**2 + vep*complex(0,-1))/MU_R**2))/MZ**2 - 4*(-27 - 21*Ncol + 108*sw**2 + 44*Ncol*sw**2)*reglogp(-(MU_R**2/(MZ**2 + vep*complex(0,1)))) + (8*(2*MT**2 + MZ**2)*Ncol*(-3 + 8*sw**2)*reglog((-MZ**2 - cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)))/MZ**2 + (8*(2*MT**2 + MZ**2)*Ncol*(-3 + 8*sw**2)*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)))/MZ**2 - (4*(2*MT**2 + MZ**2)*Ncol*(-3 + 8*sw**2)*(MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))))/MZ**4 - (4*(2*MT**2 + MZ**2)*Ncol*(-3 + 8*sw**2)*(MZ**2 - cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))*reglog((MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(-MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))))/MZ**4 + (18*(cw**2*(32*MW**2 + 19*MZ**2) + (8*MW**2 + MZ**2)*sw**2)*reglog((-MZ**2 - cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)))/MZ**2 + (18*(cw**2*(32*MW**2 + 19*MZ**2) + (8*MW**2 + MZ**2)*sw**2)*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)))/MZ**2 - (9*(cw**2*(32*MW**2 + 19*MZ**2) + (8*MW**2 + MZ**2)*sw**2)*(MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))))/MZ**4 - (9*(cw**2*(32*MW**2 + 19*MZ**2) + (8*MW**2 + MZ**2)*sw**2)*(MZ**2 - cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))*reglog((MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(-MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))))/MZ**4))/(864.*cw*cmath.pi**2*sw))'+'+'+dMB_AZWcft_UV_EW.value[0]},
                           texname = '\delta Z_{AZ}^{EW}')

ZAWcft_UV_EW = CTParameter(name = 'ZAWcft_UV_EW',
                           type = 'complex',
                           value = {-1:'(ee**2*MW**2*(cw**2 + sw**2))/(4.*cw*MZ**2*cmath.pi**2*sw)',
                                     0:'-(ee**2*MW**2*(cw**2 + sw**2)*reglog(MW**2/MU_R**2))/(4.*cw*MZ**2*cmath.pi**2*sw)'},
                           texname = '\delta Z_{ZA}^{EW}')

AAWcft_UV_EW = CTParameter(name = 'AAWcft_UV_EW',
                           type = 'complex',
                           value = {-1:'(ee**2*(81 - 16*Ncol))/(432.*cmath.pi**2)'+'+'+dMB_AAWcft_UV_EW.value[-1],
                                     0:'(ee**2*(9 + 16*Ncol*reglog(MT/MU_R) - 81*reglog(MW/MU_R)))/(216.*cmath.pi**2)'+'+'+dMB_AAWcft_UV_EW.value[0]},
                           texname = '\delta Z_{AA}^{EW}')


eCoup_UV_EW = CTParameter(name = 'eCoup_UV_EW',
                          type = 'complex',
                          value = {-1:'(ee**2*(cw**2*(-36*MW**2 + MZ**2*(9 + 20*Ncol)) - 36*MW**2*sw**2))/(288.*cw**2*MZ**2*cmath.pi**2)',
                                    0:'recms(CMSParam==1.0,(ee**2*(-7 + 4*sw**2)*reglog(cw**2))/(64.*cmath.pi**2*sw**4) - (ee**2*(-36*MT**4*Ncol + 81*MH**2*MW**2*sw**2 - 2133*MW**4*sw**2 + 144*MT**4*Ncol*sw**2 + 402*MT**2*MW**2*Ncol*sw**2 - 18*MH**4*sw**4 - 162*MH**2*MW**2*sw**4 + 10161*MW**4*sw**4 - 180*MT**4*Ncol*sw**4 - 1700*MT**2*MW**2*Ncol*sw**4 - 800*MW**4*Ncol*sw**4 + 36*MH**4*sw**6 + 81*MH**2*MW**2*sw**6 - 15966*MW**4*sw**6 + 72*MT**4*Ncol*sw**6 + 2706*MT**2*MW**2*Ncol*sw**6 + 1600*MW**4*Ncol*sw**6 - 18*MH**4*sw**8 + 9648*MW**4*sw**8 - 1920*MT**2*MW**2*Ncol*sw**8 - 800*MW**4*Ncol*sw**8 - 1728*MW**4*sw**10 + 512*MT**2*MW**2*Ncol*sw**10 + 384*MW**4*sw**2*reglog(64) - 1152*MW**4*sw**4*reglog(64) - 160*MW**4*Ncol*sw**4*reglog(64) + 1008*MW**4*sw**6*reglog(64) + 320*MW**4*Ncol*sw**6*reglog(64) - 240*MW**4*sw**8*reglog(64) - 160*MW**4*Ncol*sw**8*reglog(64) - 72*MW**4*sw**6*reglog(262144) + 72*MW**4*sw**8*reglog(262144) + 2088*MW**4*sw**2*reglog(cmath.pi) - 5184*MW**4*sw**4*reglog(cmath.pi) - 608*MW**4*Ncol*sw**4*reglog(cmath.pi) + 3240*MW**4*sw**6*reglog(cmath.pi) + 1216*MW**4*Ncol*sw**6*reglog(cmath.pi) - 144*MW**4*sw**8*reglog(cmath.pi) - 608*MW**4*Ncol*sw**8*reglog(cmath.pi) - 1872*MW**4*sw**2*reglog(2*cmath.pi) + 3456*MW**4*sw**4*reglog(2*cmath.pi) + 256*MW**4*Ncol*sw**4*reglog(2*cmath.pi) - 1728*MW**4*sw**6*reglog(2*cmath.pi) - 512*MW**4*Ncol*sw**6*reglog(2*cmath.pi) + 144*MW**4*sw**8*reglog(2*cmath.pi) + 256*MW**4*Ncol*sw**8*reglog(2*cmath.pi) - 1080*MW**4*sw**2*reglog(4*cmath.pi) + 4320*MW**4*sw**4*reglog(4*cmath.pi) + 352*MW**4*Ncol*sw**4*reglog(4*cmath.pi) - 4104*MW**4*sw**6*reglog(4*cmath.pi) - 704*MW**4*Ncol*sw**6*reglog(4*cmath.pi) + 864*MW**4*sw**8*reglog(4*cmath.pi) + 352*MW**4*Ncol*sw**8*reglog(4*cmath.pi)))/(6912.*MW**4*cmath.pi**2*(-1 + sw)**2*sw**4*(1 + sw)**2) + (ee**2*MW**2*(cw**2 + sw**2)*reglog(MW**2/MU_R**2))/(8.*cw**2*MZ**2*cmath.pi**2) - (ee**2*Ncol*reglog(MT/MU_R))/(27.*cmath.pi**2) + (3*ee**2*reglog(MW/MU_R))/(16.*cmath.pi**2) - (ee**2*MH**2*(-3*MH**2*MW**2 + 12*MW**4 + MH**4*sw**2 - MH**2*MW**2*sw**2)*reglog(MU_R**2/MH**2))/(384.*(MH - MW)*MW**4*(MH + MW)*cmath.pi**2*sw**2) + (ee**2*Ncol*(9*MT**2 - 18*MW**2 + 39*MT**2*sw**2 + 36*MW**2*sw**2 - 112*MT**2*sw**4 - 32*MW**2*sw**4 + 64*MT**2*sw**6)*reglog(MU_R**2/MT**2))/(1728.*MW**2*cmath.pi**2*sw**4) - (ee**2*(MH**4 + 33*MH**2*MW**2 - 34*MW**4 - 3*MH**4*sw**2 - 57*MH**2*MW**2*sw**2 + 51*MW**4*sw**2 + 2*MH**4*sw**4 - 45*MH**2*MW**2*sw**4 + 52*MW**4*sw**4 + 116*MH**2*MW**2*sw**6 - 116*MW**4*sw**6 - 48*MH**2*MW**2*sw**8 + 48*MW**4*sw**8)*reglog(MU_R**2/MW**2))/(384.*MW**2*(-MH + MW)*(MH + MW)*cmath.pi**2*(-1 + sw)*sw**4*(1 + sw)) + (ee**2*(-1 + sw)*(1 + sw)*reglog((4*cmath.pi*MU_R**2)/MW**2))/(8.*cmath.pi**2*sw**2) + (ee**2*(MH**2 + 34*MW**2 - 3*MH**2*sw**2 - 61*MW**2*sw**2 + 3*MH**2*sw**4 + 2*MW**2*sw**4 - MH**2*sw**6 + 24*MW**2*sw**6)*reglog(-(((-1 + sw**2)*MU_R**2)/MW**2)))/(384.*MW**2*cmath.pi**2*(-1 + sw)**2*sw**4*(1 + sw)**2) + (ee**2*(-1 + sw)*(1 + sw)*(MH**4 - 4*MH**2*MW**2 + 12*MW**4 - 2*MH**4*sw**2 + 4*MH**2*MW**2*sw**2 + MH**4*sw**4)*(-MH**2 + cmath.sqrt((-MH**4 + 4*MH**2*MW**2 + MH**4*sw**2 + MW**2*vep*complex(0,-4))/(-1 + sw**2)))*reglog((-MH**2 - (2*MW**2)/(-1 + sw**2) + cmath.sqrt((4*MH**2*MW**2 + MH**4*(-1 + sw**2) + MW**2*vep*complex(0,-4))/(-1 + sw**2)))/(-MH**2 + cmath.sqrt((4*MH**2*MW**2 + MH**4*(-1 + sw**2) + MW**2*vep*complex(0,-4))/(-1 + sw**2)))))/(768.*MW**6*cmath.pi**2*sw**4) - (ee**2*(-1 + sw)*(1 + sw)*(MH**4 - 4*MH**2*MW**2 + 12*MW**4 - 2*MH**4*sw**2 + 4*MH**2*MW**2*sw**2 + MH**4*sw**4)*(MH**2 + cmath.sqrt((-MH**4 + 4*MH**2*MW**2 + MH**4*sw**2 + MW**2*vep*complex(0,-4))/(-1 + sw**2)))*reglog((MH**2 + (2*MW**2)/(-1 + sw**2) + cmath.sqrt((4*MH**2*MW**2 + MH**4*(-1 + sw**2) + MW**2*vep*complex(0,-4))/(-1 + sw**2)))/(MH**2 + cmath.sqrt((4*MH**2*MW**2 + MH**4*(-1 + sw**2) + MW**2*vep*complex(0,-4))/(-1 + sw**2)))))/(768.*MW**6*cmath.pi**2*sw**4) - (ee**2*Ncol*(-9*MT**2 + 9*MW**2 - 39*MT**2*sw**2 - 24*MW**2*sw**2 + 112*MT**2*sw**4 + 32*MW**2*sw**4 - 64*MT**2*sw**6)*reglog((-MW**2 - (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2 + 4*MT**2*(-1 + sw**2) + (-1 + sw**2)*vep*complex(0,-4)))/(-1 + sw**2)**2))/(2.*MW**2)))/(1728.*MW**2*cmath.pi**2*sw**4) - (ee**2*Ncol*(-9*MT**2 + 9*MW**2 - 39*MT**2*sw**2 - 24*MW**2*sw**2 + 112*MT**2*sw**4 + 32*MW**2*sw**4 - 64*MT**2*sw**6)*reglog((-MW**2 + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2 + 4*MT**2*(-1 + sw**2) + (-1 + sw**2)*vep*complex(0,-4)))/(-1 + sw**2)**2))/(2.*MW**2)))/(1728.*MW**2*cmath.pi**2*sw**4) + (ee**2*Ncol*(-9*MT**2 + 9*MW**2 - 39*MT**2*sw**2 - 24*MW**2*sw**2 + 112*MT**2*sw**4 + 32*MW**2*sw**4 - 64*MT**2*sw**6)*(MW**2 - cmath.sqrt((MW**2*(-4*MT**2 + MW**2 + 4*MT**2*sw**2 + sw**2*vep*complex(0,-4) + vep*complex(0,4)))/(-1 + sw**2)**2) + sw**2*cmath.sqrt((MW**2*(-4*MT**2 + MW**2 + 4*MT**2*sw**2 + sw**2*vep*complex(0,-4) + vep*complex(0,4)))/(-1 + sw**2)**2))*reglog((-MW**2 + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2 + 4*MT**2*(-1 + sw**2) + (-1 + sw**2)*vep*complex(0,-4)))/(-1 + sw**2)**2))/(MW**2 + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2 + 4*MT**2*(-1 + sw**2) + (-1 + sw**2)*vep*complex(0,-4)))/(-1 + sw**2)**2))))/(3456.*MW**4*cmath.pi**2*sw**4) + (ee**2*Ncol*(-9*MT**2 + 9*MW**2 - 39*MT**2*sw**2 - 24*MW**2*sw**2 + 112*MT**2*sw**4 + 32*MW**2*sw**4 - 64*MT**2*sw**6)*(MW**2 + cmath.sqrt((MW**2*(-4*MT**2 + MW**2 + 4*MT**2*sw**2 + sw**2*vep*complex(0,-4) + vep*complex(0,4)))/(-1 + sw**2)**2) - sw**2*cmath.sqrt((MW**2*(-4*MT**2 + MW**2 + 4*MT**2*sw**2 + sw**2*vep*complex(0,-4) + vep*complex(0,4)))/(-1 + sw**2)**2))*reglog((MW**2 + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2 + 4*MT**2*(-1 + sw**2) + (-1 + sw**2)*vep*complex(0,-4)))/(-1 + sw**2)**2))/(-MW**2 + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2 + 4*MT**2*(-1 + sw**2) + (-1 + sw**2)*vep*complex(0,-4)))/(-1 + sw**2)**2))))/(3456.*MW**4*cmath.pi**2*sw**4) - (ee**2*(-3 + 4*sw**2)*(33 - 44*sw**2 + 12*sw**4)*reglog((-MW**2 - (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2*(-3 + 4*sw**2) + (-1 + sw**2)*vep*complex(0,-4)))/(-1 + sw**2)**2))/(2.*MW**2)))/(384.*cmath.pi**2*sw**4) - (ee**2*(-3 + 4*sw**2)*(33 - 44*sw**2 + 12*sw**4)*reglog((-MW**2 + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2*(-3 + 4*sw**2) + (-1 + sw**2)*vep*complex(0,-4)))/(-1 + sw**2)**2))/(2.*MW**2)))/(384.*cmath.pi**2*sw**4) + (ee**2*(-3 + 4*sw**2)*(33 - 44*sw**2 + 12*sw**4)*(MW**2 - cmath.sqrt((MW**2*(-3*MW**2 + 4*MW**2*sw**2 + sw**2*vep*complex(0,-4) + vep*complex(0,4)))/(-1 + sw**2)**2) + sw**2*cmath.sqrt((MW**2*(-3*MW**2 + 4*MW**2*sw**2 + sw**2*vep*complex(0,-4) + vep*complex(0,4)))/(-1 + sw**2)**2))*reglog((-MW**2 + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2*(-3 + 4*sw**2) + (-1 + sw**2)*vep*complex(0,-4)))/(-1 + sw**2)**2))/(MW**2 + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2*(-3 + 4*sw**2) + (-1 + sw**2)*vep*complex(0,-4)))/(-1 + sw**2)**2))))/(768.*MW**2*cmath.pi**2*sw**4) + (ee**2*(-3 + 4*sw**2)*(33 - 44*sw**2 + 12*sw**4)*(MW**2 + cmath.sqrt((MW**2*(-3*MW**2 + 4*MW**2*sw**2 + sw**2*vep*complex(0,-4) + vep*complex(0,4)))/(-1 + sw**2)**2) - sw**2*cmath.sqrt((MW**2*(-3*MW**2 + 4*MW**2*sw**2 + sw**2*vep*complex(0,-4) + vep*complex(0,4)))/(-1 + sw**2)**2))*reglog((MW**2 + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2*(-3 + 4*sw**2) + (-1 + sw**2)*vep*complex(0,-4)))/(-1 + sw**2)**2))/(-MW**2 + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2*(-3 + 4*sw**2) + (-1 + sw**2)*vep*complex(0,-4)))/(-1 + sw**2)**2))))/(768.*MW**2*cmath.pi**2*sw**4) - (ee**2*(MT - MW)**2*(MT + MW)**2*(MT**2 + 2*MW**2)*Ncol*(-1 + 2*sw**2)*reglog((MT**2 - MW**2 + vep*complex(0,-1))/MT**2))/(192.*MW**6*cmath.pi**2*sw**4) - (ee**2*(-1 + 2*sw**2)*(MH**4 - 4*MH**2*MW**2 - 87*MW**4 - 2*MH**4*sw**2 + 8*MH**2*MW**2*sw**2 + 240*MW**4*sw**2 + MH**4*sw**4 - 4*MH**2*MW**2*sw**4 - 200*MW**4*sw**4 + 48*MW**4*sw**6)*reglog((MW**2 + vep*complex(0,-1))/MU_R**2))/(384.*MW**4*cmath.pi**2*(-1 + sw)**2*sw**4*(1 + sw)**2) - (ee**2*(9*MH**4 - 36*MH**2*MW**2 - 783*MW**4 - 18*MT**2*MW**2*Ncol + 18*MW**4*Ncol - 18*MH**4*sw**2 + 36*MH**2*MW**2*sw**2 + 2376*MW**4*sw**2 - 78*MT**2*MW**2*Ncol*sw**2 - 48*MW**4*Ncol*sw**2 + 9*MH**4*sw**4 - 1908*MW**4*sw**4 + 224*MT**2*MW**2*Ncol*sw**4 + 64*MW**4*Ncol*sw**4 + 432*MW**4*sw**6 - 128*MT**2*MW**2*Ncol*sw**6)*reglog((MW**2/(1 - sw**2) + vep*complex(0,-1))/MU_R**2))/(3456.*MW**4*cmath.pi**2*sw**4) + (ee**2*(54 + 45*Ncol - 108*sw**2 - 84*Ncol*sw**2 + 216*sw**4 + 88*Ncol*sw**4)*reglogp(((-1 + sw**2)*MU_R**2)/(MW**2 + (-1 + sw**2)*vep*complex(0,-1))))/(1728.*cmath.pi**2*sw**4) - (ee**2*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*(-1 + 2*sw**2)*reglog(-1 + (MH**2 - cmath.sqrt(MH**4 - 4*MW**2*(MH**2 + vep*complex(0,-1))))/(2.*MW**2)))/(384.*MW**4*cmath.pi**2*sw**4) - (ee**2*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*(-1 + 2*sw**2)*reglog(-1 + (MH**2 + cmath.sqrt(MH**4 - 4*MW**2*(MH**2 + vep*complex(0,-1))))/(2.*MW**2)))/(384.*MW**4*cmath.pi**2*sw**4) - (ee**2*(MH**4 - 4*MH**2*MW**2 + 12*MW**4 - 2*MH**4*sw**2 + 4*MH**2*MW**2*sw**2 + MH**4*sw**4)*reglog(-1 + ((-1 + sw**2)*(-MH**2 + cmath.sqrt(MH**4 + (4*MW**2*(MH**2 + vep*complex(0,-1)))/(-1 + sw**2))))/(2.*MW**2)))/(384.*MW**4*cmath.pi**2*sw**4) - (ee**2*(MH**4 - 4*MH**2*MW**2 + 12*MW**4 - 2*MH**4*sw**2 + 4*MH**2*MW**2*sw**2 + MH**4*sw**4)*reglog(-1 - ((-1 + sw**2)*(MH**2 + cmath.sqrt(MH**4 + (4*MW**2*(MH**2 + vep*complex(0,-1)))/(-1 + sw**2))))/(2.*MW**2)))/(384.*MW**4*cmath.pi**2*sw**4) + (ee**2*(3 + 2*Ncol)*(-1 + 2*sw**2)*reglogp(-(MU_R**2/(MW**2 + vep*complex(0,1)))))/(96.*cmath.pi**2*sw**4) + (ee**2*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*(-1 + 2*sw**2)*(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))*reglog((MH**2 - 2*MW**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))/(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))))/(768.*MW**6*cmath.pi**2*sw**4) - (ee**2*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*(-1 + 2*sw**2)*(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))*reglog((-MH**2 + 2*MW**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))/(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))))/(768.*MW**6*cmath.pi**2*sw**4) - (ee**2*(-1 + 2*sw**2)*(-3 + 4*sw**2)*(33 - 44*sw**2 + 12*sw**4)*reglog((-(MW**2/(1 - sw**2)) - cmath.sqrt((MW**2*(MW**2*(-3 + 4*sw**2) + (-1 + sw**2)**2*vep*complex(0,4)))/(-1 + sw**2)**2))/(2.*MW**2)))/(384.*cmath.pi**2*(-1 + sw)**2*sw**4*(1 + sw)**2) - (ee**2*(-1 + 2*sw**2)*(-3 + 4*sw**2)*(33 - 44*sw**2 + 12*sw**4)*reglog((MW**2 + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2*(-3 + 4*sw**2) + (-1 + sw**2)**2*vep*complex(0,4)))/(-1 + sw**2)**2))/(2.*MW**2*(-1 + sw**2))))/(384.*cmath.pi**2*(-1 + sw)**2*sw**4*(1 + sw)**2) + (ee**2*(-1 + 2*sw**2)*(-3 + 4*sw**2)*(33 - 44*sw**2 + 12*sw**4)*(-MW**2 + 2*MW**2*sw**2 + cmath.sqrt((MW**2*(-3*MW**2 + 4*MW**2*sw**2 + sw**2*vep*complex(0,-8) + vep*complex(0,4) + sw**4*vep*complex(0,4)))/(-1 + sw**2)**2) - sw**2*cmath.sqrt((MW**2*(-3*MW**2 + 4*MW**2*sw**2 + sw**2*vep*complex(0,-8) + vep*complex(0,4) + sw**4*vep*complex(0,4)))/(-1 + sw**2)**2))*reglog((-MW**2 + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2*(-3 + 4*sw**2) + (-1 + sw**2)**2*vep*complex(0,4)))/(-1 + sw**2)**2))/(MW**2*(1 - 2*sw**2) + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2*(-3 + 4*sw**2) + (-1 + sw**2)**2*vep*complex(0,4)))/(-1 + sw**2)**2))))/(768.*MW**2*cmath.pi**2*(-1 + sw)**3*sw**4*(1 + sw)**3) + (ee**2*(-1 + 2*sw**2)*(-3 + 4*sw**2)*(33 - 44*sw**2 + 12*sw**4)*(-MW**2 + 2*MW**2*sw**2 - cmath.sqrt((MW**2*(-3*MW**2 + 4*MW**2*sw**2 + sw**2*vep*complex(0,-8) + vep*complex(0,4) + sw**4*vep*complex(0,4)))/(-1 + sw**2)**2) + sw**2*cmath.sqrt((MW**2*(-3*MW**2 + 4*MW**2*sw**2 + sw**2*vep*complex(0,-8) + vep*complex(0,4) + sw**4*vep*complex(0,4)))/(-1 + sw**2)**2))*reglog((MW**2 + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2*(-3 + 4*sw**2) + (-1 + sw**2)**2*vep*complex(0,4)))/(-1 + sw**2)**2))/(MW**2*(-1 + 2*sw**2) + (-1 + sw**2)*cmath.sqrt((MW**2*(MW**2*(-3 + 4*sw**2) + (-1 + sw**2)**2*vep*complex(0,4)))/(-1 + sw**2)**2))))/(768.*MW**2*cmath.pi**2*(-1 + sw)**3*sw**4*(1 + sw)**3))'+'+'+dMB_eCoup_UV_EW.value[0]},
                          texname = '\delta e')


SWCoup_UV_EW = CTParameter(name = 'SWCoup_UV_EW',
                           type = 'complex',
                           value = {-1:'recms(CMSParam==1.0 and (WW != 0 or WZ != 0),-(ee**2*(-18*(2*cw**6*MZ**4 + cw**4*MT**2*MZ**2*Ncol) + 36*MW**4*(-1 + 2*cw**6 - 2*cw**2*sw**4) + cw**2*MW**2*(18*MT**2*Ncol - MZ**2*(39 + 147*cw**4 - 72*sw**2 + 111*sw**4 - 6*cw**2*(31 + 6*Ncol - 37*sw**2) + 4*Ncol*(9 - 18*sw**2 + 20*sw**4)))))/(1152.*cw**2*MW**2*MZ**2*cmath.pi**2*sw**3))'+'+'+dMB_SWCoup_UV_EW.value[-1],
                           0:'recms(CMSParam==1.0 and (WW != 0 or WZ != 0),(ee**2*(-18*(2*cw**6*MZ**4 + cw**4*MT**2*MZ**2*Ncol) + 36*MW**4*(-1 + 2*cw**6 - 2*cw**2*sw**4) + cw**2*MW**2*(18*MT**2*Ncol - MZ**2*(39 + 147*cw**4 - 72*sw**2 + 111*sw**4 - 6*cw**2*(31 + 6*Ncol - 37*sw**2) + 4*Ncol*(9 - 18*sw**2 + 20*sw**4))))*reglog(4*cmath.pi))/(1152.*cw**2*MW**2*MZ**2*cmath.pi**2*sw**3) + (cw**2*(-(ee**2*((2*(cw**2*(3*MH**4 - 18*MH**2*MW**2 + 3*(MZ**4 - 2*MT**4*Ncol) - 6*MW**2*(3*MZ**2 + MT**2*Ncol*(2 + reglog(64) + 3*reglog(cmath.pi))) - 2*MW**4*(-83 + 178*sw**2 + 93*reglog(cmath.pi) - 114*sw**2*reglog(cmath.pi) - 6*Ncol*(5 + reglog(64) + 3*reglog(cmath.pi)) - 186*reglog(2*cmath.pi) + 228*sw**2*reglog(2*cmath.pi))) + 4*cw**4*(6*MZ**4 + MW**4*(-107 + 66*reglog(cmath.pi) - 132*reglog(2*cmath.pi)) + 9*MW**2*MZ**2*(-6 - reglog(4*cmath.pi))) + 36*MW**4*sw**4*(2 + reglog(4*cmath.pi))))/(cw**2*MW**2) - (6*MH**2*(MH**2 - 3*MW**2)*reglog(MU_R**2/MH**2))/MW**2 - 12*(3*MT**2 - 2*MW**2)*Ncol*reglog(MU_R**2/MT**2) + 6*(MH**2 + (1 + 8*cw**2)*MZ**2 + MW**2*(38 - 28*cw**2 - 76*sw**2))*reglog(MU_R**2/MW**2) - (6*(1 + 8*cw**2)*MZ**2*(-3*MW**2 + MZ**2)*reglog(MU_R**2/MZ**2))/MW**2 - (12*(MT - MW)**2*(MT + MW)**2*(MT**2 + 2*MW**2)*Ncol*reglog((MT**2 - MW**2 + vep*complex(0,-1))/MT**2))/MW**4 + (6*(cw**4*(60*MW**4 + 44*MW**2*MZ**2 - 8*MZ**4) - cw**2*(MH**4 - 4*MH**2*MW**2 + 12*MW**4 - 4*MW**2*MZ**2 + MZ**4) - 12*MW**4*sw**4)*reglog((MW**2 + vep*complex(0,-1))/MU_R**2))/(cw**2*MW**2) + (6*(cw**4*(60*MW**4 + 44*MW**2*MZ**2 - 8*MZ**4) + cw**2*(4*MW**2*MZ**2 - MZ**4) - 12*MW**4*sw**4)*reglog((-MZ**2 - cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(2.*MW**2)))/(cw**2*MW**2) + (6*(cw**4*(60*MW**4 + 44*MW**2*MZ**2 - 8*MZ**4) + cw**2*(4*MW**2*MZ**2 - MZ**4) - 12*MW**4*sw**4)*reglog((-MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(2.*MW**2)))/(cw**2*MW**2) - (3*(cw**4*(60*MW**4 + 44*MW**2*MZ**2 - 8*MZ**4) + cw**2*(4*MW**2*MZ**2 - MZ**4) - 12*MW**4*sw**4)*(2*MW**2 - MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))*reglog((-MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(2*MW**2 - MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))))/(cw**2*MW**4) + (3*(cw**4*(60*MW**4 + 44*MW**2*MZ**2 - 8*MZ**4) + cw**2*(4*MW**2*MZ**2 - MZ**4) - 12*MW**4*sw**4)*(-2*MW**2 + MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))*reglog((MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(-2*MW**2 + MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))))/(cw**2*MW**4) - (6*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*reglog(-1 + (MH**2 - cmath.sqrt(MH**4 - 4*MW**2*(MH**2 + vep*complex(0,-1))))/(2.*MW**2)))/MW**2 - (6*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*reglog(-1 + (MH**2 + cmath.sqrt(MH**4 - 4*MW**2*(MH**2 + vep*complex(0,-1))))/(2.*MW**2)))/MW**2 + 24*MW**2*(3 + 2*Ncol)*reglogp(-(MU_R**2/(MW**2 + vep*complex(0,1)))) + (3*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))*reglog((MH**2 - 2*MW**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))/(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))))/MW**4 - (3*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))*reglog((-MH**2 + 2*MW**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))/(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))))/MW**4))/(1152.*MW**2*cmath.pi**2*sw**2) + (ee**2*((2*(-108*MW**2*MZ**2*(-2 + reglog(1/(4.*cmath.pi))) + 6*cw**4*MZ**2*sw**2*(24*MW**2 + MZ**2*(-8 - reglog(64) - 3*reglog(cmath.pi))) + 9*cw**6*MZ**2*(24*MW**2*(-5 + reglog(1/(4.*cmath.pi))) + MZ**2*(-80 + 39*reglog(cmath.pi) - 78*reglog(2*cmath.pi))) + cw**2*(9*MH**4 - 54*MH**2*MZ**2 + MZ**2*(2*(-36*MW**2*sw**4*(-5 - reglog(64) - 3*reglog(cmath.pi)) + MT**2*Ncol*(-96*sw**2 + 128*sw**4 - 9*(2 + reglog(64) + 3*reglog(cmath.pi)))) + MZ**2*(4*Ncol*(9 - 18*sw**2 + 20*sw**4)*(5 + reglog(64) + 3*reglog(cmath.pi)) + 3*(59 - 39*reglog(cmath.pi) - 24*sw**2*(5 + reglog(64) + 3*reglog(cmath.pi)) + 78*reglog(2*cmath.pi) + sw**4*(248 - 147*reglog(cmath.pi) + 294*reglog(2*cmath.pi))))))))/MZ**2 - (18*cw**2*MH**2*(MH**2 - 3*MZ**2)*reglog(MU_R**2/MH**2))/MZ**2 - 8*cw**2*MT**2*Ncol*(9 - 24*sw**2 + 32*sw**4)*reglog(MU_R**2/MT**2) + 72*cw**2*MW**2*(9*cw**4 - 2*cw**2*sw**2 + sw**4)*reglog(MU_R**2/MW**2) + 18*cw**2*(MH**2 + MZ**2)*reglog(MU_R**2/MZ**2) + (2*(-108*MW**2*MZ**2 + 27*cw**6*(20*MW**2*MZ**2 + 13*MZ**4) + 18*cw**4*MZ**2*(-4*MW**2 + MZ**2)*sw**2 - cw**2*(9*MH**4 - 36*MH**2*MZ**2 + MZ**2*(180*MW**2*sw**4 + 2*MT**2*Ncol*(-9 - 48*sw**2 + 64*sw**4) + MZ**2*(9*sw**4 + 2*Ncol*(9 - 24*sw**2 + 32*sw**4)))))*reglog((MZ**2 + vep*complex(0,-1))/MU_R**2))/MZ**2 - (18*(12*MW**2*MZ**2 + cw**2*(MH**4 - 4*MH**2*MZ**2))*reglog(-1 + (MH**2 - cmath.sqrt(MH**4 - 4*MZ**2*(MH**2 + vep*complex(0,-1))))/(2.*MZ**2)))/MZ**2 - (18*(12*MW**2*MZ**2 + cw**2*(MH**4 - 4*MH**2*MZ**2))*reglog(-1 + (MH**2 + cmath.sqrt(MH**4 - 4*MZ**2*(MH**2 + vep*complex(0,-1))))/(2.*MZ**2)))/MZ**2 + 4*cw**2*MZ**2*(54*(1 - 2*sw**2 + 4*sw**4) + Ncol*(45 - 84*sw**2 + 88*sw**4))*reglogp(-(MU_R**2/(MZ**2 + vep*complex(0,1)))) - 4*cw**2*Ncol*(MZ**2*(9 - 24*sw**2 + 32*sw**4) + MT**2*(-9 - 48*sw**2 + 64*sw**4))*reglog((-MZ**2 - cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)) - 4*cw**2*Ncol*(MZ**2*(9 - 24*sw**2 + 32*sw**4) + MT**2*(-9 - 48*sw**2 + 64*sw**4))*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)) + (2*cw**2*Ncol*(MZ**2*(9 - 24*sw**2 + 32*sw**4) + MT**2*(-9 - 48*sw**2 + 64*sw**4))*(MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))))/MZ**2 + (2*cw**2*Ncol*(MZ**2*(9 - 24*sw**2 + 32*sw**4) + MT**2*(-9 - 48*sw**2 + 64*sw**4))*(MZ**2 - cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))*reglog((MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(-MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))))/MZ**2 + 18*cw**2*(cw**4*(60*MW**2 + 39*MZ**2) + 2*cw**2*(-4*MW**2 + MZ**2)*sw**2 - (20*MW**2 + MZ**2)*sw**4)*reglog((-MZ**2 - cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)) + 18*cw**2*(cw**4*(60*MW**2 + 39*MZ**2) + 2*cw**2*(-4*MW**2 + MZ**2)*sw**2 - (20*MW**2 + MZ**2)*sw**4)*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)) - (9*cw**2*(cw**4*(60*MW**2 + 39*MZ**2) + 2*cw**2*(-4*MW**2 + MZ**2)*sw**2 - (20*MW**2 + MZ**2)*sw**4)*(MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))))/MZ**2 - (9*cw**2*(cw**4*(60*MW**2 + 39*MZ**2) + 2*cw**2*(-4*MW**2 + MZ**2)*sw**2 - (20*MW**2 + MZ**2)*sw**4)*(MZ**2 - cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))*reglog((MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(-MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))))/MZ**2 + (9*(12*MW**2*MZ**2 + cw**2*(MH**4 - 4*MH**2*MZ**2))*(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))*reglog((MH**2 - 2*MZ**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))/(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))))/MZ**4 - (9*(12*MW**2*MZ**2 + cw**2*(MH**4 - 4*MH**2*MZ**2))*(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))*reglog((-MH**2 + 2*MZ**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))/(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))))/MZ**4))/(3456.*cw**4*MZ**2*cmath.pi**2*sw**2)))/(2.*sw))'+'+'+dMB_SWCoup_UV_EW.value[0]},
                           texname = '\delta SW')


CWCoup_UV_EW = CTParameter(name = 'CWCoup_UV_EW',
                           type = 'complex',
                           value = {-1:'recms(CMSParam==1.0 and (WW != 0 or WZ != 0),(ee**2*(-18*(2*cw**6*MZ**4 + cw**4*MT**2*MZ**2*Ncol) + 36*MW**4*(-1 + 2*cw**6 - 2*cw**2*sw**4) + cw**2*MW**2*(18*MT**2*Ncol - MZ**2*(39 + 147*cw**4 - 72*sw**2 + 111*sw**4 - 6*cw**2*(31 + 6*Ncol - 37*sw**2) + 4*Ncol*(9 - 18*sw**2 + 20*sw**4)))))/(1152.*cw**3*MW**2*MZ**2*cmath.pi**2*sw**2))'+'+'+dMB_CWCoup_UV_EW.value[-1],
                           0:'recms(CMSParam==1.0 and (WW != 0 or WZ != 0),-(ee**2*(-18*(2*cw**6*MZ**4 + cw**4*MT**2*MZ**2*Ncol) + 36*MW**4*(-1 + 2*cw**6 - 2*cw**2*sw**4) + cw**2*MW**2*(18*MT**2*Ncol - MZ**2*(39 + 147*cw**4 - 72*sw**2 + 111*sw**4 - 6*cw**2*(31 + 6*Ncol - 37*sw**2) + 4*Ncol*(9 - 18*sw**2 + 20*sw**4))))*reglog(4*cmath.pi))/(1152.*cw**3*MW**2*MZ**2*cmath.pi**2*sw**2) + (cw*((ee**2*((2*(cw**2*(3*MH**4 - 18*MH**2*MW**2 + 3*(MZ**4 - 2*MT**4*Ncol) - 6*MW**2*(3*MZ**2 + MT**2*Ncol*(2 + reglog(64) + 3*reglog(cmath.pi))) - 2*MW**4*(-83 + 178*sw**2 + 93*reglog(cmath.pi) - 114*sw**2*reglog(cmath.pi) - 6*Ncol*(5 + reglog(64) + 3*reglog(cmath.pi)) - 186*reglog(2*cmath.pi) + 228*sw**2*reglog(2*cmath.pi))) + 4*cw**4*(6*MZ**4 + MW**4*(-107 + 66*reglog(cmath.pi) - 132*reglog(2*cmath.pi)) + 9*MW**2*MZ**2*(-6 - reglog(4*cmath.pi))) + 36*MW**4*sw**4*(2 + reglog(4*cmath.pi))))/(cw**2*MW**2) - (6*MH**2*(MH**2 - 3*MW**2)*reglog(MU_R**2/MH**2))/MW**2 - 12*(3*MT**2 - 2*MW**2)*Ncol*reglog(MU_R**2/MT**2) + 6*(MH**2 + (1 + 8*cw**2)*MZ**2 + MW**2*(38 - 28*cw**2 - 76*sw**2))*reglog(MU_R**2/MW**2) - (6*(1 + 8*cw**2)*MZ**2*(-3*MW**2 + MZ**2)*reglog(MU_R**2/MZ**2))/MW**2 - (12*(MT - MW)**2*(MT + MW)**2*(MT**2 + 2*MW**2)*Ncol*reglog((MT**2 - MW**2 + vep*complex(0,-1))/MT**2))/MW**4 + (6*(cw**4*(60*MW**4 + 44*MW**2*MZ**2 - 8*MZ**4) - cw**2*(MH**4 - 4*MH**2*MW**2 + 12*MW**4 - 4*MW**2*MZ**2 + MZ**4) - 12*MW**4*sw**4)*reglog((MW**2 + vep*complex(0,-1))/MU_R**2))/(cw**2*MW**2) + (6*(cw**4*(60*MW**4 + 44*MW**2*MZ**2 - 8*MZ**4) + cw**2*(4*MW**2*MZ**2 - MZ**4) - 12*MW**4*sw**4)*reglog((-MZ**2 - cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(2.*MW**2)))/(cw**2*MW**2) + (6*(cw**4*(60*MW**4 + 44*MW**2*MZ**2 - 8*MZ**4) + cw**2*(4*MW**2*MZ**2 - MZ**4) - 12*MW**4*sw**4)*reglog((-MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(2.*MW**2)))/(cw**2*MW**2) - (3*(cw**4*(60*MW**4 + 44*MW**2*MZ**2 - 8*MZ**4) + cw**2*(4*MW**2*MZ**2 - MZ**4) - 12*MW**4*sw**4)*(2*MW**2 - MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))*reglog((-MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(2*MW**2 - MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))))/(cw**2*MW**4) + (3*(cw**4*(60*MW**4 + 44*MW**2*MZ**2 - 8*MZ**4) + cw**2*(4*MW**2*MZ**2 - MZ**4) - 12*MW**4*sw**4)*(-2*MW**2 + MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))*reglog((MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))/(-2*MW**2 + MZ**2 + cmath.sqrt(MZ**4 - 4*MW**2*(MZ**2 + vep*complex(0,-1))))))/(cw**2*MW**4) - (6*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*reglog(-1 + (MH**2 - cmath.sqrt(MH**4 - 4*MW**2*(MH**2 + vep*complex(0,-1))))/(2.*MW**2)))/MW**2 - (6*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*reglog(-1 + (MH**2 + cmath.sqrt(MH**4 - 4*MW**2*(MH**2 + vep*complex(0,-1))))/(2.*MW**2)))/MW**2 + 24*MW**2*(3 + 2*Ncol)*reglogp(-(MU_R**2/(MW**2 + vep*complex(0,1)))) + (3*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))*reglog((MH**2 - 2*MW**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))/(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))))/MW**4 - (3*(MH**4 - 4*MH**2*MW**2 + 12*MW**4)*(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))*reglog((-MH**2 + 2*MW**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))/(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MW**2 + MW**2*vep*complex(0,4)))))/MW**4))/(1152.*MW**2*cmath.pi**2*sw**2) - (ee**2*((2*(-108*MW**2*MZ**2*(-2 + reglog(1/(4.*cmath.pi))) + 6*cw**4*MZ**2*sw**2*(24*MW**2 + MZ**2*(-8 - reglog(64) - 3*reglog(cmath.pi))) + 9*cw**6*MZ**2*(24*MW**2*(-5 + reglog(1/(4.*cmath.pi))) + MZ**2*(-80 + 39*reglog(cmath.pi) - 78*reglog(2*cmath.pi))) + cw**2*(9*MH**4 - 54*MH**2*MZ**2 + MZ**2*(2*(-36*MW**2*sw**4*(-5 - reglog(64) - 3*reglog(cmath.pi)) + MT**2*Ncol*(-96*sw**2 + 128*sw**4 - 9*(2 + reglog(64) + 3*reglog(cmath.pi)))) + MZ**2*(4*Ncol*(9 - 18*sw**2 + 20*sw**4)*(5 + reglog(64) + 3*reglog(cmath.pi)) + 3*(59 - 39*reglog(cmath.pi) - 24*sw**2*(5 + reglog(64) + 3*reglog(cmath.pi)) + 78*reglog(2*cmath.pi) + sw**4*(248 - 147*reglog(cmath.pi) + 294*reglog(2*cmath.pi))))))))/MZ**2 - (18*cw**2*MH**2*(MH**2 - 3*MZ**2)*reglog(MU_R**2/MH**2))/MZ**2 - 8*cw**2*MT**2*Ncol*(9 - 24*sw**2 + 32*sw**4)*reglog(MU_R**2/MT**2) + 72*cw**2*MW**2*(9*cw**4 - 2*cw**2*sw**2 + sw**4)*reglog(MU_R**2/MW**2) + 18*cw**2*(MH**2 + MZ**2)*reglog(MU_R**2/MZ**2) + (2*(-108*MW**2*MZ**2 + 27*cw**6*(20*MW**2*MZ**2 + 13*MZ**4) + 18*cw**4*MZ**2*(-4*MW**2 + MZ**2)*sw**2 - cw**2*(9*MH**4 - 36*MH**2*MZ**2 + MZ**2*(180*MW**2*sw**4 + 2*MT**2*Ncol*(-9 - 48*sw**2 + 64*sw**4) + MZ**2*(9*sw**4 + 2*Ncol*(9 - 24*sw**2 + 32*sw**4)))))*reglog((MZ**2 + vep*complex(0,-1))/MU_R**2))/MZ**2 - (18*(12*MW**2*MZ**2 + cw**2*(MH**4 - 4*MH**2*MZ**2))*reglog(-1 + (MH**2 - cmath.sqrt(MH**4 - 4*MZ**2*(MH**2 + vep*complex(0,-1))))/(2.*MZ**2)))/MZ**2 - (18*(12*MW**2*MZ**2 + cw**2*(MH**4 - 4*MH**2*MZ**2))*reglog(-1 + (MH**2 + cmath.sqrt(MH**4 - 4*MZ**2*(MH**2 + vep*complex(0,-1))))/(2.*MZ**2)))/MZ**2 + 4*cw**2*MZ**2*(54*(1 - 2*sw**2 + 4*sw**4) + Ncol*(45 - 84*sw**2 + 88*sw**4))*reglogp(-(MU_R**2/(MZ**2 + vep*complex(0,1)))) - 4*cw**2*Ncol*(MZ**2*(9 - 24*sw**2 + 32*sw**4) + MT**2*(-9 - 48*sw**2 + 64*sw**4))*reglog((-MZ**2 - cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)) - 4*cw**2*Ncol*(MZ**2*(9 - 24*sw**2 + 32*sw**4) + MT**2*(-9 - 48*sw**2 + 64*sw**4))*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)) + (2*cw**2*Ncol*(MZ**2*(9 - 24*sw**2 + 32*sw**4) + MT**2*(-9 - 48*sw**2 + 64*sw**4))*(MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))))/MZ**2 + (2*cw**2*Ncol*(MZ**2*(9 - 24*sw**2 + 32*sw**4) + MT**2*(-9 - 48*sw**2 + 64*sw**4))*(MZ**2 - cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))*reglog((MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))/(-MZ**2 + cmath.sqrt(MZ**2*(-4*MT**2 + MZ**2 + vep*complex(0,4))))))/MZ**2 + 18*cw**2*(cw**4*(60*MW**2 + 39*MZ**2) + 2*cw**2*(-4*MW**2 + MZ**2)*sw**2 - (20*MW**2 + MZ**2)*sw**4)*reglog((-MZ**2 - cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)) + 18*cw**2*(cw**4*(60*MW**2 + 39*MZ**2) + 2*cw**2*(-4*MW**2 + MZ**2)*sw**2 - (20*MW**2 + MZ**2)*sw**4)*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(2.*MZ**2)) - (9*cw**2*(cw**4*(60*MW**2 + 39*MZ**2) + 2*cw**2*(-4*MW**2 + MZ**2)*sw**2 - (20*MW**2 + MZ**2)*sw**4)*(MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))*reglog((-MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))))/MZ**2 - (9*cw**2*(cw**4*(60*MW**2 + 39*MZ**2) + 2*cw**2*(-4*MW**2 + MZ**2)*sw**2 - (20*MW**2 + MZ**2)*sw**4)*(MZ**2 - cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))*reglog((MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))/(-MZ**2 + cmath.sqrt(MZ**2*(-4*MW**2 + MZ**2 + vep*complex(0,4))))))/MZ**2 + (9*(12*MW**2*MZ**2 + cw**2*(MH**4 - 4*MH**2*MZ**2))*(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))*reglog((MH**2 - 2*MZ**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))/(MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))))/MZ**4 - (9*(12*MW**2*MZ**2 + cw**2*(MH**4 - 4*MH**2*MZ**2))*(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))*reglog((-MH**2 + 2*MZ**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))/(-MH**2 + cmath.sqrt(MH**4 - 4*MH**2*MZ**2 + MZ**2*vep*complex(0,4)))))/MZ**4))/(3456.*cw**4*MZ**2*cmath.pi**2*sw**2)))/2.)'+'+'+dMB_CWCoup_UV_EW.value[0]},
                           texname = '\delta CW')

# ================================================ #
# QED UV parameters                                #
# Following UV parameters should be added if MB!=0 #
# ================================================ #

# ============== #
# Mixed QCD-QED  #
# ============== #

UV_yuk_c = CTParameter(name = 'UV_yuk_c',
                       type = 'real',
                       value = {-1:'-(1.0/2.0)*((G**2)/(16.0*cmath.pi**2))*3.0*CF*2.0',
                       0:'cond(MC,0.0,-(1.0/2.0)*((G**2)/(16.0*cmath.pi**2))*CF*(-3.0*reglog(MC**2/MU_R**2)+4.0)*2.0)'
                       },
                       texname = '\delta y_c')

UV_yuk_b = CTParameter(name = 'UV_yuk_b',
                       type = 'real',
                       value = {-1:'-(1.0/2.0)*((G**2)/(16.0*cmath.pi**2))*3.0*CF*2.0',
                       0:'cond(MB,0.0,-(1.0/2.0)*((G**2)/(16.0*cmath.pi**2))*CF*(-3.0*reglog(MB**2/MU_R**2)+4.0)*2.0)'
                       },
                       texname = '\delta y_b')

UV_yuk_t = CTParameter(name = 'UV_yuk_t',
                       type = 'real',
                       value = {-1:'-(1.0/2.0)*((G**2)/(16.0*cmath.pi**2))*3.0*CF*2.0',
                       0:'cond(MT,0.0,-(1.0/2.0)*((G**2)/(16.0*cmath.pi**2))*CF*(-3.0*reglog(MT**2/MU_R**2)+4.0)*2.0)'
                       },
                       texname = '\delta y_t')

