(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    527472,      12032]
NotebookOptionsPosition[    505408,      11358]
NotebookOutlinePosition[    506063,      11381]
CellTagsIndexPosition[    506020,      11378]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[Cell["topBSM", "Title",
  CellChangeTimes->{{3.576909642338835*^9, 3.5769096553571987`*^9}}]], "Input",\

 CellChangeTimes->{{3.576995731423401*^9, 3.576995734864747*^9}}],

Cell[CellGroupData[{

Cell["Initialization", "Subsubtitle",
 CellChangeTimes->{{3.5768444140363092`*^9, 3.576844436676321*^9}, {
  3.576908540598782*^9, 3.57690854318825*^9}, {3.57692409730613*^9, 
  3.576924098087501*^9}, {3.577001764223649*^9, 3.5770017658554983`*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.5770090402447157`*^9, 3.5770090410758057`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", "\"\</scratch/skrastanov/feynrules\>\"", "]"}]}], ";", 
  RowBox[{"<<", "FeynRules`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/topBSM\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<../SM/SM.fr\>\"", ",", " ", "\"\<topBSM.fr\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{"\"\<../SM/Cabibbo.rst\>\"", ",", "\"\<../SM/Massless.rst\>\""}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "False"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5757105960602818`*^9, 3.575710603935651*^9}, {
   3.57578243012792*^9, 3.5757824441106367`*^9}, {3.575782494158711*^9, 
   3.5757825305743513`*^9}, {3.575957845650674*^9, 3.575957871970462*^9}, {
   3.576316090315236*^9, 3.57631609268423*^9}, {3.576475823332283*^9, 
   3.5764758301727753`*^9}, {3.5769095727971373`*^9, 3.576909575548011*^9}, {
   3.576999343382819*^9, 3.576999345318432*^9}, 3.5783050745361757`*^9, {
   3.578306831719882*^9, 3.5783068386009197`*^9}, {3.5829801909785023`*^9, 
   3.582980197969267*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.583319474431493*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"1.7.178\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"28 May 2013\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "1.7.178", " (" "28 May 2013", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.5833194744328547`*^9}],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.583319474434108*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.5833194744352703`*^9}],

Cell[BoxData["\<\"Please cite: Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.583319474436522*^9}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.583319474437749*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.5833194744389257`*^9}],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.5833194744402113`*^9}],

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.5833194803093348`*^9}],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.583319480363839*^9}],

Cell[BoxData["\<\"McAuthor\"\>"], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.5833194803652163`*^9}],

Cell[BoxData["\<\"Poly Postdoc\"\>"], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.583319480366529*^9}],

Cell[BoxData["\<\"Dr Docky\"\>"], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.5833194803678427`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"0\"\>"}],
  SequenceForm["Model Version: ", "0"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.583319480369274*^9}],

Cell[BoxData["\<\"example.com\"\>"], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.583319480370592*^9}],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.5833194803794527`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.5833194803807898`*^9}],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.5833194803821707`*^9}],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.583319480567374*^9}],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.583319480622727*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"topBSM\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "topBSM", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.5833194807081423`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"../SM/Cabibbo.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{16., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "6"}],
  SequenceForm["Loading restrictions from ", "../SM/Cabibbo.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 6],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.583319481141243*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"../SM/Massless.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{16., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18"}],
  SequenceForm["Loading restrictions from ", "../SM/Massless.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.5833194813081284`*^9}],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{
  3.576921060608716*^9, 3.5769241118142033`*^9, {3.576924254519211*^9, 
   3.576924279377029*^9}, 3.576924314539659*^9, 3.5769243884840393`*^9, 
   3.576924606494104*^9, 3.576924876466647*^9, 3.576926229440332*^9, 
   3.576929368557392*^9, 3.576929784578537*^9, 3.57699575274131*^9, {
   3.576999334754154*^9, 3.5769993535665483`*^9}, 3.577000406341497*^9, 
   3.57700048049507*^9, 3.5770005284538918`*^9, 3.5770006843360977`*^9, 
   3.577001197294558*^9, 3.577001334535886*^9, 3.577004596270455*^9, 
   3.577005378978451*^9, 3.57700904532548*^9, 3.577009269826077*^9, 
   3.577011462107565*^9, 3.577165496570634*^9, {3.57717297562813*^9, 
   3.57717300132343*^9}, 3.577173218688097*^9, 3.5771732793314667`*^9, 
   3.577174274780031*^9, 3.577174387448155*^9, 3.577175040360053*^9, 
   3.577184061677867*^9, 3.577188798357963*^9, 3.577189600774597*^9, 
   3.577427258185413*^9, {3.5774278591370277`*^9, 3.577427877555851*^9}, 
   3.5774285276709642`*^9, 3.57743465395566*^9, 3.577437673011628*^9, 
   3.5774377044836197`*^9, 3.5777754356467123`*^9, 3.578134599259243*^9, 
   3.578134883078326*^9, {3.578134925820919*^9, 3.578134955687478*^9}, 
   3.5781350233767767`*^9, 3.578135122969839*^9, 3.578135213797826*^9, 
   3.578135254279922*^9, 3.5781353027568398`*^9, 3.57813596233011*^9, 
   3.5781360311263103`*^9, 3.578136393848377*^9, 3.578136442467016*^9, 
   3.578136645499117*^9, 3.5781403429409227`*^9, 3.578140397612409*^9, 
   3.5781406524700317`*^9, 3.578140742041177*^9, 3.578140988094077*^9, 
   3.578144325576377*^9, 3.578144792528865*^9, 3.578144823503563*^9, 
   3.57820330834361*^9, 3.578205681827704*^9, 3.5782059812246037`*^9, 
   3.578304122540851*^9, 3.578304176611801*^9, 3.578304222135399*^9, 
   3.578304265020756*^9, 3.5783043253315163`*^9, 3.5783046915652933`*^9, 
   3.578304733178646*^9, 3.578305080344287*^9, 3.578306771083302*^9, 
   3.5783068156387157`*^9, 3.5783068811353073`*^9, 3.5783069279790487`*^9, {
   3.578306958014578*^9, 3.578306980694296*^9}, 3.578307016248886*^9, 
   3.578307188816362*^9, 3.5783072713137693`*^9, 3.5783073249687243`*^9, 
   3.578307377600041*^9, 3.578310971463491*^9, 3.578311168813881*^9, 
   3.578311313356852*^9, 3.578375605372764*^9, 3.5783811304463873`*^9, 
   3.578381414106896*^9, 3.578383669401577*^9, 3.578657557209033*^9, 
   3.578657646967415*^9, 3.5786581682417803`*^9, 3.578658206813073*^9, {
   3.578658243011338*^9, 3.578658305589816*^9}, 3.578658375626298*^9, 
   3.5786588233470087`*^9, 3.578658957338928*^9, 3.57865908411287*^9, 
   3.57865917465403*^9, 3.578659225552744*^9, 3.5786600158231497`*^9, 
   3.578737906971922*^9, 3.5787384533556137`*^9, 3.578739100059568*^9, 
   3.578904112813568*^9, 3.578904198977916*^9, 3.578907137926094*^9, 
   3.578908627842637*^9, 3.578916834867568*^9, 3.578918274021546*^9, 
   3.5789183608640327`*^9, 3.579000970496759*^9, 3.579174317845963*^9, 
   3.579174405320025*^9, {3.579174893702989*^9, 3.579174914449615*^9}, 
   3.5791749461891623`*^9, 3.579248304787442*^9, 3.579248674048401*^9, 
   3.5792488621795263`*^9, 3.5795061917582808`*^9, 3.579506276382373*^9, 
   3.579598380977426*^9, 3.5795984155437193`*^9, 3.579598497558055*^9, 
   3.579598528623856*^9, 3.579600009428553*^9, 3.579600051188591*^9, 
   3.579608595576488*^9, 3.579609531589098*^9, 3.581072045931547*^9, 
   3.581076696956615*^9, 3.58115324185452*^9, 3.581155123534793*^9, 
   3.582980207251278*^9, 3.583042258498118*^9, 3.583223133407558*^9, 
   3.583231446022376*^9, {3.583231692439569*^9, 3.58323171204828*^9}, 
   3.5832318798434343`*^9, 3.5832344882293863`*^9, 3.583244934205217*^9, 
   3.583244989300933*^9, 3.583246415412347*^9, 3.583319481458433*^9}]
}, Open  ]]
}, Closed]],

Cell["\<\
When printing out results here we do not want all internal parameters to be \
expanded, so we define a few dummies to be used for the interactive work. Do \
_not_ use them for generating models.\
\>", "Text",
 CellChangeTimes->{{3.5781371199980173`*^9, 3.578137180368835*^9}}],

Cell[BoxData[
 RowBox[{"dummies", ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"s0fusionScalar", "\[Rule]", "s0fs"}], ",", 
    RowBox[{"s0fusionAxial", "\[Rule]", "s0fa"}], ",", 
    RowBox[{"o0fusionScalar", "\[Rule]", "o0fs"}], ",", 
    RowBox[{"o0fusionAxial", "\[Rule]", "o0fa"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.578137186436026*^9, 3.578137247492285*^9}, {
  3.578307444133318*^9, 3.578307456133444*^9}}],

Cell[TextData[StyleBox["It does not support FeynmanGauge", "Text"]], "Text",
 CellChangeTimes->{{3.576909821280615*^9, 3.576909859988627*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "False"}], ";"}]], "Input",
 CellChangeTimes->{{3.5769098465599403`*^9, 3.5769098545038424`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Technical problems with the model!\
\>", "Subsubtitle",
 CellChangeTimes->{{3.578134425767261*^9, 3.578134438465879*^9}, {
  3.578134534095989*^9, 3.5781345353288116`*^9}}],

Cell["\<\
When the model UFO files are generated, whether the scalar is light or heavy \
compared to the top is _hardcoded_. Do _not_ change the mass of the scalar \
from within MadGraph if it passes below/above twice the top mass. Change it \
in FeynRules and regenerate the model files.

The model will probably behave badly when the scalar mass is very near two \
times the top mass.\
\>", "Text",
 CellChangeTimes->{{3.578134446082402*^9, 3.578134528160145*^9}, {
  3.578136902992489*^9, 3.5781369387685966`*^9}, {3.578144666738386*^9, 
  3.578144694050115*^9}, {3.58332182604189*^9, 3.583321846968223*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Effective  couplings used for gluon fusion into heavy/light (pseudo)scalars\
\>", "Subsubtitle",
 CellChangeTimes->{{3.578137701980884*^9, 3.5781377428650103`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sertHeavy", "[", "t", "]"}]], "Input",
 CellChangeTimes->{{3.5781376619467287`*^9, 3.578137668755929*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["3", "2"], " ", "t", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{"t", "-", "1"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"log", "(", 
          FractionBox[
           RowBox[{
            SqrtBox[
             RowBox[{"1", "-", "t"}]], "+", "1"}], 
           RowBox[{"1", "-", 
            SqrtBox[
             RowBox[{"1", "-", "t"}]]}]], ")"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}], "2"]}]}], ")"}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.578137664464551*^9, 3.578137669441545*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sertLight", "[", "t", "]"}]], "Input",
 CellChangeTimes->{{3.578137672206565*^9, 3.578137676548595*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["3", "2"], " ", "t", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "t"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["sin", 
         RowBox[{"-", "1"}]], "(", 
        FractionBox["1", 
         SqrtBox["t"]], ")"}], "2"]}], "+", "1"}], ")"}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.578137677056595*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"serpHeavy", "[", "t", "]"}]], "Input",
 CellChangeTimes->{{3.578137679554677*^9, 3.5781376858913927`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "4"]}], " ", "t", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"log", "(", 
       FractionBox[
        RowBox[{
         SqrtBox[
          RowBox[{"1", "-", "t"}]], "+", "1"}], 
        RowBox[{"1", "-", 
         SqrtBox[
          RowBox[{"1", "-", "t"}]]}]], ")"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}], "2"]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.578137686864924*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"serpLight", "[", "t", "]"}]], "Input",
 CellChangeTimes->{{3.578137687954591*^9, 3.5781376954271812`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"t", " ", 
   SuperscriptBox[
    RowBox[{
     SuperscriptBox["sin", 
      RowBox[{"-", "1"}]], "(", 
     FractionBox["1", 
      SqrtBox["t"]], ")"}], "2"]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.578137695888454*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Spin 0, color singlet", "Subtitle",
 CellChangeTimes->{{3.5763186596886253`*^9, 3.576318674225849*^9}, {
  3.576318938377852*^9, 3.576318939322701*^9}, {3.577011473122003*^9, 
  3.577011473969521*^9}}],

Cell[CellGroupData[{

Cell[BoxData["S0"], "Input",
 CellChangeTimes->{{3.5774348670090933`*^9, 3.5774348674484453`*^9}}],

Cell[BoxData["S0"], "Output",
 CellChangeTimes->{3.577434868149713*^9}]
}, Open  ]],

Cell["\<\
Introducing a spin-0 singlet coupled only to the physical top.

The gluon fussion top loop is implemented as an effective operator in the \
lagrangian.

Two parameters are introduced: s0scalar and s0axial. Dependent on them are \
the s0fusionScalar and s0fusionAxial which contain the integrated top loop.\
\>", "Text",
 CellChangeTimes->{{3.5768445062707157`*^9, 3.576844620532359*^9}, {
  3.5768446505800323`*^9, 3.576844668820506*^9}, {3.5768447014925127`*^9, 
  3.57684471206841*^9}, {3.576845258132791*^9, 3.5768453245649548`*^9}, {
  3.576995784447092*^9, 3.576995811086684*^9}, {3.577775487674387*^9, 
  3.577775488153625*^9}, {3.577775536970112*^9, 3.577775546425754*^9}, {
  3.578137851728983*^9, 3.578137853488522*^9}}],

Cell[CellGroupData[{

Cell["Coupling to top", "Subsubtitle",
 CellChangeTimes->{{3.576318687232041*^9, 3.576318690406094*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LS0top"], "Input",
 CellChangeTimes->{{3.5757103517184887`*^9, 3.5757104886884623`*^9}, {
   3.5757108081282473`*^9, 3.5757108152953444`*^9}, {3.575710891937009*^9, 
   3.5757109206262283`*^9}, {3.5757109803684607`*^9, 
   3.5757109929593077`*^9}, {3.575711134048708*^9, 3.575711174928607*^9}, {
   3.575711313792768*^9, 3.575711347392899*^9}, 3.575714470876689*^9, {
   3.57571468348612*^9, 3.5757146844652147`*^9}, {3.575715511697496*^9, 
   3.575715519681115*^9}, {3.5757196297466307`*^9, 3.5757196418446293`*^9}, {
   3.5757198387392883`*^9, 3.5757198945146713`*^9}, {3.575719977410556*^9, 
   3.575720024834053*^9}, {3.5757201296829453`*^9, 3.575720136498171*^9}, {
   3.5757203834266644`*^9, 3.575720424434667*^9}, {3.57572045675422*^9, 
   3.575720466450326*^9}, {3.575720527250671*^9, 3.575720543939529*^9}, {
   3.575720802067177*^9, 3.575720824483234*^9}, {3.5757208623550167`*^9, 
   3.575720881491063*^9}, {3.575803447526205*^9, 3.575803457991686*^9}, {
   3.5758075625691957`*^9, 3.575807572745495*^9}, {3.575873104758226*^9, 
   3.575873107256053*^9}, {3.575953869093923*^9, 3.5759539224885893`*^9}, {
   3.576316116684032*^9, 3.576316122688367*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{"MT", " ", "S0", " ", 
     RowBox[{
      FormBox[
       OverscriptBox["t", "\<\"-\"\>"],
       TraditionalForm], ".", "t"}], " ", 
     FormBox[
      SubscriptBox["s0", "scalar"],
      TraditionalForm]}], "vev"], "+", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "MT", " ", "S0", " ", 
     FormBox[
      SubscriptBox["s0", "axial"],
      TraditionalForm], " ", 
     RowBox[{
      FormBox[
       OverscriptBox["t", "\<\"-\"\>"],
       TraditionalForm], ".", 
      FormBox[
       SuperscriptBox["\[Gamma]", "5"],
       TraditionalForm], ".", "t"}]}], "vev"]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.576316123748204*^9, 3.57631732865878*^9, 3.576321172927269*^9, 
   3.5764748491246*^9, 3.576475599703177*^9, 3.57647584864898*^9, 
   3.576838248131874*^9, {3.576838278180558*^9, 3.576838281357786*^9}, 
   3.576838924980031*^9, 3.576839063796001*^9, 3.576839110458744*^9, 
   3.576839421508849*^9, 3.576839511716107*^9, 3.5768403132406673`*^9, 
   3.576840466133134*^9, 3.576841906725453*^9, 3.576842234933474*^9, 
   3.5768429424863377`*^9, 3.576909918010613*^9, 3.576921168642881*^9, 
   3.576995762126313*^9, 3.576999363486916*^9, 3.577000538687789*^9, 
   3.5770013439840307`*^9, 3.5770017539957733`*^9, 3.577173286850161*^9, 
   3.577188809351915*^9, 3.578136451873348*^9, 3.57813665697759*^9, 
   3.578137365745411*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LS0top", ",", " ", 
   RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.57571861669071*^9, 3.5757186206385183`*^9}, {
   3.575720560719078*^9, 3.575720567406155*^9}, {3.5759568797261744`*^9, 
   3.575956943567664*^9}, {3.5759569991178017`*^9, 3.575957065070512*^9}, {
   3.575957166464693*^9, 3.575957215680324*^9}, {3.5759574338622293`*^9, 
   3.5759574385486727`*^9}, {3.575957905631774*^9, 3.575957935951001*^9}, {
   3.5763161360905848`*^9, 3.576316153809236*^9}, 3.576318957736636*^9, {
   3.576844727768158*^9, 3.576844736967598*^9}, {3.576845219031888*^9, 
   3.5768452289203444`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  StyleBox["\<\"Starting Feynman rule calculation.\"\>",
   StripOnInput->False,
   LineColor->RGBColor[1, 0.5, 0],
   FrontFaceColor->RGBColor[1, 0.5, 0],
   BackFaceColor->RGBColor[1, 0.5, 0],
   GraphicsColor->RGBColor[1, 0.5, 0],
   FontWeight->Bold,
   FontColor->RGBColor[1, 0.5, 0]], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.575957491003508*^9, 3.575957684265312*^9, {3.575957888156546*^9, 
   3.575957937876129*^9}, 3.575958091981783*^9, 3.575958214088179*^9, 
   3.575958889114544*^9, 3.57595899496387*^9, 3.575959124707939*^9, 
   3.575959700832821*^9, 3.575967136268403*^9, 3.576215822659492*^9, 
   3.576316154977828*^9, 3.576317382054942*^9, 3.5763212041768436`*^9, 
   3.5768382531501303`*^9, {3.576845223776215*^9, 3.5768452294619417`*^9}, 
   3.576909920481695*^9, 3.5769211703408413`*^9, 3.576999370281933*^9, 
   3.577000540213258*^9, 3.577001345693692*^9, 3.577173297269738*^9, 
   3.577188811749868*^9, 3.578136455495762*^9, 3.578137367531797*^9}],

Cell[BoxData[
 FormBox["\<\"Expanding the Lagrangian...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.575957491003508*^9, 3.575957684265312*^9, {3.575957888156546*^9, 
   3.575957937876129*^9}, 3.575958091981783*^9, 3.575958214088179*^9, 
   3.575958889114544*^9, 3.57595899496387*^9, 3.575959124707939*^9, 
   3.575959700832821*^9, 3.575967136268403*^9, 3.576215822659492*^9, 
   3.576316154977828*^9, 3.576317382054942*^9, 3.5763212041768436`*^9, 
   3.5768382531501303`*^9, {3.576845223776215*^9, 3.5768452294619417`*^9}, 
   3.576909920481695*^9, 3.5769211703408413`*^9, 3.576999370281933*^9, 
   3.577000540213258*^9, 3.577001345693692*^9, 3.577173297269738*^9, 
   3.577188811749868*^9, 3.578136455495762*^9, 3.578137367569886*^9}],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the vertex.\"\>",
   TraditionalForm]], "Print",
 CellChangeTimes->{
  3.575957491003508*^9, 3.575957684265312*^9, {3.575957888156546*^9, 
   3.575957937876129*^9}, 3.575958091981783*^9, 3.575958214088179*^9, 
   3.575958889114544*^9, 3.57595899496387*^9, 3.575959124707939*^9, 
   3.575959700832821*^9, 3.575967136268403*^9, 3.576215822659492*^9, 
   3.576316154977828*^9, 3.576317382054942*^9, 3.5763212041768436`*^9, 
   3.5768382531501303`*^9, {3.576845223776215*^9, 3.5768452294619417`*^9}, 
   3.576909920481695*^9, 3.5769211703408413`*^9, 3.576999370281933*^9, 
   3.577000540213258*^9, 3.577001345693692*^9, 3.577173297269738*^9, 
   3.577188811749868*^9, 3.578136455495762*^9, 3.578137367572854*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
   "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
    DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, TraditionalForm],
     ImageSizeCache->{6., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
    "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
   SequenceForm[
   1, " possible non-zero vertices have been found -> starting the \
computation: ", 
    Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.575957491003508*^9, 3.575957684265312*^9, {3.575957888156546*^9, 
   3.575957937876129*^9}, 3.575958091981783*^9, 3.575958214088179*^9, 
   3.575958889114544*^9, 3.57595899496387*^9, 3.575959124707939*^9, 
   3.575959700832821*^9, 3.575967136268403*^9, 3.576215822659492*^9, 
   3.576316154977828*^9, 3.576317382054942*^9, 3.5763212041768436`*^9, 
   3.5768382531501303`*^9, {3.576845223776215*^9, 3.5768452294619417`*^9}, 
   3.576909920481695*^9, 3.5769211703408413`*^9, 3.576999370281933*^9, 
   3.577000540213258*^9, 3.577001345693692*^9, 3.577173297269738*^9, 
   3.577188811749868*^9, 3.578136455495762*^9, 3.578137367575391*^9}],

Cell[BoxData[
 FormBox["\<\"1 vertex obtained.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.575957491003508*^9, 3.575957684265312*^9, {3.575957888156546*^9, 
   3.575957937876129*^9}, 3.575958091981783*^9, 3.575958214088179*^9, 
   3.575958889114544*^9, 3.57595899496387*^9, 3.575959124707939*^9, 
   3.575959700832821*^9, 3.575967136268403*^9, 3.576215822659492*^9, 
   3.576316154977828*^9, 3.576317382054942*^9, 3.5763212041768436`*^9, 
   3.5768382531501303`*^9, {3.576845223776215*^9, 3.5768452294619417`*^9}, 
   3.576909920481695*^9, 3.5769211703408413`*^9, 3.576999370281933*^9, 
   3.577000540213258*^9, 3.577001345693692*^9, 3.577173297269738*^9, 
   3.577188811749868*^9, 3.578136455495762*^9, 3.5781373675771523`*^9}]
}, Closed]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["t", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"t", "2"},
         {"S0", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "MT", " ", 
         FormBox[
          SubscriptBox["s0", "scalar"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], "vev"], "-", 
       FractionBox[
        RowBox[{"MT", " ", 
         FormBox[
          SubscriptBox["s0", "axial"],
          TraditionalForm], " ", 
         FormBox[
          SubsuperscriptBox["\[Gamma]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}], "5"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"m\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"m\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], "vev"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.57684522953555*^9, 3.576909920518743*^9, 
  3.576921170394147*^9, 3.576999370321013*^9, 3.577000540244905*^9, 
  3.5770013457261*^9, 3.577001738217383*^9, 3.577173297317974*^9, 
  3.577188811869732*^9, 3.578136455561207*^9, 3.5781373675808992`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Coupling to gluons (through a top loop)", "Subsubtitle",
 CellChangeTimes->{{3.576318687232041*^9, 3.576318725240529*^9}, {
  3.5768465205171947`*^9, 3.5768465221169167`*^9}}],

Cell["With the following effective parameters", "Text",
 CellChangeTimes->{{3.576909145215076*^9, 3.57690917954064*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definitions", "/.", 
  RowBox[{"(", 
   RowBox[{"s0fusionScalar", " ", "/.", " ", 
    RowBox[{"(", 
     RowBox[{"M$Parameters", "/.", 
      RowBox[{
       RowBox[{"Equal", "[", 
        RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"x", "->", "y"}], ")"}]}]}], ")"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.5769086659741497`*^9, 3.5769087491115427`*^9}, 
   3.576909112535284*^9, {3.577165324399412*^9, 3.577165351429234*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["s0", "fusionScalar"], "\[RuleDelayed]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"NumericalValue", "(", "MS0", ")"}], ">", 
       RowBox[{"2", " ", 
        RowBox[{"NumericalValue", "(", "MT", ")"}]}]}], ",", 
      FractionBox[
       RowBox[{
        SubsuperscriptBox["g", "s", "2"], " ", 
        SubscriptBox["s0", "scalar"], " ", 
        RowBox[{"sertHeavy", "(", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox[
            RowBox[{"2", " ", "MT"}], "MS0"], ")"}], "2"], ")"}]}], 
       RowBox[{"12", " ", 
        SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], ",", 
      FractionBox[
       RowBox[{
        SubsuperscriptBox["g", "s", "2"], " ", 
        SubscriptBox["s0", "scalar"], " ", 
        RowBox[{"sertLight", "(", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox[
            RowBox[{"2", " ", "MT"}], "MS0"], ")"}], "2"], ")"}]}], 
       RowBox[{"12", " ", 
        SuperscriptBox["\[Pi]", "2"], " ", "vev"}]]}], "]"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.576908749596757*^9, 3.576909114004822*^9, 3.576921179527534*^9, 
   3.5769993787309217`*^9, 3.577000546720379*^9, 3.577001356115144*^9, 
   3.577001733823744*^9, {3.577165329003004*^9, 3.57716535248153*^9}, 
   3.5781364664959373`*^9, 3.578136661681057*^9, {3.5795063325317183`*^9, 
   3.579506338165695*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definitions", "/.", 
  RowBox[{"(", 
   RowBox[{"s0fusionAxial", " ", "/.", " ", 
    RowBox[{"(", 
     RowBox[{"M$Parameters", "/.", 
      RowBox[{
       RowBox[{"Equal", "[", 
        RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"x", "->", "y"}], ")"}]}]}], ")"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.5769086659741497`*^9, 3.5769087491115427`*^9}, {
  3.576909112535284*^9, 3.576909138039616*^9}, {3.5769092211450033`*^9, 
  3.5769092453684473`*^9}, {3.57716536154286*^9, 3.5771653634933443`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["s0", "fusionAxial"], "\[RuleDelayed]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"NumericalValue", "(", "MS0", ")"}], ">", 
       RowBox[{"2", " ", 
        RowBox[{"NumericalValue", "(", "MT", ")"}]}]}], ",", 
      FractionBox[
       RowBox[{
        SubscriptBox["s0", "axial"], " ", 
        SubsuperscriptBox["g", "s", "2"], " ", 
        RowBox[{"serpHeavy", "(", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox[
            RowBox[{"2", " ", "MT"}], "MS0"], ")"}], "2"], ")"}]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], ",", 
      FractionBox[
       RowBox[{
        SubscriptBox["s0", "axial"], " ", 
        SubsuperscriptBox["g", "s", "2"], " ", 
        RowBox[{"serpLight", "(", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox[
            RowBox[{"2", " ", "MT"}], "MS0"], ")"}], "2"], ")"}]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["\[Pi]", "2"], " ", "vev"}]]}], "]"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.576909138493441*^9, {3.5769092272314157`*^9, 3.576909250852874*^9}, 
   3.576921181127459*^9, 3.576999384359323*^9, 3.5770005513604107`*^9, 
   3.577001361434181*^9, 3.577001730831819*^9, 3.5771653641602077`*^9, 
   3.578136518185392*^9, 3.578136664065669*^9, {3.579506341798462*^9, 
   3.579506347651203*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{
   RowBox[{"LS0ggfusionScalar", "/.", "dummies"}], ",", " ", 
   RowBox[{"ScreenOutput", "\[Rule]", "False"}], ",", " ", 
   RowBox[{"MaxParticles", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.576846415769596*^9, 3.576846477175753*^9}, {
   3.578136840432412*^9, 3.578136882520363*^9}, 3.578136971269651*^9, {
   3.578137076404581*^9, 3.578137096611326*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  StyleBox["\<\"Starting Feynman rule calculation.\"\>",
   StripOnInput->False,
   LineColor->RGBColor[1, 0.5, 0],
   FrontFaceColor->RGBColor[1, 0.5, 0],
   BackFaceColor->RGBColor[1, 0.5, 0],
   GraphicsColor->RGBColor[1, 0.5, 0],
   FontWeight->Bold,
   FontColor->RGBColor[1, 0.5, 0]], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.576846436478302*^9, 3.5768464780001297`*^9, 3.576909925354851*^9, 
   3.576921195825272*^9, 3.576999435942572*^9, 3.577000555528265*^9, 
   3.577001369440147*^9, 3.578136689176999*^9, {3.5781368641457148`*^9, 
   3.5781368867732353`*^9}, 3.578137209798716*^9, 3.578137252589466*^9, 
   3.578137391854391*^9}],

Cell[BoxData[
 FormBox["\<\"Expanding the Lagrangian...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.576846436478302*^9, 3.5768464780001297`*^9, 3.576909925354851*^9, 
   3.576921195825272*^9, 3.576999435942572*^9, 3.577000555528265*^9, 
   3.577001369440147*^9, 3.578136689176999*^9, {3.5781368641457148`*^9, 
   3.5781368867732353`*^9}, 3.578137209798716*^9, 3.578137252589466*^9, 
   3.578137391893444*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Neglecting all terms with more than \"\>", 
    "\[InvisibleSpace]", "\<\"3\"\>", 
    "\[InvisibleSpace]", "\<\" particles.\"\>"}],
   SequenceForm["Neglecting all terms with more than ", "3", " particles."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.576846436478302*^9, 3.5768464780001297`*^9, 3.576909925354851*^9, 
   3.576921195825272*^9, 3.576999435942572*^9, 3.577000555528265*^9, 
   3.577001369440147*^9, 3.578136689176999*^9, {3.5781368641457148`*^9, 
   3.5781368867732353`*^9}, 3.578137209798716*^9, 3.578137252589466*^9, 
   3.578137391989097*^9}],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the vertex.\"\>",
   TraditionalForm]], "Print",
 CellChangeTimes->{
  3.576846436478302*^9, 3.5768464780001297`*^9, 3.576909925354851*^9, 
   3.576921195825272*^9, 3.576999435942572*^9, 3.577000555528265*^9, 
   3.577001369440147*^9, 3.578136689176999*^9, {3.5781368641457148`*^9, 
   3.5781368867732353`*^9}, 3.578137209798716*^9, 3.578137252589466*^9, 
   3.578137391990802*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
   "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
    DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, TraditionalForm],
     ImageSizeCache->{6., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
    "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
   SequenceForm[
   1, " possible non-zero vertices have been found -> starting the \
computation: ", 
    Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.576846436478302*^9, 3.5768464780001297`*^9, 3.576909925354851*^9, 
   3.576921195825272*^9, 3.576999435942572*^9, 3.577000555528265*^9, 
   3.577001369440147*^9, 3.578136689176999*^9, {3.5781368641457148`*^9, 
   3.5781368867732353`*^9}, 3.578137209798716*^9, 3.578137252589466*^9, 
   3.578137391993469*^9}],

Cell[BoxData[
 FormBox["\<\"1 vertex obtained.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.576846436478302*^9, 3.5768464780001297`*^9, 3.576909925354851*^9, 
   3.576921195825272*^9, 3.576999435942572*^9, 3.577000555528265*^9, 
   3.577001369440147*^9, 3.578136689176999*^9, {3.5781368641457148`*^9, 
   3.5781368867732353`*^9}, 3.578137209798716*^9, 3.578137252589466*^9, 
   3.578137391995347*^9}]
}, Closed]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"G", "2"},
         {"S0", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", "s0fs", " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         RowBox[{
          SubscriptBox["\<\"p\"\>", "1"], ".", 
          SubscriptBox["\<\"p\"\>", "2"]}],
         TraditionalForm]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", "s0fs", " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "1", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "2"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "2", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "1"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.576846437652829*^9, 3.57684647809168*^9, 3.5769099254964743`*^9, 
   3.5769211959328127`*^9, 3.576999436097315*^9, 3.577000555652252*^9, 
   3.5770013695722237`*^9, 3.577001718950753*^9, 3.578136690031889*^9, {
   3.578136864311318*^9, 3.578136886920702*^9}, 3.578137210017687*^9, 
   3.578137252744005*^9, 3.578137391999443*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{
   RowBox[{"LS0ggfusionAxial", "/.", "dummies"}], ",", " ", 
   RowBox[{"ScreenOutput", "\[Rule]", "False"}], ",", " ", 
   RowBox[{"MaxParticles", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5768464932886887`*^9, 3.576846494055841*^9}, {
  3.5781369615894403`*^9, 3.578136975184288*^9}, {3.5781370632245083`*^9, 
  3.578137087635084*^9}, {3.578137258102076*^9, 3.578137259333209*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  StyleBox["\<\"Starting Feynman rule calculation.\"\>",
   StripOnInput->False,
   LineColor->RGBColor[1, 0.5, 0],
   FrontFaceColor->RGBColor[1, 0.5, 0],
   BackFaceColor->RGBColor[1, 0.5, 0],
   GraphicsColor->RGBColor[1, 0.5, 0],
   FontWeight->Bold,
   FontColor->RGBColor[1, 0.5, 0]], TraditionalForm]], "Print",
 CellChangeTimes->{3.5768464946235228`*^9, 3.576909927877137*^9, 
  3.576921201908342*^9, 3.576999438792468*^9, 3.577000563392887*^9, 
  3.577001371322928*^9, 3.5781367464180803`*^9, 3.578136975937731*^9, 
  3.578137067621958*^9, 3.57813722800391*^9, 3.578137260306508*^9}],

Cell[BoxData[
 FormBox["\<\"Expanding the Lagrangian...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5768464946235228`*^9, 3.576909927877137*^9, 
  3.576921201908342*^9, 3.576999438792468*^9, 3.577000563392887*^9, 
  3.577001371322928*^9, 3.5781367464180803`*^9, 3.578136975937731*^9, 
  3.578137067621958*^9, 3.57813722800391*^9, 3.5781372603340673`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Neglecting all terms with more than \"\>", 
    "\[InvisibleSpace]", "\<\"3\"\>", 
    "\[InvisibleSpace]", "\<\" particles.\"\>"}],
   SequenceForm["Neglecting all terms with more than ", "3", " particles."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5768464946235228`*^9, 3.576909927877137*^9, 
  3.576921201908342*^9, 3.576999438792468*^9, 3.577000563392887*^9, 
  3.577001371322928*^9, 3.5781367464180803`*^9, 3.578136975937731*^9, 
  3.578137067621958*^9, 3.57813722800391*^9, 3.578137260505682*^9}],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the vertex.\"\>",
   TraditionalForm]], "Print",
 CellChangeTimes->{3.5768464946235228`*^9, 3.576909927877137*^9, 
  3.576921201908342*^9, 3.576999438792468*^9, 3.577000563392887*^9, 
  3.577001371322928*^9, 3.5781367464180803`*^9, 3.578136975937731*^9, 
  3.578137067621958*^9, 3.57813722800391*^9, 3.578137260589157*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
   "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
    DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, TraditionalForm],
     ImageSizeCache->{6., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
    "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
   SequenceForm[
   1, " possible non-zero vertices have been found -> starting the \
computation: ", 
    Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5768464946235228`*^9, 3.576909927877137*^9, 
  3.576921201908342*^9, 3.576999438792468*^9, 3.577000563392887*^9, 
  3.577001371322928*^9, 3.5781367464180803`*^9, 3.578136975937731*^9, 
  3.578137067621958*^9, 3.57813722800391*^9, 3.57813726059202*^9}],

Cell[BoxData[
 FormBox["\<\"1 vertex obtained.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5768464946235228`*^9, 3.576909927877137*^9, 
  3.576921201908342*^9, 3.576999438792468*^9, 3.577000563392887*^9, 
  3.577001371322928*^9, 3.5781367464180803`*^9, 3.578136975937731*^9, 
  3.578137067621958*^9, 3.57813722800391*^9, 3.578137260678412*^9}]
}, Closed]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"G", "2"},
         {"S0", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{
        FractionBox["1", "8"], " ", "\[ImaginaryI]", " ", "s0fa", " ", 
        FormBox[
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox["\[Alpha]1",
            TraditionalForm], ",", 
           FormBox["\[Beta]1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "1", 
          FormBox["\[Beta]1",
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "2", 
          FormBox["\[Alpha]1",
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{
        FractionBox["1", "8"], " ", "\[ImaginaryI]", " ", "s0fa", " ", 
        FormBox[
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox["\[Alpha]1",
            TraditionalForm], ",", 
           FormBox["\[Delta]1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "1", 
          FormBox["\[Delta]1",
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "2", 
          FormBox["\[Alpha]1",
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{
        FractionBox["1", "8"], " ", "\[ImaginaryI]", " ", "s0fa", " ", 
        FormBox[
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox["\[Alpha]1",
            TraditionalForm], ",", 
           FormBox["\[Beta]1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "1", 
          FormBox["\[Alpha]1",
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "2", 
          FormBox["\[Beta]1",
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{
        FractionBox["1", "8"], " ", "\[ImaginaryI]", " ", "s0fa", " ", 
        FormBox[
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox["\[Gamma]1",
            TraditionalForm], ",", 
           FormBox["\[Beta]1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "1", 
          FormBox["\[Gamma]1",
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "2", 
          FormBox["\[Beta]1",
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{
        FractionBox["1", "8"], " ", "\[ImaginaryI]", " ", "s0fa", " ", 
        FormBox[
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox["\[Gamma]1",
            TraditionalForm], ",", 
           FormBox["\[Beta]1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "1", 
          FormBox["\[Beta]1",
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "2", 
          FormBox["\[Gamma]1",
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{
        FractionBox["1", "8"], " ", "\[ImaginaryI]", " ", "s0fa", " ", 
        FormBox[
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox["\[Gamma]1",
            TraditionalForm], ",", 
           FormBox["\[Delta]1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "1", 
          FormBox["\[Delta]1",
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "2", 
          FormBox["\[Gamma]1",
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{
        FractionBox["1", "8"], " ", "\[ImaginaryI]", " ", "s0fa", " ", 
        FormBox[
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox["\[Alpha]1",
            TraditionalForm], ",", 
           FormBox["\[Delta]1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "1", 
          FormBox["\[Alpha]1",
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "2", 
          FormBox["\[Delta]1",
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{
        FractionBox["1", "8"], " ", "\[ImaginaryI]", " ", "s0fa", " ", 
        FormBox[
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox["\[Gamma]1",
            TraditionalForm], ",", 
           FormBox["\[Delta]1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "1", 
          FormBox["\[Gamma]1",
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "2", 
          FormBox["\[Delta]1",
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.576846494930935*^9, 3.576909928176862*^9, 
  3.5769212022021008`*^9, 3.576999439193357*^9, 3.577000563792943*^9, 
  3.5770013717075853`*^9, 3.577001713117086*^9, 3.578136747315556*^9, 
  3.5781369763395348`*^9, 3.578137068014584*^9, 3.578137228315291*^9, 
  3.578137260690695*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Width of the resonance", "Subsubtitle",
 CellChangeTimes->{{3.576926002258409*^9, 3.576926036840067*^9}}],

Cell["\<\
The width of the resonance was calculated in FeynRules, but then hardcoded, \
because depending on the mass of the scalar its decay width is governed by \
different decays. The value was also checked numerically in MadGraph5.\
\>", "Text",
 CellChangeTimes->{{3.5769260408749847`*^9, 3.576926054056046*^9}, {
  3.576926178235866*^9, 3.576926190359894*^9}, {3.5769994470391483`*^9, 
  3.576999453695177*^9}, {3.5769996225751343`*^9, 3.5769996789756927`*^9}, {
  3.5770115235859127`*^9, 3.577011533218289*^9}, {3.578143572482514*^9, 
  3.5781435849298353`*^9}, {3.5781436164661427`*^9, 3.5781436173141813`*^9}, {
  3.5832343177354527`*^9, 3.5832343190309963`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definitions", "/.", 
  RowBox[{"(", 
   RowBox[{"WS0", "/.", 
    RowBox[{"(", 
     RowBox[{"M$Parameters", "/.", 
      RowBox[{
       RowBox[{"Equal", "[", 
        RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"x", "\[Rule]", "y"}], ")"}]}]}], ")"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.577000585187807*^9, 3.577000586384079*^9}, {
  3.577000860725183*^9, 3.577001031156968*^9}, {3.577001099301875*^9, 
  3.577001100130754*^9}, {3.577001379219845*^9, 3.577001428355833*^9}, {
  3.5771653866789017`*^9, 3.5771654069167233`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"WS0", "\[RuleDelayed]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"NumericalValue", "(", "MS0", ")"}], ">", 
       RowBox[{"2", " ", 
        RowBox[{"NumericalValue", "(", "MT", ")"}]}]}], ",", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["MS0", "3"], " ", 
         SuperscriptBox[
          TemplateBox[{SubscriptBox["s0", "fusionScalar"]},
           "Abs"], "2"]}], 
        RowBox[{"8", " ", "\[Pi]"}]], "+", 
       FractionBox[
        RowBox[{"3", " ", 
         SuperscriptBox["MT", "2"], " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["MS0", "4"], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["MS0", "2"], " ", 
            SuperscriptBox["MT", "2"]}]}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["MS0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["s0", "axial", "2"], "+", 
              SubsuperscriptBox["s0", "scalar", "2"]}], ")"}]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["MT", "2"], " ", 
            SubsuperscriptBox["s0", "scalar", "2"]}]}], ")"}]}], 
        RowBox[{"8", " ", "\[Pi]", " ", 
         SuperscriptBox["MS0", "3"], " ", 
         SuperscriptBox["vev", "2"]}]]}], ",", 
      FractionBox[
       RowBox[{
        SuperscriptBox["MS0", "3"], " ", 
        SuperscriptBox[
         TemplateBox[{SubscriptBox["s0", "fusionScalar"]},
          "Abs"], "2"]}], 
       RowBox[{"8", " ", "\[Pi]"}]]}], "]"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.578203330374555*^9, 3.578205996394471*^9, {3.578385369154684*^9, 
   3.578385378412673*^9}, {3.583231398786581*^9, 3.5832314058834743`*^9}, {
   3.583234497815926*^9, 3.5832345033159227`*^9}}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Spin 0, color octet", "Subtitle",
 CellChangeTimes->{{3.5763186596886253`*^9, 3.576318674225849*^9}, {
  3.576318938377852*^9, 3.576318939322701*^9}, {3.577011473122003*^9, 
  3.577011473969521*^9}, {3.577168373072678*^9, 3.577168374000292*^9}}],

Cell[CellGroupData[{

Cell[BoxData["O0"], "Input",
 CellChangeTimes->{{3.577434847304411*^9, 3.577434850680747*^9}}],

Cell[BoxData["O0"], "Output",
 CellChangeTimes->{3.577434851541717*^9}]
}, Open  ]],

Cell["\<\
Introducing a spin-0 color-octet coupled only to the physical top.

The kinetic term creating a gluon-gluon-scalar vertex is neglected.

The gluon fussion top loop is implemented as an effective operator in the \
lagrangian.

Two parameters are introduced: o0scalar and o0axial. Dependent on them are \
the o0fusionScalar and o0fusionAxial which contain the integrated top loop.\
\>", "Text",
 CellChangeTimes->{{3.5768445062707157`*^9, 3.576844620532359*^9}, {
  3.5768446505800323`*^9, 3.576844668820506*^9}, {3.5768447014925127`*^9, 
  3.57684471206841*^9}, {3.576845258132791*^9, 3.5768453245649548`*^9}, {
  3.576995784447092*^9, 3.576995811086684*^9}, {3.577175069154901*^9, 
  3.577175072754261*^9}, {3.577434750743391*^9, 3.5774347689026213`*^9}, {
  3.577434834342506*^9, 3.5774348426303864`*^9}, {3.578303664966322*^9, 
  3.578303690033896*^9}}],

Cell[CellGroupData[{

Cell["Coupling to top", "Subsubtitle",
 CellChangeTimes->{{3.576318687232041*^9, 3.576318690406094*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LO0top"], "Input",
 CellChangeTimes->{{3.577174285330597*^9, 3.577174288012072*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{"MT", " ", 
     SubscriptBox["O0", "a"], " ", 
     SubscriptBox["o0", "scalar"], " ", 
     RowBox[{
      OverscriptBox["t", "\<\"-\"\>"], ".", 
      SuperscriptBox["T", "a"], ".", "t"}]}], "vev"], "+", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "MT", " ", 
     SubscriptBox["O0", "a"], " ", 
     SubscriptBox["o0", "axial"], " ", 
     RowBox[{
      OverscriptBox["t", "\<\"-\"\>"], ".", 
      SuperscriptBox["T", "a"], ".", 
      SuperscriptBox["\[Gamma]", "5"], ".", "t"}]}], "vev"]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.5771742894426117`*^9, 3.577174398739113*^9, 3.577184030293065*^9, 
   3.57718407104521*^9, 3.5783073902037888`*^9, 3.578307479242729*^9, {
   3.578381266800846*^9, 3.578381271238566*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LO0top", ",", " ", 
   RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5771743109337482`*^9, 3.577174311380574*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.577174312701707*^9, 3.577184078132329*^9, 
  3.5783073968912373`*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.577174312701707*^9, 3.577184078132329*^9, 
  3.5783073969583397`*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.577174312701707*^9, 3.577184078132329*^9, 
  3.578307396960442*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{7., {0., 7.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.577174312701707*^9, 3.577184078132329*^9, 
  3.5783073969624968`*^9}],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->{3.577174312701707*^9, 3.577184078132329*^9, 
  3.578307396964003*^9}]
}, Closed]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["t", "\<\"-\"\>"], "1"},
         {"t", "2"},
         {"O0", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "MT", " ", 
         SubscriptBox["o0", "scalar"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}], 
          SubscriptBox["\<\"a\"\>", "3"]]}], "vev"], "-", 
       FractionBox[
        RowBox[{"MT", " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubsuperscriptBox["\[Gamma]", 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}], "5"], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}], 
          SubscriptBox["\<\"a\"\>", "3"]]}], "vev"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.577174312798154*^9, 3.577184078260206*^9, {3.57830739701258*^9, 
   3.578307402611945*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Coupling to gluons (through a top loop)", "Subsubtitle",
 CellChangeTimes->{{3.576318687232041*^9, 3.576318725240529*^9}, {
  3.5768465205171947`*^9, 3.5768465221169167`*^9}}],

Cell["With the following effective parameters", "Text",
 CellChangeTimes->{{3.576909145215076*^9, 3.57690917954064*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definitions", "/.", 
  RowBox[{"(", 
   RowBox[{"o0fusionScalar", " ", "/.", " ", 
    RowBox[{"(", 
     RowBox[{"M$Parameters", "/.", 
      RowBox[{
       RowBox[{"Equal", "[", 
        RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"x", "->", "y"}], ")"}]}]}], ")"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.5769086659741497`*^9, 3.5769087491115427`*^9}, 
   3.576909112535284*^9, {3.577165324399412*^9, 3.577165351429234*^9}, {
   3.5774350106986637`*^9, 3.577435010858741*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["o0", "fusionScalar"], "\[RuleDelayed]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"NumericalValue", "(", "MO0", ")"}], ">", 
       RowBox[{"2", " ", 
        RowBox[{"NumericalValue", "(", "MT", ")"}]}]}], ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "scalar"], " ", 
         RowBox[{"sertHeavy", "(", 
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox[
             RowBox[{"2", " ", "MT"}], "MO0"], ")"}], "2"], ")"}]}], 
        RowBox[{"12", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]]}], ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "scalar"], " ", 
         RowBox[{"sertLight", "(", 
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox[
             RowBox[{"2", " ", "MT"}], "MO0"], ")"}], "2"], ")"}]}], 
        RowBox[{"12", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]]}]}], "]"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.576908749596757*^9, 3.576909114004822*^9, 3.576921179527534*^9, 
   3.5769993787309217`*^9, 3.577000546720379*^9, 3.577001356115144*^9, 
   3.577001733823744*^9, {3.577165329003004*^9, 3.57716535248153*^9}, {
   3.5774350121316233`*^9, 3.5774350174422703`*^9}, 3.578307424676525*^9, 
   3.578307489895965*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definitions", "/.", 
  RowBox[{"(", 
   RowBox[{"o0fusionAxial", " ", "/.", " ", 
    RowBox[{"(", 
     RowBox[{"M$Parameters", "/.", 
      RowBox[{
       RowBox[{"Equal", "[", 
        RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"x", "->", "y"}], ")"}]}]}], ")"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.5769086659741497`*^9, 3.5769087491115427`*^9}, {
  3.576909112535284*^9, 3.576909138039616*^9}, {3.5769092211450033`*^9, 
  3.5769092453684473`*^9}, {3.57716536154286*^9, 3.5771653634933443`*^9}, {
  3.577435006586997*^9, 3.577435007098967*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["o0", "fusionAxial"], "\[RuleDelayed]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"NumericalValue", "(", "MO0", ")"}], ">", 
       RowBox[{"2", " ", 
        RowBox[{"NumericalValue", "(", "MT", ")"}]}]}], ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SubscriptBox["o0", "axial"], " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         RowBox[{"serpHeavy", "(", 
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox[
             RowBox[{"2", " ", "MT"}], "MO0"], ")"}], "2"], ")"}]}], 
        RowBox[{"8", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]]}], ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SubscriptBox["o0", "axial"], " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         RowBox[{"serpLight", "(", 
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox[
             RowBox[{"2", " ", "MT"}], "MO0"], ")"}], "2"], ")"}]}], 
        RowBox[{"8", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]]}]}], "]"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.576909138493441*^9, {3.5769092272314157`*^9, 3.576909250852874*^9}, 
   3.576921181127459*^9, 3.576999384359323*^9, 3.5770005513604107`*^9, 
   3.577001361434181*^9, 3.577001730831819*^9, 3.5771653641602077`*^9, {
   3.577435014124652*^9, 3.577435020641736*^9}, {3.5783074945480337`*^9, 
   3.578307498569057*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{
   RowBox[{"LO0ggfusionScalar", "/.", "dummies"}], ",", " ", 
   RowBox[{"ScreenOutput", "\[Rule]", "False"}], ",", " ", 
   RowBox[{"MaxParticles", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.576846415769596*^9, 3.576846477175753*^9}, {
  3.5774350460572357`*^9, 3.5774350468252983`*^9}, {3.5783075149174843`*^9, 
  3.578307526223881*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.576846436478302*^9, 3.5768464780001297`*^9, 
  3.576909925354851*^9, 3.576921195825272*^9, 3.576999435942572*^9, 
  3.577000555528265*^9, 3.577001369440147*^9, 3.577435047719418*^9, 
  3.578307527292119*^9, 3.57837557822195*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.576846436478302*^9, 3.5768464780001297`*^9, 
  3.576909925354851*^9, 3.576921195825272*^9, 3.576999435942572*^9, 
  3.577000555528265*^9, 3.577001369440147*^9, 3.577435047719418*^9, 
  3.578307527292119*^9, 3.57837557827789*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"3\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "3", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.576846436478302*^9, 3.5768464780001297`*^9, 
  3.576909925354851*^9, 3.576921195825272*^9, 3.576999435942572*^9, 
  3.577000555528265*^9, 3.577001369440147*^9, 3.577435047719418*^9, 
  3.578307527292119*^9, 3.578375578360487*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.576846436478302*^9, 3.5768464780001297`*^9, 
  3.576909925354851*^9, 3.576921195825272*^9, 3.576999435942572*^9, 
  3.577000555528265*^9, 3.577001369440147*^9, 3.577435047719418*^9, 
  3.578307527292119*^9, 3.578375578368021*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{7., {0., 7.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.576846436478302*^9, 3.5768464780001297`*^9, 
  3.576909925354851*^9, 3.576921195825272*^9, 3.576999435942572*^9, 
  3.577000555528265*^9, 3.577001369440147*^9, 3.577435047719418*^9, 
  3.578307527292119*^9, 3.5783755783702497`*^9}],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->{3.576846436478302*^9, 3.5768464780001297`*^9, 
  3.576909925354851*^9, 3.576921195825272*^9, 3.576999435942572*^9, 
  3.577000555528265*^9, 3.577001369440147*^9, 3.577435047719418*^9, 
  3.578307527292119*^9, 3.578375578452856*^9}]
}, Closed]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"G", "2"},
         {"O0", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", "o0fs", " ", 
        SubscriptBox["dSUN", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
        RowBox[{
         SubscriptBox["\<\"p\"\>", "1"], ".", 
         SubscriptBox["p", "2"]}]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", "o0fs", " ", 
        SubscriptBox["dSUN", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"]]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.576846437652829*^9, 3.57684647809168*^9, 3.5769099254964743`*^9, 
   3.5769211959328127`*^9, 3.576999436097315*^9, 3.577000555652252*^9, 
   3.5770013695722237`*^9, 3.577001718950753*^9, {3.5774350484868317`*^9, 
   3.577435052674008*^9}, 3.578307528042903*^9, {3.578375578456437*^9, 
   3.5783755912858543`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LO0ggfusionAxial", ",", " ", 
   RowBox[{"ScreenOutput", "\[Rule]", "False"}], ",", " ", 
   RowBox[{"MaxParticles", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5768464932886887`*^9, 3.576846494055841*^9}, {
  3.5774350578812428`*^9, 3.5774350585855427`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.5768464946235228`*^9, 3.576909927877137*^9, 
  3.576921201908342*^9, 3.576999438792468*^9, 3.577000563392887*^9, 
  3.577001371322928*^9, 3.57743505941088*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.5768464946235228`*^9, 3.576909927877137*^9, 
  3.576921201908342*^9, 3.576999438792468*^9, 3.577000563392887*^9, 
  3.577001371322928*^9, 3.5774350594259043`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"3\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "3", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5768464946235228`*^9, 3.576909927877137*^9, 
  3.576921201908342*^9, 3.576999438792468*^9, 3.577000563392887*^9, 
  3.577001371322928*^9, 3.577435060735322*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.5768464946235228`*^9, 3.576909927877137*^9, 
  3.576921201908342*^9, 3.576999438792468*^9, 3.577000563392887*^9, 
  3.577001371322928*^9, 3.5774350608175097`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{92., {2., 7.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5768464946235228`*^9, 3.576909927877137*^9, 
  3.576921201908342*^9, 3.576999438792468*^9, 3.577000563392887*^9, 
  3.577001371322928*^9, 3.577435060819861*^9}],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->{3.5768464946235228`*^9, 3.576909927877137*^9, 
  3.576921201908342*^9, 3.576999438792468*^9, 3.577000563392887*^9, 
  3.577001371322928*^9, 3.577435061930241*^9}]
}, Closed]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"G", "2"},
         {"O0", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Beta]1"], " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Alpha]1", ",", 
           "\[Beta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Alpha]1"]}], 
        RowBox[{"64", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["MO0", "2"], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Beta]1"], " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Alpha]1", ",", 
           "\[Beta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Alpha]1"]}], 
        RowBox[{"768", " ", 
         SuperscriptBox["MT", "2"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["MO0", "4"], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Beta]1"], " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Alpha]1", ",", 
           "\[Beta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Alpha]1"]}], 
        RowBox[{"5760", " ", 
         SuperscriptBox["MT", "4"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["MO0", "6"], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Beta]1"], " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Alpha]1", ",", 
           "\[Beta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Alpha]1"]}], 
        RowBox[{"35840", " ", 
         SuperscriptBox["MT", "6"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Delta]1"], " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Alpha]1", ",", 
           "\[Delta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Alpha]1"]}], 
        RowBox[{"64", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["MO0", "2"], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Delta]1"], " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Alpha]1", ",", 
           "\[Delta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Alpha]1"]}], 
        RowBox[{"768", " ", 
         SuperscriptBox["MT", "2"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["MO0", "4"], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Delta]1"], " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Alpha]1", ",", 
           "\[Delta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Alpha]1"]}], 
        RowBox[{"5760", " ", 
         SuperscriptBox["MT", "4"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["MO0", "6"], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Delta]1"], " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Alpha]1", ",", 
           "\[Delta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Alpha]1"]}], 
        RowBox[{"35840", " ", 
         SuperscriptBox["MT", "6"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Alpha]1", ",", 
           "\[Beta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Alpha]1"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Beta]1"]}], 
        RowBox[{"64", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Gamma]1", ",", 
           "\[Beta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Gamma]1"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Beta]1"]}], 
        RowBox[{"64", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SuperscriptBox["MO0", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Alpha]1", ",", 
           "\[Beta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Alpha]1"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Beta]1"]}], 
        RowBox[{"768", " ", 
         SuperscriptBox["MT", "2"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SuperscriptBox["MO0", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Gamma]1", ",", 
           "\[Beta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Gamma]1"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Beta]1"]}], 
        RowBox[{"768", " ", 
         SuperscriptBox["MT", "2"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SuperscriptBox["MO0", "4"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Alpha]1", ",", 
           "\[Beta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Alpha]1"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Beta]1"]}], 
        RowBox[{"5760", " ", 
         SuperscriptBox["MT", "4"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SuperscriptBox["MO0", "4"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Gamma]1", ",", 
           "\[Beta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Gamma]1"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Beta]1"]}], 
        RowBox[{"5760", " ", 
         SuperscriptBox["MT", "4"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SuperscriptBox["MO0", "6"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Alpha]1", ",", 
           "\[Beta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Alpha]1"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Beta]1"]}], 
        RowBox[{"35840", " ", 
         SuperscriptBox["MT", "6"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SuperscriptBox["MO0", "6"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Gamma]1", ",", 
           "\[Beta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Gamma]1"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Beta]1"]}], 
        RowBox[{"35840", " ", 
         SuperscriptBox["MT", "6"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Beta]1"], " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Gamma]1", ",", 
           "\[Beta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Gamma]1"]}], 
        RowBox[{"64", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["MO0", "2"], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Beta]1"], " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Gamma]1", ",", 
           "\[Beta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Gamma]1"]}], 
        RowBox[{"768", " ", 
         SuperscriptBox["MT", "2"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["MO0", "4"], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Beta]1"], " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Gamma]1", ",", 
           "\[Beta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Gamma]1"]}], 
        RowBox[{"5760", " ", 
         SuperscriptBox["MT", "4"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["MO0", "6"], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Beta]1"], " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Gamma]1", ",", 
           "\[Beta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Gamma]1"]}], 
        RowBox[{"35840", " ", 
         SuperscriptBox["MT", "6"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Delta]1"], " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Gamma]1", ",", 
           "\[Delta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Gamma]1"]}], 
        RowBox[{"64", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["MO0", "2"], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Delta]1"], " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Gamma]1", ",", 
           "\[Delta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Gamma]1"]}], 
        RowBox[{"768", " ", 
         SuperscriptBox["MT", "2"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["MO0", "4"], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Delta]1"], " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Gamma]1", ",", 
           "\[Delta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Gamma]1"]}], 
        RowBox[{"5760", " ", 
         SuperscriptBox["MT", "4"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["MO0", "6"], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Delta]1"], " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Gamma]1", ",", 
           "\[Delta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Gamma]1"]}], 
        RowBox[{"35840", " ", 
         SuperscriptBox["MT", "6"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Alpha]1", ",", 
           "\[Delta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Alpha]1"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Delta]1"]}], 
        RowBox[{"64", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Gamma]1", ",", 
           "\[Delta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Gamma]1"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Delta]1"]}], 
        RowBox[{"64", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SuperscriptBox["MO0", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Alpha]1", ",", 
           "\[Delta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Alpha]1"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Delta]1"]}], 
        RowBox[{"768", " ", 
         SuperscriptBox["MT", "2"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SuperscriptBox["MO0", "2"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Gamma]1", ",", 
           "\[Delta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Gamma]1"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Delta]1"]}], 
        RowBox[{"768", " ", 
         SuperscriptBox["MT", "2"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SuperscriptBox["MO0", "4"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Alpha]1", ",", 
           "\[Delta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Alpha]1"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Delta]1"]}], 
        RowBox[{"5760", " ", 
         SuperscriptBox["MT", "4"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SuperscriptBox["MO0", "4"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Gamma]1", ",", 
           "\[Delta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Gamma]1"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Delta]1"]}], 
        RowBox[{"5760", " ", 
         SuperscriptBox["MT", "4"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SuperscriptBox["MO0", "6"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Alpha]1", ",", 
           "\[Delta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Alpha]1"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Delta]1"]}], 
        RowBox[{"35840", " ", 
         SuperscriptBox["MT", "6"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubsuperscriptBox["g", "s", "2"], " ", 
         SuperscriptBox["MO0", "6"], " ", 
         SubscriptBox["o0", "axial"], " ", 
         SubscriptBox["\[Epsilon]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "\[Gamma]1", ",", 
           "\[Delta]1"}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "2", "\[Gamma]1"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"a\"\>", "1"], ",", 
           SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", "\[Delta]1"]}], 
        RowBox[{"35840", " ", 
         SuperscriptBox["MT", "6"], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "vev"}]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.576846494930935*^9, 3.576909928176862*^9, 3.5769212022021008`*^9, 
   3.576999439193357*^9, 3.577000563792943*^9, 3.5770013717075853`*^9, 
   3.577001713117086*^9, {3.577435062028213*^9, 3.577435075518983*^9}}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Spin 1, color singlet", "Subtitle",
 CellChangeTimes->{{3.5763186596886253`*^9, 3.576318674225849*^9}, {
  3.576318938377852*^9, 3.576318939322701*^9}, {3.577011473122003*^9, 
  3.577011473969521*^9}, {3.577168373072678*^9, 3.577168374000292*^9}, {
  3.578738682177874*^9, 3.578738688114422*^9}}],

Cell[CellGroupData[{

Cell[BoxData["S1"], "Input",
 CellChangeTimes->{{3.577434847304411*^9, 3.577434850680747*^9}, {
  3.5787386982923517`*^9, 3.5787386991404457`*^9}}],

Cell[BoxData["S1"], "Output",
 CellChangeTimes->{3.577434851541717*^9, 3.578738699895171*^9}]
}, Open  ]],

Cell["\<\
Introducing a spin-1 color-singlet coupled to all SM fermions with separate \
couplings for left and right particles.

Parameters for each coupling are introduced (s1er, s1el, s1ur, s1ul, s1dr, \
s1dl for respectively leptons, up-type quars and down-type quarks, \
respectively right and left, as well as s1nu for neutrinos). The generations \
are grouped together.

The width is externally fixed and not calculated.\
\>", "Text",
 CellChangeTimes->{{3.5768445062707157`*^9, 3.576844620532359*^9}, {
  3.5768446505800323`*^9, 3.576844668820506*^9}, {3.5768447014925127`*^9, 
  3.57684471206841*^9}, {3.576845258132791*^9, 3.5768453245649548`*^9}, {
  3.576995784447092*^9, 3.576995811086684*^9}, {3.577175069154901*^9, 
  3.577175072754261*^9}, {3.577434750743391*^9, 3.5774347689026213`*^9}, {
  3.577434834342506*^9, 3.5774348426303864`*^9}, {3.578303664966322*^9, 
  3.578303690033896*^9}, {3.5787387036177883`*^9, 3.578738791073983*^9}, {
  3.578738902466176*^9, 3.578738921458044*^9}, {3.578918519589651*^9, 
  3.578918675701339*^9}}],

Cell[CellGroupData[{

Cell["Coupling to charged leptons", "Subsubtitle",
 CellChangeTimes->{{3.576318687232041*^9, 3.576318690406094*^9}, {
  3.578738807698063*^9, 3.5787388154418373`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LS1er"], "Input",
 CellChangeTimes->{{3.577174285330597*^9, 3.577174288012072*^9}, {
  3.5787387951246767`*^9, 3.578738820213571*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{"e", " ", 
     SubscriptBox["s1", "er"], " ", 
     SubscriptBox["S1", "mu"], " ", 
     SubscriptBox["s", "w"], " ", 
     RowBox[{
      OverscriptBox["lR", "\<\"-\"\>"], ".", 
      SuperscriptBox["\[Gamma]", "mu"], ".", "lR"}]}], 
    SubscriptBox["c", "w"]]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.578907162370669*^9, 3.5789071683082123`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["LS1el"], "Input",
 CellChangeTimes->{{3.5787388236055183`*^9, 3.578738827177387*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["s1", "el"], " ", 
    SubscriptBox["S1", "mu"], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      SubsuperscriptBox["s", "w", "2"]}], ")"}], " ", 
    SubscriptBox["LL", 
     RowBox[{"sp2", ",", "2", ",", "ff"}]], " ", 
    SubscriptBox[
     OverscriptBox["LL", "\<\"-\"\>"], 
     RowBox[{"sp1", ",", "2", ",", "ff"}]], " ", 
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{"sp1", ",", "sp2"}], "mu"]}], 
   RowBox[{
    SubscriptBox["c", "w"], " ", 
    SubscriptBox["s", "w"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.578738827698213*^9, 3.578739033782812*^9, {3.578907173700502*^9, 
   3.578907179273725*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Coupling to neutrinos", "Subsubtitle",
 CellChangeTimes->{{3.576318687232041*^9, 3.576318690406094*^9}, {
  3.578738807698063*^9, 3.57873884429027*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LS1nu"], "Input",
 CellChangeTimes->{{3.577174285330597*^9, 3.577174288012072*^9}, {
  3.5787387951246767`*^9, 3.578738848708346*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{"e", " ", 
     SubscriptBox["S1", "mu"], " ", 
     SubscriptBox["s1", "v"], " ", 
     SubscriptBox["LL", 
      RowBox[{"sp2", ",", "1", ",", "ff"}]], " ", 
     SubscriptBox[
      OverscriptBox["LL", "\<\"-\"\>"], 
      RowBox[{"sp1", ",", "1", ",", "ff"}]], " ", 
     SubsuperscriptBox["\[Gamma]", 
      RowBox[{"sp1", ",", "sp2"}], "mu"]}], 
    RowBox[{"2", " ", 
     SubscriptBox["c", "w"], " ", 
     SubscriptBox["s", "w"]}]]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.5771742894426117`*^9, 3.577174398739113*^9, 3.577184030293065*^9, 
   3.57718407104521*^9, 3.5783073902037888`*^9, 3.578307479242729*^9, {
   3.578381266800846*^9, 3.578381271238566*^9}, {3.5787388210579453`*^9, 
   3.57873884957964*^9}, 3.578739031267293*^9, {3.5789071816194553`*^9, 
   3.5789071863485403`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Coupling to up quarks (all generations)\
\>", "Subsubtitle",
 CellChangeTimes->{{3.576318687232041*^9, 3.576318690406094*^9}, {
  3.578738807698063*^9, 3.5787388154418373`*^9}, {3.578738856785945*^9, 
  3.578738878449788*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LS1ur"], "Input",
 CellChangeTimes->{{3.577174285330597*^9, 3.577174288012072*^9}, {
  3.5787387951246767`*^9, 3.578738820213571*^9}, {3.578738881444738*^9, 
  3.57873888280406*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"2", " ", "e", " ", 
    SubscriptBox["S1", "mu"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["s1", "ur"], " ", 
    RowBox[{
     OverscriptBox["uR", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", "uR"}]}], 
   RowBox[{"3", " ", 
    SubscriptBox["c", "w"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.5771742894426117`*^9, 3.577174398739113*^9, 3.577184030293065*^9, 
   3.57718407104521*^9, 3.5783073902037888`*^9, 3.578307479242729*^9, {
   3.578381266800846*^9, 3.578381271238566*^9}, 3.5787388210579453`*^9, 
   3.578738883585939*^9, 3.578739028053281*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["LS1ul"], "Input",
 CellChangeTimes->{{3.5787388236055183`*^9, 3.578738827177387*^9}, {
  3.5787388857325583`*^9, 3.578738887220152*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["S1", "mu"], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}], "3"], "-", 
      FractionBox["1", "2"]}], ")"}], " ", 
    SubscriptBox["s1", "ul"], " ", 
    SubscriptBox["QL", 
     RowBox[{"sp2", ",", "1", ",", "ff", ",", "cc"}]], " ", 
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{"sp1", ",", "sp2"}], "mu"], " ", 
    SubscriptBox[
     OverscriptBox["QL", "\<\"-\"\>"], 
     RowBox[{"sp1", ",", "1", ",", "ff", ",", "cc"}]]}], 
   RowBox[{
    SubscriptBox["c", "w"], " ", 
    SubscriptBox["s", "w"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{3.578738827698213*^9, 3.578738889058331*^9, 
  3.57873902407981*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Coupling to down quarks (all generations)\
\>", "Subsubtitle",
 CellChangeTimes->{{3.576318687232041*^9, 3.576318690406094*^9}, {
  3.578738807698063*^9, 3.5787388154418373`*^9}, {3.578738856785945*^9, 
  3.578738878449788*^9}, {3.5791742799435787`*^9, 3.57917428101548*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LS1dr"], "Input",
 CellChangeTimes->{{3.577174285330597*^9, 3.577174288012072*^9}, {
  3.5787387951246767`*^9, 3.578738820213571*^9}, {3.578738881444738*^9, 
  3.57873888280406*^9}, {3.5787389268533792`*^9, 3.578738931508564*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{"e", " ", 
     SubscriptBox["s1", "dr"], " ", 
     SubscriptBox["S1", "mu"], " ", 
     SubscriptBox["s", "w"], " ", 
     RowBox[{
      OverscriptBox["dR", "\<\"-\"\>"], ".", 
      SuperscriptBox["\[Gamma]", "mu"], ".", "dR"}]}], 
    RowBox[{"3", " ", 
     SubscriptBox["c", "w"]}]]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.5771742894426117`*^9, 3.577174398739113*^9, 3.577184030293065*^9, 
   3.57718407104521*^9, 3.5783073902037888`*^9, 3.578307479242729*^9, {
   3.578381266800846*^9, 3.578381271238566*^9}, 3.5787388210579453`*^9, 
   3.578738883585939*^9, 3.578738932209981*^9, 3.5787390207183657`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["LS1dl"], "Input",
 CellChangeTimes->{{3.5787388236055183`*^9, 3.578738827177387*^9}, {
  3.5787388857325583`*^9, 3.578738887220152*^9}, {3.578738935364875*^9, 
  3.578738935476595*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["s1", "dl"], " ", 
    SubscriptBox["S1", "mu"], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox[
       SubsuperscriptBox["s", "w", "2"], "3"]}], ")"}], " ", 
    SubscriptBox["QL", 
     RowBox[{"sp2", ",", "2", ",", "ff", ",", "cc"}]], " ", 
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{"sp1", ",", "sp2"}], "mu"], " ", 
    SubscriptBox[
     OverscriptBox["QL", "\<\"-\"\>"], 
     RowBox[{"sp1", ",", "2", ",", "ff", ",", "cc"}]]}], 
   RowBox[{
    SubscriptBox["c", "w"], " ", 
    SubscriptBox["s", "w"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{3.578738827698213*^9, 3.578738889058331*^9, 
  3.578738936226221*^9, 3.5787390182001247`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vertices", "Subsubtitle",
 CellChangeTimes->{{3.576318687232041*^9, 3.576318690406094*^9}, {
  3.578738807698063*^9, 3.5787388154418373`*^9}, {3.578738856785945*^9, 
  3.578738878449788*^9}, {3.578738961794153*^9, 3.578738964385903*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LS1", ",", " ", 
   RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5771743109337482`*^9, 3.577174311380574*^9}, {
  3.578738967667603*^9, 3.57873896962145*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.577174312701707*^9, 3.577184078132329*^9, 
  3.5783073968912373`*^9, 3.5787389716238117`*^9, 3.578907193087538*^9, 
  3.5789086447443447`*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.577174312701707*^9, 3.577184078132329*^9, 
  3.5783073968912373`*^9, 3.5787389716238117`*^9, 3.578907193087538*^9, 
  3.5789086448171663`*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.577174312701707*^9, 3.577184078132329*^9, 
  3.5783073968912373`*^9, 3.5787389716238117`*^9, 3.578907193087538*^9, 
  3.578908644954262*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "4", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{9., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  4, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 4, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.577174312701707*^9, 3.577184078132329*^9, 
  3.5783073968912373`*^9, 3.5787389716238117`*^9, 3.578907193087538*^9, 
  3.5789086450355577`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[4, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.577174312701707*^9, 3.577184078132329*^9, 
  3.5783073968912373`*^9, 3.5787389716238117`*^9, 3.578907193087538*^9, 
  3.578908645169433*^9}]
}, Closed]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["vl", "\<\"-\"\>"], "1"},
         {"vl", "2"},
         {"S1", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s1", "v"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"], " ", 
        SubscriptBox["s", "w"]}]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["l", "\<\"-\"\>"], "1"},
         {"l", "2"},
         {"S1", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"e", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["s", "w"], " ", 
         SubscriptBox["s1", "el"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        SubscriptBox["c", "w"]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "e", " ", 
         SubscriptBox["s1", "el"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["c", "w"], " ", 
         SubscriptBox["s", "w"]}]], "+", 
       FractionBox[
        RowBox[{"e", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["s", "w"], " ", 
         SubscriptBox["s1", "er"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"+\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        SubscriptBox["c", "w"]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["uq", "\<\"-\"\>"], "1"},
         {"uq", "2"},
         {"S1", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"e", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["s1", "ul"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["c", "w"], " ", 
         SubscriptBox["s", "w"]}]], "-", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "e", " ", 
         SubscriptBox["s1", "ul"], " ", 
         SubscriptBox["s", "w"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"3", " ", 
         SubscriptBox["c", "w"]}]], "-", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "e", " ", 
         SubscriptBox["s1", "ur"], " ", 
         SubscriptBox["s", "w"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"+\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"3", " ", 
         SubscriptBox["c", "w"]}]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["dq", "\<\"-\"\>"], "1"},
         {"dq", "2"},
         {"S1", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"e", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["s", "w"], " ", 
         SubscriptBox["s1", "dl"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"3", " ", 
         SubscriptBox["c", "w"]}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "e", " ", 
         SubscriptBox["s1", "dl"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["c", "w"], " ", 
         SubscriptBox["s", "w"]}]], "+", 
       FractionBox[
        RowBox[{"e", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["s", "w"], " ", 
         SubscriptBox["s1", "dr"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"+\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"3", " ", 
         SubscriptBox["c", "w"]}]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.577174312798154*^9, 3.577184078260206*^9, {3.57830739701258*^9, 
   3.578307402611945*^9}, 3.578738972071248*^9, 3.578739014204702*^9, 
   3.5789071935279284`*^9, 3.578908537819581*^9, {3.5789086452487926`*^9, 
   3.5789086498895597`*^9}}]
}, Open  ]],

Cell["\<\
For comparison here are the Z vertices (given that 1/sin+1/cos=1/(sin*cos) \
they are the same):\
\>", "Text",
 CellChangeTimes->{{3.57890854226236*^9, 3.578908612339438*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LFermions", ",", 
   RowBox[{"MaxParticles", "\[Rule]", "3"}], ",", 
   RowBox[{"Contains", "\[Rule]", 
    RowBox[{"{", "Z", "}"}]}], ",", 
   RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.578908573128215*^9, 3.578908574966208*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.578908559772344*^9, 3.5789086589922028`*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.578908559772344*^9, 3.578908658993412*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expansion of indices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Expansion of indices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.578908559772344*^9, 3.5789086589959927`*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.578908559772344*^9, 3.578908659822255*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "4", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{9., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  4, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 4, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.578908559772344*^9, 3.578908659827345*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[4, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.578908559772344*^9, 3.578908660047572*^9}]
}, Closed]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["vl", "\<\"-\"\>"], "1"},
         {"vl", "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"e", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["s", "w"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["c", "w"]}]], "+", 
       FractionBox[
        RowBox[{"e", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["l", "\<\"-\"\>"], "1"},
         {"l", "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"e", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["s", "w"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["c", "w"]}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]], "+", 
       FractionBox[
        RowBox[{"e", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["s", "w"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"+\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        SubscriptBox["c", "w"]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["uq", "\<\"-\"\>"], "1"},
         {"uq", "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"e", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "e", " ", 
         SubscriptBox["s", "w"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"6", " ", 
         SubscriptBox["c", "w"]}]], "-", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "e", " ", 
         SubscriptBox["s", "w"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"+\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"3", " ", 
         SubscriptBox["c", "w"]}]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["dq", "\<\"-\"\>"], "1"},
         {"dq", "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "e", " ", 
          SubscriptBox["s", "w"], " ", 
          SubscriptBox["\[Delta]", 
           RowBox[{
            SubscriptBox["\<\"m\"\>", "1"], ",", 
            SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
          SubscriptBox["\[Delta]", 
           RowBox[{
            SubscriptBox["\<\"f\"\>", "1"], ",", 
            SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
          SubscriptBox[
           RowBox[{
            SuperscriptBox["\[Gamma]", 
             SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
            SubscriptBox["P", "\<\"-\"\>"]}], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]]}], 
         RowBox[{"6", " ", 
          SubscriptBox["c", "w"]}]]}], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]], "+", 
       FractionBox[
        RowBox[{"e", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["s", "w"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"+\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"3", " ", 
         SubscriptBox["c", "w"]}]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.5789085609322023`*^9, 3.578908566235079*^9}, {
  3.578908660120668*^9, 3.578908667077943*^9}}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Spin 1, color octet", "Subtitle",
 CellChangeTimes->{{3.5763186596886253`*^9, 3.576318674225849*^9}, {
  3.576318938377852*^9, 3.576318939322701*^9}, {3.577011473122003*^9, 
  3.577011473969521*^9}, {3.577168373072678*^9, 3.577168374000292*^9}, {
  3.578738682177874*^9, 3.578738688114422*^9}, {3.579001155398176*^9, 
  3.5790011561013927`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["O1"], "Input",
 CellChangeTimes->{{3.577434847304411*^9, 3.577434850680747*^9}, {
  3.5787386982923517`*^9, 3.5787386991404457`*^9}, {3.5790011339118147`*^9, 
  3.579001134983529*^9}}],

Cell[BoxData["O1"], "Output",
 CellChangeTimes->{3.577434851541717*^9, 3.578738699895171*^9, 
  3.579001135797367*^9}]
}, Open  ]],

Cell["\<\
Introducing a spin-1 color-octet coupled to all SM quarks with separate \
couplings for left and right particles.

Parameters for each coupling are introduced (s1er, s1el, s1ur, s1ul, s1dr, \
s1dl for respectively leptons, up-type quars and down-type quarks, \
respectively right and left, as well as s1nu for neutrinos). The generations \
are grouped together.\
\>", "Text",
 CellChangeTimes->{{3.5768445062707157`*^9, 3.576844620532359*^9}, {
  3.5768446505800323`*^9, 3.576844668820506*^9}, {3.5768447014925127`*^9, 
  3.57684471206841*^9}, {3.576845258132791*^9, 3.5768453245649548`*^9}, {
  3.576995784447092*^9, 3.576995811086684*^9}, {3.577175069154901*^9, 
  3.577175072754261*^9}, {3.577434750743391*^9, 3.5774347689026213`*^9}, {
  3.577434834342506*^9, 3.5774348426303864`*^9}, {3.578303664966322*^9, 
  3.578303690033896*^9}, {3.5787387036177883`*^9, 3.578738791073983*^9}, {
  3.578738902466176*^9, 3.578738921458044*^9}, {3.578918519589651*^9, 
  3.578918675701339*^9}, {3.579001130501616*^9, 3.579001152453539*^9}}],

Cell[CellGroupData[{

Cell["Coupling to up quarks (all generations)", "Subsubtitle",
 CellChangeTimes->{{3.576318687232041*^9, 3.576318690406094*^9}, {
  3.578738807698063*^9, 3.5787388154418373`*^9}, {3.578738856785945*^9, 
  3.578738878449788*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LO1ur"], "Input",
 CellChangeTimes->{{3.577174285330597*^9, 3.577174288012072*^9}, {
  3.5787387951246767`*^9, 3.578738820213571*^9}, {3.578738881444738*^9, 
  3.57873888280406*^9}, {3.57900110115941*^9, 3.5790011015276537`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["o1", "ur"], " ", 
   SubscriptBox["O1", 
    RowBox[{"mu", ",", "a"}]], " ", 
   RowBox[{
    OverscriptBox["uR", "\<\"-\"\>"], ".", 
    SuperscriptBox["T", "a"], ".", 
    SuperscriptBox["\[Gamma]", "mu"], ".", "uR"}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.5771742894426117`*^9, 3.577174398739113*^9, 3.577184030293065*^9, 
   3.57718407104521*^9, 3.5783073902037888`*^9, 3.578307479242729*^9, {
   3.578381266800846*^9, 3.578381271238566*^9}, 3.5787388210579453`*^9, 
   3.578738883585939*^9, 3.578739028053281*^9, {3.579001109605723*^9, 
   3.579001114380506*^9}, {3.579608647470107*^9, 3.5796086527514277`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["LO1ul"], "Input",
 CellChangeTimes->{{3.5787388236055183`*^9, 3.578738827177387*^9}, {
  3.5787388857325583`*^9, 3.578738887220152*^9}, {3.5790011058478937`*^9, 
  3.5790011062798977`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["o1", "ul"], " ", 
   SubscriptBox["O1", 
    RowBox[{"mu", ",", "a"}]], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc1", ",", "cc2"}], "a"], " ", 
   SubscriptBox["QL", 
    RowBox[{"sp2", ",", "1", ",", "ff", ",", "cc2"}]], " ", 
   SubsuperscriptBox["\[Gamma]", 
    RowBox[{"sp1", ",", "sp2"}], "mu"], " ", 
   SubscriptBox[
    OverscriptBox["QL", "\<\"-\"\>"], 
    RowBox[{"sp1", ",", "1", ",", "ff", ",", "cc1"}]]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.578738827698213*^9, 3.578738889058331*^9, 3.57873902407981*^9, {
   3.579001107285508*^9, 3.579001117094657*^9}, {3.5796086488937893`*^9, 
   3.579608656145741*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Coupling to down quarks (all generations)\
\>", "Subsubtitle",
 CellChangeTimes->{{3.576318687232041*^9, 3.576318690406094*^9}, {
  3.578738807698063*^9, 3.5787388154418373`*^9}, {3.578738856785945*^9, 
  3.578738878449788*^9}, {3.579174270536014*^9, 3.5791742717834673`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LO1dr"], "Input",
 CellChangeTimes->{{3.577174285330597*^9, 3.577174288012072*^9}, {
  3.5787387951246767`*^9, 3.578738820213571*^9}, {3.578738881444738*^9, 
  3.57873888280406*^9}, {3.5787389268533792`*^9, 3.578738931508564*^9}, {
  3.579001082214304*^9, 3.579001084183481*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["o1", "dr"], " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["O1", 
    RowBox[{"mu", ",", "a"}]], " ", 
   RowBox[{
    OverscriptBox["dR", "\<\"-\"\>"], ".", 
    SuperscriptBox["T", "a"], ".", 
    SuperscriptBox["\[Gamma]", "mu"], ".", "dR"}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.5771742894426117`*^9, 3.577174398739113*^9, 3.577184030293065*^9, 
   3.57718407104521*^9, 3.5783073902037888`*^9, 3.578307479242729*^9, {
   3.578381266800846*^9, 3.578381271238566*^9}, 3.5787388210579453`*^9, 
   3.578738883585939*^9, 3.578738932209981*^9, 3.5787390207183657`*^9, {
   3.579001085061694*^9, 3.579001093102803*^9}, {3.5796086592292833`*^9, 
   3.579608664081092*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["LO1dl"], "Input",
 CellChangeTimes->{{3.5787388236055183`*^9, 3.578738827177387*^9}, {
  3.5787388857325583`*^9, 3.578738887220152*^9}, {3.578738935364875*^9, 
  3.578738935476595*^9}, {3.579001086824051*^9, 3.579001087352049*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["o1", "dl"], " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["O1", 
    RowBox[{"mu", ",", "a"}]], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"cc1", ",", "cc2"}], "a"], " ", 
   SubscriptBox["QL", 
    RowBox[{"sp2", ",", "2", ",", "ff", ",", "cc2"}]], " ", 
   SubsuperscriptBox["\[Gamma]", 
    RowBox[{"sp1", ",", "sp2"}], "mu"], " ", 
   SubscriptBox[
    OverscriptBox["QL", "\<\"-\"\>"], 
    RowBox[{"sp1", ",", "2", ",", "ff", ",", "cc1"}]]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.578738827698213*^9, 3.578738889058331*^9, 3.578738936226221*^9, 
   3.5787390182001247`*^9, {3.579001088133975*^9, 3.579001096689641*^9}, {
   3.579608660189313*^9, 3.579608667434236*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vertices", "Subsubtitle",
 CellChangeTimes->{{3.576318687232041*^9, 3.576318690406094*^9}, {
  3.578738807698063*^9, 3.5787388154418373`*^9}, {3.578738856785945*^9, 
  3.578738878449788*^9}, {3.578738961794153*^9, 3.578738964385903*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LO1", ",", " ", 
   RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5771743109337482`*^9, 3.577174311380574*^9}, {
  3.578738967667603*^9, 3.57873896962145*^9}, {3.579001035226943*^9, 
  3.579001035736705*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.577174312701707*^9, 3.577184078132329*^9, 
  3.5783073968912373`*^9, 3.5787389716238117`*^9, 3.578907193087538*^9, 
  3.5789086447443447`*^9, 3.5790010367026663`*^9, 3.579608671738364*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.577174312701707*^9, 3.577184078132329*^9, 
  3.5783073968912373`*^9, 3.5787389716238117`*^9, 3.578907193087538*^9, 
  3.5789086447443447`*^9, 3.5790010367026663`*^9, 3.5796086717760067`*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.577174312701707*^9, 3.577184078132329*^9, 
  3.5783073968912373`*^9, 3.5787389716238117`*^9, 3.578907193087538*^9, 
  3.5789086447443447`*^9, 3.5790010367026663`*^9, 3.5796086718379517`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{8., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  2, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 2, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.577174312701707*^9, 3.577184078132329*^9, 
  3.5783073968912373`*^9, 3.5787389716238117`*^9, 3.578907193087538*^9, 
  3.5789086447443447`*^9, 3.5790010367026663`*^9, 3.579608671845755*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[2, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.577174312701707*^9, 3.577184078132329*^9, 
  3.5783073968912373`*^9, 3.5787389716238117`*^9, 3.578907193087538*^9, 
  3.5789086447443447`*^9, 3.5790010367026663`*^9, 3.579608671937813*^9}]
}, Closed]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["uq", "\<\"-\"\>"], "1"},
         {"uq", "2"},
         {"O1", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["o1", "ul"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubsuperscriptBox["T", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}], 
         SubscriptBox["\<\"a\"\>", "3"]]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["o1", "ur"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubsuperscriptBox["T", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}], 
         SubscriptBox["\<\"a\"\>", "3"]]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["dq", "\<\"-\"\>"], "1"},
         {"dq", "2"},
         {"O1", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["o1", "dl"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubsuperscriptBox["T", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}], 
         SubscriptBox["\<\"a\"\>", "3"]]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["o1", "dr"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubsuperscriptBox["T", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}], 
         SubscriptBox["\<\"a\"\>", "3"]]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.577174312798154*^9, 3.577184078260206*^9, {3.57830739701258*^9, 
   3.578307402611945*^9}, 3.578738972071248*^9, 3.578739014204702*^9, 
   3.5789071935279284`*^9, 3.578908537819581*^9, {3.5789086452487926`*^9, 
   3.5789086498895597`*^9}, {3.579001036893961*^9, 3.5790010418624887`*^9}, {
   3.579608671988668*^9, 3.579608678819571*^9}}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Generating UFO", "Subtitle",
 CellChangeTimes->{{3.5769095994290657`*^9, 3.5769096211567287`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DeleteDirectory", "[", 
   RowBox[{
    RowBox[{"$FeynRulesPath", "<>", "\"\</Models/topBSM/topBSM_UFO\>\""}], 
    ",", 
    RowBox[{"DeleteContents", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", "\[IndentingNewLine]", 
   RowBox[{
   "LGauge", ",", "\[IndentingNewLine]", "LHiggs", ",", "\[IndentingNewLine]",
     "LFermions", ",", "\[IndentingNewLine]", "LYukawa", ",", 
    "\[IndentingNewLine]", "LGhost", ",", "\[IndentingNewLine]", "LS0", ",", 
    "LO0", ",", "LS1", ",", "LO1", ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"S2", "[", 
       RowBox[{"mu", ",", "nu"}], "]"}], 
      RowBox[{"del", "[", 
       RowBox[{
        RowBox[{"uqbar", ".", 
         RowBox[{"Ga", "[", "nu", "]"}], ".", "uq"}], ",", "mu"}], "]"}]}], 
     "+", 
     RowBox[{
      RowBox[{"S2", "[", 
       RowBox[{"mu", ",", "nu"}], "]"}], " ", 
      RowBox[{"FS", "[", 
       RowBox[{"G", ",", "mu", ",", "rho", ",", "aaa"}], "]"}], " ", 
      RowBox[{"FS", "[", 
       RowBox[{"G", ",", "nu", ",", "rho", ",", "aaa"}], "]"}]}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"AddDecays", "\[Rule]", " ", "False"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DeleteDirectory", "[", 
   RowBox[{"\"\</scratch/skrastanov/mg5/models/topBSM_UFO\>\"", ",", 
    RowBox[{"DeleteContents", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CopyDirectory", "[", 
   RowBox[{
    RowBox[{"$FeynRulesPath", "<>", "\"\</Models/topBSM/topBSM_UFO\>\""}], 
    ",", " ", "\"\</scratch/skrastanov/mg5/models/topBSM_UFO\>\""}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.57690988685634*^9, 3.576909888760282*^9}, {
   3.5769176535473022`*^9, 3.576917660474906*^9}, {3.576917700651354*^9, 
   3.576917701594803*^9}, {3.5769992916361094`*^9, 3.576999294707532*^9}, {
   3.577001485380102*^9, 3.577001487507496*^9}, {3.5771655294596033`*^9, 
   3.577165531634631*^9}, {3.5771661097464533`*^9, 3.577166140006445*^9}, {
   3.577166182821739*^9, 3.577166209957836*^9}, {3.577166256085588*^9, 
   3.577166277974374*^9}, {3.577166330566298*^9, 3.577166350601408*^9}, {
   3.577166574363196*^9, 3.577166578716486*^9}, 3.577166622342843*^9, {
   3.578384632570266*^9, 3.5783846356256533`*^9}, {3.578659849307643*^9, 
   3.5786598512910767`*^9}, {3.579175518528586*^9, 3.579175522224704*^9}, {
   3.5829803642868147`*^9, 3.582980385950281*^9}, {3.5832464055712*^9, 
   3.5832464060199757`*^9}, {3.583319855617889*^9, 3.583319886833877*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319899035729*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319899294512*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.5833198992959967`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319899297271*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319900153119*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "8", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{9., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "8", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  8, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 8, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.58331990020759*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[8, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319901003923*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319901005525*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319901006782*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319901138495*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "6", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{9., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "6", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  6, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 6, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319901141436*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[6, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319901237509*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.5833199012970753`*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319901303823*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.58331990130518*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319902420011*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "18", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{9., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  18, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 18, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319902486619*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"13", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[13, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319903466501*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319903530675*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319903532077*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.5833199037303*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "3", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{9., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  3, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 3, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319903785268*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[3, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319903859865*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.5833199038614264`*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319903862747*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319903916218*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{9., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319903917953*^9}],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.5833199039199467`*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.5833199039213037`*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319903922597*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319906088135*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "4", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{9., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  4, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 4, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319906147888*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[4, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319914745257*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.5833199148128653`*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.5833199148143587`*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319918798656*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "4", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{9., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  4, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 4, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319918983045*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[4, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319934863063*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319934865183*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.58331993486655*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.58331993512037*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "4", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{9., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  4, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 4, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319935205585*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[4, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319935355506*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.58331993535756*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.5833199353589697`*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319935483459*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{9., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  2, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 2, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319935485257*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[2, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319935607464*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319935609356*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319935610751*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319935762847*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "4", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{9., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  4, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 4, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319935815529*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[4, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319937623239*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319938980987*^9}],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319944127348*^9}],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.5833199441856403`*^9}],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319945006302*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319945260106*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{16., {0., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "93", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 93, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319946647532*^9}],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319946932748*^9}],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{
  3.576909891981635*^9, 3.5769100258059797`*^9, 3.57691742061303*^9, 
   3.576917469973853*^9, 3.576917662664886*^9, 3.576917703734581*^9, 
   3.5769179442875147`*^9, 3.57691996947579*^9, 3.57692164821926*^9, {
   3.5769241261931133`*^9, 3.576924155043062*^9}, 3.576924323988607*^9, {
   3.576924398292897*^9, 3.576924420938908*^9}, 3.5769246199724083`*^9, 
   3.576924888730426*^9, 3.576926276786317*^9, 3.5769293796879473`*^9, 
   3.576929803521225*^9, 3.577001549655031*^9, 3.577011866186071*^9, 
   3.577166143464096*^9, {3.5771661968561687`*^9, 3.577166225544922*^9}, 
   3.5771663735501537`*^9, 3.577166581163175*^9, 3.578140413680502*^9, 
   3.5781406704549627`*^9, 3.578140762974176*^9, 3.578141000521132*^9, 
   3.578144337514853*^9, 3.5782060637851048`*^9, {3.578384620465341*^9, 
   3.578384638215139*^9}, 3.5783847177388153`*^9, 3.578659854436335*^9, 
   3.578660043515574*^9, 3.578737921028932*^9, 3.578738487452351*^9, 
   3.5787391250274563`*^9, 3.57890875247561*^9, 3.578918447175644*^9, {
   3.579175512952828*^9, 3.579175524599847*^9}, 3.579175626304579*^9, 
   3.579248322082686*^9, 3.579248688879595*^9, 3.579248883651945*^9, 
   3.5795063977930183`*^9, 3.57959949781769*^9, 3.579600067870562*^9, 
   3.5796095692421227`*^9, 3.581076714774959*^9, 3.582980393466264*^9, 
   3.583231906441511*^9, 3.583246453773172*^9, 3.583319947123435*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Addendum: The gluon fussion through a top loop", "Subtitle",
 CellChangeTimes->{{3.577188867418963*^9, 3.577188909940403*^9}, 
   3.577434596568234*^9}],

Cell["\<\
We will work out the details of the top loop for each of the scalars here. We \
will use FeynCalc. However as both FeynCalc and FeynRules polute the \
namespace with a great number of global variable we will do it in a separate \
notebook.\
\>", "Text",
 CellChangeTimes->{{3.577437420574812*^9, 3.577437493639023*^9}, {
  3.5774377991301527`*^9, 3.577437822151277*^9}, {3.577438602359129*^9, 
  3.577438654599126*^9}}],

Cell[CellGroupData[{

Cell["The vertices in the loop", "Subsubtitle",
 CellChangeTimes->{{3.577436091865487*^9, 3.57743612559056*^9}, {
  3.57743866379878*^9, 3.577438678023211*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LS0top"], "Input",
 CellChangeTimes->{{3.577436903497677*^9, 3.5774369079530363`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{"MT", " ", "S0", " ", 
     RowBox[{
      OverscriptBox["t", "\<\"-\"\>"], ".", "t"}], " ", 
     SubscriptBox["s0", "scalar"]}], "vev"], "+", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "MT", " ", "S0", " ", 
     SubscriptBox["s0", "axial"], " ", 
     RowBox[{
      OverscriptBox["t", "\<\"-\"\>"], ".", 
      SuperscriptBox["\[Gamma]", "5"], ".", "t"}]}], "vev"]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.577436908502611*^9, 3.577437064982656*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"FeynmanRules", "[", 
  RowBox[{
   RowBox[{"S0", " ", 
    RowBox[{"tbar", ".", "t"}]}], ",", " ", 
   RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"FeynmanRules", "[", 
  RowBox[{
   RowBox[{"I", " ", "S0", " ", 
    RowBox[{"tbar", ".", 
     RowBox[{"Ga", "[", "5", "]"}], ".", "t"}]}], ",", " ", 
   RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.577436563529793*^9, 3.577436567347454*^9}, {
  3.577436886441903*^9, 3.577436897321623*^9}, {3.577436927690117*^9, 
  3.5774370424449587`*^9}, {3.577437098716362*^9, 3.577437102055475*^9}, {
  3.5774371389718657`*^9, 3.5774371392756643`*^9}, {3.57743868954988*^9, 
  3.5774386940925217`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  StyleBox["\<\"Starting Feynman rule calculation.\"\>",
   StripOnInput->False,
   LineColor->RGBColor[1, 0.5, 0],
   FrontFaceColor->RGBColor[1, 0.5, 0],
   BackFaceColor->RGBColor[1, 0.5, 0],
   GraphicsColor->RGBColor[1, 0.5, 0],
   FontWeight->Bold,
   FontColor->RGBColor[1, 0.5, 0]], TraditionalForm]], "Print",
 CellChangeTimes->{{3.577437031096184*^9, 3.577437043016522*^9}, 
   3.577437103045848*^9, 3.57743713992177*^9, 3.5774386962267303`*^9}],

Cell[BoxData[
 FormBox["\<\"Expanding the Lagrangian...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.577437031096184*^9, 3.577437043016522*^9}, 
   3.577437103045848*^9, 3.57743713992177*^9, 3.57743869626859*^9}],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the vertex.\"\>",
   TraditionalForm]], "Print",
 CellChangeTimes->{{3.577437031096184*^9, 3.577437043016522*^9}, 
   3.577437103045848*^9, 3.57743713992177*^9, 3.577438696272663*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
   "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
    DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, TraditionalForm],
     ImageSizeCache->{6., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
    "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
   SequenceForm[
   1, " possible non-zero vertices have been found -> starting the \
computation: ", 
    Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.577437031096184*^9, 3.577437043016522*^9}, 
   3.577437103045848*^9, 3.57743713992177*^9, 3.577438696275209*^9}],

Cell[BoxData[
 FormBox["\<\"1 vertex obtained.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.577437031096184*^9, 3.577437043016522*^9}, 
   3.577437103045848*^9, 3.57743713992177*^9, 3.577438696276963*^9}]
}, Closed]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["t", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"t", "2"},
         {"S0", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"m\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"m\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.577437031183752*^9, 3.577437058068808*^9}, {
   3.577437103096621*^9, 3.577437145672617*^9}, 3.577438696280087*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  StyleBox["\<\"Starting Feynman rule calculation.\"\>",
   StripOnInput->False,
   LineColor->RGBColor[1, 0.5, 0],
   FrontFaceColor->RGBColor[1, 0.5, 0],
   BackFaceColor->RGBColor[1, 0.5, 0],
   GraphicsColor->RGBColor[1, 0.5, 0],
   FontWeight->Bold,
   FontColor->RGBColor[1, 0.5, 0]], TraditionalForm]], "Print",
 CellChangeTimes->{{3.577437031096184*^9, 3.577437043016522*^9}, 
   3.577437103045848*^9, 3.57743713992177*^9, 3.577438696281473*^9}],

Cell[BoxData[
 FormBox["\<\"Expanding the Lagrangian...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.577437031096184*^9, 3.577437043016522*^9}, 
   3.577437103045848*^9, 3.57743713992177*^9, 3.577438696282248*^9}],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the vertex.\"\>",
   TraditionalForm]], "Print",
 CellChangeTimes->{{3.577437031096184*^9, 3.577437043016522*^9}, 
   3.577437103045848*^9, 3.57743713992177*^9, 3.577438696283724*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
   "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
    DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, TraditionalForm],
     ImageSizeCache->{6., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
    "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
   SequenceForm[
   1, " possible non-zero vertices have been found -> starting the \
computation: ", 
    Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.577437031096184*^9, 3.577437043016522*^9}, 
   3.577437103045848*^9, 3.57743713992177*^9, 3.5774386962860327`*^9}],

Cell[BoxData[
 FormBox["\<\"1 vertex obtained.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.577437031096184*^9, 3.577437043016522*^9}, 
   3.577437103045848*^9, 3.57743713992177*^9, 3.577438696287752*^9}]
}, Closed]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["t", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"t", "2"},
         {"S0", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", 
        FormBox[
         SubsuperscriptBox["\[Gamma]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}], "5"],
         TraditionalForm]}], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"m\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"m\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.577437031183752*^9, 3.577437058068808*^9}, {
   3.577437103096621*^9, 3.577437145672617*^9}, 3.577438696290434*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LSM", ",", " ", 
   RowBox[{"Contains", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"uq", ",", " ", "uqbar", ",", " ", "G"}], "}"}]}], ",", " ", 
   RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.577436140219532*^9, 3.577436170202025*^9}, {
  3.577436222937742*^9, 3.577436283058028*^9}, {3.57743639503568*^9, 
  3.5774364490658903`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.577436235772636*^9, 3.5774362854183607`*^9}, 
   3.577436398917313*^9, {3.577436431468766*^9, 3.577436451249983*^9}}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.577436235772636*^9, 3.5774362854183607`*^9}, 
   3.577436398917313*^9, {3.577436431468766*^9, 3.577436451251114*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expansion of indices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Expansion of indices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.577436235772636*^9, 3.5774362854183607`*^9}, 
   3.577436398917313*^9, {3.577436431468766*^9, 3.577436451252626*^9}}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.577436235772636*^9, 3.5774362854183607`*^9}, 
   3.577436398917313*^9, {3.577436431468766*^9, 3.577436452964484*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{7., {0., 7.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.577436235772636*^9, 3.5774362854183607`*^9}, 
   3.577436398917313*^9, {3.577436431468766*^9, 3.5774364529668713`*^9}}],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->{{3.577436235772636*^9, 3.5774362854183607`*^9}, 
   3.577436398917313*^9, {3.577436431468766*^9, 3.577436453037846*^9}}]
}, Closed]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["uq", "\<\"-\"\>"], "1"},
         {"uq", "2"},
         {"G", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "s"], " ", 
       SubsuperscriptBox["\[Gamma]", 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}], 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}], 
        SubscriptBox["\<\"a\"\>", "3"]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.577436241656002*^9, 3.577436287729786*^9}, 
   3.57743640106925*^9, {3.5774364333231993`*^9, 3.5774364609983873`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The effective vertex", "Subsubtitle",
 CellChangeTimes->{{3.577438714873914*^9, 3.577438738087105*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{
   RowBox[{"S0", " ", 
    RowBox[{"FS", "[", 
     RowBox[{"G", ",", " ", "mu", ",", " ", "nu", ",", " ", "aa"}], "]"}], 
    " ", 
    RowBox[{"FS", "[", 
     RowBox[{"G", ",", " ", "mu", ",", " ", "nu", ",", " ", "aa"}], "]"}]}], 
   ",", " ", 
   RowBox[{"MaxParticles", "\[Rule]", "3"}], ",", " ", 
   RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.577434628324563*^9, 3.577434634040144*^9}, {
  3.577435921240918*^9, 3.577435979737751*^9}, {3.5774360114998417`*^9, 
  3.5774360187956123`*^9}, {3.577436614028335*^9, 3.577436618011897*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.5774359649055023`*^9, {3.5774359950779*^9, 3.577436019268713*^9}, 
   3.577436618815551*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.5774359649055023`*^9, {3.5774359950779*^9, 3.577436019268713*^9}, 
   3.5774366188430023`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"3\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "3", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5774359649055023`*^9, {3.5774359950779*^9, 3.577436019268713*^9}, 
   3.577436618915147*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.5774359649055023`*^9, {3.5774359950779*^9, 3.577436019268713*^9}, 
   3.577436618916609*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{7., {0., 7.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5774359649055023`*^9, {3.5774359950779*^9, 3.577436019268713*^9}, 
   3.57743661891868*^9}],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->{
  3.5774359649055023`*^9, {3.5774359950779*^9, 3.577436019268713*^9}, 
   3.577436618920261*^9}]
}, Closed]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"G", "2"},
         {"S0", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"4", " ", "\[ImaginaryI]", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"]}]]}], "-", 
       RowBox[{"4", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
        RowBox[{
         SubscriptBox["\<\"p\"\>", "1"], ".", 
         SubscriptBox["p", "2"]}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.577434635061796*^9, 3.577435964979323*^9, {3.577435995571294*^9, 
   3.577436024808703*^9}, {3.5774366189222813`*^9, 3.577436628951249*^9}}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Addendum: Calculating the widths", "Subtitle",
 CellChangeTimes->{{3.5770015670858307`*^9, 3.577001615471738*^9}, {
  3.577009421089899*^9, 3.577009421921103*^9}}],

Cell["For S0", "Text",
 CellChangeTimes->{{3.5791754426219273`*^9, 3.579175451816486*^9}}],

Cell[BoxData[
 RowBox[{"UpdateParameters", "[", 
  RowBox[{"s0axial", "\[Rule]", "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.583231325950224*^9, 3.583231340584877*^9}, {
  3.583232748809801*^9, 3.5832327492939053`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericalValue", "[", "WS0", "]"}]], "Input",
 CellChangeTimes->{{3.578918397273728*^9, 3.5789184069674177`*^9}}],

Cell[BoxData["14.985750688914285`"], "Output",
 CellChangeTimes->{
  3.578918407348998*^9, 3.579174965220076*^9, 3.5791751276539*^9, 
   3.5832313425384817`*^9, {3.583231472358139*^9, 3.583231481158032*^9}, 
   3.583231761606271*^9, 3.58323188823004*^9, 3.583231986534486*^9, 
   3.583232751014204*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"myverts", " ", "=", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{
     RowBox[{"LS0", "/.", "dummies"}], ",", " ", 
     RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myexpanded", " ", "=", " ", 
   RowBox[{"FlavorExpansion", "[", "myverts", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CalculateM2Decays", "[", "myexpanded", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mydecays", " ", "=", " ", 
  RowBox[{"ComputeDecays", "[", 
   RowBox[{"%", ",", " ", 
    RowBox[{"Simplify", "\[Rule]", "True"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.576998965860227*^9, 3.576999017553656*^9}, {
  3.5769990526799383`*^9, 3.576999054972035*^9}, {3.576999475688168*^9, 
  3.576999476051052*^9}, {3.577001655222089*^9, 3.577001667599221*^9}, {
  3.57701137739784*^9, 3.577011377653968*^9}, {3.578137294614687*^9, 
  3.578137299077929*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.576999019584539*^9, 3.576999056040906*^9, 3.576999476583143*^9, 
   3.577001668394505*^9, 3.5770046035159197`*^9, 3.577009425086978*^9, 
   3.577011563705009*^9, 3.578137033714571*^9, 3.578137299715431*^9, 
   3.578138886642433*^9, {3.5791749668497677`*^9, 3.579174987818643*^9}, 
   3.579175129030064*^9, {3.58323284012113*^9, 3.5832328613520327`*^9}}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.576999019584539*^9, 3.576999056040906*^9, 3.576999476583143*^9, 
   3.577001668394505*^9, 3.5770046035159197`*^9, 3.577009425086978*^9, 
   3.577011563705009*^9, 3.578137033714571*^9, 3.578137299715431*^9, 
   3.578138886642433*^9, {3.5791749668497677`*^9, 3.579174987818643*^9}, 
   3.579175129030064*^9, {3.58323284012113*^9, 3.58323286138828*^9}}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.576999019584539*^9, 3.576999056040906*^9, 3.576999476583143*^9, 
   3.577001668394505*^9, 3.5770046035159197`*^9, 3.577009425086978*^9, 
   3.577011563705009*^9, 3.578137033714571*^9, 3.578137299715431*^9, 
   3.578138886642433*^9, {3.5791749668497677`*^9, 3.579174987818643*^9}, 
   3.579175129030064*^9, {3.58323284012113*^9, 3.583232861675119*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "4", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{9., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  4, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 4, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576999019584539*^9, 3.576999056040906*^9, 3.576999476583143*^9, 
   3.577001668394505*^9, 3.5770046035159197`*^9, 3.577009425086978*^9, 
   3.577011563705009*^9, 3.578137033714571*^9, 3.578137299715431*^9, 
   3.578138886642433*^9, {3.5791749668497677`*^9, 3.579174987818643*^9}, 
   3.579175129030064*^9, {3.58323284012113*^9, 3.583232861726787*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[4, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576999019584539*^9, 3.576999056040906*^9, 3.576999476583143*^9, 
   3.577001668394505*^9, 3.5770046035159197`*^9, 3.577009425086978*^9, 
   3.577011563705009*^9, 3.578137033714571*^9, 3.578137299715431*^9, 
   3.578138886642433*^9, {3.5791749668497677`*^9, 3.579174987818643*^9}, 
   3.579175129030064*^9, {3.58323284012113*^9, 3.5832328626921673`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576999019584539*^9, 3.576999056040906*^9, 3.576999476583143*^9, 
   3.577001668394505*^9, 3.5770046035159197`*^9, 3.577009425086978*^9, 
   3.577011563705009*^9, 3.578137033714571*^9, 3.578137299715431*^9, 
   3.578138886642433*^9, {3.5791749668497677`*^9, 3.579174987818643*^9}, 
   3.579175129030064*^9, {3.58323284012113*^9, 3.58323286275844*^9}}],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.576999019584539*^9, 3.576999056040906*^9, 3.576999476583143*^9, 
   3.577001668394505*^9, 3.5770046035159197`*^9, 3.577009425086978*^9, 
   3.577011563705009*^9, 3.578137033714571*^9, 3.578137299715431*^9, 
   3.578138886642433*^9, {3.5791749668497677`*^9, 3.579174987818643*^9}, 
   3.579175129030064*^9, {3.58323284012113*^9, 3.583232863119185*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{8., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "2"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576999019584539*^9, 3.576999056040906*^9, 3.576999476583143*^9, 
   3.577001668394505*^9, 3.5770046035159197`*^9, 3.577009425086978*^9, 
   3.577011563705009*^9, 3.578137033714571*^9, 3.578137299715431*^9, 
   3.578138886642433*^9, {3.5791749668497677`*^9, 3.579174987818643*^9}, 
   3.579175129030064*^9, {3.58323284012113*^9, 3.5832328631213293`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"Computing all the partial 1->2 decay widths: \"\>",
    StripOnInput->False,
    LineColor->RGBColor[1, 0.5, 0],
    FrontFaceColor->RGBColor[1, 0.5, 0],
    BackFaceColor->RGBColor[1, 0.5, 0],
    GraphicsColor->RGBColor[1, 0.5, 0],
    FontWeight->Bold,
    FontColor->RGBColor[1, 0.5, 0]], "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$DecayCntb, StandardForm],
    ImageSizeCache->{8., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "2"}],
  SequenceForm[
   Style["Computing all the partial 1->2 decay widths: ", 
    RGBColor[1, 0.5, 0], Bold], 
   Dynamic[FeynRules`FR$DecayCntb], " / ", 2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.576999019584539*^9, 3.576999056040906*^9, 3.576999476583143*^9, 
   3.577001668394505*^9, 3.5770046035159197`*^9, 3.577009425086978*^9, 
   3.577011563705009*^9, 3.578137033714571*^9, 3.578137299715431*^9, 
   3.578138886642433*^9, {3.5791749668497677`*^9, 3.579174987818643*^9}, 
   3.579175129030064*^9, {3.58323284012113*^9, 3.583232863949643*^9}}]
}, Closed]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"{", 
       RowBox[{"S0", ",", "G", ",", "G"}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["MS0", "6"], " ", "s0fs", " ", 
        SuperscriptBox["s0fs", "\<\"*\"\>"]}], 
       RowBox[{"8", " ", "\[Pi]", " ", 
        SuperscriptBox[
         TemplateBox[{"MS0"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"S0", ",", "t", ",", 
        OverscriptBox["t", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{"3", " ", 
        SuperscriptBox["MT", "2"], " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["MS0", "4"], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["MS0", "2"], " ", 
           SuperscriptBox["MT", "2"]}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["MS0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["s0", "axial", "2"], "+", 
             SubsuperscriptBox["s0", "scalar", "2"]}], ")"}]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["MT", "2"], " ", 
           SubsuperscriptBox["s0", "scalar", "2"]}]}], ")"}]}], 
       RowBox[{"8", " ", "\[Pi]", " ", 
        SuperscriptBox["vev", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MS0"},
          "Abs"], "3"]}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.577011580803955*^9, 3.578137040257702*^9, 3.57813730239128*^9, {
   3.578138889230557*^9, 3.578138916488226*^9}, {3.579174967108127*^9, 
   3.579174997862258*^9}, 3.579175131605567*^9, 3.579175291781025*^9, {
   3.583232842829751*^9, 3.583232868250516*^9}}]
}, Open  ]],

Cell["For O0", "Text",
 CellChangeTimes->{{3.5791754426219273`*^9, 3.579175462856036*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericalValue", "[", "WO0", "]"}]], "Input",
 CellChangeTimes->{{3.578918397273728*^9, 3.578918421703477*^9}, {
  3.579175012342449*^9, 3.579175022466405*^9}}],

Cell[BoxData["2.4976251148190465`"], "Output",
 CellChangeTimes->{
  3.578918422133093*^9, 3.579175270519444*^9, {3.579509028489615*^9, 
   3.5795090499937*^9}, 3.579523381872311*^9, 3.579597136346609*^9, 
   3.5832313699739857`*^9, 3.583231494529172*^9, 3.583231765056147*^9, 
   3.583231894150034*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"myverts", " ", "=", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{
     RowBox[{"LO0", "/.", "dummies"}], ",", " ", 
     RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myexpanded", " ", "=", " ", 
   RowBox[{"FlavorExpansion", "[", "myverts", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CalculateM2Decays", "[", "myexpanded", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mydecays", " ", "=", " ", 
  RowBox[{"ComputeDecays", "[", 
   RowBox[{"%", ",", " ", 
    RowBox[{"Simplify", "\[Rule]", "True"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.576998965860227*^9, 3.576999017553656*^9}, {
  3.5769990526799383`*^9, 3.576999054972035*^9}, {3.576999475688168*^9, 
  3.576999476051052*^9}, {3.577001655222089*^9, 3.577001667599221*^9}, {
  3.57701137739784*^9, 3.577011377653968*^9}, {3.578137294614687*^9, 
  3.578137299077929*^9}, {3.578384384391281*^9, 3.578384384759079*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.578384385759063*^9, 3.57838440426084*^9}, 
   3.579175272057065*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.578384385759063*^9, 3.57838440426084*^9}, 
   3.5791752720824747`*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.578384385759063*^9, 3.57838440426084*^9}, 
   3.579175272518362*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "4", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{9., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  4, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 4, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.578384385759063*^9, 3.57838440426084*^9}, 
   3.579175272570116*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[4, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.578384385759063*^9, 3.57838440426084*^9}, 
   3.579175274400632*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.578384385759063*^9, 3.57838440426084*^9}, 
   3.579175274484627*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
    StripOnInput->False,
    LineColor->RGBColor[1, 0.5, 0],
    FrontFaceColor->RGBColor[1, 0.5, 0],
    BackFaceColor->RGBColor[1, 0.5, 0],
    GraphicsColor->RGBColor[1, 0.5, 0],
    FontWeight->Bold,
    FontColor->RGBColor[1, 0.5, 0]], "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{8., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "2"}],
  SequenceForm[
   Style["Computing the squared matrix elements relevant for the 1->2 decays: \
", 
    RGBColor[1, 0.5, 0], Bold], 
   Dynamic[FeynRules`FR$DecayCounter], " / ", 2],
  Editable->False]], "Print",
 CellChangeTimes->{{3.578384385759063*^9, 3.57838440426084*^9}, 
   3.579175274918192*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"Computing all the partial 1->2 decay widths: \"\>",
    StripOnInput->False,
    LineColor->RGBColor[1, 0.5, 0],
    FrontFaceColor->RGBColor[1, 0.5, 0],
    BackFaceColor->RGBColor[1, 0.5, 0],
    GraphicsColor->RGBColor[1, 0.5, 0],
    FontWeight->Bold,
    FontColor->RGBColor[1, 0.5, 0]], "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$DecayCntb, StandardForm],
    ImageSizeCache->{8., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "2"}],
  SequenceForm[
   Style["Computing all the partial 1->2 decay widths: ", 
    RGBColor[1, 0.5, 0], Bold], 
   Dynamic[FeynRules`FR$DecayCntb], " / ", 2],
  Editable->False]], "Print",
 CellChangeTimes->{{3.578384385759063*^9, 3.57838440426084*^9}, 
   3.579175275264614*^9}]
}, Closed]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Decay", "::", "Overwrite"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: Previous results will be overwritten.\"\>"}]], \
"Message", "MSG",
 CellChangeTimes->{3.579175275414173*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"{", 
       RowBox[{"O0", ",", "G", ",", "G"}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["MO0", "6"], " ", "o0fs", " ", 
        SuperscriptBox["o0fs", "\<\"*\"\>"], " ", 
        SubsuperscriptBox["dSUN", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"], ",", 
          SubscriptBox["\<\"a\"\>", "1"]}], "2"]}], 
       RowBox[{"512", " ", "\[Pi]", " ", 
        SuperscriptBox[
         TemplateBox[{"MO0"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"O0", ",", "t", ",", 
        OverscriptBox["t", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["MT", "2"], " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["MO0", "4"], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["MO0", "2"], " ", 
           SuperscriptBox["MT", "2"]}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["MO0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["o0", "axial", "2"], "+", 
             SubsuperscriptBox["o0", "scalar", "2"]}], ")"}]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["MT", "2"], " ", 
           SubsuperscriptBox["o0", "scalar", "2"]}]}], ")"}]}], 
       RowBox[{"16", " ", "\[Pi]", " ", 
        SuperscriptBox["vev", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MO0"},
          "Abs"], "3"]}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.5783843860514507`*^9, 3.578384407374316*^9}, 
   3.578384447468309*^9, {3.579175275416415*^9, 3.57917528560285*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Fold", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#1", "+", 
      RowBox[{"#2", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "&"}], ",", "0", ",", 
    RowBox[{"mydecays", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Abs", "[", "MO0", "]"}], "\[Rule]", "MO0"}], "}"}]}]}], "]"}],
   "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.579175038781498*^9, 3.579175089628989*^9}, {
  3.5791751463646507`*^9, 3.579175147917482*^9}, {3.579175202685326*^9, 
  3.579175250716889*^9}, {3.579175301997322*^9, 3.5791753047806168`*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["MO0", "6"], " ", "o0fs", " ", 
     SuperscriptBox["vev", "2"], " ", 
     SuperscriptBox["o0fs", "\<\"*\"\>"], " ", 
     SubsuperscriptBox["dSUN", 
      RowBox[{
       SubscriptBox["\<\"a\"\>", "2"], ",", 
       SubscriptBox["\<\"a\"\>", "3"], ",", 
       SubscriptBox["\<\"a\"\>", "1"]}], "2"]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["MT", "2"], " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["MO0", "4"], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["MO0", "2"], " ", 
        SuperscriptBox["MT", "2"]}]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["MO0", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubsuperscriptBox["o0", "axial", "2"], "+", 
          SubsuperscriptBox["o0", "scalar", "2"]}], ")"}]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["MT", "2"], " ", 
        SubsuperscriptBox["o0", "scalar", "2"]}]}], ")"}]}]}], 
   RowBox[{"512", " ", "\[Pi]", " ", 
    SuperscriptBox["MO0", "3"], " ", 
    SuperscriptBox["vev", "2"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.57917530579452*^9, 3.5791753128656073`*^9}}]
}, Open  ]],

Cell["For S1", "Text",
 CellChangeTimes->{{3.5791754426219273`*^9, 3.5791754697677803`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericalValue", "[", "WS1", "]"}]], "Input",
 CellChangeTimes->{{3.578918397273728*^9, 3.578918427479536*^9}}],

Cell[BoxData["58.981853821456596`"], "Output",
 CellChangeTimes->{
  3.578918427941093*^9, 3.5791753222154922`*^9, {3.5832314996838923`*^9, 
   3.5832315127900476`*^9}, 3.583231896805883*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"myverts", " ", "=", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{"LS1", ",", " ", 
     RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myexpanded", " ", "=", " ", 
   RowBox[{"FlavorExpansion", "[", "myverts", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CalculateM2Decays", "[", "myexpanded", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mydecays", " ", "=", " ", 
  RowBox[{"ComputeDecays", "[", 
   RowBox[{"%", ",", " ", 
    RowBox[{"Simplify", "\[Rule]", "True"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.576998965860227*^9, 3.576999017553656*^9}, {
  3.5769990526799383`*^9, 3.576999054972035*^9}, {3.576999475688168*^9, 
  3.576999476051052*^9}, {3.577001655222089*^9, 3.577001667599221*^9}, {
  3.57701137739784*^9, 3.577011377653968*^9}, {3.578137294614687*^9, 
  3.578137299077929*^9}, {3.578384384391281*^9, 3.578384384759079*^9}, {
  3.578915703514648*^9, 3.578915708666231*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.578915709550982*^9, 3.5789168542932568`*^9, 
  3.578918313495654*^9, 3.578918380089081*^9, 3.579174423219689*^9, 
  3.579175324181158*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.578915709550982*^9, 3.5789168542932568`*^9, 
  3.578918313495654*^9, 3.578918380089081*^9, 3.579174423219689*^9, 
  3.579175324213615*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.578915709550982*^9, 3.5789168542932568`*^9, 
  3.578918313495654*^9, 3.578918380089081*^9, 3.579174423219689*^9, 
  3.579175324391417*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "4", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{9., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  4, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 4, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.578915709550982*^9, 3.5789168542932568`*^9, 
  3.578918313495654*^9, 3.578918380089081*^9, 3.579174423219689*^9, 
  3.579175324394692*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[4, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.578915709550982*^9, 3.5789168542932568`*^9, 
  3.578918313495654*^9, 3.578918380089081*^9, 3.579174423219689*^9, 
  3.5791753246029377`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.578915709550982*^9, 3.5789168542932568`*^9, 
  3.578918313495654*^9, 3.578918380089081*^9, 3.579174423219689*^9, 
  3.579175324664475*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
    StripOnInput->False,
    LineColor->RGBColor[1, 0.5, 0],
    FrontFaceColor->RGBColor[1, 0.5, 0],
    BackFaceColor->RGBColor[1, 0.5, 0],
    GraphicsColor->RGBColor[1, 0.5, 0],
    FontWeight->Bold,
    FontColor->RGBColor[1, 0.5, 0]], "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{16., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "12"}],
  SequenceForm[
   Style["Computing the squared matrix elements relevant for the 1->2 decays: \
", 
    RGBColor[1, 0.5, 0], Bold], 
   Dynamic[FeynRules`FR$DecayCounter], " / ", 12],
  Editable->False]], "Print",
 CellChangeTimes->{3.578915709550982*^9, 3.5789168542932568`*^9, 
  3.578918313495654*^9, 3.578918380089081*^9, 3.579174423219689*^9, 
  3.579175325150971*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"Computing all the partial 1->2 decay widths: \"\>",
    StripOnInput->False,
    LineColor->RGBColor[1, 0.5, 0],
    FrontFaceColor->RGBColor[1, 0.5, 0],
    BackFaceColor->RGBColor[1, 0.5, 0],
    GraphicsColor->RGBColor[1, 0.5, 0],
    FontWeight->Bold,
    FontColor->RGBColor[1, 0.5, 0]], "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$DecayCntb, StandardForm],
    ImageSizeCache->{16., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "12"}],
  SequenceForm[
   Style["Computing all the partial 1->2 decay widths: ", 
    RGBColor[1, 0.5, 0], Bold], 
   Dynamic[FeynRules`FR$DecayCntb], " / ", 12],
  Editable->False]], "Print",
 CellChangeTimes->{3.578915709550982*^9, 3.5789168542932568`*^9, 
  3.578918313495654*^9, 3.578918380089081*^9, 3.579174423219689*^9, 
  3.5791753257104273`*^9}]
}, Closed]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Decay", "::", "Overwrite"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: Previous results will be overwritten.\"\>"}]], \
"Message", "MSG",
 CellChangeTimes->{3.5791753260507812`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"{", 
       RowBox[{"S1", ",", "d", ",", 
        OverscriptBox["d", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["MS1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SubsuperscriptBox["s1", "dr", "2"], " ", 
           SubsuperscriptBox["s", "w", "4"]}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"3", "-", 
              RowBox[{"2", " ", 
               SubsuperscriptBox["s", "w", "2"]}]}], ")"}], "2"], " ", 
           SubsuperscriptBox["s1", "dl", "2"]}]}], ")"}]}], 
       RowBox[{"288", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", "\[Pi]", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MS1"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"S1", ",", "s", ",", 
        OverscriptBox["s", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["MS1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SubsuperscriptBox["s1", "dr", "2"], " ", 
           SubsuperscriptBox["s", "w", "4"]}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"3", "-", 
              RowBox[{"2", " ", 
               SubsuperscriptBox["s", "w", "2"]}]}], ")"}], "2"], " ", 
           SubsuperscriptBox["s1", "dl", "2"]}]}], ")"}]}], 
       RowBox[{"288", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", "\[Pi]", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MS1"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"S1", ",", "b", ",", 
        OverscriptBox["b", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["e", "2"], " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["MS1", "4"], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["MB", "2"], " ", 
           SuperscriptBox["MS1", "2"]}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["MS1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SubsuperscriptBox["s1", "dr", "2"], " ", 
              SubsuperscriptBox["s", "w", "4"]}], "+", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"3", "-", 
                 RowBox[{"2", " ", 
                  SubsuperscriptBox["s", "w", "2"]}]}], ")"}], "2"], " ", 
              SubsuperscriptBox["s1", "dl", "2"]}]}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["MB", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SubsuperscriptBox["s1", "dr", "2"], " ", 
              SubsuperscriptBox["s", "w", "4"]}], "+", 
             RowBox[{"12", " ", 
              RowBox[{"(", 
               RowBox[{"3", "-", 
                RowBox[{"2", " ", 
                 SubsuperscriptBox["s", "w", "2"]}]}], ")"}], " ", 
              SubscriptBox["s1", "dl"], " ", 
              SubscriptBox["s1", "dr"], " ", 
              SubsuperscriptBox["s", "w", "2"]}], "+", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"3", "-", 
                 RowBox[{"2", " ", 
                  SubsuperscriptBox["s", "w", "2"]}]}], ")"}], "2"], " ", 
              SubsuperscriptBox["s1", "dl", "2"]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"288", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", "\[Pi]", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MS1"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"S1", ",", "e", ",", 
        OverscriptBox["e", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["MS1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SubsuperscriptBox["s1", "er", "2"], " ", 
           SubsuperscriptBox["s", "w", "4"]}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", " ", 
               SubsuperscriptBox["s", "w", "2"]}]}], ")"}], "2"], " ", 
           SubsuperscriptBox["s1", "el", "2"]}]}], ")"}]}], 
       RowBox[{"96", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", "\[Pi]", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MS1"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"S1", ",", "mu", ",", 
        OverscriptBox["mu", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["MS1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SubsuperscriptBox["s1", "er", "2"], " ", 
           SubsuperscriptBox["s", "w", "4"]}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", " ", 
               SubsuperscriptBox["s", "w", "2"]}]}], ")"}], "2"], " ", 
           SubsuperscriptBox["s1", "el", "2"]}]}], ")"}]}], 
       RowBox[{"96", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", "\[Pi]", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MS1"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"S1", ",", "ta", ",", 
        OverscriptBox["ta", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["e", "2"], " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["MS1", "4"], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["MS1", "2"], " ", 
           SuperscriptBox["MTA", "2"]}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["MS1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SubsuperscriptBox["s1", "er", "2"], " ", 
              SubsuperscriptBox["s", "w", "4"]}], "+", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 RowBox[{"2", " ", 
                  SubsuperscriptBox["s", "w", "2"]}]}], ")"}], "2"], " ", 
              SubsuperscriptBox["s1", "el", "2"]}]}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["MTA", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SubsuperscriptBox["s1", "er", "2"], " ", 
              SubsuperscriptBox["s", "w", "4"]}], "+", 
             RowBox[{"12", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"2", " ", 
                 SubsuperscriptBox["s", "w", "2"]}]}], ")"}], " ", 
              SubscriptBox["s1", "el"], " ", 
              SubscriptBox["s1", "er"], " ", 
              SubsuperscriptBox["s", "w", "2"]}], "+", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 RowBox[{"2", " ", 
                  SubsuperscriptBox["s", "w", "2"]}]}], ")"}], "2"], " ", 
              SubsuperscriptBox["s1", "el", "2"]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"96", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", "\[Pi]", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MS1"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"S1", ",", "u", ",", 
        OverscriptBox["u", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["MS1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SubsuperscriptBox["s1", "ur", "2"], " ", 
           SubsuperscriptBox["s", "w", "4"]}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"3", "-", 
              RowBox[{"4", " ", 
               SubsuperscriptBox["s", "w", "2"]}]}], ")"}], "2"], " ", 
           SubsuperscriptBox["s1", "ul", "2"]}]}], ")"}]}], 
       RowBox[{"288", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", "\[Pi]", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MS1"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"S1", ",", "c", ",", 
        OverscriptBox["c", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["MS1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SubsuperscriptBox["s1", "ur", "2"], " ", 
           SubsuperscriptBox["s", "w", "4"]}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"3", "-", 
              RowBox[{"4", " ", 
               SubsuperscriptBox["s", "w", "2"]}]}], ")"}], "2"], " ", 
           SubsuperscriptBox["s1", "ul", "2"]}]}], ")"}]}], 
       RowBox[{"288", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", "\[Pi]", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MS1"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"S1", ",", "t", ",", 
        OverscriptBox["t", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["e", "2"], " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["MS1", "4"], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["MS1", "2"], " ", 
           SuperscriptBox["MT", "2"]}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["MS1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"16", " ", 
              SubsuperscriptBox["s1", "ur", "2"], " ", 
              SubsuperscriptBox["s", "w", "4"]}], "+", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"3", "-", 
                 RowBox[{"4", " ", 
                  SubsuperscriptBox["s", "w", "2"]}]}], ")"}], "2"], " ", 
              SubsuperscriptBox["s1", "ul", "2"]}]}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["MT", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"16", " ", 
              SubsuperscriptBox["s1", "ur", "2"], " ", 
              SubsuperscriptBox["s", "w", "4"]}], "+", 
             RowBox[{"24", " ", 
              RowBox[{"(", 
               RowBox[{"3", "-", 
                RowBox[{"4", " ", 
                 SubsuperscriptBox["s", "w", "2"]}]}], ")"}], " ", 
              SubscriptBox["s1", "ul"], " ", 
              SubscriptBox["s1", "ur"], " ", 
              SubsuperscriptBox["s", "w", "2"]}], "+", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"3", "-", 
                 RowBox[{"4", " ", 
                  SubsuperscriptBox["s", "w", "2"]}]}], ")"}], "2"], " ", 
              SubsuperscriptBox["s1", "ul", "2"]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"288", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", "\[Pi]", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MS1"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"S1", ",", "ve", ",", 
        OverscriptBox["ve", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["MS1", "4"], " ", 
        SubsuperscriptBox["s1", "v", "2"]}], 
       RowBox[{"96", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", "\[Pi]", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MS1"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"S1", ",", "vm", ",", 
        OverscriptBox["vm", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["MS1", "4"], " ", 
        SubsuperscriptBox["s1", "v", "2"]}], 
       RowBox[{"96", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", "\[Pi]", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MS1"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"S1", ",", "vt", ",", 
        OverscriptBox["vt", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["MS1", "4"], " ", 
        SubsuperscriptBox["s1", "v", "2"]}], 
       RowBox[{"96", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", "\[Pi]", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MS1"},
          "Abs"], "3"]}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.5791753261235743`*^9, 3.579175332258438*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Fold", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#1", "+", 
      RowBox[{"#2", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "&"}], ",", "0", ",", 
    RowBox[{"mydecays", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Abs", "[", "MS1", "]"}], "\[Rule]", "MS1"}], "}"}]}]}], "]"}],
   "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.579175038781498*^9, 3.579175089628989*^9}, {
  3.5791751463646507`*^9, 3.579175147917482*^9}, {3.579175202685326*^9, 
  3.579175250716889*^9}, {3.5791753438690042`*^9, 3.579175345756125*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"288", " ", "\[Pi]", " ", 
     SuperscriptBox["MS1", "3"], " ", 
     SubsuperscriptBox["c", "w", "2"], " ", 
     SubsuperscriptBox["s", "w", "2"]}]], 
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SqrtBox[
        RowBox[{
         SuperscriptBox["MS1", "4"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["MB", "2"], " ", 
          SuperscriptBox["MS1", "2"]}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["MB", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"4", " ", 
              SubsuperscriptBox["s", "w", "4"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"6", " ", 
                  SubscriptBox["s1", "dl"], " ", 
                  SubscriptBox["s1", "dr"]}]}], "+", 
                SubsuperscriptBox["s1", "dl", "2"], "+", 
                SubsuperscriptBox["s1", "dr", "2"]}], ")"}]}]}], "+", 
            RowBox[{"12", " ", 
             SubscriptBox["s1", "dl"], " ", 
             SubsuperscriptBox["s", "w", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SubscriptBox["s1", "dl"], "-", 
               RowBox[{"3", " ", 
                SubscriptBox["s1", "dr"]}]}], ")"}]}], "-", 
            RowBox[{"9", " ", 
             SubsuperscriptBox["s1", "dl", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["MS1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SubsuperscriptBox["s1", "dl", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"3", "-", 
                RowBox[{"2", " ", 
                 SubsuperscriptBox["s", "w", "2"]}]}], ")"}], "2"]}], "+", 
            RowBox[{"4", " ", 
             SubsuperscriptBox["s1", "dr", "2"], " ", 
             SubsuperscriptBox["s", "w", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["MS1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubsuperscriptBox["s1", "dl", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"3", "-", 
             RowBox[{"2", " ", 
              SubsuperscriptBox["s", "w", "2"]}]}], ")"}], "2"]}], "+", 
         RowBox[{"4", " ", 
          SubsuperscriptBox["s1", "dr", "2"], " ", 
          SubsuperscriptBox["s", "w", "4"]}]}], ")"}]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["MS1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubsuperscriptBox["s1", "el", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"2", " ", 
              SubsuperscriptBox["s", "w", "2"]}]}], ")"}], "2"]}], "+", 
         RowBox[{"4", " ", 
          SubsuperscriptBox["s1", "er", "2"], " ", 
          SubsuperscriptBox["s", "w", "4"]}]}], ")"}]}], "+", 
      RowBox[{"3", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["MS1", "4"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["MS1", "2"], " ", 
          SuperscriptBox["MTA", "2"]}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["MS1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SubsuperscriptBox["s1", "el", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"2", " ", 
                 SubsuperscriptBox["s", "w", "2"]}]}], ")"}], "2"]}], "+", 
            RowBox[{"4", " ", 
             SubsuperscriptBox["s1", "er", "2"], " ", 
             SubsuperscriptBox["s", "w", "4"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["MTA", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SubsuperscriptBox["s", "w", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"6", " ", 
                 SubscriptBox["s1", "el"], " ", 
                 SubscriptBox["s1", "er"]}]}], "+", 
               SubsuperscriptBox["s1", "el", "2"], "+", 
               SubsuperscriptBox["s1", "er", "2"]}], ")"}]}], "-", 
            RowBox[{"4", " ", 
             SubscriptBox["s1", "el"], " ", 
             SubsuperscriptBox["s", "w", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SubscriptBox["s1", "el"], "-", 
               RowBox[{"3", " ", 
                SubscriptBox["s1", "er"]}]}], ")"}]}], "+", 
            SubsuperscriptBox["s1", "el", "2"]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["MS1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"3", "-", 
             RowBox[{"4", " ", 
              SubsuperscriptBox["s", "w", "2"]}]}], ")"}], "2"], " ", 
          SubsuperscriptBox["s1", "ul", "2"]}], "+", 
         RowBox[{"16", " ", 
          SubsuperscriptBox["s", "w", "4"], " ", 
          SubsuperscriptBox["s1", "ur", "2"]}]}], ")"}]}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["MS1", "4"], " ", 
       SubsuperscriptBox["s1", "v", "2"]}], "+", 
      RowBox[{
       SqrtBox[
        RowBox[{
         SuperscriptBox["MS1", "4"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["MS1", "2"], " ", 
          SuperscriptBox["MT", "2"]}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["MS1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"3", "-", 
                RowBox[{"4", " ", 
                 SubsuperscriptBox["s", "w", "2"]}]}], ")"}], "2"], " ", 
             SubsuperscriptBox["s1", "ul", "2"]}], "+", 
            RowBox[{"16", " ", 
             SubsuperscriptBox["s", "w", "4"], " ", 
             SubsuperscriptBox["s1", "ur", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["MT", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"16", " ", 
              SubsuperscriptBox["s", "w", "4"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"6", " ", 
                  SubscriptBox["s1", "ul"], " ", 
                  SubscriptBox["s1", "ur"]}]}], "+", 
                SubsuperscriptBox["s1", "ul", "2"], "+", 
                SubsuperscriptBox["s1", "ur", "2"]}], ")"}]}]}], "+", 
            RowBox[{"24", " ", 
             SubsuperscriptBox["s", "w", "2"], " ", 
             SubscriptBox["s1", "ul"], " ", 
             RowBox[{"(", 
              RowBox[{
               SubscriptBox["s1", "ul"], "-", 
               RowBox[{"3", " ", 
                SubscriptBox["s1", "ur"]}]}], ")"}]}], "-", 
            RowBox[{"9", " ", 
             SubsuperscriptBox["s1", "ul", "2"]}]}], ")"}]}]}], ")"}]}]}], 
     ")"}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.579175355273655*^9, 3.579175359715658*^9}}]
}, Open  ]],

Cell["For O1", "Text",
 CellChangeTimes->{{3.5791754426219273`*^9, 3.57917547898413*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericalValue", "[", "WO1", "]"}]], "Input",
 CellChangeTimes->{{3.578918397273728*^9, 3.578918427479536*^9}, {
   3.579174302873942*^9, 3.579174304666011*^9}, 3.580046277292117*^9, 
   3.5810765302087517`*^9, {3.582980263031994*^9, 3.582980311975606*^9}}],

Cell[BoxData["236.7869169356945`"], "Output",
 CellChangeTimes->{
  3.578918427941093*^9, 3.579175364557753*^9, 3.579608703752829*^9, 
   3.5796096181780643`*^9, 3.579851592076695*^9, {3.57985162591085*^9, 
   3.579851658235222*^9}, 3.581153278860764*^9, 3.5811551536427803`*^9, 
   3.581165444913165*^9, 3.582980234320545*^9, {3.582980275947204*^9, 
   3.582980312580525*^9}, 3.5830449077135572`*^9, 3.583045644785771*^9, 
   3.583231504962401*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"myverts", " ", "=", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{"LO1", ",", " ", 
     RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myexpanded", " ", "=", " ", 
   RowBox[{"FlavorExpansion", "[", "myverts", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CalculateM2Decays", "[", "myexpanded", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mydecays", " ", "=", " ", 
  RowBox[{"ComputeDecays", "[", 
   RowBox[{"%", ",", " ", 
    RowBox[{"Simplify", "\[Rule]", "True"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.576998965860227*^9, 3.576999017553656*^9}, {
  3.5769990526799383`*^9, 3.576999054972035*^9}, {3.576999475688168*^9, 
  3.576999476051052*^9}, {3.577001655222089*^9, 3.577001667599221*^9}, {
  3.57701137739784*^9, 3.577011377653968*^9}, {3.578137294614687*^9, 
  3.578137299077929*^9}, {3.578384384391281*^9, 3.578384384759079*^9}, {
  3.578915703514648*^9, 3.578915708666231*^9}, {3.579174309084853*^9, 
  3.579174309404623*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.5791743490578117`*^9, 3.579174633827922*^9, 
  3.5791753690856743`*^9, 3.5796087057595463`*^9, 3.581153298567444*^9, 
  3.5811551549841833`*^9, 3.5811654510228662`*^9, 3.583042550029442*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.5791743490578117`*^9, 3.579174633827922*^9, 
  3.5791753690856743`*^9, 3.5796087057595463`*^9, 3.581153298567444*^9, 
  3.5811551549841833`*^9, 3.5811654510228662`*^9, 3.583042550062992*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.5791743490578117`*^9, 3.579174633827922*^9, 
  3.5791753690856743`*^9, 3.5796087057595463`*^9, 3.581153298567444*^9, 
  3.5811551549841833`*^9, 3.5811654510228662`*^9, 3.583042550131133*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{8., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  2, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 2, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5791743490578117`*^9, 3.579174633827922*^9, 
  3.5791753690856743`*^9, 3.5796087057595463`*^9, 3.581153298567444*^9, 
  3.5811551549841833`*^9, 3.5811654510228662`*^9, 3.58304255013323*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[2, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5791743490578117`*^9, 3.579174633827922*^9, 
  3.5791753690856743`*^9, 3.5796087057595463`*^9, 3.581153298567444*^9, 
  3.5811551549841833`*^9, 3.5811654510228662`*^9, 3.583042550228244*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5791743490578117`*^9, 3.579174633827922*^9, 
  3.5791753690856743`*^9, 3.5796087057595463`*^9, 3.581153298567444*^9, 
  3.5811551549841833`*^9, 3.5811654510228662`*^9, 3.583042550304262*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.5791743490578117`*^9, 3.579174633827922*^9, 
  3.5791753690856743`*^9, 3.5796087057595463`*^9, 3.581153298567444*^9, 
  3.5811551549841833`*^9, 3.5811654510228662`*^9, 3.583042550599585*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{8., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "6"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 6],
  Editable->False]], "Print",
 CellChangeTimes->{3.5791743490578117`*^9, 3.579174633827922*^9, 
  3.5791753690856743`*^9, 3.5796087057595463`*^9, 3.581153298567444*^9, 
  3.5811551549841833`*^9, 3.5811654510228662`*^9, 3.5830425506015043`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"Computing all the partial 1->2 decay widths: \"\>",
    StripOnInput->False,
    LineColor->RGBColor[1, 0.5, 0],
    FrontFaceColor->RGBColor[1, 0.5, 0],
    BackFaceColor->RGBColor[1, 0.5, 0],
    GraphicsColor->RGBColor[1, 0.5, 0],
    FontWeight->Bold,
    FontColor->RGBColor[1, 0.5, 0]], "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$DecayCntb, StandardForm],
    ImageSizeCache->{8., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "6"}],
  SequenceForm[
   Style["Computing all the partial 1->2 decay widths: ", 
    RGBColor[1, 0.5, 0], Bold], 
   Dynamic[FeynRules`FR$DecayCntb], " / ", 6],
  Editable->False]], "Print",
 CellChangeTimes->{3.5791743490578117`*^9, 3.579174633827922*^9, 
  3.5791753690856743`*^9, 3.5796087057595463`*^9, 3.581153298567444*^9, 
  3.5811551549841833`*^9, 3.5811654510228662`*^9, 3.583042550776269*^9}]
}, Closed]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"{", 
       RowBox[{"O1", ",", "d", ",", 
        OverscriptBox["d", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["G", "2"], " ", 
        SuperscriptBox["MO1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubsuperscriptBox["o1", "dl", "2"], "+", 
          SubsuperscriptBox["o1", "dr", "2"]}], ")"}]}], 
       RowBox[{"48", " ", "\[Pi]", " ", 
        SuperscriptBox[
         TemplateBox[{"MO1"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"O1", ",", "s", ",", 
        OverscriptBox["s", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["G", "2"], " ", 
        SuperscriptBox["MO1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubsuperscriptBox["o1", "dl", "2"], "+", 
          SubsuperscriptBox["o1", "dr", "2"]}], ")"}]}], 
       RowBox[{"48", " ", "\[Pi]", " ", 
        SuperscriptBox[
         TemplateBox[{"MO1"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"O1", ",", "b", ",", 
        OverscriptBox["b", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["G", "2"], " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["MO1", "4"], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["MB", "2"], " ", 
           SuperscriptBox["MO1", "2"]}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["MO1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["o1", "dl", "2"], "+", 
             SubsuperscriptBox["o1", "dr", "2"]}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["MB", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["o1", "dl", "2"], "-", 
             RowBox[{"6", " ", 
              SubscriptBox["o1", "dr"], " ", 
              SubscriptBox["o1", "dl"]}], "+", 
             SubsuperscriptBox["o1", "dr", "2"]}], ")"}]}]}], ")"}]}], 
       RowBox[{"48", " ", "\[Pi]", " ", 
        SuperscriptBox[
         TemplateBox[{"MO1"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"O1", ",", "u", ",", 
        OverscriptBox["u", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["G", "2"], " ", 
        SuperscriptBox["MO1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubsuperscriptBox["o1", "ul", "2"], "+", 
          SubsuperscriptBox["o1", "ur", "2"]}], ")"}]}], 
       RowBox[{"48", " ", "\[Pi]", " ", 
        SuperscriptBox[
         TemplateBox[{"MO1"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"O1", ",", "c", ",", 
        OverscriptBox["c", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["G", "2"], " ", 
        SuperscriptBox["MO1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubsuperscriptBox["o1", "ul", "2"], "+", 
          SubsuperscriptBox["o1", "ur", "2"]}], ")"}]}], 
       RowBox[{"48", " ", "\[Pi]", " ", 
        SuperscriptBox[
         TemplateBox[{"MO1"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"O1", ",", "t", ",", 
        OverscriptBox["t", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["G", "2"], " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["MO1", "4"], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["MO1", "2"], " ", 
           SuperscriptBox["MT", "2"]}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["MO1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["o1", "ul", "2"], "+", 
             SubsuperscriptBox["o1", "ur", "2"]}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["MT", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["o1", "ul", "2"], "-", 
             RowBox[{"6", " ", 
              SubscriptBox["o1", "ur"], " ", 
              SubscriptBox["o1", "ul"]}], "+", 
             SubsuperscriptBox["o1", "ur", "2"]}], ")"}]}]}], ")"}]}], 
       RowBox[{"48", " ", "\[Pi]", " ", 
        SuperscriptBox[
         TemplateBox[{"MO1"},
          "Abs"], "3"]}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.579174349885922*^9, 3.5791743561662416`*^9}, 
   3.5791746346666727`*^9, {3.579175369961651*^9, 3.579175376321494*^9}, {
   3.57960870663052*^9, 3.579608715998344*^9}, 3.5811532999810467`*^9, 
   3.581153458262947*^9, {3.581155155748599*^9, 3.5811551621843643`*^9}, 
   3.58116545195166*^9, 3.581166662346054*^9, {3.583042550884763*^9, 
   3.583042556682448*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Fold", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#1", "+", 
      RowBox[{"#2", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "&"}], ",", "0", ",", 
    RowBox[{"mydecays", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Abs", "[", "MO1", "]"}], "\[Rule]", "MO1"}], "}"}]}]}], "]"}],
   "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.579175038781498*^9, 3.579175089628989*^9}, {
   3.5791751463646507`*^9, 3.579175147917482*^9}, {3.579175202685326*^9, 
   3.579175250716889*^9}, {3.5791753849401093`*^9, 3.579175389148361*^9}, {
   3.581153293731441*^9, 3.581153320081787*^9}, {3.581155147618628*^9, 
   3.5811551483704977`*^9}, {3.5811582250919447`*^9, 3.581158254931628*^9}, 
   3.581165401682724*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"48", " ", "\[Pi]", " ", 
     SuperscriptBox["MO1", "3"]}]], 
   RowBox[{
    SuperscriptBox["G", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SqrtBox[
        RowBox[{
         SuperscriptBox["MO1", "4"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["MB", "2"], " ", 
          SuperscriptBox["MO1", "2"]}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["MO1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubsuperscriptBox["o1", "dl", "2"], "+", 
            SubsuperscriptBox["o1", "dr", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["MB", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"6", " ", 
              SubscriptBox["o1", "dl"], " ", 
              SubscriptBox["o1", "dr"]}]}], "+", 
            SubsuperscriptBox["o1", "dl", "2"], "+", 
            SubsuperscriptBox["o1", "dr", "2"]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["MO1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox["o1", "dl", "2"], "+", 
         SubsuperscriptBox["o1", "dr", "2"]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["MO1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox["o1", "ul", "2"], "+", 
         SubsuperscriptBox["o1", "ur", "2"]}], ")"}]}], "+", 
      RowBox[{
       SqrtBox[
        RowBox[{
         SuperscriptBox["MO1", "4"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["MO1", "2"], " ", 
          SuperscriptBox["MT", "2"]}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["MO1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubsuperscriptBox["o1", "ul", "2"], "+", 
            SubsuperscriptBox["o1", "ur", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["MT", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"6", " ", 
              SubscriptBox["o1", "ul"], " ", 
              SubscriptBox["o1", "ur"]}]}], "+", 
            SubsuperscriptBox["o1", "ul", "2"], "+", 
            SubsuperscriptBox["o1", "ur", "2"]}], ")"}]}]}], ")"}]}]}], 
     ")"}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.579175384998328*^9, 3.579175398241267*^9}, {
   3.579608723244809*^9, 3.579608728323354*^9}, {3.581153294724028*^9, 
   3.581153320750814*^9}, 3.581155175869771*^9, 3.5811582605315313`*^9, 
   3.5811654623370333`*^9, 3.581244821459379*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Addendum: Hermiticity", "Subtitle",
 CellChangeTimes->{{3.577174928993369*^9, 3.577174972737718*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "LS0", "]"}]], "Input",
 CellChangeTimes->{{3.577174974825507*^9, 3.57717498218012*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{
  3.577174983029687*^9, 3.577184104255619*^9, 3.578139211068714*^9, 
   3.578209405840987*^9, 3.578311391244331*^9, 3.578381281687068*^9, 
   3.578381398051785*^9, {3.578381446679924*^9, 3.5783814513334093`*^9}, 
   3.5783837313398333`*^9, 3.578658834894248*^9, 3.578659072189032*^9, 
   3.5795063737579727`*^9, 3.57959854697353*^9}],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{
  3.577174983029687*^9, 3.577184104255619*^9, 3.578139211068714*^9, 
   3.578209405840987*^9, 3.578311391244331*^9, 3.578381281687068*^9, 
   3.578381398051785*^9, {3.578381446679924*^9, 3.5783814513334093`*^9}, 
   3.5783837313398333`*^9, 3.578658834894248*^9, 3.578659072189032*^9, 
   3.5795063737579727`*^9, 3.579598546985797*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.577174983029687*^9, 3.577184104255619*^9, 3.578139211068714*^9, 
   3.578209405840987*^9, 3.578311391244331*^9, 3.578381281687068*^9, 
   3.578381398051785*^9, {3.578381446679924*^9, 3.5783814513334093`*^9}, 
   3.5783837313398333`*^9, 3.578658834894248*^9, 3.578659072189032*^9, 
   3.5795063737579727`*^9, 3.579598547039989*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.577174983029687*^9, 3.577184104255619*^9, 3.578139211068714*^9, 
   3.578209405840987*^9, 3.578311391244331*^9, 3.578381281687068*^9, 
   3.578381398051785*^9, {3.578381446679924*^9, 3.5783814513334093`*^9}, 
   3.5783837313398333`*^9, 3.578658834894248*^9, 3.578659072189032*^9, 
   3.5795063737579727`*^9, 3.579598547041123*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.577174983029687*^9, 3.577184104255619*^9, 3.578139211068714*^9, 
   3.578209405840987*^9, 3.578311391244331*^9, 3.578381281687068*^9, 
   3.578381398051785*^9, {3.578381446679924*^9, 3.5783814513334093`*^9}, 
   3.5783837313398333`*^9, 3.578658834894248*^9, 3.578659072189032*^9, 
   3.5795063737579727`*^9, 3.579598548369853*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{8., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  2, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 2, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.577174983029687*^9, 3.577184104255619*^9, 3.578139211068714*^9, 
   3.578209405840987*^9, 3.578311391244331*^9, 3.578381281687068*^9, 
   3.578381398051785*^9, {3.578381446679924*^9, 3.5783814513334093`*^9}, 
   3.5783837313398333`*^9, 3.578658834894248*^9, 3.578659072189032*^9, 
   3.5795063737579727`*^9, 3.579598548426773*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Part", "::", "partw"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Part \[NoBreak]\\!\\(1\\)\[NoBreak] of \
\[NoBreak]\\!\\({}\\)\[NoBreak] does not exist. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/partw\\\", ButtonNote -> \
\\\"Part::partw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.57717498597263*^9, 3.577184107197295*^9, 3.578139212143527*^9, 
   3.5782094085679827`*^9, 3.578311393942863*^9, 3.578381284376546*^9, 
   3.5783813981394663`*^9, {3.578381449412759*^9, 3.578381454005768*^9}, 
   3.578383734048914*^9, 3.5786588375425053`*^9, 3.578659074782647*^9, 
   3.579506376478444*^9, 3.579598549710577*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.577174983029687*^9, 3.577184104255619*^9, 3.578139211068714*^9, 
   3.578209405840987*^9, 3.578311391244331*^9, 3.578381281687068*^9, 
   3.578381398051785*^9, {3.578381446679924*^9, 3.5783814513334093`*^9}, 
   3.5783837313398333`*^9, 3.578658834894248*^9, 3.578659072189032*^9, 
   3.5795063737579727`*^9, 3.5795985497118177`*^9}],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{
  3.577174983029687*^9, 3.577184104255619*^9, 3.578139211068714*^9, 
   3.578209405840987*^9, 3.578311391244331*^9, 3.578381281687068*^9, 
   3.578381398051785*^9, {3.578381446679924*^9, 3.5783814513334093`*^9}, 
   3.5783837313398333`*^9, 3.578658834894248*^9, 3.578659072189032*^9, 
   3.5795063737579727`*^9, 3.579598549712646*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.57717498597723*^9, 3.577184107200597*^9, 3.578139212146928*^9, 
   3.578209408571187*^9, 3.578311393946035*^9, 3.578381284380287*^9, 
   3.578381398151782*^9, {3.57838144941665*^9, 3.578381454009343*^9}, 
   3.578383734052699*^9, 3.578658837545823*^9, 3.5786590747857447`*^9, 
   3.579506376481881*^9, 3.579598549713833*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CheckHermiticity", "[", "LO0", "]"}], " "}]], "Input",
 CellChangeTimes->{
  3.578377106533237*^9, {3.578380938068934*^9, 3.578380938724339*^9}, {
   3.578380996166234*^9, 3.578381077783472*^9}, {3.57838132037466*^9, 
   3.578381326102907*^9}, {3.578381374836347*^9, 3.5783813784074583`*^9}, {
   3.578381457256886*^9, 3.5783814758157*^9}, {3.578381518724292*^9, 
   3.578381519619605*^9}, 3.5783835708205338`*^9, {3.5783836017963247`*^9, 
   3.578383611405855*^9}, {3.578383747220833*^9, 3.5783837642196283`*^9}, {
   3.578384289909011*^9, 3.578384318308461*^9}, {3.5787379931895943`*^9, 
   3.578738000275979*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{
  3.5783813279450407`*^9, 3.57838137920287*^9, {3.578381471415703*^9, 
   3.578381543268519*^9}, 3.578381852180402*^9, {3.57838263793609*^9, 
   3.5783826480717907`*^9}, 3.578382691111844*^9, 3.578382730920114*^9, 
   3.578382842019665*^9, {3.578382906022101*^9, 3.578382913163315*^9}, 
   3.57838361211377*^9, {3.5783837414049873`*^9, 3.5783837648031893`*^9}, 
   3.579598555634428*^9}],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{
  3.5783813279450407`*^9, 3.57838137920287*^9, {3.578381471415703*^9, 
   3.578381543268519*^9}, 3.578381852180402*^9, {3.57838263793609*^9, 
   3.5783826480717907`*^9}, 3.578382691111844*^9, 3.578382730920114*^9, 
   3.578382842019665*^9, {3.578382906022101*^9, 3.578382913163315*^9}, 
   3.57838361211377*^9, {3.5783837414049873`*^9, 3.5783837648031893`*^9}, 
   3.579598555644848*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.5783813279450407`*^9, 3.57838137920287*^9, {3.578381471415703*^9, 
   3.578381543268519*^9}, 3.578381852180402*^9, {3.57838263793609*^9, 
   3.5783826480717907`*^9}, 3.578382691111844*^9, 3.578382730920114*^9, 
   3.578382842019665*^9, {3.578382906022101*^9, 3.578382913163315*^9}, 
   3.57838361211377*^9, {3.5783837414049873`*^9, 3.5783837648031893`*^9}, 
   3.5795985557341623`*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.5783813279450407`*^9, 3.57838137920287*^9, {3.578381471415703*^9, 
   3.578381543268519*^9}, 3.578381852180402*^9, {3.57838263793609*^9, 
   3.5783826480717907`*^9}, 3.578382691111844*^9, 3.578382730920114*^9, 
   3.578382842019665*^9, {3.578382906022101*^9, 3.578382913163315*^9}, 
   3.57838361211377*^9, {3.5783837414049873`*^9, 3.5783837648031893`*^9}, 
   3.579598555736865*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.5783813279450407`*^9, 3.57838137920287*^9, {3.578381471415703*^9, 
   3.578381543268519*^9}, 3.578381852180402*^9, {3.57838263793609*^9, 
   3.5783826480717907`*^9}, 3.578382691111844*^9, 3.578382730920114*^9, 
   3.578382842019665*^9, {3.578382906022101*^9, 3.578382913163315*^9}, 
   3.57838361211377*^9, {3.5783837414049873`*^9, 3.5783837648031893`*^9}, 
   3.579598557320426*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{8., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  2, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 2, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5783813279450407`*^9, 3.57838137920287*^9, {3.578381471415703*^9, 
   3.578381543268519*^9}, 3.578381852180402*^9, {3.57838263793609*^9, 
   3.5783826480717907`*^9}, 3.578382691111844*^9, 3.578382730920114*^9, 
   3.578382842019665*^9, {3.578382906022101*^9, 3.578382913163315*^9}, 
   3.57838361211377*^9, {3.5783837414049873`*^9, 3.5783837648031893`*^9}, 
   3.579598557378531*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Part", "::", "partw"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Part \[NoBreak]\\!\\(1\\)\[NoBreak] of \
\[NoBreak]\\!\\({}\\)\[NoBreak] does not exist. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/partw\\\", ButtonNote -> \
\\\"Part::partw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.579598559401338*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5783813279450407`*^9, 3.57838137920287*^9, {3.578381471415703*^9, 
   3.578381543268519*^9}, 3.578381852180402*^9, {3.57838263793609*^9, 
   3.5783826480717907`*^9}, 3.578382691111844*^9, 3.578382730920114*^9, 
   3.578382842019665*^9, {3.578382906022101*^9, 3.578382913163315*^9}, 
   3.57838361211377*^9, {3.5783837414049873`*^9, 3.5783837648031893`*^9}, 
   3.579598559402462*^9}],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{
  3.5783813279450407`*^9, 3.57838137920287*^9, {3.578381471415703*^9, 
   3.578381543268519*^9}, 3.578381852180402*^9, {3.57838263793609*^9, 
   3.5783826480717907`*^9}, 3.578382691111844*^9, 3.578382730920114*^9, 
   3.578382842019665*^9, {3.578382906022101*^9, 3.578382913163315*^9}, 
   3.57838361211377*^9, {3.5783837414049873`*^9, 3.5783837648031893`*^9}, 
   3.579598559403344*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.5783813282625113`*^9, 3.5783813793886223`*^9, {3.5783814724494247`*^9, 
   3.5783815441708612`*^9}, 3.5783818530842457`*^9, {3.5783826388352957`*^9, 
   3.578382648974224*^9}, 3.57838269201328*^9, 3.578382731817897*^9, 
   3.578382764733098*^9, 3.5783828420910883`*^9, {3.578382907043253*^9, 
   3.578382914040104*^9}, 3.578383612183206*^9, {3.578383741491969*^9, 
   3.5783837648843*^9}, 3.579598559404567*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "LS1", "]"}]], "Input",
 CellChangeTimes->{{3.578659236592739*^9, 3.5786592471734247`*^9}, {
  3.5786592817283573`*^9, 3.578659345333906*^9}, {3.578659806237001*^9, 
  3.578659808389702*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{{3.578659241207849*^9, 3.578659247990909*^9}, {
   3.578659283103327*^9, 3.57865934860835*^9}, 3.578659810366868*^9, 
   3.578737979869953*^9, 3.578738466941774*^9, 3.578904126288846*^9, 
   3.578904215400818*^9, 3.578908717120791*^9, 3.5789184321959743`*^9, 
   3.579598564006703*^9}],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{{3.578659241207849*^9, 3.578659247990909*^9}, {
   3.578659283103327*^9, 3.57865934860835*^9}, 3.578659810366868*^9, 
   3.578737979869953*^9, 3.578738466941774*^9, 3.578904126288846*^9, 
   3.578904215400818*^9, 3.578908717120791*^9, 3.5789184321959743`*^9, 
   3.5795985640161*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.578659241207849*^9, 3.578659247990909*^9}, {
   3.578659283103327*^9, 3.57865934860835*^9}, 3.578659810366868*^9, 
   3.578737979869953*^9, 3.578738466941774*^9, 3.578904126288846*^9, 
   3.578904215400818*^9, 3.578908717120791*^9, 3.5789184321959743`*^9, 
   3.5795985640598917`*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.578659241207849*^9, 3.578659247990909*^9}, {
   3.578659283103327*^9, 3.57865934860835*^9}, 3.578659810366868*^9, 
   3.578737979869953*^9, 3.578738466941774*^9, 3.578904126288846*^9, 
   3.578904215400818*^9, 3.578908717120791*^9, 3.5789184321959743`*^9, 
   3.57959856406104*^9}],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{{3.578659241207849*^9, 3.578659247990909*^9}, {
   3.578659283103327*^9, 3.57865934860835*^9}, 3.578659810366868*^9, 
   3.578737979869953*^9, 3.578738466941774*^9, 3.578904126288846*^9, 
   3.578904215400818*^9, 3.578908717120791*^9, 3.5789184321959743`*^9, 
   3.5795985640621367`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.578659241207849*^9, 3.578659247990909*^9}, {
   3.578659283103327*^9, 3.57865934860835*^9}, 3.578659810366868*^9, 
   3.578737979869953*^9, 3.578738466941774*^9, 3.578904126288846*^9, 
   3.578904215400818*^9, 3.578908717120791*^9, 3.5789184321959743`*^9, 
   3.579598564063343*^9}],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{{3.578659241207849*^9, 3.578659247990909*^9}, {
   3.578659283103327*^9, 3.57865934860835*^9}, 3.578659810366868*^9, 
   3.578737979869953*^9, 3.578738466941774*^9, 3.578904126288846*^9, 
   3.578904215400818*^9, 3.578908717120791*^9, 3.5789184321959743`*^9, 
   3.579598564064472*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{{3.5786592413767138`*^9, 3.5786592481495256`*^9}, {
   3.578659283223328*^9, 3.578659348753764*^9}, 3.578659810579043*^9, 
   3.578737979886176*^9, 3.578738466997644*^9, 3.578904126900998*^9, 
   3.5789042154520884`*^9, 3.578908717177393*^9, 3.5789184322509336`*^9, 
   3.579598564065645*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "LO1", "]"}]], "Input",
 CellChangeTimes->{{3.579175489097077*^9, 3.57917549554646*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{3.579175496144882*^9, 3.5795985694309053`*^9, 
  3.581155085009905*^9, 3.581155137757681*^9}],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{3.579175496144882*^9, 3.5795985694309053`*^9, 
  3.581155085009905*^9, 3.581155137765615*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.579175496144882*^9, 3.5795985694309053`*^9, 
  3.581155085009905*^9, 3.581155137792288*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.579175496144882*^9, 3.5795985694309053`*^9, 
  3.581155085009905*^9, 3.581155137794423*^9}],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{3.579175496144882*^9, 3.5795985694309053`*^9, 
  3.581155085009905*^9, 3.581155137795168*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.579175496144882*^9, 3.5795985694309053`*^9, 
  3.581155085009905*^9, 3.581155137795987*^9}],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{3.579175496144882*^9, 3.5795985694309053`*^9, 
  3.581155085009905*^9, 3.5811551377967033`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{3.579175496193925*^9, 3.579598569447191*^9, 
  3.581155085707472*^9, 3.581155137797491*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Scratchpad", "Subtitle",
 CellChangeTimes->{
  3.583050333013604*^9, 3.583050704405258*^9, {3.583321759610138*^9, 
   3.583321764232031*^9}}],

Cell["\<\
From http://arxiv.org/pdf/0705.1499v2.pdf\
\>", "Text",
 CellChangeTimes->{{3.583044916304085*^9, 3.5830449365136766`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"shat", " ", "=", " ", 
   SuperscriptBox["7000", "2"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ctheta", " ", "=", " ", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GammaO1", " ", "=", " ", 
   RowBox[{"NumericalValue", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"aS", " ", "MO1"}], "6"], 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"4", 
            SuperscriptBox["MT", "2"]}], 
           SuperscriptBox["MO1", "2"]]}], ")"}], 
        RowBox[{"3", "/", "2"}]]}], ")"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"betta", " ", "=", " ", 
   SqrtBox[
    RowBox[{"1", "-", 
     FractionBox[
      RowBox[{"4", 
       SuperscriptBox["MT", "2"]}], "shat"]}]]}], ";"}]}], "Input",
 CellChangeTimes->{{3.583042268813814*^9, 3.5830422756031313`*^9}, {
  3.583042336900189*^9, 3.58304243642249*^9}, {3.5830554700265427`*^9, 
  3.583055478505068*^9}, {3.5830557093857517`*^9, 3.5830557106334753`*^9}, {
  3.583055818538703*^9, 3.583055860122944*^9}, {3.583055896011821*^9, 
  3.583055908394742*^9}, {3.5830563051335917`*^9, 3.583056306074875*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericalValue", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "\[Pi]", " ", 
     SuperscriptBox["aS", "2"]}], 
    RowBox[{"9", " ", 
     SuperscriptBox["shat", "2"]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["MT", "2"]}], "shat"], 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["ctheta", "2"]}], ")"}]}], "+", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["ctheta", "2"]}], ")"}], "+", 
     FractionBox[
      RowBox[{
       RowBox[{
        SuperscriptBox["shat", "2"], 
        SuperscriptBox["betta", "2"], 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["ctheta", "2"]}], ")"}]}], "+", 
       RowBox[{"4", "shat", 
        RowBox[{"(", 
         RowBox[{"shat", "-", 
          SuperscriptBox["MO1", "2"]}], ")"}], "betta", " ", "ctheta"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"shat", "-", 
          SuperscriptBox["MO1", "2"]}], ")"}], "2"], "+", 
       RowBox[{
        SuperscriptBox["GammaO1", "2"], 
        SuperscriptBox["MO1", "2"]}]}]]}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.583055499555991*^9, 3.583055705194921*^9}, {
  3.583055876890977*^9, 3.5830558889244137`*^9}}],

Cell[BoxData["1.0768685295585936`*^-17"], "Output",
 CellChangeTimes->{{3.5830558898755217`*^9, 3.5830559111233387`*^9}, 
   3.583056308067528*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "[", 
     RowBox[{"mu", ",", "nu"}], "]"}], 
    RowBox[{"del", "[", 
     RowBox[{
      RowBox[{"uqbar", ".", 
       RowBox[{"Ga", "[", "nu", "]"}], ".", "uq"}], ",", "mu"}], "]"}]}], ",",
    " ", 
   RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5768464932886887`*^9, 3.576846494055841*^9}, {
  3.5774350578812428`*^9, 3.5774350585855427`*^9}, {3.583245020956766*^9, 
  3.583245026844239*^9}, {3.583245067133257*^9, 3.5832450873452473`*^9}, {
  3.583245150559677*^9, 3.583245151647086*^9}, {3.5832452060314093`*^9, 
  3.5832452516094627`*^9}, {3.58324627077041*^9, 3.583246287297967*^9}, {
  3.583246342959177*^9, 3.5832463509421377`*^9}, {3.583319692397471*^9, 
  3.583319695436016*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.5832450882411203`*^9, 3.583245154564101*^9, {3.583245237687014*^9, 
   3.583245252355637*^9}, 3.583246288222301*^9, {3.58324634617033*^9, 
   3.583246351402752*^9}, 3.583246437460573*^9, 3.583319488860251*^9, 
   3.583319652389522*^9, 3.583319696437337*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.5832450882411203`*^9, 3.583245154564101*^9, {3.583245237687014*^9, 
   3.583245252355637*^9}, 3.583246288222301*^9, {3.58324634617033*^9, 
   3.583246351402752*^9}, 3.583246437460573*^9, 3.583319488860251*^9, 
   3.583319652389522*^9, 3.583319696506939*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.5832450882411203`*^9, 3.583245154564101*^9, {3.583245237687014*^9, 
   3.583245252355637*^9}, 3.583246288222301*^9, {3.58324634617033*^9, 
   3.583246351402752*^9}, 3.583246437460573*^9, 3.583319488860251*^9, 
   3.583319652389522*^9, 3.5833196965084963`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{9., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5832450882411203`*^9, 3.583245154564101*^9, {3.583245237687014*^9, 
   3.583245252355637*^9}, 3.583246288222301*^9, {3.58324634617033*^9, 
   3.583246351402752*^9}, 3.583246437460573*^9, 3.583319488860251*^9, 
   3.583319652389522*^9, 3.583319696511094*^9}],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->{
  3.5832450882411203`*^9, 3.583245154564101*^9, {3.583245237687014*^9, 
   3.583245252355637*^9}, 3.583246288222301*^9, {3.58324634617033*^9, 
   3.583246351402752*^9}, 3.583246437460573*^9, 3.583319488860251*^9, 
   3.583319652389522*^9, 3.58331969659746*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"uq", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"S2", ",", "3"}], "}"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      SubsuperscriptBox["\<\"p\"\>", "1", 
       SubscriptBox["\<\"\[Mu]\"\>", 
        RowBox[{"3", ",", "2"}]]], " ", 
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}], 
       SubscriptBox["\<\"\[Mu]\"\>", 
        RowBox[{"3", ",", "1"}]]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SubsuperscriptBox["\<\"p\"\>", "2", 
       SubscriptBox["\<\"\[Mu]\"\>", 
        RowBox[{"3", ",", "2"}]]], " ", 
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}], 
       SubscriptBox["\<\"\[Mu]\"\>", 
        RowBox[{"3", ",", "1"}]]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SubsuperscriptBox["\<\"p\"\>", "1", 
       SubscriptBox["\<\"\[Mu]\"\>", 
        RowBox[{"3", ",", "1"}]]], " ", 
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}], 
       SubscriptBox["\<\"\[Mu]\"\>", 
        RowBox[{"3", ",", "2"}]]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SubsuperscriptBox["\<\"p\"\>", "2", 
       SubscriptBox["\<\"\[Mu]\"\>", 
        RowBox[{"3", ",", "1"}]]], " ", 
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}], 
       SubscriptBox["\<\"\[Mu]\"\>", 
        RowBox[{"3", ",", "2"}]]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.583245088490611*^9, 3.5832451547556*^9, {3.5832452379208803`*^9, 
   3.583245252474279*^9}, 3.583246288338162*^9, {3.58324634635522*^9, 
   3.583246351519651*^9}, 3.58324643757378*^9, 3.583319489122802*^9, 
   3.583319652515828*^9, 3.5833196966035748`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", 
  RowBox[{
   RowBox[{"S2", "[", 
    RowBox[{"mu", ",", "nu"}], "]"}], "  ", 
   RowBox[{"del", "[", 
    RowBox[{
     RowBox[{"uqbar", ".", 
      RowBox[{"Ga", "[", "nu", "]"}], ".", "uq"}], ",", "mu"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5832462532706633`*^9, 3.583246277326152*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{{3.583246263354519*^9, 3.583246278090354*^9}, 
   3.58324644069462*^9, 3.583319698457933*^9}],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{{3.583246263354519*^9, 3.583246278090354*^9}, 
   3.58324644069462*^9, 3.5833196985055923`*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.583246263354519*^9, 3.583246278090354*^9}, 
   3.58324644069462*^9, 3.5833196985080633`*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.583246263354519*^9, 3.583246278090354*^9}, 
   3.58324644069462*^9, 3.58331969850945*^9}],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{{3.583246263354519*^9, 3.583246278090354*^9}, 
   3.58324644069462*^9, 3.583319698510866*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.583246263354519*^9, 3.583246278090354*^9}, 
   3.58324644069462*^9, 3.583319698512312*^9}],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{{3.583246263354519*^9, 3.583246278090354*^9}, 
   3.58324644069462*^9, 3.583319698513731*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{{3.58324626354414*^9, 3.583246278105338*^9}, 
   3.583246440709598*^9, 3.58331969851516*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", 
  RowBox[{
   RowBox[{"S2", "[", 
    RowBox[{"mu", ",", "nu"}], "]"}], " ", 
   RowBox[{"FS", "[", 
    RowBox[{"G", ",", "mu", ",", "rho", ",", "aaa"}], "]"}], " ", 
   RowBox[{"FS", "[", 
    RowBox[{"G", ",", "nu", ",", "rho", ",", "aaa"}], "]"}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.583246514001894*^9, 3.583246559886956*^9}, {
  3.583319725662422*^9, 3.583319749371372*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{3.583246560489626*^9, 3.583319715790512*^9, 
  3.5833197682423143`*^9}],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{3.583246560489626*^9, 3.583319715790512*^9, 
  3.5833197683073997`*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.583246560489626*^9, 3.583319715790512*^9, 
  3.5833197683091288`*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.583246560489626*^9, 3.583319715790512*^9, 
  3.583319768310603*^9}],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{3.583246560489626*^9, 3.583319715790512*^9, 
  3.583319768312091*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.583246560489626*^9, 3.583319715790512*^9, 
  3.583319768313601*^9}],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{3.583246560489626*^9, 3.583319715790512*^9, 
  3.583319768315103*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{3.583246560538169*^9, 3.583319715865554*^9, 
  3.583319768316655*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "[", 
     RowBox[{"mu", ",", "nu"}], "]"}], " ", 
    RowBox[{"FS", "[", 
     RowBox[{"G", ",", "mu", ",", "rho", ",", "aaa"}], "]"}], " ", 
    RowBox[{"FS", "[", 
     RowBox[{"G", ",", "nu", ",", "rho", ",", "aaa"}], "]"}]}], 
   "\[IndentingNewLine]", ",", " ", 
   RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5768464932886887`*^9, 3.576846494055841*^9}, {
   3.5774350578812428`*^9, 3.5774350585855427`*^9}, {3.583245020956766*^9, 
   3.583245026844239*^9}, {3.583245067133257*^9, 3.5832450873452473`*^9}, {
   3.583245150559677*^9, 3.583245151647086*^9}, {3.5832452060314093`*^9, 
   3.5832452516094627`*^9}, {3.58324627077041*^9, 3.583246287297967*^9}, {
   3.583246342959177*^9, 3.5832463509421377`*^9}, 3.583246580735968*^9, {
   3.583246617135729*^9, 3.583246631278009*^9}, {3.583246662446155*^9, 
   3.5832466814852*^9}, 3.583246719016996*^9, {3.583246750733294*^9, 
   3.58324682340528*^9}, 3.583319791945821*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.583246581884719*^9, {3.583246648087604*^9, 3.583246668568295*^9}, 
   3.583246752616502*^9, {3.5832468045609217`*^9, 3.5832468291797657`*^9}, 
   3.5833197929831*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.583246581884719*^9, {3.583246648087604*^9, 3.583246668568295*^9}, 
   3.583246752616502*^9, {3.5832468045609217`*^9, 3.5832468291797657`*^9}, 
   3.583319792994977*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.583246581884719*^9, {3.583246648087604*^9, 3.583246668568295*^9}, 
   3.583246752616502*^9, {3.5832468045609217`*^9, 3.5832468291797657`*^9}, 
   3.583319793128695*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "3", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{9., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  3, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 3, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.583246581884719*^9, {3.583246648087604*^9, 3.583246668568295*^9}, 
   3.583246752616502*^9, {3.5832468045609217`*^9, 3.5832468291797657`*^9}, 
   3.583319793129986*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[3, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.583246581884719*^9, {3.583246648087604*^9, 3.583246668568295*^9}, 
   3.583246752616502*^9, {3.5832468045609217`*^9, 3.5832468291797657`*^9}, 
   3.58331979511716*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"G", "2"},
         {"S2", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"3", ",", "2"}]]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"3", ",", "1"}]]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"]]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"3", ",", "1"}]]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"3", ",", "2"}]]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"]]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"3", ",", "2"}]]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"3", ",", "1"}]]]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"3", ",", "2"}]]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"3", ",", "1"}]]]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"3", ",", "1"}]]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"3", ",", "2"}]]]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"3", ",", "1"}]]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"3", ",", "2"}]]]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"3", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"3", ",", "1"}]]}]], " ", 
        RowBox[{
         SubscriptBox["\<\"p\"\>", "1"], ".", 
         SubscriptBox["p", "2"]}]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"3", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"3", ",", "2"}]]}]], " ", 
        RowBox[{
         SubscriptBox["\<\"p\"\>", "1"], ".", 
         SubscriptBox["p", "2"]}]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"G", "2"},
         {"G", "3"},
         {"S2", "4"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["g", "s"]}], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "1"}]]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"]]}], "-", 
       RowBox[{
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "2"}]]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"]]}], "+", 
       RowBox[{
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "1"}]]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
       RowBox[{
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "2"}]]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "-", 
       RowBox[{
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"4", ",", "1"}]]]}], "+", 
       RowBox[{
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "2"}]]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"4", ",", "1"}]]]}], "-", 
       RowBox[{
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"4", ",", "2"}]]]}], "+", 
       RowBox[{
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "1"}]]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"4", ",", "2"}]]]}], "-", 
       RowBox[{
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "3", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"4", ",", "2"}]]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "1"}]]}]]}], "-", 
       RowBox[{
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "1"}]]}]]}], "-", 
       RowBox[{
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "3", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"4", ",", "1"}]]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "2"}]]}]]}], "-", 
       RowBox[{
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "2"}]]}]]}], "-", 
       RowBox[{
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"4", ",", "2"}]]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "1"}]]}]]}], "-", 
       RowBox[{
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "3", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "1"}]]}]]}], "-", 
       RowBox[{
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"4", ",", "1"}]]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "2"}]]}]]}], "-", 
       RowBox[{
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
        SubsuperscriptBox["\<\"p\"\>", "3", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "2"}]]}]]}], "+", 
       RowBox[{
        SubsuperscriptBox["\<\"p\"\>", "3", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"4", ",", "2"}]]], " ", 
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]]}], "+", 
       RowBox[{
        SubsuperscriptBox["\<\"p\"\>", "3", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"4", ",", "1"}]]], " ", 
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]]}], "+", 
       RowBox[{
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"4", ",", "2"}]]], " ", 
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "1"}]]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]]}], "+", 
       RowBox[{
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", 
          RowBox[{"4", ",", "1"}]]], " ", 
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "2"}]]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]]}], "+", 
       RowBox[{
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "1"}]]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]]}], "+", 
       RowBox[{
        SubsuperscriptBox["\<\"p\"\>", "3", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "1"}]]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]]}], "+", 
       RowBox[{
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "2"}]]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]]}], "+", 
       RowBox[{
        SubsuperscriptBox["\<\"p\"\>", "3", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"4", ",", "2"}]]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"]}]]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"G", "2"},
         {"G", "3"},
         {"G", "4"},
         {"S2", "5"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "3"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "3"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "3"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "3"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "3"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "3"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "3"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "1"}]]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", 
           RowBox[{"5", ",", "2"}]]}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "1"], ",", 
          SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "3"], ",", 
          SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.5832465820570374`*^9, {3.5832466678035307`*^9, 3.5832466687209797`*^9}, 
   3.5832467550095577`*^9, {3.583246806519423*^9, 3.583246831097745*^9}, {
   3.58331979513524*^9, 3.583319799369443*^9}}]
}, Open  ]]
}, Closed]]
},
Evaluator->"topbsm",
WindowSize->{1280, 1000},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperOrientation"->"Portrait",
"PaperSize"->{594.75, 842.25},
"PostScriptOutputFile"->"/home/skrastanov/print.pdf"},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
FrontEndVersion->"9.0 for Linux x86 (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 184, 3, 70, "Input"],
Cell[CellGroupData[{
Cell[754, 27, 249, 3, 31, "Subsubtitle"],
Cell[1006, 32, 122, 2, 32, "Input"],
Cell[CellGroupData[{
Cell[1153, 38, 1284, 27, 121, "Input"],
Cell[CellGroupData[{
Cell[2462, 69, 3714, 52, 23, "Print"],
Cell[6179, 123, 3989, 59, 23, "Print"],
Cell[10171, 184, 3766, 53, 23, "Print"],
Cell[13940, 239, 3702, 52, 23, "Print"],
Cell[17645, 293, 3770, 53, 23, "Print"],
Cell[21418, 348, 3730, 52, 23, "Print"],
Cell[25151, 402, 3702, 52, 23, "Print"],
Cell[28856, 456, 3769, 53, 23, "Print"],
Cell[32628, 511, 3723, 52, 23, "Print"],
Cell[36354, 565, 3739, 52, 23, "Print"],
Cell[40096, 619, 3709, 52, 23, "Print"],
Cell[43808, 673, 3711, 52, 23, "Print"],
Cell[47522, 727, 3709, 52, 23, "Print"],
Cell[51234, 781, 3841, 56, 23, "Print"],
Cell[55078, 839, 3710, 52, 23, "Print"],
Cell[58791, 893, 3749, 53, 23, "Print"],
Cell[62543, 948, 3701, 52, 23, "Print"],
Cell[66247, 1002, 3731, 52, 23, "Print"],
Cell[69981, 1056, 3732, 52, 23, "Print"],
Cell[73716, 1110, 3730, 52, 23, "Print"],
Cell[77449, 1164, 3897, 57, 43, "Print"],
Cell[81349, 1223, 4194, 62, 23, "Print"],
Cell[85546, 1287, 4200, 62, 23, "Print"],
Cell[89749, 1351, 3719, 52, 23, "Print"]
}, Open  ]]
}, Closed]],
Cell[93495, 1407, 286, 5, 48, "Text"],
Cell[93784, 1414, 424, 9, 32, "Input"],
Cell[94211, 1425, 142, 1, 31, "Text"],
Cell[94356, 1428, 152, 3, 32, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[94545, 1436, 182, 4, 31, "Subsubtitle"],
Cell[94730, 1442, 611, 11, 91, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[95378, 1458, 174, 3, 31, "Subsubtitle"],
Cell[CellGroupData[{
Cell[95577, 1465, 130, 2, 32, "Input"],
Cell[95710, 1469, 718, 23, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[96465, 1497, 128, 2, 32, "Input"],
Cell[96596, 1501, 450, 16, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[97083, 1522, 130, 2, 32, "Input"],
Cell[97216, 1526, 513, 18, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[97766, 1549, 130, 2, 32, "Input"],
Cell[97899, 1553, 267, 9, 57, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[98215, 1568, 207, 3, 51, "Subtitle"],
Cell[CellGroupData[{
Cell[98447, 1575, 98, 1, 32, "Input"],
Cell[98548, 1578, 71, 1, 32, "Output"]
}, Open  ]],
Cell[98634, 1582, 739, 14, 111, "Text"],
Cell[CellGroupData[{
Cell[99398, 1600, 104, 1, 31, "Subsubtitle"],
Cell[CellGroupData[{
Cell[99527, 1605, 1178, 16, 32, "Input"],
Cell[100708, 1623, 1422, 35, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102167, 1663, 686, 11, 32, "Input"],
Cell[CellGroupData[{
Cell[102878, 1678, 1002, 19, 25, "Print"],
Cell[103883, 1699, 749, 11, 9, "Print"],
Cell[104635, 1712, 783, 12, 9, "Print"],
Cell[105421, 1726, 1271, 23, 9, "Print"],
Cell[106695, 1751, 742, 11, 9, "Print"]
}, Closed]],
Cell[107452, 1765, 3061, 89, 75, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[110562, 1860, 181, 2, 31, "Subsubtitle"],
Cell[110746, 1864, 120, 1, 31, "Text"],
Cell[CellGroupData[{
Cell[110891, 1869, 495, 12, 32, "Input"],
Cell[111389, 1883, 1467, 39, 63, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[112893, 1927, 571, 13, 32, "Input"],
Cell[113467, 1942, 1463, 39, 63, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[114967, 1986, 429, 8, 32, "Input"],
Cell[CellGroupData[{
Cell[115421, 1998, 675, 15, 25, "Print"],
Cell[116099, 2015, 422, 7, 9, "Print"],
Cell[116524, 2024, 652, 13, 9, "Print"],
Cell[117179, 2039, 456, 8, 9, "Print"],
Cell[117638, 2049, 944, 19, 9, "Print"],
Cell[118585, 2070, 413, 7, 9, "Print"]
}, Closed]],
Cell[119013, 2080, 3041, 87, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[122091, 2172, 456, 8, 32, "Input"],
Cell[CellGroupData[{
Cell[122572, 2184, 616, 13, 25, "Print"],
Cell[123191, 2199, 365, 5, 9, "Print"],
Cell[123559, 2206, 593, 11, 9, "Print"],
Cell[124155, 2219, 397, 6, 9, "Print"],
Cell[124555, 2227, 884, 17, 9, "Print"],
Cell[125442, 2246, 354, 5, 9, "Print"]
}, Closed]],
Cell[125811, 2254, 10638, 325, 69, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[136498, 2585, 111, 1, 31, "Subsubtitle"],
Cell[136612, 2588, 672, 10, 51, "Text"],
Cell[CellGroupData[{
Cell[137309, 2602, 600, 14, 32, "Input"],
Cell[137912, 2618, 1874, 52, 98, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[139847, 2677, 251, 3, 51, "Subtitle"],
Cell[CellGroupData[{
Cell[140123, 2684, 94, 1, 32, "Input"],
Cell[140220, 2687, 71, 1, 32, "Output"]
}, Open  ]],
Cell[140306, 2691, 865, 17, 151, "Text"],
Cell[CellGroupData[{
Cell[141196, 2712, 104, 1, 31, "Subsubtitle"],
Cell[CellGroupData[{
Cell[141325, 2717, 98, 1, 32, "Input"],
Cell[141426, 2720, 812, 22, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[142275, 2747, 211, 4, 32, "Input"],
Cell[CellGroupData[{
Cell[142511, 2755, 397, 10, 23, "Print"],
Cell[142911, 2767, 152, 2, 13, "Print"],
Cell[143066, 2771, 183, 3, 13, "Print"],
Cell[143252, 2776, 661, 14, 13, "Print"],
Cell[143916, 2792, 141, 2, 13, "Print"]
}, Closed]],
Cell[144072, 2797, 2222, 60, 75, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[146343, 2863, 181, 2, 31, "Subsubtitle"],
Cell[146527, 2867, 120, 1, 31, "Text"],
Cell[CellGroupData[{
Cell[146672, 2872, 547, 13, 32, "Input"],
Cell[147222, 2887, 1533, 41, 63, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[148792, 2933, 620, 14, 32, "Input"],
Cell[149415, 2949, 1533, 41, 63, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[150985, 2995, 411, 8, 32, "Input"],
Cell[CellGroupData[{
Cell[151421, 3007, 556, 12, 23, "Print"],
Cell[151980, 3021, 311, 4, 13, "Print"],
Cell[152294, 3027, 536, 10, 13, "Print"],
Cell[152833, 3039, 345, 5, 13, "Print"],
Cell[153181, 3046, 823, 16, 13, "Print"],
Cell[154007, 3064, 303, 4, 13, "Print"]
}, Closed]],
Cell[154325, 3071, 2418, 61, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[156780, 3137, 330, 6, 32, "Input"],
Cell[CellGroupData[{
Cell[157135, 3147, 487, 11, 23, "Print"],
Cell[157625, 3160, 245, 3, 13, "Print"],
Cell[157873, 3165, 467, 9, 13, "Print"],
Cell[158343, 3176, 278, 4, 13, "Print"],
Cell[158624, 3182, 753, 15, 13, "Print"],
Cell[159380, 3199, 234, 3, 13, "Print"]
}, Closed]],
Cell[159629, 3205, 26939, 628, 69, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[186629, 3840, 302, 4, 51, "Subtitle"],
Cell[CellGroupData[{
Cell[186956, 3848, 147, 2, 32, "Input"],
Cell[187106, 3852, 93, 1, 32, "Output"]
}, Open  ]],
Cell[187214, 3856, 1049, 19, 131, "Text"],
Cell[CellGroupData[{
Cell[188288, 3879, 167, 2, 31, "Subsubtitle"],
Cell[CellGroupData[{
Cell[188480, 3885, 148, 2, 32, "Input"],
Cell[188631, 3889, 431, 12, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[189099, 3906, 99, 1, 32, "Input"],
Cell[189201, 3909, 738, 22, 69, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[189988, 3937, 158, 2, 31, "Subsubtitle"],
Cell[CellGroupData[{
Cell[190171, 3943, 148, 2, 32, "Input"],
Cell[190322, 3947, 879, 22, 66, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[191250, 3975, 236, 5, 31, "Subsubtitle"],
Cell[CellGroupData[{
Cell[191511, 3984, 196, 3, 32, "Input"],
Cell[191710, 3989, 655, 16, 64, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[192402, 4010, 150, 2, 32, "Input"],
Cell[192555, 4014, 786, 23, 71, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[193390, 4043, 285, 5, 31, "Subsubtitle"],
Cell[CellGroupData[{
Cell[193700, 4052, 244, 3, 32, "Input"],
Cell[193947, 4057, 697, 17, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[194681, 4079, 199, 3, 32, "Input"],
Cell[194883, 4084, 782, 22, 71, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[195714, 4112, 243, 3, 31, "Subsubtitle"],
Cell[CellGroupData[{
Cell[195982, 4119, 256, 5, 32, "Input"],
Cell[CellGroupData[{
Cell[196263, 4128, 470, 11, 23, "Print"],
Cell[196736, 4141, 225, 3, 23, "Print"],
Cell[196964, 4146, 256, 4, 23, "Print"],
Cell[197223, 4152, 734, 15, 23, "Print"],
Cell[197960, 4169, 336, 7, 23, "Print"]
}, Closed]],
Cell[198311, 4179, 10952, 296, 271, "Output"]
}, Open  ]],
Cell[209278, 4478, 185, 4, 31, "Text"],
Cell[CellGroupData[{
Cell[209488, 4486, 330, 7, 32, "Input"],
Cell[CellGroupData[{
Cell[209843, 4497, 372, 9, 23, "Print"],
Cell[210218, 4508, 125, 1, 23, "Print"],
Cell[210346, 4511, 337, 6, 23, "Print"],
Cell[210686, 4519, 158, 2, 23, "Print"],
Cell[210847, 4523, 634, 13, 23, "Print"],
Cell[211484, 4538, 238, 5, 23, "Print"]
}, Closed]],
Cell[211737, 4546, 11122, 303, 271, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[222920, 4856, 351, 5, 51, "Subtitle"],
Cell[CellGroupData[{
Cell[223296, 4865, 198, 3, 32, "Input"],
Cell[223497, 4870, 118, 2, 32, "Output"]
}, Open  ]],
Cell[223630, 4875, 1040, 17, 91, "Text"],
Cell[CellGroupData[{
Cell[224695, 4896, 228, 3, 31, "Subsubtitle"],
Cell[CellGroupData[{
Cell[224948, 4903, 243, 3, 32, "Input"],
Cell[225194, 4908, 721, 17, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[225952, 4930, 203, 3, 32, "Input"],
Cell[226158, 4935, 733, 20, 42, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[226940, 4961, 286, 5, 31, "Subsubtitle"],
Cell[CellGroupData[{
Cell[227251, 4970, 293, 4, 32, "Input"],
Cell[227547, 4976, 749, 18, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[228333, 4999, 245, 3, 32, "Input"],
Cell[228581, 5004, 756, 20, 42, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[229386, 5030, 243, 3, 31, "Subsubtitle"],
Cell[CellGroupData[{
Cell[229654, 5037, 305, 6, 32, "Input"],
Cell[CellGroupData[{
Cell[229984, 5047, 516, 11, 23, "Print"],
Cell[230503, 5060, 273, 3, 23, "Print"],
Cell[230779, 5065, 306, 4, 23, "Print"],
Cell[231088, 5071, 780, 15, 23, "Print"],
Cell[231871, 5088, 384, 7, 23, "Print"]
}, Closed]],
Cell[232270, 5098, 5196, 138, 139, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[237527, 5243, 104, 1, 51, "Subtitle"],
Cell[CellGroupData[{
Cell[237656, 5248, 2589, 56, 275, "Input"],
Cell[CellGroupData[{
Cell[240270, 5308, 1463, 21, 23, "Print"],
Cell[241736, 5331, 1686, 28, 23, "Print"],
Cell[243425, 5361, 1443, 20, 23, "Print"],
Cell[244871, 5383, 1615, 25, 23, "Print"],
Cell[246489, 5410, 1474, 21, 23, "Print"],
Cell[247966, 5433, 1949, 32, 23, "Print"],
Cell[249918, 5467, 1554, 24, 23, "Print"],
Cell[251475, 5493, 1686, 28, 23, "Print"],
Cell[253164, 5523, 1441, 20, 23, "Print"],
Cell[254608, 5545, 1474, 21, 23, "Print"],
Cell[256085, 5568, 1950, 32, 23, "Print"],
Cell[258038, 5602, 1554, 24, 23, "Print"],
Cell[259595, 5628, 1688, 28, 23, "Print"],
Cell[261286, 5658, 1441, 20, 23, "Print"],
Cell[262730, 5680, 1614, 25, 23, "Print"],
Cell[264347, 5707, 1474, 21, 23, "Print"],
Cell[265824, 5730, 1954, 32, 23, "Print"],
Cell[267781, 5764, 1556, 24, 23, "Print"],
Cell[269340, 5790, 1686, 28, 23, "Print"],
Cell[271029, 5820, 1441, 20, 23, "Print"],
Cell[272473, 5842, 1472, 21, 23, "Print"],
Cell[273948, 5865, 1950, 32, 23, "Print"],
Cell[275901, 5899, 1554, 24, 23, "Print"],
Cell[277458, 5925, 1688, 28, 23, "Print"],
Cell[279149, 5955, 1441, 20, 23, "Print"],
Cell[280593, 5977, 1474, 21, 23, "Print"],
Cell[282070, 6000, 1950, 32, 23, "Print"],
Cell[284023, 6034, 1434, 20, 23, "Print"],
Cell[285460, 6056, 1688, 28, 23, "Print"],
Cell[287151, 6086, 1441, 20, 23, "Print"],
Cell[288595, 6108, 1474, 21, 23, "Print"],
Cell[290072, 6131, 1950, 32, 23, "Print"],
Cell[292025, 6165, 1554, 24, 23, "Print"],
Cell[293582, 6191, 1688, 28, 23, "Print"],
Cell[295273, 6221, 1443, 20, 23, "Print"],
Cell[296719, 6243, 1474, 21, 23, "Print"],
Cell[298196, 6266, 1950, 32, 23, "Print"],
Cell[300149, 6300, 1554, 24, 23, "Print"],
Cell[301706, 6326, 1686, 28, 23, "Print"],
Cell[303395, 6356, 1440, 20, 23, "Print"],
Cell[304838, 6378, 1473, 21, 23, "Print"],
Cell[306314, 6401, 1950, 32, 23, "Print"],
Cell[308267, 6435, 1554, 24, 23, "Print"],
Cell[309824, 6461, 1685, 28, 23, "Print"],
Cell[311512, 6491, 1443, 20, 23, "Print"],
Cell[312958, 6513, 1474, 21, 23, "Print"],
Cell[314435, 6536, 1950, 32, 23, "Print"],
Cell[316388, 6570, 1554, 24, 23, "Print"],
Cell[317945, 6596, 1686, 28, 23, "Print"],
Cell[319634, 6626, 1441, 20, 23, "Print"],
Cell[321078, 6648, 1474, 21, 23, "Print"],
Cell[322555, 6671, 1950, 32, 23, "Print"],
Cell[324508, 6705, 1554, 24, 23, "Print"],
Cell[326065, 6731, 1678, 26, 23, "Print"],
Cell[327746, 6759, 1455, 20, 23, "Print"],
Cell[329204, 6781, 1440, 20, 23, "Print"],
Cell[330647, 6803, 1462, 21, 23, "Print"],
Cell[332112, 6826, 1653, 25, 23, "Print"],
Cell[333768, 6853, 1810, 28, 23, "Print"],
Cell[335581, 6883, 1434, 20, 23, "Print"],
Cell[337018, 6905, 1419, 20, 23, "Print"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[338498, 6932, 158, 2, 51, "Subtitle"],
Cell[338659, 6936, 429, 8, 51, "Text"],
Cell[CellGroupData[{
Cell[339113, 6948, 160, 2, 31, "Subsubtitle"],
Cell[CellGroupData[{
Cell[339298, 6954, 100, 1, 32, "Input"],
Cell[339401, 6957, 538, 15, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[339976, 6977, 755, 17, 55, "Input"],
Cell[CellGroupData[{
Cell[340756, 6998, 479, 11, 25, "Print"],
Cell[341238, 7011, 223, 3, 6, "Print"],
Cell[341464, 7016, 258, 4, 6, "Print"],
Cell[341725, 7022, 746, 15, 6, "Print"],
Cell[342474, 7039, 215, 3, 6, "Print"]
}, Closed]],
Cell[342704, 7045, 1958, 57, 75, "Output"],
Cell[CellGroupData[{
Cell[344687, 7106, 477, 11, 25, "Print"],
Cell[345167, 7119, 224, 3, 6, "Print"],
Cell[345394, 7124, 258, 4, 6, "Print"],
Cell[345655, 7130, 748, 15, 6, "Print"],
Cell[346406, 7147, 215, 3, 6, "Print"]
}, Closed]],
Cell[346636, 7153, 1979, 58, 75, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[348652, 7216, 433, 9, 32, "Input"],
Cell[CellGroupData[{
Cell[349110, 7229, 446, 10, 23, "Print"],
Cell[349559, 7241, 201, 2, 6, "Print"],
Cell[349763, 7245, 411, 7, 6, "Print"],
Cell[350177, 7254, 234, 3, 6, "Print"],
Cell[350414, 7259, 712, 14, 6, "Print"],
Cell[351129, 7275, 192, 2, 6, "Print"]
}, Closed]],
Cell[351336, 7280, 1898, 50, 73, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[353283, 7336, 109, 1, 31, "Subsubtitle"],
Cell[CellGroupData[{
Cell[353417, 7341, 642, 14, 32, "Input"],
Cell[CellGroupData[{
Cell[354084, 7359, 423, 11, 23, "Print"],
Cell[354510, 7372, 180, 3, 6, "Print"],
Cell[354693, 7377, 402, 9, 6, "Print"],
Cell[355098, 7388, 211, 4, 6, "Print"],
Cell[355312, 7394, 686, 15, 6, "Print"],
Cell[356001, 7411, 169, 3, 6, "Print"]
}, Closed]],
Cell[356185, 7417, 2151, 56, 69, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[358397, 7480, 169, 2, 51, "Subtitle"],
Cell[358569, 7484, 90, 1, 31, "Text"],
Cell[358662, 7487, 221, 4, 32, "Input"],
Cell[CellGroupData[{
Cell[358908, 7495, 137, 2, 32, "Input"],
Cell[359048, 7499, 302, 5, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[359387, 7509, 961, 23, 99, "Input"],
Cell[CellGroupData[{
Cell[360373, 7536, 684, 14, 23, "Print"],
Cell[361060, 7552, 436, 6, 23, "Print"],
Cell[361499, 7560, 470, 7, 23, "Print"],
Cell[361972, 7569, 946, 18, 23, "Print"],
Cell[362921, 7589, 552, 10, 23, "Print"],
Cell[363476, 7601, 673, 12, 23, "Print"],
Cell[364152, 7615, 718, 15, 23, "Print"],
Cell[364873, 7632, 687, 14, 23, "Print"],
Cell[365563, 7648, 1103, 24, 23, "Print"]
}, Closed]],
Cell[366681, 7675, 2123, 59, 93, "Output"]
}, Open  ]],
Cell[368819, 7737, 90, 1, 31, "Text"],
Cell[CellGroupData[{
Cell[368934, 7742, 184, 3, 32, "Input"],
Cell[369121, 7747, 303, 5, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[369461, 7757, 1007, 23, 99, "Input"],
Cell[CellGroupData[{
Cell[370493, 7784, 397, 10, 23, "Print"],
Cell[370893, 7796, 154, 2, 23, "Print"],
Cell[371050, 7800, 185, 3, 23, "Print"],
Cell[371238, 7805, 661, 14, 23, "Print"],
Cell[371902, 7821, 265, 6, 23, "Print"],
Cell[372170, 7829, 389, 8, 23, "Print"],
Cell[372562, 7839, 874, 22, 23, "Print"],
Cell[373439, 7863, 818, 20, 23, "Print"]
}, Closed]],
Cell[374272, 7886, 241, 7, 24, "Message"],
Cell[374516, 7895, 2178, 61, 100, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[376731, 7961, 582, 15, 32, "Input"],
Cell[377316, 7978, 1232, 35, 67, "Output"]
}, Open  ]],
Cell[378563, 8016, 92, 1, 31, "Text"],
Cell[CellGroupData[{
Cell[378680, 8021, 135, 2, 32, "Input"],
Cell[378818, 8025, 191, 3, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[379046, 8033, 1023, 23, 99, "Input"],
Cell[CellGroupData[{
Cell[380094, 8060, 466, 11, 23, "Print"],
Cell[380563, 8073, 221, 3, 23, "Print"],
Cell[380787, 8078, 254, 4, 23, "Print"],
Cell[381044, 8084, 730, 15, 23, "Print"],
Cell[381777, 8101, 336, 7, 23, "Print"],
Cell[382116, 8110, 458, 9, 23, "Print"],
Cell[382577, 8121, 946, 23, 23, "Print"],
Cell[383526, 8146, 892, 21, 23, "Print"]
}, Closed]],
Cell[384433, 8170, 243, 7, 24, "Message"],
Cell[384679, 8179, 13783, 387, 519, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[398499, 8571, 582, 15, 32, "Input"],
Cell[399084, 8588, 7334, 200, 159, "Output"]
}, Open  ]],
Cell[406433, 8791, 89, 1, 31, "Text"],
Cell[CellGroupData[{
Cell[406547, 8796, 281, 4, 32, "Input"],
Cell[406831, 8802, 449, 7, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[407317, 8814, 1072, 24, 99, "Input"],
Cell[CellGroupData[{
Cell[408414, 8842, 518, 11, 23, "Print"],
Cell[408935, 8855, 273, 3, 23, "Print"],
Cell[409211, 8860, 306, 4, 23, "Print"],
Cell[409520, 8866, 781, 15, 23, "Print"],
Cell[410304, 8883, 386, 7, 23, "Print"],
Cell[410693, 8892, 510, 9, 23, "Print"],
Cell[411206, 8903, 554, 12, 23, "Print"],
Cell[411763, 8917, 523, 11, 23, "Print"],
Cell[412289, 8930, 939, 21, 23, "Print"]
}, Closed]],
Cell[413243, 8954, 5222, 152, 259, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[418502, 9111, 760, 18, 32, "Input"],
Cell[419265, 9131, 2674, 76, 95, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[421988, 9213, 107, 1, 51, "Subtitle"],
Cell[CellGroupData[{
Cell[422120, 9218, 136, 2, 32, "Input"],
Cell[CellGroupData[{
Cell[422281, 9224, 469, 7, 23, "Print"],
Cell[422753, 9233, 466, 7, 23, "Print"],
Cell[423222, 9242, 661, 14, 23, "Print"],
Cell[423886, 9258, 416, 6, 23, "Print"],
Cell[424305, 9266, 449, 7, 23, "Print"],
Cell[424757, 9275, 925, 18, 23, "Print"]
}, Open  ]],
Cell[425697, 9296, 777, 15, 24, "Message"],
Cell[CellGroupData[{
Cell[426499, 9315, 531, 10, 23, "Print"],
Cell[427033, 9327, 417, 6, 23, "Print"]
}, Open  ]],
Cell[427465, 9336, 394, 7, 65, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[427896, 9348, 651, 11, 26, "Input"],
Cell[CellGroupData[{
Cell[428572, 9363, 523, 8, 23, "Print"],
Cell[429098, 9373, 519, 8, 23, "Print"],
Cell[429620, 9383, 716, 15, 23, "Print"],
Cell[430339, 9400, 469, 7, 23, "Print"],
Cell[430811, 9409, 502, 8, 23, "Print"],
Cell[431316, 9419, 978, 19, 23, "Print"]
}, Open  ]],
Cell[432309, 9441, 465, 10, 24, "Message"],
Cell[CellGroupData[{
Cell[432799, 9455, 582, 11, 23, "Print"],
Cell[433384, 9468, 470, 7, 23, "Print"]
}, Open  ]],
Cell[433869, 9478, 481, 8, 65, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[434387, 9491, 239, 4, 26, "Input"],
Cell[CellGroupData[{
Cell[434651, 9499, 420, 6, 23, "Print"],
Cell[435074, 9507, 414, 6, 23, "Print"],
Cell[435491, 9515, 613, 13, 23, "Print"],
Cell[436107, 9530, 365, 5, 23, "Print"],
Cell[436475, 9537, 359, 5, 23, "Print"],
Cell[436837, 9544, 479, 9, 23, "Print"],
Cell[437319, 9555, 367, 5, 23, "Print"]
}, Open  ]],
Cell[437701, 9563, 357, 6, 65, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[438095, 9574, 136, 2, 26, "Input"],
Cell[CellGroupData[{
Cell[438256, 9580, 228, 3, 23, "Print"],
Cell[438487, 9585, 224, 3, 23, "Print"],
Cell[438714, 9590, 419, 10, 23, "Print"],
Cell[439136, 9602, 174, 2, 23, "Print"],
Cell[439313, 9606, 165, 2, 23, "Print"],
Cell[439481, 9610, 287, 6, 23, "Print"],
Cell[439771, 9618, 177, 2, 23, "Print"]
}, Open  ]],
Cell[439963, 9623, 156, 3, 32, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[440168, 9632, 147, 3, 51, "Subtitle"],
Cell[440318, 9637, 133, 3, 31, "Text"],
Cell[440454, 9642, 1256, 34, 181, "Input"],
Cell[CellGroupData[{
Cell[441735, 9680, 1326, 41, 69, "Input"],
Cell[443064, 9723, 147, 2, 34, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[443248, 9730, 821, 18, 32, "Input"],
Cell[CellGroupData[{
Cell[444094, 9752, 588, 13, 23, "Print"],
Cell[444685, 9767, 343, 5, 23, "Print"],
Cell[445031, 9774, 378, 6, 23, "Print"],
Cell[445412, 9782, 852, 17, 23, "Print"],
Cell[446267, 9801, 333, 5, 23, "Print"]
}, Open  ]],
Cell[446615, 9809, 3369, 94, 82, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[450021, 9908, 353, 10, 32, "Input"],
Cell[CellGroupData[{
Cell[450399, 9922, 228, 3, 23, "Print"],
Cell[450630, 9927, 226, 3, 23, "Print"],
Cell[450859, 9932, 421, 10, 23, "Print"],
Cell[451283, 9944, 173, 2, 23, "Print"],
Cell[451459, 9948, 165, 2, 23, "Print"],
Cell[451627, 9952, 287, 6, 23, "Print"],
Cell[451917, 9960, 175, 2, 23, "Print"]
}, Open  ]],
Cell[452107, 9965, 157, 3, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[452301, 9973, 436, 11, 32, "Input"],
Cell[CellGroupData[{
Cell[452762, 9988, 206, 3, 23, "Print"],
Cell[452971, 9993, 202, 3, 23, "Print"],
Cell[453176, 9998, 397, 10, 23, "Print"],
Cell[453576, 10010, 150, 2, 23, "Print"],
Cell[453729, 10014, 141, 2, 23, "Print"],
Cell[453873, 10018, 263, 6, 23, "Print"],
Cell[454139, 10026, 151, 2, 23, "Print"]
}, Open  ]],
Cell[454305, 10031, 134, 3, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[454476, 10039, 1061, 20, 55, "Input"],
Cell[CellGroupData[{
Cell[455562, 10063, 497, 12, 23, "Print"],
Cell[456062, 10077, 254, 4, 23, "Print"],
Cell[456319, 10083, 287, 5, 23, "Print"],
Cell[456609, 10090, 763, 16, 23, "Print"],
Cell[457375, 10108, 366, 8, 23, "Print"]
}, Open  ]],
Cell[457756, 10119, 47624, 1235, 242, "Output"]
}, Open  ]]
}, Closed]]
}
]
*)

(* End of internal cache information *)
