(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     94414,       2196]
NotebookOptionsPosition[     89547,       2052]
NotebookOutlinePosition[     90203,       2075]
CellTagsIndexPosition[     90160,       2072]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Coupling of a top, a higgs and a light quark\
\>", "Title",
 CellChangeTimes->{{3.583403598268314*^9, 3.583403644392417*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", "\"\</scratch/skrastanov/feynrules\>\"", "]"}]}], ";", 
  RowBox[{"<<", "FeynRules`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/thu\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<../SM/SM.fr\>\"", ",", " ", "\"\<thu.fr\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{"\"\<../SM/Cabibbo.rst\>\"", ",", "\"\<../SM/Massless.rst\>\""}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5757105960602818`*^9, 3.575710603935651*^9}, {
  3.57578243012792*^9, 3.5757824441106367`*^9}, {3.575782494158711*^9, 
  3.5757825305743513`*^9}, {3.575957845650674*^9, 3.575957871970462*^9}, {
  3.583403436740262*^9, 3.583403454740095*^9}, {3.583403662173706*^9, 
  3.583403662509575*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.583415335570386*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"1.7.178\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"28 May 2013\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "1.7.178", " (" "28 May 2013", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.583415335571521*^9}],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.583415335572721*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.5834153355738153`*^9}],

Cell[BoxData["\<\"Please cite: Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.583415335575014*^9}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.583415335576189*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.5834153355773163`*^9}],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.583415335578554*^9}],

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.583415337989997*^9}],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.583415338081379*^9}],

Cell[BoxData["\<\"McAuthor\"\>"], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.58341533808289*^9}],

Cell[BoxData["\<\"Poly Postdoc\"\>"], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.58341533808422*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"0\"\>"}],
  SequenceForm["Model Version: ", "0"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.583415338085723*^9}],

Cell[BoxData["\<\"exemple.com\"\>"], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.5834153380870543`*^9}],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.583415338088382*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.58341533809006*^9}],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.5834153380913553`*^9}],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.583415338195985*^9}],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.583415338197472*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"thu\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "thu", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.583415338273405*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"../SM/Cabibbo.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{13., {0., 7.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "6"}],
  SequenceForm["Loading restrictions from ", "../SM/Cabibbo.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 6],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.583415338861166*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"../SM/Massless.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{13., {0., 7.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18"}],
  SequenceForm["Loading restrictions from ", "../SM/Massless.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.5834153389822273`*^9}],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{
  3.5756354616924763`*^9, 3.575699011089006*^9, 3.575708992124817*^9, 
   3.575710561671961*^9, {3.575710605362877*^9, 3.575710619352478*^9}, 
   3.5757107735482283`*^9, 3.575714617065689*^9, {3.575714730848892*^9, 
   3.575714737315496*^9}, 3.5757148516602583`*^9, 3.575715506289091*^9, 
   3.575719883551283*^9, 3.57572020927063*^9, 3.575720656591461*^9, 
   3.57572077085436*^9, 3.575720888109211*^9, 3.575782459803651*^9, 
   3.5757825317226267`*^9, 3.575783264657056*^9, 3.575783318080265*^9, 
   3.575783384126301*^9, {3.575783415769002*^9, 3.5757834206898117`*^9}, 
   3.575783457118078*^9, {3.575803466423965*^9, 3.575803473620495*^9}, 
   3.575807557022588*^9, 3.575807635192937*^9, 3.57587094575677*^9, 
   3.575871832463529*^9, 3.575872127155285*^9, 3.575873120409257*^9, 
   3.575953932244513*^9, 3.575957138440948*^9, {3.575957454622562*^9, 
   3.5759574828996077`*^9}, 3.575957670406905*^9, 3.5759578792578506`*^9, 
   3.57595808689965*^9, 3.575958207410863*^9, 3.575958883457035*^9, {
   3.5759589740692263`*^9, 3.575958989623763*^9}, 3.5759591207074966`*^9, 
   3.575959696123766*^9, 3.575967125102757*^9, 3.576215803247912*^9, 
   3.583403664701638*^9, {3.583405554734682*^9, 3.583405574643551*^9}, {
   3.583409881912966*^9, 3.583409910058514*^9}, 3.5834144503439617`*^9, 
   3.583415118989789*^9, 3.5834153392828817`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"verts", "=", 
  RowBox[{"FeynmanRules", "[", 
   RowBox[{"Lthu", ",", "\[IndentingNewLine]", 
    RowBox[{"MaxParticles", "\[Rule]", "3"}], ",", 
    RowBox[{"Free", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"GP", ",", " ", "GPbar", ",", " ", "G0"}], "}"}]}], ",", 
    RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.57571861669071*^9, 3.5757186206385183`*^9}, {
  3.575720560719078*^9, 3.575720567406155*^9}, {3.5759568797261744`*^9, 
  3.575956943567664*^9}, {3.5759569991178017`*^9, 3.575957065070512*^9}, {
  3.575957166464693*^9, 3.575957215680324*^9}, {3.5759574338622293`*^9, 
  3.5759574385486727`*^9}, {3.575957905631774*^9, 3.575957935951001*^9}, {
  3.5834144586798077`*^9, 3.583414460638941*^9}, {3.583414657358889*^9, 
  3.5834146659163113`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.583414468822613*^9, 3.5834145102731667`*^9, 
  3.583414689462159*^9, 3.583415346471596*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.583414468822613*^9, 3.5834145102731667`*^9, 
  3.583414689462159*^9, 3.583415346472549*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.583414468822613*^9, 3.5834145102731667`*^9, 
  3.583414689462159*^9, 3.583415346473815*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.583414468822613*^9, 3.5834145102731667`*^9, 
  3.583414689462159*^9, 3.583415415694195*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "8", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{15.5625, {0., 6.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "8", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  8, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 8, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.583414468822613*^9, 3.5834145102731667`*^9, 
  3.583414689462159*^9, 3.583415415750979*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[8, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.583414468822613*^9, 3.5834145102731667`*^9, 
  3.583414689462159*^9, 3.58341541665555*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["t", "\<\"-\"\>"], "1"},
         {"u", "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SubscriptBox["o", 
           RowBox[{"13", " ", "uphi"}]], " ", 
          SubscriptBox["\[Delta]", 
           RowBox[{
            SubscriptBox["\<\"m\"\>", "1"], ",", 
            SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
          SubscriptBox[
           SubscriptBox["P", "\<\"-\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
          SuperscriptBox["ymt", "3"]}], 
         RowBox[{
          SuperscriptBox["\[CapitalLambda]", "2"], " ", "vev"}]]}], "-", 
       FractionBox[
        RowBox[{"3", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["o", 
          RowBox[{"31", " ", "uphi"}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"+\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SuperscriptBox["ymt", "3"]}], 
        RowBox[{
         SuperscriptBox["\[CapitalLambda]", "2"], " ", "vev"}]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["t", "\<\"-\"\>"], "1"},
         {"c", "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SubscriptBox["o", 
           RowBox[{"23", " ", "uphi"}]], " ", 
          SubscriptBox["\[Delta]", 
           RowBox[{
            SubscriptBox["\<\"m\"\>", "1"], ",", 
            SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
          SubscriptBox[
           SubscriptBox["P", "\<\"-\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
          SuperscriptBox["ymt", "3"]}], 
         RowBox[{
          SuperscriptBox["\[CapitalLambda]", "2"], " ", "vev"}]]}], "-", 
       FractionBox[
        RowBox[{"3", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["o", 
          RowBox[{"32", " ", "uphi"}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"+\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SuperscriptBox["ymt", "3"]}], 
        RowBox[{
         SuperscriptBox["\[CapitalLambda]", "2"], " ", "vev"}]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["u", "\<\"-\"\>"], "1"},
         {"t", "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SubscriptBox["o", 
           RowBox[{"31", " ", "uphi"}]], " ", 
          SubscriptBox["\[Delta]", 
           RowBox[{
            SubscriptBox["\<\"m\"\>", "1"], ",", 
            SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
          SubscriptBox[
           SubscriptBox["P", "\<\"-\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
          SuperscriptBox["ymt", "3"]}], 
         RowBox[{
          SuperscriptBox["\[CapitalLambda]", "2"], " ", "vev"}]]}], "-", 
       FractionBox[
        RowBox[{"3", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["o", 
          RowBox[{"13", " ", "uphi"}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"+\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SuperscriptBox["ymt", "3"]}], 
        RowBox[{
         SuperscriptBox["\[CapitalLambda]", "2"], " ", "vev"}]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["c", "\<\"-\"\>"], "1"},
         {"t", "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SubscriptBox["o", 
           RowBox[{"32", " ", "uphi"}]], " ", 
          SubscriptBox["\[Delta]", 
           RowBox[{
            SubscriptBox["\<\"m\"\>", "1"], ",", 
            SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
          SubscriptBox[
           SubscriptBox["P", "\<\"-\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
          SuperscriptBox["ymt", "3"]}], 
         RowBox[{
          SuperscriptBox["\[CapitalLambda]", "2"], " ", "vev"}]]}], "-", 
       FractionBox[
        RowBox[{"3", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["o", 
          RowBox[{"23", " ", "uphi"}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"+\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SuperscriptBox["ymt", "3"]}], 
        RowBox[{
         SuperscriptBox["\[CapitalLambda]", "2"], " ", "vev"}]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["u", "\<\"-\"\>"], "1"},
         {"t", "2"},
         {"G", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "ymt", " ", 
         SubsuperscriptBox["\<\"p\"\>", "3", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
         SubscriptBox["g", "s"], " ", 
         SubscriptBox["o", 
          RowBox[{"31", " ", "ug"}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}], 
          SubscriptBox["\<\"a\"\>", "3"]]}], 
        SuperscriptBox["\[CapitalLambda]", "2"]], "+", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "ymt", " ", 
         SubsuperscriptBox["\<\"p\"\>", "3", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
         SubscriptBox["g", "s"], " ", 
         SubscriptBox["o", 
          RowBox[{"13", " ", "ug"}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"+\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}], 
          SubscriptBox["\<\"a\"\>", "3"]]}], 
        SuperscriptBox["\[CapitalLambda]", "2"]], "-", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["g", "s"], " ", 
         SubscriptBox["o", 
          RowBox[{"31", " ", "ug"}]], " ", "ymt", " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           RowBox[{"SlashedP", "(", "3", ")"}], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}], 
          SubscriptBox["\<\"a\"\>", "3"]]}], 
        SuperscriptBox["\[CapitalLambda]", "2"]], "-", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["g", "s"], " ", 
         SubscriptBox["o", 
          RowBox[{"13", " ", "ug"}]], " ", "ymt", " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           RowBox[{"SlashedP", "(", "3", ")"}], ".", 
           SubscriptBox["P", "\<\"+\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}], 
          SubscriptBox["\<\"a\"\>", "3"]]}], 
        SuperscriptBox["\[CapitalLambda]", "2"]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["c", "\<\"-\"\>"], "1"},
         {"t", "2"},
         {"G", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "ymt", " ", 
         SubsuperscriptBox["\<\"p\"\>", "3", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
         SubscriptBox["g", "s"], " ", 
         SubscriptBox["o", 
          RowBox[{"32", " ", "ug"}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}], 
          SubscriptBox["\<\"a\"\>", "3"]]}], 
        SuperscriptBox["\[CapitalLambda]", "2"]], "+", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "ymt", " ", 
         SubsuperscriptBox["\<\"p\"\>", "3", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
         SubscriptBox["g", "s"], " ", 
         SubscriptBox["o", 
          RowBox[{"23", " ", "ug"}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"+\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}], 
          SubscriptBox["\<\"a\"\>", "3"]]}], 
        SuperscriptBox["\[CapitalLambda]", "2"]], "-", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["g", "s"], " ", 
         SubscriptBox["o", 
          RowBox[{"32", " ", "ug"}]], " ", "ymt", " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           RowBox[{"SlashedP", "(", "3", ")"}], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}], 
          SubscriptBox["\<\"a\"\>", "3"]]}], 
        SuperscriptBox["\[CapitalLambda]", "2"]], "-", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["g", "s"], " ", 
         SubscriptBox["o", 
          RowBox[{"23", " ", "ug"}]], " ", "ymt", " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           RowBox[{"SlashedP", "(", "3", ")"}], ".", 
           SubscriptBox["P", "\<\"+\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}], 
          SubscriptBox["\<\"a\"\>", "3"]]}], 
        SuperscriptBox["\[CapitalLambda]", "2"]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["t", "\<\"-\"\>"], "1"},
         {"u", "2"},
         {"G", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "ymt", " ", 
         SubsuperscriptBox["\<\"p\"\>", "3", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
         SubscriptBox["g", "s"], " ", 
         SubscriptBox["o", 
          RowBox[{"13", " ", "ug"}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}], 
          SubscriptBox["\<\"a\"\>", "3"]]}], 
        SuperscriptBox["\[CapitalLambda]", "2"]], "+", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "ymt", " ", 
         SubsuperscriptBox["\<\"p\"\>", "3", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
         SubscriptBox["g", "s"], " ", 
         SubscriptBox["o", 
          RowBox[{"31", " ", "ug"}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"+\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}], 
          SubscriptBox["\<\"a\"\>", "3"]]}], 
        SuperscriptBox["\[CapitalLambda]", "2"]], "-", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["g", "s"], " ", 
         SubscriptBox["o", 
          RowBox[{"13", " ", "ug"}]], " ", "ymt", " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           RowBox[{"SlashedP", "(", "3", ")"}], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}], 
          SubscriptBox["\<\"a\"\>", "3"]]}], 
        SuperscriptBox["\[CapitalLambda]", "2"]], "-", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["g", "s"], " ", 
         SubscriptBox["o", 
          RowBox[{"31", " ", "ug"}]], " ", "ymt", " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           RowBox[{"SlashedP", "(", "3", ")"}], ".", 
           SubscriptBox["P", "\<\"+\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}], 
          SubscriptBox["\<\"a\"\>", "3"]]}], 
        SuperscriptBox["\[CapitalLambda]", "2"]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          OverscriptBox["t", "\<\"-\"\>"], "1"},
         {"c", "2"},
         {"G", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "ymt", " ", 
         SubsuperscriptBox["\<\"p\"\>", "3", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
         SubscriptBox["g", "s"], " ", 
         SubscriptBox["o", 
          RowBox[{"23", " ", "ug"}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}], 
          SubscriptBox["\<\"a\"\>", "3"]]}], 
        SuperscriptBox["\[CapitalLambda]", "2"]], "+", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "ymt", " ", 
         SubsuperscriptBox["\<\"p\"\>", "3", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
         SubscriptBox["g", "s"], " ", 
         SubscriptBox["o", 
          RowBox[{"32", " ", "ug"}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"+\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}], 
          SubscriptBox["\<\"a\"\>", "3"]]}], 
        SuperscriptBox["\[CapitalLambda]", "2"]], "-", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["g", "s"], " ", 
         SubscriptBox["o", 
          RowBox[{"23", " ", "ug"}]], " ", "ymt", " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           RowBox[{"SlashedP", "(", "3", ")"}], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}], 
          SubscriptBox["\<\"a\"\>", "3"]]}], 
        SuperscriptBox["\[CapitalLambda]", "2"]], "-", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         SubscriptBox["g", "s"], " ", 
         SubscriptBox["o", 
          RowBox[{"32", " ", "ug"}]], " ", "ymt", " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           RowBox[{"SlashedP", "(", "3", ")"}], ".", 
           SubscriptBox["P", "\<\"+\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}], 
          SubscriptBox["\<\"a\"\>", "3"]]}], 
        SuperscriptBox["\[CapitalLambda]", "2"]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.583414737806924*^9, 3.58341506381066*^9, 
  3.583415416723378*^9, 3.5834158207045717`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CheckHermiticity", "[", "Lthu", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.575953965518354*^9, 3.5759539737415524`*^9}, {
  3.583414511117826*^9, 3.5834145130371027`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{
  3.575953974753036*^9, 3.5759591552626*^9, 3.575967148423678*^9, 
   3.5762158286814327`*^9, {3.583409977041298*^9, 3.583409986920431*^9}, 
   3.583414564478292*^9, 3.5834154214713173`*^9}],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{
  3.575953974753036*^9, 3.5759591552626*^9, 3.575967148423678*^9, 
   3.5762158286814327`*^9, {3.583409977041298*^9, 3.583409986920431*^9}, 
   3.583414564478292*^9, 3.583415421472363*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.575953974753036*^9, 3.5759591552626*^9, 3.575967148423678*^9, 
   3.5762158286814327`*^9, {3.583409977041298*^9, 3.583409986920431*^9}, 
   3.583414564478292*^9, 3.583415424399831*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.575953974753036*^9, 3.5759591552626*^9, 3.575967148423678*^9, 
   3.5762158286814327`*^9, {3.583409977041298*^9, 3.583409986920431*^9}, 
   3.583414564478292*^9, 3.583415424401155*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.575953974753036*^9, 3.5759591552626*^9, 3.575967148423678*^9, 
   3.5762158286814327`*^9, {3.583409977041298*^9, 3.583409986920431*^9}, 
   3.583414564478292*^9, 3.583415424402255*^9}],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{
  3.575953974753036*^9, 3.5759591552626*^9, 3.575967148423678*^9, 
   3.5762158286814327`*^9, {3.583409977041298*^9, 3.583409986920431*^9}, 
   3.583414564478292*^9, 3.5834154909831333`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.575953974753036*^9, 3.5759591552626*^9, 3.575967148423678*^9, 
   3.5762158286814327`*^9, {3.583409977041298*^9, 3.583409986920431*^9}, 
   3.583414564478292*^9, 3.583415490984572*^9}],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{
  3.575953974753036*^9, 3.5759591552626*^9, 3.575967148423678*^9, 
   3.5762158286814327`*^9, {3.583409977041298*^9, 3.583409986920431*^9}, 
   3.583414564478292*^9, 3.583415490985737*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Create UFO files", "Subtitle",
 CellChangeTimes->{{3.5834145350283737`*^9, 3.583414541239071*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DeleteDirectory", "[", 
   RowBox[{
    RowBox[{"$FeynRulesPath", "<>", "\"\</Models/thu/thu_UFO\>\""}], ",", 
    RowBox[{"DeleteContents", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", "\[IndentingNewLine]", 
   RowBox[{
   "LGauge", ",", "\[IndentingNewLine]", "LHiggs", ",", "\[IndentingNewLine]",
     "LFermions", ",", "\[IndentingNewLine]", "LYukawa", ",", 
    "\[IndentingNewLine]", "LGhost", ",", "\[IndentingNewLine]", "Lthu", ",", 
    "\[IndentingNewLine]", 
    RowBox[{"AddDecays", "\[Rule]", " ", "False"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DeleteDirectory", "[", 
   RowBox[{"\"\</scratch/skrastanov/mg5/models/thu_UFO\>\"", ",", 
    RowBox[{"DeleteContents", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CopyDirectory", "[", 
   RowBox[{
    RowBox[{"$FeynRulesPath", "<>", "\"\</Models/thu/thu_UFO\>\""}], ",", 
    " ", "\"\</scratch/skrastanov/mg5/models/thu_UFO\>\""}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.583403359029461*^9, 3.5834034023420887`*^9}, {
  3.5834145543228703`*^9, 3.583414556498189*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.5834154973922243`*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415499926992*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.5834154999284782`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415499929611*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415501079084*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "8", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{18., {0., 7.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "8", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  8, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 8, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415501166868*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[8, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415502094116*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415502096266*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415502097527*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415502228866*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "6", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{18., {0., 7.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "6", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  6, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 6, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.5834155023795137`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[6, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415502381679*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415502382786*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415502383852*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415502384933*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.5834155039153557`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "18", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{18., {0., 7.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  18, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 18, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.58341550399465*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"13", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[13, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415505059474*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415505128353*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415505129668*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415505320801*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "3", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{18., {0., 7.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  3, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 3, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415505388225*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[3, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415505456485*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415505457859*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415505458967*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415505530436*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{18., {0., 7.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.5834155055318003`*^9}],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415505533499*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415507747098*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415507748501*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.5834155077496347`*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.5834155760453997`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "114", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{18., {0., 7.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "114", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  114, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 114, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415576188849*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"114", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[114, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415588712144*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.5834155894528723`*^9}],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415594115102*^9}],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415594178371*^9}],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415594549169*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415594611931*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{18., {0., 7.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "189", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 189, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415595258161*^9}],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415595595439*^9}],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{3.5834147437321568`*^9, 3.583415134322645*^9, 
  3.583415595813684*^9}]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Addendum : Check Widths", "Subtitle",
 CellChangeTimes->{{3.5834145857147913`*^9, 3.583414595739143*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"myexpanded", " ", "=", " ", 
   RowBox[{"FlavorExpansion", "[", "verts", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CalculateM2Decays", "[", "myexpanded", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mydecays", " ", "=", " ", 
  RowBox[{"ComputeDecays", "[", 
   RowBox[{"%", ",", " ", 
    RowBox[{"Simplify", "\[Rule]", "True"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.5834146397125473`*^9, 3.5834146440947037`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.583414646051449*^9, 3.583415595971238*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.583414646051449*^9, 3.583415596182557*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{7., {0., 7.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "8"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 8],
  Editable->False]], "Print",
 CellChangeTimes->{3.583414646051449*^9, 3.583415596184051*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"Computing all the partial 1->2 decay widths: \"\>",
    StripOnInput->False,
    LineColor->RGBColor[1, 0.5, 0],
    FrontFaceColor->RGBColor[1, 0.5, 0],
    BackFaceColor->RGBColor[1, 0.5, 0],
    GraphicsColor->RGBColor[1, 0.5, 0],
    FontWeight->Bold,
    FontColor->RGBColor[1, 0.5, 0]], "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$DecayCntb, StandardForm],
    ImageSizeCache->{7., {0., 7.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "8"}],
  SequenceForm[
   Style["Computing all the partial 1->2 decay widths: ", 
    RGBColor[1, 0.5, 0], Bold], 
   Dynamic[FeynRules`FR$DecayCntb], " / ", 8],
  Editable->False]], "Print",
 CellChangeTimes->{3.583414646051449*^9, 3.5834156098476543`*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"{", 
       RowBox[{"H", ",", "t", ",", 
        OverscriptBox["u", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{"27", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["MH", "2"], "-", 
           SuperscriptBox["MT", "2"]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubsuperscriptBox["o", 
           RowBox[{"13", " ", "uphi"}], "2"], "+", 
          SubsuperscriptBox["o", 
           RowBox[{"31", " ", "uphi"}], "2"]}], ")"}], " ", 
        SuperscriptBox["ymt", "6"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["\[CapitalLambda]", "4"], " ", "\[Pi]", " ", 
        SuperscriptBox["vev", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MH"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"H", ",", "t", ",", 
        OverscriptBox["c", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{"27", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["MH", "2"], "-", 
           SuperscriptBox["MT", "2"]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubsuperscriptBox["o", 
           RowBox[{"23", " ", "uphi"}], "2"], "+", 
          SubsuperscriptBox["o", 
           RowBox[{"32", " ", "uphi"}], "2"]}], ")"}], " ", 
        SuperscriptBox["ymt", "6"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["\[CapitalLambda]", "4"], " ", "\[Pi]", " ", 
        SuperscriptBox["vev", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MH"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"H", ",", "u", ",", 
        OverscriptBox["t", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{"27", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["MH", "2"], "-", 
           SuperscriptBox["MT", "2"]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubsuperscriptBox["o", 
           RowBox[{"13", " ", "uphi"}], "2"], "+", 
          SubsuperscriptBox["o", 
           RowBox[{"31", " ", "uphi"}], "2"]}], ")"}], " ", 
        SuperscriptBox["ymt", "6"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["\[CapitalLambda]", "4"], " ", "\[Pi]", " ", 
        SuperscriptBox["vev", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MH"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"t", ",", "H", ",", "u"}], "}"}], 
      FractionBox[
       RowBox[{"9", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["MH", "2"], "-", 
           SuperscriptBox["MT", "2"]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubsuperscriptBox["o", 
           RowBox[{"13", " ", "uphi"}], "2"], "+", 
          SubsuperscriptBox["o", 
           RowBox[{"31", " ", "uphi"}], "2"]}], ")"}], " ", 
        SuperscriptBox["ymt", "6"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["\[CapitalLambda]", "4"], " ", "\[Pi]", " ", 
        SuperscriptBox["vev", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MT"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"H", ",", "c", ",", 
        OverscriptBox["t", "\<\"-\"\>"]}], "}"}], 
      FractionBox[
       RowBox[{"27", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["MH", "2"], "-", 
           SuperscriptBox["MT", "2"]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubsuperscriptBox["o", 
           RowBox[{"23", " ", "uphi"}], "2"], "+", 
          SubsuperscriptBox["o", 
           RowBox[{"32", " ", "uphi"}], "2"]}], ")"}], " ", 
        SuperscriptBox["ymt", "6"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["\[CapitalLambda]", "4"], " ", "\[Pi]", " ", 
        SuperscriptBox["vev", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MH"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"t", ",", "H", ",", "c"}], "}"}], 
      FractionBox[
       RowBox[{"9", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["MH", "2"], "-", 
           SuperscriptBox["MT", "2"]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubsuperscriptBox["o", 
           RowBox[{"23", " ", "uphi"}], "2"], "+", 
          SubsuperscriptBox["o", 
           RowBox[{"32", " ", "uphi"}], "2"]}], ")"}], " ", 
        SuperscriptBox["ymt", "6"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["\[CapitalLambda]", "4"], " ", "\[Pi]", " ", 
        SuperscriptBox["vev", "2"], " ", 
        SuperscriptBox[
         TemplateBox[{"MT"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"t", ",", "G", ",", "u"}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["G", "2"], " ", 
        SuperscriptBox["MT", "6"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubsuperscriptBox["o", 
           RowBox[{"13", " ", "ug"}], "2"], "+", 
          SubsuperscriptBox["o", 
           RowBox[{"31", " ", "ug"}], "2"]}], ")"}], " ", 
        SuperscriptBox["ymt", "2"]}], 
       RowBox[{"3", " ", 
        SuperscriptBox["\[CapitalLambda]", "4"], " ", "\[Pi]", " ", 
        SuperscriptBox[
         TemplateBox[{"MT"},
          "Abs"], "3"]}]]},
     {
      RowBox[{"{", 
       RowBox[{"t", ",", "G", ",", "c"}], "}"}], 
      FractionBox[
       RowBox[{
        SuperscriptBox["G", "2"], " ", 
        SuperscriptBox["MT", "6"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubsuperscriptBox["o", 
           RowBox[{"23", " ", "ug"}], "2"], "+", 
          SubsuperscriptBox["o", 
           RowBox[{"32", " ", "ug"}], "2"]}], ")"}], " ", 
        SuperscriptBox["ymt", "2"]}], 
       RowBox[{"3", " ", 
        SuperscriptBox["\[CapitalLambda]", "4"], " ", "\[Pi]", " ", 
        SuperscriptBox[
         TemplateBox[{"MT"},
          "Abs"], "3"]}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.5834146603793592`*^9, 3.5834146751570063`*^9}, 
   3.583415609889741*^9, 3.583415845268197*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericalValue", "[", 
  RowBox[{
   RowBox[{"mydecays", "[", 
    RowBox[{"[", "4", "]"}], "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.583416336878539*^9, 3.5834163954381638`*^9}}],

Cell[BoxData["0.0034648283442891216`"], "Output",
 CellChangeTimes->{{3.58341634382663*^9, 3.5834163961874447`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{607, 961},
WindowMargins->{{Automatic, 73}, {0, Automatic}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperOrientation"->"Portrait",
"PaperSize"->{594.75, 842.25},
"PostScriptOutputFile"->"/home/skrastanov/printm1.pdf"},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->0.75,
FrontEndVersion->"9.0 for Linux x86 (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 135, 3, 113, "Title"],
Cell[705, 27, 52, 1, 24, "Input"],
Cell[CellGroupData[{
Cell[782, 32, 964, 22, 93, "Input"],
Cell[CellGroupData[{
Cell[1771, 58, 1408, 20, 18, "Print"],
Cell[3182, 80, 1681, 27, 18, "Print"],
Cell[4866, 109, 1460, 21, 18, "Print"],
Cell[6329, 132, 1396, 20, 18, "Print"],
Cell[7728, 154, 1464, 21, 18, "Print"],
Cell[9195, 177, 1424, 20, 18, "Print"],
Cell[10622, 199, 1396, 20, 18, "Print"],
Cell[12021, 221, 1461, 21, 18, "Print"],
Cell[13485, 244, 1415, 20, 18, "Print"],
Cell[14903, 266, 1433, 20, 18, "Print"],
Cell[16339, 288, 1400, 20, 18, "Print"],
Cell[17742, 310, 1404, 20, 18, "Print"],
Cell[19149, 332, 1535, 24, 18, "Print"],
Cell[20687, 358, 1406, 20, 18, "Print"],
Cell[22096, 380, 1441, 21, 18, "Print"],
Cell[23540, 403, 1392, 20, 18, "Print"],
Cell[24935, 425, 1425, 20, 18, "Print"],
Cell[26363, 447, 1426, 20, 18, "Print"],
Cell[27792, 469, 1424, 20, 18, "Print"],
Cell[29219, 491, 1583, 25, 32, "Print"],
Cell[30805, 518, 1888, 30, 18, "Print"],
Cell[32696, 550, 1894, 30, 18, "Print"],
Cell[34593, 582, 1415, 20, 18, "Print"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36057, 608, 828, 15, 38, "Input"],
Cell[CellGroupData[{
Cell[36910, 627, 419, 10, 18, "Print"],
Cell[37332, 639, 174, 2, 18, "Print"],
Cell[37509, 643, 348, 7, 18, "Print"],
Cell[37860, 652, 207, 3, 18, "Print"],
Cell[38070, 657, 688, 14, 32, "Print"],
Cell[38761, 673, 286, 6, 18, "Print"]
}, Open  ]],
Cell[39062, 682, 23036, 604, 393, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62135, 1291, 209, 4, 24, "Input"],
Cell[CellGroupData[{
Cell[62369, 1299, 326, 5, 32, "Print"],
Cell[62698, 1306, 320, 5, 18, "Print"],
Cell[63021, 1313, 515, 12, 18, "Print"],
Cell[63539, 1327, 270, 4, 18, "Print"],
Cell[63812, 1333, 444, 9, 18, "Print"],
Cell[64259, 1344, 263, 4, 18, "Print"],
Cell[64525, 1350, 383, 8, 18, "Print"],
Cell[64911, 1360, 271, 4, 18, "Print"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[65231, 1370, 104, 1, 38, "Subtitle"],
Cell[CellGroupData[{
Cell[65360, 1375, 1201, 28, 246, "Input"],
Cell[CellGroupData[{
Cell[66586, 1407, 176, 3, 18, "Print"],
Cell[66765, 1412, 397, 10, 18, "Print"],
Cell[67165, 1424, 154, 2, 18, "Print"],
Cell[67322, 1428, 326, 7, 18, "Print"],
Cell[67651, 1437, 185, 3, 18, "Print"],
Cell[67839, 1442, 662, 14, 32, "Print"],
Cell[68504, 1458, 265, 6, 18, "Print"],
Cell[68772, 1466, 397, 10, 18, "Print"],
Cell[69172, 1478, 152, 2, 18, "Print"],
Cell[69327, 1482, 185, 3, 18, "Print"],
Cell[69515, 1487, 664, 14, 32, "Print"],
Cell[70182, 1503, 265, 6, 18, "Print"],
Cell[70450, 1511, 397, 10, 18, "Print"],
Cell[70850, 1523, 152, 2, 18, "Print"],
Cell[71005, 1527, 326, 7, 18, "Print"],
Cell[71334, 1536, 187, 3, 18, "Print"],
Cell[71524, 1541, 665, 14, 32, "Print"],
Cell[72192, 1557, 267, 6, 18, "Print"],
Cell[72462, 1565, 397, 10, 18, "Print"],
Cell[72862, 1577, 152, 2, 18, "Print"],
Cell[73017, 1581, 185, 3, 18, "Print"],
Cell[73205, 1586, 662, 14, 32, "Print"],
Cell[73870, 1602, 265, 6, 18, "Print"],
Cell[74138, 1610, 397, 10, 18, "Print"],
Cell[74538, 1622, 152, 2, 18, "Print"],
Cell[74693, 1626, 185, 3, 18, "Print"],
Cell[74881, 1631, 664, 14, 32, "Print"],
Cell[75548, 1647, 143, 2, 18, "Print"],
Cell[75694, 1651, 397, 10, 18, "Print"],
Cell[76094, 1663, 152, 2, 18, "Print"],
Cell[76249, 1667, 328, 7, 18, "Print"],
Cell[76580, 1676, 187, 3, 18, "Print"],
Cell[76770, 1681, 670, 14, 32, "Print"],
Cell[77443, 1697, 269, 6, 18, "Print"],
Cell[77715, 1705, 391, 8, 18, "Print"],
Cell[78109, 1715, 166, 2, 18, "Print"],
Cell[78278, 1719, 149, 2, 18, "Print"],
Cell[78430, 1723, 173, 3, 18, "Print"],
Cell[78606, 1728, 364, 7, 18, "Print"],
Cell[78973, 1737, 523, 10, 18, "Print"],
Cell[79499, 1749, 145, 2, 18, "Print"],
Cell[79647, 1753, 130, 2, 18, "Print"]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[79838, 1762, 111, 1, 38, "Subtitle"],
Cell[CellGroupData[{
Cell[79974, 1767, 486, 12, 59, "Input"],
Cell[CellGroupData[{
Cell[80485, 1783, 362, 7, 18, "Print"],
Cell[80850, 1792, 406, 10, 18, "Print"],
Cell[81259, 1804, 373, 9, 18, "Print"],
Cell[81635, 1815, 793, 19, 18, "Print"]
}, Open  ]],
Cell[82443, 1837, 6660, 196, 295, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[89140, 2038, 248, 6, 24, "Input"],
Cell[89391, 2046, 116, 1, 24, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
