# This file was automatically created by FeynRules 2.3.49
# Mathematica version: 13.0.1 for Linux x86 (64-bit) (January 29, 2022)
# Date: Wed 24 Jan 2024 16:39:22



from object_library import all_parameters, Parameter


from function_library import complexconjugate, re, im, csc, sec, acsc, asec, cot

# This is a default parameter object representing 0.
ZERO = Parameter(name = 'ZERO',
                 nature = 'internal',
                 type = 'real',
                 value = '0.0',
                 texname = '0')

# User-defined parameters.
cabi = Parameter(name = 'cabi',
                 nature = 'external',
                 type = 'real',
                 value = 0.227736,
                 texname = '\\theta _c',
                 lhablock = 'CKMBLOCK',
                 lhacode = [ 1 ])

Mmaj = Parameter(name = 'Mmaj',
                 nature = 'external',
                 type = 'real',
                 value = 20,
                 texname = 'm_M',
                 lhablock = 'pSPSS',
                 lhacode = [ 1 ])

deltaM = Parameter(name = 'deltaM',
                   nature = 'external',
                   type = 'real',
                   value = 1.e-12,
                   texname = '\\delta _m',
                   lhablock = 'pSPSS',
                   lhacode = [ 2 ])

theta1 = Parameter(name = 'theta1',
                   nature = 'external',
                   type = 'real',
                   value = 0,
                   texname = '\\theta _1',
                   lhablock = 'pSPSS',
                   lhacode = [ 3 ])

theta2 = Parameter(name = 'theta2',
                   nature = 'external',
                   type = 'real',
                   value = 0.0001,
                   texname = '\\theta _2',
                   lhablock = 'pSPSS',
                   lhacode = [ 4 ])

theta3 = Parameter(name = 'theta3',
                   nature = 'external',
                   type = 'real',
                   value = 0,
                   texname = '\\theta _3',
                   lhablock = 'pSPSS',
                   lhacode = [ 5 ])

damping = Parameter(name = 'damping',
                    nature = 'external',
                    type = 'real',
                    value = 0,
                    texname = '\\text{damping}',
                    lhablock = 'pSPSS',
                    lhacode = [ 6 ])

aEWM1 = Parameter(name = 'aEWM1',
                  nature = 'external',
                  type = 'real',
                  value = 127.9,
                  texname = '\\text{aEWM1}',
                  lhablock = 'SMINPUTS',
                  lhacode = [ 1 ])

Gf = Parameter(name = 'Gf',
               nature = 'external',
               type = 'real',
               value = 0.0000116637,
               texname = 'G_F',
               lhablock = 'SMINPUTS',
               lhacode = [ 2 ])

aS = Parameter(name = 'aS',
               nature = 'external',
               type = 'real',
               value = 0.1184,
               texname = '\\alpha _s',
               lhablock = 'SMINPUTS',
               lhacode = [ 3 ])

ymdo = Parameter(name = 'ymdo',
                 nature = 'external',
                 type = 'real',
                 value = 0.00504,
                 texname = '\\text{ymdo}',
                 lhablock = 'YUKAWA',
                 lhacode = [ 1 ])

ymup = Parameter(name = 'ymup',
                 nature = 'external',
                 type = 'real',
                 value = 0.00255,
                 texname = '\\text{ymup}',
                 lhablock = 'YUKAWA',
                 lhacode = [ 2 ])

yms = Parameter(name = 'yms',
                nature = 'external',
                type = 'real',
                value = 0.101,
                texname = '\\text{yms}',
                lhablock = 'YUKAWA',
                lhacode = [ 3 ])

ymc = Parameter(name = 'ymc',
                nature = 'external',
                type = 'real',
                value = 1.27,
                texname = '\\text{ymc}',
                lhablock = 'YUKAWA',
                lhacode = [ 4 ])

ymb = Parameter(name = 'ymb',
                nature = 'external',
                type = 'real',
                value = 4.7,
                texname = '\\text{ymb}',
                lhablock = 'YUKAWA',
                lhacode = [ 5 ])

ymt = Parameter(name = 'ymt',
                nature = 'external',
                type = 'real',
                value = 172,
                texname = '\\text{ymt}',
                lhablock = 'YUKAWA',
                lhacode = [ 6 ])

yme = Parameter(name = 'yme',
                nature = 'external',
                type = 'real',
                value = 0.000511,
                texname = '\\text{yme}',
                lhablock = 'YUKAWA',
                lhacode = [ 11 ])

ymm = Parameter(name = 'ymm',
                nature = 'external',
                type = 'real',
                value = 0.10566,
                texname = '\\text{ymm}',
                lhablock = 'YUKAWA',
                lhacode = [ 13 ])

ymtau = Parameter(name = 'ymtau',
                  nature = 'external',
                  type = 'real',
                  value = 1.777,
                  texname = '\\text{ymtau}',
                  lhablock = 'YUKAWA',
                  lhacode = [ 15 ])

mZ = Parameter(name = 'mZ',
               nature = 'external',
               type = 'real',
               value = 91.1876,
               texname = '\\text{mZ}',
               lhablock = 'MASS',
               lhacode = [ 23 ])

me = Parameter(name = 'me',
               nature = 'external',
               type = 'real',
               value = 0.000511,
               texname = '\\text{me}',
               lhablock = 'MASS',
               lhacode = [ 11 ])

mmu = Parameter(name = 'mmu',
                nature = 'external',
                type = 'real',
                value = 0.10566,
                texname = '\\text{mmu}',
                lhablock = 'MASS',
                lhacode = [ 13 ])

mta = Parameter(name = 'mta',
                nature = 'external',
                type = 'real',
                value = 1.777,
                texname = '\\text{mta}',
                lhablock = 'MASS',
                lhacode = [ 15 ])

mup = Parameter(name = 'mup',
                nature = 'external',
                type = 'real',
                value = 0.00255,
                texname = '\\text{mup}',
                lhablock = 'MASS',
                lhacode = [ 2 ])

mc = Parameter(name = 'mc',
               nature = 'external',
               type = 'real',
               value = 1.27,
               texname = '\\text{mc}',
               lhablock = 'MASS',
               lhacode = [ 4 ])

mt = Parameter(name = 'mt',
               nature = 'external',
               type = 'real',
               value = 172,
               texname = '\\text{mt}',
               lhablock = 'MASS',
               lhacode = [ 6 ])

md = Parameter(name = 'md',
               nature = 'external',
               type = 'real',
               value = 0.00504,
               texname = '\\text{md}',
               lhablock = 'MASS',
               lhacode = [ 1 ])

ms = Parameter(name = 'ms',
               nature = 'external',
               type = 'real',
               value = 0.101,
               texname = '\\text{ms}',
               lhablock = 'MASS',
               lhacode = [ 3 ])

mb = Parameter(name = 'mb',
               nature = 'external',
               type = 'real',
               value = 4.7,
               texname = '\\text{mb}',
               lhablock = 'MASS',
               lhacode = [ 5 ])

MH = Parameter(name = 'MH',
               nature = 'external',
               type = 'real',
               value = 125,
               texname = '\\text{MH}',
               lhablock = 'MASS',
               lhacode = [ 25 ])

WZ = Parameter(name = 'WZ',
               nature = 'external',
               type = 'real',
               value = 2.4952,
               texname = '\\text{WZ}',
               lhablock = 'DECAY',
               lhacode = [ 23 ])

WW = Parameter(name = 'WW',
               nature = 'external',
               type = 'real',
               value = 2.085,
               texname = '\\text{WW}',
               lhablock = 'DECAY',
               lhacode = [ 24 ])

WT = Parameter(name = 'WT',
               nature = 'external',
               type = 'real',
               value = 1.50833649,
               texname = '\\text{WT}',
               lhablock = 'DECAY',
               lhacode = [ 6 ])

Wn4 = Parameter(name = 'Wn4',
                nature = 'external',
                type = 'real',
                value = 0.00001,
                texname = '\\text{Wn4}',
                lhablock = 'DECAY',
                lhacode = [ 8000011 ])

Wn5 = Parameter(name = 'Wn5',
                nature = 'external',
                type = 'real',
                value = 0.00001,
                texname = '\\text{Wn5}',
                lhablock = 'DECAY',
                lhacode = [ 8000012 ])

WH = Parameter(name = 'WH',
               nature = 'external',
               type = 'real',
               value = 0.00407,
               texname = '\\text{WH}',
               lhablock = 'DECAY',
               lhacode = [ 25 ])

thetasqr = Parameter(name = 'thetasqr',
                     nature = 'internal',
                     type = 'real',
                     value = 'theta1**2 + theta2**2 + theta3**2',
                     texname = '\\text{thetasqr}')

aEW = Parameter(name = 'aEW',
                nature = 'internal',
                type = 'real',
                value = '1/aEWM1',
                texname = '\\alpha _{\\text{EW}}')

G = Parameter(name = 'G',
              nature = 'internal',
              type = 'real',
              value = '2*cmath.sqrt(aS)*cmath.sqrt(cmath.pi)',
              texname = 'G')

CKM1x1 = Parameter(name = 'CKM1x1',
                   nature = 'internal',
                   type = 'complex',
                   value = 'cmath.cos(cabi)',
                   texname = '\\text{CKM1x1}')

CKM1x2 = Parameter(name = 'CKM1x2',
                   nature = 'internal',
                   type = 'complex',
                   value = 'cmath.sin(cabi)',
                   texname = '\\text{CKM1x2}')

CKM1x3 = Parameter(name = 'CKM1x3',
                   nature = 'internal',
                   type = 'complex',
                   value = '0',
                   texname = '\\text{CKM1x3}')

CKM2x1 = Parameter(name = 'CKM2x1',
                   nature = 'internal',
                   type = 'complex',
                   value = '-cmath.sin(cabi)',
                   texname = '\\text{CKM2x1}')

CKM2x2 = Parameter(name = 'CKM2x2',
                   nature = 'internal',
                   type = 'complex',
                   value = 'cmath.cos(cabi)',
                   texname = '\\text{CKM2x2}')

CKM2x3 = Parameter(name = 'CKM2x3',
                   nature = 'internal',
                   type = 'complex',
                   value = '0',
                   texname = '\\text{CKM2x3}')

CKM3x1 = Parameter(name = 'CKM3x1',
                   nature = 'internal',
                   type = 'complex',
                   value = '0',
                   texname = '\\text{CKM3x1}')

CKM3x2 = Parameter(name = 'CKM3x2',
                   nature = 'internal',
                   type = 'complex',
                   value = '0',
                   texname = '\\text{CKM3x2}')

CKM3x3 = Parameter(name = 'CKM3x3',
                   nature = 'internal',
                   type = 'complex',
                   value = '1',
                   texname = '\\text{CKM3x3}')

mn4 = Parameter(name = 'mn4',
                nature = 'internal',
                type = 'real',
                value = '-0.5*deltaM + Mmaj*(1 + thetasqr/2.)',
                texname = 'M_4')

mn5 = Parameter(name = 'mn5',
                nature = 'internal',
                type = 'real',
                value = 'deltaM/2. + Mmaj*(1 + thetasqr/2.)',
                texname = 'M_5')

mW = Parameter(name = 'mW',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(mZ**2/2. + cmath.sqrt(mZ**4/4. - (aEW*cmath.pi*mZ**2)/(Gf*cmath.sqrt(2))))',
               texname = 'M_W')

ee = Parameter(name = 'ee',
               nature = 'internal',
               type = 'real',
               value = '2*cmath.sqrt(aEW)*cmath.sqrt(cmath.pi)',
               texname = 'e')

sw2 = Parameter(name = 'sw2',
                nature = 'internal',
                type = 'real',
                value = '1 - mW**2/mZ**2',
                texname = '\\text{sw2}')

cw = Parameter(name = 'cw',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(1 - sw2)',
               texname = 'c_w')

sw = Parameter(name = 'sw',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(sw2)',
               texname = 's_w')

g1 = Parameter(name = 'g1',
               nature = 'internal',
               type = 'real',
               value = 'ee/cw',
               texname = 'g_1')

gw = Parameter(name = 'gw',
               nature = 'internal',
               type = 'real',
               value = 'ee/sw',
               texname = 'g_w')

vev = Parameter(name = 'vev',
                nature = 'internal',
                type = 'real',
                value = '(mW*sw*cmath.sqrt(2))/ee',
                texname = 'v')

vevNP = Parameter(name = 'vevNP',
                  nature = 'internal',
                  type = 'real',
                  value = '(mW*sw*cmath.sqrt(2))/ee',
                  texname = 'v')

yvn1 = Parameter(name = 'yvn1',
                 nature = 'internal',
                 type = 'real',
                 value = '(Mmaj*theta1)/vevNP',
                 texname = 'y^{\\nu _1}')

yvn2 = Parameter(name = 'yvn2',
                 nature = 'internal',
                 type = 'real',
                 value = '(Mmaj*theta2)/vevNP',
                 texname = 'y^{\\nu _2}')

yvn3 = Parameter(name = 'yvn3',
                 nature = 'internal',
                 type = 'real',
                 value = '(Mmaj*theta3)/vevNP',
                 texname = 'y^{\\nu _3}')

lam = Parameter(name = 'lam',
                nature = 'internal',
                type = 'real',
                value = 'MH**2/(4.*vev**2)',
                texname = '\\lambda')

yb = Parameter(name = 'yb',
               nature = 'internal',
               type = 'real',
               value = 'ymb/vev',
               texname = '\\text{yb}')

yc = Parameter(name = 'yc',
               nature = 'internal',
               type = 'real',
               value = 'ymc/vev',
               texname = '\\text{yc}')

ydo = Parameter(name = 'ydo',
                nature = 'internal',
                type = 'real',
                value = 'ymdo/vev',
                texname = '\\text{ydo}')

ye = Parameter(name = 'ye',
               nature = 'internal',
               type = 'real',
               value = 'yme/vev',
               texname = '\\text{ye}')

ym = Parameter(name = 'ym',
               nature = 'internal',
               type = 'real',
               value = 'ymm/vev',
               texname = '\\text{ym}')

ys = Parameter(name = 'ys',
               nature = 'internal',
               type = 'real',
               value = 'yms/vev',
               texname = '\\text{ys}')

yt = Parameter(name = 'yt',
               nature = 'internal',
               type = 'real',
               value = 'ymt/vev',
               texname = '\\text{yt}')

ytau = Parameter(name = 'ytau',
                 nature = 'internal',
                 type = 'real',
                 value = 'ymtau/vev',
                 texname = '\\text{ytau}')

yup = Parameter(name = 'yup',
                nature = 'internal',
                type = 'real',
                value = 'ymup/vev',
                texname = '\\text{yup}')

muH = Parameter(name = 'muH',
                nature = 'internal',
                type = 'real',
                value = 'vev*cmath.sqrt(2)*cmath.sqrt(lam)',
                texname = '\\mu')

