(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    211523,       4550]
NotebookOptionsPosition[    162802,       3615]
NotebookOutlinePosition[    183957,       4045]
CellTagsIndexPosition[    183914,       4042]
WindowTitle->SM_with_pNG.nb
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Pseudo-Nambu-Goldstone Dark Matter\n",
 StyleBox["Based on: C. Gross, O. Lebedev and T. Toma [arXiv:1708.02253]", 
  "Subtitle"],
 StyleBox["\n", "Subchapter"],
 StyleBox["Author: Ankit Beniwal (CP3, UCLouvain)\nEmail: \
ankit.beniwal@uclouvain.be\nLast modified: Mar, Apr 2019", "Subsection"]
}], "Title",
 CellChangeTimes->{{3.7609450290469637`*^9, 3.76094505638911*^9}, {
  3.7609616680713053`*^9, 3.760961700619087*^9}, {3.761039310552822*^9, 
  3.7610393298226023`*^9}, {3.761039668320422*^9, 3.761039668484126*^9}, {
  3.76105136569417*^9, 3.7610514169989977`*^9}, {3.761224404608835*^9, 
  3.76122442013498*^9}, {3.761376507495722*^9, 3.761376572715755*^9}, {
  3.761382718271511*^9, 3.761382720716045*^9}, {3.761563013876987*^9, 
  3.7615630286742897`*^9}, {3.76164637317334*^9, 3.761646379154291*^9}, {
  3.761647916922364*^9, 3.7616479169227543`*^9}, {3.761655226957109*^9, 
  3.761655228347907*^9}, {3.7639021800286427`*^9, 3.763902182660822*^9}, {
  3.764393125347082*^9, 3.764393137939487*^9}, {3.764413556231992*^9, 
  3.7644135932497597`*^9}, {3.779710847902232*^9, 3.779710848504632*^9}},
 CellID->281390532,ExpressionUUID->"d539e99e-3778-4dc6-8232-a8ff8dd31e65"],

Cell[CellGroupData[{

Cell["Load the FeynRules package", "Section",
 CellChangeTimes->{{3.7609453145561047`*^9, 3.760945353548984*^9}, {
  3.760945416768804*^9, 3.760945440787341*^9}, {3.7610514196881104`*^9, 
  3.761051422252089*^9}},
 CellID->1358143829,ExpressionUUID->"c72f400a-8139-41f9-9fbe-bd420ab97f1d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.76094535633109*^9, 3.7609453950437517`*^9}, {
  3.761056041541994*^9, 3.7610560721528378`*^9}, {3.761384598519239*^9, 
  3.761384599327896*^9}, {3.764332546648679*^9, 3.764332547356412*^9}},
 CellLabel->"In[1]:=",
 CellID->2670957,ExpressionUUID->"bfff4caa-bcf4-4d8d-b1f4-b00710edd0f8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$FeynRulesPath", "=", 
  RowBox[{"SetDirectory", "[", 
   RowBox[{
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<../../\>\""}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.761056085190226*^9, 3.7610560857528276`*^9}, {
   3.761902435347582*^9, 3.76190243626408*^9}, {3.7634418666816273`*^9, 
   3.763441870108839*^9}, {3.763441912754735*^9, 3.763441932599285*^9}, {
   3.765180180470434*^9, 3.765180198664114*^9}, {3.7651802503940153`*^9, 
   3.765180264790156*^9}, 3.765180329333486*^9, {3.765180376825309*^9, 
   3.765180380294485*^9}},
 CellLabel->"In[1]:=",
 CellID->768162998,ExpressionUUID->"da00745e-07d3-4b8e-bb09-6d421dbad650"],

Cell[BoxData["\<\"/Users/ankitbeniwal/Documents/Projects/U1_DM/feynrules-\
current\"\>"], "Output",
 CellChangeTimes->{{3.76105608755882*^9, 3.761056098188025*^9}, 
   3.7610569036487093`*^9, 3.7610573507691097`*^9, 3.76105902205711*^9, {
   3.7612244391908817`*^9, 3.7612244664929247`*^9}, 3.7612249553167763`*^9, 
   3.761225300368449*^9, {3.7612873311295633`*^9, 3.761287355039419*^9}, 
   3.7612873995190353`*^9, 3.761376611006*^9, 3.761382764442033*^9, 
   3.761384382777412*^9, 3.76138449623738*^9, 3.761384602764518*^9, 
   3.76138622753712*^9, 3.7613865944296827`*^9, 3.761388033329485*^9, 
   3.7613883971327343`*^9, 3.761389370775671*^9, 3.761455629003179*^9, 
   3.761476207754416*^9, 3.761476476731204*^9, 3.761508495864071*^9, 
   3.761508742025488*^9, 3.761509397950469*^9, 3.761563035682685*^9, 
   3.7615644405880957`*^9, 3.761566231315854*^9, 3.761566422576643*^9, 
   3.761566900136829*^9, 3.76156777677458*^9, 3.761567945548202*^9, 
   3.7615681018111477`*^9, 3.761568285556428*^9, 3.76156836674468*^9, 
   3.761568739533979*^9, 3.7615763527703114`*^9, 3.761576490637507*^9, 
   3.761576584551592*^9, 3.7615771717370443`*^9, 3.7615772566014423`*^9, 
   3.761577316780299*^9, 3.7615773692667713`*^9, 3.7615774476476088`*^9, 
   3.761577665609565*^9, 3.761577753326419*^9, 3.7615778498332233`*^9, 
   3.761578025137184*^9, 3.76157816130184*^9, 3.76157819646301*^9, 
   3.761578233245879*^9, 3.7615783324748077`*^9, 3.7615783814164743`*^9, 
   3.761578495644684*^9, 3.761578540269621*^9, 3.761646388346274*^9, {
   3.7616473418173237`*^9, 3.761647367295035*^9}, 3.761648428219337*^9, 
   3.761648993087933*^9, 3.761649487909631*^9, 3.761650028431324*^9, 
   3.7616521565876102`*^9, 3.761652270132111*^9, 3.761652431207617*^9, 
   3.761652610227942*^9, 3.7616530735163803`*^9, 3.7616552351227617`*^9, {
   3.761896456893723*^9, 3.761896474957245*^9}, {3.76190241855748*^9, 
   3.7619024380342007`*^9}, 3.76190530931047*^9, 3.761905947981382*^9, 
   3.761999277108335*^9, 3.762693752829754*^9, 3.762694182442463*^9, 
   3.76284029294736*^9, 3.762855853681984*^9, 3.762856512576935*^9, {
   3.763441935088292*^9, 3.763441964743207*^9}, 3.7634448041510363`*^9, 
   3.7634450963594227`*^9, 3.7638081004808702`*^9, 3.763808158651141*^9, 
   3.763808322760981*^9, 3.763808546485516*^9, 3.763808765862438*^9, 
   3.76380884653454*^9, 3.763902193297851*^9, 3.763903218287838*^9, 
   3.763903515176221*^9, 3.763903548761651*^9, 3.764329971104062*^9, {
   3.764330098238902*^9, 3.764330116260236*^9}, 3.764330553632427*^9, 
   3.764331607207357*^9, 3.764332549986973*^9, 3.7643931579417877`*^9, 
   3.7644135230910997`*^9, 3.765180204619924*^9, 3.7651802702244387`*^9, 
   3.7651803379315243`*^9, 3.765180385394135*^9, 3.765180420673092*^9, 
   3.765265857251067*^9, 3.779710870734934*^9},
 CellLabel->"Out[1]=",
 CellID->1354565812,ExpressionUUID->"6eb03549-73aa-446a-96c8-71e4ae4f2498"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "FeynRules`"}]], "Input",
 CellChangeTimes->{{3.761056100031893*^9, 3.76105610527532*^9}},
 CellLabel->"In[2]:=",
 CellID->1177512340,ExpressionUUID->"5d4499a5-7221-4e96-9335-99754b4e3e91"],

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{3.765180387441599*^9, 3.76518042131925*^9, 
  3.765265867276009*^9, 3.77971087087514*^9},
 CellLabel->"During evaluation of In[2]:=",
 CellID->713460437,ExpressionUUID->"ac8683eb-cb36-4878-8540-93d0c65bcbe2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.32\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"12 March 2018\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.32", " (" "12 March 2018", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.765180387441599*^9, 3.76518042131925*^9, 
  3.765265867276009*^9, 3.77971087087851*^9},
 CellLabel->"During evaluation of In[2]:=",
 CellID->1728363458,ExpressionUUID->"466019d9-1b61-4b57-99cb-b08600d9b7f1"],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{3.765180387441599*^9, 3.76518042131925*^9, 
  3.765265867276009*^9, 3.779710870879921*^9},
 CellLabel->"During evaluation of In[2]:=",
 CellID->1740829284,ExpressionUUID->"fd1f80ad-47f6-4bc9-ab78-6e50edd81427"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.765180387441599*^9, 3.76518042131925*^9, 
  3.765265867276009*^9, 3.779710870881064*^9},
 CellLabel->"During evaluation of In[2]:=",
 CellID->800569460,ExpressionUUID->"88ab585f-7dec-4ba9-b3a7-08011a9bcbb0"],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{3.765180387441599*^9, 3.76518042131925*^9, 
  3.765265867276009*^9, 3.779710870882091*^9},
 CellLabel->"During evaluation of In[2]:=",
 CellID->1185865765,ExpressionUUID->"daf69402-aacb-4b51-b607-dcca52b2aa7c"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{3.765180387441599*^9, 3.76518042131925*^9, 
  3.765265867276009*^9, 3.7797108708831577`*^9},
 CellLabel->"During evaluation of In[2]:=",
 CellID->50184548,ExpressionUUID->"36f0c617-fef4-47a7-9cc4-b3a840e8cdb1"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{3.765180387441599*^9, 3.76518042131925*^9, 
  3.765265867276009*^9, 3.779710870884549*^9},
 CellLabel->"During evaluation of In[2]:=",
 CellID->1638108612,ExpressionUUID->"45cd1cd5-1f56-4dfe-98a8-a57afaffaa1d"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.765180387441599*^9, 3.76518042131925*^9, 
  3.765265867276009*^9, 3.7797108708858*^9},
 CellLabel->"During evaluation of In[2]:=",
 CellID->951087344,ExpressionUUID->"9790132a-01a6-4a22-ba9f-f1b4c6b694e5"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{3.765180387441599*^9, 3.76518042131925*^9, 
  3.765265867276009*^9, 3.779710870887024*^9},
 CellLabel->"During evaluation of In[2]:=",
 CellID->1204205987,ExpressionUUID->"a77a1444-4764-4067-a487-42c2842535d2"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.765180387441599*^9, 3.76518042131925*^9, 
  3.765265867276009*^9, 3.7797108708881702`*^9},
 CellLabel->"During evaluation of In[2]:=",
 CellID->1204134181,ExpressionUUID->"511e0fe8-1995-4e78-a2f5-d2f4d39d534e"],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{3.765180387441599*^9, 3.76518042131925*^9, 
  3.765265867276009*^9, 3.779710870889202*^9},
 CellLabel->"During evaluation of In[2]:=",
 CellID->2144774386,ExpressionUUID->"92de052a-484c-4535-b153-1485a803f0dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  RowBox[{"NotebookDirectory", "[", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.760945313661097*^9, 3.76094531366329*^9}, {
   3.760945410157215*^9, 3.760945428683935*^9}, {3.76105147178158*^9, 
   3.761051474222394*^9}, {3.763903552747932*^9, 3.763903553446105*^9}, 
   3.765180362254319*^9, 3.765180405357141*^9},
 CellLabel->"In[4]:=",
 CellID->1032924823,ExpressionUUID->"349109c7-483d-4f62-a3a6-d148884dad8c"],

Cell[BoxData["\<\"/Users/ankitbeniwal/Documents/Projects/U1_DM/feynrules-\
current/Models/U1_model\"\>"], "Output",
 CellChangeTimes->{
  3.7609454298007107`*^9, 3.760945765958591*^9, 3.760945884154675*^9, 
   3.7609460023831463`*^9, 3.760946129912846*^9, 3.7609488734538794`*^9, 
   3.760949231611659*^9, 3.760949336995974*^9, {3.760949404990945*^9, 
   3.760949422334174*^9}, 3.7609495811919317`*^9, 3.76094963549221*^9, 
   3.760953021395864*^9, 3.760953061346439*^9, 3.760953139903256*^9, 
   3.7609538249792433`*^9, 3.760954385414*^9, 3.760958255378442*^9, 
   3.760963699849228*^9, 3.761051475100132*^9, 3.761054561285969*^9, {
   3.7610560893934*^9, 3.7610561095431232`*^9}, 3.7610569077723503`*^9, 
   3.761057355494062*^9, 3.761059030765526*^9, {3.761224453830772*^9, 
   3.761224474710288*^9}, 3.761224962912654*^9, 3.761225327421187*^9, 
   3.761287345429614*^9, 3.7612874075199757`*^9, 3.76137684240233*^9, 
   3.7613827881044483`*^9, 3.761384504784245*^9, 3.761384609729089*^9, 
   3.761386245002345*^9, 3.761386606139578*^9, 3.761388039544592*^9, 
   3.7613884043400583`*^9, 3.76138937530282*^9, 3.76145564175729*^9, 
   3.761476479751519*^9, 3.761508500918961*^9, 3.761508745659778*^9, 
   3.7615094013981113`*^9, 3.761563040814702*^9, 3.761564443848806*^9, 
   3.761566241492217*^9, 3.7615664271122828`*^9, 3.76156690393985*^9, 
   3.761567780850781*^9, 3.761567951106501*^9, 3.761568105942946*^9, 
   3.761568207523019*^9, 3.761568290674519*^9, 3.7615683697599583`*^9, 
   3.761568742819351*^9, 3.761576357030141*^9, 3.7615764935731363`*^9, 
   3.761576587551157*^9, 3.761577176228904*^9, 3.7615772596203203`*^9, 
   3.761577320047978*^9, 3.7615773729760942`*^9, 3.761577450602201*^9, 
   3.7615776690108957`*^9, 3.76157775649929*^9, 3.7615778529138327`*^9, 
   3.7615780281140213`*^9, 3.76157816418495*^9, 3.76157820020188*^9, 
   3.7615782361525173`*^9, 3.761578335357788*^9, 3.761578384440937*^9, 
   3.761578499292695*^9, 3.7615785432165203`*^9, 3.761646392893908*^9, 
   3.761647371512127*^9, 3.761648431441218*^9, 3.76164899668893*^9, 
   3.761649491704468*^9, 3.761650032818918*^9, 3.76165216043093*^9, 
   3.761652273093171*^9, 3.761652615103764*^9, 3.761653077199112*^9, 
   3.7616552382606277`*^9, 3.761896479535036*^9, 3.7619024452551003`*^9, 
   3.761902887114101*^9, 3.761905314776311*^9, 3.7619059565597067`*^9, 
   3.7619992825261097`*^9, 3.762693761837132*^9, 3.762694187799048*^9, 
   3.7628402984366493`*^9, 3.7628558576983013`*^9, 3.762856516280079*^9, 
   3.763441944522827*^9, 3.763441976058036*^9, 3.7634448291211777`*^9, 
   3.76344510043248*^9, 3.763808165754888*^9, 3.7638083271574373`*^9, 
   3.763808550234599*^9, 3.763808771734481*^9, 3.763808851957075*^9, 
   3.7639021990361032`*^9, 3.763903223445015*^9, 3.763903519582713*^9, 
   3.763903553959145*^9, {3.764329974527646*^9, 3.764329976576929*^9}, 
   3.7643301316045637`*^9, 3.764330563877782*^9, 3.764331614250681*^9, 
   3.7643325567180634`*^9, 3.7643931662610683`*^9, 3.7644136073585176`*^9, {
   3.765180392092063*^9, 3.765180425148274*^9}, 3.765265871591058*^9, {
   3.779710877821547*^9, 3.779710877931424*^9}},
 CellLabel->"Out[4]=",
 CellID->1551130900,ExpressionUUID->"0371be9b-3c7a-4ea1-bd23-ef1b867748e6"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load the pNG model (.fr) file", "Section",
 CellChangeTimes->{{3.7609454442200727`*^9, 3.760945450448369*^9}, {
   3.7609492336011267`*^9, 3.760949236796007*^9}, {3.761382794359136*^9, 
   3.761382794844552*^9}, 3.761578385165807*^9},
 CellID->119441446,ExpressionUUID->"9f036dbd-41e3-4e2d-a48e-f00ab04e5051"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadModel", "[", "\"\<SM_with_pNG.fr\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.7610569152237053`*^9, 3.761056925189496*^9}, {
  3.763808169769127*^9, 3.763808170088894*^9}, {3.76390220464394*^9, 
  3.763902206023871*^9}},
 CellLabel->"In[5]:=",
 CellID->1596089084,ExpressionUUID->"9d30463c-132a-4f84-9ddd-39e744da891c"],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.763441978370428*^9, 3.763444832531658*^9, 
  3.763445102128273*^9, 3.7638081713901033`*^9, 3.7638083287495823`*^9, 
  3.7638085518411493`*^9, 3.763808775500742*^9, 3.763808853872477*^9, 
  3.763902207405286*^9, 3.7639032249328747`*^9, 3.76390355618261*^9, 
  3.764329979079928*^9, 3.764330133184156*^9, 3.764330566042296*^9, 
  3.764331616103654*^9, 3.7643325598154373`*^9, 3.764393169157153*^9, 
  3.764413610549877*^9, 3.7651804273337393`*^9, 3.76526618023358*^9, 
  3.7797108829660273`*^9},
 CellLabel->"During evaluation of In[5]:=",
 CellID->990359039,ExpressionUUID->"305c8984-7d36-401a-a499-5bf4c8353a49"],

Cell[BoxData["\<\"A. Beniwal\"\>"], "Print",
 CellChangeTimes->{3.763441978370428*^9, 3.763444832531658*^9, 
  3.763445102128273*^9, 3.7638081713901033`*^9, 3.7638083287495823`*^9, 
  3.7638085518411493`*^9, 3.763808775500742*^9, 3.763808853872477*^9, 
  3.763902207405286*^9, 3.7639032249328747`*^9, 3.76390355618261*^9, 
  3.764329979079928*^9, 3.764330133184156*^9, 3.764330566042296*^9, 
  3.764331616103654*^9, 3.7643325598154373`*^9, 3.764393169157153*^9, 
  3.764413610549877*^9, 3.7651804273337393`*^9, 3.76526618023358*^9, 
  3.779710882968795*^9},
 CellLabel->"During evaluation of In[5]:=",
 CellID->1966104223,ExpressionUUID->"0ae114b8-c23b-4c4c-9d62-d9605a18296b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0.0\"\>"}],
  SequenceForm["Model Version: ", "1.0.0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.763441978370428*^9, 3.763444832531658*^9, 
  3.763445102128273*^9, 3.7638081713901033`*^9, 3.7638083287495823`*^9, 
  3.7638085518411493`*^9, 3.763808775500742*^9, 3.763808853872477*^9, 
  3.763902207405286*^9, 3.7639032249328747`*^9, 3.76390355618261*^9, 
  3.764329979079928*^9, 3.764330133184156*^9, 3.764330566042296*^9, 
  3.764331616103654*^9, 3.7643325598154373`*^9, 3.764393169157153*^9, 
  3.764413610549877*^9, 3.7651804273337393`*^9, 3.76526618023358*^9, 
  3.779710882970207*^9},
 CellLabel->"During evaluation of In[5]:=",
 CellID->982799572,ExpressionUUID->"cd04f4fe-ec35-4cad-ab5b-b8db162da841"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.763441978370428*^9, 3.763444832531658*^9, 
  3.763445102128273*^9, 3.7638081713901033`*^9, 3.7638083287495823`*^9, 
  3.7638085518411493`*^9, 3.763808775500742*^9, 3.763808853872477*^9, 
  3.763902207405286*^9, 3.7639032249328747`*^9, 3.76390355618261*^9, 
  3.764329979079928*^9, 3.764330133184156*^9, 3.764330566042296*^9, 
  3.764331616103654*^9, 3.7643325598154373`*^9, 3.764393169157153*^9, 
  3.764413610549877*^9, 3.7651804273337393`*^9, 3.76526618023358*^9, 
  3.779710882971434*^9},
 CellLabel->"During evaluation of In[5]:=",
 CellID->1615677527,ExpressionUUID->"0b8d91fe-d33b-4458-b444-f6c0c06fb258"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.763441978370428*^9, 3.763444832531658*^9, 
  3.763445102128273*^9, 3.7638081713901033`*^9, 3.7638083287495823`*^9, 
  3.7638085518411493`*^9, 3.763808775500742*^9, 3.763808853872477*^9, 
  3.763902207405286*^9, 3.7639032249328747`*^9, 3.76390355618261*^9, 
  3.764329979079928*^9, 3.764330133184156*^9, 3.764330566042296*^9, 
  3.764331616103654*^9, 3.7643325598154373`*^9, 3.764393169157153*^9, 
  3.764413610549877*^9, 3.7651804273337393`*^9, 3.76526618023358*^9, 
  3.77971088297261*^9},
 CellLabel->"During evaluation of In[5]:=",
 CellID->1908963621,ExpressionUUID->"ab1e3af0-1951-4a6e-a27a-e18df501cd08"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.763441978370428*^9, 3.763444832531658*^9, 
  3.763445102128273*^9, 3.7638081713901033`*^9, 3.7638083287495823`*^9, 
  3.7638085518411493`*^9, 3.763808775500742*^9, 3.763808853872477*^9, 
  3.763902207405286*^9, 3.7639032249328747`*^9, 3.76390355618261*^9, 
  3.764329979079928*^9, 3.764330133184156*^9, 3.764330566042296*^9, 
  3.764331616103654*^9, 3.7643325598154373`*^9, 3.764393169157153*^9, 
  3.764413610549877*^9, 3.7651804273337393`*^9, 3.76526618023358*^9, 
  3.7797108829739237`*^9},
 CellLabel->"During evaluation of In[5]:=",
 CellID->545891967,ExpressionUUID->"72b1a76e-e784-468a-8aed-fe5d87221b1e"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.763441978370428*^9, 3.763444832531658*^9, 
  3.763445102128273*^9, 3.7638081713901033`*^9, 3.7638083287495823`*^9, 
  3.7638085518411493`*^9, 3.763808775500742*^9, 3.763808853872477*^9, 
  3.763902207405286*^9, 3.7639032249328747`*^9, 3.76390355618261*^9, 
  3.764329979079928*^9, 3.764330133184156*^9, 3.764330566042296*^9, 
  3.764331616103654*^9, 3.7643325598154373`*^9, 3.764393169157153*^9, 
  3.764413610549877*^9, 3.7651804273337393`*^9, 3.76526618023358*^9, 
  3.77971088310328*^9},
 CellLabel->"During evaluation of In[5]:=",
 CellID->756149385,ExpressionUUID->"22937c3b-a517-44aa-9e73-f37a8b3b7274"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.763441978370428*^9, 3.763444832531658*^9, 
  3.763445102128273*^9, 3.7638081713901033`*^9, 3.7638083287495823`*^9, 
  3.7638085518411493`*^9, 3.763808775500742*^9, 3.763808853872477*^9, 
  3.763902207405286*^9, 3.7639032249328747`*^9, 3.76390355618261*^9, 
  3.764329979079928*^9, 3.764330133184156*^9, 3.764330566042296*^9, 
  3.764331616103654*^9, 3.7643325598154373`*^9, 3.764393169157153*^9, 
  3.764413610549877*^9, 3.7651804273337393`*^9, 3.76526618023358*^9, 
  3.7797108831082897`*^9},
 CellLabel->"During evaluation of In[5]:=",
 CellID->1941974396,ExpressionUUID->"d1eea055-9e8f-419e-882f-27371711f5b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"SM_with_pNG\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "SM_with_pNG", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.763441978370428*^9, 3.763444832531658*^9, 
  3.763445102128273*^9, 3.7638081713901033`*^9, 3.7638083287495823`*^9, 
  3.7638085518411493`*^9, 3.763808775500742*^9, 3.763808853872477*^9, 
  3.763902207405286*^9, 3.7639032249328747`*^9, 3.76390355618261*^9, 
  3.764329979079928*^9, 3.764330133184156*^9, 3.764330566042296*^9, 
  3.764331616103654*^9, 3.7643325598154373`*^9, 3.764393169157153*^9, 
  3.764413610549877*^9, 3.7651804273337393`*^9, 3.76526618023358*^9, 
  3.7797108831755667`*^9},
 CellLabel->"During evaluation of In[5]:=",
 CellID->1307206466,ExpressionUUID->"0ebb2b93-7513-44e5-9707-28b4ccbc9a8e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Check values of free/dependent parameters (pNG \
model)", "Subsection"]], "Chapter",
 CellChangeTimes->{{3.760953154131637*^9, 3.7609531838119287`*^9}, {
  3.761051430246804*^9, 3.761051434888815*^9}},
 CellID->1487958666,ExpressionUUID->"88d87069-0380-4eb3-bf67-4bbdef48ef32"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"NumericalValue", "[", "Mh", "]"}], ",", " ", 
   RowBox[{"NumericalValue", "[", "Mh2", "]"}], ",", 
   RowBox[{"NumericalValue", "[", "vh", "]"}], ",", 
   RowBox[{"NumericalValue", "[", "vs", "]"}], ",", 
   RowBox[{"NumericalValue", "[", "mX", "]"}], ",", 
   RowBox[{"NumericalValue", "[", "theta", "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.760945597789899*^9, 3.7609455991370907`*^9}, {
  3.76105244933633*^9, 3.761052450118393*^9}, {3.7610567011246967`*^9, 
  3.7610567012469187`*^9}, {3.761057538539311*^9, 3.761057538781625*^9}, {
  3.763808175575659*^9, 3.763808178215814*^9}, {3.764393173540064*^9, 
  3.764393173695662*^9}},
 CellLabel->"In[6]:=",
 CellID->474117842,ExpressionUUID->"3bf8b9dd-f4e6-4e28-8586-2a0c2054b2c3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "125.`", ",", "300.`", ",", "246.220569073486`", ",", "300.`", ",", "100.`",
    ",", "0.7854`"}], "}"}]], "Output",
 CellChangeTimes->{3.765180433394163*^9, 3.7652661877064753`*^9, 
  3.7797109003575773`*^9},
 CellLabel->"Out[6]=",
 CellID->1970017204,ExpressionUUID->"f5fe2ed8-ae85-45c5-8347-c4e3bb5c61e0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"NumericalValue", "[", "ct", "]"}], ",", 
   RowBox[{"NumericalValue", "[", "st", "]"}], ",", 
   RowBox[{"NumericalValue", "[", "lambdaP", "]"}], ",", 
   RowBox[{"NumericalValue", "[", "lambdaS", "]"}], ",", 
   RowBox[{"NumericalValue", "[", "lambdaPS", "]"}], ",", 
   RowBox[{"NumericalValue", "[", "muSpsq", "]"}], ",", 
   RowBox[{"NumericalValue", "[", "muPsq", "]"}], ",", 
   RowBox[{"NumericalValue", "[", "muSsq", "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.760945606849324*^9, 3.760945606860314*^9}, {
   3.761287596954381*^9, 3.76128760431846*^9}, 3.7615644498062563`*^9, {
   3.76156691544514*^9, 3.761566918804035*^9}, {3.76156829944096*^9, 
   3.761568301799968*^9}, {3.763903575314803*^9, 3.7639035825375338`*^9}},
 CellLabel->"In[7]:=",
 CellID->911236787,ExpressionUUID->"c0f4564d-1f61-4eb9-8fe5-da3865586f21"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.7071054825112364`", ",", "0.7071080798594735`", ",", 
   "0.8711424722111247`", ",", "0.5868040378076136`", ",", 
   "0.5034442646239723`", ",", "10000.`", ",", "98122.6204134723`", ",", 
   "73333.45477721353`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.761386260603848*^9, 3.7613866837091503`*^9, 3.761388061751823*^9, 
   3.761388415247198*^9, 3.761389389891644*^9, 3.7614556457000732`*^9, 
   3.7615087604080963`*^9, 3.761509408136573*^9, 3.761564451494206*^9, 
   3.761566249427019*^9, 3.761566434480953*^9, {3.7615669135722713`*^9, 
   3.761566919325116*^9}, 3.761567788150689*^9, 3.76156795949622*^9, 
   3.7615683026229*^9, 3.76156874826937*^9, 3.761576363861538*^9, 
   3.761576498782077*^9, 3.7615773260930347`*^9, 3.761646402840417*^9, 
   3.7616473775965242`*^9, 3.7616484366767187`*^9, 3.761649002137464*^9, 
   3.7616495011306953`*^9, 3.761650041892077*^9, 3.761652166291183*^9, 
   3.7616522809809237`*^9, 3.761652622255685*^9, 3.7616530925160437`*^9, 
   3.761655263536489*^9, 3.762693770475621*^9, 3.7626941979490767`*^9, 
   3.76284030486687*^9, 3.7638083358059263`*^9, 3.763902216805521*^9, 
   3.763903231104104*^9, {3.7639035607092857`*^9, 3.763903588718774*^9}, 
   3.764393180917705*^9, 3.7644136335092*^9, 3.765266187748448*^9, 
   3.779710908133964*^9},
 CellLabel->"Out[7]=",
 CellID->339685744,ExpressionUUID->"0025e6db-b654-4913-8ce5-86184f4049e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteParameters", "[", "]"}]], "Input",
 CellChangeTimes->{{3.761648600360564*^9, 3.761648603163348*^9}},
 CellLabel->"In[8]:=",
 CellID->1194927059,ExpressionUUID->"233b311f-17a8-417f-8877-4464741d6138"],

Cell[BoxData["\<\"Writing output to SM_with_pNG.pars.\"\>"], "Print",
 CellChangeTimes->{3.764393186972455*^9, 3.7644136369856853`*^9, 
  3.765266187798452*^9, 3.779710919987247*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->1111727724,ExpressionUUID->"be802a5d-7fcd-40b4-898c-8cbb7178d242"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Check consistency of the model Lagrangian", "Section",
 CellChangeTimes->{{3.7610547119807367`*^9, 3.761054729972829*^9}, {
  3.7610549292099657`*^9, 3.761054931120467*^9}},
 CellID->674230147,ExpressionUUID->"d0229eed-93b9-4734-8f6c-9e96cd9a6740"],

Cell[CellGroupData[{

Cell[BoxData["FeynmanGauge"], "Input",
 CellChangeTimes->{{3.761647179282256*^9, 3.7616471834427233`*^9}, {
   3.761647747556176*^9, 3.7616477484570837`*^9}, 3.761648440044314*^9, {
   3.761649243519326*^9, 3.7616492443476143`*^9}, {3.761649325806226*^9, 
   3.761649330661934*^9}, 3.761649510076666*^9, {3.761653322819559*^9, 
   3.7616533236698427`*^9}, 3.761655270365419*^9, {3.7616557163827477`*^9, 
   3.761655717770639*^9}, {3.761655913238618*^9, 3.761655916080965*^9}, 
   3.761896800369381*^9},
 CellLabel->"In[9]:=",
 CellID->1258740756,ExpressionUUID->"b7baa43e-73db-4089-a8e2-acfefb565e30"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{
  3.761647206760092*^9, 3.7616473802545843`*^9, 3.761647748891255*^9, {
   3.761648440435154*^9, 3.7616484466129923`*^9}, {3.761649015186542*^9, 
   3.761649018933405*^9}, 3.761649244663622*^9, {3.761649327027546*^9, 
   3.761649330942741*^9}, {3.761649510478189*^9, 3.76164951448193*^9}, {
   3.761650044094614*^9, 3.7616500467735157`*^9}, {3.761652177140581*^9, 
   3.761652181123356*^9}, 3.761652287359169*^9, 3.761652626539109*^9, {
   3.761653107538307*^9, 3.761653111301724*^9}, {3.7616533241161537`*^9, 
   3.761653331384987*^9}, {3.761655270778551*^9, 3.7616552743445063`*^9}, {
   3.7616557180075903`*^9, 3.761655721100963*^9}, {3.7618968011705933`*^9, 
   3.761896819622746*^9}, 3.7619029008628187`*^9, 3.761902951392161*^9, 
   3.7619053503266277`*^9, 3.761905973880018*^9, 3.761999287217087*^9, 
   3.762693786588008*^9, 3.7626942006403227`*^9, 3.762840313549139*^9, 
   3.762855889415707*^9, 3.7628565292167788`*^9, 3.7634420074472303`*^9, 
   3.763444836407834*^9, 3.763445107089777*^9, 3.763808417619776*^9, 
   3.763808555475409*^9, 3.763808778851039*^9, 3.763808857145591*^9, 
   3.7639024924488707`*^9, 3.76390324488008*^9, {3.7639036192888927`*^9, 
   3.763903635938676*^9}, 3.764329983260085*^9, {3.764330136791974*^9, 
   3.764330139771008*^9}, 3.764330571584619*^9, 3.764331620423396*^9, 
   3.764332563652667*^9, 3.764393502327622*^9, 3.764413641800596*^9, 
   3.76526618783174*^9, 3.779710925062229*^9},
 CellLabel->"Out[9]=",
 CellID->185050757,ExpressionUUID->"0e7e9d3b-690a-4ea0-bb49-97673c4aa719"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", 
  RowBox[{"LSM", "+", "LpNG"}], "]"}]], "Input",
 CellChangeTimes->{{3.761054734100574*^9, 3.7610547593801107`*^9}, {
   3.761054957023353*^9, 3.761054960256103*^9}, {3.7613834194125633`*^9, 
   3.761383420963297*^9}, 3.761383479906818*^9, {3.7613862650820932`*^9, 
   3.761386268653821*^9}, {3.76156333260437*^9, 3.76156335672055*^9}, {
   3.761563440975638*^9, 3.761563441462257*^9}, {3.761566283557073*^9, 
   3.7615662849265614`*^9}, {3.7615670503399878`*^9, 3.761567052569703*^9}},
 CellLabel->"In[10]:=",
 CellID->1662359057,ExpressionUUID->"c91020cd-7d22-4229-8bbb-16026d677d74"],

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{
  3.761383482448341*^9, 3.7613845465885267`*^9, 3.761384631874687*^9, 
   3.761384774054881*^9, 3.761385358926145*^9, 3.761386270791223*^9, {
   3.761386689266787*^9, 3.761386704661427*^9}, 3.761388076091844*^9, 
   3.761388423626894*^9, 3.761389706895433*^9, 3.761455654877965*^9, 
   3.76150877133786*^9, 3.7615094131706533`*^9, {3.761563335506083*^9, 
   3.761563357696949*^9}, 3.761563443975205*^9, {3.7615636896642523`*^9, 
   3.761563715208393*^9}, 3.761563923879592*^9, 3.761564469597739*^9, 
   3.761566285805978*^9, 3.7615663759342117`*^9, 3.761566412443241*^9, 
   3.7615664508984013`*^9, 3.761567055316062*^9, 3.761646968913659*^9, 
   3.761647383709326*^9, 3.761647752127029*^9, 3.761648448653368*^9, 
   3.7616490206891727`*^9, 3.761649516524778*^9, 3.7616500485437803`*^9, 
   3.761652183332971*^9, 3.761652289542741*^9, 3.7616526306337337`*^9, 
   3.7616531134088593`*^9, 3.761653333221566*^9, 3.761655276439623*^9, 
   3.761655722998839*^9, 3.761896821650465*^9, 3.7619029531645937`*^9, 
   3.761905352236924*^9, 3.76190597562061*^9, 3.762693796663116*^9, 
   3.762694209472665*^9, 3.762840321999609*^9, 3.7628558928052807`*^9, 
   3.762856535637409*^9, 3.763442013926531*^9, 3.763444848288785*^9, 
   3.763445113755658*^9, 3.763808424856518*^9, 3.763808558785873*^9, 
   3.763808782748797*^9, 3.76380886488389*^9, 3.76390250162859*^9, 
   3.763903246725988*^9, {3.7639036233361797`*^9, 3.7639036375087433`*^9}, 
   3.764329990630907*^9, 3.7643301415197067`*^9, 3.764330573278549*^9, 
   3.764331622161376*^9, 3.764332565400124*^9, 3.764393504103426*^9, 
   3.764413643587579*^9, 3.765266189545627*^9, 3.779710928467767*^9},
 CellLabel->"During evaluation of In[10]:=",
 CellID->1858474869,ExpressionUUID->"cb93f3c2-7957-457a-8662-d12686cc1691"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{
  3.761383482448341*^9, 3.7613845465885267`*^9, 3.761384631874687*^9, 
   3.761384774054881*^9, 3.761385358926145*^9, 3.761386270791223*^9, {
   3.761386689266787*^9, 3.761386704661427*^9}, 3.761388076091844*^9, 
   3.761388423626894*^9, 3.761389706895433*^9, 3.761455654877965*^9, 
   3.76150877133786*^9, 3.7615094131706533`*^9, {3.761563335506083*^9, 
   3.761563357696949*^9}, 3.761563443975205*^9, {3.7615636896642523`*^9, 
   3.761563715208393*^9}, 3.761563923879592*^9, 3.761564469597739*^9, 
   3.761566285805978*^9, 3.7615663759342117`*^9, 3.761566412443241*^9, 
   3.7615664508984013`*^9, 3.761567055316062*^9, 3.761646968913659*^9, 
   3.761647383709326*^9, 3.761647752127029*^9, 3.761648448653368*^9, 
   3.7616490206891727`*^9, 3.761649516524778*^9, 3.7616500485437803`*^9, 
   3.761652183332971*^9, 3.761652289542741*^9, 3.7616526306337337`*^9, 
   3.7616531134088593`*^9, 3.761653333221566*^9, 3.761655276439623*^9, 
   3.761655722998839*^9, 3.761896821650465*^9, 3.7619029531645937`*^9, 
   3.761905352236924*^9, 3.76190597562061*^9, 3.762693796663116*^9, 
   3.762694209472665*^9, 3.762840321999609*^9, 3.7628558928052807`*^9, 
   3.762856535637409*^9, 3.763442013926531*^9, 3.763444848288785*^9, 
   3.763445113755658*^9, 3.763808424856518*^9, 3.763808558785873*^9, 
   3.763808782748797*^9, 3.76380886488389*^9, 3.76390250162859*^9, 
   3.763903246725988*^9, {3.7639036233361797`*^9, 3.7639036375087433`*^9}, 
   3.764329990630907*^9, 3.7643301415197067`*^9, 3.764330573278549*^9, 
   3.764331622161376*^9, 3.764332565400124*^9, 3.764393504103426*^9, 
   3.764413643587579*^9, 3.765266189545627*^9, 3.7797109284751883`*^9},
 CellLabel->"During evaluation of In[10]:=",
 CellID->237477668,ExpressionUUID->"47181730-fe17-4d4f-bca5-bd2253a12abe"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.761383482448341*^9, 3.7613845465885267`*^9, 3.761384631874687*^9, 
   3.761384774054881*^9, 3.761385358926145*^9, 3.761386270791223*^9, {
   3.761386689266787*^9, 3.761386704661427*^9}, 3.761388076091844*^9, 
   3.761388423626894*^9, 3.761389706895433*^9, 3.761455654877965*^9, 
   3.76150877133786*^9, 3.7615094131706533`*^9, {3.761563335506083*^9, 
   3.761563357696949*^9}, 3.761563443975205*^9, {3.7615636896642523`*^9, 
   3.761563715208393*^9}, 3.761563923879592*^9, 3.761564469597739*^9, 
   3.761566285805978*^9, 3.7615663759342117`*^9, 3.761566412443241*^9, 
   3.7615664508984013`*^9, 3.761567055316062*^9, 3.761646968913659*^9, 
   3.761647383709326*^9, 3.761647752127029*^9, 3.761648448653368*^9, 
   3.7616490206891727`*^9, 3.761649516524778*^9, 3.7616500485437803`*^9, 
   3.761652183332971*^9, 3.761652289542741*^9, 3.7616526306337337`*^9, 
   3.7616531134088593`*^9, 3.761653333221566*^9, 3.761655276439623*^9, 
   3.761655722998839*^9, 3.761896821650465*^9, 3.7619029531645937`*^9, 
   3.761905352236924*^9, 3.76190597562061*^9, 3.762693796663116*^9, 
   3.762694209472665*^9, 3.762840321999609*^9, 3.7628558928052807`*^9, 
   3.762856535637409*^9, 3.763442013926531*^9, 3.763444848288785*^9, 
   3.763445113755658*^9, 3.763808424856518*^9, 3.763808558785873*^9, 
   3.763808782748797*^9, 3.76380886488389*^9, 3.76390250162859*^9, 
   3.763903246725988*^9, {3.7639036233361797`*^9, 3.7639036375087433`*^9}, 
   3.764329990630907*^9, 3.7643301415197067`*^9, 3.764330573278549*^9, 
   3.764331622161376*^9, 3.764332565400124*^9, 3.764393504103426*^9, 
   3.764413643587579*^9, 3.765266189545627*^9, 3.779710944226904*^9},
 CellLabel->"During evaluation of In[10]:=",
 CellID->1153855207,ExpressionUUID->"85d27ccf-9778-4b15-b2ea-5596171fc1ed"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.761383482448341*^9, 3.7613845465885267`*^9, 3.761384631874687*^9, 
   3.761384774054881*^9, 3.761385358926145*^9, 3.761386270791223*^9, {
   3.761386689266787*^9, 3.761386704661427*^9}, 3.761388076091844*^9, 
   3.761388423626894*^9, 3.761389706895433*^9, 3.761455654877965*^9, 
   3.76150877133786*^9, 3.7615094131706533`*^9, {3.761563335506083*^9, 
   3.761563357696949*^9}, 3.761563443975205*^9, {3.7615636896642523`*^9, 
   3.761563715208393*^9}, 3.761563923879592*^9, 3.761564469597739*^9, 
   3.761566285805978*^9, 3.7615663759342117`*^9, 3.761566412443241*^9, 
   3.7615664508984013`*^9, 3.761567055316062*^9, 3.761646968913659*^9, 
   3.761647383709326*^9, 3.761647752127029*^9, 3.761648448653368*^9, 
   3.7616490206891727`*^9, 3.761649516524778*^9, 3.7616500485437803`*^9, 
   3.761652183332971*^9, 3.761652289542741*^9, 3.7616526306337337`*^9, 
   3.7616531134088593`*^9, 3.761653333221566*^9, 3.761655276439623*^9, 
   3.761655722998839*^9, 3.761896821650465*^9, 3.7619029531645937`*^9, 
   3.761905352236924*^9, 3.76190597562061*^9, 3.762693796663116*^9, 
   3.762694209472665*^9, 3.762840321999609*^9, 3.7628558928052807`*^9, 
   3.762856535637409*^9, 3.763442013926531*^9, 3.763444848288785*^9, 
   3.763445113755658*^9, 3.763808424856518*^9, 3.763808558785873*^9, 
   3.763808782748797*^9, 3.76380886488389*^9, 3.76390250162859*^9, 
   3.763903246725988*^9, {3.7639036233361797`*^9, 3.7639036375087433`*^9}, 
   3.764329990630907*^9, 3.7643301415197067`*^9, 3.764330573278549*^9, 
   3.764331622161376*^9, 3.764332565400124*^9, 3.764393504103426*^9, 
   3.764413643587579*^9, 3.765266189545627*^9, 3.7797109442284803`*^9},
 CellLabel->"During evaluation of In[10]:=",
 CellID->1067131639,ExpressionUUID->"f0a23bf3-2464-4fab-95d2-129b8215961b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.761383482448341*^9, 3.7613845465885267`*^9, 3.761384631874687*^9, 
   3.761384774054881*^9, 3.761385358926145*^9, 3.761386270791223*^9, {
   3.761386689266787*^9, 3.761386704661427*^9}, 3.761388076091844*^9, 
   3.761388423626894*^9, 3.761389706895433*^9, 3.761455654877965*^9, 
   3.76150877133786*^9, 3.7615094131706533`*^9, {3.761563335506083*^9, 
   3.761563357696949*^9}, 3.761563443975205*^9, {3.7615636896642523`*^9, 
   3.761563715208393*^9}, 3.761563923879592*^9, 3.761564469597739*^9, 
   3.761566285805978*^9, 3.7615663759342117`*^9, 3.761566412443241*^9, 
   3.7615664508984013`*^9, 3.761567055316062*^9, 3.761646968913659*^9, 
   3.761647383709326*^9, 3.761647752127029*^9, 3.761648448653368*^9, 
   3.7616490206891727`*^9, 3.761649516524778*^9, 3.7616500485437803`*^9, 
   3.761652183332971*^9, 3.761652289542741*^9, 3.7616526306337337`*^9, 
   3.7616531134088593`*^9, 3.761653333221566*^9, 3.761655276439623*^9, 
   3.761655722998839*^9, 3.761896821650465*^9, 3.7619029531645937`*^9, 
   3.761905352236924*^9, 3.76190597562061*^9, 3.762693796663116*^9, 
   3.762694209472665*^9, 3.762840321999609*^9, 3.7628558928052807`*^9, 
   3.762856535637409*^9, 3.763442013926531*^9, 3.763444848288785*^9, 
   3.763445113755658*^9, 3.763808424856518*^9, 3.763808558785873*^9, 
   3.763808782748797*^9, 3.76380886488389*^9, 3.76390250162859*^9, 
   3.763903246725988*^9, {3.7639036233361797`*^9, 3.7639036375087433`*^9}, 
   3.764329990630907*^9, 3.7643301415197067`*^9, 3.764330573278549*^9, 
   3.764331622161376*^9, 3.764332565400124*^9, 3.764393504103426*^9, 
   3.764413643587579*^9, 3.765266189545627*^9, 3.779710944229651*^9},
 CellLabel->"During evaluation of In[10]:=",
 CellID->1645520576,ExpressionUUID->"c6da117a-c763-40a0-89a1-be63146d2eda"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.761383482448341*^9, 3.7613845465885267`*^9, 3.761384631874687*^9, 
   3.761384774054881*^9, 3.761385358926145*^9, 3.761386270791223*^9, {
   3.761386689266787*^9, 3.761386704661427*^9}, 3.761388076091844*^9, 
   3.761388423626894*^9, 3.761389706895433*^9, 3.761455654877965*^9, 
   3.76150877133786*^9, 3.7615094131706533`*^9, {3.761563335506083*^9, 
   3.761563357696949*^9}, 3.761563443975205*^9, {3.7615636896642523`*^9, 
   3.761563715208393*^9}, 3.761563923879592*^9, 3.761564469597739*^9, 
   3.761566285805978*^9, 3.7615663759342117`*^9, 3.761566412443241*^9, 
   3.7615664508984013`*^9, 3.761567055316062*^9, 3.761646968913659*^9, 
   3.761647383709326*^9, 3.761647752127029*^9, 3.761648448653368*^9, 
   3.7616490206891727`*^9, 3.761649516524778*^9, 3.7616500485437803`*^9, 
   3.761652183332971*^9, 3.761652289542741*^9, 3.7616526306337337`*^9, 
   3.7616531134088593`*^9, 3.761653333221566*^9, 3.761655276439623*^9, 
   3.761655722998839*^9, 3.761896821650465*^9, 3.7619029531645937`*^9, 
   3.761905352236924*^9, 3.76190597562061*^9, 3.762693796663116*^9, 
   3.762694209472665*^9, 3.762840321999609*^9, 3.7628558928052807`*^9, 
   3.762856535637409*^9, 3.763442013926531*^9, 3.763444848288785*^9, 
   3.763445113755658*^9, 3.763808424856518*^9, 3.763808558785873*^9, 
   3.763808782748797*^9, 3.76380886488389*^9, 3.76390250162859*^9, 
   3.763903246725988*^9, {3.7639036233361797`*^9, 3.7639036375087433`*^9}, 
   3.764329990630907*^9, 3.7643301415197067`*^9, 3.764330573278549*^9, 
   3.764331622161376*^9, 3.764332565400124*^9, 3.764393504103426*^9, 
   3.764413643587579*^9, 3.765266189545627*^9, 3.779710945229095*^9},
 CellLabel->"During evaluation of In[10]:=",
 CellID->1956591432,ExpressionUUID->"48916f3e-e784-456f-9a0d-48b6b882411f"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{
  3.761383482448341*^9, 3.7613845465885267`*^9, 3.761384631874687*^9, 
   3.761384774054881*^9, 3.761385358926145*^9, 3.761386270791223*^9, {
   3.761386689266787*^9, 3.761386704661427*^9}, 3.761388076091844*^9, 
   3.761388423626894*^9, 3.761389706895433*^9, 3.761455654877965*^9, 
   3.76150877133786*^9, 3.7615094131706533`*^9, {3.761563335506083*^9, 
   3.761563357696949*^9}, 3.761563443975205*^9, {3.7615636896642523`*^9, 
   3.761563715208393*^9}, 3.761563923879592*^9, 3.761564469597739*^9, 
   3.761566285805978*^9, 3.7615663759342117`*^9, 3.761566412443241*^9, 
   3.7615664508984013`*^9, 3.761567055316062*^9, 3.761646968913659*^9, 
   3.761647383709326*^9, 3.761647752127029*^9, 3.761648448653368*^9, 
   3.7616490206891727`*^9, 3.761649516524778*^9, 3.7616500485437803`*^9, 
   3.761652183332971*^9, 3.761652289542741*^9, 3.7616526306337337`*^9, 
   3.7616531134088593`*^9, 3.761653333221566*^9, 3.761655276439623*^9, 
   3.761655722998839*^9, 3.761896821650465*^9, 3.7619029531645937`*^9, 
   3.761905352236924*^9, 3.76190597562061*^9, 3.762693796663116*^9, 
   3.762694209472665*^9, 3.762840321999609*^9, 3.7628558928052807`*^9, 
   3.762856535637409*^9, 3.763442013926531*^9, 3.763444848288785*^9, 
   3.763445113755658*^9, 3.763808424856518*^9, 3.763808558785873*^9, 
   3.763808782748797*^9, 3.76380886488389*^9, 3.76390250162859*^9, 
   3.763903246725988*^9, {3.7639036233361797`*^9, 3.7639036375087433`*^9}, 
   3.764329990630907*^9, 3.7643301415197067`*^9, 3.764330573278549*^9, 
   3.764331622161376*^9, 3.764332565400124*^9, 3.764393504103426*^9, 
   3.764413643587579*^9, 3.765266189545627*^9, 3.779710945273885*^9},
 CellLabel->"During evaluation of In[10]:=",
 CellID->15111113,ExpressionUUID->"13f2d430-3a81-4607-a3bf-1c75e9a9c834"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.761383482448341*^9, 3.7613845465885267`*^9, 3.761384631874687*^9, 
   3.761384774054881*^9, 3.761385358926145*^9, 3.761386270791223*^9, {
   3.761386689266787*^9, 3.761386704661427*^9}, 3.761388076091844*^9, 
   3.761388423626894*^9, 3.761389706895433*^9, 3.761455654877965*^9, 
   3.76150877133786*^9, 3.7615094131706533`*^9, {3.761563335506083*^9, 
   3.761563357696949*^9}, 3.761563443975205*^9, {3.7615636896642523`*^9, 
   3.761563715208393*^9}, 3.761563923879592*^9, 3.761564469597739*^9, 
   3.761566285805978*^9, 3.7615663759342117`*^9, 3.761566412443241*^9, 
   3.7615664508984013`*^9, 3.761567055316062*^9, 3.761646968913659*^9, 
   3.761647383709326*^9, 3.761647752127029*^9, 3.761648448653368*^9, 
   3.7616490206891727`*^9, 3.761649516524778*^9, 3.7616500485437803`*^9, 
   3.761652183332971*^9, 3.761652289542741*^9, 3.7616526306337337`*^9, 
   3.7616531134088593`*^9, 3.761653333221566*^9, 3.761655276439623*^9, 
   3.761655722998839*^9, 3.761896821650465*^9, 3.7619029531645937`*^9, 
   3.761905352236924*^9, 3.76190597562061*^9, 3.762693796663116*^9, 
   3.762694209472665*^9, 3.762840321999609*^9, 3.7628558928052807`*^9, 
   3.762856535637409*^9, 3.763442013926531*^9, 3.763444848288785*^9, 
   3.763445113755658*^9, 3.763808424856518*^9, 3.763808558785873*^9, 
   3.763808782748797*^9, 3.76380886488389*^9, 3.76390250162859*^9, 
   3.763903246725988*^9, {3.7639036233361797`*^9, 3.7639036375087433`*^9}, 
   3.764329990630907*^9, 3.7643301415197067`*^9, 3.764330573278549*^9, 
   3.764331622161376*^9, 3.764332565400124*^9, 3.764393504103426*^9, 
   3.764413643587579*^9, 3.765266189545627*^9, 3.779710945275352*^9},
 CellLabel->"During evaluation of In[10]:=",
 CellID->569405845,ExpressionUUID->"d66efcea-2c80-48ce-88e6-fba0b6e339a7"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{
  3.761383482448341*^9, 3.7613845465885267`*^9, 3.761384631874687*^9, 
   3.761384774054881*^9, 3.761385358926145*^9, 3.761386270791223*^9, {
   3.761386689266787*^9, 3.761386704661427*^9}, 3.761388076091844*^9, 
   3.761388423626894*^9, 3.761389706895433*^9, 3.761455654877965*^9, 
   3.76150877133786*^9, 3.7615094131706533`*^9, {3.761563335506083*^9, 
   3.761563357696949*^9}, 3.761563443975205*^9, {3.7615636896642523`*^9, 
   3.761563715208393*^9}, 3.761563923879592*^9, 3.761564469597739*^9, 
   3.761566285805978*^9, 3.7615663759342117`*^9, 3.761566412443241*^9, 
   3.7615664508984013`*^9, 3.761567055316062*^9, 3.761646968913659*^9, 
   3.761647383709326*^9, 3.761647752127029*^9, 3.761648448653368*^9, 
   3.7616490206891727`*^9, 3.761649516524778*^9, 3.7616500485437803`*^9, 
   3.761652183332971*^9, 3.761652289542741*^9, 3.7616526306337337`*^9, 
   3.7616531134088593`*^9, 3.761653333221566*^9, 3.761655276439623*^9, 
   3.761655722998839*^9, 3.761896821650465*^9, 3.7619029531645937`*^9, 
   3.761905352236924*^9, 3.76190597562061*^9, 3.762693796663116*^9, 
   3.762694209472665*^9, 3.762840321999609*^9, 3.7628558928052807`*^9, 
   3.762856535637409*^9, 3.763442013926531*^9, 3.763444848288785*^9, 
   3.763445113755658*^9, 3.763808424856518*^9, 3.763808558785873*^9, 
   3.763808782748797*^9, 3.76380886488389*^9, 3.76390250162859*^9, 
   3.763903246725988*^9, {3.7639036233361797`*^9, 3.7639036375087433`*^9}, 
   3.764329990630907*^9, 3.7643301415197067`*^9, 3.764330573278549*^9, 
   3.764331622161376*^9, 3.764332565400124*^9, 3.764393504103426*^9, 
   3.764413643587579*^9, 3.765266189545627*^9, 3.779710945276601*^9},
 CellLabel->"During evaluation of In[10]:=",
 CellID->816905883,ExpressionUUID->"4cd4838c-730c-4b9a-a932-7c3d7d1f8f21"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.7616526491992188`*^9, 3.761653132120722*^9, 3.7616533474319277`*^9, 
   3.761655295765419*^9, 3.761655736526668*^9, 3.761896839808742*^9, 
   3.761902965970603*^9, 3.761905365173819*^9, 3.761905989677824*^9, 
   3.7626938154982367`*^9, 3.762694223189571*^9, 3.762840343855537*^9, 
   3.7628559119349318`*^9, 3.762856548600811*^9, 3.7634420333298883`*^9, 
   3.763444863045739*^9, 3.763445126721821*^9, 3.7638084487350407`*^9, 
   3.763808577470776*^9, 3.7638088004779053`*^9, 3.763808877855874*^9, 
   3.763902514113455*^9, 3.763903260022565*^9, {3.7639036358485823`*^9, 
   3.76390365059223*^9}, 3.764330003686466*^9, 3.764330153871986*^9, 
   3.7643305861313353`*^9, 3.764331635561331*^9, 3.764332578359757*^9, 
   3.764393516880026*^9, 3.76441365731387*^9, 3.765266202520102*^9, 
   3.7797109452778807`*^9},
 CellLabel->"Out[10]=",
 CellID->874220310,ExpressionUUID->"ed206374-7ced-44c3-98a8-be605d300a2f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckDiagonalKineticTerms", "[", 
  RowBox[{"LSM", "+", "LpNG"}], "]"}]], "Input",
 CellChangeTimes->{{3.761054991582073*^9, 3.761055005985064*^9}, 
   3.761386296780901*^9, 3.7615636905835323`*^9, 3.761566290083891*^9, {
   3.761567080204935*^9, 3.761567083122097*^9}},
 CellLabel->"In[11]:=",
 CellID->506423529,ExpressionUUID->"1ba0235f-d1b3-4430-8d3e-328bbb221e7f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7610550139794407`*^9, {3.761056177247188*^9, 3.761056185771463*^9}, 
   3.761056971592476*^9, 3.76128779163736*^9, 3.76138361313025*^9, 
   3.7613846835685883`*^9, 3.761384794338574*^9, 3.761386317579575*^9, 
   3.761386723180666*^9, 3.7613880959538107`*^9, 3.761388446137732*^9, 
   3.761389732379801*^9, 3.761508800579604*^9, 3.761509435908183*^9, 
   3.761563741171238*^9, 3.761563942126356*^9, 3.761564489409955*^9, 
   3.7615663776851788`*^9, 3.761566453249761*^9, {3.7615670788079157`*^9, 
   3.761567091566497*^9}, 3.7616470120176287`*^9, 3.7616474113155603`*^9, 
   3.761647771835943*^9, 3.761648474733555*^9, 3.7616490404710827`*^9, 
   3.761649543800218*^9, 3.761650067309202*^9, 3.761652213966196*^9, 
   3.7616526600532103`*^9, 3.761653140162984*^9, 3.761653353943096*^9, 
   3.761655303980753*^9, 3.7616557427319403`*^9, 3.761896847716053*^9, 
   3.761902971354694*^9, 3.761905371319126*^9, 3.761905995743095*^9, 
   3.7626938234735403`*^9, 3.762694228968528*^9, 3.7628403537506638`*^9, 
   3.7628559195601482`*^9, 3.762856554268311*^9, 3.76344204920432*^9, 
   3.763444870844419*^9, 3.763445132284449*^9, 3.7638084574933863`*^9, 
   3.763808809597142*^9, 3.763808883585926*^9, 3.7639025199844027`*^9, 
   3.7639032655172167`*^9, 3.763903656040123*^9, 3.764330009326212*^9, 
   3.764330159857983*^9, 3.7643305919007883`*^9, 3.7643316413816338`*^9, 
   3.76433258409338*^9, 3.764393522323625*^9, 3.764413663209292*^9, 
   3.765266207998945*^9, 3.77971095262844*^9},
 CellLabel->"During evaluation of In[11]:=",
 CellID->2085121043,ExpressionUUID->"cb6e7659-1f82-471b-9dcd-9b6e769c706a"],

Cell[BoxData["\<\"All kinetic terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{
  3.7610550139794407`*^9, {3.761056177247188*^9, 3.761056185771463*^9}, 
   3.761056971592476*^9, 3.76128779163736*^9, 3.76138361313025*^9, 
   3.7613846835685883`*^9, 3.761384794338574*^9, 3.761386317579575*^9, 
   3.761386723180666*^9, 3.7613880959538107`*^9, 3.761388446137732*^9, 
   3.761389732379801*^9, 3.761508800579604*^9, 3.761509435908183*^9, 
   3.761563741171238*^9, 3.761563942126356*^9, 3.761564489409955*^9, 
   3.7615663776851788`*^9, 3.761566453249761*^9, {3.7615670788079157`*^9, 
   3.761567091566497*^9}, 3.7616470120176287`*^9, 3.7616474113155603`*^9, 
   3.761647771835943*^9, 3.761648474733555*^9, 3.7616490404710827`*^9, 
   3.761649543800218*^9, 3.761650067309202*^9, 3.761652213966196*^9, 
   3.7616526600532103`*^9, 3.761653140162984*^9, 3.761653353943096*^9, 
   3.761655303980753*^9, 3.7616557427319403`*^9, 3.761896847716053*^9, 
   3.761902971354694*^9, 3.761905371319126*^9, 3.761905995743095*^9, 
   3.7626938234735403`*^9, 3.762694228968528*^9, 3.7628403537506638`*^9, 
   3.7628559195601482`*^9, 3.762856554268311*^9, 3.76344204920432*^9, 
   3.763444870844419*^9, 3.763445132284449*^9, 3.7638084574933863`*^9, 
   3.763808809597142*^9, 3.763808883585926*^9, 3.7639025199844027`*^9, 
   3.7639032655172167`*^9, 3.763903656040123*^9, 3.764330009326212*^9, 
   3.764330159857983*^9, 3.7643305919007883`*^9, 3.7643316413816338`*^9, 
   3.76433258409338*^9, 3.764393522323625*^9, 3.764413663209292*^9, 
   3.765266207998945*^9, 3.779710953124529*^9},
 CellLabel->"During evaluation of In[11]:=",
 CellID->1991217955,ExpressionUUID->"4a16809f-97e9-4e2c-88e1-f1d9fdd40f3b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.7610550139813423`*^9, {3.761056177738266*^9, 3.761056185778488*^9}, 
   3.7610569720722847`*^9, 3.7612877919163513`*^9, 3.761383613412237*^9, 
   3.761384683850456*^9, 3.7613847943457603`*^9, 3.761386317841043*^9, 
   3.761386723461854*^9, 3.761388096215003*^9, 3.761388446430937*^9, 
   3.761389732858708*^9, 3.761508801073023*^9, 3.761509436191061*^9, 
   3.7615637416604557`*^9, 3.761563942133465*^9, 3.7615644896937323`*^9, 
   3.761566377690221*^9, 3.7615664533632174`*^9, {3.76156707883048*^9, 
   3.761567091572934*^9}, 3.761647012023493*^9, 3.761647411829723*^9, 
   3.761647771841288*^9, 3.761648475198509*^9, 3.761649040762898*^9, 
   3.761649544285507*^9, 3.76165006757892*^9, 3.7616522144788637`*^9, 
   3.761652660546879*^9, 3.7616531406954393`*^9, 3.761653353948441*^9, 
   3.761655304526507*^9, 3.761655742737483*^9, 3.761896848216773*^9, 
   3.76190297161411*^9, 3.761905371608128*^9, 3.76190599603419*^9, 
   3.762693823960874*^9, 3.7626942292520447`*^9, 3.762840354359077*^9, 
   3.762855920039608*^9, 3.762856554542438*^9, 3.763442049215418*^9, 
   3.763444871363121*^9, 3.763445132560185*^9, 3.763808458050899*^9, 
   3.763808810064733*^9, 3.7638088838554707`*^9, 3.763902520276352*^9, 
   3.763903265785748*^9, 3.7639036563075*^9, 3.764330009603204*^9, 
   3.764330160121949*^9, 3.7643305921773577`*^9, 3.764331641662476*^9, 
   3.764332584376513*^9, 3.764393522598228*^9, 3.764413663503242*^9, 
   3.7652662082721567`*^9, 3.779710953126172*^9},
 CellLabel->"Out[11]=",
 CellID->15014837,ExpressionUUID->"eb84ff75-26d7-48b1-a05a-d0464916d688"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckDiagonalMassTerms", "[", 
  RowBox[{"LSM", "+", "LpNG"}], "]"}]], "Input",
 CellChangeTimes->{{3.761055021098061*^9, 3.76105503118442*^9}, 
   3.761386298734084*^9, 3.761563695349894*^9, 3.761566292443959*^9, 
   3.761567089716655*^9},
 CellLabel->"In[12]:=",
 CellID->1711954106,ExpressionUUID->"baa3118f-e43c-48c8-9aa1-cf3ec00bc473"],

Cell[BoxData["\<\"All mass terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{
  3.76138469877291*^9, 3.761384801520822*^9, 3.761386323492378*^9, 
   3.761386729622128*^9, 3.761388101907136*^9, 3.761388452166457*^9, 
   3.761389740777728*^9, 3.761455675856124*^9, 3.7615088104475822`*^9, 
   3.761509443932146*^9, 3.761563749727734*^9, 3.761563947737631*^9, 
   3.761564495817079*^9, 3.761566378196258*^9, 3.761566454194818*^9, 
   3.761567108774716*^9, 3.761647020290498*^9, 3.7616474203835697`*^9, 
   3.761647777830193*^9, 3.761648483509231*^9, 3.7616490470271997`*^9, 
   3.761649552394514*^9, 3.7616500735976753`*^9, 3.7616522231087933`*^9, {
   3.761652668959041*^9, 3.761652677125964*^9}, 3.761653148795291*^9, 
   3.76165336022689*^9, 3.7616553130283833`*^9, 3.761655748982808*^9, 
   3.76189685666463*^9, 3.761902977234311*^9, 3.7619053778172827`*^9, 
   3.761906002300269*^9, 3.7626938321371717`*^9, 3.762694235406597*^9, 
   3.762840364075384*^9, 3.762855927884989*^9, 3.762856560729293*^9, 
   3.763442057661644*^9, 3.763444879668968*^9, 3.763445138771203*^9, 
   3.7638084671312838`*^9, 3.763808820786742*^9, 3.763808889480414*^9, 
   3.763902526119934*^9, 3.7639032718476553`*^9, 3.7639036618757563`*^9, 
   3.76433001563011*^9, 3.76433016614187*^9, 3.764330598013948*^9, 
   3.764331647669134*^9, 3.7643325901656*^9, 3.764393528344466*^9, 
   3.764413669659336*^9, 3.765266214254353*^9, 3.7797109607441397`*^9},
 CellLabel->"During evaluation of In[12]:=",
 CellID->1098778760,ExpressionUUID->"386618f2-d017-4c50-85ec-2505d1d09aef"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.761055039296892*^9, 3.761056193921134*^9, 3.761056981480109*^9, 
   3.761287798800208*^9, 3.761383620375794*^9, 3.761384698777359*^9, 
   3.761384801527549*^9, 3.761386323497965*^9, 3.761386729630143*^9, 
   3.761388101915399*^9, 3.761388452174719*^9, 3.761389740787754*^9, 
   3.76145567614382*^9, 3.761508810456112*^9, 3.761509443940786*^9, 
   3.761563749734742*^9, 3.7615639477443132`*^9, 3.7615644958229437`*^9, 
   3.7615663782018967`*^9, 3.7615664542023563`*^9, 3.76156710878091*^9, 
   3.761647020296344*^9, 3.761647420389123*^9, 3.761647777835375*^9, 
   3.761648483514707*^9, 3.761649047032983*^9, 3.7616495524009457`*^9, 
   3.761650073603754*^9, 3.761652223139683*^9, {3.7616526689643087`*^9, 
   3.7616526771316357`*^9}, 3.761653148801012*^9, 3.761653360232885*^9, 
   3.761655313033291*^9, 3.761655748988165*^9, 3.761896856671331*^9, 
   3.761902977240719*^9, 3.761905377824152*^9, 3.761906002308179*^9, 
   3.762693832143052*^9, 3.762694235412841*^9, 3.762840364080971*^9, 
   3.762855927891984*^9, 3.762856560737239*^9, 3.763442057668119*^9, 
   3.763444879678298*^9, 3.763445138783287*^9, 3.763808467157159*^9, 
   3.7638088207970543`*^9, 3.763808889489212*^9, 3.7639025261289*^9, 
   3.7639032718552723`*^9, 3.763903661887916*^9, 3.764330015643008*^9, 
   3.7643301661492968`*^9, 3.764330598022252*^9, 3.764331647677588*^9, 
   3.7643325901732883`*^9, 3.764393528352482*^9, 3.764413669665851*^9, 
   3.765266214262574*^9, 3.7797109607456493`*^9},
 CellLabel->"Out[12]=",
 CellID->962738767,ExpressionUUID->"b402f6f0-06e4-4c7a-91e7-90947ffa88fe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckDiagonalQuadraticTerms", "[", 
  RowBox[{"LSM", "+", "LpNG"}], "]"}]], "Input",
 CellChangeTimes->{{3.7610550409113207`*^9, 3.761055048785925*^9}, 
   3.7613863002345867`*^9, 3.761563698789051*^9, 3.761566294360551*^9, 
   3.761567091281692*^9},
 CellLabel->"In[13]:=",
 CellID->1819434187,ExpressionUUID->"45887bc9-2cd1-4092-a195-491e49cff7ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with less than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with less than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.761055057114777*^9, {3.7610562020291023`*^9, 3.761056210480133*^9}, 
   3.761287808478218*^9, 3.761383629393447*^9, 3.76138470704631*^9, 
   3.761384808815338*^9, 3.761386329115725*^9, 3.761386735726506*^9, 
   3.761388107577655*^9, 3.761388457713578*^9, 3.761389748814158*^9, 
   3.761455683741213*^9, 3.7615088206898317`*^9, 3.7615094513653803`*^9, 
   3.761563757677946*^9, 3.761563953623231*^9, 3.761564501831789*^9, 
   3.7615663787797194`*^9, 3.7615664552547503`*^9, 3.761567118828328*^9, 
   3.761647028285061*^9, 3.761647428750368*^9, 3.7616477837154922`*^9, 
   3.761648491817212*^9, 3.761649053446575*^9, 3.761649560732933*^9, 
   3.7616500796856318`*^9, 3.7616522318581343`*^9, 3.7616526851229753`*^9, 
   3.761653156699602*^9, 3.761653366317794*^9, 3.761655321455843*^9, 
   3.76165575515873*^9, 3.761896864895852*^9, 3.761902983226305*^9, 
   3.761905384057666*^9, 3.7619060088145247`*^9, 3.762693840251545*^9, 
   3.762694241667165*^9, 3.762840373979776*^9, 3.7628559357098618`*^9, 
   3.762856566779523*^9, 3.763442066114687*^9, 3.763444887790929*^9, 
   3.7634451449099407`*^9, 3.763808476107666*^9, 3.7638085850398283`*^9, 
   3.763808830889915*^9, 3.763808895215324*^9, 3.763902531924006*^9, 
   3.76390327802341*^9, 3.763903668081238*^9, 3.764330021692971*^9, 
   3.764330171699224*^9, 3.764330604070074*^9, 3.764331653559317*^9, 
   3.764332596079015*^9, 3.7643935341669893`*^9, 3.7644136760496492`*^9, 
   3.765266220073162*^9, 3.7797109684182577`*^9},
 CellLabel->"During evaluation of In[13]:=",
 CellID->1728079815,ExpressionUUID->"5b52cf2e-9c0d-4f2e-b6c8-8b35cb65022d"],

Cell[BoxData["\<\"All quadratic terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{
  3.761055057114777*^9, {3.7610562020291023`*^9, 3.761056210480133*^9}, 
   3.761287808478218*^9, 3.761383629393447*^9, 3.76138470704631*^9, 
   3.761384808815338*^9, 3.761386329115725*^9, 3.761386735726506*^9, 
   3.761388107577655*^9, 3.761388457713578*^9, 3.761389748814158*^9, 
   3.761455683741213*^9, 3.7615088206898317`*^9, 3.7615094513653803`*^9, 
   3.761563757677946*^9, 3.761563953623231*^9, 3.761564501831789*^9, 
   3.7615663787797194`*^9, 3.7615664552547503`*^9, 3.761567118828328*^9, 
   3.761647028285061*^9, 3.761647428750368*^9, 3.7616477837154922`*^9, 
   3.761648491817212*^9, 3.761649053446575*^9, 3.761649560732933*^9, 
   3.7616500796856318`*^9, 3.7616522318581343`*^9, 3.7616526851229753`*^9, 
   3.761653156699602*^9, 3.761653366317794*^9, 3.761655321455843*^9, 
   3.76165575515873*^9, 3.761896864895852*^9, 3.761902983226305*^9, 
   3.761905384057666*^9, 3.7619060088145247`*^9, 3.762693840251545*^9, 
   3.762694241667165*^9, 3.762840373979776*^9, 3.7628559357098618`*^9, 
   3.762856566779523*^9, 3.763442066114687*^9, 3.763444887790929*^9, 
   3.7634451449099407`*^9, 3.763808476107666*^9, 3.7638085850398283`*^9, 
   3.763808830889915*^9, 3.763808895215324*^9, 3.763902531924006*^9, 
   3.76390327802341*^9, 3.763903668081238*^9, 3.764330021692971*^9, 
   3.764330171699224*^9, 3.764330604070074*^9, 3.764331653559317*^9, 
   3.764332596079015*^9, 3.7643935341669893`*^9, 3.7644136760496492`*^9, 
   3.765266220073162*^9, 3.779710968537582*^9},
 CellLabel->"During evaluation of In[13]:=",
 CellID->434644030,ExpressionUUID->"fdff66a5-00a3-4319-8607-5d370d094daf"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.7610550571985893`*^9, {3.761056202121381*^9, 3.76105621049476*^9}, 
   3.76128780856994*^9, 3.761383629458984*^9, 3.761384707109125*^9, 
   3.761384808878574*^9, 3.7613863291706963`*^9, 3.761386735795845*^9, 
   3.761388107641246*^9, 3.76138845777667*^9, 3.761389748903466*^9, 
   3.761455683803912*^9, 3.761508820782054*^9, 3.76150945143657*^9, 
   3.76156375776332*^9, 3.7615639536959667`*^9, 3.761564501928249*^9, 
   3.761566379057788*^9, 3.761566455271289*^9, 3.761567118909148*^9, 
   3.7616470283668613`*^9, 3.761647428831696*^9, 3.761647783776265*^9, 
   3.7616484919159718`*^9, 3.761649053510816*^9, 3.761649560818347*^9, 
   3.7616500797478437`*^9, 3.761652232005067*^9, 3.761652685205611*^9, 
   3.76165315678121*^9, 3.761653366380701*^9, 3.76165532154347*^9, 
   3.76165575522059*^9, 3.7618968649836187`*^9, 3.761902983293178*^9, 
   3.7619053841136923`*^9, 3.76190600887951*^9, 3.7626938403367653`*^9, 
   3.76269424172759*^9, 3.76284037407128*^9, 3.762855935796369*^9, 
   3.762856566842101*^9, 3.763442066202038*^9, 3.763444887881296*^9, 
   3.763445144979817*^9, 3.763808476245908*^9, 3.7638085856008863`*^9, 
   3.76380883097814*^9, 3.763808895277052*^9, 3.763902531989822*^9, 
   3.763903278087089*^9, 3.7639036681440983`*^9, 3.764330021806488*^9, 
   3.764330171761979*^9, 3.76433060413279*^9, 3.76433165362327*^9, 
   3.764332596141801*^9, 3.764393534232435*^9, 3.7644136762044*^9, 
   3.765266220133782*^9, 3.779710968538794*^9},
 CellLabel->"Out[13]=",
 CellID->1470328763,ExpressionUUID->"fce2c44c-6f0e-45b6-96ec-2a2c18d0a96d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckKineticTermNormalisation", "[", 
  RowBox[{"LSM", "+", "LpNG"}], "]"}]], "Input",
 CellChangeTimes->{{3.761055080715129*^9, 3.761055085467546*^9}, {
   3.76138630114634*^9, 3.76138630205814*^9}, 3.761563701898076*^9, 
   3.7615662969199533`*^9, 3.761567094540159*^9},
 CellLabel->"In[14]:=",
 CellID->350105501,ExpressionUUID->"d5e8837f-fd26-42a9-b425-92a2e72bfccc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxVkow3EcAPCZmxE5JrSyRP6WYiJs6ecaS5FQHkRylTNM8TDHHohSrjBZ
yRwP7m1ZhNTmemA8SESOTaPfSrEShe/34dMnrKKpoMqBxWKJAbd4aVXtTMlK
QHbKPFyo0E3jV0cjJYEulOgVp8GZsNDUNouX2fhruOXRVJcFX97rVXienSeV
wN+/Vhn+9TbIzYZ39PM5tfCQ76ioF14UVw7gZvOS9ww8a7VG4NvrHXW4qrSl
SAULgpzK8LNETw3OWBVbRjjER/mKCwRbAYcwL1bWiL/vNmtxF0n4J36m1sQf
wT5jTmnHcL/jZCd+Ix7S4frAvnNctMA3nMC1E7xvfK8zWJfqSknX/sZGGmw4
MN6lwzFT99EZ8JyIfWtwo6Txws4xwu0JdzUcd0oKHCwsf7jepszDxxmpMM6D
Eg/mY1QIS7VPGvy2YzrUArP3GAbPj1Tm4z8yobufJyVynawaf8kRT+Dqh1bj
M5z+wb/Gy8MTvc1wt71mGG/oSXG1wIuv8mM2hxKbpFTFgTerk1+WvSjJNf3+
JUVR8g8tjOWn
  "],
 CellLabel->"During evaluation of In[14]:=",
 CellID->223535781,ExpressionUUID->"f5c31b75-cab4-4716-8bfa-45f99d07ed61"],

Cell[BoxData["\<\"All kinetic terms are diagonal.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxVkow3EcAPC/OeaYRc7QyhL5W4oJsaWfa+yFhPIgkqucYYoH1x6IUq4w
WckcD+5ZW4TUxnhwPUhEjk2j30qxEiXf78OnT3hFU0GVE8MwUhBUvLymcaVk
NSAndQEuVOpm8Ovj0ZJAN0oMytOQLFh80TaHl9mF67j16aIuG756MKjxPIdA
LoN//mwK/Pt9KCgH3jUs5NbCw75jkj54SVo5iFssy/xZeM5mi8R3NjrqcHVp
S5EaFgW7lOFnSV5anLUp9SY41Ef1hotE+oAjWBCnaMQ/9pq3cTdZxBd+ptEm
HMM+4y7pZnjAeaoTv5UO63BDYP85LlkUGk/g2knBD77fGaJL41LSfbC5mQ4b
D033GXDs9ENMJjwv4dwZ3SlpvHTwTHB74n0Nz4OSAicr4w/X21V5+AQrF8d7
UuLJfo6JYfn2sxa/65gJs8KcfZbF86NU+fivQuzh50VJl05Rjb/mSidxzWOr
6QXO+BTe4OURSXwL3OOoGcEbelO5VnjprcvM4VFil5WqefBWdcrrijclybd8
JiWakn8im+Ov
  "],
 CellLabel->"During evaluation of In[14]:=",
 CellID->1308204219,ExpressionUUID->"a5704921-29ac-4898-95cf-9761e0acada6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: Kinetic term for \"\>", 
   "\[InvisibleSpace]", "\<\"{ve, vebar}\"\>", 
   "\[InvisibleSpace]", "\<\" seems not to be correctly normalized.\"\>"}],
  SequenceForm[
  "Warning: Kinetic term for ", "{ve, vebar}", 
   " seems not to be correctly normalized."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzmkog3EcwPHH3IzIGVpZcjyWYqLY0t819oaE8kIkVznDFC9ce0HUihEm
K5njhXuWRUhtrheuFxKRY9ND/5ViJUp+vxffPm+/4RVNBVUODMNIoaDixRWd
MyXLATmpc2Ch0jCFXh+NlAS6UGJUnoZkgeKLthm0zCZcRa1PF3XZ4NWDUYvm
2QVyGfjzxynQ7/ehoBxwxziXWwuqfNWSPnBBWjmIWiyL3tPgDMdFottrHXWo
trSlSAuKgp3K0LNkTz3KcsotMxjqo3lDRaKtgENQEK9oRD92mzdRF1nEF3qm
0ycegT6jTunH4IDjRCd6K1UZUGNg/zkqmReaTsDaccEPutcZYkhzpaR7f309
HTQdmO8zwLjJh9hMcFbCuzO5UdJ4aeebwfak+xq+OyUFDlbGH6y3afLQMVYu
TvCgxIP9VItB+eazHr3rmAqzgrw9lkXzozT56K9C7O7nSUmXQVGNvuZKx1Hd
Y6v5Bcz4FN6g5RHJ3hawx14zjDb0prpawYW3rmMenxKbrFTLBzeqU16XvOAz
eodJiaHkHyN74+A=
  "],
 CellLabel->"During evaluation of In[14]:=",
 CellID->1346454711,ExpressionUUID->"94123e3b-df91-443d-8a16-7d8928d74f65"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: Kinetic term for \"\>", 
   "\[InvisibleSpace]", "\<\"{vm, vmbar}\"\>", 
   "\[InvisibleSpace]", "\<\" seems not to be correctly normalized.\"\>"}],
  SequenceForm[
  "Warning: Kinetic term for ", "{vm, vmbar}", 
   " seems not to be correctly normalized."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxVkow3EcAPC/mXtEztDKEvlbijlqtvRzjb2QUB5EcpUzTPHg2oOrlCtM
VjLHg3tbFiG1uR5cDxKRY9Pot1KsRMn3+/DpE1bWkFfhwDCMFAQWLq1qnChZ
8c9Knofzlfpp/PpopCjAmRKD8jQ4AxZdtMziJTbBGm55uqjJhK8eDGo8x86X
y+CfP6sC/34fDMyCdwzz2dXwkM+opAdelJYP4GbzktcMPGu1RuDb6201uLq4
qUANC4O4JfhZkocWZ63KLRMc4q16w4XCLf9DmB+rqMc/dht1uLMs/As/02jj
j2DvMW7qMdznONmO30qH9LghoPcclywIjCdw9QT/B99rD9anuFDSub+xkQob
D0z3aXDM1EN0Ojwn4dwZXSmpv7TzTHBr4n0Vz42SPAcL4wfX2lQ5+DgrF8W5
U+LOfo6KYLnuWYvftU2HWmDOHsviuZGqXPxXIXLz9aCkQ6+oxF+zpRO45rHZ
9AKnfQpu8NLwJC8z3GWvGsbrupNdLPDiW8cxh0eJTVas5sGbleLXZU9K+hN2
GHEUJf8kruQI
  "],
 CellLabel->"During evaluation of In[14]:=",
 CellID->1829139338,ExpressionUUID->"9ffe1bf8-5ae9-4997-b379-26851992f3ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: Kinetic term for \"\>", 
   "\[InvisibleSpace]", "\<\"{vt, vtbar}\"\>", 
   "\[InvisibleSpace]", "\<\" seems not to be correctly normalized.\"\>"}],
  SequenceForm[
  "Warning: Kinetic term for ", "{vt, vtbar}", 
   " seems not to be correctly normalized."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVz2kog3EcwPHH3DwWOUMrS+SxFBPFlv6usTcklBciucoZpnjh2guilCtM
VjLHC/esLUJqc71wvZCIHJtG/5VipSn5/V58+7z+RlQ0FVQ5MQwjhYKLl9c0
rpSsBuakLoCFSt0MenM8WhLkRolBeRaaBYov2+bQMptwHbU8X9Zlg9ePBjWa
ZxfIZaDjz6pAfz6GgnPAXcNCbi047Dcm6QOXpJWDqNm8zJ8F56zWKHRno6MO
VZe2FKlBUYhLGXqe7K1FOatSbwLDfFXvqEikDzwCBfGKRvRzr3kbdZNFfqPn
Gm3iMeg77pJ+Ag44T3Wid9JhHWoI6r9AJYtC4ylYOylwoPudobo0d0q6DzY3
00HjoekhA4ybfozNBOclvHujByWNV3bWBLYnPdSwnpQUOFmYALDepspDJzi5
OMGLEi/ua0wMyrdftOh9x0y4BeTtcxyaH63KR38VYk9/b0q6dIpq9C1XOolq
nlpNr2DGl/AWLY9M5pvBHnvNCNrQm+puAZfeu054LCU2WamaBbeqU95WfOAj
bZdJiaHkHySk5Ag=
  "],
 CellLabel->"During evaluation of In[14]:=",
 CellID->1116446961,ExpressionUUID->"bae25491-cb14-43b4-afa6-e7fc206a79ed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"CheckMassSpectrum", "[", 
   RowBox[{
    RowBox[{"LSM", "+", "LpNG"}], ",", 
    RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.761055096143298*^9, 3.761055106885706*^9}, 
   3.7613863032398148`*^9, 3.761563704991057*^9, {3.761564044230242*^9, 
   3.7615640475890417`*^9}, {3.761564711533854*^9, 3.761564746752191*^9}, 
   3.7615663112102127`*^9, 3.761567095731244*^9, {3.761647315437684*^9, 
   3.761647318171315*^9}},
 CellLabel->"In[15]:=",
 CellID->1348508967,ExpressionUUID->"470158b6-90b9-48e0-ba50-3511a9c89d40"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.761055114684297*^9, 3.761056232868743*^9, 3.7610570233641*^9, 
   3.761287898612447*^9, 3.761383654039109*^9, 3.761384725325296*^9, 
   3.761384835081208*^9, 3.761386344138378*^9, 3.761386752082531*^9, 
   3.761388123362561*^9, 3.76138847361415*^9, 3.761389770092876*^9, 
   3.7614557069981413`*^9, 3.7615088526931267`*^9, 3.761509468907997*^9, 
   3.761563779837392*^9, 3.761563969023183*^9, 3.761564053331833*^9, 
   3.7615645308799677`*^9, 3.7615646146458063`*^9, {3.7615647227631607`*^9, 
   3.761564743208927*^9}, 3.7615663799867373`*^9, 3.761566456964254*^9, 
   3.7615671442771273`*^9, 3.761647050468947*^9, 3.761647326165859*^9, 
   3.761647451098283*^9, 3.761648513727165*^9, 3.7616490703538513`*^9, 
   3.761649257084671*^9, 3.761649340698421*^9, 3.7616495845267467`*^9, 
   3.761650095852833*^9, 3.7616522557471027`*^9, 3.7616527069634027`*^9, 
   3.761653179360311*^9, 3.76165338268795*^9, 3.7616553433531322`*^9, 
   3.761655771312251*^9, 3.761896887064355*^9, 3.761903000238689*^9, 
   3.761905401115988*^9, 3.7619060259496117`*^9, 3.762693862305703*^9, 
   3.7626942589264097`*^9, 3.7628403998778353`*^9, 3.7628559568892403`*^9, 
   3.7628565831987667`*^9, 3.763442090166279*^9, 3.76344490975675*^9, 
   3.7634451614538517`*^9, 3.7638084936611958`*^9, 3.7638086077764187`*^9, 
   3.7638089109251013`*^9, 3.763902547644603*^9, 3.763903294162451*^9, 
   3.763903684314849*^9, 3.764330037787932*^9, 3.764330186728929*^9, 
   3.764330619880863*^9, 3.7643316692751093`*^9, 3.7643326126748257`*^9, 
   3.7643935502768097`*^9, 3.764413694771717*^9, 3.765266236293106*^9, 
   3.779710989573729*^9},
 CellLabel->"During evaluation of In[15]:=",
 CellID->190939555,ExpressionUUID->"c704b565-5808-4c22-888e-9f72f48fd6f8"],

Cell[BoxData["\<\"All mass terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{
  3.761055114684297*^9, 3.761056232868743*^9, 3.7610570233641*^9, 
   3.761287898612447*^9, 3.761383654039109*^9, 3.761384725325296*^9, 
   3.761384835081208*^9, 3.761386344138378*^9, 3.761386752082531*^9, 
   3.761388123362561*^9, 3.76138847361415*^9, 3.761389770092876*^9, 
   3.7614557069981413`*^9, 3.7615088526931267`*^9, 3.761509468907997*^9, 
   3.761563779837392*^9, 3.761563969023183*^9, 3.761564053331833*^9, 
   3.7615645308799677`*^9, 3.7615646146458063`*^9, {3.7615647227631607`*^9, 
   3.761564743208927*^9}, 3.7615663799867373`*^9, 3.761566456964254*^9, 
   3.7615671442771273`*^9, 3.761647050468947*^9, 3.761647326165859*^9, 
   3.761647451098283*^9, 3.761648513727165*^9, 3.7616490703538513`*^9, 
   3.761649257084671*^9, 3.761649340698421*^9, 3.7616495845267467`*^9, 
   3.761650095852833*^9, 3.7616522557471027`*^9, 3.7616527069634027`*^9, 
   3.761653179360311*^9, 3.76165338268795*^9, 3.7616553433531322`*^9, 
   3.761655771312251*^9, 3.761896887064355*^9, 3.761903000238689*^9, 
   3.761905401115988*^9, 3.7619060259496117`*^9, 3.762693862305703*^9, 
   3.7626942589264097`*^9, 3.7628403998778353`*^9, 3.7628559568892403`*^9, 
   3.7628565831987667`*^9, 3.763442090166279*^9, 3.76344490975675*^9, 
   3.7634451614538517`*^9, 3.7638084936611958`*^9, 3.7638086077764187`*^9, 
   3.7638089109251013`*^9, 3.763902547644603*^9, 3.763903294162451*^9, 
   3.763903684314849*^9, 3.764330037787932*^9, 3.764330186728929*^9, 
   3.764330619880863*^9, 3.7643316692751093`*^9, 3.7643326126748257`*^9, 
   3.7643935502768097`*^9, 3.764413694771717*^9, 3.765266236293106*^9, 
   3.779710990149653*^9},
 CellLabel->"During evaluation of In[15]:=",
 CellID->780532267,ExpressionUUID->"95cce1c5-a8cf-4430-bd85-03ec5b0cf3ec"],

Cell[BoxData["\<\"Getting mass spectrum.\"\>"], "Print",
 CellChangeTimes->{
  3.761055114684297*^9, 3.761056232868743*^9, 3.7610570233641*^9, 
   3.761287898612447*^9, 3.761383654039109*^9, 3.761384725325296*^9, 
   3.761384835081208*^9, 3.761386344138378*^9, 3.761386752082531*^9, 
   3.761388123362561*^9, 3.76138847361415*^9, 3.761389770092876*^9, 
   3.7614557069981413`*^9, 3.7615088526931267`*^9, 3.761509468907997*^9, 
   3.761563779837392*^9, 3.761563969023183*^9, 3.761564053331833*^9, 
   3.7615645308799677`*^9, 3.7615646146458063`*^9, {3.7615647227631607`*^9, 
   3.761564743208927*^9}, 3.7615663799867373`*^9, 3.761566456964254*^9, 
   3.7615671442771273`*^9, 3.761647050468947*^9, 3.761647326165859*^9, 
   3.761647451098283*^9, 3.761648513727165*^9, 3.7616490703538513`*^9, 
   3.761649257084671*^9, 3.761649340698421*^9, 3.7616495845267467`*^9, 
   3.761650095852833*^9, 3.7616522557471027`*^9, 3.7616527069634027`*^9, 
   3.761653179360311*^9, 3.76165338268795*^9, 3.7616553433531322`*^9, 
   3.761655771312251*^9, 3.761896887064355*^9, 3.761903000238689*^9, 
   3.761905401115988*^9, 3.7619060259496117`*^9, 3.762693862305703*^9, 
   3.7626942589264097`*^9, 3.7628403998778353`*^9, 3.7628559568892403`*^9, 
   3.7628565831987667`*^9, 3.763442090166279*^9, 3.76344490975675*^9, 
   3.7634451614538517`*^9, 3.7638084936611958`*^9, 3.7638086077764187`*^9, 
   3.7638089109251013`*^9, 3.763902547644603*^9, 3.763903294162451*^9, 
   3.763903684314849*^9, 3.764330037787932*^9, 3.764330186728929*^9, 
   3.764330619880863*^9, 3.7643316692751093`*^9, 3.7643326126748257`*^9, 
   3.7643935502768097`*^9, 3.764413694771717*^9, 3.765266236293106*^9, 
   3.77971099592489*^9},
 CellLabel->"During evaluation of In[15]:=",
 CellID->1575695593,ExpressionUUID->"9463549f-0f3a-404d-8467-e90966778f2a"],

Cell[BoxData["\<\"Checking for less then 0.1% agreement with model file \
values.\"\>"], "Print",
 CellChangeTimes->{
  3.761055114684297*^9, 3.761056232868743*^9, 3.7610570233641*^9, 
   3.761287898612447*^9, 3.761383654039109*^9, 3.761384725325296*^9, 
   3.761384835081208*^9, 3.761386344138378*^9, 3.761386752082531*^9, 
   3.761388123362561*^9, 3.76138847361415*^9, 3.761389770092876*^9, 
   3.7614557069981413`*^9, 3.7615088526931267`*^9, 3.761509468907997*^9, 
   3.761563779837392*^9, 3.761563969023183*^9, 3.761564053331833*^9, 
   3.7615645308799677`*^9, 3.7615646146458063`*^9, {3.7615647227631607`*^9, 
   3.761564743208927*^9}, 3.7615663799867373`*^9, 3.761566456964254*^9, 
   3.7615671442771273`*^9, 3.761647050468947*^9, 3.761647326165859*^9, 
   3.761647451098283*^9, 3.761648513727165*^9, 3.7616490703538513`*^9, 
   3.761649257084671*^9, 3.761649340698421*^9, 3.7616495845267467`*^9, 
   3.761650095852833*^9, 3.7616522557471027`*^9, 3.7616527069634027`*^9, 
   3.761653179360311*^9, 3.76165338268795*^9, 3.7616553433531322`*^9, 
   3.761655771312251*^9, 3.761896887064355*^9, 3.761903000238689*^9, 
   3.761905401115988*^9, 3.7619060259496117`*^9, 3.762693862305703*^9, 
   3.7626942589264097`*^9, 3.7628403998778353`*^9, 3.7628559568892403`*^9, 
   3.7628565831987667`*^9, 3.763442090166279*^9, 3.76344490975675*^9, 
   3.7634451614538517`*^9, 3.7638084936611958`*^9, 3.7638086077764187`*^9, 
   3.7638089109251013`*^9, 3.763902547644603*^9, 3.763903294162451*^9, 
   3.763903684314849*^9, 3.764330037787932*^9, 3.764330186728929*^9, 
   3.764330619880863*^9, 3.7643316692751093`*^9, 3.7643326126748257`*^9, 
   3.7643935502768097`*^9, 3.764413694771717*^9, 3.765266236293106*^9, 
   3.779710995926758*^9},
 CellLabel->"During evaluation of In[15]:=",
 CellID->2094980394,ExpressionUUID->"34b325e1-b88b-4891-bd2a-526cecac9157"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Particle\"\>", "\<\"Analytic value\"\>", "\<\"Numerical value\"\>", \
"\<\"Model-file value\"\>"},
    {"h", 
     FractionBox[
      SqrtBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         RowBox[{"(", 
          RowBox[{"Cos", " ", "\[Theta]"}], ")"}], " ", 
         SubscriptBox["\[Lambda]", "\[CapitalPhi]S"], " ", 
         RowBox[{"(", 
          RowBox[{"Sin", " ", "\[Theta]"}], ")"}], " ", 
         SubscriptBox["v", "h"], " ", 
         SubscriptBox["v", "s"]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"Cos", " ", "\[Theta]"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            TemplateBox[{SubscriptBox["\[Mu]", "\[CapitalPhi]"],"2"},
             "Superscript"]}], "+", 
           RowBox[{"3", " ", 
            SubscriptBox["\[Lambda]", "\[CapitalPhi]"], " ", 
            SubsuperscriptBox["v", "h", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Lambda]", "\[CapitalPhi]S"], " ", 
            SubsuperscriptBox["v", "s", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"Sin", " ", "\[Theta]"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           
           TemplateBox[{
            SubscriptBox["\[Mu]", "S"],RowBox[{"2", " ", "\[Prime]"}]},
            "Superscript"], "+", 
           TemplateBox[{SubscriptBox["\[Mu]", "S"],"2"},
            "Superscript"], "-", 
           RowBox[{
            SubscriptBox["\[Lambda]", "\[CapitalPhi]S"], " ", 
            SubsuperscriptBox["v", "h", "2"]}], "-", 
           RowBox[{"3", " ", 
            SubscriptBox["\[Lambda]", "S"], " ", 
            SubsuperscriptBox["v", "s", "2"]}]}], ")"}]}]}]], 
      SqrtBox["2"]], "125.`", "125.`"},
    {"h2", 
     FractionBox[
      SqrtBox[
       RowBox[{
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{"Cos", " ", "\[Theta]"}], ")"}], " ", 
         SubscriptBox["\[Lambda]", "\[CapitalPhi]S"], " ", 
         RowBox[{"(", 
          RowBox[{"Sin", " ", "\[Theta]"}], ")"}], " ", 
         SubscriptBox["v", "h"], " ", 
         SubscriptBox["v", "s"]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"Sin", " ", "\[Theta]"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            TemplateBox[{SubscriptBox["\[Mu]", "\[CapitalPhi]"],"2"},
             "Superscript"]}], "+", 
           RowBox[{"3", " ", 
            SubscriptBox["\[Lambda]", "\[CapitalPhi]"], " ", 
            SubsuperscriptBox["v", "h", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Lambda]", "\[CapitalPhi]S"], " ", 
            SubsuperscriptBox["v", "s", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"Cos", " ", "\[Theta]"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           
           TemplateBox[{
            SubscriptBox["\[Mu]", "S"],RowBox[{"2", " ", "\[Prime]"}]},
            "Superscript"], "+", 
           TemplateBox[{SubscriptBox["\[Mu]", "S"],"2"},
            "Superscript"], "-", 
           RowBox[{
            SubscriptBox["\[Lambda]", "\[CapitalPhi]S"], " ", 
            SubsuperscriptBox["v", "h", "2"]}], "-", 
           RowBox[{"3", " ", 
            SubscriptBox["\[Lambda]", "S"], " ", 
            SubsuperscriptBox["v", "s", "2"]}]}], ")"}]}]}]], 
      SqrtBox["2"]], "300.00000000000006`", "300.`"},
    {"X", 
     FractionBox[
      SqrtBox[
       RowBox[{
        TemplateBox[{
         SubscriptBox["\[Mu]", "S"],RowBox[{"2", " ", "\[Prime]"}]},
         "Superscript"], "-", 
        TemplateBox[{SubscriptBox["\[Mu]", "S"],"2"},
         "Superscript"], "+", 
        RowBox[{
         SubscriptBox["\[Lambda]", "\[CapitalPhi]S"], " ", 
         SubsuperscriptBox["v", "h", "2"]}], "+", 
        RowBox[{
         SubscriptBox["\[Lambda]", "S"], " ", 
         SubsuperscriptBox["v", "s", "2"]}]}]], 
      SqrtBox["2"]], "100.00000000000006`", "100.`"},
    {"b", 
     FractionBox[
      RowBox[{
       SubscriptBox["v", "h"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","d"},
            "Superscript"], ")"}], 
          RowBox[{"3", ",", "3"}], "\<\"*\"\>"], "+", 
         SubscriptBox[
          TemplateBox[{"y","d"},
           "Superscript"], 
          RowBox[{"3", ",", "3"}]]}], ")"}]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]], "4.700000000000002`", "4.7`"},
    {"d", 
     FractionBox[
      RowBox[{
       SubscriptBox["v", "h"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","d"},
            "Superscript"], ")"}], 
          RowBox[{"1", ",", "1"}], "\<\"*\"\>"], "+", 
         SubscriptBox[
          TemplateBox[{"y","d"},
           "Superscript"], 
          RowBox[{"1", ",", "1"}]]}], ")"}]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]], "0.005040000000000001`", "0.00504`"},
    {"s", 
     FractionBox[
      RowBox[{
       SubscriptBox["v", "h"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","d"},
            "Superscript"], ")"}], 
          RowBox[{"2", ",", "2"}], "\<\"*\"\>"], "+", 
         SubscriptBox[
          TemplateBox[{"y","d"},
           "Superscript"], 
          RowBox[{"2", ",", "2"}]]}], ")"}]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]], "0.10100000000000002`", "0.101`"},
    {"e", 
     FractionBox[
      RowBox[{
       SubscriptBox["v", "h"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","l"},
            "Superscript"], ")"}], 
          RowBox[{"1", ",", "1"}], "\<\"*\"\>"], "+", 
         SubscriptBox[
          TemplateBox[{"y","l"},
           "Superscript"], 
          RowBox[{"1", ",", "1"}]]}], ")"}]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]], "0.0005110000000000001`", "0.000511`"},
    {"mu", 
     FractionBox[
      RowBox[{
       SubscriptBox["v", "h"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","l"},
            "Superscript"], ")"}], 
          RowBox[{"2", ",", "2"}], "\<\"*\"\>"], "+", 
         SubscriptBox[
          TemplateBox[{"y","l"},
           "Superscript"], 
          RowBox[{"2", ",", "2"}]]}], ")"}]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]], "0.10566000000000003`", "0.10566`"},
    {"ta", 
     FractionBox[
      RowBox[{
       SubscriptBox["v", "h"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","l"},
            "Superscript"], ")"}], 
          RowBox[{"3", ",", "3"}], "\<\"*\"\>"], "+", 
         SubscriptBox[
          TemplateBox[{"y","l"},
           "Superscript"], 
          RowBox[{"3", ",", "3"}]]}], ")"}]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]], "1.7770000000000006`", "1.777`"},
    {"c", 
     FractionBox[
      RowBox[{
       SubscriptBox["v", "h"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","u"},
            "Superscript"], ")"}], 
          RowBox[{"2", ",", "2"}], "\<\"*\"\>"], "+", 
         SubscriptBox[
          TemplateBox[{"y","u"},
           "Superscript"], 
          RowBox[{"2", ",", "2"}]]}], ")"}]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]], "1.2700000000000002`", "1.27`"},
    {"t", 
     FractionBox[
      RowBox[{
       SubscriptBox["v", "h"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","u"},
            "Superscript"], ")"}], 
          RowBox[{"3", ",", "3"}], "\<\"*\"\>"], "+", 
         SubscriptBox[
          TemplateBox[{"y","u"},
           "Superscript"], 
          RowBox[{"3", ",", "3"}]]}], ")"}]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]], "172.00000000000003`", "172.`"},
    {"u", 
     FractionBox[
      RowBox[{
       SubscriptBox["v", "h"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","u"},
            "Superscript"], ")"}], 
          RowBox[{"1", ",", "1"}], "\<\"*\"\>"], "+", 
         SubscriptBox[
          TemplateBox[{"y","u"},
           "Superscript"], 
          RowBox[{"1", ",", "1"}]]}], ")"}]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]], "0.002550000000000001`", "0.00255`"},
    {"W", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       FractionBox[
        RowBox[{
         SuperscriptBox["e", "2"], " ", 
         SubsuperscriptBox["v", "h", "2"]}], 
        SubsuperscriptBox["s", "w", "2"]]]}], "79.82435974619786`", 
     "79.82435974619784`"},
    {"Z", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       FractionBox[
        RowBox[{
         SuperscriptBox["e", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubsuperscriptBox["c", "w", "2"], "+", 
            SubsuperscriptBox["s", "w", "2"]}], ")"}], "2"], " ", 
         SubsuperscriptBox["v", "h", "2"]}], 
        RowBox[{
         SubsuperscriptBox["c", "w", "2"], " ", 
         SubsuperscriptBox["s", "w", "2"]}]]]}], "91.18760000000003`", 
     "91.1876`"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.7643301912947702`*^9, 3.76433062449349*^9, 
  3.764331673844698*^9, 3.7643326172507553`*^9, 3.764393554996098*^9, 
  3.764413699695644*^9, 3.765266241106073*^9, 3.7797109961411037`*^9},
 CellLabel->"Out[15]//TableForm=",
 CellID->193605746,ExpressionUUID->"f5cb9743-69d7-45e0-b8ae-38f65b50fc2d"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.764330014877201*^9},
 CellID->967486392,ExpressionUUID->"74787f9b-d216-4ecb-849a-35eb875d3b61"],

Cell[CellGroupData[{

Cell["Calculate Feynman rules", "Section",
 CellChangeTimes->{{3.761055223014491*^9, 3.761055246948103*^9}},
 CellID->366046402,ExpressionUUID->"9b721fac-1f43-4090-bea5-e7e7ac0bc819"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"vertices", "=", " ", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{
     RowBox[{"LSM", "+", "LpNG"}], ",", 
     RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.761055249052518*^9, 3.761055260167818*^9}, {
  3.761055347583497*^9, 3.761055351186933*^9}},
 CellLabel->"In[16]:=",
 CellID->1748713406,ExpressionUUID->"c0f5fa87-55fd-4dda-894f-439732244ef1"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAWKGW9cPL2F942ji634eRDvlLbVfCqQFfJTixNjeOEps
mqDpCqTtlsZsBtE9MdN/guiWhUFlbkC6QOVoFYiWcvldD6JvV9v7uQNpvUnm
ch5A+snjU05NQPpXyL1eEC2wtPn4USBdVHPmLYgueBFcdAxI1/3tPgyidzDP
YDwOpGtcHW1A9JltnY0ngLTcnUk7QPS1CWeugOiotN+nT4L0/5zwF0QvLOM6
a8/+xlHUMvekE5DeIR73xBlIWyy2s3YB0kV8svePcLxxdBNy5j8KpMvOx1Xx
cL5xvJI8WVIESK/Q6Q0G0VzexWZGXG8cqz5emWYMpF9oK+8F0W3J56WFud84
Vrj1ZoDoFYlhM0H08dWzTjHxvHEUYjPZxgOkP2mlvVjD+8ax7+YPNivNN44A
vFCf2Q==
  "],
 CellLabel->"During evaluation of In[16]:=",
 CellID->1526377920,ExpressionUUID->"2bac2e3c-7c3d-45fc-bf22-d92cabbbdaed"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAWKGW9cPL2F942ji634eRDvlLbVfCqQFfJTixNjeOEps
mqDpCqTtlsZsBtE9MdN/guiWhUFlbkC6QOVoFYiWcvldD6JvV9v7uQNpvUnm
ch5A+snjU05NQPpXyL1eEC2wtPn4USBdVHPmLYgueBFcdAxI1/3tPgyidzDP
YDwOpGtcHW1A9JltnY0ngLTcnUk7QPS1CWeugOiotN+nT4L0/5zwF0QvLOM6
a8/+xlHUMvekE5DeIR73xBlIWyy2s3YB0kV8svePcLxxdBNy5j8KpMvOx1Xx
cL5xvJI8WVIESK/Q6Q0G0VzexWZGXG8cqz5emWYMpF9oK+8F0W3J56WFud84
Vrj1ZoDoFYlhM0H08dWzTjHxvHEUYjPZxgOkP2mlvVjD+8bx3ssfbFaabxwB
v0CgOQ==
  "],
 CellLabel->"During evaluation of In[16]:=",
 CellID->2141538025,ExpressionUUID->"28f08a91-1d48-45c0-8408-6649f9ca8e47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAWKGW9cPL2F942ji634eRDvlLbVfCqQFfJTixNjeOEps
mqDpCqTtlsZsBtE9MdN/guiWhUFlbkC6QOVoFYiWcvldD6JvV9v7uQNpvUnm
ch5A+snjU05NQPpXyL1eEC2wtPn4USBdVHPmLYgueBFcdAxI1/3tPgyidzDP
YDwOpGtcHW1A9JltnY0ngLTcnUk7QPS1CWeugOiotN+nT4L0/5zwF0QvLOM6
a8/+xlHUMvekE5DeIR73xBlIWyy2s3YB0kV8svePcLxxdBNy5j8KpMvOx1Xx
cL5xvJI8WVIESK/Q6Q0G0VzexWZGXG8cqz5emWYMpF9oK+8F0W3J56WFud84
Vrj1ZoDoFYlhM0H08dWzTjHxvHEUYjPZxgOkP2mlvVjD+8Yx7NMPNivNN44A
uz+fug==
  "],
 CellLabel->"During evaluation of In[16]:=",
 CellID->1003662455,ExpressionUUID->"740e8171-eca2-4697-80b2-deaa9657c46b"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAWKGW9cPL2F942ji634eRDvlLbVfCqQFfJTixNjeOEps
mqDpCqTtlsZsBtE9MdN/guiWhUFlbkC6QOVoFYiWcvldD6JvV9v7uQNpvUnm
ch5A+snjU05NQPpXyL1eEC2wtPn4USBdVHPmLYgueBFcdAxI1/3tPgyidzDP
YDwOpGtcHW1A9JltnY0ngLTcnUk7QPS1CWeugOiotN+nT4L0/5zwF0QvLOM6
a8/+xlHUMvekE5DeIR73xBlIWyy2s3YB0kV8svePcLxxdBNy5j8KpMvOx1Xx
cL5xvJI8WVIESK/Q6Q0G0VzexWZGXG8cqz5emWYMpF9oK+8F0W3J56WFud84
Vrj1ZoDoFYlhM0H08dWzTjHxvHEUYjPZxgOkP2mlvVjD+8YxNeQGu5XmG0cA
tqqfDA==
  "],
 CellLabel->"During evaluation of In[16]:=",
 CellID->701203447,ExpressionUUID->"e3fea650-4a48-4e8e-b23f-b27863230938"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "130", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "130", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  130, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 130, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAWKGW9cPL2F942ji634eRDvlLbVfCqQFfJTixNjeOEps
mqDpCqTtlsZsBtE9MdN/guiWhUFlbkC6QOVoFYiWcvldD6JvV9v7uQNpvUnm
ch5A+snjU05NQPpXyL1eEC2wtPn4USBdVHPmLYgueBFcdAxI1/3tPgyidzDP
YDwOpGtcHW1A9JltnY0ngLTcnUk7QPS1CWeugOiotN+nT4L0/5zwF0QvLOM6
a8/+xlHUMvekE5DeIR73xBlIWyy2s3YB0kV8svePcLxxdBNy5j8KpMvOx1Xx
cL5xvJI8WVIESK/Q6Q0G0VzexWZGXG8cqz5emWYMpF9oK+8F0W3J56WFud84
Vrj1ZoDoFYlhM0H08dWzTjHxvHEUYjPZxgOkP2mlvVjDCxT/dIvdSvONIwC+
GKAO
  "],
 CellLabel->"During evaluation of In[16]:=",
 CellID->1883562640,ExpressionUUID->"0ac82ace-56dd-432a-8c08-07d3fdfa1b16"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"103", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[103, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAWKGW9cPL2F942ji634eRDvlLbVfCqQFfJTixNjeOEps
mqDpCqTtlsZsBtE9MdN/guiWhUFlbkC6QOVoFYiWcvldD6JvV9v7uQNpvUnm
ch5A+snjU05NQPpXyL1eEC2wtPn4USBdVHPmLYgueBFcdAxI1/3tPgyidzDP
YDwOpGtcHW1A9JltnY0ngLTcnUk7QPS1CWeugOiotN+nT4L0/5zwF0QvLOM6
a8/+xlHUMvekE5DeIR73xBlIWyy2s3YB0kV8svePcLxxdBNy5j8KpMvOx1Xx
cL5xvJI8WVIESK/Q6Q0G0VzexWZGXG8cqz5emWYMpF9oK+8F0W3J56WFud84
Vrj1ZoDoFYlhM0H08dWzTjHxvHEUYjPZxgOkP2mlvVjD+8bxiOpsDivNN44A
tvCfAA==
  "],
 CellLabel->"During evaluation of In[16]:=",
 CellID->980850053,ExpressionUUID->"c94db32b-e8fc-432d-93f5-f15220b0b6b2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generate output files (CalcHEP/CompHEP or UFO or FeynArts)", "Section",
 CellChangeTimes->{{3.7610552993454933`*^9, 3.761055306968809*^9}, {
  3.761056348844407*^9, 3.761056357622654*^9}, {3.7613848771658287`*^9, 
  3.761384878694256*^9}, {3.7619038889576*^9, 3.761903897270966*^9}},
 CellID->116816367,ExpressionUUID->"28612ff9-e185-4763-893b-36ce4ca841e0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteCHOutput", "[", 
  RowBox[{
   RowBox[{"LSM", "+", "LpNG"}], ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.761999330301106*^9, 3.76199934276195*^9}, {
  3.762000672504694*^9, 3.7620006726632566`*^9}},
 CellLabel->"In[17]:=",
 CellID->2109175560,ExpressionUUID->"8dc78173-e1dd-4be8-981e-fce8c3293986"],

Cell[BoxData["\<\" - - - FeynRules interface to CalcHep/CompHEP\"\>"], "Print",
 CellChangeTimes->{3.779711090971788*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->1546512867,ExpressionUUID->"92186d78-5edc-44e2-9060-2a542abee31f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" - - - \"\>", "\[InvisibleSpace]", 
   StyleBox["\<\"Authors:\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" N. Christensen, C. Duhr\"\>"}],
  SequenceForm[" - - - ", 
   Style["Authors:", 
    RGBColor[0, 0, 1]], " N. Christensen, C. Duhr"],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711090974123*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->1247176028,ExpressionUUID->"b60ea563-308b-48aa-bd54-707c4584b9c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" - - - \"\>", "\[InvisibleSpace]", 
   StyleBox["\<\"Please cite:\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" arXiv:0906.2474\"\>"}],
  SequenceForm[" - - - ", 
   Style["Please cite:", 
    RGBColor[0, 0, 1]], " arXiv:0906.2474"],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711090975651*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->1847107876,ExpressionUUID->"eeec06b0-953c-4263-b8d4-23077580f1b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" files to \
/Users/ankitbeniwal/Documents/Projects/U1_DM/feynrules-current/Models/U1_\
model/SM_with_pNG-CH.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], 
   " files to \
/Users/ankitbeniwal/Documents/Projects/U1_DM/feynrules-current/Models/U1_\
model/SM_with_pNG-CH."],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711091016045*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->318470900,ExpressionUUID->"17020eba-08fc-4aa3-a8df-ccae59665f8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" particles file 'prtcls1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " particles file 'prtcls1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711091017301*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->1011167976,ExpressionUUID->"2d5dd02d-95fd-417b-a9c0-0840603caf3f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" external parameter file 'vars1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " external parameter file 'vars1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711091058486*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->1662073921,ExpressionUUID->"3024111f-1ff5-4e5c-b893-cf760ce745cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" internal parameter file 'func1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " internal parameter file 'func1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711091060275*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->9110071,ExpressionUUID->"7a98bdb7-93bd-4b98-8482-6f3c8449e510"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" external library file 'extlib1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " external library file 'extlib1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711091061849*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->641624360,ExpressionUUID->"5a78ee83-9384-4426-b622-6f45d692c067"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.7797110910630083`*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->1265226933,ExpressionUUID->"492c2ef8-2836-47eb-8b58-cb72eca0739d"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.779711091147873*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->285990337,ExpressionUUID->"b869d964-651d-468d-98d8-e232d058869b"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.77971109114895*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->571191973,ExpressionUUID->"aceaa45c-a040-43e6-8916-acc7dfa648de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7797110911500053`*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->771588121,ExpressionUUID->"7d632881-2468-4a20-a0f9-65b919811797"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.779711095887195*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->1575289061,ExpressionUUID->"561587a6-b458-474b-b10b-62ec77ed43bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "58", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "58", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  58, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 58, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711095935286*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->1704848011,ExpressionUUID->"1678d9b0-259b-4de6-8f56-c9d73fc59ee7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"53", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[53, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711099263261*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->1653702603,ExpressionUUID->"078b2af0-7780-48b8-a641-7f86c09ed3ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "53"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 4, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 53],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711100429657*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->1046289147,ExpressionUUID->"9e167179-b62e-4545-954c-443d42fdd4d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" vertices file 'lgrng1.mdl'\\nand appending \
variable file 'func1.mdl', particle file 'prtcls1.mdl' and variable file \
'vars1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], 
   " vertices file 'lgrng1.mdl'\nand appending variable file 'func1.mdl', \
particle file 'prtcls1.mdl' and variable file 'vars1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7797111051845284`*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->1385591993,ExpressionUUID->"6e7e6810-ea43-4b0a-8586-f37871a6f203"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nFinishing\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" vertices file 'lgrng1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nFinishing", 
    RGBColor[0, 0, 1]], " vertices file 'lgrng1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7797111074308157`*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->331958283,ExpressionUUID->"f40d1082-6a0a-42c4-9e46-1e9f6b915cd0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"Finishing\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" internal parameter file 'func1.mdl'.\"\>"}],
  SequenceForm[
   Style["Finishing", 
    RGBColor[0, 0, 1]], " internal parameter file 'func1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711107471167*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->60347475,ExpressionUUID->"aab39683-32c7-4d1d-aeeb-63aa4921f127"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nDone\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" in 0.28min!\"\>"}],
  SequenceForm[
   Style["\nDone", 
    RGBColor[0, 0, 1]], " in 0.28min!"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7797111074788513`*^9},
 CellLabel->"During evaluation of In[17]:=",
 CellID->647730941,ExpressionUUID->"2b4ebe63-9e55-4cdd-aea8-79ace656a57a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteUFO", "[", 
  RowBox[{
   RowBox[{"LSM", "+", "LpNG"}], ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.761056361807794*^9, 3.761056380206089*^9}},
 CellLabel->"In[18]:=",
 CellID->2077815379,ExpressionUUID->"672de9f1-0cfc-4e45-8d49-7822c9c0b6ce"],

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{3.7797114835238657`*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->49295002,ExpressionUUID->"2c2bb492-e94b-4c88-b4f6-a4cffc9bd478"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.779711483859654*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->1719894519,ExpressionUUID->"6a536d19-a0e9-4702-b664-a641d1128db8"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.7797114838609324`*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->1137292213,ExpressionUUID->"6e8532ce-e6d7-4721-86b8-19d34eb826d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7797114838622*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->1865765591,ExpressionUUID->"21577fcb-0c1e-4159-b83a-7ad182a5924d"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.779711490874557*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->366074443,ExpressionUUID->"7a4449ee-9252-4d66-a2e3-37cabd64a770"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "130", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "130", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  130, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 130, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7797114909622498`*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->72514846,ExpressionUUID->"9cfb82f4-8507-47be-9b3e-bbdbc6704c0c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"103", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[103, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711497084532*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->1133788873,ExpressionUUID->"5eed7a4a-703b-46c0-a0ff-7a2437dd9609"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "103"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 4, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 103],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711499013178*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->967188680,ExpressionUUID->"177e7bdc-0a74-4104-8926-6a4d9b413023"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{3.7797115028309813`*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->1236420617,ExpressionUUID->"76e4e84d-8e56-4e6c-b137-cd69429930b4"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.779711502873279*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->1469541547,ExpressionUUID->"5c82ecfd-ec11-4ff3-89b8-ebb586682a5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "63"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 63],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711502922612*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->375356282,ExpressionUUID->"8b4fe656-f649-4281-ac12-28cb3ed53d01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "2.309497`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 2.309497, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711509724934*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->1453560335,ExpressionUUID->"7d6dfc9f-fc1d-4bdf-a91c-1c001de5d0b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "72"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 72],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711509726947*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->214582073,ExpressionUUID->"6728870f-0119-4e6a-a9c2-9d2c6ab8cf39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.558356`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 0.558356, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7797115106705227`*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->855857598,ExpressionUUID->"9615ab0b-9bf1-449e-ba02-470edc1e26bf"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{3.779711510671946*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->553181980,ExpressionUUID->"230778e9-0059-41d2-a5cf-e8fdc7e58988"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{3.7797115108174973`*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->872829997,ExpressionUUID->"4991b19d-e2e4-4b80-8ab7-4825e4cf3961"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 4, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711510859573*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->192966922,ExpressionUUID->"3240d6ea-9ccb-4afa-a06f-ec8b3f117527"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "103", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 103, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{3.77971151189237*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->494751084,ExpressionUUID->"26dde681-7749-4c76-b87c-5b11a6583fab"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{3.779711512037706*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->224787604,ExpressionUUID->"f73ec221-67b7-4d92-a988-1bfd6f1ce7b6"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{3.779711512227901*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->581525355,ExpressionUUID->"ecca50c5-8730-47f8-b2d8-7026c5b09cba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteFeynArtsOutput", "[", 
  RowBox[{
   RowBox[{"LSM", "+", "LpNG"}], ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7610553087198668`*^9, 3.761055345745677*^9}, {
  3.7619038000362453`*^9, 3.761903811298986*^9}},
 CellLabel->"In[19]:=",
 CellID->456746452,ExpressionUUID->"e3f9db62-1e0b-4c39-8c60-ca414ec93ad2"],

Cell[BoxData["\<\" - - - FeynRules interface to FeynArts - - -\"\>"], "Print",
 CellChangeTimes->{3.779711514445889*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->498563988,ExpressionUUID->"01fc50bb-778a-4706-952a-4111b8033fc5"],

Cell[BoxData["\<\"      C. Degrande C. Duhr, 2013\"\>"], "Print",
 CellChangeTimes->{3.7797115144476957`*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->2031239369,ExpressionUUID->"ad3338be-a227-49f1-9e0c-b7217c168bca"],

Cell[BoxData["\<\"      Counterterms: B. Fuks, 2012\"\>"], "Print",
 CellChangeTimes->{3.779711514448678*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->492538424,ExpressionUUID->"34b97f69-9f15-4b94-8981-7c11058f5267"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Creating output directory: \"\>", 
   "\[InvisibleSpace]", "\<\"SM_with_pNG_FA\"\>"}],
  SequenceForm["Creating output directory: ", "SM_with_pNG_FA"],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711514449645*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->1691316630,ExpressionUUID->"ab4d1659-49c3-4919-aa03-009497df27e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating Feynman rules for \"\>", 
   "\[InvisibleSpace]", "\<\"L1\"\>"}],
  SequenceForm["Calculating Feynman rules for ", "L1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711514450613*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->1865048718,ExpressionUUID->"bae952d3-fdee-44a3-a0bd-e861a4563223"],

Cell[BoxData["\<\"Redefining classes in such a way that each particle is in a \
separate FeynArts class.\"\>"], "Print",
 CellChangeTimes->{3.7797115144515553`*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->1202491814,ExpressionUUID->"b7628f5c-3b81-430c-a4c3-b1645ff5c4a8"],

Cell[BoxData["\<\"See NewFeynArtsClasses[] for more information on the new \
classes\"\>"], "Print",
 CellChangeTimes->{3.779711514452546*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->311315981,ExpressionUUID->"8d7cb411-0934-4204-947c-0b6187bdf8d4"],

Cell[BoxData["\<\"Restarting Feynman rule calculation, setting FlavorExpand \
-> True.\"\>"], "Print",
 CellChangeTimes->{3.77971151445352*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->1017528575,ExpressionUUID->"efff8976-0a34-400d-8914-808101b99003"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating Feynman rules for \"\>", 
   "\[InvisibleSpace]", "\<\"L1\"\>"}],
  SequenceForm["Calculating Feynman rules for ", "L1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711514454504*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->1190478964,ExpressionUUID->"fefb74ca-436f-4ad5-b6b2-6ec7a58a1294"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rules calculation for L1.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.779711514543572*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->274808849,ExpressionUUID->"bc21bed8-c870-406a-8c1b-889a8f263136"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.7797115145450087`*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->1622484093,ExpressionUUID->"9e4e95b3-cd0a-4b4f-8b09-2de1cabaf60b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711514546445*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->342801445,ExpressionUUID->"e112e94d-ab2b-410a-aaeb-8435bb12401b"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.7797115215419273`*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->1912744861,ExpressionUUID->"20f33b74-3b76-45b7-9b22-ab258d5f7ad5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "130", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "130", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  130, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 130, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7797115216195374`*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->1820166884,ExpressionUUID->"1db5bd74-b63b-490b-8d0a-f58249491ab0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"103", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[103, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.779711527606604*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->640267873,ExpressionUUID->"c5daecd6-0e66-4e45-afc4-9b29b0d48985"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711529950382*^9},
 CellLabel->"(kernel 4)",
 CellID->2089070041,ExpressionUUID->"25604d61-f23b-4499-8aa2-8eb3b193daa4"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711529976759*^9},
 CellLabel->"(kernel 3)",
 CellID->1790034284,ExpressionUUID->"3a3063f9-93eb-459e-8e81-82d86944ecd3"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.77971153004797*^9},
 CellLabel->"(kernel 2)",
 CellID->1007800365,ExpressionUUID->"45824848-1bee-4cb1-9081-f89eb171e7a3"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.7797115300740423`*^9},
 CellLabel->"(kernel 3)",
 CellID->897210666,ExpressionUUID->"0b00ad92-7d4b-4226-8e1c-ccb66948dc15"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711530145967*^9},
 CellLabel->"(kernel 2)",
 CellID->1936977875,ExpressionUUID->"0e429797-6b66-4075-a8be-663a92a7fa91"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711530173499*^9},
 CellLabel->"(kernel 1)",
 CellID->1082540252,ExpressionUUID->"c7baf0ec-432d-4187-b36e-c94cfe82aeed"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.7797115302380457`*^9},
 CellLabel->"(kernel 2)",
 CellID->772557980,ExpressionUUID->"e6fa4e72-96e8-42bc-a0d2-ba69ba8240f9"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711530265332*^9},
 CellLabel->"(kernel 3)",
 CellID->695840098,ExpressionUUID->"9f9e15ef-fab4-4eed-8a32-23bcba3e531a"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"Simplify\\\", \\\
\"::\\\", \\\"time\\\"}], \\\"MessageName\\\"]\\) will be suppressed during \
this calculation.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711530331744*^9},
 CellLabel->"(kernel 2)",
 CellID->1936069171,ExpressionUUID->"13c44780-ec19-4f80-b191-87c30ad2a8a9"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711530408927*^9},
 CellLabel->"(kernel 1)",
 CellID->842337653,ExpressionUUID->"4cd66d50-03da-43dc-a857-ae380aba98b9"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711530478899*^9},
 CellLabel->"(kernel 4)",
 CellID->956732947,ExpressionUUID->"513bee28-6199-42ed-8d4c-53ffb6a3bfac"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711530509158*^9},
 CellLabel->"(kernel 1)",
 CellID->1600575140,ExpressionUUID->"ab23f203-0427-4f2c-9c1c-10d851bfc7b0"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.7797115305822773`*^9},
 CellLabel->"(kernel 4)",
 CellID->1486215658,ExpressionUUID->"bdffe834-82ff-40d4-9a72-065075f6b2c9"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711530608173*^9},
 CellLabel->"(kernel 3)",
 CellID->1444265749,ExpressionUUID->"731ce4c1-641a-47dd-966c-228ce50aae5e"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711530675561*^9},
 CellLabel->"(kernel 1)",
 CellID->766781402,ExpressionUUID->"ddade674-7ae8-4f49-ae16-f43310a0e556"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711530701985*^9},
 CellLabel->"(kernel 4)",
 CellID->245657767,ExpressionUUID->"b48cc0fd-c1a5-495e-a9f6-e07d9592e847"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711530766633*^9},
 CellLabel->"(kernel 3)",
 CellID->1306520435,ExpressionUUID->"6ff5d2e5-5327-452b-b8e2-aafe4105f35d"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711530792206*^9},
 CellLabel->"(kernel 1)",
 CellID->668660470,ExpressionUUID->"67ed6279-8bc8-4b52-a475-0bd3d4e505b0"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711530860186*^9},
 CellLabel->"(kernel 4)",
 CellID->394594539,ExpressionUUID->"31fbb9eb-4870-4fe3-8510-b8d00a3d6354"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711530885558*^9},
 CellLabel->"(kernel 3)",
 CellID->520915037,ExpressionUUID->"f5705068-9ea0-4b10-911b-97216722c6e5"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711530955534*^9},
 CellLabel->"(kernel 1)",
 CellID->1875681687,ExpressionUUID->"70d73f29-3243-4afb-996a-280167d5d45c"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711530981782*^9},
 CellLabel->"(kernel 4)",
 CellID->1669659096,ExpressionUUID->"3b97f864-f40a-44b0-8b96-3773a93a9ed2"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711531049109*^9},
 CellLabel->"(kernel 2)",
 CellID->791611123,ExpressionUUID->"f8ab4ac2-eb73-473f-aa13-3956a5fe5421"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.7797115310752068`*^9},
 CellLabel->"(kernel 3)",
 CellID->946951096,ExpressionUUID->"6dd5dad4-ff7a-47af-8b85-ddb366c4c411"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711531147237*^9},
 CellLabel->"(kernel 1)",
 CellID->405762555,ExpressionUUID->"37111d7f-6431-44fd-9193-c3364e84adff"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711531176528*^9},
 CellLabel->"(kernel 4)",
 CellID->1390682660,ExpressionUUID->"c7a434ca-1855-4a89-bf37-8ed92edf1e9c"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711531248672*^9},
 CellLabel->"(kernel 3)",
 CellID->2138936319,ExpressionUUID->"3a2012fe-8475-42d8-814f-1c1e899d8e68"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.77971153127322*^9},
 CellLabel->"(kernel 2)",
 CellID->226462653,ExpressionUUID->"6b803092-1818-485a-bb63-0123155c28db"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711531342136*^9},
 CellLabel->"(kernel 1)",
 CellID->816786487,ExpressionUUID->"06340baa-3332-4c92-b5cc-12603f48d2ce"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.77971153141525*^9},
 CellLabel->"(kernel 4)",
 CellID->1015015385,ExpressionUUID->"2b46803f-edad-4499-affb-46d603c1def9"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.7797115314416018`*^9},
 CellLabel->"(kernel 2)",
 CellID->1900967574,ExpressionUUID->"32ba9a35-a41c-4b94-b24a-67d30c5cc05b"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.7797115315093117`*^9},
 CellLabel->"(kernel 3)",
 CellID->1447799799,ExpressionUUID->"b5f6bfed-49a9-4b92-ac51-83f214a3f4e2"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711531538165*^9},
 CellLabel->"(kernel 1)",
 CellID->34017636,ExpressionUUID->"86f6d7cd-e8b0-4fd1-8575-7d362b1bcac2"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.77971153160983*^9},
 CellLabel->"(kernel 3)",
 CellID->503758150,ExpressionUUID->"2bddb63c-01af-40cd-87c6-2b894500052f"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711531636757*^9},
 CellLabel->"(kernel 1)",
 CellID->1282690576,ExpressionUUID->"5fddc6b8-75c8-4e05-b1f2-974fbc0f74d6"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.77971153170422*^9},
 CellLabel->"(kernel 4)",
 CellID->1739662246,ExpressionUUID->"8f51db69-6372-473e-aa79-8afe441991de"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711531731333*^9},
 CellLabel->"(kernel 3)",
 CellID->513514617,ExpressionUUID->"378b24b6-f3f7-4efa-9833-9691163d1bb1"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711531800796*^9},
 CellLabel->"(kernel 2)",
 CellID->2050874273,ExpressionUUID->"5df7d9c8-81c4-4699-8347-4db4f99298e2"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711531827154*^9},
 CellLabel->"(kernel 1)",
 CellID->1931371961,ExpressionUUID->"117a5414-7505-4635-a203-9af42987f00a"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711531893194*^9},
 CellLabel->"(kernel 4)",
 CellID->1353224122,ExpressionUUID->"ee9e35dd-11f3-425c-bd0e-6d004f088747"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711531921596*^9},
 CellLabel->"(kernel 3)",
 CellID->1785996724,ExpressionUUID->"e79c45e2-4454-4ced-af7b-05b544b88aee"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.7797115319923687`*^9},
 CellLabel->"(kernel 2)",
 CellID->1868006149,ExpressionUUID->"f9696b81-3623-4abf-a153-de7736c62487"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.7797115320211163`*^9},
 CellLabel->"(kernel 1)",
 CellID->1515910750,ExpressionUUID->"dc470f3a-0043-4f0c-a47b-0204638681a4"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711532101006*^9},
 CellLabel->"(kernel 4)",
 CellID->165987242,ExpressionUUID->"7c55b6df-e544-45d4-a1e9-96b1064d23b0"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711532126902*^9},
 CellLabel->"(kernel 3)",
 CellID->166318841,ExpressionUUID->"054c2e1c-1a53-4d57-9749-f18ffa8f116b"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.77971153220759*^9},
 CellLabel->"(kernel 2)",
 CellID->1444535940,ExpressionUUID->"dad7f7ff-63e3-43c4-a584-1d2c9691caee"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.7797115322387447`*^9},
 CellLabel->"(kernel 1)",
 CellID->1012914245,ExpressionUUID->"0014cb35-3e91-479a-8803-5728e2af7922"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.7797115323199263`*^9},
 CellLabel->"(kernel 4)",
 CellID->946845946,ExpressionUUID->"ec94006e-fbea-4ddc-a70f-8d5edf814024"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711532356455*^9},
 CellLabel->"(kernel 3)",
 CellID->785990152,ExpressionUUID->"68c3e99a-8114-4e24-96b1-cd86a30463e3"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711532425758*^9},
 CellLabel->"(kernel 2)",
 CellID->964571967,ExpressionUUID->"550fd119-b13e-4e23-8fa8-28c346ca1dcf"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711532454708*^9},
 CellLabel->"(kernel 1)",
 CellID->206998166,ExpressionUUID->"d508e71d-a1ac-4105-b8c7-6a151393dd43"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711532525756*^9},
 CellLabel->"(kernel 4)",
 CellID->94667822,ExpressionUUID->"a1c90384-81b7-4306-9665-2cfdd606e3f4"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711532552483*^9},
 CellLabel->"(kernel 3)",
 CellID->1944185574,ExpressionUUID->"1db7aaac-17cf-482f-a090-80c1e27519b7"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711532618306*^9},
 CellLabel->"(kernel 2)",
 CellID->1963253113,ExpressionUUID->"5f58585e-5bc0-4a8b-99b0-85e4444766b6"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711532644931*^9},
 CellLabel->"(kernel 1)",
 CellID->308834036,ExpressionUUID->"05f33399-8e37-47a2-ad19-7811e7205d44"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711532714982*^9},
 CellLabel->"(kernel 4)",
 CellID->105668253,ExpressionUUID->"08f193dd-4ff0-47fd-900e-33397f36c311"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.7797115327416153`*^9},
 CellLabel->"(kernel 3)",
 CellID->2144835749,ExpressionUUID->"096efd2a-7f7c-4496-b3ad-5ca103171440"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711532809572*^9},
 CellLabel->"(kernel 2)",
 CellID->593934901,ExpressionUUID->"d6b8edc8-5e10-4733-8e92-af88f0d29034"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.7797115328363867`*^9},
 CellLabel->"(kernel 1)",
 CellID->759889851,ExpressionUUID->"141693f9-411c-47fa-adfb-97462094e013"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711532903689*^9},
 CellLabel->"(kernel 4)",
 CellID->383477048,ExpressionUUID->"0780590f-cfe8-4277-bf26-efe3daece1e8"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.7797115329327602`*^9},
 CellLabel->"(kernel 3)",
 CellID->500321089,ExpressionUUID->"d376f839-08c5-447d-b838-1a487f73818f"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711532998267*^9},
 CellLabel->"(kernel 2)",
 CellID->1498064818,ExpressionUUID->"c49e9887-4823-4b2b-b662-077453247b96"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.7797115330243177`*^9},
 CellLabel->"(kernel 1)",
 CellID->877118698,ExpressionUUID->"ee375011-9500-4cfe-a896-92f93851e1cd"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711533102771*^9},
 CellLabel->"(kernel 4)",
 CellID->1406204278,ExpressionUUID->"eadb7579-a243-4083-b227-f22768462150"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711533132649*^9},
 CellLabel->"(kernel 3)",
 CellID->1017765111,ExpressionUUID->"fe3e8728-9356-40c2-aaf1-b9fad010dd59"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711533201509*^9},
 CellLabel->"(kernel 2)",
 CellID->870972222,ExpressionUUID->"d489138d-4bbc-4987-819d-c73069246d49"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711533227977*^9},
 CellLabel->"(kernel 1)",
 CellID->1181597202,ExpressionUUID->"88a05bdf-bacc-4197-906f-4ba0ae94f81d"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.7797115332997627`*^9},
 CellLabel->"(kernel 4)",
 CellID->1322890205,ExpressionUUID->"b72bfdd5-cde3-4b93-9370-0f6ffe041a4b"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711533326124*^9},
 CellLabel->"(kernel 3)",
 CellID->917478044,ExpressionUUID->"5ec2ab99-64f6-4c87-8cfb-a14bfad2a302"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711533394557*^9},
 CellLabel->"(kernel 2)",
 CellID->1120900048,ExpressionUUID->"1441ae64-9a12-4838-bef3-3bde90a2d42a"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711533419135*^9},
 CellLabel->"(kernel 1)",
 CellID->1240555252,ExpressionUUID->"0b104cc9-9f68-4b2d-9be2-baf9a377b30e"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711533485526*^9},
 CellLabel->"(kernel 4)",
 CellID->93391641,ExpressionUUID->"097eaa58-fff1-4607-81e6-07c79046303d"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711533513095*^9},
 CellLabel->"(kernel 1)",
 CellID->1970247977,ExpressionUUID->"87f6a680-3ef0-43ff-9858-a1bb452c6a24"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.7797115335772133`*^9},
 CellLabel->"(kernel 4)",
 CellID->1907396346,ExpressionUUID->"fdef274d-527f-4660-9ac9-852f5f3d8cda"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711533603867*^9},
 CellLabel->"(kernel 3)",
 CellID->2121988453,ExpressionUUID->"7952c282-e4b9-47f9-a0e4-6a976357c851"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711533669902*^9},
 CellLabel->"(kernel 2)",
 CellID->999003842,ExpressionUUID->"4b2aff15-a711-4037-bb3f-0338b7f47d07"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.77971153369595*^9},
 CellLabel->"(kernel 1)",
 CellID->1230420248,ExpressionUUID->"bacf17ee-4b90-4278-8dd6-b46936d01f04"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711533768794*^9},
 CellLabel->"(kernel 4)",
 CellID->1553071173,ExpressionUUID->"e97567b9-88a2-4590-8825-079c70675dc2"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.7797115338059464`*^9},
 CellLabel->"(kernel 3)",
 CellID->1950958973,ExpressionUUID->"a5d438be-a5bb-4b6c-8062-aebe91a90d16"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.7797115338775454`*^9},
 CellLabel->"(kernel 2)",
 CellID->1987136815,ExpressionUUID->"2e4b0ebf-3cb7-4c1c-a938-c755dd3ebb0c"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711533903968*^9},
 CellLabel->"(kernel 1)",
 CellID->142771561,ExpressionUUID->"b64d4bea-a368-4d19-8b48-90855f094223"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711533973319*^9},
 CellLabel->"(kernel 4)",
 CellID->822392028,ExpressionUUID->"6c5fb897-a864-4d71-b131-487de6d99037"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711534004652*^9},
 CellLabel->"(kernel 3)",
 CellID->738062504,ExpressionUUID->"92181cf7-717c-4dda-93db-eb8bcc38ebbc"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.779711534076654*^9},
 CellLabel->"(kernel 4)",
 CellID->750959656,ExpressionUUID->"6d726126-87c5-4afe-87a2-351aaa5ca1ad"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Simplify", "::", "time"}], "MessageName"], " ", ":", 
  "  ", "\<\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"\>"}]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.77971153410773*^9},
 CellLabel->"(kernel 3)",
 CellID->617544973,ExpressionUUID->"97f3a1bc-9f7b-4c3f-9c3c-632db37e2087"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Writing FeynArts model file into directory \"\>", 
   "\[InvisibleSpace]", "\<\"SM_with_pNG_FA\"\>"}],
  SequenceForm[
  "Writing FeynArts model file into directory ", "SM_with_pNG_FA"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7797115344300613`*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->289895260,ExpressionUUID->"e01a19ac-8a89-438d-a534-ad099c733623"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Writing FeynArts generic file on \"\>", 
   "\[InvisibleSpace]", "\<\"SM_with_pNG_FA.gen\"\>", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["Writing FeynArts generic file on ", "SM_with_pNG_FA.gen", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7797115344634037`*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->1776723424,ExpressionUUID->"11caf163-1156-4fd2-9fd9-acf76b5eff4e"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1082, 953},
WindowMargins->{{Automatic, 263}, {7, Automatic}},
WindowTitle->"SM_with_pNG.nb",
DockedCells->Cell[
  BoxData[
   PanelBox[
    PaneBox[
     TagBox[
      GridBox[{{
         StyleBox[
          DynamicBox[
           FEPrivate`FrontEndResource[
           "MUnitStrings", "TestingNotebook-Title"], 
           ImageSizeCache -> {100., {3., 9.}}], StripOnInput -> False, 
          FontSize -> 12, FontColor -> GrayLevel[0.4]], "\[SpanFromLeft]", 
         "\[SpanFromLeft]", "\[SpanFromLeft]", "\[SpanFromLeft]", 
         "\[SpanFromLeft]"}, {
         ButtonBox[
          TagBox[
           TooltipBox[
            PaneSelectorBox[{False -> PaneBox[
                TagBox[
                 GridBox[{{
                    DynamicBox[
                    FEPrivate`FrontEndResource["MUnitExpressions", "New"], 
                    ImageSizeCache -> {11., {4., 8.}}], 
                    StyleBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource["MUnitStrings", "New-Label"], 
                    ImageSizeCache -> {26., {0., 9.}}], "ButtonText", 
                    StripOnInput -> False]}}, AutoDelete -> False, 
                  GridBoxAlignment -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Center}}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{0.4}}, "Rows" -> {{Automatic}}}], "Grid"], 
                ImageMargins -> {{Automatic, Automatic}, {4, Automatic}}], 
              True -> PaneBox[
                TagBox[
                 GridBox[{{
                    DynamicBox[
                    FEPrivate`FrontEndResource["MUnitExpressions", "New"]], 
                    StyleBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource["MUnitStrings", "New-Label"]], 
                    "ButtonText", StripOnInput -> False, LineColor -> 
                    RGBColor[0.9059, 0.3451, 0.102], FrontFaceColor -> 
                    RGBColor[
                    0.9059, 0.3451, 0.102], $CellContext`BackFaceColor -> 
                    RGBColor[0.9059, 0.3451, 0.102], GraphicsColor -> 
                    RGBColor[0.9059, 0.3451, 0.102], FontColor -> 
                    RGBColor[0.9059, 0.3451, 0.102]]}}, AutoDelete -> False, 
                  GridBoxAlignment -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Center}}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{0.4}}, "Rows" -> {{Automatic}}}], "Grid"], 
                ImageMargins -> {{Automatic, Automatic}, {4, Automatic}}]}, 
             Dynamic[
              CurrentValue["MouseOver"]], FrameMargins -> 0, ImageSize -> 
             Automatic], 
            DynamicBox[
             FEPrivate`FrontEndResource["MUnitStrings", "New-Tooltip"]], 
            TooltipDelay -> 0.5], Annotation[#, 
            Dynamic[
             RawBoxes[
              FEPrivate`FrontEndResource["MUnitStrings", "New-Tooltip"]]], 
            "Tooltip"]& ], Appearance -> 
          FEPrivate`FrontEndResource["MUnitExpressions", "ButtonAppearances"],
           ButtonFunction :> 
          Block[{$ContextPath}, Needs["MUnit`"]; MUnit`PaletteInsertTest[
              InputNotebook[]]], Evaluator -> Automatic, 
          FrameMargins -> {{10, 10}, {0, 0}}, ImageSize -> {Automatic, 28}, 
          Method -> "Queued"], 
         ButtonBox[
          TagBox[
           TooltipBox[
            PaneSelectorBox[{False -> PaneBox[
                TagBox[
                 GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "MUnitExpressions", "ConvertSelection"], 
                    ImageSizeCache -> {14., {4., 8.}}], 
                    ImageMargins -> {{
                    Automatic, Automatic}, {-1, Automatic}}], 
                    PaneBox[
                    StyleBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "MUnitStrings", "ConvertSelectiontoTest-Label"], 
                    ImageSizeCache -> {99., {1., 9.}}], "ButtonText", 
                    StripOnInput -> False], 
                    ImageMargins -> {{
                    Automatic, Automatic}, {-1, Automatic}}]}}, AutoDelete -> 
                  False, GridBoxAlignment -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Center}}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{0.4}}, "Rows" -> {{Automatic}}}], "Grid"], 
                ImageMargins -> {{Automatic, Automatic}, {4, Automatic}}], 
              True -> PaneBox[
                TagBox[
                 GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "MUnitExpressions", "ConvertSelection"]], 
                    ImageMargins -> {{
                    Automatic, Automatic}, {-1, Automatic}}], 
                    PaneBox[
                    StyleBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "MUnitStrings", "ConvertSelectiontoTest-Label"]], 
                    "ButtonText", StripOnInput -> False, LineColor -> 
                    RGBColor[0.9059, 0.3451, 0.102], FrontFaceColor -> 
                    RGBColor[
                    0.9059, 0.3451, 0.102], $CellContext`BackFaceColor -> 
                    RGBColor[0.9059, 0.3451, 0.102], GraphicsColor -> 
                    RGBColor[0.9059, 0.3451, 0.102], FontColor -> 
                    RGBColor[0.9059, 0.3451, 0.102]], 
                    ImageMargins -> {{
                    Automatic, Automatic}, {-1, Automatic}}]}}, AutoDelete -> 
                  False, GridBoxAlignment -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Center}}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{0.4}}, "Rows" -> {{Automatic}}}], "Grid"], 
                ImageMargins -> {{Automatic, Automatic}, {4, Automatic}}]}, 
             Dynamic[
              CurrentValue["MouseOver"]], FrameMargins -> 0, ImageSize -> 
             Automatic], 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "MUnitStrings", "ConvertSelectiontoTest-Tooltip"]], TooltipDelay -> 
            0.5], Annotation[#, 
            Dynamic[
             RawBoxes[
              FEPrivate`FrontEndResource[
              "MUnitStrings", "ConvertSelectiontoTest-Tooltip"]]], 
            "Tooltip"]& ], Appearance -> 
          FEPrivate`FrontEndResource["MUnitExpressions", "ButtonAppearances"],
           ButtonFunction :> 
          Block[{$ContextPath}, Needs["MUnit`"]; 
            MUnit`buttonConvertCellGroup[
              InputNotebook[]]], Evaluator -> Automatic, 
          FrameMargins -> {{10, 10}, {0, 0}}, ImageSize -> {Automatic, 28}, 
          Method -> "Queued"], 
         ButtonBox[
          TagBox[
           TooltipBox[
            PaneSelectorBox[{False -> PaneBox[
                TagBox[
                 GridBox[{{
                    DynamicBox[
                    FEPrivate`FrontEndResource["MUnitExpressions", "Run"], 
                    ImageSizeCache -> {9., {4., 8.}}], 
                    StyleBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource["MUnitStrings", "Run-Label"], 
                    ImageSizeCache -> {22., {0., 9.}}], "ButtonText", 
                    StripOnInput -> False]}}, AutoDelete -> False, 
                  GridBoxAlignment -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Center}}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{0.3}}, "Rows" -> {{Automatic}}}], "Grid"], 
                ImageMargins -> {{Automatic, Automatic}, {4, Automatic}}], 
              True -> PaneBox[
                TagBox[
                 GridBox[{{
                    DynamicBox[
                    FEPrivate`FrontEndResource["MUnitExpressions", "Run"]], 
                    StyleBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource["MUnitStrings", "Run-Label"]], 
                    "ButtonText", StripOnInput -> False, LineColor -> 
                    RGBColor[0.9059, 0.3451, 0.102], FrontFaceColor -> 
                    RGBColor[
                    0.9059, 0.3451, 0.102], $CellContext`BackFaceColor -> 
                    RGBColor[0.9059, 0.3451, 0.102], GraphicsColor -> 
                    RGBColor[0.9059, 0.3451, 0.102], FontColor -> 
                    RGBColor[0.9059, 0.3451, 0.102]]}}, AutoDelete -> False, 
                  GridBoxAlignment -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Center}}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{0.3}}, "Rows" -> {{Automatic}}}], "Grid"], 
                ImageMargins -> {{Automatic, Automatic}, {4, Automatic}}]}, 
             Dynamic[
              CurrentValue["MouseOver"]], FrameMargins -> 0, ImageSize -> 
             Automatic], 
            DynamicBox[
             FEPrivate`FrontEndResource["MUnitStrings", "Run-Tooltip"]], 
            TooltipDelay -> 0.5], Annotation[#, 
            Dynamic[
             RawBoxes[
              FEPrivate`FrontEndResource["MUnitStrings", "Run-Tooltip"]]], 
            "Tooltip"]& ], Appearance -> 
          FEPrivate`FrontEndResource["MUnitExpressions", "ButtonAppearances"],
           ButtonFunction :> 
          Block[{$ContextPath}, Needs["MUnit`"]; MUnit`PaletteRun[
              InputNotebook[]]], Evaluator -> Automatic, 
          FrameMargins -> {{10, 10}, {0, 0}}, ImageSize -> {Automatic, 28}, 
          Method -> "Queued"], 
         ActionMenuBox[
          ButtonBox[
           PaneSelectorBox[{False -> StyleBox[
               TagBox[
                GridBox[{{
                   DynamicBox[
                    FEPrivate`FrontEndResource["MUnitStrings", "More-Label"], 
                    ImageSizeCache -> {30., {0., 9.}}], 
                   "\"\[FilledDownTriangle]\""}}, AutoDelete -> False, 
                 GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{Automatic}}}], "Grid"], 
               "ButtonText", StripOnInput -> False], True -> StyleBox[
               TagBox[
                GridBox[{{
                   DynamicBox[
                    FEPrivate`FrontEndResource["MUnitStrings", "More-Label"]],
                    "\"\[FilledDownTriangle]\""}}, AutoDelete -> False, 
                 GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{Automatic}}}], "Grid"], 
               "ButtonText", StripOnInput -> False, LineColor -> 
               RGBColor[0.9059, 0.3451, 0.102], FrontFaceColor -> 
               RGBColor[0.9059, 0.3451, 0.102], $CellContext`BackFaceColor -> 
               RGBColor[0.9059, 0.3451, 0.102], GraphicsColor -> 
               RGBColor[0.9059, 0.3451, 0.102], FontColor -> 
               RGBColor[0.9059, 0.3451, 0.102]]}, 
            Dynamic[
             CurrentValue["MouseOver"]], FrameMargins -> 0, ImageSize -> 
            Automatic], Appearance -> 
           FEPrivate`FrontEndResource[
            "MUnitExpressions", "ButtonAppearances"], ButtonFunction :> {}, 
           ContentPadding -> False, Evaluator -> None, 
           FrameMargins -> {{10, 10}, {0, 0}}, ImageSize -> {Automatic, 28}, 
           Method -> "Preemptive"], {TagBox[
             GridBox[{{
                PaneBox[
                 DynamicBox[
                  FEPrivate`FrontEndResource[
                  "MUnitExpressions", "AssignTestIDs"]], 
                 ImageMargins -> {{Automatic, Automatic}, {2, Automatic}}], 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "MUnitStrings", "AssignTestIDs-Label"]]}}, AutoDelete -> 
              False, GridBoxAlignment -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Center}}}, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"] :> 
           Block[{$ContextPath}, Needs["MUnit`"]; MUnit`PaletteAddTestIDs[
               InputNotebook[]]], TagBox[
             GridBox[{{
                PaneBox[
                 DynamicBox[
                  FEPrivate`FrontEndResource[
                  "MUnitExpressions", "SaveAsDotwlt"]], 
                 ImageMargins -> {{Automatic, Automatic}, {2, Automatic}}], 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "MUnitStrings", "SaveAsDotwlt-Label"]]}}, AutoDelete -> 
              False, GridBoxAlignment -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Center}}}, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"] :> 
           Block[{$ContextPath}, Needs["MUnit`"]; MUnit`PaletteSaveAs[
               InputNotebook[]]], TagBox[
             GridBox[{{
                PaneBox[
                 DynamicBox[
                  FEPrivate`FrontEndResource["MUnitExpressions", "Help"]], 
                 ImageMargins -> {{Automatic, Automatic}, {3, Automatic}}], 
                DynamicBox[
                 FEPrivate`FrontEndResource["MUnitStrings", "Help-Label"]]}}, 
              AutoDelete -> False, 
              GridBoxAlignment -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Center}}}, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"] :> 
           SystemOpen["paclet:tutorial/UsingTheTestingFramework"]}, 
          Appearance -> None, Method -> "Queued"], 
         ItemBox["\"\"", ItemSize -> Fit, StripOnInput -> False], 
         PaneSelectorBox[{True -> ButtonBox[
             TagBox[
              TooltipBox[
               PaneSelectorBox[{False -> TagBox[
                   GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "MUnitExpressions", "ClearTestResults-on"], 
                    ImageSizeCache -> {9., {4., 8.}}], 
                    ImageMargins -> {{Automatic, Automatic}, {2, Automatic}}], 
                    StyleBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "MUnitStrings", "ClearTestResults-Label"], 
                    ImageSizeCache -> {96., {1., 9.}}], "ButtonText", 
                    StripOnInput -> False]}}, AutoDelete -> False, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Center}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.4}}, "Rows" -> {{Automatic}}}], "Grid"], 
                 True -> TagBox[
                   GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "MUnitExpressions", "ClearTestResults-on"]], 
                    ImageMargins -> {{Automatic, Automatic}, {2, Automatic}}], 
                    StyleBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "MUnitStrings", "ClearTestResults-Label"]], "ButtonText", 
                    StripOnInput -> False, LineColor -> 
                    RGBColor[0.9059, 0.3451, 0.102], FrontFaceColor -> 
                    RGBColor[
                    0.9059, 0.3451, 0.102], $CellContext`BackFaceColor -> 
                    RGBColor[0.9059, 0.3451, 0.102], GraphicsColor -> 
                    RGBColor[0.9059, 0.3451, 0.102], FontColor -> 
                    RGBColor[0.9059, 0.3451, 0.102]]}}, AutoDelete -> False, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Center}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.4}}, "Rows" -> {{Automatic}}}], "Grid"]}, 
                Dynamic[
                 CurrentValue["MouseOver"]], FrameMargins -> 0, ImageSize -> 
                Automatic], 
               DynamicBox[
                FEPrivate`FrontEndResource[
                "MUnitStrings", "ClearTestResults-Tooltip"]], TooltipDelay -> 
               0.5], Annotation[#, 
               Dynamic[
                RawBoxes[
                 FEPrivate`FrontEndResource[
                 "MUnitStrings", "ClearTestResults-Tooltip"]]], "Tooltip"]& ],
              Appearance -> 
             FEPrivate`FrontEndResource[
              "MUnitExpressions", "ButtonAppearances"], ButtonFunction :> 
             Block[{$ContextPath}, Needs["MUnit`"]; MUnit`clearTestResults[]],
              Enabled -> FEPrivate`SameQ[
               FrontEnd`CurrentValue[
                FrontEnd`ButtonNotebook[], {TaggingRules, "$testsRun"}, 
                False], True], Evaluator -> Automatic, 
             FrameMargins -> {{10, 10}, {0, 0}}, ImageSize -> {Automatic, 28},
              Method -> "Queued"], False -> ButtonBox[
             TagBox[
              GridBox[{{
                 PaneBox[
                  DynamicBox[
                   FEPrivate`FrontEndResource[
                   "MUnitExpressions", "ClearTestResults-off"], 
                   ImageSizeCache -> {9., {4., 8.}}], 
                  ImageMargins -> {{Automatic, Automatic}, {2, Automatic}}], 
                 StyleBox[
                  DynamicBox[
                   FEPrivate`FrontEndResource[
                   "MUnitStrings", "ClearTestResults-Label"], 
                   ImageSizeCache -> {96., {1., 9.}}], "ButtonText", 
                  StripOnInput -> False, LineColor -> GrayLevel[0.7], 
                  FrontFaceColor -> 
                  GrayLevel[0.7], $CellContext`BackFaceColor -> 
                  GrayLevel[0.7], GraphicsColor -> GrayLevel[0.7], FontColor -> 
                  GrayLevel[0.7]]}}, AutoDelete -> False, 
               GridBoxAlignment -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Center}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{0.4}}, "Rows" -> {{Automatic}}}], "Grid"], 
             Appearance -> 
             FEPrivate`FrontEndResource[
              "MUnitExpressions", "ButtonAppearances"], ButtonFunction :> {}, 
             Enabled -> FEPrivate`SameQ[
               FrontEnd`CurrentValue[
                FrontEnd`ButtonNotebook[], {TaggingRules, "$testsRun"}, 
                False], True], Evaluator -> None, 
             FrameMargins -> {{10, 10}, {0, 0}}, ImageSize -> {Automatic, 28},
              Method -> "Preemptive"]}, 
          FrontEnd`CurrentValue[
           FrontEnd`ButtonNotebook[], {TaggingRules, "$testsRun"}, False], 
          ImageSize -> All]}}, AutoDelete -> False, 
       BaseStyle -> {
        "DialogStyle", Bold, FontColor -> 
         RGBColor[
          0.33333333333333337`, 0.33333333333333337`, 0.33333333333333337`]}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, 
       GridBoxDividers -> {"Columns" -> {{False}}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
       GridBoxSpacings -> {"Columns" -> {{Automatic}}, "Rows" -> {{1}}}], 
      "Grid"], ImageMargins -> {{5, 5}, {Automatic, Automatic}}], Appearance -> 
    FEPrivate`FrontEndResource["MUnitExpressions", "StaticToolbarNinePatch"], 
    FrameMargins -> {{26, 12}, {8, 12}}, ImageMargins -> -1]], "DockedCell", 
  CellFrameMargins -> 0, ShowCellTags -> False, CellTags -> 
  "MUnitStaticToolbar"],
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
TaggingRules->{"$testsRun" -> False},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->FrontEnd`FileName[{"MUnit"}, "TestResults.nb", 
  CharacterEncoding -> "UTF-8"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[608, 23, 1197, 19, 223, "Title",ExpressionUUID->"d539e99e-3778-4dc6-8232-a8ff8dd31e65",
 CellID->281390532],
Cell[CellGroupData[{
Cell[1830, 46, 289, 4, 67, "Section",ExpressionUUID->"c72f400a-8139-41f9-9fbe-bd420ab97f1d",
 CellID->1358143829],
Cell[2122, 52, 379, 7, 30, "Input",ExpressionUUID->"bfff4caa-bcf4-4d8d-b1f4-b00710edd0f8",
 CellID->2670957],
Cell[CellGroupData[{
Cell[2526, 63, 671, 13, 30, "Input",ExpressionUUID->"da00745e-07d3-4b8e-bb09-6d421dbad650",
 CellID->768162998],
Cell[3200, 78, 2893, 41, 34, "Output",ExpressionUUID->"6eb03549-73aa-446a-96c8-71e4ae4f2498",
 CellID->1354565812]
}, Open  ]],
Cell[CellGroupData[{
Cell[6130, 124, 218, 4, 30, "Input",ExpressionUUID->"5d4499a5-7221-4e96-9335-99754b4e3e91",
 CellID->1177512340],
Cell[6351, 130, 277, 4, 24, "Print",ExpressionUUID->"ac8683eb-cb36-4878-8540-93d0c65bcbe2",
 CellID->713460437],
Cell[6631, 136, 553, 11, 24, "Print",ExpressionUUID->"466019d9-1b61-4b57-99cb-b08600d9b7f1",
 CellID->1728363458],
Cell[7187, 149, 331, 5, 24, "Print",ExpressionUUID->"fd1f80ad-47f6-4bc9-ab78-6e50edd81427",
 CellID->1740829284],
Cell[7521, 156, 264, 4, 24, "Print",ExpressionUUID->"88ab585f-7dec-4ba9-b3a7-08011a9bcbb0",
 CellID->800569460],
Cell[7788, 162, 276, 4, 24, "Print",ExpressionUUID->"daf69402-aacb-4b51-b607-dcca52b2aa7c",
 CellID->1185865765],
Cell[8067, 168, 328, 5, 24, "Print",ExpressionUUID->"36f0c617-fef4-47a7-9cc4-b3a840e8cdb1",
 CellID->50184548],
Cell[8398, 175, 328, 5, 24, "Print",ExpressionUUID->"45cd1cd5-1f56-4dfe-98a8-a57afaffaa1d",
 CellID->1638108612],
Cell[8729, 182, 262, 4, 24, "Print",ExpressionUUID->"9790132a-01a6-4a22-ba9f-f1b4c6b694e5",
 CellID->951087344],
Cell[8994, 188, 295, 4, 24, "Print",ExpressionUUID->"a77a1444-4764-4067-a487-42c2842535d2",
 CellID->1204205987],
Cell[9292, 194, 267, 4, 24, "Print",ExpressionUUID->"511e0fe8-1995-4e78-a2f5-d2f4d39d534e",
 CellID->1204134181],
Cell[9562, 200, 332, 5, 24, "Print",ExpressionUUID->"92de052a-484c-4535-b153-1485a803f0dc",
 CellID->2144774386]
}, Open  ]],
Cell[CellGroupData[{
Cell[9931, 210, 461, 8, 30, "Input",ExpressionUUID->"349109c7-483d-4f62-a3a6-d148884dad8c",
 CellID->1032924823],
Cell[10395, 220, 3215, 46, 34, "Output",ExpressionUUID->"0371be9b-3c7a-4ea1-bd23-ef1b867748e6",
 CellID->1551130900]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13671, 273, 315, 4, 67, "Section",ExpressionUUID->"9f036dbd-41e3-4e2d-a48e-f00ab04e5051",
 CellID->119441446],
Cell[CellGroupData[{
Cell[14011, 281, 347, 6, 30, "Input",ExpressionUUID->"9d30463c-132a-4f84-9ddd-39e744da891c",
 CellID->1596089084],
Cell[14361, 289, 708, 10, 24, "Print",ExpressionUUID->"305c8984-7d36-401a-a499-5bf4c8353a49",
 CellID->990359039],
Cell[15072, 301, 677, 10, 24, "Print",ExpressionUUID->"0ae114b8-c23b-4c4c-9d62-d9605a18296b",
 CellID->1966104223],
Cell[15752, 313, 816, 14, 24, "Print",ExpressionUUID->"cd04f4fe-ec35-4cad-ab5b-b8db162da841",
 CellID->982799572],
Cell[16571, 329, 715, 11, 24, "Print",ExpressionUUID->"0b8d91fe-d33b-4458-b444-f6c0c06fb258",
 CellID->1615677527],
Cell[17289, 342, 666, 10, 24, "Print",ExpressionUUID->"ab1e3af0-1951-4a6e-a27a-e18df501cd08",
 CellID->1908963621],
Cell[17958, 354, 698, 10, 24, "Print",ExpressionUUID->"72b1a76e-e784-468a-8aed-fe5d87221b1e",
 CellID->545891967],
Cell[18659, 366, 698, 10, 24, "Print",ExpressionUUID->"22937c3b-a517-44aa-9e73-f37a8b3b7274",
 CellID->756149385],
Cell[19360, 378, 700, 10, 24, "Print",ExpressionUUID->"d1eea055-9e8f-419e-882f-27371711f5b5",
 CellID->1941974396],
Cell[20063, 390, 875, 15, 44, "Print",ExpressionUUID->"0ebb2b93-7513-44e5-9707-28b4ccbc9a8e",
 CellID->1307206466]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20987, 411, 301, 4, 51, "Chapter",ExpressionUUID->"88d87069-0380-4eb3-bf67-4bbdef48ef32",
 CellID->1487958666],
Cell[CellGroupData[{
Cell[21313, 419, 790, 15, 52, "Input",ExpressionUUID->"3bf8b9dd-f4e6-4e28-8586-2a0c2054b2c3",
 CellID->474117842],
Cell[22106, 436, 350, 8, 34, "Output",ExpressionUUID->"f5fe2ed8-ae85-45c5-8347-c4e3bb5c61e0",
 CellID->1970017204]
}, Open  ]],
Cell[CellGroupData[{
Cell[22493, 449, 885, 16, 52, "Input",ExpressionUUID->"c0f4564d-1f61-4eb9-8fe5-da3865586f21",
 CellID->911236787],
Cell[23381, 467, 1423, 24, 34, "Output",ExpressionUUID->"0025e6db-b654-4913-8ce5-86184f4049e6",
 CellID->339685744]
}, Open  ]],
Cell[CellGroupData[{
Cell[24841, 496, 228, 4, 30, "Input",ExpressionUUID->"233b311f-17a8-417f-8877-4464741d6138",
 CellID->1194927059],
Cell[25072, 502, 302, 4, 24, "Print",ExpressionUUID->"be802a5d-7fcd-40b4-898c-8cbb7178d242",
 CellID->1111727724]
}, Open  ]],
Cell[CellGroupData[{
Cell[25411, 511, 254, 3, 67, "Section",ExpressionUUID->"d0229eed-93b9-4734-8f6c-9e96cd9a6740",
 CellID->674230147],
Cell[CellGroupData[{
Cell[25690, 518, 601, 9, 30, "Input",ExpressionUUID->"b7baa43e-73db-4089-a8e2-acfefb565e30",
 CellID->1258740756],
Cell[26294, 529, 1578, 23, 34, "Output",ExpressionUUID->"0e7e9d3b-690a-4ea0-bb49-97673c4aa719",
 CellID->185050757]
}, Open  ]],
Cell[CellGroupData[{
Cell[27909, 557, 635, 10, 30, "Input",ExpressionUUID->"c91020cd-7d22-4229-8bbb-16026d677d74",
 CellID->1662359057],
Cell[28547, 569, 1897, 27, 24, "Print",ExpressionUUID->"cb93f3c2-7957-457a-8662-d12686cc1691",
 CellID->1858474869],
Cell[30447, 598, 1894, 27, 24, "Print",ExpressionUUID->"47181730-fe17-4d4f-bca5-bd2253a12abe",
 CellID->237477668],
Cell[32344, 627, 2088, 34, 24, "Print",ExpressionUUID->"85d27ccf-9778-4b15-b2ea-5596171fc1ed",
 CellID->1153855207],
Cell[34435, 663, 1845, 26, 24, "Print",ExpressionUUID->"f0a23bf3-2464-4fab-95d2-129b8215961b",
 CellID->1067131639],
Cell[36283, 691, 2025, 31, 24, "Print",ExpressionUUID->"c6da117a-c763-40a0-89a1-be63146d2eda",
 CellID->1645520576],
Cell[38311, 724, 1876, 27, 24, "Print",ExpressionUUID->"48916f3e-e784-456f-9a0d-48b6b882411f",
 CellID->1956591432],
Cell[40190, 753, 1832, 26, 24, "Print",ExpressionUUID->"13f2d430-3a81-4607-a3bf-1c75e9a9c834",
 CellID->15111113],
Cell[42025, 781, 1955, 30, 24, "Print",ExpressionUUID->"d66efcea-2c80-48ce-88e6-fba0b6e339a7",
 CellID->569405845],
Cell[43983, 813, 1843, 26, 24, "Print",ExpressionUUID->"4cd4838c-730c-4b9a-a932-7c3d7d1f8f21",
 CellID->816905883],
Cell[45829, 841, 979, 16, 34, "Output",ExpressionUUID->"ed206374-7ced-44c3-98a8-be605d300a2f",
 CellID->874220310]
}, Open  ]],
Cell[CellGroupData[{
Cell[46845, 862, 393, 7, 30, "Input",ExpressionUUID->"1ba0235f-d1b3-4430-8d3e-328bbb221e7f",
 CellID->506423529],
Cell[47241, 871, 1908, 30, 24, "Print",ExpressionUUID->"cb6e7659-1f82-471b-9dcd-9b6e769c706a",
 CellID->2085121043],
Cell[49152, 903, 1689, 24, 24, "Print",ExpressionUUID->"4a16809f-97e9-4e2c-88e1-f1d9fdd40f3b",
 CellID->1991217955],
Cell[50844, 929, 1620, 24, 34, "Output",ExpressionUUID->"eb84ff75-26d7-48b1-a05a-d0464916d688",
 CellID->15014837]
}, Open  ]],
Cell[CellGroupData[{
Cell[52501, 958, 364, 7, 30, "Input",ExpressionUUID->"baa3118f-e43c-48c8-9aa1-cf3ec00bc473",
 CellID->1711954106],
Cell[52868, 967, 1551, 22, 24, "Print",ExpressionUUID->"386618f2-d017-4c50-85ec-2505d1d09aef",
 CellID->1098778760],
Cell[54422, 991, 1619, 24, 34, "Output",ExpressionUUID->"b402f6f0-06e4-4c7a-91e7-90947ffa88fe",
 CellID->962738767]
}, Open  ]],
Cell[CellGroupData[{
Cell[56078, 1020, 374, 7, 30, "Input",ExpressionUUID->"45887bc9-2cd1-4092-a195-491e49cff7ee",
 CellID->1819434187],
Cell[56455, 1029, 1904, 30, 24, "Print",ExpressionUUID->"5b52cf2e-9c0d-4f2e-b6c8-8b35cb65022d",
 CellID->1728079815],
Cell[58362, 1061, 1683, 24, 24, "Print",ExpressionUUID->"fdff66a5-00a3-4319-8607-5d370d094daf",
 CellID->434644030],
Cell[60048, 1087, 1606, 24, 34, "Output",ExpressionUUID->"fce2c44c-6f0e-45b6-96ec-2a2c18d0a96d",
 CellID->1470328763]
}, Open  ]],
Cell[CellGroupData[{
Cell[61691, 1116, 395, 7, 30, "Input",ExpressionUUID->"d5e8837f-fd26-42a9-b425-92a2e72bfccc",
 CellID->350105501],
Cell[62089, 1125, 1010, 20, 24, "Print",ExpressionUUID->"f5c31b75-cab4-4716-8bfa-45f99d07ed61",
 CellID->223535781],
Cell[63102, 1147, 791, 14, 24, "Print",ExpressionUUID->"a5704921-29ac-4898-95cf-9761e0acada6",
 CellID->1308204219],
Cell[63896, 1163, 1076, 22, 24, "Print",ExpressionUUID->"94123e3b-df91-443d-8a16-7d8928d74f65",
 CellID->1346454711],
Cell[64975, 1187, 1072, 22, 24, "Print",ExpressionUUID->"9ffe1bf8-5ae9-4997-b379-26851992f3ec",
 CellID->1829139338],
Cell[66050, 1211, 1076, 22, 24, "Print",ExpressionUUID->"bae25491-cb14-43b4-afa6-e7fc206a79ed",
 CellID->1116446961]
}, Open  ]],
Cell[CellGroupData[{
Cell[67163, 1238, 618, 12, 30, "Input",ExpressionUUID->"470158b6-90b9-48e0-ba50-3511a9c89d40",
 CellID->1348508967],
Cell[67784, 1252, 2035, 32, 24, "Print",ExpressionUUID->"c704b565-5808-4c22-888e-9f72f48fd6f8",
 CellID->190939555],
Cell[69822, 1286, 1812, 26, 24, "Print",ExpressionUUID->"95cce1c5-a8cf-4430-bd85-03ec5b0cf3ec",
 CellID->780532267],
Cell[71637, 1314, 1806, 26, 24, "Print",ExpressionUUID->"9463549f-0f3a-404d-8467-e90966778f2a",
 CellID->1575695593],
Cell[73446, 1342, 1848, 27, 24, "Print",ExpressionUUID->"34b325e1-b88b-4891-bd2a-526cecac9157",
 CellID->2094980394],
Cell[75297, 1371, 10304, 308, 658, "Output",ExpressionUUID->"f5cb9743-69d7-45e0-b8ae-38f65b50fc2d",
 CellID->193605746]
}, Open  ]]
}, Open  ]],
Cell[85628, 1683, 143, 2, 30, "Input",ExpressionUUID->"74787f9b-d216-4ecb-849a-35eb875d3b61",
 CellID->967486392],
Cell[CellGroupData[{
Cell[85796, 1689, 183, 2, 67, "Section",ExpressionUUID->"9b721fac-1f43-4090-bea5-e7e7ac0bc819",
 CellID->366046402],
Cell[CellGroupData[{
Cell[86004, 1695, 436, 10, 30, "Input",ExpressionUUID->"c0f5fa87-55fd-4dda-894f-439732244ef1",
 CellID->1748713406],
Cell[86443, 1707, 906, 20, 24, "Print",ExpressionUUID->"2bac2e3c-7c3d-45fc-bf22-d92cabbbdaed",
 CellID->1526377920],
Cell[87352, 1729, 661, 12, 24, "Print",ExpressionUUID->"28f08a91-1d48-45c0-8408-6649f9ca8e47",
 CellID->2141538025],
Cell[88016, 1743, 843, 17, 24, "Print",ExpressionUUID->"740e8171-eca2-4697-80b2-deaa9657c46b",
 CellID->1003662455],
Cell[88862, 1762, 693, 13, 24, "Print",ExpressionUUID->"e3fea650-4a48-4e8e-b23f-b27863230938",
 CellID->701203447],
Cell[89558, 1777, 1175, 24, 24, "Print",ExpressionUUID->"0ac82ace-56dd-432a-8c08-07d3fdfa1b16",
 CellID->1883562640],
Cell[90736, 1803, 777, 16, 24, "Print",ExpressionUUID->"c94db32b-e8fc-432d-93f5-f15220b0b6b2",
 CellID->980850053]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[91562, 1825, 364, 4, 67, "Section",ExpressionUUID->"28612ff9-e185-4763-893b-36ce4ca841e0",
 CellID->116816367],
Cell[CellGroupData[{
Cell[91951, 1833, 378, 8, 30, "Input",ExpressionUUID->"8dc78173-e1dd-4be8-981e-fce8c3293986",
 CellID->2109175560],
Cell[92332, 1843, 242, 3, 24, "Print",ExpressionUUID->"92186d78-5edc-44e2-9060-2a542abee31f",
 CellID->1546512867],
Cell[92577, 1848, 683, 17, 24, "Print",ExpressionUUID->"b60ea563-308b-48aa-bd54-707c4584b9c0",
 CellID->1247176028],
Cell[93263, 1867, 675, 17, 24, "Print",ExpressionUUID->"eeec06b0-953c-4263-b8d4-23077580f1b2",
 CellID->1847107876],
Cell[93941, 1886, 806, 22, 44, "Print",ExpressionUUID->"17020eba-08fc-4aa3-a8df-ccae59665f8f",
 CellID->318470900],
Cell[94750, 1910, 647, 17, 44, "Print",ExpressionUUID->"2d5dd02d-95fd-417b-a9c0-0840603caf3f",
 CellID->1011167976],
Cell[95400, 1929, 661, 17, 44, "Print",ExpressionUUID->"3024111f-1ff5-4e5c-b893-cf760ce745cc",
 CellID->1662073921],
Cell[96064, 1948, 658, 17, 44, "Print",ExpressionUUID->"7a98bdb7-93bd-4b98-8482-6f3c8449e510",
 CellID->9110071],
Cell[96725, 1967, 660, 17, 44, "Print",ExpressionUUID->"5a78ee83-9384-4426-b622-6f45d692c067",
 CellID->641624360],
Cell[97388, 1986, 199, 3, 24, "Print",ExpressionUUID->"492c2ef8-2836-47eb-8b58-cb72eca0739d",
 CellID->1265226933],
Cell[97590, 1991, 468, 11, 24, "Print",ExpressionUUID->"b869d964-651d-468d-98d8-e232d058869b",
 CellID->285990337],
Cell[98061, 2004, 222, 3, 24, "Print",ExpressionUUID->"aceaa45c-a040-43e6-8916-acc7dfa648de",
 CellID->571191973],
Cell[98286, 2009, 407, 8, 24, "Print",ExpressionUUID->"7d632881-2468-4a20-a0f9-65b919811797",
 CellID->771588121],
Cell[98696, 2019, 257, 4, 24, "Print",ExpressionUUID->"561587a6-b458-474b-b10b-62ec77ed43bb",
 CellID->1575289061],
Cell[98956, 2025, 738, 15, 24, "Print",ExpressionUUID->"1678d9b0-259b-4de6-8f56-c9d73fc59ee7",
 CellID->1704848011],
Cell[99697, 2042, 339, 7, 24, "Print",ExpressionUUID->"078b2af0-7780-48b8-a641-7f86c09ed3ee",
 CellID->1653702603],
Cell[100039, 2051, 693, 14, 24, "Print",ExpressionUUID->"9e167179-b62e-4545-954c-443d42fdd4d2",
 CellID->1046289147],
Cell[100735, 2067, 856, 21, 63, "Print",ExpressionUUID->"6e7e6810-ea43-4b0a-8586-f37871a6f203",
 CellID->1385591993],
Cell[101594, 2090, 648, 17, 44, "Print",ExpressionUUID->"f40d1082-6a0a-42c4-9e46-1e9f6b915cd0",
 CellID->331958283],
Cell[102245, 2109, 658, 17, 24, "Print",ExpressionUUID->"aab39683-32c7-4d1d-aeeb-63aa4921f127",
 CellID->60347475],
Cell[102906, 2128, 606, 17, 44, "Print",ExpressionUUID->"2b4ebe63-9e55-4cdd-aea8-79ace656a57a",
 CellID->647730941]
}, Open  ]],
Cell[CellGroupData[{
Cell[103549, 2150, 323, 7, 30, "Input",ExpressionUUID->"672de9f1-0cfc-4e45-8d49-7822c9c0b6ce",
 CellID->2077815379],
Cell[103875, 2159, 246, 4, 24, "Print",ExpressionUUID->"2c2bb492-e94b-4c88-b4f6-a4cffc9bd478",
 CellID->49295002],
Cell[104124, 2165, 469, 11, 24, "Print",ExpressionUUID->"6a536d19-a0e9-4702-b664-a641d1128db8",
 CellID->1719894519],
Cell[104596, 2178, 226, 3, 24, "Print",ExpressionUUID->"6e8532ce-e6d7-4721-86b8-19d34eb826d6",
 CellID->1137292213],
Cell[104825, 2183, 404, 8, 24, "Print",ExpressionUUID->"21577fcb-0c1e-4159-b83a-7ad182a5924d",
 CellID->1865765591],
Cell[105232, 2193, 256, 4, 24, "Print",ExpressionUUID->"7a4449ee-9252-4d66-a2e3-37cabd64a770",
 CellID->366074443],
Cell[105491, 2199, 742, 15, 24, "Print",ExpressionUUID->"9cfb82f4-8507-47be-9b3e-bbdbc6704c0c",
 CellID->72514846],
Cell[106236, 2216, 341, 7, 24, "Print",ExpressionUUID->"5eed7a4a-703b-46c0-a0ff-7a2437dd9609",
 CellID->1133788873],
Cell[106580, 2225, 694, 14, 24, "Print",ExpressionUUID->"177e7bdc-0a74-4104-8926-6a4d9b413023",
 CellID->967188680],
Cell[107277, 2241, 240, 3, 24, "Print",ExpressionUUID->"76e4e84d-8e56-4e6c-b137-cd69429930b4",
 CellID->1236420617],
Cell[107520, 2246, 505, 12, 24, "Print",ExpressionUUID->"5c82ecfd-ec11-4ff3-89b8-ebb586682a5d",
 CellID->1469541547],
Cell[108028, 2260, 458, 11, 24, "Print",ExpressionUUID->"8b4fe656-f649-4281-ac12-28cb3ed53d01",
 CellID->375356282],
Cell[108489, 2273, 437, 8, 24, "Print",ExpressionUUID->"7d6dfc9f-fc1d-4bdf-a91c-1c001de5d0b6",
 CellID->1453560335],
Cell[108929, 2283, 458, 11, 24, "Print",ExpressionUUID->"6728870f-0119-4e6a-a9c2-9d2c6ab8cf39",
 CellID->214582073],
Cell[109390, 2296, 424, 8, 24, "Print",ExpressionUUID->"9615ab0b-9bf1-449e-ba02-470edc1e26bf",
 CellID->855857598],
Cell[109817, 2306, 220, 3, 24, "Print",ExpressionUUID->"230778e9-0059-41d2-a5cf-e8fdc7e58988",
 CellID->553181980],
Cell[110040, 2311, 246, 4, 24, "Print",ExpressionUUID->"4991b19d-e2e4-4b80-8ab7-4825e4cf3961",
 CellID->872829997],
Cell[110289, 2317, 435, 8, 24, "Print",ExpressionUUID->"3240d6ea-9ccb-4afa-a06f-ec8b3f117527",
 CellID->192966922],
Cell[110727, 2327, 593, 11, 24, "Print",ExpressionUUID->"26dde681-7749-4c76-b87c-5b11a6583fab",
 CellID->494751084],
Cell[111323, 2340, 216, 3, 24, "Print",ExpressionUUID->"f73ec221-67b7-4d92-a988-1bfd6f1ce7b6",
 CellID->224787604],
Cell[111542, 2345, 201, 3, 24, "Print",ExpressionUUID->"ecca50c5-8730-47f8-b2d8-7026c5b09cba",
 CellID->581525355]
}, Open  ]],
Cell[CellGroupData[{
Cell[111780, 2353, 386, 8, 30, "Input",ExpressionUUID->"e3f9db62-1e0b-4c39-8c60-ca414ec93ad2",
 CellID->456746452],
Cell[112169, 2363, 240, 3, 24, "Print",ExpressionUUID->"01fc50bb-778a-4706-952a-4111b8033fc5",
 CellID->498563988],
Cell[112412, 2368, 230, 3, 24, "Print",ExpressionUUID->"ad3338be-a227-49f1-9e0c-b7217c168bca",
 CellID->2031239369],
Cell[112645, 2373, 229, 3, 24, "Print",ExpressionUUID->"34b97f69-9f15-4b94-8981-7c11058f5267",
 CellID->492538424],
Cell[112877, 2378, 393, 8, 24, "Print",ExpressionUUID->"ab4d1659-49c3-4919-aa03-009497df27e0",
 CellID->1691316630],
Cell[113273, 2388, 375, 8, 24, "Print",ExpressionUUID->"bae952d3-fdee-44a3-a0bd-e861a4563223",
 CellID->1865048718],
Cell[113651, 2398, 285, 4, 24, "Print",ExpressionUUID->"b7628f5c-3b81-430c-a4c3-b1645ff5c4a8",
 CellID->1202491814],
Cell[113939, 2404, 262, 4, 24, "Print",ExpressionUUID->"8d7cb411-0934-4204-947c-0b6187bdf8d4",
 CellID->311315981],
Cell[114204, 2410, 264, 4, 24, "Print",ExpressionUUID->"efff8976-0a34-400d-8914-808101b99003",
 CellID->1017528575],
Cell[114471, 2416, 375, 8, 24, "Print",ExpressionUUID->"fefb74ca-436f-4ad5-b6b2-6ec7a58a1294",
 CellID->1190478964],
Cell[114849, 2426, 476, 11, 24, "Print",ExpressionUUID->"bc21bed8-c870-406a-8c1b-889a8f263136",
 CellID->274808849],
Cell[115328, 2439, 226, 3, 24, "Print",ExpressionUUID->"9e4e95b3-cd0a-4b4f-8b09-2de1cabaf60b",
 CellID->1622484093],
Cell[115557, 2444, 405, 8, 24, "Print",ExpressionUUID->"e112e94d-ab2b-410a-aaeb-8435bb12401b",
 CellID->342801445],
Cell[115965, 2454, 259, 4, 24, "Print",ExpressionUUID->"20f33b74-3b76-45b7-9b22-ab258d5f7ad5",
 CellID->1912744861],
Cell[116227, 2460, 744, 15, 24, "Print",ExpressionUUID->"1db5bd74-b63b-490b-8d0a-f58249491ab0",
 CellID->1820166884],
Cell[116974, 2477, 340, 7, 24, "Print",ExpressionUUID->"c5daecd6-0e66-4e45-afc4-9b29b0d48985",
 CellID->640267873],
Cell[117317, 2486, 522, 11, 39, "Message",ExpressionUUID->"25604d61-f23b-4499-8aa2-8eb3b193daa4",
 CellID->2089070041],
Cell[117842, 2499, 522, 11, 39, "Message",ExpressionUUID->"3a3063f9-93eb-459e-8e81-82d86944ecd3",
 CellID->1790034284],
Cell[118367, 2512, 521, 11, 39, "Message",ExpressionUUID->"45824848-1bee-4cb1-9081-f89eb171e7a3",
 CellID->1007800365],
Cell[118891, 2525, 523, 11, 39, "Message",ExpressionUUID->"0b00ad92-7d4b-4226-8e1c-ccb66948dc15",
 CellID->897210666],
Cell[119417, 2538, 522, 11, 39, "Message",ExpressionUUID->"0e429797-6b66-4075-a8be-663a92a7fa91",
 CellID->1936977875],
Cell[119942, 2551, 522, 11, 39, "Message",ExpressionUUID->"c7baf0ec-432d-4187-b36e-c94cfe82aeed",
 CellID->1082540252],
Cell[120467, 2564, 523, 11, 39, "Message",ExpressionUUID->"e6fa4e72-96e8-42bc-a0d2-ba69ba8240f9",
 CellID->772557980],
Cell[120993, 2577, 521, 11, 39, "Message",ExpressionUUID->"9f9e15ef-fab4-4eed-8a32-23bcba3e531a",
 CellID->695840098],
Cell[121517, 2590, 468, 10, 24, "Message",ExpressionUUID->"13c44780-ec19-4f80-b191-87c30ad2a8a9",
 CellID->1936069171],
Cell[121988, 2602, 521, 11, 39, "Message",ExpressionUUID->"4cd66d50-03da-43dc-a857-ae380aba98b9",
 CellID->842337653],
Cell[122512, 2615, 521, 11, 39, "Message",ExpressionUUID->"513bee28-6199-42ed-8d4c-53ffb6a3bfac",
 CellID->956732947],
Cell[123036, 2628, 522, 11, 39, "Message",ExpressionUUID->"ab23f203-0427-4f2c-9c1c-10d851bfc7b0",
 CellID->1600575140],
Cell[123561, 2641, 524, 11, 39, "Message",ExpressionUUID->"bdffe834-82ff-40d4-9a72-065075f6b2c9",
 CellID->1486215658],
Cell[124088, 2654, 522, 11, 39, "Message",ExpressionUUID->"731ce4c1-641a-47dd-966c-228ce50aae5e",
 CellID->1444265749],
Cell[124613, 2667, 521, 11, 39, "Message",ExpressionUUID->"ddade674-7ae8-4f49-ae16-f43310a0e556",
 CellID->766781402],
Cell[125137, 2680, 521, 11, 39, "Message",ExpressionUUID->"b48cc0fd-c1a5-495e-a9f6-e07d9592e847",
 CellID->245657767],
Cell[125661, 2693, 522, 11, 39, "Message",ExpressionUUID->"6ff5d2e5-5327-452b-b8e2-aafe4105f35d",
 CellID->1306520435],
Cell[126186, 2706, 521, 11, 39, "Message",ExpressionUUID->"67ed6279-8bc8-4b52-a475-0bd3d4e505b0",
 CellID->668660470],
Cell[126710, 2719, 521, 11, 39, "Message",ExpressionUUID->"31fbb9eb-4870-4fe3-8510-b8d00a3d6354",
 CellID->394594539],
Cell[127234, 2732, 521, 11, 39, "Message",ExpressionUUID->"f5705068-9ea0-4b10-911b-97216722c6e5",
 CellID->520915037],
Cell[127758, 2745, 522, 11, 39, "Message",ExpressionUUID->"70d73f29-3243-4afb-996a-280167d5d45c",
 CellID->1875681687],
Cell[128283, 2758, 522, 11, 39, "Message",ExpressionUUID->"3b97f864-f40a-44b0-8b96-3773a93a9ed2",
 CellID->1669659096],
Cell[128808, 2771, 521, 11, 39, "Message",ExpressionUUID->"f8ab4ac2-eb73-473f-aa13-3956a5fe5421",
 CellID->791611123],
Cell[129332, 2784, 523, 11, 39, "Message",ExpressionUUID->"6dd5dad4-ff7a-47af-8b85-ddb366c4c411",
 CellID->946951096],
Cell[129858, 2797, 521, 11, 39, "Message",ExpressionUUID->"37111d7f-6431-44fd-9193-c3364e84adff",
 CellID->405762555],
Cell[130382, 2810, 522, 11, 39, "Message",ExpressionUUID->"c7a434ca-1855-4a89-bf37-8ed92edf1e9c",
 CellID->1390682660],
Cell[130907, 2823, 522, 11, 39, "Message",ExpressionUUID->"3a2012fe-8475-42d8-814f-1c1e899d8e68",
 CellID->2138936319],
Cell[131432, 2836, 520, 11, 39, "Message",ExpressionUUID->"6b803092-1818-485a-bb63-0123155c28db",
 CellID->226462653],
Cell[131955, 2849, 521, 11, 39, "Message",ExpressionUUID->"06340baa-3332-4c92-b5cc-12603f48d2ce",
 CellID->816786487],
Cell[132479, 2862, 521, 11, 39, "Message",ExpressionUUID->"2b46803f-edad-4499-affb-46d603c1def9",
 CellID->1015015385],
Cell[133003, 2875, 524, 11, 39, "Message",ExpressionUUID->"32ba9a35-a41c-4b94-b24a-67d30c5cc05b",
 CellID->1900967574],
Cell[133530, 2888, 524, 11, 39, "Message",ExpressionUUID->"b5f6bfed-49a9-4b92-ac51-83f214a3f4e2",
 CellID->1447799799],
Cell[134057, 2901, 520, 11, 39, "Message",ExpressionUUID->"86f6d7cd-e8b0-4fd1-8575-7d362b1bcac2",
 CellID->34017636],
Cell[134580, 2914, 520, 11, 39, "Message",ExpressionUUID->"2bddb63c-01af-40cd-87c6-2b894500052f",
 CellID->503758150],
Cell[135103, 2927, 522, 11, 39, "Message",ExpressionUUID->"5fddc6b8-75c8-4e05-b1f2-974fbc0f74d6",
 CellID->1282690576],
Cell[135628, 2940, 521, 11, 39, "Message",ExpressionUUID->"8f51db69-6372-473e-aa79-8afe441991de",
 CellID->1739662246],
Cell[136152, 2953, 521, 11, 39, "Message",ExpressionUUID->"378b24b6-f3f7-4efa-9833-9691163d1bb1",
 CellID->513514617],
Cell[136676, 2966, 522, 11, 39, "Message",ExpressionUUID->"5df7d9c8-81c4-4699-8347-4db4f99298e2",
 CellID->2050874273],
Cell[137201, 2979, 522, 11, 39, "Message",ExpressionUUID->"117a5414-7505-4635-a203-9af42987f00a",
 CellID->1931371961],
Cell[137726, 2992, 522, 11, 39, "Message",ExpressionUUID->"ee9e35dd-11f3-425c-bd0e-6d004f088747",
 CellID->1353224122],
Cell[138251, 3005, 522, 11, 39, "Message",ExpressionUUID->"e79c45e2-4454-4ced-af7b-05b544b88aee",
 CellID->1785996724],
Cell[138776, 3018, 524, 11, 39, "Message",ExpressionUUID->"f9696b81-3623-4abf-a153-de7736c62487",
 CellID->1868006149],
Cell[139303, 3031, 524, 11, 39, "Message",ExpressionUUID->"dc470f3a-0043-4f0c-a47b-0204638681a4",
 CellID->1515910750],
Cell[139830, 3044, 521, 11, 39, "Message",ExpressionUUID->"7c55b6df-e544-45d4-a1e9-96b1064d23b0",
 CellID->165987242],
Cell[140354, 3057, 521, 11, 39, "Message",ExpressionUUID->"054c2e1c-1a53-4d57-9749-f18ffa8f116b",
 CellID->166318841],
Cell[140878, 3070, 521, 11, 39, "Message",ExpressionUUID->"dad7f7ff-63e3-43c4-a584-1d2c9691caee",
 CellID->1444535940],
Cell[141402, 3083, 524, 11, 39, "Message",ExpressionUUID->"0014cb35-3e91-479a-8803-5728e2af7922",
 CellID->1012914245],
Cell[141929, 3096, 523, 11, 39, "Message",ExpressionUUID->"ec94006e-fbea-4ddc-a70f-8d5edf814024",
 CellID->946845946],
Cell[142455, 3109, 521, 11, 39, "Message",ExpressionUUID->"68c3e99a-8114-4e24-96b1-cd86a30463e3",
 CellID->785990152],
Cell[142979, 3122, 521, 11, 39, "Message",ExpressionUUID->"550fd119-b13e-4e23-8fa8-28c346ca1dcf",
 CellID->964571967],
Cell[143503, 3135, 521, 11, 39, "Message",ExpressionUUID->"d508e71d-a1ac-4105-b8c7-6a151393dd43",
 CellID->206998166],
Cell[144027, 3148, 520, 11, 39, "Message",ExpressionUUID->"a1c90384-81b7-4306-9665-2cfdd606e3f4",
 CellID->94667822],
Cell[144550, 3161, 522, 11, 39, "Message",ExpressionUUID->"1db7aaac-17cf-482f-a090-80c1e27519b7",
 CellID->1944185574],
Cell[145075, 3174, 522, 11, 39, "Message",ExpressionUUID->"5f58585e-5bc0-4a8b-99b0-85e4444766b6",
 CellID->1963253113],
Cell[145600, 3187, 521, 11, 39, "Message",ExpressionUUID->"05f33399-8e37-47a2-ad19-7811e7205d44",
 CellID->308834036],
Cell[146124, 3200, 521, 11, 39, "Message",ExpressionUUID->"08f193dd-4ff0-47fd-900e-33397f36c311",
 CellID->105668253],
Cell[146648, 3213, 524, 11, 39, "Message",ExpressionUUID->"096efd2a-7f7c-4496-b3ad-5ca103171440",
 CellID->2144835749],
Cell[147175, 3226, 521, 11, 39, "Message",ExpressionUUID->"d6b8edc8-5e10-4733-8e92-af88f0d29034",
 CellID->593934901],
Cell[147699, 3239, 523, 11, 39, "Message",ExpressionUUID->"141693f9-411c-47fa-adfb-97462094e013",
 CellID->759889851],
Cell[148225, 3252, 521, 11, 39, "Message",ExpressionUUID->"0780590f-cfe8-4277-bf26-efe3daece1e8",
 CellID->383477048],
Cell[148749, 3265, 523, 11, 39, "Message",ExpressionUUID->"d376f839-08c5-447d-b838-1a487f73818f",
 CellID->500321089],
Cell[149275, 3278, 522, 11, 39, "Message",ExpressionUUID->"c49e9887-4823-4b2b-b662-077453247b96",
 CellID->1498064818],
Cell[149800, 3291, 523, 11, 39, "Message",ExpressionUUID->"ee375011-9500-4cfe-a896-92f93851e1cd",
 CellID->877118698],
Cell[150326, 3304, 522, 11, 39, "Message",ExpressionUUID->"eadb7579-a243-4083-b227-f22768462150",
 CellID->1406204278],
Cell[150851, 3317, 522, 11, 39, "Message",ExpressionUUID->"fe3e8728-9356-40c2-aaf1-b9fad010dd59",
 CellID->1017765111],
Cell[151376, 3330, 521, 11, 39, "Message",ExpressionUUID->"d489138d-4bbc-4987-819d-c73069246d49",
 CellID->870972222],
Cell[151900, 3343, 522, 11, 39, "Message",ExpressionUUID->"88a05bdf-bacc-4197-906f-4ba0ae94f81d",
 CellID->1181597202],
Cell[152425, 3356, 524, 11, 39, "Message",ExpressionUUID->"b72bfdd5-cde3-4b93-9370-0f6ffe041a4b",
 CellID->1322890205],
Cell[152952, 3369, 521, 11, 39, "Message",ExpressionUUID->"5ec2ab99-64f6-4c87-8cfb-a14bfad2a302",
 CellID->917478044],
Cell[153476, 3382, 522, 11, 39, "Message",ExpressionUUID->"1441ae64-9a12-4838-bef3-3bde90a2d42a",
 CellID->1120900048],
Cell[154001, 3395, 522, 11, 39, "Message",ExpressionUUID->"0b104cc9-9f68-4b2d-9be2-baf9a377b30e",
 CellID->1240555252],
Cell[154526, 3408, 520, 11, 39, "Message",ExpressionUUID->"097eaa58-fff1-4607-81e6-07c79046303d",
 CellID->93391641],
Cell[155049, 3421, 522, 11, 39, "Message",ExpressionUUID->"87f6a680-3ef0-43ff-9858-a1bb452c6a24",
 CellID->1970247977],
Cell[155574, 3434, 524, 11, 39, "Message",ExpressionUUID->"fdef274d-527f-4660-9ac9-852f5f3d8cda",
 CellID->1907396346],
Cell[156101, 3447, 522, 11, 39, "Message",ExpressionUUID->"7952c282-e4b9-47f9-a0e4-6a976357c851",
 CellID->2121988453],
Cell[156626, 3460, 521, 11, 39, "Message",ExpressionUUID->"4b2aff15-a711-4037-bb3f-0338b7f47d07",
 CellID->999003842],
Cell[157150, 3473, 521, 11, 39, "Message",ExpressionUUID->"bacf17ee-4b90-4278-8dd6-b46936d01f04",
 CellID->1230420248],
Cell[157674, 3486, 522, 11, 39, "Message",ExpressionUUID->"e97567b9-88a2-4590-8825-079c70675dc2",
 CellID->1553071173],
Cell[158199, 3499, 524, 11, 39, "Message",ExpressionUUID->"a5d438be-a5bb-4b6c-8062-aebe91a90d16",
 CellID->1950958973],
Cell[158726, 3512, 524, 11, 39, "Message",ExpressionUUID->"2e4b0ebf-3cb7-4c1c-a938-c755dd3ebb0c",
 CellID->1987136815],
Cell[159253, 3525, 521, 11, 39, "Message",ExpressionUUID->"b64d4bea-a368-4d19-8b48-90855f094223",
 CellID->142771561],
Cell[159777, 3538, 521, 11, 39, "Message",ExpressionUUID->"6c5fb897-a864-4d71-b131-487de6d99037",
 CellID->822392028],
Cell[160301, 3551, 521, 11, 39, "Message",ExpressionUUID->"92181cf7-717c-4dda-93db-eb8bcc38ebbc",
 CellID->738062504],
Cell[160825, 3564, 521, 11, 39, "Message",ExpressionUUID->"6d726126-87c5-4afe-87a2-351aaa5ca1ad",
 CellID->750959656],
Cell[161349, 3577, 520, 11, 39, "Message",ExpressionUUID->"97f3a1bc-9f7b-4c3f-9c3c-632db37e2087",
 CellID->617544973],
Cell[161872, 3590, 429, 9, 24, "Print",ExpressionUUID->"e01a19ac-8a89-438d-a534-ad099c733623",
 CellID->289895260],
Cell[162304, 3601, 458, 9, 24, "Print",ExpressionUUID->"11caf163-1156-4fd2-9fd9-acf76b5eff4e",
 CellID->1776723424]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

