//
// Macro to calculate the colored resonance width
//
// Set the coupling (qqtrip) and then the code loops over triplet particle
// masses and prints them to the screen and into a text file and shell script
// that is convenient to use for event generation.
//
// Author: Reinhard Schwienhorst, from the bprime one
//
// Date: July 2012
//
//
#include "TMath.h"
#include <iostream>
ofstream fout, fout1,fshell;
// 
// coupling parameters. You could change these if you wanted to
double qqtrip = 0.3;    // default: 1

// SM parameters
double MT  = 172.5;
double MW  = 80.267;
double MB  = 4.2;
double MH  = 125.0;
double k_z = 1.;
double gs = 1.2177158;
double MZ = 91.545;

double gwrs=0.65189214;
double cwrs=0.876812409;
double vrs=246.259632;

oneMRes (const double& MRes=700, const double& qqt=0.3);

resonanceWidth(){

  fout.open("colored_resonance_masswidth.lst");
  fout1.open("colored_resonance_widthdetails.lst");
  fshell.open("masswidth.sh");
  fout << " qqtrip = " << qqtrip <<endl;
  fout << " M_T = " << MT << endl;
  fout << "colored resonance Mass [GeV]  Width [GeV] " << endl;
  fout1<< "colored res Mass [GeV]  Width [GeV]" << endl;
  for(int i=0; i<60; i++){
      double inMR = 300 + 50 * i ;
      cout << inMR<<" qqtrip = " << qqtrip<<endl;
      oneMRes(inMR,qqtrip);
  }
  fout.close();
  fout1.close();
  fshell.close();
}

// helper functions for the width calculation
double lambda(const double& m0,const double& m1,const double& m2) {
  return (pow(m0,4) + pow(m1,4) + pow(m2,4) 
	  - 2.*pow(m0,2)*pow(m1,2)
	  - 2.*pow(m0,2)*pow(m2,2)
	  - 2.*pow(m1,2)*pow(m2,2));
}
double lambda2(const double& xf,const double& xv) { return lambda(xf,xv,1.); }
double FFV1(const double& g,const double& fL, const double& fR, const double& mB,const double& mv, const double& xf, const double& xv) {
  return (pow(g,2)/(32.*TMath::Pi())
	  * pow(mB,3)/pow(mv,2)
	  * TMath::Sqrt(lambda2(xf,xv))
	  * ((pow(fL,2)+pow(fR,2))*(1.+pow(xv,2)-2.*pow(xf,2)-2.*pow(xv,4)
				    +pow(xv,2)*pow(xf,2)+pow(xf,4))
	     - 12.*fL*fR*pow(xv,2)*xf) );
}


//
// function to compute the partial and total widths at one mass
//
oneMRes(const double& MRes, const double& qqt){
  //
  // RS implementing what Jianghao has:
  double fL=qqt;
  double fR=qqt;
  double wtb = MRes/16./TMath::Pi()
    * TMath::Sqrt(lambda2(MT/MRes,MB/MRes))
    * ( (pow(fL,2)+pow(fR,2))*(1.-pow(MT/MRes,2)-pow(MB/MRes,2))
	- 4.*fL*fR*MT/MRes*MB/MRes);
  
  // output to text file and script that updates the param_card.dat-bak file
  fout << MRes << " \t\t " << wtb << endl;
  fout1 << MRes << " \t " << wtb << endl;
  //
  // now for light quarks: 
  double wqq = MRes/16./TMath::Pi()
    * 1.
    * (pow(fL,2)+pow(fR,2));
  
  cout<<MRes<<", tb width "<<wtb<<", qq' width "<<wqq<<", total width "<<2.*wqq+wtb<<endl;
  //cout << "Width of " << MRes << " GeV colored resonance is : " << wtb << endl;
  
}

