(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6235,        166]
NotebookOptionsPosition[      5464,        136]
NotebookOutlinePosition[      5921,        154]
CellTagsIndexPosition[      5878,        151]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.529729640301558*^9, 3.529729640867762*^9}, {
  3.571948057562459*^9, 3.571948060394286*^9}, {3.5720308710290203`*^9, 
  3.572030871692618*^9}, {3.572116374658242*^9, 3.572116375210046*^9}}],

Cell[CellGroupData[{

Cell["Setup", "Section"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$OldDir", "=", 
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", 
    "\"\<~/Work/tools/FeynRules/trunk/feynrules-development\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\n", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$OldDir", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<../MSSM/mssm.fr\>\"", ",", " ", "\"\<gldgrv.fr\>\""}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"$CalcLag", "=", "True"}], ";"}]}], "Input",
 CellChangeTimes->{{3.510511714359152*^9, 3.5105117232569723`*^9}, {
   3.52972960449199*^9, 3.529729617872299*^9}, {3.52981709669534*^9, 
   3.529817102988616*^9}, {3.529817239106802*^9, 3.52981723986018*^9}, {
   3.529817572824171*^9, 3.5298175822034388`*^9}, {3.5298176180919333`*^9, 
   3.529817618644792*^9}, {3.529818319105591*^9, 3.529818319452136*^9}, {
   3.5298183862814817`*^9, 3.5298183867754917`*^9}, {3.530014184363921*^9, 
   3.530014184866425*^9}, {3.530279274200142*^9, 3.5302792746787453`*^9}, {
   3.530279346994732*^9, 3.530279347463052*^9}, {3.5302824581143637`*^9, 
   3.530282458669952*^9}, {3.530283431734676*^9, 3.530283432112616*^9}, {
   3.530284233506078*^9, 3.530284234083164*^9}, {3.53216778814719*^9, 
   3.532167788450335*^9}, {3.532170481347641*^9, 3.5321704955865726`*^9}, {
   3.5328392804839478`*^9, 3.532839282856853*^9}, {3.532870659813244*^9, 
   3.532870660152001*^9}, {3.532980915978623*^9, 3.53298091649365*^9}, {
   3.563594666949706*^9, 3.5635946673053303`*^9}, {3.56360763247821*^9, 
   3.563607633001974*^9}, {3.563614230295828*^9, 3.563614230638699*^9}, {
   3.563703741362089*^9, 3.563703741862739*^9}, {3.563704233601944*^9, 
   3.563704233981513*^9}, 3.564826908520685*^9, {3.564827597631703*^9, 
   3.5648276214934063`*^9}, {3.564827676195327*^9, 3.564827676745825*^9}, {
   3.5648279742339077`*^9, 3.5648279754098043`*^9}, {3.5648280073143187`*^9, 
   3.5648280802298717`*^9}, {3.5648396878377533`*^9, 3.564839694346941*^9}, {
   3.5649176397614527`*^9, 3.564917646271906*^9}, {3.570417430328074*^9, 
   3.570417430718464*^9}, {3.570545250194833*^9, 3.570545250713505*^9}, {
   3.572372212656474*^9, 3.5723722138227777`*^9}, {3.573266982773725*^9, 
   3.573266986561677*^9}, {3.573384322022996*^9, 3.573384322476486*^9}, {
   3.584948958535923*^9, 3.5849490070137243`*^9}, {3.584949050767918*^9, 
   3.58494905143953*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computing the lagrangian", "Section",
 CellChangeTimes->{{3.5328706710103292`*^9, 3.5328706735457983`*^9}, {
  3.5637073298373117`*^9, 3.563707331318151*^9}, {3.563707694492751*^9, 
  3.563707697482766*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{"$CalcLag", ",", 
    RowBox[{
     RowBox[{"lagr", "=", "lagra"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Definition", "[", "lagr", "]"}], ">>", "lagrangian.dat"}]}], 
    ",", 
    RowBox[{"<<", "lagrangian.dat"}]}], "]"}], ";"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Parameters and UFO output", "Section",
 CellChangeTimes->{{3.529817450398305*^9, 3.529817451889786*^9}, {
  3.532839547831317*^9, 3.5328395490020723`*^9}, {3.584949062152893*^9, 
  3.584949063471664*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<../MSSM\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ReadLHAFile", "[", 
   RowBox[{"Input", "\[Rule]", "\"\<sps1a.dat\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$OldDir", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5323172969392443`*^9, 3.532317326551259*^9}, {
  3.532870710712151*^9, 3.532870716195807*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteRestrictionFile", "[", "]"}], ";", 
  RowBox[{"LoadRestriction", "[", "\"\<ZeroValues.rst\>\"", "]"}], ";", 
  RowBox[{"DeleteFile", "[", "\"\<ZeroValues.rst\>\"", "]"}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{"lagr", ",", 
    RowBox[{"Exclude4Scalars", "\[Rule]", "True"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.532870730989689*^9, 3.532870744946867*^9}, {
   3.5328966188316507`*^9, 3.5328966380583057`*^9}, 3.532896678206644*^9, {
   3.532924522141225*^9, 3.532924581016425*^9}, {3.532924686543313*^9, 
   3.5329246868077917`*^9}, {3.532957195462633*^9, 3.532957198473382*^9}, {
   3.532969254775139*^9, 3.532969255318975*^9}, {3.584949067591806*^9, 
   3.584949071325344*^9}}]
}, Open  ]]
},
WindowSize->{1367, 856},
WindowMargins->{{Automatic, 248}, {38, Automatic}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 264, 4, 28, "Input"],
Cell[CellGroupData[{
Cell[834, 28, 24, 0, 80, "Section"],
Cell[861, 30, 2544, 45, 114, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3442, 80, 213, 3, 80, "Section"],
Cell[3658, 85, 318, 9, 46, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4013, 99, 210, 3, 80, "Section"],
Cell[4226, 104, 445, 11, 63, "Input"],
Cell[4674, 117, 227, 4, 28, "Input"],
Cell[4904, 123, 544, 10, 28, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
