(* ::Package:: *)

Print["qq->WW amplitudes for the dim-8 operators"];
Print["The results are stored in the form of ResultWW[\"ON\"][\"uu/dd\"], where ON label the corresponding dim-8 Operators"];
Print["dd/uu indicated the initial quarks states, for example ResultWW[\"O10\"][uu] gives an association storing the relevant amplitude results for u\!\(\*OverscriptBox[\(u\), \(_\)]\)->\!\(\*SuperscriptBox[\(W\), \(+\)]\)\!\(\*SuperscriptBox[\(W\), \(-\)]\) generated by O10"];
Print["The association has following keys:\n
HelAmpNP: a list of helicity amplitudes for W+ W- with polarizations in order of (-+,--,-0,++,+-,+0,0-,0+,00)\n
HelAmpSM: a list of helicity amplitudes for W+ W- with polarizations in order of (-+,--,-0,++,+-,+0,0-,0+,00)\n
Mint2t:   The total interference amplitudes Re[\!\(\*SubscriptBox[\(A\), \(SM\)]\)\!\(\*SubsuperscriptBox[\(A\), \(NP\), \(*\)]\)] as a function of (S, t=Cos[\[Theta]]), where S is the square of ECOM, \[Theta] is the scattering angle\n
Mint2tInt: The total interference amplitudes after integration over the solid angle\n
SMint2t:  Expansion of the total interference amplitudes in power of S\n
SMint2tInt:  Expansion of the total interference amplitudes after integration over the solid angle in power of S\n"];


(* ::Input::Initialization:: *)
ResultWW["O8"]["dd"]=<|"HelAmpNP"->{C8 S (-2 MW2+S) Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2],C8 MW2 S Cos[\[Theta]] Sin[\[Theta]] SUNT[Col1,Col2],(C8 MW2 S^(3/2) (1+2 Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(Sqrt[2] MW),C8 MW2 S Cos[\[Theta]] Sin[\[Theta]] SUNT[Col1,Col2],-2 C8 S (-2 MW2+S) Cos[\[Theta]/2]^3 Sin[\[Theta]/2] SUNT[Col1,Col2],(C8 MW2 S^(3/2) Cos[\[Theta]/2]^2 (-1+2 Cos[\[Theta]]) SUNT[Col1,Col2])/(Sqrt[2] MW),-((C8 MW2 S^(3/2) (1+2 Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(Sqrt[2] MW)),(C8 MW2 S^(3/2) Cos[\[Theta]/2]^2 (1-2 Cos[\[Theta]]) SUNT[Col1,Col2])/(Sqrt[2] MW),-2 C8 MW2 S (Cos[\[Theta]/2]+Cos[(3 \[Theta])/2]) Sin[\[Theta]/2] SUNT[Col1,Col2]},"HelAmpSM"->{0,(4 Alfa MZ2 \[Pi] Sqrt[1-(4 MW2)/S] Sin[\[Theta]] SUNT[Col1,Col2])/(3 (-MZ2+S)),(4 Alfa MZ2 \[Pi] Sqrt[-8 MW2+2 S] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(-3 MW MZ2+3 MW S),(4 Alfa MZ2 \[Pi] Sqrt[1-(4 MW2)/S] Sin[\[Theta]] SUNT[Col1,Col2])/(3 (-MZ2+S)),0,(4 Alfa MZ2 \[Pi] Sqrt[-8 MW2+2 S] Cos[\[Theta]/2]^2 SUNT[Col1,Col2])/(-3 MW MZ2+3 MW S),(4 Sqrt[2] Alfa MZ2 \[Pi] Sqrt[-4 MW2+S] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW MZ2-3 MW S),(4 Sqrt[2] Alfa MZ2 \[Pi] Sqrt[-4 MW2+S] Cos[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW MZ2-3 MW S),(2 Alfa MZ2 \[Pi] Sqrt[1-(4 MW2)/S] (2 MW2+S) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW2 (MZ2-S))},"Mint2t"->-(1/(MZ2-S))8 (4 Alfa C8 MW2 MZ2 \[Pi] Sqrt[S (-4 MW2+S)] t+Alfa C8 MZ2 \[Pi] Sqrt[S^3 (-4 MW2+S)] t-4 Alfa C8 MW2 MZ2 \[Pi] Sqrt[S (-4 MW2+S)] t^3+Alfa C8 MZ2 \[Pi] Sqrt[S^3 (-4 MW2+S)] t^3),"Mint2tInt"->0,"SMint2t"->SeriesData[S, DirectedInfinity[1], {8 ((((Alfa C8) MZ2) Pi) t + (((Alfa C8) MZ2) Pi) t^3), 0, (-8) (((((((-2) Alfa) C8) MW2) MZ2) Pi) t + (((((6 Alfa) C8) MW2) MZ2) Pi) t^3 - MZ2 ((((Alfa C8) MZ2) Pi) t + (((Alfa C8) MZ2) Pi) t^3))}, -2, 1, 2],"SMint2tInt"->0|>;
ResultWW["O9"]["uu"]=<|"HelAmpNP"->{C9 S (-2 MW2+S) Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2],C9 MW2 S Cos[\[Theta]] Sin[\[Theta]] SUNT[Col1,Col2],(C9 MW2 S^(3/2) (1+2 Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(Sqrt[2] MW),C9 MW2 S Cos[\[Theta]] Sin[\[Theta]] SUNT[Col1,Col2],-2 C9 S (-2 MW2+S) Cos[\[Theta]/2]^3 Sin[\[Theta]/2] SUNT[Col1,Col2],(C9 MW2 S^(3/2) Cos[\[Theta]/2]^2 (-1+2 Cos[\[Theta]]) SUNT[Col1,Col2])/(Sqrt[2] MW),-((C9 MW2 S^(3/2) (1+2 Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(Sqrt[2] MW)),(C9 MW2 S^(3/2) Cos[\[Theta]/2]^2 (1-2 Cos[\[Theta]]) SUNT[Col1,Col2])/(Sqrt[2] MW),-2 C9 MW2 S (Cos[\[Theta]/2]+Cos[(3 \[Theta])/2]) Sin[\[Theta]/2] SUNT[Col1,Col2]},"HelAmpSM"->{0,(8 Alfa MZ2 \[Pi] Sqrt[1-(4 MW2)/S] Sin[\[Theta]] SUNT[Col1,Col2])/(3 MZ2-3 S),(8 Sqrt[2] Alfa MZ2 \[Pi] Sqrt[-4 MW2+S] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW MZ2-3 MW S),(8 Alfa MZ2 \[Pi] Sqrt[1-(4 MW2)/S] Sin[\[Theta]] SUNT[Col1,Col2])/(3 MZ2-3 S),0,(8 Sqrt[2] Alfa MZ2 \[Pi] Sqrt[-4 MW2+S] Cos[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW MZ2-3 MW S),(8 Alfa MZ2 \[Pi] Sqrt[-8 MW2+2 S] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(-3 MW MZ2+3 MW S),(8 Alfa MZ2 \[Pi] Sqrt[-8 MW2+2 S] Cos[\[Theta]/2]^2 SUNT[Col1,Col2])/(-3 MW MZ2+3 MW S),(4 Alfa MZ2 \[Pi] Sqrt[1-(4 MW2)/S] (2 MW2+S) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW2 (-MZ2+S))},"Mint2t"->1/(MZ2-S) 16 (4 Alfa C9 MW2 MZ2 \[Pi] Sqrt[S (-4 MW2+S)] t+Alfa C9 MZ2 \[Pi] Sqrt[S^3 (-4 MW2+S)] t-4 Alfa C9 MW2 MZ2 \[Pi] Sqrt[S (-4 MW2+S)] t^3+Alfa C9 MZ2 \[Pi] Sqrt[S^3 (-4 MW2+S)] t^3),"Mint2tInt"->0,"SMint2t"->SeriesData[S, DirectedInfinity[1], {(-16) ((((Alfa C9) MZ2) Pi) t + (((Alfa C9) MZ2) Pi) t^3), 0, 16 (((((((-2) Alfa) C9) MW2) MZ2) Pi) t + (((((6 Alfa) C9) MW2) MZ2) Pi) t^3 - MZ2 ((((Alfa C9) MZ2) Pi) t + (((Alfa C9) MZ2) Pi) t^3))}, -2, 1, 2],"SMint2tInt"->0|>;
ResultWW["O10"]["uu"]=<|"HelAmpNP"->{-2 C10 S (-2 MW2+S) Cos[\[Theta]/2]^3 Sin[\[Theta]/2] SUNT[Col1,Col2],C10 MW2 S Cos[\[Theta]] Sin[\[Theta]] SUNT[Col1,Col2],-((C10 MW2 S^(3/2) Cos[\[Theta]/2]^2 (-1+2 Cos[\[Theta]]) SUNT[Col1,Col2])/(Sqrt[2] MW)),C10 MW2 S Cos[\[Theta]] Sin[\[Theta]] SUNT[Col1,Col2],C10 S (-2 MW2+S) Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2],-((C10 MW2 S^(3/2) (1+2 Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(Sqrt[2] MW)),(C10 MW2 S^(3/2) Cos[\[Theta]/2]^2 (-1+2 Cos[\[Theta]]) SUNT[Col1,Col2])/(Sqrt[2] MW),(C10 MW2 S^(3/2) (1+2 Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(Sqrt[2] MW),-2 C10 MW2 S (Cos[\[Theta]/2]+Cos[(3 \[Theta])/2]) Sin[\[Theta]/2] SUNT[Col1,Col2]},"HelAmpSM"->{-((4 Alfa MZ2 \[Pi] S Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (8 MW2^2-8 MW2 MZ2+2 MW2 S+MZ2 S)-Sqrt[S] (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (8 MW2^2-8 MW2 MZ2+2 MW2 S+MZ2 S)-Sqrt[S] (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(4 Alfa MZ2 \[Pi] S Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((2 Sqrt[2] Alfa MZ2 \[Pi] (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(2 Sqrt[2] Alfa MZ2 \[Pi] (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(Alfa MZ2 \[Pi] (-Sqrt[-4 MW2+S] (2 MW2+S) (8 MW2^2-8 MW2 MZ2+2 MW2 S+MZ2 S)+Sqrt[S] (32 MW2^3-32 MW2^2 (MZ2-S)+MZ2 S^2+2 MW2 S (-4 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW2 (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))},"Mint2t"->(4 Alfa C10 MZ2 \[Pi] Sqrt[S] (16 MW2^2 S Sqrt[-4 MW2+S] t+16 MW2^2 S^(3/2) t^2 (-3+t^2)-32 MW2^3 Sqrt[-4 MW2+S] t (-1+t^2)+64 MW2^3 Sqrt[S] t^2 (-1+t^2)+2 MW2 S^2 Sqrt[-4 MW2+S] t (1+t^2)-4 MW2 S^(5/2) t^2 (-4+5 t^2)+3 S^(7/2) (-1+t^4)+MZ2 (32 MW2^2 Sqrt[-4 MW2+S] t (-1+t^2)-64 MW2^2 Sqrt[S] t^2 (-1+t^2)+S^2 Sqrt[-4 MW2+S] t (1+t^2)-4 MW2 S Sqrt[-4 MW2+S] t (1+3 t^2)+4 MW2 S^(3/2) t^2 (-3+8 t^2)-S^(5/2) (-3+t^2+4 t^4))))/((MW2-MZ2) (MZ2-S) (2 MW2-S+Sqrt[S (-4 MW2+S)] t)),"Mint2tInt"->-((32 Alfa C10 MZ2 \[Pi]^2 (2 Sqrt[S^5 (-4 MW2+S)]+MW2 Sqrt[S (-4 MW2+S)] (6 MW2+S)+12 MW2^3 ArcCoth[(-2 MW2+S)/Sqrt[S (-4 MW2+S)]]))/((MW2-MZ2) Sqrt[S (-4 MW2+S)])),"SMint2t"->SeriesData[S, DirectedInfinity[1], {((((((-12) Alfa) C10)/(MW2 - MZ2)) MZ2) Pi) (1 + t + t^2 + t^3), 0, (((((4 Alfa) C10)/(MW2 - MZ2)) MZ2) Pi) ((-6) MW2 - (4 MW2) t + MZ2 t + (12 MW2) t^2 + (14 MW2) t^3 + MZ2 t^3), 0, (((((4 Alfa) C10)/(MW2 - MZ2)) MZ2) Pi) ((-12) MW2^2 + (10 MW2^2) t - ((2 MW2) MZ2) t + MZ2^2 t + (6 MW2^2) t^3 - ((10 MW2) MZ2) t^3 + MZ2^2 t^3)}, -4, 1, 2],"SMint2tInt"->SeriesData[S, DirectedInfinity[1], {(((((-64) Alfa) C10)/(MW2 - MZ2)) MZ2) Pi^2, 0, ((((((-32) Alfa) C10) MW2)/(MW2 - MZ2)) MZ2) Pi^2, 0, ((((((-192) Alfa) C10) MW2^2)/(MW2 - MZ2)) MZ2) Pi^2}, -4, 1, 2]|>;
ResultWW["O10"]["dd"]=<|"HelAmpNP"->{-2 C10 S (-2 MW2+S) Cos[\[Theta]/2]^3 Sin[\[Theta]/2] SUNT[Col1,Col2],C10 MW2 S Cos[\[Theta]] Sin[\[Theta]] SUNT[Col1,Col2],-((C10 MW2 S^(3/2) Cos[\[Theta]/2]^2 (-1+2 Cos[\[Theta]]) SUNT[Col1,Col2])/(Sqrt[2] MW)),C10 MW2 S Cos[\[Theta]] Sin[\[Theta]] SUNT[Col1,Col2],C10 S (-2 MW2+S) Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2],-((C10 MW2 S^(3/2) (1+2 Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(Sqrt[2] MW)),(C10 MW2 S^(3/2) Cos[\[Theta]/2]^2 (-1+2 Cos[\[Theta]]) SUNT[Col1,Col2])/(Sqrt[2] MW),(C10 MW2 S^(3/2) (1+2 Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(Sqrt[2] MW),-2 C10 MW2 S (Cos[\[Theta]/2]+Cos[(3 \[Theta])/2]) Sin[\[Theta]/2] SUNT[Col1,Col2]},"HelAmpSM"->{(4 Alfa MZ2 \[Pi] S Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (-4 MW2^2+4 MW2 (MZ2-S)+MZ2 S)-Sqrt[S] (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (-4 MW2^2+4 MW2 (MZ2-S)+MZ2 S)-Sqrt[S] (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((4 Alfa MZ2 \[Pi] S Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((2 Sqrt[2] Alfa MZ2 \[Pi] (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(2 Sqrt[2] Alfa MZ2 \[Pi] (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (2 MW2+S) (4 MW2^2-4 MW2 MZ2+4 MW2 S-MZ2 S)+Sqrt[S] (16 MW2^3-4 MW2^2 (4 MZ2-7 S)-MZ2 S^2+4 MW2 S (-MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW2 (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])))},"Mint2t"->-((4 Alfa C10 MZ2 \[Pi] Sqrt[S] (2 MW2 S^(5/2) t^2 (7-11 t^2)+16 MW2^3 Sqrt[-4 MW2+S] t (-1+t^2)+32 MW2^3 Sqrt[S] t^2 (-1+t^2)-4 MW2 S^2 Sqrt[-4 MW2+S] t (1+t^2)+16 MW2^2 S^(3/2) t^2 (-3+2 t^2)+4 MW2^2 S Sqrt[-4 MW2+S] t (-5+3 t^2)+3 S^(7/2) (-1+t^4)+MZ2 (8 MW2 S Sqrt[-4 MW2+S] t-16 MW2^2 Sqrt[-4 MW2+S] t (-1+t^2)-32 MW2^2 Sqrt[S] t^2 (-1+t^2)+S^2 Sqrt[-4 MW2+S] t (1+t^2)+4 MW2 S^(3/2) t^2 (-3+4 t^2)+S^(5/2) (3+t^2-2 t^4))))/((MW2-MZ2) (MZ2-S) (-2 MW2+S+Sqrt[S (-4 MW2+S)] t))),"Mint2tInt"->-((32 Alfa C10 MZ2 \[Pi]^2 (2 Sqrt[S^5 (-4 MW2+S)]+MW2 Sqrt[S (-4 MW2+S)] (6 MW2+S)+12 MW2^3 ArcCoth[(-2 MW2+S)/Sqrt[S (-4 MW2+S)]]))/((MW2-MZ2) Sqrt[S (-4 MW2+S)])),"SMint2t"->SeriesData[S, DirectedInfinity[1], {((((((12 Alfa) C10)/(MW2 - MZ2)) MZ2) Pi)/(1 + t)) (-1 + t^4), 0, ((((((-4) Alfa) C10)/(MW2 - MZ2)) MZ2) Pi) (6 MW2 - (2 MW2) t - MZ2 t - (12 MW2) t^2 + (16 MW2) t^3 - MZ2 t^3), 0, (((((4 Alfa) C10)/(MW2 - MZ2)) MZ2) Pi) ((-12) MW2^2 - (14 MW2^2) t + ((4 MW2) MZ2) t + MZ2^2 t + (6 MW2^2) t^3 - ((4 MW2) MZ2) t^3 + MZ2^2 t^3)}, -4, 1, 2],"SMint2tInt"->SeriesData[S, DirectedInfinity[1], {(((((-64) Alfa) C10)/(MW2 - MZ2)) MZ2) Pi^2, 0, ((((((-32) Alfa) C10) MW2)/(MW2 - MZ2)) MZ2) Pi^2, 0, ((((((-192) Alfa) C10) MW2^2)/(MW2 - MZ2)) MZ2) Pi^2}, -4, 1, 2]|>;
ResultWW["O11"]["uu"]=<|"HelAmpNP"->{0,1/4 I C11 (2 MW2-S) S Sin[\[Theta]] SUNT[Col1,Col2],(I C11 MW2 S^(3/2) Cos[\[Theta]/2]^2 SUNT[Col1,Col2])/(2 Sqrt[2] MW),-(1/4) I C11 (2 MW2-S) S Sin[\[Theta]] SUNT[Col1,Col2],0,-((I C11 MW2 S^(3/2) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(2 Sqrt[2] MW)),(I C11 MW2 S^(3/2) Cos[\[Theta]/2]^2 SUNT[Col1,Col2])/(2 Sqrt[2] MW),-((I C11 MW2 S^(3/2) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(2 Sqrt[2] MW)),0},"HelAmpSM"->{-((4 Alfa MZ2 \[Pi] S Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Alfa \[Pi] (Sqrt[-4 MW2+S] (8 MW2^2 (MZ2-I MZ \[CapitalGamma]Z)+MZ2 S (MZ2-I MZ \[CapitalGamma]Z)+MW2 (-8 MZ2^2+2 MZ2 S+8 I MZ MZ2 \[CapitalGamma]Z+4 I MZ S \[CapitalGamma]Z))-Sqrt[S] (16 MW2^2 (MZ2-I MZ \[CapitalGamma]Z)+MZ2 S (MZ2-I MZ \[CapitalGamma]Z)+MW2 (-16 MZ2^2+4 I MZ S \[CapitalGamma]Z+8 MZ2 (S+2 I MZ \[CapitalGamma]Z))) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) Sqrt[S] (MZ2-S-I MZ \[CapitalGamma]Z) (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 ((4 (MW2-MZ2) Sqrt[-4 MW2+S])/MZ2+((4 MW2-MZ2) S Sqrt[-4 MW2+S])/(MZ2 (MZ2-S-I MZ \[CapitalGamma]Z))-(3 Sqrt[S] (-2 MW2-Sqrt[S (-4 MW2+S)]+S Cos[\[Theta]]))/(-2 MW2+S-Sqrt[S (-4 MW2+S)] Cos[\[Theta]])) SUNT[Col1,Col2])/(3 MW (MW2-MZ2))),(2 Alfa \[Pi] (Sqrt[-4 MW2+S] (8 MW2^2 (MZ2-I MZ \[CapitalGamma]Z)+MZ2 S (MZ2-I MZ \[CapitalGamma]Z)+MW2 (-8 MZ2^2+2 MZ2 S+8 I MZ MZ2 \[CapitalGamma]Z+4 I MZ S \[CapitalGamma]Z))-Sqrt[S] (16 MW2^2 (MZ2-I MZ \[CapitalGamma]Z)+MZ2 S (MZ2-I MZ \[CapitalGamma]Z)+MW2 (-16 MZ2^2+4 I MZ S \[CapitalGamma]Z+8 MZ2 (S+2 I MZ \[CapitalGamma]Z))) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) Sqrt[S] (MZ2-S-I MZ \[CapitalGamma]Z) (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(4 Alfa MZ2 \[Pi] S Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((2 Sqrt[2] Alfa MZ2 \[Pi] ((4 (MW2-MZ2) Sqrt[-4 MW2+S])/MZ2+((4 MW2-MZ2) S Sqrt[-4 MW2+S])/(MZ2 (MZ2-S-I MZ \[CapitalGamma]Z))-(3 Sqrt[S] (2 MW2-Sqrt[S (-4 MW2+S)]+S Cos[\[Theta]]))/(-2 MW2+S-Sqrt[S (-4 MW2+S)] Cos[\[Theta]])) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2))),-((2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (-((4 (MW2-MZ2) Sqrt[-4 MW2+S])/MZ2)-((4 MW2-MZ2) S Sqrt[-4 MW2+S])/(MZ2 (MZ2-S-I MZ \[CapitalGamma]Z))+(3 Sqrt[S] (-2 MW2-Sqrt[S (-4 MW2+S)]+S Cos[\[Theta]]))/(-2 MW2+S-Sqrt[S (-4 MW2+S)] Cos[\[Theta]])) SUNT[Col1,Col2])/(3 MW (MW2-MZ2))),-((2 Sqrt[2] Alfa MZ2 \[Pi] (-((4 (MW2-MZ2) Sqrt[-4 MW2+S])/MZ2)-((4 MW2-MZ2) S Sqrt[-4 MW2+S])/(MZ2 (MZ2-S-I MZ \[CapitalGamma]Z))+(3 Sqrt[S] (2 MW2-Sqrt[S (-4 MW2+S)]+S Cos[\[Theta]]))/(-2 MW2+S-Sqrt[S (-4 MW2+S)] Cos[\[Theta]])) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2))),(Alfa \[Pi] (-Sqrt[-4 MW2+S] (2 MW2+S) (8 MW2^2 (MZ2-I MZ \[CapitalGamma]Z)+MZ2 S (MZ2-I MZ \[CapitalGamma]Z)+MW2 (-8 MZ2^2+4 I MZ S \[CapitalGamma]Z+2 MZ2 (S+4 I MZ \[CapitalGamma]Z)))+Sqrt[S] (32 MW2^3 (MZ2-I MZ \[CapitalGamma]Z)+MZ2 S^2 (MZ2-I MZ \[CapitalGamma]Z)-8 MW2^2 (4 MZ2^2+I MZ S \[CapitalGamma]Z-4 MZ2 (S+I MZ \[CapitalGamma]Z))+2 MW2 S (-4 MZ2^2+2 I MZ S \[CapitalGamma]Z+MZ2 (S+4 I MZ \[CapitalGamma]Z))) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW2 (MW2-MZ2) Sqrt[S] (MZ2-S-I MZ \[CapitalGamma]Z) (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))},"Mint2t"->0,"Mint2tInt"->0,"SMint2t"->0,"SMint2tInt"->0|>;
ResultWW["O11"]["dd"]=<|"HelAmpNP"->{0,-(1/4) I C11 (2 MW2-S) S Sin[\[Theta]] SUNT[Col1,Col2],-((I C11 MW2 S^(3/2) Cos[\[Theta]/2]^2 SUNT[Col1,Col2])/(2 Sqrt[2] MW)),1/4 I C11 (2 MW2-S) S Sin[\[Theta]] SUNT[Col1,Col2],0,(I C11 MW2 S^(3/2) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(2 Sqrt[2] MW),-((I C11 MW2 S^(3/2) Cos[\[Theta]/2]^2 SUNT[Col1,Col2])/(2 Sqrt[2] MW)),(I C11 MW2 S^(3/2) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(2 Sqrt[2] MW),0},"HelAmpSM"->{(4 Alfa MZ2 \[Pi] S Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(2 Alfa \[Pi] (Sqrt[-4 MW2+S] (4 MW2^2 (MZ2-I MZ \[CapitalGamma]Z)-MZ2 S (MZ2-I MZ \[CapitalGamma]Z)+MW2 (-4 MZ2^2+4 MZ2 S+4 I MZ MZ2 \[CapitalGamma]Z+2 I MZ S \[CapitalGamma]Z))+Sqrt[S] (8 MW2^2 (MZ2-I MZ \[CapitalGamma]Z)-MZ2 S (MZ2-I MZ \[CapitalGamma]Z)+MW2 (-8 MZ2^2+10 MZ2 S+8 I MZ MZ2 \[CapitalGamma]Z+2 I MZ S \[CapitalGamma]Z)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) Sqrt[S] (MZ2-S-I MZ \[CapitalGamma]Z) (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (-((2 (MW2-MZ2) Sqrt[-4 MW2+S])/MZ2)-((2 MW2+MZ2) S Sqrt[-4 MW2+S])/(MZ2 (MZ2-S-I MZ \[CapitalGamma]Z))-(3 Sqrt[S] (-2 MW2+Sqrt[S (-4 MW2+S)]+S Cos[\[Theta]]))/(-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])) SUNT[Col1,Col2])/(3 MW (MW2-MZ2))),(2 Alfa \[Pi] (Sqrt[-4 MW2+S] (4 MW2^2 (MZ2-I MZ \[CapitalGamma]Z)-MZ2 S (MZ2-I MZ \[CapitalGamma]Z)+MW2 (-4 MZ2^2+4 MZ2 S+4 I MZ MZ2 \[CapitalGamma]Z+2 I MZ S \[CapitalGamma]Z))+Sqrt[S] (8 MW2^2 (MZ2-I MZ \[CapitalGamma]Z)-MZ2 S (MZ2-I MZ \[CapitalGamma]Z)+MW2 (-8 MZ2^2+10 MZ2 S+8 I MZ MZ2 \[CapitalGamma]Z+2 I MZ S \[CapitalGamma]Z)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) Sqrt[S] (MZ2-S-I MZ \[CapitalGamma]Z) (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((4 Alfa MZ2 \[Pi] S Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((2 Sqrt[2] Alfa MZ2 \[Pi] (-((2 (MW2-MZ2) Sqrt[-4 MW2+S])/MZ2)-((2 MW2+MZ2) S Sqrt[-4 MW2+S])/(MZ2 (MZ2-S-I MZ \[CapitalGamma]Z))-(3 Sqrt[S] (2 MW2+Sqrt[S (-4 MW2+S)]+S Cos[\[Theta]]))/(-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2))),-((2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 ((2 (MW2-MZ2) Sqrt[-4 MW2+S])/MZ2+((2 MW2+MZ2) S Sqrt[-4 MW2+S])/(MZ2 (MZ2-S-I MZ \[CapitalGamma]Z))+(3 Sqrt[S] (-2 MW2+Sqrt[S (-4 MW2+S)]+S Cos[\[Theta]]))/(-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])) SUNT[Col1,Col2])/(3 MW (MW2-MZ2))),-((2 Sqrt[2] Alfa MZ2 \[Pi] ((2 (MW2-MZ2) Sqrt[-4 MW2+S])/MZ2+((2 MW2+MZ2) S Sqrt[-4 MW2+S])/(MZ2 (MZ2-S-I MZ \[CapitalGamma]Z))+(3 Sqrt[S] (2 MW2+Sqrt[S (-4 MW2+S)]+S Cos[\[Theta]]))/(-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2))),-((Alfa \[Pi] (Sqrt[-4 MW2+S] (2 MW2+S) (4 MW2^2 (MZ2-I MZ \[CapitalGamma]Z)-MZ2 S (MZ2-I MZ \[CapitalGamma]Z)+MW2 (-4 MZ2^2+2 I MZ S \[CapitalGamma]Z+4 MZ2 (S+I MZ \[CapitalGamma]Z)))+Sqrt[S] (16 MW2^3 (MZ2-I MZ \[CapitalGamma]Z)-MZ2 S^2 (MZ2-I MZ \[CapitalGamma]Z)-4 MW2^2 (4 MZ2^2-7 MZ2 S-4 I MZ MZ2 \[CapitalGamma]Z+I MZ S \[CapitalGamma]Z)+2 MW2 S (-2 MZ2^2+I MZ S \[CapitalGamma]Z+2 MZ2 (S+I MZ \[CapitalGamma]Z))) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW2 (MW2-MZ2) Sqrt[S] (MZ2-S-I MZ \[CapitalGamma]Z) (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])))},"Mint2t"->0,"Mint2tInt"->0,"SMint2t"->0,"SMint2tInt"->0|>;
ResultWW["O12"]["uu"]=<|"HelAmpNP"->{1/2 C12 Sqrt[S^3 (-4 MW2+S)] Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2],1/4 C12 Sqrt[S^3 (-4 MW2+S)] Sin[\[Theta]] SUNT[Col1,Col2],-((C12 MW2 S Sqrt[-4 MW2+S] Sin[\[Theta]]^2 SUNT[Col1,Col2])/(2 Sqrt[2] MW)),1/4 C12 Sqrt[S^3 (-4 MW2+S)] Sin[\[Theta]] SUNT[Col1,Col2],1/2 C12 Sqrt[S^3 (-4 MW2+S)] Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2],-((C12 MW2 S Sqrt[-4 MW2+S] Sin[\[Theta]]^2 SUNT[Col1,Col2])/(2 Sqrt[2] MW)),(C12 MW2 S Sqrt[-4 MW2+S] Sin[\[Theta]]^2 SUNT[Col1,Col2])/(2 Sqrt[2] MW),(C12 MW2 S Sqrt[-4 MW2+S] Sin[\[Theta]]^2 SUNT[Col1,Col2])/(2 Sqrt[2] MW),0},"HelAmpSM"->{-((4 Alfa MZ2 \[Pi] S Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (8 MW2^2-8 MW2 MZ2+2 MW2 S+MZ2 S)-Sqrt[S] (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (8 MW2^2-8 MW2 MZ2+2 MW2 S+MZ2 S)-Sqrt[S] (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(4 Alfa MZ2 \[Pi] S Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((2 Sqrt[2] Alfa MZ2 \[Pi] (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(2 Sqrt[2] Alfa MZ2 \[Pi] (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(Alfa MZ2 \[Pi] (-Sqrt[-4 MW2+S] (2 MW2+S) (8 MW2^2-8 MW2 MZ2+2 MW2 S+MZ2 S)+Sqrt[S] (32 MW2^3-32 MW2^2 (MZ2-S)+MZ2 S^2+2 MW2 S (-4 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW2 (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))},"Mint2t"->(6 Alfa C12 MZ2 \[Pi] (-1+t^2) (32 MW2^3 S-MZ2 S^3+3 MZ2 Sqrt[S^5 (-4 MW2+S)] t-2 Sqrt[S^7 (-4 MW2+S)] t+16 MW2^2 S (-2 MZ2+Sqrt[S (-4 MW2+S)] t)+MW2 (-2 S^3+4 Sqrt[S^5 (-4 MW2+S)] t+12 MZ2 S (S-Sqrt[S (-4 MW2+S)] t))))/((MW2-MZ2) (MZ2-S) (2 MW2-S+Sqrt[S (-4 MW2+S)] t)),"Mint2tInt"->1/((MW2-MZ2) (MZ2-S) (S (-4 MW2+S))^(5/2)) 16 Alfa C12 MZ2 \[Pi]^2 (4 MW2-S) S^2 (-(4 MW2-S) Sqrt[S (-4 MW2+S)] (S^3+MW2 S (-9 MZ2+S)+2 MW2^2 (3 MZ2+5 S))+6 MW2^2 (MZ2-S) (4 MW2^2+3 MW2 S-S^2) Log[-2 MW2+S-Sqrt[S (-4 MW2+S)]]-6 MW2^2 (MZ2-S) (4 MW2^2+3 MW2 S-S^2) Log[-2 MW2+S+Sqrt[S (-4 MW2+S)]]),"SMint2t"->SeriesData[S, DirectedInfinity[1], {((((((12 Alfa) C12)/(MW2 - MZ2)) MZ2) Pi) t) (1 + t), 0, (((((((-6) Alfa) C12)/(MW2 - MZ2)) MZ2) Pi) (1 + t)) ((-2) MW2 - MZ2 + (4 MW2) t + MZ2 t), 0, ((((((((-6) Alfa) C12)/(MW2 - MZ2)) MZ2) Pi)/(-1 + t)) (1 + t)) (4 MW2^2 - (8 MW2) MZ2 + MZ2^2 - (24 MW2^2) t + ((16 MW2) MZ2) t - (2 MZ2^2) t + (16 MW2^2) t^2 - ((8 MW2) MZ2) t^2 + MZ2^2 t^2)}, -4, 1, 2],"SMint2tInt"->SeriesData[S, DirectedInfinity[1], {((((16 Alfa) C12)/(MW2 - MZ2)) MZ2) Pi^2, (((((16 Alfa) C12)/(MW2 - MZ2)) MZ2) (MW2 + MZ2)) Pi^2, (((((16 Alfa) C12)/(MW2 - MZ2)) MZ2) Pi^2) (10 MW2^2 - (8 MW2) MZ2 + MZ2^2 + (12 MW2^2) Log[MW2] - (12 MW2^2) Log[S])}, -2, 1, 1]|>;
ResultWW["O12"]["dd"]=<|"HelAmpNP"->{-(1/2) C12 Sqrt[S^3 (-4 MW2+S)] Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2],-(1/4) C12 Sqrt[S^3 (-4 MW2+S)] Sin[\[Theta]] SUNT[Col1,Col2],(C12 MW2 S Sqrt[-4 MW2+S] Sin[\[Theta]]^2 SUNT[Col1,Col2])/(2 Sqrt[2] MW),-(1/4) C12 Sqrt[S^3 (-4 MW2+S)] Sin[\[Theta]] SUNT[Col1,Col2],-(1/2) C12 Sqrt[S^3 (-4 MW2+S)] Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2],(C12 MW2 S Sqrt[-4 MW2+S] Sin[\[Theta]]^2 SUNT[Col1,Col2])/(2 Sqrt[2] MW),-((C12 MW2 S Sqrt[-4 MW2+S] Sin[\[Theta]]^2 SUNT[Col1,Col2])/(2 Sqrt[2] MW)),-((C12 MW2 S Sqrt[-4 MW2+S] Sin[\[Theta]]^2 SUNT[Col1,Col2])/(2 Sqrt[2] MW)),0},"HelAmpSM"->{(4 Alfa MZ2 \[Pi] S Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (-4 MW2^2+4 MW2 (MZ2-S)+MZ2 S)-Sqrt[S] (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (-4 MW2^2+4 MW2 (MZ2-S)+MZ2 S)-Sqrt[S] (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((4 Alfa MZ2 \[Pi] S Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((2 Sqrt[2] Alfa MZ2 \[Pi] (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(2 Sqrt[2] Alfa MZ2 \[Pi] (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (2 MW2+S) (4 MW2^2-4 MW2 MZ2+4 MW2 S-MZ2 S)+Sqrt[S] (16 MW2^3-4 MW2^2 (4 MZ2-7 S)-MZ2 S^2+4 MW2 S (-MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW2 (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])))},"Mint2t"->-((6 Alfa C12 MZ2 \[Pi] (-1+t^2) (16 MW2^3 S+2 Sqrt[S^7 (-4 MW2+S)] t+MW2^2 (-16 MZ2 S+12 S^2-8 Sqrt[S^3 (-4 MW2+S)] t)+MW2 (-4 S^3+4 MZ2 Sqrt[S^3 (-4 MW2+S)] t-6 Sqrt[S^5 (-4 MW2+S)] t)+MZ2 (S^3-Sqrt[S^5 (-4 MW2+S)] t)))/((MW2-MZ2) (MZ2-S) (-2 MW2+S+Sqrt[S (-4 MW2+S)] t))),"Mint2tInt"->-((16 Alfa C12 MZ2 \[Pi]^2 (24 MW2^3 MZ2 Sqrt[S]+8 MW2^3 S^(3/2)-10 MW2^2 MZ2 S^(3/2)+10 MW2^2 S^(5/2)-7 MW2 MZ2 S^(5/2)+MW2 S^(7/2)+2 MZ2 S^(7/2)-S^(9/2)-6 MW2^2 Sqrt[-4 MW2+S] (MW2+S) (-MZ2+S) ArcTanh[Sqrt[S (-4 MW2+S)]/(2 MW2-S)]-3 MW2^2 Sqrt[-4 MW2+S] (MW2+S) (-MZ2+S) Log[-2 MW2+S-Sqrt[S (-4 MW2+S)]]-3 MW2^3 MZ2 Sqrt[-4 MW2+S] Log[-2 MW2+S+Sqrt[S (-4 MW2+S)]]+3 MW2^3 S Sqrt[-4 MW2+S] Log[-2 MW2+S+Sqrt[S (-4 MW2+S)]]-3 MW2^2 MZ2 S Sqrt[-4 MW2+S] Log[-2 MW2+S+Sqrt[S (-4 MW2+S)]]+3 MW2^2 S^2 Sqrt[-4 MW2+S] Log[-2 MW2+S+Sqrt[S (-4 MW2+S)]]))/((MW2-MZ2) (4 MW2-S) (MZ2-S) Sqrt[S])),"SMint2t"->SeriesData[S, DirectedInfinity[1], {((((((12 Alfa) C12)/(MW2 - MZ2)) MZ2) Pi) (-1 + t)) t, 0, (((((((-6) Alfa) C12)/(MW2 - MZ2)) MZ2) Pi) (-1 + t)) (4 MW2 - MZ2 + (6 MW2) t - MZ2 t), 0, ((((((((-6) Alfa) C12)/(MW2 - MZ2)) MZ2) Pi) (-1 + t))/(1 + t)) ((-4) MW2^2 + (2 MW2) MZ2 - MZ2^2 + (8 MW2^2) t + ((4 MW2) MZ2) t - (2 MZ2^2) t + (8 MW2^2) t^2 + ((2 MW2) MZ2) t^2 - MZ2^2 t^2)}, -4, 1, 2],"SMint2tInt"->SeriesData[S, DirectedInfinity[1], {((((16 Alfa) C12)/(MW2 - MZ2)) MZ2) Pi^2, 0, (((((16 Alfa) C12)/(MW2 - MZ2)) (3 MW2 - MZ2)) MZ2) Pi^2, 0, (((((16 Alfa) C12)/(MW2 - MZ2)) MZ2) Pi^2) (2 MW2^2 + (2 MW2) MZ2 - MZ2^2 + (12 MW2^2) Log[MW2] - (12 MW2^2) Log[S])}, -4, 1, 2]|>;
ResultWW["O13"]["uu"]=<|"HelAmpNP"->{-(1/2) C13 Sqrt[S^3 (-4 MW2+S)] Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2],1/4 C13 Sqrt[S^3 (-4 MW2+S)] Sin[\[Theta]] SUNT[Col1,Col2],-((C13 MW2 S Sqrt[-4 MW2+S] Cos[\[Theta]/2]^2 Cos[\[Theta]] SUNT[Col1,Col2])/(Sqrt[2] MW)),1/4 C13 Sqrt[S^3 (-4 MW2+S)] Sin[\[Theta]] SUNT[Col1,Col2],-(1/2) C13 Sqrt[S^3 (-4 MW2+S)] Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2],(C13 MW2 S Sqrt[-4 MW2+S] Cos[\[Theta]] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(Sqrt[2] MW),(C13 MW2 S Sqrt[-4 MW2+S] Cos[\[Theta]/2]^2 Cos[\[Theta]] SUNT[Col1,Col2])/(Sqrt[2] MW),-((C13 MW2 S Sqrt[-4 MW2+S] Cos[\[Theta]] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(Sqrt[2] MW)),0},"HelAmpSM"->{-((4 Alfa MZ2 \[Pi] S Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (8 MW2^2-8 MW2 MZ2+2 MW2 S+MZ2 S)-Sqrt[S] (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (8 MW2^2-8 MW2 MZ2+2 MW2 S+MZ2 S)-Sqrt[S] (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(4 Alfa MZ2 \[Pi] S Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((2 Sqrt[2] Alfa MZ2 \[Pi] (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(2 Sqrt[2] Alfa MZ2 \[Pi] (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(Alfa MZ2 \[Pi] (-Sqrt[-4 MW2+S] (2 MW2+S) (8 MW2^2-8 MW2 MZ2+2 MW2 S+MZ2 S)+Sqrt[S] (32 MW2^3-32 MW2^2 (MZ2-S)+MZ2 S^2+2 MW2 S (-4 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW2 (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))},"Mint2t"->(2 Alfa C13 MZ2 \[Pi] (MZ2 Sqrt[S^5 (-4 MW2+S)] t (5-9 t^2)+6 Sqrt[S^7 (-4 MW2+S)] t (-1+t^2)+MZ2 S^3 (1+3 t^2)+16 MW2^2 S (2 MZ2-Sqrt[S (-4 MW2+S)] t) (1+3 t^2)-32 MW2^3 (S+3 S t^2)+2 MW2 (2 Sqrt[S^5 (-4 MW2+S)] t (1-3 t^2)+S^3 (1+3 t^2)-2 MZ2 S (-Sqrt[S (-4 MW2+S)] t (1+9 t^2)+S (3+9 t^2)))))/((MW2-MZ2) (MZ2-S) (2 MW2-S+Sqrt[S (-4 MW2+S)] t)),"Mint2tInt"->-((16 Alfa C13 MZ2 \[Pi]^2 (4 MW2-S) S^2 ((4 MW2-S) Sqrt[S (-4 MW2+S)] ((2 MZ2-S) S^2+MW2 S (-11 MZ2+3 S)+MW2^2 (-6 MZ2+22 S))+6 MW2^2 (MZ2-S) (4 MW2^2-5 MW2 S+S^2) Log[-2 MW2+S-Sqrt[S (-4 MW2+S)]]-6 MW2^2 (MZ2-S) (4 MW2^2-5 MW2 S+S^2) Log[-2 MW2+S+Sqrt[S (-4 MW2+S)]]))/((MW2-MZ2) (MZ2-S) (S (-4 MW2+S))^(5/2))),"SMint2t"->SeriesData[S, DirectedInfinity[1], {(((((((-12) Alfa) C13)/(MW2 - MZ2)) MZ2) Pi) t) (1 + t), 0, (((((2 Alfa) C13)/(MW2 - MZ2)) MZ2) Pi) (2 MW2 + MZ2 + (6 MW2) t + (12 MW2) t^2 + (3 MZ2) t^2), 0, ((((((2 Alfa) C13)/(MW2 - MZ2)) MZ2) Pi)/(-1 + t)) ((-4) MW2^2 + (8 MW2) MZ2 - MZ2^2 + (4 MW2^2) t - ((8 MW2) MZ2) t + MZ2^2 t - (24 MW2^2) t^2 + ((24 MW2) MZ2) t^2 - (3 MZ2^2) t^2 + (48 MW2^2) t^3 - ((24 MW2) MZ2) t^3 + (3 MZ2^2) t^3)}, -4, 1, 2],"SMint2tInt"->SeriesData[S, DirectedInfinity[1], {(((((-16) Alfa) C13)/(MW2 - MZ2)) MZ2) Pi^2, (((((16 Alfa) C13)/(MW2 - MZ2)) MZ2) (3 MW2 + MZ2)) Pi^2, (((((16 Alfa) C13)/(MW2 - MZ2)) MZ2) Pi^2) (22 MW2^2 - (8 MW2) MZ2 + MZ2^2 + (12 MW2^2) Log[MW2] - (12 MW2^2) Log[S])}, -2, 1, 1]|>;
ResultWW["O13"]["dd"]=<|"HelAmpNP"->{1/2 C13 Sqrt[S^3 (-4 MW2+S)] Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2],-(1/4) C13 Sqrt[S^3 (-4 MW2+S)] Sin[\[Theta]] SUNT[Col1,Col2],(C13 MW2 S Sqrt[-4 MW2+S] Cos[\[Theta]/2]^2 Cos[\[Theta]] SUNT[Col1,Col2])/(Sqrt[2] MW),-(1/4) C13 Sqrt[S^3 (-4 MW2+S)] Sin[\[Theta]] SUNT[Col1,Col2],1/2 C13 Sqrt[S^3 (-4 MW2+S)] Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2],-((C13 MW2 S Sqrt[-4 MW2+S] Cos[\[Theta]] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(Sqrt[2] MW)),-((C13 MW2 S Sqrt[-4 MW2+S] Cos[\[Theta]/2]^2 Cos[\[Theta]] SUNT[Col1,Col2])/(Sqrt[2] MW)),(C13 MW2 S Sqrt[-4 MW2+S] Cos[\[Theta]] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(Sqrt[2] MW),0},"HelAmpSM"->{(4 Alfa MZ2 \[Pi] S Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (-4 MW2^2+4 MW2 (MZ2-S)+MZ2 S)-Sqrt[S] (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (-4 MW2^2+4 MW2 (MZ2-S)+MZ2 S)-Sqrt[S] (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((4 Alfa MZ2 \[Pi] S Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((2 Sqrt[2] Alfa MZ2 \[Pi] (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(2 Sqrt[2] Alfa MZ2 \[Pi] (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (2 MW2+S) (4 MW2^2-4 MW2 MZ2+4 MW2 S-MZ2 S)+Sqrt[S] (16 MW2^3-4 MW2^2 (4 MZ2-7 S)-MZ2 S^2+4 MW2 S (-MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW2 (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])))},"Mint2t"->(2 Alfa C13 MZ2 \[Pi] S (MZ2 Sqrt[S^3 (-4 MW2+S)] t (7-3 t^2)+6 Sqrt[S^5 (-4 MW2+S)] t (-1+t^2)+16 MW2^3 (1+3 t^2)+MZ2 S^2 (1+3 t^2)-4 MW2^2 (4 MZ2-3 S+2 Sqrt[S (-4 MW2+S)] t) (1+3 t^2)-2 MW2 (2 MZ2 Sqrt[S (-4 MW2+S)] t (1-3 t^2)+S^2 (2+6 t^2)+Sqrt[S^3 (-4 MW2+S)] t (-1+9 t^2))))/((MW2-MZ2) (MZ2-S) (-2 MW2+S+Sqrt[S (-4 MW2+S)] t)),"Mint2tInt"->-((16 Alfa C13 MZ2 \[Pi]^2 (4 MW2-S) S^2 (Sqrt[S (-4 MW2+S)] (3 MW2 MZ2-7 MW2 S+S^2) (-8 MW2^2-2 MW2 S+S^2)+6 MW2^2 (MZ2-S) (4 MW2^2-5 MW2 S+S^2) Log[-2 MW2+S-Sqrt[S (-4 MW2+S)]]-6 MW2^2 (MZ2-S) (4 MW2^2-5 MW2 S+S^2) Log[-2 MW2+S+Sqrt[S (-4 MW2+S)]]))/((MW2-MZ2) (MZ2-S) (S (-4 MW2+S))^(5/2))),"SMint2t"->SeriesData[S, DirectedInfinity[1], {(((((((-12) Alfa) C13)/(MW2 - MZ2)) MZ2) Pi) (-1 + t)) t, 0, (((((2 Alfa) C13)/(MW2 - MZ2)) MZ2) Pi) (4 MW2 - MZ2 - (6 MW2) t + (18 MW2) t^2 - (3 MZ2) t^2), 0, ((((((2 Alfa) C13)/(MW2 - MZ2)) MZ2) Pi)/(1 + t)) ((-4) MW2^2 + (2 MW2) MZ2 - MZ2^2 - (4 MW2^2) t + ((2 MW2) MZ2) t - MZ2^2 t + ((6 MW2) MZ2) t^2 - (3 MZ2^2) t^2 + (24 MW2^2) t^3 + ((6 MW2) MZ2) t^3 - (3 MZ2^2) t^3)}, -4, 1, 2],"SMint2tInt"->SeriesData[S, DirectedInfinity[1], {(((((-16) Alfa) C13)/(MW2 - MZ2)) MZ2) Pi^2, (((((16 Alfa) C13)/(MW2 - MZ2)) (5 MW2 - MZ2)) MZ2) Pi^2, (((((16 Alfa) C13)/(MW2 - MZ2)) MZ2) Pi^2) (14 MW2^2 + (2 MW2) MZ2 - MZ2^2 + (12 MW2^2) Log[MW2] - (12 MW2^2) Log[S])}, -2, 1, 1]|>;


(* ::Input::Initialization:: *)
ResultWW["O14"]["uu"]=<|"HelAmpNP"->{-((Alfa C14 MZ2 \[Pi] S vev^2 Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(MW2-MZ2)),(Alfa C14 MZ2 \[Pi] S vev^2 Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(MW2-MZ2),(Alfa C14 MZ2 \[Pi] S^(3/2) vev^2 Cos[\[Theta]] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(Sqrt[2] (-MW MW2+MW MZ2)),-((Alfa C14 MZ2 \[Pi] S vev^2 Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(MW2-MZ2)),(Alfa C14 MZ2 \[Pi] S vev^2 Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(MW2-MZ2),(Alfa C14 MZ2 \[Pi] S^(3/2) vev^2 Cos[\[Theta]/2]^2 Cos[\[Theta]] SUNT[Col1,Col2])/(Sqrt[2] (-MW MW2+MW MZ2)),(Alfa C14 MZ2 \[Pi] S^(3/2) vev^2 Sin[\[Theta]]^2 SUNT[Col1,Col2])/(Sqrt[2] (2 MW MW2-2 MW MZ2)),-((Alfa C14 MZ2 \[Pi] S^(3/2) vev^2 Sin[\[Theta]]^2 SUNT[Col1,Col2])/(Sqrt[2] (2 MW MW2-2 MW MZ2))),(Alfa C14 MZ2 \[Pi] S^2 vev^2 Cos[\[Theta]] Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW2^2-4 MW2 MZ2)},"HelAmpSM"->{0,(8 Alfa MZ2 \[Pi] Sqrt[1-(4 MW2)/S] Sin[\[Theta]] SUNT[Col1,Col2])/(3 MZ2-3 S),(8 Sqrt[2] Alfa MZ2 \[Pi] Sqrt[-4 MW2+S] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW MZ2-3 MW S),(8 Alfa MZ2 \[Pi] Sqrt[1-(4 MW2)/S] Sin[\[Theta]] SUNT[Col1,Col2])/(3 MZ2-3 S),0,(8 Sqrt[2] Alfa MZ2 \[Pi] Sqrt[-4 MW2+S] Cos[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW MZ2-3 MW S),(8 Alfa MZ2 \[Pi] Sqrt[-8 MW2+2 S] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(-3 MW MZ2+3 MW S),(8 Alfa MZ2 \[Pi] Sqrt[-8 MW2+2 S] Cos[\[Theta]/2]^2 SUNT[Col1,Col2])/(-3 MW MZ2+3 MW S),(4 Alfa MZ2 \[Pi] Sqrt[1-(4 MW2)/S] (2 MW2+S) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW2 (-MZ2+S))},"Mint2t"->1/(MW2^2 (MW2-MZ2) (MZ2-S)^2) 2 Alfa2 C14 MZ2^2 \[Pi]^2 t (-8 MW2^2 (-MZ2 Sqrt[S (-4 MW2+S)]+Sqrt[S^3 (-4 MW2+S)]) (-1+t^2)-(-MZ2 Sqrt[S^5 (-4 MW2+S)]+Sqrt[S^7 (-4 MW2+S)]) (-1+t^2)+2 MW2 (-MZ2 Sqrt[S^3 (-4 MW2+S)]+Sqrt[S^5 (-4 MW2+S)]) (1+3 t^2)) vev^2,"Mint2tInt"->0,"SMint2t"->SeriesData[S, DirectedInfinity[1], {(((((((((-2) Alfa2) C14) MW2^(-2))/(MW2 - MZ2)) MZ2^2) Pi^2) t) (-1 + t^2)) vev^2, 0, ((((((((2 Alfa2) C14) MW2^(-2))/(MW2 - MZ2)) MZ2^2) Pi^2) t) (MZ2 + (8 MW2) t^2 - MZ2 t^2)) vev^2, 0, (((((((((-2) Alfa2) C14) MW2^(-2))/(MW2 - MZ2)) MZ2^2) Pi^2) t) ((-2) MW2^2 - MZ2^2 + (18 MW2^2) t^2 - ((8 MW2) MZ2) t^2 + MZ2^2 t^2)) vev^2}, -4, 2, 2],"SMint2tInt"->0|>;
ResultWW["O15"]["dd"]=<|"HelAmpNP"->{-((Alfa C15 MZ2 \[Pi] S vev^2 Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(MW2-MZ2)),(Alfa C15 MZ2 \[Pi] S vev^2 Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(MW2-MZ2),(Alfa C15 MZ2 \[Pi] S^(3/2) vev^2 Cos[\[Theta]] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(Sqrt[2] (-MW MW2+MW MZ2)),-((Alfa C15 MZ2 \[Pi] S vev^2 Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(MW2-MZ2)),(Alfa C15 MZ2 \[Pi] S vev^2 Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(MW2-MZ2),(Alfa C15 MZ2 \[Pi] S^(3/2) vev^2 Cos[\[Theta]/2]^2 Cos[\[Theta]] SUNT[Col1,Col2])/(Sqrt[2] (-MW MW2+MW MZ2)),(Alfa C15 MZ2 \[Pi] S^(3/2) vev^2 Sin[\[Theta]]^2 SUNT[Col1,Col2])/(Sqrt[2] (2 MW MW2-2 MW MZ2)),-((Alfa C15 MZ2 \[Pi] S^(3/2) vev^2 Sin[\[Theta]]^2 SUNT[Col1,Col2])/(Sqrt[2] (2 MW MW2-2 MW MZ2))),(Alfa C15 MZ2 \[Pi] S^2 vev^2 Cos[\[Theta]] Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW2^2-4 MW2 MZ2)},"HelAmpSM"->{0,(4 Alfa MZ2 \[Pi] Sqrt[1-(4 MW2)/S] Sin[\[Theta]] SUNT[Col1,Col2])/(3 (-MZ2+S)),(4 Alfa MZ2 \[Pi] Sqrt[-8 MW2+2 S] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(-3 MW MZ2+3 MW S),(4 Alfa MZ2 \[Pi] Sqrt[1-(4 MW2)/S] Sin[\[Theta]] SUNT[Col1,Col2])/(3 (-MZ2+S)),0,(4 Alfa MZ2 \[Pi] Sqrt[-8 MW2+2 S] Cos[\[Theta]/2]^2 SUNT[Col1,Col2])/(-3 MW MZ2+3 MW S),(4 Sqrt[2] Alfa MZ2 \[Pi] Sqrt[-4 MW2+S] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW MZ2-3 MW S),(4 Sqrt[2] Alfa MZ2 \[Pi] Sqrt[-4 MW2+S] Cos[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW MZ2-3 MW S),(2 Alfa MZ2 \[Pi] Sqrt[1-(4 MW2)/S] (2 MW2+S) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW2 (MZ2-S))},"Mint2t"->(Alfa2 C15 MZ2^2 \[Pi]^2 t (8 MW2^2 (-MZ2 Sqrt[S (-4 MW2+S)]+Sqrt[S^3 (-4 MW2+S)]) (-1+t^2)+(-MZ2 Sqrt[S^5 (-4 MW2+S)]+Sqrt[S^7 (-4 MW2+S)]) (-1+t^2)-2 MW2 (-MZ2 Sqrt[S^3 (-4 MW2+S)]+Sqrt[S^5 (-4 MW2+S)]) (1+3 t^2)) vev^2)/(MW2^2 (MW2-MZ2) (MZ2-S)^2),"Mint2tInt"->0,"SMint2t"->SeriesData[S, DirectedInfinity[1], {(((((((Alfa2 C15) MW2^(-2))/(MW2 - MZ2)) MZ2^2) Pi^2) t) (-1 + t^2)) vev^2, 0, ((((((((-Alfa2) C15) MW2^(-2))/(MW2 - MZ2)) MZ2^2) Pi^2) t) (MZ2 + (8 MW2) t^2 - MZ2 t^2)) vev^2, 0, (((((((Alfa2 C15) MW2^(-2))/(MW2 - MZ2)) MZ2^2) Pi^2) t) ((-2) MW2^2 - MZ2^2 + (18 MW2^2) t^2 - ((8 MW2) MZ2) t^2 + MZ2^2 t^2)) vev^2}, -4, 2, 2],"SMint2tInt"->0|>;


(* ::Input::Initialization:: *)
ResultWW["O16"]["uu"]=<|"HelAmpNP"->{(Alfa C16 MZ2 \[Pi] S vev^2 Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(MW2-MZ2),-((Alfa C16 MZ2 \[Pi] S vev^2 Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(MW2-MZ2)),(Alfa C16 MZ2 \[Pi] S^(3/2) vev^2 Cos[\[Theta]/2]^2 Cos[\[Theta]] SUNT[Col1,Col2])/(Sqrt[2] (MW MW2-MW MZ2)),(Alfa C16 MZ2 \[Pi] S vev^2 Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(MW2-MZ2),-((Alfa C16 MZ2 \[Pi] S vev^2 Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(MW2-MZ2)),(Alfa C16 MZ2 \[Pi] S^(3/2) vev^2 Cos[\[Theta]] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(Sqrt[2] (MW MW2-MW MZ2)),(Alfa C16 MZ2 \[Pi] S^(3/2) vev^2 Sin[\[Theta]]^2 SUNT[Col1,Col2])/(Sqrt[2] (2 MW MW2-2 MW MZ2)),-((Alfa C16 MZ2 \[Pi] S^(3/2) vev^2 Sin[\[Theta]]^2 SUNT[Col1,Col2])/(Sqrt[2] (2 MW MW2-2 MW MZ2))),(Alfa C16 MZ2 \[Pi] S^2 vev^2 Cos[\[Theta]] Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW2^2-4 MW2 MZ2)},"HelAmpSM"->{-((4 Alfa MZ2 \[Pi] S Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (8 MW2^2-8 MW2 MZ2+2 MW2 S+MZ2 S)-Sqrt[S] (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (8 MW2^2-8 MW2 MZ2+2 MW2 S+MZ2 S)-Sqrt[S] (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(4 Alfa MZ2 \[Pi] S Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((2 Sqrt[2] Alfa MZ2 \[Pi] (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(2 Sqrt[2] Alfa MZ2 \[Pi] (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(Alfa MZ2 \[Pi] (-Sqrt[-4 MW2+S] (2 MW2+S) (8 MW2^2-8 MW2 MZ2+2 MW2 S+MZ2 S)+Sqrt[S] (32 MW2^3-32 MW2^2 (MZ2-S)+MZ2 S^2+2 MW2 S (-4 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW2 (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))},"Mint2t"->(Alfa2 C16 MZ2^2 \[Pi]^2 Sqrt[S] (64 MW2^4 t (Sqrt[-4 MW2+S]-2 Sqrt[S] t) (-1+t^2)+MZ2 S^3 t (Sqrt[-4 MW2+S]-Sqrt[S] t) (-1+t^2)-32 MW2^3 t (2 MZ2 (Sqrt[-4 MW2+S]-2 Sqrt[S] t) (-1+t^2)+S Sqrt[-4 MW2+S] (1+t^2)-S^(3/2) t (3+t^2))+2 MW2 S^2 t (MZ2 Sqrt[-4 MW2+S] (3-7 t^2)+S (Sqrt[-4 MW2+S]-Sqrt[S] t) (-1+t^2)+MZ2 Sqrt[S] (-4 t+8 t^3))-4 MW2^2 S (S Sqrt[-4 MW2+S] t (3+t^2)-2 MZ2 Sqrt[-4 MW2+S] t (1+7 t^2)-2 S^(3/2) (6-5 t^2+t^4)+4 MZ2 Sqrt[S] (3-3 t^2+5 t^4))) vev^2)/(2 MW2^2 (MW2-MZ2)^2 (MZ2-S) (2 MW2-S+Sqrt[S (-4 MW2+S)] t)),"Mint2tInt"->(96 Alfa2 C16 MZ2^2 \[Pi]^3 Sqrt[S/(-4 MW2+S)] vev^2 (Sqrt[S (-4 MW2+S)]+2 MW2 ArcCoth[(-2 MW2+S)/Sqrt[S (-4 MW2+S)]]))/(MW2-MZ2)^2,"SMint2t"->SeriesData[S, DirectedInfinity[1], {((((((((Rational[1, 2] Alfa2) C16) MW2^(-2)) (MW2 - MZ2)^(-2)) MZ2^2) Pi^2) (-1 + t)) ((2 MW2) t + MZ2 t + (2 MW2) t^2 + MZ2 t^2)) vev^2, 0, (((((((Rational[-1, 2] Alfa2) C16) MW2^(-2)) (MW2 - MZ2)^(-2)) MZ2^2) Pi^2) ((-48) MW2^2 - (36 MW2^2) t - ((4 MW2) MZ2) t + MZ2^2 t + (4 MW2^2) t^3 + ((12 MW2) MZ2) t^3 - MZ2^2 t^3)) vev^2, 0, ((((((((Rational[-1, 2] Alfa2) C16) MW2^(-2)) (MW2 - MZ2)^(-2)) MZ2^2) Pi^2)/(-1 + t)) (96 MW2^3 - (28 MW2^3) t - ((2 MW2^2) MZ2) t + ((4 MW2) MZ2^2) t - MZ2^3 t + (28 MW2^3) t^2 + ((2 MW2^2) MZ2) t^2 - ((4 MW2) MZ2^2) t^2 + MZ2^3 t^2 - (36 MW2^3) t^3 + ((50 MW2^2) MZ2) t^3 - ((12 MW2) MZ2^2) t^3 + MZ2^3 t^3 + (36 MW2^3) t^4 - ((50 MW2^2) MZ2) t^4 + ((12 MW2) MZ2^2) t^4 - MZ2^3 t^4)) vev^2}, -4, 1, 2],"SMint2tInt"->SeriesData[S, DirectedInfinity[1], {(((((96 Alfa2) C16) (MW2 - MZ2)^(-2)) MZ2^2) Pi^3) vev^2, (((((((-192) Alfa2) C16) (MW2 - MZ2)^(-2)) MZ2^2) Pi^3) vev^2) (MW2 Log[MW2] - MW2 Log[S])}, -1, 1, 1]|>;


(* ::Input::Initialization:: *)
ResultWW["O16"]["dd"]=<|"HelAmpNP"->{(Alfa C16 MZ2 \[Pi] S vev^2 Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(MW2-MZ2),-((Alfa C16 MZ2 \[Pi] S vev^2 Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(MW2-MZ2)),(Alfa C16 MZ2 \[Pi] S^(3/2) vev^2 Cos[\[Theta]/2]^2 Cos[\[Theta]] SUNT[Col1,Col2])/(Sqrt[2] (MW MW2-MW MZ2)),(Alfa C16 MZ2 \[Pi] S vev^2 Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(MW2-MZ2),-((Alfa C16 MZ2 \[Pi] S vev^2 Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(MW2-MZ2)),(Alfa C16 MZ2 \[Pi] S^(3/2) vev^2 Cos[\[Theta]] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(Sqrt[2] (MW MW2-MW MZ2)),(Alfa C16 MZ2 \[Pi] S^(3/2) vev^2 Sin[\[Theta]]^2 SUNT[Col1,Col2])/(Sqrt[2] (2 MW MW2-2 MW MZ2)),-((Alfa C16 MZ2 \[Pi] S^(3/2) vev^2 Sin[\[Theta]]^2 SUNT[Col1,Col2])/(Sqrt[2] (2 MW MW2-2 MW MZ2))),(Alfa C16 MZ2 \[Pi] S^2 vev^2 Cos[\[Theta]] Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW2^2-4 MW2 MZ2)},"HelAmpSM"->{(4 Alfa MZ2 \[Pi] S Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (-4 MW2^2+4 MW2 (MZ2-S)+MZ2 S)-Sqrt[S] (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (-4 MW2^2+4 MW2 (MZ2-S)+MZ2 S)-Sqrt[S] (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((4 Alfa MZ2 \[Pi] S Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((2 Sqrt[2] Alfa MZ2 \[Pi] (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(2 Sqrt[2] Alfa MZ2 \[Pi] (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (2 MW2+S) (4 MW2^2-4 MW2 MZ2+4 MW2 S-MZ2 S)+Sqrt[S] (16 MW2^3-4 MW2^2 (4 MZ2-7 S)-MZ2 S^2+4 MW2 S (-MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW2 (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])))},"Mint2t"->(Alfa2 C16 MZ2^2 \[Pi]^2 Sqrt[S] (-MZ2 S^3 t (Sqrt[-4 MW2+S]+Sqrt[S] t) (-1+t^2)+32 MW2^4 t (Sqrt[-4 MW2+S]+2 Sqrt[S] t) (-1+t^2)+8 MW2^3 t (S Sqrt[-4 MW2+S] (-5+t^2)+4 S^(3/2) t (-3+t^2)-4 MZ2 (Sqrt[-4 MW2+S]+2 Sqrt[S] t) (-1+t^2))+2 MW2 S^2 t (2 S (Sqrt[-4 MW2+S]+Sqrt[S] t) (-1+t^2)+MZ2 Sqrt[-4 MW2+S] (3+t^2)+2 MZ2 Sqrt[S] (t+t^3))+4 MW2^2 S (4 MZ2 (Sqrt[-4 MW2+S] t (1+t^2)+Sqrt[S] (3-3 t^2+t^4))-S (Sqrt[-4 MW2+S] t (3+5 t^2)+Sqrt[S] (12-11 t^2+7 t^4)))) vev^2)/(2 MW2^2 (MW2-MZ2)^2 (MZ2-S) (-2 MW2+S+Sqrt[S (-4 MW2+S)] t)),"Mint2tInt"->(96 Alfa2 C16 MZ2^2 \[Pi]^3 Sqrt[S/(-4 MW2+S)] vev^2 (Sqrt[S (-4 MW2+S)]+2 MW2 ArcCoth[(-2 MW2+S)/Sqrt[S (-4 MW2+S)]]))/(MW2-MZ2)^2,"SMint2t"->SeriesData[S, DirectedInfinity[1], {((((((((Rational[-1, 2] Alfa2) C16) MW2^(-2)) (MW2 - MZ2)^(-2)) MZ2^2) Pi^2) (1 + t)) (((-4) MW2) t + MZ2 t + (4 MW2) t^2 - MZ2 t^2)) vev^2, 0, (((((((Rational[1, 2] Alfa2) C16) MW2^(-2)) (MW2 - MZ2)^(-2)) MZ2^2) Pi^2) (48 MW2^2 - (36 MW2^2) t - ((2 MW2) MZ2) t - MZ2^2 t + (20 MW2^2) t^3 - ((6 MW2) MZ2) t^3 + MZ2^2 t^3)) vev^2, 0, ((((((((Rational[1, 2] Alfa2) C16) MW2^(-2)) (MW2 - MZ2)^(-2)) MZ2^2) Pi^2)/(1 + t)) (96 MW2^3 + (32 MW2^3) t - ((2 MW2^2) MZ2) t - ((2 MW2) MZ2^2) t - MZ2^3 t + (32 MW2^3) t^2 - ((2 MW2^2) MZ2) t^2 - ((2 MW2) MZ2^2) t^2 - MZ2^3 t^2 + ((2 MW2^2) MZ2) t^3 - ((6 MW2) MZ2^2) t^3 + MZ2^3 t^3 + ((2 MW2^2) MZ2) t^4 - ((6 MW2) MZ2^2) t^4 + MZ2^3 t^4)) vev^2}, -4, 1, 2],"SMint2tInt"->SeriesData[S, DirectedInfinity[1], {(((((96 Alfa2) C16) (MW2 - MZ2)^(-2)) MZ2^2) Pi^3) vev^2, (((((((-192) Alfa2) C16) (MW2 - MZ2)^(-2)) MZ2^2) Pi^3) vev^2) (MW2 Log[MW2] - MW2 Log[S])}, -1, 1, 1]|>;


(* ::Input::Initialization:: *)
ResultWW["O17"]["uu"]=<|"HelAmpNP"->{(Alfa C17 MZ2 \[Pi] S vev^2 Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW2-4 MZ2),-((Alfa C17 MZ2 \[Pi] S vev^2 Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW2-4 MZ2)),(Alfa C17 MZ2 \[Pi] S^(3/2) vev^2 Cos[\[Theta]/2]^2 Cos[\[Theta]] SUNT[Col1,Col2])/(Sqrt[2] (4 MW MW2-4 MW MZ2)),(Alfa C17 MZ2 \[Pi] S vev^2 Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW2-4 MZ2),-((Alfa C17 MZ2 \[Pi] S vev^2 Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW2-4 MZ2)),(Alfa C17 MZ2 \[Pi] S^(3/2) vev^2 Cos[\[Theta]] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(Sqrt[2] (4 MW MW2-4 MW MZ2)),(Alfa C17 MZ2 \[Pi] S^(3/2) vev^2 Sin[\[Theta]]^2 SUNT[Col1,Col2])/(Sqrt[2] (8 MW MW2-8 MW MZ2)),-((Alfa C17 MZ2 \[Pi] S^(3/2) vev^2 Sin[\[Theta]]^2 SUNT[Col1,Col2])/(Sqrt[2] (8 MW MW2-8 MW MZ2))),(Alfa C17 MZ2 \[Pi] S^2 vev^2 Cos[\[Theta]] Sin[\[Theta]] SUNT[Col1,Col2])/(16 MW2^2-16 MW2 MZ2)},"HelAmpSM"->{-((4 Alfa MZ2 \[Pi] S Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (8 MW2^2-8 MW2 MZ2+2 MW2 S+MZ2 S)-Sqrt[S] (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (8 MW2^2-8 MW2 MZ2+2 MW2 S+MZ2 S)-Sqrt[S] (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(4 Alfa MZ2 \[Pi] S Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((2 Sqrt[2] Alfa MZ2 \[Pi] (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(2 Sqrt[2] Alfa MZ2 \[Pi] (8 MW2^2 Sqrt[S (-4 MW2+S)]+MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-8 MZ2 Sqrt[S (-4 MW2+S)]+2 Sqrt[S^3 (-4 MW2+S)])-S (16 MW2^2+MZ2 S+8 MW2 (-2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(Alfa MZ2 \[Pi] (-Sqrt[-4 MW2+S] (2 MW2+S) (8 MW2^2-8 MW2 MZ2+2 MW2 S+MZ2 S)+Sqrt[S] (32 MW2^3-32 MW2^2 (MZ2-S)+MZ2 S^2+2 MW2 S (-4 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW2 (MW2-MZ2) (MZ2-S) Sqrt[S] (2 MW2-S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))},"Mint2t"->(Alfa2 C17 MZ2^2 \[Pi]^2 Sqrt[S] (64 MW2^4 t (Sqrt[-4 MW2+S]-2 Sqrt[S] t) (-1+t^2)+MZ2 S^3 t (Sqrt[-4 MW2+S]-Sqrt[S] t) (-1+t^2)-32 MW2^3 t (2 MZ2 (Sqrt[-4 MW2+S]-2 Sqrt[S] t) (-1+t^2)+S Sqrt[-4 MW2+S] (1+t^2)-S^(3/2) t (3+t^2))+2 MW2 S^2 t (MZ2 Sqrt[-4 MW2+S] (3-7 t^2)+S (Sqrt[-4 MW2+S]-Sqrt[S] t) (-1+t^2)+MZ2 Sqrt[S] (-4 t+8 t^3))-4 MW2^2 S (S Sqrt[-4 MW2+S] t (3+t^2)-2 MZ2 Sqrt[-4 MW2+S] t (1+7 t^2)-2 S^(3/2) (6-5 t^2+t^4)+4 MZ2 Sqrt[S] (3-3 t^2+5 t^4))) vev^2)/(8 MW2^2 (MW2-MZ2)^2 (MZ2-S) (2 MW2-S+Sqrt[S (-4 MW2+S)] t)),"Mint2tInt"->(24 Alfa2 C17 MZ2^2 \[Pi]^3 Sqrt[S/(-4 MW2+S)] vev^2 (Sqrt[S (-4 MW2+S)]+2 MW2 ArcCoth[(-2 MW2+S)/Sqrt[S (-4 MW2+S)]]))/(MW2-MZ2)^2,"SMint2t"->SeriesData[S, DirectedInfinity[1], {((((((((Rational[1, 8] Alfa2) C17) MW2^(-2)) (MW2 - MZ2)^(-2)) MZ2^2) Pi^2) (-1 + t)) ((2 MW2) t + MZ2 t + (2 MW2) t^2 + MZ2 t^2)) vev^2, 0, (((((((Rational[-1, 8] Alfa2) C17) MW2^(-2)) (MW2 - MZ2)^(-2)) MZ2^2) Pi^2) ((-48) MW2^2 - (36 MW2^2) t - ((4 MW2) MZ2) t + MZ2^2 t + (4 MW2^2) t^3 + ((12 MW2) MZ2) t^3 - MZ2^2 t^3)) vev^2, 0, ((((((((Rational[-1, 8] Alfa2) C17) MW2^(-2)) (MW2 - MZ2)^(-2)) MZ2^2) Pi^2)/(-1 + t)) (96 MW2^3 - (28 MW2^3) t - ((2 MW2^2) MZ2) t + ((4 MW2) MZ2^2) t - MZ2^3 t + (28 MW2^3) t^2 + ((2 MW2^2) MZ2) t^2 - ((4 MW2) MZ2^2) t^2 + MZ2^3 t^2 - (36 MW2^3) t^3 + ((50 MW2^2) MZ2) t^3 - ((12 MW2) MZ2^2) t^3 + MZ2^3 t^3 + (36 MW2^3) t^4 - ((50 MW2^2) MZ2) t^4 + ((12 MW2) MZ2^2) t^4 - MZ2^3 t^4)) vev^2}, -4, 1, 2],"SMint2tInt"->SeriesData[S, DirectedInfinity[1], {(((((24 Alfa2) C17) (MW2 - MZ2)^(-2)) MZ2^2) Pi^3) vev^2, (((((((-48) Alfa2) C17) (MW2 - MZ2)^(-2)) MZ2^2) Pi^3) vev^2) (MW2 Log[MW2] - MW2 Log[S])}, -1, 1, 1]|>;


(* ::Input::Initialization:: *)
ResultWW["O17"]["dd"]=<|"HelAmpNP"->{-((Alfa C17 MZ2 \[Pi] S vev^2 Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW2-4 MZ2)),(Alfa C17 MZ2 \[Pi] S vev^2 Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW2-4 MZ2),-((Alfa C17 MZ2 \[Pi] S^(3/2) vev^2 Cos[\[Theta]/2]^2 Cos[\[Theta]] SUNT[Col1,Col2])/(Sqrt[2] (4 MW MW2-4 MW MZ2))),-((Alfa C17 MZ2 \[Pi] S vev^2 Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW2-4 MZ2)),(Alfa C17 MZ2 \[Pi] S vev^2 Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW2-4 MZ2),-((Alfa C17 MZ2 \[Pi] S^(3/2) vev^2 Cos[\[Theta]] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(Sqrt[2] (4 MW MW2-4 MW MZ2))),-((Alfa C17 MZ2 \[Pi] S^(3/2) vev^2 Sin[\[Theta]]^2 SUNT[Col1,Col2])/(Sqrt[2] (8 MW MW2-8 MW MZ2))),(Alfa C17 MZ2 \[Pi] S^(3/2) vev^2 Sin[\[Theta]]^2 SUNT[Col1,Col2])/(Sqrt[2] (8 MW MW2-8 MW MZ2)),(Alfa C17 MZ2 \[Pi] S^2 vev^2 Cos[\[Theta]] Sin[\[Theta]] SUNT[Col1,Col2])/(-16 MW2^2+16 MW2 MZ2)},"HelAmpSM"->{(4 Alfa MZ2 \[Pi] S Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (-4 MW2^2+4 MW2 (MZ2-S)+MZ2 S)-Sqrt[S] (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((2 Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (-4 MW2^2+4 MW2 (MZ2-S)+MZ2 S)-Sqrt[S] (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((4 Alfa MZ2 \[Pi] S Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/((MW2-MZ2) (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),-((2 Sqrt[2] Alfa MZ2 \[Pi] (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]]))),(2 Sqrt[2] Alfa MZ2 \[Pi] Cos[\[Theta]/2]^2 (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (6 MZ2 S-6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),(2 Sqrt[2] Alfa MZ2 \[Pi] (4 MW2^2 Sqrt[S (-4 MW2+S)]-MZ2 Sqrt[S^3 (-4 MW2+S)]+MW2 (-6 MZ2 S+6 S^2-4 MZ2 Sqrt[S (-4 MW2+S)]+4 Sqrt[S^3 (-4 MW2+S)])+S (8 MW2^2-8 MW2 MZ2+10 MW2 S-MZ2 S) Cos[\[Theta]]) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])),-((Alfa MZ2 \[Pi] (Sqrt[-4 MW2+S] (2 MW2+S) (4 MW2^2-4 MW2 MZ2+4 MW2 S-MZ2 S)+Sqrt[S] (16 MW2^3-4 MW2^2 (4 MZ2-7 S)-MZ2 S^2+4 MW2 S (-MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW2 (MW2-MZ2) (MZ2-S) Sqrt[S] (-2 MW2+S+Sqrt[S (-4 MW2+S)] Cos[\[Theta]])))},"Mint2t"->-((Alfa2 C17 MZ2^2 \[Pi]^2 Sqrt[S] (-MZ2 S^3 t (Sqrt[-4 MW2+S]+Sqrt[S] t) (-1+t^2)+32 MW2^4 t (Sqrt[-4 MW2+S]+2 Sqrt[S] t) (-1+t^2)+8 MW2^3 t (S Sqrt[-4 MW2+S] (-5+t^2)+4 S^(3/2) t (-3+t^2)-4 MZ2 (Sqrt[-4 MW2+S]+2 Sqrt[S] t) (-1+t^2))+2 MW2 S^2 t (2 S (Sqrt[-4 MW2+S]+Sqrt[S] t) (-1+t^2)+MZ2 Sqrt[-4 MW2+S] (3+t^2)+2 MZ2 Sqrt[S] (t+t^3))+4 MW2^2 S (4 MZ2 (Sqrt[-4 MW2+S] t (1+t^2)+Sqrt[S] (3-3 t^2+t^4))-S (Sqrt[-4 MW2+S] t (3+5 t^2)+Sqrt[S] (12-11 t^2+7 t^4)))) vev^2)/(8 MW2^2 (MW2-MZ2)^2 (MZ2-S) (-2 MW2+S+Sqrt[S (-4 MW2+S)] t))),"Mint2tInt"->-((24 Alfa2 C17 MZ2^2 \[Pi]^3 Sqrt[S/(-4 MW2+S)] vev^2 (Sqrt[S (-4 MW2+S)]+2 MW2 ArcCoth[(-2 MW2+S)/Sqrt[S (-4 MW2+S)]]))/(MW2-MZ2)^2),"SMint2t"->SeriesData[S, DirectedInfinity[1], {((((((((Rational[1, 8] Alfa2) C17) MW2^(-2)) (MW2 - MZ2)^(-2)) MZ2^2) Pi^2) (1 + t)) (((-4) MW2) t + MZ2 t + (4 MW2) t^2 - MZ2 t^2)) vev^2, 0, (((((((Rational[-1, 8] Alfa2) C17) MW2^(-2)) (MW2 - MZ2)^(-2)) MZ2^2) Pi^2) (48 MW2^2 - (36 MW2^2) t - ((2 MW2) MZ2) t - MZ2^2 t + (20 MW2^2) t^3 - ((6 MW2) MZ2) t^3 + MZ2^2 t^3)) vev^2, 0, ((((((((Rational[-1, 8] Alfa2) C17) MW2^(-2)) (MW2 - MZ2)^(-2)) MZ2^2) Pi^2)/(1 + t)) (96 MW2^3 + (32 MW2^3) t - ((2 MW2^2) MZ2) t - ((2 MW2) MZ2^2) t - MZ2^3 t + (32 MW2^3) t^2 - ((2 MW2^2) MZ2) t^2 - ((2 MW2) MZ2^2) t^2 - MZ2^3 t^2 + ((2 MW2^2) MZ2) t^3 - ((6 MW2) MZ2^2) t^3 + MZ2^3 t^3 + ((2 MW2^2) MZ2) t^4 - ((6 MW2) MZ2^2) t^4 + MZ2^3 t^4)) vev^2}, -4, 1, 2],"SMint2tInt"->SeriesData[S, DirectedInfinity[1], {((((((-24) Alfa2) C17) (MW2 - MZ2)^(-2)) MZ2^2) Pi^3) vev^2, ((((((48 Alfa2) C17) (MW2 - MZ2)^(-2)) MZ2^2) Pi^3) vev^2) (MW2 Log[MW2] - MW2 Log[S])}, -1, 1, 1]|>;
