(* ::Package:: *)

Print["qq->WZ amplitudes for the dim-8 operators"];
Print["The results are stored in the form of ResultWZ[\"ON\"][\"uu/dd\"], where ON label the corresponding dim-8 Operators"];
Print["dd/uu indicated the initial quarks states, for example ResultWW[\"O10\"][uu] gives an association storing the relevant amplitude results for u\!\(\*OverscriptBox[\(u\), \(_\)]\)->\!\(\*SuperscriptBox[\(W\), \(+\)]\)\!\(\*SuperscriptBox[\(W\), \(-\)]\) generated by O10"];
Print["The association has following keys:\n
HelAmpNP: a list of helicity amplitudes for W+ Z with polarizations in order of (-+,--,-0,++,+-,+0,0-,0+,00)\n
HelAmpSM: a list of helicity amplitudes for W+ Z with polarizations in order of (-+,--,-0,++,+-,+0,0-,0+,00)\n
Mint2t:   The total interference amplitudes Re[\!\(\*SubscriptBox[\(A\), \(SM\)]\)\!\(\*SubsuperscriptBox[\(A\), \(NP\), \(*\)]\)] as a function of (S, t=Cos[\[Theta]]), where S is the square of ECOM, \[Theta] is the scattering angle\n
Mint2tInt: The total interference amplitudes after integration over the solid angle\n
SMint2t:  Expansion of the total interference amplitudes in power of S\n
SMint2tInt:  Expansion of the total interference amplitudes after integration over the solid angle in power of S\n"];


ResultWZ["O4"]=<|"HelAmpNP"->{(C4 Sqrt[1-MW2/MZ2] (MW2+MZ2-S) S Cos[\[Theta]/2]^3 Sin[\[Theta]/2] SUNT[Col1,Col2])/Sqrt[2],-((C4 Sqrt[1-MW2/MZ2] (S (-MW2-MZ2+S)+(MW2^2+MZ2 (MZ2-S)-MW2 (2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 Sqrt[2])),(C4 Sqrt[MZ2 (-MW2+MZ2) S] (MW2-MZ2+S) Sin[\[Theta]]^2 SUNT[Col1,Col2])/(4 MZ),-((C4 Sqrt[1-MW2/MZ2] ((MW2+MZ2-S) S+(MW2^2+MZ2 (MZ2-S)-MW2 (2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 Sqrt[2])),-((C4 Sqrt[1-MW2/MZ2] (MW2+MZ2-S) S Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(2 Sqrt[2])),-((C4 MZ2 S (MW2-MZ2+S) Sin[\[Theta]]^2 SUNT[Col1,Col2])/(4 MZ Sqrt[(MZ2 S)/(-MW2+MZ2)])),(C4 MW2 (-MW2+MZ2+S) Sqrt[S-(MW2 S)/MZ2] Cos[\[Theta]/2]^2 Cos[\[Theta]] SUNT[Col1,Col2])/(2 MW),(C4 MW2 (-MW2+MZ2+S) Sqrt[S-(MW2 S)/MZ2] Cos[\[Theta]] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(2 MW),1/(16 Sqrt[2] MW MZ Sqrt[-((MZ2 S)/(MW2-MZ2))]) C4 (4 MW2 Sqrt[S] (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)) Cos[\[Theta]] Sin[\[Theta]]+(-MW2+MZ2+S) (-2 (MW2+MZ2-S) Sqrt[S] (Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]-(MW2-MZ2+S) Cos[\[Theta]])+2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) Sin[\[Theta]]) SUNT[Col1,Col2]},"HelAmpSM"->{-((2 Sqrt[2] Alfa MZ \[Pi] S Cos[\[Theta]/2]^2 (2 (MW2-MZ2) (MW2+MZ2-S)+6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))),(Sqrt[2] Alfa MZ \[Pi] ((6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2-S))-((4 MW2-MZ2) (MW2-MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) (MW2-MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))))/(3 (MW-(MW MW2)/MZ2)),(2 Alfa \[Pi] Cos[\[Theta]/2]^2 ((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S)-((4 MW2-MZ2) Sqrt[S] (2 MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (2 MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) SUNT[Col1,Col2])/(3 MW (-MW2+MZ2)),(Sqrt[2] Alfa MZ \[Pi] ((6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2-S))-((4 MW2-MZ2) (-MW2+MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) (-MW2+MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))))/(3 (MW-(MW MW2)/MZ2)),(4 Sqrt[2] Alfa MZ \[Pi] S ((MW2-MZ2) (MW2+MZ2-S)+3 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])),(2 Alfa \[Pi] ((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S)-((4 MW2-MZ2) Sqrt[S] (-2 MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (-2 MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW (-MW2+MZ2)),-((2 Alfa MZ \[Pi] Cos[\[Theta]/2]^2 (-((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S))-((4 MW2-MZ2) Sqrt[S] (-2 MW2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (-2 MW2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) SUNT[Col1,Col2])/(3 MW2 (MW2-MZ2))),-((2 Alfa MZ \[Pi] (-((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S))-((4 MW2-MZ2) Sqrt[S] (2 MW2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (2 MW2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(3 MW2 (MW2-MZ2))),1/(3 (MW-(MW MW2)/MZ2)) Sqrt[2] Alfa MZ \[Pi] (-((3 MW2 (MW2+MZ2+S) Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MW MZ MZ2 (MW2-S)))+((4 MW2-MZ2) Sqrt[S] (((MW2-MZ2+S)^2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/S^(3/2)+2 (-MW2+MZ2+S) Sqrt[(MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S]-((MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S)^(3/2)+(2 (MW2-MZ2+S) (-MW2+MZ2+S) Cos[\[Theta]])/Sqrt[S]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW MZ MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) Sqrt[S] (((MW2-MZ2+S)^2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/S^(3/2)+2 (-MW2+MZ2+S) Sqrt[(MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S]-((MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S)^(3/2)-(2 (MW2-MZ2+S) (-MW2+MZ2+S) Cos[\[Theta]])/Sqrt[S]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW MZ MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])))},"Mint2t"->-((Alfa C4 Sqrt[MZ2] \[Pi] (-6 Sqrt[-MW2+MZ2] (-1+t^2) (MW2^6 t^2+MZ2^2 (MZ2-S)^2 S (S+MZ2 t^2)-MW2^5 (S+3 S t^2+t^2 (5 MZ2-3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t))+MW2 MZ2 (-MZ2^4 t^2+S^3 (-2 S+3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^3)-MZ2^3 (S+3 S t^2-3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (-1+t^2))+MZ2 S^2 (S+9 S t^2+6 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (-1+t^2))+MZ2^2 S (3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (3-4 t^2)+S (2+3 t^2)))+MW2^4 (3 S^2 (1+t^2)-3 S t (-3 MZ2 t+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (1+2 t^2))+MZ2 t (10 MZ2 t-3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (1+4 t^2)))+MW2^3 (-10 MZ2^3 t^2+MZ2 S (-2 S+9 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+5 S t^2)+S^2 (3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (2+t^2)-S (3+t^2))+MZ2^2 (S (2-10 t^2)+3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (1+6 t^2)))+MW2^2 (5 MZ2^4 t^2+S^3 (S-3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t)+3 MZ2^3 t (2 S t+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (1-4 t^2))+MZ2^2 S (9 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (1+2 t^2)-S (4+9 t^2))+MZ2 S^2 (S (4-9 t^2)+3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (-2+11 t^2))))+3 S (-2 MW2^5 (-1+t^2) (-2 Sqrt[-MW2+MZ2] t^2+MZ2 Sqrt[1/(-MW2+MZ2)] (1+t)^2)+2 MZ2 (MZ2-S)^2 S (-1+t^2) (MZ2^2 Sqrt[1/(-MW2+MZ2)] (-1+t^2)+MZ2 Sqrt[-MW2+MZ2] (-1+t^2)-Sqrt[-MW2+MZ2] S (1+t^2))-MW2^4 (-4 MZ2^2 Sqrt[1/(-MW2+MZ2)] (1+t)^2 (-1-t+2 t^2)+2 Sqrt[-MW2+MZ2] (-1+t^2) (S+7 S t^2-6 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^3)+MZ2 (2 Sqrt[-MW2+MZ2]-3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]-4 Sqrt[-MW2+MZ2] t-9 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+4 Sqrt[-MW2+MZ2] t^2-6 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^2+4 Sqrt[-MW2+MZ2] t^3+6 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^3+10 Sqrt[-MW2+MZ2] t^4+9 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^4+3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^5+2 Sqrt[1/(-MW2+MZ2)] S (-1+t^2)^2))+MW2^3 (-12 MZ2^3 Sqrt[1/(-MW2+MZ2)] (-1+t) t (1+t)^2+MZ2^2 (2 Sqrt[-MW2+MZ2]-3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]-8 Sqrt[-MW2+MZ2] t-15 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+24 Sqrt[-MW2+MZ2] t^2-18 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^2+8 Sqrt[-MW2+MZ2] t^3+6 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^3+6 Sqrt[-MW2+MZ2] t^4+21 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^4+9 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^5+4 Sqrt[1/(-MW2+MZ2)] S (1+t)^2 (2-3 t+t^2))+6 Sqrt[-MW2+MZ2] S (-1+t^2) (S+3 S t^2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (1+5 t^2))+MZ2 (2 Sqrt[1/(-MW2+MZ2)] S^2 (-1+t) (1+t)^3-3 Sqrt[-MW2+MZ2] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (-1+5 t-2 t^2+2 t^3+3 t^4+9 t^5)+4 S (Sqrt[-MW2+MZ2]+3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^2+3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^3+(7 Sqrt[-MW2+MZ2]-3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]) t^4-3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^5)))+MW2 (-2 MZ2^5 Sqrt[1/(-MW2+MZ2)] (-1+t^2)^2+MZ2^4 (-1+t) (1+t)^2 (2 Sqrt[-MW2+MZ2]-3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]-2 (Sqrt[-MW2+MZ2]+2 Sqrt[1/(-MW2+MZ2)] S) t+3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^2)+2 Sqrt[-MW2+MZ2] S^3 (S-3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t) (-1+t^4)+MZ2 Sqrt[-MW2+MZ2] S^2 (-1+t^2) (4 S (1+t^2)+3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (1+t-t^2+7 t^3))+MZ2^3 (2 Sqrt[1/(-MW2+MZ2)] S^2 (1+t)^2 (3-8 t+5 t^2)-3 Sqrt[-MW2+MZ2] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (1-3 t-2 t^2+2 t^3+t^4+t^5)-2 S (3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+2 (Sqrt[-MW2+MZ2]+3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]) t-6 (Sqrt[-MW2+MZ2]+Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]) t^2-2 (Sqrt[-MW2+MZ2]+6 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]) t^3+(-2 Sqrt[-MW2+MZ2]+3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]) t^4+6 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^5))+MZ2^2 (-4 Sqrt[1/(-MW2+MZ2)] S^3 (-1+t^2)^2-6 Sqrt[-MW2+MZ2] S Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (-1+2 t) (-1+t^2)^2+S^2 (8 Sqrt[-MW2+MZ2]+3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(4 Sqrt[-MW2+MZ2]+9 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]) t-6 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^2-2 (2 Sqrt[-MW2+MZ2]+9 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]) t^3+(8 Sqrt[-MW2+MZ2]+3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]) t^4+9 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^5)))+MW2^2 (4 MZ2^4 Sqrt[1/(-MW2+MZ2)] (1+t)^2 (1-3 t+2 t^2)+MZ2^3 (2 Sqrt[-MW2+MZ2]-3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+4 Sqrt[-MW2+MZ2] t+3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t-20 Sqrt[-MW2+MZ2] t^2+18 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^2-4 Sqrt[-MW2+MZ2] t^3+6 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^3+2 Sqrt[-MW2+MZ2] t^4-15 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^4-9 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^5+8 Sqrt[1/(-MW2+MZ2)] S (-1+t) (1+t)^2)+2 Sqrt[-MW2+MZ2] S^2 (-1+t^2) (6 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (1+2 t^2)-S (3+5 t^2))-2 MZ2^2 (4 Sqrt[1/(-MW2+MZ2)] S^2 (-1+t) t (1+t)^2-3 Sqrt[-MW2+MZ2] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (1-2 t+4 t^2+2 t^3+3 t^4)+S (4 Sqrt[-MW2+MZ2]-3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]-2 (Sqrt[-MW2+MZ2]+3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]) t+2 (5 Sqrt[-MW2+MZ2]+6 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]) t^2+2 (Sqrt[-MW2+MZ2]+9 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]) t^3+(10 Sqrt[-MW2+MZ2]-9 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]) t^4-12 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^5))+MZ2 (2 Sqrt[1/(-MW2+MZ2)] S^3 (-1+t^2)^2+6 Sqrt[-MW2+MZ2] S Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (3+2 t-2 t^3+5 t^4)-S^2 (3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(4 Sqrt[-MW2+MZ2]+9 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]) t-2 (2 Sqrt[-MW2+MZ2]+3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]) t^2-2 (2 Sqrt[-MW2+MZ2]+9 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]) t^3+(20 Sqrt[-MW2+MZ2]+3 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]) t^4+9 Sqrt[1/(-MW2+MZ2)] Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^5))))))/(3 MW MZ (MW2-MZ2) (MW2-S) (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t) (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t))),"Mint2tInt"->-(1/(3 MW MZ))8 Alfa C4 \[Pi]^2 Sqrt[(MZ2 (-MW2+MZ2))/(MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] ((MW2^2+10 MW2 MZ2+MZ2^2-5 MW2 S+7 MZ2 S+4 S^2) Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+6 MW2 MZ2 (MW2+MZ2) Log[(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/(MW2+MZ2-S)]-6 MW2 MZ2 (MW2+MZ2) Log[(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/(MW2+MZ2-S)]),"SMint2t"->SeriesData[FeynArts`S, DirectedInfinity[1], {((((((((2 Alfa) C4)/MW)/MZ)/(MW2 - MZ2)) MZ2^Rational[1, 2]) (-MW2 + MZ2)^Rational[1, 2]) Pi) (-MW2 + MZ2 + (3 MW2) t - MW2 t^2 + MZ2 t^2 + (3 MW2) t^3), (((((((2 Alfa) C4)/MW)/MZ) MZ2^Rational[1, 2]) (-MW2 + MZ2)^Rational[-1, 2]) Pi) (-MW2^2 + (4 MW2) MZ2 - 3 MZ2^2 + (3 MW2^2) t - ((6 MW2) MZ2) t - (2 MW2^2) t^2 + (2 MZ2^2) t^2 + (6 MW2^2) t^3 + ((9 MW2) MZ2) t^3), ((((((((-2) Alfa) C4)/MW)/MZ) MZ2^Rational[1, 2]) (-MW2 + MZ2)^Rational[-1, 2]) Pi) (((-4) MW2^2) MZ2 + (4 MW2) MZ2^2 + ((3 MW2^2) MZ2) t - ((12 MW2) MZ2^2) t - MW2^3 t^2 + ((3 MW2^2) MZ2) t^2 - ((3 MW2) MZ2^2) t^2 + MZ2^3 t^2 + (3 MW2^3) t^3 - ((9 MW2^2) MZ2) t^3 + ((9 MW2) MZ2^2) t^3)}, -2, 1, 1],"SMint2tInt"->SeriesData[FeynArts`S, DirectedInfinity[1], {(((((Rational[-32, 3] Alfa) C4)/MW)/MZ) (MZ2 (-MW2 + MZ2))^Rational[1, 2]) Pi^2, ((((((Rational[8, 3] Alfa) C4)/MW)/MZ) (5 MW2 - 7 MZ2)) ((-(MW2 - MZ2)) MZ2)^Rational[1, 2]) Pi^2, ((((((Rational[-8, 3] Alfa) C4)/MW)/MZ) ((-(MW2 - MZ2)) MZ2)^Rational[1, 2]) (MW2^2 + (10 MW2) MZ2 + MZ2^2)) Pi^2}, -2, 1, 1]|>;
ResultWZ["O5"]=<|"HelAmpNP"->{(I C5 S Sqrt[((-MW2+MZ2) (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)))/MZ2] Cos[\[Theta]/2]^3 Sin[\[Theta]/2] SUNT[Col1,Col2])/Sqrt[2],-((I C5 Sqrt[-(((MW2-MZ2) (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)))/MZ2)] (S+(-MW2+MZ2) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 Sqrt[2])),(I C5 MZ2 Sqrt[(1-MW2/MZ2) S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] Cos[\[Theta]/2]^2 Cos[\[Theta]] SUNT[Col1,Col2])/(2 MZ),-((I C5 Sqrt[-(((MW2-MZ2) (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)))/MZ2)] (S+(MW2-MZ2) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 Sqrt[2])),(I C5 S Sqrt[((-MW2+MZ2) (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)))/MZ2] Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(2 Sqrt[2]),-((I C5 MZ2 Sqrt[(1-MW2/MZ2) S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] Cos[\[Theta]] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(2 MZ)),-((I C5 MW2 Sqrt[(1-MW2/MZ2) S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] Cos[\[Theta]/2]^2 Cos[\[Theta]] SUNT[Col1,Col2])/(2 MW)),(I C5 MW2 Sqrt[(1-MW2/MZ2) S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] Cos[\[Theta]] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(2 MW),0},"HelAmpSM"->{-((2 Sqrt[2] Alfa MZ \[Pi] S Cos[\[Theta]/2]^2 (2 (MW2-MZ2) (MW2+MZ2-S)+6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))),1/(3 (MW-(MW MW2)/MZ2)) Sqrt[2] Alfa MZ \[Pi] ((6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2-S-I MW \[CapitalGamma]W))-((4 MW2-MZ2) (MW2-MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) (MW2-MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))),1/(3 MW (-MW2+MZ2)) 2 Alfa \[Pi] Cos[\[Theta]/2]^2 ((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S+I MW \[CapitalGamma]W)-((4 MW2-MZ2) Sqrt[S] (2 MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (2 MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) SUNT[Col1,Col2],1/(3 (MW-(MW MW2)/MZ2)) Sqrt[2] Alfa MZ \[Pi] ((6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2-S-I MW \[CapitalGamma]W))-((4 MW2-MZ2) (-MW2+MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) (-MW2+MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))),(4 Sqrt[2] Alfa MZ \[Pi] S ((MW2-MZ2) (MW2+MZ2-S)+3 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])),1/(3 MW (-MW2+MZ2)) 2 Alfa \[Pi] ((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S+I MW \[CapitalGamma]W)-((4 MW2-MZ2) Sqrt[S] (-2 MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (-2 MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) Sin[\[Theta]/2]^2 SUNT[Col1,Col2],1/(3 MW (-MW2+MZ2)) 2 Alfa MZ \[Pi] Cos[\[Theta]/2]^2 (-((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(MW (-MW2+S)+I MW2 \[CapitalGamma]W))-((4 MW2-MZ2) Sqrt[S] (-2 MW2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) Sqrt[S] (-2 MW2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))) SUNT[Col1,Col2],1/(3 MW (-MW2+MZ2)) 2 Alfa MZ \[Pi] (-((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(MW (-MW2+S)+I MW2 \[CapitalGamma]W))-((4 MW2-MZ2) Sqrt[S] (2 MW2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) Sqrt[S] (2 MW2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))) Sin[\[Theta]/2]^2 SUNT[Col1,Col2],1/(3 (MW-(MW MW2)/MZ2)) Sqrt[2] Alfa MZ \[Pi] (-((3 MW2 (MW2+MZ2+S) Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MZ MZ2 (MW (MW2-S)-I MW2 \[CapitalGamma]W)))+((4 MW2-MZ2) Sqrt[S] (((MW2-MZ2+S)^2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/S^(3/2)+2 (-MW2+MZ2+S) Sqrt[(MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S]-((MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S)^(3/2)+(2 (MW2-MZ2+S) (-MW2+MZ2+S) Cos[\[Theta]])/Sqrt[S]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW MZ MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) Sqrt[S] (((MW2-MZ2+S)^2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/S^(3/2)+2 (-MW2+MZ2+S) Sqrt[(MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S]-((MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S)^(3/2)-(2 (MW2-MZ2+S) (-MW2+MZ2+S) Cos[\[Theta]])/Sqrt[S]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW MZ MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])))},"Mint2t"->-((3 Alfa C5 MW2 \[Pi] S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))^(3/2) (1+3 t^2) \[CapitalGamma]W)/(MZ Sqrt[-(((MW2-MZ2) (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)))/MZ2)] (MW2^2+S^2+MW2 (-2 S+\[CapitalGamma]W^2)))),"Mint2tInt"->(24 Alfa C5 MW2 Sqrt[MZ2] \[Pi]^2 S Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sqrt[-(MW2-MZ2) (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] \[CapitalGamma]W)/(MZ (MW2-MZ2) (MW2^2+S^2+MW2 (-2 S+\[CapitalGamma]W^2))),"SMint2t"->SeriesData[FeynArts`S, DirectedInfinity[1], {((((((((-3) Alfa) C5) MW2)/MZ) (MZ2/(-MW2 + MZ2))^Rational[1, 2]) Pi) (1 + 3 t^2)) \[CapitalGamma]W, ((((((((6 Alfa) C5) MW2)/MZ) MZ2) (((-1)/(MW2 - MZ2)) MZ2)^Rational[1, 2]) Pi) (1 + 3 t^2)) \[CapitalGamma]W}, -1, 1, 1],"SMint2tInt"->SeriesData[FeynArts`S, DirectedInfinity[1], {(((((((24 Alfa) C5) MW2)/MZ)/(MW2 - MZ2)) (MZ2 (-MW2 + MZ2))^Rational[1, 2]) Pi^2) \[CapitalGamma]W, (((((((((-48) Alfa) C5) MW2)/MZ)/(MW2 - MZ2)) MZ2) ((-(MW2 - MZ2)) MZ2)^Rational[1, 2]) Pi^2) \[CapitalGamma]W}, -1, 1, 1]|>;ResultWZ["O6"]=<|"HelAmpNP"->{(C6 Sqrt[1-MW2/MZ2] (MW2+MZ2-S) S Cos[\[Theta]/2]^3 Sin[\[Theta]/2] SUNT[Col1,Col2])/Sqrt[2],-(1/(4 Sqrt[2]))C6 Sqrt[1-MW2/MZ2] ((MW2+MZ2-S) S+(MW2^2+MZ2 (MZ2-S)-MW2 (2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2],-((C6 MZ2 (MW2-MZ2+S) Sqrt[S-(MW2 S)/MZ2] Cos[\[Theta]/2]^2 Cos[\[Theta]] SUNT[Col1,Col2])/(2 MZ)),-(1/(4 Sqrt[2]))C6 Sqrt[1-MW2/MZ2] (S (-MW2-MZ2+S)+(MW2^2+MZ2 (MZ2-S)-MW2 (2 MZ2+S)) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2],-((C6 Sqrt[1-MW2/MZ2] (MW2+MZ2-S) S Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(2 Sqrt[2])),-((C6 MZ2 (MW2-MZ2+S) Sqrt[S-(MW2 S)/MZ2] Cos[\[Theta]] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(2 MZ)),-((C6 MW2 (-MW2+MZ2+S) Sqrt[S-(MW2 S)/MZ2] Sin[\[Theta]]^2 SUNT[Col1,Col2])/(4 MW)),(C6 MW2 (-MW2+MZ2+S) Sqrt[S-(MW2 S)/MZ2] Sin[\[Theta]]^2 SUNT[Col1,Col2])/(4 MW),1/(16 Sqrt[2] MW MZ Sqrt[-((MZ2 S)/(MW2-MZ2))]) C6 (4 MZ2 Sqrt[S] (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)) Cos[\[Theta]] Sin[\[Theta]]-(MW2-MZ2+S) (-2 (MW2+MZ2-S) Sqrt[S] (Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(-MW2+MZ2+S) Cos[\[Theta]])-2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] (-MW2-MZ2+S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) Sin[\[Theta]]) SUNT[Col1,Col2]},"HelAmpSM"->{-((2 Sqrt[2] Alfa MZ \[Pi] S Cos[\[Theta]/2]^2 (2 (MW2-MZ2) (MW2+MZ2-S)+6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))),1/(3 (MW-(MW MW2)/MZ2)) Sqrt[2] Alfa MZ \[Pi] ((6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2-S))-((4 MW2-MZ2) (MW2-MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) (MW2-MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))),1/(3 MW (-MW2+MZ2)) 2 Alfa \[Pi] Cos[\[Theta]/2]^2 ((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S)-((4 MW2-MZ2) Sqrt[S] (2 MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (2 MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) SUNT[Col1,Col2],1/(3 (MW-(MW MW2)/MZ2)) Sqrt[2] Alfa MZ \[Pi] ((6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2-S))-((4 MW2-MZ2) (-MW2+MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) (-MW2+MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))),(4 Sqrt[2] Alfa MZ \[Pi] S ((MW2-MZ2) (MW2+MZ2-S)+3 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])),1/(3 MW (-MW2+MZ2)) 2 Alfa \[Pi] ((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S)-((4 MW2-MZ2) Sqrt[S] (-2 MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (-2 MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) Sin[\[Theta]/2]^2 SUNT[Col1,Col2],-(1/(3 MW2 (MW2-MZ2)))2 Alfa MZ \[Pi] Cos[\[Theta]/2]^2 (-((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S))-((4 MW2-MZ2) Sqrt[S] (-2 MW2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (-2 MW2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) SUNT[Col1,Col2],-(1/(3 MW2 (MW2-MZ2)))2 Alfa MZ \[Pi] (-((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S))-((4 MW2-MZ2) Sqrt[S] (2 MW2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (2 MW2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) Sin[\[Theta]/2]^2 SUNT[Col1,Col2],1/(3 (MW-(MW MW2)/MZ2)) Sqrt[2] Alfa MZ \[Pi] (-((3 MW2 (MW2+MZ2+S) Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MW MZ MZ2 (MW2-S)))+((4 MW2-MZ2) Sqrt[S] (((MW2-MZ2+S)^2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/S^(3/2)+2 (-MW2+MZ2+S) Sqrt[(MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S]-((MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S)^(3/2)+(2 (MW2-MZ2+S) (-MW2+MZ2+S) Cos[\[Theta]])/Sqrt[S]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW MZ MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) Sqrt[S] (((MW2-MZ2+S)^2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/S^(3/2)+2 (-MW2+MZ2+S) Sqrt[(MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S]-((MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S)^(3/2)-(2 (MW2-MZ2+S) (-MW2+MZ2+S) Cos[\[Theta]])/Sqrt[S]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW MZ MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])))},"Mint2t"->-((2 Alfa C6 Sqrt[-(MZ2/(MW2-MZ2))] \[Pi] (3 (-1+t^2) (MW2^6 t^2+MZ2^2 (MZ2-S)^2 S (-S+MZ2 t^2)+MW2^5 (S-3 S t^2+t^2 (-5 MZ2+3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t))+MW2 MZ2 (-MZ2^4 t^2+MZ2 S^2 (-S+9 S t^2+6 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^3)+S^3 (2 S+3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (-2+t^2))+MZ2^3 (S-3 S t^2+3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (-1+t^2))+MZ2^2 S (3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (3-4 t^2)+S (-2+3 t^2)))+MW2^4 (3 S^2 (-1+t^2)+3 S t (3 MZ2 t+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (1-2 t^2))+MZ2 t (10 MZ2 t-3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (1+4 t^2)))+MW2^2 (5 MZ2^4 t^2-S^3 (S-3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t)+MZ2 S^2 (-4 S-9 S t^2+33 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^3)+3 MZ2^3 t (2 S t+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (1-4 t^2))+MZ2^2 S (S (4-9 t^2)+3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (1+6 t^2)))+MW2^3 (-10 MZ2^3 t^2+MZ2 S (2 S+9 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+5 S t^2)+S^2 (-S (-3+t^2)+3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (-2+t^2))+MZ2^2 (-2 S (1+5 t^2)+3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (1+6 t^2))))-3 S (2 MW2^5 (-1+t^2)^2+MZ2 (MZ2-S)^2 S (-1+t^2) (2 MZ2 t^2-S (1+t^2))+MW2^4 (-2 MZ2 (1-7 t^2+2 t^4)+(-1+t^2) (S (5-7 t^2)+6 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (-1+t^2)))+MW2^2 (-S^2 (-1+t^2) (S+5 S t^2-12 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^3)+2 MZ2^3 (1+t^2+2 t^4)+MZ2^2 (6 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^3 (-5+t^2)+S (1+18 t^2-11 t^4))+MZ2 S (S (-7+10 t^2-11 t^4)+3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (1+7 t^4)))+MW2 (-2 MZ2^4 t^2 (-1+t^2)+S^3 (S-3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t) (-1+t^4)+MZ2 S^2 (-1+t^2) (S (-1+t^2)+3 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (1+5 t^2))+MZ2^3 (6 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (-1+t^2)+S (-3-6 t^2+t^4))+MZ2^2 S (6 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (1+t^2-2 t^4)+S (3-2 t^2+7 t^4)))+MW2^3 (-2 MZ2^2 (1+7 t^2)-3 S (-1+t^2) (S-3 S t^2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t (-3+5 t^2))+MZ2 (-12 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t^3 (-3+t^2)+S (7-22 t^2+15 t^4))))))/(3 MW MZ (-MW2+S) (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t) (-MW2-MZ2+S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t))),"Mint2tInt"->-(1/(3 MW MZ (-MW2+S)))8 Alfa C6 (MW2-MZ2) \[Pi]^2 (MW2-S) Sqrt[-(MZ2/((MW2-MZ2) (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))))] ((MW2^2+10 MW2 MZ2+MZ2^2+7 MW2 S-5 MZ2 S+4 S^2) Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+6 MW2 MZ2 (MW2+MZ2) Log[(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/(MW2+MZ2-S)]-6 MW2 MZ2 (MW2+MZ2) Log[(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/(MW2+MZ2-S)]),"SMint2t"->SeriesData[FeynArts`S, DirectedInfinity[1], {(((((((-2) Alfa) C6)/MW)/MZ) (((-1)/(MW2 - MZ2)) MZ2)^Rational[1, 2]) Pi) (-MW2 + MZ2 + (3 MW2) t - MW2 t^2 + MZ2 t^2 + (3 MW2) t^3), ((((((2 Alfa) C6)/MW)/MZ) (((-1)/(MW2 - MZ2)) MZ2)^Rational[1, 2]) Pi) (3 MW2^2 - (4 MW2) MZ2 + MZ2^2 - (9 MW2^2) t + ((6 MW2) MZ2) t - (2 MW2^2) t^2 + (2 MZ2^2) t^2 + (6 MW2^2) t^3 + ((9 MW2) MZ2) t^3), (((((((-2) Alfa) C6)/MW)/MZ) (((-1)/(MW2 - MZ2)) MZ2)^Rational[1, 2]) Pi) (((-4) MW2^2) MZ2 + (4 MW2) MZ2^2 - ((9 MW2^2) MZ2) t - MW2^3 t^2 + ((3 MW2^2) MZ2) t^2 - ((3 MW2) MZ2^2) t^2 + MZ2^3 t^2 + (3 MW2^3) t^3 - ((9 MW2^2) MZ2) t^3 + ((9 MW2) MZ2^2) t^3)}, -2, 1, 1],"SMint2tInt"->SeriesData[FeynArts`S, DirectedInfinity[1], {((((((Rational[32, 3] Alfa) C6)/MW)/MZ) (MW2 - MZ2)) (MZ2/(-MW2 + MZ2))^Rational[1, 2]) Pi^2, (((((((Rational[8, 3] Alfa) C6)/MW)/MZ) (7 MW2 - 5 MZ2)) (MW2 - MZ2)) (((-1)/(MW2 - MZ2)) MZ2)^Rational[1, 2]) Pi^2, (((((((Rational[8, 3] Alfa) C6)/MW)/MZ) (MW2 - MZ2)) (((-1)/(MW2 - MZ2)) MZ2)^Rational[1, 2]) (MW2^2 + (10 MW2) MZ2 + MZ2^2)) Pi^2}, -2, 1, 1]|>;
ResultWZ["O7"]=<|"HelAmpNP"->{(I C7 S Sqrt[((-MW2+MZ2) (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)))/MZ2] Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(2 Sqrt[2]),(I C7 Sqrt[((-MW2+MZ2) (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)))/MZ2] (S+(MW2-MZ2) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 Sqrt[2]),-((I C7 Sqrt[MZ2 (-MW2+MZ2) S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] Sin[\[Theta]]^2 SUNT[Col1,Col2])/(4 MZ)),(I C7 Sqrt[((-MW2+MZ2) (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)))/MZ2] (S+(-MW2+MZ2) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 Sqrt[2]),(I C7 S Sqrt[((-MW2+MZ2) (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)))/MZ2] Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(2 Sqrt[2]),-((I C7 Sqrt[MZ2 (-MW2+MZ2) S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] Sin[\[Theta]]^2 SUNT[Col1,Col2])/(4 MZ)),(I C7 MW2 Sqrt[(1-MW2/MZ2) S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] Sin[\[Theta]]^2 SUNT[Col1,Col2])/(4 MW),(I C7 MW2 Sqrt[(1-MW2/MZ2) S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] Sin[\[Theta]]^2 SUNT[Col1,Col2])/(4 MW),0},"HelAmpSM"->{-((2 Sqrt[2] Alfa MZ \[Pi] S Cos[\[Theta]/2]^2 (2 (MW2-MZ2) (MW2+MZ2-S)+6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))),1/(3 (MW-(MW MW2)/MZ2)) Sqrt[2] Alfa MZ \[Pi] ((6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2-S-I MW \[CapitalGamma]W))-((4 MW2-MZ2) (MW2-MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) (MW2-MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))),1/(3 MW (-MW2+MZ2)) 2 Alfa \[Pi] Cos[\[Theta]/2]^2 ((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S+I MW \[CapitalGamma]W)-((4 MW2-MZ2) Sqrt[S] (2 MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (2 MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) SUNT[Col1,Col2],1/(3 (MW-(MW MW2)/MZ2)) Sqrt[2] Alfa MZ \[Pi] ((6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2-S-I MW \[CapitalGamma]W))-((4 MW2-MZ2) (-MW2+MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) (-MW2+MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))),(4 Sqrt[2] Alfa MZ \[Pi] S ((MW2-MZ2) (MW2+MZ2-S)+3 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])),1/(3 MW (-MW2+MZ2)) 2 Alfa \[Pi] ((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S+I MW \[CapitalGamma]W)-((4 MW2-MZ2) Sqrt[S] (-2 MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (-2 MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) Sin[\[Theta]/2]^2 SUNT[Col1,Col2],1/(3 MW (-MW2+MZ2)) 2 Alfa MZ \[Pi] Cos[\[Theta]/2]^2 (-((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(MW (-MW2+S)+I MW2 \[CapitalGamma]W))-((4 MW2-MZ2) Sqrt[S] (-2 MW2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) Sqrt[S] (-2 MW2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))) SUNT[Col1,Col2],1/(3 MW (-MW2+MZ2)) 2 Alfa MZ \[Pi] (-((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(MW (-MW2+S)+I MW2 \[CapitalGamma]W))-((4 MW2-MZ2) Sqrt[S] (2 MW2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) Sqrt[S] (2 MW2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))) Sin[\[Theta]/2]^2 SUNT[Col1,Col2],1/(3 (MW-(MW MW2)/MZ2)) Sqrt[2] Alfa MZ \[Pi] (-((3 MW2 (MW2+MZ2+S) Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MZ MZ2 (MW (MW2-S)-I MW2 \[CapitalGamma]W)))+((4 MW2-MZ2) Sqrt[S] (((MW2-MZ2+S)^2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/S^(3/2)+2 (-MW2+MZ2+S) Sqrt[(MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S]-((MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S)^(3/2)+(2 (MW2-MZ2+S) (-MW2+MZ2+S) Cos[\[Theta]])/Sqrt[S]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW MZ MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) Sqrt[S] (((MW2-MZ2+S)^2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/S^(3/2)+2 (-MW2+MZ2+S) Sqrt[(MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S]-((MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S)^(3/2)-(2 (MW2-MZ2+S) (-MW2+MZ2+S) Cos[\[Theta]])/Sqrt[S]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW MZ MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])))},"Mint2t"->(9 Alfa C7 MW2 \[Pi] S Sqrt[-(MW2-MZ2) (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] Sqrt[MZ2 (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] (-1+t^2) \[CapitalGamma]W)/(MZ (MW2-MZ2) (MW2^2+S^2+MW2 (-2 S+\[CapitalGamma]W^2))),"Mint2tInt"->-((24 Alfa C7 MW2 Sqrt[MZ2] \[Pi]^2 S Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sqrt[-(MW2-MZ2) (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] \[CapitalGamma]W)/(MZ (MW2-MZ2) (MW2^2+S^2+MW2 (-2 S+\[CapitalGamma]W^2)))),"SMint2t"->SeriesData[FeynArts`S, DirectedInfinity[1], {((((((((9 Alfa) C7) MW2)/MZ)/(MW2 - MZ2)) (MZ2 (-MW2 + MZ2))^Rational[1, 2]) Pi) (-1 + t^2)) \[CapitalGamma]W, ((((((((((-18) Alfa) C7) MW2)/MZ)/(MW2 - MZ2)) MZ2) ((-(MW2 - MZ2)) MZ2)^Rational[1, 2]) Pi) (-1 + t^2)) \[CapitalGamma]W}, -1, 1, 1],"SMint2tInt"->SeriesData[FeynArts`S, DirectedInfinity[1], {((((((((-24) Alfa) C7) MW2)/MZ)/(MW2 - MZ2)) (MZ2 (-MW2 + MZ2))^Rational[1, 2]) Pi^2) \[CapitalGamma]W, ((((((((48 Alfa) C7) MW2)/MZ)/(MW2 - MZ2)) MZ2) ((-(MW2 - MZ2)) MZ2)^Rational[1, 2]) Pi^2) \[CapitalGamma]W}, -1, 1, 1]|>;ResultWZ["O11"]=<|"HelAmpNP"->{0,-((I C11 MW (MW2+MZ2-S) S Sin[\[Theta]] SUNT[Col1,Col2])/(2 Sqrt[2] MZ)),-(1/2) I C11 MW Sqrt[S] (MW2-MZ2+S) Cos[\[Theta]/2]^2 SUNT[Col1,Col2],(I C11 MW (MW2+MZ2-S) S Sin[\[Theta]] SUNT[Col1,Col2])/(2 Sqrt[2] MZ),0,1/2 I C11 MW Sqrt[S] (MW2-MZ2+S) Sin[\[Theta]/2]^2 SUNT[Col1,Col2],-((I C11 MW2 Sqrt[S] (-MW2+MZ2+S) Cos[\[Theta]/2]^2 SUNT[Col1,Col2])/(2 MZ)),-((I C11 MW2 (MW2-MZ2-S) Sqrt[S] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/(2 MZ)),0},"HelAmpSM"->{-((2 Sqrt[2] Alfa MZ \[Pi] S Cos[\[Theta]/2]^2 (2 (MW2-MZ2) (MW2+MZ2-S)+6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))),1/(3 (MW-(MW MW2)/MZ2)) Sqrt[2] Alfa MZ \[Pi] ((6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2-S-I MW \[CapitalGamma]W))-((4 MW2-MZ2) (MW2-MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) (MW2-MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))),1/(3 MW (-MW2+MZ2)) 2 Alfa \[Pi] Cos[\[Theta]/2]^2 ((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S+I MW \[CapitalGamma]W)-((4 MW2-MZ2) Sqrt[S] (2 MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (2 MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) SUNT[Col1,Col2],1/(3 (MW-(MW MW2)/MZ2)) Sqrt[2] Alfa MZ \[Pi] ((6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2-S-I MW \[CapitalGamma]W))-((4 MW2-MZ2) (-MW2+MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) (-MW2+MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))),(4 Sqrt[2] Alfa MZ \[Pi] S ((MW2-MZ2) (MW2+MZ2-S)+3 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])),1/(3 MW (-MW2+MZ2)) 2 Alfa \[Pi] ((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S+I MW \[CapitalGamma]W)-((4 MW2-MZ2) Sqrt[S] (-2 MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (-2 MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) Sin[\[Theta]/2]^2 SUNT[Col1,Col2],1/(3 MW (-MW2+MZ2)) 2 Alfa MZ \[Pi] Cos[\[Theta]/2]^2 (-((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(MW (-MW2+S)+I MW2 \[CapitalGamma]W))-((4 MW2-MZ2) Sqrt[S] (-2 MW2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) Sqrt[S] (-2 MW2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))) SUNT[Col1,Col2],1/(3 MW (-MW2+MZ2)) 2 Alfa MZ \[Pi] (-((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(MW (-MW2+S)+I MW2 \[CapitalGamma]W))-((4 MW2-MZ2) Sqrt[S] (2 MW2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) Sqrt[S] (2 MW2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))) Sin[\[Theta]/2]^2 SUNT[Col1,Col2],1/(3 (MW-(MW MW2)/MZ2)) Sqrt[2] Alfa MZ \[Pi] (-((3 MW2 (MW2+MZ2+S) Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MZ MZ2 (MW (MW2-S)-I MW2 \[CapitalGamma]W)))+((4 MW2-MZ2) Sqrt[S] (((MW2-MZ2+S)^2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/S^(3/2)+2 (-MW2+MZ2+S) Sqrt[(MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S]-((MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S)^(3/2)+(2 (MW2-MZ2+S) (-MW2+MZ2+S) Cos[\[Theta]])/Sqrt[S]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW MZ MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) Sqrt[S] (((MW2-MZ2+S)^2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/S^(3/2)+2 (-MW2+MZ2+S) Sqrt[(MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S]-((MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S)^(3/2)-(2 (MW2-MZ2+S) (-MW2+MZ2+S) Cos[\[Theta]])/Sqrt[S]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW MZ MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])))},"Mint2t"->-((24 Alfa C11 MW2^3 \[Pi] S Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t \[CapitalGamma]W (MW2^2+S^2+MW2 (-2 S+\[CapitalGamma]W^2)))/(MW (I MW2-I S+MW \[CapitalGamma]W) (-I MW2+I S+MW \[CapitalGamma]W) (MW (MW2-S)-I MW2 \[CapitalGamma]W) (MW (MW2-S)+I MW2 \[CapitalGamma]W))),"Mint2tInt"->0,"SMint2t"->SeriesData[FeynArts`S, DirectedInfinity[1], {(((((((-24) Alfa) C11)/MW) MW2^2) Pi) t) \[CapitalGamma]W}, 0, 1, 1],"SMint2tInt"->0|>;
ResultWZ["O12"]=<|"HelAmpNP"->{-((C12 MW S Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(Sqrt[2] MZ)),-(1/(2 Sqrt[2] MZ))C12 MW Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (S+(MW2-MZ2) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2],1/2 C12 MW Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] Sin[\[Theta]]^2 SUNT[Col1,Col2],-(1/(2 Sqrt[2] MZ))C12 MW Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (S+(-MW2+MZ2) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2],-((C12 MW S Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(Sqrt[2] MZ)),1/2 C12 MW Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] Sin[\[Theta]]^2 SUNT[Col1,Col2],-((C12 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] Sin[\[Theta]]^2 SUNT[Col1,Col2])/(2 MZ)),-((C12 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] Sin[\[Theta]]^2 SUNT[Col1,Col2])/(2 MZ)),0},"HelAmpSM"->{-((2 Sqrt[2] Alfa MZ \[Pi] S Cos[\[Theta]/2]^2 (2 (MW2-MZ2) (MW2+MZ2-S)+6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))),1/(3 (MW-(MW MW2)/MZ2)) Sqrt[2] Alfa MZ \[Pi] ((6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2-S))-((4 MW2-MZ2) (MW2-MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) (MW2-MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))),1/(3 MW (-MW2+MZ2)) 2 Alfa \[Pi] Cos[\[Theta]/2]^2 ((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S)-((4 MW2-MZ2) Sqrt[S] (2 MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (2 MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) SUNT[Col1,Col2],1/(3 (MW-(MW MW2)/MZ2)) Sqrt[2] Alfa MZ \[Pi] ((6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2-S))-((4 MW2-MZ2) (-MW2+MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) (-MW2+MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))),(4 Sqrt[2] Alfa MZ \[Pi] S ((MW2-MZ2) (MW2+MZ2-S)+3 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])),1/(3 MW (-MW2+MZ2)) 2 Alfa \[Pi] ((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S)-((4 MW2-MZ2) Sqrt[S] (-2 MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (-2 MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) Sin[\[Theta]/2]^2 SUNT[Col1,Col2],-(1/(3 MW2 (MW2-MZ2)))2 Alfa MZ \[Pi] Cos[\[Theta]/2]^2 (-((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S))-((4 MW2-MZ2) Sqrt[S] (-2 MW2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (-2 MW2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) SUNT[Col1,Col2],-(1/(3 MW2 (MW2-MZ2)))2 Alfa MZ \[Pi] (-((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S))-((4 MW2-MZ2) Sqrt[S] (2 MW2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (2 MW2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) Sin[\[Theta]/2]^2 SUNT[Col1,Col2],1/(3 (MW-(MW MW2)/MZ2)) Sqrt[2] Alfa MZ \[Pi] (-((3 MW2 (MW2+MZ2+S) Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MW MZ MZ2 (MW2-S)))+((4 MW2-MZ2) Sqrt[S] (((MW2-MZ2+S)^2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/S^(3/2)+2 (-MW2+MZ2+S) Sqrt[(MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S]-((MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S)^(3/2)+(2 (MW2-MZ2+S) (-MW2+MZ2+S) Cos[\[Theta]])/Sqrt[S]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW MZ MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) Sqrt[S] (((MW2-MZ2+S)^2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/S^(3/2)+2 (-MW2+MZ2+S) Sqrt[(MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S]-((MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S)^(3/2)-(2 (MW2-MZ2+S) (-MW2+MZ2+S) Cos[\[Theta]])/Sqrt[S]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW MZ MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])))},"Mint2t"->(4 Alfa C12 \[Pi] (-1+t^2) (3 (MZ2^2 S (MZ2^2-S^2) Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+3 MW2^6 t^2+MW2^5 t (Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]-12 MZ2 t-6 S t)+MW2^2 (3 MZ2^4 t^2+S^3 t (Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]-3 S t)+9 MZ2 S^3 (-1+2 t^2)+6 MZ2^2 S^2 (1+2 t^2)+MZ2^3 (3 S+2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t-6 S t^2))+MW2^3 (-12 MZ2^3 t^2+S^2 t (-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+6 S t)+MZ2 S (9 S+2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t-6 S t^2)+3 MZ2^2 (S+2 S t^2))+MW2^4 (-S Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+18 MZ2^2 t^2+MZ2 (-3 S-2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+6 S t^2))-MW2 MZ2 (MZ2^3 (3 S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t)+3 S^4 (-1+2 t^2)+MZ2^2 S (-9 S+2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+6 S t^2)-MZ2 S^2 (-9 S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+12 S t^2)))-6 S (MZ2 (MZ2-S) S^2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+3 MW2^4 (MZ2+3 MZ2 t^2+S t^2)+MW2 (S^3 t (Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]-3 S t)-3 MZ2^4 (-1+t^2)+9 MZ2^3 S (-1+t^2)+3 MZ2^2 S (3 S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t-4 S t^2)+MZ2 S^2 (-3 S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+9 S t^2))-MW2^3 (S t (-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+9 S t)+3 MZ2^2 (1+7 t^2)+MZ2 (9 S-4 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+21 S t^2))+MW2^2 (S^2 t (-2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+9 S t)+3 MZ2^3 (-1+5 t^2)+MZ2 S (-4 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+3 S (3+t^2))-MZ2^2 (4 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+3 S (2+5 t^2))))))/(3 (MW2-MZ2) (MW2-S) (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t) (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t)),"Mint2tInt"->-(1/((MW2-MZ2) (MW2-S) Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]))16 Alfa C12 MW2 \[Pi]^2 (Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (MW2^3+10 MW2^2 MZ2+MW2 (MZ2^2+9 MZ2 S-3 S^2)+S (-7 MZ2^2+5 MZ2 S+2 S^2))+6 MW2 MZ2 (MW2-S) (MW2+MZ2+2 S) Log[(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/(MW2+MZ2-S)]-6 MW2 MZ2 (MW2-S) (MW2+MZ2+2 S) Log[(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/(MW2+MZ2-S)]),"SMint2t"->SeriesData[FeynArts`S, DirectedInfinity[1], {((((8 Alfa) C12)/(MW2 - MZ2)) Pi) ((-MW2) t + MZ2 t + (3 MW2) t^2), (((((-4) Alfa) C12)/(MW2 - MZ2)) Pi) (((-9) MW2) MZ2 - MW2^2 t + MZ2^2 t + (3 MW2^2) t^2 + ((12 MW2) MZ2) t^2), (((((((-4) Alfa) C12)/(MW2 - MZ2)) Pi)/(-1 + t))/(1 + t)) (((-9) MW2) MZ2^2 + MW2^3 t + ((13 MW2^2) MZ2) t - ((13 MW2) MZ2^2) t - MZ2^3 t - (3 MW2^3) t^2 - ((54 MW2^2) MZ2) t^2 + ((15 MW2) MZ2^2) t^2 - MW2^3 t^3 - ((5 MW2^2) MZ2) t^3 + ((5 MW2) MZ2^2) t^3 + MZ2^3 t^3 + (3 MW2^3) t^4 + ((30 MW2^2) MZ2) t^4 - ((6 MW2) MZ2^2) t^4)}, -2, 1, 1],"SMint2tInt"->SeriesData[FeynArts`S, DirectedInfinity[1], {((((32 Alfa) C12) MW2)/(MW2 - MZ2)) Pi^2, ((((((-16) Alfa) C12) MW2) (MW2 - 5 MZ2))/(MW2 - MZ2)) Pi^2, ((((((-16) Alfa) C12) MW2)/(MW2 - MZ2)) Pi^2) (MW2^2 - (14 MW2) MZ2 + 7 MZ2^2 - ((12 MW2) MZ2) Log[MW2] - ((12 MW2) MZ2) Log[MZ2] + ((24 MW2) MZ2) Log[FeynArts`S])}, -2, 1, 1]|>;
ResultWZ["O13"]=<|"HelAmpNP"->{(C13 MW S Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Csc[\[Theta]/2]^2 Sin[\[Theta]]^3 SUNT[Col1,Col2])/(4 Sqrt[2] MZ),-(1/(2 Sqrt[2] MZ))C13 MW Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (S+(-MW2+MZ2) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2],C13 MW Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] Cos[\[Theta]/2]^2 Cos[\[Theta]] SUNT[Col1,Col2],-(1/(2 Sqrt[2] MZ))C13 MW Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (S+(MW2-MZ2) Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2],(C13 MW S Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(Sqrt[2] MZ),-C13 MW Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] Cos[\[Theta]] Sin[\[Theta]/2]^2 SUNT[Col1,Col2],-((C13 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] Cos[\[Theta]/2]^2 Cos[\[Theta]] SUNT[Col1,Col2])/MZ),(C13 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))] Cos[\[Theta]] Sin[\[Theta]/2]^2 SUNT[Col1,Col2])/MZ,0},"HelAmpSM"->{-((2 Sqrt[2] Alfa MZ \[Pi] S Cos[\[Theta]/2]^2 (2 (MW2-MZ2) (MW2+MZ2-S)+6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))),1/(3 (MW-(MW MW2)/MZ2)) Sqrt[2] Alfa MZ \[Pi] ((6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2-S))-((4 MW2-MZ2) (MW2-MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) (MW2-MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))),1/(3 MW (-MW2+MZ2)) 2 Alfa \[Pi] Cos[\[Theta]/2]^2 ((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S)-((4 MW2-MZ2) Sqrt[S] (2 MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (2 MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) SUNT[Col1,Col2],1/(3 (MW-(MW MW2)/MZ2)) Sqrt[2] Alfa MZ \[Pi] ((6 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2-S))-((4 MW2-MZ2) (-MW2+MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) (-MW2+MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+S Cos[\[Theta]]) Sin[\[Theta]] SUNT[Col1,Col2])/(MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))),(4 Sqrt[2] Alfa MZ \[Pi] S ((MW2-MZ2) (MW2+MZ2-S)+3 MW2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) Sin[\[Theta]/2]^2 Sin[\[Theta]] SUNT[Col1,Col2])/(3 MW (MW2-MZ2) (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]) (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])),1/(3 MW (-MW2+MZ2)) 2 Alfa \[Pi] ((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S)-((4 MW2-MZ2) Sqrt[S] (-2 MZ2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (-2 MZ2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2-S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) Sin[\[Theta]/2]^2 SUNT[Col1,Col2],-(1/(3 MW2 (MW2-MZ2)))2 Alfa MZ \[Pi] Cos[\[Theta]/2]^2 (-((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S))-((4 MW2-MZ2) Sqrt[S] (-2 MW2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (-2 MW2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) SUNT[Col1,Col2],-(1/(3 MW2 (MW2-MZ2)))2 Alfa MZ \[Pi] (-((6 MW2 Sqrt[S (MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))])/(-MW2+S))-((4 MW2-MZ2) Sqrt[S] (2 MW2+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])+((2 MW2+MZ2) Sqrt[S] (2 MW2-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+(MW2-MZ2+S) Cos[\[Theta]]))/(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])) Sin[\[Theta]/2]^2 SUNT[Col1,Col2],1/(3 (MW-(MW MW2)/MZ2)) Sqrt[2] Alfa MZ \[Pi] (-((3 MW2 (MW2+MZ2+S) Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Sin[\[Theta]] SUNT[Col1,Col2])/(MW MZ MZ2 (MW2-S)))+((4 MW2-MZ2) Sqrt[S] (((MW2-MZ2+S)^2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/S^(3/2)+2 (-MW2+MZ2+S) Sqrt[(MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S]-((MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S)^(3/2)+(2 (MW2-MZ2+S) (-MW2+MZ2+S) Cos[\[Theta]])/Sqrt[S]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW MZ MZ2 (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]]))+((2 MW2+MZ2) Sqrt[S] (((MW2-MZ2+S)^2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/S^(3/2)+2 (-MW2+MZ2+S) Sqrt[(MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S]-((MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S))/S)^(3/2)-(2 (MW2-MZ2+S) (-MW2+MZ2+S) Cos[\[Theta]])/Sqrt[S]) Sin[\[Theta]] SUNT[Col1,Col2])/(4 MW MZ MZ2 (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] Cos[\[Theta]])))},"Mint2t"->-((4 Alfa C13 \[Pi] (3 (-1+t^2) (MZ2^2 (MZ2-S)^2 S Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+3 MW2^6 t^2+MW2^5 t (Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]-12 MZ2 t-12 S t)+MW2 MZ2 (9 MZ2^2 S^2 (-1+2 t^2)+3 S^4 (-1+2 t^2)+MZ2 S^2 (9 S+5 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t-18 S t^2)-MZ2^3 (-3 S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+6 S t^2))-MW2^3 (12 MZ2^3 t^2+3 S^2 t (-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+4 S t)+3 MZ2^2 (S+10 S t^2)+MZ2 S (9 S-8 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+18 S t^2))+MW2^2 (3 MZ2^4 t^2+S^3 t (-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+3 S t)-3 MZ2 S^2 (-3 S+2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+2 S t^2)-6 MZ2^2 S (S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+3 S t^2)+MZ2^3 (-3 S+2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+18 S t^2))+MW2^4 (18 MZ2^2 t^2+3 S t (-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+6 S t)+MZ2 (3 S-2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t+30 S t^2)))+6 S t (MZ2 (MZ2-S)^2 S Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (-1+t^2)+3 MW2^5 t (-1+t^2)+MW2^4 ((Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]-12 S t) (-1+t^2)-3 MZ2 (t+7 t^3))+MW2^3 (-3 S (Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]-6 S t) (-1+t^2)-MZ2 Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (1+7 t^2)+3 MZ2 S t (7+9 t^2)+MZ2^2 (9 t+39 t^3))-MW2 (-6 MZ2^4 t (-1+t^2)+S^3 (Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]-3 S t) (-1+t^2)+MZ2 S^2 (Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+15 S t) (-1+t^2)+MZ2^3 (Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]+21 S t) (-1+t^2)+MZ2^2 S (-27 S t (-1+t^2)+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (3+5 t^2)))+MW2^2 (3 S^2 (Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]-4 S t) (-1+t^2)+MZ2^3 (3 t-27 t^3)+MZ2^2 (6 S t (3+5 t^2)+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (1+7 t^2))+MZ2 S (Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (1+7 t^2)+S (-33 t+9 t^3))))))/(3 (MW2-MZ2) (MW2-S) (MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t) (MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] t))),"Mint2tInt"->1/((MW2-MZ2) (MW2-S) Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)]) 16 Alfa C13 MW2 \[Pi]^2 (Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)] (MW2^3+10 MW2^2 MZ2+MW2 (MZ2^2-27 MZ2 S-3 S^2)+S (5 MZ2^2-7 MZ2 S+2 S^2))+6 MW2 MZ2 (MW2+MZ2-2 S) (MW2-S) Log[(MW2+MZ2-S-Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/(MW2+MZ2-S)]-6 MW2 MZ2 (MW2+MZ2-2 S) (MW2-S) Log[(MW2+MZ2-S+Sqrt[MW2^2+(MZ2-S)^2-2 MW2 (MZ2+S)])/(MW2+MZ2-S)]),"SMint2t"->SeriesData[FeynArts`S, DirectedInfinity[1], {((((((-8) Alfa) C13)/(MW2 - MZ2)) Pi) t) (-MW2 + MZ2 + (3 MW2) t), ((((4 Alfa) C13)/(MW2 - MZ2)) Pi) ((3 MW2) MZ2 - MW2^2 t + MZ2^2 t + (3 MW2^2) t^2 + ((12 MW2) MZ2) t^2), ((((((4 Alfa) C13)/(MW2 - MZ2)) Pi)/(-1 + t))/(1 + t)) ((3 MW2) MZ2^2 + MW2^3 t - ((3 MW2^2) MZ2) t + ((3 MW2) MZ2^2) t - MZ2^3 t - (3 MW2^3) t^2 - ((6 MW2^2) MZ2) t^2 + ((3 MW2) MZ2^2) t^2 - MW2^3 t^3 - ((5 MW2^2) MZ2) t^3 + ((5 MW2) MZ2^2) t^3 + MZ2^3 t^3 + (3 MW2^3) t^4 + ((30 MW2^2) MZ2) t^4 - ((6 MW2) MZ2^2) t^4)}, -2, 1, 1],"SMint2tInt"->SeriesData[FeynArts`S, DirectedInfinity[1], {(((((-32) Alfa) C13) MW2)/(MW2 - MZ2)) Pi^2, (((((16 Alfa) C13) MW2)/(MW2 - MZ2)) (MW2 + 7 MZ2)) Pi^2, (((((16 Alfa) C13) MW2)/(MW2 - MZ2)) Pi^2) (MW2^2 + (34 MW2) MZ2 - 5 MZ2^2 + ((12 MW2) MZ2) Log[MW2] + ((12 MW2) MZ2) Log[MZ2] - ((24 MW2) MZ2) Log[FeynArts`S])}, -2, 1, 1]|>;
