(*
M$InteractionOrderHierarchy = {
  {DIM6, 99},
  {FCNC, 99}
};
*)

M$Parameters = {
	PS == {
		Indices			->	{Index[SU2W], Index[SU2D], Index[SU2D]}, 
		Hermitian		->	True, 
		Definitions		->	{
			PS[u_?NumericQ, i_?NumericQ, j_?NumericQ] -> PauliSigma[u, i, j]}, 
		Description		->	"Pauli matrix with proper indices types"
	},
	Lambda == {
		ParameterType		->	External,
		Value			->	10^3,
		BlockName		->	DIM6,
		Description		->	"The scale of new physics"
	},
	Gstrong == {
		ParameterType		->	Internal,
		Value			->	"1.",
		InteractionOrder	->	{QCD,77},
		Description		->	"Normalization of the chromo-dipole operators (flavour conserving and FCNCs)"
	},


(* Flavour-conserving couplings *)

	ctp == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1},{QED,3}},
		Description		->	""
	},

	ctpI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1},{QED,3}},
		Description		->	""
	},

	cpQM == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1},{QED,2}},
		Description		->	""
	},

	cpQ3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1},{QED,2}},
		Description		->	""
	},

	cpt == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1},{QED,2}},
		Description		->	""
	},

	cpb == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1},{QED,2}},
		Description		->	""
	},

	cptb == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1},{QED,2}},
		Description		->	""
	},

	cptbI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1},{QED,2}},
		Description		->	""
	},

	ctW == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1},{QED,1}},
		Description		->	""
	},

	ctZ == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1},{QED,1}},
		Description		->	""
	},

	ctWI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1},{QED,1}},
		Description		->	""
	},

	ctZI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1},{QED,1}},
		Description		->	""
	},

	cbW == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1},{QED,1}},
		Description		->	""
	},

	cbWI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1},{QED,1}},
		Description		->	""
	},

	ctG == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1},{QED,1}},
		Description		->	""
	},

	ctGI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1},{QED,1}},
		Description		->	""
	},

	cQlM1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQlM2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQlM3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQl31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQl32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQl33 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQe1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQe2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQe3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctl1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctl2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctl3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cte1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cte2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cte3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctlS1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctlSI1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctlS2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctlSI2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctlS3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctlSI3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctlT1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctlTI1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctlT2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctlTI2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctlT3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctlTI3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cblS1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cblSI1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cblS2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cblSI2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cblS3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cblSI3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQq83 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQq81 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQu8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQd8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctq8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctu8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctd8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQq13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQq11 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQu1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQd1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctq1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctu1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctd1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQQ1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQQ8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQt1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQb1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctt1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctb1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQt8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQb8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctb8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctQqu1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctQqu1I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctQqu8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctQqu8I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cbQqd1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cbQqd1I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cbQqd8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cbQqd8I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQtqd1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQtqd1I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQtqd8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQtqd8I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQbqu1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQbqu1I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQbqu8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQbqu8I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctQqu1T == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctQqu1TI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctQqu8T == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	ctQqu8TI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cbQqd1T == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cbQqd1TI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cbQqd8T == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cbQqd8TI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQtqd1T == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQtqd1TI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQtqd8T == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQtqd8TI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQbqu1T == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQbqu1TI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQbqu8T == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQbqu8TI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cbtud1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cbtud1I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cbtud8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cbtud8I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQtQb1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQtQb8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQtQb1I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},

	cQtQb8I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6,1}},
		Description		->	""
	},
(* Internal parameters *)
	
	ctA == {
		ComplexParameter	->	False,
		ParameterType		->	Internal,
		Value			->	"(ctW-cw*ctZ)/sw",
		InteractionOrder	->	{DIM6,1},
		Description		->	""
	},

	cQQplus == {
		ComplexParameter	->	False,
		ParameterType		->	Internal,
		Value			->	"cQQ1/2+cQQ8/6",
		InteractionOrder	->	{DIM6,1},
		Description		->	""
	},

	sq2 == {
		ComplexParameter	->	False,
		ParameterType		->	Internal,
		Value			->	"cmath.sqrt(2)",
		Description		->	""
	},

(* FCNC couplings *)

	ctpx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,3}},
		Description		->	""
	},

	ctpx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,3}},
		Description		->	""
	},

	ctpx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,3}},
		Description		->	""
	},

	ctpx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,3}},
		Description		->	""
	},

	ctpIx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,3}},
		Description		->	""
	},

	ctpIx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,3}},
		Description		->	""
	},

	ctpIx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,3}},
		Description		->	""
	},

	ctpIx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,3}},
		Description		->	""
	},

	cpQMx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cpQMx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cpQMIx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cpQMIx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cpQ3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cpQ3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cpQ3Ix31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cpQ3Ix32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cptx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cptx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cptIx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cptIx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cptbx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cptbx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cptbx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cptbx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cptbIx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cptbIx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cptbIx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cptbIx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	ctAx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctAx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctAx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctAx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctAIx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctAIx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctAIx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctAIx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctZx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctZx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctZx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctZx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctZIx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctZIx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctZIx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctZIx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	cbWx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	cbWx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	cbWx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	cbWx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	cbWIx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	cbWIx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	cbWIx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	cbWIx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctGx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctGx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctGx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctGx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctGIx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctGIx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctGIx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	ctGIx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,1}},
		Description		->	""
	},

	cQl3x1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQl3x1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQl3x2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQl3x2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQl3x3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQl3x3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQl3Ix1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQl3Ix1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQl3Ix2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQl3Ix2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQl3Ix3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQl3Ix3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQlMx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQlMx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQlMx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQlMx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQlMx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQlMx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQlMIx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQlMIx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQlMIx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQlMIx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQlMIx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQlMIx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQex1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQex1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQex2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQex2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQex3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQex3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQeIx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQeIx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQeIx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQeIx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQeIx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cQeIx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlIx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlIx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlIx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlIx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlIx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlIx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctex1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctex1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctex2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctex2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctex3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctex3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cteIx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cteIx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cteIx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cteIx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cteIx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cteIx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSx1x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSx1x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSx2x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSx2x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSx3x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSx3x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSIx1x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSIx1x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSIx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSIx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSIx2x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSIx2x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSIx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSIx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSIx3x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSIx3x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSIx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlSIx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTx1x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTx1x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTx2x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTx2x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTx3x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTx3x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTIx1x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTIx1x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTIx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTIx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTIx2x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTIx2x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTIx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTIx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTIx3x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTIx3x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTIx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	ctlTIx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq11x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq11x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq11Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq11Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq13x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq13x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq13Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq13Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cuu1x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cuu1x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cuu1Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cuu1Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu1x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu1x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu1Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu1Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu1x3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu1x3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu1Ix3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu1Ix3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu8x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu8x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu8Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu8Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu8x3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu8x3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu8Ix3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu8Ix3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd1x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd1x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd1Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd1Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd1x3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd1x3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd1Ix3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd1Ix3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd8x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd8x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd8Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd8Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd8x3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd8x3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd8Ix3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd8Ix3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud1x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud1x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud1Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud1Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud1x3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud1x3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud1Ix3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud1Ix3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud8x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud8x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud8Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud8Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud8x3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud8x3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud8Ix3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud8Ix3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd1x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd1x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd1x3313 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd1x3323 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd1x3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd1x3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd1x1333 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd1x2333 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd1Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd1Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd1Ix3313 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd1Ix3323 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd1Ix3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd1Ix3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd1Ix1333 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd1Ix2333 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd8x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd8x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd8x3313 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd8x3323 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd8x3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd8x3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd8x1333 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd8x2333 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd8Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd8Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd8Ix3313 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd8Ix3323 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd8Ix3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd8Ix3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd8Ix1333 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cquqd8Ix2333 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq11x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq11x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq11Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq11Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq13x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq13x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq13Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq13Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq81x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq81x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq81Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq81Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq83x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq83x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq83Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqq83Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cuu1x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cuu1x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cuu1Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cuu1Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cuu8x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cuu8x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cuu8Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cuu8Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud1x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud1x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud1Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud1Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud8x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud8x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud8Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cud8Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu1x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu1x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu1Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu1Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu8x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu8x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu8Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu8Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu1xii31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu1xii32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu1Ixii31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu1Ixii32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu8xii31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu8xii32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu8Ixii31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqu8Ixii32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd1x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd1x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd1Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd1Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd8Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd8Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd8x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cqd8x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cpbIx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cpbIx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cpbx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cpbx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1},{QED,2}},
		Description		->	""
	},

	cblSx1x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSx1x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSx2x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSx2x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSx3x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSx3x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSIx1x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSIx1x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSIx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSIx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSIx2x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSIx2x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSIx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSIx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSIx3x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSIx3x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSIx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	},

	cblSIx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC,1}},
		Description		->	""
	}
}
