(*
M$InteractionOrderHierarchy = {
  {DIM6, 99},
  {FCNC, 99}
};
*)

M$Parameters = {
	PS == {
		Indices			->	{Index[SU2W], Index[SU2D], Index[SU2D]}, 
		Hermitian		->	True, 
		Definitions		->	{
			PS[u_?NumericQ, i_?NumericQ, j_?NumericQ] -> PauliSigma[u, i, j]}, 
		Description		->	"Pauli matrix with proper indices types"
	},
	Lambda == {
		ParameterType		->	External,
		Value			->	10^3,
		BlockName		->	DIM6,
		Description		->	"The scale of new physics"
	},
	Gstrong == {
		ParameterType		->	Internal,
		Value			->	"1.",
		InteractionOrder	->	{QCD,77},
		Description		->	"Normalization of the chromo-dipole operators (flavour conserving and FCNCs)"
	},


(* Flavour-conserving couplings *)

	ctp == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctp,1},{QED,3}},
		Description		->	""
	},

	ctpI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctpI,1},{QED,3}},
		Description		->	""
	},

	cpQM == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cpQM,1},{QED,2}},
		Description		->	""
	},

	cpQ3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cpQ3,1},{QED,2}},
		Description		->	""
	},

	cpt == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cpt,1},{QED,2}},
		Description		->	""
	},

	cpb == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cpb,1},{QED,2}},
		Description		->	""
	},

	cptb == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cptb,1},{QED,2}},
		Description		->	""
	},

	cptbI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cptbI,1},{QED,2}},
		Description		->	""
	},

	ctW == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctW,1},{QED,1}},
		Description		->	""
	},

	ctZ == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctZ,1},{QED,1}},
		Description		->	""
	},

	ctWI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctWI,1},{QED,1}},
		Description		->	""
	},

	ctZI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctZI,1},{QED,1}},
		Description		->	""
	},

	cbW == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cbW,1},{QED,1}},
		Description		->	""
	},

	cbWI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cbWI,1},{QED,1}},
		Description		->	""
	},

	ctG == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctG,1},{QED,1}},
		Description		->	""
	},

	ctGI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctGI,1},{QED,1}},
		Description		->	""
	},

	cQlM1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQlM1,1}},
		Description		->	""
	},

	cQlM2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQlM2,1}},
		Description		->	""
	},

	cQlM3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQlM3,1}},
		Description		->	""
	},

	cQl31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQl31,1}},
		Description		->	""
	},

	cQl32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQl32,1}},
		Description		->	""
	},

	cQl33 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQl33,1}},
		Description		->	""
	},

	cQe1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQe1,1}},
		Description		->	""
	},

	cQe2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQe2,1}},
		Description		->	""
	},

	cQe3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQe3,1}},
		Description		->	""
	},

	ctl1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctl1,1}},
		Description		->	""
	},

	ctl2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctl2,1}},
		Description		->	""
	},

	ctl3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctl3,1}},
		Description		->	""
	},

	cte1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cte1,1}},
		Description		->	""
	},

	cte2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cte2,1}},
		Description		->	""
	},

	cte3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cte3,1}},
		Description		->	""
	},

	ctlS1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctlS1,1}},
		Description		->	""
	},

	ctlSI1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctlSI1,1}},
		Description		->	""
	},

	ctlS2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctlS2,1}},
		Description		->	""
	},

	ctlSI2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctlSI2,1}},
		Description		->	""
	},

	ctlS3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctlS3,1}},
		Description		->	""
	},

	ctlSI3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctlSI3,1}},
		Description		->	""
	},

	ctlT1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctlT1,1}},
		Description		->	""
	},

	ctlTI1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctlTI1,1}},
		Description		->	""
	},

	ctlT2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctlT2,1}},
		Description		->	""
	},

	ctlTI2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctlTI2,1}},
		Description		->	""
	},

	ctlT3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctlT3,1}},
		Description		->	""
	},

	ctlTI3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctlTI3,1}},
		Description		->	""
	},

	cblS1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cblS1,1}},
		Description		->	""
	},

	cblSI1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cblSI1,1}},
		Description		->	""
	},

	cblS2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cblS2,1}},
		Description		->	""
	},

	cblSI2 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cblSI2,1}},
		Description		->	""
	},

	cblS3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cblS3,1}},
		Description		->	""
	},

	cblSI3 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cblSI3,1}},
		Description		->	""
	},

	cQq83 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQq83,1}},
		Description		->	""
	},

	cQq81 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQq81,1}},
		Description		->	""
	},

	cQu8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQu8,1}},
		Description		->	""
	},

	cQd8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQd8,1}},
		Description		->	""
	},

	ctq8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctq8,1}},
		Description		->	""
	},

	ctu8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctu8,1}},
		Description		->	""
	},

	ctd8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctd8,1}},
		Description		->	""
	},

	cQq13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQq13,1}},
		Description		->	""
	},

	cQq11 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQq11,1}},
		Description		->	""
	},

	cQu1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQu1,1}},
		Description		->	""
	},

	cQd1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQd1,1}},
		Description		->	""
	},

	ctq1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctq1,1}},
		Description		->	""
	},

	ctu1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctu1,1}},
		Description		->	""
	},

	ctd1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctd1,1}},
		Description		->	""
	},

	cQQ1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQQ1,1}},
		Description		->	""
	},

	cQQ8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQQ8,1}},
		Description		->	""
	},

	cQt1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQt1,1}},
		Description		->	""
	},

	cQb1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQb1,1}},
		Description		->	""
	},

	ctt1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctt1,1}},
		Description		->	""
	},

	ctb1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctb1,1}},
		Description		->	""
	},

	cQt8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQt8,1}},
		Description		->	""
	},

	cQb8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQb8,1}},
		Description		->	""
	},

	ctb8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctb8,1}},
		Description		->	""
	},

	ctQqu1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctQqu1,1}},
		Description		->	""
	},

	ctQqu1I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctQqu1I,1}},
		Description		->	""
	},

	ctQqu8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctQqu8,1}},
		Description		->	""
	},

	ctQqu8I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctQqu8I,1}},
		Description		->	""
	},

	cbQqd1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cbQqd1,1}},
		Description		->	""
	},

	cbQqd1I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cbQqd1I,1}},
		Description		->	""
	},

	cbQqd8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cbQqd8,1}},
		Description		->	""
	},

	cbQqd8I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cbQqd8I,1}},
		Description		->	""
	},

	cQtqd1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQtqd1,1}},
		Description		->	""
	},

	cQtqd1I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQtqd1I,1}},
		Description		->	""
	},

	cQtqd8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQtqd8,1}},
		Description		->	""
	},

	cQtqd8I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQtqd8I,1}},
		Description		->	""
	},

	cQbqu1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQbqu1,1}},
		Description		->	""
	},

	cQbqu1I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQbqu1I,1}},
		Description		->	""
	},

	cQbqu8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQbqu8,1}},
		Description		->	""
	},

	cQbqu8I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQbqu8I,1}},
		Description		->	""
	},

	ctQqu1T == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctQqu1T,1}},
		Description		->	""
	},

	ctQqu1TI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctQqu1TI,1}},
		Description		->	""
	},

	ctQqu8T == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctQqu8T,1}},
		Description		->	""
	},

	ctQqu8TI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_ctQqu8TI,1}},
		Description		->	""
	},

	cbQqd1T == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cbQqd1T,1}},
		Description		->	""
	},

	cbQqd1TI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cbQqd1TI,1}},
		Description		->	""
	},

	cbQqd8T == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cbQqd8T,1}},
		Description		->	""
	},

	cbQqd8TI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cbQqd8TI,1}},
		Description		->	""
	},

	cQtqd1T == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQtqd1T,1}},
		Description		->	""
	},

	cQtqd1TI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQtqd1TI,1}},
		Description		->	""
	},

	cQtqd8T == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQtqd8T,1}},
		Description		->	""
	},

	cQtqd8TI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQtqd8TI,1}},
		Description		->	""
	},

	cQbqu1T == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQbqu1T,1}},
		Description		->	""
	},

	cQbqu1TI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQbqu1TI,1}},
		Description		->	""
	},

	cQbqu8T == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQbqu8T,1}},
		Description		->	""
	},

	cQbqu8TI == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQbqu8TI,1}},
		Description		->	""
	},

	cbtud1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cbtud1,1}},
		Description		->	""
	},

	cbtud1I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cbtud1I,1}},
		Description		->	""
	},

	cbtud8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cbtud8,1}},
		Description		->	""
	},

	cbtud8I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cbtud8I,1}},
		Description		->	""
	},

	cQtQb1 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQtQb1,1}},
		Description		->	""
	},

	cQtQb8 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQtQb8,1}},
		Description		->	""
	},

	cQtQb1I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQtQb1I,1}},
		Description		->	""
	},

	cQtQb8I == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	DIM6,
		InteractionOrder	->	{{DIM6_cQtQb8I,1}},
		Description		->	""
	},
(* Internal parameters *)
	
	ctA == {
		ComplexParameter	->	False,
		ParameterType		->	Internal,
		Value			->	"(ctW-cw*ctZ)/sw",
		InteractionOrder	->	{DIM6,1},
		Description		->	""
	},

	cQQplus == {
		ComplexParameter	->	False,
		ParameterType		->	Internal,
		Value			->	"cQQ1/2+cQQ8/6",
		InteractionOrder	->	{DIM6,1},
		Description		->	""
	},

	sq2 == {
		ComplexParameter	->	False,
		ParameterType		->	Internal,
		Value			->	"cmath.sqrt(2)",
		Description		->	""
	},

(* FCNC couplings *)

	ctpx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctpx13,1},{QED,3}},
		Description		->	""
	},

	ctpx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctpx23,1},{QED,3}},
		Description		->	""
	},

	ctpx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctpx31,1},{QED,3}},
		Description		->	""
	},

	ctpx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctpx32,1},{QED,3}},
		Description		->	""
	},

	ctpIx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctpIx13,1},{QED,3}},
		Description		->	""
	},

	ctpIx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctpIx23,1},{QED,3}},
		Description		->	""
	},

	ctpIx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctpIx31,1},{QED,3}},
		Description		->	""
	},

	ctpIx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctpIx32,1},{QED,3}},
		Description		->	""
	},

	cpQMx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cpQMx31,1},{QED,2}},
		Description		->	""
	},

	cpQMx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cpQMx32,1},{QED,2}},
		Description		->	""
	},

	cpQMIx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cpQMIx31,1},{QED,2}},
		Description		->	""
	},

	cpQMIx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cpQMIx32,1},{QED,2}},
		Description		->	""
	},

	cpQ3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cpQ3x31,1},{QED,2}},
		Description		->	""
	},

	cpQ3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cpQ3x32,1},{QED,2}},
		Description		->	""
	},

	cpQ3Ix31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cpQ3Ix31,1},{QED,2}},
		Description		->	""
	},

	cpQ3Ix32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cpQ3Ix32,1},{QED,2}},
		Description		->	""
	},

	cptx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cptx31,1},{QED,2}},
		Description		->	""
	},

	cptx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cptx32,1},{QED,2}},
		Description		->	""
	},

	cptIx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cptIx31,1},{QED,2}},
		Description		->	""
	},

	cptIx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cptIx32,1},{QED,2}},
		Description		->	""
	},

	cptbx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cptbx13,1},{QED,2}},
		Description		->	""
	},

	cptbx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cptbx23,1},{QED,2}},
		Description		->	""
	},

	cptbx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cptbx31,1},{QED,2}},
		Description		->	""
	},

	cptbx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cptbx32,1},{QED,2}},
		Description		->	""
	},

	cptbIx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cptbIx13,1},{QED,2}},
		Description		->	""
	},

	cptbIx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cptbIx23,1},{QED,2}},
		Description		->	""
	},

	cptbIx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cptbIx31,1},{QED,2}},
		Description		->	""
	},

	cptbIx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cptbIx32,1},{QED,2}},
		Description		->	""
	},

	ctAx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctAx13,1},{QED,1}},
		Description		->	""
	},

	ctAx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctAx23,1},{QED,1}},
		Description		->	""
	},

	ctAx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctAx31,1},{QED,1}},
		Description		->	""
	},

	ctAx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctAx32,1},{QED,1}},
		Description		->	""
	},

	ctAIx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctAIx13,1},{QED,1}},
		Description		->	""
	},

	ctAIx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctAIx23,1},{QED,1}},
		Description		->	""
	},

	ctAIx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctAIx31,1},{QED,1}},
		Description		->	""
	},

	ctAIx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctAIx32,1},{QED,1}},
		Description		->	""
	},

	ctZx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctZx13,1},{QED,1}},
		Description		->	""
	},

	ctZx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctZx23,1},{QED,1}},
		Description		->	""
	},

	ctZx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctZx31,1},{QED,1}},
		Description		->	""
	},

	ctZx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctZx32,1},{QED,1}},
		Description		->	""
	},

	ctZIx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctZIx13,1},{QED,1}},
		Description		->	""
	},

	ctZIx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctZIx23,1},{QED,1}},
		Description		->	""
	},

	ctZIx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctZIx31,1},{QED,1}},
		Description		->	""
	},

	ctZIx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctZIx32,1},{QED,1}},
		Description		->	""
	},

	cbWx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cbWx13,1},{QED,1}},
		Description		->	""
	},

	cbWx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cbWx23,1},{QED,1}},
		Description		->	""
	},

	cbWx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cbWx31,1},{QED,1}},
		Description		->	""
	},

	cbWx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cbWx32,1},{QED,1}},
		Description		->	""
	},

	cbWIx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cbWIx13,1},{QED,1}},
		Description		->	""
	},

	cbWIx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cbWIx23,1},{QED,1}},
		Description		->	""
	},

	cbWIx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cbWIx31,1},{QED,1}},
		Description		->	""
	},

	cbWIx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cbWIx32,1},{QED,1}},
		Description		->	""
	},

	ctGx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctGx13,1},{QED,1}},
		Description		->	""
	},

	ctGx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctGx23,1},{QED,1}},
		Description		->	""
	},

	ctGx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctGx31,1},{QED,1}},
		Description		->	""
	},

	ctGx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctGx32,1},{QED,1}},
		Description		->	""
	},

	ctGIx13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctGIx13,1},{QED,1}},
		Description		->	""
	},

	ctGIx23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctGIx23,1},{QED,1}},
		Description		->	""
	},

	ctGIx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctGIx31,1},{QED,1}},
		Description		->	""
	},

	ctGIx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctGIx32,1},{QED,1}},
		Description		->	""
	},

	cQl3x1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQl3x1x31,1}},
		Description		->	""
	},

	cQl3x1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQl3x1x32,1}},
		Description		->	""
	},

	cQl3x2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQl3x2x31,1}},
		Description		->	""
	},

	cQl3x2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQl3x2x32,1}},
		Description		->	""
	},

	cQl3x3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQl3x3x31,1}},
		Description		->	""
	},

	cQl3x3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQl3x3x32,1}},
		Description		->	""
	},

	cQl3Ix1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQl3Ix1x31,1}},
		Description		->	""
	},

	cQl3Ix1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQl3Ix1x32,1}},
		Description		->	""
	},

	cQl3Ix2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQl3Ix2x31,1}},
		Description		->	""
	},

	cQl3Ix2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQl3Ix2x32,1}},
		Description		->	""
	},

	cQl3Ix3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQl3Ix3x31,1}},
		Description		->	""
	},

	cQl3Ix3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQl3Ix3x32,1}},
		Description		->	""
	},

	cQlMx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQlMx1x31,1}},
		Description		->	""
	},

	cQlMx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQlMx1x32,1}},
		Description		->	""
	},

	cQlMx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQlMx2x31,1}},
		Description		->	""
	},

	cQlMx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQlMx2x32,1}},
		Description		->	""
	},

	cQlMx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQlMx3x31,1}},
		Description		->	""
	},

	cQlMx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQlMx3x32,1}},
		Description		->	""
	},

	cQlMIx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQlMIx1x31,1}},
		Description		->	""
	},

	cQlMIx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQlMIx1x32,1}},
		Description		->	""
	},

	cQlMIx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQlMIx2x31,1}},
		Description		->	""
	},

	cQlMIx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQlMIx2x32,1}},
		Description		->	""
	},

	cQlMIx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQlMIx3x31,1}},
		Description		->	""
	},

	cQlMIx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQlMIx3x32,1}},
		Description		->	""
	},

	cQex1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQex1x31,1}},
		Description		->	""
	},

	cQex1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQex1x32,1}},
		Description		->	""
	},

	cQex2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQex2x31,1}},
		Description		->	""
	},

	cQex2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQex2x32,1}},
		Description		->	""
	},

	cQex3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQex3x31,1}},
		Description		->	""
	},

	cQex3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQex3x32,1}},
		Description		->	""
	},

	cQeIx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQeIx1x31,1}},
		Description		->	""
	},

	cQeIx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQeIx1x32,1}},
		Description		->	""
	},

	cQeIx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQeIx2x31,1}},
		Description		->	""
	},

	cQeIx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQeIx2x32,1}},
		Description		->	""
	},

	cQeIx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQeIx3x31,1}},
		Description		->	""
	},

	cQeIx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cQeIx3x32,1}},
		Description		->	""
	},

	ctlx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlx1x31,1}},
		Description		->	""
	},

	ctlx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlx1x32,1}},
		Description		->	""
	},

	ctlx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlx2x31,1}},
		Description		->	""
	},

	ctlx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlx2x32,1}},
		Description		->	""
	},

	ctlx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlx3x31,1}},
		Description		->	""
	},

	ctlx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlx3x32,1}},
		Description		->	""
	},

	ctlIx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlIx1x31,1}},
		Description		->	""
	},

	ctlIx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlIx1x32,1}},
		Description		->	""
	},

	ctlIx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlIx2x31,1}},
		Description		->	""
	},

	ctlIx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlIx2x32,1}},
		Description		->	""
	},

	ctlIx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlIx3x31,1}},
		Description		->	""
	},

	ctlIx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlIx3x32,1}},
		Description		->	""
	},

	ctex1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctex1x31,1}},
		Description		->	""
	},

	ctex1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctex1x32,1}},
		Description		->	""
	},

	ctex2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctex2x31,1}},
		Description		->	""
	},

	ctex2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctex2x32,1}},
		Description		->	""
	},

	ctex3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctex3x31,1}},
		Description		->	""
	},

	ctex3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctex3x32,1}},
		Description		->	""
	},

	cteIx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cteIx1x31,1}},
		Description		->	""
	},

	cteIx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cteIx1x32,1}},
		Description		->	""
	},

	cteIx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cteIx2x31,1}},
		Description		->	""
	},

	cteIx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cteIx2x32,1}},
		Description		->	""
	},

	cteIx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cteIx3x31,1}},
		Description		->	""
	},

	cteIx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cteIx3x32,1}},
		Description		->	""
	},

	ctlSx1x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSx1x13,1}},
		Description		->	""
	},

	ctlSx1x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSx1x23,1}},
		Description		->	""
	},

	ctlSx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSx1x31,1}},
		Description		->	""
	},

	ctlSx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSx1x32,1}},
		Description		->	""
	},

	ctlSx2x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSx2x13,1}},
		Description		->	""
	},

	ctlSx2x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSx2x23,1}},
		Description		->	""
	},

	ctlSx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSx2x31,1}},
		Description		->	""
	},

	ctlSx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSx2x32,1}},
		Description		->	""
	},

	ctlSx3x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSx3x13,1}},
		Description		->	""
	},

	ctlSx3x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSx3x23,1}},
		Description		->	""
	},

	ctlSx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSx3x31,1}},
		Description		->	""
	},

	ctlSx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSx3x32,1}},
		Description		->	""
	},

	ctlSIx1x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSIx1x13,1}},
		Description		->	""
	},

	ctlSIx1x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSIx1x23,1}},
		Description		->	""
	},

	ctlSIx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSIx1x31,1}},
		Description		->	""
	},

	ctlSIx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSIx1x32,1}},
		Description		->	""
	},

	ctlSIx2x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSIx2x13,1}},
		Description		->	""
	},

	ctlSIx2x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSIx2x23,1}},
		Description		->	""
	},

	ctlSIx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSIx2x31,1}},
		Description		->	""
	},

	ctlSIx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSIx2x32,1}},
		Description		->	""
	},

	ctlSIx3x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSIx3x13,1}},
		Description		->	""
	},

	ctlSIx3x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSIx3x23,1}},
		Description		->	""
	},

	ctlSIx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSIx3x31,1}},
		Description		->	""
	},

	ctlSIx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlSIx3x32,1}},
		Description		->	""
	},

	ctlTx1x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTx1x13,1}},
		Description		->	""
	},

	ctlTx1x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTx1x23,1}},
		Description		->	""
	},

	ctlTx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTx1x31,1}},
		Description		->	""
	},

	ctlTx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTx1x32,1}},
		Description		->	""
	},

	ctlTx2x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTx2x13,1}},
		Description		->	""
	},

	ctlTx2x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTx2x23,1}},
		Description		->	""
	},

	ctlTx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTx2x31,1}},
		Description		->	""
	},

	ctlTx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTx2x32,1}},
		Description		->	""
	},

	ctlTx3x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTx3x13,1}},
		Description		->	""
	},

	ctlTx3x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTx3x23,1}},
		Description		->	""
	},

	ctlTx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTx3x31,1}},
		Description		->	""
	},

	ctlTx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTx3x32,1}},
		Description		->	""
	},

	ctlTIx1x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTIx1x13,1}},
		Description		->	""
	},

	ctlTIx1x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTIx1x23,1}},
		Description		->	""
	},

	ctlTIx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTIx1x31,1}},
		Description		->	""
	},

	ctlTIx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTIx1x32,1}},
		Description		->	""
	},

	ctlTIx2x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTIx2x13,1}},
		Description		->	""
	},

	ctlTIx2x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTIx2x23,1}},
		Description		->	""
	},

	ctlTIx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTIx2x31,1}},
		Description		->	""
	},

	ctlTIx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTIx2x32,1}},
		Description		->	""
	},

	ctlTIx3x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTIx3x13,1}},
		Description		->	""
	},

	ctlTIx3x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTIx3x23,1}},
		Description		->	""
	},

	ctlTIx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTIx3x31,1}},
		Description		->	""
	},

	ctlTIx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_ctlTIx3x32,1}},
		Description		->	""
	},

	cqq11x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq11x3331,1}},
		Description		->	""
	},

	cqq11x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq11x3332,1}},
		Description		->	""
	},

	cqq11Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq11Ix3331,1}},
		Description		->	""
	},

	cqq11Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq11Ix3332,1}},
		Description		->	""
	},

	cqq13x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq13x3331,1}},
		Description		->	""
	},

	cqq13x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq13x3332,1}},
		Description		->	""
	},

	cqq13Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq13Ix3331,1}},
		Description		->	""
	},

	cqq13Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq13Ix3332,1}},
		Description		->	""
	},

	cuu1x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cuu1x3331,1}},
		Description		->	""
	},

	cuu1x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cuu1x3332,1}},
		Description		->	""
	},

	cuu1Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cuu1Ix3331,1}},
		Description		->	""
	},

	cuu1Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cuu1Ix3332,1}},
		Description		->	""
	},

	cqu1x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu1x3331,1}},
		Description		->	""
	},

	cqu1x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu1x3332,1}},
		Description		->	""
	},

	cqu1Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu1Ix3331,1}},
		Description		->	""
	},

	cqu1Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu1Ix3332,1}},
		Description		->	""
	},

	cqu1x3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu1x3133,1}},
		Description		->	""
	},

	cqu1x3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu1x3233,1}},
		Description		->	""
	},

	cqu1Ix3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu1Ix3133,1}},
		Description		->	""
	},

	cqu1Ix3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu1Ix3233,1}},
		Description		->	""
	},

	cqu8x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu8x3331,1}},
		Description		->	""
	},

	cqu8x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu8x3332,1}},
		Description		->	""
	},

	cqu8Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu8Ix3331,1}},
		Description		->	""
	},

	cqu8Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu8Ix3332,1}},
		Description		->	""
	},

	cqu8x3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu8x3233,1}},
		Description		->	""
	},

	cqu8x3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu8x3133,1}},
		Description		->	""
	},

	cqu8Ix3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu8Ix3133,1}},
		Description		->	""
	},

	cqu8Ix3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu8Ix3233,1}},
		Description		->	""
	},

	cqd1x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd1x3331,1}},
		Description		->	""
	},

	cqd1x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd1x3332,1}},
		Description		->	""
	},

	cqd1Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd1Ix3331,1}},
		Description		->	""
	},

	cqd1Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd1Ix3332,1}},
		Description		->	""
	},

	cqd1x3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd1x3133,1}},
		Description		->	""
	},

	cqd1x3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd1x3233,1}},
		Description		->	""
	},

	cqd1Ix3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd1Ix3133,1}},
		Description		->	""
	},

	cqd1Ix3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd1Ix3233,1}},
		Description		->	""
	},

	cqd8x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd8x3331,1}},
		Description		->	""
	},

	cqd8x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd8x3332,1}},
		Description		->	""
	},

	cqd8Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd8Ix3331,1}},
		Description		->	""
	},

	cqd8Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd8Ix3332,1}},
		Description		->	""
	},

	cqd8x3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd8x3133,1}},
		Description		->	""
	},

	cqd8x3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd8x3233,1}},
		Description		->	""
	},

	cqd8Ix3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd8Ix3133,1}},
		Description		->	""
	},

	cqd8Ix3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd8Ix3233,1}},
		Description		->	""
	},

	cud1x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud1x3331,1}},
		Description		->	""
	},

	cud1x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud1x3332,1}},
		Description		->	""
	},

	cud1Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud1Ix3331,1}},
		Description		->	""
	},

	cud1Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud1Ix3332,1}},
		Description		->	""
	},

	cud1x3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud1x3133,1}},
		Description		->	""
	},

	cud1x3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud1x3233,1}},
		Description		->	""
	},

	cud1Ix3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud1Ix3133,1}},
		Description		->	""
	},

	cud1Ix3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud1Ix3233,1}},
		Description		->	""
	},

	cud8x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud8x3331,1}},
		Description		->	""
	},

	cud8x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud8x3332,1}},
		Description		->	""
	},

	cud8Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud8Ix3331,1}},
		Description		->	""
	},

	cud8Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud8Ix3332,1}},
		Description		->	""
	},

	cud8x3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud8x3133,1}},
		Description		->	""
	},

	cud8x3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud8x3233,1}},
		Description		->	""
	},

	cud8Ix3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud8Ix3133,1}},
		Description		->	""
	},

	cud8Ix3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud8Ix3233,1}},
		Description		->	""
	},

	cquqd1x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd1x3331,1}},
		Description		->	""
	},

	cquqd1x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd1x3332,1}},
		Description		->	""
	},

	cquqd1x3313 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd1x3313,1}},
		Description		->	""
	},

	cquqd1x3323 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd1x3323,1}},
		Description		->	""
	},

	cquqd1x3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd1x3133,1}},
		Description		->	""
	},

	cquqd1x3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd1x3233,1}},
		Description		->	""
	},

	cquqd1x1333 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd1x1333,1}},
		Description		->	""
	},

	cquqd1x2333 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd1x2333,1}},
		Description		->	""
	},

	cquqd1Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd1Ix3331,1}},
		Description		->	""
	},

	cquqd1Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd1Ix3332,1}},
		Description		->	""
	},

	cquqd1Ix3313 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd1Ix3313,1}},
		Description		->	""
	},

	cquqd1Ix3323 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd1Ix3323,1}},
		Description		->	""
	},

	cquqd1Ix3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd1Ix3133,1}},
		Description		->	""
	},

	cquqd1Ix3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd1Ix3233,1}},
		Description		->	""
	},

	cquqd1Ix1333 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd1Ix1333,1}},
		Description		->	""
	},

	cquqd1Ix2333 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd1Ix2333,1}},
		Description		->	""
	},

	cquqd8x3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd8x3331,1}},
		Description		->	""
	},

	cquqd8x3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd8x3332,1}},
		Description		->	""
	},

	cquqd8x3313 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd8x3313,1}},
		Description		->	""
	},

	cquqd8x3323 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd8x3323,1}},
		Description		->	""
	},

	cquqd8x3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd8x3133,1}},
		Description		->	""
	},

	cquqd8x3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd8x3233,1}},
		Description		->	""
	},

	cquqd8x1333 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd8x1333,1}},
		Description		->	""
	},

	cquqd8x2333 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd8x2333,1}},
		Description		->	""
	},

	cquqd8Ix3331 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd8Ix3331,1}},
		Description		->	""
	},

	cquqd8Ix3332 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd8Ix3332,1}},
		Description		->	""
	},

	cquqd8Ix3313 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd8Ix3313,1}},
		Description		->	""
	},

	cquqd8Ix3323 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd8Ix3323,1}},
		Description		->	""
	},

	cquqd8Ix3133 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd8Ix3133,1}},
		Description		->	""
	},

	cquqd8Ix3233 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd8Ix3233,1}},
		Description		->	""
	},

	cquqd8Ix1333 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd8Ix1333,1}},
		Description		->	""
	},

	cquqd8Ix2333 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cquqd8Ix2333,1}},
		Description		->	""
	},

	cqq11x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq11x31ii,1}},
		Description		->	""
	},

	cqq11x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq11x32ii,1}},
		Description		->	""
	},

	cqq11Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq11Ix31ii,1}},
		Description		->	""
	},

	cqq11Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq11Ix32ii,1}},
		Description		->	""
	},

	cqq13x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq13x31ii,1}},
		Description		->	""
	},

	cqq13x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq13x32ii,1}},
		Description		->	""
	},

	cqq13Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq13Ix31ii,1}},
		Description		->	""
	},

	cqq13Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq13Ix32ii,1}},
		Description		->	""
	},

	cqq81x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq81x31ii,1}},
		Description		->	""
	},

	cqq81x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq81x32ii,1}},
		Description		->	""
	},

	cqq81Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq81Ix31ii,1}},
		Description		->	""
	},

	cqq81Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq81Ix32ii,1}},
		Description		->	""
	},

	cqq83x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq83x31ii,1}},
		Description		->	""
	},

	cqq83x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq83x32ii,1}},
		Description		->	""
	},

	cqq83Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq83Ix31ii,1}},
		Description		->	""
	},

	cqq83Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqq83Ix32ii,1}},
		Description		->	""
	},

	cuu1x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cuu1x31ii,1}},
		Description		->	""
	},

	cuu1x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cuu1x32ii,1}},
		Description		->	""
	},

	cuu1Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cuu1Ix31ii,1}},
		Description		->	""
	},

	cuu1Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cuu1Ix32ii,1}},
		Description		->	""
	},

	cuu8x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cuu8x31ii,1}},
		Description		->	""
	},

	cuu8x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cuu8x32ii,1}},
		Description		->	""
	},

	cuu8Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cuu8Ix31ii,1}},
		Description		->	""
	},

	cuu8Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cuu8Ix32ii,1}},
		Description		->	""
	},

	cud1x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud1x31ii,1}},
		Description		->	""
	},

	cud1x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud1x32ii,1}},
		Description		->	""
	},

	cud1Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud1Ix31ii,1}},
		Description		->	""
	},

	cud1Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud1Ix32ii,1}},
		Description		->	""
	},

	cud8x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud8x31ii,1}},
		Description		->	""
	},

	cud8x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud8x32ii,1}},
		Description		->	""
	},

	cud8Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud8Ix31ii,1}},
		Description		->	""
	},

	cud8Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cud8Ix32ii,1}},
		Description		->	""
	},

	cqu1x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu1x31ii,1}},
		Description		->	""
	},

	cqu1x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu1x32ii,1}},
		Description		->	""
	},

	cqu1Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu1Ix31ii,1}},
		Description		->	""
	},

	cqu1Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu1Ix32ii,1}},
		Description		->	""
	},

	cqu8x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu8x31ii,1}},
		Description		->	""
	},

	cqu8x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu8x32ii,1}},
		Description		->	""
	},

	cqu8Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu8Ix31ii,1}},
		Description		->	""
	},

	cqu8Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu8Ix32ii,1}},
		Description		->	""
	},

	cqu1xii31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu1xii31,1}},
		Description		->	""
	},

	cqu1xii32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu1xii32,1}},
		Description		->	""
	},

	cqu1Ixii31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu1Ixii31,1}},
		Description		->	""
	},

	cqu1Ixii32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu1Ixii32,1}},
		Description		->	""
	},

	cqu8xii31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu8xii31,1}},
		Description		->	""
	},

	cqu8xii32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu8xii32,1}},
		Description		->	""
	},

	cqu8Ixii31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu8Ixii31,1}},
		Description		->	""
	},

	cqu8Ixii32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqu8Ixii32,1}},
		Description		->	""
	},

	cqd1x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd1x31ii,1}},
		Description		->	""
	},

	cqd1x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd1x32ii,1}},
		Description		->	""
	},

	cqd1Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd1Ix31ii,1}},
		Description		->	""
	},

	cqd1Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd1Ix32ii,1}},
		Description		->	""
	},

	cqd8Ix31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd8Ix31ii,1}},
		Description		->	""
	},

	cqd8Ix32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd8Ix32ii,1}},
		Description		->	""
	},

	cqd8x31ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd8x31ii,1}},
		Description		->	""
	},

	cqd8x32ii == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cqd8x32ii,1}},
		Description		->	""
	},

	cpbIx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cpbIx31,1},{QED,2}},
		Description		->	""
	},

	cpbIx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cpbIx32,1},{QED,2}},
		Description		->	""
	},

	cpbx31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cpbx31,1},{QED,2}},
		Description		->	""
	},

	cpbx32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cpbx32,1},{QED,2}},
		Description		->	""
	},

	cblSx1x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSx1x13,1}},
		Description		->	""
	},

	cblSx1x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSx1x23,1}},
		Description		->	""
	},

	cblSx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSx1x31,1}},
		Description		->	""
	},

	cblSx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSx1x32,1}},
		Description		->	""
	},

	cblSx2x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSx2x13,1}},
		Description		->	""
	},

	cblSx2x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSx2x23,1}},
		Description		->	""
	},

	cblSx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSx2x31,1}},
		Description		->	""
	},

	cblSx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSx2x32,1}},
		Description		->	""
	},

	cblSx3x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSx3x13,1}},
		Description		->	""
	},

	cblSx3x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSx3x23,1}},
		Description		->	""
	},

	cblSx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSx3x31,1}},
		Description		->	""
	},

	cblSx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSx3x32,1}},
		Description		->	""
	},

	cblSIx1x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSIx1x13,1}},
		Description		->	""
	},

	cblSIx1x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSIx1x23,1}},
		Description		->	""
	},

	cblSIx1x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSIx1x31,1}},
		Description		->	""
	},

	cblSIx1x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSIx1x32,1}},
		Description		->	""
	},

	cblSIx2x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSIx2x13,1}},
		Description		->	""
	},

	cblSIx2x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSIx2x23,1}},
		Description		->	""
	},

	cblSIx2x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSIx2x31,1}},
		Description		->	""
	},

	cblSIx2x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSIx2x32,1}},
		Description		->	""
	},

	cblSIx3x13 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSIx3x13,1}},
		Description		->	""
	},

	cblSIx3x23 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSIx3x23,1}},
		Description		->	""
	},

	cblSIx3x31 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSIx3x31,1}},
		Description		->	""
	},

	cblSIx3x32 == {
		ComplexParameter	->	False,
		ParameterType		->	External,
		Value			->	0.,
		BlockName		->	FCNC,
		InteractionOrder	->	{{FCNC_cblSIx3x32,1}},
		Description		->	""
	}
}
