(***************************************************************************************************************)
(******                       This is the FeynRules mod-file for an Anomaly free Z' model                 ******)
(******                                                                                                   ******)
(******     Author: Sascha Diefenbacher	                                                                  ******)
(******                                                                                                   ******)
(****** Choose whether Feynman gauge is desired.                                                          ******)
(****** If set to False, unitary gauge is assumed.                                                          ****)
(****** Feynman gauge is especially useful for CalcHEP/CompHEP where the calculation is 10-100 times faster. ***)
(****** Feynman gauge is not supported in MadGraph and Sherpa.                                              ****)
(***************************************************************************************************************)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "AnoFree_ZP";

M$Information = {Authors -> {"Sascha D. Diefenbacher"}, 
             Version -> "1.0",
             Date -> "26. 8. 2017",
             Institutions -> {"Uni-Heidelberg"},
             Emails -> {""}
             };

(* ************************** *)
(* *****    Indices     ***** *)
(* ************************** *)




(* Parameter list *) 

M$Parameters = {

(****External Parameters****)
    
	MZptarget == { 
         ParameterType    -> External, 
         Value            -> 300, 
         InteractionOrder -> {Zp,1},  
         TeX              -> Subscript[M, zptarget], 
         Description      -> "mzp target"
    },  
	
	Mn1 == { 
         ParameterType    -> External, 
         Value            -> 250, 
         InteractionOrder -> {Mn1,1},  
         TeX              -> Subscript[M,n1], 
         Description      -> "DM mass"
    },
    
    xi == { 
         ParameterType    -> External, 
         Value            -> 0.1, 
         TeX              -> "Chi", 
         Description      -> "Some mixing thing-y"
    },
    
    QS0 == { 
         ParameterType    -> External, 
         Value            -> 2.0, 
         InteractionOrder -> {QED,1},  
         TeX              -> Subscript[Q,S0], 
         Description      -> "S0 Carge"
    },
    
    QDM == { 
         ParameterType    -> External, 
         Value            -> 1.0, 
         TeX              -> Subscript[Q,DM], 
         Description      -> "DM Carge"
    },
    
    
    gzp == { 
         ParameterType    -> External, 
         Value            -> 1.0, 
         InteractionOrder -> {Zp,1},  
         TeX              -> Subscript[g, zp], 
         Description      -> "Z' gauge coupling"
    },
 
  	chi == { 
         ParameterType    -> External, 
         Value            -> Cos[0.0], 
         TeX              -> "cos(hi)", 
         Description      -> "asljdf"
    },
    
	MStarget == { 
         ParameterType    -> External, 
         Value            -> 200, 
         TeX              -> "MStarget", 
         Description      -> "desired MS0"
    },
    
    MHtarget == { 
         ParameterType    -> External, 
         Value            -> 125, 
         TeX              -> "MHtarget", 
         Description      -> "desred MH"
    },
    
    lambHS == { 
         ParameterType    -> External, 
         Value            -> 0.01, 
         InteractionOrder -> {QED,2},  
         TeX              -> "lambdaHS", 
         Description      -> "lambda Mixing"
    },
  

      

(*************Internal Parameters************)
	
	sxi == { 
         ParameterType    -> Internal, 
         Value            -> Sin[xi], 
         TeX              -> "Sin(xi)", 
         Description      -> "Sin(xi)"
    }, 
    
    cxi == { 
         ParameterType    -> Internal, 
         Value            -> Cos[xi], 
         TeX              -> "Cos(xi)", 
         Description      -> "Cos(xi)"
    },
    
    txi == { 
         ParameterType    -> Internal, 
         Value            -> sxi/cxi, 
         TeX              -> "Tan(xi)", 
         Description      -> "Tan(xi)"
    },
    
	VS == { 
         ParameterType    -> Internal, 
         Value            -> (Sqrt[2]*cxi*MZptarget*Sqrt[-MZ^2 + MZptarget^2 - MZ^2*sw^2*txi^2])/(gzp*Sqrt[-MZ^2 + MZptarget^2]*QS0), 
         InteractionOrder -> {QED,-1},  
         TeX              -> Subscript[vev, S0], 
         Description      -> "vev of S0"
    },
	
	lambS == { 
         ParameterType    -> Internal, 
         Value            -> (MStarget^2 + MHtarget^2 + Sqrt[(MStarget^2-MHtarget^2)^2-(2*lambHS*vev*VS)^2])/(2*VS*VS), 
         InteractionOrder -> {QED,2},  
         TeX              -> Subscript[#lambda, S0], 
         Description      -> "lambda S0"
    },  
    
    lambH == { 
         ParameterType    -> Internal, 
         Value            -> (MStarget^2 + MHtarget^2)/(vev*vev) - lambS*VS*VS/vev/vev,
		 InteractionOrder -> {QED,2},  
         TeX              -> Subscript[#lambda, H], 
         Description      -> "lambda H"
    },
	
    
    zi == { 
         ParameterType    -> Internal, 
         Value            -> (1/2)*ArcTan[2*MZ^2*txi*sw/(MZ^2(1-sw^2*txi^2) - xs*vev^2/(2*cxi^2*VS^2)*(gzp*QS0*VS)^2)], 
         TeX              -> "zi", 
         Description      -> "other mixing thing"
    },
    
    szi == { 
         ParameterType    -> Internal, 
         Value            -> Sin[zi], 
         TeX              -> "Sin(zi)", 
         Description      -> "Sin(zi)"
    }, 
    
    czi == { 
         ParameterType    -> Internal, 
         Value            -> Cos[zi], 
         TeX              -> "Cos(zi)", 
         Description      -> "Cos(zi)"
    },
      
	alp == { 
         ParameterType    -> Internal, 
         Value            -> (1/2)*ArcTan[2*lambHS*vev*VS/(lambH*vev*vev-lambS*VS*VS)], 
         TeX              -> "alpha", 
         Description      -> "Higgs S0 Mixing"
    }, 
	
	xs == { 
         ParameterType    -> Internal, 
         Value            -> (VS/vev)^2, 
         TeX              -> "xs", 
         Description      -> "xs"
    }, 
    
    sal == { 
         ParameterType    -> Internal, 
         Value            -> Sin[alp], 
         TeX              -> "Sin(alpha)", 
         Description      -> "Sin(alpha)"
    }, 
    
    cal == { 
         ParameterType    -> Internal, 
         Value            -> Cos[alp], 
         TeX              -> "Cos(alpha)", 
         Description      -> "Cos(alpha)"
    },
	
	ozp == { 
         ParameterType    -> Internal, 
         Value            -> 1, 
         InteractionOrder -> {Zp,1},  
         TeX              -> "orderzp", 
         Description      -> "orderzp"
    },
    
    MS0 == { 
         ParameterType    -> Internal, 
         Value            -> Sqrt[(1/2)*(lambH*vev*vev+lambS*VS*VS + Sqrt[(lambH*vev*vev-lambS*VS*VS)^2+(2*lambHS*vev*VS)^2])],
         TeX              -> Subscript[M,S0], 
         Description      -> "Mass S0 after Mixing"
    }, 
	
	MZp == { 
         ParameterType    -> Internal, 
         Value            -> Sqrt[(1/2)*(vev/vev)^2*(MZ^2*(1+txi^2*sw^2) + xs*vev^2/(2*cxi^2*VS^2)*(gzp*QS0*VS)^2
         					+ Sqrt[(MZ^2*(1+txi^2*sw^2) + xs*vev^2/(2*cxi^2*VS^2)*(gzp*QS0*VS)^2)^2 - 2*xs*vev^2/(cxi^2*VS^2)*(gzp*QS0*VS)^2*MZ^2])],
         TeX              -> Subscript[M,zp], 
         Description      -> "Z' Mass"
    }
};


(*****************************************************************************)
(*              New fields                                                   *)
(*****************************************************************************)

(************* New Quarks ***********)

M$ClassesDescription = {

(* Gauge bosons: physical vector fields *)  


  S[4] == {
	ClassName        -> S0,
	SelfConjugate    -> True,
	Indices          -> {},
	Mass             -> {MS0, Internal},
	Width            -> {WS0, 1.},
	ParticleName     -> "S0",
	PDG              -> 200002100,
	PropagatorLabel  -> "S0",
	PropagatorType   -> ScalarDash,
	PropagatorArrow  -> None},
	
  F[7] == { 
    ClassName 	      -> dm,
    SelfConjugate     -> False,
    Mass	     -> {Mn1, Internal},
    Width            -> 0,
    PDG              -> 200002200,
    ParticleName     -> {"dm"},
    AntiParticleName -> {"dm~"},
    TeX 	      -> "dm",
    FullName	      -> "Dirac DM" },
  
  V[5] == { 
    ClassName       -> Zp, 
    SelfConjugate   -> True,
    Mass            -> {MZp, Internal},
    Width           -> {WZp, 1}, 
    ParticleName    -> "Zp", 
    PDG             -> 23000, 
    PropagatorLabel -> "Zp",
    PropagatorType  -> Sine,
    PropagatorArrow -> None,
    FullName        -> "Zp"
  }
};

(*****************************************************************************)
(*              New Lagrangian Terms                                         *)
(*****************************************************************************)

(*********************)
(**** Kinetic terms***)
(*********************)

LZPkin :=   -1/4 FS[Zp,mu,nu] FS[Zp,mu,nu] + (MZp^2/2) Zp[mu].Zp[mu];

LS0kin := 1/2 del[S0, mu] del[S0, mu] - 1/2 MS0^2 S0^2;

LNewkin := LZPkin + LS0kin;

(*******************************)
(**** Z Z' H S0 interactions ***)
(*******************************)

(*LZHSMneg := -chi*(cw^2 + sw^2)^2*vev^2*ee^2/4 Z[mu].Z[mu]  H;*)
LZHSMneg := -chi*(MZ^2/(vev)) Z[mu].Z[mu]  H;

LHS0ZZ := Z[mu].Z[mu] ( (MZ^2/(vev))*(cal H + sal S0)*(czi+sw*szi*txi)^2 + ((gzp*QS0*VS/ozp)^2/(VS))*(cal S0 - sal H)*(szi^2/cxi^2) );

LHS0ZPZP := Zp[mu].Zp[mu] ( (MZ^2/(vev))*(cal H + sal S0)*(-szi+sw*czi*txi)^2 + ((gzp*QS0*VS/ozp)^2/(VS))*(cal S0 - sal H)*(czi^2/cxi^2) );

LHS0ZZP := 2*( (MZ^2/(vev))*(cal*(Zp[mu].Z[mu] H) + sal*(Zp[mu].Z[mu] S0))*(czi+sw*szi*txi)*(-szi+sw*czi*txi) + ((gzp*QS0*VS/ozp)^2/(VS))*(cal*(Zp[mu].Z[mu] S0) - sal*(Zp[mu].Z[mu] H))*(szi*czi/cxi^2) );

LHS0ZZPtotal := LHS0ZZ + LHS0ZZP + LHS0ZPZP;


(*****************************)
(**** H S0 SM interactions ***)
(*****************************)

(*LHHHHneg := chi*lam/4*(vev + H)^4;*)

LS0S0HH :=  S0 H H*(-3 cal^2 lambH sal vev + 2 cal^2 lambHS sal vev - lambHS sal^3 vev + cal^3 lambHS VS - 2 cal lambHS sal^2 VS + 3 cal lambS sal^2 VS)
           +S0 H*ozp*(-3 cal lambH sal vev^2 + cal lambHS sal vev^2 + 2 cal^2 lambHS vev VS - 2 lambHS sal^2 vev VS - cal lambHS sal VS^2 + 3 cal lambS sal VS^2);

LHSMneg := -chi*H*((1/Sqrt[2])*ydo dbar.d + (1/Sqrt[2])*yup ubar.u + (1/Sqrt[2])*ys sbar.s + (1/Sqrt[2])*yc cbar.c + (1/Sqrt[2])*yb bbar.b + (1/Sqrt[2])*yt tbar.t +  (1/Sqrt[2])*ye ebar.e + (1/Sqrt[2])*ym mubar.mu + (1/Sqrt[2])*ytau tabar.ta + ee^2*vev/(2*sw^2) W[mu].Wbar[mu]);

LHS0SM := (cal*H + sal*S0)*((1/Sqrt[2])*ydo dbar.d + (1/Sqrt[2])*yup ubar.u + (1/Sqrt[2])*ys sbar.s + (1/Sqrt[2])*yc cbar.c + (1/Sqrt[2])*yb bbar.b + (1/Sqrt[2])*yt tbar.t +  (1/Sqrt[2])*ye ebar.e + (1/Sqrt[2])*ym mubar.mu + (1/Sqrt[2])*ytau tabar.ta + ee^2*vev/(2*sw^2) W[mu].Wbar[mu]);

LHS0SMtotal :=LHSMneg + LHS0SM + LS0S0HH;

(*****************************)
(**** Z Z' SM interactions ***)
(*****************************)

LZJEM :=-cw*szi*txi*ee*( (-1)*ebar.Ga[mu].e Z[mu]   +   (2/3)*ubar.Ga[mu].u Z[mu] + (-1/3)*dbar.Ga[mu].d Z[mu] +
                      (-1)*mubar.Ga[mu].mu Z[mu] +   (2/3)*cbar.Ga[mu].c Z[mu] + (-1/3)*sbar.Ga[mu].s Z[mu] +
                      (-1)*tabar.Ga[mu].ta Z[mu] +   (2/3)*tbar.Ga[mu].t Z[mu] + (-1/3)*bbar.Ga[mu].b Z[mu] );

LZPJEM :=-cw*czi*txi*ee*( (-1)*ebar.Ga[mu].e Zp[mu]   +   (2/3)*ubar.Ga[mu].u Zp[mu] + (-1/3)*dbar.Ga[mu].d Zp[mu] +
                       (-1)*mubar.Ga[mu].mu Zp[mu] +   (2/3)*cbar.Ga[mu].c Zp[mu] + (-1/3)*sbar.Ga[mu].s Zp[mu] +
                       (-1)*tabar.Ga[mu].ta Zp[mu] +   (2/3)*tbar.Ga[mu].t Zp[mu] + (-1/3)*bbar.Ga[mu].b Zp[mu] );

JZJZSMneg := ee/(sw*cw)*(-chi)*( (1/2)*left[vlbar].Ga[mu].left[vl] Z[mu] + (-(1/2)+sw^2)*left[lbar].Ga[mu].left[l] Z[mu] + (sw^2)*right[lbar].Ga[mu].right[l] Z[mu]
                                     +((1/2)-(2/3)*sw^2)*left[uqbar].Ga[mu].left[uq] Z[mu] + (-(2/3)*sw^2)*right[uqbar].Ga[mu].right[uq] Z[mu]
                                     +(-(1/2)+(1/3)*sw^2)*left[dqbar].Ga[mu].left[dq] Z[mu] + ((1/3)*sw^2)*right[dqbar].Ga[mu].right[dq] Z[mu] );



LZJZ := ee/(sw*cw)*(czi+sw*szi*txi)*( (1/2)*left[vebar].Ga[mu].left[ve] Z[mu] + (-(1/2)+sw^2)*left[ebar].Ga[mu].left[e] Z[mu] + (sw^2)*right[ebar].Ga[mu].right[e] Z[mu]
                                     +((1/2)-(2/3)*sw^2)*left[ubar].Ga[mu].left[u] Z[mu] + (-(2/3)*sw^2)*right[ubar].Ga[mu].right[u] Z[mu]
                                     +(-(1/2)+(1/3)*sw^2)*left[dbar].Ga[mu].left[d] Z[mu] + ((1/3)*sw^2)*right[dbar].Ga[mu].right[d] Z[mu] 
                                     +(1/2)*left[vmbar].Ga[mu].left[vm] Z[mu] + (-(1/2)+sw^2)*left[mubar].Ga[mu].left[mu] Z[mu] + (sw^2)*right[mubar].Ga[mu].right[mu] Z[mu]
                                     +((1/2)-(2/3)*sw^2)*left[cbar].Ga[mu].left[c] Z[mu] + (-(2/3)*sw^2)*right[cbar].Ga[mu].right[c] Z[mu]
                                     +(-(1/2)+(1/3)*sw^2)*left[sbar].Ga[mu].left[s] Z[mu] + ((1/3)*sw^2)*right[sbar].Ga[mu].right[s] Z[mu] 
                                     +(1/2)*left[vtbar].Ga[mu].left[vt] Z[mu] + (-(1/2)+sw^2)*left[tabar].Ga[mu].left[ta] Z[mu] + (sw^2)*right[tabar].Ga[mu].right[ta] Z[mu]
                                     +((1/2)-(2/3)*sw^2)*left[tbar].Ga[mu].left[t] Z[mu] + (-(2/3)*sw^2)*right[tbar].Ga[mu].right[t] Z[mu]
                                     +(-(1/2)+(1/3)*sw^2)*left[bbar].Ga[mu].left[b] Z[mu] + ((1/3)*sw^2)*right[bbar].Ga[mu].right[b] Z[mu] );

LZPJZ := ee/(sw*cw)*(-szi+sw*czi*txi)*((1/2)*left[vebar].Ga[mu].left[ve] Zp[mu] + (-(1/2)+sw^2)*left[ebar].Ga[mu].left[e] Zp[mu] + (sw^2)*right[ebar].Ga[mu].right[e] Zp[mu]
                                     +((1/2)-(2/3)*sw^2)*left[ubar].Ga[mu].left[u] Zp[mu] + (-(2/3)*sw^2)*right[ubar].Ga[mu].right[u] Zp[mu]
                                     +(-(1/2)+(1/3)*sw^2)*left[dbar].Ga[mu].left[d] Zp[mu] + ((1/3)*sw^2)*right[dbar].Ga[mu].right[d] Zp[mu] 
                                     +(1/2)*left[vmbar].Ga[mu].left[vm] Zp[mu] + (-(1/2)+sw^2)*left[mubar].Ga[mu].left[mu] Zp[mu] + (sw^2)*right[mubar].Ga[mu].right[mu] Zp[mu]
                                     +((1/2)-(2/3)*sw^2)*left[cbar].Ga[mu].left[c] Zp[mu] + (-(2/3)*sw^2)*right[cbar].Ga[mu].right[c] Zp[mu]
                                     +(-(1/2)+(1/3)*sw^2)*left[sbar].Ga[mu].left[s] Zp[mu] + ((1/3)*sw^2)*right[sbar].Ga[mu].right[s] Zp[mu] 
                                     +(1/2)*left[vtbar].Ga[mu].left[vt] Zp[mu] + (-(1/2)+sw^2)*left[tabar].Ga[mu].left[ta] Zp[mu] + (sw^2)*right[tabar].Ga[mu].right[ta] Zp[mu]
                                     +((1/2)-(2/3)*sw^2)*left[tbar].Ga[mu].left[t] Zp[mu] + (-(2/3)*sw^2)*right[tbar].Ga[mu].right[t] Zp[mu]
                                     +(-(1/2)+(1/3)*sw^2)*left[bbar].Ga[mu].left[b] Zp[mu] + ((1/3)*sw^2)*right[bbar].Ga[mu].right[b] Zp[mu] );



LZWWneg  = -chi*(1/2)*gw*((del[(W[nu] + Wbar[nu])/Sqrt[2],   mu] -   del[(W[mu] + Wbar[mu])/Sqrt[2],   nu])*   (Wbar[mu] - W[mu])/Sqrt[2]/I *cw*Z[nu]	                  - 
                          (del[(W[nu] + Wbar[nu])/Sqrt[2],   mu] -   del[(W[mu] + Wbar[mu])/Sqrt[2],   nu])*   cw*Z[mu]                     *(Wbar[nu] - W[nu])/Sqrt[2]/I +
                          (del[cw*Z[nu],                     mu] -   del[cw*Z[mu],                     nu])*   (W[mu] + Wbar[mu])/Sqrt[2]   *(Wbar[nu] - W[nu])/Sqrt[2]/I -
   						  (del[cw*Z[nu],                     mu] -   del[cw*Z[mu],                     nu])*   (Wbar[mu] - W[mu])/Sqrt[2]/I *(W[nu] + Wbar[nu])/Sqrt[2]   +
                          (del[(Wbar[nu] - W[nu])/Sqrt[2]/I, mu] -   del[(Wbar[mu] - W[mu])/Sqrt[2]/I, nu])*   cw*Z[mu]                     *(W[nu] + Wbar[nu])/Sqrt[2]   -
                          (del[(Wbar[nu] - W[nu])/Sqrt[2]/I, mu] -   del[(Wbar[mu] - W[mu])/Sqrt[2]/I, nu])*   (W[mu] + Wbar[mu])/Sqrt[2]   *cw*Z[nu]);                     
                         

LZWW =   ((czi+sw*szi*txi)  -cw*szi*txi*(sw/cw))*(1/2)*gw*((del[(W[nu] + Wbar[nu])/Sqrt[2],   mu] -   del[(W[mu] + Wbar[mu])/Sqrt[2],   nu])*   (Wbar[mu] - W[mu])/Sqrt[2]/I *cw*Z[nu]	                  - 
                                                           (del[(W[nu] + Wbar[nu])/Sqrt[2],   mu] -   del[(W[mu] + Wbar[mu])/Sqrt[2],   nu])*   cw*Z[mu]                     *(Wbar[nu] - W[nu])/Sqrt[2]/I +
                                                           (del[cw*Z[nu],                     mu] -   del[cw*Z[mu],                     nu])*   (W[mu] + Wbar[mu])/Sqrt[2]   *(Wbar[nu] - W[nu])/Sqrt[2]/I -
   						                                   (del[cw*Z[nu],                     mu] -   del[cw*Z[mu],                     nu])*   (Wbar[mu] - W[mu])/Sqrt[2]/I *(W[nu] + Wbar[nu])/Sqrt[2]   +
                                                           (del[(Wbar[nu] - W[nu])/Sqrt[2]/I, mu] -   del[(Wbar[mu] - W[mu])/Sqrt[2]/I, nu])*   cw*Z[mu]                     *(W[nu] + Wbar[nu])/Sqrt[2]   -
                                                           (del[(Wbar[nu] - W[nu])/Sqrt[2]/I, mu] -   del[(Wbar[mu] - W[mu])/Sqrt[2]/I, nu])*   (W[mu] + Wbar[mu])/Sqrt[2]   *cw*Z[nu]);                     
                         
LZPWW =  ((-szi+sw*czi*txi) -cw*czi*txi*(sw/cw))*(1/2)*gw*((del[(W[nu] + Wbar[nu])/Sqrt[2],   mu] -   del[(W[mu] + Wbar[mu])/Sqrt[2],   nu])*   (Wbar[mu] - W[mu])/Sqrt[2]/I *cw*Zp[nu]                  - 
                                                           (del[(W[nu] + Wbar[nu])/Sqrt[2],   mu] -   del[(W[mu] + Wbar[mu])/Sqrt[2],   nu])*   cw*Zp[mu]                    *(Wbar[nu] - W[nu])/Sqrt[2]/I +
                                                           (del[cw*Zp[nu],                    mu] -   del[cw*Zp[mu],                    nu])*   (W[mu] + Wbar[mu])/Sqrt[2]   *(Wbar[nu] - W[nu])/Sqrt[2]/I -
   						                                   (del[cw*Zp[nu],                    mu] -   del[cw*Zp[mu],                    nu])*   (Wbar[mu] - W[mu])/Sqrt[2]/I *(W[nu] + Wbar[nu])/Sqrt[2]   +
                                                           (del[(Wbar[nu] - W[nu])/Sqrt[2]/I, mu] -   del[(Wbar[mu] - W[mu])/Sqrt[2]/I, nu])*   cw*Zp[mu]                    *(W[nu] + Wbar[nu])/Sqrt[2]   -
                                                           (del[(Wbar[nu] - W[nu])/Sqrt[2]/I, mu] -   del[(Wbar[mu] - W[mu])/Sqrt[2]/I, nu])*   (W[mu] + Wbar[mu])/Sqrt[2]   *cw*Zp[nu]);                     



LZJBmL :=  gzp*(szi/cxi)*((-1)*vebar.Ga[mu].ve + (-1)*ebar.Ga[mu].e   + (1/3)*ubar.Ga[mu].u + (1/3)*dbar.Ga[mu].d+
                          (-1)*vmbar.Ga[mu].vm + (-1)*mubar.Ga[mu].mu + (1/3)*cbar.Ga[mu].c + (1/3)*sbar.Ga[mu].s+
                          (-1)*vtbar.Ga[mu].vt + (-1)*tabar.Ga[mu].ta + (1/3)*tbar.Ga[mu].t + (1/3)*bbar.Ga[mu].b)*Z[mu];

LZPJBmL := gzp*(czi/cxi)*((-1)*vebar.Ga[mu].ve + (-1)*ebar.Ga[mu].e   + (1/3)*ubar.Ga[mu].u + (1/3)*dbar.Ga[mu].d+
                          (-1)*vmbar.Ga[mu].vm + (-1)*mubar.Ga[mu].mu + (1/3)*cbar.Ga[mu].c + (1/3)*sbar.Ga[mu].s+
                          (-1)*vtbar.Ga[mu].vt + (-1)*tabar.Ga[mu].ta + (1/3)*tbar.Ga[mu].t + (1/3)*bbar.Ga[mu].b)*Zp[mu];

LZJMUTAU :=  gzp*(szi/cxi)*((1)*mubar.Ga[mu].mu + (-1)*tabar.Ga[mu].ta + (1)*vmbar.Ga[mu].vm + (-1)*vtbar.Ga[mu].vt)*Z[mu];

LZPJMUTAU := gzp*(czi/cxi)*((1)*mubar.Ga[mu].mu + (-1)*tabar.Ga[mu].ta + (1)*vmbar.Ga[mu].vm + (-1)*vtbar.Ga[mu].vt)*Zp[mu];


LZDM := gzp*(szi/cxi)*QDM*dmbar.Ga[mu].dm*Z[mu];

LZPDM := gzp*(czi/cxi)*QDM*dmbar.Ga[mu].dm*Zp[mu];

LZZPSMtotal := LZJEM + LZPJEM + JZJZSMneg + LZJZ + LZPJZ + LZPDM + LZDM + LZWWneg + LZWW + LZPWW;


Ltotal := LSM + LNewkin + LHS0ZZPtotal + LHS0SMtotal + LZZPSMtotal + LZPJMUTAU + LZJMUTAU;
