(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22236,        545]
NotebookOptionsPosition[     18643,        484]
NotebookOutlinePosition[     19116,        502]
CellTagsIndexPosition[     19073,        499]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"R", ".", " ", "Ruiz"}], ";", " ", 
   RowBox[{"2022", " ", "June"}]}], "  ", "*)"}]], "Input",
 CellChangeTimes->{{3.665142881510211*^9, 3.665142884049021*^9}, {
  3.665142942303646*^9, 3.6651429529879627`*^9}, {3.8578849922141743`*^9, 
  3.857884996676725*^9}, {3.865578290201123*^9, 
  3.865578290708436*^9}},ExpressionUUID->"cee4e897-cbc1-4bf1-a304-\
44bbfcd5aed3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "generate", " ", "LO", " ", 
     RowBox[{"UFO", ":", " ", 
      RowBox[{"Set", " ", "paths"}]}]}], ",", " ", 
    RowBox[{"load", " ", "model"}], ",", " ", 
    RowBox[{"write", " ", "UFO"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "generate", " ", "NLO", " ", 
     RowBox[{"UFO", ":", " ", 
      RowBox[{"Set", " ", "paths"}]}]}], ",", " ", 
    RowBox[{"load", " ", "model"}], ",", " ", 
    RowBox[{
     RowBox[{"extract", " ", "on"}], "-", 
     RowBox[{"shell", " ", "renormalization", " ", "terms"}]}], ",", " ", 
    RowBox[{"write", " ", "CT", " ", "terms"}], ",", " ", 
    RowBox[{"reset", " ", "paths"}], ",", " ", 
    RowBox[{"reload", " ", "model"}], ",", " ", 
    RowBox[{"write", " ", "everything", " ", "to", " ", 
     RowBox[{"file", "."}]}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.6648662671878157`*^9, 3.664866418502534*^9}, {
  3.664866852892112*^9, 
  3.664866879416404*^9}},ExpressionUUID->"4149d1d2-f5f9-4692-ab77-\
ed3366c4e0f7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.800203881213688*^9, 3.800203885091346*^9}, {
  3.814192661966413*^9, 3.81419266729278*^9}, {3.814196498380603*^9, 
  3.814196499409697*^9}, {3.814196533345257*^9, 3.814196534014574*^9}, {
  3.814537179057211*^9, 3.814537179988576*^9}, {3.817278556475902*^9, 
  3.817278557221746*^9}, {3.8308506728039427`*^9, 3.83085067396842*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"2dd3093a-c7ea-41c7-a007-d589dc397211"],

Cell[CellGroupData[{

Cell["FeynRules Setup", "Title",
 CellChangeTimes->{{3.596207285657744*^9, 3.596207286276866*^9}, {
  3.596207330352247*^9, 3.59620733250506*^9}, {3.655035967648223*^9, 
  3.65503597269068*^9}},ExpressionUUID->"36a8985f-3b71-4bb1-acae-\
6fbe5493c081"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$CurrentPath", "=", 
   RowBox[{"Directory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", "\"\<~/Scripts/FeynRules/FeynRules\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$CurrentPath", "]"}], ";"}]}], "Input",Express\
ionUUID->"c02dce38-3048-4633-94e9-e77e8ef0c800"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Load", " ", "default", " ", "SM", " ", "file", " ", "v1", ".4", 
   RowBox[{".7", "."}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.6550381551475554`*^9, 3.655038155711425*^9}, {
   3.6622141225281467`*^9, 3.662214139672209*^9}, {3.730294820431093*^9, 
   3.730294820982045*^9}, 
   3.8655804703528767`*^9},ExpressionUUID->"d74de1e8-93f7-4afe-980e-\
8f4e6a416a1f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"isLeptonMassive", "=", "True"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"switch", " ", "for", " ", 
    RowBox[{"massless", " ", "/", " ", "massive"}], " ", "charged", " ", 
    "leptons"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<sm.fr\>\"", ",", "\"\<zeebabu_NLO_public.fr\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{"isLeptonMassive", ",", "\[IndentingNewLine]", 
    RowBox[{"LoadRestriction", "[", 
     RowBox[{"\"\<diagonalCKM.rst\>\"", ",", "\"\<massless_quarks.rst\>\""}], 
     "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"LoadRestriction", "[", 
     RowBox[{"\"\<diagonalCKM.rst\>\"", ",", "\"\<massless.rst\>\""}], 
     "]"}]}], "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]}], "Input",ExpressionUUID->\
"5ea88f54-35d3-4b35-bd98-245cd541651b"],

Cell[CellGroupData[{

Cell["New Feynman Rules for ZB Interactions", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, {
  3.572348211890565*^9, 3.572348234275403*^9}, {3.596207324453108*^9, 
  3.596207326711195*^9}, {3.655036212669145*^9, 3.6550362220422897`*^9}, {
  3.655036282693001*^9, 3.655036287060457*^9}, {3.655037866940884*^9, 
  3.6550378926486187`*^9}, {3.662214296374611*^9, 3.662214296674329*^9}, {
  3.865578449133216*^9, 
  3.8655784503336477`*^9}},ExpressionUUID->"430f6c12-ab98-447b-8fa4-\
8a13c875b6c3"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"The", " ", "following", " ", "warnings", " ", "will", " ", 
   RowBox[{"appear", ":", " ", 
    RowBox[{
    "\"\<\!\(\*StyleBox[\"QN\", \"MessageName\"]\)\!\(\*StyleBox[\"::\", \
\"MessageName\"]\)\!\(\*StyleBox[\"NonConserv\", \"MessageName\"]\): \>\"", 
     "Warning"}], ":", " ", 
    RowBox[{
    "non", " ", "quantum", " ", "number", " ", "conserving", " ", "vertex", 
     " ", 
     RowBox[{"encountered", "!"}], 
     "\"\<;\nThis is expected as Lepton Number is violated and FeynRules \
checks for this.\>"}]}]}], "*)"}]], "Input",ExpressionUUID->"ace2f1a4-cdb5-\
4121-9963-39b4d1feecad"],

Cell[BoxData[{"LZBKin", "\[IndentingNewLine]", 
 RowBox[{"FeynmanRules", "[", "LZBKin", "]"}]}], "Input",
 CellChangeTimes->{{3.5723482442775097`*^9, 3.572348252612296*^9}, {
  3.596212546796714*^9, 3.596212547440735*^9}, {3.655037865036394*^9, 
  3.6550378653420067`*^9}, {3.6622141995703773`*^9, 3.6622142141549997`*^9}, {
  3.857877763779788*^9, 3.857877766487311*^9}, {3.865578361212719*^9, 
  3.86557836149465*^9}},ExpressionUUID->"4b15b6dc-b821-4c12-bd21-\
ceb678b9a346"],

Cell[BoxData[{"Lkll", "\[IndentingNewLine]", 
 RowBox[{"ExpandIndices", "[", "Lkll", "]"}]}], "Input",
 CellChangeTimes->{{3.6622142327067413`*^9, 3.662214233288702*^9}, {
   3.857877874835691*^9, 3.857877880139495*^9}, {3.857878029397729*^9, 
   3.857878052035183*^9}, {3.85787818070706*^9, 3.8578781868335533`*^9}, {
   3.857878442957178*^9, 3.857878443624498*^9}, {3.857889837254807*^9, 
   3.8578898455728083`*^9}, 
   3.865578418659614*^9},ExpressionUUID->"e6072a7f-a1db-426d-b53f-\
0b3a0d059746"],

Cell[BoxData[{"Lhll", "\[IndentingNewLine]", 
 RowBox[{"ExpandIndices", "[", "Lhll", "]"}]}], "Input",
 CellChangeTimes->{{3.6622142357666893`*^9, 3.6622142376786947`*^9}, 
   3.662826298532291*^9, {3.857877985083164*^9, 3.857877986765386*^9}, {
   3.865578409051498*^9, 
   3.865578412702682*^9}},ExpressionUUID->"e4b33362-cb94-4ba2-a771-\
443401bf60bf"],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "Llnv", "]"}]], "Input",ExpressionUUID->"d12be5a0-8a03-4271-bb2f-33d3a6709310"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Basic checks for new Lagrangian terms", "Section",
 CellChangeTimes->{{3.4234156496121893`*^9, 3.423415657027569*^9}, {
  3.655037883884348*^9, 3.655037906883815*^9}, {3.865293916945572*^9, 
  3.8652939246393557`*^9}},ExpressionUUID->"963bd5da-1517-491b-8768-\
3e81fb288ca2"],

Cell[BoxData[{
 RowBox[{"CheckHermiticity", "[", "LZB", "]"}], "\[IndentingNewLine]", 
 RowBox[{"CheckMassSpectrum", "[", "LZB", "]"}], "\[IndentingNewLine]", 
 RowBox[{"CheckKineticTermNormalisation", "[", "LZB", "]"}]}], "Input",Express\
ionUUID->"bf30a8c1-c27e-4d9e-896e-422310148051"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UFO Output", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.59620768137986*^9, 
   3.596207684212212*^9}},ExpressionUUID->"47f009e8-0603-4d37-95af-\
884018211353"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"The", " ", "following", " ", "warnings", " ", "will", " ", 
   RowBox[{"appear", ":", " ", 
    RowBox[{
    "\"\<\!\(\*StyleBox[\"QN\", \"MessageName\"]\)\!\(\*StyleBox[\"::\", \
\"MessageName\"]\)\!\(\*StyleBox[\"NonConserv\", \"MessageName\"]\): \>\"", 
     "Warning"}], ":", " ", 
    RowBox[{
    "non", " ", "quantum", " ", "number", " ", "conserving", " ", "vertex", 
     " ", 
     RowBox[{"encountered", "!"}], 
     "\"\<;\nThis is expected as lepton number is violated and FeynRules \
checks for this.\>"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.656940935403554*^9, 3.656940952617087*^9}, {
  3.6648662530247602`*^9, 
  3.664866256652151*^9}},ExpressionUUID->"95ec60e1-8ba3-42ae-912b-\
c6b75ece5652"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LpQCD", " ", "=", " ", 
   RowBox[{"ExpandIndices", "/@", 
    RowBox[{"Expand", "[", 
     RowBox[{"LSM", "+", "LZB"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{"isLeptonMassive", ",", "\[IndentingNewLine]", 
    RowBox[{"WriteUFO", "[", 
     RowBox[{"LpQCD", ",", 
      RowBox[{
      "Output", "\[Rule]", "\"\<SM_ZeeBabu_MassiveLeptons_XLO\>\""}]}], "]"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{"WriteUFO", "[", 
     RowBox[{"LpQCD", ",", 
      RowBox[{"Output", "\[Rule]", "\"\<SM_ZeeBabu_XLO\>\""}]}], "]"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}]}], "Input",ExpressionUUID->"34c50153-\
1c7b-45c0-b793-17a5f54e6210"]
}, Open  ]],

Cell[CellGroupData[{

Cell["On-Shell Renormalization with FeynArts", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.59620768137986*^9, 3.596207684212212*^9}, {3.662199318805483*^9, 
   3.6621993287719097`*^9}, {3.662216149623213*^9, 
   3.662216170908692*^9}},ExpressionUUID->"f35c5a82-2f44-4096-9399-\
e82f5b97ff8d"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"The", " ", "following", " ", "warnings", " ", "will", " ", 
   RowBox[{"appear", ":", " ", 
    RowBox[{
    "\"\<\!\(\*StyleBox[\"QN\", \"MessageName\"]\)\!\(\*StyleBox[\"::\", \
\"MessageName\"]\)\!\(\*StyleBox[\"NonConserv\", \"MessageName\"]\): \>\"", 
     "Warning"}], ":", " ", 
    RowBox[{
    "non", " ", "quantum", " ", "number", " ", "conserving", " ", "vertex", 
     " ", 
     RowBox[{"encountered", "!"}], 
     "\"\<;\nThis is expected as lepton number is violated and FeynRules \
checks for this.\>"}]}]}], "*)"}]], "Input",ExpressionUUID->"eafcd19a-c48f-\
46e1-8302-30202d5af7c6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LRen", " ", "=", " ", 
   RowBox[{"OnShellRenormalization", "[", 
    RowBox[{
     RowBox[{"LSM", "+", "LZB"}], ",", 
     RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
     RowBox[{"FlavorMixing", "\[Rule]", " ", "False"}], ",", 
     RowBox[{"Exclude4ScalarsCT", "\[Rule]", "True"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SetDirectory", "[", 
  "\"\<~/Scripts/FeynArts/FeynArts-3.11/Models\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteFeynArtsOutput", "[", 
   RowBox[{"LRen", ",", 
    RowBox[{"GenericFile", "\[Rule]", "True"}], ",", 
    RowBox[{"FlavorExpand", "\[Rule]", "True"}], ",", 
    RowBox[{"Output", "\[Rule]", "\"\<SM_ZeeBabu_FA\>\""}]}], "]"}], 
  ";"}]}], "Input",ExpressionUUID->"02f82583-a5c0-4ac9-8b08-6f2cc230ee4b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Write Counter Terms to BSM.nlo", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.59620768137986*^9, 3.596207684212212*^9}, {3.662199461128889*^9, 
   3.662199467953211*^9}, {3.662216541485611*^9, 
   3.662216544705964*^9}},ExpressionUUID->"637e3231-e751-489a-ad59-\
470d98c11b8b"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"quit", " ", "kernel", " ", "before", " ", "continuing"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.664866502336069*^9, 
  3.664866536918194*^9}},ExpressionUUID->"558b9e27-1057-416f-a429-\
231889bb6a86"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"3640fc82-001c-4a97-8551-70d99a9b683d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\<~/Scripts/FeynArts/FeynArts-3.11/\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynArts`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<~/Scripts/FeynRules/FeynRules\>\"", "]"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "NLOCT`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$CurrentPath", "=", 
   RowBox[{"NotebookDirectory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$CurrentPath", "]"}], ";"}]}], "Input",Express\
ionUUID->"415ceffa-5035-4fe0-bcb8-4cc2ac3a3a63"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Note", ":", " ", 
     RowBox[{"Grab", " ", "some", " ", "coffee"}]}], ";", " ", 
    RowBox[{"this", " ", "will", " ", "take", " ", "a", " ", "few", " ", 
     RowBox[{"minutes", ".", " ", "Output"}], " ", "is", " ", "located", " ", 
     "in", " ", "FeynRules", " ", 
     RowBox[{"directory", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"WriteCT", "[", 
   RowBox[{
   "\"\<SM_ZeeBabu_FA/SM_ZeeBabu_FA\>\"", ",", 
    "\"\<SM_ZeeBabu_FA/SM_ZeeBabu_FA\>\"", ",", 
    RowBox[{"Output", "\[Rule]", "\"\<SM_ZeeBabu\>\""}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ZeroMom", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"aS", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"F", "[", "7", "]"}], ",", 
          RowBox[{"V", "[", "4", "]"}], ",", 
          RowBox[{"-", 
           RowBox[{"F", "[", "7", "]"}]}]}], "}"}]}], "}"}], "}"}]}], ",", 
    RowBox[{"ComplexMass", "\[Rule]", "False"}], ",", 
    RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
    RowBox[{"Exclude4ScalarsCT", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.865584086094201*^9, 
  3.865584090328697*^9}},ExpressionUUID->"7744ad0f-d54b-4fc9-a3e5-\
6ec91e11b757"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load BSM.nlo and Generate UFO at NLO", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, {
  3.572348211890565*^9, 3.572348234275403*^9}, {3.596207324453108*^9, 
  3.596207326711195*^9}, {3.655036212669145*^9, 3.6550362220422897`*^9}, {
  3.655036282693001*^9, 3.655036287060457*^9}, {3.655037866940884*^9, 
  3.6550378926486187`*^9}, {3.660583469669636*^9, 
  3.6605834886500196`*^9}},ExpressionUUID->"493a4b49-0255-47ae-87b0-\
254220da35ea"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"quit", " ", "kernel", " ", "before", " ", "continuing"}], " ", 
  "*)"}]], "Input",ExpressionUUID->"6c2b66dd-ba7d-4d84-96e6-433ecd080754"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.660583502811754*^9, 3.6605835046945877`*^9}, 
   3.66212390294204*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"8506311a-f288-4488-903d-47a5940847e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"load", " ", "FeynRules"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"$CurrentPath", "=", 
     RowBox[{"NotebookDirectory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"$FeynRulesPath", "=", 
     RowBox[{
     "SetDirectory", "[", "\"\<~/Scripts/FeynRules/FeynRules\>\"", "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "$CurrentPath", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.865584286630831*^9, 
  3.8655842870432568`*^9}},ExpressionUUID->"84058f34-7b2a-47b2-a076-\
a7a271d6cba9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"load", " ", "model", " ", "files"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"isLeptonMassive", "=", "True"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"switch", " ", "for", " ", 
       RowBox[{"massless", " ", "/", " ", "massive"}], " ", "charged", " ", 
       "leptons"}], ";", " ", 
      RowBox[{"must", " ", "match", " ", "above"}]}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"LoadModel", "[", 
     RowBox[{"\"\<sm.fr\>\"", ",", "\"\<zeebabu_NLO_public.fr\>\""}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{"isLeptonMassive", ",", "\[IndentingNewLine]", 
      RowBox[{"LoadRestriction", "[", 
       RowBox[{
       "\"\<diagonalCKM.rst\>\"", ",", "\"\<massless_quarks.rst\>\""}], "]"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"LoadRestriction", "[", 
       RowBox[{"\"\<diagonalCKM.rst\>\"", ",", "\"\<massless.rst\>\""}], 
       "]"}]}], "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FeynmanGauge", "=", "True"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.865584246879266*^9, 
  3.865584252863028*^9}},ExpressionUUID->"06c39969-fb4d-4bdb-9dae-\
a2d392b421e8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"generate", " ", "UFO"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Get", "[", "\"\<./SM_ZeeBabu.nlo\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LpQCD", " ", "=", " ", 
     RowBox[{"ExpandIndices", "/@", 
      RowBox[{"Expand", "[", 
       RowBox[{"LSM", "+", "LZB"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{"isLeptonMassive", ",", "\[IndentingNewLine]", 
      RowBox[{"WriteUFO", "[", 
       RowBox[{"LpQCD", ",", 
        RowBox[{"UVCounterterms", "\[Rule]", "UV$vertlist"}], ",", 
        RowBox[{"R2Vertices", "\[Rule]", "R2$vertlist"}], ",", " ", 
        RowBox[{
        "Output", "\[Rule]", "\"\<SM_ZeeBabu_MassiveLeptons_NLO\>\""}]}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"WriteUFO", "[", 
       RowBox[{"LpQCD", ",", 
        RowBox[{"UVCounterterms", "\[Rule]", "UV$vertlist"}], ",", 
        RowBox[{"R2Vertices", "\[Rule]", "R2$vertlist"}], ",", " ", 
        RowBox[{"Output", "\[Rule]", "\"\<SM_ZeeBabu_NLO\>\""}]}], "]"}]}], 
     "\[IndentingNewLine]", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.865584131474765*^9, 
  3.865584136767414*^9}},ExpressionUUID->"335b5ec7-5fa2-4add-be4c-\
6a63111321ae"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1330, 918},
WindowMargins->{{Automatic, 18}, {0, Automatic}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
TaggingRules->{"TryRealOnly" -> False},
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 426, 9, 31, "Input",ExpressionUUID->"cee4e897-cbc1-4bf1-a304-44bbfcd5aed3"],
Cell[974, 31, 1108, 26, 78, "Input",ExpressionUUID->"4149d1d2-f5f9-4692-ab77-ed3366c4e0f7"],
Cell[2085, 59, 502, 8, 31, "Input",ExpressionUUID->"2dd3093a-c7ea-41c7-a007-d589dc397211"],
Cell[CellGroupData[{
Cell[2612, 71, 251, 4, 99, "Title",ExpressionUUID->"36a8985f-3b71-4bb1-acae-6fbe5493c081"],
Cell[2866, 77, 483, 12, 101, "Input",ExpressionUUID->"c02dce38-3048-4633-94e9-e77e8ef0c800"],
Cell[3352, 91, 404, 8, 31, "Input",ExpressionUUID->"d74de1e8-93f7-4afe-980e-8f4e6a416a1f"],
Cell[3759, 101, 990, 23, 170, "Input",ExpressionUUID->"5ea88f54-35d3-4b35-bd98-245cd541651b"],
Cell[CellGroupData[{
Cell[4774, 128, 525, 8, 68, "Section",ExpressionUUID->"430f6c12-ab98-447b-8fa4-8a13c875b6c3"],
Cell[5302, 138, 645, 14, 55, "Input",ExpressionUUID->"ace2f1a4-cdb5-4121-9963-39b4d1feecad"],
Cell[5950, 154, 477, 7, 55, "Input",ExpressionUUID->"4b15b6dc-b821-4c12-bd21-ceb678b9a346"],
Cell[6430, 163, 502, 8, 55, "Input",ExpressionUUID->"e6072a7f-a1db-426d-b53f-0b3a0d059746"],
Cell[6935, 173, 355, 6, 55, "Input",ExpressionUUID->"e4b33362-cb94-4ba2-a771-443401bf60bf"],
Cell[7293, 181, 123, 1, 31, "Input",ExpressionUUID->"d12be5a0-8a03-4271-bb2f-33d3a6709310"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7453, 187, 281, 4, 68, "Section",ExpressionUUID->"963bd5da-1517-491b-8768-3e81fb288ca2"],
Cell[7737, 193, 288, 4, 78, "Input",ExpressionUUID->"bf30a8c1-c27e-4d9e-896e-422310148051"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8062, 202, 230, 5, 68, "Section",ExpressionUUID->"47f009e8-0603-4d37-95af-884018211353"],
Cell[8295, 209, 765, 17, 55, "Input",ExpressionUUID->"95ec60e1-8ba3-42ae-912b-c6b75ece5652"],
Cell[9063, 228, 716, 18, 124, "Input",ExpressionUUID->"34c50153-1c7b-45c0-b793-17a5f54e6210"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9816, 251, 356, 6, 68, "Section",ExpressionUUID->"f35c5a82-2f44-4096-9399-e82f5b97ff8d"],
Cell[10175, 259, 645, 14, 55, "Input",ExpressionUUID->"eafcd19a-c48f-46e1-8302-30202d5af7c6"],
Cell[10823, 275, 813, 19, 78, "Input",ExpressionUUID->"02f82583-a5c0-4ac9-8b08-6f2cc230ee4b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11673, 299, 346, 6, 68, "Section",ExpressionUUID->"637e3231-e751-489a-ad59-470d98c11b8b"],
Cell[12022, 307, 255, 6, 31, "Input",ExpressionUUID->"558b9e27-1057-416f-a429-231889bb6a86"],
Cell[12280, 315, 148, 3, 31, "Input",ExpressionUUID->"3640fc82-001c-4a97-8551-70d99a9b683d"],
Cell[12431, 320, 630, 15, 147, "Input",ExpressionUUID->"415ceffa-5035-4fe0-bcb8-4cc2ac3a3a63"],
Cell[13064, 337, 1270, 31, 78, "Input",ExpressionUUID->"7744ad0f-d54b-4fc9-a3e5-6ec91e11b757"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14371, 373, 475, 7, 68, "Section",ExpressionUUID->"493a4b49-0255-47ae-87b0-254220da35ea"],
Cell[14849, 382, 184, 3, 31, "Input",ExpressionUUID->"6c2b66dd-ba7d-4d84-96e6-433ecd080754"],
Cell[15036, 387, 241, 5, 31, "Input",ExpressionUUID->"8506311a-f288-4488-903d-47a5940847e6"],
Cell[15280, 394, 709, 19, 124, "Input",ExpressionUUID->"84058f34-7b2a-47b2-a076-a7a271d6cba9"],
Cell[15992, 415, 1301, 32, 193, "Input",ExpressionUUID->"06c39969-fb4d-4bdb-9dae-a2d392b421e8"],
Cell[17296, 449, 1319, 31, 170, "Input",ExpressionUUID->"335b5ec7-5fa2-4add-be4c-6a63111321ae"]
}, Open  ]]
}, Open  ]]
}
]
*)

