# This file was automatically created by FeynRules 2.3.36
# Mathematica version: 12.0.0 for Linux x86 (64-bit) (April 7, 2019)
# Date: Fri 1 Jul 2022 07:58:40



from object_library import all_parameters, Parameter


from function_library import complexconjugate, re, im, csc, sec, acsc, asec, cot

# This is a default parameter object representing 0.
ZERO = Parameter(name = 'ZERO',
                 nature = 'internal',
                 type = 'real',
                 value = '0.0',
                 texname = '0')

# User-defined parameters.
aEWM1 = Parameter(name = 'aEWM1',
                  nature = 'external',
                  type = 'real',
                  value = 127.94,
                  texname = '\\text{aEWM1}',
                  lhablock = 'SMINPUTS',
                  lhacode = [ 1 ])

Gf = Parameter(name = 'Gf',
               nature = 'external',
               type = 'real',
               value = 0.0000117456,
               texname = 'G_f',
               lhablock = 'SMINPUTS',
               lhacode = [ 2 ])

aS = Parameter(name = 'aS',
               nature = 'external',
               type = 'real',
               value = 0.1184,
               texname = '\\alpha _s',
               lhablock = 'SMINPUTS',
               lhacode = [ 3 ])

ymt = Parameter(name = 'ymt',
                nature = 'external',
                type = 'real',
                value = 173.3,
                texname = '\\text{ymt}',
                lhablock = 'YUKAWA',
                lhacode = [ 6 ])

femu = Parameter(name = 'femu',
                 nature = 'external',
                 type = 'real',
                 value = 1.00000002,
                 texname = 'f_{\\text{emu}}',
                 lhablock = 'ZeeBabuAntisymmetric',
                 lhacode = [ 1 ])

fetau = Parameter(name = 'fetau',
                  nature = 'external',
                  type = 'real',
                  value = 1.000000021,
                  texname = 'f_{\\text{etau}}',
                  lhablock = 'ZeeBabuAntisymmetric',
                  lhacode = [ 2 ])

fmutau = Parameter(name = 'fmutau',
                   nature = 'external',
                   type = 'real',
                   value = 1.000000022,
                   texname = 'f_{\\text{mutau}}',
                   lhablock = 'ZeeBabuAntisymmetric',
                   lhacode = [ 3 ])

muZB = Parameter(name = 'muZB',
                 nature = 'external',
                 type = 'real',
                 value = 1000.,
                 texname = '\\mu _{\\text{ZB}}',
                 lhablock = 'ZeeBabuPotential',
                 lhacode = [ 1 ])

lamhZB = Parameter(name = 'lamhZB',
                   nature = 'external',
                   type = 'real',
                   value = 1.,
                   texname = '\\lambda _{\\text{hZB}}',
                   lhablock = 'ZeeBabuPotential',
                   lhacode = [ 2 ])

lamkZB = Parameter(name = 'lamkZB',
                   nature = 'external',
                   type = 'real',
                   value = 1.000000001,
                   texname = '\\lambda _{\\text{kZB}}',
                   lhablock = 'ZeeBabuPotential',
                   lhacode = [ 3 ])

lamhZBkZB = Parameter(name = 'lamhZBkZB',
                      nature = 'external',
                      type = 'real',
                      value = 1.000000002,
                      texname = '\\lambda _{\\text{hZBkZB}}',
                      lhablock = 'ZeeBabuPotential',
                      lhacode = [ 4 ])

lamhZBH = Parameter(name = 'lamhZBH',
                    nature = 'external',
                    type = 'real',
                    value = 1.000000003,
                    texname = '\\lambda _{\\text{hZBH}}',
                    lhablock = 'ZeeBabuPotential',
                    lhacode = [ 5 ])

lamkZBH = Parameter(name = 'lamkZBH',
                    nature = 'external',
                    type = 'real',
                    value = 1.000000004,
                    texname = '\\lambda _{\\text{kZBH}}',
                    lhablock = 'ZeeBabuPotential',
                    lhacode = [ 6 ])

gee = Parameter(name = 'gee',
                nature = 'external',
                type = 'real',
                value = 1.00000001,
                texname = 'g_e',
                lhablock = 'ZeeBabuSymmetric',
                lhacode = [ 1 ])

gemu = Parameter(name = 'gemu',
                 nature = 'external',
                 type = 'real',
                 value = 1.000000011,
                 texname = 'g_{\\text{emu}}',
                 lhablock = 'ZeeBabuSymmetric',
                 lhacode = [ 2 ])

getau = Parameter(name = 'getau',
                  nature = 'external',
                  type = 'real',
                  value = 1.000000012,
                  texname = 'g_{\\text{etau}}',
                  lhablock = 'ZeeBabuSymmetric',
                  lhacode = [ 3 ])

gmumu = Parameter(name = 'gmumu',
                  nature = 'external',
                  type = 'real',
                  value = 1.000000013,
                  texname = 'g_{\\text{mumu}}',
                  lhablock = 'ZeeBabuSymmetric',
                  lhacode = [ 4 ])

gmutau = Parameter(name = 'gmutau',
                   nature = 'external',
                   type = 'real',
                   value = 1.000000014,
                   texname = 'g_{\\text{mutau}}',
                   lhablock = 'ZeeBabuSymmetric',
                   lhacode = [ 5 ])

gtautau = Parameter(name = 'gtautau',
                    nature = 'external',
                    type = 'real',
                    value = 1.000000015,
                    texname = 'g_{\\text{tautau}}',
                    lhablock = 'ZeeBabuSymmetric',
                    lhacode = [ 6 ])

MZ = Parameter(name = 'MZ',
               nature = 'external',
               type = 'real',
               value = 91.1876,
               texname = '\\text{MZ}',
               lhablock = 'MASS',
               lhacode = [ 23 ])

MT = Parameter(name = 'MT',
               nature = 'external',
               type = 'real',
               value = 173.3,
               texname = '\\text{MT}',
               lhablock = 'MASS',
               lhacode = [ 6 ])

MH = Parameter(name = 'MH',
               nature = 'external',
               type = 'real',
               value = 125.7,
               texname = '\\text{MH}',
               lhablock = 'MASS',
               lhacode = [ 25 ])

mhZB = Parameter(name = 'mhZB',
                 nature = 'external',
                 type = 'real',
                 value = 300.,
                 texname = '\\text{mhZB}',
                 lhablock = 'MASS',
                 lhacode = [ 38 ])

mkZB = Parameter(name = 'mkZB',
                 nature = 'external',
                 type = 'real',
                 value = 500.,
                 texname = '\\text{mkZB}',
                 lhablock = 'MASS',
                 lhacode = [ 61 ])

WZ = Parameter(name = 'WZ',
               nature = 'external',
               type = 'real',
               value = 2.4952,
               texname = '\\text{WZ}',
               lhablock = 'DECAY',
               lhacode = [ 23 ])

WW = Parameter(name = 'WW',
               nature = 'external',
               type = 'real',
               value = 2.085,
               texname = '\\text{WW}',
               lhablock = 'DECAY',
               lhacode = [ 24 ])

WT = Parameter(name = 'WT',
               nature = 'external',
               type = 'real',
               value = 1.35,
               texname = '\\text{WT}',
               lhablock = 'DECAY',
               lhacode = [ 6 ])

WH = Parameter(name = 'WH',
               nature = 'external',
               type = 'real',
               value = 0.00417,
               texname = '\\text{WH}',
               lhablock = 'DECAY',
               lhacode = [ 25 ])

whZB = Parameter(name = 'whZB',
                 nature = 'external',
                 type = 'real',
                 value = 1,
                 texname = '\\text{whZB}',
                 lhablock = 'DECAY',
                 lhacode = [ 38 ])

wkZB = Parameter(name = 'wkZB',
                 nature = 'external',
                 type = 'real',
                 value = 1,
                 texname = '\\text{wkZB}',
                 lhablock = 'DECAY',
                 lhacode = [ 61 ])

aEW = Parameter(name = 'aEW',
                nature = 'internal',
                type = 'real',
                value = '1/aEWM1',
                texname = '\\alpha _{\\text{EW}}')

fll1x1 = Parameter(name = 'fll1x1',
                   nature = 'internal',
                   type = 'real',
                   value = '0',
                   texname = '\\text{fll1x1}')

fll1x2 = Parameter(name = 'fll1x2',
                   nature = 'internal',
                   type = 'real',
                   value = 'femu',
                   texname = '\\text{fll1x2}')

fll1x3 = Parameter(name = 'fll1x3',
                   nature = 'internal',
                   type = 'real',
                   value = 'fetau',
                   texname = '\\text{fll1x3}')

fll2x1 = Parameter(name = 'fll2x1',
                   nature = 'internal',
                   type = 'real',
                   value = '-femu',
                   texname = '\\text{fll2x1}')

fll2x2 = Parameter(name = 'fll2x2',
                   nature = 'internal',
                   type = 'real',
                   value = '0',
                   texname = '\\text{fll2x2}')

fll2x3 = Parameter(name = 'fll2x3',
                   nature = 'internal',
                   type = 'real',
                   value = 'fmutau',
                   texname = '\\text{fll2x3}')

fll3x1 = Parameter(name = 'fll3x1',
                   nature = 'internal',
                   type = 'real',
                   value = '-fetau',
                   texname = '\\text{fll3x1}')

fll3x2 = Parameter(name = 'fll3x2',
                   nature = 'internal',
                   type = 'real',
                   value = '-fmutau',
                   texname = '\\text{fll3x2}')

fll3x3 = Parameter(name = 'fll3x3',
                   nature = 'internal',
                   type = 'real',
                   value = '0',
                   texname = '\\text{fll3x3}')

G = Parameter(name = 'G',
              nature = 'internal',
              type = 'real',
              value = '2*cmath.sqrt(aS)*cmath.sqrt(cmath.pi)',
              texname = 'G')

gll1x1 = Parameter(name = 'gll1x1',
                   nature = 'internal',
                   type = 'real',
                   value = 'gee',
                   texname = '\\text{gll1x1}')

gll1x2 = Parameter(name = 'gll1x2',
                   nature = 'internal',
                   type = 'real',
                   value = 'gemu',
                   texname = '\\text{gll1x2}')

gll1x3 = Parameter(name = 'gll1x3',
                   nature = 'internal',
                   type = 'real',
                   value = 'getau',
                   texname = '\\text{gll1x3}')

gll2x1 = Parameter(name = 'gll2x1',
                   nature = 'internal',
                   type = 'real',
                   value = 'gemu',
                   texname = '\\text{gll2x1}')

gll2x2 = Parameter(name = 'gll2x2',
                   nature = 'internal',
                   type = 'real',
                   value = 'gmumu',
                   texname = '\\text{gll2x2}')

gll2x3 = Parameter(name = 'gll2x3',
                   nature = 'internal',
                   type = 'real',
                   value = 'gmutau',
                   texname = '\\text{gll2x3}')

gll3x1 = Parameter(name = 'gll3x1',
                   nature = 'internal',
                   type = 'real',
                   value = 'getau',
                   texname = '\\text{gll3x1}')

gll3x2 = Parameter(name = 'gll3x2',
                   nature = 'internal',
                   type = 'real',
                   value = 'gmutau',
                   texname = '\\text{gll3x2}')

gll3x3 = Parameter(name = 'gll3x3',
                   nature = 'internal',
                   type = 'real',
                   value = 'gtautau',
                   texname = '\\text{gll3x3}')

MW = Parameter(name = 'MW',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(MZ**2/2. + cmath.sqrt(MZ**4/4. - (aEW*cmath.pi*MZ**2)/(Gf*cmath.sqrt(2))))',
               texname = 'M_W')

ee = Parameter(name = 'ee',
               nature = 'internal',
               type = 'real',
               value = '2*cmath.sqrt(aEW)*cmath.sqrt(cmath.pi)',
               texname = 'e')

sw2 = Parameter(name = 'sw2',
                nature = 'internal',
                type = 'real',
                value = '1 - MW**2/MZ**2',
                texname = '\\text{sw2}')

cw = Parameter(name = 'cw',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(1 - sw2)',
               texname = 'c_w')

sw = Parameter(name = 'sw',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(sw2)',
               texname = 's_w')

g1 = Parameter(name = 'g1',
               nature = 'internal',
               type = 'real',
               value = 'ee/cw',
               texname = 'g_1')

gw = Parameter(name = 'gw',
               nature = 'internal',
               type = 'real',
               value = 'ee/sw',
               texname = 'g_w')

vev = Parameter(name = 'vev',
                nature = 'internal',
                type = 'real',
                value = '(2*MW*sw)/ee',
                texname = '\\text{vev}')

mhZBTree = Parameter(name = 'mhZBTree',
                     nature = 'internal',
                     type = 'real',
                     value = 'cmath.sqrt(mhZB**2 - (lamhZBH*vev**2)/2.)',
                     texname = '\\text{mhZBTree}')

mkZBTree = Parameter(name = 'mkZBTree',
                     nature = 'internal',
                     type = 'real',
                     value = 'cmath.sqrt(mkZB**2 - (lamhZBH*vev**2)/2.)',
                     texname = '\\text{mkZBTree}')

lam = Parameter(name = 'lam',
                nature = 'internal',
                type = 'real',
                value = 'MH**2/(2.*vev**2)',
                texname = '\\text{lam}')

yt = Parameter(name = 'yt',
               nature = 'internal',
               type = 'real',
               value = '(ymt*cmath.sqrt(2))/vev',
               texname = '\\text{yt}')

muH = Parameter(name = 'muH',
                nature = 'internal',
                type = 'real',
                value = 'cmath.sqrt(lam*vev**2)',
                texname = '\\mu')

