(* ********************************************************* *)
(* *****                                               ***** *)
(* *****  FeynRules model file: SM + Wprime            ***** *)
(* *****  Author: B. Fuks                              ***** *)
(* *****                                               ***** *)
(* ********************************************************* *)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "WEff";
M$Information = { Authors->{"Benjamin Fuks"}, 
		  Emails->{"benjamin.fuks@iphc.cnrs.fr"}, 
		  Institutions->{"IPHC Strasbourg / University of Strasbourg"},
                  Date->"03.07.12", Version->"1.0.0",
                  References->{"Z. Sullivan, Phys. Rev. D 66 (2002) 075011."},
                  URLs->{""} };
FeynmanGauge = True;





(* ************************** *)
(* *****     Fields     ***** *)
(* ************************** *)
M$ClassesDescription = {
(* Additional W' boson *)
  V[7] == { 
	ClassName->Wp, SelfConjugate->False,  
	Mass->{MWp,1000.}, 
	Width->{WWp,10.}, 
	ParticleName->"Wp+", 
	AntiParticleName->"Wp-", 
        QuantumNumbers -> {Q->1}, 
	PDG->34, 
	PropagatorLabel->"Wp", 
	PropagatorType->Sine, 
	PropagatorArrow->Forward}
};

(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {
  CRq == { TeX->Subsuperscript[C,q,R], ParameterType->External, ComplexParameter->False, Indices->{Index[Generation],Index[Generation]}, BlockName->CRq,
            Value-> {
              CRq[1,1]->1.0,    CRq[1,2]->.225773, CRq[1,3]->0.,
              CRq[2,1]->0, 	CRq[2,2]->.97418,  CRq[2,3]->0.,
              CRq[3,1]->0,      CRq[3,2]->0.,      CRq[3,3]->1. }, 
            Description->"Right-handed W' couplings to quarks"},
  CRl == { TeX->Subsuperscript[C,l,R], ParameterType->External, ComplexParameter->False, Indices->{Index[Generation],Index[Generation]}, BlockName->CRl,
            Value-> {
              CRl[1,1]->1.,  CRl[1,2]->0., CRl[1,3]->0.,
              CRl[2,1]->0.,  CRl[2,2]->1., CRl[2,3]->0.,
              CRl[3,1]->0.,  CRl[3,2]->0., CRl[3,3]->1. }, 
            Description->"Right-handed W' couplings to leptons"},
  CLq == { TeX->Subsuperscript[C,q,L], ParameterType->External, ComplexParameter->False, Indices->{Index[Generation],Index[Generation]}, BlockName->CLq,
            Value-> {
              CLq[1,1]->.97418,   CLq[1,2]->.225773, CLq[1,3]->0.,
              CLq[2,1]->-.225773, CLq[2,2]->.97418,  CLq[2,3]->0.,
              CLq[3,1]->0.,       CLq[3,2]->0.,      CLq[3,3]->1. }, 
            Description->"Left-handed W' couplings to quarks"},
  CLl == { TeX->Subsuperscript[C,l,L], ParameterType->External, ComplexParameter->False, Indices->{Index[Generation],Index[Generation]}, BlockName->CLl,
            Value-> {
              CLl[1,1]->1.,  CLl[1,2]->0., CLl[1,3]->0.,
              CLl[2,1]->0.,  CLl[2,2]->1., CLl[2,3]->0.,
              CLl[3,1]->0.,  CLl[3,2]->0., CLl[3,3]->1. }, 
            Description->"Left-handed W' couplings to leptons"
	},


  kL == { ParameterType -> External, 
	  Value -> 0.0,
	  InteractionOrder -> {NP,1}, 
	  BlockName->WPCOUP,
	  OrderBlock->1,
	  TeX -> Subscript[kappa,L], 
          Description -> "Left-handed W' coupling constant scale factor"},

  kR == { ParameterType -> External, 
	  Value -> 1.0, 
	  InteractionOrder -> {NP,1}, 
	  TeX -> Subscript[kappa,R], 
	  BlockName->WPCOUP,
	  OrderBlock->2,
          Description -> "Right-handed W' coupling constant scale factor"
	},


  gL == { ParameterType -> Internal, 
	  Definitions   -> {gL->kL*ee/sw},
	  InteractionOrder -> {NP,1}, 
	  TeX -> Subscript[g,L], 
          Description -> "Left-handed W' coupling constant"
	},

  gR == { ParameterType -> Internal, 
	  Definitions   -> {gR->kR*ee/sw},
	  InteractionOrder -> {NP,1}, 
	  TeX -> Subscript[g,R], 
          Description -> "Right-handed W' coupling constant"}
};

(* ************************** *)
(* *** Interaction orders *** *)
(* ************************** *)
M$InteractionOrderHierarchy = { {QCD, 1}, {QED, 2} };


(* New Lagrangian interaction terms *)

LWprimeTmp := ExpandIndices[
    gL/Sqrt[2]*(vlbar.Ga[mu].ProjM.CLl.l + uqbar.Ga[mu].ProjM.CLq.dq)*Wp[mu] +
    gR/Sqrt[2]*(vlbar.Ga[mu].ProjP.CRl.l + uqbar.Ga[mu].ProjP.CRq.dq)*Wp[mu],
     FlavorExpand -> {SU2D}];

LWprime := LWprimeTmp + HC[LWprimeTmp];

