(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      3568,        113]
NotebookOptionsPosition[      2938,         86]
NotebookOutlinePosition[      3296,        102]
CellTagsIndexPosition[      3253,         99]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.540113020401739*^9, 3.5401130208992767`*^9}}],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.518892288721245*^9, 3.518892291440427*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$olddir", "=", 
   RowBox[{"Directory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", "\"\<~/FeynRules/trunk/feynrules-development\>\"", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$olddir", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{
    RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/SM.fr\>\""}], ",", 
    "\"\<weff.fr\>\""}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.500793438723139*^9, 3.500793441143552*^9}, {
   3.503666867066519*^9, 3.503666869077112*^9}, {3.518892141094482*^9, 
   3.518892168024193*^9}, {3.540112894489603*^9, 3.540112897923902*^9}, 
   3.549599083212336*^9, {3.5502926102866373`*^9, 3.55029261102719*^9}, {
   3.550292678153421*^9, 3.550292688594266*^9}, {3.550292930964777*^9, 
   3.5502929556915627`*^9}, 3.55029308559453*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Additionnal Feymman rules", "Section",
 CellChangeTimes->{{3.518892294504589*^9, 3.518892300256538*^9}}],

Cell[BoxData["LWprime"], "Input",
 CellChangeTimes->{{3.5502931353860607`*^9, 3.550293141347558*^9}, {
  3.550293172686055*^9, 3.550293373133667*^9}, {3.550293493764401*^9, 
  3.550293495086035*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LWprime", ",", 
   RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.550293385320056*^9, 3.550293401316181*^9}, {
  3.550293498391491*^9, 3.550293501689383*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generating the UFO model files", "Section",
 CellChangeTimes->{{3.518892302672626*^9, 3.518892305688608*^9}}],

Cell[BoxData[
 RowBox[{"WriteUFO", "[", 
  RowBox[{"LSM", ",", "LWprime"}], "]"}]], "Input",
 CellChangeTimes->{{3.500890697245646*^9, 3.500890704222636*^9}, {
  3.5008908901215143`*^9, 3.5008908903708687`*^9}, {3.518892235767663*^9, 
  3.518892237775363*^9}, {3.540113570516355*^9, 3.54011357075742*^9}, {
  3.5502935101903954`*^9, 3.550293511961158*^9}}]
}, Open  ]]
},
WindowSize->{1440, 825},
WindowMargins->{{3, Automatic}, {Automatic, 23}},
ShowSelection->True,
FrontEndVersion->"7.0 for Linux x86 (64-bit) (February 25, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 120, 2, 32, "Input"],
Cell[CellGroupData[{
Cell[690, 26, 90, 1, 73, "Section"],
Cell[783, 29, 1022, 22, 121, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1842, 56, 110, 1, 73, "Section"],
Cell[1955, 59, 199, 3, 32, "Input"],
Cell[2157, 64, 254, 5, 32, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2448, 74, 115, 1, 73, "Section"],
Cell[2566, 77, 356, 6, 32, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
