(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16347,        443]
NotebookOptionsPosition[     14567,        383]
NotebookOutlinePosition[     15004,        400]
CellTagsIndexPosition[     14961,        397]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"R", ".", " ", "Ruiz"}], ";", " ", 
   RowBox[{"2016", " ", "February", " ", "22"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.665142881510211*^9, 3.665142884049021*^9}, {
  3.665142942303646*^9, 3.6651429529879627`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "generate", " ", "LO", " ", 
     RowBox[{"UFO", ":", " ", 
      RowBox[{"Set", " ", "paths"}]}]}], ",", " ", 
    RowBox[{"load", " ", "model"}], ",", " ", 
    RowBox[{"write", " ", "UFO"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "generate", " ", "NLO", " ", 
     RowBox[{"UFO", ":", " ", 
      RowBox[{"Set", " ", "paths"}]}]}], ",", " ", 
    RowBox[{"load", " ", "model"}], ",", " ", 
    RowBox[{
     RowBox[{"extract", " ", "on"}], "-", 
     RowBox[{"shell", " ", "renormalization", " ", "terms"}]}], ",", " ", 
    RowBox[{"write", " ", "CT", " ", "terms"}], ",", " ", 
    RowBox[{"reset", " ", "paths"}], ",", " ", 
    RowBox[{"reload", " ", "model"}], ",", " ", 
    RowBox[{"write", " ", "everything", " ", "to", " ", 
     RowBox[{"file", "."}]}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.6648662671878157`*^9, 3.664866418502534*^9}, {
  3.664866852892112*^9, 3.664866879416404*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.6780702279189262`*^9, 3.678070229446971*^9}}],

Cell[CellGroupData[{

Cell["FeynRules Setup", "Title",
 CellChangeTimes->{{3.596207285657744*^9, 3.596207286276866*^9}, {
  3.596207330352247*^9, 3.59620733250506*^9}, {3.655035967648223*^9, 
  3.65503597269068*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$CurrentPath", "=", 
   RowBox[{"Directory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", "\"\<~/Scripts/FeynRules/feynrules-2_x\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$CurrentPath", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
   3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
   3.4234163227881193`*^9}, {3.572102427116931*^9, 3.572102456206238*^9}, {
   3.572280529035656*^9, 3.572280529468644*^9}, {3.572366766720894*^9, 
   3.572366773370627*^9}, {3.596207212826934*^9, 3.5962072447909603`*^9}, {
   3.596914045279478*^9, 3.5969140472383204`*^9}, 3.596914102616413*^9, 
   3.596915921742405*^9, {3.596915961175353*^9, 3.59691596259039*^9}, {
   3.60744636894991*^9, 3.607446377507101*^9}, {3.6364757082312813`*^9, 
   3.636475708315627*^9}, {3.655035981353272*^9, 3.655035982244761*^9}, {
   3.6550360677717857`*^9, 3.655036081259776*^9}, {3.655036117419112*^9, 
   3.655036143336364*^9}, {3.655037954145546*^9, 3.6550379644813023`*^9}, {
   3.6605209855658293`*^9, 3.6605209855964212`*^9}, {3.6605772969976788`*^9, 
   3.660577300733718*^9}, {3.6621928886588717`*^9, 3.662192889375732*^9}, {
   3.6628197402754908`*^9, 3.662819763199905*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Load", " ", "default", " ", "SM", " ", "file", " ", "v1", ".4", ".6", " ", 
   "and", " ", "SSM", " ", 
   RowBox[{"extension", "."}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.6550381551475554`*^9, 3.655038155711425*^9}, {
  3.6622141225281467`*^9, 3.662214139672209*^9}, {3.685104939249427*^9, 
  3.685104946441214*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<sm.fr\>\"", ",", "\"\<vPrimeNLO.fr\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{"\"\<diagonalCKM.rst\>\"", ",", "\"\<massless.rst\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]}], "Input",
 CellChangeTimes->{{3.678057093323627*^9, 3.6780571044706087`*^9}, {
  3.6780701061217957`*^9, 3.678070116325616*^9}, {3.685104562504938*^9, 
  3.68510456739747*^9}, {3.693830623413735*^9, 3.693830625047556*^9}}],

Cell[CellGroupData[{

Cell["\<\
Lagrangian Terms and Feynman Rules\
\>", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, {
  3.572348211890565*^9, 3.572348234275403*^9}, {3.596207324453108*^9, 
  3.596207326711195*^9}, {3.655036212669145*^9, 3.6550362220422897`*^9}, {
  3.655036282693001*^9, 3.655036287060457*^9}, {3.655037866940884*^9, 
  3.6550378926486187`*^9}, {3.662214296374611*^9, 3.662214296674329*^9}, {
  3.685105123484643*^9, 3.685105125895092*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Z_SSM", " ", "Lagrangian"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.6622142421620703`*^9, 3.662214256550921*^9}, {
  3.685104641419363*^9, 3.685104648866871*^9}, {3.685104693105164*^9, 
  3.6851046993583927`*^9}}],

Cell[BoxData["LZSSM"], "Input",
 CellChangeTimes->{{3.685104911398961*^9, 3.6851049117325573`*^9}}],

Cell[BoxData["LWSSM"], "Input",
 CellChangeTimes->{{3.685104659284914*^9, 3.685104659300068*^9}, {
  3.6851049145279512`*^9, 3.685104915453402*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"LFull", " ", "=", " ", 
    RowBox[{"LSM", " ", "+", " ", "LSSM"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "LFull"}]], "Input"],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LSSM", "]"}]], "Input",
 CellChangeTimes->{
  3.664866752982409*^9, {3.685104661835256*^9, 3.685104671539464*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sanity Checks for New Lagrangian Terms", "Section",
 CellChangeTimes->{{3.4234156496121893`*^9, 3.423415657027569*^9}, {
  3.655037883884348*^9, 3.655037906883815*^9}}],

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "LSSM", "]"}]], "Input",
 CellChangeTimes->{
  3.607446407230465*^9, {3.67807014021633*^9, 3.6780701414840117`*^9}, {
   3.68510495799578*^9, 3.685104959674774*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["UFO Output", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.59620768137986*^9, 3.596207684212212*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{"LSM", ",", " ", 
    RowBox[{"Output", "\[Rule]", "\"\<SM_UFO\>\""}]}], "]"}], ";"}]], "Input",\

 CellChangeTimes->{{3.664870139775291*^9, 3.664870140066676*^9}, {
  3.685250711311055*^9, 3.685250713015635*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{"LFull", ",", " ", 
    RowBox[{"Output", "\[Rule]", "\"\<VPrime_UFO\>\""}]}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.685105630862656*^9, 3.685105638157789*^9}, {
  3.6938306566838427`*^9, 3.6938306949848824`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
On-Shell Renormalization with FeynArts\
\>", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.59620768137986*^9, 3.596207684212212*^9}, {3.662199318805483*^9, 
   3.6621993287719097`*^9}, {3.662216149623213*^9, 3.662216170908692*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LRen", " ", "=", " ", 
   RowBox[{"OnShellRenormalization", "[", 
    RowBox[{"LFull", ",", 
     RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
     RowBox[{"FlavorMixing", "\[Rule]", " ", "False"}], ",", 
     RowBox[{"Exclude4ScalarsCT", "\[Rule]", "True"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SetDirectory", "[", 
  "\"\<~/Scripts/FeynArts/FeynArts-3.8/Models\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteFeynArtsOutput", "[", 
   RowBox[{"LRen", ",", 
    RowBox[{"GenericFile", "\[Rule]", "False"}], ",", 
    RowBox[{"FlavorExpand", "\[Rule]", "True"}], ",", 
    RowBox[{"Output", "\[Rule]", "\"\<VPrimeNLO_FA\>\""}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.678057190696954*^9, 3.678057203308004*^9}, {
  3.678070314781888*^9, 3.678070315277923*^9}, {3.68510845465352*^9, 
  3.6851084571847258`*^9}, {3.6851084974673643`*^9, 3.685108499258304*^9}, {
  3.6852507332531557`*^9, 3.685250734468832*^9}, {3.6938307805054283`*^9, 
  3.69383078391374*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Write Counter Terms to BSM.nlo", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.59620768137986*^9, 3.596207684212212*^9}, {3.662199461128889*^9, 
   3.662199467953211*^9}, {3.662216541485611*^9, 3.662216544705964*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"quit", " ", "kernel", " ", "before", " ", "continuing"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.664866502336069*^9, 3.664866536918194*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\<~/Scripts/FeynArts/FeynArts-3.8\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynArts`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\<~/Scripts/FeynRules/feynrules-2_x\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "NLOCT`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$CurrentPath", "=", 
   RowBox[{"Directory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$CurrentPath", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.6605244352671556`*^9, 3.660524496529204*^9}, {
   3.660524555733032*^9, 3.660524556119355*^9}, 3.660528429455056*^9, {
   3.6605286020387897`*^9, 3.660528602100609*^9}, {3.660530319063929*^9, 
   3.660530319160571*^9}, {3.660530366154963*^9, 3.66053037265125*^9}, {
   3.660567620251087*^9, 3.6605676243565598`*^9}, {3.660568912072307*^9, 
   3.660568912133321*^9}, {3.66056999189439*^9, 3.660569993076742*^9}, {
   3.660570552697504*^9, 3.660570554442918*^9}, {3.6605786705389338`*^9, 
   3.660578696714662*^9}, {3.660579471210005*^9, 3.660579471258161*^9}, {
   3.660579558812049*^9, 3.6605795588460417`*^9}, {3.6605809812710743`*^9, 
   3.660580981737924*^9}, {3.662198567340746*^9, 3.662198568029338*^9}, {
   3.664866430517086*^9, 3.664866431258605*^9}, {3.664866469872073*^9, 
   3.664866472738167*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Note", ":", " ", 
    RowBox[{"Grab", " ", "some", " ", "coffee"}]}], ";", " ", 
   RowBox[{"this", " ", "will", " ", "take", " ", "a", " ", "few", " ", 
    RowBox[{"minutes", ".", " ", "Output"}], " ", "is", " ", "located", " ", 
    "in", " ", "FeynRules", " ", 
    RowBox[{"directory", "."}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.660583519626089*^9, 3.660583556727778*^9}}],

Cell[BoxData[
 RowBox[{"WriteCT", "[", 
  RowBox[{"\"\<VPrimeNLO_FA/VPrimeNLO_FA\>\"", ",", "\"\<Lorentz\>\"", ",", 
   RowBox[{"Output", "\[Rule]", "\"\<vPrimeNLO\>\""}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ZeroMom", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"aS", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"F", "[", "7", "]"}], ",", 
         RowBox[{"V", "[", "4", "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"F", "[", "7", "]"}]}]}], "}"}]}], "}"}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
   RowBox[{"Exclude4ScalarsCT", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6938315960715723`*^9, 3.693831604921082*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Load BSM.nlo and Generate UFO at NLO\
\>", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, {
  3.572348211890565*^9, 3.572348234275403*^9}, {3.596207324453108*^9, 
  3.596207326711195*^9}, {3.655036212669145*^9, 3.6550362220422897`*^9}, {
  3.655036282693001*^9, 3.655036287060457*^9}, {3.655037866940884*^9, 
  3.6550378926486187`*^9}, {3.660583469669636*^9, 3.6605834886500196`*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"quit", " ", "kernel", " ", "before", " ", "continuing"}], " ", 
  "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.660583502811754*^9, 3.6605835046945877`*^9}, 
   3.66212390294204*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$CurrentPath", "=", 
   RowBox[{"Directory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", "\"\<~/Scripts/FeynRules/feynrules-2_x\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$CurrentPath", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.6648666749712143`*^9, 3.664866676189664*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<sm.fr\>\"", ",", "\"\<vPrimeNLO.fr\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{"\"\<diagonalCKM.rst\>\"", ",", "\"\<massless.rst\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]}], "Input",
 CellChangeTimes->{{3.662827026079749*^9, 3.662827026713024*^9}, {
  3.678057576389485*^9, 3.6780575835323477`*^9}, {3.678070991353997*^9, 
  3.678070991957912*^9}, {3.685108574817178*^9, 3.6851085761154137`*^9}, {
  3.6938316252161922`*^9, 3.693831627879601*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "Get", "[", "\"\<~/Scripts/FeynRules/feynrules-2_x/vPrimeNLO.nlo\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{"LFull", ",", 
    RowBox[{"UVCounterterms", "\[Rule]", "UV$vertlist"}], ",", 
    RowBox[{"R2Vertices", "\[Rule]", "R2$vertlist"}], ",", " ", 
    RowBox[{"Output", "\[Rule]", "\"\<VPrime_NLO\>\""}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.662198991781353*^9, 3.662199036363181*^9}, 
   3.662199840894348*^9, {3.662216970646433*^9, 3.6622170227272053`*^9}, {
   3.662217345266424*^9, 3.6622173537750807`*^9}, {3.67805759047082*^9, 
   3.67805759800605*^9}, {3.678059798652795*^9, 3.6780598259741096`*^9}, {
   3.685108591275426*^9, 3.685108601781252*^9}, {3.685110167774995*^9, 
   3.685110169998728*^9}, {3.693831632830879*^9, 3.693831640798044*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1418, 704},
WindowMargins->{{Automatic, 26}, {53, Automatic}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
FrontEndVersion->"9.0 for Linux x86 (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 283, 6, 32, "Input"],
Cell[831, 28, 1048, 24, 99, "Input"],
Cell[1882, 54, 120, 2, 32, "Input"],
Cell[CellGroupData[{
Cell[2027, 60, 194, 3, 90, "Title"],
Cell[2224, 65, 1441, 25, 99, "Input"],
Cell[3668, 92, 366, 8, 32, "Input"],
Cell[4037, 102, 590, 13, 77, "Input"],
Cell[CellGroupData[{
Cell[4652, 119, 468, 8, 80, "Section"],
Cell[5123, 129, 265, 5, 32, "Input"],
Cell[5391, 136, 99, 1, 32, "Input"],
Cell[5493, 139, 148, 2, 32, "Input"],
Cell[5644, 143, 187, 5, 55, "Input"],
Cell[5834, 150, 159, 3, 32, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6030, 158, 174, 2, 80, "Section"],
Cell[6207, 162, 213, 4, 32, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6457, 171, 169, 3, 80, "Section"],
Cell[6629, 176, 276, 7, 32, "Input"],
Cell[6908, 185, 287, 7, 32, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7232, 197, 303, 6, 80, "Section"],
Cell[7538, 205, 1045, 23, 77, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8620, 233, 285, 4, 80, "Section"],
Cell[8908, 239, 195, 4, 32, "Input"],
Cell[9106, 245, 70, 2, 32, "Input"],
Cell[9179, 249, 1402, 27, 143, "Input"],
Cell[10584, 278, 438, 9, 32, "Input"],
Cell[11025, 289, 743, 18, 77, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11805, 312, 423, 7, 80, "Section"],
Cell[12231, 321, 129, 3, 32, "Input"],
Cell[12363, 326, 163, 4, 32, "Input"],
Cell[12529, 332, 498, 12, 99, "Input"],
Cell[13030, 346, 642, 14, 77, "Input"],
Cell[13675, 362, 864, 17, 55, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
