(* ********************************************************* *)
(* *****                                               ***** *)
(* *****  FeynRules model file: SM + W_SSM + Z_SSM     ***** *)
(* *****  Authors: B. Fuks, R. Ruiz                    ***** *)
(* *****                                               ***** *)
(* ********************************************************* *)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "vPrimeNLO";
M$Information = { Authors->{"B. Fuks, R. Ruiz"}, 
		  Emails->{"benjamin.fuks@iphc.cnrs.fr,rruiz@durham.ac.uk"}, 
		  Institutions->{"IPHC Strasbourg / University of Strasbourg, IPPP/University of Durham"},
                  Date->"2017 January 20", 
		  Version->"1.1",
                  References->{"B. Fuks, R. Ruiz [arXiv:1701.YYYYY], and references therein."},
                  URLs->{"feynrules.irmp.ucl.ac.be/"} };
FeynmanGauge = True;





(* ************************** *)
(* *****     Fields     ***** *)
(* ************************** *)
M$ClassesDescription = {
(* Sequential SM Z prime boson *)
  V[32] == {
	ClassName        -> Zp,
	SelfConjugate    -> True,
	Mass             -> {MZp,  3000.00},
	Width            -> {WZp,    89.59},
	ParticleName     -> "Zp",
	PDG              -> 32, 
	PropagatorLabel  -> "Zp",
	PropagatorType   -> Sine,
	PropagatorArrow  -> None,
	FullName         -> "Zp"
  },
(* Sequential SM W prime boson *)
  V[34] == { 
	ClassName	->Wp, 
	SelfConjugate	->False,  
	Mass		->{MWp, 3000.00},
	Width		->{WWp,  101.27},
	ParticleName	->"Wp+", 
	AntiParticleName->"Wp-", 
        QuantumNumbers 	->{Q->1}, 
	PDG		->34, 
	PropagatorLabel	->"Wp", 
	PropagatorType	->Sine, 
	PropagatorArrow	->Forward
	FullName	->"Wp"
  }
};

(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {
  CRq == { TeX->Subsuperscript[C,q,R], ParameterType->External, ComplexParameter->False, Indices->{Index[Generation],Index[Generation]}, BlockName->CRq,
            Value-> {
              CRq[1,1]->1.0,    CRq[1,2]->.225773, CRq[1,3]->0.,
              CRq[2,1]->0, 	CRq[2,2]->.97418,  CRq[2,3]->0.,
              CRq[3,1]->0,      CRq[3,2]->0.,      CRq[3,3]->1. }, 
            Description->"Right-handed W' couplings to quarks"},
  CRl == { TeX->Subsuperscript[C,l,R], ParameterType->External, ComplexParameter->False, Indices->{Index[Generation],Index[Generation]}, BlockName->CRl,
            Value-> {
              CRl[1,1]->1.,  CRl[1,2]->0., CRl[1,3]->0.,
              CRl[2,1]->0.,  CRl[2,2]->1., CRl[2,3]->0.,
              CRl[3,1]->0.,  CRl[3,2]->0., CRl[3,3]->1. }, 
            Description->"Right-handed W' couplings to leptons"},
  CLq == { TeX->Subsuperscript[C,q,L], ParameterType->External, ComplexParameter->False, Indices->{Index[Generation],Index[Generation]}, BlockName->CLq,
            Value-> {
              CLq[1,1]->.97418,   CLq[1,2]->.225773, CLq[1,3]->0.,
              CLq[2,1]->-.225773, CLq[2,2]->.97418,  CLq[2,3]->0.,
              CLq[3,1]->0.,       CLq[3,2]->0.,      CLq[3,3]->1. }, 
            Description->"Left-handed W' couplings to quarks"},
  CLl == { TeX->Subsuperscript[C,l,L], ParameterType->External, ComplexParameter->False, Indices->{Index[Generation],Index[Generation]}, BlockName->CLl,
            Value-> {
              CLl[1,1]->1.,  CLl[1,2]->0., CLl[1,3]->0.,
              CLl[2,1]->0.,  CLl[2,2]->1., CLl[2,3]->0.,
              CLl[3,1]->0.,  CLl[3,2]->0., CLl[3,3]->1. }, 
            Description->"Left-handed W' couplings to leptons"
	},


  kL == { ParameterType -> External, 
	  Value -> 1.0,
	  BlockName->SSMCOUP,
	  OrderBlock->1,
	  TeX -> Subscript[kappa,L], 
          Description -> "Left-handed W' coupling constant scale factor"
	},

  kR == { ParameterType -> External, 
	  Value -> 0.0, 
	  TeX -> Subscript[kappa,R], 
	  BlockName->SSMCOUP,
	  OrderBlock->2,
          Description -> "Right-handed W' coupling constant scale factor"
	},

(* Z_SSM vector coupling to fermions: gZp,f_V =  (1/2)TL3 - Qf*sW2 *)
  gZpuV == {
	ParameterType -> Internal, 
	Value         -> (1/2)*( 1/2) - ( 2/3)*sw2,
	Description   -> "Vector Zp-u-uBar Coupling"
  },
  gZpdV == {
	ParameterType -> Internal, 
	Value         -> (1/2)*(-1/2) - (-1/3)*sw2,
	Description   -> "Vector Zp-d-dBar Coupling"
  },
  gZpvV == {
	ParameterType -> Internal, 
	Value         -> (1/2)*( 1/2) - (0)*sw2,
	Description   -> "Vector Zp-v-vBar Coupling"
  },
  gZpeV == {
	ParameterType -> Internal, 
	Value         -> (1/2)*(-1/2) - (-1)*sw2,
	Description   -> "Vector Zp-e-eBar Coupling"
  },

(* Z_SSM axial-vector coupling to fermions: gZp,f_A = (-1/2)TL3 *)
  gZpuA == {
	ParameterType -> Internal, 
	Value         -> (-1/2)*(1/2),
	Description   -> "Axial-vector Zp-u-uBar Coupling"
  },
  gZpdA == {
	ParameterType -> Internal, 
	Value         -> (-1/2)*(-1/2),
	Description   -> "Axial-vector Zp-d-dBar Coupling"
  },
  gZpvA == {
	ParameterType -> Internal, 
	Value         -> (-1/2)*(1/2),
	Description   -> "Axial-vector Zp-v-vBar Coupling"
  },
  gZpeA == {
	ParameterType -> Internal, 
	Value         -> (-1/2)*(-1/2),
	Description   -> "Axial-vector Zp-e-eBar Coupling"
  },

(* Z_SSM LH coupling to fermions: gZp,f_L = gZpfV - gZpfA  *)
  gZpuL == {
	ParameterType -> Internal, 
	Value         -> gZpuV - gZpuA,
	Description   -> "LH Zp-u-uBar Coupling"
  },
  gZpdL == {
	ParameterType -> Internal, 
	Value         -> gZpdV - gZpdA,
	Description   -> "LH Zp-d-dBar Coupling"
  },
  gZpvL == {
	ParameterType -> Internal, 
	Value         -> gZpvV - gZpvA,
	Description   -> "LH Zp-v-vBar Coupling"
  },
  gZpeL == {
	ParameterType -> Internal, 
	Value         -> gZpeV - gZpeA,
	Description   -> "LH Zp-e-eBar Coupling"
  },

(* Z_SSM RH coupling to fermions: gZp,f_R = gZpfV + gZpfA  *)
  gZpuR == {
	ParameterType -> Internal, 
	Value         -> gZpuV + gZpuA,
	Description   -> "LH Zp-u-uBar Coupling"
  },
  gZpdR == {
	ParameterType -> Internal, 
	Value         -> gZpdV + gZpdA,
	Description   -> "LH Zp-d-dBar Coupling"
  },
  gZpvR == {
	ParameterType -> Internal, 
	Value         -> gZpvV + gZpvA,
	Description   -> "LH Zp-v-vBar Coupling"
  },
  gZpeR == {
	ParameterType -> Internal, 
	Value         -> gZpeV + gZpeA,
	Description   -> "LH Zp-e-eBar Coupling"
  }

};

(* ************************** *)
(* *** Interaction orders *** *)
(* ************************** *)

(* ZSSM Currents *)
LZSSMTmpU := -kL*ee/sw/cw *Zp[mu]*(gZpuR* uqbar.Ga[mu].ProjP.uq \
			   + gZpuL* uqbar.Ga[mu].ProjM.uq );
LZSSMTmpD := -kL*ee/sw/cw *Zp[mu]*(gZpdR* dqbar.Ga[mu].ProjP.dq \
			   + gZpdL* dqbar.Ga[mu].ProjM.dq );
LZSSMTmpV := -kL*ee/sw/cw *Zp[mu]*(gZpvR* vlbar.Ga[mu].ProjP.vl \
		   	   + gZpvL* vlbar.Ga[mu].ProjM.vl );
LZSSMTmpE := -kL*ee/sw/cw *Zp[mu]*(gZpeR*  lbar.Ga[mu].ProjP.l  \
			   + gZpeL*  lbar.Ga[mu].ProjM.l  );
LZSSM     := LZSSMTmpU + LZSSMTmpD + LZSSMTmpV + LZSSMTmpE;

(* WSSM Currents *)
LWSSMTmp := -kL*ee/sw/Sqrt[2]*(vlbar.Ga[mu].ProjM.CLl.l + uqbar.Ga[mu].ProjM.CLq.dq)*Wp[mu] \
            -kR*ee/sw/Sqrt[2]*(vlbar.Ga[mu].ProjP.CRl.l + uqbar.Ga[mu].ProjP.CRq.dq)*Wp[mu];

LWSSM := LWSSMTmp + HC[LWSSMTmp];

(* Combine Everything *)
LSSM  := LWSSM + LZSSM;
LFull := LSM + LSSM;