    (******               This is the FeynRules model file for the Leptoquark model : SM + LLQ                ******)
	(******                                                                                                   ******)
	(******                        Authors: J. Roy                                           ******)
	(******                     Choose whether Feynman gauge is desired.                                      ******)
    (******                      If set to False, unitary gauge is assumed.                                     ****)
    (******  Feynman gauge is especially useful for CalcHEP/CompHEP where the calculation is 10-100 times faster.***)
    (******                    Feynman gauge is not supported in MadGraph and Sherpa.                           ****)
	
	(* ************************** *)
	(* *****  Information   ***** *)
	(* ************************** *)
	M$ModelName = "1.5 TeV Leptoquark Model";
	
	M$Information = {Authors      -> {"J. Roy"},
                 Version      -> "1.0",
				 Date         -> "07. 15. 2017",
				 Institutions -> {"Institute of Thoeretical Physics, Beijing"},
				 Emails       -> {"jdroy@itp.ac.cn","joyroy.phy@gmail.com"}
		};
			
FeynmanGauge = False;


(***** Setting for interaction order (as e.g. used by MadGraph 5)  ******)

M$InteractionOrderHierarchy = {{QCD, 1},{QED, 2},{NP,2}};

M$InteractionOrderLimit = { {QCD, 99}, {QED, 99} , {NP,3}};

(****************  Parameters *************)

M$Parameters = {

    (* External Parameters *)
	
			  
     CLQ  == {
        ParameterType    -> External,
        ParameterName    -> "CLQ",
		ComplexParameter -> False,
		Indices          -> {Index[Generation], Index[Generation]},
	    TeX              -> Subscript[C,LQ],
		Value-> {
              CLQ[1,1]->0.,  CLQ[1,2]->0., CLQ[1,3]->0.,
              CLQ[2,1]->0.,  CLQ[2,2]->0., CLQ[2,3]->0.,
              CLQ[3,1]->0.,  CLQ[3,2]->0., CLQ[3,3]->1. }, 
		InteractionOrder -> {NP, 1},
        Description      -> "Left-handed Leptoquark Coupling parameter"
}
   
};		



(* ************************** *)
(* ****      Fields      **** *)
(* ************************** *)


M$ClassesDescription = {

(* Additional Leptoquark field: Physical vector fields *)


V[110] == {
        ClassName        -> LtQk,
	    SelfConjugate    -> False,
		Mass             -> {MLQ, 1500.0},
	    Width            -> {WLQ, 2.},
		ParticleName     -> "LtQk", 
		AntiParticleName -> "LtQk~",
		Indices          -> {Index[Colour]},
		QuantumNumbers   -> {Q -> 2/3, LeptonNumber -> -1}}
		(*FullName         -> "Leptoquark"*)
		
};





(* New Lagrangian interaction terms *)

LLQ := Block[{sp1,sp2,sp3,ff1,ff2,aa,lag},
   lag = CLQ[ff1,ff2].(uqbar[sp1,ff1,aa].Ga[mu,sp1,sp3].ProjM[sp3,sp2].vl[sp2,ff2] +
	      dqbar[sp1,ff1,aa].Ga[mu,sp1,sp3].ProjM[sp3,sp2].l[sp2,ff2]).LtQk[mu,aa];
      Return[lag + HC[lag]];
];

LLQqcd := Block[{mu,nu,aa,bb,cc1,cc2,lagqcd}, 
   lagqcd = 1/2 (DC[LtQkbar[nu,aa],mu] - DC[LtQkbar[mu,aa],nu])(DC[LtQk[nu,aa],mu] - DC[LtQk[mu,aa],nu]) + MLQ^2 LtQkbar[mu,aa].LtQk[mu,aa] - I gs LtQkbar[mu,cc1].FS[G,mu,nu,aa].T[aa,cc1,cc2].LtQk[nu,cc2] ; 
   Return[lagqcd];
];
   (* Since 'LtQk' is defined as "SelfConjugate-> False", need to use 'LtQkbar' specifically to conserve the quantum numbers at all vertices *)

(*********Final Lagrangian*******)	 
	
LTotal := LSM + LLQ + LLQqcd ;
