(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    122837,       2704]
NotebookOptionsPosition[    105273,       2462]
NotebookOutlinePosition[    105746,       2480]
CellTagsIndexPosition[    105703,       2477]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"R", ".", " ", "Ruiz"}], ";", " ", 
   RowBox[{"2024", " ", "February", " ", "1"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.665142881510211*^9, 3.665142884049021*^9}, {
  3.665142942303646*^9, 3.6651429529879627`*^9}, {3.915781408935854*^9, 
  3.915781417053225*^9}},ExpressionUUID->"cee4e897-cbc1-4bf1-a304-\
44bbfcd5aed3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "generate", " ", "LO", " ", 
     RowBox[{"UFO", ":", " ", 
      RowBox[{"Set", " ", "paths"}]}]}], ",", " ", 
    RowBox[{"load", " ", "model"}], ",", " ", 
    RowBox[{"write", " ", "UFO"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "generate", " ", "NLO", " ", 
     RowBox[{"UFO", ":", " ", 
      RowBox[{"Set", " ", "paths"}]}]}], ",", " ", 
    RowBox[{"load", " ", "model"}], ",", " ", 
    RowBox[{
     RowBox[{"extract", " ", "on"}], "-", 
     RowBox[{"shell", " ", "renormalization", " ", "terms"}]}], ",", " ", 
    RowBox[{"write", " ", "CT", " ", "terms"}], ",", " ", 
    RowBox[{"reset", " ", "paths"}], ",", " ", 
    RowBox[{"reload", " ", "model"}], ",", " ", 
    RowBox[{"write", " ", "everything", " ", "to", " ", 
     RowBox[{"file", "."}]}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.6648662671878157`*^9, 3.664866418502534*^9}, {
  3.664866852892112*^9, 
  3.664866879416404*^9}},ExpressionUUID->"4149d1d2-f5f9-4692-ab77-\
ed3366c4e0f7"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.861654623307424*^9, 3.861654624686407*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"7eec092d-a909-4a5c-86c4-663c165c8312"],

Cell[CellGroupData[{

Cell["FeynRules Setup", "Title",
 CellChangeTimes->{{3.596207285657744*^9, 3.596207286276866*^9}, {
  3.596207330352247*^9, 3.59620733250506*^9}, {3.655035967648223*^9, 
  3.65503597269068*^9}},ExpressionUUID->"36a8985f-3b71-4bb1-acae-\
6fbe5493c081"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$CurrentPath", "=", 
   RowBox[{"Directory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{"SetDirectory", "[", "\"\<~/PATH_TO_FR/FeynRules\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$CurrentPath", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
   3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
   3.4234163227881193`*^9}, {3.572102427116931*^9, 3.572102456206238*^9}, {
   3.572280529035656*^9, 3.572280529468644*^9}, {3.572366766720894*^9, 
   3.572366773370627*^9}, {3.596207212826934*^9, 3.5962072447909603`*^9}, {
   3.596914045279478*^9, 3.5969140472383204`*^9}, 3.596914102616413*^9, 
   3.596915921742405*^9, {3.596915961175353*^9, 3.59691596259039*^9}, {
   3.60744636894991*^9, 3.607446377507101*^9}, {3.6364757082312813`*^9, 
   3.636475708315627*^9}, {3.655035981353272*^9, 3.655035982244761*^9}, {
   3.6550360677717857`*^9, 3.655036081259776*^9}, {3.655036117419112*^9, 
   3.655036143336364*^9}, {3.655037954145546*^9, 3.6550379644813023`*^9}, {
   3.6605209855658293`*^9, 3.6605209855964212`*^9}, {3.6605772969976788`*^9, 
   3.660577300733718*^9}, {3.6621928886588717`*^9, 3.662192889375732*^9}, {
   3.6628197402754908`*^9, 3.662819763199905*^9}, 3.8616546615279083`*^9, {
   3.9157812154507437`*^9, 
   3.915781221148716*^9}},ExpressionUUID->"2b566197-5488-4f54-9e47-\
2d15cdf0dd38"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{{3.912887249515995*^9, 3.912887277031378*^9}, 
   3.912887575670307*^9, 3.9128964012065372`*^9, 3.913048142688889*^9, 
   3.9130500064320374`*^9, 3.913050130527836*^9, 3.913050231543453*^9, 
   3.913050351134853*^9, 3.913050500551477*^9, 3.913050672578713*^9, 
   3.9130507476994667`*^9, 3.913051545511651*^9, 3.913076007259791*^9, 
   3.9130761538447123`*^9, 3.913076223314002*^9, 3.913076465472743*^9, 
   3.913076500793632*^9, 3.91311451973176*^9, 3.913116906606896*^9, 
   3.913155212971789*^9, 3.915560858683702*^9, 3.91556175798633*^9, 
   3.915611043302732*^9, 3.91561959342465*^9, 3.915633750348263*^9, 
   3.91563496372218*^9, {3.915637358076454*^9, 3.9156373786180162`*^9}, 
   3.9156401333542557`*^9, 3.915641916058178*^9, 3.915641978780775*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"4d4ac3b9-593f-45a0-a909-b97331eaeb75"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.36\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"28 November 2019\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.36", " (" "28 November 2019", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.912887249515995*^9, 3.912887277031378*^9}, 
   3.912887575670307*^9, 3.9128964012065372`*^9, 3.913048142688889*^9, 
   3.9130500064320374`*^9, 3.913050130527836*^9, 3.913050231543453*^9, 
   3.913050351134853*^9, 3.913050500551477*^9, 3.913050672578713*^9, 
   3.9130507476994667`*^9, 3.913051545511651*^9, 3.913076007259791*^9, 
   3.9130761538447123`*^9, 3.913076223314002*^9, 3.913076465472743*^9, 
   3.913076500793632*^9, 3.91311451973176*^9, 3.913116906606896*^9, 
   3.913155212971789*^9, 3.915560858683702*^9, 3.91556175798633*^9, 
   3.915611043302732*^9, 3.91561959342465*^9, 3.915633750348263*^9, 
   3.91563496372218*^9, {3.915637358076454*^9, 3.9156373786180162`*^9}, 
   3.9156401333542557`*^9, 3.915641916058178*^9, 3.915641978784814*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"0ff452ec-329a-48ef-8af8-b484ea547c1e"],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{{3.912887249515995*^9, 3.912887277031378*^9}, 
   3.912887575670307*^9, 3.9128964012065372`*^9, 3.913048142688889*^9, 
   3.9130500064320374`*^9, 3.913050130527836*^9, 3.913050231543453*^9, 
   3.913050351134853*^9, 3.913050500551477*^9, 3.913050672578713*^9, 
   3.9130507476994667`*^9, 3.913051545511651*^9, 3.913076007259791*^9, 
   3.9130761538447123`*^9, 3.913076223314002*^9, 3.913076465472743*^9, 
   3.913076500793632*^9, 3.91311451973176*^9, 3.913116906606896*^9, 
   3.913155212971789*^9, 3.915560858683702*^9, 3.91556175798633*^9, 
   3.915611043302732*^9, 3.91561959342465*^9, 3.915633750348263*^9, 
   3.91563496372218*^9, {3.915637358076454*^9, 3.9156373786180162`*^9}, 
   3.9156401333542557`*^9, 3.915641916058178*^9, 3.9156419787869167`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"ba12d1b7-28b7-44bb-87b2-7440d50c55fb"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.912887249515995*^9, 3.912887277031378*^9}, 
   3.912887575670307*^9, 3.9128964012065372`*^9, 3.913048142688889*^9, 
   3.9130500064320374`*^9, 3.913050130527836*^9, 3.913050231543453*^9, 
   3.913050351134853*^9, 3.913050500551477*^9, 3.913050672578713*^9, 
   3.9130507476994667`*^9, 3.913051545511651*^9, 3.913076007259791*^9, 
   3.9130761538447123`*^9, 3.913076223314002*^9, 3.913076465472743*^9, 
   3.913076500793632*^9, 3.91311451973176*^9, 3.913116906606896*^9, 
   3.913155212971789*^9, 3.915560858683702*^9, 3.91556175798633*^9, 
   3.915611043302732*^9, 3.91561959342465*^9, 3.915633750348263*^9, 
   3.91563496372218*^9, {3.915637358076454*^9, 3.9156373786180162`*^9}, 
   3.9156401333542557`*^9, 3.915641916058178*^9, 3.915641978788274*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"2b0769c3-8078-4ede-9469-a309648e24aa"],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{{3.912887249515995*^9, 3.912887277031378*^9}, 
   3.912887575670307*^9, 3.9128964012065372`*^9, 3.913048142688889*^9, 
   3.9130500064320374`*^9, 3.913050130527836*^9, 3.913050231543453*^9, 
   3.913050351134853*^9, 3.913050500551477*^9, 3.913050672578713*^9, 
   3.9130507476994667`*^9, 3.913051545511651*^9, 3.913076007259791*^9, 
   3.9130761538447123`*^9, 3.913076223314002*^9, 3.913076465472743*^9, 
   3.913076500793632*^9, 3.91311451973176*^9, 3.913116906606896*^9, 
   3.913155212971789*^9, 3.915560858683702*^9, 3.91556175798633*^9, 
   3.915611043302732*^9, 3.91561959342465*^9, 3.915633750348263*^9, 
   3.91563496372218*^9, {3.915637358076454*^9, 3.9156373786180162`*^9}, 
   3.9156401333542557`*^9, 3.915641916058178*^9, 3.915641978790072*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"2081de6a-6cf4-4662-8b6a-45232c995360"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{{3.912887249515995*^9, 3.912887277031378*^9}, 
   3.912887575670307*^9, 3.9128964012065372`*^9, 3.913048142688889*^9, 
   3.9130500064320374`*^9, 3.913050130527836*^9, 3.913050231543453*^9, 
   3.913050351134853*^9, 3.913050500551477*^9, 3.913050672578713*^9, 
   3.9130507476994667`*^9, 3.913051545511651*^9, 3.913076007259791*^9, 
   3.9130761538447123`*^9, 3.913076223314002*^9, 3.913076465472743*^9, 
   3.913076500793632*^9, 3.91311451973176*^9, 3.913116906606896*^9, 
   3.913155212971789*^9, 3.915560858683702*^9, 3.91556175798633*^9, 
   3.915611043302732*^9, 3.91561959342465*^9, 3.915633750348263*^9, 
   3.91563496372218*^9, {3.915637358076454*^9, 3.9156373786180162`*^9}, 
   3.9156401333542557`*^9, 3.915641916058178*^9, 3.915641978791676*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"8c153932-50f8-4c3a-8131-89c877233f07"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{{3.912887249515995*^9, 3.912887277031378*^9}, 
   3.912887575670307*^9, 3.9128964012065372`*^9, 3.913048142688889*^9, 
   3.9130500064320374`*^9, 3.913050130527836*^9, 3.913050231543453*^9, 
   3.913050351134853*^9, 3.913050500551477*^9, 3.913050672578713*^9, 
   3.9130507476994667`*^9, 3.913051545511651*^9, 3.913076007259791*^9, 
   3.9130761538447123`*^9, 3.913076223314002*^9, 3.913076465472743*^9, 
   3.913076500793632*^9, 3.91311451973176*^9, 3.913116906606896*^9, 
   3.913155212971789*^9, 3.915560858683702*^9, 3.91556175798633*^9, 
   3.915611043302732*^9, 3.91561959342465*^9, 3.915633750348263*^9, 
   3.91563496372218*^9, {3.915637358076454*^9, 3.9156373786180162`*^9}, 
   3.9156401333542557`*^9, 3.915641916058178*^9, 3.9156419787924843`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"dca728df-dd9c-4e50-920e-d9a5203d6801"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.912887249515995*^9, 3.912887277031378*^9}, 
   3.912887575670307*^9, 3.9128964012065372`*^9, 3.913048142688889*^9, 
   3.9130500064320374`*^9, 3.913050130527836*^9, 3.913050231543453*^9, 
   3.913050351134853*^9, 3.913050500551477*^9, 3.913050672578713*^9, 
   3.9130507476994667`*^9, 3.913051545511651*^9, 3.913076007259791*^9, 
   3.9130761538447123`*^9, 3.913076223314002*^9, 3.913076465472743*^9, 
   3.913076500793632*^9, 3.91311451973176*^9, 3.913116906606896*^9, 
   3.913155212971789*^9, 3.915560858683702*^9, 3.91556175798633*^9, 
   3.915611043302732*^9, 3.91561959342465*^9, 3.915633750348263*^9, 
   3.91563496372218*^9, {3.915637358076454*^9, 3.9156373786180162`*^9}, 
   3.9156401333542557`*^9, 3.915641916058178*^9, 3.9156419787931356`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"3ff25800-db44-4e6e-beba-967a6cccae16"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{{3.912887249515995*^9, 3.912887277031378*^9}, 
   3.912887575670307*^9, 3.9128964012065372`*^9, 3.913048142688889*^9, 
   3.9130500064320374`*^9, 3.913050130527836*^9, 3.913050231543453*^9, 
   3.913050351134853*^9, 3.913050500551477*^9, 3.913050672578713*^9, 
   3.9130507476994667`*^9, 3.913051545511651*^9, 3.913076007259791*^9, 
   3.9130761538447123`*^9, 3.913076223314002*^9, 3.913076465472743*^9, 
   3.913076500793632*^9, 3.91311451973176*^9, 3.913116906606896*^9, 
   3.913155212971789*^9, 3.915560858683702*^9, 3.91556175798633*^9, 
   3.915611043302732*^9, 3.91561959342465*^9, 3.915633750348263*^9, 
   3.91563496372218*^9, {3.915637358076454*^9, 3.9156373786180162`*^9}, 
   3.9156401333542557`*^9, 3.915641916058178*^9, 3.915641978793727*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"abfe83ea-1c4f-428e-8a1a-c42ac085f7ae"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.912887249515995*^9, 3.912887277031378*^9}, 
   3.912887575670307*^9, 3.9128964012065372`*^9, 3.913048142688889*^9, 
   3.9130500064320374`*^9, 3.913050130527836*^9, 3.913050231543453*^9, 
   3.913050351134853*^9, 3.913050500551477*^9, 3.913050672578713*^9, 
   3.9130507476994667`*^9, 3.913051545511651*^9, 3.913076007259791*^9, 
   3.9130761538447123`*^9, 3.913076223314002*^9, 3.913076465472743*^9, 
   3.913076500793632*^9, 3.91311451973176*^9, 3.913116906606896*^9, 
   3.913155212971789*^9, 3.915560858683702*^9, 3.91556175798633*^9, 
   3.915611043302732*^9, 3.91561959342465*^9, 3.915633750348263*^9, 
   3.91563496372218*^9, {3.915637358076454*^9, 3.9156373786180162`*^9}, 
   3.9156401333542557`*^9, 3.915641916058178*^9, 3.9156419787942877`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"ac3d8c75-6565-45d0-9f70-19c249fc1b49"],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{{3.912887249515995*^9, 3.912887277031378*^9}, 
   3.912887575670307*^9, 3.9128964012065372`*^9, 3.913048142688889*^9, 
   3.9130500064320374`*^9, 3.913050130527836*^9, 3.913050231543453*^9, 
   3.913050351134853*^9, 3.913050500551477*^9, 3.913050672578713*^9, 
   3.9130507476994667`*^9, 3.913051545511651*^9, 3.913076007259791*^9, 
   3.9130761538447123`*^9, 3.913076223314002*^9, 3.913076465472743*^9, 
   3.913076500793632*^9, 3.91311451973176*^9, 3.913116906606896*^9, 
   3.913155212971789*^9, 3.915560858683702*^9, 3.91556175798633*^9, 
   3.915611043302732*^9, 3.91561959342465*^9, 3.915633750348263*^9, 
   3.91563496372218*^9, {3.915637358076454*^9, 3.9156373786180162`*^9}, 
   3.9156401333542557`*^9, 3.915641916058178*^9, 3.915641978794772*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"5e7ac8e2-1d57-4b11-bc6e-018b4d85d72b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Choose", " ", "one", " ", "of", " ", "the", " ", "three", " ", 
     RowBox[{"files", ":", " ", "vpolar"}]}], ",", " ", "wpolar", ",", " ", 
    "zpolar"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"LoadModel", "[", "\"\<sm_loop_vpolar.fr\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"LoadModel", "[", "\"\<sm_loop_wpolar.fr\>\"", "]"}], ";"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"LoadModel", "[", "\"\<sm_loop_zpolar.fr\>\"", "]"}], ";"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LoadRestriction", "[", 
     RowBox[{"\"\<diagonalCKM.rst\>\"", ",", "\"\<massless.rst\>\""}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FeynmanGauge", "=", "True"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6550379628078337`*^9, 3.6550379664979897`*^9}, 
   3.6605212599219637`*^9, {3.660521401196807*^9, 3.660521401690201*^9}, {
   3.6628198742702703`*^9, 3.6628198755313597`*^9}, {3.8616546038612413`*^9, 
   3.8616546064396963`*^9}, {3.9128866426988773`*^9, 
   3.9128866427566338`*^9}, {3.915611050502357*^9, 3.915611059850965*^9}, {
   3.915619596932329*^9, 3.915619602734688*^9}, {3.9156337550519953`*^9, 
   3.915633794690062*^9}, {3.9156373614598293`*^9, 3.9156373650923643`*^9}, {
   3.915640136364911*^9, 3.9156401416867523`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"0e39e6c0-37a4-4139-8e09-3d0b04f3b8fd"],

Cell[CellGroupData[{

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.915637382871049*^9, 3.915640145072423*^9, 
  3.915641921173086*^9, 3.915641982585558*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"1f6006ec-ed2c-4d8b-acbb-3c632a6c3651"],

Cell[BoxData["\<\"N. Christensen\"\>"], "Print",
 CellChangeTimes->{3.915637382871049*^9, 3.915640145072423*^9, 
  3.915641921173086*^9, 3.915641982588326*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"c15f1a0c-a03b-4228-97f7-d14eb638caae"],

Cell[BoxData["\<\"C. Duhr\"\>"], "Print",
 CellChangeTimes->{3.915637382871049*^9, 3.915640145072423*^9, 
  3.915641921173086*^9, 3.9156419825901623`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"f6105458-88dc-48a1-948f-30551032584a"],

Cell[BoxData["\<\"B. Fuks\"\>"], "Print",
 CellChangeTimes->{3.915637382871049*^9, 3.915640145072423*^9, 
  3.915641921173086*^9, 3.915641982591577*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"76e0c67d-79dd-4e80-8791-0a3032a71bb4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.4.7\"\>"}],
  SequenceForm["Model Version: ", "1.4.7"],
  Editable->False]], "Print",
 CellChangeTimes->{3.915637382871049*^9, 3.915640145072423*^9, 
  3.915641921173086*^9, 3.9156419825934677`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"4a731c7f-e759-4b43-a419-b0885b31a42e"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be/view/Main/StandardModel\"\>\
"], "Print",
 CellChangeTimes->{3.915637382871049*^9, 3.915640145072423*^9, 
  3.915641921173086*^9, 3.915641982594796*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"4b41b075-2e83-4e4c-9624-c7caa1ad0e20"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.915637382871049*^9, 3.915640145072423*^9, 
  3.915641921173086*^9, 3.915641982596122*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"1a64c1cb-1e77-4b76-ad7d-c90a34191f97"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.915637382871049*^9, 3.915640145072423*^9, 
  3.915641921173086*^9, 3.9156419825971003`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"d141bc42-2afa-4e6d-8ad5-a298447019bc"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.915637382871049*^9, 3.915640145072423*^9, 
  3.915641921173086*^9, 3.9156419825980463`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"213b4c60-4306-4852-961f-4d18641b7b38"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.915637382871049*^9, 3.915640145072423*^9, 
  3.915641921173086*^9, 3.9156419826933947`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"78303c24-6314-49d4-9689-033e06bb71c7"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.915637382871049*^9, 3.915640145072423*^9, 
  3.915641921173086*^9, 3.915641982717186*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"f70123b7-4c96-48e4-a329-f856afde08f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"Standard Model\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "Standard Model", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.915637382871049*^9, 3.915640145072423*^9, 
  3.915641921173086*^9, 3.915641982748906*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"c42c919e-03b4-4507-a0a9-59d3d3533b06"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"diagonalCKM.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{226., {2., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "6"}],
  SequenceForm["Loading restrictions from ", "diagonalCKM.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 6],
  Editable->False]], "Print",
 CellChangeTimes->{3.915637382871049*^9, 3.915640145072423*^9, 
  3.915641921173086*^9, 3.915641983346434*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"139ba302-6473-42a4-8c9f-a52d2c87c9f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"massless.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{226., {2., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "24"}],
  SequenceForm["Loading restrictions from ", "massless.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 24],
  Editable->False]], "Print",
 CellChangeTimes->{3.915637382871049*^9, 3.915640145072423*^9, 
  3.915641921173086*^9, 3.9156419835035133`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"4e31d5d7-ba3c-4ede-8299-7a52ab67a7a0"],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{3.915637382871049*^9, 3.915640145072423*^9, 
  3.915641921173086*^9, 3.915641983615013*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"d8f04cd7-e4d2-4865-b393-7172c9d96cf2"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pQCDLag", "=", " ", 
   RowBox[{"ExpandIndices", "/@", 
    RowBox[{"Simplify", "[", "LSM", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Definition", "[", "pQCDLag", "]"}], " ", ">>", " ", 
   "vpolar_lagrangian.dat"}], ";"}]}], "Input",
 CellChangeTimes->{{3.715342142509688*^9, 3.715342163031452*^9}, {
   3.715344057238492*^9, 3.715344058291609*^9}, {3.7178506900799713`*^9, 
   3.717850690973333*^9}, {3.7180002809816017`*^9, 3.718000300883692*^9}, {
   3.718000394980835*^9, 3.7180003951009827`*^9}, {3.745153113604156*^9, 
   3.745153113886346*^9}, {3.757403422964182*^9, 3.757403423697225*^9}, {
   3.758251145793989*^9, 3.7582511468706083`*^9}, 3.7582513470889874`*^9, {
   3.76335111930016*^9, 3.763351139093457*^9}, {3.7633511693483973`*^9, 
   3.763351173687544*^9}, {3.763886545633397*^9, 3.763886571907737*^9}, 
   3.767099220292862*^9, {3.767374514400957*^9, 3.767374515454331*^9}, {
   3.767375022418717*^9, 3.76737502255937*^9}, {3.7674580186709423`*^9, 
   3.767458019546134*^9}, {3.767610478088133*^9, 3.767610507175609*^9}, {
   3.767610538533186*^9, 3.76761053951677*^9}, {3.767610603703107*^9, 
   3.7676106297846937`*^9}, {3.7676900131323767`*^9, 
   3.7676900151887627`*^9}, {3.76858524470041*^9, 3.768585245204138*^9}, {
   3.77027747721585*^9, 3.7702775056436033`*^9}, {3.7711262488766813`*^9, 
   3.771126253973398*^9}, {3.771126559639118*^9, 3.771126602632146*^9}, 
   3.771139675031245*^9, {3.771139748794265*^9, 3.771139751639614*^9}, {
   3.7711399153197002`*^9, 3.7711399456001577`*^9}, {3.771139981523079*^9, 
   3.771139981644162*^9}, {3.77857888321222*^9, 3.778578897476334*^9}, {
   3.77857892985773*^9, 3.7785789375119877`*^9}, 3.7785789770568542`*^9, {
   3.77857907445473*^9, 3.7785791018908577`*^9}, {3.779597422325054*^9, 
   3.779597426820354*^9}, {3.780921597734684*^9, 3.780921601148004*^9}, 
   3.780942736968416*^9, {3.780998835004087*^9, 3.780998837598987*^9}, 
   3.914884774807321*^9, {3.914884819987893*^9, 3.914884891493264*^9}, {
   3.9152601526626997`*^9, 3.9152601638796377`*^9}, {3.9152668085452423`*^9, 
   3.9152668090098143`*^9}, {3.915268574545311*^9, 3.915268615074039*^9}, {
   3.91526878602829*^9, 3.915268803045566*^9}, 3.915268845679759*^9, 
   3.9153122433422203`*^9, {3.915312313405923*^9, 3.9153123140255613`*^9}, {
   3.915312460407957*^9, 3.91531248638748*^9}, 3.91555992288029*^9, 
   3.9155599686602783`*^9, {3.915560900926422*^9, 3.915560918177857*^9}, {
   3.915640163572584*^9, 3.915640166577341*^9}, {3.915641987412075*^9, 
   3.915641989263286*^9}},ExpressionUUID->"97808359-025b-4359-9ecf-\
779e8e5ca2d2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Is", " ", "it", " ", "necessary", " ", "to", " ", "re"}], "-", 
    RowBox[{
    "expand", " ", "the", " ", "Lagrangian", " ", "if", " ", "it", " ", "is", 
     " ", "already", " ", "written", " ", "to", " ", 
     RowBox[{"file", "?"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Get", "[", "\"\<vpolar_lagrangian.dat\>\"", "]"}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.915641929585512*^9, 3.915641968943142*^9}, {
  3.915781243660981*^9, 
  3.915781294765223*^9}},ExpressionUUID->"e0d984d8-7455-49ec-998c-\
c35045fd9a86"],

Cell[CellGroupData[{

Cell["Lagrangian Terms", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, {
  3.572348211890565*^9, 3.572348234275403*^9}, {3.596207324453108*^9, 
  3.596207326711195*^9}, {3.655036212669145*^9, 3.6550362220422897`*^9}, {
  3.655036282693001*^9, 3.655036287060457*^9}, {3.655037866940884*^9, 
  3.6550378926486187`*^9}, {3.662214296374611*^9, 
  3.662214296674329*^9}},ExpressionUUID->"430f6c12-ab98-447b-8fa4-\
8a13c875b6c3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LHiggs", "]"}]], "Input",
 CellChangeTimes->{{3.664866736738257*^9, 3.664866737292602*^9}, {
  3.86165470748829*^9, 3.8616547308642673`*^9}, {3.915618525994691*^9, 
  3.915618560206333*^9}, {3.9157802889645863`*^9, 
  3.915780294808648*^9}},ExpressionUUID->"01776d56-05d4-475b-b025-\
2f0ebd0c8fc8"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.8616547327058153`*^9, {3.915618531935725*^9, 3.915618560698848*^9}, 
   3.915637514802968*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"ad7147cd-90d5-49f0-b387-0343e72459ac"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.8616547327058153`*^9, {3.915618531935725*^9, 3.915618560698848*^9}, 
   3.915637514805875*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"b4a6bc98-715d-4abc-8d8c-53ddff957489"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.8616547327058153`*^9, {3.915618531935725*^9, 3.915618560698848*^9}, 
   3.915637514831558*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"110bb0d8-bad8-493b-b401-35b1b5f755c3"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{
  3.8616547327058153`*^9, {3.915618531935725*^9, 3.915618560698848*^9}, 
   3.9156375148322144`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"dfe9be29-85cc-4300-8625-020e53ba16c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8616547327058153`*^9, {3.915618531935725*^9, 3.915618560698848*^9}, 
   3.915637514832646*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"ba028401-557e-41f7-b903-df112c97cd38"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{{3.915618534112711*^9, 3.915618560720058*^9}, 
   3.9156375148330584`*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"78e8edf7-e7ef-4da3-a3fe-3149222e6001"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sanity Checks for New Lagrangian Terms", "Section",
 CellChangeTimes->{{3.4234156496121893`*^9, 3.423415657027569*^9}, {
  3.655037883884348*^9, 
  3.655037906883815*^9}},ExpressionUUID->"963bd5da-1517-491b-8768-\
3e81fb288ca2"],

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "pQCDLag", "]"}]], "Input",ExpressionUUID->"ac633701-1714-47ff-b059-96a9d55ac743"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckMassSpectrum", "[", "LHiggs", "]"}]], "Input",
 CellChangeTimes->{{3.607446409988699*^9, 3.6074464110954323`*^9}, 
   3.6550378392495413`*^9, {3.861654777282482*^9, 3.861654778067959*^9}, {
   3.8616548452623672`*^9, 3.8616548478156652`*^9}, {3.913051554641657*^9, 
   3.913051556105932*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"92049f5e-2336-49b3-a1cf-102286807753"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6760964240892897`*^9, 3.8616547962502604`*^9, 3.861654850491796*^9, 
   3.861884192788991*^9, 3.912887383405389*^9, 3.912896591176524*^9, 
   3.913049325884521*^9, {3.9130500368632936`*^9, 3.9130500515206633`*^9}, 
   3.913050141026074*^9, 3.913050243631068*^9, 3.913050363672976*^9, 
   3.913050513816114*^9, 3.913050682607633*^9, 3.913050983978071*^9, 
   3.913051558908925*^9, 3.913076021981505*^9, 3.9130761665329857`*^9, 
   3.9130762351912613`*^9, 3.9130767127511168`*^9, 3.915562627346305*^9, 
   3.9156111688870173`*^9, 3.9156205560519123`*^9, 3.9156350780813704`*^9, 
   3.915637596990299*^9, 3.915641635720832*^9},
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"83ed3121-7c45-42b6-a73c-536be8e0990c"],

Cell[BoxData["\<\"All mass terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{
  3.6760964240892897`*^9, 3.8616547962502604`*^9, 3.861654850491796*^9, 
   3.861884192788991*^9, 3.912887383405389*^9, 3.912896591176524*^9, 
   3.913049325884521*^9, {3.9130500368632936`*^9, 3.9130500515206633`*^9}, 
   3.913050141026074*^9, 3.913050243631068*^9, 3.913050363672976*^9, 
   3.913050513816114*^9, 3.913050682607633*^9, 3.913050983978071*^9, 
   3.913051558908925*^9, 3.913076021981505*^9, 3.9130761665329857`*^9, 
   3.9130762351912613`*^9, 3.9130767127511168`*^9, 3.915562627346305*^9, 
   3.9156111688870173`*^9, 3.9156205560519123`*^9, 3.9156350780813704`*^9, 
   3.915637596990299*^9, 3.91564163576924*^9},
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"7d0b43f5-72f4-4eaf-887b-907ba02ee1ff"],

Cell[BoxData["\<\"Getting mass spectrum.\"\>"], "Print",
 CellChangeTimes->{
  3.6760964240892897`*^9, 3.8616547962502604`*^9, 3.861654850491796*^9, 
   3.861884192788991*^9, 3.912887383405389*^9, 3.912896591176524*^9, 
   3.913049325884521*^9, {3.9130500368632936`*^9, 3.9130500515206633`*^9}, 
   3.913050141026074*^9, 3.913050243631068*^9, 3.913050363672976*^9, 
   3.913050513816114*^9, 3.913050682607633*^9, 3.913050983978071*^9, 
   3.913051558908925*^9, 3.913076021981505*^9, 3.9130761665329857`*^9, 
   3.9130762351912613`*^9, 3.9130767127511168`*^9, 3.915562627346305*^9, 
   3.9156111688870173`*^9, 3.9156205560519123`*^9, 3.9156350780813704`*^9, 
   3.915637596990299*^9, 3.915641636866457*^9},
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"e4851d06-682f-456f-819f-0b16bb338d54"],

Cell[BoxData["\<\"Checking for less then 0.1% agreement with model file \
values.\"\>"], "Print",
 CellChangeTimes->{
  3.6760964240892897`*^9, 3.8616547962502604`*^9, 3.861654850491796*^9, 
   3.861884192788991*^9, 3.912887383405389*^9, 3.912896591176524*^9, 
   3.913049325884521*^9, {3.9130500368632936`*^9, 3.9130500515206633`*^9}, 
   3.913050141026074*^9, 3.913050243631068*^9, 3.913050363672976*^9, 
   3.913050513816114*^9, 3.913050682607633*^9, 3.913050983978071*^9, 
   3.913051558908925*^9, 3.913076021981505*^9, 3.9130761665329857`*^9, 
   3.9130762351912613`*^9, 3.9130767127511168`*^9, 3.915562627346305*^9, 
   3.9156111688870173`*^9, 3.9156205560519123`*^9, 3.9156350780813704`*^9, 
   3.915637596990299*^9, 3.915641636868479*^9},
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"8c9cd384-69f1-435e-8d0a-8599d0c3160a"]
}, Open  ]],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Particle\"\>", "\<\"Analytic value\"\>", "\<\"Numerical value\"\>", \
"\<\"Model-file value\"\>"},
    {"H", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["\[Mu]", "2"], "2"]}], "+", 
        FractionBox[
         RowBox[{"3", " ", "lam", " ", 
          SuperscriptBox["vev", "2"]}], "2"]}]]}], "125.7`", "125.7`"},
    {"W0", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       FractionBox[
        RowBox[{
         SuperscriptBox["e", "2"], " ", 
         SuperscriptBox["vev", "2"]}], 
        SubsuperscriptBox["s", "w", "2"]]]}], "79.95122985543638`", 
     "79.9512298554364`"},
    {"WA", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       FractionBox[
        RowBox[{
         SuperscriptBox["e", "2"], " ", 
         SuperscriptBox["vev", "2"]}], 
        SubsuperscriptBox["s", "w", "2"]]]}], "79.95122985543638`", 
     "79.9512298554364`"},
    {"WT", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       FractionBox[
        RowBox[{
         SuperscriptBox["e", "2"], " ", 
         SuperscriptBox["vev", "2"]}], 
        SubsuperscriptBox["s", "w", "2"]]]}], "79.95122985543638`", 
     "79.9512298554364`"},
    {"WX", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       FractionBox[
        RowBox[{
         SuperscriptBox["e", "2"], " ", 
         SuperscriptBox["vev", "2"]}], 
        SubsuperscriptBox["s", "w", "2"]]]}], "79.95122985543638`", 
     "79.9512298554364`"},
    {"Z0", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SuperscriptBox["vev", "2"]}], "4"], "+", 
        FractionBox[
         RowBox[{
          SubsuperscriptBox["c", "w", "2"], " ", 
          SuperscriptBox["e", "2"], " ", 
          SuperscriptBox["vev", "2"]}], 
         RowBox[{"8", " ", 
          SubsuperscriptBox["s", "w", "2"]}]], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SubsuperscriptBox["s", "w", "2"], " ", 
          SuperscriptBox["vev", "2"]}], 
         RowBox[{"8", " ", 
          SubsuperscriptBox["c", "w", "2"]}]]}]]}], "91.1876`", "91.1876`"},
    {"ZA", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SuperscriptBox["vev", "2"]}], "4"], "+", 
        FractionBox[
         RowBox[{
          SubsuperscriptBox["c", "w", "2"], " ", 
          SuperscriptBox["e", "2"], " ", 
          SuperscriptBox["vev", "2"]}], 
         RowBox[{"8", " ", 
          SubsuperscriptBox["s", "w", "2"]}]], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SubsuperscriptBox["s", "w", "2"], " ", 
          SuperscriptBox["vev", "2"]}], 
         RowBox[{"8", " ", 
          SubsuperscriptBox["c", "w", "2"]}]]}]]}], "91.1876`", "91.1876`"},
    {"ZT", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SuperscriptBox["vev", "2"]}], "4"], "+", 
        FractionBox[
         RowBox[{
          SubsuperscriptBox["c", "w", "2"], " ", 
          SuperscriptBox["e", "2"], " ", 
          SuperscriptBox["vev", "2"]}], 
         RowBox[{"8", " ", 
          SubsuperscriptBox["s", "w", "2"]}]], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SubsuperscriptBox["s", "w", "2"], " ", 
          SuperscriptBox["vev", "2"]}], 
         RowBox[{"8", " ", 
          SubsuperscriptBox["c", "w", "2"]}]]}]]}], "91.1876`", "91.1876`"},
    {"ZX", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SuperscriptBox["vev", "2"]}], "4"], "+", 
        FractionBox[
         RowBox[{
          SubsuperscriptBox["c", "w", "2"], " ", 
          SuperscriptBox["e", "2"], " ", 
          SuperscriptBox["vev", "2"]}], 
         RowBox[{"8", " ", 
          SubsuperscriptBox["s", "w", "2"]}]], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SubsuperscriptBox["s", "w", "2"], " ", 
          SuperscriptBox["vev", "2"]}], 
         RowBox[{"8", " ", 
          SubsuperscriptBox["c", "w", "2"]}]]}]]}], "91.1876`", "91.1876`"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.913076236062688*^9, 3.91307671377273*^9, 
  3.915562628484663*^9, 3.915611169445716*^9, 3.915620557203182*^9, 
  3.915635078687229*^9, 3.915637597481542*^9, 3.915641636870161*^9},
 CellLabel->
  "Out[11]//TableForm=",ExpressionUUID->"59d97bf5-775e-443b-9d3b-\
2dfb2fc8fe30"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"CheckKineticTermNormalisation", "[", "LGauge", "]"}]], "Input",
 CellChangeTimes->{{3.414763473002973*^9, 3.4147634845507174`*^9}, {
   3.572348320182221*^9, 3.572348326613598*^9}, {3.572358912362153*^9, 
   3.572358917148378*^9}, {3.596207478919518*^9, 3.596207486580676*^9}, {
   3.596212578276376*^9, 3.5962125890639143`*^9}, 3.607446414234477*^9, {
   3.86165478154783*^9, 3.8616547825023623`*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"98abda96-0800-4fdf-a9dc-54c145864a34"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UFO Output", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.59620768137986*^9, 
   3.596207684212212*^9}},ExpressionUUID->"47f009e8-0603-4d37-95af-\
884018211353"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Choose", " ", "one", " ", "of", " ", "the", " ", "three", " ", 
     RowBox[{"files", ":", " ", "vpolar"}]}], ",", " ", "wpolar", ",", " ", 
    "zpolar"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"WriteUFO", "[", 
     RowBox[{"pQCDLag", ",", 
      RowBox[{"Output", "\[Rule]", "\"\<SM_VPolar_XLO\>\""}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"WriteUFO", "[", 
      RowBox[{"pQCDLag", ",", 
       RowBox[{"Output", "\[Rule]", "\"\<SM_WPolar_XLO\>\""}]}], "]"}], ";"}],
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"WriteUFO", "[", 
      RowBox[{"pQCDLag", ",", 
       RowBox[{"Output", "\[Rule]", "\"\<SM_ZPolar_XLO\>\""}]}], "]"}], ";"}],
     "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.86165481715454*^9, 3.86165482958214*^9}, {
   3.8616549433492403`*^9, 3.8616549496521873`*^9}, {3.861685355081511*^9, 
   3.861685363252585*^9}, {3.9128867372412367`*^9, 3.9128867504953413`*^9}, 
   3.9128869570689173`*^9, {3.915560948192116*^9, 3.9155609830758123`*^9}, {
   3.915562206773633*^9, 3.915562207483501*^9}, {3.915611143398251*^9, 
   3.915611170976355*^9}, {3.915620106478825*^9, 3.915620113452277*^9}, {
   3.9156350230206833`*^9, 3.915635052179039*^9}, {3.915637628382011*^9, 
   3.915637637768077*^9}, {3.915640338820579*^9, 3.915640343502655*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"758085c5-adf3-40e0-830a-07fa05d96b6c"],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.915641662278695*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"efe5d50d-8d4b-4ffc-ba41-3dbd9266a7e7"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.91564166371111*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"fba6eacc-1ed8-4e6a-99c5-7abf15f0d8c6"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.915641663713972*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"32776f0f-0a52-473f-9295-16b252e9e487"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 12, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.9156416637153807`*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"236a5d2a-58fa-49bd-af53-aa5199072083"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.915641691302638*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"b08ac910-1b6e-48ec-be04-b8aee1d47e1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "905", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{195., {3., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "905", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  905, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 905, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.91564169186045*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"97e2ad9c-326a-4a90-a340-2abb379768a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"854", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[854, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.915641714608047*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"0ec1c870-7aa6-4d59-a410-f3b1fba4c5e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "12", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{148., {3., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "854"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 12, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 854],
  Editable->False]], "Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.915641722374485*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"e5939aa8-5257-4f7f-89f6-753da63df342"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.915641732090476*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"52b8f533-f01a-4b0f-a42a-f2220c9ccab4"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.915641732123837*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"1f6af9d8-9211-431a-98b8-086ca423bd58"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{133., {3., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "212"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 212],
  Editable->False]], "Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.915641732147189*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"a4570cc1-b87d-401e-909a-c1454e8f58e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "16.648857`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 16.648857, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.915641767896209*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"cc54b6aa-15e8-4f66-b4eb-9d0ede4e9975"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{133., {3., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "251"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 251],
  Editable->False]], "Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.91564176789806*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"28981911-1ec6-4415-94f4-27a897fb45a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "3.613981`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 3.613981, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.915641771981142*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"65f57f24-0a21-40bf-bb39-f71819e680d8"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.915641771984147*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"bf4f2976-7f54-48cb-8aae-21c1abeb019d"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.9156417723900843`*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"81f6af8c-86f3-432a-89ee-4c873af19f70"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "12", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 12, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.9156417724595222`*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"eef6cb96-6e36-45eb-8eb2-4cde4d4cc31a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{226., {3., 10.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "854", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 854, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.915641775574494*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"d98fb764-508a-454e-8a61-d28a711c67aa"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.915641775810152*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"6804a583-41f6-4740-a9d0-79074bcd0361"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{3.912896631091104*^9, 3.913049420600663*^9, 
  3.913076759036146*^9, 3.9155626507292023`*^9, 3.915611171200577*^9, 
  3.9156205808611097`*^9, 3.915635080681964*^9, 3.91563763953545*^9, 
  3.915641776159041*^9},
 CellLabel->
  "During evaluation of \
In[13]:=",ExpressionUUID->"b8afd9b3-5b0c-43af-894a-0c6efe8e6a15"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["On-Shell Renormalization with FeynArts", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.59620768137986*^9, 3.596207684212212*^9}, {3.662199318805483*^9, 
   3.6621993287719097`*^9}, {3.662216149623213*^9, 
   3.662216170908692*^9}},ExpressionUUID->"f35c5a82-2f44-4096-9399-\
e82f5b97ff8d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Assumes", " ", "Setup", " ", "from", " ", "above", " ", "was", " ", 
    "called"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"LRen", " ", "=", " ", 
     RowBox[{"OnShellRenormalization", "[", 
      RowBox[{"pQCDLag", ",", 
       RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
       RowBox[{"FlavorMixing", "\[Rule]", " ", "False"}], ",", 
       RowBox[{"Exclude4ScalarsCT", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"SetDirectory", "[", "\"\<~/PATH_TO_FA/FeynArts/Models\>\"", "]"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"WriteFeynArtsOutput", "[", 
     RowBox[{"LRen", ",", 
      RowBox[{"GenericFile", "\[Rule]", "True"}], ",", 
      RowBox[{"FlavorExpand", "\[Rule]", "True"}], ",", 
      RowBox[{"Output", "\[Rule]", "\"\<SM_Loop_VPolar_FA\>\""}]}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.9128872437464952`*^9, 3.912887244594708*^9}, 
   3.913077528037888*^9, {3.913114472993066*^9, 3.9131144851067343`*^9}, {
   3.913114549979589*^9, 3.9131145514739017`*^9}, {3.913116930543614*^9, 
   3.91311693520016*^9}, {3.9131552320203667`*^9, 3.913155232435649*^9}, {
   3.915562684131472*^9, 3.915562688109376*^9}, 3.9155627489455547`*^9, {
   3.915635119612056*^9, 3.9156351390117197`*^9}, {3.9157813246718807`*^9, 
   3.915781326035039*^9}},ExpressionUUID->"7cbd8e0c-bc17-43d7-8e66-\
37ef6a194ab6"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Putting 4 scalars term aside for the renormalization\"\>"], \
"Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.9156420030308657`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"5b6159b4-f381-41bd-b30a-89cd3d90b7bc"],

Cell[BoxData["\<\"Extracting the mass and kinetic terms to simplify \
them\"\>"], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.915642018461681*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"ca97e212-f124-4e1e-b63b-d881d74522cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.915642035193337*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"31873469-0cd1-4ff1-81c7-de54dcf5f4da"],

Cell[BoxData["\<\"renormalizing the fields\"\>"], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.91564207432592*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"975aa446-77d6-4c81-a788-017063a0bc4b"],

Cell[BoxData["\<\"No mixing allowed for the renormalization\"\>"], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.915642074401038*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"bea99c55-06e1-42c2-91c2-b03c37c3dcb9"],

Cell[BoxData["\<\"renormalizing the parameters\"\>"], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.91564207443039*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"7c40f2eb-0569-4daf-87df-aa3fad5aafb0"],

Cell[BoxData["\<\"renormalizing the masses\"\>"], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.9156420744320908`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"43f041ff-f9ba-4642-980d-7bf422e81a23"],

Cell[BoxData["\<\"renormalizing the other external parameters\"\>"], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.91564207443359*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"eba24c3e-b0e5-45b1-a978-5c0c2cbae489"],

Cell[BoxData["\<\"Internal parameter renormalization\"\>"], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.915642074435111*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"04bbef6d-3e46-4269-8711-1687c1d877c6"],

Cell[BoxData["\<\"renormalizing the Lagrangian\"\>"], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.915642079701807*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"e5be37c2-76ad-4180-9629-22ec9844bc6b"],

Cell[BoxData["\<\"with the parameters\"\>"], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.915642079772464*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"90b9b158-7da5-40a8-b60b-5aa6ed901f8a"],

Cell[BoxData["\<\"with the fields\"\>"], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.915642080253537*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"14e8a0b6-48bc-4d7f-9cda-450def5d7a14"]
}, Open  ]],

Cell[BoxData["\<\"/home/richard/Scripts/FeynArts/FeynArts-3.11/Models\"\>"], \
"Output",
 CellChangeTimes->{3.912897021652402*^9, 3.913049699498197*^9, 
  3.9130770586807823`*^9, 3.913077729531104*^9, 3.913114626309532*^9, 
  3.913117041198494*^9, 3.913155312116624*^9, 3.915562951748036*^9, 
  3.915611225887409*^9, 3.91562089128279*^9, 3.915635178328033*^9, 
  3.9156377487214727`*^9, 3.915642182748485*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"e6f4dcec-627a-4791-a2b8-ea794631e20b"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - - - FeynRules interface to FeynArts - - -\"\>"], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.915642182749938*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"e3c6e209-77b5-4856-a146-ea232ca4f9ae"],

Cell[BoxData["\<\"      C. Degrande C. Duhr, 2013\"\>"], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.915642182751173*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"c3832de8-abbc-4504-87a4-75e842b3a737"],

Cell[BoxData["\<\"      Counterterms: B. Fuks, 2012\"\>"], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.9156421827529783`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"9e7b525e-ce3e-4560-9a5c-46ed7267d984"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating Feynman rules for \"\>", 
   "\[InvisibleSpace]", "\<\"L1\"\>"}],
  SequenceForm["Calculating Feynman rules for ", "L1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.915642182754023*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"9b75247e-4314-4b9c-a079-5bd085637a38"],

Cell[BoxData["\<\"Redefining classes in such a way that each particle is in a \
separate FeynArts class.\"\>"], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.915642182754799*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"8f1a12c9-5262-4f2f-9cf1-e806afc5411c"],

Cell[BoxData["\<\"See NewFeynArtsClasses[] for more information on the new \
classes\"\>"], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.9156421827554293`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"e3e0cb9f-8637-4114-ade4-21d9e6f0251d"],

Cell[BoxData["\<\"Restarting Feynman rule calculation, setting FlavorExpand \
-> True.\"\>"], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.9156421827559834`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"53f9168b-c315-4f00-a198-6af1bc62623e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating Feynman rules for \"\>", 
   "\[InvisibleSpace]", "\<\"L1\"\>"}],
  SequenceForm["Calculating Feynman rules for ", "L1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.915642182756537*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"f54ab376-94c2-44c6-91cd-8d2d807f94e7"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rules calculation for L1.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.915642197139433*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"ab79dc8b-d087-4afd-99fb-3a0c8f323b8c"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.915642197141691*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"c02edd39-daa4-4437-afc5-7c1567db73b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 12, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.9156421971432323`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"ba3edf86-3dbe-4f40-968e-cf31bb48fc09"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.91564226737033*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"820a8c6f-9c98-4824-95f0-711c58eecf8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "965", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{195., {3., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "965", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  965, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 965, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.915642268643848*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"f733662c-9fc6-43b8-8757-63c0334cfce6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"914", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[914, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.9156423246687937`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"2f71070c-112e-4871-9dbc-ec23807c6165"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Writing FeynArts model file into directory \"\>", 
   "\[InvisibleSpace]", "\<\"SM_Loop_VPolar_FA\"\>"}],
  SequenceForm[
  "Writing FeynArts model file into directory ", "SM_Loop_VPolar_FA"],
  Editable->False]], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.9156423460778217`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"7879c64d-b027-46de-a3be-77a3900cf496"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Writing FeynArts generic file on \"\>", 
   "\[InvisibleSpace]", "\<\"SM_Loop_VPolar_FA.gen\"\>", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Writing FeynArts generic file on ", "SM_Loop_VPolar_FA.gen", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.912896861934539*^9, 3.913049522092771*^9, 
  3.913076865250711*^9, 3.913077555623789*^9, 3.913114567177339*^9, 
  3.913116952704258*^9, 3.913155248838007*^9, 3.915562767758401*^9, 
  3.9156111951113157`*^9, 3.915620698068378*^9, 3.915635140786703*^9, 
  3.9156376939278708`*^9, 3.9156423461429768`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"4a2e0dda-88c3-4896-95db-93dd22884907"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Write Counter Terms to BSM.nlo", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.59620768137986*^9, 3.596207684212212*^9}, {3.662199461128889*^9, 
   3.662199467953211*^9}, {3.662216541485611*^9, 
   3.662216544705964*^9}},ExpressionUUID->"637e3231-e751-489a-ad59-\
470d98c11b8b"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"quit", " ", "kernel", " ", "before", " ", "continuing"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.664866502336069*^9, 
  3.664866536918194*^9}},ExpressionUUID->"558b9e27-1057-416f-a429-\
231889bb6a86"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"3640fc82-001c-4a97-8551-70d99a9b683d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearSystemCache", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.915649171552142*^9, 3.915649172574946*^9}, 
   3.91564925064156*^9},
 CellLabel->"In[3]:=",ExpressionUUID->"8cd0fa8f-7c3a-4d14-8360-24f7398e3040"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<~/PATH_TO_FA/FeynArts/\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynArts`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<~/PATH_TO_FR/FeynRules\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "NLOCT`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$CurrentPath", "=", 
   RowBox[{"NotebookDirectory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$CurrentPath", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.6605244352671556`*^9, 3.660524496529204*^9}, {
   3.660524555733032*^9, 3.660524556119355*^9}, 3.660528429455056*^9, {
   3.6605286020387897`*^9, 3.660528602100609*^9}, {3.660530319063929*^9, 
   3.660530319160571*^9}, {3.660530366154963*^9, 3.66053037265125*^9}, {
   3.660567620251087*^9, 3.6605676243565598`*^9}, {3.660568912072307*^9, 
   3.660568912133321*^9}, {3.66056999189439*^9, 3.660569993076742*^9}, {
   3.660570552697504*^9, 3.660570554442918*^9}, {3.6605786705389338`*^9, 
   3.660578696714662*^9}, {3.660579471210005*^9, 3.660579471258161*^9}, {
   3.660579558812049*^9, 3.6605795588460417`*^9}, {3.6605809812710743`*^9, 
   3.660580981737924*^9}, {3.662198567340746*^9, 3.662198568029338*^9}, {
   3.664866430517086*^9, 3.664866431258605*^9}, {3.664866469872073*^9, 
   3.664866472738167*^9}, {3.730294872498015*^9, 3.730294872583467*^9}, {
   3.8616849017841673`*^9, 3.8616849546276712`*^9}, 3.8616851893112297`*^9, {
   3.912887236597804*^9, 3.9128872375559483`*^9}, {3.9157813348246317`*^9, 
   3.9157813408718576`*^9}},ExpressionUUID->"cb2da490-5600-44da-b7e4-\
f7f288533aed"],

Cell[CellGroupData[{

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.7302958286839*^9, 3.7303048523578568`*^9, 3.861684961711014*^9, 
   3.861685205694721*^9, {3.861685722885729*^9, 3.861685746318432*^9}, 
   3.861686024867342*^9, 3.861701403198098*^9, 3.8618945358347683`*^9, 
   3.912897312692958*^9, 3.913077972152131*^9, 3.913117655170566*^9, 
   3.913155479462757*^9, 3.915563452632976*^9, 3.9155791432897367`*^9, 
   3.9156112772983313`*^9, 3.9156224983904133`*^9, 3.915635431084176*^9, 
   3.915637851096553*^9, 3.915642371963913*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"e62cc9c4-ad75-44ca-a619-52d7b35ad15b"],

Cell[BoxData["\<\"FeynArts 3.11 (3 Aug 2020)\"\>"], "Print",
 CellChangeTimes->{
  3.7302958286839*^9, 3.7303048523578568`*^9, 3.861684961711014*^9, 
   3.861685205694721*^9, {3.861685722885729*^9, 3.861685746318432*^9}, 
   3.861686024867342*^9, 3.861701403198098*^9, 3.8618945358347683`*^9, 
   3.912897312692958*^9, 3.913077972152131*^9, 3.913117655170566*^9, 
   3.913155479462757*^9, 3.915563452632976*^9, 3.9155791432897367`*^9, 
   3.9156112772983313`*^9, 3.9156224983904133`*^9, 3.915635431084176*^9, 
   3.915637851096553*^9, 3.9156423719661427`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"8da2cdc6-9c7e-4bb9-9a82-0eda13c9b053"],

Cell[BoxData["\<\"by Hagen Eck, Sepp Kueblbeck, and Thomas Hahn\"\>"], "Print",
 CellChangeTimes->{
  3.7302958286839*^9, 3.7303048523578568`*^9, 3.861684961711014*^9, 
   3.861685205694721*^9, {3.861685722885729*^9, 3.861685746318432*^9}, 
   3.861686024867342*^9, 3.861701403198098*^9, 3.8618945358347683`*^9, 
   3.912897312692958*^9, 3.913077972152131*^9, 3.913117655170566*^9, 
   3.913155479462757*^9, 3.915563452632976*^9, 3.9155791432897367`*^9, 
   3.9156112772983313`*^9, 3.9156224983904133`*^9, 3.915635431084176*^9, 
   3.915637851096553*^9, 3.9156423719673023`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"6206f0d6-8896-42d9-ad05-b526dd6abcfc"],

Cell[BoxData["\<\" - NLOCT - \"\>"], "Print",
 CellChangeTimes->{
  3.7302958286839*^9, 3.7303048523578568`*^9, 3.861684961711014*^9, 
   3.861685205694721*^9, {3.861685722885729*^9, 3.861685746318432*^9}, 
   3.861686024867342*^9, 3.861701403198098*^9, 3.8618945358347683`*^9, 
   3.912897312692958*^9, 3.913077972152131*^9, 3.913117655170566*^9, 
   3.913155479462757*^9, 3.915563452632976*^9, 3.9155791432897367`*^9, 
   3.9156112772983313`*^9, 3.9156224983904133`*^9, 3.915635431084176*^9, 
   3.915637851096553*^9, 3.915642371981483*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"73af02ec-1a46-476e-9f8a-c73353c013d6"],

Cell[BoxData["\<\"Version: 1.02\"\>"], "Print",
 CellChangeTimes->{
  3.7302958286839*^9, 3.7303048523578568`*^9, 3.861684961711014*^9, 
   3.861685205694721*^9, {3.861685722885729*^9, 3.861685746318432*^9}, 
   3.861686024867342*^9, 3.861701403198098*^9, 3.8618945358347683`*^9, 
   3.912897312692958*^9, 3.913077972152131*^9, 3.913117655170566*^9, 
   3.913155479462757*^9, 3.915563452632976*^9, 3.9155791432897367`*^9, 
   3.9156112772983313`*^9, 3.9156224983904133`*^9, 3.915635431084176*^9, 
   3.915637851096553*^9, 3.915642371983041*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"0564d4bf-70b7-4484-b834-6abae6324db2"],

Cell[BoxData["\<\"Authors: C. Degrande\"\>"], "Print",
 CellChangeTimes->{
  3.7302958286839*^9, 3.7303048523578568`*^9, 3.861684961711014*^9, 
   3.861685205694721*^9, {3.861685722885729*^9, 3.861685746318432*^9}, 
   3.861686024867342*^9, 3.861701403198098*^9, 3.8618945358347683`*^9, 
   3.912897312692958*^9, 3.913077972152131*^9, 3.913117655170566*^9, 
   3.913155479462757*^9, 3.915563452632976*^9, 3.9155791432897367`*^9, 
   3.9156112772983313`*^9, 3.9156224983904133`*^9, 3.915635431084176*^9, 
   3.915637851096553*^9, 3.915642371983514*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"3f0f891c-6191-4ec0-8ca2-5c87ee16d5b1"],

Cell[BoxData["\<\"Please cite C. Degrande, Comput.Phys.Commun. 197 (2015) \
239-262\"\>"], "Print",
 CellChangeTimes->{
  3.7302958286839*^9, 3.7303048523578568`*^9, 3.861684961711014*^9, 
   3.861685205694721*^9, {3.861685722885729*^9, 3.861685746318432*^9}, 
   3.861686024867342*^9, 3.861701403198098*^9, 3.8618945358347683`*^9, 
   3.912897312692958*^9, 3.913077972152131*^9, 3.913117655170566*^9, 
   3.913155479462757*^9, 3.915563452632976*^9, 3.9155791432897367`*^9, 
   3.9156112772983313`*^9, 3.9156224983904133`*^9, 3.915635431084176*^9, 
   3.915637851096553*^9, 3.915642371983943*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"019fdb33-bdfc-4379-8523-b7829c46ae07"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Note", ":", " ", 
    RowBox[{"Grab", " ", "some", " ", "coffee"}]}], ";", " ", 
   RowBox[{"this", " ", "will", " ", "take", " ", "a", " ", "few", " ", 
    RowBox[{"minutes", ".", " ", "Output"}], " ", "is", " ", "located", " ", 
    "in", " ", "FeynRules", " ", 
    RowBox[{"directory", "."}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.660583519626089*^9, 
  3.660583556727778*^9}},ExpressionUUID->"ee8e0629-2939-4697-a0c4-\
dba81be5b6fc"],

Cell[BoxData[
 RowBox[{"WriteCT", "[", 
  RowBox[{
  "\"\<SM_Loop_VPolar_FA/SM_Loop_VPolar_FA\>\"", ",", 
   "\"\<SM_Loop_VPolar_FA/SM_Loop_VPolar_FA\>\"", ",", 
   RowBox[{"Output", "\[Rule]", "\"\<SM_Loop_VPolar_FA\>\""}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ZeroMom", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"aS", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"F", "[", "7", "]"}], ",", 
         RowBox[{"V", "[", "4", "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"F", "[", "7", "]"}]}]}], "}"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"ComplexMass", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
   RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
   RowBox[{"Exclude4ScalarsCT", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.660577675799324*^9, 3.6605777030824823`*^9}, {
   3.660580587703251*^9, 3.660580590446691*^9}, {3.660580749662204*^9, 
   3.6605807699669333`*^9}, {3.660580838061507*^9, 3.660580868074533*^9}, {
   3.660581534014558*^9, 3.660581534403365*^9}, {3.6605816019013977`*^9, 
   3.660581602442067*^9}, {3.660582264939988*^9, 3.660582265472268*^9}, {
   3.6605825450914*^9, 3.660582545457938*^9}, {3.660582582287341*^9, 
   3.66058260852942*^9}, 3.660583287010807*^9, {3.661385930903625*^9, 
   3.661385938127997*^9}, {3.662216217715084*^9, 3.6622162416021957`*^9}, {
   3.6622169226201477`*^9, 3.6622169231786327`*^9}, 3.730295853197522*^9, {
   3.861685084045143*^9, 3.8616851066133547`*^9}, {3.861685142783972*^9, 
   3.861685154883861*^9}, {3.861685596217422*^9, 3.861685624525661*^9}, {
   3.861685761077841*^9, 3.861685761643894*^9}, {3.8616858376701307`*^9, 
   3.861685861335697*^9}, {3.861685903759907*^9, 3.861685921817471*^9}, {
   3.861701417840008*^9, 3.861701429896585*^9}, {3.91288670319106*^9, 
   3.912886723973674*^9}, {3.912886768442192*^9, 3.912886776652598*^9}, {
   3.912887012459882*^9, 3.912887026823209*^9}, {3.915781349012597*^9, 
   3.915781349821772*^9}},ExpressionUUID->"b8c64182-c4af-4e41-81a4-\
fbb5588d16ce"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load output.nlo and Generate UFO at NLO", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, {
  3.572348211890565*^9, 3.572348234275403*^9}, {3.596207324453108*^9, 
  3.596207326711195*^9}, {3.655036212669145*^9, 3.6550362220422897`*^9}, {
  3.655036282693001*^9, 3.655036287060457*^9}, {3.655037866940884*^9, 
  3.6550378926486187`*^9}, {3.660583469669636*^9, 3.6605834886500196`*^9}, {
  3.91288706703934*^9, 3.912887070269107*^9}, {3.915780327054948*^9, 
  3.915780327565382*^9}},ExpressionUUID->"493a4b49-0255-47ae-87b0-\
254220da35ea"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"quit", " ", "kernel", " ", "before", " ", "continuing"}], " ", 
  "*)"}]], "Input",ExpressionUUID->"6c2b66dd-ba7d-4d84-96e6-433ecd080754"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.660583502811754*^9, 3.6605835046945877`*^9}, 
   3.66212390294204*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"8506311a-f288-4488-903d-47a5940847e6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$CurrentPath", "=", 
   RowBox[{"NotebookDirectory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{"SetDirectory", "[", "\"\<~/PATH_TO_FR/FeynRules\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$CurrentPath", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.6648666749712143`*^9, 3.664866676189664*^9}, 
   3.8616861045287247`*^9, 
   3.9157813594855556`*^9},ExpressionUUID->"95f917ed-a9c9-4c6c-b687-\
25a83f1532e1"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{3.912922414485695*^9, 3.915612481603961*^9, 
  3.9156168520772533`*^9, 3.915636908936844*^9, 3.9156397070734453`*^9, 
  3.915780330549439*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"e36543be-5823-428b-b41c-6eedeed58d2f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.36\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"28 November 2019\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.36", " (" "28 November 2019", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.912922414485695*^9, 3.915612481603961*^9, 
  3.9156168520772533`*^9, 3.915636908936844*^9, 3.9156397070734453`*^9, 
  3.9157803305508327`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"dbb16abb-6b43-4a6a-b9a2-b648908166b9"],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{3.912922414485695*^9, 3.915612481603961*^9, 
  3.9156168520772533`*^9, 3.915636908936844*^9, 3.9156397070734453`*^9, 
  3.9157803305519657`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"5f213e0e-4867-4c37-8ae7-8286e78c2e7b"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.912922414485695*^9, 3.915612481603961*^9, 
  3.9156168520772533`*^9, 3.915636908936844*^9, 3.9156397070734453`*^9, 
  3.91578033055254*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"46bf34cf-7f2f-4510-972d-c7168e15889d"],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{3.912922414485695*^9, 3.915612481603961*^9, 
  3.9156168520772533`*^9, 3.915636908936844*^9, 3.9156397070734453`*^9, 
  3.91578033055295*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"33e8c91c-ca7e-40d7-9a32-4ef06906a279"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{3.912922414485695*^9, 3.915612481603961*^9, 
  3.9156168520772533`*^9, 3.915636908936844*^9, 3.9156397070734453`*^9, 
  3.91578033055337*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"38a78a0f-77ad-41d1-8208-33f8ee4a51ea"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{3.912922414485695*^9, 3.915612481603961*^9, 
  3.9156168520772533`*^9, 3.915636908936844*^9, 3.9156397070734453`*^9, 
  3.915780330553811*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"ee9f3c13-9b33-4056-a800-fee9f6d9fe6d"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.912922414485695*^9, 3.915612481603961*^9, 
  3.9156168520772533`*^9, 3.915636908936844*^9, 3.9156397070734453`*^9, 
  3.915780330554268*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"3d4ff15f-c4d9-4ec9-894d-a474377e4d1f"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{3.912922414485695*^9, 3.915612481603961*^9, 
  3.9156168520772533`*^9, 3.915636908936844*^9, 3.9156397070734453`*^9, 
  3.915780330554702*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"8b5487bb-01c8-4a5d-84ea-38da227e3452"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.912922414485695*^9, 3.915612481603961*^9, 
  3.9156168520772533`*^9, 3.915636908936844*^9, 3.9156397070734453`*^9, 
  3.915780330555126*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"87ece0a1-34ff-433c-ba90-24fcd76e78b0"],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{3.912922414485695*^9, 3.915612481603961*^9, 
  3.9156168520772533`*^9, 3.915636908936844*^9, 3.9156397070734453`*^9, 
  3.9157803305555363`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"95527c63-28e0-4fb9-97ff-52e8dd6e84ed"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Choose", " ", "one", " ", "of", " ", "the", " ", "three", " ", 
     RowBox[{"files", ":", " ", "vpolar"}]}], ",", " ", "wpolar", ",", " ", 
    "zpolar"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"LoadModel", "[", "\"\<sm_loop_vpolar.fr\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"LoadModel", "[", "\"\<sm_loop_wpolar.fr\>\"", "]"}], ";"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"LoadModel", "[", "\"\<sm_loop_zpolar.fr\>\"", "]"}], ";"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LoadRestriction", "[", 
     RowBox[{"\"\<diagonalCKM.rst\>\"", ",", "\"\<massless.rst\>\""}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FeynmanGauge", "=", "True"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.662827026079749*^9, 3.662827026713024*^9}, {
  3.861686122926333*^9, 3.861686125319552*^9}, {3.9128867873862343`*^9, 
  3.9128867874775553`*^9}, {3.915612488541889*^9, 3.915612489748021*^9}, {
  3.9156369139507437`*^9, 3.9156369443099823`*^9}, {3.915639710664559*^9, 
  3.915639714319955*^9}, {3.91578031154674*^9, 3.915780318964014*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"39c2e736-287a-43b4-afd0-e71ce7e12993"],

Cell[CellGroupData[{

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.9129224199391947`*^9, 3.915612491627448*^9, 
  3.915616855869882*^9, 3.9156369505473013`*^9, 3.915639716735722*^9, 
  3.915780339805962*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"585f21a4-8128-44bf-9e59-abfc8501ad53"],

Cell[BoxData["\<\"N. Christensen\"\>"], "Print",
 CellChangeTimes->{3.9129224199391947`*^9, 3.915612491627448*^9, 
  3.915616855869882*^9, 3.9156369505473013`*^9, 3.915639716735722*^9, 
  3.915780339807617*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"e674e443-7214-4665-a75b-02a3186b5607"],

Cell[BoxData["\<\"C. Duhr\"\>"], "Print",
 CellChangeTimes->{3.9129224199391947`*^9, 3.915612491627448*^9, 
  3.915616855869882*^9, 3.9156369505473013`*^9, 3.915639716735722*^9, 
  3.915780339808669*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"664b3672-05f4-4e42-bdba-48bcf0440be7"],

Cell[BoxData["\<\"B. Fuks\"\>"], "Print",
 CellChangeTimes->{3.9129224199391947`*^9, 3.915612491627448*^9, 
  3.915616855869882*^9, 3.9156369505473013`*^9, 3.915639716735722*^9, 
  3.915780339809545*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"f74903a2-db9c-434e-b4c5-922da3dcc226"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.4.7\"\>"}],
  SequenceForm["Model Version: ", "1.4.7"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9129224199391947`*^9, 3.915612491627448*^9, 
  3.915616855869882*^9, 3.9156369505473013`*^9, 3.915639716735722*^9, 
  3.915780339810442*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"fe48fa8d-f572-4b6a-bde7-ce85b98d81dc"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be/view/Main/StandardModel\"\>\
"], "Print",
 CellChangeTimes->{3.9129224199391947`*^9, 3.915612491627448*^9, 
  3.915616855869882*^9, 3.9156369505473013`*^9, 3.915639716735722*^9, 
  3.91578033981117*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"7601425b-f172-4ae9-bbe1-07c81ab2be65"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.9129224199391947`*^9, 3.915612491627448*^9, 
  3.915616855869882*^9, 3.9156369505473013`*^9, 3.915639716735722*^9, 
  3.915780339811607*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"4fe3d21a-0e7a-47ad-8509-601afd595984"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.9129224199391947`*^9, 3.915612491627448*^9, 
  3.915616855869882*^9, 3.9156369505473013`*^9, 3.915639716735722*^9, 
  3.915780339812025*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"36439886-e89f-4a0f-9dc2-4281cc88d89f"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.9129224199391947`*^9, 3.915612491627448*^9, 
  3.915616855869882*^9, 3.9156369505473013`*^9, 3.915639716735722*^9, 
  3.915780339812495*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"17973fe0-d374-4c00-80b4-4694e7276ecf"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.9129224199391947`*^9, 3.915612491627448*^9, 
  3.915616855869882*^9, 3.9156369505473013`*^9, 3.915639716735722*^9, 
  3.91578033986736*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"f54b4e4a-37d8-4f0f-8642-b73c622b5138"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.9129224199391947`*^9, 3.915612491627448*^9, 
  3.915616855869882*^9, 3.9156369505473013`*^9, 3.915639716735722*^9, 
  3.915780339868869*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"2acc75db-c3c6-42dd-a25f-e620e78bea99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"Standard Model\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "Standard Model", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9129224199391947`*^9, 3.915612491627448*^9, 
  3.915616855869882*^9, 3.9156369505473013`*^9, 3.915639716735722*^9, 
  3.915780339897461*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"a79e96e0-8118-43e3-aa2f-32c81efd5e0c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"diagonalCKM.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{16., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "6"}],
  SequenceForm["Loading restrictions from ", "diagonalCKM.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 6],
  Editable->False]], "Print",
 CellChangeTimes->{3.9129224199391947`*^9, 3.915612491627448*^9, 
  3.915616855869882*^9, 3.9156369505473013`*^9, 3.915639716735722*^9, 
  3.915780340286618*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"e79e85aa-15d8-4438-b2b9-92b6832813eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"massless.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{16., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "24"}],
  SequenceForm["Loading restrictions from ", "massless.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 24],
  Editable->False]], "Print",
 CellChangeTimes->{3.9129224199391947`*^9, 3.915612491627448*^9, 
  3.915616855869882*^9, 3.9156369505473013`*^9, 3.915639716735722*^9, 
  3.915780340390904*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"9ef0db59-5ae6-4106-bbf7-d05b4bab7d59"],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{3.9129224199391947`*^9, 3.915612491627448*^9, 
  3.915616855869882*^9, 3.9156369505473013`*^9, 3.915639716735722*^9, 
  3.915780340467186*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"2a55decb-75a9-4581-8133-886f8866bd66"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Get", "[", "\"\<./vpolar_lagrangian.dat\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Get", "[", "\"\<./SM_Loop_VPolar_FA.nlo\>\"", "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.91561680774023*^9, 3.9156168271911297`*^9}, {
  3.915616866697307*^9, 3.915616871542939*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"f55940db-4e54-4f2a-9fd0-4dc2a8718cd0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"WriteUFO", "[", 
    RowBox[{"pQCDLag", ",", 
     RowBox[{"UVCounterterms", "\[Rule]", "UV$vertlist"}], ",", 
     RowBox[{"R2Vertices", "\[Rule]", "R2$vertlist"}], ",", " ", 
     RowBox[{"Output", "\[Rule]", "\"\<SM_Loop_VPolar\>\""}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"WriteUFO", "[", 
     RowBox[{"pQCDLag", ",", 
      RowBox[{"UVCounterterms", "\[Rule]", "UV$vertlist"}], ",", 
      RowBox[{"R2Vertices", "\[Rule]", "R2$vertlist"}], ",", " ", 
      RowBox[{"Output", "\[Rule]", "\"\<SM_Loop_WPolar\>\""}]}], "]"}], ";"}],
    "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"WriteUFO", "[", 
     RowBox[{"pQCDLag", ",", 
      RowBox[{"UVCounterterms", "\[Rule]", "UV$vertlist"}], ",", 
      RowBox[{"R2Vertices", "\[Rule]", "R2$vertlist"}], ",", " ", 
      RowBox[{"Output", "\[Rule]", "\"\<SM_Loop_ZPolar\>\""}]}], "]"}], ";"}],
    "*)"}]}]}], "Input",
 CellChangeTimes->{{3.861686244381927*^9, 3.861686244911277*^9}, {
   3.861688148714806*^9, 3.861688150197706*^9}, {3.912886676141691*^9, 
   3.912886678153192*^9}, {3.912887046708946*^9, 3.912887047019154*^9}, 
   3.91292245415985*^9, {3.915616718889497*^9, 3.915616789175929*^9}, {
   3.915616865158184*^9, 3.9156168879268217`*^9}, {3.91563695935815*^9, 
   3.915636986573348*^9}, {3.915637329236565*^9, 3.9156373340580072`*^9}, {
   3.9156397230681887`*^9, 3.915639729367779*^9}, {3.915780356261959*^9, 
   3.915780362681622*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"da29c21e-5dc7-4f3b-a841-0fec4b834793"],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.9157803740881233`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"8e37f643-11b0-4ce7-bcb6-c433185f7974"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.91578037507194*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"92d0f0c3-6a84-44be-aa84-cf6663b1943d"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.915780375073683*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"72e51ba8-bd1f-48ac-809f-a0f9cc025f4c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 12, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.915780375074884*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"4b8aa456-b2bc-4269-803b-1255eaf90443"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.915780398802265*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"33d75e7a-3afe-4b25-ab15-5cf958e72225"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "905", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{23., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "905", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  905, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 905, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.9157803992072887`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"fbe494a4-6a0c-46fc-adff-5d9b13b1e947"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"854", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[854, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.915780417081214*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"4be3ff7d-7ebf-4b25-8dcd-ed8945b2ddea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "12", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{23., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "901"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 12, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 901],
  Editable->False]], "Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.915780427820963*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"ef1a334d-209b-4932-8265-5eba5aa804bd"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.91578044201628*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"d762e2cf-e8eb-4f79-819b-923aa0e1dc1c"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.915780442395994*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"8b9f5361-35aa-4f71-bbe4-4e0536b292ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{23., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "213"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 213],
  Editable->False]], "Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.915780442419632*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"3fc508e9-30d7-41df-849f-f73d6f3f9a1d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "15.805031`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 15.805031, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.915780477349168*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"688a217c-2fd2-417a-abf3-9dac433ca702"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{23., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "251"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 251],
  Editable->False]], "Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.915780477383421*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"8075fb55-278d-4a7d-93eb-ecbf357e7dbd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "3.436132`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 3.436132, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.9157804812541037`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"3db6298b-cf04-47b2-89fb-5e4bc29d68e4"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.915780481255805*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"c7cacef6-5283-4a5e-93f5-892b42eb242a"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.9157804821057243`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"dfe42199-5ed2-4034-8e73-a9eef240e2d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "12", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 12, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.9157804826844873`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"3760151a-2ad8-4891-8632-a3a7d83df1f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{23., {0., 9.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "901", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 901, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.915780488522963*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"3ad8a001-94d5-4767-931f-2ce6eddd1045"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.915780489458684*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"39261eff-fc16-4681-9e64-6fcf02be395d"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{3.912922448968795*^9, 3.915616783956234*^9, 
  3.915616891433731*^9, 3.915636987188876*^9, 3.9156397366440077`*^9, 
  3.915780489977851*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"e19f72ba-f07e-4880-b363-23672dcdc90f"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1387, 852},
WindowMargins->{{55, Automatic}, {0, Automatic}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
TaggingRules->{"TryRealOnly" -> False},
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 388, 8, 31, "Input",ExpressionUUID->"cee4e897-cbc1-4bf1-a304-44bbfcd5aed3"],
Cell[936, 30, 1108, 26, 78, "Input",ExpressionUUID->"4149d1d2-f5f9-4692-ab77-ed3366c4e0f7"],
Cell[2047, 58, 196, 3, 31, "Input",ExpressionUUID->"7eec092d-a909-4a5c-86c4-663c165c8312"],
Cell[CellGroupData[{
Cell[2268, 65, 251, 4, 99, "Title",ExpressionUUID->"36a8985f-3b71-4bb1-acae-6fbe5493c081"],
Cell[CellGroupData[{
Cell[2544, 73, 1563, 27, 101, "Input",ExpressionUUID->"2b566197-5488-4f54-9e47-2d15cdf0dd38"],
Cell[CellGroupData[{
Cell[4132, 104, 929, 14, 25, "Print",ExpressionUUID->"4d4ac3b9-593f-45a0-a909-b97331eaeb75"],
Cell[5064, 120, 1210, 21, 25, "Print",ExpressionUUID->"0ff452ec-329a-48ef-8af8-b484ea547c1e"],
Cell[6277, 143, 983, 15, 25, "Print",ExpressionUUID->"ba12d1b7-28b7-44bb-87b2-7440d50c55fb"],
Cell[7263, 160, 915, 14, 25, "Print",ExpressionUUID->"2b0769c3-8078-4ede-9469-a309648e24aa"],
Cell[8181, 176, 926, 14, 25, "Print",ExpressionUUID->"2081de6a-6cf4-4662-8b6a-45232c995360"],
Cell[9110, 192, 978, 15, 25, "Print",ExpressionUUID->"8c153932-50f8-4c3a-8131-89c877233f07"],
Cell[10091, 209, 980, 15, 25, "Print",ExpressionUUID->"dca728df-dd9c-4e50-920e-d9a5203d6801"],
Cell[11074, 226, 917, 14, 25, "Print",ExpressionUUID->"3ff25800-db44-4e6e-beba-967a6cccae16"],
Cell[11994, 242, 945, 14, 25, "Print",ExpressionUUID->"abfe83ea-1c4f-428e-8a1a-c42ac085f7ae"],
Cell[12942, 258, 917, 14, 25, "Print",ExpressionUUID->"ac3d8c75-6565-45d0-9f70-19c249fc1b49"],
Cell[13862, 274, 982, 15, 25, "Print",ExpressionUUID->"5e7ac8e2-1d57-4b11-bc6e-018b4d85d72b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14893, 295, 1535, 33, 147, "Input",ExpressionUUID->"0e39e6c0-37a4-4139-8e09-3d0b04f3b8fd"],
Cell[CellGroupData[{
Cell[16453, 332, 289, 5, 25, "Print",ExpressionUUID->"1f6006ec-ed2c-4d8b-acbb-3c632a6c3651"],
Cell[16745, 339, 263, 5, 25, "Print",ExpressionUUID->"c15f1a0c-a03b-4228-97f7-d14eb638caae"],
Cell[17011, 346, 258, 5, 25, "Print",ExpressionUUID->"f6105458-88dc-48a1-948f-30551032584a"],
Cell[17272, 353, 256, 5, 25, "Print",ExpressionUUID->"76e0c67d-79dd-4e80-8791-0a3032a71bb4"],
Cell[17531, 360, 401, 9, 25, "Print",ExpressionUUID->"4a731c7f-e759-4b43-a419-b0885b31a42e"],
Cell[17935, 371, 306, 6, 25, "Print",ExpressionUUID->"4b41b075-2e83-4e4c-9624-c7caa1ad0e20"],
Cell[18244, 379, 297, 6, 25, "Print",ExpressionUUID->"1a64c1cb-1e77-4b76-ad7d-c90a34191f97"],
Cell[18544, 387, 251, 5, 25, "Print",ExpressionUUID->"d141bc42-2afa-4e6d-8ad5-a298447019bc"],
Cell[18798, 394, 281, 5, 25, "Print",ExpressionUUID->"213b4c60-4306-4852-961f-4d18641b7b38"],
Cell[19082, 401, 284, 5, 25, "Print",ExpressionUUID->"78303c24-6314-49d4-9689-033e06bb71c7"],
Cell[19369, 408, 280, 5, 25, "Print",ExpressionUUID->"f70123b7-4c96-48e4-a329-f856afde08f4"],
Cell[19652, 415, 461, 10, 48, "Print",ExpressionUUID->"c42c919e-03b4-4507-a0a9-59d3d3533b06"],
Cell[20116, 427, 742, 15, 25, "Print",ExpressionUUID->"139ba302-6473-42a4-8c9f-a52d2c87c9f5"],
Cell[20861, 444, 740, 15, 25, "Print",ExpressionUUID->"4e31d5d7-ba3c-4ede-8299-7a52ab67a7a0"],
Cell[21604, 461, 269, 5, 25, "Print",ExpressionUUID->"d8f04cd7-e4d2-4865-b393-7172c9d96cf2"]
}, Open  ]]
}, Open  ]],
Cell[21900, 470, 2647, 41, 55, "Input",ExpressionUUID->"97808359-025b-4359-9ecf-779e8e5ca2d2"],
Cell[24550, 513, 611, 15, 55, "Input",ExpressionUUID->"e0d984d8-7455-49ec-998c-c35045fd9a86"],
Cell[CellGroupData[{
Cell[25186, 532, 453, 7, 68, "Section",ExpressionUUID->"430f6c12-ab98-447b-8fa4-8a13c875b6c3"],
Cell[CellGroupData[{
Cell[25664, 543, 343, 6, 31, "Input",ExpressionUUID->"01776d56-05d4-475b-b025-2f0ebd0c8fc8"],
Cell[CellGroupData[{
Cell[26032, 553, 530, 14, 25, "Print",ExpressionUUID->"ad7147cd-90d5-49f0-b387-0343e72459ac"],
Cell[26565, 569, 285, 6, 25, "Print",ExpressionUUID->"b4a6bc98-715d-4abc-8d8c-53ddff957489"],
Cell[26853, 577, 318, 7, 25, "Print",ExpressionUUID->"110bb0d8-bad8-493b-b401-35b1b5f755c3"],
Cell[27174, 586, 278, 6, 25, "Print",ExpressionUUID->"dfe9be29-85cc-4300-8625-020e53ba16c5"],
Cell[27455, 594, 398, 10, 25, "Print",ExpressionUUID->"ba028401-557e-41f7-b903-df112c97cd38"]
}, Open  ]],
Cell[27868, 607, 218, 4, 35, "Output",ExpressionUUID->"78e8edf7-e7ef-4da3-a3fe-3149222e6001"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28135, 617, 234, 4, 68, "Section",ExpressionUUID->"963bd5da-1517-491b-8768-3e81fb288ca2"],
Cell[28372, 623, 130, 1, 31, "Input",ExpressionUUID->"ac633701-1714-47ff-b059-96a9d55ac743"],
Cell[CellGroupData[{
Cell[28527, 628, 400, 6, 31, "Input",ExpressionUUID->"92049f5e-2336-49b3-a1cf-102286807753"],
Cell[CellGroupData[{
Cell[28952, 638, 1039, 19, 25, "Print",ExpressionUUID->"83ed3121-7c45-42b6-a73c-536be8e0990c"],
Cell[29994, 659, 815, 13, 25, "Print",ExpressionUUID->"7d0b43f5-72f4-4eaf-887b-907ba02ee1ff"],
Cell[30812, 674, 810, 13, 25, "Print",ExpressionUUID->"e4851d06-682f-456f-819f-0b16bb338d54"],
Cell[31625, 689, 851, 14, 25, "Print",ExpressionUUID->"8c9cd384-69f1-435e-8d0a-8599d0c3160a"]
}, Open  ]],
Cell[32491, 706, 5263, 163, 535, "Output",ExpressionUUID->"59d97bf5-775e-443b-9d3b-2dfb2fc8fe30"]
}, Open  ]],
Cell[37769, 872, 505, 7, 31, "Input",ExpressionUUID->"98abda96-0800-4fdf-a9dc-54c145864a34"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38311, 884, 230, 5, 68, "Section",ExpressionUUID->"47f009e8-0603-4d37-95af-884018211353"],
Cell[CellGroupData[{
Cell[38566, 893, 1518, 33, 101, "Input",ExpressionUUID->"758085c5-adf3-40e0-830a-07fa05d96b6c"],
Cell[CellGroupData[{
Cell[40109, 930, 418, 8, 25, "Print",ExpressionUUID->"efe5d50d-8d4b-4ffc-ba41-3dbd9266a7e7"],
Cell[40530, 940, 640, 15, 25, "Print",ExpressionUUID->"fba6eacc-1ed8-4e6a-99c5-7abf15f0d8c6"],
Cell[41173, 957, 396, 7, 25, "Print",ExpressionUUID->"32776f0f-0a52-473f-9295-16b252e9e487"],
Cell[41572, 966, 582, 12, 25, "Print",ExpressionUUID->"236a5d2a-58fa-49bd-af53-aa5199072083"],
Cell[42157, 980, 429, 8, 25, "Print",ExpressionUUID->"b08ac910-1b6e-48ec-be04-b8aee1d47e1b"],
Cell[42589, 990, 915, 19, 25, "Print",ExpressionUUID->"97e2ad9c-326a-4a90-a340-2abb379768a0"],
Cell[43507, 1011, 513, 11, 25, "Print",ExpressionUUID->"0ec1c870-7aa6-4d59-a410-f3b1fba4c5e5"],
Cell[44023, 1024, 871, 18, 25, "Print",ExpressionUUID->"e5939aa8-5257-4f7f-89f6-753da63df342"],
Cell[44897, 1044, 410, 7, 25, "Print",ExpressionUUID->"52b8f533-f01a-4b0f-a42a-f2220c9ccab4"],
Cell[45310, 1053, 677, 16, 25, "Print",ExpressionUUID->"1f6af9d8-9211-431a-98b8-086ca423bd58"],
Cell[45990, 1071, 635, 15, 25, "Print",ExpressionUUID->"a4570cc1-b87d-401e-909a-c1454e8f58e6"],
Cell[46628, 1088, 611, 12, 25, "Print",ExpressionUUID->"cc54b6aa-15e8-4f66-b4eb-9d0ede4e9975"],
Cell[47242, 1102, 634, 15, 25, "Print",ExpressionUUID->"28981911-1ec6-4415-94f4-27a897fb45a3"],
Cell[47879, 1119, 595, 12, 25, "Print",ExpressionUUID->"65f57f24-0a21-40bf-bb39-f71819e680d8"],
Cell[48477, 1133, 393, 7, 25, "Print",ExpressionUUID->"bf4f2976-7f54-48cb-8aae-21c1abeb019d"],
Cell[48873, 1142, 419, 8, 25, "Print",ExpressionUUID->"81f6af8c-86f3-432a-89ee-4c873af19f70"],
Cell[49295, 1152, 612, 12, 25, "Print",ExpressionUUID->"eef6cb96-6e36-45eb-8eb2-4cde4d4cc31a"],
Cell[49910, 1166, 769, 15, 25, "Print",ExpressionUUID->"d98fb764-508a-454e-8a61-d28a711c67aa"],
Cell[50682, 1183, 389, 7, 25, "Print",ExpressionUUID->"6804a583-41f6-4740-a9d0-79074bcd0361"],
Cell[51074, 1192, 374, 7, 25, "Print",ExpressionUUID->"b8afd9b3-5b0c-43af-894a-0c6efe8e6a15"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[51509, 1206, 356, 6, 68, "Section",ExpressionUUID->"f35c5a82-2f44-4096-9399-e82f5b97ff8d"],
Cell[CellGroupData[{
Cell[51890, 1216, 1465, 31, 101, "Input",ExpressionUUID->"7cbd8e0c-bc17-43d7-8e66-37ef6a194ab6"],
Cell[CellGroupData[{
Cell[53380, 1251, 516, 9, 25, "Print",ExpressionUUID->"5b6159b4-f381-41bd-b30a-89cd3d90b7bc"],
Cell[53899, 1262, 516, 9, 25, "Print",ExpressionUUID->"ca97e212-f124-4e1e-b63b-d881d74522cc"],
Cell[54418, 1273, 711, 14, 25, "Print",ExpressionUUID->"31873469-0cd1-4ff1-81c7-de54dcf5f4da"],
Cell[55132, 1289, 483, 8, 25, "Print",ExpressionUUID->"975aa446-77d6-4c81-a788-017063a0bc4b"],
Cell[55618, 1299, 501, 8, 25, "Print",ExpressionUUID->"bea99c55-06e1-42c2-91c2-b03c37c3dcb9"],
Cell[56122, 1309, 487, 8, 25, "Print",ExpressionUUID->"7c40f2eb-0569-4daf-87df-aa3fad5aafb0"],
Cell[56612, 1319, 486, 8, 25, "Print",ExpressionUUID->"43f041ff-f9ba-4642-980d-7bf422e81a23"],
Cell[57101, 1329, 502, 8, 25, "Print",ExpressionUUID->"eba24c3e-b0e5-45b1-a978-5c0c2cbae489"],
Cell[57606, 1339, 494, 8, 25, "Print",ExpressionUUID->"04bbef6d-3e46-4269-8711-1687c1d877c6"],
Cell[58103, 1349, 488, 8, 25, "Print",ExpressionUUID->"e5be37c2-76ad-4180-9629-22ec9844bc6b"],
Cell[58594, 1359, 479, 8, 25, "Print",ExpressionUUID->"90b9b158-7da5-40a8-b60b-5aa6ed901f8a"],
Cell[59076, 1369, 475, 8, 25, "Print",ExpressionUUID->"14e8a0b6-48bc-4d7f-9cda-450def5d7a14"]
}, Open  ]],
Cell[59566, 1380, 488, 7, 35, "Output",ExpressionUUID->"e6f4dcec-627a-4791-a2b8-ea794631e20b"],
Cell[CellGroupData[{
Cell[60079, 1391, 504, 8, 25, "Print",ExpressionUUID->"e3c6e209-77b5-4856-a146-ea232ca4f9ae"],
Cell[60586, 1401, 491, 8, 25, "Print",ExpressionUUID->"c3832de8-abbc-4504-87a4-75e842b3a737"],
Cell[61080, 1411, 495, 8, 25, "Print",ExpressionUUID->"9e7b525e-ce3e-4560-9a5c-46ed7267d984"],
Cell[61578, 1421, 638, 13, 25, "Print",ExpressionUUID->"9b75247e-4314-4b9c-a079-5bd085637a38"],
Cell[62219, 1436, 546, 9, 25, "Print",ExpressionUUID->"8f1a12c9-5262-4f2f-9cf1-e806afc5411c"],
Cell[62768, 1447, 528, 9, 25, "Print",ExpressionUUID->"e3e0cb9f-8637-4114-ade4-21d9e6f0251d"],
Cell[63299, 1458, 530, 9, 25, "Print",ExpressionUUID->"53f9168b-c315-4f00-a198-6af1bc62623e"],
Cell[63832, 1469, 638, 13, 25, "Print",ExpressionUUID->"f54ab376-94c2-44c6-91cd-8d2d807f94e7"],
Cell[64473, 1484, 740, 16, 25, "Print",ExpressionUUID->"ab79dc8b-d087-4afd-99fb-3a0c8f323b8c"],
Cell[65216, 1502, 487, 8, 25, "Print",ExpressionUUID->"c02edd39-daa4-4437-afc5-7c1567db73b0"],
Cell[65706, 1512, 673, 13, 25, "Print",ExpressionUUID->"ba3edf86-3dbe-4f40-968e-cf31bb48fc09"],
Cell[66382, 1527, 519, 9, 25, "Print",ExpressionUUID->"820a8c6f-9c98-4824-95f0-711c58eecf8f"],
Cell[66904, 1538, 1007, 20, 25, "Print",ExpressionUUID->"f733662c-9fc6-43b8-8757-63c0334cfce6"],
Cell[67914, 1560, 606, 12, 25, "Print",ExpressionUUID->"2f71070c-112e-4871-9dbc-ec23807c6165"],
Cell[68523, 1574, 699, 14, 25, "Print",ExpressionUUID->"7879c64d-b027-46de-a3be-77a3900cf496"],
Cell[69225, 1590, 730, 15, 25, "Print",ExpressionUUID->"4a2e0dda-88c3-4896-95db-93dd22884907"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[70016, 1612, 346, 6, 68, "Section",ExpressionUUID->"637e3231-e751-489a-ad59-470d98c11b8b"],
Cell[70365, 1620, 255, 6, 31, "Input",ExpressionUUID->"558b9e27-1057-416f-a429-231889bb6a86"],
Cell[70623, 1628, 148, 3, 31, "Input",ExpressionUUID->"3640fc82-001c-4a97-8551-70d99a9b683d"],
Cell[70774, 1633, 251, 5, 31, "Input",ExpressionUUID->"8cd0fa8f-7c3a-4d14-8360-24f7398e3040"],
Cell[CellGroupData[{
Cell[71050, 1642, 1671, 29, 147, "Input",ExpressionUUID->"cb2da490-5600-44da-b7e4-f7f288533aed"],
Cell[CellGroupData[{
Cell[72746, 1675, 635, 11, 25, "Print",ExpressionUUID->"e62cc9c4-ad75-44ca-a619-52d7b35ad15b"],
Cell[73384, 1688, 663, 11, 25, "Print",ExpressionUUID->"8da2cdc6-9c7e-4bb9-9a82-0eda13c9b053"],
Cell[74050, 1701, 682, 11, 25, "Print",ExpressionUUID->"6206f0d6-8896-42d9-ad05-b526dd6abcfc"],
Cell[74735, 1714, 646, 11, 25, "Print",ExpressionUUID->"73af02ec-1a46-476e-9f8a-c73353c013d6"],
Cell[75384, 1727, 648, 11, 25, "Print",ExpressionUUID->"0564d4bf-70b7-4484-b834-6abae6324db2"],
Cell[76035, 1740, 655, 11, 25, "Print",ExpressionUUID->"3f0f891c-6191-4ec0-8ca2-5c87ee16d5b1"],
Cell[76693, 1753, 700, 12, 25, "Print",ExpressionUUID->"019fdb33-bdfc-4379-8523-b7829c46ae07"]
}, Open  ]]
}, Open  ]],
Cell[77420, 1769, 498, 11, 31, "Input",ExpressionUUID->"ee8e0629-2939-4697-a0c4-dba81be5b6fc"],
Cell[77921, 1782, 2033, 37, 78, "Input",ExpressionUUID->"b8c64182-c4af-4e41-81a4-fbb5588d16ce"]
}, Open  ]],
Cell[CellGroupData[{
Cell[79991, 1824, 572, 8, 68, "Section",ExpressionUUID->"493a4b49-0255-47ae-87b0-254220da35ea"],
Cell[80566, 1834, 184, 3, 31, "Input",ExpressionUUID->"6c2b66dd-ba7d-4d84-96e6-433ecd080754"],
Cell[80753, 1839, 241, 5, 31, "Input",ExpressionUUID->"8506311a-f288-4488-903d-47a5940847e6"],
Cell[CellGroupData[{
Cell[81019, 1848, 604, 14, 101, "Input",ExpressionUUID->"95f917ed-a9c9-4c6c-b687-25a83f1532e1"],
Cell[CellGroupData[{
Cell[81648, 1866, 315, 6, 25, "Print",ExpressionUUID->"e36543be-5823-428b-b41c-6eedeed58d2f"],
Cell[81966, 1874, 598, 13, 25, "Print",ExpressionUUID->"dbb16abb-6b43-4a6a-b9a2-b648908166b9"],
Cell[82567, 1889, 369, 7, 25, "Print",ExpressionUUID->"5f213e0e-4867-4c37-8ae7-8286e78c2e7b"],
Cell[82939, 1898, 300, 6, 25, "Print",ExpressionUUID->"46bf34cf-7f2f-4510-972d-c7168e15889d"],
Cell[83242, 1906, 311, 6, 25, "Print",ExpressionUUID->"33e8c91c-ca7e-40d7-9a32-4ef06906a279"],
Cell[83556, 1914, 363, 7, 25, "Print",ExpressionUUID->"38a78a0f-77ad-41d1-8208-33f8ee4a51ea"],
Cell[83922, 1923, 364, 7, 25, "Print",ExpressionUUID->"ee9f3c13-9b33-4056-a800-fee9f6d9fe6d"],
Cell[84289, 1932, 301, 6, 25, "Print",ExpressionUUID->"3d4ff15f-c4d9-4ec9-894d-a474377e4d1f"],
Cell[84593, 1940, 331, 6, 25, "Print",ExpressionUUID->"8b5487bb-01c8-4a5d-84ea-38da227e3452"],
Cell[84927, 1948, 301, 6, 25, "Print",ExpressionUUID->"87ece0a1-34ff-433c-ba90-24fcd76e78b0"],
Cell[85231, 1956, 370, 7, 25, "Print",ExpressionUUID->"95527c63-28e0-4fb9-97ff-52e8dd6e84ed"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[85650, 1969, 1340, 30, 147, "Input",ExpressionUUID->"39c2e736-287a-43b4-afd0-e71ce7e12993"],
Cell[CellGroupData[{
Cell[87015, 2003, 340, 6, 25, "Print",ExpressionUUID->"585f21a4-8128-44bf-9e59-abfc8501ad53"],
Cell[87358, 2011, 314, 6, 25, "Print",ExpressionUUID->"e674e443-7214-4665-a75b-02a3186b5607"],
Cell[87675, 2019, 307, 6, 25, "Print",ExpressionUUID->"664b3672-05f4-4e42-bdba-48bcf0440be7"],
Cell[87985, 2027, 307, 6, 25, "Print",ExpressionUUID->"f74903a2-db9c-434e-b4c5-922da3dcc226"],
Cell[88295, 2035, 450, 10, 25, "Print",ExpressionUUID->"fe48fa8d-f572-4b6a-bde7-ce85b98d81dc"],
Cell[88748, 2047, 356, 7, 25, "Print",ExpressionUUID->"7601425b-f172-4ae9-bbe1-07c81ab2be65"],
Cell[89107, 2056, 348, 7, 25, "Print",ExpressionUUID->"4fe3d21a-0e7a-47ad-8509-601afd595984"],
Cell[89458, 2065, 300, 6, 25, "Print",ExpressionUUID->"36439886-e89f-4a0f-9dc2-4281cc88d89f"],
Cell[89761, 2073, 330, 6, 25, "Print",ExpressionUUID->"17973fe0-d374-4c00-80b4-4694e7276ecf"],
Cell[90094, 2081, 332, 6, 25, "Print",ExpressionUUID->"f54b4e4a-37d8-4f0f-8642-b73c622b5138"],
Cell[90429, 2089, 331, 6, 25, "Print",ExpressionUUID->"2acc75db-c3c6-42dd-a25f-e620e78bea99"],
Cell[90763, 2097, 512, 11, 48, "Print",ExpressionUUID->"a79e96e0-8118-43e3-aa2f-32c81efd5e0c"],
Cell[91278, 2110, 791, 16, 25, "Print",ExpressionUUID->"e79e85aa-15d8-4438-b2b9-92b6832813eb"],
Cell[92072, 2128, 787, 16, 25, "Print",ExpressionUUID->"9ef0db59-5ae6-4106-bbf7-d05b4bab7d59"],
Cell[92862, 2146, 320, 6, 25, "Print",ExpressionUUID->"2a55decb-75a9-4581-8133-886f8866bd66"]
}, Open  ]]
}, Open  ]],
Cell[93209, 2156, 411, 9, 55, "Input",ExpressionUUID->"f55940db-4e54-4f2a-9fd0-4dc2a8718cd0"],
Cell[CellGroupData[{
Cell[93645, 2169, 1617, 34, 78, "Input",ExpressionUUID->"da29c21e-5dc7-4f3b-a841-0fec4b834793"],
Cell[CellGroupData[{
Cell[95287, 2207, 350, 7, 25, "Print",ExpressionUUID->"8e37f643-11b0-4ce7-bcb6-c433185f7974"],
Cell[95640, 2216, 570, 14, 25, "Print",ExpressionUUID->"92d0f0c3-6a84-44be-aa84-cf6663b1943d"],
Cell[96213, 2232, 326, 6, 25, "Print",ExpressionUUID->"72e51ba8-bd1f-48ac-809f-a0f9cc025f4c"],
Cell[96542, 2240, 510, 11, 25, "Print",ExpressionUUID->"4b8aa456-b2bc-4269-803b-1255eaf90443"],
Cell[97055, 2253, 359, 7, 25, "Print",ExpressionUUID->"33d75e7a-3afe-4b25-ab15-5cf958e72225"],
Cell[97417, 2262, 846, 18, 25, "Print",ExpressionUUID->"fbe494a4-6a0c-46fc-adff-5d9b13b1e947"],
Cell[98266, 2282, 443, 10, 25, "Print",ExpressionUUID->"4be3ff7d-7ebf-4b25-8dcd-ed8945b2ddea"],
Cell[98712, 2294, 799, 17, 25, "Print",ExpressionUUID->"ef1a334d-209b-4932-8265-5eba5aa804bd"],
Cell[99514, 2313, 339, 6, 25, "Print",ExpressionUUID->"d762e2cf-e8eb-4f79-819b-923aa0e1dc1c"],
Cell[99856, 2321, 607, 15, 25, "Print",ExpressionUUID->"8b9f5361-35aa-4f71-bbe4-4e0536b292ec"],
Cell[100466, 2338, 563, 14, 25, "Print",ExpressionUUID->"3fc508e9-30d7-41df-849f-f73d6f3f9a1d"],
Cell[101032, 2354, 541, 11, 25, "Print",ExpressionUUID->"688a217c-2fd2-417a-abf3-9dac433ca702"],
Cell[101576, 2367, 563, 14, 25, "Print",ExpressionUUID->"8075fb55-278d-4a7d-93eb-ecbf357e7dbd"],
Cell[102142, 2383, 527, 11, 25, "Print",ExpressionUUID->"3db6298b-cf04-47b2-89fb-5e4bc29d68e4"],
Cell[102672, 2396, 323, 6, 25, "Print",ExpressionUUID->"c7cacef6-5283-4a5e-93f5-892b42eb242a"],
Cell[102998, 2404, 349, 7, 25, "Print",ExpressionUUID->"dfe42199-5ed2-4034-8e73-a9eef240e2d6"],
Cell[103350, 2413, 542, 11, 25, "Print",ExpressionUUID->"3760151a-2ad8-4891-8632-a3a7d83df1f9"],
Cell[103895, 2426, 697, 14, 25, "Print",ExpressionUUID->"3ad8a001-94d5-4767-931f-2ce6eddd1045"],
Cell[104595, 2442, 319, 6, 25, "Print",ExpressionUUID->"39261eff-fc16-4681-9e64-6fcf02be395d"],
Cell[104917, 2450, 304, 6, 25, "Print",ExpressionUUID->"e19f72ba-f07e-4880-b363-23672dcdc90f"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

