# This file was automatically created by FeynRules $Revision: 573 $
# Mathematica version: 8.0 for Microsoft Windows (32-bit) (February 24, 2011)
# Date: Mon 21 Apr 2014 11:48:15



from object_library import all_parameters, Parameter


from function_library import complexconjugate, re, im, csc, sec, acsc, asec

# This is a default parameter object representing 0.
ZERO = Parameter(name = 'ZERO',
                 nature = 'internal',
                 type = 'real',
                 value = '0.0',
                 texname = '0')

# User-defined parameters.
CKM11 = Parameter(name = 'CKM11',
                  nature = 'external',
                  type = 'complex',
                  value = 0.97428,
                  texname = '\\text{CKM11}',
                  lhablock = 'CKMBlock',
                  lhacode = [ 1, 1 ])

CKM12 = Parameter(name = 'CKM12',
                  nature = 'external',
                  type = 'complex',
                  value = 0.2253,
                  texname = '\\text{CKM12}',
                  lhablock = 'CKMBlock',
                  lhacode = [ 1, 2 ])

CKM13 = Parameter(name = 'CKM13',
                  nature = 'external',
                  type = 'complex',
                  value = 0.00347,
                  texname = '\\text{CKM13}',
                  lhablock = 'CKMBlock',
                  lhacode = [ 1, 3 ])

CKM21 = Parameter(name = 'CKM21',
                  nature = 'external',
                  type = 'complex',
                  value = 0.2252,
                  texname = '\\text{CKM21}',
                  lhablock = 'CKMBlock',
                  lhacode = [ 2, 1 ])

CKM22 = Parameter(name = 'CKM22',
                  nature = 'external',
                  type = 'complex',
                  value = 0.97345,
                  texname = '\\text{CKM22}',
                  lhablock = 'CKMBlock',
                  lhacode = [ 2, 2 ])

CKM23 = Parameter(name = 'CKM23',
                  nature = 'external',
                  type = 'complex',
                  value = 0.041,
                  texname = '\\text{CKM23}',
                  lhablock = 'CKMBlock',
                  lhacode = [ 2, 3 ])

CKM31 = Parameter(name = 'CKM31',
                  nature = 'external',
                  type = 'complex',
                  value = 0.00862,
                  texname = '\\text{CKM31}',
                  lhablock = 'CKMBlock',
                  lhacode = [ 3, 1 ])

CKM32 = Parameter(name = 'CKM32',
                  nature = 'external',
                  type = 'complex',
                  value = 0.0403,
                  texname = '\\text{CKM32}',
                  lhablock = 'CKMBlock',
                  lhacode = [ 3, 2 ])

CKM33 = Parameter(name = 'CKM33',
                  nature = 'external',
                  type = 'complex',
                  value = 0.999152,
                  texname = '\\text{CKM33}',
                  lhablock = 'CKMBlock',
                  lhacode = [ 3, 3 ])

Gvl = Parameter(name = 'Gvl',
                nature = 'external',
                type = 'real',
                value = 1,
                texname = 'g_{\\text{VL}}',
                lhablock = 'Gvl',
                lhacode = [ 1 ])

gstar = Parameter(name = 'gstar',
                  nature = 'external',
                  type = 'real',
                  value = 0.1,
                  texname = '\\text{gstar}',
                  lhablock = 'Kappa',
                  lhacode = [ 1 ])

aEWM1 = Parameter(name = 'aEWM1',
                  nature = 'external',
                  type = 'real',
                  value = 127.9,
                  texname = '\\text{aEWM1}',
                  lhablock = 'SMINPUTS',
                  lhacode = [ 1 ])

Gf = Parameter(name = 'Gf',
               nature = 'external',
               type = 'real',
               value = 0.00001166,
               texname = 'G_f',
               lhablock = 'SMINPUTS',
               lhacode = [ 2 ])

aS = Parameter(name = 'aS',
               nature = 'external',
               type = 'real',
               value = 0.118,
               texname = '\\text{aS}',
               lhablock = 'SMINPUTS',
               lhacode = [ 3 ])

ymb = Parameter(name = 'ymb',
                nature = 'external',
                type = 'real',
                value = 4.2,
                texname = '\\text{ymb}',
                lhablock = 'YUKAWA',
                lhacode = [ 5 ])

ymt = Parameter(name = 'ymt',
                nature = 'external',
                type = 'real',
                value = 174.3,
                texname = '\\text{ymt}',
                lhablock = 'YUKAWA',
                lhacode = [ 6 ])

ymtau = Parameter(name = 'ymtau',
                  nature = 'external',
                  type = 'real',
                  value = 1.777,
                  texname = '\\text{ymtau}',
                  lhablock = 'YUKAWA',
                  lhacode = [ 15 ])

RL = Parameter(name = 'RL',
               nature = 'external',
               type = 'real',
               value = 1,
               texname = '\\text{RL}',
               lhablock = 'Zeta',
               lhacode = [ 1 ])

MTA = Parameter(name = 'MTA',
                nature = 'external',
                type = 'real',
                value = 1.777,
                texname = '\\text{MTA}',
                lhablock = 'MASS',
                lhacode = [ 15 ])

MT = Parameter(name = 'MT',
               nature = 'external',
               type = 'real',
               value = 174.3,
               texname = '\\text{MT}',
               lhablock = 'MASS',
               lhacode = [ 6 ])

MB = Parameter(name = 'MB',
               nature = 'external',
               type = 'real',
               value = 4.2,
               texname = '\\text{MB}',
               lhablock = 'MASS',
               lhacode = [ 5 ])

MQ = Parameter(name = 'MQ',
               nature = 'external',
               type = 'real',
               value = 1000,
               texname = '\\text{MQ}',
               lhablock = 'MASS',
               lhacode = [ 6000007 ])

MZ = Parameter(name = 'MZ',
               nature = 'external',
               type = 'real',
               value = 91.1876,
               texname = '\\text{MZ}',
               lhablock = 'MASS',
               lhacode = [ 23 ])

MH = Parameter(name = 'MH',
               nature = 'external',
               type = 'real',
               value = 125,
               texname = '\\text{MH}',
               lhablock = 'MASS',
               lhacode = [ 25 ])

WT = Parameter(name = 'WT',
               nature = 'external',
               type = 'real',
               value = 1.5101349,
               texname = '\\text{WT}',
               lhablock = 'DECAY',
               lhacode = [ 6 ])

WBP = Parameter(name = 'WBP',
                nature = 'external',
                type = 'real',
                value = 1,
                texname = '\\text{WBP}',
                lhablock = 'DECAY',
                lhacode = [ 6000007 ])

WZ = Parameter(name = 'WZ',
               nature = 'external',
               type = 'real',
               value = 2.44639985,
               texname = '\\text{WZ}',
               lhablock = 'DECAY',
               lhacode = [ 23 ])

WW = Parameter(name = 'WW',
               nature = 'external',
               type = 'real',
               value = 2.0353557,
               texname = '\\text{WW}',
               lhablock = 'DECAY',
               lhacode = [ 24 ])

WH = Parameter(name = 'WH',
               nature = 'external',
               type = 'real',
               value = 0.00679485838,
               texname = '\\text{WH}',
               lhablock = 'DECAY',
               lhacode = [ 25 ])

KB = Parameter(name = 'KB',
               nature = 'internal',
               type = 'real',
               value = 'gstar',
               texname = '\\text{KB}')

zetaBbL = Parameter(name = 'zetaBbL',
                    nature = 'internal',
                    type = 'real',
                    value = '1/(1 + RL)',
                    texname = '\\text{zetaBbL}')

zetaBbR = Parameter(name = 'zetaBbR',
                    nature = 'internal',
                    type = 'real',
                    value = '0',
                    texname = '\\text{zetaBbR}')

zetaBdL = Parameter(name = 'zetaBdL',
                    nature = 'internal',
                    type = 'real',
                    value = 'RL/(1 + RL)',
                    texname = '\\text{zetaBdL}')

zetaBdR = Parameter(name = 'zetaBdR',
                    nature = 'internal',
                    type = 'real',
                    value = '0',
                    texname = '\\text{zetaBdR}')

zetaBsL = Parameter(name = 'zetaBsL',
                    nature = 'internal',
                    type = 'real',
                    value = '0',
                    texname = '\\text{zetaBsL}')

zetaBsR = Parameter(name = 'zetaBsR',
                    nature = 'internal',
                    type = 'real',
                    value = '0',
                    texname = '\\text{zetaBsR}')

aEW = Parameter(name = 'aEW',
                nature = 'internal',
                type = 'real',
                value = '1/aEWM1',
                texname = '\\text{aEW}')

G = Parameter(name = 'G',
              nature = 'internal',
              type = 'real',
              value = '2*cmath.sqrt(aS)*cmath.sqrt(cmath.pi)',
              texname = 'G')

MW = Parameter(name = 'MW',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(MZ**2/2. + cmath.sqrt(MZ**4/4. - (aEW*cmath.pi*MZ**2)/(Gf*cmath.sqrt(2))))',
               texname = 'M_W')

ee = Parameter(name = 'ee',
               nature = 'internal',
               type = 'real',
               value = '2*cmath.sqrt(aEW)*cmath.sqrt(cmath.pi)',
               texname = 'e')

KBbLh = Parameter(name = 'KBbLh',
                  nature = 'internal',
                  type = 'real',
                  value = 'cmath.sqrt(zetaBbL)',
                  texname = '\\text{KBbLh}')

KBbRh = Parameter(name = 'KBbRh',
                  nature = 'internal',
                  type = 'real',
                  value = 'cmath.sqrt(zetaBbR)',
                  texname = '\\text{KBbRh}')

KBdLh = Parameter(name = 'KBdLh',
                  nature = 'internal',
                  type = 'real',
                  value = 'cmath.sqrt(zetaBdL)',
                  texname = '\\text{KBdLh}')

KBdRh = Parameter(name = 'KBdRh',
                  nature = 'internal',
                  type = 'real',
                  value = 'cmath.sqrt(zetaBdR)',
                  texname = '\\text{KBdRh}')

KBsLh = Parameter(name = 'KBsLh',
                  nature = 'internal',
                  type = 'real',
                  value = 'cmath.sqrt(zetaBsL)',
                  texname = '\\text{KBsLh}')

KBsRh = Parameter(name = 'KBsRh',
                  nature = 'internal',
                  type = 'real',
                  value = 'cmath.sqrt(zetaBsR)',
                  texname = '\\text{KBsRh}')

sw2 = Parameter(name = 'sw2',
                nature = 'internal',
                type = 'real',
                value = '1 - MW**2/MZ**2',
                texname = '\\text{sw2}')

cw = Parameter(name = 'cw',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(1 - sw2)',
               texname = 'c_w')

sw = Parameter(name = 'sw',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(sw2)',
               texname = 's_w')

g1 = Parameter(name = 'g1',
               nature = 'internal',
               type = 'real',
               value = 'ee/cw',
               texname = 'g_1')

gw = Parameter(name = 'gw',
               nature = 'internal',
               type = 'real',
               value = 'ee/sw',
               texname = 'g_w')

KBdLw = Parameter(name = 'KBdLw',
                  nature = 'internal',
                  type = 'real',
                  value = '(ee*cmath.sqrt(zetaBdL))/(sw*cmath.sqrt(2))',
                  texname = '\\text{KBdLw}')

KBdRw = Parameter(name = 'KBdRw',
                  nature = 'internal',
                  type = 'real',
                  value = '(ee*cmath.sqrt(zetaBdR))/(sw*cmath.sqrt(2))',
                  texname = '\\text{KBdRw}')

KBsLw = Parameter(name = 'KBsLw',
                  nature = 'internal',
                  type = 'real',
                  value = '(ee*cmath.sqrt(zetaBsL))/(sw*cmath.sqrt(2))',
                  texname = '\\text{KBsLw}')

v = Parameter(name = 'v',
              nature = 'internal',
              type = 'real',
              value = '(2*MW*sw)/ee',
              texname = 'v')

KBbLw = Parameter(name = 'KBbLw',
                  nature = 'internal',
                  type = 'real',
                  value = '(gw*cmath.sqrt(zetaBbL))/cmath.sqrt(2)',
                  texname = '\\text{KBbLw}')

KBbLz = Parameter(name = 'KBbLz',
                  nature = 'internal',
                  type = 'real',
                  value = '(gw*cmath.sqrt(zetaBbL))/(2.*cw)',
                  texname = '\\text{KBbLz}')

KBbRw = Parameter(name = 'KBbRw',
                  nature = 'internal',
                  type = 'real',
                  value = '(gw*cmath.sqrt(zetaBbR))/cmath.sqrt(2)',
                  texname = '\\text{KBbRw}')

KBbRz = Parameter(name = 'KBbRz',
                  nature = 'internal',
                  type = 'real',
                  value = '(gw*cmath.sqrt(zetaBbR))/(2.*cw)',
                  texname = '\\text{KBbRz}')

KBdLz = Parameter(name = 'KBdLz',
                  nature = 'internal',
                  type = 'real',
                  value = '(gw*cmath.sqrt(zetaBdL))/(2.*cw)',
                  texname = '\\text{KBdLz}')

KBdRz = Parameter(name = 'KBdRz',
                  nature = 'internal',
                  type = 'real',
                  value = '(gw*cmath.sqrt(zetaBdR))/(2.*cw)',
                  texname = '\\text{KBdRz}')

KBsLz = Parameter(name = 'KBsLz',
                  nature = 'internal',
                  type = 'real',
                  value = '(gw*cmath.sqrt(zetaBsL))/(2.*cw)',
                  texname = '\\text{KBsLz}')

KBsRw = Parameter(name = 'KBsRw',
                  nature = 'internal',
                  type = 'real',
                  value = '(gw*cmath.sqrt(zetaBsR))/cmath.sqrt(2)',
                  texname = '\\text{KBsRw}')

KBsRz = Parameter(name = 'KBsRz',
                  nature = 'internal',
                  type = 'real',
                  value = '(gw*cmath.sqrt(zetaBsR))/(2.*cw)',
                  texname = '\\text{KBsRz}')

lam = Parameter(name = 'lam',
                nature = 'internal',
                type = 'real',
                value = 'MH**2/(2.*v**2)',
                texname = '\\text{lam}')

yb = Parameter(name = 'yb',
               nature = 'internal',
               type = 'real',
               value = '(ymb*cmath.sqrt(2))/v',
               texname = '\\text{yb}')

yt = Parameter(name = 'yt',
               nature = 'internal',
               type = 'real',
               value = '(ymt*cmath.sqrt(2))/v',
               texname = '\\text{yt}')

ytau = Parameter(name = 'ytau',
                 nature = 'internal',
                 type = 'real',
                 value = '(ymtau*cmath.sqrt(2))/v',
                 texname = '\\text{ytau}')

muH = Parameter(name = 'muH',
                nature = 'internal',
                type = 'real',
                value = 'cmath.sqrt(lam*v**2)',
                texname = '\\mu')

