(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    926374,      24656]
NotebookOptionsPosition[    884166,      23601]
NotebookOutlinePosition[    884550,      23618]
CellTagsIndexPosition[    884507,      23615]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Loading the Model", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.5747635829149995`*^9, 3.57476358536814*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell["FeynRules", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}, {
  3.5745083801218367`*^9, 3.5745083815726395`*^9}, {3.5747636519029455`*^9, 
  3.574763653096014*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Development", " ", "version", " ", "of", " ", "FeynRules"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"$FeynRulesPath", "=", 
    RowBox[{
    "SetDirectory", "[", 
     "\"\<D:\\Logiciels\\Mathematica\\AddOns\\Applications\\FeynRules\>\"", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"<<", "FeynRules`"}]}]}]], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
   3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
   3.4234163227881193`*^9}, {3.511089776533998*^9, 3.511089890304998*^9}, {
   3.570344357677924*^9, 3.5703443578229322`*^9}, {3.570344512008752*^9, 
   3.5703445121387587`*^9}, 3.5703446555509615`*^9, {3.570344736530594*^9, 
   3.570344736711604*^9}, {3.570344822226495*^9, 3.5703448224985104`*^9}, {
   3.570344870967283*^9, 3.5703448712172976`*^9}, {3.570344942914398*^9, 
   3.57034494452749*^9}, 3.570345090188822*^9, 3.570345194557791*^9, 
   3.570345250109968*^9, {3.5703453456004305`*^9, 3.5703453706358624`*^9}, 
   3.570345439946827*^9, {3.5703454920498066`*^9, 3.5703454921988153`*^9}, {
   3.570346138690792*^9, 3.5703461395958443`*^9}, 3.5703463179550457`*^9, 
   3.5704279554332037`*^9, 3.5704315647245255`*^9, 3.570431832892078*^9, 
   3.570432419915621*^9, 3.5704339108589463`*^9, 3.5704393993113914`*^9, {
   3.570441431289675*^9, 3.5704414314956865`*^9}, 3.5704588277894716`*^9, 
   3.5705147301564636`*^9, 3.5705157733421307`*^9, 3.5705194500223126`*^9, 
   3.5705210964258795`*^9, 3.5705224186222773`*^9, 3.570637608174341*^9, {
   3.5718105955684996`*^9, 3.5718105958850393`*^9}, {3.5719846095556064`*^9, 
   3.5719846097111263`*^9}, {3.572196586126171*^9, 3.572196589630116*^9}, {
   3.572198016392996*^9, 3.572198020120469*^9}, {3.5721988385443954`*^9, 
   3.572198838699915*^9}, {3.5730668032312374`*^9, 3.573066839596855*^9}, {
   3.57431159696554*^9, 3.574311618353177*^9}, {3.574311650212433*^9, 
   3.5743116507116337`*^9}, {3.574311696185714*^9, 3.574311836982362*^9}, {
   3.574311868541217*^9, 3.574311869570819*^9}, {3.574763410843158*^9, 
   3.5747634367356386`*^9}, 3.575089230788249*^9, 3.5750920968561935`*^9, {
   3.5751899699742503`*^9, 3.5751899744723215`*^9}, {3.5810870147563124`*^9, 
   3.581087021565177*^9}},
 EmphasizeSyntaxErrors->True,
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"D:\\\\Logiciels\\\\Mathematica\\\\AddOns\\\\Applications\\\\\
FeynRules\"\>", TraditionalForm]], "Output",
 CellChangeTimes->{
  3.5730666912455173`*^9, {3.573066734017948*^9, 3.573066757883479*^9}, 
   3.573066843316828*^9, {3.5743116119259663`*^9, 3.5743116225183845`*^9}, 
   3.574311656452444*^9, {3.574311702924926*^9, 3.5743118723320236`*^9}, 
   3.5743119211977096`*^9, 3.574506187694845*^9, 3.574506359525549*^9, 
   3.57450671996922*^9, 3.57450680096904*^9, 3.5745069969483643`*^9, 
   3.5745070275088177`*^9, 3.5745071110937653`*^9, 3.574507150858235*^9, 
   3.5745081530312376`*^9, 3.574763442671978*^9, 3.5747648311793966`*^9, 
   3.575086126206517*^9, 3.5750862345922804`*^9, 3.5750863815544424`*^9, 
   3.575086561645811*^9, 3.5750871134913864`*^9, 3.5750872267162642`*^9, 
   3.575092102509411*^9, 3.5751812131354384`*^9, 3.5751846905558243`*^9, 
   3.5751848375214868`*^9, 3.5751892208091183`*^9, 3.5751894338566723`*^9, 
   3.575189493254715*^9, 3.5810871387325554`*^9, 3.581705744532957*^9, 
   3.581706639135057*^9},
 FontSize->7],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\" - FeynRules - \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574311872347624*^9, 3.5743119211977096`*^9, 
  3.5745061877104454`*^9, 3.574506359525549*^9, 3.57450671996922*^9, 
  3.57450680096904*^9, 3.5745069969483643`*^9, 3.5745070275088177`*^9, 
  3.574507111109365*^9, 3.574507150858235*^9, 3.5745081530312376`*^9, 
  3.5747634426929793`*^9, 3.5747648311823964`*^9, 3.575086126210518*^9, 
  3.575086234596781*^9, 3.575086381558943*^9, 3.5750865616498117`*^9, 
  3.5750871135293913`*^9, 3.575087226721265*^9, 3.5750921025134115`*^9, 
  3.5751812133514657`*^9, 3.5751846906598377`*^9, 3.575184837529988*^9, 
  3.575189220834622*^9, 3.5751894339006777`*^9, 3.5751894932607155`*^9, 
  3.5810871393951397`*^9, 3.581705744697478*^9, 3.5817066392970777`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Authors: C. Duhr, N. Christensen, B. Fuks\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.574311872347624*^9, 3.5743119211977096`*^9, 
  3.5745061877104454`*^9, 3.574506359525549*^9, 3.57450671996922*^9, 
  3.57450680096904*^9, 3.5745069969483643`*^9, 3.5745070275088177`*^9, 
  3.574507111109365*^9, 3.574507150858235*^9, 3.5745081530312376`*^9, 
  3.5747634426929793`*^9, 3.5747648311823964`*^9, 3.575086126210518*^9, 
  3.575086234596781*^9, 3.575086381558943*^9, 3.5750865616498117`*^9, 
  3.5750871135293913`*^9, 3.575087226721265*^9, 3.5750921025134115`*^9, 
  3.5751812133514657`*^9, 3.5751846906598377`*^9, 3.575184837529988*^9, 
  3.575189220834622*^9, 3.5751894339006777`*^9, 3.5751894932607155`*^9, 
  3.5810871393951397`*^9, 3.581705744697478*^9, 3.5817066393045783`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\" \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574311872347624*^9, 3.5743119211977096`*^9, 
  3.5745061877104454`*^9, 3.574506359525549*^9, 3.57450671996922*^9, 
  3.57450680096904*^9, 3.5745069969483643`*^9, 3.5745070275088177`*^9, 
  3.574507111109365*^9, 3.574507150858235*^9, 3.5745081530312376`*^9, 
  3.5747634426929793`*^9, 3.5747648311823964`*^9, 3.575086126210518*^9, 
  3.575086234596781*^9, 3.575086381558943*^9, 3.5750865616498117`*^9, 
  3.5750871135293913`*^9, 3.575087226721265*^9, 3.5750921025134115`*^9, 
  3.5751812133514657`*^9, 3.5751846906598377`*^9, 3.575184837529988*^9, 
  3.575189220834622*^9, 3.5751894339006777`*^9, 3.5751894932607155`*^9, 
  3.5810871393951397`*^9, 3.581705744697478*^9, 3.5817066393135796`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Please cite: Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574311872347624*^9, 3.5743119211977096`*^9, 
  3.5745061877104454`*^9, 3.574506359525549*^9, 3.57450671996922*^9, 
  3.57450680096904*^9, 3.5745069969483643`*^9, 3.5745070275088177`*^9, 
  3.574507111109365*^9, 3.574507150858235*^9, 3.5745081530312376`*^9, 
  3.5747634426929793`*^9, 3.5747648311823964`*^9, 3.575086126210518*^9, 
  3.575086234596781*^9, 3.575086381558943*^9, 3.5750865616498117`*^9, 
  3.5750871135293913`*^9, 3.575087226721265*^9, 3.5750921025134115`*^9, 
  3.5751812133514657`*^9, 3.5751846906598377`*^9, 3.575184837529988*^9, 
  3.575189220834622*^9, 3.5751894339006777`*^9, 3.5751894932607155`*^9, 
  3.5810871393951397`*^9, 3.581705744697478*^9, 3.5817066393255816`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"http://feynrules.phys.ucl.ac.be\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{3.574311872347624*^9, 3.5743119211977096`*^9, 
  3.5745061877104454`*^9, 3.574506359525549*^9, 3.57450671996922*^9, 
  3.57450680096904*^9, 3.5745069969483643`*^9, 3.5745070275088177`*^9, 
  3.574507111109365*^9, 3.574507150858235*^9, 3.5745081530312376`*^9, 
  3.5747634426929793`*^9, 3.5747648311823964`*^9, 3.575086126210518*^9, 
  3.575086234596781*^9, 3.575086381558943*^9, 3.5750865616498117`*^9, 
  3.5750871135293913`*^9, 3.575087226721265*^9, 3.5750921025134115`*^9, 
  3.5751812133514657`*^9, 3.5751846906598377`*^9, 3.575184837529988*^9, 
  3.575189220834622*^9, 3.5751894339006777`*^9, 3.5751894932607155`*^9, 
  3.5810871393951397`*^9, 3.581705744697478*^9, 3.581706639330082*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\" \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574311872347624*^9, 3.5743119211977096`*^9, 
  3.5745061877104454`*^9, 3.574506359525549*^9, 3.57450671996922*^9, 
  3.57450680096904*^9, 3.5745069969483643`*^9, 3.5745070275088177`*^9, 
  3.574507111109365*^9, 3.574507150858235*^9, 3.5745081530312376`*^9, 
  3.5747634426929793`*^9, 3.5747648311823964`*^9, 3.575086126210518*^9, 
  3.575086234596781*^9, 3.575086381558943*^9, 3.5750865616498117`*^9, 
  3.5750871135293913`*^9, 3.575087226721265*^9, 3.5750921025134115`*^9, 
  3.5751812133514657`*^9, 3.5751846906598377`*^9, 3.575184837529988*^9, 
  3.575189220834622*^9, 3.5751894339006777`*^9, 3.5751894932607155`*^9, 
  3.5810871393951397`*^9, 3.581705744697478*^9, 3.5817066393345823`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574311872347624*^9, 3.5743119211977096`*^9, 
  3.5745061877104454`*^9, 3.574506359525549*^9, 3.57450671996922*^9, 
  3.57450680096904*^9, 3.5745069969483643`*^9, 3.5745070275088177`*^9, 
  3.574507111109365*^9, 3.574507150858235*^9, 3.5745081530312376`*^9, 
  3.5747634426929793`*^9, 3.5747648311823964`*^9, 3.575086126210518*^9, 
  3.575086234596781*^9, 3.575086381558943*^9, 3.5750865616498117`*^9, 
  3.5750871135293913`*^9, 3.575087226721265*^9, 3.5750921025134115`*^9, 
  3.5751812133514657`*^9, 3.5751846906598377`*^9, 3.575184837529988*^9, 
  3.575189220834622*^9, 3.5751894339006777`*^9, 3.5751894932607155`*^9, 
  3.5810871393951397`*^9, 3.581705744697478*^9, 3.581706639339583*^9},
 FontSize->7]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
VLQ.fr (with \[OpenCurlyDoubleQuote]Massless\[CloseCurlyDoubleQuote] \
Restriction)\
\>", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}, {
  3.5745083801218367`*^9, 3.5745083815726395`*^9}, {3.5747636603284273`*^9, 
  3.5747636618625154`*^9}, {3.5751899838405113`*^9, 3.575189994177824*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/VLQ\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LoadModel", "[", "\"\<VLQ.fr\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"LoadRestriction", "[", "\"\<Massless.rst\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ModelInformation", "[", "]"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "The", " ", "massless", " ", "restriction", " ", "ensures", " ", 
      "appropriate", " ", "definitions", " ", "for", " ", "the", " ", "PDF"}],
      " ", "&"}], " ", "light", " ", "quarks"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"LoadRestriction", "[", "\"\<Cabibbo.rst\>\"", "]"}], 
    "\[IndentingNewLine]", 
    RowBox[{"LoadRestriction", "[", "\"\<DiagonalCKM.rst\>\"", "]"}]}], 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.574506706301206*^9, 3.5745067318765955`*^9}, {
  3.5747636000559797`*^9, 3.574763622303252*^9}, {3.575089695153716*^9, 
  3.575089721000498*^9}, {3.5751899988184133`*^9, 3.575190006169347*^9}},
 FontSize->8],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"This model implementation was created by\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.58170666483082*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"M. Buchkremer\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.5817066648358207`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"G. Cacciapaglia\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.581706664841821*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"A. Deandrea\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.581706664848322*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"L. Panizzi\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.5817066648538227`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.2.5\"\>"}],
   SequenceForm["Model Version: ", "1.2.5"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.5817066648593235`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"For more information, type ModelInformation[].\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.581706664870325*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.581706664875826*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"   - Loading particle classes.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.5817066648838267`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"   - Loading gauge group classes.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.581706665056349*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"   - Loading parameter classes.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.581706665073351*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"VLQ\"\>", 
    "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
   SequenceForm["\nModel ", "VLQ", " loaded."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.5817066652613745`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Loading restrictions from \"\>", 
    "\[InvisibleSpace]", "\<\"Massless.rst\"\>", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
    DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, TraditionalForm],
     ImageSizeCache->{12., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
    "\[InvisibleSpace]", "18"}],
   SequenceForm["Loading restrictions from ", "Massless.rst", " : ", 
    Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.5817066653408847`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Restrictions loaded.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.5817066654804025`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Model name: \"\>", "\[InvisibleSpace]", "\<\"VLQ\"\>"}],
   SequenceForm["Model name: ", "VLQ"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.5817066655604124`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Model version: \"\>", "\[InvisibleSpace]", "\<\"1.2.5\"\>"}],
   SequenceForm["Model version: ", "1.2.5"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.581706665566413*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Date: \"\>", "\[InvisibleSpace]", "\<\"10. 04. 2013\"\>"}],
   SequenceForm["Date: ", "10. 04. 2013"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.5817066655719137`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Authors: \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.581706665576915*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"   M. Buchkremer\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.5817066655834155`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"   G. Cacciapaglia\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.581706665596917*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"   A. Deandrea\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.581706665602418*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"   L. Panizzi\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.5817066656079187`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Institutions: \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.5817066656189203`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"   Universite catholique de Louvain (CP3)\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.581706665624421*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"   Universite de Lyon (CNRS/IN2P3)\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.5817066656299214`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"   University of Southampton (School of Physics and \
Astronomy)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.5817066656424227`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Emails: \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.581706665648424*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"   mathieu.buchkremer@uclouvain.be\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.5817066656544247`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"   g.cacciapaglia@ipnl.in2p3.fr\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.581706665667426*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"   deandrea@ipnl.in2p3.fr\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.5817066656724267`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"   l.panizzi@soton.ac.uk\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507167971465*^9, 3.574508184012892*^9, 
  3.574763448033285*^9, 3.574764835253629*^9, 3.575086134039012*^9, 
  3.5750862411286106`*^9, 3.5750863908736258`*^9, 3.5750865657613335`*^9, 
  3.5750871230456*^9, 3.5750872337986636`*^9, 3.575092119329547*^9, 
  3.5751812158267803`*^9, 3.5751846934256887`*^9, 3.5751848379560423`*^9, 
  3.5751892214291973`*^9, 3.575189435171339*^9, 3.57518949368827*^9, 
  3.5810871723968306`*^9, 3.5817057501896753`*^9, 3.5817066656779275`*^9},
 FontSize->7]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Displaying the Feynman Rules for the VLQ lagrangian\
\>", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}, {
  3.5745083801218367`*^9, 3.5745083815726395`*^9}, {3.5747636723761168`*^9, 
  3.5747636850628424`*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LVLQ", "]"}]], "Input",
 FontSize->7],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"Starting Feynman rule calculation.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066660564756`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the \
vertex...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706667636176*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Found \"\>", "\[InvisibleSpace]", "\<\"56\"\>", 
    "\[InvisibleSpace]", "\<\" possible non zero vertices.\"\>"}],
   SequenceForm["Found ", "56", " possible non zero vertices."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066677356887`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Start calculating vertices...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066677406893`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  ProgressIndicatorBox[Dynamic[PRIVATE`progress$902]], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066677451897`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"56", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
   SequenceForm[56, " vertices obtained."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066696039257`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066696244287`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "1"}],
   SequenceForm["Vertex ", 1],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706669628929*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "A"}],
   SequenceForm["Particle ", 1, " : ", "Vector", " , ", $CellContext`A],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.58170666963443*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706669644431*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066696479316`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706669651432*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "3"]}], " ", "\[ImaginaryI]", " ", 
   FormBox["e",
    TraditionalForm], " ", 
   FormBox[
    SubscriptBox["\[Delta]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"i\"\>", "2"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"i\"\>", "3"],
       TraditionalForm]}]],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"s\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"s\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"\[Mu]\"\>", "1"],
      TraditionalForm]],
    TraditionalForm]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066697139397`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706669719941*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "2"}],
   SequenceForm["Vertex ", 2],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066697244415`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "A"}],
   SequenceForm["Particle ", 1, " : ", "Vector", " , ", $CellContext`A],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066697279415`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066697334423`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706669744444*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066697479444`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", 
   FormBox["e",
    TraditionalForm], " ", 
   FormBox[
    SubscriptBox["\[Delta]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"i\"\>", "2"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"i\"\>", "3"],
       TraditionalForm]}]],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"s\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"s\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"\[Mu]\"\>", "1"],
      TraditionalForm]],
    TraditionalForm]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706669751445*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066697579455`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "3"}],
   SequenceForm["Vertex ", 3],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706669768447*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "A"}],
   SequenceForm["Particle ", 1, " : ", "Vector", " , ", $CellContext`A],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066697729473`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "x"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`x],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706669776948*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["x", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`xbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066697929497`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706669799451*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["5", "3"], " ", "\[ImaginaryI]", " ", 
   FormBox["e",
    TraditionalForm], " ", 
   FormBox[
    SubscriptBox["\[Delta]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"i\"\>", "2"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"i\"\>", "3"],
       TraditionalForm]}]],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"s\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"s\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"\[Mu]\"\>", "1"],
      TraditionalForm]],
    TraditionalForm]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066698089523`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706669824954*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "4"}],
   SequenceForm["Vertex ", 4],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066698309546`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "A"}],
   SequenceForm["Particle ", 1, " : ", "Vector", " , ", $CellContext`A],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706669845457*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "y"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`y],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066698509574`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["y", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`ybar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066698569584`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.58170666987246*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["4", "3"]}], " ", "\[ImaginaryI]", " ", 
   FormBox["e",
    TraditionalForm], " ", 
   FormBox[
    SubscriptBox["\[Delta]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"i\"\>", "2"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"i\"\>", "3"],
       TraditionalForm]}]],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"s\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"s\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"\[Mu]\"\>", "1"],
      TraditionalForm]],
    TraditionalForm]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706669878461*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706669886962*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "5"}],
   SequenceForm["Vertex ", 5],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706669902964*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["b", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066699129653`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706669922967*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 3, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066699274673`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066699319677`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbLh", " ", "MBP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "2"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "2"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbRh", " ", "MBP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "2"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "2"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066699444695`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066699514704`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "6"}],
   SequenceForm["Vertex ", 6],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706669960471*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "b"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`b],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706669970973*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066699769735`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 3, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706669992975*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706669998976*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbRh", " ", "MBP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "2"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "2"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "1"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbLh", " ", "MBP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "2"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "2"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "1"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670006977*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066700204787`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "7"}],
   SequenceForm["Vertex ", 7],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066700244794`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066700289803`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "d"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`d],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066700359807`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 3, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066700459824`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066700509825`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdRh", " ", "MBP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "2"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "2"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdLh", " ", "MBP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "2"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "2"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066700559835`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670067485*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "8"}],
   SequenceForm["Vertex ", 8],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670072486*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066700779862`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 2, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670084487*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "s"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", FeynRules`s],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670099989*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.58170667010899*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsRh", " ", "MBP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsLh", " ", "MBP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670122492*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670130993*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "9"}],
   SequenceForm["Vertex ", 9],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066701454945`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["c", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`cbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670153996*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 2, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066701679974`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066701739984`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670179499*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcLh", " ", "MTP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcRh", " ", "MTP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066701875*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670202002*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "10"}],
   SequenceForm["Vertex ", 10],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066702090025`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066702210045`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["d", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`dbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066702265053`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 3, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066702315054`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066702435074`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdLh", " ", "MBP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "2"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "2"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "1"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdRh", " ", "MBP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "2"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "2"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "1"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670248008*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066702550087`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "11"}],
   SequenceForm["Vertex ", 11],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066702675104`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670273011*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 2, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066702785115`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["s", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`sbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066702830124`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670295014*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsLh", " ", "MBP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "3"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "1"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsRh", " ", "MBP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "3"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "1"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670299014*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670306515*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "12"}],
   SequenceForm["Vertex ", 12],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670318017*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 1, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670323017*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["t", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670327018*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670331518*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.58170667034202*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtLh", " ", "MTP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "2"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "2"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtRh", " ", "MTP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "2"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "2"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066703460207`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670351521*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "13"}],
   SequenceForm["Vertex ", 13],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066703555217`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "c"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`c],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066703605223`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 2, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066703700233`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066703735237`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670377024*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcRh", " ", "MTP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "3"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "1"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcLh", " ", "MTP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "3"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "1"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670381525*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670392026*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "14"}],
   SequenceForm["Vertex ", 14],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670396527*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 1, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066704000273`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "t"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`t],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670410528*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066704190297`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.58170667042303*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtRh", " ", "MTP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "2"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "3"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "2"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtLh", " ", "MTP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "2"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "3"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "2"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066704270306`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066704325314`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "15"}],
   SequenceForm["Vertex ", 15],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066704430323`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 1, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670446533*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670450534*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "u"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", FeynRules`u],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670454534*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670460035*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuRh", " ", "MTP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "2"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "2"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuLh", " ", "MTP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "2"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "2"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670469536*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670474036*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "16"}],
   SequenceForm["Vertex ", 16],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670478037*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 1, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066704820375`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066704920387`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["u", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`ubar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066704960394`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.58170667050104*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuLh", " ", "MTP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "2"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "3"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "2"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuRh", " ", "MTP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "2"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "3"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "2"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.58170667050504*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670515542*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "17"}],
   SequenceForm["Vertex ", 17],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066705200424`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670523543*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670527543*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "G"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", FeynRules`G],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670532544*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066705435457`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{"\[ImaginaryI]", " ", 
   FormBox[
    SubscriptBox["g", "s"],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["T", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"i\"\>", "2"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"i\"\>", "1"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"a\"\>", "3"],
      TraditionalForm]],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"s\"\>", "2"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"s\"\>", "1"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"\[Mu]\"\>", "3"],
      TraditionalForm]],
    TraditionalForm]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670547546*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066705525465`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "18"}],
   SequenceForm["Vertex ", 18],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670558547*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "G"}],
   SequenceForm["Particle ", 1, " : ", "Vector", " , ", FeynRules`G],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066705665483`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670570549*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670574049*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066705780497`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{"\[ImaginaryI]", " ", 
   FormBox[
    SubscriptBox["g", "s"],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["T", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"i\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"i\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"a\"\>", "1"],
      TraditionalForm]],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"s\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"s\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"\[Mu]\"\>", "1"],
      TraditionalForm]],
    TraditionalForm]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066705830507`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670595052*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "19"}],
   SequenceForm["Vertex ", 19],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066705990524`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "G"}],
   SequenceForm["Particle ", 1, " : ", "Vector", " , ", FeynRules`G],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670603053*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "x"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`x],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066706075535`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["x", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`xbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066706175547`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066706215553`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{"\[ImaginaryI]", " ", 
   FormBox[
    SubscriptBox["g", "s"],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["T", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"i\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"i\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"a\"\>", "1"],
      TraditionalForm]],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"s\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"s\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"\[Mu]\"\>", "1"],
      TraditionalForm]],
    TraditionalForm]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670625556*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066706300564`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "20"}],
   SequenceForm["Vertex ", 20],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670634557*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "G"}],
   SequenceForm["Particle ", 1, " : ", "Vector", " , ", FeynRules`G],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670644058*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "y"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`y],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670649059*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["y", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`ybar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066706540594`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.58170667065956*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{"\[ImaginaryI]", " ", 
   FormBox[
    SubscriptBox["g", "s"],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["T", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"i\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"i\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"a\"\>", "1"],
      TraditionalForm]],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"s\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"s\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"\[Mu]\"\>", "1"],
      TraditionalForm]],
    TraditionalForm]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670668561*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670673562*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "21"}],
   SequenceForm["Vertex ", 21],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066706775627`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "b"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`b],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670682563*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066706925645`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066706965647`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066707005653`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066707050657`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670715567*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "22"}],
   SequenceForm["Vertex ", 22],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066707195673`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "d"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`d],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066707345695`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670743571*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670747571*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670753072*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066707570724`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670778575*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "23"}],
   SequenceForm["Vertex ", 23],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670790577*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "s"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`s],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670794577*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066707985773`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066708025784`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670808579*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.58170667081708*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670824081*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "24"}],
   SequenceForm["Vertex ", 24],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066708280816`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670832582*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["u", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`ubar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066708430834`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670847084*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066708505845`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066708545847`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066708660865`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "25"}],
   SequenceForm["Vertex ", 25],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670871587*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "c"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`c],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066708760877`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670879588*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["x", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`xbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066708905897`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.58170667089459*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXcL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXcR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066708995905`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066709085913`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "26"}],
   SequenceForm["Vertex ", 26],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066709180927`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "t"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`t],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066709220934`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706670927094*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["x", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`xbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066709420958`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066709630985`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXtL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXtR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066709781003`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066710041037`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "27"}],
   SequenceForm["Vertex ", 27],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066710246067`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "u"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`u],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671046109*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.58170667105311*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["x", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`xbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066710736127`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066710891147`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXuL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXuR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671100116*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066711071167`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "28"}],
   SequenceForm["Vertex ", 28],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066711211185`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["b", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671126119*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066711351204`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671149122*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671156123*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671170125*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066711776257`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "29"}],
   SequenceForm["Vertex ", 29],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671185627*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066711991286`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "c"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`c],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066712036295`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066712076297`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671219631*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671223632*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066712291327`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "30"}],
   SequenceForm["Vertex ", 30],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671233133*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671243634*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "t"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`t],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671249135*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066712531357`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066712596364`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066712686377`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671273638*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "31"}],
   SequenceForm["Vertex ", 31],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066712776384`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066712826395`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "u"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`u],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671295641*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066712996416`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066713046417`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671309643*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671320644*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "32"}],
   SequenceForm["Vertex ", 32],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671324644*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["c", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`cbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671328645*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671333646*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "x"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", FeynRules`x],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066713426466`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066713466473`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXcL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXcR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671350648*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066713566484`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "33"}],
   SequenceForm["Vertex ", 33],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066713671503`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["d", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`dbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066713716507`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671375651*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066713791513`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671384652*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066713946533`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066714006543`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "34"}],
   SequenceForm["Vertex ", 34],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066714046545`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["s", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`sbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671408655*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671419156*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671423157*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066714271574`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671431658*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066714431596`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "35"}],
   SequenceForm["Vertex ", 35],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.58170667144816*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["t", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`tbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671453161*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671467663*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "x"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", FeynRules`x],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066714741635`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671478664*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXtL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXtR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671494166*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671502167*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "36"}],
   SequenceForm["Vertex ", 36],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066715111685`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["u", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`ubar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066715246696`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066715301704`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "x"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", FeynRules`x],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671546673*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066715521736`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXuL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXuR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066715596743`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066715766764`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "37"}],
   SequenceForm["Vertex ", 37],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066715936785`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "b"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`b],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066715986795`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066716056805`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["y", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`ybar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066716236825`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671628683*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYbL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYbR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066716451855`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671652186*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "38"}],
   SequenceForm["Vertex ", 38],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066716576867`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "d"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`d],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066716701884`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671675689*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["y", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`ybar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066716811895`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066716956916`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYdL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYdR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066717011924`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671720195*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "39"}],
   SequenceForm["Vertex ", 39],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066717261953`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "s"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`s],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671731696*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671748698*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["y", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`ybar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066717737017`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066717792025`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYsL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYsR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066717847033`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066718027053`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "40"}],
   SequenceForm["Vertex ", 40],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671809206*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["b", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671823208*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066718287086`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066718447104`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066718497114`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671854212*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066718737144`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "41"}],
   SequenceForm["Vertex ", 41],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066718792152`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "b"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`b],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671895217*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066719007177`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066719072185`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066719212203`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066719257207`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671933722*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "42"}],
   SequenceForm["Vertex ", 42],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671946724*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066719507236`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "d"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`d],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066719547243`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671959225*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066719702263`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706671974227*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066719802275`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "43"}],
   SequenceForm["Vertex ", 43],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066719907293`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066719947295`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "s"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`s],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.58170667199973*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672003731*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066720097313`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066720197325`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672025734*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "44"}],
   SequenceForm["Vertex ", 44],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066720297337`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["c", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`cbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672034235*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066720457363`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066720497365`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066720542374`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066720587378`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066720707393`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "45"}],
   SequenceForm["Vertex ", 45],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066720747395`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066720792403`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["d", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`dbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672090742*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066720962424`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672101243*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066721057434`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066721187453`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "46"}],
   SequenceForm["Vertex ", 46],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672122746*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672126746*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["s", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`sbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672132747*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672142248*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672146249*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672150749*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066721572504`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "47"}],
   SequenceForm["Vertex ", 47],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672166752*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["t", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`tbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672171752*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066721757526`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066721797533`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066722067566`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066722142577`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066722202587`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "48"}],
   SequenceForm["Vertex ", 48],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672224759*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "c"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`c],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066722297597`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066722392607`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066722447615`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672249262*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066722537622`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672264764*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "49"}],
   SequenceForm["Vertex ", 49],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672269264*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "t"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`t],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672273265*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066722777653`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066722837667`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672293768*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066722982683`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672307269*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "50"}],
   SequenceForm["Vertex ", 50],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.58170667231227*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066723172703`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "u"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`u],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672321771*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066723262715`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066723307724`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066723357725`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672346774*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "51"}],
   SequenceForm["Vertex ", 51],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066723512745`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672355275*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["u", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`ubar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672359776*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066723702774`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672374278*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066723782787`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066723842793`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "52"}],
   SequenceForm["Vertex ", 52],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066723942804`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["b", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672398781*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066724027815`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "y"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", FeynRules`y],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672406782*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672417283*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYbL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYbR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672421784*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066724267845`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "53"}],
   SequenceForm["Vertex ", 53],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672431785*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066724422865`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["c", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`cbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672446787*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066724507875`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672454788*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066724592886`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.58170667247079*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "54"}],
   SequenceForm["Vertex ", 54],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066724747906`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["d", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`dbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672479291*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066724837914`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "y"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", FeynRules`y],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672493293*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066724977937`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYdL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYdR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672501794*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672507795*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "55"}],
   SequenceForm["Vertex ", 55],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672519296*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["s", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`sbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672523797*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066725287976`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "y"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", FeynRules`y],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672540799*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066725452995`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYsL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYsR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066725493*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672554801*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "56"}],
   SequenceForm["Vertex ", 56],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672568302*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672573303*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["t", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672577304*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066725828047`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.5817066725938053`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672597806*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719846736677475`*^9, 3.5721967373743773`*^9, 
  3.5730660940666847`*^9, 3.573066860069955*^9, 3.5743119552681694`*^9, 
  3.5745071808726873`*^9, 3.574508189441702*^9, 3.574763456091746*^9, 
  3.5747648368577213`*^9, 3.5750861401467876`*^9, 3.575086246151248*^9, 
  3.57508639531619*^9, 3.5750865675570617`*^9, 3.575181221513502*^9, 
  3.575184839116189*^9, 3.5751892227703676`*^9, 3.575189494963432*^9, 
  3.581087202138607*^9, 3.581705753825637*^9, 3.581706672603307*^9},
 FontSize->7]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"A", "1"},
         {"bp", "2"},
         {
          FormBox[
           OverscriptBox["bp", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "3"]}], " ", "\[ImaginaryI]", " ", 
       FormBox["e",
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["\[Gamma]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "3"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "1"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"A", "1"},
         {"tp", "2"},
         {
          FormBox[
           OverscriptBox["tp", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", 
       FormBox["e",
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["\[Gamma]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "3"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "1"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"A", "1"},
         {"x", "2"},
         {
          FormBox[
           OverscriptBox["x", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox["5", "3"], " ", "\[ImaginaryI]", " ", 
       FormBox["e",
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["\[Gamma]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "3"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "1"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"A", "1"},
         {"y", "2"},
         {
          FormBox[
           OverscriptBox["y", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["4", "3"]}], " ", "\[ImaginaryI]", " ", 
       FormBox["e",
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["\[Gamma]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "3"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "1"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["b", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"bp", "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KB", " ", "MBP", " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KBbLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KBbRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"b", "1"},
         {
          FormBox[
           OverscriptBox["bp", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KB", " ", "MBP", " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KBbRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KBbLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["bp", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"d", "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KB", " ", "MBP", " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KBdRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KBdLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["bp", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"H", "2"},
         {"s", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KB", " ", "MBP", " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KBsRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KBsLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["c", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"H", "2"},
         {"tp", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KT", " ", "MTP", " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KTcLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KTcRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"bp", "1"},
         {
          FormBox[
           OverscriptBox["d", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KB", " ", "MBP", " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KBdLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KBdRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"bp", "1"},
         {"H", "2"},
         {
          FormBox[
           OverscriptBox["s", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KB", " ", "MBP", " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KBsLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KBsRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"H", "1"},
         {
          FormBox[
           OverscriptBox["t", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"tp", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KT", " ", "MTP", " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KTtLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KTtRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"c", "1"},
         {"H", "2"},
         {
          FormBox[
           OverscriptBox["tp", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KT", " ", "MTP", " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KTcRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KTcLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"H", "1"},
         {"t", "2"},
         {
          FormBox[
           OverscriptBox["tp", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KT", " ", "MTP", " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KTtRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KTtLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"H", "1"},
         {
          FormBox[
           OverscriptBox["tp", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"u", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KT", " ", "MTP", " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KTuRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KTuLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"H", "1"},
         {"tp", "2"},
         {
          FormBox[
           OverscriptBox["u", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KT", " ", "MTP", " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KTuLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KTuRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"bp", "1"},
         {
          FormBox[
           OverscriptBox["bp", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"G", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", 
       FormBox[
        SubscriptBox["g", "s"],
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["\[Gamma]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["T", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"a\"\>", "3"],
          TraditionalForm]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"tp", "2"},
         {
          FormBox[
           OverscriptBox["tp", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", 
       FormBox[
        SubscriptBox["g", "s"],
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["\[Gamma]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "3"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "1"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["T", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"a\"\>", "1"],
          TraditionalForm]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"x", "2"},
         {
          FormBox[
           OverscriptBox["x", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", 
       FormBox[
        SubscriptBox["g", "s"],
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["\[Gamma]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "3"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "1"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["T", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"a\"\>", "1"],
          TraditionalForm]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"y", "2"},
         {
          FormBox[
           OverscriptBox["y", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", 
       FormBox[
        SubscriptBox["g", "s"],
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["\[Gamma]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "3"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "1"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["T", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"a\"\>", "1"],
          TraditionalForm]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"b", "1"},
         {
          FormBox[
           OverscriptBox["tp", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"W", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KTtLw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KTtRw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"d", "1"},
         {
          FormBox[
           OverscriptBox["tp", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"W", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KTuLw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KTuRw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"s", "1"},
         {
          FormBox[
           OverscriptBox["tp", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"W", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KTcLw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KTcRw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"bp", "1"},
         {
          FormBox[
           OverscriptBox["u", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"W", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KBdLw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KBdRw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"c", "1"},
         {"W", "2"},
         {
          FormBox[
           OverscriptBox["x", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KX", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KXcL", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KXcR", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"t", "1"},
         {"W", "2"},
         {
          FormBox[
           OverscriptBox["x", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KX", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KXtL", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KXtR", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"u", "1"},
         {"W", "2"},
         {
          FormBox[
           OverscriptBox["x", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KX", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KXuL", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KXuR", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["b", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"tp", "2"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KTtLw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KTtRw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["bp", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"c", "2"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KBsLw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KBsRw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["bp", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"t", "2"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KBbLw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KBbRw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["bp", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"u", "2"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KBdLw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KBdRw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["c", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "2"},
         {"x", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KX", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KXcL", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KXcR", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["d", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"tp", "2"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KTuLw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KTuRw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["s", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"tp", "2"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KTcLw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KTcRw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["t", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "2"},
         {"x", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KX", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KXtL", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KXtR", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["u", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "2"},
         {"x", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KX", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KXuL", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KXuR", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"b", "1"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "2"},
         {
          FormBox[
           OverscriptBox["y", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KY", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KYbL", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KYbR", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"d", "1"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "2"},
         {
          FormBox[
           OverscriptBox["y", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KY", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KYdL", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KYdR", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"s", "1"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "2"},
         {
          FormBox[
           OverscriptBox["y", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KY", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KYsL", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KYsR", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["b", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"bp", "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KBbLz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KBbRz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"b", "1"},
         {
          FormBox[
           OverscriptBox["bp", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KBbLz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KBbRz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["bp", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"d", "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KBdLz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KBdRz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["bp", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"s", "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KBsLz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KBsRz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["c", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"tp", "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KTcLz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KTcRz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"bp", "1"},
         {
          FormBox[
           OverscriptBox["d", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KBdLz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KBdRz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"bp", "1"},
         {
          FormBox[
           OverscriptBox["s", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KBsLz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KBsRz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["t", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"tp", "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KTtLz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KTtRz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"c", "1"},
         {
          FormBox[
           OverscriptBox["tp", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KTcLz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KTcRz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"t", "1"},
         {
          FormBox[
           OverscriptBox["tp", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KTtLz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KTtRz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["tp", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"u", "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KTuLz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KTuRz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"tp", "1"},
         {
          FormBox[
           OverscriptBox["u", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KTuLz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KTuRz", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["b", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"W", "2"},
         {"y", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KY", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KYbL", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KYbR", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"bp", "1"},
         {
          FormBox[
           OverscriptBox["c", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"W", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KBsLw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KBsRw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["d", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"W", "2"},
         {"y", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KY", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KYdL", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KYdR", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["s", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"W", "2"},
         {"y", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KY", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KYsL", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KYsR", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "2"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"bp", "1"},
         {
          FormBox[
           OverscriptBox["t", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"W", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KBbLw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KBbRw", " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.5719846783263392`*^9, 3.572196742032469*^9, 
  3.573066098764782*^9, 3.573066864447011*^9, 3.5743119602757783`*^9, 
  3.574507185256295*^9, 3.5745081944181104`*^9, 3.574763460545*^9, 
  3.574764841684997*^9, 3.5750861448613863`*^9, 3.575086250920354*^9, 
  3.5750863999917836`*^9, 3.5750865728462334`*^9, 3.5751812254304996`*^9, 
  3.5751848443258505`*^9, 3.575189233808769*^9, 3.575189503004953*^9, 
  3.5810872154352956`*^9, 3.581705758824772*^9, 3.581706672652813*^9},
 FontSize->7]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sanity checks", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.5747635829149995`*^9, 3.57476358536814*^9}, {3.574763724599104*^9, 
   3.574763728890349*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell["Hermiticity", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}, {
  3.5745083801218367`*^9, 3.5745083815726395`*^9}, {3.574763732028528*^9, 
  3.574763733336603*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "LVLQ", "]"}]], "Input",
 CellChangeTimes->{{3.570637941239635*^9, 3.5706379431033716`*^9}},
 FontSize->7],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.5817066728103333`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.5817066728203344`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Starting Feynman rule calculation.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.5817066883348045`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the \
vertex...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.5817066890518956`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Found \"\>", "\[InvisibleSpace]", "\<\"12\"\>", 
    "\[InvisibleSpace]", "\<\" possible non zero vertices.\"\>"}],
   SequenceForm["Found ", "12", " possible non zero vertices."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.581706689100402*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Start calculating vertices...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.5817066891064024`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  ProgressIndicatorBox[Dynamic[PRIVATE`progress$2051]], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.581706689118404*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"12", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
   SequenceForm[12, " vertices obtained."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.5817066896819754`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"The lagrangian appears not to be hermitian.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.5817066898614984`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Non vanishing terms during the Feynman rule calculation for L - \
HC[L]:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.581706689865999*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FormBox[
         OverscriptBox["b", "\<\"-\"\>"],
         TraditionalForm], "1"},
       {"bp", "2"},
       {"H", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
       RowBox[{"(", 
        RowBox[{"MBP", "-", 
         FormBox[
          SuperscriptBox["MBP", "\[Dagger]"],
          TraditionalForm]}], ")"}], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KBbLh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"-\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KBbRh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"+\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}], "v"]}]}], "}"}], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.581706689888502*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"b", "1"},
       {
        FormBox[
         OverscriptBox["bp", "\<\"-\"\>"],
         TraditionalForm], "2"},
       {"H", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
       RowBox[{"(", 
        RowBox[{"MBP", "-", 
         FormBox[
          SuperscriptBox["MBP", "\[Dagger]"],
          TraditionalForm]}], ")"}], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KBbRh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"-\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KBbLh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"+\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}], "v"]}]}], "}"}], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.581706689895503*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FormBox[
         OverscriptBox["bp", "\<\"-\"\>"],
         TraditionalForm], "1"},
       {"d", "2"},
       {"H", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
       RowBox[{"(", 
        RowBox[{"MBP", "-", 
         FormBox[
          SuperscriptBox["MBP", "\[Dagger]"],
          TraditionalForm]}], ")"}], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KBdRh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"-\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KBdLh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"+\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}], "v"]}]}], "}"}], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.581706689904004*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FormBox[
         OverscriptBox["bp", "\<\"-\"\>"],
         TraditionalForm], "1"},
       {"H", "2"},
       {"s", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
       RowBox[{"(", 
        RowBox[{"MBP", "-", 
         FormBox[
          SuperscriptBox["MBP", "\[Dagger]"],
          TraditionalForm]}], ")"}], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KBsRh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"-\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KBsLh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"+\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}], "v"]}]}], "}"}], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.5817066899170055`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FormBox[
         OverscriptBox["c", "\<\"-\"\>"],
         TraditionalForm], "1"},
       {"H", "2"},
       {"tp", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
       RowBox[{"(", 
        RowBox[{"MTP", "-", 
         FormBox[
          SuperscriptBox["MTP", "\[Dagger]"],
          TraditionalForm]}], ")"}], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KTcLh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"-\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KTcRh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"+\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}], "v"]}]}], "}"}], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.581706689924506*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"bp", "1"},
       {
        FormBox[
         OverscriptBox["d", "\<\"-\"\>"],
         TraditionalForm], "2"},
       {"H", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
       RowBox[{"(", 
        RowBox[{"MBP", "-", 
         FormBox[
          SuperscriptBox["MBP", "\[Dagger]"],
          TraditionalForm]}], ")"}], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KBdLh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"-\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KBdRh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"+\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}], "v"]}]}], "}"}], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.58170668995551*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"bp", "1"},
       {"H", "2"},
       {
        FormBox[
         OverscriptBox["s", "\<\"-\"\>"],
         TraditionalForm], "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
       RowBox[{"(", 
        RowBox[{"MBP", "-", 
         FormBox[
          SuperscriptBox["MBP", "\[Dagger]"],
          TraditionalForm]}], ")"}], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KBsLh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"-\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KBsRh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"+\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}], "v"]}]}], "}"}], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.5817066899670115`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"H", "1"},
       {
        FormBox[
         OverscriptBox["t", "\<\"-\"\>"],
         TraditionalForm], "2"},
       {"tp", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
       RowBox[{"(", 
        RowBox[{"MTP", "-", 
         FormBox[
          SuperscriptBox["MTP", "\[Dagger]"],
          TraditionalForm]}], ")"}], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KTtLh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"-\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KTtRh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"+\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}], "v"]}]}], "}"}], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.5817066899725122`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"c", "1"},
       {"H", "2"},
       {
        FormBox[
         OverscriptBox["tp", "\<\"-\"\>"],
         TraditionalForm], "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
       RowBox[{"(", 
        RowBox[{"MTP", "-", 
         FormBox[
          SuperscriptBox["MTP", "\[Dagger]"],
          TraditionalForm]}], ")"}], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KTcRh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"-\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KTcLh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"+\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}], "v"]}]}], "}"}], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.581706689980014*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"H", "1"},
       {"t", "2"},
       {
        FormBox[
         OverscriptBox["tp", "\<\"-\"\>"],
         TraditionalForm], "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
       RowBox[{"(", 
        RowBox[{"MTP", "-", 
         FormBox[
          SuperscriptBox["MTP", "\[Dagger]"],
          TraditionalForm]}], ")"}], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KTtRh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"-\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KTtLh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"+\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}], "v"]}]}], "}"}], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.5817066899930153`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"H", "1"},
       {
        FormBox[
         OverscriptBox["tp", "\<\"-\"\>"],
         TraditionalForm], "2"},
       {"u", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
       RowBox[{"(", 
        RowBox[{"MTP", "-", 
         FormBox[
          SuperscriptBox["MTP", "\[Dagger]"],
          TraditionalForm]}], ")"}], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KTuRh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"-\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KTuLh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"+\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}], "v"]}]}], "}"}], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.581706689999016*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"H", "1"},
       {"tp", "2"},
       {
        FormBox[
         OverscriptBox["u", "\<\"-\"\>"],
         TraditionalForm], "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
       RowBox[{"(", 
        RowBox[{"MTP", "-", 
         FormBox[
          SuperscriptBox["MTP", "\[Dagger]"],
          TraditionalForm]}], ")"}], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"KTuLh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"-\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}], "+", 
         RowBox[{"KTuRh", " ", 
          FormBox[
           SubscriptBox[
            SubscriptBox["P", "\<\"+\"\>"], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "3"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}]}], ")"}]}], "v"]}]}], "}"}], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.581087218831727*^9, 3.5817057589647894`*^9, 3.5817066900045166`*^9},
 FontSize->7]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["b", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"bp", "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
         RowBox[{"(", 
          RowBox[{"MBP", "-", 
           FormBox[
            SuperscriptBox["MBP", "\[Dagger]"],
            TraditionalForm]}], ")"}], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KBbLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KBbRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"b", "1"},
         {
          FormBox[
           OverscriptBox["bp", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
         RowBox[{"(", 
          RowBox[{"MBP", "-", 
           FormBox[
            SuperscriptBox["MBP", "\[Dagger]"],
            TraditionalForm]}], ")"}], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KBbRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KBbLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["bp", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"d", "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
         RowBox[{"(", 
          RowBox[{"MBP", "-", 
           FormBox[
            SuperscriptBox["MBP", "\[Dagger]"],
            TraditionalForm]}], ")"}], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KBdRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KBdLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["bp", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"H", "2"},
         {"s", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
         RowBox[{"(", 
          RowBox[{"MBP", "-", 
           FormBox[
            SuperscriptBox["MBP", "\[Dagger]"],
            TraditionalForm]}], ")"}], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KBsRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KBsLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["c", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"H", "2"},
         {"tp", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
         RowBox[{"(", 
          RowBox[{"MTP", "-", 
           FormBox[
            SuperscriptBox["MTP", "\[Dagger]"],
            TraditionalForm]}], ")"}], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KTcLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KTcRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"bp", "1"},
         {
          FormBox[
           OverscriptBox["d", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
         RowBox[{"(", 
          RowBox[{"MBP", "-", 
           FormBox[
            SuperscriptBox["MBP", "\[Dagger]"],
            TraditionalForm]}], ")"}], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KBdLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KBdRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"bp", "1"},
         {"H", "2"},
         {
          FormBox[
           OverscriptBox["s", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KB", " ", 
         RowBox[{"(", 
          RowBox[{"MBP", "-", 
           FormBox[
            SuperscriptBox["MBP", "\[Dagger]"],
            TraditionalForm]}], ")"}], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KBsLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KBsRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"H", "1"},
         {
          FormBox[
           OverscriptBox["t", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"tp", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
         RowBox[{"(", 
          RowBox[{"MTP", "-", 
           FormBox[
            SuperscriptBox["MTP", "\[Dagger]"],
            TraditionalForm]}], ")"}], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KTtLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KTtRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"c", "1"},
         {"H", "2"},
         {
          FormBox[
           OverscriptBox["tp", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
         RowBox[{"(", 
          RowBox[{"MTP", "-", 
           FormBox[
            SuperscriptBox["MTP", "\[Dagger]"],
            TraditionalForm]}], ")"}], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KTcRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KTcLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "1"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"H", "1"},
         {"t", "2"},
         {
          FormBox[
           OverscriptBox["tp", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
         RowBox[{"(", 
          RowBox[{"MTP", "-", 
           FormBox[
            SuperscriptBox["MTP", "\[Dagger]"],
            TraditionalForm]}], ")"}], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KTtRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KTtLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"H", "1"},
         {
          FormBox[
           OverscriptBox["tp", "\<\"-\"\>"],
           TraditionalForm], "2"},
         {"u", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
         RowBox[{"(", 
          RowBox[{"MTP", "-", 
           FormBox[
            SuperscriptBox["MTP", "\[Dagger]"],
            TraditionalForm]}], ")"}], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KTuRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KTuLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"H", "1"},
         {"tp", "2"},
         {
          FormBox[
           OverscriptBox["u", "\<\"-\"\>"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "KT", " ", 
         RowBox[{"(", 
          RowBox[{"MTP", "-", 
           FormBox[
            SuperscriptBox["MTP", "\[Dagger]"],
            TraditionalForm]}], ")"}], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KTuLh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"-\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm]}]],
             TraditionalForm]}], "+", 
           RowBox[{"KTuRh", " ", 
            FormBox[
             SubscriptBox[
              SubscriptBox["P", "\<\"+\"\>"], 
              RowBox[{
               FormBox[
                SubscriptBox["\<\"s\"\>", "3"],
                TraditionalForm], ",", 
               FormBox[
                SubscriptBox["\<\"s\"\>", "2"],
                TraditionalForm]}]],
             TraditionalForm]}]}], ")"}]}], "v"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.571984733741376*^9, 3.5721967642922955`*^9, 
  3.5730661334836903`*^9, 3.5730668970701537`*^9, 3.5743119935818367`*^9, 
  3.574507259933626*^9, 3.574508216164549*^9, 3.5747635121739535`*^9, 
  3.574764858812977*^9, 3.575086592161686*^9, 3.575181243760827*^9, 
  3.575184862126611*^9, 3.575189256080598*^9, 3.5751895218418446`*^9, 
  3.5810872399704113`*^9, 3.5817057757914267`*^9, 3.581706690041521*^9},
 FontSize->7]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Partial Widths", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}, {
  3.5745083801218367`*^9, 3.5745083815726395`*^9}, {3.574763732028528*^9, 
  3.574763733336603*^9}, {3.5747639342440944`*^9, 3.574763936407218*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Widths", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"FeynmanRules", "[", "LVLQ", "]"}], "//", "FlavorExpansion"}], "//",
     "ComputeWidths"}]}], ";"}], "\[IndentingNewLine]", 
 ButtonBox["FR$PartialWidths",
  BaseStyle->"InformationLink",
  ButtonData:>{"Info3574771045-2097307", {"FR$PartialWidths", "FeynRules`"}},
  ButtonNote->"FeynRules`"], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Verts", "=", 
     RowBox[{"FeynmanRules", "[", "LVLQ", "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"VertsExp", "=", 
     RowBox[{"FlavorExpansion", "[", "Verts", "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Results", "=", 
     RowBox[{"ComputeWidths", "[", "VertsExp", "]"}]}]}], 
   "\[IndentingNewLine]", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.574317723280984*^9, 3.5743177571712875`*^9}, {
  3.5743177993721457`*^9, 3.5743178016929407`*^9}, {3.57431788366835*^9, 
  3.574317884254425*^9}, {3.5745083532585897`*^9, 3.5745083534769897`*^9}, {
  3.57476379184595*^9, 3.5747638529254436`*^9}, {3.574763906929532*^9, 
  3.574763921716378*^9}},
 FontSize->8],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"Starting Feynman rule calculation.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706690160036*^9}],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the \
vertex...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706691668728*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Found \"\>", "\[InvisibleSpace]", "\<\"56\"\>", 
    "\[InvisibleSpace]", "\<\" possible non zero vertices.\"\>"}],
   SequenceForm["Found ", "56", " possible non zero vertices."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706691774741*^9}],

Cell[BoxData[
 FormBox["\<\"Start calculating vertices...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066917797422`*^9}],

Cell[BoxData[
 FormBox[
  ProgressIndicatorBox[Dynamic[PRIVATE`progress$2413]], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066917907434`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"56", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
   SequenceForm[56, " vertices obtained."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066938275023`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066938345027`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "1"}],
   SequenceForm["Vertex ", 1],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706693842004*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "A"}],
   SequenceForm["Particle ", 1, " : ", "Vector", " , ", $CellContext`A],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066938490047`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706693868007*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066938720074`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066938755083`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "3"]}], " ", "\[ImaginaryI]", " ", 
   FormBox["e",
    TraditionalForm], " ", 
   FormBox[
    SubscriptBox["\[Delta]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"i\"\>", "2"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"i\"\>", "3"],
       TraditionalForm]}]],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"s\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"s\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"\[Mu]\"\>", "1"],
      TraditionalForm]],
    TraditionalForm]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066938800087`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.58170669389051*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "2"}],
   SequenceForm["Vertex ", 2],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066938935103`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "A"}],
   SequenceForm["Particle ", 1, " : ", "Vector", " , ", $CellContext`A],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706693897011*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066939005113`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066939040117`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706693913513*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", 
   FormBox["e",
    TraditionalForm], " ", 
   FormBox[
    SubscriptBox["\[Delta]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"i\"\>", "2"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"i\"\>", "3"],
       TraditionalForm]}]],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"s\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"s\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"\[Mu]\"\>", "1"],
      TraditionalForm]],
    TraditionalForm]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066939165134`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706693920014*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "3"}],
   SequenceForm["Vertex ", 3],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706693923014*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "A"}],
   SequenceForm["Particle ", 1, " : ", "Vector", " , ", $CellContext`A],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706693926015*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "x"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`x],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066939290147`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["x", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`xbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706693937516*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706693941016*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["5", "3"], " ", "\[ImaginaryI]", " ", 
   FormBox["e",
    TraditionalForm], " ", 
   FormBox[
    SubscriptBox["\[Delta]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"i\"\>", "2"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"i\"\>", "3"],
       TraditionalForm]}]],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"s\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"s\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"\[Mu]\"\>", "1"],
      TraditionalForm]],
    TraditionalForm]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066939440165`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066939475174`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "4"}],
   SequenceForm["Vertex ", 4],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066939510174`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "A"}],
   SequenceForm["Particle ", 1, " : ", "Vector", " , ", $CellContext`A],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706693954018*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "y"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`y],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066939630194`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["y", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`ybar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066939660196`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.58170669396952*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["4", "3"]}], " ", "\[ImaginaryI]", " ", 
   FormBox["e",
    TraditionalForm], " ", 
   FormBox[
    SubscriptBox["\[Delta]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"i\"\>", "2"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"i\"\>", "3"],
       TraditionalForm]}]],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"s\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"s\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"\[Mu]\"\>", "1"],
      TraditionalForm]],
    TraditionalForm]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706693974021*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706693979021*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "5"}],
   SequenceForm["Vertex ", 5],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066939890223`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["b", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066939920225`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706693996524*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 3, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706693999524*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066940035243`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbLh", " ", "MBP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "2"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "2"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbRh", " ", "MBP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "2"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "2"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066940135255`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066940180264`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "6"}],
   SequenceForm["Vertex ", 6],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694021527*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "b"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`b],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694026027*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694031028*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 3, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694039029*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694042529*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbRh", " ", "MBP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "2"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "2"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "1"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbLh", " ", "MBP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "2"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "2"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "1"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066940455294`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066940505304`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "7"}],
   SequenceForm["Vertex ", 7],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694055531*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066940645323`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "d"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`d],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066940680323`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 3, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694071033*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066940750337`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdRh", " ", "MBP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "2"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "2"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdLh", " ", "MBP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "2"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "2"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066940800343`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694089535*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "8"}],
   SequenceForm["Vertex ", 8],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066940930357`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694096536*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 2, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066941000366`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "s"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", FeynRules`s],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694104537*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066941140385`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsRh", " ", "MBP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsLh", " ", "MBP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066941170387`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694121539*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "9"}],
   SequenceForm["Vertex ", 9],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.58170669412454*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["c", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`cbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066941285405`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 2, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066941380415`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694141542*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066941450424`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcLh", " ", "MTP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcRh", " ", "MTP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066941480427`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066941540437`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "10"}],
   SequenceForm["Vertex ", 10],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694164045*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066941675453`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["d", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`dbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066941720457`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 3, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066941760464`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694182047*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdLh", " ", "MBP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "2"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "2"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "1"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdRh", " ", "MBP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "2"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "2"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "1"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066941915483`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066941985493`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "11"}],
   SequenceForm["Vertex ", 11],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.58170669420355*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694213051*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 2, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694216051*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["s", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`sbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694219052*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694222052*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsLh", " ", "MBP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "3"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "1"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsRh", " ", "MBP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "3"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "1"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066942255526`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066942405543`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "12"}],
   SequenceForm["Vertex ", 12],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694243555*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 1, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066942465553`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["t", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066942495556`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066942535563`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066942635574`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtLh", " ", "MTP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "2"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "2"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtRh", " ", "MTP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "2"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "2"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694267058*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694271058*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "13"}],
   SequenceForm["Vertex ", 13],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694274059*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "c"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`c],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066942770596`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 2, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.58170669428656*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694290061*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066942930613`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcRh", " ", "MTP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "1"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "3"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "1"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcLh", " ", "MTP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "1"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "3"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "1"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694297062*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066943020625`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "14"}],
   SequenceForm["Vertex ", 14],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694312564*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 1, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694315564*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "t"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`t],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694319064*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694322065*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066943255653`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtRh", " ", "MTP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "2"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "3"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "2"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtLh", " ", "MTP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "2"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "3"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "2"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066943300657`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694338567*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "15"}],
   SequenceForm["Vertex ", 15],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066943420677`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 1, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694345068*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694348068*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "u"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", FeynRules`u],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066943515687`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694356069*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuRh", " ", "MTP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "2"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "2"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuLh", " ", "MTP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "2"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "2"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066943650703`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066943695707`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "16"}],
   SequenceForm["Vertex ", 16],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694372571*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Scalar\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "H"}],
   SequenceForm["Particle ", 1, " : ", "Scalar", " , ", FeynRules`H],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694376072*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066943805723`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["u", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`ubar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066943890734`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066943920736`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuLh", " ", "MTP", " ", 
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"i\"\>", "2"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"i\"\>", "3"],
          TraditionalForm]}]],
       TraditionalForm], " ", 
      FormBox[
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         FormBox[
          SubscriptBox["\<\"s\"\>", "3"],
          TraditionalForm], ",", 
         FormBox[
          SubscriptBox["\<\"s\"\>", "2"],
          TraditionalForm]}]],
       TraditionalForm]}], "v"]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuRh", " ", "MTP", " ", 
     FormBox[
      SubscriptBox["\[Delta]", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"i\"\>", "2"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"i\"\>", "3"],
         TraditionalForm]}]],
      TraditionalForm], " ", 
     FormBox[
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"s\"\>", "3"],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox["\<\"s\"\>", "2"],
         TraditionalForm]}]],
      TraditionalForm]}], "v"]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694395074*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066943995748`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "17"}],
   SequenceForm["Vertex ", 17],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066944055758`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066944130764`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066944160767`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "G"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", FeynRules`G],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694419077*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066944220777`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"\[ImaginaryI]", " ", 
   FormBox[
    SubscriptBox["g", "s"],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["T", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"i\"\>", "2"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"i\"\>", "1"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"a\"\>", "3"],
      TraditionalForm]],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"s\"\>", "2"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"s\"\>", "1"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"\[Mu]\"\>", "3"],
      TraditionalForm]],
    TraditionalForm]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694425078*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694429078*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "18"}],
   SequenceForm["Vertex ", 18],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066944385796`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "G"}],
   SequenceForm["Particle ", 1, " : ", "Vector", " , ", FeynRules`G],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.58170669444158*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.58170669444458*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066944470806`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694450081*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"\[ImaginaryI]", " ", 
   FormBox[
    SubscriptBox["g", "s"],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["T", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"i\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"i\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"a\"\>", "1"],
      TraditionalForm]],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"s\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"s\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"\[Mu]\"\>", "1"],
      TraditionalForm]],
    TraditionalForm]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694453582*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694463583*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "19"}],
   SequenceForm["Vertex ", 19],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066944665833`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "G"}],
   SequenceForm["Particle ", 1, " : ", "Vector", " , ", FeynRules`G],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066944695835`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "x"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`x],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694472584*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["x", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`xbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066944755845`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694479085*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"\[ImaginaryI]", " ", 
   FormBox[
    SubscriptBox["g", "s"],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["T", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"i\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"i\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"a\"\>", "1"],
      TraditionalForm]],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"s\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"s\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"\[Mu]\"\>", "1"],
      TraditionalForm]],
    TraditionalForm]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694487086*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066944905863`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "20"}],
   SequenceForm["Vertex ", 20],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066944935865`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "G"}],
   SequenceForm["Particle ", 1, " : ", "Vector", " , ", FeynRules`G],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694496587*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "y"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`y],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694499587*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["y", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`ybar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694503088*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694514089*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"\[ImaginaryI]", " ", 
   FormBox[
    SubscriptBox["g", "s"],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["T", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"i\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"i\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"a\"\>", "1"],
      TraditionalForm]],
    TraditionalForm], " ", 
   FormBox[
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{
      FormBox[
       SubscriptBox["\<\"s\"\>", "3"],
       TraditionalForm], ",", 
      FormBox[
       SubscriptBox["\<\"s\"\>", "2"],
       TraditionalForm]}], 
     FormBox[
      SubscriptBox["\<\"\[Mu]\"\>", "1"],
      TraditionalForm]],
    TraditionalForm]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066945165896`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.58170669452109*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "21"}],
   SequenceForm["Vertex ", 21],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066945240903`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["b", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066945275908`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694536592*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "y"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", FeynRules`y],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066945400925`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066945430927`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYbL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYbR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694546093*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066945505943`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "22"}],
   SequenceForm["Vertex ", 22],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066945540943`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694562095*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["c", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`cbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694565096*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694568596*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694571596*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066945740967`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066945790977`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "23"}],
   SequenceForm["Vertex ", 23],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066945880985`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["d", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`dbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694591099*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694594099*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "y"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", FeynRules`y],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066945971*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066945996*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYdL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYdR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066946031003`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694615102*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "24"}],
   SequenceForm["Vertex ", 24],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066946186028`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["s", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`sbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694621603*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066946246033`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "y"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", FeynRules`y],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066946281033`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694638105*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYsL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYsR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066946411057`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694646106*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "25"}],
   SequenceForm["Vertex ", 25],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066946491065`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694652607*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["t", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694662108*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066946656084`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694668109*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694671109*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066946756096`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "26"}],
   SequenceForm["Vertex ", 26],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694686611*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "b"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`b],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066946896114`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066946926117`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066946956124`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066946986127`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066947046137`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066947121143`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "27"}],
   SequenceForm["Vertex ", 27],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694715615*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "d"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`d],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066947191153`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066947221155`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066947306166`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694738618*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694742118*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694748119*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "28"}],
   SequenceForm["Vertex ", 28],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066947531195`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "s"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`s],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066947631207`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066947686214`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694772122*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066947771225`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694788624*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066947941246`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "29"}],
   SequenceForm["Vertex ", 29],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694797125*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066948016253`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["u", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`ubar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694807126*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694816128*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694819128*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066948226285`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694829129*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "30"}],
   SequenceForm["Vertex ", 30],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066948391304`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "c"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`c],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694864134*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066948691344`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["x", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`xbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694873635*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694879636*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXcL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXcR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694891137*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694896638*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "31"}],
   SequenceForm["Vertex ", 31],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066949016385`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "t"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`t],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.58170669491364*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066949176407`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["x", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`xbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066949216413`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066949261417`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXtL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXtR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066949316425`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066949436436`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "32"}],
   SequenceForm["Vertex ", 32],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066949491444`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "u"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`u],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066949541454`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "W"}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", FeynRules`W],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694965146*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["x", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`xbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066949691467`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694974148*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXuL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXuR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066949816484`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.58170669499165*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "33"}],
   SequenceForm["Vertex ", 33],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066949956503`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["b", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706694999651*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066950051517`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066950156527`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066950206537`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695025154*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695037656*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "34"}],
   SequenceForm["Vertex ", 34],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066950416565`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066950466566`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "c"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`c],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066950526576`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066950641594`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066950691595`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.58170669507316*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066950791607`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "35"}],
   SequenceForm["Vertex ", 35],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066950891623`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066950931625`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "t"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`t],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695097163*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066951016636`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066951056643`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066951151657`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066951221666`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "36"}],
   SequenceForm["Vertex ", 36],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695128167*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066951396685`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "u"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`u],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066951456695`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066951516705`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695163172*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066951671724`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695173173*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "37"}],
   SequenceForm["Vertex ", 37],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066951786737`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["c", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`cbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695190175*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066951941757`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "x"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", FeynRules`x],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695198676*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066952051773`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXcL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXcR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066952146783`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066952206793`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "38"}],
   SequenceForm["Vertex ", 38],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.58170669522468*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["d", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`dbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066952301803`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066952401814`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695244182*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066952481823`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695253683*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066952641845`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "39"}],
   SequenceForm["Vertex ", 39],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695269185*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["s", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`sbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066952731857`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066952781863`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066952896876`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066952941885`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcLw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcRw", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066952996893`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066953126907`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "40"}],
   SequenceForm["Vertex ", 40],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695317691*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["t", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`tbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066953216915`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066953276925`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "x"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", FeynRules`x],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695338694*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695344695*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXtL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXtR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695349695*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066953631973`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "41"}],
   SequenceForm["Vertex ", 41],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066953671975`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["u", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`ubar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695371698*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695378199*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "x"}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", FeynRules`x],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066953887005`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695392701*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXuL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KX", " ", "KXuR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695396701*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066954042025`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "42"}],
   SequenceForm["Vertex ", 42],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066954142036`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "b"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`b],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066954207044`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066954267054`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["y", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`ybar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066954377065`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066954422073`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYbL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYbR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695447708*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066954617095`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "43"}],
   SequenceForm["Vertex ", 43],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066954657097`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "d"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`d],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066954697104`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695473711*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["y", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`ybar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695480712*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695489713*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYdL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYdR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066954937134`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066954987144`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "44"}],
   SequenceForm["Vertex ", 44],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066955042152`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "s"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`s],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695514716*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     SuperscriptBox["W", "\[Dagger]"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Vector", " , ", $CellContext`Wbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066955192165`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["y", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 3, " : ", "Dirac", " , ", $CellContext`ybar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066955237174`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695528718*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYsL", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KY", " ", "KYsR", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "3"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "2"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "3"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066955407195`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695549721*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "45"}],
   SequenceForm["Vertex ", 45],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066955552216`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["b", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066955652227`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066955712233`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695576724*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066955887256`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695593726*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695599727*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "46"}],
   SequenceForm["Vertex ", 46],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066956047277`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "b"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`b],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695615229*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066956192293`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066956237297`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695628231*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBbRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695638232*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695645733*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "47"}],
   SequenceForm["Vertex ", 47],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066956502333`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066956547337`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "d"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`d],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066956657352`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695671236*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695675737*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695681237*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695706741*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "48"}],
   SequenceForm["Vertex ", 48],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695712241*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["bp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695717742*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "s"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`s],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066957232428`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695734744*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695740245*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066957442455`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066957512465`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "49"}],
   SequenceForm["Vertex ", 49],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066957612476`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["c", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`cbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066957667484`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695772249*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066957772493`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695788751*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695794752*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695801253*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "50"}],
   SequenceForm["Vertex ", 50],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066958072534`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066958127537`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["d", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`dbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695817255*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695822255*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695826256*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBdRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066958317566`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066958442583`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "51"}],
   SequenceForm["Vertex ", 51],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066958482585`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "bp"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`bp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066958527594`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["s", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`sbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066958627605`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066958782625`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066958882637`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KB", " ", "KBsRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066958922644`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695898265*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "52"}],
   SequenceForm["Vertex ", 52],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066959027653`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["t", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`tbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066959162674`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695920268*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066959242687`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695928769*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.58170669593927*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695944771*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "53"}],
   SequenceForm["Vertex ", 53],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066959487715`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "c"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`c],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695962273*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066959662733`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695970774*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066959742746`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTcRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695986276*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706695992777*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "54"}],
   SequenceForm["Vertex ", 54],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066959967775`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "t"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", FeynRules`t],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706696000278*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066960127797`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.58170669601678*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066960207806`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTtRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706696024781*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066960362825`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "55"}],
   SequenceForm["Vertex ", 55],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706696040783*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["tp", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`tpbar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066960447836`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "u"}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", FeynRules`u],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706696048284*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066960532846`*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706696063286*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066960672865`*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706696072287*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Vertex \"\>", "\[InvisibleSpace]", "56"}],
   SequenceForm["Vertex ", 56],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706696076788*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "tp"}],
   SequenceForm["Particle ", 1, " : ", "Dirac", " , ", $CellContext`tp],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066960877895`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Dirac\"\>", 
    "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", 
    FormBox[
     OverscriptBox["u", "\<\"-\"\>"],
     TraditionalForm]}],
   SequenceForm["Particle ", 2, " : ", "Dirac", " , ", $CellContext`ubar],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.58170669609229*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Particle \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", "\<\"Vector\"\>",
     "\[InvisibleSpace]", "\<\" , \"\>", "\[InvisibleSpace]", "Z"}],
   SequenceForm["Particle ", 3, " : ", "Vector", " , ", $CellContext`Z],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.58170669609629*^9}],

Cell[BoxData[
 FormBox["\<\"Vertex:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066960997906`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuLz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"-\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "KT", " ", "KTuRz", " ", 
    FormBox[
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"i\"\>", "1"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"i\"\>", "2"],
        TraditionalForm]}]],
     TraditionalForm], " ", 
    FormBox[
     SubscriptBox[
      RowBox[{
       FormBox[
        SuperscriptBox["\[Gamma]", 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], ".", 
       FormBox[
        SubscriptBox["P", "\<\"+\"\>"],
        TraditionalForm]}], 
      RowBox[{
       FormBox[
        SubscriptBox["\<\"s\"\>", "2"],
        TraditionalForm], ",", 
       FormBox[
        SubscriptBox["\<\"s\"\>", "1"],
        TraditionalForm]}]],
     TraditionalForm]}]}], TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.581706696111292*^9}],

Cell[BoxData[
 FormBox["\<\"(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \
* * * *)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.581705775919442*^9, 3.5817066961167927`*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  ButtonBox["FR$PartialWidths",
   Appearance->Automatic,
   BaseStyle->"InformationLink",
   ButtonData:>{"Info3574771045-2097307", {"FR$PartialWidths", "FeynRules`"}},
   
   ButtonNote->"FeynRules`",
   Evaluator->Automatic,
   Method->"Preemptive"], TraditionalForm]], "Output",
 CellChangeTimes->{3.574763861772949*^9, 3.574764868977558*^9, 
  3.5750866033956127`*^9, 3.575181249516058*^9, 3.575184870442667*^9, 
  3.5751892624494066`*^9, 3.5751895274715595`*^9, 3.5817057819677105`*^9, 
  3.581706696121293*^9},
 FontSize->6]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Check if the quadratic parts are diagonal\
\>", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}, {
  3.5745083801218367`*^9, 3.5745083815726395`*^9}, {3.574763732028528*^9, 
  3.574763733336603*^9}, {3.5747640154917417`*^9, 3.574764021864106*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"CheckDiagonalQuadraticTerms", "[", "LVLQ", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"CheckDiagonalKineticTerms", "[", "LVLQ", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"CheckDiagonalMassTerms", "[", "LVLQ", "]"}]}], "Input",
 CellChangeTimes->{{3.57476402298317*^9, 3.574764081076493*^9}, {
   3.5747641281091833`*^9, 3.574764128265192*^9}, 3.5747641693945446`*^9},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Neglecting all terms with more than \"\>", 
    "\[InvisibleSpace]", "\<\"2\"\>", 
    "\[InvisibleSpace]", "\<\" particles.\"\>"}],
   SequenceForm["Neglecting all terms with more than ", "2", " particles."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.5747640598952813`*^9, 3.574764083165612*^9}, 
   3.5747641311033545`*^9, 3.5747641716836753`*^9, 3.5747648707966623`*^9, 
   3.5750866054493732`*^9, 3.5751812497370863`*^9, 3.5751848706191893`*^9, 
   3.5751892626399307`*^9, 3.575189527638081*^9, 3.58108724428996*^9, 
   3.581705782153234*^9, 3.581706696267812*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Neglecting all terms with less than \"\>", 
    "\[InvisibleSpace]", "\<\"2\"\>", 
    "\[InvisibleSpace]", "\<\" particles.\"\>"}],
   SequenceForm["Neglecting all terms with less than ", "2", " particles."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.5747640598952813`*^9, 3.574764083165612*^9}, 
   3.5747641311033545`*^9, 3.5747641716836753`*^9, 3.5747648707966623`*^9, 
   3.5750866054493732`*^9, 3.5751812497370863`*^9, 3.5751848706191893`*^9, 
   3.5751892626399307`*^9, 3.575189527638081*^9, 3.58108724428996*^9, 
   3.581705782153234*^9, 3.581706696306317*^9}],

Cell[BoxData[
 FormBox["\<\"All quadratic terms are diagonal.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{{3.5747640598952813`*^9, 3.574764083165612*^9}, 
   3.5747641311033545`*^9, 3.5747641716836753`*^9, 3.5747648707966623`*^9, 
   3.5750866054493732`*^9, 3.5751812497370863`*^9, 3.5751848706191893`*^9, 
   3.5751892626399307`*^9, 3.575189527638081*^9, 3.58108724428996*^9, 
   3.581705782153234*^9, 3.5817066963663244`*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox["True", TraditionalForm]], "Output",
 CellChangeTimes->{{3.574764059942284*^9, 3.574764083212615*^9}, 
   3.574764131147357*^9, 3.5747641717246776`*^9, 3.5747648708396645`*^9, 
   3.575086605480377*^9, 3.575181249837099*^9, 3.575184870733204*^9, 
   3.575189262769447*^9, 3.575189527747095*^9, 3.5810872443919725`*^9, 
   3.5817057822682486`*^9, 3.581706696371825*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Neglecting all terms with more than \"\>", 
    "\[InvisibleSpace]", "\<\"2\"\>", 
    "\[InvisibleSpace]", "\<\" particles.\"\>"}],
   SequenceForm["Neglecting all terms with more than ", "2", " particles."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.5747640598952813`*^9, 3.574764083165612*^9}, 
   3.5747641311033545`*^9, 3.5747641716836753`*^9, 3.5747648707966623`*^9, 
   3.5750866054493732`*^9, 3.5751812497370863`*^9, 3.5751848706191893`*^9, 
   3.5751892626399307`*^9, 3.575189527638081*^9, 3.58108724428996*^9, 
   3.581705782153234*^9, 3.581706696457836*^9}],

Cell[BoxData[
 FormBox["\<\"All kinetic terms are diagonal.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{{3.5747640598952813`*^9, 3.574764083165612*^9}, 
   3.5747641311033545`*^9, 3.5747641716836753`*^9, 3.5747648707966623`*^9, 
   3.5750866054493732`*^9, 3.5751812497370863`*^9, 3.5751848706191893`*^9, 
   3.5751892626399307`*^9, 3.575189527638081*^9, 3.58108724428996*^9, 
   3.581705782153234*^9, 3.581706696557849*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox["True", TraditionalForm]], "Output",
 CellChangeTimes->{{3.574764059942284*^9, 3.574764083212615*^9}, 
   3.574764131147357*^9, 3.5747641717246776`*^9, 3.5747648708396645`*^9, 
   3.575086605480377*^9, 3.575181249837099*^9, 3.575184870733204*^9, 
   3.575189262769447*^9, 3.575189527747095*^9, 3.5810872443919725`*^9, 
   3.5817057822682486`*^9, 3.581706696561849*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Neglecting all terms with more than \"\>", 
    "\[InvisibleSpace]", "\<\"2\"\>", 
    "\[InvisibleSpace]", "\<\" particles.\"\>"}],
   SequenceForm["Neglecting all terms with more than ", "2", " particles."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.5747640598952813`*^9, 3.574764083165612*^9}, 
   3.5747641311033545`*^9, 3.5747641716836753`*^9, 3.5747648707966623`*^9, 
   3.5750866054493732`*^9, 3.5751812497370863`*^9, 3.5751848706191893`*^9, 
   3.5751892626399307`*^9, 3.575189527638081*^9, 3.58108724428996*^9, 
   3.581705782153234*^9, 3.58170669664686*^9}],

Cell[BoxData[
 FormBox["\<\"All mass terms are diagonal.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.5747640598952813`*^9, 3.574764083165612*^9}, 
   3.5747641311033545`*^9, 3.5747641716836753`*^9, 3.5747648707966623`*^9, 
   3.5750866054493732`*^9, 3.5751812497370863`*^9, 3.5751848706191893`*^9, 
   3.5751892626399307`*^9, 3.575189527638081*^9, 3.58108724428996*^9, 
   3.581705782153234*^9, 3.5817066967493734`*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox["True", TraditionalForm]], "Output",
 CellChangeTimes->{{3.574764059942284*^9, 3.574764083212615*^9}, 
   3.574764131147357*^9, 3.5747641717246776`*^9, 3.5747648708396645`*^9, 
   3.575086605480377*^9, 3.575181249837099*^9, 3.575184870733204*^9, 
   3.575189262769447*^9, 3.575189527747095*^9, 3.5810872443919725`*^9, 
   3.5817057822682486`*^9, 3.581706696753874*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Check normalisation & mass spectrum\
\>", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}, {
  3.5745083801218367`*^9, 3.5745083815726395`*^9}, {3.574763732028528*^9, 
  3.574763733336603*^9}, {3.5747640154917417`*^9, 3.574764021864106*^9}, {
  3.574764161644101*^9, 3.5747641663523703`*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"CheckKineticTermNormalisation", "[", "LVLQ", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"CheckMassSpectrum", "[", "LVLQ", "]"}]}], "Input",
 CellChangeTimes->{{3.5747641591359577`*^9, 3.574764186922547*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Neglecting all terms with more than \"\>", 
    "\[InvisibleSpace]", "\<\"2\"\>", 
    "\[InvisibleSpace]", "\<\" particles.\"\>"}],
   SequenceForm["Neglecting all terms with more than ", "2", " particles."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.5810872491090717`*^9, 
  3.5817057828018165`*^9, 3.5817066968828897`*^9}],

Cell[BoxData[
 FormBox["\<\"All kinetic terms are diagonal.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.5810872491090717`*^9, 
  3.5817057828018165`*^9, 3.5817066969588995`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Neglecting all terms with more than \"\>", 
    "\[InvisibleSpace]", "\<\"2\"\>", 
    "\[InvisibleSpace]", "\<\" particles.\"\>"}],
   SequenceForm["Neglecting all terms with more than ", "2", " particles."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.5810872491090717`*^9, 
  3.5817057828018165`*^9, 3.5817066970499115`*^9}],

Cell[BoxData[
 FormBox["\<\"All kinetic terms are correctly normalized.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.5810872491090717`*^9, 
  3.5817057828018165`*^9, 3.581706697148924*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox["True", TraditionalForm]], "Output",
 CellChangeTimes->{3.5747641905887566`*^9, 3.5747648783860965`*^9, 
  3.575086613315872*^9, 3.5751812506111975`*^9, 3.5751848715123034`*^9, 
  3.575189263681563*^9, 3.575189528881239*^9, 3.5810872495036216`*^9, 
  3.5817057830898533`*^9, 3.5817066971529245`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Neglecting all terms with more than \"\>", 
    "\[InvisibleSpace]", "\<\"2\"\>", 
    "\[InvisibleSpace]", "\<\" particles.\"\>"}],
   SequenceForm["Neglecting all terms with more than ", "2", " particles."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.5810872491090717`*^9, 
  3.5817057828018165`*^9, 3.5817066972484365`*^9}],

Cell[BoxData[
 FormBox["\<\"All mass terms are diagonal.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.5810872491090717`*^9, 
  3.5817057828018165`*^9, 3.5817066973474493`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Neglecting all terms with more than \"\>", 
    "\[InvisibleSpace]", "\<\"2\"\>", 
    "\[InvisibleSpace]", "\<\" particles.\"\>"}],
   SequenceForm["Neglecting all terms with more than ", "2", " particles."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.5810872491090717`*^9, 
  3.5817057828018165`*^9, 3.5817066974389606`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Warning: non numerical value encountered for \"\>", 
    "\[InvisibleSpace]", "\<\"{bp, bpbar}\"\>", 
    "\[InvisibleSpace]", "\<\". Unable to get numerical value.\"\>"}],
   SequenceForm[
   "Warning: non numerical value encountered for ", "{bp, bpbar}", 
    ". Unable to get numerical value."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.5810872491090717`*^9, 
  3.5817057828018165`*^9, 3.5817066975704775`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Warning: non numerical value encountered for \"\>", 
    "\[InvisibleSpace]", "\<\"{tp, tpbar}\"\>", 
    "\[InvisibleSpace]", "\<\". Unable to get numerical value.\"\>"}],
   SequenceForm[
   "Warning: non numerical value encountered for ", "{tp, tpbar}", 
    ". Unable to get numerical value."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.5810872491090717`*^9, 
  3.5817057828018165`*^9, 3.581706697574478*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Warning: non numerical value encountered for \"\>", 
    "\[InvisibleSpace]", "\<\"{x, xbar}\"\>", 
    "\[InvisibleSpace]", "\<\". Unable to get numerical value.\"\>"}],
   SequenceForm[
   "Warning: non numerical value encountered for ", "{x, xbar}", 
    ". Unable to get numerical value."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.5810872491090717`*^9, 
  3.5817057828018165`*^9, 3.5817066975789785`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Warning: non numerical value encountered for \"\>", 
    "\[InvisibleSpace]", "\<\"{y, ybar}\"\>", 
    "\[InvisibleSpace]", "\<\". Unable to get numerical value.\"\>"}],
   SequenceForm[
   "Warning: non numerical value encountered for ", "{y, ybar}", 
    ". Unable to get numerical value."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.5810872491090717`*^9, 
  3.5817057828018165`*^9, 3.58170669759098*^9}],

Cell[BoxData[
 FormBox["\<\"Getting mass spectrum.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.5810872491090717`*^9, 
  3.5817057828018165`*^9, 3.5817066975944805`*^9}],

Cell[BoxData[
 FormBox["\<\"Checking for less then 0.1% agreement with model file values.\"\
\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.5810872491090717`*^9, 
  3.5817057828018165`*^9, 3.5817066975984807`*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  InterpretationBox[GridBox[{
     {"\<\"Particle\"\>", "\<\"Analytic value\"\>", "\<\"Numerical \
value\"\>", "\<\"Model-file value\"\>", "\<\"\"\>"},
     {"bp", 
      RowBox[{"MBP", ".", "1"}], 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Im", "(", 
          RowBox[{"NumericalValue", "(", 
           RowBox[{"MBP", ".", "1"}], ")"}], ")"}], "<", "1.`*^-13"}], ",", 
        RowBox[{"Re", "(", 
         RowBox[{"NumericalValue", "(", 
          RowBox[{"MBP", ".", "1"}], ")"}], ")"}]}], "]"}], "600.`", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Im", "(", 
              RowBox[{"NumericalValue", "(", 
               RowBox[{"MBP", ".", "1"}], ")"}], ")"}], "<", "1.`*^-13"}], 
            ",", 
            RowBox[{"Re", "(", 
             RowBox[{"NumericalValue", "(", 
              RowBox[{"MBP", ".", "1"}], ")"}], ")"}]}], "]"}], ">", 
          "599.4`"}], "\[And]", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Im", "(", 
              RowBox[{"NumericalValue", "(", 
               RowBox[{"MBP", ".", "1"}], ")"}], ")"}], "<", "1.`*^-13"}], 
            ",", 
            RowBox[{"Re", "(", 
             RowBox[{"NumericalValue", "(", 
              RowBox[{"MBP", ".", "1"}], ")"}], ")"}]}], "]"}], "<", 
          "600.5999999999999`"}]}], ",", "\<\"OK\"\>", ",", 
        TagBox[
         StyleBox["\<\"Discrepency!\"\>",
          FontColor->RGBColor[1, 0, 0]],
         StyleForm[#, FontColor -> RGBColor[1, 0, 0]]& ]}], "]"}]},
     {"tp", 
      RowBox[{"MTP", ".", "1"}], 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Im", "(", 
          RowBox[{"NumericalValue", "(", 
           RowBox[{"MTP", ".", "1"}], ")"}], ")"}], "<", "1.`*^-13"}], ",", 
        RowBox[{"Re", "(", 
         RowBox[{"NumericalValue", "(", 
          RowBox[{"MTP", ".", "1"}], ")"}], ")"}]}], "]"}], "600.`", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Im", "(", 
              RowBox[{"NumericalValue", "(", 
               RowBox[{"MTP", ".", "1"}], ")"}], ")"}], "<", "1.`*^-13"}], 
            ",", 
            RowBox[{"Re", "(", 
             RowBox[{"NumericalValue", "(", 
              RowBox[{"MTP", ".", "1"}], ")"}], ")"}]}], "]"}], ">", 
          "599.4`"}], "\[And]", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Im", "(", 
              RowBox[{"NumericalValue", "(", 
               RowBox[{"MTP", ".", "1"}], ")"}], ")"}], "<", "1.`*^-13"}], 
            ",", 
            RowBox[{"Re", "(", 
             RowBox[{"NumericalValue", "(", 
              RowBox[{"MTP", ".", "1"}], ")"}], ")"}]}], "]"}], "<", 
          "600.5999999999999`"}]}], ",", "\<\"OK\"\>", ",", 
        TagBox[
         StyleBox["\<\"Discrepency!\"\>",
          FontColor->RGBColor[1, 0, 0]],
         StyleForm[#, FontColor -> RGBColor[1, 0, 0]]& ]}], "]"}]},
     {"x", 
      RowBox[{"MX", ".", "1"}], 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Im", "(", 
          RowBox[{"NumericalValue", "(", 
           RowBox[{"MX", ".", "1"}], ")"}], ")"}], "<", "1.`*^-13"}], ",", 
        RowBox[{"Re", "(", 
         RowBox[{"NumericalValue", "(", 
          RowBox[{"MX", ".", "1"}], ")"}], ")"}]}], "]"}], "600.`", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Im", "(", 
              RowBox[{"NumericalValue", "(", 
               RowBox[{"MX", ".", "1"}], ")"}], ")"}], "<", "1.`*^-13"}], ",", 
            RowBox[{"Re", "(", 
             RowBox[{"NumericalValue", "(", 
              RowBox[{"MX", ".", "1"}], ")"}], ")"}]}], "]"}], ">", 
          "599.4`"}], "\[And]", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Im", "(", 
              RowBox[{"NumericalValue", "(", 
               RowBox[{"MX", ".", "1"}], ")"}], ")"}], "<", "1.`*^-13"}], ",", 
            RowBox[{"Re", "(", 
             RowBox[{"NumericalValue", "(", 
              RowBox[{"MX", ".", "1"}], ")"}], ")"}]}], "]"}], "<", 
          "600.5999999999999`"}]}], ",", "\<\"OK\"\>", ",", 
        TagBox[
         StyleBox["\<\"Discrepency!\"\>",
          FontColor->RGBColor[1, 0, 0]],
         StyleForm[#, FontColor -> RGBColor[1, 0, 0]]& ]}], "]"}]},
     {"y", 
      RowBox[{"MY", ".", "1"}], 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Im", "(", 
          RowBox[{"NumericalValue", "(", 
           RowBox[{"MY", ".", "1"}], ")"}], ")"}], "<", "1.`*^-13"}], ",", 
        RowBox[{"Re", "(", 
         RowBox[{"NumericalValue", "(", 
          RowBox[{"MY", ".", "1"}], ")"}], ")"}]}], "]"}], "600.`", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Im", "(", 
              RowBox[{"NumericalValue", "(", 
               RowBox[{"MY", ".", "1"}], ")"}], ")"}], "<", "1.`*^-13"}], ",", 
            RowBox[{"Re", "(", 
             RowBox[{"NumericalValue", "(", 
              RowBox[{"MY", ".", "1"}], ")"}], ")"}]}], "]"}], ">", 
          "599.4`"}], "\[And]", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Im", "(", 
              RowBox[{"NumericalValue", "(", 
               RowBox[{"MY", ".", "1"}], ")"}], ")"}], "<", "1.`*^-13"}], ",", 
            RowBox[{"Re", "(", 
             RowBox[{"NumericalValue", "(", 
              RowBox[{"MY", ".", "1"}], ")"}], ")"}]}], "]"}], "<", 
          "600.5999999999999`"}]}], ",", "\<\"OK\"\>", ",", 
        TagBox[
         StyleBox["\<\"Discrepency!\"\>",
          FontColor->RGBColor[1, 0, 0]],
         StyleForm[#, FontColor -> RGBColor[1, 0, 0]]& ]}], "]"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   TableForm[{{
     "Particle", "Analytic value", "Numerical value", 
      "Model-file value"}, {$CellContext`bp, 
      Dot[$CellContext`MBP, 1], 
      If[Im[
         FeynRules`NumericalValue[
          Dot[$CellContext`MBP, 1]]] < 1.*^-13, 
       Re[
        FeynRules`NumericalValue[
         Dot[$CellContext`MBP, 1]]]], 600., 
      If[
       And[If[Im[
            FeynRules`NumericalValue[
             Dot[$CellContext`MBP, 1]]] < 1.*^-13, 
          Re[
           FeynRules`NumericalValue[
            Dot[$CellContext`MBP, 1]]]] > 599.4, If[Im[
            FeynRules`NumericalValue[
             Dot[$CellContext`MBP, 1]]] < 1.*^-13, 
          Re[
           FeynRules`NumericalValue[
            Dot[$CellContext`MBP, 1]]]] < 600.5999999999999], "OK", 
       StyleForm[
       "Discrepency!", FontColor -> RGBColor[1, 0, 0]]]}, {$CellContext`tp, 
      Dot[$CellContext`MTP, 1], 
      If[Im[
         FeynRules`NumericalValue[
          Dot[$CellContext`MTP, 1]]] < 1.*^-13, 
       Re[
        FeynRules`NumericalValue[
         Dot[$CellContext`MTP, 1]]]], 600., 
      If[
       And[If[Im[
            FeynRules`NumericalValue[
             Dot[$CellContext`MTP, 1]]] < 1.*^-13, 
          Re[
           FeynRules`NumericalValue[
            Dot[$CellContext`MTP, 1]]]] > 599.4, If[Im[
            FeynRules`NumericalValue[
             Dot[$CellContext`MTP, 1]]] < 1.*^-13, 
          Re[
           FeynRules`NumericalValue[
            Dot[$CellContext`MTP, 1]]]] < 600.5999999999999], "OK", 
       StyleForm["Discrepency!", FontColor -> RGBColor[1, 0, 0]]]}, {
     FeynRules`x, 
      Dot[$CellContext`MX, 1], 
      If[Im[
         FeynRules`NumericalValue[
          Dot[$CellContext`MX, 1]]] < 1.*^-13, 
       Re[
        FeynRules`NumericalValue[
         Dot[$CellContext`MX, 1]]]], 600., 
      If[
       And[If[Im[
            FeynRules`NumericalValue[
             Dot[$CellContext`MX, 1]]] < 1.*^-13, 
          Re[
           FeynRules`NumericalValue[
            Dot[$CellContext`MX, 1]]]] > 599.4, If[Im[
            FeynRules`NumericalValue[
             Dot[$CellContext`MX, 1]]] < 1.*^-13, 
          Re[
           FeynRules`NumericalValue[
            Dot[$CellContext`MX, 1]]]] < 600.5999999999999], "OK", 
       StyleForm["Discrepency!", FontColor -> RGBColor[1, 0, 0]]]}, {
     FeynRules`y, 
      Dot[$CellContext`MY, 1], 
      If[Im[
         FeynRules`NumericalValue[
          Dot[$CellContext`MY, 1]]] < 1.*^-13, 
       Re[
        FeynRules`NumericalValue[
         Dot[$CellContext`MY, 1]]]], 600., 
      If[
       And[If[Im[
            FeynRules`NumericalValue[
             Dot[$CellContext`MY, 1]]] < 1.*^-13, 
          Re[
           FeynRules`NumericalValue[
            Dot[$CellContext`MY, 1]]]] > 599.4, If[Im[
            FeynRules`NumericalValue[
             Dot[$CellContext`MY, 1]]] < 1.*^-13, 
          Re[
           FeynRules`NumericalValue[
            Dot[$CellContext`MY, 1]]]] < 600.5999999999999], "OK", 
       StyleForm["Discrepency!", FontColor -> RGBColor[1, 0, 0]]]}}]], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.5747641905887566`*^9, 3.5747648783860965`*^9, 
  3.575086613315872*^9, 3.5751812506111975`*^9, 3.5751848715123034`*^9, 
  3.575189263681563*^9, 3.575189528881239*^9, 3.5810872495036216`*^9, 
  3.5817057830898533`*^9, 3.5817066976034813`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Outputs and interfaces", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell["CalcHep output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
  3.411911150323291*^9, 3.4119111515122623`*^9}},
 FontSize->10],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteCHOutput", "[", "L", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.57518471886992*^9, 3.5751847190109377`*^9}, {
  3.5751847979554625`*^9, 3.5751848086533213`*^9}, {3.5751849572211866`*^9, 
  3.5751849627703915`*^9}, {3.5751894185427275`*^9, 3.5751894200289164`*^9}},
 FontSize->8],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\" - - - FeynRules interface to CalcHep/CompHEP\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5751849126225233`*^9, 3.5751893072655973`*^9, 
  3.575189443747428*^9, 3.5751895292967916`*^9, 3.5817061617169323`*^9, 
  3.581706774979307*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\" - - - \"\>", "\[InvisibleSpace]", 
    StyleBox["\<\"Authors:\"\>",
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]], 
    "\[InvisibleSpace]", "\<\" N. Christensen, C. Duhr\"\>"}],
   SequenceForm[" - - - ", 
    Style["Authors:", 
     RGBColor[0, 0, 1]], " N. Christensen, C. Duhr"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5751849126225233`*^9, 3.5751893072655973`*^9, 
  3.575189443747428*^9, 3.5751895292967916`*^9, 3.5817061617169323`*^9, 
  3.581706775012811*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\" - - - \"\>", "\[InvisibleSpace]", 
    StyleBox["\<\"Please cite:\"\>",
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]], 
    "\[InvisibleSpace]", "\<\" arXiv:0906.2474\"\>"}],
   SequenceForm[" - - - ", 
    Style["Please cite:", 
     RGBColor[0, 0, 1]], " arXiv:0906.2474"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5751849126225233`*^9, 3.5751893072655973`*^9, 
  3.575189443747428*^9, 3.5751895292967916`*^9, 3.5817061617169323`*^9, 
  3.581706775017812*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    StyleBox["\<\"\\nWriting\"\>",
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]], 
    "\[InvisibleSpace]", "\<\" files to \
D:\\\\Logiciels\\\\Mathematica\\\\AddOns\\\\Applications\\\\FeynRules\\\\\
Models\\\\VLQ\\\\VLQ-CH.\"\>"}],
   SequenceForm[
    Style["\nWriting", 
     RGBColor[0, 0, 1]], 
    " files to \
D:\\Logiciels\\Mathematica\\AddOns\\Applications\\FeynRules\\Models\\VLQ\\VLQ-\
CH."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5751849126225233`*^9, 3.5751893072655973`*^9, 
  3.575189443747428*^9, 3.5751895292967916`*^9, 3.5817061617169323`*^9, 
  3.5817067750228124`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    StyleBox["\<\"\\nWriting\"\>",
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]], 
    "\[InvisibleSpace]", "\<\" particles file 'prtcls1.mdl'.\"\>"}],
   SequenceForm[
    Style["\nWriting", 
     RGBColor[0, 0, 1]], " particles file 'prtcls1.mdl'."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5751849126225233`*^9, 3.5751893072655973`*^9, 
  3.575189443747428*^9, 3.5751895292967916`*^9, 3.5817061617169323`*^9, 
  3.581706775026813*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    StyleBox["\<\"\\nWriting\"\>",
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]], 
    "\[InvisibleSpace]", "\<\" external parameter file 'vars1.mdl'.\"\>"}],
   SequenceForm[
    Style["\nWriting", 
     RGBColor[0, 0, 1]], " external parameter file 'vars1.mdl'."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5751849126225233`*^9, 3.5751893072655973`*^9, 
  3.575189443747428*^9, 3.5751895292967916`*^9, 3.5817061617169323`*^9, 
  3.58170677508432*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    StyleBox["\<\"\\nWriting\"\>",
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]], 
    "\[InvisibleSpace]", "\<\" internal parameter file 'func1.mdl'.\"\>"}],
   SequenceForm[
    Style["\nWriting", 
     RGBColor[0, 0, 1]], " internal parameter file 'func1.mdl'."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5751849126225233`*^9, 3.5751893072655973`*^9, 
  3.575189443747428*^9, 3.5751895292967916`*^9, 3.5817061617169323`*^9, 
  3.581706775101322*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    StyleBox["\<\"\\nWriting\"\>",
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]], 
    "\[InvisibleSpace]", "\<\" external library file 'extlib1.mdl'.\"\>"}],
   SequenceForm[
    Style["\nWriting", 
     RGBColor[0, 0, 1]], " external library file 'extlib1.mdl'."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5751849126225233`*^9, 3.5751893072655973`*^9, 
  3.575189443747428*^9, 3.5751895292967916`*^9, 3.5817061617169323`*^9, 
  3.5817067751638308`*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5751849126225233`*^9, 3.5751893072655973`*^9, 
  3.575189443747428*^9, 3.5751895292967916`*^9, 3.5817061617169323`*^9, 
  3.581706775177332*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Calculating Feynman rules for \"\>", 
    "\[InvisibleSpace]", "\<\"L1\"\>"}],
   SequenceForm["Calculating Feynman rules for ", "L1"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5751849126225233`*^9, 3.5751893072655973`*^9, 
  3.575189443747428*^9, 3.5751895292967916`*^9, 3.5817061617169323`*^9, 
  3.581706775180833*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Starting Feynman rule calculation for \"\>", 
    "\[InvisibleSpace]", "\<\"L1\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
   SequenceForm["Starting Feynman rule calculation for ", "L1", "."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5751849126225233`*^9, 3.5751893072655973`*^9, 
  3.575189443747428*^9, 3.5751895292967916`*^9, 3.5817061617169323`*^9, 
  3.5817067754328647`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Neglecting all terms with more than \"\>", 
    "\[InvisibleSpace]", "\<\"4\"\>", 
    "\[InvisibleSpace]", "\<\" particles.\"\>"}],
   SequenceForm["Neglecting all terms with more than ", "4", " particles."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5751849126225233`*^9, 3.5751893072655973`*^9, 
  3.575189443747428*^9, 3.5751895292967916`*^9, 3.5817061617169323`*^9, 
  3.581706775879421*^9}],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the \
vertex...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5751849126225233`*^9, 3.5751893072655973`*^9, 
  3.575189443747428*^9, 3.5751895292967916`*^9, 3.5817061617169323`*^9, 
  3.581706786557277*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Found \"\>", "\[InvisibleSpace]", "\<\"149\"\>", 
    "\[InvisibleSpace]", "\<\" possible non zero vertices.\"\>"}],
   SequenceForm["Found ", "149", " possible non zero vertices."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5751849126225233`*^9, 3.5751893072655973`*^9, 
  3.575189443747428*^9, 3.5751895292967916`*^9, 3.5817061617169323`*^9, 
  3.581706786809809*^9}],

Cell[BoxData[
 FormBox["\<\"Start calculating vertices...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5751849126225233`*^9, 3.5751893072655973`*^9, 
  3.575189443747428*^9, 3.5751895292967916`*^9, 3.5817061617169323`*^9, 
  3.58170678681381*^9}],

Cell[BoxData[
 FormBox[
  ProgressIndicatorBox[Dynamic[PRIVATE`progress$11775]], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5751849126225233`*^9, 3.5751893072655973`*^9, 
  3.575189443747428*^9, 3.5751895292967916`*^9, 3.5817061617169323`*^9, 
  3.58170678681781*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"149", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
   SequenceForm[149, " vertices obtained."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5751849126225233`*^9, 3.5751893072655973`*^9, 
  3.575189443747428*^9, 3.5751895292967916`*^9, 3.5817061617169323`*^9, 
  3.581706791466901*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["UFO output", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}, {
  3.5745083801218367`*^9, 3.5745083815726395`*^9}},
 FontSize->9],

Cell["\<\
The FeynRules output for the SM can be obtained via\
\>", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911062212926*^9, 3.4119110634765463`*^9}, {3.5745083846458445`*^9, 
  3.5745083861746473`*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", " ", "=", " ", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"L", "//", "WriteUFO"}]}], "Input",
 CellChangeTimes->{{3.5705189929967775`*^9, 3.570519000011668*^9}, 
   3.5705192098938203`*^9, {3.5705192814649086`*^9, 3.570519281656433*^9}, {
   3.5705193273207316`*^9, 3.570519333615531*^9}, {3.570521451647987*^9, 
   3.570521531465122*^9}, {3.571326951698388*^9, 3.5713269550678167`*^9}, {
   3.5743121975149927`*^9, 3.574312200204996*^9}, 3.5745073225521364`*^9},
 FontSize->8],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\" --- Universal FeynRules Output (UFO) v 0.1 ---\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.574508395004263*^9, 3.574764359475416*^9, 
  3.5747648822643185`*^9, 3.575086618727559*^9, 3.575181251271781*^9, 
  3.5751848720748744`*^9, 3.575189264533671*^9, 3.575189551840154*^9, 
  3.581087259444384*^9, 3.5817058299503036`*^9, 3.5817067042463255`*^9}],

Cell[BoxData[
 FormBox["\<\"Starting Feynman rule calculation.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.574508395004263*^9, 3.574764359475416*^9, 
  3.5747648822643185`*^9, 3.575086618727559*^9, 3.575181251271781*^9, 
  3.5751848720748744`*^9, 3.575189264533671*^9, 3.575189551840154*^9, 
  3.581087259444384*^9, 3.5817058299503036`*^9, 3.5817067048238983`*^9}],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the \
vertex...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574508395004263*^9, 3.574764359475416*^9, 
  3.5747648822643185`*^9, 3.575086618727559*^9, 3.575181251271781*^9, 
  3.5751848720748744`*^9, 3.575189264533671*^9, 3.575189551840154*^9, 
  3.581087259444384*^9, 3.5817058299503036`*^9, 3.5817067130489426`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Found \"\>", "\[InvisibleSpace]", "\<\"87\"\>", 
    "\[InvisibleSpace]", "\<\" possible non zero vertices.\"\>"}],
   SequenceForm["Found ", "87", " possible non zero vertices."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.574508395004263*^9, 3.574764359475416*^9, 
  3.5747648822643185`*^9, 3.575086618727559*^9, 3.575181251271781*^9, 
  3.5751848720748744`*^9, 3.575189264533671*^9, 3.575189551840154*^9, 
  3.581087259444384*^9, 3.5817058299503036`*^9, 3.5817067132384667`*^9}],

Cell[BoxData[
 FormBox["\<\"Start calculating vertices...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574508395004263*^9, 3.574764359475416*^9, 
  3.5747648822643185`*^9, 3.575086618727559*^9, 3.575181251271781*^9, 
  3.5751848720748744`*^9, 3.575189264533671*^9, 3.575189551840154*^9, 
  3.581087259444384*^9, 3.5817058299503036`*^9, 3.5817067132424674`*^9}],

Cell[BoxData[
 FormBox[
  ProgressIndicatorBox[Dynamic[PRIVATE`progress$4612]], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.574508395004263*^9, 3.574764359475416*^9, 
  3.5747648822643185`*^9, 3.575086618727559*^9, 3.575181251271781*^9, 
  3.5751848720748744`*^9, 3.575189264533671*^9, 3.575189551840154*^9, 
  3.581087259444384*^9, 3.5817058299503036`*^9, 3.5817067132509685`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"87", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
   SequenceForm[87, " vertices obtained."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.574508395004263*^9, 3.574764359475416*^9, 
  3.5747648822643185`*^9, 3.575086618727559*^9, 3.575181251271781*^9, 
  3.5751848720748744`*^9, 3.575189264533671*^9, 3.575189551840154*^9, 
  3.581087259444384*^9, 3.5817058299503036`*^9, 3.5817067176870317`*^9}],

Cell[BoxData[
 FormBox["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.574508395004263*^9, 3.574764359475416*^9, 
  3.5747648822643185`*^9, 3.575086618727559*^9, 3.575181251271781*^9, 
  3.5751848720748744`*^9, 3.575189264533671*^9, 3.575189551840154*^9, 
  3.581087259444384*^9, 3.5817058299503036`*^9, 3.5817067196767845`*^9}],

Cell[BoxData[
 FormBox["\<\"Preparing Python output.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574508395004263*^9, 3.574764359475416*^9, 
  3.5747648822643185`*^9, 3.575086618727559*^9, 3.575181251271781*^9, 
  3.5751848720748744`*^9, 3.575189264533671*^9, 3.575189551840154*^9, 
  3.581087259444384*^9, 3.5817058299503036`*^9, 3.5817067196907864`*^9}],

Cell[BoxData[
 FormBox["\<\"    - Splitting vertices into building blocks.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.574508395004263*^9, 3.574764359475416*^9, 
  3.5747648822643185`*^9, 3.575086618727559*^9, 3.575181251271781*^9, 
  3.5751848720748744`*^9, 3.575189264533671*^9, 3.575189551840154*^9, 
  3.581087259444384*^9, 3.5817058299503036`*^9, 3.5817067198018007`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
    DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, TraditionalForm],
     ImageSizeCache->{253., {4., 13.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
    "\[InvisibleSpace]", "125", "\[InvisibleSpace]", "\<\" .\"\>"}],
   SequenceForm["    - Optimizing: ", 
    Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 125, " ."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.574508395004263*^9, 3.574764359475416*^9, 
  3.5747648822643185`*^9, 3.575086618727559*^9, 3.575181251271781*^9, 
  3.5751848720748744`*^9, 3.575189264533671*^9, 3.575189551840154*^9, 
  3.581087259444384*^9, 3.5817058299503036`*^9, 3.5817067206349063`*^9}],

Cell[BoxData[
 FormBox["\<\"    - Writing files.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574508395004263*^9, 3.574764359475416*^9, 
  3.5747648822643185`*^9, 3.575086618727559*^9, 3.575181251271781*^9, 
  3.5751848720748744`*^9, 3.575189264533671*^9, 3.575189551840154*^9, 
  3.581087259444384*^9, 3.5817058299503036`*^9, 3.5817067208734365`*^9}],

Cell[BoxData[
 FormBox["\<\"Done!\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574508395004263*^9, 3.574764359475416*^9, 
  3.5747648822643185`*^9, 3.575086618727559*^9, 3.575181251271781*^9, 
  3.5751848720748744`*^9, 3.575189264533671*^9, 3.575189551840154*^9, 
  3.581087259444384*^9, 3.5817058299503036`*^9, 3.581706721108466*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FeynArts output", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}},
 FontSize->9],

Cell["The FeynArts output for the SM can be obtained via", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911062212926*^9, 3.4119110634765463`*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", " ", "=", " ", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"WriteFeynArtsOutput", "[", "L", "]"}]}], "Input",
 CellChangeTimes->{{3.411911018354619*^9, 3.4119110196967573`*^9}, {
   3.412185470680571*^9, 3.412185480912915*^9}, {3.41245048911446*^9, 
   3.4124504892674522`*^9}, 3.414315634453483*^9, {3.423416180751266*^9, 
   3.423416182892613*^9}, {3.5745076371682897`*^9, 3.574507647635908*^9}, 
   3.575092129385824*^9},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\" - - - FeynRules interface to FeynArts - - -\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.5817067499846334`*^9}],

Cell[BoxData[
 FormBox["\<\"      C. Degrande C. Duhr, 2010\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.5817067499896336`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Calculating Feynman rules for \"\>", 
    "\[InvisibleSpace]", "\<\"L1\"\>"}],
   SequenceForm["Calculating Feynman rules for ", "L1"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.5817067500031357`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Starting Feynman rule calculation for \"\>", 
    "\[InvisibleSpace]", "\<\"L1\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
   SequenceForm["Starting Feynman rule calculation for ", "L1", "."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.581706750189659*^9}],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the \
vertex...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.581706756442953*^9}],

Cell[BoxData[
 FormBox["\<\"Warning: Encountered class members in the lagrangian! This is \
not supported by FeynArts.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.581706756593972*^9}],

Cell[BoxData[
 FormBox["\<\"1 vertex obtained.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.581706756597473*^9}],

Cell[BoxData[
 FormBox["\<\"Redefining classes in such a way that each particle is in a \
separate FeynArts class.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.5817067566019735`*^9}],

Cell[BoxData[
 FormBox["\<\"See NewFeynArtsClasses[] for more information on the new \
classes\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.5817067566069736`*^9}],

Cell[BoxData[
 FormBox["\<\"Restarting Feynman rule calculation, setting FlavorExpand -> \
True.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.5817067566109743`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Calculating Feynman rules for \"\>", 
    "\[InvisibleSpace]", "\<\"L1\"\>"}],
   SequenceForm["Calculating Feynman rules for ", "L1"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.581706756614975*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Starting Feynman rule calculation for \"\>", 
    "\[InvisibleSpace]", "\<\"L1\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
   SequenceForm["Starting Feynman rule calculation for ", "L1", "."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.5817067567999983`*^9}],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the \
vertex...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.581706765701129*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Found \"\>", "\[InvisibleSpace]", "\<\"125\"\>", 
    "\[InvisibleSpace]", "\<\" possible non zero vertices.\"\>"}],
   SequenceForm["Found ", "125", " possible non zero vertices."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.581706765940159*^9}],

Cell[BoxData[
 FormBox["\<\"Start calculating vertices...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.5817067659441595`*^9}],

Cell[BoxData[
 FormBox[
  ProgressIndicatorBox[Dynamic[PRIVATE`progress$7381]], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.5817067659486604`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"125", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
   SequenceForm[125, " vertices obtained."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.5817067706722603`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"FFS\"\>", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "1"}], ",", 
        RowBox[{"2", "\[Rule]", "2"}], ",", 
        RowBox[{"3", "\[Rule]", "3"}]}], "}"}], 
      RowBox[{"{", 
       RowBox[{
        FormBox[
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox[
          SubscriptBox["P", "\<\"+\"\>"], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "}"}]},
     {"\<\"FFV\"\>", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"3", "\[Rule]", "1"}], ",", 
        RowBox[{"2", "\[Rule]", "2"}], ",", 
        RowBox[{"1", "\[Rule]", "3"}]}], "}"}], 
      RowBox[{"{", 
       RowBox[{
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            SuperscriptBox["\[Gamma]", 
             FormBox[
              SubscriptBox["\<\"\[Mu]\"\>", "1"],
              TraditionalForm]],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            SuperscriptBox["\[Gamma]", 
             FormBox[
              SubscriptBox["\<\"\[Mu]\"\>", "1"],
              TraditionalForm]],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"+\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "}"}]},
     {"\<\"SSS\"\>", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "1"}], ",", 
        RowBox[{"2", "\[Rule]", "2"}], ",", 
        RowBox[{"3", "\[Rule]", "3"}]}], "}"}], 
      RowBox[{"{", "1", "}"}]},
     {"\<\"SSSS\"\>", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "1"}], ",", 
        RowBox[{"2", "\[Rule]", "2"}], ",", 
        RowBox[{"3", "\[Rule]", "3"}], ",", 
        RowBox[{"4", "\[Rule]", "4"}]}], "}"}], 
      RowBox[{"{", "1", "}"}]},
     {"\<\"SSVV\"\>", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "1"}], ",", 
        RowBox[{"2", "\[Rule]", "2"}], ",", 
        RowBox[{"3", "\[Rule]", "3"}], ",", 
        RowBox[{"4", "\[Rule]", "4"}]}], "}"}], 
      RowBox[{"{", 
       FormBox[
        SubscriptBox["\[Eta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "3"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "4"],
           TraditionalForm]}]],
        TraditionalForm], "}"}]},
     {"\<\"SVV\"\>", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "1"}], ",", 
        RowBox[{"2", "\[Rule]", "2"}], ",", 
        RowBox[{"3", "\[Rule]", "3"}]}], "}"}], 
      RowBox[{"{", 
       FormBox[
        SubscriptBox["\[Eta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "2"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], "}"}]},
     {"\<\"UUV\"\>", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", "\[Rule]", "1"}], ",", 
        RowBox[{"3", "\[Rule]", "2"}], ",", 
        RowBox[{"1", "\[Rule]", "3"}]}], "}"}], 
      RowBox[{"{", 
       RowBox[{
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "1", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "1"],
           TraditionalForm]],
         TraditionalForm], ",", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "3", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "1"],
           TraditionalForm]],
         TraditionalForm]}], "}"}]},
     {"\<\"VVV\"\>", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "1"}], ",", 
        RowBox[{"2", "\[Rule]", "2"}], ",", 
        RowBox[{"3", "\[Rule]", "3"}]}], "}"}], 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         FormBox[
          SubsuperscriptBox["\<\"p\"\>", "1", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], ",", 
        RowBox[{
         FormBox[
          SubsuperscriptBox["\<\"p\"\>", "2", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], ",", 
        RowBox[{
         FormBox[
          SubsuperscriptBox["\<\"p\"\>", "1", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm]}], ",", 
        RowBox[{
         FormBox[
          SubsuperscriptBox["\<\"p\"\>", "3", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm]}], ",", 
        RowBox[{
         FormBox[
          SubsuperscriptBox["\<\"p\"\>", "2", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm]}], ",", 
        RowBox[{
         FormBox[
          SubsuperscriptBox["\<\"p\"\>", "3", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm]}]}], "}"}]},
     {"\<\"VVVV\"\>", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "1"}], ",", 
        RowBox[{"2", "\[Rule]", "2"}], ",", 
        RowBox[{"3", "\[Rule]", "3"}], ",", 
        RowBox[{"4", "\[Rule]", "4"}]}], "}"}], 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "4"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm]}], ",", 
        RowBox[{
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "4"],
             TraditionalForm]}]],
          TraditionalForm]}], ",", 
        RowBox[{
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "4"],
             TraditionalForm]}]],
          TraditionalForm]}]}], "}"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.5817067717228937`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"FFS\"\>", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "1"}], ",", 
        RowBox[{"2", "\[Rule]", "2"}], ",", 
        RowBox[{"3", "\[Rule]", "3"}]}], "}"}], 
      RowBox[{"{", 
       RowBox[{
        FormBox[
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox[
          SubscriptBox["P", "\<\"+\"\>"], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "}"}]},
     {"\<\"FFV\"\>", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"3", "\[Rule]", "1"}], ",", 
        RowBox[{"2", "\[Rule]", "2"}], ",", 
        RowBox[{"1", "\[Rule]", "3"}]}], "}"}], 
      RowBox[{"{", 
       RowBox[{
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            SuperscriptBox["\[Gamma]", 
             FormBox[
              SubscriptBox["\<\"\[Mu]\"\>", "1"],
              TraditionalForm]],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], ",", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            SuperscriptBox["\[Gamma]", 
             FormBox[
              SubscriptBox["\<\"\[Mu]\"\>", "1"],
              TraditionalForm]],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"+\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "}"}]},
     {"\<\"SSS\"\>", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "1"}], ",", 
        RowBox[{"2", "\[Rule]", "2"}], ",", 
        RowBox[{"3", "\[Rule]", "3"}]}], "}"}], 
      RowBox[{"{", "1", "}"}]},
     {"\<\"SSSS\"\>", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "1"}], ",", 
        RowBox[{"2", "\[Rule]", "2"}], ",", 
        RowBox[{"3", "\[Rule]", "3"}], ",", 
        RowBox[{"4", "\[Rule]", "4"}]}], "}"}], 
      RowBox[{"{", "1", "}"}]},
     {"\<\"SSVV\"\>", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "1"}], ",", 
        RowBox[{"2", "\[Rule]", "2"}], ",", 
        RowBox[{"3", "\[Rule]", "3"}], ",", 
        RowBox[{"4", "\[Rule]", "4"}]}], "}"}], 
      RowBox[{"{", 
       FormBox[
        SubscriptBox["\[Eta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "3"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "4"],
           TraditionalForm]}]],
        TraditionalForm], "}"}]},
     {"\<\"SVV\"\>", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "1"}], ",", 
        RowBox[{"2", "\[Rule]", "2"}], ",", 
        RowBox[{"3", "\[Rule]", "3"}]}], "}"}], 
      RowBox[{"{", 
       FormBox[
        SubscriptBox["\[Eta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "2"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "3"],
           TraditionalForm]}]],
        TraditionalForm], "}"}]},
     {"\<\"UUV\"\>", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", "\[Rule]", "1"}], ",", 
        RowBox[{"3", "\[Rule]", "2"}], ",", 
        RowBox[{"1", "\[Rule]", "3"}]}], "}"}], 
      RowBox[{"{", 
       RowBox[{
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "1", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "1"],
           TraditionalForm]],
         TraditionalForm], ",", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "3", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "1"],
           TraditionalForm]],
         TraditionalForm], ",", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "2", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "1"],
           TraditionalForm]],
         TraditionalForm]}], "}"}]},
     {"\<\"VVV\"\>", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "1"}], ",", 
        RowBox[{"2", "\[Rule]", "2"}], ",", 
        RowBox[{"3", "\[Rule]", "3"}]}], "}"}], 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         FormBox[
          SubsuperscriptBox["\<\"p\"\>", "1", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], ",", 
        RowBox[{
         FormBox[
          SubsuperscriptBox["\<\"p\"\>", "2", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], ",", 
        RowBox[{
         FormBox[
          SubsuperscriptBox["\<\"p\"\>", "1", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm]}], ",", 
        RowBox[{
         FormBox[
          SubsuperscriptBox["\<\"p\"\>", "3", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm]}], ",", 
        RowBox[{
         FormBox[
          SubsuperscriptBox["\<\"p\"\>", "2", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm]}], ",", 
        RowBox[{
         FormBox[
          SubsuperscriptBox["\<\"p\"\>", "3", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm]}]}], "}"}]},
     {"\<\"VVVV\"\>", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "1"}], ",", 
        RowBox[{"2", "\[Rule]", "2"}], ",", 
        RowBox[{"3", "\[Rule]", "3"}], ",", 
        RowBox[{"4", "\[Rule]", "4"}]}], "}"}], 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "4"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm]}], ",", 
        RowBox[{
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "4"],
             TraditionalForm]}]],
          TraditionalForm]}], ",", 
        RowBox[{
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "4"],
             TraditionalForm]}]],
          TraditionalForm]}]}], "}"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.5817067717673993`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Writing FeynArts model file into directory \"\>", 
    "\[InvisibleSpace]", "\<\"VLQ_FA\"\>"}],
   SequenceForm["Writing FeynArts model file into directory ", "VLQ_FA"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.5817067726780148`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Writing FeynArts generic file on \"\>", 
    "\[InvisibleSpace]", "\<\"VLQ_FA.gen\"\>", 
    "\[InvisibleSpace]", "\<\".\"\>"}],
   SequenceForm["Writing FeynArts generic file on ", "VLQ_FA.gen", "."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.574507550744138*^9, 3.574507649227111*^9, 
  3.57450842217951*^9, 3.574764376235375*^9, 3.5747648968341513`*^9, 
  3.5750866345365667`*^9, 3.5750921299453955`*^9, 3.575181267842885*^9, 
  3.5751848882909336`*^9, 3.5751892827569847`*^9, 3.575189568062214*^9, 
  3.581706772853037*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NewFeynArtsClasses", "[", "]"}]], "Input",
 CellChangeTimes->{{3.575092157608408*^9, 3.5750921634096446`*^9}},
 FontSize->8],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ve", "\[Rule]", 
     RowBox[{"F", "(", "1", ")"}]}], ",", 
    RowBox[{"vm", "\[Rule]", 
     RowBox[{"F", "(", "2", ")"}]}], ",", 
    RowBox[{"vt", "\[Rule]", 
     RowBox[{"F", "(", "3", ")"}]}], ",", 
    RowBox[{"e", "\[Rule]", 
     RowBox[{"F", "(", "4", ")"}]}], ",", 
    RowBox[{"m", "\[Rule]", 
     RowBox[{"F", "(", "5", ")"}]}], ",", 
    RowBox[{"tt", "\[Rule]", 
     RowBox[{"F", "(", "6", ")"}]}], ",", 
    RowBox[{"u", "\[Rule]", 
     RowBox[{"F", "(", "7", ")"}]}], ",", 
    RowBox[{"c", "\[Rule]", 
     RowBox[{"F", "(", "8", ")"}]}], ",", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{"F", "(", "9", ")"}]}], ",", 
    RowBox[{"d", "\[Rule]", 
     RowBox[{"F", "(", "10", ")"}]}], ",", 
    RowBox[{"s", "\[Rule]", 
     RowBox[{"F", "(", "11", ")"}]}], ",", 
    RowBox[{"b", "\[Rule]", 
     RowBox[{"F", "(", "12", ")"}]}], ",", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"F", "(", "13", ")"}]}], ",", 
    RowBox[{"tp", "\[Rule]", 
     RowBox[{"F", "(", "14", ")"}]}], ",", 
    RowBox[{"bp", "\[Rule]", 
     RowBox[{"F", "(", "15", ")"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"F", "(", "16", ")"}]}], ",", 
    RowBox[{"ghA", "\[Rule]", 
     RowBox[{"U", "(", "1", ")"}]}], ",", 
    RowBox[{"ghZ", "\[Rule]", 
     RowBox[{"U", "(", "2", ")"}]}], ",", 
    RowBox[{"ghWp", "\[Rule]", 
     RowBox[{"U", "(", "3", ")"}]}], ",", 
    RowBox[{"ghWm", "\[Rule]", 
     RowBox[{"U", "(", "4", ")"}]}], ",", 
    RowBox[{"ghG", "\[Rule]", 
     RowBox[{"U", "(", "5", ")"}]}], ",", 
    RowBox[{"A", "\[Rule]", 
     RowBox[{"V", "(", "1", ")"}]}], ",", 
    RowBox[{"Z", "\[Rule]", 
     RowBox[{"V", "(", "2", ")"}]}], ",", 
    RowBox[{"W", "\[Rule]", 
     RowBox[{"V", "(", "3", ")"}]}], ",", 
    RowBox[{"G", "\[Rule]", 
     RowBox[{"V", "(", "4", ")"}]}], ",", 
    RowBox[{"H", "\[Rule]", 
     RowBox[{"S", "(", "1", ")"}]}], ",", 
    RowBox[{"phi", "\[Rule]", 
     RowBox[{"S", "(", "2", ")"}]}], ",", 
    RowBox[{"phi2", "\[Rule]", 
     RowBox[{"S", "(", "3", ")"}]}]}], "}"}], TraditionalForm]], "Output",
 CellChangeTimes->{3.5750921639157085`*^9, 3.57518129355215*^9, 
  3.575184912537513*^9, 3.5751893072055893`*^9, 3.5751895925018177`*^9}]
}, Open  ]],

Cell["FeynArts also supports the Feynman gauge", "Text",
 CellChangeTimes->{{3.4121854851672792`*^9, 3.412185494183435*^9}},
 FontSize->9],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"FeynmanGauge", " ", "=", " ", "True"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"WriteFeynArtsOutput", "[", 
    RowBox[{
    "LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", "LGhost", 
     ",", 
     RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}], ",", 
     RowBox[{"Output", "\[Rule]", "\"\<SM.mod\>\""}]}], "]"}]}], 
  "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.411911018354619*^9, 3.4119110196967573`*^9}, {
  3.412185470680571*^9, 3.412185506240796*^9}, {3.4234161971513453`*^9, 
  3.423416209716672*^9}, {3.574507563816961*^9, 3.574507568637369*^9}},
 FontSize->9]
}, Open  ]]
}, Open  ]]
},
WindowSize->{667, 690},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.5,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 192, 4, 86, "Section"],
Cell[CellGroupData[{
Cell[784, 30, 215, 4, 46, "Subsection"],
Cell[CellGroupData[{
Cell[1024, 38, 2333, 39, 109, "Input"],
Cell[3360, 79, 1077, 17, 36, "Output"],
Cell[CellGroupData[{
Cell[4462, 100, 806, 12, 26, "Print"],
Cell[5271, 114, 835, 13, 26, "Print"],
Cell[6109, 129, 792, 12, 26, "Print"],
Cell[6904, 143, 862, 13, 26, "Print"],
Cell[7769, 158, 822, 13, 26, "Print"],
Cell[8594, 173, 792, 12, 26, "Print"],
Cell[9389, 187, 857, 13, 26, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10307, 207, 347, 7, 46, "Subsection"],
Cell[CellGroupData[{
Cell[10679, 218, 1154, 28, 179, "Input"],
Cell[CellGroupData[{
Cell[11858, 250, 613, 10, 26, "Print"],
Cell[12474, 262, 586, 9, 26, "Print"],
Cell[13063, 273, 586, 9, 26, "Print"],
Cell[13652, 284, 582, 9, 26, "Print"],
Cell[14237, 295, 583, 9, 26, "Print"],
Cell[14823, 306, 727, 13, 26, "Print"],
Cell[15553, 321, 620, 10, 26, "Print"],
Cell[16176, 333, 571, 9, 26, "Print"],
Cell[16750, 344, 605, 10, 26, "Print"],
Cell[17358, 356, 607, 10, 26, "Print"],
Cell[17968, 368, 604, 10, 26, "Print"],
Cell[18575, 380, 768, 14, 45, "Print"],
Cell[19346, 396, 1073, 19, 26, "Print"],
Cell[20422, 417, 593, 9, 26, "Print"],
Cell[21018, 428, 717, 13, 26, "Print"],
Cell[21738, 443, 725, 13, 26, "Print"],
Cell[22466, 458, 723, 13, 26, "Print"],
Cell[23192, 473, 580, 9, 26, "Print"],
Cell[23775, 484, 589, 9, 26, "Print"],
Cell[24367, 495, 589, 9, 26, "Print"],
Cell[24959, 506, 585, 9, 26, "Print"],
Cell[25547, 517, 586, 9, 26, "Print"],
Cell[26136, 528, 587, 9, 26, "Print"],
Cell[26726, 539, 615, 10, 26, "Print"],
Cell[27344, 551, 610, 10, 26, "Print"],
Cell[27957, 563, 637, 10, 26, "Print"],
Cell[28597, 575, 579, 9, 26, "Print"],
Cell[29179, 586, 610, 10, 26, "Print"],
Cell[29792, 598, 604, 10, 26, "Print"],
Cell[30399, 610, 598, 9, 26, "Print"],
Cell[31000, 621, 597, 9, 26, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31658, 637, 267, 6, 46, "Subsection"],
Cell[CellGroupData[{
Cell[31950, 647, 82, 2, 36, "Input"],
Cell[CellGroupData[{
Cell[32057, 653, 610, 10, 26, "Print"],
Cell[32670, 665, 633, 10, 26, "Print"],
Cell[33306, 677, 801, 14, 26, "Print"],
Cell[34110, 693, 602, 9, 26, "Print"],
Cell[34715, 704, 620, 11, 38, "Print"],
Cell[35338, 717, 719, 13, 26, "Print"],
Cell[36060, 732, 646, 10, 26, "Print"],
Cell[36709, 744, 691, 13, 26, "Print"],
Cell[37403, 759, 881, 15, 26, "Print"],
Cell[38287, 776, 882, 15, 26, "Print"],
Cell[39172, 793, 957, 18, 33, "Print"],
Cell[40132, 813, 578, 9, 26, "Print"],
Cell[40713, 824, 1275, 37, 46, "Print"],
Cell[41991, 863, 644, 10, 26, "Print"],
Cell[42638, 875, 693, 13, 26, "Print"],
Cell[43334, 890, 884, 15, 26, "Print"],
Cell[44221, 907, 884, 15, 26, "Print"],
Cell[45108, 924, 955, 18, 32, "Print"],
Cell[46066, 944, 580, 9, 26, "Print"],
Cell[46649, 955, 1253, 36, 46, "Print"],
Cell[47905, 993, 646, 10, 26, "Print"],
Cell[48554, 1005, 691, 13, 26, "Print"],
Cell[49248, 1020, 884, 15, 26, "Print"],
Cell[50135, 1037, 877, 15, 26, "Print"],
Cell[51015, 1054, 955, 18, 30, "Print"],
Cell[51973, 1074, 578, 9, 26, "Print"],
Cell[52554, 1085, 1255, 36, 46, "Print"],
Cell[53812, 1123, 644, 10, 26, "Print"],
Cell[54459, 1135, 693, 13, 26, "Print"],
Cell[55155, 1150, 882, 15, 26, "Print"],
Cell[56040, 1167, 879, 15, 26, "Print"],
Cell[56922, 1184, 955, 18, 30, "Print"],
Cell[57880, 1204, 577, 9, 26, "Print"],
Cell[58460, 1215, 1273, 37, 46, "Print"],
Cell[59736, 1254, 644, 10, 26, "Print"],
Cell[60383, 1266, 691, 13, 26, "Print"],
Cell[61077, 1281, 955, 18, 33, "Print"],
Cell[62035, 1301, 882, 15, 26, "Print"],
Cell[62920, 1318, 881, 15, 26, "Print"],
Cell[63804, 1335, 580, 9, 26, "Print"],
Cell[64387, 1346, 1943, 57, 49, "Print"],
Cell[66333, 1405, 646, 10, 26, "Print"],
Cell[66982, 1417, 691, 13, 26, "Print"],
Cell[67676, 1432, 877, 15, 26, "Print"],
Cell[68556, 1449, 957, 18, 33, "Print"],
Cell[69516, 1469, 879, 15, 26, "Print"],
Cell[70398, 1486, 578, 9, 26, "Print"],
Cell[70979, 1497, 1941, 57, 49, "Print"],
Cell[72923, 1556, 646, 10, 26, "Print"],
Cell[73572, 1568, 693, 13, 26, "Print"],
Cell[74268, 1583, 957, 18, 33, "Print"],
Cell[75228, 1603, 879, 15, 26, "Print"],
Cell[76110, 1620, 881, 15, 26, "Print"],
Cell[76994, 1637, 580, 9, 26, "Print"],
Cell[77577, 1648, 1943, 57, 49, "Print"],
Cell[79523, 1707, 644, 10, 26, "Print"],
Cell[80170, 1719, 691, 13, 26, "Print"],
Cell[80864, 1734, 957, 18, 33, "Print"],
Cell[81824, 1754, 879, 15, 26, "Print"],
Cell[82706, 1771, 877, 15, 26, "Print"],
Cell[83586, 1788, 577, 9, 26, "Print"],
Cell[84166, 1799, 1941, 57, 49, "Print"],
Cell[86110, 1858, 644, 10, 26, "Print"],
Cell[86757, 1870, 693, 13, 26, "Print"],
Cell[87453, 1885, 953, 18, 30, "Print"],
Cell[88409, 1905, 881, 15, 26, "Print"],
Cell[89293, 1922, 884, 15, 26, "Print"],
Cell[90180, 1939, 578, 9, 26, "Print"],
Cell[90761, 1950, 1939, 57, 49, "Print"],
Cell[92703, 2009, 644, 10, 26, "Print"],
Cell[93350, 2021, 695, 13, 26, "Print"],
Cell[94048, 2036, 884, 15, 26, "Print"],
Cell[94935, 2053, 955, 18, 33, "Print"],
Cell[95893, 2073, 881, 15, 26, "Print"],
Cell[96777, 2090, 580, 9, 26, "Print"],
Cell[97360, 2101, 1941, 57, 49, "Print"],
Cell[99304, 2160, 646, 10, 26, "Print"],
Cell[99953, 2172, 695, 13, 26, "Print"],
Cell[100651, 2187, 882, 15, 26, "Print"],
Cell[101536, 2204, 881, 15, 26, "Print"],
Cell[102420, 2221, 955, 18, 30, "Print"],
Cell[103378, 2241, 578, 9, 26, "Print"],
Cell[103959, 2252, 1941, 57, 49, "Print"],
Cell[105903, 2311, 644, 10, 26, "Print"],
Cell[106550, 2323, 693, 13, 26, "Print"],
Cell[107246, 2338, 879, 15, 26, "Print"],
Cell[108128, 2355, 953, 18, 31, "Print"],
Cell[109084, 2375, 882, 15, 26, "Print"],
Cell[109969, 2392, 577, 9, 26, "Print"],
Cell[110549, 2403, 1943, 57, 49, "Print"],
Cell[112495, 2462, 644, 10, 26, "Print"],
Cell[113142, 2474, 695, 13, 26, "Print"],
Cell[113840, 2489, 879, 15, 26, "Print"],
Cell[114722, 2506, 881, 15, 26, "Print"],
Cell[115606, 2523, 957, 18, 32, "Print"],
Cell[116566, 2543, 578, 9, 26, "Print"],
Cell[117147, 2554, 1941, 57, 49, "Print"],
Cell[119091, 2613, 644, 10, 26, "Print"],
Cell[119738, 2625, 693, 13, 26, "Print"],
Cell[120434, 2640, 881, 15, 26, "Print"],
Cell[121318, 2657, 877, 15, 26, "Print"],
Cell[122198, 2674, 957, 18, 32, "Print"],
Cell[123158, 2694, 577, 9, 26, "Print"],
Cell[123738, 2705, 1943, 57, 49, "Print"],
Cell[125684, 2764, 646, 10, 26, "Print"],
Cell[126333, 2776, 695, 13, 26, "Print"],
Cell[127031, 2791, 879, 15, 26, "Print"],
Cell[127913, 2808, 955, 18, 32, "Print"],
Cell[128871, 2828, 877, 15, 26, "Print"],
Cell[129751, 2845, 578, 9, 26, "Print"],
Cell[130332, 2856, 1941, 57, 49, "Print"],
Cell[132276, 2915, 644, 10, 26, "Print"],
Cell[132923, 2927, 693, 13, 26, "Print"],
Cell[133619, 2942, 881, 15, 26, "Print"],
Cell[134503, 2959, 884, 15, 26, "Print"],
Cell[135390, 2976, 955, 18, 30, "Print"],
Cell[136348, 2996, 577, 9, 26, "Print"],
Cell[136928, 3007, 1940, 57, 49, "Print"],
Cell[138871, 3066, 644, 10, 26, "Print"],
Cell[139518, 3078, 695, 13, 26, "Print"],
Cell[140216, 3093, 882, 15, 26, "Print"],
Cell[141101, 3110, 955, 18, 33, "Print"],
Cell[142059, 3130, 879, 15, 26, "Print"],
Cell[142941, 3147, 580, 9, 26, "Print"],
Cell[143524, 3158, 1320, 39, 38, "Print"],
Cell[144847, 3199, 646, 10, 26, "Print"],
Cell[145496, 3211, 693, 13, 26, "Print"],
Cell[146192, 3226, 881, 15, 26, "Print"],
Cell[147076, 3243, 882, 15, 26, "Print"],
Cell[147961, 3260, 955, 18, 32, "Print"],
Cell[148919, 3280, 580, 9, 26, "Print"],
Cell[149502, 3291, 1322, 39, 38, "Print"],
Cell[150827, 3332, 644, 10, 26, "Print"],
Cell[151474, 3344, 695, 13, 26, "Print"],
Cell[152172, 3359, 879, 15, 26, "Print"],
Cell[153054, 3376, 879, 15, 26, "Print"],
Cell[153936, 3393, 955, 18, 30, "Print"],
Cell[154894, 3413, 580, 9, 26, "Print"],
Cell[155477, 3424, 1320, 39, 38, "Print"],
Cell[156800, 3465, 646, 10, 26, "Print"],
Cell[157449, 3477, 693, 13, 26, "Print"],
Cell[158145, 3492, 879, 15, 26, "Print"],
Cell[159027, 3509, 877, 15, 26, "Print"],
Cell[159907, 3526, 955, 18, 30, "Print"],
Cell[160865, 3546, 577, 9, 26, "Print"],
Cell[161445, 3557, 1320, 39, 38, "Print"],
Cell[162768, 3598, 644, 10, 26, "Print"],
Cell[163415, 3610, 695, 13, 26, "Print"],
Cell[164113, 3625, 877, 15, 26, "Print"],
Cell[164993, 3642, 957, 18, 32, "Print"],
Cell[165953, 3662, 881, 15, 26, "Print"],
Cell[166837, 3679, 580, 9, 26, "Print"],
Cell[167420, 3690, 2265, 72, 34, "Print"],
Cell[169688, 3764, 644, 10, 26, "Print"],
Cell[170335, 3776, 695, 13, 26, "Print"],
Cell[171033, 3791, 879, 15, 26, "Print"],
Cell[171915, 3808, 955, 18, 32, "Print"],
Cell[172873, 3828, 879, 15, 26, "Print"],
Cell[173755, 3845, 578, 9, 26, "Print"],
Cell[174336, 3856, 2265, 72, 34, "Print"],
Cell[176604, 3930, 644, 10, 26, "Print"],
Cell[177251, 3942, 693, 13, 26, "Print"],
Cell[177947, 3957, 877, 15, 26, "Print"],
Cell[178827, 3974, 957, 18, 32, "Print"],
Cell[179787, 3994, 881, 15, 26, "Print"],
Cell[180671, 4011, 578, 9, 26, "Print"],
Cell[181252, 4022, 2262, 72, 34, "Print"],
Cell[183517, 4096, 644, 10, 26, "Print"],
Cell[184164, 4108, 695, 13, 26, "Print"],
Cell[184862, 4123, 882, 15, 26, "Print"],
Cell[185747, 4140, 955, 18, 30, "Print"],
Cell[186705, 4160, 879, 15, 26, "Print"],
Cell[187587, 4177, 580, 9, 26, "Print"],
Cell[188170, 4188, 2265, 72, 34, "Print"],
Cell[190438, 4262, 646, 10, 26, "Print"],
Cell[191087, 4274, 693, 13, 26, "Print"],
Cell[191783, 4289, 879, 15, 26, "Print"],
Cell[192665, 4306, 879, 15, 26, "Print"],
Cell[193547, 4323, 955, 18, 30, "Print"],
Cell[194505, 4343, 577, 9, 26, "Print"],
Cell[195085, 4354, 2263, 72, 34, "Print"],
Cell[197351, 4428, 646, 10, 26, "Print"],
Cell[198000, 4440, 695, 13, 26, "Print"],
Cell[198698, 4455, 879, 15, 26, "Print"],
Cell[199580, 4472, 879, 15, 26, "Print"],
Cell[200462, 4489, 955, 18, 30, "Print"],
Cell[201420, 4509, 580, 9, 26, "Print"],
Cell[202003, 4520, 2263, 72, 34, "Print"],
Cell[204269, 4594, 646, 10, 26, "Print"],
Cell[204918, 4606, 695, 13, 26, "Print"],
Cell[205616, 4621, 877, 15, 26, "Print"],
Cell[206496, 4638, 878, 15, 26, "Print"],
Cell[207377, 4655, 955, 18, 30, "Print"],
Cell[208335, 4675, 580, 9, 26, "Print"],
Cell[208918, 4686, 2261, 72, 34, "Print"],
Cell[211182, 4760, 646, 10, 26, "Print"],
Cell[211831, 4772, 695, 13, 26, "Print"],
Cell[212529, 4787, 953, 18, 33, "Print"],
Cell[213485, 4807, 884, 15, 26, "Print"],
Cell[214372, 4824, 956, 18, 29, "Print"],
Cell[215331, 4844, 578, 9, 26, "Print"],
Cell[215912, 4855, 2263, 72, 34, "Print"],
Cell[218178, 4929, 646, 10, 26, "Print"],
Cell[218827, 4941, 693, 13, 26, "Print"],
Cell[219523, 4956, 957, 18, 33, "Print"],
Cell[220483, 4976, 879, 15, 26, "Print"],
Cell[221365, 4993, 958, 18, 29, "Print"],
Cell[222326, 5013, 578, 9, 26, "Print"],
Cell[222907, 5024, 2263, 72, 34, "Print"],
Cell[225173, 5098, 646, 10, 26, "Print"],
Cell[225822, 5110, 693, 13, 26, "Print"],
Cell[226518, 5125, 955, 18, 33, "Print"],
Cell[227476, 5145, 877, 15, 26, "Print"],
Cell[228356, 5162, 958, 18, 29, "Print"],
Cell[229317, 5182, 580, 9, 26, "Print"],
Cell[229900, 5193, 2265, 72, 34, "Print"],
Cell[232168, 5267, 644, 10, 26, "Print"],
Cell[232815, 5279, 695, 13, 26, "Print"],
Cell[233513, 5294, 957, 18, 33, "Print"],
Cell[234473, 5314, 877, 15, 26, "Print"],
Cell[235353, 5331, 958, 18, 29, "Print"],
Cell[236314, 5351, 580, 9, 26, "Print"],
Cell[236897, 5362, 2263, 72, 34, "Print"],
Cell[239163, 5436, 644, 10, 26, "Print"],
Cell[239810, 5448, 693, 13, 26, "Print"],
Cell[240506, 5463, 953, 18, 30, "Print"],
Cell[241462, 5483, 956, 18, 29, "Print"],
Cell[242421, 5503, 879, 15, 26, "Print"],
Cell[243303, 5520, 580, 9, 26, "Print"],
Cell[243886, 5531, 2261, 72, 34, "Print"],
Cell[246150, 5605, 646, 10, 26, "Print"],
Cell[246799, 5617, 695, 13, 26, "Print"],
Cell[247497, 5632, 955, 18, 33, "Print"],
Cell[248455, 5652, 882, 15, 26, "Print"],
Cell[249340, 5669, 958, 18, 29, "Print"],
Cell[250301, 5689, 578, 9, 26, "Print"],
Cell[250882, 5700, 2265, 72, 34, "Print"],
Cell[253150, 5774, 646, 10, 26, "Print"],
Cell[253799, 5786, 695, 13, 26, "Print"],
Cell[254497, 5801, 953, 18, 30, "Print"],
Cell[255453, 5821, 882, 15, 26, "Print"],
Cell[256338, 5838, 956, 18, 29, "Print"],
Cell[257297, 5858, 580, 9, 26, "Print"],
Cell[257880, 5869, 2263, 72, 34, "Print"],
Cell[260146, 5943, 646, 10, 26, "Print"],
Cell[260795, 5955, 692, 13, 26, "Print"],
Cell[261490, 5970, 953, 18, 31, "Print"],
Cell[262446, 5990, 956, 18, 29, "Print"],
Cell[263405, 6010, 879, 15, 26, "Print"],
Cell[264287, 6027, 578, 9, 26, "Print"],
Cell[264868, 6038, 2261, 72, 34, "Print"],
Cell[267132, 6112, 644, 10, 26, "Print"],
Cell[267779, 6124, 695, 13, 26, "Print"],
Cell[268477, 6139, 955, 18, 30, "Print"],
Cell[269435, 6159, 958, 18, 29, "Print"],
Cell[270396, 6179, 877, 15, 26, "Print"],
Cell[271276, 6196, 580, 9, 26, "Print"],
Cell[271859, 6207, 2263, 72, 34, "Print"],
Cell[274125, 6281, 646, 10, 26, "Print"],
Cell[274774, 6293, 695, 13, 26, "Print"],
Cell[275472, 6308, 879, 15, 26, "Print"],
Cell[276354, 6325, 958, 18, 29, "Print"],
Cell[277315, 6345, 955, 18, 30, "Print"],
Cell[278273, 6365, 578, 9, 26, "Print"],
Cell[278854, 6376, 2263, 72, 34, "Print"],
Cell[281120, 6450, 644, 10, 26, "Print"],
Cell[281767, 6462, 695, 13, 26, "Print"],
Cell[282465, 6477, 879, 15, 26, "Print"],
Cell[283347, 6494, 956, 18, 29, "Print"],
Cell[284306, 6514, 955, 18, 30, "Print"],
Cell[285264, 6534, 580, 9, 26, "Print"],
Cell[285847, 6545, 2263, 72, 34, "Print"],
Cell[288113, 6619, 644, 10, 26, "Print"],
Cell[288760, 6631, 695, 13, 26, "Print"],
Cell[289458, 6646, 877, 15, 26, "Print"],
Cell[290338, 6663, 956, 18, 29, "Print"],
Cell[291297, 6683, 955, 18, 30, "Print"],
Cell[292255, 6703, 580, 9, 26, "Print"],
Cell[292838, 6714, 2263, 72, 34, "Print"],
Cell[295104, 6788, 646, 10, 26, "Print"],
Cell[295753, 6800, 693, 13, 26, "Print"],
Cell[296449, 6815, 953, 18, 33, "Print"],
Cell[297405, 6835, 884, 15, 26, "Print"],
Cell[298292, 6852, 884, 15, 26, "Print"],
Cell[299179, 6869, 580, 9, 26, "Print"],
Cell[299762, 6880, 2263, 72, 34, "Print"],
Cell[302028, 6954, 646, 10, 26, "Print"],
Cell[302677, 6966, 695, 13, 26, "Print"],
Cell[303375, 6981, 877, 15, 26, "Print"],
Cell[304255, 6998, 957, 18, 33, "Print"],
Cell[305215, 7018, 884, 15, 26, "Print"],
Cell[306102, 7035, 580, 9, 26, "Print"],
Cell[306685, 7046, 2265, 72, 34, "Print"],
Cell[308953, 7120, 644, 10, 26, "Print"],
Cell[309600, 7132, 693, 13, 26, "Print"],
Cell[310296, 7147, 957, 18, 33, "Print"],
Cell[311256, 7167, 879, 15, 26, "Print"],
Cell[312138, 7184, 882, 15, 26, "Print"],
Cell[313023, 7201, 580, 9, 26, "Print"],
Cell[313606, 7212, 2263, 72, 34, "Print"],
Cell[315872, 7286, 646, 10, 26, "Print"],
Cell[316521, 7298, 695, 13, 26, "Print"],
Cell[317219, 7313, 957, 18, 33, "Print"],
Cell[318179, 7333, 876, 15, 26, "Print"],
Cell[319058, 7350, 882, 15, 26, "Print"],
Cell[319943, 7367, 580, 9, 26, "Print"],
Cell[320526, 7378, 2265, 72, 34, "Print"],
Cell[322794, 7452, 644, 10, 26, "Print"],
Cell[323441, 7464, 695, 13, 26, "Print"],
Cell[324139, 7479, 953, 18, 30, "Print"],
Cell[325095, 7499, 884, 15, 26, "Print"],
Cell[325982, 7516, 884, 15, 26, "Print"],
Cell[326869, 7533, 580, 9, 26, "Print"],
Cell[327452, 7544, 2265, 72, 34, "Print"],
Cell[329720, 7618, 646, 10, 26, "Print"],
Cell[330369, 7630, 695, 13, 26, "Print"],
Cell[331067, 7645, 884, 15, 26, "Print"],
Cell[331954, 7662, 953, 18, 33, "Print"],
Cell[332910, 7682, 884, 15, 26, "Print"],
Cell[333797, 7699, 578, 9, 26, "Print"],
Cell[334378, 7710, 2265, 72, 34, "Print"],
Cell[336646, 7784, 646, 10, 26, "Print"],
Cell[337295, 7796, 693, 13, 26, "Print"],
Cell[337991, 7811, 882, 15, 26, "Print"],
Cell[338876, 7828, 953, 18, 30, "Print"],
Cell[339832, 7848, 882, 15, 26, "Print"],
Cell[340717, 7865, 578, 9, 26, "Print"],
Cell[341298, 7876, 2263, 72, 34, "Print"],
Cell[343564, 7950, 646, 10, 26, "Print"],
Cell[344213, 7962, 693, 13, 26, "Print"],
Cell[344909, 7977, 953, 18, 31, "Print"],
Cell[345865, 7997, 884, 15, 26, "Print"],
Cell[346752, 8014, 884, 15, 26, "Print"],
Cell[347639, 8031, 580, 9, 26, "Print"],
Cell[348222, 8042, 2265, 72, 34, "Print"],
Cell[350490, 8116, 646, 10, 26, "Print"],
Cell[351139, 8128, 693, 13, 26, "Print"],
Cell[351835, 8143, 879, 15, 26, "Print"],
Cell[352717, 8160, 957, 18, 32, "Print"],
Cell[353677, 8180, 884, 15, 26, "Print"],
Cell[354564, 8197, 578, 9, 26, "Print"],
Cell[355145, 8208, 2265, 72, 34, "Print"],
Cell[357413, 8282, 644, 10, 26, "Print"],
Cell[358060, 8294, 693, 13, 26, "Print"],
Cell[358756, 8309, 877, 15, 26, "Print"],
Cell[359636, 8326, 957, 18, 32, "Print"],
Cell[360596, 8346, 884, 15, 26, "Print"],
Cell[361483, 8363, 578, 9, 26, "Print"],
Cell[362064, 8374, 2265, 72, 34, "Print"],
Cell[364332, 8448, 644, 10, 26, "Print"],
Cell[364979, 8460, 692, 13, 26, "Print"],
Cell[365674, 8475, 957, 18, 32, "Print"],
Cell[366634, 8495, 877, 15, 26, "Print"],
Cell[367514, 8512, 884, 15, 26, "Print"],
Cell[368401, 8529, 580, 9, 26, "Print"],
Cell[368984, 8540, 2265, 72, 34, "Print"],
Cell[371252, 8614, 644, 10, 26, "Print"],
Cell[371899, 8626, 695, 13, 26, "Print"],
Cell[372597, 8641, 882, 15, 26, "Print"],
Cell[373482, 8658, 953, 18, 30, "Print"],
Cell[374438, 8678, 884, 15, 26, "Print"],
Cell[375325, 8695, 578, 9, 26, "Print"],
Cell[375906, 8706, 2265, 72, 34, "Print"],
Cell[378174, 8780, 646, 10, 26, "Print"],
Cell[378823, 8792, 695, 13, 26, "Print"],
Cell[379521, 8807, 953, 18, 33, "Print"],
Cell[380477, 8827, 881, 15, 26, "Print"],
Cell[381361, 8844, 877, 15, 26, "Print"],
Cell[382241, 8861, 578, 9, 26, "Print"],
Cell[382822, 8872, 2261, 72, 34, "Print"],
Cell[385086, 8946, 646, 10, 26, "Print"],
Cell[385735, 8958, 693, 13, 26, "Print"],
Cell[386431, 8973, 884, 15, 26, "Print"],
Cell[387318, 8990, 953, 18, 30, "Print"],
Cell[388274, 9010, 881, 15, 26, "Print"],
Cell[389158, 9027, 578, 9, 26, "Print"],
Cell[389739, 9038, 2265, 72, 34, "Print"],
Cell[392007, 9112, 643, 10, 26, "Print"],
Cell[392653, 9124, 695, 13, 26, "Print"],
Cell[393351, 9139, 953, 18, 33, "Print"],
Cell[394307, 9159, 881, 15, 26, "Print"],
Cell[395191, 9176, 877, 15, 26, "Print"],
Cell[396071, 9193, 580, 9, 26, "Print"],
Cell[396654, 9204, 2261, 72, 34, "Print"],
Cell[398918, 9278, 644, 10, 26, "Print"],
Cell[399565, 9290, 693, 13, 26, "Print"],
Cell[400261, 9305, 953, 18, 30, "Print"],
Cell[401217, 9325, 881, 15, 26, "Print"],
Cell[402101, 9342, 877, 15, 26, "Print"],
Cell[402981, 9359, 580, 9, 26, "Print"],
Cell[403564, 9370, 2259, 72, 34, "Print"],
Cell[405826, 9444, 644, 10, 26, "Print"],
Cell[406473, 9456, 693, 13, 26, "Print"],
Cell[407169, 9471, 882, 15, 26, "Print"],
Cell[408054, 9488, 953, 18, 31, "Print"],
Cell[409010, 9508, 881, 15, 26, "Print"],
Cell[409894, 9525, 580, 9, 26, "Print"],
Cell[410477, 9536, 2263, 72, 34, "Print"],
Cell[412743, 9610, 644, 10, 26, "Print"]
}, Open  ]],
Cell[413402, 9623, 125407, 3856, 2872, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[538870, 13486, 238, 5, 86, "Section"],
Cell[CellGroupData[{
Cell[539133, 13495, 215, 4, 46, "Subsection"],
Cell[CellGroupData[{
Cell[539373, 13503, 154, 3, 36, "Input"],
Cell[CellGroupData[{
Cell[539552, 13510, 577, 9, 26, "Print"],
Cell[540132, 13521, 573, 9, 26, "Print"],
Cell[540708, 13532, 533, 9, 26, "Print"],
Cell[541244, 13543, 558, 9, 26, "Print"],
Cell[541805, 13554, 722, 13, 26, "Print"],
Cell[542530, 13569, 525, 8, 26, "Print"],
Cell[543058, 13579, 542, 10, 38, "Print"],
Cell[543603, 13591, 642, 12, 26, "Print"],
Cell[544248, 13605, 542, 9, 26, "Print"],
Cell[544793, 13616, 566, 9, 26, "Print"],
Cell[545362, 13627, 2517, 73, 61, "Print"],
Cell[547882, 13702, 2517, 73, 61, "Print"],
Cell[550402, 13777, 2517, 73, 61, "Print"],
Cell[552922, 13852, 2519, 73, 61, "Print"],
Cell[555444, 13927, 2517, 73, 60, "Print"],
Cell[557964, 14002, 2516, 73, 61, "Print"],
Cell[560483, 14077, 2519, 73, 60, "Print"],
Cell[563005, 14152, 2519, 73, 60, "Print"],
Cell[565527, 14227, 2517, 73, 61, "Print"],
Cell[568047, 14302, 2519, 73, 61, "Print"],
Cell[570569, 14377, 2517, 73, 61, "Print"],
Cell[573089, 14452, 2519, 73, 60, "Print"]
}, Open  ]],
Cell[575623, 14528, 26543, 789, 624, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[602215, 15323, 266, 4, 46, "Subsection"],
Cell[CellGroupData[{
Cell[602506, 15331, 1163, 27, 159, "Input"],
Cell[CellGroupData[{
Cell[603694, 15362, 163, 3, 32, "Print"],
Cell[603860, 15367, 188, 3, 32, "Print"],
Cell[604051, 15372, 354, 7, 32, "Print"],
Cell[604408, 15381, 157, 2, 32, "Print"],
Cell[604568, 15385, 176, 4, 38, "Print"],
Cell[604747, 15391, 274, 6, 32, "Print"],
Cell[605024, 15399, 201, 3, 32, "Print"],
Cell[605228, 15404, 246, 6, 32, "Print"],
Cell[605477, 15412, 439, 8, 32, "Print"],
Cell[605919, 15422, 437, 8, 32, "Print"],
Cell[606359, 15432, 512, 11, 43, "Print"],
Cell[606874, 15445, 135, 2, 32, "Print"],
Cell[607012, 15449, 830, 30, 55, "Print"],
Cell[607845, 15481, 198, 3, 32, "Print"],
Cell[608046, 15486, 248, 6, 32, "Print"],
Cell[608297, 15494, 437, 8, 32, "Print"],
Cell[608737, 15504, 439, 8, 32, "Print"],
Cell[609179, 15514, 512, 11, 41, "Print"],
Cell[609694, 15527, 133, 2, 32, "Print"],
Cell[609830, 15531, 810, 29, 55, "Print"],
Cell[610643, 15562, 199, 3, 32, "Print"],
Cell[610845, 15567, 246, 6, 32, "Print"],
Cell[611094, 15575, 437, 8, 32, "Print"],
Cell[611534, 15585, 434, 8, 32, "Print"],
Cell[611971, 15595, 508, 11, 38, "Print"],
Cell[612482, 15608, 133, 2, 32, "Print"],
Cell[612618, 15612, 810, 29, 55, "Print"],
Cell[613431, 15643, 201, 3, 32, "Print"],
Cell[613635, 15648, 248, 6, 32, "Print"],
Cell[613886, 15656, 437, 8, 32, "Print"],
Cell[614326, 15666, 434, 8, 32, "Print"],
Cell[614763, 15676, 510, 11, 38, "Print"],
Cell[615276, 15689, 132, 2, 32, "Print"],
Cell[615411, 15693, 828, 30, 55, "Print"],
Cell[616242, 15725, 199, 3, 32, "Print"],
Cell[616444, 15730, 248, 6, 32, "Print"],
Cell[616695, 15738, 510, 11, 43, "Print"],
Cell[617208, 15751, 437, 8, 32, "Print"],
Cell[617648, 15761, 434, 8, 32, "Print"],
Cell[618085, 15771, 135, 2, 32, "Print"],
Cell[618223, 15775, 1498, 50, 115, "Print"],
Cell[619724, 15827, 201, 3, 32, "Print"],
Cell[619928, 15832, 246, 6, 32, "Print"],
Cell[620177, 15840, 432, 8, 32, "Print"],
Cell[620612, 15850, 510, 11, 43, "Print"],
Cell[621125, 15863, 434, 8, 32, "Print"],
Cell[621562, 15873, 133, 2, 32, "Print"],
Cell[621698, 15877, 1498, 50, 115, "Print"],
Cell[623199, 15929, 201, 3, 32, "Print"],
Cell[623403, 15934, 246, 6, 32, "Print"],
Cell[623652, 15942, 512, 11, 43, "Print"],
Cell[624167, 15955, 434, 8, 32, "Print"],
Cell[624604, 15965, 434, 8, 32, "Print"],
Cell[625041, 15975, 135, 2, 32, "Print"],
Cell[625179, 15979, 1498, 50, 115, "Print"],
Cell[626680, 16031, 199, 3, 32, "Print"],
Cell[626882, 16036, 248, 6, 32, "Print"],
Cell[627133, 16044, 510, 11, 43, "Print"],
Cell[627646, 16057, 436, 8, 32, "Print"],
Cell[628085, 16067, 432, 8, 32, "Print"],
Cell[628520, 16077, 135, 2, 32, "Print"],
Cell[628658, 16081, 1498, 50, 115, "Print"],
Cell[630159, 16133, 199, 3, 32, "Print"],
Cell[630361, 16138, 245, 6, 32, "Print"],
Cell[630609, 16146, 510, 11, 38, "Print"],
Cell[631122, 16159, 436, 8, 32, "Print"],
Cell[631561, 16169, 437, 8, 32, "Print"],
Cell[632001, 16179, 135, 2, 32, "Print"],
Cell[632139, 16183, 1498, 50, 115, "Print"],
Cell[633640, 16235, 201, 3, 32, "Print"],
Cell[633844, 16240, 248, 6, 32, "Print"],
Cell[634095, 16248, 439, 8, 32, "Print"],
Cell[634537, 16258, 510, 11, 43, "Print"],
Cell[635050, 16271, 436, 8, 32, "Print"],
Cell[635489, 16281, 133, 2, 32, "Print"],
Cell[635625, 16285, 1498, 50, 115, "Print"],
Cell[637126, 16337, 201, 3, 32, "Print"],
Cell[637330, 16342, 247, 6, 32, "Print"],
Cell[637580, 16350, 437, 8, 32, "Print"],
Cell[638020, 16360, 434, 8, 32, "Print"],
Cell[638457, 16370, 508, 11, 38, "Print"],
Cell[638968, 16383, 133, 2, 32, "Print"],
Cell[639104, 16387, 1498, 50, 115, "Print"],
Cell[640605, 16439, 201, 3, 32, "Print"],
Cell[640809, 16444, 248, 6, 32, "Print"],
Cell[641060, 16452, 436, 8, 32, "Print"],
Cell[641499, 16462, 510, 11, 40, "Print"],
Cell[642012, 16475, 439, 8, 32, "Print"],
Cell[642454, 16485, 135, 2, 32, "Print"],
Cell[642592, 16489, 1496, 50, 59, "Print"],
Cell[644091, 16541, 199, 3, 32, "Print"],
Cell[644293, 16546, 248, 6, 32, "Print"],
Cell[644544, 16554, 434, 8, 32, "Print"],
Cell[644981, 16564, 433, 8, 32, "Print"],
Cell[645417, 16574, 510, 11, 41, "Print"],
Cell[645930, 16587, 135, 2, 32, "Print"],
Cell[646068, 16591, 1496, 50, 115, "Print"],
Cell[647567, 16643, 201, 3, 32, "Print"],
Cell[647771, 16648, 248, 6, 32, "Print"],
Cell[648022, 16656, 434, 8, 32, "Print"],
Cell[648459, 16666, 432, 8, 32, "Print"],
Cell[648894, 16676, 510, 11, 41, "Print"],
Cell[649407, 16689, 135, 2, 32, "Print"],
Cell[649545, 16693, 1498, 50, 59, "Print"],
Cell[651046, 16745, 199, 3, 32, "Print"],
Cell[651248, 16750, 250, 6, 32, "Print"],
Cell[651501, 16758, 434, 8, 32, "Print"],
Cell[651938, 16768, 510, 11, 41, "Print"],
Cell[652451, 16781, 434, 8, 32, "Print"],
Cell[652888, 16791, 133, 2, 32, "Print"],
Cell[653024, 16795, 1498, 50, 115, "Print"],
Cell[654525, 16847, 201, 3, 32, "Print"],
Cell[654729, 16852, 248, 6, 32, "Print"],
Cell[654980, 16860, 434, 8, 32, "Print"],
Cell[655417, 16870, 439, 8, 32, "Print"],
Cell[655859, 16880, 510, 11, 38, "Print"],
Cell[656372, 16893, 135, 2, 32, "Print"],
Cell[656510, 16897, 1496, 50, 115, "Print"],
Cell[658009, 16949, 201, 3, 32, "Print"],
Cell[658213, 16954, 250, 6, 32, "Print"],
Cell[658466, 16962, 439, 8, 32, "Print"],
Cell[658908, 16972, 512, 11, 43, "Print"],
Cell[659423, 16985, 434, 8, 32, "Print"],
Cell[659860, 16995, 135, 2, 32, "Print"],
Cell[659998, 16999, 875, 32, 44, "Print"],
Cell[660876, 17033, 199, 3, 32, "Print"],
Cell[661078, 17038, 250, 6, 32, "Print"],
Cell[661331, 17046, 433, 8, 32, "Print"],
Cell[661767, 17056, 436, 8, 32, "Print"],
Cell[662206, 17066, 512, 11, 41, "Print"],
Cell[662721, 17079, 133, 2, 32, "Print"],
Cell[662857, 17083, 875, 32, 44, "Print"],
Cell[663735, 17117, 199, 3, 32, "Print"],
Cell[663937, 17122, 250, 6, 32, "Print"],
Cell[664190, 17130, 436, 8, 32, "Print"],
Cell[664629, 17140, 432, 8, 32, "Print"],
Cell[665064, 17150, 510, 11, 38, "Print"],
Cell[665577, 17163, 133, 2, 32, "Print"],
Cell[665713, 17167, 875, 32, 44, "Print"],
Cell[666591, 17201, 201, 3, 32, "Print"],
Cell[666795, 17206, 250, 6, 32, "Print"],
Cell[667048, 17214, 434, 8, 32, "Print"],
Cell[667485, 17224, 432, 8, 32, "Print"],
Cell[667920, 17234, 508, 11, 38, "Print"],
Cell[668431, 17247, 133, 2, 32, "Print"],
Cell[668567, 17251, 877, 32, 44, "Print"],
Cell[669447, 17285, 198, 3, 32, "Print"],
Cell[669648, 17290, 250, 6, 32, "Print"],
Cell[669901, 17298, 510, 11, 43, "Print"],
Cell[670414, 17311, 434, 8, 32, "Print"],
Cell[670851, 17321, 434, 8, 32, "Print"],
Cell[671288, 17331, 135, 2, 32, "Print"],
Cell[671426, 17335, 1816, 65, 38, "Print"],
Cell[673245, 17402, 201, 3, 32, "Print"],
Cell[673449, 17407, 250, 6, 32, "Print"],
Cell[673702, 17415, 437, 8, 32, "Print"],
Cell[674142, 17425, 508, 11, 38, "Print"],
Cell[674653, 17438, 434, 8, 32, "Print"],
Cell[675090, 17448, 133, 2, 32, "Print"],
Cell[675226, 17452, 1820, 65, 38, "Print"],
Cell[677049, 17519, 201, 3, 32, "Print"],
Cell[677253, 17524, 250, 6, 32, "Print"],
Cell[677506, 17532, 508, 11, 43, "Print"],
Cell[678017, 17545, 434, 8, 32, "Print"],
Cell[678454, 17555, 430, 8, 32, "Print"],
Cell[678887, 17565, 131, 2, 32, "Print"],
Cell[679021, 17569, 1818, 65, 38, "Print"],
Cell[680842, 17636, 199, 3, 32, "Print"],
Cell[681044, 17641, 250, 6, 32, "Print"],
Cell[681297, 17649, 508, 11, 38, "Print"],
Cell[681808, 17662, 436, 8, 32, "Print"],
Cell[682247, 17672, 434, 8, 32, "Print"],
Cell[682684, 17682, 133, 2, 32, "Print"],
Cell[682820, 17686, 1818, 65, 38, "Print"],
Cell[684641, 17753, 199, 3, 32, "Print"],
Cell[684843, 17758, 250, 6, 32, "Print"],
Cell[685096, 17766, 437, 8, 32, "Print"],
Cell[685536, 17776, 508, 11, 40, "Print"],
Cell[686047, 17789, 436, 8, 32, "Print"],
Cell[686486, 17799, 133, 2, 32, "Print"],
Cell[686622, 17803, 1818, 65, 38, "Print"],
Cell[688443, 17870, 201, 3, 32, "Print"],
Cell[688647, 17875, 248, 6, 32, "Print"],
Cell[688898, 17883, 434, 8, 32, "Print"],
Cell[689335, 17893, 512, 11, 41, "Print"],
Cell[689850, 17906, 436, 8, 32, "Print"],
Cell[690289, 17916, 135, 2, 32, "Print"],
Cell[690427, 17920, 1820, 65, 38, "Print"],
Cell[692250, 17987, 201, 3, 32, "Print"],
Cell[692454, 17992, 248, 6, 32, "Print"],
Cell[692705, 18000, 434, 8, 32, "Print"],
Cell[693142, 18010, 512, 11, 41, "Print"],
Cell[693657, 18023, 436, 8, 32, "Print"],
Cell[694096, 18033, 133, 2, 32, "Print"],
Cell[694232, 18037, 1818, 65, 38, "Print"],
Cell[696053, 18104, 199, 3, 32, "Print"],
Cell[696255, 18109, 250, 6, 32, "Print"],
Cell[696508, 18117, 434, 8, 32, "Print"],
Cell[696945, 18127, 512, 11, 41, "Print"],
Cell[697460, 18140, 434, 8, 32, "Print"],
Cell[697897, 18150, 135, 2, 32, "Print"],
Cell[698035, 18154, 1818, 65, 38, "Print"],
Cell[699856, 18221, 201, 3, 32, "Print"],
Cell[700060, 18226, 248, 6, 32, "Print"],
Cell[700311, 18234, 439, 8, 32, "Print"],
Cell[700753, 18244, 508, 11, 38, "Print"],
Cell[701264, 18257, 434, 8, 32, "Print"],
Cell[701701, 18267, 133, 2, 32, "Print"],
Cell[701837, 18271, 1820, 65, 38, "Print"],
Cell[703660, 18338, 199, 3, 32, "Print"],
Cell[703862, 18343, 250, 6, 32, "Print"],
Cell[704115, 18351, 432, 8, 32, "Print"],
Cell[704550, 18361, 436, 8, 32, "Print"],
Cell[704989, 18371, 508, 11, 38, "Print"],
Cell[705500, 18384, 133, 2, 32, "Print"],
Cell[705636, 18388, 1816, 65, 38, "Print"],
Cell[707455, 18455, 199, 3, 32, "Print"],
Cell[707657, 18460, 250, 6, 32, "Print"],
Cell[707910, 18468, 431, 8, 32, "Print"],
Cell[708344, 18478, 436, 8, 32, "Print"],
Cell[708783, 18488, 510, 11, 38, "Print"],
Cell[709296, 18501, 135, 2, 32, "Print"],
Cell[709434, 18505, 1818, 65, 38, "Print"],
Cell[711255, 18572, 201, 3, 32, "Print"],
Cell[711459, 18577, 250, 6, 32, "Print"],
Cell[711712, 18585, 434, 8, 32, "Print"],
Cell[712149, 18595, 434, 8, 32, "Print"],
Cell[712586, 18605, 510, 11, 38, "Print"],
Cell[713099, 18618, 133, 2, 32, "Print"],
Cell[713235, 18622, 1818, 65, 38, "Print"],
Cell[715056, 18689, 198, 3, 32, "Print"],
Cell[715257, 18694, 250, 6, 32, "Print"],
Cell[715510, 18702, 508, 11, 43, "Print"],
Cell[716021, 18715, 439, 8, 32, "Print"],
Cell[716463, 18725, 513, 11, 35, "Print"],
Cell[716979, 18738, 135, 2, 32, "Print"],
Cell[717117, 18742, 1818, 65, 38, "Print"],
Cell[718938, 18809, 199, 3, 32, "Print"],
Cell[719140, 18814, 250, 6, 32, "Print"],
Cell[719393, 18822, 512, 11, 43, "Print"],
Cell[719908, 18835, 434, 8, 32, "Print"],
Cell[720345, 18845, 513, 11, 35, "Print"],
Cell[720861, 18858, 135, 2, 32, "Print"],
Cell[720999, 18862, 1817, 65, 38, "Print"],
Cell[722819, 18929, 201, 3, 32, "Print"],
Cell[723023, 18934, 250, 6, 32, "Print"],
Cell[723276, 18942, 512, 11, 43, "Print"],
Cell[723791, 18955, 432, 8, 32, "Print"],
Cell[724226, 18965, 513, 11, 35, "Print"],
Cell[724742, 18978, 135, 2, 32, "Print"],
Cell[724880, 18982, 1820, 65, 38, "Print"],
Cell[726703, 19049, 201, 3, 32, "Print"],
Cell[726907, 19054, 248, 6, 32, "Print"],
Cell[727158, 19062, 512, 11, 43, "Print"],
Cell[727673, 19075, 434, 8, 32, "Print"],
Cell[728110, 19085, 513, 11, 35, "Print"],
Cell[728626, 19098, 133, 2, 32, "Print"],
Cell[728762, 19102, 1820, 65, 38, "Print"],
Cell[730585, 19169, 199, 3, 32, "Print"],
Cell[730787, 19174, 250, 6, 32, "Print"],
Cell[731040, 19182, 508, 11, 38, "Print"],
Cell[731551, 19195, 513, 11, 35, "Print"],
Cell[732067, 19208, 432, 8, 32, "Print"],
Cell[732502, 19218, 135, 2, 32, "Print"],
Cell[732640, 19222, 1818, 65, 38, "Print"],
Cell[734461, 19289, 201, 3, 32, "Print"],
Cell[734665, 19294, 247, 6, 32, "Print"],
Cell[734915, 19302, 510, 11, 43, "Print"],
Cell[735428, 19315, 439, 8, 32, "Print"],
Cell[735870, 19325, 511, 11, 35, "Print"],
Cell[736384, 19338, 135, 2, 32, "Print"],
Cell[736522, 19342, 1818, 65, 38, "Print"],
Cell[738343, 19409, 201, 3, 32, "Print"],
Cell[738547, 19414, 248, 6, 32, "Print"],
Cell[738798, 19422, 510, 11, 38, "Print"],
Cell[739311, 19435, 439, 8, 32, "Print"],
Cell[739753, 19445, 513, 11, 35, "Print"],
Cell[740269, 19458, 135, 2, 32, "Print"],
Cell[740407, 19462, 1820, 65, 38, "Print"],
Cell[742230, 19529, 201, 3, 32, "Print"],
Cell[742434, 19534, 248, 6, 32, "Print"],
Cell[742685, 19542, 510, 11, 40, "Print"],
Cell[743198, 19555, 513, 11, 35, "Print"],
Cell[743714, 19568, 432, 8, 32, "Print"],
Cell[744149, 19578, 133, 2, 32, "Print"],
Cell[744285, 19582, 1816, 65, 38, "Print"],
Cell[746104, 19649, 201, 3, 32, "Print"],
Cell[746308, 19654, 250, 6, 32, "Print"],
Cell[746561, 19662, 508, 11, 38, "Print"],
Cell[747072, 19675, 511, 11, 35, "Print"],
Cell[747586, 19688, 434, 8, 32, "Print"],
Cell[748023, 19698, 133, 2, 32, "Print"],
Cell[748159, 19702, 1816, 65, 38, "Print"],
Cell[749978, 19769, 201, 3, 32, "Print"],
Cell[750182, 19774, 250, 6, 32, "Print"],
Cell[750435, 19782, 434, 8, 32, "Print"],
Cell[750872, 19792, 513, 11, 35, "Print"],
Cell[751388, 19805, 510, 11, 38, "Print"],
Cell[751901, 19818, 135, 2, 32, "Print"],
Cell[752039, 19822, 1816, 65, 38, "Print"],
Cell[753858, 19889, 201, 3, 32, "Print"],
Cell[754062, 19894, 250, 6, 32, "Print"],
Cell[754315, 19902, 434, 8, 32, "Print"],
Cell[754752, 19912, 511, 11, 35, "Print"],
Cell[755266, 19925, 508, 11, 38, "Print"],
Cell[755777, 19938, 133, 2, 32, "Print"],
Cell[755913, 19942, 1818, 65, 38, "Print"],
Cell[757734, 20009, 201, 3, 32, "Print"],
Cell[757938, 20014, 250, 6, 32, "Print"],
Cell[758191, 20022, 432, 8, 32, "Print"],
Cell[758626, 20032, 513, 11, 35, "Print"],
Cell[759142, 20045, 510, 11, 38, "Print"],
Cell[759655, 20058, 133, 2, 32, "Print"],
Cell[759791, 20062, 1818, 65, 38, "Print"],
Cell[761612, 20129, 199, 3, 32, "Print"],
Cell[761814, 20134, 250, 6, 32, "Print"],
Cell[762067, 20142, 510, 11, 43, "Print"],
Cell[762580, 20155, 439, 8, 32, "Print"],
Cell[763022, 20165, 437, 8, 32, "Print"],
Cell[763462, 20175, 135, 2, 32, "Print"],
Cell[763600, 20179, 1818, 65, 38, "Print"],
Cell[765421, 20246, 199, 3, 32, "Print"],
Cell[765623, 20251, 250, 6, 32, "Print"],
Cell[765876, 20259, 432, 8, 32, "Print"],
Cell[766311, 20269, 512, 11, 43, "Print"],
Cell[766826, 20282, 439, 8, 32, "Print"],
Cell[767268, 20292, 133, 2, 32, "Print"],
Cell[767404, 20296, 1818, 65, 38, "Print"],
Cell[769225, 20363, 199, 3, 32, "Print"],
Cell[769427, 20368, 250, 6, 32, "Print"],
Cell[769680, 20376, 512, 11, 43, "Print"],
Cell[770195, 20389, 434, 8, 32, "Print"],
Cell[770632, 20399, 437, 8, 32, "Print"],
Cell[771072, 20409, 133, 2, 32, "Print"],
Cell[771208, 20413, 1818, 65, 38, "Print"],
Cell[773029, 20480, 199, 3, 32, "Print"],
Cell[773231, 20485, 248, 6, 32, "Print"],
Cell[773482, 20493, 510, 11, 43, "Print"],
Cell[773995, 20506, 434, 8, 32, "Print"],
Cell[774432, 20516, 437, 8, 32, "Print"],
Cell[774872, 20526, 133, 2, 32, "Print"],
Cell[775008, 20530, 1820, 65, 38, "Print"],
Cell[776831, 20597, 201, 3, 32, "Print"],
Cell[777035, 20602, 250, 6, 32, "Print"],
Cell[777288, 20610, 510, 11, 38, "Print"],
Cell[777801, 20623, 437, 8, 32, "Print"],
Cell[778241, 20633, 439, 8, 32, "Print"],
Cell[778683, 20643, 133, 2, 32, "Print"],
Cell[778819, 20647, 1818, 65, 38, "Print"],
Cell[780640, 20714, 199, 3, 32, "Print"],
Cell[780842, 20719, 250, 6, 32, "Print"],
Cell[781095, 20727, 439, 8, 32, "Print"],
Cell[781537, 20737, 508, 11, 43, "Print"],
Cell[782048, 20750, 437, 8, 32, "Print"],
Cell[782488, 20760, 133, 2, 32, "Print"],
Cell[782624, 20764, 1820, 65, 38, "Print"],
Cell[784447, 20831, 201, 3, 32, "Print"],
Cell[784651, 20836, 250, 6, 32, "Print"],
Cell[784904, 20844, 439, 8, 32, "Print"],
Cell[785346, 20854, 510, 11, 38, "Print"],
Cell[785859, 20867, 439, 8, 32, "Print"],
Cell[786301, 20877, 135, 2, 32, "Print"],
Cell[786439, 20881, 1820, 65, 38, "Print"],
Cell[788262, 20948, 199, 3, 32, "Print"],
Cell[788464, 20953, 250, 6, 32, "Print"],
Cell[788717, 20961, 510, 11, 40, "Print"],
Cell[789230, 20974, 437, 8, 32, "Print"],
Cell[789670, 20984, 439, 8, 32, "Print"],
Cell[790112, 20994, 133, 2, 32, "Print"],
Cell[790248, 20998, 1817, 65, 38, "Print"],
Cell[792068, 21065, 199, 3, 32, "Print"],
Cell[792270, 21070, 250, 6, 32, "Print"],
Cell[792523, 21078, 432, 8, 32, "Print"],
Cell[792958, 21088, 512, 11, 41, "Print"],
Cell[793473, 21101, 437, 8, 32, "Print"],
Cell[793913, 21111, 135, 2, 32, "Print"],
Cell[794051, 21115, 1818, 65, 38, "Print"],
Cell[795872, 21182, 199, 3, 32, "Print"],
Cell[796074, 21187, 250, 6, 32, "Print"],
Cell[796327, 21195, 432, 8, 32, "Print"],
Cell[796762, 21205, 512, 11, 41, "Print"],
Cell[797277, 21218, 436, 8, 32, "Print"],
Cell[797716, 21228, 135, 2, 32, "Print"],
Cell[797854, 21232, 1818, 65, 38, "Print"],
Cell[799675, 21299, 201, 3, 32, "Print"],
Cell[799879, 21304, 248, 6, 32, "Print"],
Cell[800130, 21312, 512, 11, 41, "Print"],
Cell[800645, 21325, 432, 8, 32, "Print"],
Cell[801080, 21335, 439, 8, 32, "Print"],
Cell[801522, 21345, 133, 2, 32, "Print"],
Cell[801658, 21349, 1820, 65, 38, "Print"],
Cell[803481, 21416, 199, 3, 32, "Print"],
Cell[803683, 21421, 248, 6, 32, "Print"],
Cell[803934, 21429, 439, 8, 32, "Print"],
Cell[804376, 21439, 507, 11, 38, "Print"],
Cell[804886, 21452, 436, 8, 32, "Print"],
Cell[805325, 21462, 135, 2, 32, "Print"],
Cell[805463, 21466, 1818, 65, 38, "Print"],
Cell[807284, 21533, 201, 3, 32, "Print"]
}, Open  ]],
Cell[807500, 21539, 555, 14, 48, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[808104, 21559, 301, 6, 46, "Subsection"],
Cell[CellGroupData[{
Cell[808430, 21569, 407, 8, 79, "Input"],
Cell[CellGroupData[{
Cell[808862, 21581, 658, 12, 32, "Print"],
Cell[809523, 21595, 658, 12, 32, "Print"],
Cell[810184, 21609, 439, 7, 32, "Print"]
}, Open  ]],
Cell[810638, 21619, 391, 6, 42, "Output"],
Cell[CellGroupData[{
Cell[811054, 21629, 658, 12, 32, "Print"],
Cell[811715, 21643, 434, 7, 32, "Print"]
}, Open  ]],
Cell[812164, 21653, 391, 6, 42, "Output"],
Cell[CellGroupData[{
Cell[812580, 21663, 657, 12, 32, "Print"],
Cell[813240, 21677, 431, 6, 32, "Print"]
}, Open  ]],
Cell[813686, 21686, 391, 6, 42, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[814126, 21698, 346, 7, 46, "Subsection"],
Cell[CellGroupData[{
Cell[814497, 21709, 246, 5, 59, "Input"],
Cell[CellGroupData[{
Cell[814768, 21718, 582, 11, 32, "Print"],
Cell[815353, 21731, 358, 6, 32, "Print"],
Cell[815714, 21739, 582, 11, 32, "Print"],
Cell[816299, 21752, 369, 6, 32, "Print"]
}, Open  ]],
Cell[816683, 21761, 322, 5, 42, "Output"],
Cell[CellGroupData[{
Cell[817030, 21770, 582, 11, 32, "Print"],
Cell[817615, 21783, 353, 5, 32, "Print"],
Cell[817971, 21790, 582, 11, 32, "Print"],
Cell[818556, 21803, 671, 13, 58, "Print"],
Cell[819230, 21818, 669, 13, 58, "Print"],
Cell[819902, 21833, 667, 13, 58, "Print"],
Cell[820572, 21848, 664, 13, 58, "Print"],
Cell[821239, 21863, 347, 5, 32, "Print"],
Cell[821589, 21870, 388, 6, 32, "Print"]
}, Open  ]],
Cell[821992, 21879, 10012, 270, 212, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[832065, 22156, 146, 3, 86, "Section"],
Cell[CellGroupData[{
Cell[832236, 22163, 170, 3, 48, "Subsection"],
Cell[CellGroupData[{
Cell[832431, 22170, 405, 8, 59, "Input"],
Cell[CellGroupData[{
Cell[832861, 22182, 276, 5, 32, "Print"],
Cell[833140, 22189, 728, 18, 32, "Print"],
Cell[833871, 22209, 720, 18, 32, "Print"],
Cell[834594, 22229, 845, 23, 108, "Print"],
Cell[835442, 22254, 692, 18, 58, "Print"],
Cell[836137, 22274, 705, 18, 58, "Print"],
Cell[836845, 22294, 706, 18, 58, "Print"],
Cell[837554, 22314, 708, 18, 58, "Print"],
Cell[838265, 22334, 228, 4, 32, "Print"],
Cell[838496, 22340, 411, 9, 32, "Print"],
Cell[838910, 22351, 468, 9, 32, "Print"],
Cell[839381, 22362, 485, 10, 32, "Print"],
Cell[839869, 22374, 290, 5, 32, "Print"],
Cell[840162, 22381, 458, 9, 32, "Print"],
Cell[840623, 22392, 256, 4, 32, "Print"],
Cell[840882, 22398, 276, 6, 38, "Print"],
Cell[841161, 22406, 376, 8, 32, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[841598, 22421, 165, 3, 46, "Subsection"],
Cell[841766, 22426, 261, 6, 37, "Text"],
Cell[CellGroupData[{
Cell[842052, 22436, 539, 10, 59, "Input"],
Cell[CellGroupData[{
Cell[842616, 22450, 391, 6, 32, "Print"],
Cell[843010, 22458, 378, 6, 32, "Print"],
Cell[843391, 22466, 403, 6, 32, "Print"],
Cell[843797, 22474, 569, 10, 32, "Print"],
Cell[844369, 22486, 370, 5, 32, "Print"],
Cell[844742, 22493, 389, 7, 38, "Print"],
Cell[845134, 22502, 487, 9, 32, "Print"],
Cell[845624, 22513, 385, 6, 32, "Print"],
Cell[846012, 22521, 365, 5, 32, "Print"],
Cell[846380, 22528, 390, 6, 32, "Print"],
Cell[846773, 22536, 752, 13, 32, "Print"],
Cell[847528, 22551, 361, 5, 32, "Print"],
Cell[847892, 22558, 344, 5, 32, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[848297, 22570, 117, 2, 46, "Subsection"],
Cell[848417, 22574, 199, 3, 37, "Text"],
Cell[CellGroupData[{
Cell[848641, 22581, 499, 10, 59, "Input"],
Cell[CellGroupData[{
Cell[849165, 22595, 416, 7, 32, "Print"],
Cell[849584, 22604, 402, 7, 32, "Print"],
Cell[849989, 22613, 552, 11, 32, "Print"],
Cell[850544, 22626, 605, 11, 32, "Print"],
Cell[851152, 22639, 429, 7, 32, "Print"],
Cell[851584, 22648, 457, 7, 58, "Print"],
Cell[852044, 22657, 385, 6, 32, "Print"],
Cell[852432, 22665, 455, 7, 58, "Print"],
Cell[852890, 22674, 435, 7, 32, "Print"],
Cell[853328, 22683, 437, 7, 32, "Print"],
Cell[853768, 22692, 550, 11, 32, "Print"],
Cell[854321, 22705, 607, 11, 32, "Print"],
Cell[854931, 22718, 429, 7, 32, "Print"],
Cell[855363, 22727, 597, 11, 32, "Print"],
Cell[855963, 22740, 398, 6, 32, "Print"],
Cell[856364, 22748, 417, 8, 38, "Print"],
Cell[856784, 22758, 517, 10, 32, "Print"],
Cell[857304, 22770, 11062, 349, 283, "Print"],
Cell[868369, 23121, 11254, 355, 283, "Print"],
Cell[879626, 23478, 586, 11, 32, "Print"],
Cell[880215, 23491, 616, 12, 32, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[880880, 23509, 148, 3, 38, "Input"],
Cell[881031, 23514, 2267, 61, 168, "Output"]
}, Open  ]],
Cell[883313, 23578, 138, 2, 37, "Text"],
Cell[883454, 23582, 684, 15, 119, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
