(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     21976,        523]
NotebookOptionsPosition[     20002,        489]
NotebookOutlinePosition[     20342,        504]
CellTagsIndexPosition[     20299,        501]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["NLO", "Section",
 CellChangeTimes->{{3.783689867070311*^9, 3.783689868916458*^9}, 
   3.7836902568877707`*^9},ExpressionUUID->"208ed184-f7f3-4e8a-809e-\
d289ef792820"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.7836902645715714`*^9, 3.7836902661140347`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"f9d88617-362b-48ac-b512-65895534dee1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{"SetDirectory", "[", "\"\<<path to feynrules>\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{
   "\"\<sm_reduced.fr\>\"", ",", "\"\<type_ii_PertSafeScheme.fr\>\""}], "]"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
    "\"\</Massless_4f.rst\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
    "\"\</DiagonalCKM.rst\>\""}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.715342142509688*^9, 3.715342163031452*^9}, {
   3.715344057238492*^9, 3.715344058291609*^9}, {3.7178506900799713`*^9, 
   3.717850690973333*^9}, {3.7180002809816017`*^9, 3.718000300883692*^9}, {
   3.718000394980835*^9, 3.7180003951009827`*^9}, {3.745153113604156*^9, 
   3.745153113886346*^9}, {3.757403422964182*^9, 3.757403423697225*^9}, {
   3.758251145793989*^9, 3.7582511468706083`*^9}, 3.7582513470889874`*^9, {
   3.76335111930016*^9, 3.763351139093457*^9}, {3.7633511693483973`*^9, 
   3.763351173687544*^9}, {3.763886545633397*^9, 3.763886571907737*^9}, 
   3.767099220292862*^9, {3.767374514400957*^9, 3.767374515454331*^9}, {
   3.767375022418717*^9, 3.76737502255937*^9}, {3.7674580186709423`*^9, 
   3.767458019546134*^9}, {3.767610478088133*^9, 3.767610507175609*^9}, {
   3.767610538533186*^9, 3.76761053951677*^9}, {3.767610603703107*^9, 
   3.7676106297846937`*^9}, {3.7676900131323767`*^9, 
   3.7676900151887627`*^9}, {3.76858524470041*^9, 3.768585245204138*^9}, {
   3.77027747721585*^9, 3.7702775056436033`*^9}, {3.7711262488766813`*^9, 
   3.771126253973398*^9}, {3.771126559639118*^9, 3.771126602632146*^9}, 
   3.771139675031245*^9, {3.771139748794265*^9, 3.771139751639614*^9}, {
   3.7711399153197002`*^9, 3.7711399456001577`*^9}, {3.771139981523079*^9, 
   3.771139981644162*^9}, {3.77857888321222*^9, 3.778578897476334*^9}, {
   3.77857892985773*^9, 3.7785789375119877`*^9}, 3.7785789770568542`*^9, {
   3.77857907445473*^9, 3.7785791018908577`*^9}, {3.779597422325054*^9, 
   3.779597426820354*^9}, {3.780921597734684*^9, 3.780921601148004*^9}, 
   3.780942736968416*^9, {3.780998835004087*^9, 3.780998837598987*^9}, {
   3.783657571383642*^9, 3.783657585695908*^9}, 3.783666267346821*^9, {
   3.783675777945162*^9, 3.78367581535364*^9}, 3.783690275947172*^9, {
   3.7856661572318487`*^9, 3.785666198640686*^9}, {3.785666290959208*^9, 
   3.785666293388596*^9}, {3.7939537785164833`*^9, 
   3.7939537815409813`*^9}},ExpressionUUID->"a41a6f64-aff6-490a-a0d8-\
1e3c8c43b534"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Begin", "[", "\"\<MoGRe`\>\"", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"<<", "MoGRe_v1.1.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"End", "[", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MoGRe`ClearRenormalizationScheme", "[", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.779621739750206*^9, 3.7796217508767843`*^9}, {
  3.7796273631453953`*^9, 3.77962740535894*^9}, {3.78099943900846*^9, 
  3.780999439837109*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"85900211-dbcd-4e7c-adc9-b0c3454ff9c5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Calculation", " ", "of", " ", "the", " ", "Lagrangian", " ", 
    RowBox[{"(", 
     RowBox[{"once", " ", "and", " ", "for", " ", "all"}], ")"}], " ", "if", 
    " ", "not", " ", "done", " ", "already"}], " ", "*)"}], " ", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"!", 
       RowBox[{"FileExistsQ", "[", "\"\<lagrangian.dat\>\"", "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"lags", "=", " ", 
        RowBox[{"ExpandIndices", "/@", "LType2"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Definition", "[", "lags", "]"}], " ", ">>", " ", 
        "lagrangian.dat"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"<<", "lagrangian.dat"}], ";"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"To", " ", "get", " ", "more", " ", "print"}], "-", 
     RowBox[{"outs", " ", "to", " ", "the", " ", "screen"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MoGRe$Debug", "=", "True"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Setting", " ", "the", " ", "options", " ", "of", " ", "the", " ", "main",
      " ", "function"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"MoGRe$Renormalize", ",", " ", "\[IndentingNewLine]", 
      RowBox[{"Exclude4Scalars", "\[Rule]", "False"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FlavorMixing", "\[Rule]", "False"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"CouplingOrders", "\[Rule]", 
       RowBox[{"{", "QCD", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"CanonicalTwoPoints", "\[Rule]", "True"}]}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.771263641132224*^9, 3.7712636559080553`*^9}, {
  3.7796218121813602`*^9, 3.7796218127058563`*^9}, {3.7796229843052807`*^9, 
  3.779622984874784*^9}, {3.780979808313796*^9, 3.7809798160041103`*^9}, {
  3.7836576738553047`*^9, 3.783657677982736*^9}, {3.783941676984709*^9, 
  3.783941677261827*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"09fec849-448a-49a6-9b9f-74909bc58ac7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Unrenormalized", " ", "parameters"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"MoGRe`DefineUnrenormalizedParameters", "[", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
      "Gf", ",", "aEWM1", ",", "MZ", ",", "delCP", ",", "dmsq31", ",", 
       "dmsq21", ",", "th12", ",", "th13", ",", "th23", ",", "phiM1", ",", 
       "\[IndentingNewLine]", "phiM2", ",", "vevD", ",", "lamHD1", ",", 
       "lamD1", ",", "lamD2"}], "}"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Fields", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MoGRe`DeclareUnrenormalizedFields", "[", 
     RowBox[{"W", ",", "A", ",", "Z"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MoGRe`RealFieldRenormalization", "[", "]"}], " ", ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Removing", " ", "some", " ", "parameters", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"cf", ".", " ", "the"}], " ", "way", " ", "NLOCT", " ", 
       "works"}], ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"MoGRe`RemovingInternalCst", "[", "#", "]"}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{"gs", ",", "\[IndentingNewLine]", 
       RowBox[{"Sequence", "@@", 
        RowBox[{"Flatten", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"yu", "[", 
              RowBox[{"i", ",", "i"}], "]"}], ",", 
             RowBox[{"yd", "[", 
              RowBox[{"i", ",", "i"}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Sequence", "@@", 
        RowBox[{"Flatten", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"CKM", "[", 
             RowBox[{"i", ",", "j"}], "]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}]}], 
      "}"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.771264625204327*^9, 3.771264640138379*^9}, 
   3.779622343993898*^9, {3.783941695184012*^9, 3.7839416993404083`*^9}, {
   3.78394296649778*^9, 3.783942967329603*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"b4d75f27-ad07-4041-8347-16469b72ae53"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LReno", " ", "=", 
   RowBox[{"MoGRe$Renormalize", "[", 
    RowBox[{"Plus", "@@", "lags"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.771264750774624*^9, 3.771264754345985*^9}, {
   3.779622437680065*^9, 3.7796224387360353`*^9}, 3.779624783600335*^9, {
   3.7796274220329533`*^9, 3.779627429379524*^9}, {3.7796294251206827`*^9, 
   3.779629444949071*^9}, {3.779629548413604*^9, 3.7796295518915253`*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"19928e68-86cc-4534-8fca-91adca3c7aa9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"The", " ", "renormalization", " ", "conditions", " ", 
    RowBox[{"(", 
     RowBox[{"this", " ", "is", " ", "an", " ", "input"}], ")"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"MoGRe`SchemeRules", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Masses", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"RenormalizationRules", "[", "\"\<Masses\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"External", " ", "parameters"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"RenormalizationRules", "[", "\"\<Externals\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Internal", " ", "parameters"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"RenormalizationRules", "[", "\"\<Internals\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Fields", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"RenormalizationRules", "[", "\"\<Fields\>\"", "]"}]}]}]], "Input",\

 CellChangeTimes->{{3.771265755382235*^9, 3.771265786258514*^9}, {
  3.783690373862105*^9, 3.78369037421682*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"64686b84-eb26-4f51-92c1-9655c67accb6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteFeynArtsOutput", "[", 
   RowBox[{"LReno", ",", 
    RowBox[{"Output", "\[Rule]", "\"\<typeII_v1_3_FA\>\""}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.779597577798992*^9, 3.779597584199922*^9}, {
  3.779597680344357*^9, 3.779597685565913*^9}, {3.77959779313251*^9, 
  3.779597803082788*^9}, {3.779632511026588*^9, 3.77963252396973*^9}, {
  3.779632589533596*^9, 3.779632594866434*^9}, {3.780944772665889*^9, 
  3.780944773643894*^9}, {3.7809989929665813`*^9, 3.780998995191955*^9}, {
  3.783690388414618*^9, 3.783690388485291*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"2924914f-57ad-4c21-a2d2-0196a3defb04"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.779636370018443*^9, 3.779636371598173*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"0e5e3761-6f79-4f6e-8b2a-f2114850b009"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<<path to FeynArts 3.9>\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "FeynArts`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<<path to FeynRules>\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "NLOCT`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7796363829653883`*^9, 3.779636429912023*^9}, {
  3.780999051176557*^9, 3.780999062807684*^9}, {3.7809991888797283`*^9, 
  3.7809991906985292`*^9}, {3.783666715410285*^9, 3.7836667830468483`*^9}, {
  3.783666837843645*^9, 3.7836668379020767`*^9}, {3.783675863628983*^9, 
  3.78367586429869*^9}, {3.7836830056644*^9, 3.783683021227706*^9}, {
  3.783683207946851*^9, 3.783683216510889*^9}, {3.7856662093637953`*^9, 
  3.7856662300282087`*^9}},ExpressionUUID->"98bc1033-ce6c-4e63-9595-\
b9987539869f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteCT", "[", "\[IndentingNewLine]", 
   RowBox[{
   "\"\<./typeII_v1_3_FA/typeII_v1_3_FA\>\"", ",", "\[IndentingNewLine]", 
    "\"\<./typeII_v1_3_FA/typeII_v1_3_FA\>\"", ",", "\[IndentingNewLine]", 
    " ", 
    RowBox[{"Output", "->", "\"\<typeII_4FNS_v1_3\>\""}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelInternal", "\[Rule]", "True"}], ",", 
    RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
    RowBox[{"KeptIndices", "\[Rule]", 
     RowBox[{"{", "}"}]}], ",", 
    RowBox[{"ZeroMom", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"aS", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"F", "[", "7", "]"}], ",", 
          RowBox[{"V", "[", "4", "]"}], ",", 
          RowBox[{"-", 
           RowBox[{"F", "[", "7", "]"}]}]}], "}"}], ",", "0"}], "}"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"Assumptions", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"MT", ">", "0"}], ",", 
       RowBox[{"MB", ">", "0"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"CTparameters", "\[Rule]", "True"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.783683167612175*^9, 3.783683180859993*^9}, {
  3.783690410598928*^9, 3.783690414708645*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"88620b5f-5d7b-4464-ab3b-e8ce766d1b54"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.779639826390726*^9, 3.7796398270234957`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"ed21d954-0e8d-476e-8faa-22ff29a890dc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{"SetDirectory", "[", "\"\<<path to feynrules>\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{
   "\"\<sm_reduced.fr\>\"", ",", "\"\<type_ii_PertSafeScheme.fr\>\""}], "]"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
    "\"\</Massless_4f.rst\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
    "\"\</DiagonalCKM.rst\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Get", "[", "\"\<typeII_4FNS_v1_3.nlo\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"!", 
     RowBox[{"FileExistsQ", "[", "\"\<lagrangian.dat\>\"", "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"lags", "=", " ", 
      RowBox[{"ExpandIndices", "/@", "LType2"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Definition", "[", "lags", "]"}], " ", ">>", " ", 
      "lagrangian.dat"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"<<", "lagrangian.dat"}], ";"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7796397898851013`*^9, 3.779639824714785*^9}, {
   3.780999092284133*^9, 3.780999094749385*^9}, {3.7836678960469713`*^9, 
   3.783667901509082*^9}, {3.783686022716382*^9, 3.783686063398385*^9}, {
   3.783741038031934*^9, 3.783741053196666*^9}, 3.7839338270663137`*^9, 
   3.783934024792015*^9, {3.78394413622283*^9, 3.7839441580079813`*^9}, 
   3.785666244959271*^9, 
   3.793953789989683*^9},ExpressionUUID->"0e3735fa-3c99-489e-a4f3-\
9047156e3c61"],

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{"lags", ",", 
    RowBox[{"UVCounterterms", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"UV$vertlist", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FR$IR", "\[Rule]", "1"}], ",", 
         RowBox[{"FR$IRLog", "\[Rule]", "1"}]}], "}"}]}], ")"}]}], " ", ",", 
    RowBox[{"R2Vertices", "\[Rule]", "R2$vertlist"}], ",", " ", 
    RowBox[{"CTParameters", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FR$CTparam", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FR$IR", "\[Rule]", "1"}], ",", 
         RowBox[{"FR$IRLog", "\[Rule]", "1"}]}], "}"}]}], ")"}]}], ",", 
    RowBox[{"Output", "\[Rule]", "\"\<TypeII_NLO_v_1_3_UFO\>\""}]}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.779639836439653*^9, 3.779639854005334*^9}, {
   3.7809990847792883`*^9, 3.780999086952511*^9}, 3.7837410590366163`*^9, 
   3.78393402662431*^9, {3.783944132135982*^9, 3.783944132366199*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"baa57a44-b9b0-4154-aa69-15fac54a3828"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LO", "Section",
 CellChangeTimes->{{3.783689867070311*^9, 
  3.783689868916458*^9}},ExpressionUUID->"c25536b3-78a0-4fa9-be3d-\
ef2e68af53f3"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.783689874059099*^9, 3.783689875531411*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"431ebc49-1852-4271-a973-569f8a35a959"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{"SetDirectory", "[", "\"\<<path to feynrules>\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{
   "\"\<sm_reduced.fr\>\"", ",", "\"\<type_ii_PertSafeScheme.fr\>\""}], "]"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
    "\"\</Massless_4f.rst\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
    "\"\</DiagonalCKM.rst\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"!", 
     RowBox[{"FileExistsQ", "[", "\"\<lagrangian.dat\>\"", "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"lags", "=", " ", 
      RowBox[{"ExpandIndices", "/@", "LType2"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Definition", "[", "lags", "]"}], " ", ">>", " ", 
      "lagrangian.dat"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"<<", "lagrangian.dat"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{"lags", ",", 
    RowBox[{"Output", "\[Rule]", "\"\<TypeII_LO_v1_3_UFO\>\""}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.7796397898851013`*^9, 3.779639824714785*^9}, {
   3.780975707166958*^9, 3.780975707338049*^9}, {3.780999012384077*^9, 
   3.780999012577855*^9}, 3.783686126148706*^9, {3.7836898979975758`*^9, 
   3.783689909028027*^9}, 3.783738191127874*^9, {3.7856661090823603`*^9, 
   3.7856661225345592`*^9}, 
   3.793953796188011*^9},ExpressionUUID->"63867beb-ca61-4047-bfc9-\
852e883b05e3"]
}, Open  ]]
},
WindowSize->{1092, 744},
WindowMargins->{{Automatic, 662}, {305, Automatic}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 173, 3, 67, "Section",ExpressionUUID->"208ed184-f7f3-4e8a-809e-d289ef792820"],
Cell[756, 27, 200, 3, 30, "Input",ExpressionUUID->"f9d88617-362b-48ac-b512-65895534dee1"],
Cell[959, 32, 2885, 53, 136, "Input",ExpressionUUID->"a41a6f64-aff6-490a-a0d8-1e3c8c43b534"],
Cell[3847, 87, 706, 16, 115, "Input",ExpressionUUID->"85900211-dbcd-4e7c-adc9-b0c3454ff9c5"],
Cell[4556, 105, 2241, 52, 283, "Input",ExpressionUUID->"09fec849-448a-49a6-9b9f-74909bc58ac7"],
Cell[6800, 159, 2531, 61, 241, "Input",ExpressionUUID->"b4d75f27-ad07-4041-8347-16469b72ae53"],
Cell[9334, 222, 524, 9, 30, "Input",ExpressionUUID->"19928e68-86cc-4534-8fca-91adca3c7aa9"],
Cell[9861, 233, 1204, 26, 220, "Input",ExpressionUUID->"64686b84-eb26-4f51-92c1-9655c67accb6"],
Cell[11068, 261, 789, 16, 52, "Input",ExpressionUUID->"2924914f-57ad-4c21-a2d2-0196a3defb04"],
Cell[11860, 279, 214, 4, 30, "Input",ExpressionUUID->"0e5e3761-6f79-4f6e-8b2a-f2114850b009"],
Cell[12077, 285, 989, 19, 115, "Input",ExpressionUUID->"98bc1033-ce6c-4e63-9595-b9987539869f"],
Cell[13069, 306, 1337, 32, 157, "Input",ExpressionUUID->"88620b5f-5d7b-4464-ab3b-e8ce766d1b54"],
Cell[14409, 340, 198, 3, 30, "Input",ExpressionUUID->"ed21d954-0e8d-476e-8faa-22ff29a890dc"],
Cell[14610, 345, 1960, 49, 241, "Input",ExpressionUUID->"0e3735fa-3c99-489e-a4f3-9047156e3c61"],
Cell[16573, 396, 1046, 24, 52, "Input",ExpressionUUID->"baa57a44-b9b0-4154-aa69-15fac54a3828"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17656, 425, 147, 3, 67, "Section",ExpressionUUID->"c25536b3-78a0-4fa9-be3d-ef2e68af53f3"],
Cell[17806, 430, 196, 3, 30, "Input",ExpressionUUID->"431ebc49-1852-4271-a973-569f8a35a959"],
Cell[18005, 435, 1981, 51, 262, "Input",ExpressionUUID->"63867beb-ca61-4047-bfc9-852e883b05e3"]
}, Open  ]]
}
]
*)

