(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26848,        669]
NotebookOptionsPosition[     24961,        603]
NotebookOutlinePosition[     25339,        620]
CellTagsIndexPosition[     25296,        617]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.7638865422974358`*^9, 3.763886542860983*^9}, {
  3.767372147789777*^9, 3.7673721483716993`*^9}, {3.780996846995326*^9, 
  3.780996847734174*^9}}],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.518892288721245*^9, 3.518892291440427*^9}, {
  3.648272586359296*^9, 3.648272589589151*^9}, {3.744951163067635*^9, 
  3.744951164882929*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", 
    "\"\<~/Work/tools/FeynRules/trunk/feynrules-development\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<sm_reduced.fr\>\"", ",", "\"\<type_ii_ih.fr\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
    "\"\</Massless_4f.rst\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
    "\"\</DiagonalCKM.rst\>\""}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.715342142509688*^9, 3.715342163031452*^9}, {
   3.715344057238492*^9, 3.715344058291609*^9}, {3.7178506900799713`*^9, 
   3.717850690973333*^9}, {3.7180002809816017`*^9, 3.718000300883692*^9}, {
   3.718000394980835*^9, 3.7180003951009827`*^9}, {3.745153113604156*^9, 
   3.745153113886346*^9}, {3.757403422964182*^9, 3.757403423697225*^9}, {
   3.758251145793989*^9, 3.7582511468706083`*^9}, 3.7582513470889874`*^9, {
   3.76335111930016*^9, 3.763351139093457*^9}, {3.7633511693483973`*^9, 
   3.763351173687544*^9}, {3.763886545633397*^9, 3.763886571907737*^9}, 
   3.767099220292862*^9, {3.767374514400957*^9, 3.767374515454331*^9}, {
   3.767375022418717*^9, 3.76737502255937*^9}, {3.7674580186709423`*^9, 
   3.767458019546134*^9}, {3.767610478088133*^9, 3.767610507175609*^9}, {
   3.767610538533186*^9, 3.76761053951677*^9}, {3.767610603703107*^9, 
   3.7676106297846937`*^9}, {3.7676900131323767`*^9, 
   3.7676900151887627`*^9}, {3.76858524470041*^9, 3.768585245204138*^9}, {
   3.77027747721585*^9, 3.7702775056436033`*^9}, {3.7711262488766813`*^9, 
   3.771126253973398*^9}, {3.771126559639118*^9, 3.771126602632146*^9}, 
   3.771139675031245*^9, {3.771139748794265*^9, 3.771139751639614*^9}, {
   3.7711399153197002`*^9, 3.7711399456001577`*^9}, {3.771139981523079*^9, 
   3.771139981644162*^9}, {3.77857888321222*^9, 3.778578897476334*^9}, {
   3.77857892985773*^9, 3.7785789375119877`*^9}, 3.7785789770568542`*^9, {
   3.77857907445473*^9, 3.7785791018908577`*^9}, {3.779597422325054*^9, 
   3.779597426820354*^9}, {3.780921597734684*^9, 3.780921601148004*^9}, 
   3.780942736968416*^9, {3.7822144773378153`*^9, 3.782214477791381*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["NLO", "Section",
 CellChangeTimes->{{3.7795974887503777`*^9, 3.779597489081195*^9}}],

Cell[CellGroupData[{

Cell["Setup", "Subsubsection",
 CellChangeTimes->{{3.7712636194863377`*^9, 3.771263622434663*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Begin", "[", "\"\<MoGRe`\>\"", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"<<", "MoGRe_v1.1.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"End", "[", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MoGRe`ClearRenormalizationScheme", "[", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.779621739750206*^9, 3.7796217508767843`*^9}, {
  3.7796273631453953`*^9, 3.77962740535894*^9}, {3.780999820096065*^9, 
  3.780999821023857*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"!", 
     RowBox[{"FileExistsQ", "[", "\"\<lagrangian.dat\>\"", "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"lags", "=", " ", 
      RowBox[{"ExpandIndices", "/@", "LType2"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Definition", "[", "lags", "]"}], " ", ">>", " ", 
      "lagrangian.dat"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"<<", "lagrangian.dat"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.779597667101206*^9, 3.7795976737764177`*^9}, {
  3.779621768389236*^9, 3.7796217817142982`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "get", " ", "more", " ", "print"}], "-", 
    RowBox[{"outs", " ", "to", " ", "the", " ", "screen"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"MoGRe$Debug", "=", "True"}], ";"}]}]], "Input",
 CellChangeTimes->{{3.771263627141055*^9, 3.7712636335707293`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Setting", " ", "the", " ", "options", " ", "of", " ", "the", " ", "main", 
    " ", "function"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SetOptions", "[", 
    RowBox[{"MoGRe$Renormalize", ",", " ", 
     RowBox[{"Exclude4Scalars", "\[Rule]", "False"}], ",", 
     RowBox[{"FlavorMixing", "\[Rule]", "False"}], ",", 
     RowBox[{"CouplingOrders", "\[Rule]", 
      RowBox[{"{", "QCD", "}"}]}], ",", 
     RowBox[{"CanonicalTwoPoints", "\[Rule]", "True"}]}], "]"}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.771263641132224*^9, 3.7712636559080553`*^9}, {
  3.7796218121813602`*^9, 3.7796218127058563`*^9}, {3.7796229843052807`*^9, 
  3.779622984874784*^9}, {3.780979808313796*^9, 3.7809798160041103`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["OS renormalization", "Subsubsection",
 CellChangeTimes->{{3.771264549679812*^9, 3.771264557709045*^9}, {
  3.771264725891897*^9, 3.771264729628981*^9}, {3.779622421220426*^9, 
  3.779622424683118*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Unrenormalized", " ", "parameters"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"MoGRe`DefineUnrenormalizedParameters", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
     "Gf", ",", "aEWM1", ",", "MZ", ",", "delCP", ",", "dmsq32", ",", 
      "dmsq21", ",", "th12", ",", "th13", ",", "th23", ",", "phiM1", ",", 
      "phiM2", ",", "vevD", ",", "lamHD1", ",", "lamD1"}], "}"}], "]"}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.771264570309547*^9, 3.771264574380278*^9}, {
  3.779622328795891*^9, 3.779622332835644*^9}, {3.779623239502658*^9, 
  3.7796232588028*^9}, {3.779623369643303*^9, 3.7796233703313828`*^9}, {
  3.779625801787382*^9, 3.779625812383876*^9}, {3.779625921812018*^9, 
  3.7796259254903584`*^9}, {3.779626038445567*^9, 3.779626041360046*^9}, {
  3.779626348010645*^9, 3.779626365854025*^9}, {3.779626431993538*^9, 
  3.7796264326080313`*^9}, {3.7796265337645187`*^9, 3.779626563396529*^9}, {
  3.780942696192215*^9, 3.780942696568851*^9}, {3.782214502433197*^9, 
  3.782214502546574*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Fields", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"MoGRe`DeclareUnrenormalizedFields", "[", 
     RowBox[{"W", ",", "A", ",", "Z"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MoGRe`RealFieldRenormalization", "[", "]"}], " ", 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.771264582333989*^9, 3.771264608943572*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Removing", " ", "some", " ", "parameters", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"cf", ".", " ", "the"}], " ", "way", " ", "NLOCT", " ", 
      "works"}], ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"MoGRe`RemovingInternalCst", "[", "#", "]"}], "&"}], "/@", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"gs", ",", "\[IndentingNewLine]", 
      RowBox[{"Sequence", "@@", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"yu", "[", 
             RowBox[{"i", ",", "i"}], "]"}], ",", 
            RowBox[{"yd", "[", 
             RowBox[{"i", ",", "i"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Sequence", "@@", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"CKM", "[", 
            RowBox[{"i", ",", "j"}], "]"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}]}]}], 
     "\[IndentingNewLine]", "}"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.771264625204327*^9, 3.771264640138379*^9}, 
   3.779622343993898*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computation of the renormalised Lagrangian", "Subsubsection",
 CellChangeTimes->{{3.771264736607092*^9, 3.771264744086411*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"LReno", " ", "=", 
   RowBox[{"MoGRe$Renormalize", "[", 
    RowBox[{"Plus", "@@", "lags"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.771264750774624*^9, 3.771264754345985*^9}, {
   3.779622437680065*^9, 3.7796224387360353`*^9}, 3.779624783600335*^9, {
   3.7796274220329533`*^9, 3.779627429379524*^9}, {3.7796294251206827`*^9, 
   3.779629444949071*^9}, {3.779629548413604*^9, 3.7796295518915253`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Check of the output", "Subsubsection",
 CellChangeTimes->{{3.771265709950657*^9, 3.771265712926222*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"The", " ", "renormalization", " ", "conditions", " ", 
    RowBox[{"(", 
     RowBox[{"this", " ", "is", " ", "an", " ", "input"}], ")"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", "MoGRe`SchemeRules"}]], "Input",
 CellChangeTimes->{{3.771265755382235*^9, 3.771265786258514*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Masses", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"RenormalizationRules", "[", "\"\<Masses\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.7451518713843946`*^9, 3.745151922162116*^9}, {
   3.745164095936433*^9, 3.745164096200345*^9}, {3.745164380017013*^9, 
   3.745164380432691*^9}, {3.7451660736095877`*^9, 3.7451660750228863`*^9}, {
   3.745213815312695*^9, 3.745213818856022*^9}, {3.74523151148385*^9, 
   3.7452315119531517`*^9}, {3.745303047472493*^9, 3.7453030478622513`*^9}, {
   3.745303157313552*^9, 3.745303157889686*^9}, 3.745303406136817*^9, {
   3.745574845804298*^9, 3.745574846145966*^9}, {3.745575407401681*^9, 
   3.7455754079116373`*^9}, {3.745578284288937*^9, 3.745578290465178*^9}, {
   3.745582587034992*^9, 3.745582592977302*^9}, {3.7455826657703257`*^9, 
   3.7455826676585293`*^9}, {3.745582880576159*^9, 3.7455828928842697`*^9}, {
   3.745583654476617*^9, 3.74558365461695*^9}, {3.7455837983158484`*^9, 
   3.745583798571127*^9}, 3.74564688658142*^9, {3.745647697834746*^9, 
   3.745647728311248*^9}, {3.745647806746401*^9, 3.745647810713956*^9}, {
   3.7456480115435867`*^9, 3.7456481102599573`*^9}, {3.745663218654118*^9, 
   3.74566325795298*^9}, {3.745663711108547*^9, 3.745663711921837*^9}, {
   3.745664612538536*^9, 3.7456646408908463`*^9}, 3.7456654013484077`*^9, {
   3.745665650589293*^9, 3.7456656519560213`*^9}, {3.745665936303863*^9, 
   3.74566593728722*^9}, {3.7456688354046164`*^9, 3.7456688378674917`*^9}, {
   3.745669024959618*^9, 3.745669030940509*^9}, {3.745669163428668*^9, 
   3.7456691987440863`*^9}, {3.745686812472076*^9, 3.74568681368325*^9}, {
   3.745686880794334*^9, 3.74568688213133*^9}, {3.7456871775241747`*^9, 
   3.745687178863327*^9}, {3.745857725037485*^9, 3.745857735208394*^9}, {
   3.7458586075203047`*^9, 3.745858613138812*^9}, {3.7458627781148767`*^9, 
   3.745862788627599*^9}, 3.745863379016315*^9, {3.745895772747778*^9, 
   3.7458957948440533`*^9}, {3.7458958293849087`*^9, 3.745895832308837*^9}, {
   3.7463392933769217`*^9, 3.746339293953823*^9}, {3.746340958247019*^9, 
   3.746340980757111*^9}, {3.746446967049057*^9, 3.7464469672316236`*^9}, {
   3.757309129229148*^9, 3.757309129577918*^9}, {3.757311847604082*^9, 
   3.757311850951976*^9}, {3.7573119060012207`*^9, 3.7573119133483257`*^9}, {
   3.757400119485875*^9, 3.7574001368021793`*^9}, {3.757402948489932*^9, 
   3.757402960729457*^9}, {3.757403682464596*^9, 3.757403685895455*^9}, {
   3.757406015321528*^9, 3.757406016888089*^9}, {3.75741526102887*^9, 
   3.757415265769416*^9}, {3.7574152965611763`*^9, 3.757415298314205*^9}, {
   3.757416463439416*^9, 3.757416466010469*^9}, {3.757417500086125*^9, 
   3.757417523855345*^9}, {3.7574201860450373`*^9, 3.757420186670478*^9}, {
   3.757448602343779*^9, 3.757448611302442*^9}, 3.757449335625184*^9, {
   3.757449874383556*^9, 3.757449880587248*^9}, {3.757912547323681*^9, 
   3.757912548642529*^9}, {3.7580005002291107`*^9, 3.758000500760256*^9}, {
   3.758005087249868*^9, 3.758005090807074*^9}, {3.758006435804907*^9, 
   3.758006444604958*^9}, {3.758161578806641*^9, 3.758161582999338*^9}, {
   3.758164979635907*^9, 3.758164982381565*^9}, {3.758165013510289*^9, 
   3.758165029147532*^9}, {3.758165070730723*^9, 3.7581650858708963`*^9}, {
   3.758165462675087*^9, 3.758165464347835*^9}, {3.758166197918043*^9, 
   3.7581662072139597`*^9}, {3.7581671637742367`*^9, 3.75816718202489*^9}, {
   3.758177963109878*^9, 3.758177981847004*^9}, {3.758178134359646*^9, 
   3.758178159140918*^9}, {3.7582313015106*^9, 3.758231315264636*^9}, {
   3.758248921123448*^9, 3.758248931762648*^9}, {3.758250734518733*^9, 
   3.758250783798354*^9}, {3.758250835228381*^9, 3.758250845550149*^9}, {
   3.7582511056739693`*^9, 3.7582511090483103`*^9}, {3.75825131359096*^9, 
   3.758251325445635*^9}, {3.758251381280675*^9, 3.758251384116638*^9}, 
   3.758251422640869*^9, {3.75825319671157*^9, 3.758253224083932*^9}, {
   3.758257134438253*^9, 3.758257136759152*^9}, {3.758257209158524*^9, 
   3.7582572123266*^9}, {3.7582574013488417`*^9, 3.758257401749174*^9}, {
   3.7582575392174883`*^9, 3.758257543960134*^9}, {3.758257710440304*^9, 
   3.758257731760181*^9}, {3.758257835439458*^9, 3.7582578864437447`*^9}, {
   3.758258210240507*^9, 3.758258254261258*^9}, {3.758259393453458*^9, 
   3.7582594699190207`*^9}, {3.758259849130109*^9, 3.758259849496891*^9}, 
   3.760938752558837*^9, {3.760938791593569*^9, 3.76093879283946*^9}, {
   3.76094336376334*^9, 3.760943369090857*^9}, {3.760943562738961*^9, 
   3.760943588064082*^9}, 3.760944298912347*^9, {3.760952987831949*^9, 
   3.760952987979011*^9}, {3.760953226892173*^9, 3.760953236996063*^9}, {
   3.76095348865825*^9, 3.760953489028057*^9}, {3.763457602937347*^9, 
   3.763457611310288*^9}, 3.763982907134116*^9, {3.763983088407049*^9, 
   3.763983089444828*^9}, {3.763983130719948*^9, 3.763983131117784*^9}, {
   3.763983964034717*^9, 3.763983965670892*^9}, {3.763987056564139*^9, 
   3.763987059126238*^9}, {3.764005252103383*^9, 3.764005252336042*^9}, {
   3.7640062913058977`*^9, 3.7640062939055023`*^9}, {3.7640073431045647`*^9, 
   3.764007410995483*^9}, {3.76452231518419*^9, 3.764522315471777*^9}, 
   3.764522354075388*^9, {3.7645232675315247`*^9, 3.764523275689969*^9}, {
   3.7645238003142233`*^9, 3.764523801367539*^9}, {3.764523872479026*^9, 
   3.764523881589555*^9}, {3.771263472262384*^9, 3.771263478300324*^9}, {
   3.771263615037691*^9, 3.77126364922724*^9}, {3.771264545348506*^9, 
   3.771264606885642*^9}, 3.771264660161273*^9, 3.771264747418335*^9, {
   3.771265717192766*^9, 3.771265723035942*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"External", " ", "parameters"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"RenormalizationRules", "[", "\"\<Externals\>\"", "]"}]}]], "Input",\

 CellChangeTimes->{{3.771265730383052*^9, 3.771265734792964*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Internal", " ", "parameters"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"RenormalizationRules", "[", "\"\<Internals\>\"", "]"}]}]], "Input",\

 CellChangeTimes->{{3.758258382884212*^9, 3.758258384402162*^9}, {
  3.7712657927013063`*^9, 3.77126579615121*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Fields", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"RenormalizationRules", "[", "\"\<Fields\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.780998786973021*^9, 3.780998787517807*^9}, {
  3.7809989754805193`*^9, 3.780998977358685*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Writing the FA model", "Subsubsection",
 CellChangeTimes->{{3.7796363600275784`*^9, 3.779636361893107*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteFeynArtsOutput", "[", 
   RowBox[{"LReno", ",", 
    RowBox[{"Output", "\[Rule]", "\"\<typeII_ih_v1_0_FA\>\""}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.779597577798992*^9, 3.779597584199922*^9}, {
  3.779597680344357*^9, 3.779597685565913*^9}, {3.77959779313251*^9, 
  3.779597803082788*^9}, {3.779632511026588*^9, 3.77963252396973*^9}, {
  3.779632589533596*^9, 3.779632594866434*^9}, {3.780944772665889*^9, 
  3.780944773643894*^9}, {3.7809986337490673`*^9, 3.780998634516259*^9}, {
  3.782214543741765*^9, 3.782214545574505*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["NLOCT run", "Subsubsection",
 CellChangeTimes->{{3.779636351041431*^9, 3.779636352006412*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.779636370018443*^9, 3.779636371598173*^9}}],

Cell[BoxData[{
 RowBox[{"<<", " ", "FeynArts`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "SetDirectory", "[", 
   "\"\<~/Work/tools/FeynRules/trunk/feynrules-development\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "NLOCT`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteCT", "[", 
   RowBox[{
   "\"\<typeII_ih_v1_0_FA/typeII_ih_v1_0_FA\>\"", ",", 
    "\"\<typeII_ih_v1_0_FA/typeII_ih_v1_0_FA\>\"", ",", " ", 
    RowBox[{"Output", "->", "\"\<typeII_ih_4FNS_v1_0\>\""}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelInternal", "\[Rule]", "True"}], ",", 
    RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
    RowBox[{"KeptIndices", "\[Rule]", 
     RowBox[{"{", "}"}]}], ",", 
    RowBox[{"ZeroMom", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"aS", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"F", "[", "7", "]"}], ",", 
          RowBox[{"V", "[", "4", "]"}], ",", 
          RowBox[{"-", 
           RowBox[{"F", "[", "7", "]"}]}]}], "}"}], ",", "0"}], "}"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"Assumptions", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"MT", ">", "0"}], ",", 
       RowBox[{"MB", ">", "0"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"CTparameters", "\[Rule]", "True"}], ",", 
    RowBox[{"MaxDim", "\[Rule]", "4"}], ",", 
    RowBox[{"EvenOnly", "\[Rule]", "False"}], ",", 
    RowBox[{"IsFeynmanGauge", "\[Rule]", "True"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7796363829653883`*^9, 3.779636429912023*^9}, {
  3.780999249505413*^9, 3.780999260364827*^9}, {3.782215229537178*^9, 
  3.782215245861569*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["NLO UFO", "Subsubsection",
 CellChangeTimes->{{3.7796397724027576`*^9, 3.7796397744779*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.779639826390726*^9, 3.7796398270234957`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", 
    "\"\<~/Work/tools/FeynRules/trunk/feynrules-development\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<sm_reduced.fr\>\"", ",", "\"\<type_ii_ih.fr\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
    "\"\</Massless_4f.rst\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
    "\"\</DiagonalCKM.rst\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Get", "[", "\"\<typeII_ih_4FNS_v1_0.nlo\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"!", 
     RowBox[{"FileExistsQ", "[", "\"\<lagrangian.dat\>\"", "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"lags", "=", " ", 
      RowBox[{"ExpandIndices", "/@", "LType2"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Definition", "[", "lags", "]"}], " ", ">>", " ", 
      "lagrangian.dat"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"<<", "lagrangian.dat"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{"lags", ",", 
    RowBox[{"UVCounterterms", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"UV$vertlist", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FR$IR", "\[Rule]", "1"}], ",", 
         RowBox[{"FR$IRLog", "\[Rule]", "1"}]}], "}"}]}], ")"}]}], " ", ",", 
    RowBox[{"R2Vertices", "\[Rule]", "R2$vertlist"}], ",", " ", 
    RowBox[{"CTParameters", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FR$CTparam", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FR$IR", "\[Rule]", "1"}], ",", 
         RowBox[{"FR$IRLog", "\[Rule]", "1"}]}], "}"}]}], ")"}]}], ",", 
    RowBox[{"Output", "\[Rule]", "\"\<TypeII_ih_NLO_v_1_0_UFO\>\""}]}], "]"}],
   ";"}]}], "Input",
 CellChangeTimes->{{3.7796397898851013`*^9, 3.779639824714785*^9}, {
  3.7809993015566797`*^9, 3.7809993075014963`*^9}, {3.7810099956346083`*^9, 
  3.7810099982607403`*^9}, {3.7822435662746162`*^9, 3.7822435952673607`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LO UFO", "Section",
 CellChangeTimes->{{3.7796397724027576`*^9, 3.7796397744779*^9}, 
   3.7809756787787046`*^9}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.779639826390726*^9, 3.7796398270234957`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", 
    "\"\<~/Work/tools/FeynRules/trunk/feynrules-development\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<sm_reduced.fr\>\"", ",", "\"\<type_ii_ih.fr\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
    "\"\</Massless_4f.rst\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
    "\"\</DiagonalCKM.rst\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"!", 
     RowBox[{"FileExistsQ", "[", "\"\<lagrangian.dat\>\"", "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"lags", "=", " ", 
      RowBox[{"ExpandIndices", "/@", "LType2"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Definition", "[", "lags", "]"}], " ", ">>", " ", 
      "lagrangian.dat"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"<<", "lagrangian.dat"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{"lags", ",", 
    RowBox[{"Output", "\[Rule]", "\"\<TypeII_ih_LO_v1_0_UFO\>\""}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.7796397898851013`*^9, 3.779639824714785*^9}, {
  3.780975707166958*^9, 3.780975707338049*^9}, {3.7809992294303713`*^9, 
  3.780999234867724*^9}, {3.782244668064073*^9, 3.782244673917873*^9}}]
}, Open  ]]
},
WindowSize->{855, 701},
WindowMargins->{{112, Automatic}, {Automatic, 142}},
ShowSelection->True,
FrontEndVersion->"10.4 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 11, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 220, 4, 28, "Input"],
Cell[CellGroupData[{
Cell[790, 28, 188, 3, 64, "Section"],
Cell[981, 33, 2555, 48, 114, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3573, 86, 90, 1, 64, "Section"],
Cell[CellGroupData[{
Cell[3688, 91, 98, 1, 35, "Subsubsection"],
Cell[3789, 94, 629, 15, 97, "Input"],
Cell[4421, 111, 668, 17, 97, "Input"],
Cell[5092, 130, 363, 9, 46, "Input"],
Cell[5458, 141, 791, 17, 63, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6286, 163, 207, 3, 35, "Subsubsection"],
Cell[6496, 168, 1102, 21, 63, "Input"],
Cell[7601, 191, 414, 10, 63, "Input"],
Cell[8018, 203, 1490, 40, 114, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9545, 248, 133, 1, 35, "Subsubsection"],
Cell[9681, 251, 445, 8, 28, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10163, 264, 110, 1, 35, "Subsubsection"],
Cell[10276, 267, 332, 7, 46, "Input"],
Cell[10611, 276, 5597, 77, 46, "Input"],
Cell[16211, 355, 276, 7, 46, "Input"],
Cell[16490, 364, 326, 8, 46, "Input"],
Cell[16819, 374, 284, 5, 46, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17140, 384, 113, 1, 35, "Subsubsection"],
Cell[17256, 387, 713, 15, 46, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18006, 407, 100, 1, 35, "Subsubsection"],
Cell[18109, 410, 136, 3, 28, "Input"],
Cell[18248, 415, 1797, 45, 182, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20082, 465, 98, 1, 35, "Subsubsection"],
Cell[20183, 468, 120, 2, 28, "Input"],
Cell[20306, 472, 2524, 66, 267, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22879, 544, 119, 2, 64, "Section"],
Cell[23001, 548, 120, 2, 28, "Input"],
Cell[23124, 552, 1821, 48, 216, "Input"]
}, Open  ]]
}
]
*)

