(* ****************************************************************** *)
(* *****                                                        ***** *)
(* *****  FeynRules model file supplementing the reduced SM     ***** *)
(* *****  with a type-II see-saw                                ***** *)
(* *****                                                        ***** *)
(* *****  Author: Benjamin Fuks                                 ***** *)
(* *****                                                        ***** *)
(* ****************************************************************** *)

(* ************************** *)
(* *****      Setup     ***** *)
(* ************************** *)
M$ModelName   = "TypeII";
M$Information = { Authors -> {"B. Fuks"}, Version -> "1.2", Date -> "18.11.2019" };
FeynmanGauge  = True;


(* ************************** *)
(* *****  Change  log   ***** *)
(* ************************** *)

(* 25.09.19 - v1.0: first version                                                   *)
(* 24.10.19 - v1.1: All scalar masses external.                                     *)
(*                  Mixing relations are now exact.                                 *)
(* 18.11.19 - v1.2: Changing the name of the LH block for vevD (cannot be vevd too) *)


(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)
M$ClassesDescription = {
(* Fermions: physical fields *)
  F[1] == {
    ClassName -> vi, ClassMembers -> {v1,v2,v3}, Indices -> {Index[Generation]}, FlavorIndex -> Generation,
    SelfConjugate -> True, Mass -> {Mvi, {Mv1, 0.05*^-9}, {Mv2, Internal}, {Mv3, Internal} }, Width -> 0,
    PDG -> {12,14,16}
  },

  (* Fermions: unphysical fields *)
  F[11] == {
    ClassName -> LL, Unphysical -> True, Indices -> {Index[SU2D], Index[Generation]}, FlavorIndex -> SU2D,
    SelfConjugate -> False, QuantumNumbers -> {Y->-1/2},
    Definitions -> {
      LL[sp1_,1,ff_] :> Module[{sp2,ff2}, PMNS[ff,ff2] ProjM[sp1,sp2] vi[sp2,ff2]],
      LL[sp1_,2,ff_] :> Module[{sp2}, ProjM[sp1,sp2] l[sp2,ff]]
    }
  },

  (* Higgs: unphysical scalars  *)
  S[11] == {
    ClassName -> Phi, Unphysical -> True, Indices -> {Index[SU2D]}, FlavorIndex -> SU2D,
    SelfConjugate -> False, QuantumNumbers -> {Y -> 1/2},
    Definitions -> {
      Phi[1] -> vev/Sqrt[vev^2+2*vevD^2] GP - Sqrt[2] vevD/Sqrt[vev^2+2*vevD^2] DP,
      Phi[2] -> 1/Sqrt[2](vev + cxi H - sxi D0 + I vev/Sqrt[vev^2+4*vevD^2] G0 - 2 I vevD/Sqrt[vev^2+4*vevD^2] chi)
    }
  },
  S[12] == {
    ClassName -> hatD, Unphysical -> True, Indices-> {Index[SU2W]}, FlavorIndex->SU2W,
    SelfConjugate -> False, QuantumNumbers -> {Y->1},
    Definitions -> {
      hatD[1] -> 1/2 (vevD + sxi*H + cxi*D0 + 2 I vevD/Sqrt[vev^2+4*vevD^2] G0 + I vev/Sqrt[vev^2+4*vevD^2] chi) \
         + 1/Sqrt[2] DPP,
      hatD[2] -> -I/2 (vevD + sxi*H + cxi*D0 + 2 I vevD/Sqrt[vev^2+4*vevD^2] G0 + I vev/Sqrt[vev^2+4*vevD^2] chi) \
         + I/Sqrt[2] DPP,
      hatD[3] -> Sqrt[2] vevD/Sqrt[vev^2+2*vevD^2] GP + vev/Sqrt[vev^2+2*vevD^2] DP
    }
  },

  (* Higgs: physical scalars *)
  S[4] == {
    ClassName -> D0,  SelfConjugate -> True,  Mass -> {MD0, 500.}, Width -> {WD0, 1.017718*^-5}, PDG -> 44
  },
  S[5] == {
    ClassName -> DP,  SelfConjugate -> False, Mass -> {MDP, 503.}, Width -> {WDP, 1.017090*^-5}, PDG -> 38,
    ParticleName -> "D+",  AntiParticleName -> "D-",  QuantumNumbers -> {Q->1}
  },
  S[6] == {
    ClassName -> DPP, SelfConjugate -> False, Mass -> {MDPP,502.}, Width -> {WDPP,1.011029*^-5}, PDG -> 61,
    ParticleName -> "D++", AntiParticleName -> "D--", QuantumNumbers -> {Q->2}
  },
  S[7] == {
    ClassName -> chi, SelfConjugate -> True,  Mass -> {Mchi,Internal}, Width -> {Wchi,1.017817*^-5}, PDG -> 62
  }
};


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {
  (* PMNS matrix *)
  th12 == {
    ParameterType -> External, Value -> 0.59, TeX -> Subscript[\[Theta], 12],
    BlockName -> PMNS, OrderBlock -> 1, Description -> "Solar mixing angle - theta12"
  },
  th23 == {
    ParameterType -> External, Value -> 0.87, TeX -> Subscript[\[Theta], 23],
    BlockName -> PMNS, OrderBlock -> 2, Description -> "Atmospheric mixing angle - theta23"
  },
  th13 == {
    ParameterType -> External, Value -> 0.15, TeX -> Subscript[\[Theta], 13],
    BlockName -> PMNS, OrderBlock -> 3, Description -> "Reactor mixing angle - theta_13"
  },
  delCP == {
    ParameterType -> External, Value -> 0 (* 3.8 *), TeX -> Subscript[\[Delta], CP],
    BlockName -> PMNS, OrderBlock -> 4, Description -> "Leptonic Dirac CP phase"
  },
  phiM1 == {
    ParameterType -> External, Value -> 0.0, TeX -> Subscript[\[Phi], 1],
    BlockName -> PMNS, OrderBlock -> 5, Description -> "1st Majorana CP phase"
  },
  phiM2 == {
    ParameterType -> External, Value -> 0.0, TeX -> Subscript[\[Phi], 2],
    BlockName -> PMNS, OrderBlock -> 6, Description -> "2nd Majorana CP phase"
  },

  (* Neutrino mass differences *)
  dmsq21 == {
    ParameterType -> External, Value -> 7.39*^-23, TeX -> Subsuperscript["\[CapitalDelta]m",21,2],
    BlockName -> MNU, OrderBlock -> 2, Description -> "Solar mass splitting squared"
  },
  dmsq31 == {
    ParameterType -> External, Value -> 2.5*^-21, TeX -> Subsuperscript["\[CapitalDelta]m",31,2],
    BlockName -> MNU, OrderBlock -> 3, Description -> "Atmospheric mass splitting squared"
  },

  (* PMNS mixing matrix defined from oscillation data *)
  PMNS == {
    ParameterType -> Internal, Indices -> {Index[Generation],Index[Generation]}, TeX -> Superscript[V, PMNS],
    ComplexParameter -> True,
    Value -> {
        PMNS[1,1] ->  Cos[th12]*Cos[th13],
        PMNS[1,2] ->  Cos[th13]*Sin[th12]*Exp[I/2 phiM1],
        PMNS[1,3] ->  Sin[th13]*Exp[I (phiM2/2 - delCP)],
        PMNS[2,1] -> -Cos[th23]*Sin[th12] - Cos[th12]*Sin[th13]*Sin[th23]*Exp[I delCP],
        PMNS[2,2] ->  (Cos[th12]*Cos[th23] - Sin[th12]*Sin[th13]*Sin[th23]*Exp[I delCP])*Exp[I/2 phiM1],
        PMNS[2,3] ->  Cos[th13]*Sin[th23]*Exp[I/2 phiM2],
        PMNS[3,1] ->  Sin[th12]*Sin[th23] - Cos[th12]*Cos[th23]*Sin[th13]*Exp[I delCP],
        PMNS[3,2] ->  (-Cos[th23]*Sin[th12]*Sin[th13]*Exp[I delCP] - Cos[th12]*Sin[th23])*Exp[I/2 phiM1],
        PMNS[3,3] -> Cos[th13]*Cos[th23]*Exp[I/2 phiM2]
    }
  },

  (* Higgs sector: external parameters *)
  lamHD1 == {
    ParameterType -> External, Value -> 0.10, InteractionOrder -> {QED,2},
    BlockName -> QUARTICS, OrderBlock -> 1, TeX -> Subscript[\[Lambda], "h\[CapitalDelta]1"]
  },
  lamD1 == {
    ParameterType -> External, Value -> 0.11, InteractionOrder -> {QED,2},
    BlockName -> QUARTICS, OrderBlock -> 2, TeX  -> Subscript[\[Lambda], "\[CapitalDelta]1"]
  },
  vevD == {
    ParameterType -> External,  Value -> 1.0*^-7, InteractionOrder -> { QED,-1},
    BlockName -> VEVDELTA, OrderBlock -> 1, TeX -> Subscript[v,\[CapitalDelta]]
  },

  (* Neutrino masses and Yukawas *)
  Mv2 == { ParameterType -> Internal, Value -> Sqrt[Mv1^2 + dmsq21], TeX -> Subscript[m, "\[Nu]2"] },
  Mv3 == { ParameterType -> Internal, Value -> Sqrt[Mv1^2 + dmsq31], TeX -> Subscript[m, "\[Nu]3"] },
  yDL == {
    ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]},
    InteractionOrder -> {QED, 1}, TeX -> Subscript[Y, \[CapitalDelta]], ComplexParameter -> True,
    Value               -> {
      yDL[1,1] -> Conjugate[PMNS[1,1]*PMNS[1,1]*Mv1+PMNS[1,2]*PMNS[1,2]*Mv2+PMNS[1,3]*PMNS[1,3]*Mv3]/(Sqrt[2]*vevD),
      yDL[1,2] -> Conjugate[PMNS[1,1]*PMNS[2,1]*Mv1+PMNS[1,2]*PMNS[2,2]*Mv2+PMNS[1,3]*PMNS[2,3]*Mv3]/(Sqrt[2]*vevD),
      yDL[1,3] -> Conjugate[PMNS[1,1]*PMNS[3,1]*Mv1+PMNS[1,2]*PMNS[3,2]*Mv2+PMNS[1,3]*PMNS[3,3]*Mv3]/(Sqrt[2]*vevD),

      yDL[2,1] -> Conjugate[PMNS[2,1]*PMNS[1,1]*Mv1+PMNS[2,2]*PMNS[1,2]*Mv2+PMNS[2,3]*PMNS[1,3]*Mv3]/(Sqrt[2]*vevD),
      yDL[2,2] -> Conjugate[PMNS[2,1]*PMNS[2,1]*Mv1+PMNS[2,2]*PMNS[2,2]*Mv2+PMNS[2,3]*PMNS[2,3]*Mv3]/(Sqrt[2]*vevD),
      yDL[2,3] -> Conjugate[PMNS[2,1]*PMNS[3,1]*Mv1+PMNS[2,2]*PMNS[3,2]*Mv2+PMNS[2,3]*PMNS[3,3]*Mv3]/(Sqrt[2]*vevD),

      yDL[3,1] -> Conjugate[PMNS[3,1]*PMNS[1,1]*Mv1+PMNS[3,2]*PMNS[1,2]*Mv2+PMNS[3,3]*PMNS[1,3]*Mv3]/(Sqrt[2]*vevD),
      yDL[3,2] -> Conjugate[PMNS[3,1]*PMNS[2,1]*Mv1+PMNS[3,2]*PMNS[2,2]*Mv2+PMNS[3,3]*PMNS[2,3]*Mv3]/(Sqrt[2]*vevD),
      yDL[3,3] -> Conjugate[PMNS[3,1]*PMNS[3,1]*Mv1+PMNS[3,2]*PMNS[3,2]*Mv2+PMNS[3,3]*PMNS[3,3]*Mv3]/(Sqrt[2]*vevD)
    }
  },




  (* Higgs sector: internal parameters *)
  mD2  == {
   ParameterType -> Internal, Value -> MDPP^2 - lamHD1/2*vev^2 - lamD1*vevD^2,
   TeX -> Subsuperscript[m,\[CapitalDelta],2]
  },
  lamHD2 == {
   ParameterType -> Internal, TeX -> Subscript[ \[Lambda], "h\[CapitalDelta]2"], InteractionOrder -> {QED,2},
   Value -> 2*(lamD1 - lamHD1 - (2*MDP^2)/(vev^2 + 2*vevD^2) - 
   (MD0^2 - 8*MDP^2 + 4*MDPP^2 + MH^2 + (lamD1 - lamHD1)*vev^2)/(vev^2 + 4*vevD^2)) - 
     Sqrt[(-4*MD0^2*vev^6 + 24*MDP^2*vev^6 - 16*MDPP^2*vev^6 - 4*MH^2*vev^6 - 16*MD0^2*vev^4*vevD^2 + 
      80*MDP^2*vev^4*vevD^2 - 64*MDPP^2*vev^4*vevD^2 - 16*MH^2*vev^4*vevD^2 + 16*lamD1*vev^6*vevD^2 - 
      16*lamHD1*vev^6*vevD^2 - 16*MD0^2*vev^2*vevD^4 + 64*MDP^2*vev^2*vevD^4 - 64*MDPP^2*vev^2*vevD^4 - 
      16*MH^2*vev^2*vevD^4 + 64*lamD1*vev^4*vevD^4 - 64*lamHD1*vev^4*vevD^4 + 64*lamD1*vev^2*vevD^6 - 
      64*lamHD1*vev^2*vevD^6)^2 - 4*(-vev^8 - 8*vev^6*vevD^2 - 20*vev^4*vevD^4 - 16*vev^2*vevD^6)*
     (48*MD0^2*MDP^2*vev^4 - 144*MDP^4*vev^4 - 32*MD0^2*MDPP^2*vev^4 + 192*MDP^2*MDPP^2*vev^4 - 
      64*MDPP^4*vev^4 - 16*MD0^2*MH^2*vev^4 + 48*MDP^2*MH^2*vev^4 - 32*MDPP^2*MH^2*vev^4 + 
      96*MD0^2*MDP^2*vev^2*vevD^2 - 64*MDP^4*vev^2*vevD^2 - 128*MD0^2*MDPP^2*vev^2*vevD^2 + 
      384*MDP^2*MDPP^2*vev^2*vevD^2 - 256*MDPP^4*vev^2*vevD^2 - 64*MD0^2*MH^2*vev^2*vevD^2 + 
      96*MDP^2*MH^2*vev^2*vevD^2 - 128*MDPP^2*MH^2*vev^2*vevD^2 + 32*lamD1*MD0^2*vev^4*vevD^2 - 
      192*lamD1*MDP^2*vev^4*vevD^2 + 64*lamHD1*MDP^2*vev^4*vevD^2 + 128*lamD1*MDPP^2*vev^4*vevD^2 + 
      32*lamD1*MH^2*vev^4*vevD^2 - 16*lamHD1^2*vev^6*vevD^2 - 128*MD0^2*MDPP^2*vevD^4 - 256*MDPP^4*vevD^4 - 
      64*MD0^2*MH^2*vevD^4 - 128*MDPP^2*MH^2*vevD^4 + 128*lamD1*MD0^2*vev^2*vevD^4 - 
      384*lamD1*MDP^2*vev^2*vevD^4 + 128*lamHD1*MDP^2*vev^2*vevD^4 + 512*lamD1*MDPP^2*vev^2*vevD^4 + 
      128*lamD1*MH^2*vev^2*vevD^4 - 64*lamD1^2*vev^4*vevD^4 - 64*lamHD1^2*vev^4*vevD^4 + 
      128*lamD1*MD0^2*vevD^6 + 512*lamD1*MDPP^2*vevD^6 + 128*lamD1*MH^2*vevD^6 - 256*lamD1^2*vev^2*vevD^6 - 
      64*lamHD1^2*vev^2*vevD^6 - 256*lamD1^2*vevD^8)]/(2*(vev^2 + 4*vevD^2)*(vev^3 + 2*vev*vevD^2)^2)
  },
  lamD2 == {
    ParameterType -> Internal, TeX  -> Subscript[\[Lambda], "\[CapitalDelta]2"], InteractionOrder -> {QED,2},
    Value -> vev^2*MDP^2/(vevD^2(vev^2+2vevD^2)) - MDPP^2/vevD^2 - vev^2 lamHD2/(4 vevD^2)
  },
  muHD == {
   ParameterType -> Internal, TeX -> Subscript[\[Mu], "h\[CapitalDelta]"], InteractionOrder -> {QED,2},
   Value -> Sqrt[2]*vevD*(1/vev^2*(mD2+(lamHD1+lamHD2)/2*vev^2) + (lamD1+lamD2)*vevD^2/vev^2)
  },
  lamH == {
    ParameterType -> Internal, TeX -> Subscript[\[Lambda],H], InteractionOrder -> {QED,2},
    Value -> MH^2/(2*vev^2) + 1/2 vevD^2/(vev^2 + 2 vevD^2) (-4*MDP^2 + (2*lamHD1+lamHD2)*(vev^2+2*vevD^2))^2/(12*MDP^2*vev^2-(vev^2+2*vevD^2)*(8*MDPP^2+4*MH^2+lamHD2*vev^2 - 8*lamD1*vevD^2))
  },
  muH2 == {
    ParameterType -> Internal, TeX -> Superscript[Subscript[\[Mu],H],2],
    Value -> lamH*vev^2 - vevD^2/(2 vev^2)*((lamHD1+lamHD2)*vev^2+4*mD2) - 2 vevD^4/vev^2*(lamD1+lamD2)
  },

  (* Internal masses and mixings *)
  Mchi == {
    ParameterType -> Internal, TeX -> Subscript[M,\[Chi]],
    Value -> Sqrt[(vev^2+4 vevD^2)/vev^2 (MDPP^2 + lamHD2 vev^2/2 + lamD2 vevD^2)]
  },
  t2xi == {
    ParameterType -> Internal, TeX -> Subscript[t,"2\[Xi]"],
    Value -> (4*vev*vevD*(-4*MDP^2 + (2*lamHD1 + lamHD2)*(vev^2 + 2*vevD^2)))/
      (-12*MDP^2*vev^2 + (vev^2 + 2*vevD^2)*(8*MDPP^2 + (8*lamH + lamHD2)*vev^2 - 8*lamD1*vevD^2))
  },
  cxi == {
    ParameterType -> Internal, TeX -> Subscript[c,\[Xi]],
    Value -> Cos[1/2 ArcTan[t2xi]]
  },
  sxi == {
    ParameterType -> Internal, TeX -> Subscript[s,\[Xi]],
    Value -> Sin[1/2 ArcTan[t2xi]]
  }

};


(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)
LScalar := \
   DC[Phibar[ii],mu] DC[Phi[ii],mu] + DC[hatDbar[ii],mu] DC[hatD[ii],mu] \
   + muH2 Phibar[ii]  Phi[ii]  \
   - mD2  hatDbar[ii] hatD[ii] \
   - lamH Phibar[ii] Phi[ii] Phibar[jj] Phi[jj] \
   - lamD1 hatDbar[ii] hatD[ii] hatDbar[jj] hatD[jj] \
   - lamD2 (hatDbar[ii] hatD[ii] hatDbar[jj] hatD[jj] - 1/2 hatDbar[ii] hatD[jj] hatDbar[ii] hatD[jj]) \
   - lamHD1 Phibar[ii] Phi[ii] hatD[jj] hatDbar[jj] \
   - lamHD2/2 (hatD[ii] hatDbar[ii] Phibar[jj] Phi[jj] + I Eps[ii,jj,mm] PauliSigma[mm,ip,jp] Phibar[ip] Phi[jp]
        hatD[ii] hatDbar[jj] )  \
   + muHD/Sqrt[2] Phibar[ii] hatD[mm] PauliSigma[mm,ii,jj] Phibar[jp] Eps[jj,jp] \
   + muHD/Sqrt[2] Phi[jj] hatDbar[mm] PauliSigma[mm,ii,jj] Phi[jp] Eps[ii,jp];

LYukawa := Block[{yuk},
  yuk:=
   - yd[ff2, ff3] CKM[ff1, ff2] QLbar[sp, ii, ff1, cc].dR [sp, ff3, cc] Phi[ii] \
   - yl[ff1, ff3] LLbar[sp, ii, ff1].lR [sp, ff3] Phi[ii] \
   - Sum[yu[ff1, ff2] QLbar[sp, ii, ff1, cc].uR [sp, ff2, cc] Phibar[jj] Eps[ii, jj],{ii,2},{jj,2}] \
   - Sum[yDL[ff1, ff2]/Sqrt[2] Eps[ip,ii] CC[LLbar][sp, ii, ff1].LL[sp, jj, ff2] hatD[mm] PauliSigma[mm,ip,jj],
       {ii,2},{ip,2},{jj,2},{mm,3}];
  yuk+HC[yuk]
 ];

LType2:= {LGauge, LFermions, LScalar, LYukawa, LGhost};

