(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12311,        334]
NotebookOptionsPosition[      9778,        261]
NotebookOutlinePosition[     10114,        276]
CellTagsIndexPosition[     10071,        273]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "FeynRules`"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/TypeIII\>\""}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.476126542108259*^9, 3.476126544713786*^9}, {
  3.4818830018276663`*^9, 3.481883001975272*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"Type", " ", "III", " ", "Sessaw"}], "Title"]], "Input",
 CellChangeTimes->{{3.511191709404976*^9, 3.511191719277543*^9}}],

Cell[BoxData[
 RowBox[{"LoadModel", "[", "\"\<typeIIIseesaw1.0.fr\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.47612650049957*^9, 3.476126502200398*^9}, {
  3.481883005255148*^9, 3.481883005415077*^9}, {3.481883544645905*^9, 
  3.481883544789793*^9}, {3.481885977635333*^9, 3.481885977815366*^9}, {
  3.482032691896668*^9, 3.482032692639641*^9}, {3.4820339818487597`*^9, 
  3.482033982460396*^9}, {3.482038418724844*^9, 3.4820384205001574`*^9}, {
  3.482041586964872*^9, 3.482041587700461*^9}, {3.5111917369532757`*^9, 
  3.5111917426305656`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"The", " ", "lagrangian"}], "Section"]], "Input",
 CellFrame->{{0, 0}, {0, 2}},
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511192044510487*^9, 3.511192047536278*^9}, 
   3.511192117843423*^9, {3.511192197516609*^9, 3.5111922068092823`*^9}}],

Cell[BoxData["LTypeIII"], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5111920779480753`*^9, 3.5111920802570877`*^9}, 
   3.511192117843573*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"Checking", " ", "the", " ", "lagrangian"}], "Section"]], "Input",
 CellFrame->{{0, 0}, {0, 2}},
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511192246975973*^9, 3.511192251582735*^9}, 
   3.511192488247423*^9}],

Cell[BoxData[""], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5111923180133944`*^9, 3.511192331265234*^9}, 
   3.511192380642651*^9, 3.511192488247574*^9}],

Cell["Checking hermiticity", "Subsection",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4234156831783743`*^9, 3.423415689540821*^9}, {
   3.511192488247799*^9, 3.511192512864143*^9}, 3.511192548440689*^9}],

Cell["The hermiticity of the Lagrangian can be checked via", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.423415694323595*^9, 3.423415707867804*^9}, {
   3.511192488247941*^9, 3.5111925128643093`*^9}, 3.511192548440855*^9}],

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", 
  RowBox[{"LTypeIII", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.414763473002973*^9, 3.4147634845507174`*^9}, {
   3.508586944952985*^9, 3.50858694711281*^9}, {3.511192445191493*^9, 
   3.511192447301586*^9}, {3.511192488248057*^9, 3.511192512864438*^9}, 
   3.511192548440982*^9}],

Cell["\<\
The same command can be applied to the flavor - expanded Lagrangian\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.423415721582508*^9, 3.423415739787958*^9}, {
   3.511192488248184*^9, 3.511192512864554*^9}, 3.511192548441099*^9}],

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", 
  RowBox[{"LTypeIII", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.414763604111637*^9, 3.4147636044973803`*^9}, {
   3.5085869524890614`*^9, 3.508586957633074*^9}, {3.511192449189843*^9, 
   3.5111924511977987`*^9}, {3.5111924882483*^9, 3.511192512864677*^9}, 
   3.51119254844163*^9}],

Cell["Checking the mass spectrum", "Subsection",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.423415831209465*^9, 3.423415835278742*^9}, 
   3.5111924882484503`*^9, {3.511192522745852*^9, 3.5111925484417877`*^9}}],

Cell["\<\
FeynRules can check whether all the values of the masses given in the model \
file ar ein agreement with the masses given in the Lagrangian:\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.423415751305388*^9, 3.423415792594919*^9}, 
   3.511192488248652*^9, {3.511192522746015*^9, 3.511192548441927*^9}}],

Cell[BoxData[
 RowBox[{"CheckMassSpectrum", "[", "LTypeIII", "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.414736325829801*^9, 3.414736326065997*^9}, 
   3.4147528281460342`*^9, {3.508586960808408*^9, 3.508586962448135*^9}, {
   3.511192453576068*^9, 3.511192455573592*^9}, 3.511192488248768*^9, {
   3.5111925227461443`*^9, 3.5111925484420424`*^9}}],

Cell["Checking the kinetic terms", "Subsection",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.423415843532096*^9, 3.42341584850035*^9}, {
   3.511192361251031*^9, 3.511192376867984*^9}, 3.511192502199749*^9}],

Cell["\<\
In the same way, FeynRules can check whether all kinetic terms are correctly \
normalized :\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.423415798800013*^9, 3.423415817964087*^9}, {
   3.511192361251198*^9, 3.5111923768681517`*^9}, 3.511192502199913*^9}],

Cell[BoxData[
 RowBox[{"CheckKineticTermNormalisation", "[", 
  RowBox[{"LTypeIII", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4147636651636972`*^9, 3.414763667250185*^9}, {
   3.508586976753091*^9, 3.5085869778486147`*^9}, {3.5111923612513247`*^9, 
   3.511192376868272*^9}, 3.511192502200037*^9, {3.511192563266479*^9, 
   3.511192565305604*^9}}],

Cell["\<\
The same command cen be used at the level of the flavor - expanded Lagrangian \
:\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.423415868906054*^9, 3.4234158864202538`*^9}, {
   3.511192361251446*^9, 3.51119237686839*^9}, 3.5111925022001553`*^9}],

Cell[BoxData[
 RowBox[{"CheckKineticTermNormalisation", "[", 
  RowBox[{"LTypeIII", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.508586982353146*^9, 3.508586983769094*^9}, {
   3.511192361251564*^9, 3.5111923768685513`*^9}, 3.5111925022002707`*^9, {
   3.5111925669054832`*^9, 3.511192569449506*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Outputs and interfaces", "Section",
 CellFrame->{{0, 0}, {0, 2}},
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}}],

Cell[CellGroupData[{

Cell["MadGraph output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
  3.411911131666554*^9, 3.411911135984398*^9}}],

Cell["The MadGraph output for the SM can be obtained via", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911059590749*^9, 3.4119110601885567`*^9}, {3.41191113897644*^9, 
  3.411911142024486*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", "=", "False"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteMGOutput", "[", 
   RowBox[{"LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa"}], "]"}],
   ";"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
  3.412185409690489*^9, 3.4121854352800217`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["CalcHep output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
  3.411911150323291*^9, 3.4119111515122623`*^9}}],

Cell["CalcHep also supports the Feynman gauge", "Text",
 CellChangeTimes->{{3.4121853722243843`*^9, 3.412185380407339*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", "=", "True"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteCHOutput", "[", 
   RowBox[{
   "LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", "LGhost"}],
    "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
  3.412185409690489*^9, 3.4121854275198507`*^9}, {3.412450479942018*^9, 
  3.4124504817138367`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.412185367693318*^9, 3.412185407947097*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["UFO output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
  3.411911150323291*^9, 3.4119111515122623`*^9}, {3.510761255733572*^9, 
  3.510761256034461*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", "=", "True"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{
   "LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", "LGhost"}],
    "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
  3.412185409690489*^9, 3.4121854275198507`*^9}, {3.412450479942018*^9, 
  3.4124504817138367`*^9}, {3.510761258956971*^9, 3.510761260404662*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.412185367693318*^9, 3.412185407947097*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1276, 705},
WindowMargins->{{Automatic, 0}, {Automatic, 4}},
FrontEndVersion->"6.0 for Mac OS X x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 54, 1, 27, "Input"],
Cell[625, 24, 263, 6, 27, "Input"],
Cell[891, 32, 157, 3, 51, "Input"],
Cell[1051, 37, 547, 8, 27, "Input"],
Cell[CellGroupData[{
Cell[1623, 49, 307, 6, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[1933, 57, 183, 3, 27, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[2153, 65, 276, 6, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[2432, 73, 195, 3, 27, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[2630, 78, 235, 3, 34, "Subsection",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[2868, 83, 261, 3, 26, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[3132, 88, 435, 8, 27, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[3570, 98, 282, 5, 26, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[3855, 105, 437, 8, 27, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[4295, 115, 243, 3, 34, "Subsection",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[4541, 120, 355, 6, 26, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[4899, 128, 396, 6, 27, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[5298, 136, 238, 3, 34, "Subsection",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[5539, 141, 308, 6, 26, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[5850, 149, 453, 8, 27, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[6306, 159, 299, 6, 26, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[6608, 167, 403, 7, 27, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[7048, 179, 162, 3, 68, "Section"],
Cell[CellGroupData[{
Cell[7235, 186, 154, 2, 34, "Subsection"],
Cell[7392, 190, 233, 3, 26, "Text"],
Cell[7628, 195, 398, 10, 58, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8063, 210, 155, 2, 34, "Subsection"],
Cell[8221, 214, 123, 1, 26, "Text"],
Cell[8347, 217, 468, 12, 58, "Input"],
Cell[8818, 231, 90, 1, 27, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8945, 237, 200, 3, 34, "Subsection"],
Cell[9148, 242, 509, 12, 58, "Input"],
Cell[9660, 256, 90, 1, 27, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
