(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6907,        192]
NotebookOptionsPosition[      5809,        152]
NotebookOutlinePosition[      6187,        169]
CellTagsIndexPosition[      6144,        166]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"$FeynRulesPath", " ", "=", " ", 
   RowBox[{"SetDirectory", "[", "\"\<< address of the package>\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.413720861194676*^9, 3.4137208893794117`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.402202361365851*^9, 3.402202371944139*^9}, {
   3.402202561319804*^9, 3.402202569273497*^9}, 3.402745522459828*^9, 
   3.402746608214861*^9, {3.402747929860508*^9, 3.402747943827011*^9}, {
   3.403533007403466*^9, 3.403533008807395*^9}, {3.404106695164184*^9, 
   3.404106695449581*^9}, {3.405053642054455*^9, 3.4050536456262903`*^9}, 
   3.4119181919913683`*^9, {3.4137208986527243`*^9, 3.4137208996123943`*^9}, {
   3.4137242759980097`*^9, 3.413724294268169*^9}, 3.508569204008209*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</../models/SextetDiquarks\>\""}], 
   "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.508569210987895*^9, 3.508569240366075*^9}, {
  3.5086526985316563`*^9, 3.5086527008674803`*^9}, {3.5086537344899693`*^9, 
  3.508653736256976*^9}}],

Cell[CellGroupData[{

Cell["The Sextet diquark model", "Title",
 CellChangeTimes->{{3.411915778286763*^9, 3.4119157817267313`*^9}, {
  3.413720856398858*^9, 3.413720856723679*^9}, {3.508652686703946*^9, 
  3.5086526956245413`*^9}, {3.5086537494308853`*^9, 3.508653750046036*^9}}],

Cell[BoxData[
 RowBox[{"LoadModel", "[", 
  RowBox[{
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/SM.fr\>\""}], ",", 
   "\"\<SextetDiquarks.fr\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.4022069973481913`*^9, 3.402207011768662*^9}, 
   3.4022081212072697`*^9, {3.402208250379383*^9, 3.402208254043104*^9}, 
   3.4027466057480917`*^9, {3.403240270135737*^9, 3.403240277228945*^9}, 
   3.403266503388291*^9, {3.403267649630335*^9, 3.40326765417397*^9}, {
   3.403269919787421*^9, 3.403269921965273*^9}, {3.403347551273425*^9, 
   3.403347555049163*^9}, 3.403533015351287*^9, {3.40505363437746*^9, 
   3.40505363645761*^9}, {3.411912382149088*^9, 3.4119123969228477`*^9}, {
   3.50856924516405*^9, 3.5085692957646017`*^9}, {3.508652704764263*^9, 
   3.5086527148839912`*^9}, {3.508653755570479*^9, 3.508653758313497*^9}}],

Cell[CellGroupData[{

Cell["The lagrangian", "Section",
 CellChangeTimes->{{3.411915790793332*^9, 3.411915793199389*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "False"}], ";"}]], "Input",
 CellChangeTimes->{{3.411915017675109*^9, 3.411915022272778*^9}, 
   3.411915800951993*^9, {3.5085697915596943`*^9, 3.508569793189657*^9}}],

Cell["\<\
The lagrangian for the SM is the same as in SM.fr.

The kinetic term for the new sector is\
\>", "Text",
 CellChangeTimes->{{3.411915802313404*^9, 3.411915827110655*^9}, {
  3.508652776041321*^9, 3.5086527816810417`*^9}}],

Cell[BoxData["LSextetKin"], "Input",
 CellChangeTimes->{{3.4119143176932583`*^9, 3.411914319401045*^9}, {
  3.5086527413548803`*^9, 3.508652741850679*^9}, {3.508652785002825*^9, 
  3.508652786866547*^9}, {3.508652823258953*^9, 3.508652825786771*^9}, {
  3.5086537855918217`*^9, 3.508653788279793*^9}}],

Cell["The Yukawa couplings to quarks are given by", "Text",
 CellChangeTimes->{{3.50865283162808*^9, 3.5086528423553133`*^9}}],

Cell[BoxData["LD"], "Input",
 CellChangeTimes->{{3.508652853955349*^9, 3.508652858923099*^9}, 
   3.508653791031714*^9}],

Cell["The scalar diquark potential is given by", "Text",
 CellChangeTimes->{{3.508652867187509*^9, 3.508652875131366*^9}}],

Cell[BoxData["LPot"], "Input",
 CellChangeTimes->{{3.50865288551744*^9, 3.508652886027018*^9}}],

Cell["\<\
The whole new sector, i.e., the sum of the three previous pieces, can also be \
called via\
\>", "Text",
 CellChangeTimes->{{3.508652892044424*^9, 3.5086529087571917`*^9}}],

Cell[BoxData["LSextet"], "Input",
 CellChangeTimes->{{3.5086529162762423`*^9, 3.5086529189712887`*^9}, {
  3.5086537966638117`*^9, 3.5086537973194437`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Feynman rules for the new sector", "Section",
 CellChangeTimes->{{3.411915866249317*^9, 3.4119158716988153`*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LSextet", "]"}]], "Input",
 CellChangeTimes->{{3.411915883502528*^9, 3.411915928653887*^9}, {
   3.4137211614912577`*^9, 3.4137211708030777`*^9}, 3.508569350492257*^9, {
   3.5086529230279818`*^9, 3.5086529240436687`*^9}, {3.508653800616362*^9, 
   3.50865380154422*^9}}],

Cell["\<\
Note that the complaint about non conservation of the hypercharge is \
harmless.
It only results form the fact that in the SM implementation SM.fr, the quarks \
hypercharge was not defined.\
\>", "Text",
 CellChangeTimes->{{3.508652973935788*^9, 3.5086530255775213`*^9}}],

Cell["Or in a flavor expanded form", "Text",
 CellChangeTimes->{{3.411915937803143*^9, 3.4119159434558887`*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LSextet", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.411915883502528*^9, 3.411915958983838*^9}, {
  3.508569657623721*^9, 3.508569668869379*^9}, {3.508653028324347*^9, 
  3.508653029012122*^9}, {3.508653853418923*^9, 3.508653854584044*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1272, 681},
WindowMargins->{{0, Automatic}, {Automatic, 24}},
ShowSelection->True,
Magnification->1.5,
FrontEndVersion->"7.0 for Linux x86 (64-bit) (November 11, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 233, 5, 46, "Input"],
Cell[781, 27, 626, 10, 107, "Input"],
Cell[1410, 39, 327, 7, 46, "Input"],
Cell[CellGroupData[{
Cell[1762, 50, 257, 3, 126, "Title"],
Cell[2022, 55, 828, 13, 46, "Input"],
Cell[CellGroupData[{
Cell[2875, 72, 99, 1, 108, "Section"],
Cell[2977, 75, 222, 4, 46, "Input"],
Cell[3202, 81, 231, 6, 99, "Text"],
Cell[3436, 89, 301, 4, 46, "Input"],
Cell[3740, 95, 126, 1, 44, "Text"],
Cell[3869, 98, 120, 2, 46, "Input"],
Cell[3992, 102, 122, 1, 44, "Text"],
Cell[4117, 105, 95, 1, 46, "Input"],
Cell[4215, 108, 182, 4, 44, "Text"],
Cell[4400, 114, 156, 2, 46, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4593, 121, 119, 1, 108, "Section"],
Cell[4715, 124, 316, 5, 46, "Input"],
Cell[5034, 131, 281, 6, 72, "Text"],
Cell[5318, 139, 112, 1, 44, "Text"],
Cell[5433, 142, 348, 6, 46, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
