
M$ModelName = "Triplet_Diquarks";

(* 
   
   The convention and notations follow 0909.2666 
   We also allow for non intergeneration couplings between quarks. 
   The mixing matrices are however implemented in general, and put diagonal via the independent
   restriction file 

   MFV.rst

   The new particles are

   trip1  =  (6, 1, -1/3)

*)

M$Information = {Authors -> {"C. Duhr"}, 
             Version -> "1.0",
             Date -> "27. 10. 2010",
             Institutions -> {"IPPP, Durham"},
             Emails -> {"claude.duhr@durham.ac.uk"}};


(* Coupling matrices are symmetric *)


SetAttributes[LQQR, Orderless];
SetAttributes[LUDL, Orderless];
SetAttributes[LUUL, Orderless];
SetAttributes[LDDL, Orderless];

M$Parameters = {
 
   LQQRR == {Indices -> {Index[Generation], Index[Generation]},
             Value -> {LQQRR[1,1]  -> 0.1,
                       LQQRR[2,2]  -> 0.1,
                       LQQRR[3,3]  -> 0.1,
                       LQQRR[i_, j_] :> 0 /; NumericQ[i] && NumericQ[j] && (i !=j)},
             InteractionOrder -> {QCD, 1},
             ParameterType -> External,
             ComplexParameter -> False
            },

   LQQRI == {Indices -> {Index[Generation], Index[Generation]},
             Value -> {LQQRI[_,_]  -> 0},
             InteractionOrder -> {QCD, 1},
             ParameterType -> External,
             ComplexParameter -> False
            },

   LUDLR == {Indices -> {Index[Generation], Index[Generation]},
             Value -> {LUDLR[1,1]  -> 0.1,
                       LUDLR[2,2]  -> 0.1,
                       LUDLR[3,3]  -> 0.1,
                       LUDLR[i_, j_] :> 0 /; NumericQ[i] && NumericQ[j] && (i !=j)},
             InteractionOrder -> {QCD, 1},
             ParameterType -> External,
             ComplexParameter -> False
            },

   LUDLI == {Indices -> {Index[Generation], Index[Generation]},
              Value -> {LUDLI[_,_]  -> 0},
              InteractionOrder -> {QCD, 1},
              ParameterType -> External,
             ComplexParameter -> False
            },



   LHS1 == {InteractionOrder -> {QED, 2},
            Value -> 1,
            ParameterType -> External
           },

   LSS11 == {InteractionOrder -> {QCD, 2},
             Value -> 1,
             ParameterType -> External
            },


(* Internal parameters *)

   LQQR == {Indices -> {Index[Generation], Index[Generation]},
            Value -> {LQQR[i_,j_] :> LQQRR[i,j] + I LQQRI[i,j]},
            InteractionOrder -> {QCD, 1},
             ComplexParameter -> True
            },

   LUDL == {Indices -> {Index[Generation], Index[Generation]},
            Value -> {LUDL[i_,j_] :> LUDLR[i,j] + I LUDLI[i,j]},
            InteractionOrder -> {QCD, 1},
             ComplexParameter -> True
            }
};

M$ClassesDescription = {

   S[100] == {
      ClassName -> trip1,
      SelfConjugate -> False,
      Indices -> {Index[Colour]},
      Mass ->    {Mtrip1, 500},
      Width ->   {Wtrip1, 4.4108},
      QuantumNumbers -> {Q -> -1/3, Y -> -1/3}
     }
};


(* the Lagrangian *)


LTripKin := DC[trip1bar[k], mu]DC[trip1[k],mu] - Mtrip1^2 trip1bar[k]trip1[k];

LD11     := 2  (Eps[k,i,j] trip1bar[k] LQQR[n,m] ProjP[s,r] dqbar[s,n,i].CC[uq][r,m,j] + 
                Eps[k,i,j] trip1bar[k] LUDL[n,m] ProjM[s,r] dqbar[s,n,i].CC[uq][r,m,j]);

LD1 := LD11 + HC[LD11];

LPot := ExpandIndices[LHS1 Phibar[ii] Phi[ii] trip1bar[k]trip1[k] +  
       LSS11 trip1bar[k1]trip1[k1]trip1bar[k2]trip1[k2], FlavorExpand->{SU2W,SU2D}];

LTrip := LTripKin + LD1 + LPot;






