# This file was automatically created by FeynRules 2.4.58
# Mathematica version: 12.1.1 for Mac OS X x86 (64-bit) (June 19, 2020)
# Date: Fri 26 Feb 2021 09:52:16



from object_library import all_parameters, Parameter


from function_library import complexconjugate, re, im, csc, sec, acsc, asec, cot

# This is a default parameter object representing 0.
ZERO = Parameter(name = 'ZERO',
                 nature = 'internal',
                 type = 'real',
                 value = '0.0',
                 texname = '0')

# User-defined parameters.
LamNP = Parameter(name = 'LamNP',
                  nature = 'external',
                  type = 'real',
                  value = 1,
                  texname = '\\Lambda',
                  lhablock = 'DIM6',
                  lhacode = [ 1 ])

Cuu = Parameter(name = 'Cuu',
                nature = 'external',
                type = 'real',
                value = 1,
                texname = 'C_{\\text{uu}}',
                lhablock = 'DIM6',
                lhacode = [ 2 ])

Cqq = Parameter(name = 'Cqq',
                nature = 'external',
                type = 'real',
                value = 1,
                texname = 'C_{\\text{qq}}',
                lhablock = 'DIM6',
                lhacode = [ 3 ])

C1qu = Parameter(name = 'C1qu',
                 nature = 'external',
                 type = 'real',
                 value = 1,
                 texname = 'C_{\\text{qu}}^1',
                 lhablock = 'DIM6',
                 lhacode = [ 4 ])

C8qu = Parameter(name = 'C8qu',
                 nature = 'external',
                 type = 'real',
                 value = 1,
                 texname = 'C_{\\text{qu}}^8',
                 lhablock = 'DIM6',
                 lhacode = [ 5 ])

C1s = Parameter(name = 'C1s',
                nature = 'external',
                type = 'real',
                value = 1,
                texname = 'C_s^1',
                lhablock = 'DIM6',
                lhacode = [ 6 ])

C8s = Parameter(name = 'C8s',
                nature = 'external',
                type = 'real',
                value = 1,
                texname = 'C_s^8',
                lhablock = 'DIM6',
                lhacode = [ 7 ])

C1ps = Parameter(name = 'C1ps',
                 nature = 'external',
                 type = 'real',
                 value = 1,
                 texname = 'C_{\\text{ps}}^1',
                 lhablock = 'DIM6',
                 lhacode = [ 8 ])

C8ps = Parameter(name = 'C8ps',
                 nature = 'external',
                 type = 'real',
                 value = 1,
                 texname = 'C_{\\text{ps}}^8',
                 lhablock = 'DIM6',
                 lhacode = [ 9 ])

aEWM1 = Parameter(name = 'aEWM1',
                  nature = 'external',
                  type = 'real',
                  value = 127.9,
                  texname = '\\text{aEWM1}',
                  lhablock = 'SMINPUTS',
                  lhacode = [ 1 ])

Gf = Parameter(name = 'Gf',
               nature = 'external',
               type = 'real',
               value = 0.0000116637,
               texname = 'G_f',
               lhablock = 'SMINPUTS',
               lhacode = [ 2 ])

aS = Parameter(name = 'aS',
               nature = 'external',
               type = 'real',
               value = 0.1184,
               texname = '\\alpha _s',
               lhablock = 'SMINPUTS',
               lhacode = [ 3 ])

ymb = Parameter(name = 'ymb',
                nature = 'external',
                type = 'real',
                value = 4.7,
                texname = '\\text{ymb}',
                lhablock = 'YUKAWA',
                lhacode = [ 5 ])

ymt = Parameter(name = 'ymt',
                nature = 'external',
                type = 'real',
                value = 172,
                texname = '\\text{ymt}',
                lhablock = 'YUKAWA',
                lhacode = [ 6 ])

ymtau = Parameter(name = 'ymtau',
                  nature = 'external',
                  type = 'real',
                  value = 1.777,
                  texname = '\\text{ymtau}',
                  lhablock = 'YUKAWA',
                  lhacode = [ 15 ])

MZ = Parameter(name = 'MZ',
               nature = 'external',
               type = 'real',
               value = 91.1876,
               texname = '\\text{MZ}',
               lhablock = 'MASS',
               lhacode = [ 23 ])

MTA = Parameter(name = 'MTA',
                nature = 'external',
                type = 'real',
                value = 1.777,
                texname = '\\text{MTA}',
                lhablock = 'MASS',
                lhacode = [ 15 ])

MT = Parameter(name = 'MT',
               nature = 'external',
               type = 'real',
               value = 172,
               texname = '\\text{MT}',
               lhablock = 'MASS',
               lhacode = [ 6 ])

MB = Parameter(name = 'MB',
               nature = 'external',
               type = 'real',
               value = 4.7,
               texname = '\\text{MB}',
               lhablock = 'MASS',
               lhacode = [ 5 ])

MH = Parameter(name = 'MH',
               nature = 'external',
               type = 'real',
               value = 125,
               texname = '\\text{MH}',
               lhablock = 'MASS',
               lhacode = [ 25 ])

WZ = Parameter(name = 'WZ',
               nature = 'external',
               type = 'real',
               value = 2.4952,
               texname = '\\text{WZ}',
               lhablock = 'DECAY',
               lhacode = [ 23 ])

WW = Parameter(name = 'WW',
               nature = 'external',
               type = 'real',
               value = 2.085,
               texname = '\\text{WW}',
               lhablock = 'DECAY',
               lhacode = [ 24 ])

WT = Parameter(name = 'WT',
               nature = 'external',
               type = 'real',
               value = 1.50833649,
               texname = '\\text{WT}',
               lhablock = 'DECAY',
               lhacode = [ 6 ])

WH = Parameter(name = 'WH',
               nature = 'external',
               type = 'real',
               value = 0.00407,
               texname = '\\text{WH}',
               lhablock = 'DECAY',
               lhacode = [ 25 ])

aEW = Parameter(name = 'aEW',
                nature = 'internal',
                type = 'real',
                value = '1/aEWM1',
                texname = '\\alpha _{\\text{EW}}')

C1psLam = Parameter(name = 'C1psLam',
                    nature = 'internal',
                    type = 'real',
                    value = 'C1ps/LamNP**2',
                    texname = '\\frac{C_{\\text{ps}}^1}{\\Lambda ^2}')

C1quLam = Parameter(name = 'C1quLam',
                    nature = 'internal',
                    type = 'real',
                    value = 'C1qu/LamNP**2',
                    texname = '\\frac{C_{\\text{qu}}^1}{\\Lambda ^2}')

C1sLam = Parameter(name = 'C1sLam',
                   nature = 'internal',
                   type = 'real',
                   value = 'C1s/LamNP**2',
                   texname = '\\frac{C_s^1}{\\Lambda ^2}')

C8psLam = Parameter(name = 'C8psLam',
                    nature = 'internal',
                    type = 'real',
                    value = 'C8ps/LamNP**2',
                    texname = '\\frac{C_{\\text{ps}}^8}{\\Lambda ^2}')

C8quLam = Parameter(name = 'C8quLam',
                    nature = 'internal',
                    type = 'real',
                    value = 'C8qu/LamNP**2',
                    texname = '\\frac{C_{\\text{qu}}^8}{\\Lambda ^2}')

C8sLam = Parameter(name = 'C8sLam',
                   nature = 'internal',
                   type = 'real',
                   value = 'C8s/LamNP**2',
                   texname = '\\frac{C_s^8}{\\Lambda ^2}')

CqqLam = Parameter(name = 'CqqLam',
                   nature = 'internal',
                   type = 'real',
                   value = 'Cqq/LamNP**2',
                   texname = '\\frac{C_{\\text{qq}}}{\\Lambda ^2}')

CuuLam = Parameter(name = 'CuuLam',
                   nature = 'internal',
                   type = 'real',
                   value = 'Cuu/LamNP**2',
                   texname = '\\frac{C_{\\text{uu}}}{\\Lambda ^2}')

G = Parameter(name = 'G',
              nature = 'internal',
              type = 'real',
              value = '2*cmath.sqrt(aS)*cmath.sqrt(cmath.pi)',
              texname = 'G')

MW = Parameter(name = 'MW',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(MZ**2/2. + cmath.sqrt(MZ**4/4. - (aEW*cmath.pi*MZ**2)/(Gf*cmath.sqrt(2))))',
               texname = 'M_W')

ee = Parameter(name = 'ee',
               nature = 'internal',
               type = 'real',
               value = '2*cmath.sqrt(aEW)*cmath.sqrt(cmath.pi)',
               texname = 'e')

sw2 = Parameter(name = 'sw2',
                nature = 'internal',
                type = 'real',
                value = '1 - MW**2/MZ**2',
                texname = '\\text{sw2}')

cw = Parameter(name = 'cw',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(1 - sw2)',
               texname = 'c_w')

sw = Parameter(name = 'sw',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(sw2)',
               texname = 's_w')

g1 = Parameter(name = 'g1',
               nature = 'internal',
               type = 'real',
               value = 'ee/cw',
               texname = 'g_1')

gw = Parameter(name = 'gw',
               nature = 'internal',
               type = 'real',
               value = 'ee/sw',
               texname = 'g_w')

vev = Parameter(name = 'vev',
                nature = 'internal',
                type = 'real',
                value = '(2*MW*sw)/ee',
                texname = '\\text{vev}')

lam = Parameter(name = 'lam',
                nature = 'internal',
                type = 'real',
                value = 'MH**2/(2.*vev**2)',
                texname = '\\text{lam}')

yb = Parameter(name = 'yb',
               nature = 'internal',
               type = 'real',
               value = '(ymb*cmath.sqrt(2))/vev',
               texname = '\\text{yb}')

yt = Parameter(name = 'yt',
               nature = 'internal',
               type = 'real',
               value = '(ymt*cmath.sqrt(2))/vev',
               texname = '\\text{yt}')

ytau = Parameter(name = 'ytau',
                 nature = 'internal',
                 type = 'real',
                 value = '(ymtau*cmath.sqrt(2))/vev',
                 texname = '\\text{ytau}')

muH = Parameter(name = 'muH',
                nature = 'internal',
                type = 'real',
                value = 'cmath.sqrt(lam*vev**2)',
                texname = '\\mu')

I1b33 = Parameter(name = 'I1b33',
                  nature = 'internal',
                  type = 'complex',
                  value = 'yb',
                  texname = '\\text{I1b33}')

I2b33 = Parameter(name = 'I2b33',
                  nature = 'internal',
                  type = 'complex',
                  value = 'yt',
                  texname = '\\text{I2b33}')

I3b33 = Parameter(name = 'I3b33',
                  nature = 'internal',
                  type = 'complex',
                  value = 'yt',
                  texname = '\\text{I3b33}')

I4b33 = Parameter(name = 'I4b33',
                  nature = 'internal',
                  type = 'complex',
                  value = 'yb',
                  texname = '\\text{I4b33}')

