(* ********************************************************* *)
(* *****                                               ***** *)
(* *****  FeynRules model file: SM + colored scalars   ***** *)
(* *****  Author: B. Fuks, L. Darme                     ***** *)
(* *****                                               ***** *)
(* ********************************************************* *)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "ColoredScalarsAndPScalars";
M$Information = {
  Authors      -> {"Luc Darme","Benjamin Fuks"},
  Emails       -> {"luc.darme@lnf.infn.it","fuks@lpthe.jussieu.fr"},
  Institutions -> {"LPTHE / UPMC","LNF, INFN"},
  Date         -> "26.02.2021",
  Version      -> "1",
  References   -> "xxx"};

(* ************************** *)
(* *****  Orders        ***** *)
(* ************************** *)
M$InteractionOrderHierarchy = { {QCD, 1},  {QED, 2},  {NP,1} };
M$InteractionOrderLimit     = { {QCD, 99}, {QED, 99}, {NP,99} };

(* ************************** *)
(* *****     Fields     ***** *)
(* ************************** *)
M$ClassesDescription = {
  S[4] == {
    ClassName        -> sig8,
    SelfConjugate    -> True,
    Indices          -> {Index[Gluon]},
    Mass             -> {m8,400},
    Width            -> {w8,10},
    ParticleName     -> "sig8",
    PDG              -> 9000001,
    PropagatorLabel  -> "sig8",
    PropagatorType   -> ScalarDash,
    PropagatorArrow  -> Forward
  }
};

(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {
(**** slguons top interaction ****)
yPS8 == {
  TeX              -> Subsuperscript[y,"8PS"],
  ComplexParameter -> False,
  ParameterType    -> External,
  BlockName        -> NPyPS8,
  Value            -> 0.3,
  InteractionOrder -> {NP,1},
  Description      -> "Sgluon coupling to quarks"
  }

};

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)
L1 := 1/2 DC[sig8[aa],mu] DC[sig8[aa],mu] - 1/2 m8^2 sig8[aa] sig8[aa];

L2a :=  Block[{sp,sp2,sp3,ff,gg,mm,nn,aa},ExpandIndices[ sig8[aa] T[aa,mm,nn] yPS8*(-I*ProjM[sp,sp2] + I*ProjP[sp,sp2]) uqbar[sp,3,mm].uq[sp2,3,nn]]];

(*L2b = g8g*dSUN[a,b,c] sig8[a] FS[G,mu,nu,b] FS[G,mu,nu,c];*)

LagNP := L1 + L2a + HC[Expand[L2a]] ;
