(* ********************************************************* *)
(* *****                                               ***** *)
(* *****  FeynRules model file: SM + singlet vector boson   ***** *)
(* *****  Author: B. Fuks, L. Darme                     ***** *)
(* *****                                               ***** *)
(* ********************************************************* *)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "SingletVector";
M$Information = {
  Authors      -> {"Luc Darme","Benjamin Fuks"},
  Emails       -> {"luc.darme@lnf.infn.it","fuks@lpthe.jussieu.fr"},
  Institutions -> {"LPTHE / UPMC","LNF, INFN"},
  Date         -> "26.02.2021",
  Version      -> "1",
  References   -> "xxx"};


(* ************************** *)
(* *****  Orders        ***** *)
(* ************************** *)
M$InteractionOrderHierarchy = { {QCD, 1},  {QED, 2},  {NP,1} };
M$InteractionOrderLimit     = { {QCD, 99}, {QED, 99}, {NP,99} };

(* ************************** *)
(* *****     Fields     ***** *)
(* ************************** *)

M$ClassesDescription = {
  V[6] == {
    ClassName        -> Zp,
    SelfConjugate    -> True,
    Mass             -> {MZp, 3000},
    Width            -> {WZp, 500},
    ParticleName     -> "Zp",
    PropagatorLabel  -> "Zp",
    PropagatorType   -> Sine,
    PropagatorArrow  -> None,
    FullName         -> "Vsinglet"
  }
};


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {


  g0uL == {
    TeX              -> Subscript[g,"1L"],
    ParameterType    -> External,
    ComplexParameter -> False,
    BlockName        -> NPG0L,
    Value            -> 0.3,
    InteractionOrder -> {NP,1},
    Description      -> "Vector singlet coupling to Left-handed up quark"},
  g0uR == {
      TeX              -> Subscript[g,"1R"],
      ParameterType    -> External,
      ComplexParameter -> False,
      BlockName        -> NPG0R,
      Value            -> 0.3,
      InteractionOrder -> {NP,1},
      Description      -> "Vector singlet coupling to Right-handed up quark"}


};

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)
L1 := ExpandIndices[-1/4 FS[Zp,mu,nu] FS[Zp,mu,nu] + 1/2 MZp^2 Zp[mu] Zp[mu]];

LupL := Block[{sp,sp2,sp3,ff,gg,n},ExpandIndices[  Zp[mu]*g0uL *ProjM[sp2,sp3]*Ga[mu,sp,sp2] uqbar[sp,3,n].uq[sp3,3,n] ]];
LupR := Block[{sp,sp2,sp3,ff,gg,n},ExpandIndices[  Zp[mu]*g0uR *ProjP[sp2,sp3]*Ga[mu,sp,sp2] uqbar[sp,3,n].uq[sp3,3,n] ]];

LagNP := L1 + LupL + LupR ;
