(* ****************************************************************** *)
(* *****                                                      ***** *)
(* *****  FeynRules model file: SM + singlet Top-philic pseudo-scalars   ***** *)
(* *****  Author: L. Darme, B. Fuks,                          ***** *)
(* *****                                                       ***** *)
(* ****************************************************************** *)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "PseudoScalarSingletTopPhilic";
M$Information = {
  Authors      -> {"Luc Darme","Benjamin Fuks"},
  Emails       -> {"luc.darme@lnf.infn.it","fuks@lpthe.jussieu.fr"},
  Institutions -> {"LPTHE / UPMC","LNF, INFN"},
  Date         -> "26.02.2021",
  Version      -> "1",
  References   -> "xxx"};


(* ************************** *)
(* *****  Orders        ***** *)
(* ************************** *)
M$InteractionOrderHierarchy = { {QCD, 1},  {QED, 2},  {NP,1} };
M$InteractionOrderLimit     = { {QCD, 99}, {QED, 99}, {NP,99} };

(* ************************** *)
(* *****     Fields     ***** *)
(* ************************** *)
M$ClassesDescription = {
  S[4] == {
    ClassName        -> PS1,
    SelfConjugate    -> True,
    Mass             -> {mPS1,400},
    Width            -> {wPS1,10},
    ParticleName     -> "PS1",
    PDG              -> 9000001,
    PropagatorLabel  -> "PS1",
    PropagatorType   -> ScalarDash,
    PropagatorArrow  -> Forward
  }
};

(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {
  yPS1 == {
    TeX              -> Subsuperscript[y,"1P"],
    ComplexParameter -> False,
    ParameterType    -> External,
    BlockName        -> NPyPS,
    Value            -> 1,
    InteractionOrder -> {NP,1},
    Description      -> "Pseudo-Scalar singlet coupling"
    }
};

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)
(* We keep yLu and yRu, set yLu=yRu for the standard pseudo-scalar case *)

L1 := 1/2 DC[Xt,mu] DC[X,mu] - 1/2 m8^2 Xt Xt;

L2a :=   Block[{sp,sp2,sp3,ff,gg,mm,nn},ExpandIndices[   PS1*yPS1*(-I ProjM[sp,sp2] + I ProjP[sp,sp2]) uqbar[sp,3,m].uq[sp2,3,m]]];
LagNP := L1 + L2a;
