(* ********************************************************* *)
(* *****                                               ***** *)
(* *****  FeynRules model file: SM + colored vector boson   ***** *)
(* *****  Author: B. Fuks, L. Darme                     ***** *)
(* *****                                               ***** *)
(* ********************************************************* *)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "ColoredVector";
M$Information = {
  Authors      -> {"Luc Darme","Benjamin Fuks"},
  Emails       -> {"luc.darme@lnf.infn.it","fuks@lpthe.jussieu.fr"},
  Institutions -> {"LPTHE / UPMC","LNF, INFN"},
  Date         -> "26.02.2021",
  Version      -> "1",
  References   -> "xxx"};


(* ************************** *)
(* *****  Orders        ***** *)
(* ************************** *)

M$InteractionOrderHierarchy = { {QCD, 1},  {QED, 2},  {NP,1} };
M$InteractionOrderLimit     = { {QCD, 99}, {QED, 99}, {NP,99} };

(* ************************** *)
(* *****     Fields     ***** *)
(* ************************** *)

M$ClassesDescription = {
  V[6] == {
    ClassName        -> Vo,
    SelfConjugate    -> True,
    Indices          -> {Index[Gluon]},
    Mass             -> {MVo, 3000},
    Width            -> {WVo, 500},
    ParticleName     -> "Vo",
    PropagatorLabel  -> "Vo",
    PropagatorType   -> Sine,
    PropagatorArrow  -> None,
    FullName         -> "Voctet"
  }
};


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {


  g8uL == {
    TeX              -> Subscript[g,"8L"],
    ParameterType    -> External,
    ComplexParameter -> False,
    BlockName        -> NPG8L,
      InteractionOrder -> {NP,1},
    Value            -> 0.3,
    InteractionOrder -> {NP,1},
    Description      -> "Vector octet coupling to Left-handed up quark"},
  g8uR == {
      TeX              -> Subscript[g,"8R"],
      ParameterType    -> External,
      ComplexParameter -> False,
      BlockName        -> NPG8R,
      InteractionOrder -> {NP,1},
      Value            -> 0.3,
      Description      -> "Vector octet coupling to Right-handed up quark"}
};

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)
L1 := ExpandIndices[-1/4 (DC[Vo[mu,cc],nu]-DC[Vo[nu,cc],mu])^2 + 1/2 MVo^2 Vo[mu,aa] Vo[mu,aa]];

LupL := Block[{sp,sp2,sp3,ff,gg,mm,nn},ExpandIndices[  Vo[mu,a] T[a,mm,nn] *g8uL*ProjM[sp2,sp3]*Ga[mu,sp,sp2] uqbar[sp,3,mm].uq[sp3,3,nn] ]];
LupR := Block[{sp,sp2,sp3,ff,gg,mm,nn},ExpandIndices[  Vo[mu,a] T[a,mm,nn] *g8uR*ProjP[sp2,sp3]*Ga[mu,sp,sp2] uqbar[sp,3,mm].uq[sp3,3,nn] ]];

LagNP := L1 + LupL + LupR ;
