(* ********************************************************* *)
(* *****                                               ***** *)
(* *****  FeynRules model file: SM + singlet Top-philic scalars   ***** *)
(* *****  Author: B. Fuks, L. Darme                     ***** *)
(* *****                                               ***** *)
(* ********************************************************* *)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "SingletTopPhilicScalar";
M$Information = {
  Authors      -> {"Luc Darme","Benjamin Fuks"},
  Emails       -> {"luc.darme@lnf.infn.it","fuks@lpthe.jussieu.fr"},
  Institutions -> {"LPTHE / UPMC","LNF, INFN"},
  Date         -> "26.02.2021",
  Version      -> "1",
  References   -> "xxx"};

(* Change log *)

(* ************************** *)
(* *****  Orders        ***** *)
(* ************************** *)
M$InteractionOrderHierarchy = { {QCD, 1},  {QED, 2},  {NP,1} };
M$InteractionOrderLimit     = { {QCD, 99}, {QED, 99}, {NP,99} };

(* ************************** *)
(* *****     Fields     ***** *)
(* ************************** *)
M$ClassesDescription = {
  S[4] == {
    ClassName        -> sig1,
    SelfConjugate    -> True,
    Mass             -> {msig1,400},
    Width            -> {wsig1,10},
    ParticleName     -> "sig1",
    PDG              -> 9000001,
    PropagatorLabel  -> "sig1",
    PropagatorType   -> ScalarDash,
    PropagatorArrow  -> Forward
  }
};

(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {
  ynpS1 == {
    TeX              -> Subsuperscript[y,"1S"],
    ComplexParameter -> False,
    ParameterType    -> External,
    BlockName        -> NPyS1,
    Value            -> 0.1,
    InteractionOrder -> {NP,1},
    Description      -> "Scalar top-philic singlet coupling"
    }
};

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)
L1 := 1/2 DC[sig1,mu] DC[sig1,mu] - 1/2 msig1^2 sig1 sig1;

L2a :=   Block[{sp,sp2,sp3,ff,gg,mm,nn},ExpandIndices[   sig1  ynpS1*( ProjM[sp,sp2] + ProjP[sp,sp2]) uqbar[sp,3,m].uq[sp2,3,m]]];

LagNP := L1 + L2a  ;
