(***************************************************************************************************************)
(******     FeynRules for pure four top  EFT   production                                                 ******)
(******                                                                                                   ******)
(******     Authors: By L. Darme (for EW-breaking part)                                                   ******)
(******      EW-perserving part derived from C. Degrande (https://feynrules.irmp.ucl.ac.be/wiki/TopEffTh  ******)
(******                                                                                                   ******)
(***************************************************************************************************************)

M$ModelName = "4topEFT";


M$Information = {Authors -> {" L. Darme"},
             Version -> "1.0",
             Date -> "26.02. 2021",
             Institutions -> {"INFN"},
             Emails -> {"luc.darme@lnf.infn.it"}};


 M$InteractionOrderHierarchy = { {QCD, 1},  {QED, 2},  {NP,1} };
 M$InteractionOrderLimit     = { {QCD, 99}, {QED, 99}, {NP,99} };



(****************  Parameters *************)

M$Parameters = {

(* External parameters *)

LamNP == {
      ParameterType -> External,
      BlockName -> DIM6,
      Value -> 1,
  TeX -> \[CapitalLambda],
      Description -> "cHigh scale EFT "},

  Cuu == {
        ParameterType -> External,
        BlockName -> DIM6,
	  InteractionOrder -> { NP, 2},
        Value -> 1,
	  TeX -> Subscript[C,uu],
        Description -> "coefficient of Ouu "},

  Cqq== {
        ParameterType -> External,
        BlockName -> DIM6,
	  InteractionOrder -> { NP, 2},
        Value -> 1,
	  TeX -> Subscript[C,qq],
        Description -> "coefficient of Oqq "},


  C1qu== {
        ParameterType -> External,
        BlockName -> DIM6,
	  InteractionOrder -> { NP, 2},
        Value -> 1,
	  TeX -> Subsuperscript[C,qu,1],
        Description -> "coefficient of O1qu "},

  C8qu== {
        ParameterType -> External,
        BlockName -> DIM6,
	  InteractionOrder -> { NP, 2},
        Value -> 1,
	  TeX -> Subsuperscript[C,qu,8],
        Description -> "coefficient of O8qu "},


    C1s== {
          ParameterType -> External,
          BlockName -> DIM6,
  	  InteractionOrder -> { NP, 2},
          Value -> 1,
  	  TeX -> Subsuperscript[C,s,1],
          Description -> "coefficient of O1ss "},

    C8s== {
          ParameterType -> External,
          BlockName -> DIM6,
  	  InteractionOrder -> { NP, 2},
          Value -> 1,
  	  TeX -> Subsuperscript[C,s,8],
          Description -> "coefficient of O8ss "},

    C1ps== {
          ParameterType -> External,
          BlockName -> DIM6,
  	  InteractionOrder -> { NP, 2},
          Value -> 1,
  	  TeX -> Subsuperscript[C,ps,1],
          Description -> "coefficient of O1psps "},

    C8ps== {
          ParameterType -> External,
          BlockName -> DIM6,
  	  InteractionOrder -> { NP, 2},
          Value -> 1,
  	  TeX -> Subsuperscript[C,ps,8],
          Description -> "coefficient of O8psps "},



    CuuLam == {
          ParameterType -> Internal,
  	  InteractionOrder -> { NP, 2},
          Value ->  Cuu/LamNP/LamNP,
  	  TeX -> Subscript[C,uu]/\[CapitalLambda]^2,
          Description -> "coefficient of Ouu in TeV-2"},

    CqqLam== {
    ParameterType -> Internal,
InteractionOrder -> { NP, 2},
    Value ->  Cqq/LamNP/LamNP,
  	  TeX -> Subscript[C,qq]/\[CapitalLambda]^2,
          Description -> "coefficient of Oqq in TeV-2"},


    C1quLam== {
    ParameterType -> Internal,
InteractionOrder -> { NP, 2},
    Value ->  C1qu/LamNP/LamNP,
  	  TeX -> Subsuperscript[C,qu,1]/\[CapitalLambda]^2,
          Description -> "coefficient of O1qu in TeV-2"},

    C8quLam== {
    ParameterType -> Internal,
InteractionOrder -> { NP, 2},
    Value ->  C8qu/LamNP/LamNP,
  	  TeX -> Subsuperscript[C,qu,8]/\[CapitalLambda]^2,
          Description -> "coefficient of O8qu in TeV-2"},


      C1sLam== {
      ParameterType -> Internal,
  InteractionOrder -> { NP, 2},
      Value -> C1s/LamNP/LamNP,
    	  TeX -> Subsuperscript[C,s,1]/\[CapitalLambda]^2,
            Description -> "coefficient of O1ss in TeV-2"},

      C8sLam== {
      ParameterType -> Internal,
  InteractionOrder -> { NP, 2},
      Value ->  C8s/LamNP/LamNP,
    	  TeX -> Subsuperscript[C,s,8]/\[CapitalLambda]^2,
            Description -> "coefficient of O8ss in TeV-2"},

      C1psLam== {
      ParameterType -> Internal,
  InteractionOrder -> { NP, 2},
      Value -> C1ps/LamNP/LamNP,
    	  TeX -> Subsuperscript[C,ps,1]/\[CapitalLambda]^2,
            Description -> "coefficient of O1psps in TeV-2"},

      C8psLam== {
      ParameterType -> Internal,
  InteractionOrder -> { NP, 2},
      Value ->  C8ps/LamNP/LamNP,
    	  TeX -> Subsuperscript[C,ps,8]/\[CapitalLambda]^2,
            Description -> "coefficient of O8psps in TeV-2"}


};


 L4topVector := Expand[ExpandIndices[
 (C8quLam* Module[{ii,jj,kk,kk1,jj1,mu,aa,cc,sp1,sp2,sp3,sp4,cc1,cc2,cc3,cc4},  ( T[aa,cc,cc2]T[aa,cc3,cc4] uqbar[sp1,3,cc].uq[sp2,3,cc2]  Ga[mu,sp1,spa] ProjM[spa,sp2])  uqbar[sp3,3,cc3].uq[sp4,3,cc4] Ga[mu,sp3,spb]  ProjP[spb,sp4]]+
  C1quLam* Module[{ii,jj,kk,kk1,jj1,mu,aa,cc,sp1,sp2,sp3,sp4,cc1,cc2,cc3},  (uqbar[sp1,3,cc].uq[sp2,3,cc] Ga[mu,sp1,spa] ProjM[spa,sp2])  uqbar[sp3,3,cc3].uq[sp4,3,cc3] Ga[mu,sp3,spb]  ProjP[spb,sp4] ]+
  CqqLam* Module[{ii,jj,kk,kk1,jj1,mu,aa,cc,sp1,sp2,sp3,sp4,cc1,cc2,cc3},  (uqbar[sp1,3,cc].uq[sp2,3,cc] Ga[mu,sp1,spa] ProjM[spa,sp2]) uqbar[sp3,3,cc3].uq[sp4,3,cc3] Ga[mu,sp3,spb]  ProjM[spb,sp4] ]+
  CuuLam* Module[{ii,jj,kk,kk1,jj1,mu,aa,cc,sp1,sp2,sp3,sp4,cc1,cc2,cc3},   (uqbar[sp1,3,cc].uq[sp2,3,cc] Ga[mu,sp1,spa] ProjP[spa,sp2]) uqbar[sp3,3,cc3].uq[sp4,3,cc3] Ga[mu,sp3,spb]  ProjP[spb,sp4] ])/1000^2 ]];


 L4topScalar := Expand[ExpandIndices[(C1sLam* Module[{mm,mm2,sp,sp1,sp2,sp3,sp4},  uqbar[sp,3,mm].uq[sp,3,mm]* uqbar[sp3,3,mm2].uq[sp3,3,mm2]] +
 C8sLam*  Module[{aa,mm,mm2,nn,nn2,sp,sp1,sp2,sp3,sp4,ff,gg},  T[aa,mm,nn] T[aa,mm2,nn2]( ProjM[sp,sp2] + ProjP[sp,sp2]) uqbar[sp,3,mm].uq[sp2,3,nn]*( ProjM[sp3,sp4] + ProjP[sp3,sp4]) uqbar[sp3,3,mm2].uq[sp4,3,nn2]] +
 C1psLam* Module[{mm,mm2,sp,sp1,sp2,sp3,sp4},  ( -ProjM[sp,sp2] + ProjP[sp,sp2]) uqbar[sp,3,mm].uq[sp2,3,mm]*( -ProjM[sp3,sp4] + ProjP[sp3,sp4]) uqbar[sp3,3,mm2].uq[sp4,3,mm2]] +
 C8psLam*  Module[{aa,mm,mm2,nn,nn2,sp,sp1,sp2,sp3,sp4,ff,gg},  T[aa,mm,nn] T[aa,mm2,nn2]( -ProjM[sp,sp2] + ProjP[sp,sp2]) uqbar[sp,3,mm].uq[sp2,3,nn]*( -ProjM[sp3,sp4] + ProjP[sp3,sp4]) uqbar[sp3,3,mm2].uq[sp4,3,nn2]])/1000^2]];


LagNP := L4topVector + L4topScalar
