(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[    426242,       9091]
NotebookOptionsPosition[    375877,       8425]
NotebookOutlinePosition[    376330,       8443]
CellTagsIndexPosition[    376287,       8440]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellLabel->
  "In[543]:=",ExpressionUUID->"fdccdbba-01c0-464f-bb10-b61e7821bc9f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
   RowBox[{"here", "=", 
    RowBox[{"NotebookDirectory", "[", "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.75947250467022*^9, 3.7594725051843443`*^9}, {
   3.780202276666616*^9, 3.7802022771124487`*^9}, {3.780202340785331*^9, 
   3.7802023410048313`*^9}, {3.7802076291151342`*^9, 3.780207629609181*^9}, {
   3.782199108543097*^9, 3.782199109541502*^9}, {3.782645524335641*^9, 
   3.7826455324305353`*^9}, {3.793548972352523*^9, 3.793548972748909*^9}, {
   3.803976820198793*^9, 3.803976820694001*^9}, {3.80909812486642*^9, 
   3.809098125281336*^9}, {3.821441740238968*^9, 3.821441741844803*^9}, {
   3.8233178980035954`*^9, 3.823317898857934*^9}, 
   3.8278354885599003`*^9},ExpressionUUID->"da06996d-8dd9-43cf-ab0a-\
fc63da679325"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{3.823317899186027*^9, 3.82331835873413*^9, 
  3.823318431231894*^9, 3.823318576712429*^9, 3.823318623012488*^9, 
  3.823318691718403*^9, 3.82331874398936*^9, 3.823318795798674*^9, 
  3.8233207469600286`*^9, 3.823321163237851*^9, 3.8235789633066387`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"f0055f3c-041e-4825-8498-2737d1944f4d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.4.58\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"08 February 2017\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.4.58", " (" "08 February 2017", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.823317899186027*^9, 3.82331835873413*^9, 
  3.823318431231894*^9, 3.823318576712429*^9, 3.823318623012488*^9, 
  3.823318691718403*^9, 3.82331874398936*^9, 3.823318795798674*^9, 
  3.8233207469600286`*^9, 3.823321163237851*^9, 3.8235789633165894`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"ac6f7fea-8ea2-4ea5-ae9b-bf6b2b587650"],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{3.823317899186027*^9, 3.82331835873413*^9, 
  3.823318431231894*^9, 3.823318576712429*^9, 3.823318623012488*^9, 
  3.823318691718403*^9, 3.82331874398936*^9, 3.823318795798674*^9, 
  3.8233207469600286`*^9, 3.823321163237851*^9, 3.8235789633211*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"6ccaee93-bfde-4434-b058-69b44b14d86a"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.823317899186027*^9, 3.82331835873413*^9, 
  3.823318431231894*^9, 3.823318576712429*^9, 3.823318623012488*^9, 
  3.823318691718403*^9, 3.82331874398936*^9, 3.823318795798674*^9, 
  3.8233207469600286`*^9, 3.823321163237851*^9, 3.8235789633241043`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"a3b907c5-3e6d-4d6b-a4fc-eba5daebf7ad"],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{3.823317899186027*^9, 3.82331835873413*^9, 
  3.823318431231894*^9, 3.823318576712429*^9, 3.823318623012488*^9, 
  3.823318691718403*^9, 3.82331874398936*^9, 3.823318795798674*^9, 
  3.8233207469600286`*^9, 3.823321163237851*^9, 3.823578963326935*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"7f0cefcb-a6fe-46a9-96e5-a0e46d7126f6"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921;\"\>"], "Print",
 CellChangeTimes->{3.823317899186027*^9, 3.82331835873413*^9, 
  3.823318431231894*^9, 3.823318576712429*^9, 3.823318623012488*^9, 
  3.823318691718403*^9, 3.82331874398936*^9, 3.823318795798674*^9, 
  3.8233207469600286`*^9, 3.823321163237851*^9, 3.823578963330018*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"5ab7995d-5400-4b6a-8bb8-ae2afbe76837"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{3.823317899186027*^9, 3.82331835873413*^9, 
  3.823318431231894*^9, 3.823318576712429*^9, 3.823318623012488*^9, 
  3.823318691718403*^9, 3.82331874398936*^9, 3.823318795798674*^9, 
  3.8233207469600286`*^9, 3.823321163237851*^9, 3.8235789633330173`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"f326405f-85f9-4ebc-9d5d-aa6de9562eff"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.823317899186027*^9, 3.82331835873413*^9, 
  3.823318431231894*^9, 3.823318576712429*^9, 3.823318623012488*^9, 
  3.823318691718403*^9, 3.82331874398936*^9, 3.823318795798674*^9, 
  3.8233207469600286`*^9, 3.823321163237851*^9, 3.823578963335946*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"f755f5d8-5ddd-425d-9e53-d1bde84e61cd"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{3.823317899186027*^9, 3.82331835873413*^9, 
  3.823318431231894*^9, 3.823318576712429*^9, 3.823318623012488*^9, 
  3.823318691718403*^9, 3.82331874398936*^9, 3.823318795798674*^9, 
  3.8233207469600286`*^9, 3.823321163237851*^9, 3.8235789633388987`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"4a147ace-87fc-471f-9a46-041aa04f5e4e"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.823317899186027*^9, 3.82331835873413*^9, 
  3.823318431231894*^9, 3.823318576712429*^9, 3.823318623012488*^9, 
  3.823318691718403*^9, 3.82331874398936*^9, 3.823318795798674*^9, 
  3.8233207469600286`*^9, 3.823321163237851*^9, 3.8235789633419323`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"59f64a11-e010-4a52-9c4d-417844273108"],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{3.823317899186027*^9, 3.82331835873413*^9, 
  3.823318431231894*^9, 3.823318576712429*^9, 3.823318623012488*^9, 
  3.823318691718403*^9, 3.82331874398936*^9, 3.823318795798674*^9, 
  3.8233207469600286`*^9, 3.823321163237851*^9, 3.8235789633441343`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"254490e2-2258-4a76-a9f0-3cf65f285cc0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Effective model", "Section",
 CellChangeTimes->{{3.759472462715425*^9, 3.7594724703715563`*^9}, {
  3.7594740772772512`*^9, 3.759474077869609*^9}, {3.780202464184741*^9, 
  3.780202487247922*^9}, {3.7802055066965837`*^9, 
  3.780205508167942*^9}},ExpressionUUID->"b3481f82-8d60-422a-96f3-\
b2a3114db2fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", "here", "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"LoadModel", "[", " ", 
     RowBox[{
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/SM.fr\>\""}], ",", 
      "\"\<4topEFT.fr\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LoadRestriction", "[", 
     RowBox[{"\"\<DiagonalNP.rst\>\"", ",", 
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/DiagonalCKM.rst\>\""}], 
      ",", 
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/Massless.rst\>\""}], 
      ",", "\"\<NozRzL.rst\>\""}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.759473357442108*^9, 3.759473357661347*^9}, {
  3.7594740850493803`*^9, 3.759474085611158*^9}, {3.7802024273856564`*^9, 
  3.7802024409768972`*^9}, {3.780202579193604*^9, 3.7802025860480757`*^9}, {
  3.780205591345396*^9, 3.7802055924003687`*^9}, {3.7802075714717693`*^9, 
  3.780207584025361*^9}, {3.780207772660142*^9, 3.780207773841313*^9}, {
  3.780208334460888*^9, 3.780208334977392*^9}, {3.780208391012025*^9, 
  3.7802083914014606`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"a151022a-73a9-4c71-aefa-0f58c7755135"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{{3.7802083880062037`*^9, 3.7802084075045433`*^9}, 
   3.780208860701126*^9, 3.780640344666049*^9, 3.7806551137125196`*^9, 
   3.7807215773244534`*^9, 3.78090334377833*^9, 3.780904236744771*^9, {
   3.78090457388873*^9, 3.780904596197987*^9}, 3.782198695731491*^9, 
   3.782199115033786*^9, 3.782204337198497*^9, 3.782207507998438*^9, 
   3.782641451804982*^9, 3.782642775526918*^9, 3.782642948583342*^9, 
   3.78264451841315*^9, 3.7826445875859957`*^9, {3.782644794476655*^9, 
   3.782644815918336*^9}, 3.78264507614818*^9, 3.782645113736267*^9, 
   3.78264553698146*^9, 3.794239151361677*^9, 3.8233182982693157`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"95778f43-7167-45e5-9140-e7dd5e9ee053"],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{{3.7802083880062037`*^9, 3.7802084075045433`*^9}, 
   3.780208860701126*^9, 3.780640344666049*^9, 3.7806551137125196`*^9, 
   3.7807215773244534`*^9, 3.78090334377833*^9, 3.780904236744771*^9, {
   3.78090457388873*^9, 3.780904596197987*^9}, 3.782198695731491*^9, 
   3.782199115033786*^9, 3.782204337198497*^9, 3.782207507998438*^9, 
   3.782641451804982*^9, 3.782642775526918*^9, 3.782642948583342*^9, 
   3.78264451841315*^9, 3.7826445875859957`*^9, {3.782644794476655*^9, 
   3.782644815918336*^9}, 3.78264507614818*^9, 3.782645113736267*^9, 
   3.78264553698146*^9, 3.794239151361677*^9, 3.823318298274665*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"01c4a01b-c595-4038-94ce-b141928d71b3"],

Cell[BoxData["\<\" L. Darme\"\>"], "Print",
 CellChangeTimes->{{3.7802083880062037`*^9, 3.7802084075045433`*^9}, 
   3.780208860701126*^9, 3.780640344666049*^9, 3.7806551137125196`*^9, 
   3.7807215773244534`*^9, 3.78090334377833*^9, 3.780904236744771*^9, {
   3.78090457388873*^9, 3.780904596197987*^9}, 3.782198695731491*^9, 
   3.782199115033786*^9, 3.782204337198497*^9, 3.782207507998438*^9, 
   3.782641451804982*^9, 3.782642775526918*^9, 3.782642948583342*^9, 
   3.78264451841315*^9, 3.7826445875859957`*^9, {3.782644794476655*^9, 
   3.782644815918336*^9}, 3.78264507614818*^9, 3.782645113736267*^9, 
   3.78264553698146*^9, 3.794239151361677*^9, 3.823318298276648*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"0752f219-72bb-4993-8c87-006bcdce98e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
  SequenceForm["Model Version: ", "1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7802083880062037`*^9, 3.7802084075045433`*^9}, 
   3.780208860701126*^9, 3.780640344666049*^9, 3.7806551137125196`*^9, 
   3.7807215773244534`*^9, 3.78090334377833*^9, 3.780904236744771*^9, {
   3.78090457388873*^9, 3.780904596197987*^9}, 3.782198695731491*^9, 
   3.782199115033786*^9, 3.782204337198497*^9, 3.782207507998438*^9, 
   3.782641451804982*^9, 3.782642775526918*^9, 3.782642948583342*^9, 
   3.78264451841315*^9, 3.7826445875859957`*^9, {3.782644794476655*^9, 
   3.782644815918336*^9}, 3.78264507614818*^9, 3.782645113736267*^9, 
   3.78264553698146*^9, 3.794239151361677*^9, 3.823318298278255*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"0912417c-4b5d-43b1-b755-a8df303586c7"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{{3.7802083880062037`*^9, 3.7802084075045433`*^9}, 
   3.780208860701126*^9, 3.780640344666049*^9, 3.7806551137125196`*^9, 
   3.7807215773244534`*^9, 3.78090334377833*^9, 3.780904236744771*^9, {
   3.78090457388873*^9, 3.780904596197987*^9}, 3.782198695731491*^9, 
   3.782199115033786*^9, 3.782204337198497*^9, 3.782207507998438*^9, 
   3.782641451804982*^9, 3.782642775526918*^9, 3.782642948583342*^9, 
   3.78264451841315*^9, 3.7826445875859957`*^9, {3.782644794476655*^9, 
   3.782644815918336*^9}, 3.78264507614818*^9, 3.782645113736267*^9, 
   3.78264553698146*^9, 3.794239151361677*^9, 3.823318298279517*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"4dd1bbb4-d053-48e9-983c-008093dcd906"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.7802083880062037`*^9, 3.7802084075045433`*^9}, 
   3.780208860701126*^9, 3.780640344666049*^9, 3.7806551137125196`*^9, 
   3.7807215773244534`*^9, 3.78090334377833*^9, 3.780904236744771*^9, {
   3.78090457388873*^9, 3.780904596197987*^9}, 3.782198695731491*^9, 
   3.782199115033786*^9, 3.782204337198497*^9, 3.782207507998438*^9, 
   3.782641451804982*^9, 3.782642775526918*^9, 3.782642948583342*^9, 
   3.78264451841315*^9, 3.7826445875859957`*^9, {3.782644794476655*^9, 
   3.782644815918336*^9}, 3.78264507614818*^9, 3.782645113736267*^9, 
   3.78264553698146*^9, 3.794239151361677*^9, 3.8233182982807207`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"33b664d7-1b54-4d25-8491-d28c523061ae"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{{3.7802083880062037`*^9, 3.7802084075045433`*^9}, 
   3.780208860701126*^9, 3.780640344666049*^9, 3.7806551137125196`*^9, 
   3.7807215773244534`*^9, 3.78090334377833*^9, 3.780904236744771*^9, {
   3.78090457388873*^9, 3.780904596197987*^9}, 3.782198695731491*^9, 
   3.782199115033786*^9, 3.782204337198497*^9, 3.782207507998438*^9, 
   3.782641451804982*^9, 3.782642775526918*^9, 3.782642948583342*^9, 
   3.78264451841315*^9, 3.7826445875859957`*^9, {3.782644794476655*^9, 
   3.782644815918336*^9}, 3.78264507614818*^9, 3.782645113736267*^9, 
   3.78264553698146*^9, 3.794239151361677*^9, 3.8233182982818737`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"54564307-24e5-41dc-a375-0182d87750fa"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{{3.7802083880062037`*^9, 3.7802084075045433`*^9}, 
   3.780208860701126*^9, 3.780640344666049*^9, 3.7806551137125196`*^9, 
   3.7807215773244534`*^9, 3.78090334377833*^9, 3.780904236744771*^9, {
   3.78090457388873*^9, 3.780904596197987*^9}, 3.782198695731491*^9, 
   3.782199115033786*^9, 3.782204337198497*^9, 3.782207507998438*^9, 
   3.782641451804982*^9, 3.782642775526918*^9, 3.782642948583342*^9, 
   3.78264451841315*^9, 3.7826445875859957`*^9, {3.782644794476655*^9, 
   3.782644815918336*^9}, 3.78264507614818*^9, 3.782645113736267*^9, 
   3.78264553698146*^9, 3.794239151361677*^9, 3.823318298377357*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"0ce0f80b-f338-4ee4-8fb1-dfd032c7311e"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{{3.7802083880062037`*^9, 3.7802084075045433`*^9}, 
   3.780208860701126*^9, 3.780640344666049*^9, 3.7806551137125196`*^9, 
   3.7807215773244534`*^9, 3.78090334377833*^9, 3.780904236744771*^9, {
   3.78090457388873*^9, 3.780904596197987*^9}, 3.782198695731491*^9, 
   3.782199115033786*^9, 3.782204337198497*^9, 3.782207507998438*^9, 
   3.782641451804982*^9, 3.782642775526918*^9, 3.782642948583342*^9, 
   3.78264451841315*^9, 3.7826445875859957`*^9, {3.782644794476655*^9, 
   3.782644815918336*^9}, 3.78264507614818*^9, 3.782645113736267*^9, 
   3.78264553698146*^9, 3.794239151361677*^9, 3.823318298381555*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"ddfdffd8-df1f-4fc9-9f98-cca03cd8d3f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"4topEFT\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "4topEFT", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7802083880062037`*^9, 3.7802084075045433`*^9}, 
   3.780208860701126*^9, 3.780640344666049*^9, 3.7806551137125196`*^9, 
   3.7807215773244534`*^9, 3.78090334377833*^9, 3.780904236744771*^9, {
   3.78090457388873*^9, 3.780904596197987*^9}, 3.782198695731491*^9, 
   3.782199115033786*^9, 3.782204337198497*^9, 3.782207507998438*^9, 
   3.782641451804982*^9, 3.782642775526918*^9, 3.782642948583342*^9, 
   3.78264451841315*^9, 3.7826445875859957`*^9, {3.782644794476655*^9, 
   3.782644815918336*^9}, 3.78264507614818*^9, 3.782645113736267*^9, 
   3.78264553698146*^9, 3.794239151361677*^9, 3.8233182984419003`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"95846e63-1a81-4ed5-8268-490959a8b65a"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Get", "noopen", 
   "\"Cannot open \
\\!\\(\\*RowBox[{\\\"\\\\\\\"DiagonalNP.rst\\\\\\\"\\\"}]\\).\"", 2, 9, 3, 
   32130030607345978949, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823318298461687*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"c6cd31cb-9d7b-4b45-868e-9a40799a2971"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"DiagonalNP.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "0"}],
  SequenceForm["Loading restrictions from ", "DiagonalNP.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7802083880062037`*^9, 3.7802084075045433`*^9}, 
   3.780208860701126*^9, 3.780640344666049*^9, 3.7806551137125196`*^9, 
   3.7807215773244534`*^9, 3.78090334377833*^9, 3.780904236744771*^9, {
   3.78090457388873*^9, 3.780904596197987*^9}, 3.782198695731491*^9, 
   3.782199115033786*^9, 3.782204337198497*^9, 3.782207507998438*^9, 
   3.782641451804982*^9, 3.782642775526918*^9, 3.782642948583342*^9, 
   3.78264451841315*^9, 3.7826445875859957`*^9, {3.782644794476655*^9, 
   3.782644815918336*^9}, 3.78264507614818*^9, 3.782645113736267*^9, 
   3.78264553698146*^9, 3.794239151361677*^9, 3.823318299232971*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"d6ef5676-e193-492b-9d0c-aa5b755d815f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/luc/Computing/feynrules-current/Models/SM/DiagonalCKM.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm[
  "Loading restrictions from ", 
   "/Users/luc/Computing/feynrules-current/Models/SM/DiagonalCKM.rst", " : ", 
   
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7802083880062037`*^9, 3.7802084075045433`*^9}, 
   3.780208860701126*^9, 3.780640344666049*^9, 3.7806551137125196`*^9, 
   3.7807215773244534`*^9, 3.78090334377833*^9, 3.780904236744771*^9, {
   3.78090457388873*^9, 3.780904596197987*^9}, 3.782198695731491*^9, 
   3.782199115033786*^9, 3.782204337198497*^9, 3.782207507998438*^9, 
   3.782641451804982*^9, 3.782642775526918*^9, 3.782642948583342*^9, 
   3.78264451841315*^9, 3.7826445875859957`*^9, {3.782644794476655*^9, 
   3.782644815918336*^9}, 3.78264507614818*^9, 3.782645113736267*^9, 
   3.78264553698146*^9, 3.794239151361677*^9, 3.823318299434938*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f99c06cd-5ebb-4c9c-9457-e0cb39f2274c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/luc/Computing/feynrules-current/Models/SM/Massless.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18"}],
  SequenceForm[
  "Loading restrictions from ", 
   "/Users/luc/Computing/feynrules-current/Models/SM/Massless.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7802083880062037`*^9, 3.7802084075045433`*^9}, 
   3.780208860701126*^9, 3.780640344666049*^9, 3.7806551137125196`*^9, 
   3.7807215773244534`*^9, 3.78090334377833*^9, 3.780904236744771*^9, {
   3.78090457388873*^9, 3.780904596197987*^9}, 3.782198695731491*^9, 
   3.782199115033786*^9, 3.782204337198497*^9, 3.782207507998438*^9, 
   3.782641451804982*^9, 3.782642775526918*^9, 3.782642948583342*^9, 
   3.78264451841315*^9, 3.7826445875859957`*^9, {3.782644794476655*^9, 
   3.782644815918336*^9}, 3.78264507614818*^9, 3.782645113736267*^9, 
   3.78264553698146*^9, 3.794239151361677*^9, 3.823318299649852*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"2e7659b5-e10e-4951-b1c4-9d633d0b5ee0"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Get", "noopen", 
   "\"Cannot open \
\\!\\(\\*RowBox[{\\\"\\\\\\\"NozRzL.rst\\\\\\\"\\\"}]\\).\"", 2, 9, 4, 
   32130030607345978949, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823318299794739*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"0f0c88f7-1899-436d-afc2-0fa249eeba3c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"NozRzL.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{209., {2., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18"}],
  SequenceForm["Loading restrictions from ", "NozRzL.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7802083880062037`*^9, 3.7802084075045433`*^9}, 
   3.780208860701126*^9, 3.780640344666049*^9, 3.7806551137125196`*^9, 
   3.7807215773244534`*^9, 3.78090334377833*^9, 3.780904236744771*^9, {
   3.78090457388873*^9, 3.780904596197987*^9}, 3.782198695731491*^9, 
   3.782199115033786*^9, 3.782204337198497*^9, 3.782207507998438*^9, 
   3.782641451804982*^9, 3.782642775526918*^9, 3.782642948583342*^9, 
   3.78264451841315*^9, 3.7826445875859957`*^9, {3.782644794476655*^9, 
   3.782644815918336*^9}, 3.78264507614818*^9, 3.782645113736267*^9, 
   3.78264553698146*^9, 3.794239151361677*^9, 3.823318299895474*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"64395f5b-2afb-4ea0-b9b8-7cc3eb24ff1f"],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{{3.7802083880062037`*^9, 3.7802084075045433`*^9}, 
   3.780208860701126*^9, 3.780640344666049*^9, 3.7806551137125196`*^9, 
   3.7807215773244534`*^9, 3.78090334377833*^9, 3.780904236744771*^9, {
   3.78090457388873*^9, 3.780904596197987*^9}, 3.782198695731491*^9, 
   3.782199115033786*^9, 3.782204337198497*^9, 3.782207507998438*^9, 
   3.782641451804982*^9, 3.782642775526918*^9, 3.782642948583342*^9, 
   3.78264451841315*^9, 3.7826445875859957`*^9, {3.782644794476655*^9, 
   3.782644815918336*^9}, 3.78264507614818*^9, 3.782645113736267*^9, 
   3.78264553698146*^9, 3.794239151361677*^9, 3.823318300034526*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"9ff08b4b-8cbe-49e5-afba-15e4ac071b2b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  
  RowBox[{"(*", 
   RowBox[{
   "Checking", " ", "the", " ", "hermiticity", " ", "of", " ", "the", " ", 
    "model"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"CheckMassSpectrum", "[", "LagNP", "]"}], "\[IndentingNewLine]", 
   RowBox[{"CheckHermiticity", "[", "LagNP", "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Feynman", " ", "rules"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"vertices", "=", 
    RowBox[{"FeynmanRules", "[", "LagNP", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Getting", " ", "decays"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"decays", "=", 
     RowBox[{"ComputeWidths", "[", "vertices", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Getting", " ", "UFO"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"WriteUFO", "[", 
    RowBox[{
     RowBox[{"LSM", "+", "LagNP"}], ",", 
     RowBox[{"Output", "\[Rule]", "\"\<4topEFT_UFO\>\""}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7594723247858057`*^9, 3.7594724349408712`*^9}, 
   3.759472503253831*^9, {3.75947256827782*^9, 3.759472569743855*^9}, {
   3.759472916998436*^9, 3.7594729172534723`*^9}, {3.7594732513207397`*^9, 
   3.759473276459257*^9}, {3.759473397881085*^9, 3.759473420215959*^9}, {
   3.75947351737363*^9, 3.759473518066074*^9}, {3.759474092352673*^9, 
   3.7594740929439583`*^9}, 3.780202595610166*^9, {3.780205600089341*^9, 
   3.780205603496346*^9}, 3.780205973735909*^9, {3.7802075966442947`*^9, 
   3.780207600785034*^9}, {3.7802077962435503`*^9, 3.780207797225259*^9}, {
   3.780207862058444*^9, 3.78020786295437*^9}, {3.780208414163644*^9, 
   3.780208424745947*^9}, 3.7802084595240097`*^9, {3.780655121134139*^9, 
   3.780655125661723*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"03056f62-69bb-4c71-aee4-bbee43698579"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318309002758*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"fbb8926c-b7bb-4fc9-b48c-75bef0b55969"],

Cell[BoxData["\<\"No Mass terms found.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318309004772*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"34b5ea81-1d48-4051-8e98-ac97560398af"],

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.8233183091730547`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"523f8146-21c0-4137-946a-4ddbddce8a40"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.82331830917453*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"aeeb5020-77c8-4f2f-81a5-47b829f22d5b"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318309626604*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"b3bf5f67-ab7c-4320-befd-1fd1f2179d04"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318309628606*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"0627a51a-82ed-421e-9566-988135b78710"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318309629861*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"1ee17a3b-2080-45e6-9e59-70313e158549"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318309631199*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"ffc68ecd-9948-4b2b-9216-2018aa78063c"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318309632593*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"eb622903-ca0e-43fe-a842-9dda1637d536"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.759472487149548*^9, {3.759472548279285*^9, 3.759472575800432*^9}, 
   3.75947307066348*^9, 3.759473286055393*^9, 3.7594734306190653`*^9, 
   3.759474184074905*^9, 3.759474309300272*^9, 3.759474496372921*^9, 
   3.7802043442203283`*^9, 3.780205978423317*^9, 3.7802071123111773`*^9, 
   3.780207447637168*^9, 3.780207601384635*^9, 3.780207655659214*^9, 
   3.7802078675962276`*^9, 3.780208428678698*^9, 3.7802084632491198`*^9, 
   3.780208869506777*^9, 3.780640358427123*^9, 3.780655129754079*^9, 
   3.7807215859525347`*^9, 3.78090335074323*^9, 3.780904245944458*^9, 
   3.7809046033736773`*^9, 3.782198703631143*^9, 3.7821991218557777`*^9, 
   3.782204343889759*^9, 3.782207512597904*^9, 3.782641456712771*^9, 
   3.7826427792394753`*^9, 3.7826429541095667`*^9, 3.782644524173164*^9, 
   3.782644607095043*^9, 3.782644819995878*^9, 3.782645080876055*^9, 
   3.782645118002426*^9, 3.782645542537897*^9, 3.7942391584481583`*^9, 
   3.823318309633752*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"69b546e8-797c-4853-9f69-3d9cb3d0b809"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318309804611*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"93979763-f709-4c8d-a3d5-000bf40c282b"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318309806438*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"3f2cdcdb-23a8-4a71-a107-fd4dee71a386"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.8233183099736853`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"a6cfe812-a410-4164-a0ba-828ee81ccd3c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.82331830997761*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"6d2b45b5-a06a-477d-9a57-ac8c3d104165"],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318310500568*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"c7cfa345-0f45-4172-a9de-13798cd87cb8"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        OverscriptBox["t", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        OverscriptBox["t", "\<\"-\"\>"], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "4"}], "}"}]}], "}"}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        TemplateBox[{"C", "ps", "1"},
         "Subsuperscript"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       TemplateBox[{
         SubscriptBox["\[Gamma]", 
          RowBox[{
            SubscriptBox["\"s\"", "1"], ",", 
            SubscriptBox["\"s\"", "4"]}]], "5"},
        "Superscript"], " ", 
       TemplateBox[{
         SubscriptBox["\[Gamma]", 
          RowBox[{
            SubscriptBox["\"s\"", "3"], ",", 
            SubscriptBox["\"s\"", "2"]}]], "5"},
        "Superscript"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "2"], ",", 
         SubscriptBox["\<\"m\"\>", "3"]}]]}], "500000"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        TemplateBox[{"C", "ps", "1"},
         "Subsuperscript"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       TemplateBox[{
         SubscriptBox["\[Gamma]", 
          RowBox[{
            SubscriptBox["\"s\"", "1"], ",", 
            SubscriptBox["\"s\"", "2"]}]], "5"},
        "Superscript"], " ", 
       TemplateBox[{
         SubscriptBox["\[Gamma]", 
          RowBox[{
            SubscriptBox["\"s\"", "3"], ",", 
            SubscriptBox["\"s\"", "4"]}]], "5"},
        "Superscript"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "3"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}]]}], "500000"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        TemplateBox[{"C", "s", "1"},
         "Subsuperscript"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "2"], ",", 
         SubscriptBox["\<\"m\"\>", "3"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "4"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "3"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "500000"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        TemplateBox[{"C", "s", "1"},
         "Subsuperscript"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "3"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "3"], ",", 
         SubscriptBox["\<\"s\"\>", "4"]}]]}], "500000"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        TemplateBox[{"C", "ps", "8"},
         "Subsuperscript"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       TemplateBox[{
         SubscriptBox["\[Gamma]", 
          RowBox[{
            SubscriptBox["\"s\"", "1"], ",", 
            SubscriptBox["\"s\"", "4"]}]], "5"},
        "Superscript"], " ", 
       TemplateBox[{
         SubscriptBox["\[Gamma]", 
          RowBox[{
            SubscriptBox["\"s\"", "3"], ",", 
            SubscriptBox["\"s\"", "2"]}]], "5"},
        "Superscript"], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}], "Gluon$1"], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "3"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}], "Gluon$1"]}], "500000"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        TemplateBox[{"C", "s", "8"},
         "Subsuperscript"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "4"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "3"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}], "Gluon$1"], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "3"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}], "Gluon$1"]}], "500000"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        TemplateBox[{"C", "ps", "8"},
         "Subsuperscript"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       TemplateBox[{
         SubscriptBox["\[Gamma]", 
          RowBox[{
            SubscriptBox["\"s\"", "1"], ",", 
            SubscriptBox["\"s\"", "2"]}]], "5"},
        "Superscript"], " ", 
       TemplateBox[{
         SubscriptBox["\[Gamma]", 
          RowBox[{
            SubscriptBox["\"s\"", "3"], ",", 
            SubscriptBox["\"s\"", "4"]}]], "5"},
        "Superscript"], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}], "Gluon$1"], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "3"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}], "Gluon$1"]}], "500000"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        TemplateBox[{"C", "s", "8"},
         "Subsuperscript"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "3"], ",", 
         SubscriptBox["\<\"s\"\>", "4"]}]], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}], "Gluon$1"], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "3"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}], "Gluon$1"]}], "500000"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        SubscriptBox["C", "qq"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "2"], ",", 
         SubscriptBox["\<\"m\"\>", "3"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "4"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "3"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "500000"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        SubscriptBox["C", "qq"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "3"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "3"], ",", 
         SubscriptBox["\<\"s\"\>", "4"]}]]}], "500000"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        TemplateBox[{"C", "qu", "1"},
         "Subsuperscript"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "3"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "3"], ",", 
         SubscriptBox["\<\"s\"\>", "4"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "1000000"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        TemplateBox[{"C", "qu", "8"},
         "Subsuperscript"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}], "Gluon$1"], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "3"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}], "Gluon$1"], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "3"], ",", 
         SubscriptBox["\<\"s\"\>", "4"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "1000000"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        TemplateBox[{"C", "qu", "1"},
         "Subsuperscript"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "2"], ",", 
         SubscriptBox["\<\"m\"\>", "3"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "3"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "4"]}]]}], "1000000"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        TemplateBox[{"C", "qu", "8"},
         "Subsuperscript"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}], "Gluon$1"], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "3"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}], "Gluon$1"], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "3"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "4"]}]]}], "1000000"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        TemplateBox[{"C", "qu", "1"},
         "Subsuperscript"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "2"], ",", 
         SubscriptBox["\<\"m\"\>", "3"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "4"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "3"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "1000000"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        TemplateBox[{"C", "qu", "8"},
         "Subsuperscript"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}], "Gluon$1"], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "3"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}], "Gluon$1"], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "4"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "3"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "1000000"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        SubscriptBox["C", "uu"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "2"], ",", 
         SubscriptBox["\<\"m\"\>", "3"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "4"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "3"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "500000"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        TemplateBox[{"C", "qu", "1"},
         "Subsuperscript"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "3"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "3"], ",", 
         SubscriptBox["\<\"s\"\>", "4"]}]]}], "1000000"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        TemplateBox[{"C", "qu", "8"},
         "Subsuperscript"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}], "Gluon$1"], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "3"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}], "Gluon$1"], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "3"], ",", 
         SubscriptBox["\<\"s\"\>", "4"]}]]}], "1000000"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       FractionBox[
        SubscriptBox["C", "uu"], 
        SuperscriptBox["\[CapitalLambda]", "2"]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "3"], ",", 
         SubscriptBox["\<\"m\"\>", "4"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", "mu$1"},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "3"], ",", 
         SubscriptBox["\<\"s\"\>", "4"]}]]}], "500000"]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.759472487149548*^9, {3.759472548279285*^9, 3.759472575800432*^9}, 
   3.75947307066348*^9, 3.759473286055393*^9, 3.7594734306190653`*^9, 
   3.759474184074905*^9, 3.759474309300272*^9, 3.759474496372921*^9, 
   3.7802043442203283`*^9, 3.780205978423317*^9, 3.7802071123111773`*^9, 
   3.780207447637168*^9, 3.780207601384635*^9, 3.780207655659214*^9, 
   3.7802078675962276`*^9, 3.780208428678698*^9, 3.7802084632491198`*^9, 
   3.780208869506777*^9, 3.780640358427123*^9, 3.780655129754079*^9, 
   3.7807215859525347`*^9, 3.78090335074323*^9, 3.780904245944458*^9, 
   3.7809046033736773`*^9, 3.782198703631143*^9, 3.7821991218557777`*^9, 
   3.782204343889759*^9, 3.782207512597904*^9, 3.782641456712771*^9, 
   3.7826427792394753`*^9, 3.7826429541095667`*^9, 3.782644524173164*^9, 
   3.782644607095043*^9, 3.782644819995878*^9, 3.782645080876055*^9, 
   3.782645118002426*^9, 3.782645542537897*^9, 3.7942391584481583`*^9, 
   3.823318310522846*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"cee74966-eddc-4886-b341-a830beb25fff"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318310575828*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"6709e98f-b023-4100-812a-03fbdbcb992c"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318310650758*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"57b3a797-0742-4593-96e3-8704eb937ef4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "0"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.8233183106537447`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"7fcdf6bc-b740-4e1c-9198-555afb6674cc"],

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318312619968*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"cd8b1073-26d3-430c-97bd-bfbffd6359f3"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318313097239*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"2246c720-879a-4ea9-a2f3-6ba5703bb56c"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318313098589*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"39955d8f-c7e7-4d4d-9700-e78881dbd766"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.82331831309977*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"ba2eaa1a-d79c-4c6a-96c5-c9b13bd4291a"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318320221833*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"370169cf-defd-498d-9f3c-6633d1da92d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "99", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "99", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  99, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 99, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318320262636*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"51fd19c8-77c4-4e69-90ca-153ad9b091e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"94", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[94, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318324594335*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"5905b044-a0cf-403f-8151-3e2482819230"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "94"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 2, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 94],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318326756587*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"fbfd73d5-0968-4bdd-9f20-dee58fd0c4a5"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.8233183332533407`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"dc6a1bc6-6003-4aa0-bac0-50dd9bfdf533"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318333275547*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"121561c0-5b80-44e1-adf9-b7eaeca71fc3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "40"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 40],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.8233183332768993`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"58a10044-15f6-4fcc-8f05-faa783703f08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "0.819726`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 0.819726, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318334098773*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"1caf2511-dec0-42f3-a2d9-1d29ed9905f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.009761`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 0.009761, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318334117392*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"a926d3f6-8cfd-4612-b804-177ef44a9be1"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318334119226*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"577f54a4-10e4-4b0f-ba72-31472ba4a06d"],

Cell[BoxData[
 StyleBox["\<\"Warning: Multi-Fermion operators are not yet fully \
supported!\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.8233183341492987`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"5b5b12ba-4425-40fb-9951-a9eefbae5243"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318334218933*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"c20995c8-071d-4699-bf20-cc0849b4ac0f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318334238798*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"e5fe8269-b8f2-4df4-878e-a9ecd9d30a70"],

Cell[BoxData["\<\"before\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823318335944923*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"b3f05a75-ea77-41e2-9a6b-8686e706ff06"],

Cell[BoxData["\<\"before\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823318335969709*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"85cce018-9fb0-46b4-8547-d0ac350f18a8"],

Cell[BoxData["\<\"true\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823318336014955*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"dadf5961-a6db-467e-b163-0cc795cbedc7"],

Cell[BoxData["\<\"true\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823318336152317*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"f2292f9e-2463-4a5c-9a60-666e9a3a52af"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{209., {3., 9.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "120", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 120, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318336285346*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"4f196665-b484-4d78-8b24-847440bccc97"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318336395763*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"0eea4daf-4fb9-4129-8161-8e5e6e1ceb73"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780204344120599*^9, 3.780205976970922*^9, 3.780207110844549*^9, 
   3.780207446465786*^9, 3.780207601353045*^9, 3.780207655632494*^9, 
   3.780207866522584*^9, 3.7802084264726667`*^9, 3.780208461009726*^9, 
   3.7802088675815*^9, 3.780640356542487*^9, 3.7806551280105343`*^9, 
   3.780721584270252*^9, 3.780903349037813*^9, 3.7809042443099613`*^9, 
   3.780904601313138*^9, 3.7821987018409986`*^9, 3.782199120195635*^9, 
   3.782204342728475*^9, 3.7822075120543947`*^9, 3.7826414562121983`*^9, 
   3.782642778710424*^9, 3.782642953076583*^9, 3.782644523163971*^9, 
   3.782644592538116*^9, 3.782644819223568*^9, 3.782645080060171*^9, 
   3.782645117195219*^9, 3.782645541740649*^9, 3.794239157802927*^9, 
   3.823318336505858*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"2b220bdb-5764-4793-bf68-8514128ebe99"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Scalar Octet", "Section",
 CellChangeTimes->{{3.759472462715425*^9, 
  3.7594724703715563`*^9}},ExpressionUUID->"2336ad77-5f71-45d3-aa04-\
279489ef8eca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", "here", "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"LoadModel", "[", " ", 
     RowBox[{
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/SM.fr\>\""}], ",", 
      "\"\<ScalarOctet.fr\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LoadRestriction", "[", 
     RowBox[{"\"\<DiagonalNP.rst\>\"", ",", 
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/DiagonalCKM.rst\>\""}], 
      ",", 
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/Massless.rst\>\""}], 
      ",", "\"\<NozRzL.rst\>\""}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.759473357442108*^9, 3.759473357661347*^9}, {
  3.780202301155065*^9, 3.780202301592578*^9}, {3.7802023540818653`*^9, 
  3.780202359097866*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"6e6925aa-c8eb-43ad-abc2-dacc15d02aaf"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, {
   3.8233183450666437`*^9, 3.823318366023326*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"9a62a909-12f2-44a3-8773-93d18c5c2b1d"],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, {
   3.8233183450666437`*^9, 3.823318366029416*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"9ee8e020-a295-44ad-bc6f-d583c01555ce"],

Cell[BoxData["\<\"Luc Darme\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, {
   3.8233183450666437`*^9, 3.823318366031458*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"0442bb81-4467-4c21-ab2f-a336184b17fa"],

Cell[BoxData["\<\"Benjamin Fuks\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, {
   3.8233183450666437`*^9, 3.8233183660324802`*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"805612bf-1fab-4a52-b88a-e0d6808b0a0d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1\"\>"}],
  SequenceForm["Model Version: ", "1"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, {
   3.8233183450666437`*^9, 3.823318366033598*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"e6c034fd-bad3-41ac-b676-02e85b74c603"],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, {
   3.8233183450666437`*^9, 3.823318366034986*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"99b5201b-6085-4655-9e01-cad45555542d"],

Cell[BoxData["\<\"xxx\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, {
   3.8233183450666437`*^9, 3.82331836603605*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"c491350f-1df3-4b74-ab28-358cd86c5201"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, {
   3.8233183450666437`*^9, 3.823318366037389*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"214cbacc-e444-4b72-a7de-425d51690ec8"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, {
   3.8233183450666437`*^9, 3.823318366038486*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"d7e9ded2-258f-4b20-ba47-aa8275111db1"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, {
   3.8233183450666437`*^9, 3.823318366039661*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"ea277507-89e8-4bb9-a699-7eee48ce6e92"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, {
   3.8233183450666437`*^9, 3.823318366130644*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"88730290-de5d-4ed0-9381-e16d63b5ac3a"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, {
   3.8233183450666437`*^9, 3.823318366134583*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"d0cf44ca-4d37-45c8-abce-19a1ba878421"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", 
   "\[InvisibleSpace]", "\<\"ColoredScalarsAndPScalars\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "ColoredScalarsAndPScalars", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, {
   3.8233183450666437`*^9, 3.823318366190346*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"fbbcf15b-f544-490e-a55c-29942c64c954"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Get", "noopen", 
   "\"Cannot open \
\\!\\(\\*RowBox[{\\\"\\\\\\\"DiagonalNP.rst\\\\\\\"\\\"}]\\).\"", 2, 6, 1, 
   32130033628568373647, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{{3.823318343562522*^9, 3.823318366213451*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"2e49b92b-b29f-4f45-ab5a-8d3cc408e5c6"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"DiagonalNP.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "0"}],
  SequenceForm["Loading restrictions from ", "DiagonalNP.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, {
   3.8233183450666437`*^9, 3.823318366906255*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"d8866ed9-a360-4675-b24c-f27a059dbf18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/luc/Computing/feynrules-current/Models/SM/DiagonalCKM.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm[
  "Loading restrictions from ", 
   "/Users/luc/Computing/feynrules-current/Models/SM/DiagonalCKM.rst", " : ", 
   
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, {
   3.8233183450666437`*^9, 3.823318367115909*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"a7f775eb-8369-4c90-b394-f90b71bb3dbb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/luc/Computing/feynrules-current/Models/SM/Massless.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18"}],
  SequenceForm[
  "Loading restrictions from ", 
   "/Users/luc/Computing/feynrules-current/Models/SM/Massless.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, {
   3.8233183450666437`*^9, 3.82331836731704*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"11a70b88-498c-499b-bae9-94ddbb43af81"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Get", "noopen", 
   "\"Cannot open \
\\!\\(\\*RowBox[{\\\"\\\\\\\"NozRzL.rst\\\\\\\"\\\"}]\\).\"", 2, 6, 2, 
   32130033628568373647, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{{3.823318343562522*^9, 3.823318367447453*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"d76313b5-3a41-4f63-bed5-32fed241325e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"NozRzL.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18"}],
  SequenceForm["Loading restrictions from ", "NozRzL.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, {
   3.8233183450666437`*^9, 3.823318367543874*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"2963a4b9-5579-4ef4-ba60-6261b133f279"],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, {
   3.8233183450666437`*^9, 3.823318367669571*^9}},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"fa91b802-425e-4ead-b7b4-2618a11fc037"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Checking", " ", "the", " ", "hermiticity", " ", "of", " ", "the", " ", 
    "model"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"CheckMassSpectrum", "[", "LagNP", "]"}], "\[IndentingNewLine]", 
   RowBox[{"CheckHermiticity", "[", "LagNP", "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Feynman", " ", "rules"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"vertices", "=", 
    RowBox[{"FeynmanRules", "[", "LagNP", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Getting", " ", "decays"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"decays", "=", 
     RowBox[{"ComputeWidths", "[", "vertices", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Getting", " ", "UFO"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"WriteUFO", "[", 
    RowBox[{
     RowBox[{"LSM", "+", "LagNP"}], ",", 
     RowBox[{"Output", "\[Rule]", "\"\<ScalarOctet_UFO\>\""}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7594723247858057`*^9, 3.7594724349408712`*^9}, 
   3.759472503253831*^9, {3.75947256827782*^9, 3.759472569743855*^9}, {
   3.759472916998436*^9, 3.7594729172534723`*^9}, {3.7594732513207397`*^9, 
   3.759473276459257*^9}, {3.759473397881085*^9, 3.759473420215959*^9}, {
   3.75947351737363*^9, 3.759473518066074*^9}, 3.780202401768827*^9, {
   3.780646020664256*^9, 3.780646020908284*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"f035415b-5280-438a-b376-e7fcaafbf63b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318371140925*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"50267ecd-6913-4322-97e9-6c181ee62a96"],

Cell[BoxData["\<\"All mass terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318371144013*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"a2917d31-c659-454a-8b60-e33dc1af4bef"],

Cell[BoxData["\<\"Getting mass spectrum.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318371206937*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"493be979-5bcf-4e6b-908c-9fe6ed32d553"],

Cell[BoxData["\<\"Checking for less then 0.1% agreement with model file \
values.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318371208564*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"666fcd66-bf82-4c9a-851c-eaf4742466ad"]
}, Open  ]],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Particle\"\>", "\<\"Analytic value\"\>", "\<\"Numerical value\"\>", \
"\<\"Model-file value\"\>"},
    {"sig8", 
     SqrtBox[
      SuperscriptBox["m8", "2"]], "400.`", "400.`"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.759472487149548*^9, {3.759472548279285*^9, 3.759472575800432*^9}, 
   3.75947307066348*^9, 3.759473286055393*^9, 3.7594734306190653`*^9, 
   3.780202405050234*^9, 3.780645515932193*^9, 3.780645554707588*^9, 
   3.780646021907053*^9, 3.780646121004187*^9, 3.782633360340663*^9, 
   3.823318371227475*^9},
 CellLabel->
  "Out[7]//TableForm=",ExpressionUUID->"f275f380-9faa-4d3d-b1a5-a98603e7d45e"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318371259307*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"c6df1072-941a-4bdd-b231-d81e56aa235c"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318371260789*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"93dca42b-7f46-41cd-9e60-56b9c569d800"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318371415959*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"1ee14561-dec5-49b9-b234-a71a75e75b71"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318371417521*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"1c240cbd-1f6a-4245-bae0-1d4df34ab7d8"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.8233183714187*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"a2bb2c75-0e75-4a76-86a4-6056799cfbd1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318371419807*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f4db4e38-1ae7-4a7c-b70f-d43590e5fbf4"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.8233183714207153`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"ebe543cf-04e5-4720-9783-423ccff11c04"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.759472487149548*^9, {3.759472548279285*^9, 3.759472575800432*^9}, 
   3.75947307066348*^9, 3.759473286055393*^9, 3.7594734306190653`*^9, 
   3.780202405050234*^9, 3.780645515932193*^9, 3.780645554707588*^9, 
   3.780646021907053*^9, 3.780646121004187*^9, 3.782633360340663*^9, 
   3.8233183714218884`*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"98f2ab3f-e450-4b0c-a260-1c9b17046a89"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318371446041*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"c169dcec-be52-4e29-b52d-671062145d39"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.82331837144731*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"eba6af1e-9194-4afb-aa0d-a7a1b0dd3eb7"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.8233183715182457`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"84e71260-d554-4b8b-9c7d-b99619688bce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "3", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  3, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 3, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318371519781*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"b7968fce-dd9e-4ece-92b3-844fcf99d86e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[3, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318371590149*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"a6170b27-85a6-4cf7-a821-33e9142547cd"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"sig8", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"sig8", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]]}], "-", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"sig8", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"sig8", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["t", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"sig8", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", 
      RowBox[{"Subsuperscript", "[", 
       RowBox[{"y", ",", "\<\"8S\"\>"}], "]"}], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "3"]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.759472487149548*^9, {3.759472548279285*^9, 3.759472575800432*^9}, 
   3.75947307066348*^9, 3.759473286055393*^9, 3.7594734306190653`*^9, 
   3.780202405050234*^9, 3.780645515932193*^9, 3.780645554707588*^9, 
   3.780646021907053*^9, 3.780646121004187*^9, 3.782633360340663*^9, 
   3.823318371592461*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"6e6c1a4e-c279-4277-a9d1-91c7157d0e2e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318371647751*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"986c162f-5402-48de-afa0-1e6377ed236c"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318371677973*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"1d472b15-ef67-4c32-8dae-f52e4f6670ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{7., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318371680867*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"3e303b0f-2f80-4317-84a5-c4bbd71d160b"],

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318373421262*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"8d0beeec-2b91-4d4e-84d3-b4b09c9c8ca2"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.8233183738360662`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f92b69e5-ab87-4349-bf99-8fea2fdae10f"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318373837555*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"ece745cb-a380-431f-90db-96a589b22a06"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.82331837383864*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"51d7e541-75f4-4591-9cb9-71d229b9c350"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318381174364*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"3f480a38-b754-4f5e-8d05-b24223753f8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "101", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "101", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  101, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 101, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318381215991*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"d8bd1a9d-e4b2-4f54-8fbc-d1337745b88b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"96", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[96, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.8233183849135447`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"2937c92b-8610-4fca-b31e-d595a69097a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "96"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 2, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 96],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318387226913*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"76eb7127-e5c7-497c-8647-e2cb501bb1e3"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.8233183943823233`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"244fe208-f5ff-46d3-b3d8-4da7573b3464"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318394402299*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"502dda80-32a3-49ef-8567-0b6b85741db6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "41"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 41],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318394446835*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"c4876ec1-ec96-48b8-a927-4be1b34adc3f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "1.623353`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 1.623353, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318401599962*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"ef452471-3a09-41fa-8d27-e9e2f6643cda"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Decay", "Overwrite", "\"Warning: Previous results will be overwritten.\"", 
   2, 11, 3, 32130033628568373647, "Local", "FeynRules`Decay"},
  "MessageTemplate2"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.759472574381403*^9, 3.759473066224372*^9, 
  3.759473329756282*^9, 3.7594734356524353`*^9, 3.780202427044709*^9, 
  3.780645516104279*^9, 3.780645572802278*^9, 3.7806460222695017`*^9, 
  3.780646140058599*^9, 3.782633379694639*^9, 3.8233184016256733`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"64778cc8-b14c-4c61-8f80-6804cbce89fe"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.013905`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 0.013905, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318401632618*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"39f5c45f-6b82-4c34-a94d-97211a4bda10"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.8233184016341047`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"0f5efd8d-249d-41bb-8f51-880fab31fb5c"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318401709453*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"2e7fdd31-e342-412c-bf21-a83474bab44e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318401732637*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"3473018e-241a-4d6c-907c-c156387d3207"],

Cell[BoxData["\<\"before\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823318403468834*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"ff5dddcd-7396-4679-834b-1b26d6111967"],

Cell[BoxData["\<\"before\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823318403491379*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"44ce3ca8-fcef-48ab-89ee-8462b96d39f7"],

Cell[BoxData["\<\"true\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823318403526663*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"65cf8d85-2a68-4a78-b1eb-3ccedb0aacf8"],

Cell[BoxData["\<\"true\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823318403543511*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"ec919153-4ce9-41a5-aa26-c60f9ba963fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "122", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 122, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318403680352*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"05c0166b-487d-4d94-a079-f1e3fc64d8d3"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318403781838*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"6d2e18aa-5efa-447c-a152-969504353aa6"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.823318403915468*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"bd9a66bb-dc32-42ac-b42d-cd4fbb6774f1"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Pseudo-Scalar Octet", "Section",
 CellChangeTimes->{{3.759472462715425*^9, 3.7594724703715563`*^9}, {
  3.821442509885233*^9, 
  3.8214425107885437`*^9}},ExpressionUUID->"e31bbc3c-8fc8-463e-b845-\
29a34070e85b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", "here", "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"LoadModel", "[", " ", 
     RowBox[{
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/SM.fr\>\""}], ",", 
      "\"\<PseudoScalarOctet.fr\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LoadRestriction", "[", 
     RowBox[{"\"\<DiagonalNP.rst\>\"", ",", 
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/DiagonalCKM.rst\>\""}], 
      ",", 
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/Massless.rst\>\""}], 
      ",", "\"\<NozRzL.rst\>\""}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.759473357442108*^9, 3.759473357661347*^9}, {
  3.780202301155065*^9, 3.780202301592578*^9}, {3.7802023540818653`*^9, 
  3.780202359097866*^9}, {3.821442525397709*^9, 3.82144252612459*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"26825268-e6e9-43f4-9716-9772fb26478f"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, 
   3.8214425273837843`*^9, 3.823318440115117*^9, 3.82332075509305*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"781b7e65-4692-4606-b59d-d85a9f591da3"],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, 
   3.8214425273837843`*^9, 3.823318440115117*^9, 3.823320755100151*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"ae29c7f8-b072-414d-8e02-752d3b6e8a4f"],

Cell[BoxData["\<\"Luc Darme\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, 
   3.8214425273837843`*^9, 3.823318440115117*^9, 3.8233207551024942`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"f927c658-8ee9-40fa-94c0-ddbbecb6ce08"],

Cell[BoxData["\<\"Benjamin Fuks\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, 
   3.8214425273837843`*^9, 3.823318440115117*^9, 3.823320755103936*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"57d46524-e823-4b81-9dd9-970accc12130"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1\"\>"}],
  SequenceForm["Model Version: ", "1"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, 
   3.8214425273837843`*^9, 3.823318440115117*^9, 3.823320755105549*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"87adc8b3-d4ec-4de4-b5a0-a0bb3e113201"],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, 
   3.8214425273837843`*^9, 3.823318440115117*^9, 3.8233207551068974`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"28e6ce1f-ecb3-4840-8246-688479933b63"],

Cell[BoxData["\<\"xxx\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, 
   3.8214425273837843`*^9, 3.823318440115117*^9, 3.823320755108189*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"9a247eb1-487d-4b9a-8919-15d16b78e103"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, 
   3.8214425273837843`*^9, 3.823318440115117*^9, 3.823320755109398*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"cc8ef3bd-9ade-40a9-9653-aba820294ac8"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, 
   3.8214425273837843`*^9, 3.823318440115117*^9, 3.823320755110619*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"6e8aac98-da2a-4c99-a8f3-4755d513d62a"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, 
   3.8214425273837843`*^9, 3.823318440115117*^9, 3.823320755111784*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"e7601e88-fb01-492d-bdb6-15cf96e70b48"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, 
   3.8214425273837843`*^9, 3.823318440115117*^9, 3.823320755203116*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"729c9581-a31e-4ebc-923e-a3fe97c60343"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, 
   3.8214425273837843`*^9, 3.823318440115117*^9, 3.823320755207385*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"7f40bb84-b6d2-4c6d-8e01-ad413b54670c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", 
   "\[InvisibleSpace]", "\<\"ColoredScalarsAndPScalars\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "ColoredScalarsAndPScalars", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, 
   3.8214425273837843`*^9, 3.823318440115117*^9, 3.82332075526468*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"2dfb2810-a498-4677-9335-d267ca382006"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Get", "noopen", 
   "\"Cannot open \
\\!\\(\\*RowBox[{\\\"\\\\\\\"DiagonalNP.rst\\\\\\\"\\\"}]\\).\"", 2, 6, 1, 
   32130049324730186892, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8233184403065023`*^9, 3.8233207552920227`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"33738be6-83a4-4172-b4f6-85005cc90a39"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"DiagonalNP.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "0"}],
  SequenceForm["Loading restrictions from ", "DiagonalNP.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, 
   3.8214425273837843`*^9, 3.823318440115117*^9, 3.8233207560423813`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"a133ed18-0b7c-48af-8cde-030514a7b786"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/luc/Computing/feynrules-current/Models/SM/DiagonalCKM.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm[
  "Loading restrictions from ", 
   "/Users/luc/Computing/feynrules-current/Models/SM/DiagonalCKM.rst", " : ", 
   
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, 
   3.8214425273837843`*^9, 3.823318440115117*^9, 3.823320756258607*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"dd287bfb-626e-4e87-8d47-c7352d2efda3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/luc/Computing/feynrules-current/Models/SM/Massless.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18"}],
  SequenceForm[
  "Loading restrictions from ", 
   "/Users/luc/Computing/feynrules-current/Models/SM/Massless.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, 
   3.8214425273837843`*^9, 3.823318440115117*^9, 3.823320756482634*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"da353c1f-8b99-4c18-bbfc-044bc3546eeb"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Get", "noopen", 
   "\"Cannot open \
\\!\\(\\*RowBox[{\\\"\\\\\\\"NozRzL.rst\\\\\\\"\\\"}]\\).\"", 2, 6, 2, 
   32130049324730186892, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8233184403065023`*^9, 3.823320756626422*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"9a0caf35-1bb3-4279-8ad1-967e5cc138cf"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"NozRzL.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18"}],
  SequenceForm["Loading restrictions from ", "NozRzL.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, 
   3.8214425273837843`*^9, 3.823318440115117*^9, 3.8233207567378197`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"2d6897a1-2ce9-469d-9055-6990a632073a"],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{
  3.759473267058181*^9, 3.780202297656021*^9, {3.780202369364346*^9, 
   3.780202392020115*^9}, 3.7806455104595423`*^9, 3.780645550860627*^9, 
   3.780645962071322*^9, 3.780646103530203*^9, 3.78263335665174*^9, 
   3.8214425273837843`*^9, 3.823318440115117*^9, 3.823320756873501*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"a2421e22-ae06-4cc7-9360-00734641cc95"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Checking", " ", "the", " ", "hermiticity", " ", "of", " ", "the", " ", 
    "model"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"CheckMassSpectrum", "[", "LagNP", "]"}], "\[IndentingNewLine]", 
   RowBox[{"CheckHermiticity", "[", "LagNP", "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Feynman", " ", "rules"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"vertices", "=", 
    RowBox[{"FeynmanRules", "[", "LagNP", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Getting", " ", "decays"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"decays", "=", 
     RowBox[{"ComputeWidths", "[", "vertices", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Getting", " ", "UFO"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"WriteUFO", "[", 
    RowBox[{
     RowBox[{"LSM", "+", "LagNP"}], ",", 
     RowBox[{"Output", "\[Rule]", "\"\<PseudoScalarOctet_UFO\>\""}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7594723247858057`*^9, 3.7594724349408712`*^9}, 
   3.759472503253831*^9, {3.75947256827782*^9, 3.759472569743855*^9}, {
   3.759472916998436*^9, 3.7594729172534723`*^9}, {3.7594732513207397`*^9, 
   3.759473276459257*^9}, {3.759473397881085*^9, 3.759473420215959*^9}, {
   3.75947351737363*^9, 3.759473518066074*^9}, 3.780202401768827*^9, {
   3.780646020664256*^9, 3.780646020908284*^9}, {3.821442530364954*^9, 
   3.821442531044374*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"7e0dd744-d8cc-4c5d-9e79-7a3c170f227e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.8233207586138678`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"cee3a073-baa3-4f1e-8ab7-2bc180d6b6fc"],

Cell[BoxData["\<\"All mass terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320758616325*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"9aa76ae7-fec0-41c3-adc1-3b0c510e5d48"],

Cell[BoxData["\<\"Getting mass spectrum.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320758707266*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"1642a574-b840-4fb8-a6e4-49360feb28d9"],

Cell[BoxData["\<\"Checking for less then 0.1% agreement with model file \
values.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320758709297*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"625f8528-2315-4396-8fac-79dcd903f0aa"]
}, Open  ]],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Particle\"\>", "\<\"Analytic value\"\>", "\<\"Numerical value\"\>", \
"\<\"Model-file value\"\>"},
    {"sig8", 
     SqrtBox[
      SuperscriptBox["m8", "2"]], "400.`", "400.`"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.759472487149548*^9, {3.759472548279285*^9, 3.759472575800432*^9}, 
   3.75947307066348*^9, 3.759473286055393*^9, 3.7594734306190653`*^9, 
   3.780202405050234*^9, 3.780645515932193*^9, 3.780645554707588*^9, 
   3.780646021907053*^9, 3.780646121004187*^9, 3.782633360340663*^9, 
   3.821442533480537*^9, 3.823318443005598*^9, 3.8233207587109537`*^9},
 CellLabel->
  "Out[7]//TableForm=",ExpressionUUID->"e11c1c6f-5465-4dbf-8c75-afe91c9b272f"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.8233207587837*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"d9ebd4bb-ceec-4ea8-a49d-8e2dc84a32c3"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320758785337*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"2f106143-f545-48fe-a875-1768a1908753"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.82332075902805*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"7b502949-46b9-418e-b341-584f1435324a"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320759029521*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"fd7b139f-5eda-4a7c-ae7e-9e0ba1831a73"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.8233207590307093`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"65aae85c-c356-47e4-8b7a-6393c7a35258"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320759031864*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"cede2168-7f48-4317-b50c-57ed58238004"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320759032956*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"1dc4dd1f-dd86-4802-95af-1227b83c9a30"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.759472487149548*^9, {3.759472548279285*^9, 3.759472575800432*^9}, 
   3.75947307066348*^9, 3.759473286055393*^9, 3.7594734306190653`*^9, 
   3.780202405050234*^9, 3.780645515932193*^9, 3.780645554707588*^9, 
   3.780646021907053*^9, 3.780646121004187*^9, 3.782633360340663*^9, 
   3.821442533480537*^9, 3.823318443005598*^9, 3.8233207590340548`*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"b8d82e83-8c9a-4fae-ba3a-88e97421b82d"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320759098208*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"4de05185-b15d-4b2c-9034-fec340711174"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320759099938*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"9eea7f55-45ae-475e-bd69-6ec43a9c344a"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320759202611*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"3f8d8f08-b122-4988-9a31-c3526d32f648"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "3", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{7., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  3, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 3, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.8233207592043543`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"fc1e849c-5d7b-4005-a3dd-914039e169c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[3, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320759286618*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"b0cc2838-b0ed-4006-ab40-cd2daaa2cbc8"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"sig8", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"sig8", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]]}], "-", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"sig8", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"sig8", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["t", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"sig8", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"Subsuperscript", "[", 
       RowBox[{"y", ",", "\<\"8PS\"\>"}], "]"}], " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]], "5"},
       "Superscript"], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "3"]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.759472487149548*^9, {3.759472548279285*^9, 3.759472575800432*^9}, 
   3.75947307066348*^9, 3.759473286055393*^9, 3.7594734306190653`*^9, 
   3.780202405050234*^9, 3.780645515932193*^9, 3.780645554707588*^9, 
   3.780646021907053*^9, 3.780646121004187*^9, 3.782633360340663*^9, 
   3.821442533480537*^9, 3.823318443005598*^9, 3.823320759289268*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"a52809ba-4270-4e35-a3cc-5f38fde4af95"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{7., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320759344524*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"2fea827d-ddfb-4a0a-85dd-dbe1af9d0a81"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320759373089*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"6a49dc8b-af55-432d-8c08-b80e8937b93f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{7., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320759376279*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"da2fbada-cc27-449b-87bd-9e9a372d9926"],

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320761255028*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f283eed3-4b6d-422c-8fc5-ae14efeffc24"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320761658428*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"8b25f81b-4b38-4158-8054-07a1beb00cd2"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.82332076166003*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"1620d859-20c3-4e20-bd1d-185357078695"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320761661182*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"4f99bd57-453a-4fff-a4e2-a66f9058d37e"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320768455463*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"997496c1-a1db-4546-8048-e06fdc7187d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "101", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "101", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  101, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 101, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.8233207684944983`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"2bfabd8e-280e-403a-bfd9-adc8f0717657"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"96", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[96, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.8233207722824297`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"ea80373f-3619-4f86-940f-1df639bd703b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "96"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 2, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 96],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320774326942*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"60e82b16-2758-4065-b257-a2e65e6c20db"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320780953712*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"90aa9899-c5f7-4a21-9d35-0f7a62ab8f63"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.8233207809843807`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"698468a1-534f-4b1a-89d4-24ba90ac7713"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "41"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 41],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320781027752*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"bd4b3c03-3277-4b0b-bd16-8b466f1a0a01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "1.676407`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 1.676407, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320788070784*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"05898876-a6fd-43a7-8b49-0b2dce18366e"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Decay", "Overwrite", "\"Warning: Previous results will be overwritten.\"", 
   2, 11, 3, 32130049324730186892, "Local", "FeynRules`Decay"},
  "MessageTemplate2"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.759472574381403*^9, 3.759473066224372*^9, 
  3.759473329756282*^9, 3.7594734356524353`*^9, 3.780202427044709*^9, 
  3.780645516104279*^9, 3.780645572802278*^9, 3.7806460222695017`*^9, 
  3.780646140058599*^9, 3.782633379694639*^9, 3.821442552010544*^9, 
  3.8233184721343193`*^9, 3.823320788107954*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"21bf7a21-9823-443a-b022-31540b909b28"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.014025`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 0.014025, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.82332078811574*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"b3edc095-8a3b-4ef0-bd94-cb1bcf4aac72"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320788118113*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"92b2b3d5-1c58-4bdc-a406-690024bedb41"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.8233207882099667`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"05538667-f3ff-48af-b094-f00b91f51147"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320788228907*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"90dec379-d508-4e09-ab1e-412fdd45384a"],

Cell[BoxData["\<\"before\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823320789979574*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"704260e3-1ec2-49b6-a643-713e8a9fce36"],

Cell[BoxData["\<\"before\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.8233207900054626`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"e8c194b2-211f-40df-8087-f0fe423e425d"],

Cell[BoxData["\<\"true\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.8233207900510902`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"184bfe92-3645-4471-bac2-bb2764f5e8ce"],

Cell[BoxData["\<\"true\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823320790069148*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"70dd4c4c-e53e-4ca0-ba7b-743131f985a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "122", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 122, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320790218923*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"b377661b-f05d-4e05-9609-56a71dcdfd9d"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320790319848*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"d4be457c-0375-4e07-8ee9-aaedf27ad8cc"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.780202404701612*^9, 3.7806455158382893`*^9, 3.780645554620697*^9, 
   3.7806460218107843`*^9, 3.780646120910939*^9, 3.7826333602489347`*^9, 
   3.821442533390011*^9, 3.82331844290725*^9, 3.823320790494546*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"462f8e51-c476-44b3-808f-9fe6d2f61929"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Scalar Singlet", "Section",
 CellChangeTimes->{{3.759472462715425*^9, 3.7594724703715563`*^9}, {
  3.7594740772772512`*^9, 
  3.759474077869609*^9}},ExpressionUUID->"819f672c-5d2b-4ffa-a0ab-\
b460c645b2e9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", "here", "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"LoadModel", "[", " ", 
     RowBox[{
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/SM.fr\>\""}], ",", 
      "\"\<ScalarSinglet.fr\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LoadRestriction", "[", 
     RowBox[{"\"\<DiagonalNP.rst\>\"", ",", 
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/DiagonalCKM.rst\>\""}], 
      ",", 
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/Massless.rst\>\""}], 
      ",", "\"\<NozRzL.rst\>\""}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.759473357442108*^9, 3.759473357661347*^9}, {
  3.7594740850493803`*^9, 3.759474085611158*^9}, {3.7802024273856564`*^9, 
  3.7802024409768972`*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"705fcdbb-0c8b-494d-a2c9-28d07f4c5c34"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.780202524142974*^9, 3.780202932516862*^9, 
  3.780646442612776*^9, 3.782633310667122*^9, 3.803976831713336*^9, 
  3.803977004440071*^9, 3.8214417500952272`*^9, 3.82331858409059*^9, 
  3.823318635302229*^9, 3.823578972398633*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"06db0bad-5d1b-48ca-9682-8ebc09331567"],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.780202524142974*^9, 3.780202932516862*^9, 
  3.780646442612776*^9, 3.782633310667122*^9, 3.803976831713336*^9, 
  3.803977004440071*^9, 3.8214417500952272`*^9, 3.82331858409059*^9, 
  3.823318635302229*^9, 3.823578972404636*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"90a7d998-d214-4de6-96b5-3cb7cc11c5c0"],

Cell[BoxData["\<\"Luc Darme\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.780202524142974*^9, 3.780202932516862*^9, 
  3.780646442612776*^9, 3.782633310667122*^9, 3.803976831713336*^9, 
  3.803977004440071*^9, 3.8214417500952272`*^9, 3.82331858409059*^9, 
  3.823318635302229*^9, 3.823578972406855*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"b48bc65d-8dca-49c2-b39c-45715f1f392f"],

Cell[BoxData["\<\"Benjamin Fuks\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.780202524142974*^9, 3.780202932516862*^9, 
  3.780646442612776*^9, 3.782633310667122*^9, 3.803976831713336*^9, 
  3.803977004440071*^9, 3.8214417500952272`*^9, 3.82331858409059*^9, 
  3.823318635302229*^9, 3.823578972408255*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"e0c53747-96ea-473c-bffc-183ff8b10354"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1\"\>"}],
  SequenceForm["Model Version: ", "1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.780202524142974*^9, 3.780202932516862*^9, 
  3.780646442612776*^9, 3.782633310667122*^9, 3.803976831713336*^9, 
  3.803977004440071*^9, 3.8214417500952272`*^9, 3.82331858409059*^9, 
  3.823318635302229*^9, 3.823578972409422*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"bc2d4d66-48b7-48b5-9634-4ea11b7683ca"],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.780202524142974*^9, 3.780202932516862*^9, 
  3.780646442612776*^9, 3.782633310667122*^9, 3.803976831713336*^9, 
  3.803977004440071*^9, 3.8214417500952272`*^9, 3.82331858409059*^9, 
  3.823318635302229*^9, 3.8235789724106207`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"7bd53cfe-ee29-4413-967e-399fdc624069"],

Cell[BoxData["\<\"xxx\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.780202524142974*^9, 3.780202932516862*^9, 
  3.780646442612776*^9, 3.782633310667122*^9, 3.803976831713336*^9, 
  3.803977004440071*^9, 3.8214417500952272`*^9, 3.82331858409059*^9, 
  3.823318635302229*^9, 3.8235789724119062`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"a668c6e1-d75a-4b55-8c84-32bf3c946f34"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.780202524142974*^9, 3.780202932516862*^9, 
  3.780646442612776*^9, 3.782633310667122*^9, 3.803976831713336*^9, 
  3.803977004440071*^9, 3.8214417500952272`*^9, 3.82331858409059*^9, 
  3.823318635302229*^9, 3.8235789724130583`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"bbc71d9b-d5ec-4bfe-94f1-e6852b464bdc"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.780202524142974*^9, 3.780202932516862*^9, 
  3.780646442612776*^9, 3.782633310667122*^9, 3.803976831713336*^9, 
  3.803977004440071*^9, 3.8214417500952272`*^9, 3.82331858409059*^9, 
  3.823318635302229*^9, 3.823578972414249*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"fe6d26d3-dc5d-4c27-854d-36630dbeaafb"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.780202524142974*^9, 3.780202932516862*^9, 
  3.780646442612776*^9, 3.782633310667122*^9, 3.803976831713336*^9, 
  3.803977004440071*^9, 3.8214417500952272`*^9, 3.82331858409059*^9, 
  3.823318635302229*^9, 3.823578972415349*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"c352f096-2036-4205-9df7-d6f02308c3d9"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.780202524142974*^9, 3.780202932516862*^9, 
  3.780646442612776*^9, 3.782633310667122*^9, 3.803976831713336*^9, 
  3.803977004440071*^9, 3.8214417500952272`*^9, 3.82331858409059*^9, 
  3.823318635302229*^9, 3.823578972507433*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"d392c500-932f-457c-b0c9-1f674566e421"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.780202524142974*^9, 3.780202932516862*^9, 
  3.780646442612776*^9, 3.782633310667122*^9, 3.803976831713336*^9, 
  3.803977004440071*^9, 3.8214417500952272`*^9, 3.82331858409059*^9, 
  3.823318635302229*^9, 3.823578972511628*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"53d84af9-19bd-4b0d-b6ad-b4d6c5136d02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", 
   "\[InvisibleSpace]", "\<\"SingletTopPhilicScalar\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "SingletTopPhilicScalar", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.780202524142974*^9, 3.780202932516862*^9, 
  3.780646442612776*^9, 3.782633310667122*^9, 3.803976831713336*^9, 
  3.803977004440071*^9, 3.8214417500952272`*^9, 3.82331858409059*^9, 
  3.823318635302229*^9, 3.823578972567519*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"a0ea598e-f4cf-4055-bef3-221aed8df7f9"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Get","noopen",
   "\"Cannot open \
\\!\\(\\*RowBox[{\\\"\\\\\\\"DiagonalNP.rst\\\\\\\"\\\"}]\\).\"",2,6,1,
   32131741531682137609,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823318584312607*^9, 3.8233186354951878`*^9, 
  3.82357897259284*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"5ebd036c-14bd-453f-8902-fe24ccba0dc2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"DiagonalNP.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "0"}],
  SequenceForm["Loading restrictions from ", "DiagonalNP.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.780202524142974*^9, 3.780202932516862*^9, 
  3.780646442612776*^9, 3.782633310667122*^9, 3.803976831713336*^9, 
  3.803977004440071*^9, 3.8214417500952272`*^9, 3.82331858409059*^9, 
  3.823318635302229*^9, 3.823578973321041*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"2b015653-fbeb-4a9e-8619-3cee8ab8fa80"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/luc/Computing/feynrules-current/Models/SM/DiagonalCKM.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm[
  "Loading restrictions from ", 
   "/Users/luc/Computing/feynrules-current/Models/SM/DiagonalCKM.rst", " : ", 
   
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.780202524142974*^9, 3.780202932516862*^9, 
  3.780646442612776*^9, 3.782633310667122*^9, 3.803976831713336*^9, 
  3.803977004440071*^9, 3.8214417500952272`*^9, 3.82331858409059*^9, 
  3.823318635302229*^9, 3.823578973511758*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"18f856e8-763a-42a4-b816-9f6f14a84193"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/luc/Computing/feynrules-current/Models/SM/Massless.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18"}],
  SequenceForm[
  "Loading restrictions from ", 
   "/Users/luc/Computing/feynrules-current/Models/SM/Massless.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.780202524142974*^9, 3.780202932516862*^9, 
  3.780646442612776*^9, 3.782633310667122*^9, 3.803976831713336*^9, 
  3.803977004440071*^9, 3.8214417500952272`*^9, 3.82331858409059*^9, 
  3.823318635302229*^9, 3.823578973715878*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"f29b17e3-5ef9-49da-bcfb-21ceb4cb1282"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Get", "noopen", 
   "\"Cannot open \
\\!\\(\\*RowBox[{\\\"\\\\\\\"NozRzL.rst\\\\\\\"\\\"}]\\).\"", 2, 6, 2, 
   32131741531682137609, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823318584312607*^9, 3.8233186354951878`*^9, 
  3.823578973851389*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"3e99a600-32b5-404f-8115-5dd813b3a8ce"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"NozRzL.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18"}],
  SequenceForm["Loading restrictions from ", "NozRzL.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.780202524142974*^9, 3.780202932516862*^9, 
  3.780646442612776*^9, 3.782633310667122*^9, 3.803976831713336*^9, 
  3.803977004440071*^9, 3.8214417500952272`*^9, 3.82331858409059*^9, 
  3.823318635302229*^9, 3.823578973949757*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"23bdd89d-461f-4c69-abc6-98f0337c6f06"],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.780202524142974*^9, 3.780202932516862*^9, 
  3.780646442612776*^9, 3.782633310667122*^9, 3.803976831713336*^9, 
  3.803977004440071*^9, 3.8214417500952272`*^9, 3.82331858409059*^9, 
  3.823318635302229*^9, 3.823578974077059*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"3057b7aa-a578-49d6-a894-ecd0b12d2534"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  
  RowBox[{"(*", 
   RowBox[{
   "Checking", " ", "the", " ", "hermiticity", " ", "of", " ", "the", " ", 
    "model"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"CheckMassSpectrum", "[", "LagNP", "]"}], "\[IndentingNewLine]", 
   RowBox[{"CheckHermiticity", "[", "LagNP", "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Feynman", " ", "rules"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"vertices", "=", 
    RowBox[{"FeynmanRules", "[", "LagNP", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Getting", " ", "decays"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"decays", "=", 
     RowBox[{"ComputeWidths", "[", "vertices", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Getting", " ", "UFO"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"WriteUFO", "[", 
    RowBox[{
     RowBox[{"LSM", "+", "LagNP"}], ",", 
     RowBox[{"Output", "\[Rule]", "\"\<ScalarSinglet_UFO\>\""}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7594723247858057`*^9, 3.7594724349408712`*^9}, 
   3.759472503253831*^9, {3.75947256827782*^9, 3.759472569743855*^9}, {
   3.759472916998436*^9, 3.7594729172534723`*^9}, {3.7594732513207397`*^9, 
   3.759473276459257*^9}, {3.759473397881085*^9, 3.759473420215959*^9}, {
   3.75947351737363*^9, 3.759473518066074*^9}, {3.759474092352673*^9, 
   3.7594740929439583`*^9}, {3.7806464535613337`*^9, 3.780646462604203*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"d088ecf6-7071-4e1a-abb2-2ae357bb4163"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823578978048177*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"4e624a7e-5165-4d91-b2a9-c32654ae5b23"],

Cell[BoxData["\<\"All mass terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.82357897805079*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"e0359b01-3bbf-4674-95fc-1da4d15a5a75"],

Cell[BoxData["\<\"Getting mass spectrum.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.8235789780759583`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"2bd53418-eafb-47c0-a6f1-3078fff250a8"],

Cell[BoxData["\<\"Checking for less then 0.1% agreement with model file \
values.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823578978077476*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"80524763-4589-4473-a856-ef892e4a0a00"]
}, Open  ]],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Particle\"\>", "\<\"Analytic value\"\>", "\<\"Numerical value\"\>", \
"\<\"Model-file value\"\>"},
    {"sig1", 
     SqrtBox[
      SuperscriptBox["msig1", "2"]], "400.`", "400.`"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.759472487149548*^9, {3.759472548279285*^9, 3.759472575800432*^9}, 
   3.75947307066348*^9, 3.759473286055393*^9, 3.7594734306190653`*^9, 
   3.759474184074905*^9, 3.759474309300272*^9, 3.759474496372921*^9, 
   3.7802025258771276`*^9, 3.7802029377210407`*^9, 3.7806464635278683`*^9, 
   3.782633315501286*^9, 3.803976835373971*^9, 3.8039770074282713`*^9, 
   3.821441754403936*^9, 3.823318587129444*^9, 3.8233186371458197`*^9, 
   3.8235789780791187`*^9},
 CellLabel->
  "Out[7]//TableForm=",ExpressionUUID->"1ea121f5-3b08-4cee-8fe9-f2da83f31ea0"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.82357897808136*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f703df68-c566-493c-aeae-ab03f1caec86"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823578978083063*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"5bbc6466-fda1-4ede-bf71-bb20067abc78"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823578978132738*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"ab920366-f85a-4a3a-9670-cda552a3dd91"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823578978134118*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"51bb41c9-4c26-49cb-9dbd-04af77f9dab6"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823578978135357*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"05a72088-2e96-47d6-97ab-b86b92c2168a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823578978136722*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"32cc7401-0882-4cb9-a828-0d1ff90c28c4"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.8235789781381207`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"de95df15-5a72-4af7-a5cb-1dfd6a600ee8"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.759472487149548*^9, {3.759472548279285*^9, 3.759472575800432*^9}, 
   3.75947307066348*^9, 3.759473286055393*^9, 3.7594734306190653`*^9, 
   3.759474184074905*^9, 3.759474309300272*^9, 3.759474496372921*^9, 
   3.7802025258771276`*^9, 3.7802029377210407`*^9, 3.7806464635278683`*^9, 
   3.782633315501286*^9, 3.803976835373971*^9, 3.8039770074282713`*^9, 
   3.821441754403936*^9, 3.823318587129444*^9, 3.8233186371458197`*^9, 
   3.823578978139345*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"da96624f-bcdd-4c8d-a30e-cf17b2c1dcb3"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823578978161216*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"2aca0c48-9ea6-4452-ae42-0f43a80c44d6"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.8235789781632347`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"254310d7-a9a9-4e74-82fc-8f238be10232"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.8235789781658*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"5ffceceb-af6f-44a9-93df-4963e6a5c822"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{7., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823578978167076*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"d12c0252-9a14-46f5-8022-70e814a15740"],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.8235789781906767`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"64e2436f-fe3e-4d67-8735-ff97912b221c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        OverscriptBox["t", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"sig1", ",", "3"}], "}"}]}], "}"}], ",", 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"Subsuperscript", "[", 
      RowBox[{"y", ",", "\<\"1S\"\>"}], "]"}], " ", 
     SubscriptBox["\[Delta]", 
      RowBox[{
       SubscriptBox["\<\"m\"\>", "1"], ",", 
       SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
     SubscriptBox["\[Delta]", 
      RowBox[{
       SubscriptBox["\<\"s\"\>", "1"], ",", 
       SubscriptBox["\<\"s\"\>", "2"]}]]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.759472487149548*^9, {3.759472548279285*^9, 3.759472575800432*^9}, 
   3.75947307066348*^9, 3.759473286055393*^9, 3.7594734306190653`*^9, 
   3.759474184074905*^9, 3.759474309300272*^9, 3.759474496372921*^9, 
   3.7802025258771276`*^9, 3.7802029377210407`*^9, 3.7806464635278683`*^9, 
   3.782633315501286*^9, 3.803976835373971*^9, 3.8039770074282713`*^9, 
   3.821441754403936*^9, 3.823318587129444*^9, 3.8233186371458197`*^9, 
   3.823578978192122*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"63b69d02-6643-4d45-9fb3-22f3aae2fd4a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{7., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.82357897822294*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"da326263-69f9-46c2-8ca4-fff4424cf60b"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823578978230035*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"aafa66b4-b80a-43c2-ba7a-54f92bb611d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{7., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.8235789782324133`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"c9a24680-0877-4504-92f1-3305481fcb2e"],

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823578979996889*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"ea2a99c7-c4d9-4abc-9216-eb9a6f168382"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.82357898040137*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"68c5cd5b-1acb-433e-bb8e-89dbc903da30"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.82357898040272*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"2ea860fa-2151-4045-ad10-7be2cc710c45"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823578980403811*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"81a3b0aa-7476-4a13-9e1c-426a86d3550a"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823578987297676*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"e0f7e6cd-1012-4426-ab7f-b8c2e72da608"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "99", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "99", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  99, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 99, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.8235789873387623`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"a3808508-8318-41f7-ae02-382bc1051e6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"94", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[94, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823578991052312*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"af159158-b690-44eb-8811-4367866cfd5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "94"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 2, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 94],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.8235789930369368`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"d9b61900-da7b-43d6-ac7d-7b2513af042f"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.8235789992059193`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"fab9ee39-0b86-4e62-b5f5-90257a1d1d4a"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823578999223147*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"6fdf4842-4eb7-46a5-9fed-97f24fa187ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "41"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 41],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823578999270791*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"b35c0842-80bc-4db8-b611-2c4b97affdf7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "1.642562`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 1.642562, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823579006144389*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"7a779bae-d46e-4d29-8e9b-f5113fe82211"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Decay", "Overwrite", "\"Warning: Previous results will be overwritten.\"", 
   2, 11, 3, 32131741531682137609, "Local", "FeynRules`Decay"},
  "MessageTemplate2"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.759472574381403*^9, 3.759473066224372*^9, 
  3.759473329756282*^9, 3.7594734356524353`*^9, 3.759474183591339*^9, 
  3.759474308801608*^9, 3.7594745283499393`*^9, 3.780202525926607*^9, 
  3.780202958515935*^9, 3.780646481999653*^9, 3.782633334344795*^9, 
  3.803976853263113*^9, 3.803977025377245*^9, 3.821441772736952*^9, 
  3.823318615183913*^9, 3.823318663577112*^9, 3.823579006165017*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"9cb408cf-d05d-4bd8-9faa-bf3c2b19b899"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.015081`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 0.015081, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823579006177326*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"8b4983dc-0c7b-4e01-aa08-a5917e60e9c9"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823579006180895*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"373a514d-4025-402a-9695-2a2c8a40b516"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823579006279673*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"4d81d7e7-da47-4d21-a9b4-87bec47741a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.8235790062971983`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"54bbe6ab-a23b-4582-aed0-abce46c9961e"],

Cell[BoxData["\<\"before\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823579007978004*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"bbd738f4-910f-4a6d-9cdd-bc577f4ca313"],

Cell[BoxData["\<\"before\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823579008001918*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"55b89a52-997e-4aab-a32d-2324c6375348"],

Cell[BoxData["\<\"true\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823579008036851*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"61113892-0799-438f-9afb-e9a1b05cc48b"],

Cell[BoxData["\<\"true\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823579008055234*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"327214f9-b03b-4afc-817d-1d9c75c69823"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "120", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 120, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823579008214522*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"cf848ccc-73f4-4cd3-a3bc-3c4d7f448e86"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.82357900832656*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"cc258e59-f651-40ff-a7ca-353fef5396a9"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.823318587104298*^9, 3.823318637117969*^9, 
   3.823579008437755*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"8991f406-eaea-45eb-ad83-5180f2fdd853"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Pseudo-Scalar Singlet", "Section",
 CellChangeTimes->{{3.759472462715425*^9, 3.7594724703715563`*^9}, {
  3.7594740772772512`*^9, 3.759474077869609*^9}, {3.8214424079572372`*^9, 
  3.821442408884788*^9}},ExpressionUUID->"1812bef9-f936-48ad-b64b-\
c123c124db88"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", "here", "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"LoadModel", "[", " ", 
     RowBox[{
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/SM.fr\>\""}], ",", 
      "\"\<PseudoScalarSinglet.fr\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LoadRestriction", "[", 
     RowBox[{"\"\<DiagonalNP.rst\>\"", ",", 
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/DiagonalCKM.rst\>\""}], 
      ",", 
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/Massless.rst\>\""}], 
      ",", "\"\<NozRzL.rst\>\""}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.759473357442108*^9, 3.759473357661347*^9}, {
  3.7594740850493803`*^9, 3.759474085611158*^9}, {3.7802024273856564`*^9, 
  3.7802024409768972`*^9}, {3.8214424520615873`*^9, 3.82144245266854*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"0f606d4d-e1b4-4fcd-9ac1-159c2a8d2bea"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{3.8214424702668037`*^9, 3.823318701016069*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"449fa94b-e3e9-41b4-9d3c-bfa41f938e55"],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.8214424702668037`*^9, 3.8233187010221157`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"b0c36fdd-2671-4e31-84d5-2247cbc3c099"],

Cell[BoxData["\<\"Luc Darme\"\>"], "Print",
 CellChangeTimes->{3.8214424702668037`*^9, 3.823318701024301*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"a115476f-3318-4d90-a1f3-7ebfebe6428d"],

Cell[BoxData["\<\"Benjamin Fuks\"\>"], "Print",
 CellChangeTimes->{3.8214424702668037`*^9, 3.8233187010258923`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"b4cde2ef-155d-4847-beb6-91aba70b372b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1\"\>"}],
  SequenceForm["Model Version: ", "1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8214424702668037`*^9, 3.8233187010274277`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"3afa8fa0-f483-4d92-a57d-751e7c795ba0"],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{3.8214424702668037`*^9, 3.823318701028738*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"0704ac07-c220-4ce9-95bc-166f79effaf5"],

Cell[BoxData["\<\"xxx\"\>"], "Print",
 CellChangeTimes->{3.8214424702668037`*^9, 3.8233187010299473`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"50b4e075-98fe-4be1-9609-5831c25c7811"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.8214424702668037`*^9, 3.823318701031109*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"480f511b-7374-4777-bc0c-9a0ca8cb1f0a"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.8214424702668037`*^9, 3.8233187010322742`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"3f3c4dd7-e86f-4be3-b3a0-3862bd6bd6af"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.8214424702668037`*^9, 3.823318701033444*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"9f6078a0-acf4-4145-a532-31167690d432"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.8214424702668037`*^9, 3.823318701125287*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"d0231ebc-0003-48ec-904a-4e31ccb642f2"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.8214424702668037`*^9, 3.8233187011294727`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"ad32a3ed-e7bc-4c11-92c9-6a4ad71b72d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", 
   "\[InvisibleSpace]", "\<\"PseudoScalarSingletTopPhilic\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "PseudoScalarSingletTopPhilic", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8214424702668037`*^9, 3.823318701185701*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"9c6afc6f-dd18-4366-96a1-761ba9153a9f"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Get", "noopen", 
   "\"Cannot open \
\\!\\(\\*RowBox[{\\\"\\\\\\\"DiagonalNP.rst\\\\\\\"\\\"}]\\).\"", 2, 6, 1, 
   32130035856794954629, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8233187012089157`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"942aa00c-e167-4c3c-9f10-e4994a3c82e5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"DiagonalNP.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "0"}],
  SequenceForm["Loading restrictions from ", "DiagonalNP.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.8214424702668037`*^9, 3.823318701926551*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"c7f9c926-26ad-4e7a-8ee2-8db3e70d6628"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/luc/Computing/feynrules-current/Models/SM/DiagonalCKM.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm[
  "Loading restrictions from ", 
   "/Users/luc/Computing/feynrules-current/Models/SM/DiagonalCKM.rst", " : ", 
   
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.8214424702668037`*^9, 3.823318702117577*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"617f0884-15ca-4ea0-aa97-1e434db0b45d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/luc/Computing/feynrules-current/Models/SM/Massless.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18"}],
  SequenceForm[
  "Loading restrictions from ", 
   "/Users/luc/Computing/feynrules-current/Models/SM/Massless.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{3.8214424702668037`*^9, 3.823318702323023*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"95785b3a-8458-4863-90c5-a6a1abc5bf17"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Get", "noopen", 
   "\"Cannot open \
\\!\\(\\*RowBox[{\\\"\\\\\\\"NozRzL.rst\\\\\\\"\\\"}]\\).\"", 2, 6, 2, 
   32130035856794954629, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823318702458466*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"3e7fe991-e737-4dc3-a48c-507c60daa44a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"NozRzL.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18"}],
  SequenceForm["Loading restrictions from ", "NozRzL.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{3.8214424702668037`*^9, 3.823318702553987*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"00d55980-5771-4a46-a41b-2800544c6fb5"],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{3.8214424702668037`*^9, 3.823318702678584*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"af9e9d44-e78d-45c3-9450-63acb2e26912"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  
  RowBox[{"(*", 
   RowBox[{
   "Checking", " ", "the", " ", "hermiticity", " ", "of", " ", "the", " ", 
    "model"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"CheckMassSpectrum", "[", "LagNP", "]"}], "\[IndentingNewLine]", 
   RowBox[{"CheckHermiticity", "[", "LagNP", "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Feynman", " ", "rules"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"vertices", "=", 
    RowBox[{"FeynmanRules", "[", "LagNP", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Getting", " ", "decays"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"decays", "=", 
     RowBox[{"ComputeWidths", "[", "vertices", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Getting", " ", "UFO"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"WriteUFO", "[", 
    RowBox[{
     RowBox[{"LSM", "+", "LagNP"}], ",", 
     RowBox[{"Output", "\[Rule]", "\"\<PseudoScalarSinglet_UFO\>\""}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7594723247858057`*^9, 3.7594724349408712`*^9}, 
   3.759472503253831*^9, {3.75947256827782*^9, 3.759472569743855*^9}, {
   3.759472916998436*^9, 3.7594729172534723`*^9}, {3.7594732513207397`*^9, 
   3.759473276459257*^9}, {3.759473397881085*^9, 3.759473420215959*^9}, {
   3.75947351737363*^9, 3.759473518066074*^9}, {3.759474092352673*^9, 
   3.7594740929439583`*^9}, {3.7806464535613337`*^9, 3.780646462604203*^9}, 
   3.821442473877527*^9},
 CellLabel->"In[7]:=",ExpressionUUID->"60e7446f-a673-4fb9-9240-656f65e9e705"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.8233187047438507`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"559eef55-f904-44ef-9d00-565db771c842"],

Cell[BoxData["\<\"No Mass terms found.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318704745811*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"fcbe7e4e-79a6-488c-932f-01203a9dbe3e"],

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318704768508*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"9deb0eb6-d954-4056-92b4-7ccc1e375364"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318704769829*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"d9d01ad4-efaa-4f60-97b4-8c1d69501299"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318704852964*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"8b8cc6a4-d116-404f-9170-1ea44ff3a053"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.8233187048542128`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f474176e-131f-4124-b015-8d6ce9648309"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.82331870487468*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"645a0fb6-ec52-4abb-92c7-e4dfe654bc92"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318704875931*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"691515ae-9beb-4518-9c0c-0865f2183b0e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.8233187048769913`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"969ac467-ba99-4e45-9e39-beef65cc3fe2"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.8233187048779793`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"7f59fd82-c065-4b3e-ba22-997ab53f1e3b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.759472487149548*^9, {3.759472548279285*^9, 3.759472575800432*^9}, 
   3.75947307066348*^9, 3.759473286055393*^9, 3.7594734306190653`*^9, 
   3.759474184074905*^9, 3.759474309300272*^9, 3.759474496372921*^9, 
   3.7802025258771276`*^9, 3.7802029377210407`*^9, 3.7806464635278683`*^9, 
   3.782633315501286*^9, 3.803976835373971*^9, 3.8039770074282713`*^9, 
   3.821441754403936*^9, 3.821442475547104*^9, 3.823318704879018*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"3c9c0ecd-aaca-41c2-83c4-fd6840ad74d5"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.82331870490263*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"a1775cd9-0b8c-447f-b31e-c7632a4eec7b"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318704904049*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"2aa172ec-2045-4b8d-a8bd-1e0677205791"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318704934844*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"e832a92d-b63b-4192-aeb4-61e5355824c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318704937367*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"a8444e98-ea2c-463f-95fa-a6ee0e1e945a"],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.8233187049538937`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f944c31f-38f7-40e6-8d16-00f6b4c76622"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        OverscriptBox["t", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"PS1", ",", "3"}], "}"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Subsuperscript", "[", 
       RowBox[{"y", ",", "\<\"1P\"\>"}], "]"}]}], " ", 
     TemplateBox[{
       SubscriptBox["\[Gamma]", 
        RowBox[{
          SubscriptBox["\"s\"", "1"], ",", 
          SubscriptBox["\"s\"", "2"]}]], "5"},
      "Superscript"], " ", 
     SubscriptBox["\[Delta]", 
      RowBox[{
       SubscriptBox["\<\"m\"\>", "1"], ",", 
       SubscriptBox["\<\"m\"\>", "2"]}]]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.759472487149548*^9, {3.759472548279285*^9, 3.759472575800432*^9}, 
   3.75947307066348*^9, 3.759473286055393*^9, 3.7594734306190653`*^9, 
   3.759474184074905*^9, 3.759474309300272*^9, 3.759474496372921*^9, 
   3.7802025258771276`*^9, 3.7802029377210407`*^9, 3.7806464635278683`*^9, 
   3.782633315501286*^9, 3.803976835373971*^9, 3.8039770074282713`*^9, 
   3.821441754403936*^9, 3.821442475547104*^9, 3.823318704955471*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"e8efb411-9496-49f4-85ae-cd0cad8cfaf4"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318704985004*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"d6b7f6a5-d9ff-43b2-a8b3-3bb8c36062f4"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.8233187050063*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"3d0b1b1e-d0ec-4128-90de-4c8c8702ac6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{7., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318705008767*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f6331983-2452-4508-9aac-366b6a5d2c30"],

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318706833499*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"a8cb0655-b06d-431d-aab2-9c6c11b85c1a"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318707214533*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"5b65b2fc-e2bc-4f24-b207-f006146b6adb"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.8233187072158747`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"75cbd0e0-a49d-47a6-8268-1e1930a8344b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318707216951*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"d5994477-eb29-4962-8756-c1ad07f72d65"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.8233187140395937`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"7ee3bd7e-d15e-4077-a17d-8259fe9719c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "99", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "99", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  99, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 99, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318714078253*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"24adf13b-7bd1-44aa-ad10-00c594f793c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"94", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[94, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.8233187177297564`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"460c2438-8cc8-4376-b1be-4f412b73532c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "94"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 2, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 94],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.82331871967074*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f5e683a6-fdc2-48b2-9da3-08c5f8639f39"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318726011697*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"4ea9e8ef-9ffb-4ee1-a4cd-d1c0c54e3e7d"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.8233187260297213`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"57257e10-952a-42f1-9b10-2f363452722f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "41"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 41],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318726075139*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"eb4bc61d-2b53-416d-ad62-15bc50080b5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "1.615462`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 1.615462, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318732918529*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"b36d66e2-4b61-43f1-95b6-cbe3701e97f3"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Decay", "Overwrite", "\"Warning: Previous results will be overwritten.\"", 
   2, 11, 3, 32130035856794954629, "Local", "FeynRules`Decay"},
  "MessageTemplate2"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.759472574381403*^9, 3.759473066224372*^9, 
  3.759473329756282*^9, 3.7594734356524353`*^9, 3.759474183591339*^9, 
  3.759474308801608*^9, 3.7594745283499393`*^9, 3.780202525926607*^9, 
  3.780202958515935*^9, 3.780646481999653*^9, 3.782633334344795*^9, 
  3.803976853263113*^9, 3.803977025377245*^9, 3.821441772736952*^9, 
  3.821442493358333*^9, 3.823318732938633*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"9e8fc71c-abc7-46e6-913e-c883220e2812"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.014505`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 0.014505, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318732946306*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f1aeb60d-e5aa-4a5e-9ee0-6414aee323b8"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.8233187329479837`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"e58e2cc1-e88e-40c0-a3e6-e357798dfea0"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.8233187330321493`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"7f208292-e319-4953-824a-34358f8d4951"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.8233187330504837`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"4418c541-eddd-496e-8dfa-3b4517d1c7fa"],

Cell[BoxData["\<\"before\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.8233187347457457`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"c4750bef-68a0-4d20-82ac-c1dccb931539"],

Cell[BoxData["\<\"before\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823318734782517*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"92f8dfb5-0f47-4f5d-ac6f-7517882d9330"],

Cell[BoxData["\<\"true\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823318734797558*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"59f9c090-a5f4-4e42-9c55-50bd415d3be3"],

Cell[BoxData["\<\"true\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823318734826511*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"0b952620-c3e1-413e-a525-822c8b4b94e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "120", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 120, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318734960473*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"0ee8688f-0eb6-46cc-ace6-2640771b36f1"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318735045947*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f3226bc3-db02-4b6f-85ca-e94bf7f74c7c"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202525738758*^9, 3.780202937508922*^9, 3.7806464634598827`*^9, 
   3.782633315427339*^9, 3.8039768353082542`*^9, 3.803977007396261*^9, 
   3.8214417543518753`*^9, 3.8214424754918528`*^9, 3.823318735153034*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"7952b3e4-aeba-4f1c-b963-0cb45edc06d0"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Vector Singlet", "Section",
 CellChangeTimes->{{3.759472462715425*^9, 3.7594724703715563`*^9}, {
  3.7594740772772512`*^9, 3.759474077869609*^9}, {3.7802024533288593`*^9, 
  3.780202454160181*^9}},ExpressionUUID->"fd0d9fc1-1118-42d7-b6c7-\
d3c25301fc25"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", "here", "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"LoadModel", "[", " ", 
     RowBox[{
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/SM.fr\>\""}], ",", 
      "\"\<VectorSinglet.fr\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LoadRestriction", "[", 
     RowBox[{"\"\<DiagonalNP.rst\>\"", ",", 
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/DiagonalCKM.rst\>\""}], 
      ",", 
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/Massless.rst\>\""}], 
      ",", "\"\<NozRzL.rst\>\""}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.759473357442108*^9, 3.759473357661347*^9}, {
  3.7594740850493803`*^9, 3.759474085611158*^9}, {3.7802024273856564`*^9, 
  3.7802024409768972`*^9}, {3.780202496120973*^9, 3.780202498504401*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"5365947e-825e-4504-a80b-af158120802b"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{3.823318753282078*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"ebd0e264-ef9a-4bdb-97e9-dc160b9701e7"],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.823318753288423*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"9b61e05c-84e3-48f4-8be8-90d43ca68188"],

Cell[BoxData["\<\"Luc Darme\"\>"], "Print",
 CellChangeTimes->{3.823318753290635*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"bdc9d978-1637-457d-928e-7dcd03117355"],

Cell[BoxData["\<\"Benjamin Fuks\"\>"], "Print",
 CellChangeTimes->{3.823318753291913*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"3a35dc99-07e8-4e70-8196-99793c79dfb6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1\"\>"}],
  SequenceForm["Model Version: ", "1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.823318753293131*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"effe9432-1828-445b-9f46-ab1b0047af43"],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{3.823318753294714*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"e921a149-0d4d-4576-8722-9717b76e2dd5"],

Cell[BoxData["\<\"xxx\"\>"], "Print",
 CellChangeTimes->{3.8233187532960777`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"ee853602-e349-476a-bb34-0269ba8b4a54"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.823318753297255*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"97f70ebb-f080-4fb2-b6ab-5fba47af0327"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.8233187532985764`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"9b4efad1-b6b2-4bd2-877b-802329901dec"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.8233187532997723`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"6a73b97f-2164-4108-87ef-f0be9fe866c7"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.8233187533896627`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"8e6a8f66-eb72-4892-bcaf-f4949e2b0fba"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.823318753393568*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"b65509b4-e0c6-4e19-8408-366bbee101c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"SingletVector\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "SingletVector", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.82331875345014*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"59504c84-5166-4fd7-8e26-fb4980a7cf4b"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Get", "noopen", 
   "\"Cannot open \
\\!\\(\\*RowBox[{\\\"\\\\\\\"DiagonalNP.rst\\\\\\\"\\\"}]\\).\"", 2, 6, 1, 
   32130036197582639269, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.782570274223468*^9, 3.7825702827362947`*^9}, 
   3.823318753472458*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"920488ac-3ec0-41cf-aea0-9ab4aeb2b594"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"DiagonalNP.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "0"}],
  SequenceForm["Loading restrictions from ", "DiagonalNP.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.8233187541986732`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"0a896c7c-9245-459a-a4e5-f23846270ba2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/luc/Computing/feynrules-current/Models/SM/DiagonalCKM.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm[
  "Loading restrictions from ", 
   "/Users/luc/Computing/feynrules-current/Models/SM/DiagonalCKM.rst", " : ", 
   
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.823318754405246*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"1e7c0822-fbe5-49f3-a792-c96388f50de3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/luc/Computing/feynrules-current/Models/SM/Massless.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18"}],
  SequenceForm[
  "Loading restrictions from ", 
   "/Users/luc/Computing/feynrules-current/Models/SM/Massless.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{3.823318754664527*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"35826a8f-3d39-427f-904a-7af3999037cc"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Get", "noopen", 
   "\"Cannot open \
\\!\\(\\*RowBox[{\\\"\\\\\\\"NozRzL.rst\\\\\\\"\\\"}]\\).\"", 2, 6, 2, 
   32130036197582639269, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.782570274223468*^9, 3.7825702827362947`*^9}, 
   3.823318754818907*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"21346090-5053-42a9-bfb6-8607529bb55a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"NozRzL.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18"}],
  SequenceForm["Loading restrictions from ", "NozRzL.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{3.823318754932173*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"5f086361-18cc-46ca-a7a1-fd8ce633dde7"],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{3.823318755068775*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"c3e57168-e6a7-42e9-96a1-b2a9d6cf1233"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  
  RowBox[{"(*", 
   RowBox[{
   "Checking", " ", "the", " ", "hermiticity", " ", "of", " ", "the", " ", 
    "model"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"CheckMassSpectrum", "[", "LagNP", "]"}], "\[IndentingNewLine]", 
   RowBox[{"CheckHermiticity", "[", "LagNP", "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Feynman", " ", "rules"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"vertices", "=", 
    RowBox[{"FeynmanRules", "[", "LagNP", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Getting", " ", "decays"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"decays", "=", 
     RowBox[{"ComputeWidths", "[", "vertices", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Getting", " ", "UFO"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"WriteUFO", "[", 
    RowBox[{
     RowBox[{"LSM", "+", "LagNP"}], ",", 
     RowBox[{"Output", "\[Rule]", "\"\<VectorSinglet_UFO\>\""}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7594723247858057`*^9, 3.7594724349408712`*^9}, 
   3.759472503253831*^9, {3.75947256827782*^9, 3.759472569743855*^9}, {
   3.759472916998436*^9, 3.7594729172534723`*^9}, {3.7594732513207397`*^9, 
   3.759473276459257*^9}, {3.759473397881085*^9, 3.759473420215959*^9}, {
   3.75947351737363*^9, 3.759473518066074*^9}, {3.759474092352673*^9, 
   3.7594740929439583`*^9}, {3.780202504792794*^9, 3.780202505712256*^9}, {
   3.7806465148732557`*^9, 3.7806465184432364`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"5dbe612a-8462-40c9-ab92-916fc215482e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318758794973*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"39210ba9-d89e-4815-a26a-ed7e1e412f41"],

Cell[BoxData["\<\"All mass terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318758797369*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"77d62e4d-bd29-44b1-9e6b-b91e8c505287"],

Cell[BoxData["\<\"Getting mass spectrum.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318758844398*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"6c9d2813-f14f-4a0b-846a-6eae8ec18507"],

Cell[BoxData["\<\"Checking for less then 0.1% agreement with model file \
values.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318758845882*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"959f8d84-ef60-4add-b3d3-b7792e026df2"]
}, Open  ]],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Particle\"\>", "\<\"Analytic value\"\>", "\<\"Numerical value\"\>", \
"\<\"Model-file value\"\>"},
    {"Zp", 
     SqrtBox[
      SuperscriptBox["MZp", "2"]], "3000.`", "3000.`"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.759472487149548*^9, {3.759472548279285*^9, 3.759472575800432*^9}, 
   3.75947307066348*^9, 3.759473286055393*^9, 3.7594734306190653`*^9, 
   3.759474184074905*^9, 3.759474309300272*^9, 3.759474496372921*^9, 
   3.7802025475917587`*^9, 3.780203020575611*^9, 3.780203104590867*^9, 
   3.780203178957118*^9, 3.780203213156974*^9, 3.78020343582698*^9, {
   3.780203596562427*^9, 3.7802036066410933`*^9}, 3.780203689605217*^9, 
   3.780204018145047*^9, 3.780646519446307*^9, 3.823318758847343*^9},
 CellLabel->
  "Out[7]//TableForm=",ExpressionUUID->"ff9e73fe-d346-4b98-ab49-98d17b50a72b"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318758901207*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"3b8620f4-adcc-4d1a-a217-506ef5eb28be"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.8233187589027348`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"77e15359-6fe7-4165-a675-34d308c2e261"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.8233187590200853`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"138c10c7-dd03-454c-98ce-1265df2b0c77"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318759021366*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"9993a713-0c7e-4272-bcd2-d46b75f8222e"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.82331875902241*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"ff351633-7b8a-4e11-aabd-33f2c9460b4b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318759023431*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"7ffb5f54-048f-4efa-ba47-7c11e83784fa"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.8233187590244007`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"edb50ec4-4339-4e21-a641-42086c822d5e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.759472487149548*^9, {3.759472548279285*^9, 3.759472575800432*^9}, 
   3.75947307066348*^9, 3.759473286055393*^9, 3.7594734306190653`*^9, 
   3.759474184074905*^9, 3.759474309300272*^9, 3.759474496372921*^9, 
   3.7802025475917587`*^9, 3.780203020575611*^9, 3.780203104590867*^9, 
   3.780203178957118*^9, 3.780203213156974*^9, 3.78020343582698*^9, {
   3.780203596562427*^9, 3.7802036066410933`*^9}, 3.780203689605217*^9, 
   3.780204018145047*^9, 3.780646519446307*^9, 3.8233187590253572`*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"e8c0cc40-7a8d-4cea-a2c5-cad210711539"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318759070047*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"b000172d-47c8-4104-bdfe-62cf65390419"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.8233187590718327`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"67d1b322-8cf7-47c7-8c98-199936cd083d"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.8233187591214037`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"9c0de740-76b8-4f85-ad11-9c2c5e40e9ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318759123135*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"3344a3ff-9fb5-40d3-84c2-0edeb8f86925"],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318759150732*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"fa46ce77-08fc-4d22-9fff-b3f3ec85fb1b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        OverscriptBox["t", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "\<\"1L\"\>"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
      SubscriptBox[
       RowBox[{
        TemplateBox[{"\[Gamma]", 
          SubscriptBox["\"\[Mu]\"", "3"]},
         "Superscript"], ".", 
        SubscriptBox["P", "\<\"-\"\>"]}], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "\<\"1R\"\>"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
      SubscriptBox[
       RowBox[{
        TemplateBox[{"\[Gamma]", 
          SubscriptBox["\"\[Mu]\"", "3"]},
         "Superscript"], ".", 
        SubscriptBox["P", "\<\"+\"\>"]}], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.759472487149548*^9, {3.759472548279285*^9, 3.759472575800432*^9}, 
   3.75947307066348*^9, 3.759473286055393*^9, 3.7594734306190653`*^9, 
   3.759474184074905*^9, 3.759474309300272*^9, 3.759474496372921*^9, 
   3.7802025475917587`*^9, 3.780203020575611*^9, 3.780203104590867*^9, 
   3.780203178957118*^9, 3.780203213156974*^9, 3.78020343582698*^9, {
   3.780203596562427*^9, 3.7802036066410933`*^9}, 3.780203689605217*^9, 
   3.780204018145047*^9, 3.780646519446307*^9, 3.823318759152367*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"7c55b269-3f25-4f6c-9a0b-4717617b43fd"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318759182558*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"783047b1-fff5-494f-9d41-f090a109f592"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318759206167*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"cb5be894-4642-4781-9a1f-b294dd49ff6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{7., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318759208599*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"e6f2f1b6-2aa2-4af2-ace7-8286ef2d1967"],

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318761141741*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"b47b1a94-5615-4965-996d-aa583162cda0"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.8233187615082006`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"761afdb2-5f54-4eff-afcd-3f7019da0fad"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318761509591*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"fece93d6-7302-40f8-b032-e80dc1f2ff05"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.8233187615105457`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"4932919d-bb95-4fe3-9ef6-089a5570c005"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318768330495*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"c9762aed-a7e3-4046-948e-c20448fbd33e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "99", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "99", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  99, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 99, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318768368683*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"516e01c3-f29a-4623-b031-def23e5c8107"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"94", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[94, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318772067853*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"c7a25ab4-fe9f-4e0f-af1a-c1a835a9632d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "94"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 2, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 94],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.8233187741506453`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"dafcdc3a-8d6a-4879-85a9-08466b0fdd7c"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.8233187808042383`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"5482cd84-d081-44a4-9f4a-12938115be80"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318780823444*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"9e3fe13f-1ca4-4f05-a0be-08c5019f9898"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "41"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 41],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318780868264*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"9262a527-4e61-40b0-bf43-be3fa77f967e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "1.633519`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 1.633519, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318787602674*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"a476ecbf-97b5-4ef1-bac1-dd6c24d90b09"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Decay", "Overwrite", "\"Warning: Previous results will be overwritten.\"", 
   2, 11, 3, 32130036197582639269, "Local", "FeynRules`Decay"},
  "MessageTemplate2"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{
  3.759472574381403*^9, 3.759473066224372*^9, 3.759473329756282*^9, 
   3.7594734356524353`*^9, 3.759474183591339*^9, 3.759474308801608*^9, 
   3.7594745283499393`*^9, 3.7802025478581247`*^9, 3.7802030373072643`*^9, 
   3.7802031213484364`*^9, 3.7802031958430347`*^9, 3.7802032296914053`*^9, 
   3.780203436433041*^9, {3.7802035964643373`*^9, 3.780203607241201*^9}, 
   3.780203690202548*^9, 3.780204039595866*^9, 3.780646537987451*^9, 
   3.823318787621656*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"3c976cd1-a65f-4f95-affb-cd5eb7f2c7c5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.014955`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 0.014955, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.8233187876330442`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"154b17dc-f380-4a51-9360-6b9f213ce8c8"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.8233187876356916`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"6017ed2f-2f7d-404b-afb5-644a16d424ed"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318787723412*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"e5c02566-af88-45ec-ba71-a61d23e352e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.8233187877448673`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"39fe8f78-6f48-4b01-b3df-d89a404649d1"],

Cell[BoxData["\<\"before\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823318789458531*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"9a4959a4-ea21-4fdc-9cbf-588f6cb99cf1"],

Cell[BoxData["\<\"before\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823318789481365*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"787c8cac-09a0-4628-a16c-9bd97e5d71d4"],

Cell[BoxData["\<\"true\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823318789511547*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"0dde040a-41ff-4822-8078-cba3cee60ada"],

Cell[BoxData["\<\"true\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823318789528576*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"b90a6596-5bd1-49a9-ba53-4c274fbdf25b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "120", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 120, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.8233187896710873`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"cb0c68b8-5dce-4df2-aec1-625eba3e071c"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.8233187897591057`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"62433847-18d4-4946-9e0c-31f09dfb2fd2"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.780202547332205*^9, 3.780203020335136*^9, 3.780203104354333*^9, 
   3.780203178720705*^9, 3.780203212913603*^9, 3.780203435632289*^9, {
   3.780203596456085*^9, 3.780203606446967*^9}, 3.7802036894220057`*^9, 
   3.780204017936602*^9, 3.7806465193651333`*^9, 3.823318789862146*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"5a4e4df2-5945-4a6a-96c5-16ae8c2195b7"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Vector Octet ", "Section",
 CellChangeTimes->{{3.759472462715425*^9, 3.7594724703715563`*^9}, {
  3.7594740772772512`*^9, 3.759474077869609*^9}, {3.7802024575047398`*^9, 
  3.780202461391922*^9}},ExpressionUUID->"53ecbd33-5272-492c-852c-\
e5bf1a0b7721"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", "here", "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"LoadModel", "[", " ", 
     RowBox[{
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/SM.fr\>\""}], ",", 
      "\"\<VectorOctet.fr\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LoadRestriction", "[", 
     RowBox[{"\"\<DiagonalNP.rst\>\"", ",", 
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/DiagonalCKM.rst\>\""}], 
      ",", 
      RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/Massless.rst\>\""}], 
      ",", "\"\<NozRzL.rst\>\""}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.759473357442108*^9, 3.759473357661347*^9}, {
  3.7594740850493803`*^9, 3.759474085611158*^9}, {3.7802024273856564`*^9, 
  3.7802024409768972`*^9}, {3.780202523193082*^9, 3.780202527072501*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"28c116c0-1f9f-4f2c-8abc-26a8e636817b"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.7802041450711203`*^9, 3.780641324784424*^9, 
  3.780641466131731*^9, 3.7806462133788767`*^9, 3.7806462901581*^9, 
  3.79354898730926*^9, 3.823318813850049*^9, 3.823321172166622*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"85797c99-afef-436b-b980-1d6f6a594d8f"],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.7802041450711203`*^9, 3.780641324784424*^9, 
  3.780641466131731*^9, 3.7806462133788767`*^9, 3.7806462901581*^9, 
  3.79354898730926*^9, 3.823318813850049*^9, 3.823321172173015*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"95e243a0-ab98-4f77-ae85-d1ec030c90ed"],

Cell[BoxData["\<\"Luc Darme\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.7802041450711203`*^9, 3.780641324784424*^9, 
  3.780641466131731*^9, 3.7806462133788767`*^9, 3.7806462901581*^9, 
  3.79354898730926*^9, 3.823318813850049*^9, 3.823321172175037*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"ee1b636b-3469-4f35-8c6c-c47bc9007959"],

Cell[BoxData["\<\"Benjamin Fuks\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.7802041450711203`*^9, 3.780641324784424*^9, 
  3.780641466131731*^9, 3.7806462133788767`*^9, 3.7806462901581*^9, 
  3.79354898730926*^9, 3.823318813850049*^9, 3.8233211721762333`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"3ccf1f11-8901-4292-8204-4898f76a63e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1\"\>"}],
  SequenceForm["Model Version: ", "1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.7802041450711203`*^9, 3.780641324784424*^9, 
  3.780641466131731*^9, 3.7806462133788767`*^9, 3.7806462901581*^9, 
  3.79354898730926*^9, 3.823318813850049*^9, 3.8233211721776876`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"29770907-bc6b-4e2a-a929-b058506d1eec"],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.7802041450711203`*^9, 3.780641324784424*^9, 
  3.780641466131731*^9, 3.7806462133788767`*^9, 3.7806462901581*^9, 
  3.79354898730926*^9, 3.823318813850049*^9, 3.8233211721788607`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"52282be9-1018-4d84-b5e0-671859252ced"],

Cell[BoxData["\<\"xxx\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.7802041450711203`*^9, 3.780641324784424*^9, 
  3.780641466131731*^9, 3.7806462133788767`*^9, 3.7806462901581*^9, 
  3.79354898730926*^9, 3.823318813850049*^9, 3.823321172179901*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"a11677c5-6678-4f99-b636-3e4e863f12ed"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.7802041450711203`*^9, 3.780641324784424*^9, 
  3.780641466131731*^9, 3.7806462133788767`*^9, 3.7806462901581*^9, 
  3.79354898730926*^9, 3.823318813850049*^9, 3.8233211721808863`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"1933dce5-a6ee-4b76-a991-4c7f8ea22886"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.7802041450711203`*^9, 3.780641324784424*^9, 
  3.780641466131731*^9, 3.7806462133788767`*^9, 3.7806462901581*^9, 
  3.79354898730926*^9, 3.823318813850049*^9, 3.82332117218188*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"12956392-089e-4615-8579-1d1a092afe02"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.7802041450711203`*^9, 3.780641324784424*^9, 
  3.780641466131731*^9, 3.7806462133788767`*^9, 3.7806462901581*^9, 
  3.79354898730926*^9, 3.823318813850049*^9, 3.8233211721829147`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"546ac6e8-7e23-44b4-a649-b393fb1210d6"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.7802041450711203`*^9, 3.780641324784424*^9, 
  3.780641466131731*^9, 3.7806462133788767`*^9, 3.7806462901581*^9, 
  3.79354898730926*^9, 3.823318813850049*^9, 3.823321172272314*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"75241964-576a-4faf-a857-0c011bdba2d2"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.7802041450711203`*^9, 3.780641324784424*^9, 
  3.780641466131731*^9, 3.7806462133788767`*^9, 3.7806462901581*^9, 
  3.79354898730926*^9, 3.823318813850049*^9, 3.823321172276301*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"e971b67c-8225-49ba-b191-dfa45392d032"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"ColoredVector\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "ColoredVector", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.7802041450711203`*^9, 3.780641324784424*^9, 
  3.780641466131731*^9, 3.7806462133788767`*^9, 3.7806462901581*^9, 
  3.79354898730926*^9, 3.823318813850049*^9, 3.823321172333736*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"18664c6b-357d-4342-9104-8bb454361735"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Get", "noopen", 
   "\"Cannot open \
\\!\\(\\*RowBox[{\\\"\\\\\\\"DiagonalNP.rst\\\\\\\"\\\"}]\\).\"", 2, 6, 1, 
   32130052057607472547, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823318814044794*^9, 3.823321172360506*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"43500c43-05bd-4774-a154-19ea36644ac2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"DiagonalNP.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{209., {2., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "0"}],
  SequenceForm["Loading restrictions from ", "DiagonalNP.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.7802041450711203`*^9, 3.780641324784424*^9, 
  3.780641466131731*^9, 3.7806462133788767`*^9, 3.7806462901581*^9, 
  3.79354898730926*^9, 3.823318813850049*^9, 3.8233211730730658`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"1bac0ca5-6dea-4116-88f0-e8ebf4cbd88f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/luc/Computing/feynrules-current/Models/SM/DiagonalCKM.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{209., {2., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm[
  "Loading restrictions from ", 
   "/Users/luc/Computing/feynrules-current/Models/SM/DiagonalCKM.rst", " : ", 
   
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.7802041450711203`*^9, 3.780641324784424*^9, 
  3.780641466131731*^9, 3.7806462133788767`*^9, 3.7806462901581*^9, 
  3.79354898730926*^9, 3.823318813850049*^9, 3.823321173268299*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"23772da3-20bb-49a3-9791-c8e46321efca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/luc/Computing/feynrules-current/Models/SM/Massless.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18"}],
  SequenceForm[
  "Loading restrictions from ", 
   "/Users/luc/Computing/feynrules-current/Models/SM/Massless.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.7802041450711203`*^9, 3.780641324784424*^9, 
  3.780641466131731*^9, 3.7806462133788767`*^9, 3.7806462901581*^9, 
  3.79354898730926*^9, 3.823318813850049*^9, 3.823321173480298*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"535ff223-c7c1-47a2-a6fb-1c9ae3c88d71"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Get", "noopen", 
   "\"Cannot open \
\\!\\(\\*RowBox[{\\\"\\\\\\\"NozRzL.rst\\\\\\\"\\\"}]\\).\"", 2, 6, 2, 
   32130052057607472547, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823318814044794*^9, 3.82332117363945*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"c7107f3f-28a6-4663-98b0-84bfeae00026"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"NozRzL.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18"}],
  SequenceForm["Loading restrictions from ", "NozRzL.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.7802041450711203`*^9, 3.780641324784424*^9, 
  3.780641466131731*^9, 3.7806462133788767`*^9, 3.7806462901581*^9, 
  3.79354898730926*^9, 3.823318813850049*^9, 3.823321173730371*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"38865933-390c-4507-856c-a5e8e928536f"],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{3.759474176281584*^9, 3.759474304634947*^9, 
  3.7594744883064213`*^9, 3.7802041450711203`*^9, 3.780641324784424*^9, 
  3.780641466131731*^9, 3.7806462133788767`*^9, 3.7806462901581*^9, 
  3.79354898730926*^9, 3.823318813850049*^9, 3.823321173861953*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"863cf9a0-ab96-4358-b0d0-9c6d8eec3648"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  
  RowBox[{"(*", 
   RowBox[{
   "Checking", " ", "the", " ", "hermiticity", " ", "of", " ", "the", " ", 
    "model"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"CheckMassSpectrum", "[", "LagNP", "]"}], "\[IndentingNewLine]", 
   RowBox[{"CheckHermiticity", "[", "LagNP", "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Feynman", " ", "rules"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"vertices", "=", 
    RowBox[{"FeynmanRules", "[", "LagNP", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Getting", " ", "decays"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"decays", "=", 
     RowBox[{"ComputeWidths", "[", "vertices", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Getting", " ", "UFO"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"WriteUFO", "[", 
    RowBox[{
     RowBox[{"LSM", "+", "LagNP"}], ",", 
     RowBox[{"Output", "\[Rule]", "\"\<VectorOctet_UFO\>\""}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7594723247858057`*^9, 3.7594724349408712`*^9}, 
   3.759472503253831*^9, {3.75947256827782*^9, 3.759472569743855*^9}, {
   3.759472916998436*^9, 3.7594729172534723`*^9}, {3.7594732513207397`*^9, 
   3.759473276459257*^9}, {3.759473397881085*^9, 3.759473420215959*^9}, {
   3.75947351737363*^9, 3.759473518066074*^9}, {3.759474092352673*^9, 
   3.7594740929439583`*^9}, {3.7802025333695717`*^9, 3.780202535680215*^9}, {
   3.7806461838178673`*^9, 3.780646183997946*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"ada2b80e-48de-4ea4-8904-96bb6ce4269d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321182661729*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"60ca7edb-f541-45d3-a4f4-a0581683fe01"],

Cell[BoxData["\<\"All mass terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321182663863*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"30eff751-e4cb-4753-b127-3bf15542108f"],

Cell[BoxData["\<\"Getting mass spectrum.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321182784452*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"17fc9198-c2a4-42ed-8bef-afd924385c55"],

Cell[BoxData["\<\"Checking for less then 0.1% agreement with model file \
values.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321182786417*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"3a069a5b-10fe-427f-b76e-e78784455ab5"]
}, Open  ]],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Particle\"\>", "\<\"Analytic value\"\>", "\<\"Numerical value\"\>", \
"\<\"Model-file value\"\>"},
    {"Vo", 
     SqrtBox[
      SuperscriptBox["MVo", "2"]], "3000.`", "3000.`"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.759472487149548*^9, {3.759472548279285*^9, 3.759472575800432*^9}, 
   3.75947307066348*^9, 3.759473286055393*^9, 3.7594734306190653`*^9, 
   3.759474184074905*^9, 3.759474309300272*^9, 3.759474496372921*^9, 
   3.7802041490401077`*^9, 3.780641330330078*^9, 3.7806414692896547`*^9, 
   3.780646222071496*^9, 3.7806462971590147`*^9, 3.793548992324049*^9, 
   3.823318816364933*^9, 3.823321182788642*^9},
 CellLabel->
  "Out[7]//TableForm=",ExpressionUUID->"8ef8e7a9-56ee-4427-b0df-d5abfd004bab"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321182921542*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"3abcec94-6ea2-49a7-8449-0bafb455cce5"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321182923235*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"af6a461b-3939-492b-8b91-ade91cf6bf9c"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321183262361*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"e26c5907-a82f-4fc8-b164-a63b2efb9bc1"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321183263968*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"3e56152b-e697-49fe-8e43-6a8d9a48a0d5"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321183265332*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"25f78555-40ab-475f-991a-727683732769"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321183266581*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"9009ffd9-f7dc-4d7c-9e73-fa271e58ef90"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.82332118326779*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"fa5e68f8-6e71-43d4-9a2b-a3092966ad9a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.759472487149548*^9, {3.759472548279285*^9, 3.759472575800432*^9}, 
   3.75947307066348*^9, 3.759473286055393*^9, 3.7594734306190653`*^9, 
   3.759474184074905*^9, 3.759474309300272*^9, 3.759474496372921*^9, 
   3.7802041490401077`*^9, 3.780641330330078*^9, 3.7806414692896547`*^9, 
   3.780646222071496*^9, 3.7806462971590147`*^9, 3.793548992324049*^9, 
   3.823318816364933*^9, 3.82332118326898*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"fe6c443d-05c2-478f-9468-2e0003df89fd"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321183396948*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"00a6be77-ac2a-47ff-90b5-81595f769e8d"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.8233211833984957`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"7544f856-0d3a-4483-851c-08669063a7c8"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321183533587*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"9af6e530-e70c-4fbd-9772-fdd9ba2d37d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "3", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  3, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 3, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.8233211835375853`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"2694cb2b-8fc5-4b8b-93c4-64ed18de3872"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[3, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.8233211837594748`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"2572328d-4c0d-4324-8812-05d0205bafd3"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Vo", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Vo", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Vo", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Vo", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["t", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Vo", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "\<\"8L\"\>"], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}], 
        SubscriptBox["\<\"a\"\>", "3"]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "\<\"8R\"\>"], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}], 
        SubscriptBox["\<\"a\"\>", "3"]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.759472487149548*^9, {3.759472548279285*^9, 3.759472575800432*^9}, 
   3.75947307066348*^9, 3.759473286055393*^9, 3.7594734306190653`*^9, 
   3.759474184074905*^9, 3.759474309300272*^9, 3.759474496372921*^9, 
   3.7802041490401077`*^9, 3.780641330330078*^9, 3.7806414692896547`*^9, 
   3.780646222071496*^9, 3.7806462971590147`*^9, 3.793548992324049*^9, 
   3.823318816364933*^9, 3.823321183762224*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"0ce58716-9b82-46fd-a390-5f3c300753aa"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{7., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321183838229*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"20b95ae6-9032-4b09-892b-67594c12dd2c"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.8233211838848352`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"a465d649-d0f3-4ce3-a1f6-1645bd2262b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{7., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321183888386*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f0cf56c5-404c-4ef0-93b4-e21f43c83d44"],

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321185801382*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"6c7ec2e9-43a8-4cce-8726-5d51e9cb5d16"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321186216734*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"68559266-de35-46c3-8d2b-4c214867b292"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321186218287*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"04e965aa-3cb8-47ac-a1c1-f38179f5ccad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.8233211862193203`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"b58c3a8f-7910-4ce4-81d4-33bca008bd1c"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.8233211933572083`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f29867e0-e4c0-4e87-9f46-e8961c88a775"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "101", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "101", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  101, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 101, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321193408105*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"36a20ce5-bb81-4082-ae00-06115a9ff8cf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"96", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[96, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321197413999*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"45f3035d-3f4e-4487-9929-d78b7a382970"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "96"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 2, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 96],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321199498555*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"1d19f595-890e-4127-84e6-1f17a16894fd"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.8233212059408703`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"0e9481d3-3a08-4256-a0fa-0e22c1877880"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321205961521*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"17810a74-f64f-4a52-904d-d99b6aa08c29"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "41"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 41],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321206012177*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"6bfc4ad6-449c-470d-97d7-3ae3b5c764ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "1.623191`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 1.623191, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321212786232*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"957a7ba8-f247-4691-8d68-9ebca5704951"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Decay", "Overwrite", "\"Warning: Previous results will be overwritten.\"", 
   2, 11, 3, 32130052057607472547, "Local", "FeynRules`Decay"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.780646315519334*^9, 3.793549024417037*^9, 
  3.82331884623835*^9, 3.823321212812614*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"777d77dc-1a04-48ff-a6a8-957a4d701dc4"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.015368`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 0.015368, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.8233212128204737`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"c0670a75-1122-4f99-aa7c-bd0371916922"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321212821978*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"b75e6f93-b37b-4276-b1a9-1bf0e585de78"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321212913818*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"c4bab9a9-1432-4b17-afad-b3e0bed156c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.8233212129441557`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"26e020ab-ef72-4338-8d2e-73588791c498"],

Cell[BoxData["\<\"before\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823321214692285*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"dd277b44-ee19-4bd8-96b8-7649e477f036"],

Cell[BoxData["\<\"before\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823321214717079*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"e9d6d0ed-0bd0-42dd-bcc7-fafc6931bbe7"],

Cell[BoxData["\<\"true\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823321214775916*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"2719f187-7768-4195-8b59-abb64ddb2a94"],

Cell[BoxData["\<\"true\"\>"], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.823321214795871*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"d62e7e14-fbd0-426d-b901-44367b6f5b01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "122", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 122, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321214980999*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"3be7425b-beb9-44e3-a5ed-80013c789199"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.823321215087007*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"c6a34b83-8ccf-492b-b7ab-3d297e88f6c7"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{{3.759472546860662*^9, 3.7594725758553143`*^9}, 
   3.7594730661954308`*^9, 3.759473284825961*^9, 3.759473429361281*^9, 
   3.759474183804118*^9, 3.759474309011127*^9, 3.759474496097642*^9, 
   3.7802041488040752`*^9, 3.7806413302733603`*^9, 3.78064146921642*^9, 
   3.780646222005781*^9, 3.780646297080798*^9, 3.793548992182836*^9, 
   3.823318816238668*^9, 3.8233212152049103`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"cd04bdb0-a386-40ac-9f77-a4305dc68aef"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "*", 
  RowBox[{"Pi", "/", "180."}]}]], "Input",
 CellChangeTimes->{{3.793610307845633*^9, 3.793610320673718*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"9b3e8b3f-1e6b-480c-8d31-b0341a561a01"],

Cell[BoxData[
 FormBox["0.03490658503988659`", TraditionalForm]], "Output",
 CellChangeTimes->{{3.7936103177433167`*^9, 3.7936103210591993`*^9}},
 CellLabel->"Out[13]=",ExpressionUUID->"11883441-ee12-4ae9-93a9-33ef38fea381"]
}, Open  ]]
}, Closed]]
},
WindowSize->{1220, 650},
WindowMargins->{{Automatic, 97}, {Automatic, 51}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> True}},
ShowSelection->True,
FrontEndVersion->"11.3 for Mac OS X x86 (32-bit, 64-bit Kernel) (March 5, \
2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[400, 13, 135, 3, 31, "Input",ExpressionUUID->"fdccdbba-01c0-464f-bb10-b61e7821bc9f"],
Cell[CellGroupData[{
Cell[560, 20, 849, 15, 70, "Input",ExpressionUUID->"da06996d-8dd9-43cf-ab0a-fc63da679325"],
Cell[CellGroupData[{
Cell[1434, 39, 426, 7, 24, "Print",ExpressionUUID->"f0055f3c-041e-4825-8498-2737d1944f4d"],
Cell[1863, 48, 707, 14, 24, "Print",ExpressionUUID->"ac6f7fea-8ea2-4ea5-ae9b-bf6b2b587650"],
Cell[2573, 64, 474, 8, 24, "Print",ExpressionUUID->"6ccaee93-bfde-4434-b058-69b44b14d86a"],
Cell[3050, 74, 412, 7, 24, "Print",ExpressionUUID->"a3b907c5-3e6d-4d6b-a4fc-eba5daebf7ad"],
Cell[3465, 83, 421, 7, 24, "Print",ExpressionUUID->"7f0cefcb-a6fe-46a9-96e5-a0e46d7126f6"],
Cell[3889, 92, 472, 8, 24, "Print",ExpressionUUID->"5ab7995d-5400-4b6a-8bb8-ae2afbe76837"],
Cell[4364, 102, 475, 8, 24, "Print",ExpressionUUID->"f326405f-85f9-4ebc-9d5d-aa6de9562eff"],
Cell[4842, 112, 410, 7, 24, "Print",ExpressionUUID->"f755f5d8-5ddd-425d-9e53-d1bde84e61cd"],
Cell[5255, 121, 442, 7, 24, "Print",ExpressionUUID->"4a147ace-87fc-471f-9a46-041aa04f5e4e"],
Cell[5700, 130, 412, 7, 24, "Print",ExpressionUUID->"59f64a11-e010-4a52-9c4d-417844273108"],
Cell[6115, 139, 479, 8, 24, "Print",ExpressionUUID->"254490e2-2258-4a76-a9f0-3cf65f285cc0"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6643, 153, 310, 5, 68, "Section",ExpressionUUID->"b3481f82-8d60-422a-96f3-b2a3114db2fa"],
Cell[CellGroupData[{
Cell[6978, 162, 1224, 25, 89, "Input",ExpressionUUID->"a151022a-73a9-4c71-aefa-0f58c7755135"],
Cell[CellGroupData[{
Cell[8227, 191, 797, 12, 24, "Print",ExpressionUUID->"95778f43-7167-45e5-9140-e7dd5e9ee053"],
Cell[9027, 205, 813, 12, 24, "Print",ExpressionUUID->"01c4a01b-c595-4038-94ce-b141928d71b3"],
Cell[9843, 219, 782, 12, 24, "Print",ExpressionUUID->"0752f219-72bb-4993-8c87-006bcdce98e2"],
Cell[10628, 233, 919, 16, 24, "Print",ExpressionUUID->"0912417c-4b5d-43b1-b755-a8df303586c7"],
Cell[11550, 251, 821, 13, 24, "Print",ExpressionUUID->"4dd1bbb4-d053-48e9-983c-008093dcd906"],
Cell[12374, 266, 775, 12, 24, "Print",ExpressionUUID->"33b664d7-1b54-4d25-8491-d28c523061ae"],
Cell[13152, 280, 805, 12, 24, "Print",ExpressionUUID->"54564307-24e5-41dc-a375-0182d87750fa"],
Cell[13960, 294, 806, 12, 24, "Print",ExpressionUUID->"0ce0f80b-f338-4ee4-8fb1-dfd032c7311e"],
Cell[14769, 308, 804, 12, 24, "Print",ExpressionUUID->"ddfdffd8-df1f-4fc9-9f98-cca03cd8d3f1"],
Cell[15576, 322, 973, 17, 44, "Print",ExpressionUUID->"95846e63-1a81-4ed5-8268-490959a8b65a"]
}, Open  ]],
Cell[16564, 342, 366, 10, 24, "Message",ExpressionUUID->"c6cd31cb-9d7b-4b45-868e-9a40799a2971"],
Cell[CellGroupData[{
Cell[16955, 356, 1262, 22, 24, "Print",ExpressionUUID->"d6ef5676-e193-492b-9d0c-aa5b755d815f"],
Cell[18220, 380, 1375, 26, 24, "Print",ExpressionUUID->"f99c06cd-5ebb-4c9c-9457-e0cb39f2274c"],
Cell[19598, 408, 1367, 25, 24, "Print",ExpressionUUID->"2e7659b5-e10e-4951-b1c4-9d633d0b5ee0"]
}, Open  ]],
Cell[20980, 436, 362, 10, 24, "Message",ExpressionUUID->"0f0c88f7-1899-436d-afc2-0fa249eeba3c"],
Cell[CellGroupData[{
Cell[21367, 450, 1257, 22, 24, "Print",ExpressionUUID->"64395f5b-2afb-4ea0-b9b8-7cc3eb24ff1f"],
Cell[22627, 474, 793, 12, 24, "Print",ExpressionUUID->"9ff08b4b-8cbe-49e5-afba-15e4ac071b2b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23469, 492, 1921, 38, 241, "Input",ExpressionUUID->"03056f62-69bb-4c71-aee4-bbee43698579"],
Cell[CellGroupData[{
Cell[25415, 534, 1336, 23, 24, "Print",ExpressionUUID->"fbb8926c-b7bb-4fc9-b48c-75bef0b55969"],
Cell[26754, 559, 1105, 17, 24, "Print",ExpressionUUID->"34b5ea81-1d48-4051-8e98-ac97560398af"],
Cell[27862, 578, 1168, 18, 24, "Print",ExpressionUUID->"523f8146-21c0-4137-946a-4ddbddce8a40"],
Cell[29033, 598, 1161, 18, 24, "Print",ExpressionUUID->"aeeb5020-77c8-4f2f-81a5-47b829f22d5b"],
Cell[30197, 618, 1357, 25, 24, "Print",ExpressionUUID->"b3bf5f67-ab7c-4320-befd-1fd1f2179d04"],
Cell[31557, 645, 1112, 17, 24, "Print",ExpressionUUID->"0627a51a-82ed-421e-9566-988135b78710"],
Cell[32672, 664, 1103, 17, 24, "Print",ExpressionUUID->"1ee17a3b-2080-45e6-9e59-70313e158549"],
Cell[33778, 683, 1225, 21, 24, "Print",ExpressionUUID->"ffc68ecd-9948-4b2b-9216-2018aa78063c"],
Cell[35006, 706, 1113, 17, 24, "Print",ExpressionUUID->"eb622903-ca0e-43fe-a842-9dda1637d536"]
}, Open  ]],
Cell[36134, 726, 1101, 17, 31, "Output",ExpressionUUID->"69b546e8-797c-4853-9f69-3d9cb3d0b809"],
Cell[CellGroupData[{
Cell[37260, 747, 1357, 25, 24, "Print",ExpressionUUID->"93979763-f709-4c8d-a3d5-000bf40c282b"],
Cell[38620, 774, 1112, 17, 24, "Print",ExpressionUUID->"3f2cdcdb-23a8-4a71-a107-fd4dee71a386"],
Cell[39735, 793, 1147, 18, 24, "Print",ExpressionUUID->"a6cfe812-a410-4164-a0ba-828ee81ccd3c"],
Cell[40885, 813, 1621, 29, 24, "Print",ExpressionUUID->"6d2b45b5-a06a-477d-9a57-ac8c3d104165"],
Cell[42509, 844, 1103, 17, 24, "Print",ExpressionUUID->"c7cfa345-0f45-4172-a9de-13798cd87cb8"]
}, Open  ]],
Cell[43627, 864, 20922, 581, 354, "Output",ExpressionUUID->"cee74966-eddc-4886-b341-a830beb25fff"],
Cell[CellGroupData[{
Cell[64574, 1449, 1454, 25, 24, "Print",ExpressionUUID->"6709e98f-b023-4100-812a-03fbdbcb992c"],
Cell[66031, 1476, 1393, 26, 24, "Print",ExpressionUUID->"57b3a797-0742-4593-96e3-8704eb937ef4"],
Cell[67427, 1504, 1363, 25, 24, "Print",ExpressionUUID->"7fcdf6bc-b740-4e1c-9198-555afb6674cc"],
Cell[68793, 1531, 1134, 18, 24, "Print",ExpressionUUID->"cd8b1073-26d3-430c-97bd-bfbffd6359f3"],
Cell[69930, 1551, 1357, 25, 24, "Print",ExpressionUUID->"2246c720-879a-4ea9-a2f3-6ba5703bb56c"],
Cell[71290, 1578, 1112, 17, 24, "Print",ExpressionUUID->"39955d8f-c7e7-4d4d-9700-e78881dbd766"],
Cell[72405, 1597, 1293, 22, 24, "Print",ExpressionUUID->"ba2eaa1a-d79c-4c6a-96c5-c9b13bd4291a"],
Cell[73701, 1621, 1145, 18, 24, "Print",ExpressionUUID->"370169cf-defd-498d-9f3c-6633d1da92d8"],
Cell[74849, 1641, 1626, 29, 24, "Print",ExpressionUUID->"51fd19c8-77c4-4e69-90ca-153ad9b091e3"],
Cell[76478, 1672, 1227, 21, 24, "Print",ExpressionUUID->"5905b044-a0cf-403f-8151-3e2482819230"],
Cell[77708, 1695, 1581, 28, 24, "Print",ExpressionUUID->"fbfd73d5-0968-4bdd-9f20-dee58fd0c4a5"],
Cell[79292, 1725, 1128, 17, 24, "Print",ExpressionUUID->"dc6a1bc6-6003-4aa0-bac0-50dd9bfdf533"],
Cell[80423, 1744, 1393, 26, 24, "Print",ExpressionUUID->"121561c0-5b80-44e1-adf9-b7eaeca71fc3"],
Cell[81819, 1772, 1365, 25, 24, "Print",ExpressionUUID->"58a10044-15f6-4fcc-8f05-faa783703f08"],
Cell[83187, 1799, 1325, 22, 24, "Print",ExpressionUUID->"1caf2511-dec0-42f3-a2d9-1d29ed9905f3"],
Cell[84515, 1823, 1311, 22, 24, "Print",ExpressionUUID->"a926d3f6-8cfd-4612-b804-177ef44a9be1"],
Cell[85829, 1847, 1109, 17, 24, "Print",ExpressionUUID->"577f54a4-10e4-4b0f-ba72-31472ba4a06d"],
Cell[86941, 1866, 1358, 25, 24, "Print",ExpressionUUID->"5b5b12ba-4425-40fb-9951-a9eefbae5243"],
Cell[88302, 1893, 1133, 18, 24, "Print",ExpressionUUID->"c20995c8-071d-4699-bf20-cc0849b4ac0f"],
Cell[89438, 1913, 1324, 22, 24, "Print",ExpressionUUID->"e5fe8269-b8f2-4df4-878e-a9ecd9d30a70"],
Cell[90765, 1937, 188, 4, 24, "Print",ExpressionUUID->"b3f05a75-ea77-41e2-9a6b-8686e706ff06"],
Cell[90956, 1943, 188, 4, 24, "Print",ExpressionUUID->"85cce018-9fb0-46b4-8547-d0ac350f18a8"],
Cell[91147, 1949, 186, 4, 24, "Print",ExpressionUUID->"dadf5961-a6db-467e-b163-0cc795cbedc7"],
Cell[91336, 1955, 186, 4, 24, "Print",ExpressionUUID->"f2292f9e-2463-4a5c-9a60-666e9a3a52af"],
Cell[91525, 1961, 1484, 25, 24, "Print",ExpressionUUID->"4f196665-b484-4d78-8b24-847440bccc97"],
Cell[93012, 1988, 1105, 17, 24, "Print",ExpressionUUID->"0eea4daf-4fb9-4129-8161-8e5e6e1ceb73"],
Cell[94120, 2007, 1090, 17, 24, "Print",ExpressionUUID->"2b220bdb-5764-4793-bf68-8514128ebe99"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[95271, 2031, 159, 3, 38, "Section",ExpressionUUID->"2336ad77-5f71-45d3-aa04-279489ef8eca"],
Cell[CellGroupData[{
Cell[95455, 2038, 928, 21, 89, "Input",ExpressionUUID->"6e6925aa-c8eb-43ad-abc2-dacc15d02aaf"],
Cell[CellGroupData[{
Cell[96408, 2063, 444, 8, 24, "Print",ExpressionUUID->"9a62a909-12f2-44a3-8773-93d18c5c2b1d"],
Cell[96855, 2073, 462, 8, 24, "Print",ExpressionUUID->"9ee8e020-a295-44ad-bc6f-d583c01555ce"],
Cell[97320, 2083, 431, 8, 24, "Print",ExpressionUUID->"0442bb81-4467-4c21-ab2f-a336184b17fa"],
Cell[97754, 2093, 437, 8, 24, "Print",ExpressionUUID->"805612bf-1fab-4a52-b88a-e0d6808b0a0d"],
Cell[98194, 2103, 564, 12, 24, "Print",ExpressionUUID->"e6c034fd-bad3-41ac-b676-02e85b74c603"],
Cell[98761, 2117, 433, 8, 24, "Print",ExpressionUUID->"99b5201b-6085-4655-9e01-cad45555542d"],
Cell[99197, 2127, 424, 8, 24, "Print",ExpressionUUID->"c491350f-1df3-4b74-ab28-358cd86c5201"],
Cell[99624, 2137, 470, 9, 24, "Print",ExpressionUUID->"214cbacc-e444-4b72-a7de-425d51690ec8"],
Cell[100097, 2148, 422, 8, 24, "Print",ExpressionUUID->"d7e9ded2-258f-4b20-ba47-aa8275111db1"],
Cell[100522, 2158, 452, 8, 24, "Print",ExpressionUUID->"ea277507-89e8-4bb9-a699-7eee48ce6e92"],
Cell[100977, 2168, 455, 8, 24, "Print",ExpressionUUID->"88730290-de5d-4ed0-9381-e16d63b5ac3a"],
Cell[101435, 2178, 453, 8, 24, "Print",ExpressionUUID->"d0cf44ca-4d37-45c8-abce-19a1ba878421"],
Cell[101891, 2188, 660, 14, 44, "Print",ExpressionUUID->"fbbcf15b-f544-490e-a55c-29942c64c954"]
}, Open  ]],
Cell[102566, 2205, 412, 11, 35, "Message",ExpressionUUID->"2e49b92b-b29f-4f45-ab5a-8d3cc408e5c6"],
Cell[CellGroupData[{
Cell[103003, 2220, 911, 18, 24, "Print",ExpressionUUID->"d8866ed9-a360-4675-b24c-f27a059dbf18"],
Cell[103917, 2240, 1024, 22, 24, "Print",ExpressionUUID->"a7f775eb-8369-4c90-b394-f90b71bb3dbb"],
Cell[104944, 2264, 1015, 21, 24, "Print",ExpressionUUID->"11a70b88-498c-499b-bae9-94ddbb43af81"]
}, Open  ]],
Cell[105974, 2288, 408, 11, 35, "Message",ExpressionUUID->"d76313b5-3a41-4f63-bed5-32fed241325e"],
Cell[CellGroupData[{
Cell[106407, 2303, 905, 18, 24, "Print",ExpressionUUID->"2963a4b9-5579-4ef4-ba60-6261b133f279"],
Cell[107315, 2323, 442, 8, 24, "Print",ExpressionUUID->"fa91b802-425e-4ead-b7b4-2618a11fc037"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[107806, 2337, 1551, 32, 222, "Input",ExpressionUUID->"f035415b-5280-438a-b376-e7fcaafbf63b"],
Cell[CellGroupData[{
Cell[109382, 2373, 701, 14, 24, "Print",ExpressionUUID->"50267ecd-6913-4322-97e9-6c181ee62a96"],
Cell[110086, 2389, 478, 8, 24, "Print",ExpressionUUID->"a2917d31-c659-454a-8b60-e33dc1af4bef"],
Cell[110567, 2399, 472, 8, 24, "Print",ExpressionUUID->"493be979-5bcf-4e6b-908c-9fe6ed32d553"],
Cell[111042, 2409, 513, 9, 24, "Print",ExpressionUUID->"666fcd66-bf82-4c9a-851c-eaf4742466ad"]
}, Open  ]],
Cell[111570, 2421, 1011, 25, 62, "Output",ExpressionUUID->"f275f380-9faa-4d3d-b1a5-a98603e7d45e"],
Cell[CellGroupData[{
Cell[112606, 2450, 531, 9, 24, "Print",ExpressionUUID->"c6df1072-941a-4bdd-b231-d81e56aa235c"],
Cell[113140, 2461, 527, 9, 24, "Print",ExpressionUUID->"93dca42b-7f46-41cd-9e60-56b9c569d800"],
Cell[113670, 2472, 722, 16, 24, "Print",ExpressionUUID->"1ee14561-dec5-49b9-b234-a71a75e75b71"],
Cell[114395, 2490, 477, 8, 24, "Print",ExpressionUUID->"1c240cbd-1f6a-4245-bae0-1d4df34ab7d8"],
Cell[114875, 2500, 466, 8, 24, "Print",ExpressionUUID->"a2bb2c75-0e75-4a76-86a4-6056799cfbd1"],
Cell[115344, 2510, 590, 12, 24, "Print",ExpressionUUID->"f4db4e38-1ae7-4a7c-b70f-d43590e5fbf4"],
Cell[115937, 2524, 480, 8, 24, "Print",ExpressionUUID->"ebe543cf-04e5-4720-9783-423ccff11c04"]
}, Open  ]],
Cell[116432, 2535, 453, 8, 31, "Output",ExpressionUUID->"98f2ab3f-e450-4b0c-a260-1c9b17046a89"],
Cell[CellGroupData[{
Cell[116910, 2547, 722, 16, 24, "Print",ExpressionUUID->"c169dcec-be52-4e29-b52d-671062145d39"],
Cell[117635, 2565, 476, 8, 24, "Print",ExpressionUUID->"eba6af1e-9194-4afb-aa0d-a7a1b0dd3eb7"],
Cell[118114, 2575, 512, 9, 24, "Print",ExpressionUUID->"84e71260-d554-4b8b-9c7d-b99619688bce"],
Cell[118629, 2586, 987, 20, 24, "Print",ExpressionUUID->"b7968fce-dd9e-4ece-92b3-844fcf99d86e"],
Cell[119619, 2608, 590, 12, 24, "Print",ExpressionUUID->"a6170b27-85a6-4cf7-a821-33e9142547cd"]
}, Open  ]],
Cell[120224, 2623, 3698, 102, 92, "Output",ExpressionUUID->"6e6c1a4e-c279-4277-a9d1-91c7157d0e2e"],
Cell[CellGroupData[{
Cell[123947, 2729, 819, 16, 24, "Print",ExpressionUUID->"986c162f-5402-48de-afa0-1e6377ed236c"],
Cell[124769, 2747, 758, 17, 24, "Print",ExpressionUUID->"1d472b15-ef67-4c32-8dae-f52e4f6670ad"],
Cell[125530, 2766, 725, 16, 24, "Print",ExpressionUUID->"3e303b0f-2f80-4317-84a5-c4bbd71d160b"],
Cell[126258, 2784, 499, 9, 24, "Print",ExpressionUUID->"8d0beeec-2b91-4d4e-84d3-b4b09c9c8ca2"],
Cell[126760, 2795, 724, 16, 24, "Print",ExpressionUUID->"f92b69e5-ab87-4349-bf99-8fea2fdae10f"],
Cell[127487, 2813, 477, 8, 24, "Print",ExpressionUUID->"ece745cb-a380-431f-90db-96a589b22a06"],
Cell[127967, 2823, 658, 13, 24, "Print",ExpressionUUID->"51d7e541-75f4-4591-9cb9-71d229b9c350"],
Cell[128628, 2838, 510, 9, 24, "Print",ExpressionUUID->"3f480a38-b754-4f5e-8d05-b24223753f8e"],
Cell[129141, 2849, 995, 20, 24, "Print",ExpressionUUID->"d8bd1a9d-e4b2-4f54-8fbc-d1337745b88b"],
Cell[130139, 2871, 594, 12, 24, "Print",ExpressionUUID->"2937c92b-8610-4fca-b31e-d595a69097a9"],
Cell[130736, 2885, 946, 19, 24, "Print",ExpressionUUID->"76eb7127-e5c7-497c-8647-e2cb501bb1e3"],
Cell[131685, 2906, 493, 8, 24, "Print",ExpressionUUID->"244fe208-f5ff-46d3-b3d8-4da7573b3464"],
Cell[132181, 2916, 758, 17, 24, "Print",ExpressionUUID->"502dda80-32a3-49ef-8567-0b6b85741db6"],
Cell[132942, 2935, 712, 16, 24, "Print",ExpressionUUID->"c4876ec1-ec96-48b8-a927-4be1b34adc3f"],
Cell[133657, 2953, 690, 13, 24, "Print",ExpressionUUID->"ef452471-3a09-41fa-8d27-e9e2f6643cda"]
}, Open  ]],
Cell[134362, 2969, 616, 12, 35, "Message",ExpressionUUID->"64778cc8-b14c-4c61-8f80-6804cbce89fe"],
Cell[CellGroupData[{
Cell[135003, 2985, 676, 13, 24, "Print",ExpressionUUID->"39f5c45f-6b82-4c34-a94d-97211a4bda10"],
Cell[135682, 3000, 476, 8, 24, "Print",ExpressionUUID->"0f5efd8d-249d-41bb-8f51-880fab31fb5c"],
Cell[136161, 3010, 498, 9, 24, "Print",ExpressionUUID->"2e7fdd31-e342-412c-bf21-a83474bab44e"],
Cell[136662, 3021, 689, 13, 24, "Print",ExpressionUUID->"3473018e-241a-4d6c-907c-c156387d3207"],
Cell[137354, 3036, 188, 4, 24, "Print",ExpressionUUID->"ff5dddcd-7396-4679-834b-1b26d6111967"],
Cell[137545, 3042, 188, 4, 24, "Print",ExpressionUUID->"44ce3ca8-fcef-48ab-89ee-8462b96d39f7"],
Cell[137736, 3048, 186, 4, 24, "Print",ExpressionUUID->"65cf8d85-2a68-4a78-b1eb-3ccedb0aacf8"],
Cell[137925, 3054, 186, 4, 24, "Print",ExpressionUUID->"ec919153-4ce9-41a5-aa26-c60f9ba963fc"],
Cell[138114, 3060, 848, 16, 24, "Print",ExpressionUUID->"05c0166b-487d-4d94-a079-f1e3fc64d8d3"],
Cell[138965, 3078, 470, 8, 24, "Print",ExpressionUUID->"6d2e18aa-5efa-447c-a152-969504353aa6"],
Cell[139438, 3088, 455, 8, 24, "Print",ExpressionUUID->"bd9a66bb-dc32-42ac-b42d-cd4fbb6774f1"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[139954, 3103, 217, 4, 38, "Section",ExpressionUUID->"e31bbc3c-8fc8-463e-b845-29a34070e85b"],
Cell[CellGroupData[{
Cell[140196, 3111, 979, 21, 89, "Input",ExpressionUUID->"26825268-e6e9-43f4-9716-9772fb26478f"],
Cell[CellGroupData[{
Cell[141200, 3136, 463, 8, 24, "Print",ExpressionUUID->"781b7e65-4692-4606-b59d-d85a9f591da3"],
Cell[141666, 3146, 482, 8, 24, "Print",ExpressionUUID->"ae29c7f8-b072-414d-8e02-752d3b6e8a4f"],
Cell[142151, 3156, 453, 8, 24, "Print",ExpressionUUID->"f927c658-8ee9-40fa-94c0-ddbbecb6ce08"],
Cell[142607, 3166, 455, 8, 24, "Print",ExpressionUUID->"57d46524-e823-4b81-9dd9-970accc12130"],
Cell[143065, 3176, 584, 12, 24, "Print",ExpressionUUID->"87adc8b3-d4ec-4de4-b5a0-a0bb3e113201"],
Cell[143652, 3190, 455, 8, 24, "Print",ExpressionUUID->"28e6ce1f-ecb3-4840-8246-688479933b63"],
Cell[144110, 3200, 445, 8, 24, "Print",ExpressionUUID->"9a247eb1-487d-4b9a-8919-15d16b78e103"],
Cell[144558, 3210, 490, 9, 24, "Print",ExpressionUUID->"cc8ef3bd-9ade-40a9-9653-aba820294ac8"],
Cell[145051, 3221, 442, 8, 24, "Print",ExpressionUUID->"6e8aac98-da2a-4c99-a8f3-4755d513d62a"],
Cell[145496, 3231, 472, 8, 24, "Print",ExpressionUUID->"e7601e88-fb01-492d-bdb6-15cf96e70b48"],
Cell[145971, 3241, 475, 8, 24, "Print",ExpressionUUID->"729c9581-a31e-4ebc-923e-a3fe97c60343"],
Cell[146449, 3251, 473, 8, 24, "Print",ExpressionUUID->"7f40bb84-b6d2-4c6d-8e01-ad413b54670c"],
Cell[146925, 3261, 679, 14, 44, "Print",ExpressionUUID->"2dfb2810-a498-4677-9335-d267ca382006"]
}, Open  ]],
Cell[147619, 3278, 392, 10, 24, "Message",ExpressionUUID->"33738be6-83a4-4172-b4f6-85005cc90a39"],
Cell[CellGroupData[{
Cell[148036, 3292, 933, 18, 24, "Print",ExpressionUUID->"a133ed18-0b7c-48af-8cde-030514a7b786"],
Cell[148972, 3312, 1044, 22, 24, "Print",ExpressionUUID->"dd287bfb-626e-4e87-8d47-c7352d2efda3"],
Cell[150019, 3336, 1036, 21, 24, "Print",ExpressionUUID->"da353c1f-8b99-4c18-bbfc-044bc3546eeb"]
}, Open  ]],
Cell[151070, 3360, 386, 10, 24, "Message",ExpressionUUID->"9a0caf35-1bb3-4279-8ad1-967e5cc138cf"],
Cell[CellGroupData[{
Cell[151481, 3374, 927, 18, 24, "Print",ExpressionUUID->"2d6897a1-2ce9-469d-9055-6990a632073a"],
Cell[152411, 3394, 462, 8, 24, "Print",ExpressionUUID->"a2421e22-ae06-4cc7-9360-00734641cc95"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[152922, 3408, 1607, 33, 222, "Input",ExpressionUUID->"7e0dd744-d8cc-4c5d-9e79-7a3c170f227e"],
Cell[CellGroupData[{
Cell[154554, 3445, 746, 14, 24, "Print",ExpressionUUID->"cee3a073-baa3-4f1e-8ab7-2bc180d6b6fc"],
Cell[155303, 3461, 521, 8, 24, "Print",ExpressionUUID->"9aa76ae7-fec0-41c3-adc1-3b0c510e5d48"],
Cell[155827, 3471, 515, 8, 24, "Print",ExpressionUUID->"1642a574-b840-4fb8-a6e4-49360feb28d9"],
Cell[156345, 3481, 556, 9, 24, "Print",ExpressionUUID->"625f8528-2315-4396-8fac-79dcd903f0aa"]
}, Open  ]],
Cell[156916, 3493, 1057, 25, 62, "Output",ExpressionUUID->"e11c1c6f-5465-4dbf-8c75-afe91c9b272f"],
Cell[CellGroupData[{
Cell[157998, 3522, 572, 9, 24, "Print",ExpressionUUID->"d9ebd4bb-ceec-4ea8-a49d-8e2dc84a32c3"],
Cell[158573, 3533, 570, 9, 24, "Print",ExpressionUUID->"2f106143-f545-48fe-a875-1768a1908753"],
Cell[159146, 3544, 764, 16, 24, "Print",ExpressionUUID->"7b502949-46b9-418e-b341-584f1435324a"],
Cell[159913, 3562, 520, 8, 24, "Print",ExpressionUUID->"fd7b139f-5eda-4a7c-ae7e-9e0ba1831a73"],
Cell[160436, 3572, 513, 8, 24, "Print",ExpressionUUID->"65aae85c-c356-47e4-8b7a-6393c7a35258"],
Cell[160952, 3582, 633, 12, 24, "Print",ExpressionUUID->"cede2168-7f48-4317-b50c-57ed58238004"],
Cell[161588, 3596, 521, 8, 24, "Print",ExpressionUUID->"1dc4dd1f-dd86-4802-95af-1227b83c9a30"]
}, Open  ]],
Cell[162124, 3607, 497, 8, 31, "Output",ExpressionUUID->"b8d82e83-8c9a-4fae-ba3a-88e97421b82d"],
Cell[CellGroupData[{
Cell[162646, 3619, 765, 16, 24, "Print",ExpressionUUID->"4de05185-b15d-4b2c-9034-fec340711174"],
Cell[163414, 3637, 520, 8, 24, "Print",ExpressionUUID->"9eea7f55-45ae-475e-bd69-6ec43a9c344a"],
Cell[163937, 3647, 553, 9, 24, "Print",ExpressionUUID->"3f8d8f08-b122-4988-9a31-c3526d32f648"],
Cell[164493, 3658, 1031, 20, 24, "Print",ExpressionUUID->"fc1e849c-5d7b-4005-a3dd-914039e169c6"],
Cell[165527, 3680, 633, 12, 24, "Print",ExpressionUUID->"b0cc2838-b0ed-4006-ab40-cd2daaa2cbc8"]
}, Open  ]],
Cell[166175, 3695, 3794, 105, 92, "Output",ExpressionUUID->"a52809ba-4270-4e35-a3cc-5f38fde4af95"],
Cell[CellGroupData[{
Cell[169994, 3804, 861, 16, 24, "Print",ExpressionUUID->"2fea827d-ddfb-4a0a-85dd-dbe1af9d0a81"],
Cell[170858, 3822, 801, 17, 24, "Print",ExpressionUUID->"6a49dc8b-af55-432d-8c08-b80e8937b93f"],
Cell[171662, 3841, 768, 16, 24, "Print",ExpressionUUID->"da2fbada-cc27-449b-87bd-9e9a372d9926"],
Cell[172433, 3859, 542, 9, 24, "Print",ExpressionUUID->"f283eed3-4b6d-422c-8fc5-ae14efeffc24"],
Cell[172978, 3870, 765, 16, 24, "Print",ExpressionUUID->"8b25f81b-4b38-4158-8054-07a1beb00cd2"],
Cell[173746, 3888, 519, 8, 24, "Print",ExpressionUUID->"1620d859-20c3-4e20-bd1d-185357078695"],
Cell[174268, 3898, 702, 13, 24, "Print",ExpressionUUID->"4f99bd57-453a-4fff-a4e2-a66f9058d37e"],
Cell[174973, 3913, 553, 9, 24, "Print",ExpressionUUID->"997496c1-a1db-4546-8048-e06fdc7187d6"],
Cell[175529, 3924, 1040, 20, 24, "Print",ExpressionUUID->"2bfabd8e-280e-403a-bfd9-adc8f0717657"],
Cell[176572, 3946, 637, 12, 24, "Print",ExpressionUUID->"ea80373f-3619-4f86-940f-1df639bd703b"],
Cell[177212, 3960, 989, 19, 24, "Print",ExpressionUUID->"60e82b16-2758-4065-b257-a2e65e6c20db"],
Cell[178204, 3981, 534, 8, 24, "Print",ExpressionUUID->"90aa9899-c5f7-4a21-9d35-0f7a62ab8f63"],
Cell[178741, 3991, 803, 17, 24, "Print",ExpressionUUID->"698468a1-534f-4b1a-89d4-24ba90ac7713"],
Cell[179547, 4010, 755, 16, 24, "Print",ExpressionUUID->"bd4b3c03-3277-4b0b-bd16-8b466f1a0a01"],
Cell[180305, 4028, 733, 13, 24, "Print",ExpressionUUID->"05898876-a6fd-43a7-8b49-0b2dce18366e"]
}, Open  ]],
Cell[181053, 4044, 663, 13, 35, "Message",ExpressionUUID->"21bf7a21-9823-443a-b022-31540b909b28"],
Cell[CellGroupData[{
Cell[181741, 4061, 718, 13, 24, "Print",ExpressionUUID->"b3edc095-8a3b-4ef0-bd94-cb1bcf4aac72"],
Cell[182462, 4076, 517, 8, 24, "Print",ExpressionUUID->"92b2b3d5-1c58-4bdc-a406-690024bedb41"],
Cell[182982, 4086, 543, 9, 24, "Print",ExpressionUUID->"05538667-f3ff-48af-b094-f00b91f51147"],
Cell[183528, 4097, 732, 13, 24, "Print",ExpressionUUID->"90dec379-d508-4e09-ab1e-412fdd45384a"],
Cell[184263, 4112, 188, 4, 24, "Print",ExpressionUUID->"704260e3-1ec2-49b6-a643-713e8a9fce36"],
Cell[184454, 4118, 190, 4, 24, "Print",ExpressionUUID->"e8c194b2-211f-40df-8087-f0fe423e425d"],
Cell[184647, 4124, 188, 4, 24, "Print",ExpressionUUID->"184bfe92-3645-4471-bac2-bb2764f5e8ce"],
Cell[184838, 4130, 186, 4, 24, "Print",ExpressionUUID->"70dd4c4c-e53e-4ca0-ba7b-743131f985a2"],
Cell[185027, 4136, 891, 16, 24, "Print",ExpressionUUID->"b377661b-f05d-4e05-9609-56a71dcdfd9d"],
Cell[185921, 4154, 513, 8, 24, "Print",ExpressionUUID->"d4be457c-0375-4e07-8ee9-aaedf27ad8cc"],
Cell[186437, 4164, 498, 8, 24, "Print",ExpressionUUID->"462f8e51-c476-44b3-808f-9fe6d2f61929"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[186996, 4179, 212, 4, 38, "Section",ExpressionUUID->"819f672c-5d2b-4ffa-a0ab-b460c645b2e9"],
Cell[CellGroupData[{
Cell[187233, 4187, 934, 21, 89, "Input",ExpressionUUID->"705fcdbb-0c8b-494d-a2c9-28d07f4c5c34"],
Cell[CellGroupData[{
Cell[188192, 4212, 481, 8, 24, "Print",ExpressionUUID->"06db0bad-5d1b-48ca-9682-8ebc09331567"],
Cell[188676, 4222, 499, 8, 24, "Print",ExpressionUUID->"90a7d998-d214-4de6-96b5-3cb7cc11c5c0"],
Cell[189178, 4232, 468, 8, 24, "Print",ExpressionUUID->"b48bc65d-8dca-49c2-b39c-45715f1f392f"],
Cell[189649, 4242, 472, 8, 24, "Print",ExpressionUUID->"e0c53747-96ea-473c-bffc-183ff8b10354"],
Cell[190124, 4252, 601, 12, 24, "Print",ExpressionUUID->"bc2d4d66-48b7-48b5-9634-4ea11b7683ca"],
Cell[190728, 4266, 472, 8, 24, "Print",ExpressionUUID->"7bd53cfe-ee29-4413-967e-399fdc624069"],
Cell[191203, 4276, 464, 8, 24, "Print",ExpressionUUID->"a668c6e1-d75a-4b55-8c84-32bf3c946f34"],
Cell[191670, 4286, 509, 9, 24, "Print",ExpressionUUID->"bbc71d9b-d5ec-4bfe-94f1-e6852b464bdc"],
Cell[192182, 4297, 459, 8, 24, "Print",ExpressionUUID->"fe6d26d3-dc5d-4c27-854d-36630dbeaafb"],
Cell[192644, 4307, 489, 8, 24, "Print",ExpressionUUID->"c352f096-2036-4205-9df7-d6f02308c3d9"],
Cell[193136, 4317, 492, 8, 24, "Print",ExpressionUUID->"d392c500-932f-457c-b0c9-1f674566e421"],
Cell[193631, 4327, 490, 8, 24, "Print",ExpressionUUID->"53d84af9-19bd-4b0d-b6ad-b4d6c5136d02"],
Cell[194124, 4337, 691, 14, 44, "Print",ExpressionUUID->"a0ea598e-f4cf-4055-bef3-221aed8df7f9"]
}, Open  ]],
Cell[194830, 4354, 407, 11, 24, "Message",ExpressionUUID->"5ebd036c-14bd-453f-8902-fe24ccba0dc2"],
Cell[CellGroupData[{
Cell[195262, 4369, 948, 18, 24, "Print",ExpressionUUID->"2b015653-fbeb-4a9e-8619-3cee8ab8fa80"],
Cell[196213, 4389, 1061, 22, 24, "Print",ExpressionUUID->"18f856e8-763a-42a4-b816-9f6f14a84193"],
Cell[197277, 4413, 1053, 21, 24, "Print",ExpressionUUID->"f29b17e3-5ef9-49da-bcfb-21ceb4cb1282"]
}, Open  ]],
Cell[198345, 4437, 411, 11, 24, "Message",ExpressionUUID->"3e99a600-32b5-404f-8115-5dd813b3a8ce"],
Cell[CellGroupData[{
Cell[198781, 4452, 942, 18, 24, "Print",ExpressionUUID->"23bdd89d-461f-4c69-abc6-98f0337c6f06"],
Cell[199726, 4472, 479, 8, 24, "Print",ExpressionUUID->"3057b7aa-a578-49d6-a894-ecd0b12d2534"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[200254, 4486, 1607, 33, 241, "Input",ExpressionUUID->"d088ecf6-7071-4e1a-abb2-2ae357bb4163"],
Cell[CellGroupData[{
Cell[201886, 4523, 841, 16, 24, "Print",ExpressionUUID->"4e624a7e-5165-4d91-b2a9-c32654ae5b23"],
Cell[202730, 4541, 617, 10, 24, "Print",ExpressionUUID->"e0359b01-3bbf-4674-95fc-1da4d15a5a75"],
Cell[203350, 4553, 614, 10, 24, "Print",ExpressionUUID->"2bd53418-eafb-47c0-a6f1-3078fff250a8"],
Cell[203967, 4565, 653, 11, 24, "Print",ExpressionUUID->"80524763-4589-4473-a856-ef892e4a0a00"]
}, Open  ]],
Cell[204635, 4579, 1166, 27, 62, "Output",ExpressionUUID->"1ea121f5-3b08-4cee-8fe9-f2da83f31ea0"],
Cell[CellGroupData[{
Cell[205826, 4610, 670, 11, 24, "Print",ExpressionUUID->"f703df68-c566-493c-aeae-ab03f1caec86"],
Cell[206499, 4623, 667, 11, 24, "Print",ExpressionUUID->"5bbc6466-fda1-4ede-bf71-bb20067abc78"],
Cell[207169, 4636, 862, 18, 24, "Print",ExpressionUUID->"ab920366-f85a-4a3a-9670-cda552a3dd91"],
Cell[208034, 4656, 617, 10, 24, "Print",ExpressionUUID->"51bb41c9-4c26-49cb-9dbd-04af77f9dab6"],
Cell[208654, 4668, 608, 10, 24, "Print",ExpressionUUID->"05a72088-2e96-47d6-97ab-b86b92c2168a"],
Cell[209265, 4680, 730, 14, 24, "Print",ExpressionUUID->"32cc7401-0882-4cb9-a828-0d1ff90c28c4"],
Cell[209998, 4696, 620, 10, 24, "Print",ExpressionUUID->"de95df15-5a72-4af7-a5cb-1dfd6a600ee8"]
}, Open  ]],
Cell[210633, 4709, 601, 10, 31, "Output",ExpressionUUID->"da96624f-bcdd-4c8d-a30e-cf17b2c1dcb3"],
Cell[CellGroupData[{
Cell[211259, 4723, 862, 18, 24, "Print",ExpressionUUID->"2aca0c48-9ea6-4452-ae42-0f43a80c44d6"],
Cell[212124, 4743, 619, 10, 24, "Print",ExpressionUUID->"254310d7-a9a9-4e74-82fc-8f238be10232"],
Cell[212746, 4755, 648, 11, 24, "Print",ExpressionUUID->"5ffceceb-af6f-44a9-93df-4963e6a5c822"],
Cell[213397, 4768, 1126, 22, 24, "Print",ExpressionUUID->"d12c0252-9a14-46f5-8022-70e814a15740"],
Cell[214526, 4792, 610, 10, 24, "Print",ExpressionUUID->"64e2436f-fe3e-4d67-8735-ff97912b221c"]
}, Open  ]],
Cell[215151, 4805, 1314, 32, 42, "Output",ExpressionUUID->"63b69d02-6643-4d45-9fb3-22f3aae2fd4a"],
Cell[CellGroupData[{
Cell[216490, 4841, 957, 18, 24, "Print",ExpressionUUID->"da326263-69f9-46c2-8ca4-fff4424cf60b"],
Cell[217450, 4861, 898, 19, 24, "Print",ExpressionUUID->"aafa66b4-b80a-43c2-ba7a-54f92bb611d4"],
Cell[218351, 4882, 867, 18, 24, "Print",ExpressionUUID->"c9a24680-0877-4504-92f1-3305481fcb2e"],
Cell[219221, 4902, 639, 11, 24, "Print",ExpressionUUID->"ea2a99c7-c4d9-4abc-9216-eb9a6f168382"],
Cell[219863, 4915, 861, 18, 24, "Print",ExpressionUUID->"68c5cd5b-1acb-433e-bb8e-89dbc903da30"],
Cell[220727, 4935, 616, 10, 24, "Print",ExpressionUUID->"2ea860fa-2151-4045-ad10-7be2cc710c45"],
Cell[221346, 4947, 799, 15, 24, "Print",ExpressionUUID->"81a3b0aa-7476-4a13-9e1c-426a86d3550a"],
Cell[222148, 4964, 650, 11, 24, "Print",ExpressionUUID->"e0f7e6cd-1012-4426-ab7f-b8c2e72da608"],
Cell[222801, 4977, 1133, 22, 24, "Print",ExpressionUUID->"a3808508-8318-41f7-ae02-382bc1051e6b"],
Cell[223937, 5001, 732, 14, 24, "Print",ExpressionUUID->"af159158-b690-44eb-8811-4367866cfd5c"],
Cell[224672, 5017, 1088, 21, 24, "Print",ExpressionUUID->"d9b61900-da7b-43d6-ac7d-7b2513af042f"],
Cell[225763, 5040, 633, 10, 24, "Print",ExpressionUUID->"fab9ee39-0b86-4e62-b5f5-90257a1d1d4a"],
Cell[226399, 5052, 898, 19, 24, "Print",ExpressionUUID->"6fdf4842-4eb7-46a5-9fed-97f24fa187ba"],
Cell[227300, 5073, 852, 18, 24, "Print",ExpressionUUID->"b35c0842-80bc-4db8-b611-2c4b97affdf7"],
Cell[228155, 5093, 830, 15, 24, "Print",ExpressionUUID->"7a779bae-d46e-4d29-8e9b-f5113fe82211"]
}, Open  ]],
Cell[229000, 5111, 752, 14, 35, "Message",ExpressionUUID->"9cb408cf-d05d-4bd8-9faa-bf3c2b19b899"],
Cell[CellGroupData[{
Cell[229777, 5129, 816, 15, 24, "Print",ExpressionUUID->"8b4983dc-0c7b-4e01-aa08-a5917e60e9c9"],
Cell[230596, 5146, 614, 10, 24, "Print",ExpressionUUID->"373a514d-4025-402a-9695-2a2c8a40b516"],
Cell[231213, 5158, 638, 11, 24, "Print",ExpressionUUID->"4d81d7e7-da47-4d21-a9b4-87bec47741a2"],
Cell[231854, 5171, 831, 15, 24, "Print",ExpressionUUID->"54bbe6ab-a23b-4582-aed0-abce46c9961e"],
Cell[232688, 5188, 188, 4, 24, "Print",ExpressionUUID->"bbd738f4-910f-4a6d-9cdd-bc577f4ca313"],
Cell[232879, 5194, 188, 4, 24, "Print",ExpressionUUID->"55b89a52-997e-4aab-a32d-2324c6375348"],
Cell[233070, 5200, 186, 4, 24, "Print",ExpressionUUID->"61113892-0799-438f-9afb-e9a1b05cc48b"],
Cell[233259, 5206, 186, 4, 24, "Print",ExpressionUUID->"327214f9-b03b-4afc-817d-1d9c75c69823"],
Cell[233448, 5212, 988, 18, 24, "Print",ExpressionUUID->"cf848ccc-73f4-4cd3-a3bc-3c4d7f448e86"],
Cell[234439, 5232, 609, 10, 24, "Print",ExpressionUUID->"cc258e59-f651-40ff-a7ca-353fef5396a9"],
Cell[235051, 5244, 595, 10, 24, "Print",ExpressionUUID->"8991f406-eaea-45eb-ad83-5180f2fdd853"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[235707, 5261, 267, 4, 38, "Section",ExpressionUUID->"1812bef9-f936-48ad-b64b-c123c124db88"],
Cell[CellGroupData[{
Cell[235999, 5269, 987, 21, 89, "Input",ExpressionUUID->"0f606d4d-e1b4-4fcd-9ac1-159c2a8d2bea"],
Cell[CellGroupData[{
Cell[237011, 5294, 226, 4, 24, "Print",ExpressionUUID->"449fa94b-e3e9-41b4-9d3c-bfa41f938e55"],
Cell[237240, 5300, 246, 4, 24, "Print",ExpressionUUID->"b0c36fdd-2671-4e31-84d5-2247cbc3c099"],
Cell[237489, 5306, 213, 4, 24, "Print",ExpressionUUID->"a115476f-3318-4d90-a1f3-7ebfebe6428d"],
Cell[237705, 5312, 219, 4, 24, "Print",ExpressionUUID->"b4cde2ef-155d-4847-beb6-91aba70b372b"],
Cell[237927, 5318, 348, 8, 24, "Print",ExpressionUUID->"3afa8fa0-f483-4d92-a57d-751e7c795ba0"],
Cell[238278, 5328, 215, 4, 24, "Print",ExpressionUUID->"0704ac07-c220-4ce9-95bc-166f79effaf5"],
Cell[238496, 5334, 209, 4, 24, "Print",ExpressionUUID->"50b4e075-98fe-4be1-9609-5831c25c7811"],
Cell[238708, 5340, 252, 5, 24, "Print",ExpressionUUID->"480f511b-7374-4777-bc0c-9a0ca8cb1f0a"],
Cell[238963, 5347, 206, 4, 24, "Print",ExpressionUUID->"3f3c4dd7-e86f-4be3-b3a0-3862bd6bd6af"],
Cell[239172, 5353, 234, 4, 24, "Print",ExpressionUUID->"9f6078a0-acf4-4145-a532-31167690d432"],
Cell[239409, 5359, 237, 4, 24, "Print",ExpressionUUID->"d0231ebc-0003-48ec-904a-4e31ccb642f2"],
Cell[239649, 5365, 237, 4, 24, "Print",ExpressionUUID->"ad32a3ed-e7bc-4c11-92c9-6a4ad71b72d8"],
Cell[239889, 5371, 448, 10, 44, "Print",ExpressionUUID->"9c6afc6f-dd18-4366-96a1-761ba9153a9f"]
}, Open  ]],
Cell[240352, 5384, 368, 10, 24, "Message",ExpressionUUID->"942aa00c-e167-4c3c-9f10-e4994a3c82e5"],
Cell[CellGroupData[{
Cell[240745, 5398, 693, 14, 24, "Print",ExpressionUUID->"c7f9c926-26ad-4e7a-8ee2-8db3e70d6628"],
Cell[241441, 5414, 806, 18, 24, "Print",ExpressionUUID->"617f0884-15ca-4ea0-aa97-1e434db0b45d"],
Cell[242250, 5434, 798, 17, 24, "Print",ExpressionUUID->"95785b3a-8458-4863-90c5-a6a1abc5bf17"]
}, Open  ]],
Cell[243063, 5454, 362, 10, 24, "Message",ExpressionUUID->"3e7fe991-e737-4dc3-a48c-507c60daa44a"],
Cell[CellGroupData[{
Cell[243450, 5468, 687, 14, 24, "Print",ExpressionUUID->"00d55980-5771-4a46-a41b-2800544c6fb5"],
Cell[244140, 5484, 224, 4, 24, "Print",ExpressionUUID->"af9e9d44-e78d-45c3-9450-63acb2e26912"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[244413, 5494, 1639, 34, 241, "Input",ExpressionUUID->"60e7446f-a673-4fb9-9240-656f65e9e705"],
Cell[CellGroupData[{
Cell[246077, 5532, 819, 15, 24, "Print",ExpressionUUID->"559eef55-f904-44ef-9d00-565db771c842"],
Cell[246899, 5549, 586, 9, 24, "Print",ExpressionUUID->"fcbe7e4e-79a6-488c-932f-01203a9dbe3e"],
Cell[247488, 5560, 647, 10, 24, "Print",ExpressionUUID->"9deb0eb6-d954-4056-92b4-7ccc1e375364"],
Cell[248138, 5572, 643, 10, 24, "Print",ExpressionUUID->"d9d01ad4-efaa-4f60-97b4-8c1d69501299"],
Cell[248784, 5584, 838, 17, 24, "Print",ExpressionUUID->"8b8cc6a4-d116-404f-9170-1ea44ff3a053"],
Cell[249625, 5603, 595, 9, 24, "Print",ExpressionUUID->"f474176e-131f-4124-b015-8d6ce9648309"],
Cell[250223, 5614, 625, 10, 24, "Print",ExpressionUUID->"645a0fb6-ec52-4abb-92c7-e4dfe654bc92"],
Cell[250851, 5626, 584, 9, 24, "Print",ExpressionUUID->"691515ae-9beb-4518-9c0c-0865f2183b0e"],
Cell[251438, 5637, 708, 13, 24, "Print",ExpressionUUID->"969ac467-ba99-4e45-9e39-beef65cc3fe2"],
Cell[252149, 5652, 596, 9, 24, "Print",ExpressionUUID->"7f59fd82-c065-4b3e-ba22-997ab53f1e3b"]
}, Open  ]],
Cell[252760, 5664, 573, 9, 31, "Output",ExpressionUUID->"3c9c0ecd-aaca-41c2-83c4-fd6840ad74d5"],
Cell[CellGroupData[{
Cell[253358, 5677, 837, 17, 24, "Print",ExpressionUUID->"a1775cd9-0b8c-447f-b31e-c7632a4eec7b"],
Cell[254198, 5696, 593, 9, 24, "Print",ExpressionUUID->"2aa172ec-2045-4b8d-a8bd-1e0677205791"],
Cell[254794, 5707, 626, 10, 24, "Print",ExpressionUUID->"e832a92d-b63b-4192-aeb4-61e5355824c2"],
Cell[255423, 5719, 1103, 21, 24, "Print",ExpressionUUID->"a8444e98-ea2c-463f-95fa-a6ee0e1e945a"],
Cell[256529, 5742, 586, 9, 24, "Print",ExpressionUUID->"f944c31f-38f7-40e6-8d16-00f6b4c76622"]
}, Open  ]],
Cell[257130, 5754, 1335, 34, 42, "Output",ExpressionUUID->"e8efb411-9496-49f4-85ae-cd0cad8cfaf4"],
Cell[CellGroupData[{
Cell[258490, 5792, 935, 17, 24, "Print",ExpressionUUID->"d6b7f6a5-d9ff-43b2-a8b3-3bb8c36062f4"],
Cell[259428, 5811, 872, 18, 24, "Print",ExpressionUUID->"3d0b1b1e-d0ec-4128-90de-4c8c8702ac6b"],
Cell[260303, 5831, 841, 17, 24, "Print",ExpressionUUID->"f6331983-2452-4508-9aac-366b6a5d2c30"],
Cell[261147, 5850, 615, 10, 24, "Print",ExpressionUUID->"a8cb0655-b06d-431d-aab2-9c6c11b85c1a"],
Cell[261765, 5862, 838, 17, 24, "Print",ExpressionUUID->"5b65b2fc-e2bc-4f24-b207-f006146b6adb"],
Cell[262606, 5881, 595, 9, 24, "Print",ExpressionUUID->"75cbd0e0-a49d-47a6-8268-1e1930a8344b"],
Cell[263204, 5892, 775, 14, 24, "Print",ExpressionUUID->"d5994477-eb29-4962-8756-c1ad07f72d65"],
Cell[263982, 5908, 628, 10, 24, "Print",ExpressionUUID->"7ee3bd7e-d15e-4077-a17d-8259fe9719c6"],
Cell[264613, 5920, 1107, 21, 24, "Print",ExpressionUUID->"24adf13b-7bd1-44aa-ad10-00c594f793c1"],
Cell[265723, 5943, 710, 13, 24, "Print",ExpressionUUID->"460c2438-8cc8-4376-b1be-4f412b73532c"],
Cell[266436, 5958, 1061, 20, 24, "Print",ExpressionUUID->"f5e683a6-fdc2-48b2-9da3-08c5f8639f39"],
Cell[267500, 5980, 607, 9, 24, "Print",ExpressionUUID->"4ea9e8ef-9ffb-4ee1-a4cd-d1c0c54e3e7d"],
Cell[268110, 5991, 876, 18, 24, "Print",ExpressionUUID->"57257e10-952a-42f1-9b10-2f363452722f"],
Cell[268989, 6011, 828, 17, 24, "Print",ExpressionUUID->"eb4bc61d-2b53-416d-ad62-15bc50080b5a"],
Cell[269820, 6030, 806, 14, 24, "Print",ExpressionUUID->"b36d66e2-4b61-43f1-95b6-cbe3701e97f3"]
}, Open  ]],
Cell[270641, 6047, 730, 14, 35, "Message",ExpressionUUID->"9e8fc71c-abc7-46e6-913e-c883220e2812"],
Cell[CellGroupData[{
Cell[271396, 6065, 792, 14, 24, "Print",ExpressionUUID->"f1aeb60d-e5aa-4a5e-9ee0-6414aee323b8"],
Cell[272191, 6081, 592, 9, 24, "Print",ExpressionUUID->"e58e2cc1-e88e-40c0-a3e6-e357798dfea0"],
Cell[272786, 6092, 616, 10, 24, "Print",ExpressionUUID->"7f208292-e319-4953-824a-34358f8d4951"],
Cell[273405, 6104, 807, 14, 24, "Print",ExpressionUUID->"4418c541-eddd-496e-8dfa-3b4517d1c7fa"],
Cell[274215, 6120, 190, 4, 24, "Print",ExpressionUUID->"c4750bef-68a0-4d20-82ac-c1dccb931539"],
Cell[274408, 6126, 188, 4, 24, "Print",ExpressionUUID->"92f8dfb5-0f47-4f5d-ac6f-7517882d9330"],
Cell[274599, 6132, 186, 4, 24, "Print",ExpressionUUID->"59f9c090-a5f4-4e42-9c55-50bd415d3be3"],
Cell[274788, 6138, 186, 4, 24, "Print",ExpressionUUID->"0b952620-c3e1-413e-a525-822c8b4b94e7"],
Cell[274977, 6144, 964, 17, 24, "Print",ExpressionUUID->"0ee8688f-0eb6-46cc-ace6-2640771b36f1"],
Cell[275944, 6163, 586, 9, 24, "Print",ExpressionUUID->"f3226bc3-db02-4b6f-85ca-e94bf7f74c7c"],
Cell[276533, 6174, 571, 9, 24, "Print",ExpressionUUID->"7952b3e4-aeba-4f1c-b963-0cb45edc06d0"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[277165, 6190, 260, 4, 38, "Section",ExpressionUUID->"fd0d9fc1-1118-42d7-b6c7-d3c25301fc25"],
Cell[CellGroupData[{
Cell[277450, 6198, 980, 21, 89, "Input",ExpressionUUID->"5365947e-825e-4504-a80b-af158120802b"],
Cell[CellGroupData[{
Cell[278455, 6223, 202, 4, 24, "Print",ExpressionUUID->"ebd0e264-ef9a-4bdb-97e9-dc160b9701e7"],
Cell[278660, 6229, 220, 4, 24, "Print",ExpressionUUID->"9b61e05c-84e3-48f4-8be8-90d43ca68188"],
Cell[278883, 6235, 189, 4, 24, "Print",ExpressionUUID->"bdc9d978-1637-457d-928e-7dcd03117355"],
Cell[279075, 6241, 193, 4, 24, "Print",ExpressionUUID->"3a35dc99-07e8-4e70-8196-99793c79dfb6"],
Cell[279271, 6247, 322, 8, 24, "Print",ExpressionUUID->"effe9432-1828-445b-9f46-ab1b0047af43"],
Cell[279596, 6257, 191, 4, 24, "Print",ExpressionUUID->"e921a149-0d4d-4576-8722-9717b76e2dd5"],
Cell[279790, 6263, 185, 4, 24, "Print",ExpressionUUID->"ee853602-e349-476a-bb34-0269ba8b4a54"],
Cell[279978, 6269, 228, 5, 24, "Print",ExpressionUUID->"97f70ebb-f080-4fb2-b6ab-5fba47af0327"],
Cell[280209, 6276, 182, 4, 24, "Print",ExpressionUUID->"9b4efad1-b6b2-4bd2-877b-802329901dec"],
Cell[280394, 6282, 212, 4, 24, "Print",ExpressionUUID->"6a73b97f-2164-4108-87ef-f0be9fe866c7"],
Cell[280609, 6288, 215, 4, 24, "Print",ExpressionUUID->"8e6a8f66-eb72-4892-bcaf-f4949e2b0fba"],
Cell[280827, 6294, 211, 4, 24, "Print",ExpressionUUID->"b65509b4-e0c6-4e19-8408-366bbee101c3"],
Cell[281041, 6300, 389, 9, 44, "Print",ExpressionUUID->"59504c84-5166-4fd7-8e26-fb4980a7cf4b"]
}, Open  ]],
Cell[281445, 6312, 418, 11, 24, "Message",ExpressionUUID->"920488ac-3ec0-41cf-aea0-9ab4aeb2b594"],
Cell[CellGroupData[{
Cell[281888, 6327, 671, 14, 24, "Print",ExpressionUUID->"0a896c7c-9245-459a-a4e5-f23846270ba2"],
Cell[282562, 6343, 782, 18, 24, "Print",ExpressionUUID->"1e7c0822-fbe5-49f3-a792-c96388f50de3"],
Cell[283347, 6363, 774, 17, 24, "Print",ExpressionUUID->"35826a8f-3d39-427f-904a-7af3999037cc"]
}, Open  ]],
Cell[284136, 6383, 414, 11, 24, "Message",ExpressionUUID->"21346090-5053-42a9-bfb6-8607529bb55a"],
Cell[CellGroupData[{
Cell[284575, 6398, 663, 14, 24, "Print",ExpressionUUID->"5f086361-18cc-46ca-a7a1-fd8ce633dde7"],
Cell[285241, 6414, 200, 4, 24, "Print",ExpressionUUID->"c3e57168-e6a7-42e9-96a1-b2a9d6cf1233"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[285490, 6424, 1659, 34, 241, "Input",ExpressionUUID->"5dbe612a-8462-40c9-ab92-916fc215482e"],
Cell[CellGroupData[{
Cell[287174, 6462, 885, 16, 24, "Print",ExpressionUUID->"39210ba9-d89e-4815-a26a-ed7e1e412f41"],
Cell[288062, 6480, 662, 10, 24, "Print",ExpressionUUID->"77d62e4d-bd29-44b1-9e6b-b91e8c505287"],
Cell[288727, 6492, 656, 10, 24, "Print",ExpressionUUID->"6c9d2813-f14f-4a0b-846a-6eae8ec18507"],
Cell[289386, 6504, 697, 11, 24, "Print",ExpressionUUID->"959f8d84-ef60-4add-b3d3-b7792e026df2"]
}, Open  ]],
Cell[290098, 6518, 1201, 27, 62, "Output",ExpressionUUID->"ff9e73fe-d346-4b98-ab49-98d17b50a72b"],
Cell[CellGroupData[{
Cell[291324, 6549, 715, 11, 24, "Print",ExpressionUUID->"3b8620f4-adcc-4d1a-a217-506ef5eb28be"],
Cell[292042, 6562, 713, 11, 24, "Print",ExpressionUUID->"77e15359-6fe7-4165-a675-34d308c2e261"],
Cell[292758, 6575, 908, 18, 24, "Print",ExpressionUUID->"138c10c7-dd03-454c-98ce-1265df2b0c77"],
Cell[293669, 6595, 661, 10, 24, "Print",ExpressionUUID->"9993a713-0c7e-4272-bcd2-d46b75f8222e"],
Cell[294333, 6607, 651, 10, 24, "Print",ExpressionUUID->"ff351633-7b8a-4e11-aabd-33f2c9460b4b"],
Cell[294987, 6619, 774, 14, 24, "Print",ExpressionUUID->"7ffb5f54-048f-4efa-ba47-7c11e83784fa"],
Cell[295764, 6635, 664, 10, 24, "Print",ExpressionUUID->"edb50ec4-4339-4e21-a641-42086c822d5e"]
}, Open  ]],
Cell[296443, 6648, 642, 10, 31, "Output",ExpressionUUID->"e8c0cc40-7a8d-4cea-a2c5-cad210711539"],
Cell[CellGroupData[{
Cell[297110, 6662, 906, 18, 24, "Print",ExpressionUUID->"b000172d-47c8-4104-bdfe-62cf65390419"],
Cell[298019, 6682, 663, 10, 24, "Print",ExpressionUUID->"67d1b322-8cf7-47c7-8c98-199936cd083d"],
Cell[298685, 6694, 696, 11, 24, "Print",ExpressionUUID->"9c0de740-76b8-4f85-ad11-9c2c5e40e9ea"],
Cell[299384, 6707, 1171, 22, 24, "Print",ExpressionUUID->"3344a3ff-9fb5-40d3-84c2-0edeb8f86925"],
Cell[300558, 6731, 652, 10, 24, "Print",ExpressionUUID->"fa46ce77-08fc-4d22-9fff-b3f3ec85fb1b"]
}, Open  ]],
Cell[301225, 6744, 2009, 52, 42, "Output",ExpressionUUID->"7c55b269-3f25-4f6c-9a0b-4717617b43fd"],
Cell[CellGroupData[{
Cell[303259, 6800, 1003, 18, 24, "Print",ExpressionUUID->"783047b1-fff5-494f-9d41-f090a109f592"],
Cell[304265, 6820, 942, 19, 24, "Print",ExpressionUUID->"cb5be894-4642-4781-9a1f-b294dd49ff6b"],
Cell[305210, 6841, 909, 18, 24, "Print",ExpressionUUID->"e6f2f1b6-2aa2-4af2-ace7-8286ef2d1967"],
Cell[306122, 6861, 683, 11, 24, "Print",ExpressionUUID->"b47b1a94-5615-4965-996d-aa583162cda0"],
Cell[306808, 6874, 908, 18, 24, "Print",ExpressionUUID->"761afdb2-5f54-4eff-afcd-3f7019da0fad"],
Cell[307719, 6894, 661, 10, 24, "Print",ExpressionUUID->"fece93d6-7302-40f8-b032-e80dc1f2ff05"],
Cell[308383, 6906, 845, 15, 24, "Print",ExpressionUUID->"4932919d-bb95-4fe3-9ef6-089a5570c005"],
Cell[309231, 6923, 694, 11, 24, "Print",ExpressionUUID->"c9762aed-a7e3-4046-948e-c20448fbd33e"],
Cell[309928, 6936, 1175, 22, 24, "Print",ExpressionUUID->"516e01c3-f29a-4623-b031-def23e5c8107"],
Cell[311106, 6960, 776, 14, 24, "Print",ExpressionUUID->"c7a25ab4-fe9f-4e0f-af1a-c1a835a9632d"],
Cell[311885, 6976, 1132, 21, 24, "Print",ExpressionUUID->"dafcdc3a-8d6a-4879-85a9-08466b0fdd7c"],
Cell[313020, 6999, 677, 10, 24, "Print",ExpressionUUID->"5482cd84-d081-44a4-9f4a-12938115be80"],
Cell[313700, 7011, 942, 19, 24, "Print",ExpressionUUID->"9e3fe13f-1ca4-4f05-a0be-08c5019f9898"],
Cell[314645, 7032, 896, 18, 24, "Print",ExpressionUUID->"9262a527-4e61-40b0-bf43-be3fa77f967e"],
Cell[315544, 7052, 874, 15, 24, "Print",ExpressionUUID->"a476ecbf-97b5-4ef1-bac1-dd6c24d90b09"]
}, Open  ]],
Cell[316433, 7070, 822, 16, 35, "Message",ExpressionUUID->"3c976cd1-a65f-4f95-affb-cd5eb7f2c7c5"],
Cell[CellGroupData[{
Cell[317280, 7090, 862, 15, 24, "Print",ExpressionUUID->"154b17dc-f380-4a51-9360-6b9f213ce8c8"],
Cell[318145, 7107, 660, 10, 24, "Print",ExpressionUUID->"6017ed2f-2f7d-404b-afb5-644a16d424ed"],
Cell[318808, 7119, 682, 11, 24, "Print",ExpressionUUID->"e5c02566-af88-45ec-ba71-a61d23e352e7"],
Cell[319493, 7132, 875, 15, 24, "Print",ExpressionUUID->"39fe8f78-6f48-4b01-b3df-d89a404649d1"],
Cell[320371, 7149, 188, 4, 24, "Print",ExpressionUUID->"9a4959a4-ea21-4fdc-9cbf-588f6cb99cf1"],
Cell[320562, 7155, 188, 4, 24, "Print",ExpressionUUID->"787c8cac-09a0-4628-a16c-9bd97e5d71d4"],
Cell[320753, 7161, 186, 4, 24, "Print",ExpressionUUID->"0dde040a-41ff-4822-8078-cba3cee60ada"],
Cell[320942, 7167, 186, 4, 24, "Print",ExpressionUUID->"b90a6596-5bd1-49a9-ba53-4c274fbdf25b"],
Cell[321131, 7173, 1034, 18, 24, "Print",ExpressionUUID->"cb0c68b8-5dce-4df2-aec1-625eba3e071c"],
Cell[322168, 7193, 656, 10, 24, "Print",ExpressionUUID->"62433847-18d4-4946-9e0c-31f09dfb2fd2"],
Cell[322827, 7205, 639, 10, 24, "Print",ExpressionUUID->"5a4e4df2-5945-4a6a-96c5-16ae8c2195b7"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[323527, 7222, 259, 4, 38, "Section",ExpressionUUID->"53ecbd33-5272-492c-852c-e5bf1a0b7721"],
Cell[CellGroupData[{
Cell[323811, 7230, 978, 21, 89, "Input",ExpressionUUID->"28c116c0-1f9f-4f2c-8abc-26a8e636817b"],
Cell[CellGroupData[{
Cell[324814, 7255, 434, 7, 24, "Print",ExpressionUUID->"85797c99-afef-436b-b980-1d6f6a594d8f"],
Cell[325251, 7264, 452, 7, 24, "Print",ExpressionUUID->"95e243a0-ab98-4f77-ae85-d1ec030c90ed"],
Cell[325706, 7273, 421, 7, 24, "Print",ExpressionUUID->"ee1b636b-3469-4f35-8c6c-c47bc9007959"],
Cell[326130, 7282, 427, 7, 24, "Print",ExpressionUUID->"3ccf1f11-8901-4292-8204-4898f76a63e4"],
Cell[326560, 7291, 556, 11, 24, "Print",ExpressionUUID->"29770907-bc6b-4e2a-a929-b058506d1eec"],
Cell[327119, 7304, 425, 7, 24, "Print",ExpressionUUID->"52282be9-1018-4d84-b5e0-671859252ced"],
Cell[327547, 7313, 415, 7, 24, "Print",ExpressionUUID->"a11677c5-6678-4f99-b636-3e4e863f12ed"],
Cell[327965, 7322, 462, 8, 24, "Print",ExpressionUUID->"1933dce5-a6ee-4b76-a991-4c7f8ea22886"],
Cell[328430, 7332, 411, 7, 24, "Print",ExpressionUUID->"12956392-089e-4615-8579-1d1a092afe02"],
Cell[328844, 7341, 444, 7, 24, "Print",ExpressionUUID->"546ac6e8-7e23-44b4-a649-b393fb1210d6"],
Cell[329291, 7350, 445, 7, 24, "Print",ExpressionUUID->"75241964-576a-4faf-a857-0c011bdba2d2"],
Cell[329739, 7359, 443, 7, 24, "Print",ExpressionUUID->"e971b67c-8225-49ba-b191-dfa45392d032"],
Cell[330185, 7368, 622, 12, 44, "Print",ExpressionUUID->"18664c6b-357d-4342-9104-8bb454361735"]
}, Open  ]],
Cell[330822, 7383, 388, 10, 24, "Message",ExpressionUUID->"43500c43-05bd-4774-a154-19ea36644ac2"],
Cell[CellGroupData[{
Cell[331235, 7397, 904, 17, 24, "Print",ExpressionUUID->"1bac0ca5-6dea-4116-88f0-e8ebf4cbd88f"],
Cell[332142, 7416, 1015, 21, 24, "Print",ExpressionUUID->"23772da3-20bb-49a3-9791-c8e46321efca"],
Cell[333160, 7439, 1006, 20, 24, "Print",ExpressionUUID->"535ff223-c7c1-47a2-a6fb-1c9ae3c88d71"]
}, Open  ]],
Cell[334181, 7462, 383, 10, 24, "Message",ExpressionUUID->"c7107f3f-28a6-4663-98b0-84bfeae00026"],
Cell[CellGroupData[{
Cell[334589, 7476, 895, 17, 24, "Print",ExpressionUUID->"38865933-390c-4507-856c-a5e8e928536f"],
Cell[335487, 7495, 432, 7, 24, "Print",ExpressionUUID->"863cf9a0-ab96-4358-b0d0-9c6d8eec3648"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[335968, 7508, 1657, 34, 241, "Input",ExpressionUUID->"ada2b80e-48de-4ea4-8904-96bb6ce4269d"],
Cell[CellGroupData[{
Cell[337650, 7546, 790, 15, 24, "Print",ExpressionUUID->"60ca7edb-f541-45d3-a4f4-a0581683fe01"],
Cell[338443, 7563, 567, 9, 24, "Print",ExpressionUUID->"30eff751-e4cb-4753-b127-3bf15542108f"],
Cell[339013, 7574, 561, 9, 24, "Print",ExpressionUUID->"17fc9198-c2a4-42ed-8bef-afd924385c55"],
Cell[339577, 7585, 602, 10, 24, "Print",ExpressionUUID->"3a069a5b-10fe-427f-b76e-e78784455ab5"]
}, Open  ]],
Cell[340194, 7598, 1110, 26, 62, "Output",ExpressionUUID->"8ef8e7a9-56ee-4427-b0df-d5abfd004bab"],
Cell[CellGroupData[{
Cell[341329, 7628, 620, 10, 24, "Print",ExpressionUUID->"3abcec94-6ea2-49a7-8449-0bafb455cce5"],
Cell[341952, 7640, 616, 10, 24, "Print",ExpressionUUID->"af6a461b-3939-492b-8b91-ade91cf6bf9c"],
Cell[342571, 7652, 811, 17, 24, "Print",ExpressionUUID->"e26c5907-a82f-4fc8-b164-a63b2efb9bc1"],
Cell[343385, 7671, 566, 9, 24, "Print",ExpressionUUID->"3e56152b-e697-49fe-8e43-6a8d9a48a0d5"],
Cell[343954, 7682, 557, 9, 24, "Print",ExpressionUUID->"25f78555-40ab-475f-991a-727683732769"],
Cell[344514, 7693, 679, 13, 24, "Print",ExpressionUUID->"9009ffd9-f7dc-4d7c-9e73-fa271e58ef90"],
Cell[345196, 7708, 566, 9, 24, "Print",ExpressionUUID->"fa5e68f8-6e71-43d4-9a2b-a3092966ad9a"]
}, Open  ]],
Cell[345777, 7720, 548, 9, 31, "Output",ExpressionUUID->"fe6c443d-05c2-478f-9468-2e0003df89fd"],
Cell[CellGroupData[{
Cell[346350, 7733, 811, 17, 24, "Print",ExpressionUUID->"00a6be77-ac2a-47ff-90b5-81595f769e8d"],
Cell[347164, 7752, 568, 9, 24, "Print",ExpressionUUID->"7544f856-0d3a-4483-851c-08669063a7c8"],
Cell[347735, 7763, 599, 10, 24, "Print",ExpressionUUID->"9af6e530-e70c-4fbd-9772-fdd9ba2d37d9"],
Cell[348337, 7775, 1078, 21, 24, "Print",ExpressionUUID->"2694cb2b-8fc5-4b8b-93c4-64ed18de3872"],
Cell[349418, 7798, 681, 13, 24, "Print",ExpressionUUID->"2572328d-4c0d-4324-8812-05d0205bafd3"]
}, Open  ]],
Cell[350114, 7814, 7492, 202, 92, "Output",ExpressionUUID->"0ce58716-9b82-46fd-a390-5f3c300753aa"],
Cell[CellGroupData[{
Cell[357631, 8020, 907, 17, 24, "Print",ExpressionUUID->"20b95ae6-9032-4b09-892b-67594c12dd2c"],
Cell[358541, 8039, 849, 18, 24, "Print",ExpressionUUID->"a465d649-d0f3-4ce3-a1f6-1645bd2262b2"],
Cell[359393, 8059, 814, 17, 24, "Print",ExpressionUUID->"f0cf56c5-404c-4ef0-93b4-e21f43c83d44"],
Cell[360210, 8078, 588, 10, 24, "Print",ExpressionUUID->"6c7ec2e9-43a8-4cce-8726-5d51e9cb5d16"],
Cell[360801, 8090, 811, 17, 24, "Print",ExpressionUUID->"68559266-de35-46c3-8d2b-4c214867b292"],
Cell[361615, 8109, 566, 9, 24, "Print",ExpressionUUID->"04e965aa-3cb8-47ac-a1c1-f38179f5ccad"],
Cell[362184, 8120, 750, 14, 24, "Print",ExpressionUUID->"b58c3a8f-7910-4ce4-81d4-33bca008bd1c"],
Cell[362937, 8136, 601, 10, 24, "Print",ExpressionUUID->"f29867e0-e4c0-4e87-9f46-e8961c88a775"],
Cell[363541, 8148, 1084, 21, 24, "Print",ExpressionUUID->"36a20ce5-bb81-4082-ae00-06115a9ff8cf"],
Cell[364628, 8171, 681, 13, 24, "Print",ExpressionUUID->"45f3035d-3f4e-4487-9929-d78b7a382970"],
Cell[365312, 8186, 1035, 20, 24, "Print",ExpressionUUID->"1d19f595-890e-4127-84e6-1f17a16894fd"],
Cell[366350, 8208, 582, 9, 24, "Print",ExpressionUUID->"0e9481d3-3a08-4256-a0fa-0e22c1877880"],
Cell[366935, 8219, 847, 18, 24, "Print",ExpressionUUID->"17810a74-f64f-4a52-904d-d99b6aa08c29"],
Cell[367785, 8239, 801, 17, 24, "Print",ExpressionUUID->"6bfc4ad6-449c-470d-97d7-3ae3b5c764ce"],
Cell[368589, 8258, 779, 14, 24, "Print",ExpressionUUID->"957a7ba8-f247-4691-8d68-9ebca5704951"]
}, Open  ]],
Cell[369383, 8275, 427, 9, 24, "Message",ExpressionUUID->"777d77dc-1a04-48ff-a6a8-957a4d701dc4"],
Cell[CellGroupData[{
Cell[369835, 8288, 767, 14, 24, "Print",ExpressionUUID->"c0670a75-1122-4f99-aa7c-bd0371916922"],
Cell[370605, 8304, 563, 9, 24, "Print",ExpressionUUID->"b75e6f93-b37b-4276-b1a9-1bf0e585de78"],
Cell[371171, 8315, 587, 10, 24, "Print",ExpressionUUID->"c4bab9a9-1432-4b17-afad-b3e0bed156c9"],
Cell[371761, 8327, 780, 14, 24, "Print",ExpressionUUID->"26e020ab-ef72-4338-8d2e-73588791c498"],
Cell[372544, 8343, 188, 4, 24, "Print",ExpressionUUID->"dd277b44-ee19-4bd8-96b8-7649e477f036"],
Cell[372735, 8349, 188, 4, 24, "Print",ExpressionUUID->"e9d6d0ed-0bd0-42dd-bcc7-fafc6931bbe7"],
Cell[372926, 8355, 186, 4, 24, "Print",ExpressionUUID->"2719f187-7768-4195-8b59-abb64ddb2a94"],
Cell[373115, 8361, 186, 4, 24, "Print",ExpressionUUID->"d62e7e14-fbd0-426d-b901-44367b6f5b01"],
Cell[373304, 8367, 937, 17, 24, "Print",ExpressionUUID->"3be7425b-beb9-44e3-a5ed-80013c789199"],
Cell[374244, 8386, 559, 9, 24, "Print",ExpressionUUID->"c6a34b83-8ccf-492b-b7ab-3d297e88f6c7"],
Cell[374806, 8397, 546, 9, 24, "Print",ExpressionUUID->"cd04bdb0-a386-40ac-9f77-a4305dc68aef"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[375401, 8412, 221, 4, 31, "Input",ExpressionUUID->"9b3e8b3f-1e6b-480c-8d31-b0341a561a01"],
Cell[375625, 8418, 224, 3, 27, "Output",ExpressionUUID->"11883441-ee12-4ae9-93a9-33ef38fea381"]
}, Open  ]]
}, Closed]]
}
]
*)

