(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    921734,      19860]
NotebookOptionsPosition[    900278,      19190]
NotebookOutlinePosition[    900870,      19212]
CellTagsIndexPosition[    900827,      19209]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["FeynArts and FormCalc", "Title",
 CellChangeTimes->{{3.4778117188657*^9, 3.4778117348357*^9}}],

Cell["test the 3 amplitudes computed before", "Text",
 CellChangeTimes->{{3.478438848916302*^9, 3.478438849192754*^9}, {
   3.479546643579921*^9, 3.479546660109585*^9}, 3.5001162993369827`*^9}],

Cell[CellGroupData[{

Cell["uu->tt", "Subtitle",
 CellChangeTimes->{{3.4778117420706997`*^9, 3.4778117447507*^9}, {
  3.5001158577529583`*^9, 3.500115857946549*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.448968342513181*^9, 3.448968344880295*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\</home/degrande/eta/FeynProg/FeynArts-3.5\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "FeynArts`"}]}], "Input",
 CellChangeTimes->{
  3.4777456682883*^9, 3.478434363232997*^9, 3.495271937325*^9, 
   3.495273775256*^9, {3.500110182753488*^9, 3.5001101841359262`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.495271942766*^9, 3.495271949283*^9}, 3.495275934381*^9, 
   3.495275980209*^9, 3.495276745436*^9, 3.4952772886940002`*^9, 
   3.495278198532*^9, 3.4952811762790003`*^9, 3.4952822222349997`*^9, 
   3.500110154976571*^9, {3.500110185064245*^9, 3.5001101933754053`*^9}, 
   3.5001108098376293`*^9, 3.500112832793943*^9, 3.5001132212678003`*^9, 
   3.500793632598936*^9, 3.500819336150868*^9, 3.500882407513138*^9}],

Cell[BoxData[
 FormBox["\<\"FeynArts 3.5\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.495271942766*^9, 3.495271949283*^9}, 3.495275934381*^9, 
   3.495275980209*^9, 3.495276745436*^9, 3.4952772886940002`*^9, 
   3.495278198532*^9, 3.4952811762790003`*^9, 3.4952822222349997`*^9, 
   3.500110154976571*^9, {3.500110185064245*^9, 3.5001101933754053`*^9}, 
   3.5001108098376293`*^9, 3.500112832793943*^9, 3.5001132212678003`*^9, 
   3.500793632598936*^9, 3.500819336150868*^9, 3.5008824075521708`*^9}],

Cell[BoxData[
 FormBox["\<\"by Hagen Eck, Sepp Kueblbeck, and Thomas Hahn\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{{3.495271942766*^9, 3.495271949283*^9}, 3.495275934381*^9, 
   3.495275980209*^9, 3.495276745436*^9, 3.4952772886940002`*^9, 
   3.495278198532*^9, 3.4952811762790003`*^9, 3.4952822222349997`*^9, 
   3.500110154976571*^9, {3.500110185064245*^9, 3.5001101933754053`*^9}, 
   3.5001108098376293`*^9, 3.500112832793943*^9, 3.5001132212678003`*^9, 
   3.500793632598936*^9, 3.500819336150868*^9, 3.5008824075729303`*^9}],

Cell[BoxData[
 FormBox["\<\"last revised 16 Apr 10\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.495271942766*^9, 3.495271949283*^9}, 3.495275934381*^9, 
   3.495275980209*^9, 3.495276745436*^9, 3.4952772886940002`*^9, 
   3.495278198532*^9, 3.4952811762790003`*^9, 3.4952822222349997`*^9, 
   3.500110154976571*^9, {3.500110185064245*^9, 3.5001101933754053`*^9}, 
   3.5001108098376293`*^9, 3.500112832793943*^9, 3.5001132212678003`*^9, 
   3.500793632598936*^9, 3.500819336150868*^9, 3.500882407592204*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"topo", " ", "=", " ", 
   RowBox[{"CreateTopologies", "[", 
    RowBox[{"0", ",", 
     RowBox[{"2", "\[Rule]", "2"}], ",", " ", 
     RowBox[{"Adjacencies", "\[Rule]", 
      RowBox[{"{", "3", "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.47548813810296*^9, 3.475488972088063*^9, {3.4777456120408*^9, 
   3.4777456332583*^9}, 3.4778098132447*^9, 3.4778110152581997`*^9, {
   3.5001115587562923`*^9, 3.500111580397962*^9}, {3.500111634475185*^9, 
   3.5001116428315163`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Paint", "[", "topo", "]"}]], "Input",
 CellChangeTimes->{{3.4777456818157997`*^9, 3.4777456889958*^9}, {
  3.500111015829336*^9, 3.5001110174838743`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.495271989648*^9, 3.495275983322*^9, 3.500111018446618*^9,
   3.5001116461921253`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 2, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.495271989648*^9, 3.495275983322*^9, 3.500111018446618*^9,
   3.50011164629797*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 3, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.495271989648*^9, 3.495275983322*^9, 3.500111018446618*^9,
   3.500111646306368*^9}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], LineBox[{{5.999999999990206, 10.}, {13.999999999982222`, 
        10.}}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 44}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{6.139089236967266*^-12, 15.}, {10.000000000002046`, 
        14.000000000003638`}}], 
       LineBox[{{-7.503331289626658*^-12, 5.000000000003638}, {
        9.999999999988404, 6.}}], 
       LineBox[{{20.000000000002956`, 15.}, {10.000000000002956`, 14.}}], 
       LineBox[{{19.999999999997726`, 4.999999999996362}, {9.999999999997726, 
        5.999999999996362}}], 
       LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T2\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{6.139089236967266*^-12, 15.}, {10.000000000002046`, 
        14.000000000003638`}}], 
       LineBox[{{-7.503331289626658*^-12, 5.000000000003638}, {
        9.999999999988404, 6.}}], 
       LineBox[{{20.00000000000182, 15.}, {10., 6.}}], 
       LineBox[{{20.00000000000182, 5.}, {10., 14.}}], 
       LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T3\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"2\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {28.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[RightArrow]\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {33., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"2\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {37.5, 69.96}, {0, 0}]},
   AspectRatio->1.0999999999999999`,
   PlotRange->{{0, 66}, {0, 72.6}}], TraditionalForm]], "Print",
 CellChangeTimes->{3.495271989648*^9, 3.495275983322*^9, 3.500111018446618*^9,
   3.5001116463187733`*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"FeynArtsGraphics", "(", 
    RowBox[{"2", "\[Rule]", "2"}], ")"}], "\[InvisibleApplication]", 
   RowBox[{"(", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T2\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T2", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T3\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T3", "]"],
           Editable->False],
          TraditionalForm]},
        {"Null", "Null", "Null"},
        {"Null", "Null", "Null"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.4777456905908003`*^9, 3.478435705207405*^9, 
  3.495271902317*^9, 3.495271990013*^9, 3.495275983486*^9, 
  3.50011101885795*^9, 3.500111646432447*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"INTopoqq", " ", "=", " ", 
   RowBox[{"InsertFields", "[", 
    RowBox[{"topo", ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"F", "[", "7", "]"}], ",", 
        RowBox[{"-", 
         RowBox[{"F", "[", "7", "]"}]}]}], "}"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"F", "[", "9", "]"}], ",", 
        RowBox[{"-", 
         RowBox[{"F", "[", "9", "]"}]}]}], "}"}]}], ",", 
     RowBox[{"GenericModel", "\[Rule]", "\"\<TopEffTh_FA/TopEffTh_FA\>\""}], 
     ",", 
     RowBox[{"Model", "\[Rule]", "\"\<TopEffTh_FA/TopEffTh_FA\>\""}], ",", 
     RowBox[{"ExcludeParticles", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"S", ",", 
        RowBox[{"V", "[", "1", "]"}], ",", 
        RowBox[{"V", "[", "2", "]"}], ",", 
        RowBox[{"V", "[", "3", "]"}]}], "}"}]}], ",", 
     RowBox[{"InsertionLevel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Generic", ",", "Classes"}], "}"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.4778060034077*^9, 3.4778060172207003`*^9}, {
   3.4778061181482*^9, 3.4778062060957003`*^9}, {3.4778064622107*^9, 
   3.4778064974032*^9}, {3.4778096875622*^9, 3.4778097175422*^9}, {
   3.4778099067622004`*^9, 3.4778099081296997`*^9}, {3.4778111168007*^9, 
   3.4778111226157*^9}, {3.4778115172907*^9, 3.4778115174282*^9}, 
   3.478437845209915*^9, {3.479546689667869*^9, 3.479546718821388*^9}, {
   3.479546793843457*^9, 3.47954680051448*^9}, 3.4952742275699997`*^9, {
   3.49527430859*^9, 3.495274311582*^9}, {3.500110127592201*^9, 
   3.500110148872984*^9}, {3.50011023482518*^9, 3.5001102598698807`*^9}, {
   3.500110817023205*^9, 3.500110825242276*^9}, {3.500111957435989*^9, 
   3.50011198241054*^9}, {3.500113240310526*^9, 3.500113263759314*^9}, {
   3.500882422013039*^9, 3.500882443247589*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.5008824440189667`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
    "\[InvisibleSpace]", "\<\"generic\"\>", 
    "\[InvisibleSpace]", "\<\" model file \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.gen\"\>"}],
   SequenceForm[
   "", "loading ", "generic", " model file ", 
    "/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.gen"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.5008824442075768`*^9}],

Cell[BoxData[
 FormBox["\<\"> $SVMixing is OFF\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.500882444213388*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"generic model \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", "\<\"TopEffTh_FA/TopEffTh_FA\"\>", "}"}], 
    "\[InvisibleSpace]", "\<\" initialized\"\>"}],
   SequenceForm[
   "generic model ", {"TopEffTh_FA/TopEffTh_FA"}, " initialized"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.500882444225608*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.500882444237073*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
    "\[InvisibleSpace]", "\<\"classes\"\>", 
    "\[InvisibleSpace]", "\<\" model file \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.mod\"\>"}],
   SequenceForm[
   "", "loading ", "classes", " model file ", 
    "/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.mod"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.50088244424944*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "51", 
    "\[InvisibleSpace]", "\<\" particles (incl. antiparticles) in \"\>", 
    "\[InvisibleSpace]", "30", "\[InvisibleSpace]", "\<\" classes\"\>"}],
   SequenceForm[
   "> ", 51, " particles (incl. antiparticles) in ", 30, " classes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.500882444261952*^9}],

Cell[BoxData[
 FormBox["\<\"> $CounterTerms are ON\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.500882444755748*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "142", 
    "\[InvisibleSpace]", "\<\" vertices\"\>"}],
   SequenceForm["> ", 142, " vertices"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.500882444961728*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"classes model \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", "\<\"TopEffTh_FA/TopEffTh_FA\"\>", "}"}], 
    "\[InvisibleSpace]", "\<\" initialized\"\>"}],
   SequenceForm[
   "classes model ", {"TopEffTh_FA/TopEffTh_FA"}, " initialized"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.500882444971599*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.500882445111467*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Excluding \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" Generic, \"\>", "\[InvisibleSpace]", "8", 
    "\[InvisibleSpace]", "\<\" Classes, and \"\>", "\[InvisibleSpace]", "8", 
    "\[InvisibleSpace]", "\<\" Particles fields\"\>"}],
   SequenceForm[
   "Excluding ", 1, " Generic, ", 8, " Classes, and ", 8, 
    " Particles fields"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.500882445246956*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.500882445385344*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"Generic", ",", "Classes"}], "}"}]}],
   SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.50088244552699*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 5 Classes insertions\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "1 Generic, 5 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.500882445671138*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
   SequenceForm["> Top. ", 2, ": ", "0 Generic, 0 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.500882445953889*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
   SequenceForm["> Top. ", 3, ": ", "0 Generic, 0 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.500882446102857*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.500882446252879*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Restoring \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" Generic, \"\>", "\[InvisibleSpace]", "8", 
    "\[InvisibleSpace]", "\<\" Classes, and \"\>", "\[InvisibleSpace]", "8", 
    "\[InvisibleSpace]", "\<\" Particles fields\"\>"}],
   SequenceForm[
   "Restoring ", 1, " Generic, ", 8, " Classes, and ", 8, 
    " Particles fields"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.500882446405074*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"in total: \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 5 Classes insertions\"\>"}],
   SequenceForm["in total: ", "1 Generic, 5 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, 
   3.5007936351654882`*^9, 3.5008193430625668`*^9, 3.500882446558971*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Paint", "[", "INTopoqq", "]"}]], "Input",
 CellChangeTimes->{{3.4778063315682*^9, 3.4778063464357*^9}, {
   3.4778115474231997`*^9, 3.4778115475632*^9}, 3.478437858916929*^9, 
   3.479546810801527*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"6 diagrams\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "6 diagrams"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.479546811928915*^9, 3.4952720143900003`*^9, 
  3.495274238238*^9, 3.4952743199230003`*^9, 3.495276316532*^9, 
  3.49527676376*^9, 3.500110224991707*^9, 3.500111668474367*^9, 
  3.500112840460973*^9, 3.500113227219717*^9, 3.5001132697596207`*^9, 
  3.500793645667091*^9, 3.500819346946624*^9, 3.500882451068842*^9}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       PolygonBox[{{3.4609327677584254`, 12.115889360201312`}, {
        2.2829934723757828`, 12.576822127959737`}, {2.7951409921073664`, 
        13.191399151637638`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"u\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{2.5390672322415746`, 7.1158893602013125`}, {
        3.7170065276242177`, 7.576822127959738}, {3.2048590078926336`, 
        8.191399151637638}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"u\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lG1QVFUYx8+KkQzjhyYZ3pfdPYc3hcHtFBRT+DBNCiq60Uy7IzXLLu1F
dBRzSYsSKNJsRlQQiIuYmYgrfKAALRxLAuVFTistTIOpRYysEDIyxlRQsT30
4dyZO3d+c+695zzP8///9fbCbMcyQsjLeC89J0d9eK0B8v/FIHSipfaGQF5x
bH5jAoPcryqP1qjIuVYS8QqDdd+VRtgUZEuwrakQ3zcuWhP5Egc22EsYiBR7
7oJvNRBwBJUcYLDvg+CV/QJ5+1s9q3Yx8G1+CLUq8tvuzsStDEx93r43FOSM
Y4vFsQyKpw8qnCMfL667t0ChKsDzq4Ygmy5unHFTaJrq8R8S8UBmv0lafoFC
TUb2F6dUZF1592gFhc0G8+AOBbms7pPeMgrVygNzCkce84btLKdgD+Db/Qhy
3MGivTUUvm0bjrgp4oD89bj3TAeFMpc4Xa8iWzIt2rsUorMtWkVBNk3megMY
eHP6u40ceVLTvOcZBgnta1r/9cVi/9Jic7YxuPhlwfyAQO6vKgwqYlA2/9KF
WhW5y5PwZimDKqPz6zwF2cV7/d9l4DdzYpWRL61rR2z5DC53dX2+6IvB/Sp+
friewcLZxReFQM4IONweyeBU86Nbqops6Wq8Pkuh52+2KV9BJrdn2q9TCE15
7tDTHNlVnf7DGQrn8i6Vawjy2jvxFR9TSB1NWu8W0UAO+x+4X0pB89G90XoV
2fX93icOURB/arPyFWSTfWrDSQrOPM8lzpGfrf5w+gqu330snhDk2Y6WYS+F
rcWNbUIwnOct6nkSz+eX9JqqIh/v05jTGGyKdMUoCvKspVVnY3DN75dAzpHX
/pE+vp9BnHtJfxTnl1o1iP1puKqbE4LK9aAmM9ZL5ffdV4fOKgqV/9cYcrI4
p3L/6on5H30+gzzfjDUxUwiDPH9541hbnWqQ9W0JCo91KAZZf/T0zU4jN8j+
XLZmvrfo08v+JTt63xkUetnfI5/91FGn6mX/u0NWYr16OR9HlOYK53o5v9rb
aa9riF7ON6t157Rb6OT83ZVHNjSoOqmPsYHOVwsUndTPyd9q/JO5TuqLTQ2b
lhGd1N+ce3dxgxol9blvfEsP51FSv5/ed3TdEFqpb8OwudemaKX+F5xq0rwv
UvqjrjPGVKlGSv/4z5kKVvNI6a+i89tOXxMR0n/O9v2PrEqE9Ge9M+f5f3zh
0r8ttt+fUtVw6W/SbNyTzMOl/7sf6EqGRZjMh5H3hyYKlTCZHysGUtcFkjCZ
L0eZH5xTQ2X+pC8nfS/wUJlPJOTO+IgIkfm1a/d5zw4lRObbzMiS/oJl/v0H
YYABMg==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"V\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 G1 N1\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 44}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       PolygonBox[{{3.4609327677584254`, 12.115889360201312`}, {
        2.2829934723757828`, 12.576822127959737`}, {2.7951409921073664`, 
        13.191399151637638`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"u\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{2.5390672322415746`, 7.1158893602013125`}, {
        3.7170065276242177`, 7.576822127959738}, {3.2048590078926336`, 
        8.191399151637638}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"u\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lgs4lGkbxyeHJbW7KtZphnm972uxCn0S8dVtUaImQiTr1Mgh1iGKlEOs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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 C1 N2\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       PolygonBox[{{3.4609327677584254`, 12.115889360201312`}, {
        2.2829934723757828`, 12.576822127959737`}, {2.7951409921073664`, 
        13.191399151637638`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"u\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{2.5390672322415746`, 7.1158893602013125`}, {
        3.7170065276242177`, 7.576822127959738}, {3.2048590078926336`, 
        8.191399151637638}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"u\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lG1QVFUYx8+KkQzjhyYZ3pfdPYc3hcHtFBRT+DBNCiq60Uy7IzXLLu1F
dBRzSYsSKNJsRlQQiIuYmYgrfKAALRxLAuVFTistTIOpRYysEDIyxlRQsT30
4dyZO3d+c+695zzP8///9fbCbMcyQsjLeC89J0d9eK0B8v/FIHSipfaGQF5x
bH5jAoPcryqP1qjIuVYS8QqDdd+VRtgUZEuwrakQ3zcuWhP5Egc22EsYiBR7
7oJvNRBwBJUcYLDvg+CV/QJ5+1s9q3Yx8G1+CLUq8tvuzsStDEx93r43FOSM
Y4vFsQyKpw8qnCMfL667t0ChKsDzq4Ygmy5unHFTaJrq8R8S8UBmv0lafoFC
TUb2F6dUZF1592gFhc0G8+AOBbms7pPeMgrVygNzCkce84btLKdgD+Db/Qhy
3MGivTUUvm0bjrgp4oD89bj3TAeFMpc4Xa8iWzIt2rsUorMtWkVBNk3megMY
eHP6u40ceVLTvOcZBgnta1r/9cVi/9Jic7YxuPhlwfyAQO6vKgwqYlA2/9KF
WhW5y5PwZimDKqPz6zwF2cV7/d9l4DdzYpWRL61rR2z5DC53dX2+6IvB/Sp+
friewcLZxReFQM4IONweyeBU86Nbqops6Wq8Pkuh52+2KV9BJrdn2q9TCE15
7tDTHNlVnf7DGQrn8i6Vawjy2jvxFR9TSB1NWu8W0UAO+x+4X0pB89G90XoV
2fX93icOURB/arPyFWSTfWrDSQrOPM8lzpGfrf5w+gqu330snhDk2Y6WYS+F
rcWNbUIwnOct6nkSz+eX9JqqIh/v05jTGGyKdMUoCvKspVVnY3DN75dAzpHX
/pE+vp9BnHtJfxTnl1o1iP1puKqbE4LK9aAmM9ZL5ffdV4fOKgqV/9cYcrI4
p3L/6on5H30+gzzfjDUxUwiDPH9541hbnWqQ9W0JCo91KAZZf/T0zU4jN8j+
XLZmvrfo08v+JTt63xkUetnfI5/91FGn6mX/u0NWYr16OR9HlOYK53o5v9rb
aa9riF7ON6t157Rb6OT83ZVHNjSoOqmPsYHOVwsUndTPyd9q/JO5TuqLTQ2b
lhGd1N+ce3dxgxol9blvfEsP51FSv5/ed3TdEFqpb8OwudemaKX+F5xq0rwv
UvqjrjPGVKlGSv/4z5kKVvNI6a+i89tOXxMR0n/O9v2PrEqE9Ge9M+f5f3zh
0r8ttt+fUtVw6W/SbNyTzMOl/7sf6EqGRZjMh5H3hyYKlTCZHysGUtcFkjCZ
L0eZH5xTQ2X+pC8nfS/wUJlPJOTO+IgIkfm1a/d5zw4lRObbzMiS/oJl/v0H
YYABMg==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"Tri0\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 C2 N3\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       PolygonBox[{{3.4609327677584254`, 12.115889360201312`}, {
        2.2829934723757828`, 12.576822127959737`}, {2.7951409921073664`, 
        13.191399151637638`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"u\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{2.5390672322415746`, 7.1158893602013125`}, {
        3.7170065276242177`, 7.576822127959738}, {3.2048590078926336`, 
        8.191399151637638}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"u\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lG1QVFUYx8+KkQzjhyYZ3pfdPYc3hcHtFBRT+DBNCiq60Uy7IzXLLu1F
dBRzSYsSKNJsRlQQiIuYmYgrfKAALRxLAuVFTistTIOpRYysEDIyxlRQsT30
4dyZO3d+c+695zzP8///9fbCbMcyQsjLeC89J0d9eK0B8v/FIHSipfaGQF5x
bH5jAoPcryqP1qjIuVYS8QqDdd+VRtgUZEuwrakQ3zcuWhP5Egc22EsYiBR7
7oJvNRBwBJUcYLDvg+CV/QJ5+1s9q3Yx8G1+CLUq8tvuzsStDEx93r43FOSM
Y4vFsQyKpw8qnCMfL667t0ChKsDzq4Ygmy5unHFTaJrq8R8S8UBmv0lafoFC
TUb2F6dUZF1592gFhc0G8+AOBbms7pPeMgrVygNzCkce84btLKdgD+Db/Qhy
3MGivTUUvm0bjrgp4oD89bj3TAeFMpc4Xa8iWzIt2rsUorMtWkVBNk3megMY
eHP6u40ceVLTvOcZBgnta1r/9cVi/9Jic7YxuPhlwfyAQO6vKgwqYlA2/9KF
WhW5y5PwZimDKqPz6zwF2cV7/d9l4DdzYpWRL61rR2z5DC53dX2+6IvB/Sp+
friewcLZxReFQM4IONweyeBU86Nbqops6Wq8Pkuh52+2KV9BJrdn2q9TCE15
7tDTHNlVnf7DGQrn8i6Vawjy2jvxFR9TSB1NWu8W0UAO+x+4X0pB89G90XoV
2fX93icOURB/arPyFWSTfWrDSQrOPM8lzpGfrf5w+gqu330snhDk2Y6WYS+F
rcWNbUIwnOct6nkSz+eX9JqqIh/v05jTGGyKdMUoCvKspVVnY3DN75dAzpHX
/pE+vp9BnHtJfxTnl1o1iP1puKqbE4LK9aAmM9ZL5ffdV4fOKgqV/9cYcrI4
p3L/6on5H30+gzzfjDUxUwiDPH9541hbnWqQ9W0JCo91KAZZf/T0zU4jN8j+
XLZmvrfo08v+JTt63xkUetnfI5/91FGn6mX/u0NWYr16OR9HlOYK53o5v9rb
aa9riF7ON6t157Rb6OT83ZVHNjSoOqmPsYHOVwsUndTPyd9q/JO5TuqLTQ2b
lhGd1N+ce3dxgxol9blvfEsP51FSv5/ed3TdEFqpb8OwudemaKX+F5xq0rwv
UvqjrjPGVKlGSv/4z5kKVvNI6a+i89tOXxMR0n/O9v2PrEqE9Ge9M+f5f3zh
0r8ttt+fUtVw6W/SbNyTzMOl/7sf6EqGRZjMh5H3hyYKlTCZHysGUtcFkjCZ
L0eZH5xTQ2X+pC8nfS/wUJlPJOTO+IgIkfm1a/d5zw4lRObbzMiS/oJl/v0H
YYABMg==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"Tri80\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 C3 N4\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 22}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       PolygonBox[{{3.4609327677584254`, 12.115889360201312`}, {
        2.2829934723757828`, 12.576822127959737`}, {2.7951409921073664`, 
        13.191399151637638`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"u\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{2.5390672322415746`, 7.1158893602013125`}, {
        3.7170065276242177`, 7.576822127959738}, {3.2048590078926336`, 
        8.191399151637638}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"u\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lG1QVFUYx8+KkQzjhyYZ3pfdPYc3hcHtFBRT+DBNCiq60Uy7IzXLLu1F
dBRzSYsSKNJsRlQQiIuYmYgrfKAALRxLAuVFTistTIOpRYysEDIyxlRQsT30
4dyZO3d+c+695zzP8///9fbCbMcyQsjLeC89J0d9eK0B8v/FIHSipfaGQF5x
bH5jAoPcryqP1qjIuVYS8QqDdd+VRtgUZEuwrakQ3zcuWhP5Egc22EsYiBR7
7oJvNRBwBJUcYLDvg+CV/QJ5+1s9q3Yx8G1+CLUq8tvuzsStDEx93r43FOSM
Y4vFsQyKpw8qnCMfL667t0ChKsDzq4Ygmy5unHFTaJrq8R8S8UBmv0lafoFC
TUb2F6dUZF1592gFhc0G8+AOBbms7pPeMgrVygNzCkce84btLKdgD+Db/Qhy
3MGivTUUvm0bjrgp4oD89bj3TAeFMpc4Xa8iWzIt2rsUorMtWkVBNk3megMY
eHP6u40ceVLTvOcZBgnta1r/9cVi/9Jic7YxuPhlwfyAQO6vKgwqYlA2/9KF
WhW5y5PwZimDKqPz6zwF2cV7/d9l4DdzYpWRL61rR2z5DC53dX2+6IvB/Sp+
friewcLZxReFQM4IONweyeBU86Nbqops6Wq8Pkuh52+2KV9BJrdn2q9TCE15
7tDTHNlVnf7DGQrn8i6Vawjy2jvxFR9TSB1NWu8W0UAO+x+4X0pB89G90XoV
2fX93icOURB/arPyFWSTfWrDSQrOPM8lzpGfrf5w+gqu330snhDk2Y6WYS+F
rcWNbUIwnOct6nkSz+eX9JqqIh/v05jTGGyKdMUoCvKspVVnY3DN75dAzpHX
/pE+vp9BnHtJfxTnl1o1iP1puKqbE4LK9aAmM9ZL5ffdV4fOKgqV/9cYcrI4
p3L/6on5H30+gzzfjDUxUwiDPH9541hbnWqQ9W0JCo91KAZZf/T0zU4jN8j+
XLZmvrfo08v+JTt63xkUetnfI5/91FGn6mX/u0NWYr16OR9HlOYK53o5v9rb
aa9riF7ON6t157Rb6OT83ZVHNjSoOqmPsYHOVwsUndTPyd9q/JO5TuqLTQ2b
lhGd1N+ce3dxgxol9blvfEsP51FSv5/ed3TdEFqpb8OwudemaKX+F5xq0rwv
UvqjrjPGVKlGSv/4z5kKVvNI6a+i89tOXxMR0n/O9v2PrEqE9Ge9M+f5f3zh
0r8ttt+fUtVw6W/SbNyTzMOl/7sf6EqGRZjMh5H3hyYKlTCZHysGUtcFkjCZ
L0eZH5xTQ2X+pC8nfS/wUJlPJOTO+IgIkfm1a/d5zw4lRObbzMiS/oJl/v0H
YYABMg==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"V8t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 C4 N5\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 22}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       PolygonBox[{{3.4609327677584254`, 12.115889360201312`}, {
        2.2829934723757828`, 12.576822127959737`}, {2.7951409921073664`, 
        13.191399151637638`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"u\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{2.5390672322415746`, 7.1158893602013125`}, {
        3.7170065276242177`, 7.576822127959738}, {3.2048590078926336`, 
        8.191399151637638}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"u\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lG1QVFUYx8+KkQzjhyYZ3pfdPYc3hcHtFBRT+DBNCiq60Uy7IzXLLu1F
dBRzSYsSKNJsRlQQiIuYmYgrfKAALRxLAuVFTistTIOpRYysEDIyxlRQsT30
4dyZO3d+c+695zzP8///9fbCbMcyQsjLeC89J0d9eK0B8v/FIHSipfaGQF5x
bH5jAoPcryqP1qjIuVYS8QqDdd+VRtgUZEuwrakQ3zcuWhP5Egc22EsYiBR7
7oJvNRBwBJUcYLDvg+CV/QJ5+1s9q3Yx8G1+CLUq8tvuzsStDEx93r43FOSM
Y4vFsQyKpw8qnCMfL667t0ChKsDzq4Ygmy5unHFTaJrq8R8S8UBmv0lafoFC
TUb2F6dUZF1592gFhc0G8+AOBbms7pPeMgrVygNzCkce84btLKdgD+Db/Qhy
3MGivTUUvm0bjrgp4oD89bj3TAeFMpc4Xa8iWzIt2rsUorMtWkVBNk3megMY
eHP6u40ceVLTvOcZBgnta1r/9cVi/9Jic7YxuPhlwfyAQO6vKgwqYlA2/9KF
WhW5y5PwZimDKqPz6zwF2cV7/d9l4DdzYpWRL61rR2z5DC53dX2+6IvB/Sp+
friewcLZxReFQM4IONweyeBU86Nbqops6Wq8Pkuh52+2KV9BJrdn2q9TCE15
7tDTHNlVnf7DGQrn8i6Vawjy2jvxFR9TSB1NWu8W0UAO+x+4X0pB89G90XoV
2fX93icOURB/arPyFWSTfWrDSQrOPM8lzpGfrf5w+gqu330snhDk2Y6WYS+F
rcWNbUIwnOct6nkSz+eX9JqqIh/v05jTGGyKdMUoCvKspVVnY3DN75dAzpHX
/pE+vp9BnHtJfxTnl1o1iP1puKqbE4LK9aAmM9ZL5ffdV4fOKgqV/9cYcrI4
p3L/6on5H30+gzzfjDUxUwiDPH9541hbnWqQ9W0JCo91KAZZf/T0zU4jN8j+
XLZmvrfo08v+JTt63xkUetnfI5/91FGn6mX/u0NWYr16OR9HlOYK53o5v9rb
aa9riF7ON6t157Rb6OT83ZVHNjSoOqmPsYHOVwsUndTPyd9q/JO5TuqLTQ2b
lhGd1N+ce3dxgxol9blvfEsP51FSv5/ed3TdEFqpb8OwudemaKX+F5xq0rwv
UvqjrjPGVKlGSv/4z5kKVvNI6a+i89tOXxMR0n/O9v2PrEqE9Ge9M+f5f3zh
0r8ttt+fUtVw6W/SbNyTzMOl/7sf6EqGRZjMh5H3hyYKlTCZHysGUtcFkjCZ
L0eZH5xTQ2X+pC8nfS/wUJlPJOTO+IgIkfm1a/d5zw4lRObbzMiS/oJl/v0H
YYABMg==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"V8Q\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 C5 N6\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 22}, {0, 0}, {22, 22}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"u\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {24., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"u\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {28.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[RightArrow]\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {33., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"t\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {37.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"t\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {42., 69.96}, {0, 0}]},
   AspectRatio->1.0999999999999999`,
   PlotRange->{{0, 66}, {0, 72.6}}], TraditionalForm]], "Print",
 CellChangeTimes->{3.479546811928915*^9, 3.4952720143900003`*^9, 
  3.495274238238*^9, 3.4952743199230003`*^9, 3.495276316532*^9, 
  3.49527676376*^9, 3.500110224991707*^9, 3.500111668474367*^9, 
  3.500112840460973*^9, 3.500113227219717*^9, 3.5001132697596207`*^9, 
  3.500793645667091*^9, 3.500819346946624*^9, 3.50088245384809*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"FeynArtsGraphics", "(", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"u\"\>", ",", "\<\"u\"\>"}], "}"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\<\"t\"\>", ",", "\<\"t\"\>"}], "}"}]}], ")"}], 
   "\[InvisibleApplication]", 
   RowBox[{"(", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 G1 N1\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 G1 N1", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 C1 N2\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 C1 N2", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 C2 N3\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 C2 N3", "]"],
           Editable->False],
          TraditionalForm]},
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 C3 N4\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 C3 N4", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 C4 N5\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 C4 N5", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 C5 N6\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 C5 N6", "]"],
           Editable->False],
          TraditionalForm]},
        {"Null", "Null", "Null"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.4778063475407*^9, 3.4778065254607*^9, 3.4778099157272*^9, 
   3.4778115492682*^9, 3.47843686984159*^9, 3.478436906375371*^9, {
   3.478437853618226*^9, 3.478437860811162*^9}, 3.479099999826127*^9, 
   3.479106333796554*^9, {3.479546806741183*^9, 3.479546812623714*^9}, 
   3.495272014652*^9, 3.495274238559*^9, 3.495274320167*^9, 3.495276316769*^9,
    3.495276764039*^9, 3.500110227529645*^9, 3.500111668952627*^9, 
   3.500112840863007*^9, 3.50011322761375*^9, 3.500113270045206*^9, 
   3.500793648440404*^9, 3.500819347278677*^9, 3.500882453998088*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Amplqq", " ", "=", " ", 
   RowBox[{"CreateFeynAmp", "[", "INTopoqq", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4778062370957003`*^9, 3.4778062399307003`*^9}, {
   3.4778115657332*^9, 3.4778115658507*^9}, {3.4778120221097*^9, 
   3.4778120222467003`*^9}, 3.479547360479462*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778115712007*^9, {3.4778120234797*^9, 3.4778120430657*^9}, 
   3.478434383755428*^9, 3.478435578790159*^9, 3.478435879919781*^9, 
   3.478436801285664*^9, 3.478436912149393*^9, 3.479546827897663*^9, 
   3.479547326278256*^9, 3.479547708182675*^9, 3.4952721609779997`*^9, 
   3.4952743519700003`*^9, 3.495276425449*^9, 3.495276773883*^9, 
   3.495277303781*^9, 3.495278211932*^9, 3.495281183468*^9, 3.495282230146*^9,
    3.500113289384753*^9, 3.500793652002124*^9, 3.500819348454228*^9, 
   3.5008824605107613`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"Generic", ",", "Classes"}], "}"}]}],
   SequenceForm[
   "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778115712007*^9, {3.4778120234797*^9, 3.4778120430657*^9}, 
   3.478434383755428*^9, 3.478435578790159*^9, 3.478435879919781*^9, 
   3.478436801285664*^9, 3.478436912149393*^9, 3.479546827897663*^9, 
   3.479547326278256*^9, 3.479547708182675*^9, 3.4952721609779997`*^9, 
   3.4952743519700003`*^9, 3.495276425449*^9, 3.495276773883*^9, 
   3.495277303781*^9, 3.495278211932*^9, 3.495281183468*^9, 3.495282230146*^9,
    3.500113289384753*^9, 3.500793652002124*^9, 3.500819348454228*^9, 
   3.50088246065234*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 5 Classes amplitudes\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "1 Generic, 5 Classes amplitudes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778115712007*^9, {3.4778120234797*^9, 3.4778120430657*^9}, 
   3.478434383755428*^9, 3.478435578790159*^9, 3.478435879919781*^9, 
   3.478436801285664*^9, 3.478436912149393*^9, 3.479546827897663*^9, 
   3.479547326278256*^9, 3.479547708182675*^9, 3.4952721609779997`*^9, 
   3.4952743519700003`*^9, 3.495276425449*^9, 3.495276773883*^9, 
   3.495277303781*^9, 3.495278211932*^9, 3.495281183468*^9, 3.495282230146*^9,
    3.500113289384753*^9, 3.500793652002124*^9, 3.500819348454228*^9, 
   3.500882460660486*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"in total: \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 5 Classes amplitudes\"\>"}],
   SequenceForm["in total: ", "1 Generic, 5 Classes amplitudes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778115712007*^9, {3.4778120234797*^9, 3.4778120430657*^9}, 
   3.478434383755428*^9, 3.478435578790159*^9, 3.478435879919781*^9, 
   3.478436801285664*^9, 3.478436912149393*^9, 3.479546827897663*^9, 
   3.479547326278256*^9, 3.479547708182675*^9, 3.4952721609779997`*^9, 
   3.4952743519700003`*^9, 3.495276425449*^9, 3.495276773883*^9, 
   3.495277303781*^9, 3.495278211932*^9, 3.495281183468*^9, 3.495282230146*^9,
    3.500113289384753*^9, 3.500793652002124*^9, 3.500819348454228*^9, 
   3.500882460668379*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\</home/degrande/eta/FeynProg/FormCalc-6.2\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "FormCalc`"}]}], "Input",
 CellChangeTimes->{
  3.4777456682883*^9, {3.4778119018507*^9, 3.4778119054056997`*^9}, {
   3.4778119371527*^9, 3.4778119527257*^9}, {3.478434390853149*^9, 
   3.478434394596879*^9}, {3.500113298082315*^9, 3.5001132986342363`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.500113299063477*^9, 3.5007936540015497`*^9, 3.5008193503825283`*^9, 
  3.500882462744792*^9}],

Cell[BoxData[
 FormBox["\<\"FormCalc 6.2\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.500113299063477*^9, 3.5007936540015497`*^9, 3.5008193503825283`*^9, 
  3.500882462815269*^9}],

Cell[BoxData[
 FormBox["\<\"by Thomas Hahn\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.500113299063477*^9, 3.5007936540015497`*^9, 3.5008193503825283`*^9, 
  3.50088246282187*^9}],

Cell[BoxData[
 FormBox["\<\"last revised 11 Aug 10\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.500113299063477*^9, 3.5007936540015497`*^9, 3.5008193503825283`*^9, 
  3.50088246282864*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mqq", " ", "=", " ", 
   RowBox[{"CalcFeynAmp", "[", 
    RowBox[{"Amplqq", ",", 
     RowBox[{"FermionChains", "\[Rule]", "Chiral"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.4778119845017*^9, 3.4778120345607*^9}, {
   3.478435376938886*^9, 3.478435418868291*^9}, 3.479547358194307*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.478434402570528*^9, 3.478435422620416*^9, 
  3.478435588542779*^9, 3.478435896246393*^9, 3.478436924110362*^9, 
  3.479100051862622*^9, 3.479106355014496*^9, 3.479546852661124*^9, 
  3.479547334202314*^9, 3.479547712295999*^9, 3.500113303957884*^9, 
  3.500793655605455*^9, 3.5008193518213997`*^9, 3.500882465836466*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.478434402570528*^9, 3.478435422620416*^9, 
  3.478435588542779*^9, 3.478435896246393*^9, 3.478436924110362*^9, 
  3.479100051862622*^9, 3.479106355014496*^9, 3.479546852661124*^9, 
  3.479547334202314*^9, 3.479547712295999*^9, 3.500113303957884*^9, 
  3.500793655605455*^9, 3.5008193518213997`*^9, 3.5008824659087887`*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{3.478434402570528*^9, 3.478435422620416*^9, 
  3.478435588542779*^9, 3.478435896246393*^9, 3.478436924110362*^9, 
  3.479100051862622*^9, 3.479106355014496*^9, 3.479546852661124*^9, 
  3.479547334202314*^9, 3.479547712295999*^9, 3.500113303957884*^9, 
  3.500793655605455*^9, 3.5008193518213997`*^9, 3.500882466094677*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.478434402570528*^9, 3.478435422620416*^9, 
  3.478435588542779*^9, 3.478435896246393*^9, 3.478436924110362*^9, 
  3.479100051862622*^9, 3.479106355014496*^9, 3.479546852661124*^9, 
  3.479547334202314*^9, 3.479547712295999*^9, 3.500113303957884*^9, 
  3.500793655605455*^9, 3.5008193518213997`*^9, 3.500882466422512*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"col", "=", 
  RowBox[{"ColourME", "[", "Mqq", "]"}]}]], "Input",
 CellChangeTimes->{{3.478434696113564*^9, 3.478434729084623*^9}, {
  3.478435197289632*^9, 3.478435232835993*^9}, {3.478436054623279*^9, 
  3.478436055525961*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Mat", "(", 
      RowBox[{"SUN1", ",", "SUN2"}], ")"}], "\[Rule]", "3"}], ",", 
    RowBox[{
     RowBox[{"Mat", "(", 
      RowBox[{"SUN1", ",", "SUN1"}], ")"}], "\[Rule]", "9"}], ",", 
    RowBox[{
     RowBox[{"Mat", "(", 
      RowBox[{"SUN2", ",", "SUN2"}], ")"}], "\[Rule]", "9"}], ",", 
    RowBox[{
     RowBox[{"Mat", "(", 
      RowBox[{"SUN2", ",", "SUN1"}], ")"}], "\[Rule]", "3"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.478434730426236*^9, 3.478435200749498*^9, 
  3.478435233950212*^9, 3.478435426393788*^9, 3.478435591077346*^9, 
  3.478435927320691*^9, 3.478436057790335*^9, 3.478436928353135*^9, 
  3.479100063362775*^9, 3.479106358816292*^9, 3.479546864822269*^9, 
  3.479547348022377*^9, 3.479547714372858*^9, 3.500113308549095*^9, 
  3.500793657293263*^9, 3.50081935325196*^9, 3.500882469472395*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"_Hel", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hel", "=", 
   RowBox[{"HelicityME", "[", "Mqq", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.478435272631223*^9, 3.478435280805309*^9}, {
   3.478435549596737*^9, 3.478435557227066*^9}, {3.478436067208497*^9, 
   3.478436071671449*^9}, {3.478436592499899*^9, 3.478436607261712*^9}, 
   3.479547354402557*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "64", 
    "\[InvisibleSpace]", "\<\" helicity matrix elements\"\>"}],
   SequenceForm["> ", 64, " helicity matrix elements"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.478435541414897*^9, 3.478435592470004*^9, 
  3.478435933573625*^9, 3.478436072748205*^9, 3.478436610903903*^9, 
  3.478436931796526*^9, 3.47910006737685*^9, 3.479106361221098*^9, 
  3.479546867343088*^9, 3.479547349361385*^9, 3.479547716089566*^9, 
  3.500113312071175*^9, 3.500793658258705*^9, 3.500819354245208*^9, 
  3.5008824715364103`*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.478435541414897*^9, 3.478435592470004*^9, 
  3.478435933573625*^9, 3.478436072748205*^9, 3.478436610903903*^9, 
  3.478436931796526*^9, 3.47910006737685*^9, 3.479106361221098*^9, 
  3.479546867343088*^9, 3.479547349361385*^9, 3.479547716089566*^9, 
  3.500113312071175*^9, 3.500793658258705*^9, 3.500819354245208*^9, 
  3.500882471656514*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.478435541414897*^9, 3.478435592470004*^9, 
  3.478435933573625*^9, 3.478436072748205*^9, 3.478436610903903*^9, 
  3.478436931796526*^9, 3.47910006737685*^9, 3.479106361221098*^9, 
  3.479546867343088*^9, 3.479547349361385*^9, 3.479547716089566*^9, 
  3.500113312071175*^9, 3.500793658258705*^9, 3.500819354245208*^9, 
  3.500882471664732*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{3.478435541414897*^9, 3.478435592470004*^9, 
  3.478435933573625*^9, 3.478436072748205*^9, 3.478436610903903*^9, 
  3.478436931796526*^9, 3.47910006737685*^9, 3.479106361221098*^9, 
  3.479546867343088*^9, 3.479547349361385*^9, 3.479547716089566*^9, 
  3.500113312071175*^9, 3.500793658258705*^9, 3.500819354245208*^9, 
  3.500882471679557*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.478435541414897*^9, 3.478435592470004*^9, 
  3.478435933573625*^9, 3.478436072748205*^9, 3.478436610903903*^9, 
  3.478436931796526*^9, 3.47910006737685*^9, 3.479106361221098*^9, 
  3.479546867343088*^9, 3.479547349361385*^9, 3.479547716089566*^9, 
  3.500113312071175*^9, 3.500793658258705*^9, 3.500819354245208*^9, 
  3.500882471998289*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mqq2", "=", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"SquaredME", "[", "Mqq", "]"}], "/.", "col"}], "/.", "hel"}],
        "/.", 
       RowBox[{"{", 
        RowBox[{"MU2", "\[Rule]", "0"}], "}"}]}], "/.", "M$FACouplings"}], 
     ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"v", "\[Element]", "Reals"}], ",", 
        RowBox[{"g8t", "\[Element]", "Reals"}], ",", 
        RowBox[{"g8Q", "\[Element]", "Reals"}], ",", 
        RowBox[{"MTri", "\[Element]", "Reals"}], ",", 
        RowBox[{"MTri8", "\[Element]", "Reals"}], ",", 
        RowBox[{"M8t", "\[Element]", "Reals"}], ",", 
        RowBox[{"M8Q", "\[Element]", "Reals"}], ",", 
        RowBox[{"g8tu", "\[Element]", "Reals"}], ",", 
        RowBox[{"g8Qu", "\[Element]", "Reals"}], ",", 
        RowBox[{"g8tq", "\[Element]", "Reals"}], ",", 
        RowBox[{"g8Qq", "\[Element]", "Reals"}], ",", 
        RowBox[{"g8td", "\[Element]", "Reals"}], ",", 
        RowBox[{"g8Qd", "\[Element]", "Reals"}], ",", 
        RowBox[{"gT8", "\[Element]", "Reals"}], ",", 
        RowBox[{"gT8l", "\[Element]", "Reals"}], ",", 
        RowBox[{"Lambda", "\[Element]", "Reals"}]}], "}"}]}]}], "]"}], "/.", 
   RowBox[{
    RowBox[{"Den", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], "\[Rule]", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.478436009927547*^9, 3.478436018997932*^9}, {
   3.478436082403898*^9, 3.478436090700395*^9}, {3.478436177508675*^9, 
   3.47843618204671*^9}, {3.478437003898071*^9, 3.47843701110685*^9}, {
   3.478437477803822*^9, 3.478437504302616*^9}, {3.479106936214095*^9, 
   3.479106948049022*^9}, {3.479107333470424*^9, 3.479107353663611*^9}, {
   3.500113559090603*^9, 3.500113796301057*^9}, 3.5001143361762466`*^9, {
   3.500882516077317*^9, 3.500882531653469*^9}, {3.500882595446957*^9, 
   3.50088259717521*^9}, 3.500883335537979*^9, {3.500883372259367*^9, 
   3.50088338188055*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"4", " ", 
     SuperscriptBox["Lambda", "4"]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["g8Qu", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"MT2", "-", "T"}], ")"}], "2"]}], "+", 
            RowBox[{
             SuperscriptBox["g8Qq", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"MT2", "-", "U"}], ")"}], "2"]}]}], ")"}], " ", 
          SuperscriptBox["g8Q", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"S", "-", 
            SuperscriptBox["M8Q", "2"]}], ")"}], "2"]], "+", 
        FractionBox[
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"g8Qq", " ", "gT8", " ", "gT8l", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"MT2", "-", "U"}], ")"}], "2"]}], 
             RowBox[{"S", "-", 
              SuperscriptBox["MTri8", "2"]}]], "+", 
            FractionBox[
             RowBox[{"g8t", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"g8Qq", " ", "g8tq"}], "+", 
                RowBox[{"g8Qu", " ", "g8tu"}]}], ")"}], " ", "MT2", " ", 
              "S"}], 
             RowBox[{"S", "-", 
              SuperscriptBox["M8t", "2"]}]]}], ")"}], " ", "g8Q"}], 
         RowBox[{"S", "-", 
          SuperscriptBox["M8Q", "2"]}]], "+", 
        FractionBox[
         RowBox[{"2", " ", 
          SuperscriptBox["g8t", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["g8tq", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"MT2", "-", "T"}], ")"}], "2"]}], "+", 
            RowBox[{
             SuperscriptBox["g8tu", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"MT2", "-", "U"}], ")"}], "2"]}]}], ")"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"S", "-", 
            SuperscriptBox["M8t", "2"]}], ")"}], "2"]], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"MT2", "-", "U"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", 
             SuperscriptBox["gT8", "2"], " ", 
             SuperscriptBox["gT8l", "2"]}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"S", "-", 
               SuperscriptBox["MTri8", "2"]}], ")"}], "2"]], "+", 
           FractionBox[
            RowBox[{"9", " ", "gT", " ", "gTl", " ", 
             SuperscriptBox["gT", "\[Conjugate]"], " ", 
             SuperscriptBox["gTl", "\[Conjugate]"]}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"S", "-", 
               SuperscriptBox["MTri", "2"]}], ")"}], "2"]]}], ")"}]}], "+", 
        FractionBox[
         RowBox[{
         "4", " ", "g8t", " ", "g8tq", " ", "gT8", " ", "gT8l", " ", "MT2", 
          " ", "S"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"S", "-", 
            SuperscriptBox["M8t", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"S", "-", 
            SuperscriptBox["MTri8", "2"]}], ")"}]}]]}], ")"}], " ", 
      SuperscriptBox["Lambda", "4"]}], "+", 
     RowBox[{
      FractionBox["1", "S"], 
      RowBox[{"8", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FractionBox["1", 
           RowBox[{"S", "-", 
            SuperscriptBox["MTri8", "2"]}]], 
          RowBox[{"gT8", " ", "gT8l", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "Alfas", " ", "\[Pi]", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["MT2", "2"], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"S", "-", 
                   RowBox[{"2", " ", "U"}]}], ")"}], " ", "MT2"}], "+", 
                SuperscriptBox["U", "2"]}], ")"}], " ", 
              SuperscriptBox["Lambda", "2"]}], "+", 
             RowBox[{
              SqrtBox["2"], " ", "CtG", " ", "GS", " ", "MT", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"MT2", " ", 
                 RowBox[{"(", 
                  RowBox[{"S", "-", 
                   RowBox[{"2", " ", "U"}]}], ")"}]}], "+", 
                RowBox[{"U", " ", 
                 RowBox[{"(", 
                  RowBox[{"T", "+", "U"}], ")"}]}]}], ")"}], " ", "v"}], "+", 
             
             RowBox[{
              SqrtBox["2"], " ", "GS", " ", "MT", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"MT2", " ", 
                 RowBox[{"(", 
                  RowBox[{"S", "-", 
                   RowBox[{"2", " ", "U"}]}], ")"}]}], "+", 
                RowBox[{"U", " ", 
                 RowBox[{"(", 
                  RowBox[{"T", "+", "U"}], ")"}]}]}], ")"}], " ", "v", " ", 
              SuperscriptBox["CtG", "\[Conjugate]"]}]}], ")"}]}]}], "+", 
         RowBox[{
          FractionBox["1", 
           RowBox[{"S", "-", 
            SuperscriptBox["M8Q", "2"]}]], 
          RowBox[{"g8Q", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "Alfas", " ", "\[Pi]", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"g8Qu", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["MT2", "2"], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"S", "-", 
                    RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
                   SuperscriptBox["T", "2"]}], ")"}]}], "+", 
                RowBox[{"g8Qq", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["MT2", "2"], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"S", "-", 
                    RowBox[{"2", " ", "U"}]}], ")"}], " ", "MT2"}], "+", 
                   SuperscriptBox["U", "2"]}], ")"}]}]}], ")"}], " ", 
              SuperscriptBox["Lambda", "2"]}], "+", 
             RowBox[{
              SqrtBox["2"], " ", "CtG", " ", "GS", " ", "MT", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"g8Qu", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"MT2", " ", 
                    RowBox[{"(", 
                    RowBox[{"S", "-", 
                    RowBox[{"2", " ", "T"}]}], ")"}]}], "+", 
                   RowBox[{"T", " ", 
                    RowBox[{"(", 
                    RowBox[{"T", "+", "U"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{"g8Qq", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"MT2", " ", 
                    RowBox[{"(", 
                    RowBox[{"S", "-", 
                    RowBox[{"2", " ", "U"}]}], ")"}]}], "+", 
                   RowBox[{"U", " ", 
                    RowBox[{"(", 
                    RowBox[{"T", "+", "U"}], ")"}]}]}], ")"}]}]}], ")"}], " ",
               "v"}], "+", 
             RowBox[{
              SqrtBox["2"], " ", "GS", " ", "MT", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"g8Qu", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"MT2", " ", 
                    RowBox[{"(", 
                    RowBox[{"S", "-", 
                    RowBox[{"2", " ", "T"}]}], ")"}]}], "+", 
                   RowBox[{"T", " ", 
                    RowBox[{"(", 
                    RowBox[{"T", "+", "U"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{"g8Qq", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"MT2", " ", 
                    RowBox[{"(", 
                    RowBox[{"S", "-", 
                    RowBox[{"2", " ", "U"}]}], ")"}]}], "+", 
                   RowBox[{"U", " ", 
                    RowBox[{"(", 
                    RowBox[{"T", "+", "U"}], ")"}]}]}], ")"}]}]}], ")"}], " ",
               "v", " ", 
              SuperscriptBox["CtG", "\[Conjugate]"]}]}], ")"}]}]}], "+", 
         RowBox[{
          FractionBox["1", 
           RowBox[{"S", "-", 
            SuperscriptBox["M8t", "2"]}]], 
          RowBox[{"g8t", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "Alfas", " ", "\[Pi]", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"g8tq", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["MT2", "2"], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"S", "-", 
                    RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
                   SuperscriptBox["T", "2"]}], ")"}]}], "+", 
                RowBox[{"g8tu", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["MT2", "2"], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"S", "-", 
                    RowBox[{"2", " ", "U"}]}], ")"}], " ", "MT2"}], "+", 
                   SuperscriptBox["U", "2"]}], ")"}]}]}], ")"}], " ", 
              SuperscriptBox["Lambda", "2"]}], "+", 
             RowBox[{
              SqrtBox["2"], " ", "CtG", " ", "GS", " ", "MT", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"g8tq", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"MT2", " ", 
                    RowBox[{"(", 
                    RowBox[{"S", "-", 
                    RowBox[{"2", " ", "T"}]}], ")"}]}], "+", 
                   RowBox[{"T", " ", 
                    RowBox[{"(", 
                    RowBox[{"T", "+", "U"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{"g8tu", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"MT2", " ", 
                    RowBox[{"(", 
                    RowBox[{"S", "-", 
                    RowBox[{"2", " ", "U"}]}], ")"}]}], "+", 
                   RowBox[{"U", " ", 
                    RowBox[{"(", 
                    RowBox[{"T", "+", "U"}], ")"}]}]}], ")"}]}]}], ")"}], " ",
               "v"}], "+", 
             RowBox[{
              SqrtBox["2"], " ", "GS", " ", "MT", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"g8tq", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"MT2", " ", 
                    RowBox[{"(", 
                    RowBox[{"S", "-", 
                    RowBox[{"2", " ", "T"}]}], ")"}]}], "+", 
                   RowBox[{"T", " ", 
                    RowBox[{"(", 
                    RowBox[{"T", "+", "U"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{"g8tu", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"MT2", " ", 
                    RowBox[{"(", 
                    RowBox[{"S", "-", 
                    RowBox[{"2", " ", "U"}]}], ")"}]}], "+", 
                   RowBox[{"U", " ", 
                    RowBox[{"(", 
                    RowBox[{"T", "+", "U"}], ")"}]}]}], ")"}]}]}], ")"}], " ",
               "v", " ", 
              SuperscriptBox["CtG", "\[Conjugate]"]}]}], ")"}]}]}]}], ")"}], 
       " ", 
       SuperscriptBox["Lambda", "2"]}]}], "+", 
     RowBox[{
      FractionBox["1", 
       SuperscriptBox["S", "2"]], 
      RowBox[{"64", " ", "\[Pi]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Alfas2", " ", "\[Pi]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["MT2", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "-", "T", "-", "U"}], ")"}], " ", "MT2"}], "+", 
            SuperscriptBox["T", "2"], "+", 
            SuperscriptBox["U", "2"]}], ")"}], " ", 
          SuperscriptBox["Lambda", "4"]}], "+", 
         RowBox[{"2", " ", "Alfas", " ", "MT2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"T", "+", "U"}], ")"}], "2"], "+", 
            RowBox[{"2", " ", "MT2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "-", "T", "-", "U"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            SuperscriptBox["CtG", "\[Conjugate]"], ")"}], "2"]}], "+", 
         RowBox[{"Alfas", " ", "CtG", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"T", "+", "U"}], ")"}], "2"], "+", 
            RowBox[{"2", " ", "MT2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "-", "T", "-", "U"}], ")"}]}]}], ")"}], " ", "v", 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SqrtBox["2"], " ", "GS", " ", "MT", " ", 
             SuperscriptBox["Lambda", "2"]}], "+", 
            RowBox[{"2", " ", "CtG", " ", "MT2", " ", "v"}]}], ")"}]}], "+", 
         RowBox[{"Alfas", " ", "v", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SqrtBox["2"], " ", "GS", " ", "MT", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"T", "+", "U"}], ")"}], "2"], "+", 
               RowBox[{"2", " ", "MT2", " ", 
                RowBox[{"(", 
                 RowBox[{"S", "-", "T", "-", "U"}], ")"}]}]}], ")"}], " ", 
             SuperscriptBox["Lambda", "2"]}], "+", 
            RowBox[{"4", " ", "CtG", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"S", "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"3", " ", "T"}], "+", "U"}], ")"}]}]}], ")"}], 
                " ", 
                SuperscriptBox["MT2", "2"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"3", " ", 
                   SuperscriptBox["T", "2"]}], "+", 
                  RowBox[{"4", " ", "S", " ", "T"}], "+", 
                  RowBox[{"4", " ", "U", " ", "T"}], "+", 
                  SuperscriptBox["U", "2"]}], ")"}], " ", "MT2"}], "-", 
               RowBox[{"S", " ", "T", " ", 
                RowBox[{"(", 
                 RowBox[{"S", "+", "T"}], ")"}]}]}], ")"}], " ", "v"}]}], 
           ")"}], " ", 
          SuperscriptBox["CtG", "\[Conjugate]"]}]}], ")"}]}]}]}], ")"}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.479107323405954*^9, 3.479107355736181*^9}, 
   3.479546880096108*^9, 3.479547369425258*^9, 3.47954771977979*^9, 
   3.500113319040348*^9, {3.500113605572282*^9, 3.500113635069911*^9}, {
   3.5001137369378433`*^9, 3.5001137616604853`*^9}, 3.5001137973822813`*^9, 
   3.5001143377829447`*^9, 3.500114936499757*^9, 3.500793668302743*^9, 
   3.500819356136735*^9, 3.500882486583734*^9, 3.500882538936318*^9, 
   3.500882599038981*^9, 3.500883345495129*^9, 3.5008833922927094`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mqq3", " ", "=", " ", 
  RowBox[{
   RowBox[{"FullSimplify", "[", 
    RowBox[{"Normal", "[", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Mqq2", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"MTri", "\[Rule]", "Lambda"}], ",", 
            RowBox[{"MTri8", "\[Rule]", "Lambda"}], ",", 
            RowBox[{"M8t", "\[Rule]", "Lambda"}], ",", 
            RowBox[{"M8Q", "\[Rule]", "Lambda"}], ",", 
            RowBox[{"gT8l", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C83qq"}], "/", "gT8"}]}], ",", 
            RowBox[{"g8Qu", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C1qu"}], "/", "g8Q"}]}], ",", 
            RowBox[{"g8Qd", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C1qd"}], "/", "g8Q"}]}], ",", 
            RowBox[{"g8Qq", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C81qq"}], "/", "g8Q"}]}], ",", 
            RowBox[{"g8tu", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C8ut"}], "/", "g8t"}]}], ",", 
            RowBox[{"g8Qd", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C8td"}], "/", "g8t"}]}], ",", 
            RowBox[{"g8tq", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C1qt"}], "/", "g8t"}]}], ",", 
            RowBox[{"Alfas2", "\[Rule]", 
             RowBox[{
              RowBox[{"g", "^", "4"}], "/", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"4", "\[Pi]"}], ")"}], "^", "2"}]}]}], ",", 
            RowBox[{"Alfas", "\[Rule]", 
             RowBox[{
              RowBox[{"g", "^", "2"}], "/", 
              RowBox[{"(", 
               RowBox[{"4", "\[Pi]"}], ")"}]}]}]}], "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{"U", "\[Rule]", 
           RowBox[{
            RowBox[{"2", "MT2"}], "-", "S", "-", "T"}]}], "}"}]}], ")"}], ",",
        
       RowBox[{"{", 
        RowBox[{"Lambda", ",", "\[Infinity]", ",", "2"}], "}"}]}], "]"}], 
     "]"}], "]"}], "*", 
   RowBox[{"4", "/", "9"}]}]}]], "Input",
 CellChangeTimes->{{3.479107390301893*^9, 3.479107487977641*^9}, {
   3.500113806544787*^9, 3.500113883391972*^9}, {3.500113915475638*^9, 
   3.500114312515234*^9}, {3.5001145858827763`*^9, 3.5001146097490873`*^9}, {
   3.500114647770303*^9, 3.500114649735759*^9}, {3.500114688473753*^9, 
   3.500114733160845*^9}, 3.500114875060955*^9, {3.5001152545014477`*^9, 
   3.500115295968092*^9}, {3.5007936938214817`*^9, 3.50079369949374*^9}, {
   3.500803134160364*^9, 3.50080315060606*^9}, {3.5008825811536427`*^9, 
   3.5008825845495157`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"9", " ", 
     SuperscriptBox["Lambda", "2"], " ", 
     SuperscriptBox["S", "2"]}]], 
   RowBox[{"4", " ", 
    SuperscriptBox["g", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["g", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["S", "2"], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["MT2", "2"], "-", 
            RowBox[{"2", " ", "T", " ", "MT2"}], "+", 
            RowBox[{"T", " ", 
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["Lambda", "2"]}], "+", 
      RowBox[{"S", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"C1qt", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["T", "2"], "-", 
            RowBox[{"2", " ", "MT2", " ", "T"}], "+", 
            RowBox[{"MT2", " ", 
             RowBox[{"(", 
              RowBox[{"MT2", "+", "S"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"C1qu", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["T", "2"], "-", 
            RowBox[{"2", " ", "MT2", " ", "T"}], "+", 
            RowBox[{"MT2", " ", 
             RowBox[{"(", 
              RowBox[{"MT2", "+", "S"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"C81qq", "+", "C83qq", "+", "C8ut"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["MT2", "2"], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"S", "+", 
               RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}], "2"]}], ")"}]}]}], ")"}]}], "+",
       
      RowBox[{"8", " ", 
       SqrtBox["2"], " ", "GS", " ", "MT", " ", 
       SuperscriptBox["S", "2"], " ", "v", " ", 
       RowBox[{"Re", "(", "CtG", ")"}]}]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.479107432084265*^9, {3.479107479011856*^9, 3.47910748870907*^9}, 
   3.479546898992261*^9, 3.479547373602786*^9, 3.47954772133109*^9, {
   3.50011384139638*^9, 3.5001138847703648`*^9}, {3.500113947405622*^9, 
   3.5001139576032867`*^9}, 3.500114048272284*^9, {3.50011425617973*^9, 
   3.50011434215314*^9}, {3.500114589787217*^9, 3.5001146118448887`*^9}, 
   3.500114651876479*^9, {3.5001147017205477`*^9, 3.500114735328681*^9}, 
   3.5001148775573587`*^9, 3.500114938768714*^9, 3.500115299792132*^9, 
   3.5007936829350033`*^9, 3.500793715341887*^9, 3.500803158566581*^9, 
   3.500819360200091*^9, 3.500882516254529*^9, 3.50088254991638*^9, 
   3.5008826017068577`*^9, 3.500883346683653*^9, 3.500883400380582*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M2", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", 
       RowBox[{"MT2", "^", "2"}]}], "-", 
      RowBox[{"MT2", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", "T"}], "+", "U"}], ")"}]}], "+", 
      RowBox[{"T", "^", "2"}]}], ")"}], "/.", 
    RowBox[{"{", 
     RowBox[{"U", "\[Rule]", 
      RowBox[{
       RowBox[{"2", "MT2"}], "-", "S", "-", "T"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.500114741636303*^9, 3.500114788534588*^9}, 
   3.500114879198107*^9, {3.500115177864251*^9, 3.500115183854629*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["T", "2"], "-", 
   RowBox[{"2", " ", "MT2", " ", "T"}], "+", 
   RowBox[{"MT2", " ", 
    RowBox[{"(", 
     RowBox[{"MT2", "+", "S"}], ")"}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.500114782467032*^9, 3.5001147895432577`*^9}, 
   3.5001148809640017`*^9, 3.500114943206861*^9, 3.500115191434319*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M1", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", 
       RowBox[{"MT2", "^", "2"}]}], "-", 
      RowBox[{"MT2", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", "U"}], "+", "T"}], ")"}]}], "+", 
      RowBox[{"U", "^", "2"}]}], ")"}], "/.", 
    RowBox[{"{", 
     RowBox[{"U", "\[Rule]", 
      RowBox[{
       RowBox[{"2", "MT2"}], "-", "S", "-", "T"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.500114815634944*^9, 3.500114825750782*^9}, 
   3.5001148837126427`*^9, {3.500115194096051*^9, 3.500115196619672*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["MT2", "2"], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"S", "+", 
      RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"S", "+", "T"}], ")"}], "2"]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.5001148357923717`*^9, 3.500114884139975*^9, 
  3.5001149456050453`*^9, 3.5001151972425537`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"M1", "+", "M2"}], "]"}]], "Input",
 CellChangeTimes->{{3.500115199893497*^9, 3.500115212279202*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["S", "2"], "+", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["MT2", "2"], "-", 
      RowBox[{"2", " ", "T", " ", "MT2"}], "+", 
      RowBox[{"T", " ", 
       RowBox[{"(", 
        RowBox[{"S", "+", "T"}], ")"}]}]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.500115207062451*^9, 3.500115213063921*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Normal", "[", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Mqq2", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"MTri8", "\[Rule]", "Lambda"}], ",", 
            RowBox[{"M8t", "\[Rule]", "Lambda"}], ",", 
            RowBox[{"M8Q", "\[Rule]", "Lambda"}], ",", 
            RowBox[{"gT8l", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C83qq"}], "/", "gT8"}]}], ",", 
            RowBox[{"g8Qu", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C1qu"}], "/", "g8Q"}]}], ",", 
            RowBox[{"g8Qd", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C1qd"}], "/", "g8Q"}]}], ",", 
            RowBox[{"g8Qq", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C81qq"}], "/", "g8Q"}]}], ",", 
            RowBox[{"g8tu", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C8ut"}], "/", "g8t"}]}], ",", 
            RowBox[{"g8td", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C8td"}], "/", "g8t"}]}], ",", 
            RowBox[{"g8tq", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C1qt"}], "/", "g8t"}]}], ",", 
            RowBox[{"Alfas2", "\[Rule]", 
             RowBox[{
              RowBox[{"g", "^", "4"}], "/", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"4", "\[Pi]"}], ")"}], "^", "2"}]}]}], ",", 
            RowBox[{"Alfas", "\[Rule]", 
             RowBox[{
              RowBox[{"g", "^", "2"}], "/", 
              RowBox[{"(", 
               RowBox[{"4", "\[Pi]"}], ")"}]}]}]}], "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{"U", "\[Rule]", 
           RowBox[{
            RowBox[{"2", "MT2"}], "-", "S", "-", "T"}]}], "}"}]}], ")"}], ",",
        
       RowBox[{"{", 
        RowBox[{"Lambda", ",", "\[Infinity]", ",", "4"}], "}"}]}], "]"}], 
     "]"}], "-", "Mqq3"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5008189004979057`*^9, 3.500818929839912*^9}, {
  3.50081899185375*^9, 3.500818992952561*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"36", " ", 
     SuperscriptBox["Lambda", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["MTri", "2"], "-", "S"}], ")"}], "2"], " ", 
     SuperscriptBox["S", "2"]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"81", " ", "gT", " ", "gTl", " ", 
      SuperscriptBox["S", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}], "2"], " ", 
      SuperscriptBox["gT", "\[Conjugate]"], " ", 
      SuperscriptBox["gTl", "\[Conjugate]"], " ", 
      SuperscriptBox["Lambda", "4"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["MTri", "2"], "-", "S"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"10", " ", 
         SuperscriptBox["g", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["S", "2"], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["MT2", "2"], "-", 
              RowBox[{"2", " ", "T", " ", "MT2"}], "+", 
              RowBox[{"T", " ", 
               RowBox[{"(", 
                RowBox[{"S", "+", "T"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         SuperscriptBox["Lambda", "4"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["S", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["C1qt", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"MT2", "-", "T"}], ")"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["C1qu", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"MT2", "-", "T"}], ")"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"C81qq", "+", "C83qq"}], ")"}], "2"], "+", 
              SuperscriptBox["C8ut", "2"]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}], "2"]}], "+",
            
           RowBox[{"2", " ", "C1qt", " ", 
            RowBox[{"(", 
             RowBox[{"C81qq", "+", "C83qq"}], ")"}], " ", "MT2", " ", "S"}], 
           "+", 
           RowBox[{"2", " ", "C1qu", " ", "C8ut", " ", "MT2", " ", "S"}]}], 
          ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["g", "2"], " ", "S", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["Lambda", "2"]}], "+", 
           RowBox[{"9", " ", "S"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"C1qt", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["T", "2"], "-", 
              RowBox[{"2", " ", "MT2", " ", "T"}], "+", 
              RowBox[{"MT2", " ", 
               RowBox[{"(", 
                RowBox[{"MT2", "+", "S"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"C1qu", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["T", "2"], "-", 
              RowBox[{"2", " ", "MT2", " ", "T"}], "+", 
              RowBox[{"MT2", " ", 
               RowBox[{"(", 
                RowBox[{"MT2", "+", "S"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"C81qq", "+", "C83qq", "+", "C8ut"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["MT2", "2"], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"S", "+", 
                 RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"S", "+", "T"}], ")"}], "2"]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}]}], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.500818906656559*^9, 3.500818932852653*^9}, 
   3.500818993527314*^9, 3.50081937864814*^9, 3.5008826233798532`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Coefficient", "[", 
   RowBox[{"test", ",", "C81qq", ",", "2"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.500818995457375*^9, 3.500819017094617*^9}, {
  3.5008193997033033`*^9, 3.500819403365405*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}], "2"], 
   RowBox[{"2", " ", 
    SuperscriptBox["Lambda", "4"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.500819017656629*^9, {3.500819380180347*^9, 3.500819404040737*^9}, 
   3.500882628279786*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Coefficient", "[", 
   RowBox[{"test", ",", "C83qq", ",", "2"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{3.500882767334375*^9}],

Cell[BoxData[
 FormBox[
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}], "2"], 
   RowBox[{"2", " ", 
    SuperscriptBox["Lambda", "4"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{3.500882767777335*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Coefficient", "[", 
   RowBox[{"test", ",", "C8ut", ",", "2"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.500819026374195*^9, 3.500819036185522*^9}, {
  3.500819080810912*^9, 3.5008190980256443`*^9}, {3.5008194167487087`*^9, 
  3.500819437558082*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}], "2"], 
   RowBox[{"2", " ", 
    SuperscriptBox["Lambda", "4"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.500819036865534*^9, {3.500819081849884*^9, 3.5008190988970613`*^9}, {
   3.5008194177893248`*^9, 3.500819438058185*^9}, 3.500882631629285*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Coefficient", "[", 
   RowBox[{"test", ",", "C1qu", ",", "2"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{
  3.500820303239694*^9, {3.500882688981048*^9, 3.500882719141464*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"MT2", "-", "T"}], ")"}], "2"], 
   RowBox[{"2", " ", 
    SuperscriptBox["Lambda", "4"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.500820310670985*^9, 3.500882634523271*^9, {3.500882689527706*^9, 
   3.500882720235757*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Coefficient", "[", 
   RowBox[{"test", ",", "C1qt", ",", "2"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{3.5008826487196074`*^9}],

Cell[BoxData[
 FormBox[
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"MT2", "-", "T"}], ")"}], "2"], 
   RowBox[{"2", " ", 
    SuperscriptBox["Lambda", "4"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{3.5008826540577183`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["dd->tt", "Subtitle",
 CellChangeTimes->{{3.4778117420706997`*^9, 3.4778117447507*^9}, {
  3.5001158577529583`*^9, 3.5001158665004883`*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.448968342513181*^9, 3.448968344880295*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\</home/degrande/eta/FeynProg/FeynArts-3.5\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "FeynArts`"}]}], "Input",
 CellChangeTimes->{
  3.4777456682883*^9, 3.478434363232997*^9, 3.495271937325*^9, 
   3.495273775256*^9, {3.500110182753488*^9, 3.5001101841359262`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.495271942766*^9, 3.495271949283*^9}, 3.495275934381*^9, 
   3.495275980209*^9, 3.495276745436*^9, 3.4952772886940002`*^9, 
   3.495278198532*^9, 3.4952811762790003`*^9, 3.4952822222349997`*^9, 
   3.500110154976571*^9, {3.500110185064245*^9, 3.5001101933754053`*^9}, 
   3.5001108098376293`*^9, 3.500112832793943*^9, 3.5001132212678003`*^9, 
   3.500115878238862*^9, 3.50081886072397*^9}],

Cell[BoxData[
 FormBox["\<\"FeynArts 3.5\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.495271942766*^9, 3.495271949283*^9}, 3.495275934381*^9, 
   3.495275980209*^9, 3.495276745436*^9, 3.4952772886940002`*^9, 
   3.495278198532*^9, 3.4952811762790003`*^9, 3.4952822222349997`*^9, 
   3.500110154976571*^9, {3.500110185064245*^9, 3.5001101933754053`*^9}, 
   3.5001108098376293`*^9, 3.500112832793943*^9, 3.5001132212678003`*^9, 
   3.500115878238862*^9, 3.500818860742702*^9}],

Cell[BoxData[
 FormBox["\<\"by Hagen Eck, Sepp Kueblbeck, and Thomas Hahn\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{{3.495271942766*^9, 3.495271949283*^9}, 3.495275934381*^9, 
   3.495275980209*^9, 3.495276745436*^9, 3.4952772886940002`*^9, 
   3.495278198532*^9, 3.4952811762790003`*^9, 3.4952822222349997`*^9, 
   3.500110154976571*^9, {3.500110185064245*^9, 3.5001101933754053`*^9}, 
   3.5001108098376293`*^9, 3.500112832793943*^9, 3.5001132212678003`*^9, 
   3.500115878238862*^9, 3.500818860755033*^9}],

Cell[BoxData[
 FormBox["\<\"last revised 16 Apr 10\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.495271942766*^9, 3.495271949283*^9}, 3.495275934381*^9, 
   3.495275980209*^9, 3.495276745436*^9, 3.4952772886940002`*^9, 
   3.495278198532*^9, 3.4952811762790003`*^9, 3.4952822222349997`*^9, 
   3.500110154976571*^9, {3.500110185064245*^9, 3.5001101933754053`*^9}, 
   3.5001108098376293`*^9, 3.500112832793943*^9, 3.5001132212678003`*^9, 
   3.500115878238862*^9, 3.500818860766197*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"topo", " ", "=", " ", 
   RowBox[{"CreateTopologies", "[", 
    RowBox[{"0", ",", 
     RowBox[{"2", "\[Rule]", "2"}], ",", " ", 
     RowBox[{"Adjacencies", "\[Rule]", 
      RowBox[{"{", "3", "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.47548813810296*^9, 3.475488972088063*^9, {3.4777456120408*^9, 
   3.4777456332583*^9}, 3.4778098132447*^9, 3.4778110152581997`*^9, {
   3.5001115587562923`*^9, 3.500111580397962*^9}, {3.500111634475185*^9, 
   3.5001116428315163`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Paint", "[", "topo", "]"}]], "Input",
 CellChangeTimes->{{3.4777456818157997`*^9, 3.4777456889958*^9}, {
  3.500111015829336*^9, 3.5001110174838743`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.495271989648*^9, 3.495275983322*^9, 3.500111018446618*^9,
   3.5001116461921253`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 2, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.495271989648*^9, 3.495275983322*^9, 3.500111018446618*^9,
   3.50011164629797*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 3, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.495271989648*^9, 3.495275983322*^9, 3.500111018446618*^9,
   3.500111646306368*^9}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], LineBox[{{5.999999999990206, 10.}, {13.999999999982222`, 
        10.}}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 44}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{6.139089236967266*^-12, 15.}, {10.000000000002046`, 
        14.000000000003638`}}], 
       LineBox[{{-7.503331289626658*^-12, 5.000000000003638}, {
        9.999999999988404, 6.}}], 
       LineBox[{{20.000000000002956`, 15.}, {10.000000000002956`, 14.}}], 
       LineBox[{{19.999999999997726`, 4.999999999996362}, {9.999999999997726, 
        5.999999999996362}}], 
       LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T2\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{6.139089236967266*^-12, 15.}, {10.000000000002046`, 
        14.000000000003638`}}], 
       LineBox[{{-7.503331289626658*^-12, 5.000000000003638}, {
        9.999999999988404, 6.}}], 
       LineBox[{{20.00000000000182, 15.}, {10., 6.}}], 
       LineBox[{{20.00000000000182, 5.}, {10., 14.}}], 
       LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T3\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"2\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {28.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[RightArrow]\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {33., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"2\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {37.5, 69.96}, {0, 0}]},
   AspectRatio->1.0999999999999999`,
   PlotRange->{{0, 66}, {0, 72.6}}], TraditionalForm]], "Print",
 CellChangeTimes->{3.495271989648*^9, 3.495275983322*^9, 3.500111018446618*^9,
   3.5001116463187733`*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"FeynArtsGraphics", "(", 
    RowBox[{"2", "\[Rule]", "2"}], ")"}], "\[InvisibleApplication]", 
   RowBox[{"(", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T2\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T2", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T3\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T3", "]"],
           Editable->False],
          TraditionalForm]},
        {"Null", "Null", "Null"},
        {"Null", "Null", "Null"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.4777456905908003`*^9, 3.478435705207405*^9, 
  3.495271902317*^9, 3.495271990013*^9, 3.495275983486*^9, 
  3.50011101885795*^9, 3.500111646432447*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"INTopoqq", " ", "=", " ", 
   RowBox[{"InsertFields", "[", 
    RowBox[{"topo", ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"F", "[", "10", "]"}], ",", 
        RowBox[{"-", 
         RowBox[{"F", "[", "10", "]"}]}]}], "}"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"F", "[", "9", "]"}], ",", 
        RowBox[{"-", 
         RowBox[{"F", "[", "9", "]"}]}]}], "}"}]}], ",", 
     RowBox[{"GenericModel", "\[Rule]", "\"\<Top4Fermion/Top4Fermion\>\""}], 
     ",", 
     RowBox[{"Model", "\[Rule]", "\"\<Top4Fermion/Top4Fermion\>\""}], ",", 
     RowBox[{"ExcludeParticles", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"S", ",", 
        RowBox[{"V", "[", "1", "]"}], ",", 
        RowBox[{"V", "[", "2", "]"}], ",", 
        RowBox[{"V", "[", "3", "]"}]}], "}"}]}], ",", 
     RowBox[{"InsertionLevel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Generic", ",", "Classes"}], "}"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.4778060034077*^9, 3.4778060172207003`*^9}, {
   3.4778061181482*^9, 3.4778062060957003`*^9}, {3.4778064622107*^9, 
   3.4778064974032*^9}, {3.4778096875622*^9, 3.4778097175422*^9}, {
   3.4778099067622004`*^9, 3.4778099081296997`*^9}, {3.4778111168007*^9, 
   3.4778111226157*^9}, {3.4778115172907*^9, 3.4778115174282*^9}, 
   3.478437845209915*^9, {3.479546689667869*^9, 3.479546718821388*^9}, {
   3.479546793843457*^9, 3.47954680051448*^9}, 3.4952742275699997`*^9, {
   3.49527430859*^9, 3.495274311582*^9}, {3.500110127592201*^9, 
   3.500110148872984*^9}, {3.50011023482518*^9, 3.5001102598698807`*^9}, {
   3.500110817023205*^9, 3.500110825242276*^9}, {3.500111957435989*^9, 
   3.50011198241054*^9}, {3.500113240310526*^9, 3.500113263759314*^9}, {
   3.500115891404975*^9, 3.5001158943104*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.500818863227004*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
    "\[InvisibleSpace]", "\<\"generic\"\>", 
    "\[InvisibleSpace]", "\<\" model file \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/Top4Fermion/\
Top4Fermion.gen\"\>"}],
   SequenceForm[
   "", "loading ", "generic", " model file ", 
    "/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/Top4Fermion/\
Top4Fermion.gen"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.500818863382736*^9}],

Cell[BoxData[
 FormBox["\<\"> $SVMixing is OFF\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.500818863389044*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"generic model \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", "\<\"Top4Fermion/Top4Fermion\"\>", "}"}], 
    "\[InvisibleSpace]", "\<\" initialized\"\>"}],
   SequenceForm[
   "generic model ", {"Top4Fermion/Top4Fermion"}, " initialized"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.5008188634014597`*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.500818863412986*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
    "\[InvisibleSpace]", "\<\"classes\"\>", 
    "\[InvisibleSpace]", "\<\" model file \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/Top4Fermion/\
Top4Fermion.mod\"\>"}],
   SequenceForm[
   "", "loading ", "classes", " model file ", 
    "/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/Top4Fermion/\
Top4Fermion.mod"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.500818863587625*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "51", 
    "\[InvisibleSpace]", "\<\" particles (incl. antiparticles) in \"\>", 
    "\[InvisibleSpace]", "30", "\[InvisibleSpace]", "\<\" classes\"\>"}],
   SequenceForm[
   "> ", 51, " particles (incl. antiparticles) in ", 30, " classes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.500818863710537*^9}],

Cell[BoxData[
 FormBox["\<\"> $CounterTerms are ON\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.500818863837781*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "98", 
    "\[InvisibleSpace]", "\<\" vertices\"\>"}],
   SequenceForm["> ", 98, " vertices"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.5008188639649363`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"classes model \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", "\<\"Top4Fermion/Top4Fermion\"\>", "}"}], 
    "\[InvisibleSpace]", "\<\" initialized\"\>"}],
   SequenceForm[
   "classes model ", {"Top4Fermion/Top4Fermion"}, " initialized"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.5008188640951223`*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.5008188642291117`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Excluding \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" Generic, \"\>", "\[InvisibleSpace]", "8", 
    "\[InvisibleSpace]", "\<\" Classes, and \"\>", "\[InvisibleSpace]", "8", 
    "\[InvisibleSpace]", "\<\" Particles fields\"\>"}],
   SequenceForm[
   "Excluding ", 1, " Generic, ", 8, " Classes, and ", 8, 
    " Particles fields"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.500818864486908*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.5008188646270657`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"Generic", ",", "Classes"}], "}"}]}],
   SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.500818864768882*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 4 Classes insertions\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "1 Generic, 4 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.5008188649145947`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
   SequenceForm["> Top. ", 2, ": ", "0 Generic, 0 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.500818865062788*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
   SequenceForm["> Top. ", 3, ": ", "0 Generic, 0 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.5008188654263983`*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.500818865718655*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Restoring \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\" Generic, \"\>", "\[InvisibleSpace]", "8", 
    "\[InvisibleSpace]", "\<\" Classes, and \"\>", "\[InvisibleSpace]", "8", 
    "\[InvisibleSpace]", "\<\" Particles fields\"\>"}],
   SequenceForm[
   "Restoring ", 1, " Generic, ", 8, " Classes, and ", 8, 
    " Particles fields"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.500818865862444*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"in total: \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 4 Classes insertions\"\>"}],
   SequenceForm["in total: ", "1 Generic, 4 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.500110220560235*^9, 3.500110260726797*^9}, 
   3.500110826472937*^9, 3.500111008343144*^9, 3.500111652991624*^9, {
   3.500111952373335*^9, 3.500111984619184*^9}, {3.50011280614165*^9, 
   3.500112835601047*^9}, 3.50011322323335*^9, 3.5001132656239643`*^9, {
   3.500115880034738*^9, 3.500115895355101*^9}, 3.500818866008196*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Paint", "[", "INTopoqq", "]"}]], "Input",
 CellChangeTimes->{{3.4778063315682*^9, 3.4778063464357*^9}, {
   3.4778115474231997`*^9, 3.4778115475632*^9}, 3.478437858916929*^9, 
   3.479546810801527*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"5 diagrams\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "5 diagrams"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.479546811928915*^9, 3.4952720143900003`*^9, 
  3.495274238238*^9, 3.4952743199230003`*^9, 3.495276316532*^9, 
  3.49527676376*^9, 3.500110224991707*^9, 3.500111668474367*^9, 
  3.500112840460973*^9, 3.500113227219717*^9, 3.5001132697596207`*^9, 
  3.500115898238626*^9, 3.5008188665077353`*^9}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       PolygonBox[{{3.4609327677584254`, 12.115889360201312`}, {
        2.2829934723757828`, 12.576822127959737`}, {2.7951409921073664`, 
        13.191399151637638`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"d\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{2.5390672322415746`, 7.1158893602013125`}, {
        3.7170065276242177`, 7.576822127959738}, {3.2048590078926336`, 
        8.191399151637638}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"d\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lG1QVFUYx8+KkQzjhyYZ3pfdPYc3hcHtFBRT+DBNCiq60Uy7IzXLLu1F
dBRzSYsSKNJsRlQQiIuYmYgrfKAALRxLAuVFTistTIOpRYysEDIyxlRQsT30
4dyZO3d+c+695zzP8///9fbCbMcyQsjLeC89J0d9eK0B8v/FIHSipfaGQF5x
bH5jAoPcryqP1qjIuVYS8QqDdd+VRtgUZEuwrakQ3zcuWhP5Egc22EsYiBR7
7oJvNRBwBJUcYLDvg+CV/QJ5+1s9q3Yx8G1+CLUq8tvuzsStDEx93r43FOSM
Y4vFsQyKpw8qnCMfL667t0ChKsDzq4Ygmy5unHFTaJrq8R8S8UBmv0lafoFC
TUb2F6dUZF1592gFhc0G8+AOBbms7pPeMgrVygNzCkce84btLKdgD+Db/Qhy
3MGivTUUvm0bjrgp4oD89bj3TAeFMpc4Xa8iWzIt2rsUorMtWkVBNk3megMY
eHP6u40ceVLTvOcZBgnta1r/9cVi/9Jic7YxuPhlwfyAQO6vKgwqYlA2/9KF
WhW5y5PwZimDKqPz6zwF2cV7/d9l4DdzYpWRL61rR2z5DC53dX2+6IvB/Sp+
friewcLZxReFQM4IONweyeBU86Nbqops6Wq8Pkuh52+2KV9BJrdn2q9TCE15
7tDTHNlVnf7DGQrn8i6Vawjy2jvxFR9TSB1NWu8W0UAO+x+4X0pB89G90XoV
2fX93icOURB/arPyFWSTfWrDSQrOPM8lzpGfrf5w+gqu330snhDk2Y6WYS+F
rcWNbUIwnOct6nkSz+eX9JqqIh/v05jTGGyKdMUoCvKspVVnY3DN75dAzpHX
/pE+vp9BnHtJfxTnl1o1iP1puKqbE4LK9aAmM9ZL5ffdV4fOKgqV/9cYcrI4
p3L/6on5H30+gzzfjDUxUwiDPH9541hbnWqQ9W0JCo91KAZZf/T0zU4jN8j+
XLZmvrfo08v+JTt63xkUetnfI5/91FGn6mX/u0NWYr16OR9HlOYK53o5v9rb
aa9riF7ON6t157Rb6OT83ZVHNjSoOqmPsYHOVwsUndTPyd9q/JO5TuqLTQ2b
lhGd1N+ce3dxgxol9blvfEsP51FSv5/ed3TdEFqpb8OwudemaKX+F5xq0rwv
UvqjrjPGVKlGSv/4z5kKVvNI6a+i89tOXxMR0n/O9v2PrEqE9Ge9M+f5f3zh
0r8ttt+fUtVw6W/SbNyTzMOl/7sf6EqGRZjMh5H3hyYKlTCZHysGUtcFkjCZ
L0eZH5xTQ2X+pC8nfS/wUJlPJOTO+IgIkfm1a/d5zw4lRObbzMiS/oJl/v0H
YYABMg==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"V\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 G1 N1\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 44}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       PolygonBox[{{3.4609327677584254`, 12.115889360201312`}, {
        2.2829934723757828`, 12.576822127959737`}, {2.7951409921073664`, 
        13.191399151637638`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"d\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{2.5390672322415746`, 7.1158893602013125`}, {
        3.7170065276242177`, 7.576822127959738}, {3.2048590078926336`, 
        8.191399151637638}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"d\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lgs4lGkbxyeHJbW7KtZphnm972uxCn0S8dVtUaImQiTr1Mgh1iGKlEOs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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 C1 N2\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       PolygonBox[{{3.4609327677584254`, 12.115889360201312`}, {
        2.2829934723757828`, 12.576822127959737`}, {2.7951409921073664`, 
        13.191399151637638`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"d\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{2.5390672322415746`, 7.1158893602013125`}, {
        3.7170065276242177`, 7.576822127959738}, {3.2048590078926336`, 
        8.191399151637638}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"d\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lG1QVFUYx8+KkQzjhyYZ3pfdPYc3hcHtFBRT+DBNCiq60Uy7IzXLLu1F
dBRzSYsSKNJsRlQQiIuYmYgrfKAALRxLAuVFTistTIOpRYysEDIyxlRQsT30
4dyZO3d+c+695zzP8///9fbCbMcyQsjLeC89J0d9eK0B8v/FIHSipfaGQF5x
bH5jAoPcryqP1qjIuVYS8QqDdd+VRtgUZEuwrakQ3zcuWhP5Egc22EsYiBR7
7oJvNRBwBJUcYLDvg+CV/QJ5+1s9q3Yx8G1+CLUq8tvuzsStDEx93r43FOSM
Y4vFsQyKpw8qnCMfL667t0ChKsDzq4Ygmy5unHFTaJrq8R8S8UBmv0lafoFC
TUb2F6dUZF1592gFhc0G8+AOBbms7pPeMgrVygNzCkce84btLKdgD+Db/Qhy
3MGivTUUvm0bjrgp4oD89bj3TAeFMpc4Xa8iWzIt2rsUorMtWkVBNk3megMY
eHP6u40ceVLTvOcZBgnta1r/9cVi/9Jic7YxuPhlwfyAQO6vKgwqYlA2/9KF
WhW5y5PwZimDKqPz6zwF2cV7/d9l4DdzYpWRL61rR2z5DC53dX2+6IvB/Sp+
friewcLZxReFQM4IONweyeBU86Nbqops6Wq8Pkuh52+2KV9BJrdn2q9TCE15
7tDTHNlVnf7DGQrn8i6Vawjy2jvxFR9TSB1NWu8W0UAO+x+4X0pB89G90XoV
2fX93icOURB/arPyFWSTfWrDSQrOPM8lzpGfrf5w+gqu330snhDk2Y6WYS+F
rcWNbUIwnOct6nkSz+eX9JqqIh/v05jTGGyKdMUoCvKspVVnY3DN75dAzpHX
/pE+vp9BnHtJfxTnl1o1iP1puKqbE4LK9aAmM9ZL5ffdV4fOKgqV/9cYcrI4
p3L/6on5H30+gzzfjDUxUwiDPH9541hbnWqQ9W0JCo91KAZZf/T0zU4jN8j+
XLZmvrfo08v+JTt63xkUetnfI5/91FGn6mX/u0NWYr16OR9HlOYK53o5v9rb
aa9riF7ON6t157Rb6OT83ZVHNjSoOqmPsYHOVwsUndTPyd9q/JO5TuqLTQ2b
lhGd1N+ce3dxgxol9blvfEsP51FSv5/ed3TdEFqpb8OwudemaKX+F5xq0rwv
UvqjrjPGVKlGSv/4z5kKVvNI6a+i89tOXxMR0n/O9v2PrEqE9Ge9M+f5f3zh
0r8ttt+fUtVw6W/SbNyTzMOl/7sf6EqGRZjMh5H3hyYKlTCZHysGUtcFkjCZ
L0eZH5xTQ2X+pC8nfS/wUJlPJOTO+IgIkfm1a/d5zw4lRObbzMiS/oJl/v0H
YYABMg==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"Tri80\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 C2 N3\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       PolygonBox[{{3.4609327677584254`, 12.115889360201312`}, {
        2.2829934723757828`, 12.576822127959737`}, {2.7951409921073664`, 
        13.191399151637638`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"d\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{2.5390672322415746`, 7.1158893602013125`}, {
        3.7170065276242177`, 7.576822127959738}, {3.2048590078926336`, 
        8.191399151637638}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"d\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lG1QVFUYx8+KkQzjhyYZ3pfdPYc3hcHtFBRT+DBNCiq60Uy7IzXLLu1F
dBRzSYsSKNJsRlQQiIuYmYgrfKAALRxLAuVFTistTIOpRYysEDIyxlRQsT30
4dyZO3d+c+695zzP8///9fbCbMcyQsjLeC89J0d9eK0B8v/FIHSipfaGQF5x
bH5jAoPcryqP1qjIuVYS8QqDdd+VRtgUZEuwrakQ3zcuWhP5Egc22EsYiBR7
7oJvNRBwBJUcYLDvg+CV/QJ5+1s9q3Yx8G1+CLUq8tvuzsStDEx93r43FOSM
Y4vFsQyKpw8qnCMfL667t0ChKsDzq4Ygmy5unHFTaJrq8R8S8UBmv0lafoFC
TUb2F6dUZF1592gFhc0G8+AOBbms7pPeMgrVygNzCkce84btLKdgD+Db/Qhy
3MGivTUUvm0bjrgp4oD89bj3TAeFMpc4Xa8iWzIt2rsUorMtWkVBNk3megMY
eHP6u40ceVLTvOcZBgnta1r/9cVi/9Jic7YxuPhlwfyAQO6vKgwqYlA2/9KF
WhW5y5PwZimDKqPz6zwF2cV7/d9l4DdzYpWRL61rR2z5DC53dX2+6IvB/Sp+
friewcLZxReFQM4IONweyeBU86Nbqops6Wq8Pkuh52+2KV9BJrdn2q9TCE15
7tDTHNlVnf7DGQrn8i6Vawjy2jvxFR9TSB1NWu8W0UAO+x+4X0pB89G90XoV
2fX93icOURB/arPyFWSTfWrDSQrOPM8lzpGfrf5w+gqu330snhDk2Y6WYS+F
rcWNbUIwnOct6nkSz+eX9JqqIh/v05jTGGyKdMUoCvKspVVnY3DN75dAzpHX
/pE+vp9BnHtJfxTnl1o1iP1puKqbE4LK9aAmM9ZL5ffdV4fOKgqV/9cYcrI4
p3L/6on5H30+gzzfjDUxUwiDPH9541hbnWqQ9W0JCo91KAZZf/T0zU4jN8j+
XLZmvrfo08v+JTt63xkUetnfI5/91FGn6mX/u0NWYr16OR9HlOYK53o5v9rb
aa9riF7ON6t157Rb6OT83ZVHNjSoOqmPsYHOVwsUndTPyd9q/JO5TuqLTQ2b
lhGd1N+ce3dxgxol9blvfEsP51FSv5/ed3TdEFqpb8OwudemaKX+F5xq0rwv
UvqjrjPGVKlGSv/4z5kKVvNI6a+i89tOXxMR0n/O9v2PrEqE9Ge9M+f5f3zh
0r8ttt+fUtVw6W/SbNyTzMOl/7sf6EqGRZjMh5H3hyYKlTCZHysGUtcFkjCZ
L0eZH5xTQ2X+pC8nfS/wUJlPJOTO+IgIkfm1a/d5zw4lRObbzMiS/oJl/v0H
YYABMg==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"V8t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 C3 N4\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 22}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       PolygonBox[{{3.4609327677584254`, 12.115889360201312`}, {
        2.2829934723757828`, 12.576822127959737`}, {2.7951409921073664`, 
        13.191399151637638`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"d\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{2.5390672322415746`, 7.1158893602013125`}, {
        3.7170065276242177`, 7.576822127959738}, {3.2048590078926336`, 
        8.191399151637638}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"d\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lG1QVFUYx8+KkQzjhyYZ3pfdPYc3hcHtFBRT+DBNCiq60Uy7IzXLLu1F
dBRzSYsSKNJsRlQQiIuYmYgrfKAALRxLAuVFTistTIOpRYysEDIyxlRQsT30
4dyZO3d+c+695zzP8///9fbCbMcyQsjLeC89J0d9eK0B8v/FIHSipfaGQF5x
bH5jAoPcryqP1qjIuVYS8QqDdd+VRtgUZEuwrakQ3zcuWhP5Egc22EsYiBR7
7oJvNRBwBJUcYLDvg+CV/QJ5+1s9q3Yx8G1+CLUq8tvuzsStDEx93r43FOSM
Y4vFsQyKpw8qnCMfL667t0ChKsDzq4Ygmy5unHFTaJrq8R8S8UBmv0lafoFC
TUb2F6dUZF1592gFhc0G8+AOBbms7pPeMgrVygNzCkce84btLKdgD+Db/Qhy
3MGivTUUvm0bjrgp4oD89bj3TAeFMpc4Xa8iWzIt2rsUorMtWkVBNk3megMY
eHP6u40ceVLTvOcZBgnta1r/9cVi/9Jic7YxuPhlwfyAQO6vKgwqYlA2/9KF
WhW5y5PwZimDKqPz6zwF2cV7/d9l4DdzYpWRL61rR2z5DC53dX2+6IvB/Sp+
friewcLZxReFQM4IONweyeBU86Nbqops6Wq8Pkuh52+2KV9BJrdn2q9TCE15
7tDTHNlVnf7DGQrn8i6Vawjy2jvxFR9TSB1NWu8W0UAO+x+4X0pB89G90XoV
2fX93icOURB/arPyFWSTfWrDSQrOPM8lzpGfrf5w+gqu330snhDk2Y6WYS+F
rcWNbUIwnOct6nkSz+eX9JqqIh/v05jTGGyKdMUoCvKspVVnY3DN75dAzpHX
/pE+vp9BnHtJfxTnl1o1iP1puKqbE4LK9aAmM9ZL5ffdV4fOKgqV/9cYcrI4
p3L/6on5H30+gzzfjDUxUwiDPH9541hbnWqQ9W0JCo91KAZZf/T0zU4jN8j+
XLZmvrfo08v+JTt63xkUetnfI5/91FGn6mX/u0NWYr16OR9HlOYK53o5v9rb
aa9riF7ON6t157Rb6OT83ZVHNjSoOqmPsYHOVwsUndTPyd9q/JO5TuqLTQ2b
lhGd1N+ce3dxgxol9blvfEsP51FSv5/ed3TdEFqpb8OwudemaKX+F5xq0rwv
UvqjrjPGVKlGSv/4z5kKVvNI6a+i89tOXxMR0n/O9v2PrEqE9Ge9M+f5f3zh
0r8ttt+fUtVw6W/SbNyTzMOl/7sf6EqGRZjMh5H3hyYKlTCZHysGUtcFkjCZ
L0eZH5xTQ2X+pC8nfS/wUJlPJOTO+IgIkfm1a/d5zw4lRObbzMiS/oJl/v0H
YYABMg==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"V8Q\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 C4 N5\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 22}, {0, 0}, {22, 22}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"d\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {24., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"d\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {28.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[RightArrow]\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {33., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"t\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {37.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"t\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {42., 69.96}, {0, 0}]},
   AspectRatio->1.0999999999999999`,
   PlotRange->{{0, 66}, {0, 72.6}}], TraditionalForm]], "Print",
 CellChangeTimes->{3.479546811928915*^9, 3.4952720143900003`*^9, 
  3.495274238238*^9, 3.4952743199230003`*^9, 3.495276316532*^9, 
  3.49527676376*^9, 3.500110224991707*^9, 3.500111668474367*^9, 
  3.500112840460973*^9, 3.500113227219717*^9, 3.5001132697596207`*^9, 
  3.500115898238626*^9, 3.500818869096265*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"FeynArtsGraphics", "(", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"d\"\>", ",", "\<\"d\"\>"}], "}"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\<\"t\"\>", ",", "\<\"t\"\>"}], "}"}]}], ")"}], 
   "\[InvisibleApplication]", 
   RowBox[{"(", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 G1 N1\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 G1 N1", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 C1 N2\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 C1 N2", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 C2 N3\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 C2 N3", "]"],
           Editable->False],
          TraditionalForm]},
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 C3 N4\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 C3 N4", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 C4 N5\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 C4 N5", "]"],
           Editable->False],
          TraditionalForm], "Null"},
        {"Null", "Null", "Null"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.4778063475407*^9, 3.4778065254607*^9, 3.4778099157272*^9, 
   3.4778115492682*^9, 3.47843686984159*^9, 3.478436906375371*^9, {
   3.478437853618226*^9, 3.478437860811162*^9}, 3.479099999826127*^9, 
   3.479106333796554*^9, {3.479546806741183*^9, 3.479546812623714*^9}, 
   3.495272014652*^9, 3.495274238559*^9, 3.495274320167*^9, 3.495276316769*^9,
    3.495276764039*^9, 3.500110227529645*^9, 3.500111668952627*^9, 
   3.500112840863007*^9, 3.50011322761375*^9, 3.500113270045206*^9, 
   3.500115898582712*^9, 3.5008188692359467`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Amplqq", " ", "=", " ", 
   RowBox[{"CreateFeynAmp", "[", "INTopoqq", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4778062370957003`*^9, 3.4778062399307003`*^9}, {
   3.4778115657332*^9, 3.4778115658507*^9}, {3.4778120221097*^9, 
   3.4778120222467003`*^9}, 3.479547360479462*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778115712007*^9, {3.4778120234797*^9, 3.4778120430657*^9}, 
   3.478434383755428*^9, 3.478435578790159*^9, 3.478435879919781*^9, 
   3.478436801285664*^9, 3.478436912149393*^9, 3.479546827897663*^9, 
   3.479547326278256*^9, 3.479547708182675*^9, 3.4952721609779997`*^9, 
   3.4952743519700003`*^9, 3.495276425449*^9, 3.495276773883*^9, 
   3.495277303781*^9, 3.495278211932*^9, 3.495281183468*^9, 3.495282230146*^9,
    3.500113289384753*^9, 3.500115903798622*^9, 3.5008188703118362`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"Generic", ",", "Classes"}], "}"}]}],
   SequenceForm[
   "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778115712007*^9, {3.4778120234797*^9, 3.4778120430657*^9}, 
   3.478434383755428*^9, 3.478435578790159*^9, 3.478435879919781*^9, 
   3.478436801285664*^9, 3.478436912149393*^9, 3.479546827897663*^9, 
   3.479547326278256*^9, 3.479547708182675*^9, 3.4952721609779997`*^9, 
   3.4952743519700003`*^9, 3.495276425449*^9, 3.495276773883*^9, 
   3.495277303781*^9, 3.495278211932*^9, 3.495281183468*^9, 3.495282230146*^9,
    3.500113289384753*^9, 3.500115903798622*^9, 3.500818870370175*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 4 Classes amplitudes\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "1 Generic, 4 Classes amplitudes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778115712007*^9, {3.4778120234797*^9, 3.4778120430657*^9}, 
   3.478434383755428*^9, 3.478435578790159*^9, 3.478435879919781*^9, 
   3.478436801285664*^9, 3.478436912149393*^9, 3.479546827897663*^9, 
   3.479547326278256*^9, 3.479547708182675*^9, 3.4952721609779997`*^9, 
   3.4952743519700003`*^9, 3.495276425449*^9, 3.495276773883*^9, 
   3.495277303781*^9, 3.495278211932*^9, 3.495281183468*^9, 3.495282230146*^9,
    3.500113289384753*^9, 3.500115903798622*^9, 3.5008188704856157`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"in total: \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 4 Classes amplitudes\"\>"}],
   SequenceForm["in total: ", "1 Generic, 4 Classes amplitudes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778115712007*^9, {3.4778120234797*^9, 3.4778120430657*^9}, 
   3.478434383755428*^9, 3.478435578790159*^9, 3.478435879919781*^9, 
   3.478436801285664*^9, 3.478436912149393*^9, 3.479546827897663*^9, 
   3.479547326278256*^9, 3.479547708182675*^9, 3.4952721609779997`*^9, 
   3.4952743519700003`*^9, 3.495276425449*^9, 3.495276773883*^9, 
   3.495277303781*^9, 3.495278211932*^9, 3.495281183468*^9, 3.495282230146*^9,
    3.500113289384753*^9, 3.500115903798622*^9, 3.5008188706006203`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\</home/degrande/eta/FeynProg/FormCalc-6.2\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "FormCalc`"}]}], "Input",
 CellChangeTimes->{
  3.4777456682883*^9, {3.4778119018507*^9, 3.4778119054056997`*^9}, {
   3.4778119371527*^9, 3.4778119527257*^9}, {3.478434390853149*^9, 
   3.478434394596879*^9}, {3.500113298082315*^9, 3.5001132986342363`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.500113299063477*^9, 3.500115906831184*^9, 3.50081887225768*^9}],

Cell[BoxData[
 FormBox["\<\"FormCalc 6.2\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.500113299063477*^9, 3.500115906831184*^9, 3.500818872336307*^9}],

Cell[BoxData[
 FormBox["\<\"by Thomas Hahn\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.500113299063477*^9, 3.500115906831184*^9, 3.50081887251595*^9}],

Cell[BoxData[
 FormBox["\<\"last revised 11 Aug 10\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.500113299063477*^9, 3.500115906831184*^9, 3.500818872654035*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mqq", " ", "=", " ", 
   RowBox[{"CalcFeynAmp", "[", 
    RowBox[{"Amplqq", ",", 
     RowBox[{"FermionChains", "\[Rule]", "Chiral"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.4778119845017*^9, 3.4778120345607*^9}, {
   3.478435376938886*^9, 3.478435418868291*^9}, 3.479547358194307*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.478434402570528*^9, 3.478435422620416*^9, 
  3.478435588542779*^9, 3.478435896246393*^9, 3.478436924110362*^9, 
  3.479100051862622*^9, 3.479106355014496*^9, 3.479546852661124*^9, 
  3.479547334202314*^9, 3.479547712295999*^9, 3.500113303957884*^9, 
  3.5001159092885427`*^9, 3.5008188735618362`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.478434402570528*^9, 3.478435422620416*^9, 
  3.478435588542779*^9, 3.478435896246393*^9, 3.478436924110362*^9, 
  3.479100051862622*^9, 3.479106355014496*^9, 3.479546852661124*^9, 
  3.479547334202314*^9, 3.479547712295999*^9, 3.500113303957884*^9, 
  3.5001159092885427`*^9, 3.5008188736319723`*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{3.478434402570528*^9, 3.478435422620416*^9, 
  3.478435588542779*^9, 3.478435896246393*^9, 3.478436924110362*^9, 
  3.479100051862622*^9, 3.479106355014496*^9, 3.479546852661124*^9, 
  3.479547334202314*^9, 3.479547712295999*^9, 3.500113303957884*^9, 
  3.5001159092885427`*^9, 3.5008188737813663`*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.478434402570528*^9, 3.478435422620416*^9, 
  3.478435588542779*^9, 3.478435896246393*^9, 3.478436924110362*^9, 
  3.479100051862622*^9, 3.479106355014496*^9, 3.479546852661124*^9, 
  3.479547334202314*^9, 3.479547712295999*^9, 3.500113303957884*^9, 
  3.5001159092885427`*^9, 3.500818874138801*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"col", "=", 
  RowBox[{"ColourME", "[", "Mqq", "]"}]}]], "Input",
 CellChangeTimes->{{3.478434696113564*^9, 3.478434729084623*^9}, {
  3.478435197289632*^9, 3.478435232835993*^9}, {3.478436054623279*^9, 
  3.478436055525961*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Mat", "(", 
      RowBox[{"SUN1", ",", "SUN2"}], ")"}], "\[Rule]", "3"}], ",", 
    RowBox[{
     RowBox[{"Mat", "(", 
      RowBox[{"SUN1", ",", "SUN1"}], ")"}], "\[Rule]", "9"}], ",", 
    RowBox[{
     RowBox[{"Mat", "(", 
      RowBox[{"SUN2", ",", "SUN2"}], ")"}], "\[Rule]", "9"}], ",", 
    RowBox[{
     RowBox[{"Mat", "(", 
      RowBox[{"SUN2", ",", "SUN1"}], ")"}], "\[Rule]", "3"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.478434730426236*^9, 3.478435200749498*^9, 
  3.478435233950212*^9, 3.478435426393788*^9, 3.478435591077346*^9, 
  3.478435927320691*^9, 3.478436057790335*^9, 3.478436928353135*^9, 
  3.479100063362775*^9, 3.479106358816292*^9, 3.479546864822269*^9, 
  3.479547348022377*^9, 3.479547714372858*^9, 3.500113308549095*^9, 
  3.5001159120221453`*^9, 3.500818876737793*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"_Hel", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hel", "=", 
   RowBox[{"HelicityME", "[", "Mqq", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.478435272631223*^9, 3.478435280805309*^9}, {
   3.478435549596737*^9, 3.478435557227066*^9}, {3.478436067208497*^9, 
   3.478436071671449*^9}, {3.478436592499899*^9, 3.478436607261712*^9}, 
   3.479547354402557*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "16", 
    "\[InvisibleSpace]", "\<\" helicity matrix elements\"\>"}],
   SequenceForm["> ", 16, " helicity matrix elements"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.478435541414897*^9, 3.478435592470004*^9, 
  3.478435933573625*^9, 3.478436072748205*^9, 3.478436610903903*^9, 
  3.478436931796526*^9, 3.47910006737685*^9, 3.479106361221098*^9, 
  3.479546867343088*^9, 3.479547349361385*^9, 3.479547716089566*^9, 
  3.500113312071175*^9, 3.5001159149255447`*^9, 3.50081887771782*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.478435541414897*^9, 3.478435592470004*^9, 
  3.478435933573625*^9, 3.478436072748205*^9, 3.478436610903903*^9, 
  3.478436931796526*^9, 3.47910006737685*^9, 3.479106361221098*^9, 
  3.479546867343088*^9, 3.479547349361385*^9, 3.479547716089566*^9, 
  3.500113312071175*^9, 3.5001159149255447`*^9, 3.500818877799251*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.478435541414897*^9, 3.478435592470004*^9, 
  3.478435933573625*^9, 3.478436072748205*^9, 3.478436610903903*^9, 
  3.478436931796526*^9, 3.47910006737685*^9, 3.479106361221098*^9, 
  3.479546867343088*^9, 3.479547349361385*^9, 3.479547716089566*^9, 
  3.500113312071175*^9, 3.5001159149255447`*^9, 3.500818877961761*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{3.478435541414897*^9, 3.478435592470004*^9, 
  3.478435933573625*^9, 3.478436072748205*^9, 3.478436610903903*^9, 
  3.478436931796526*^9, 3.47910006737685*^9, 3.479106361221098*^9, 
  3.479546867343088*^9, 3.479547349361385*^9, 3.479547716089566*^9, 
  3.500113312071175*^9, 3.5001159149255447`*^9, 3.500818878097522*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.478435541414897*^9, 3.478435592470004*^9, 
  3.478435933573625*^9, 3.478436072748205*^9, 3.478436610903903*^9, 
  3.478436931796526*^9, 3.47910006737685*^9, 3.479106361221098*^9, 
  3.479546867343088*^9, 3.479547349361385*^9, 3.479547716089566*^9, 
  3.500113312071175*^9, 3.5001159149255447`*^9, 3.500818878224792*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mqq2", "=", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"SquaredME", "[", "Mqq", "]"}], "/.", "col"}], "/.", "hel"}],
        "/.", 
       RowBox[{"{", 
        RowBox[{"MD2", "\[Rule]", "0"}], "}"}]}], "/.", "M$FACouplings"}], 
     ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"v", "\[Element]", "Reals"}], ",", 
        RowBox[{"g8t", "\[Element]", "Reals"}], ",", 
        RowBox[{"g8Q", "\[Element]", "Reals"}], ",", 
        RowBox[{"MTri8", "\[Element]", "Reals"}], ",", 
        RowBox[{"M8t", "\[Element]", "Reals"}], ",", 
        RowBox[{"M8Q", "\[Element]", "Reals"}], ",", 
        RowBox[{"g8tu", "\[Element]", "Reals"}], ",", 
        RowBox[{"g8Qu", "\[Element]", "Reals"}], ",", 
        RowBox[{"g8tq", "\[Element]", "Reals"}], ",", 
        RowBox[{"g8Qq", "\[Element]", "Reals"}], ",", 
        RowBox[{"g8td", "\[Element]", "Reals"}], ",", 
        RowBox[{"g8Qd", "\[Element]", "Reals"}], ",", 
        RowBox[{"gT8", "\[Element]", "Reals"}], ",", 
        RowBox[{"gT8l", "\[Element]", "Reals"}]}], "}"}]}]}], "]"}], "/.", 
   RowBox[{
    RowBox[{"Den", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], "\[Rule]", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.478436009927547*^9, 3.478436018997932*^9}, {
   3.478436082403898*^9, 3.478436090700395*^9}, {3.478436177508675*^9, 
   3.47843618204671*^9}, {3.478437003898071*^9, 3.47843701110685*^9}, {
   3.478437477803822*^9, 3.478437504302616*^9}, {3.479106936214095*^9, 
   3.479106948049022*^9}, {3.479107333470424*^9, 3.479107353663611*^9}, {
   3.500113559090603*^9, 3.500113796301057*^9}, 3.5001143361762466`*^9, 
   3.50011599394346*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["g8Qd", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"MT2", "-", "T"}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["g8Qq", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"MT2", "-", "U"}], ")"}], "2"]}]}], ")"}], " ", 
       SuperscriptBox["g8Q", "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"S", "-", 
         SuperscriptBox["M8Q", "2"]}], ")"}], "2"]], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"g8t", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"g8Qd", " ", "g8td"}], "+", 
             RowBox[{"g8Qq", " ", "g8tq"}]}], ")"}], " ", "MT2", " ", "S"}], 
          RowBox[{"S", "-", 
           SuperscriptBox["M8t", "2"]}]], "-", 
         FractionBox[
          RowBox[{"g8Qq", " ", "gT8", " ", "gT8l", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"MT2", "-", "U"}], ")"}], "2"]}], 
          RowBox[{"S", "-", 
           SuperscriptBox["MTri8", "2"]}]]}], ")"}], " ", "g8Q"}], 
      RowBox[{"S", "-", 
       SuperscriptBox["M8Q", "2"]}]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["g8t", "2"], " ", 
       SuperscriptBox["g8tq", "2"], " ", 
       SuperscriptBox["T", "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"S", "-", 
         SuperscriptBox["M8t", "2"]}], ")"}], "2"]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["g8t", "2"], " ", 
       SuperscriptBox["g8td", "2"], " ", 
       SuperscriptBox["U", "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"S", "-", 
         SuperscriptBox["M8t", "2"]}], ")"}], "2"]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["gT8", "2"], " ", 
       SuperscriptBox["gT8l", "2"], " ", 
       SuperscriptBox["U", "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"S", "-", 
         SuperscriptBox["MTri8", "2"]}], ")"}], "2"]], "-", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["g8t", "2"], " ", 
       SuperscriptBox["g8tq", "2"], " ", "MT2", " ", "T"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"S", "-", 
         SuperscriptBox["M8t", "2"]}], ")"}], "2"]], "-", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["g8t", "2"], " ", 
       SuperscriptBox["g8td", "2"], " ", "MT2", " ", "U"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"S", "-", 
         SuperscriptBox["M8t", "2"]}], ")"}], "2"]], "-", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["gT8", "2"], " ", 
       SuperscriptBox["gT8l", "2"], " ", "MT2", " ", "U"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"S", "-", 
         SuperscriptBox["MTri8", "2"]}], ")"}], "2"]], "+", 
     FractionBox[
      RowBox[{"32", " ", "Alfas2", " ", 
       SuperscriptBox["\[Pi]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["MT2", "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"S", "-", "T", "-", "U"}], ")"}], " ", "MT2"}], "+", 
         SuperscriptBox["T", "2"], "+", 
         SuperscriptBox["U", "2"]}], ")"}]}], 
      SuperscriptBox["S", "2"]], "+", 
     RowBox[{
      FractionBox["1", "S"], 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"gT8", " ", "gT8l", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["MT2", "2"], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"S", "-", 
                 RowBox[{"2", " ", "U"}]}], ")"}], " ", "MT2"}], "+", 
              SuperscriptBox["U", "2"]}], ")"}]}], 
           RowBox[{"S", "-", 
            SuperscriptBox["MTri8", "2"]}]]}], "+", 
         FractionBox[
          RowBox[{"g8Q", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"g8Qd", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["MT2", "2"], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"S", "-", 
                   RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
                SuperscriptBox["T", "2"]}], ")"}]}], "+", 
             RowBox[{"g8Qq", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["MT2", "2"], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"S", "-", 
                   RowBox[{"2", " ", "U"}]}], ")"}], " ", "MT2"}], "+", 
                SuperscriptBox["U", "2"]}], ")"}]}]}], ")"}]}], 
          RowBox[{"S", "-", 
           SuperscriptBox["M8Q", "2"]}]], "+", 
         FractionBox[
          RowBox[{"g8t", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"g8tq", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["MT2", "2"], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"S", "-", 
                   RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
                SuperscriptBox["T", "2"]}], ")"}]}], "+", 
             RowBox[{"g8td", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["MT2", "2"], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"S", "-", 
                   RowBox[{"2", " ", "U"}]}], ")"}], " ", "MT2"}], "+", 
                SuperscriptBox["U", "2"]}], ")"}]}]}], ")"}]}], 
          RowBox[{"S", "-", 
           SuperscriptBox["M8t", "2"]}]]}], ")"}]}]}], "-", 
     FractionBox[
      RowBox[{
      "2", " ", "g8t", " ", "g8tq", " ", "gT8", " ", "gT8l", " ", "MT2", " ", 
       "S"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"S", "-", 
         SuperscriptBox["M8t", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"S", "-", 
         SuperscriptBox["MTri8", "2"]}], ")"}]}]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["g8t", "2"], " ", 
       SuperscriptBox["g8td", "2"], " ", 
       SuperscriptBox["MT2", "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"S", "-", 
         SuperscriptBox["M8t", "2"]}], ")"}], "2"]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["g8t", "2"], " ", 
       SuperscriptBox["g8tq", "2"], " ", 
       SuperscriptBox["MT2", "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"S", "-", 
         SuperscriptBox["M8t", "2"]}], ")"}], "2"]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["gT8", "2"], " ", 
       SuperscriptBox["gT8l", "2"], " ", 
       SuperscriptBox["MT2", "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"S", "-", 
         SuperscriptBox["MTri8", "2"]}], ")"}], "2"]]}], ")"}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.479107323405954*^9, 3.479107355736181*^9}, 
   3.479546880096108*^9, 3.479547369425258*^9, 3.47954771977979*^9, 
   3.500113319040348*^9, {3.500113605572282*^9, 3.500113635069911*^9}, {
   3.5001137369378433`*^9, 3.5001137616604853`*^9}, 3.5001137973822813`*^9, 
   3.5001143377829447`*^9, 3.500114936499757*^9, 3.500115921248946*^9, 
   3.500115995009664*^9, 3.50081888252122*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mqq3", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Mqq2", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"MTri8", "\[Rule]", "Lambda"}], ",", 
           RowBox[{"M8t", "\[Rule]", "Lambda"}], ",", 
           RowBox[{"M8Q", "\[Rule]", "Lambda"}], ",", 
           RowBox[{"gT8l", "\[Rule]", 
            RowBox[{
             RowBox[{"-", "C83qq"}], "/", "gT8"}]}], ",", 
           RowBox[{"g8Qu", "\[Rule]", 
            RowBox[{
             RowBox[{"-", "C1qu"}], "/", "g8Q"}]}], ",", 
           RowBox[{"g8Qd", "\[Rule]", 
            RowBox[{
             RowBox[{"-", "C1qd"}], "/", "g8Q"}]}], ",", 
           RowBox[{"g8Qq", "\[Rule]", 
            RowBox[{
             RowBox[{"-", "C81qq"}], "/", "g8Q"}]}], ",", 
           RowBox[{"g8tu", "\[Rule]", 
            RowBox[{
             RowBox[{"-", "C8ut"}], "/", "g8t"}]}], ",", 
           RowBox[{"g8td", "\[Rule]", 
            RowBox[{
             RowBox[{"-", "C8td"}], "/", "g8t"}]}], ",", 
           RowBox[{"g8tq", "\[Rule]", 
            RowBox[{
             RowBox[{"-", "C1qt"}], "/", "g8t"}]}], ",", 
           RowBox[{"Alfas2", "\[Rule]", 
            RowBox[{
             RowBox[{"g", "^", "4"}], "/", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"4", "\[Pi]"}], ")"}], "^", "2"}]}]}], ",", 
           RowBox[{"Alfas", "\[Rule]", 
            RowBox[{
             RowBox[{"g", "^", "2"}], "/", 
             RowBox[{"(", 
              RowBox[{"4", "\[Pi]"}], ")"}]}]}]}], "}"}]}], "/.", 
        RowBox[{"{", 
         RowBox[{"U", "\[Rule]", 
          RowBox[{
           RowBox[{"2", "MT2"}], "-", "S", "-", "T"}]}], "}"}]}], ")"}], ",", 
      
      RowBox[{"{", 
       RowBox[{"Lambda", ",", "\[Infinity]", ",", "2"}], "}"}]}], "]"}], 
    "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.479107390301893*^9, 3.479107487977641*^9}, {
   3.500113806544787*^9, 3.500113883391972*^9}, {3.500113915475638*^9, 
   3.500114312515234*^9}, {3.5001145858827763`*^9, 3.5001146097490873`*^9}, {
   3.500114647770303*^9, 3.500114649735759*^9}, {3.500114688473753*^9, 
   3.500114733160845*^9}, 3.500114875060955*^9, {3.5001152545014477`*^9, 
   3.500115295968092*^9}, 3.500115978944983*^9, {3.5008031983717012`*^9, 
   3.500803205347486*^9}, {3.500803280822464*^9, 3.500803285171212*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["Lambda", "2"], " ", 
     SuperscriptBox["S", "2"]}]], 
   RowBox[{
    SuperscriptBox["g", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["g", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["S", "2"], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["MT2", "2"], "-", 
            RowBox[{"2", " ", "T", " ", "MT2"}], "+", 
            RowBox[{"T", " ", 
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["Lambda", "2"]}], "+", 
      RowBox[{"S", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"C1qd", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["T", "2"], "-", 
            RowBox[{"2", " ", "MT2", " ", "T"}], "+", 
            RowBox[{"MT2", " ", 
             RowBox[{"(", 
              RowBox[{"MT2", "+", "S"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"C1qt", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["T", "2"], "-", 
            RowBox[{"2", " ", "MT2", " ", "T"}], "+", 
            RowBox[{"MT2", " ", 
             RowBox[{"(", 
              RowBox[{"MT2", "+", "S"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"C81qq", "-", "C83qq", "+", "C8td"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["MT2", "2"], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"S", "+", 
               RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}], "2"]}], ")"}]}]}], ")"}]}]}], 
     ")"}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.479107432084265*^9, {3.479107479011856*^9, 3.47910748870907*^9}, 
   3.479546898992261*^9, 3.479547373602786*^9, 3.47954772133109*^9, {
   3.50011384139638*^9, 3.5001138847703648`*^9}, {3.500113947405622*^9, 
   3.5001139576032867`*^9}, 3.500114048272284*^9, {3.50011425617973*^9, 
   3.50011434215314*^9}, {3.500114589787217*^9, 3.5001146118448887`*^9}, 
   3.500114651876479*^9, {3.5001147017205477`*^9, 3.500114735328681*^9}, 
   3.5001148775573587`*^9, 3.500114938768714*^9, 3.500115299792132*^9, 
   3.500115928113896*^9, {3.5001159840182247`*^9, 3.5001159997276793`*^9}, 
   3.50081892642443*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M2", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", 
       RowBox[{"MT2", "^", "2"}]}], "-", 
      RowBox[{"MT2", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", "T"}], "+", "U"}], ")"}]}], "+", 
      RowBox[{"T", "^", "2"}]}], ")"}], "/.", 
    RowBox[{"{", 
     RowBox[{"U", "\[Rule]", 
      RowBox[{
       RowBox[{"2", "MT2"}], "-", "S", "-", "T"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.500114741636303*^9, 3.500114788534588*^9}, 
   3.500114879198107*^9, {3.500115177864251*^9, 3.500115183854629*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["T", "2"], "-", 
   RowBox[{"2", " ", "MT2", " ", "T"}], "+", 
   RowBox[{"MT2", " ", 
    RowBox[{"(", 
     RowBox[{"MT2", "+", "S"}], ")"}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.500114782467032*^9, 3.5001147895432577`*^9}, 
   3.5001148809640017`*^9, 3.500114943206861*^9, 3.500115191434319*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M1", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", 
       RowBox[{"MT2", "^", "2"}]}], "-", 
      RowBox[{"MT2", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", "U"}], "+", "T"}], ")"}]}], "+", 
      RowBox[{"U", "^", "2"}]}], ")"}], "/.", 
    RowBox[{"{", 
     RowBox[{"U", "\[Rule]", 
      RowBox[{
       RowBox[{"2", "MT2"}], "-", "S", "-", "T"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.500114815634944*^9, 3.500114825750782*^9}, 
   3.5001148837126427`*^9, {3.500115194096051*^9, 3.500115196619672*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["MT2", "2"], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"S", "+", 
      RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"S", "+", "T"}], ")"}], "2"]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.5001148357923717`*^9, 3.500114884139975*^9, 
  3.5001149456050453`*^9, 3.5001151972425537`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"M1", "+", "M2"}], "]"}]], "Input",
 CellChangeTimes->{{3.500115199893497*^9, 3.500115212279202*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["S", "2"], "+", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["MT2", "2"], "-", 
      RowBox[{"2", " ", "T", " ", "MT2"}], "+", 
      RowBox[{"T", " ", 
       RowBox[{"(", 
        RowBox[{"S", "+", "T"}], ")"}]}]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.500115207062451*^9, 3.500115213063921*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Normal", "[", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Mqq2", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"MTri8", "\[Rule]", "Lambda"}], ",", 
            RowBox[{"M8t", "\[Rule]", "Lambda"}], ",", 
            RowBox[{"M8Q", "\[Rule]", "Lambda"}], ",", 
            RowBox[{"gT8l", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C83qq"}], "/", "gT8"}]}], ",", 
            RowBox[{"g8Qu", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C1qu"}], "/", "g8Q"}]}], ",", 
            RowBox[{"g8Qd", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C1qd"}], "/", "g8Q"}]}], ",", 
            RowBox[{"g8Qq", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C81qq"}], "/", "g8Q"}]}], ",", 
            RowBox[{"g8tu", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C8ut"}], "/", "g8t"}]}], ",", 
            RowBox[{"g8td", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C8td"}], "/", "g8t"}]}], ",", 
            RowBox[{"g8tq", "\[Rule]", 
             RowBox[{
              RowBox[{"-", "C1qt"}], "/", "g8t"}]}], ",", 
            RowBox[{"Alfas2", "\[Rule]", 
             RowBox[{
              RowBox[{"g", "^", "4"}], "/", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"4", "\[Pi]"}], ")"}], "^", "2"}]}]}], ",", 
            RowBox[{"Alfas", "\[Rule]", 
             RowBox[{
              RowBox[{"g", "^", "2"}], "/", 
              RowBox[{"(", 
               RowBox[{"4", "\[Pi]"}], ")"}]}]}]}], "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{"U", "\[Rule]", 
           RowBox[{
            RowBox[{"2", "MT2"}], "-", "S", "-", "T"}]}], "}"}]}], ")"}], ",",
        
       RowBox[{"{", 
        RowBox[{"Lambda", ",", "\[Infinity]", ",", "4"}], "}"}]}], "]"}], 
     "]"}], "-", "Mqq3"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5008189004979057`*^9, 3.500818929839912*^9}, {
  3.50081899185375*^9, 3.500818992952561*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     SuperscriptBox["Lambda", "4"]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "C83qq", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["MT2", "2"], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"S", "+", 
           RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"S", "+", "T"}], ")"}], "2"]}], ")"}], " ", 
      SuperscriptBox["g", "2"]}], "+", 
     RowBox[{
      SuperscriptBox["C1qd", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"MT2", "-", "T"}], ")"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["C1qt", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"MT2", "-", "T"}], ")"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["C81qq", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["C83qq", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}], "2"]}], "+", 
     RowBox[{"2", " ", "C1qt", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["T", "2"], "-", 
           RowBox[{"2", " ", "MT2", " ", "T"}], "+", 
           RowBox[{"MT2", " ", 
            RowBox[{"(", 
             RowBox[{"MT2", "+", "S"}], ")"}]}]}], ")"}], " ", 
         SuperscriptBox["g", "2"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"C81qq", "-", "C83qq"}], ")"}], " ", "MT2", " ", "S"}]}], 
       ")"}]}], "+", 
     RowBox[{"2", " ", "C1qd", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["T", "2"], "-", 
           RowBox[{"2", " ", "MT2", " ", "T"}], "+", 
           RowBox[{"MT2", " ", 
            RowBox[{"(", 
             RowBox[{"MT2", "+", "S"}], ")"}]}]}], ")"}], " ", 
         SuperscriptBox["g", "2"]}], "+", 
        RowBox[{"C8td", " ", "MT2", " ", "S"}]}], ")"}]}], "-", 
     RowBox[{"2", " ", "C81qq", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"C83qq", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}], "2"]}], "-", 
        RowBox[{
         SuperscriptBox["g", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["MT2", "2"], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"S", "+", 
              RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"S", "+", "T"}], ")"}], "2"]}], ")"}]}]}], ")"}]}], "+", 
     
     RowBox[{"C8td", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["MT2", "2"], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"S", "+", 
              RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"S", "+", "T"}], ")"}], "2"]}], ")"}], " ", 
         SuperscriptBox["g", "2"]}], "+", 
        RowBox[{"C8td", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}], "2"]}]}], 
       ")"}]}]}], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.500818906656559*^9, 3.500818932852653*^9}, 
   3.500818993527314*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{"test", ",", "C81qq", ",", "2"}], "]"}]], "Input",
 CellChangeTimes->{{3.500818995457375*^9, 3.500819017094617*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    SuperscriptBox["MT2", "2"], "-", 
    RowBox[{"2", " ", "S", " ", "MT2"}], "-", 
    RowBox[{"2", " ", "T", " ", "MT2"}], "+", 
    SuperscriptBox["S", "2"], "+", 
    SuperscriptBox["T", "2"], "+", 
    RowBox[{"2", " ", "S", " ", "T"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["Lambda", "4"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{3.500819017656629*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{"test", ",", "C8td", ",", "2"}], "]"}]], "Input",
 CellChangeTimes->{{3.500819026374195*^9, 3.500819036185522*^9}, {
  3.500819080810912*^9, 3.5008190980256443`*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    SuperscriptBox["MT2", "2"], "-", 
    RowBox[{"2", " ", "S", " ", "MT2"}], "-", 
    RowBox[{"2", " ", "T", " ", "MT2"}], "+", 
    SuperscriptBox["S", "2"], "+", 
    SuperscriptBox["T", "2"], "+", 
    RowBox[{"2", " ", "S", " ", "T"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["Lambda", "4"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.500819036865534*^9, {3.500819081849884*^9, 3.5008190988970613`*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["gg->tt", "Subtitle",
 CellChangeTimes->{{3.4778117833757*^9, 3.4778117853882*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.448968342513181*^9, 3.448968344880295*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\</home/degrande/eta/FeynProg/FeynArts-3.5\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "FeynArts`"}]}], "Input",
 CellChangeTimes->{3.4777456682883*^9, 3.47843887392115*^9, 
  3.499668009622912*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478438874714395*^9, 3.478439311157875*^9, 3.479117501605381*^9, 
   3.479122890293128*^9, 3.479127315286193*^9, 3.479547739644739*^9, 
   3.4996680105546*^9, 3.4996681813378477`*^9, 3.500119770747581*^9, 
   3.500184813621686*^9, 3.500186820640222*^9, 3.500720177985886*^9, 
   3.501237042801551*^9, 3.5012494168870077`*^9, 3.501396526448827*^9, 
   3.503388657769279*^9}],

Cell[BoxData[
 FormBox["\<\"FeynArts 3.5\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478438874714395*^9, 3.478439311157875*^9, 3.479117501605381*^9, 
   3.479122890293128*^9, 3.479127315286193*^9, 3.479547739644739*^9, 
   3.4996680105546*^9, 3.4996681813378477`*^9, 3.500119770747581*^9, 
   3.500184813621686*^9, 3.500186820640222*^9, 3.500720177985886*^9, 
   3.501237042801551*^9, 3.5012494168870077`*^9, 3.501396526448827*^9, 
   3.5033886577892323`*^9}],

Cell[BoxData[
 FormBox["\<\"by Hagen Eck, Sepp Kueblbeck, and Thomas Hahn\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478438874714395*^9, 3.478439311157875*^9, 3.479117501605381*^9, 
   3.479122890293128*^9, 3.479127315286193*^9, 3.479547739644739*^9, 
   3.4996680105546*^9, 3.4996681813378477`*^9, 3.500119770747581*^9, 
   3.500184813621686*^9, 3.500186820640222*^9, 3.500720177985886*^9, 
   3.501237042801551*^9, 3.5012494168870077`*^9, 3.501396526448827*^9, 
   3.503388657804137*^9}],

Cell[BoxData[
 FormBox["\<\"last revised 16 Apr 10\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478438874714395*^9, 3.478439311157875*^9, 3.479117501605381*^9, 
   3.479122890293128*^9, 3.479127315286193*^9, 3.479547739644739*^9, 
   3.4996680105546*^9, 3.4996681813378477`*^9, 3.500119770747581*^9, 
   3.500184813621686*^9, 3.500186820640222*^9, 3.500720177985886*^9, 
   3.501237042801551*^9, 3.5012494168870077`*^9, 3.501396526448827*^9, 
   3.50338865782311*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"topo", " ", "=", " ", 
   RowBox[{"CreateTopologies", "[", 
    RowBox[{"0", ",", 
     RowBox[{"2", "\[Rule]", "2"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.47548813810296*^9, 3.475488972088063*^9, {3.4777456120408*^9, 
   3.4777456332583*^9}, 3.4778098132447*^9, 3.4778110152581997`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Paint", "[", "topo", "]"}]], "Input",
 CellChangeTimes->{{3.4777456818157997`*^9, 3.4777456889958*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456900683002`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 2, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456901158*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 3, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456901233*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 4, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456902233*^9}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-9.094947017729282*^-12, 15.000000000003638`}, {
        9.999999999983629, 10.000000000007276`}}], 
       LineBox[{{-9.094947017729282*^-12, 4.999999999996362}, {
        9.999999999985448, 9.999999999989086}}], 
       LineBox[{{20.000000000009095`, 15.000000000003638`}, {
        10.000000000009095`, 10.000000000003638`}}], 
       LineBox[{{20., 5.}, {10., 10.}}], 
       {PointSize[0.04], PointBox[{10., 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 44}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], LineBox[{{5.999999999990206, 10.}, {13.999999999982222`, 
        10.}}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T2\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{6.139089236967266*^-12, 15.}, {10.000000000002046`, 
        14.000000000003638`}}], 
       LineBox[{{-7.503331289626658*^-12, 5.000000000003638}, {
        9.999999999988404, 6.}}], 
       LineBox[{{20.000000000002956`, 15.}, {10.000000000002956`, 14.}}], 
       LineBox[{{19.999999999997726`, 4.999999999996362}, {9.999999999997726, 
        5.999999999996362}}], 
       LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T3\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{6.139089236967266*^-12, 15.}, {10.000000000002046`, 
        14.000000000003638`}}], 
       LineBox[{{-7.503331289626658*^-12, 5.000000000003638}, {
        9.999999999988404, 6.}}], 
       LineBox[{{20.00000000000182, 15.}, {10., 6.}}], 
       LineBox[{{20.00000000000182, 5.}, {10., 14.}}], 
       LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T4\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 22}, {0, 0}, {22, 22}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"2\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {28.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[RightArrow]\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {33., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"2\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {37.5, 69.96}, {0, 0}]},
   AspectRatio->1.0999999999999999`,
   PlotRange->{{0, 66}, {0, 72.6}}], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456905458*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"FeynArtsGraphics", "(", 
    RowBox[{"2", "\[Rule]", "2"}], ")"}], "\[InvisibleApplication]", 
   RowBox[{"(", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T2\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T2", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T3\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T3", "]"],
           Editable->False],
          TraditionalForm]},
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T4\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T4", "]"],
           Editable->False],
          TraditionalForm], "Null", "Null"},
        {"Null", "Null", "Null"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.4777456905908003`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"INTopogg", " ", "=", " ", 
   RowBox[{"InsertFields", "[", 
    RowBox[{"topo", ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"V", "[", "4", "]"}], ",", 
        RowBox[{"V", "[", "4", "]"}]}], "}"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"F", "[", "9", "]"}], ",", 
        RowBox[{"-", 
         RowBox[{"F", "[", "9", "]"}]}]}], "}"}]}], ",", 
     RowBox[{"GenericModel", "\[Rule]", "\"\<TopEffTh_FA/TopEffTh_FA\>\""}], 
     ",", 
     RowBox[{"Model", "\[Rule]", "\"\<TopEffTh_FA/TopEffTh_FA\>\""}], ",", 
     RowBox[{"ExcludeParticles", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"V", "[", "1", "]"}], ",", 
        RowBox[{"V", "[", "2", "]"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.446963657162187*^9, {3.475488153382761*^9, 3.47548819550466*^9}, {
   3.475488277812788*^9, 3.47548833038444*^9}, {3.475488827421314*^9, 
   3.475488830123555*^9}, {3.4777458116422997`*^9, 3.4777459014372997`*^9}, {
   3.4777462405453*^9, 3.4777462574853*^9}, {3.4777462970928*^9, 
   3.4777463288428*^9}, {3.4777464988353*^9, 3.4777465257553*^9}, {
   3.4778060791882*^9, 3.4778060871157*^9}, 3.4778061256857*^9, {
   3.4778062251731997`*^9, 3.4778062269357*^9}, {3.4996680230902777`*^9, 
   3.4996680967055798`*^9}, 3.500185283170471*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.503388660126412*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
    "\[InvisibleSpace]", "\<\"generic\"\>", 
    "\[InvisibleSpace]", "\<\" model file \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.gen\"\>"}],
   SequenceForm[
   "", "loading ", "generic", " model file ", 
    "/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.gen"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.5033886602220078`*^9}],

Cell[BoxData[
 FormBox["\<\"> $SVMixing is OFF\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.503388660230342*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"generic model \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", "\<\"TopEffTh_FA/TopEffTh_FA\"\>", "}"}], 
    "\[InvisibleSpace]", "\<\" initialized\"\>"}],
   SequenceForm[
   "generic model ", {"TopEffTh_FA/TopEffTh_FA"}, " initialized"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.503388660355809*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.503388660364098*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
    "\[InvisibleSpace]", "\<\"classes\"\>", 
    "\[InvisibleSpace]", "\<\" model file \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.mod\"\>"}],
   SequenceForm[
   "", "loading ", "classes", " model file ", 
    "/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.mod"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.503388660372538*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "51", 
    "\[InvisibleSpace]", "\<\" particles (incl. antiparticles) in \"\>", 
    "\[InvisibleSpace]", "30", "\[InvisibleSpace]", "\<\" classes\"\>"}],
   SequenceForm[
   "> ", 51, " particles (incl. antiparticles) in ", 30, " classes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.503388660518552*^9}],

Cell[BoxData[
 FormBox["\<\"> $CounterTerms are ON\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.50338866100574*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "142", 
    "\[InvisibleSpace]", "\<\" vertices\"\>"}],
   SequenceForm["> ", 142, " vertices"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.503388661174892*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"classes model \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", "\<\"TopEffTh_FA/TopEffTh_FA\"\>", "}"}], 
    "\[InvisibleSpace]", "\<\" initialized\"\>"}],
   SequenceForm[
   "classes model ", {"TopEffTh_FA/TopEffTh_FA"}, " initialized"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.503388661301149*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.5033886614327717`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Excluding \"\>", "\[InvisibleSpace]", "0", 
    "\[InvisibleSpace]", "\<\" Generic, \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" Classes, and \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" Particles fields\"\>"}],
   SequenceForm[
   "Excluding ", 0, " Generic, ", 2, " Classes, and ", 2, 
    " Particles fields"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.503388661565857*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.503388661890716*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"Generic", ",", "Classes"}], "}"}]}],
   SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.50338866215355*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.5033886622971497`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"2 Generic, 2 Classes insertions\"\>"}],
   SequenceForm["> Top. ", 2, ": ", "2 Generic, 2 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.5033886624437513`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
   SequenceForm["> Top. ", 3, ": ", "1 Generic, 1 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.503388662594648*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
   SequenceForm["> Top. ", 4, ": ", "1 Generic, 1 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.503388662744975*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.503388663014683*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Restoring \"\>", "\[InvisibleSpace]", "0", 
    "\[InvisibleSpace]", "\<\" Generic, \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" Classes, and \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" Particles fields\"\>"}],
   SequenceForm[
   "Restoring ", 0, " Generic, ", 2, " Classes, and ", 2, 
    " Particles fields"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.503388663156974*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"in total: \"\>", 
    "\[InvisibleSpace]", "\<\"5 Generic, 5 Classes insertions\"\>"}],
   SequenceForm["in total: ", "5 Generic, 5 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500720181813981*^9, 3.501237045162122*^9, 
   3.501249421273184*^9, 3.501399245629957*^9, 3.503388663299583*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Paint", "[", "INTopogg", "]"}]], "Input",
 CellChangeTimes->{{3.4777460520773*^9, 3.4777460643283*^9}, {
  3.4777465398103*^9, 3.4777465399453*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"2 diagrams\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "2 diagrams"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777465408353*^9, 3.4778113180182*^9, 3.4778115983157*^9,
   3.47911751953127*^9, 3.47912291122788*^9, 3.479127333539017*^9, 
  3.499668102426846*^9, 3.49966818593785*^9, 3.500119781743864*^9, 
  3.500184820040362*^9, 3.500185289505512*^9, 3.500186826642324*^9, 
  3.500720184873517*^9, 3.5012370488350353`*^9, 3.501249426552867*^9, 
  3.5013992516790648`*^9, 3.5033886643146553`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"4 diagrams\"\>"}],
   SequenceForm["> Top. ", 2, ": ", "4 diagrams"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777465408353*^9, 3.4778113180182*^9, 3.4778115983157*^9,
   3.47911751953127*^9, 3.47912291122788*^9, 3.479127333539017*^9, 
  3.499668102426846*^9, 3.49966818593785*^9, 3.500119781743864*^9, 
  3.500184820040362*^9, 3.500185289505512*^9, 3.500186826642324*^9, 
  3.500720184873517*^9, 3.5012370488350353`*^9, 3.501249426552867*^9, 
  3.5013992516790648`*^9, 3.503388664380167*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"2 diagrams\"\>"}],
   SequenceForm["> Top. ", 3, ": ", "2 diagrams"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777465408353*^9, 3.4778113180182*^9, 3.4778115983157*^9,
   3.47911751953127*^9, 3.47912291122788*^9, 3.479127333539017*^9, 
  3.499668102426846*^9, 3.49966818593785*^9, 3.500119781743864*^9, 
  3.500184820040362*^9, 3.500185289505512*^9, 3.500186826642324*^9, 
  3.500720184873517*^9, 3.5012370488350353`*^9, 3.501249426552867*^9, 
  3.5013992516790648`*^9, 3.503388664521883*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"2 diagrams\"\>"}],
   SequenceForm["> Top. ", 4, ": ", "2 diagrams"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777465408353*^9, 3.4778113180182*^9, 3.4778115983157*^9,
   3.47911751953127*^9, 3.47912291122788*^9, 3.479127333539017*^9, 
  3.499668102426846*^9, 3.49966818593785*^9, 3.500119781743864*^9, 
  3.500184820040362*^9, 3.500185289505512*^9, 3.500186826642324*^9, 
  3.500720184873517*^9, 3.5012370488350353`*^9, 3.501249426552867*^9, 
  3.5013992516790648`*^9, 3.503388664654767*^9}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwd1gtYzNkbB/BfN00os7oYJCPJVMpkUauYqaft4jah2lxSWVZqMek2pf0b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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.911618926975065, 11.718437853950132`}, \
{1, 1}], LineBox[CompressedData["
1:eJwt1wtUjFsbB/C3lO6dpDLdmAgVZVKS+GpyQsklSeaQYxRKoqI0Uceo0Dk6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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {5.088381073024935, 6.71843785395013}, \
{-1, 1}], 
       LineBox[{{20.000000000009095`, 15.000000000003638`}, {
        10.000000000009095`, 10.000000000003638`}}], 
       PolygonBox[{{15.536656314599949`, 12.768328157299974`}, {
        14.284458247200067`, 12.589442719099992`}, {14.642229123600034`, 
        11.87390096630006}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {14.911618926975065`, 13.281562146049868`}, \
{1, -1}], LineBox[{{20., 5.}, {10., 10.}}], 
       PolygonBox[{{14.463343685400051`, 7.768328157299975}, {
        15.715541752799933`, 7.589442719099991}, {15.357770876399966`, 
        6.8739009663000585`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {15.088381073024935`, 8.28156214604987}, \
{-1, -1}], 
       {PointSize[0.04], PointBox[{10., 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 G1 N1\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 44}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwd1gtYzNkbB/BfN00os7oYJCPJVMpkUauYqaft4jah2lxSWVZqMek2pf0b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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.911618926975065, 11.718437853950132`}, \
{1, 1}], LineBox[CompressedData["
1:eJwt1wtUjFsbB/C3lO6dpDLdmAgVZVKS+GpyQsklSeaQYxRKoqI0Uceo0Dk6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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {5.088381073024935, 6.71843785395013}, \
{-1, 1}], 
       LineBox[{{20.000000000009095`, 15.000000000003638`}, {
        10.000000000009095`, 10.000000000003638`}}], 
       PolygonBox[{{15.536656314599949`, 12.768328157299974`}, {
        14.284458247200067`, 12.589442719099992`}, {14.642229123600034`, 
        11.87390096630006}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {14.911618926975065`, 13.281562146049868`}, \
{1, -1}], LineBox[{{20., 5.}, {10., 10.}}], 
       PolygonBox[{{14.463343685400051`, 7.768328157299975}, {
        15.715541752799933`, 7.589442719099991}, {15.357770876399966`, 
        6.8739009663000585`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {15.088381073024935`, 8.28156214604987}, \
{-1, -1}], 
       {PointSize[0.04], PointBox[{10., 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 C1 N2\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwd1A9YzNkaB/CjJo22GClh+jOl2aLpmlYylOYXLaEYWlfSkkUlZcqqWCGV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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[CompressedData["
1:eJwV1gs01GkfB/AHzUTCuKyUMC6VS6JS2NT8u2iFWkUotQ25tNlFJVRoUMu8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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], 
       {Dashing[{0.030000000000000002`, 0.030000000000000002`}], 
        LineBox[{{5.999999999990206, 10.}, {13.999999999982222`, 10.}}]}, 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"S\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.3048}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T2 G1 N3\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwd1A9YzNkaB/CjJo22GClh+jOl2aLpmlYylOYXLaEYWlfSkkUlZcqqWCGV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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[CompressedData["
1:eJwV1gs01GkfB/AHzUTCuKyUMC6VS6JS2NT8u2iFWkUotQ25tNlFJVRoUMu8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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], 
       {Dashing[{0.030000000000000002`, 0.030000000000000002`}], 
        LineBox[{{5.999999999990206, 10.}, {13.999999999982222`, 10.}}]}, 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"H\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.3048}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T2 C1 N4\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 22}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwd1A9YzNkaB/CjJo22GClh+jOl2aLpmlYylOYXLaEYWlfSkkUlZcqqWCGV
2+Rfs7eUuqnhKmxZYQilBiErmlJK2pqUKxVGBkVb+z13nqdnns9zzu+87/v9
ncn2J+nKzXqEkBP4o99EO4KPBUNYFPYM6Z5zhRMCF6fEZFGrjVaueTQR6+1s
x7Gwtqt4hjusqW6ocISvxUacUJozxPL+rrrlcNjWbXxPmHkY6p0Iiyz90p6b
MUTFuhVXAQvdQsvSYE65OFCPzxDeui37g+CqaQv2L4VLkttz5sO5C3q9s2DH
zfdzvKhXDrW9gI87/Kt/NTzwwu6Q07cMkXANWUnwD2W8M9vg7rlCphKOuBFR
dw6uPrJYwkY/8QUdrOfwgDDGZw3syMwtIQ4Mke3v0xTDUa8WV0+GhWFhl/+C
2VbWDXx4Z3bProWYt9klvt8eFr008U2E5Wt3N1vA1yzMm4vh3F1LH4zgfFGW
7bHbsMpIltIGM0eW9KlgkeoWcxX2kZb+sxAu9hfsSIVVi4Kl22HfW5mNgbBi
T8FnPuzjNuLsDMtSUx/fpv31zXDXp/O69rcshbUH/kxrRx7d6W9eV2Fe48rr
MVU0r8WJid/BCRef1l+G5Tzji9kTUCdSPuECzBTJakZMkbPl8ORSeJLTXlE4
HH+gaGYN3T9q+bdt4/H8BdOJb+HqmvqAYNi3bLiDi/rEXden42B/SonzD7Am
qHlaPmyvv9z8GHw2vzxwAyy42SlphRMSFyk94OTzncscaJ4ViQtd4IYV41b+
DGv07YbmwYqoZb/ehLVJ1meC6fktZgH6jthvZTYlE+btaOLPh7uPiPxa4Oa6
qQ/j4IDheUcc0V+3PzvpFCw3HLm4G645UWB4Cy7pjgt8DCcf/qKoh2V+/k5c
zKvp8nRugn3WzzT5Ee6q2mpXCxO3ztA0eIeFRlYGqz+qVv9O93uvf3cCZk/X
tVyleR38GLCT1l+5UVcIK7wy+H4wR1F/ew/cfCfmkzXsGGRzyJ26ODVNS+9b
D+9KB/qJaPItrYIHIvzLtsP2rxIn5sHBgWPG9mM+dZnP5H1wif/23o2wLP9V
/RZ6P/OOBuWMw3ubcvHlelgtvDQ9ZCz6+2VI+hMsX2Rn4maC30n81JFomm+r
v8LMGPn8xzz1KMyL7G/85hvMSx5FlMLMatf99kaY51L+rl5a77qLdvMY9Ntm
8Zcj+ufZvs5sZDOk/K+LTyNhjbK2NhZWd+XIS2neWbXKJbCq3C9efxr63/eL
qQQOu1NVtwzmeBnEJsGuvXW1mdTPwla1w8nWDq3NcIlJ4/Ig1Au7nH3SdDru
y6UDSe9h7Qovp/mwotf0Ywb62zFz9tfNMEeTqu+B/iUpb7h7YLmZYddzOKhg
lVMKrDGcZROOeZnT/uuTYfWiIaM/YdGFpUkx1MNtcwXIp0H+8u1a+vzd/3VI
qK9Ex86BtdGXbRfCTNvpVRx63jWzBWNg1t6T5p3oNyrgRGM2zivZFC9V0v4f
qpSDqG/vlS5IgVVnxf0CWM7mj14HC0+1Fs5B/xLjggPusKJyb5ED5mO7zXll
S9eln+cR5CG4e2PElJ7/Mu3Yo9GoJwxz4MCaFZ4ROQYM8fZkpk+h642v9kez
8HvPLvd0oXlaBNr8qI/nG1frr6L1rYryQvTw/7j1a2IyrG6VDh8bxZA+Lp+p
gOXDZcnvCX7XD0ULCc37Az92DzwQ5M34wFEC2y53OMrDKiMdJnJthgAOsy9I
aIeDdT6j/eCuO/XzpjlhPTz54HG4ZoKR1TbqovH72Kgnm+V7tggWiguyM+By
SUNFO6y2P+czE/0JdQ3n2QLUcZXZtcCsbDdvPiy0u7duL+aRjURrXGFe9kZ/
c8zLyXwZNxvWprdqM2DLWkmWM0wGbWbrYGWzNGgSrE51yXNCXvYfRm0ZRD3F
66uRs2BL07raejhhIHbEBG6wyBoqhDnz77++jOejCpqzdsLBJ7+Mc4SLE4ZC
l8Dy9vHHI2m+90e72MCqOP69VPSbPEmaMUjvz01hZRKd74+U/uew5AbLbRPy
MOa3LKum92fCMuPwYTFxXH1dpIJVM0MTRw2JiaTH8noVzf9ZT+jpQTE5zM5c
+JTut8+qC/0sJhkdvZU6ev9ZNoHrP4qJgORF0vpkqY1n7gcxGdJzN1oF897m
pAv6xUSRN70una57WRVOeS8mPuc905/BTOSnvRFaMdHWctVTkY+qhZU/FZY9
XvFECityPN54wCKLuic3aJ6JpS0lcIL/cjM9Z6zfP3vjZ5ynk9jpL4CDS75b
Eot6fS+sA3ZTK99tKEQ/5b/yZpyDmVPcB+90mLfDwPohNesOb94nzNto+72G
npfv07oT8+18vHFNtzOd97P70QEx8W2pPNNJ96d5eoYjj5pPF8Y/ofv5v8UP
waLOT3rXYF6crGf2FzFRhnA3ZPz/+fyICXB329qYcDihlL3gIPZPEkyp96Dr
X7YxuThfVaZzHUvP+8Omxg/1W527QzpoHkzn72eQr8Sgj3udmttVfBXzdBsk
Pcmi+TQteX8Q8w9pi8v20XXh4dPb3ooJ686hrO1wwqJxfYrXYpKb0/lbNMxU
+N1t6hITzuhNRXvoerXC0FMjJsHckGuZ1P+W3RtowvvM2LemnOa9wZIjVWMe
+dekN9QGZ3vmVOH9+A0WOqJfctBo3QMl+jvz35tbqRXRM/pykc/350OU1PRz
/CYxpt//YP4GmMiV9w==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[CompressedData["
1:eJwV1gs01GkfB/AHzUTCuKyUMC6VS6JS2NT8u2iFWkUotQ25tNlFJVRoUMu8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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lG1QVFUYx8+KkQzjhyYZ3pfdPYc3hcHtFBRT+DBNCiq60Uy7IzXLLu1F
dBRzSYsSKNJsRlQQiIuYmYgrfKAALRxLAuVFTistTIOpRYysEDIyxlRQsT30
4dyZO3d+c+695zzP8///9fbCbMcyQsjLeC89J0d9eK0B8v/FIHSipfaGQF5x
bH5jAoPcryqP1qjIuVYS8QqDdd+VRtgUZEuwrakQ3zcuWhP5Egc22EsYiBR7
7oJvNRBwBJUcYLDvg+CV/QJ5+1s9q3Yx8G1+CLUq8tvuzsStDEx93r43FOSM
Y4vFsQyKpw8qnCMfL667t0ChKsDzq4Ygmy5unHFTaJrq8R8S8UBmv0lafoFC
TUb2F6dUZF1592gFhc0G8+AOBbms7pPeMgrVygNzCkce84btLKdgD+Db/Qhy
3MGivTUUvm0bjrgp4oD89bj3TAeFMpc4Xa8iWzIt2rsUorMtWkVBNk3megMY
eHP6u40ceVLTvOcZBgnta1r/9cVi/9Jic7YxuPhlwfyAQO6vKgwqYlA2/9KF
WhW5y5PwZimDKqPz6zwF2cV7/d9l4DdzYpWRL61rR2z5DC53dX2+6IvB/Sp+
friewcLZxReFQM4IONweyeBU86Nbqops6Wq8Pkuh52+2KV9BJrdn2q9TCE15
7tDTHNlVnf7DGQrn8i6Vawjy2jvxFR9TSB1NWu8W0UAO+x+4X0pB89G90XoV
2fX93icOURB/arPyFWSTfWrDSQrOPM8lzpGfrf5w+gqu330snhDk2Y6WYS+F
rcWNbUIwnOct6nkSz+eX9JqqIh/v05jTGGyKdMUoCvKspVVnY3DN75dAzpHX
/pE+vp9BnHtJfxTnl1o1iP1puKqbE4LK9aAmM9ZL5ffdV4fOKgqV/9cYcrI4
p3L/6on5H30+gzzfjDUxUwiDPH9541hbnWqQ9W0JCo91KAZZf/T0zU4jN8j+
XLZmvrfo08v+JTt63xkUetnfI5/91FGn6mX/u0NWYr16OR9HlOYK53o5v9rb
aa9riF7ON6t157Rb6OT83ZVHNjSoOqmPsYHOVwsUndTPyd9q/JO5TuqLTQ2b
lhGd1N+ce3dxgxol9blvfEsP51FSv5/ed3TdEFqpb8OwudemaKX+F5xq0rwv
UvqjrjPGVKlGSv/4z5kKVvNI6a+i89tOXxMR0n/O9v2PrEqE9Ge9M+f5f3zh
0r8ttt+fUtVw6W/SbNyTzMOl/7sf6EqGRZjMh5H3hyYKlTCZHysGUtcFkjCZ
L0eZH5xTQ2X+pC8nfS/wUJlPJOTO+IgIkfm1a/d5zw4lRObbzMiS/oJl/v0H
YYABMg==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"V\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T2 G2 N5\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 22}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwd1A9YzNkaB/CjJo22GClh+jOl2aLpmlYylOYXLaEYWlfSkkUlZcqqWCGV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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[CompressedData["
1:eJwV1gs01GkfB/AHzUTCuKyUMC6VS6JS2NT8u2iFWkUotQ25tNlFJVRoUMu8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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lgs4lGkbxyeHJbW7KtZphnm972uxCn0S8dVtUaImQiTr1Mgh1iGKlEOs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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T2 C1 N6\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 22}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwl1gk41dkbB/CfpYjk2hr7nm5jTSlC95ZqZObfXCMtU5YoO0nKMuiSROst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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.84576923551745, 13.562492355174511`}, \
{0, 1}], LineBox[CompressedData["
1:eJwl1wk8VekbB/CT7OuNyDZcjKVQVxNF6h6iFKJSRMoexbhqhKL/TchIYwkz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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {5.1542307644825485`, 4.562492355174517}, \
{0, 1}], LineBox[{{20.000000000002956`, 15.}, {10.000000000002956`, 14.}}], 
       PolygonBox[{{15.597022314125994`, 14.559702231412594`}, {
        14.363176198265606`, 14.83831264467139}, {14.442779173482407`, 
        14.0422828925034}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {14.84576923551745, 15.437507644825478`}, \
{0, -1}], 
       LineBox[{{19.999999999997726`, 4.999999999996362}, {9.999999999997726, 
        5.999999999996362}}], 
       PolygonBox[{{14.402977685874006`, 5.559702231412599}, {
        15.636823801734392`, 5.838312644671396}, {15.557220826517593`, 
        5.042282892503405}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {15.154230764482548`, 6.437507644825483}, \
{0, -1}], LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}], 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"F\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.3048, 9.999999999999995}, {1, 0}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T3 G1 N7\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 0}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwl1gk41dkbB/CfpYjk2hr7nm5jTSlC95ZqZObfXCMtU5YoO0nKMuiSROst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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.84576923551745, 13.562492355174511`}, \
{0, 1}], LineBox[CompressedData["
1:eJwl1wk8VekbB/CT7OuNyDZcjKVQVxNF6h6iFKJSRMoexbhqhKL/TchIYwkz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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {5.1542307644825485`, 4.562492355174517}, \
{0, 1}], LineBox[{{20.000000000002956`, 15.}, {10.000000000002956`, 14.}}], 
       PolygonBox[{{15.597022314125994`, 14.559702231412594`}, {
        14.363176198265606`, 14.83831264467139}, {14.442779173482407`, 
        14.0422828925034}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {14.84576923551745, 15.437507644825478`}, \
{0, -1}], 
       LineBox[{{19.999999999997726`, 4.999999999996362}, {9.999999999997726, 
        5.999999999996362}}], 
       PolygonBox[{{14.402977685874006`, 5.559702231412599}, {
        15.636823801734392`, 5.838312644671396}, {15.557220826517593`, 
        5.042282892503405}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {15.154230764482548`, 6.437507644825483}, \
{0, -1}], LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}], 
       PolygonBox[{{10., 10.599999999999994`}, {9.6, 9.399999999999995}, {
        10.4, 9.399999999999995}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.0548, 9.999999999999995}, {1, 0}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T3 C1 N8\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 0}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwl1gk41dkbB/CfpYjk2hr7nm5jTSlC95ZqZObfXCMtU5YoO0nKMuiSROst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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.84576923551745, 13.562492355174511`}, \
{0, 1}], LineBox[CompressedData["
1:eJwl1wk8VekbB/CT7OuNyDZcjKVQVxNF6h6iFKJSRMoexbhqhKL/TchIYwkz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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {5.1542307644825485`, 4.562492355174517}, \
{0, 1}], LineBox[{{20.00000000000182, 15.}, {10., 6.}}], 
       PolygonBox[{{15.4459764877483, 10.90137883897347}, {14.28643761960272, 
        10.395938819525396`}, {14.82160940490068, 9.801303502527663}}], 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.937558817093933`, 13.081023536561338`}, \
{1, -1}], LineBox[{{20.00000000000182, 5.}, {10., 14.}}], 
       PolygonBox[{{14.5540235122517, 9.901378838973464}, {15.71356238039728, 
        9.395938819525393}, {15.17839059509932, 8.80130350252766}}], 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.562441182905612`, 8.08102353656179}, \
{-1, -1}], LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}], 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"F\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.404800000000002, 9.999999999999995}, \
{1, 0}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T4 G1 N9\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 0}, {0, 0}, {22, 22}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"G\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {24., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"G\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {28.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[RightArrow]\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {33., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"t\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {37.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"t\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {42., 69.96}, {0, 0}]},
   AspectRatio->1.0999999999999999`,
   PlotRange->{{0, 66}, {0, 72.6}}], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777465408353*^9, 3.4778113180182*^9, 3.4778115983157*^9,
   3.47911751953127*^9, 3.47912291122788*^9, 3.479127333539017*^9, 
  3.499668102426846*^9, 3.49966818593785*^9, 3.500119781743864*^9, 
  3.500184820040362*^9, 3.500185289505512*^9, 3.500186826642324*^9, 
  3.500720184873517*^9, 3.5012370488350353`*^9, 3.501249426552867*^9, 
  3.5013992516790648`*^9, 3.503388667046302*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],

Cell[BoxData[
 FormBox[
  GraphicsBox[{InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwl1gk41dkbB/CfpYjk2hr7nm5jTSlC95ZqZObfXCMtU5YoO0nKMuiSROst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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.84576923551745, 13.562492355174511`}, \
{0, 1}], LineBox[CompressedData["
1:eJwl1wk8VekbB/CT7OuNyDZcjKVQVxNF6h6iFKJSRMoexbhqhKL/TchIYwkz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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {5.1542307644825485`, 4.562492355174517}, \
{0, 1}], LineBox[{{20.00000000000182, 15.}, {10., 6.}}], 
       PolygonBox[{{15.4459764877483, 10.90137883897347}, {14.28643761960272, 
        10.395938819525396`}, {14.82160940490068, 9.801303502527663}}], 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.937558817093933`, 13.081023536561338`}, \
{1, -1}], LineBox[{{20.00000000000182, 5.}, {10., 14.}}], 
       PolygonBox[{{14.5540235122517, 9.901378838973464}, {15.71356238039728, 
        9.395938819525393}, {15.17839059509932, 8.80130350252766}}], 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.562441182905612`, 8.08102353656179}, \
{-1, -1}], LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}], 
       PolygonBox[{{10., 9.399999999999995}, {9.6, 10.599999999999994`}, {
        10.4, 10.599999999999994`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.154800000000002, 9.999999999999995}, \
{1, 0}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T4 C1 N10\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 44}, {0, 0}, {22, 22}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"G\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {24., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"G\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {28.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[RightArrow]\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {33., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"t\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {37.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"t\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {42., 69.96}, {0, 0}]},
   AspectRatio->1.0999999999999999`,
   PlotRange->{{0, 66}, {0, 72.6}}], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777465408353*^9, 3.4778113180182*^9, 3.4778115983157*^9,
   3.47911751953127*^9, 3.47912291122788*^9, 3.479127333539017*^9, 
  3.499668102426846*^9, 3.49966818593785*^9, 3.500119781743864*^9, 
  3.500184820040362*^9, 3.500185289505512*^9, 3.500186826642324*^9, 
  3.500720184873517*^9, 3.5012370488350353`*^9, 3.501249426552867*^9, 
  3.5013992516790648`*^9, 3.503388667265033*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"FeynArtsGraphics", "(", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"G\"\>", ",", "\<\"G\"\>"}], "}"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\<\"t\"\>", ",", "\<\"t\"\>"}], "}"}]}], ")"}], 
   "\[InvisibleApplication]", 
   RowBox[{"(", 
    RowBox[{
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 G1 N1\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T1 G1 N1", "]"],
            Editable->False],
           TraditionalForm], 
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 C1 N2\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T1 C1 N2", "]"],
            Editable->False],
           TraditionalForm], 
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T2 G1 N3\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T2 G1 N3", "]"],
            Editable->False],
           TraditionalForm]},
         {
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T2 C1 N4\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T2 C1 N4", "]"],
            Editable->False],
           TraditionalForm], 
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T2 G2 N5\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T2 G2 N5", "]"],
            Editable->False],
           TraditionalForm], 
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T2 C1 N6\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T2 C1 N6", "]"],
            Editable->False],
           TraditionalForm]},
         {
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T3 G1 N7\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T3 G1 N7", "]"],
            Editable->False],
           TraditionalForm], 
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T3 C1 N8\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T3 C1 N8", "]"],
            Editable->False],
           TraditionalForm], 
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T4 G1 N9\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T4 G1 N9", "]"],
            Editable->False],
           TraditionalForm]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], ",", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T4 C1 N10\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T4 C1 N10", "]"],
            Editable->False],
           TraditionalForm], "Null", "Null"},
         {"Null", "Null", "Null"},
         {"Null", "Null", "Null"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.4777465415753*^9, 3.4778113186507*^9, 3.4778115990982*^9,
   3.479117520198227*^9, 3.479122912293442*^9, 3.479127334271197*^9, 
  3.499668102818342*^9, 3.499668186796363*^9, 3.500119782564604*^9, 
  3.5001848229144583`*^9, 3.500185290541686*^9, 3.5001868277615*^9, 
  3.500720186098106*^9, 3.5012370520085173`*^9, 3.501249429232916*^9, 
  3.501399254897502*^9, 3.5033886673718157`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Amplgg", " ", "=", " ", 
   RowBox[{"CreateFeynAmp", "[", "INTopogg", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.446964688702283*^9, 3.446964713617584*^9}, {
  3.4777465768328*^9, 3.4777465817878*^9}, {3.5013992630098877`*^9, 
  3.501399264850178*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.475488889115984*^9, 3.475488991008407*^9, 
  3.4777463712427998`*^9, 3.4777465826103*^9, 3.4778116132157*^9, 
  3.478438895955342*^9, 3.478439318735629*^9, 3.47911752774856*^9, 
  3.479122919377945*^9, 3.479127339768536*^9, 3.479547793712118*^9, 
  3.499668106238887*^9, 3.499668187943857*^9, 3.500119787888959*^9, 
  3.500184824550815*^9, 3.500185297253456*^9, 3.500186835022079*^9, 
  3.500720186964265*^9, 3.5012370958969297`*^9, 3.501249429590145*^9, 
  3.501399265638015*^9, 3.50338867030129*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"Generic", ",", "Classes"}], "}"}]}],
   SequenceForm[
   "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.475488889115984*^9, 3.475488991008407*^9, 
  3.4777463712427998`*^9, 3.4777465826103*^9, 3.4778116132157*^9, 
  3.478438895955342*^9, 3.478439318735629*^9, 3.47911752774856*^9, 
  3.479122919377945*^9, 3.479127339768536*^9, 3.479547793712118*^9, 
  3.499668106238887*^9, 3.499668187943857*^9, 3.500119787888959*^9, 
  3.500184824550815*^9, 3.500185297253456*^9, 3.500186835022079*^9, 
  3.500720186964265*^9, 3.5012370958969297`*^9, 3.501249429590145*^9, 
  3.501399265638015*^9, 3.503388670396833*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes amplitudes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.475488889115984*^9, 3.475488991008407*^9, 
  3.4777463712427998`*^9, 3.4777465826103*^9, 3.4778116132157*^9, 
  3.478438895955342*^9, 3.478439318735629*^9, 3.47911752774856*^9, 
  3.479122919377945*^9, 3.479127339768536*^9, 3.479547793712118*^9, 
  3.499668106238887*^9, 3.499668187943857*^9, 3.500119787888959*^9, 
  3.500184824550815*^9, 3.500185297253456*^9, 3.500186835022079*^9, 
  3.500720186964265*^9, 3.5012370958969297`*^9, 3.501249429590145*^9, 
  3.501399265638015*^9, 3.503388670409238*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"2 Generic, 2 Classes amplitudes\"\>"}],
   SequenceForm["> Top. ", 2, ": ", "2 Generic, 2 Classes amplitudes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.475488889115984*^9, 3.475488991008407*^9, 
  3.4777463712427998`*^9, 3.4777465826103*^9, 3.4778116132157*^9, 
  3.478438895955342*^9, 3.478439318735629*^9, 3.47911752774856*^9, 
  3.479122919377945*^9, 3.479127339768536*^9, 3.479547793712118*^9, 
  3.499668106238887*^9, 3.499668187943857*^9, 3.500119787888959*^9, 
  3.500184824550815*^9, 3.500185297253456*^9, 3.500186835022079*^9, 
  3.500720186964265*^9, 3.5012370958969297`*^9, 3.501249429590145*^9, 
  3.501399265638015*^9, 3.5033886704150867`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
   SequenceForm["> Top. ", 3, ": ", "1 Generic, 1 Classes amplitudes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.475488889115984*^9, 3.475488991008407*^9, 
  3.4777463712427998`*^9, 3.4777465826103*^9, 3.4778116132157*^9, 
  3.478438895955342*^9, 3.478439318735629*^9, 3.47911752774856*^9, 
  3.479122919377945*^9, 3.479127339768536*^9, 3.479547793712118*^9, 
  3.499668106238887*^9, 3.499668187943857*^9, 3.500119787888959*^9, 
  3.500184824550815*^9, 3.500185297253456*^9, 3.500186835022079*^9, 
  3.500720186964265*^9, 3.5012370958969297`*^9, 3.501249429590145*^9, 
  3.501399265638015*^9, 3.503388670653047*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
   SequenceForm["> Top. ", 4, ": ", "1 Generic, 1 Classes amplitudes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.475488889115984*^9, 3.475488991008407*^9, 
  3.4777463712427998`*^9, 3.4777465826103*^9, 3.4778116132157*^9, 
  3.478438895955342*^9, 3.478439318735629*^9, 3.47911752774856*^9, 
  3.479122919377945*^9, 3.479127339768536*^9, 3.479547793712118*^9, 
  3.499668106238887*^9, 3.499668187943857*^9, 3.500119787888959*^9, 
  3.500184824550815*^9, 3.500185297253456*^9, 3.500186835022079*^9, 
  3.500720186964265*^9, 3.5012370958969297`*^9, 3.501249429590145*^9, 
  3.501399265638015*^9, 3.5033886707653437`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"in total: \"\>", 
    "\[InvisibleSpace]", "\<\"5 Generic, 5 Classes amplitudes\"\>"}],
   SequenceForm["in total: ", "5 Generic, 5 Classes amplitudes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.475488889115984*^9, 3.475488991008407*^9, 
  3.4777463712427998`*^9, 3.4777465826103*^9, 3.4778116132157*^9, 
  3.478438895955342*^9, 3.478439318735629*^9, 3.47911752774856*^9, 
  3.479122919377945*^9, 3.479127339768536*^9, 3.479547793712118*^9, 
  3.499668106238887*^9, 3.499668187943857*^9, 3.500119787888959*^9, 
  3.500184824550815*^9, 3.500185297253456*^9, 3.500186835022079*^9, 
  3.500720186964265*^9, 3.5012370958969297`*^9, 3.501249429590145*^9, 
  3.501399265638015*^9, 3.503388670879325*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\</home/degrande/eta/FeynProg/FormCalc-6.2\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "FormCalc`"}]}], "Input",
 CellChangeTimes->{
  3.4777456682883*^9, {3.4778119018507*^9, 3.4778119054056997`*^9}, {
   3.4778119371527*^9, 3.4778119527257*^9}, {3.478434390853149*^9, 
   3.478434394596879*^9}, {3.499668112516885*^9, 3.499668113089447*^9}, {
   3.4996681644825993`*^9, 3.499668165126392*^9}, {3.5001868068055573`*^9, 
   3.500186807376361*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778119597987003`*^9, 3.4778120637597*^9, 3.478434395661687*^9, 
   3.478435582118547*^9, 3.478435888622634*^9, 3.478436917398712*^9, 
   3.478438958877307*^9, 3.478439329598132*^9, 3.479117548181937*^9, 
   3.479122924582738*^9, 3.4791273434512*^9, 3.479547801779126*^9, 
   3.499668113681034*^9, {3.499668165596154*^9, 3.499668191248694*^9}, 
   3.500119791013183*^9, 3.500184828501986*^9, 3.500186836942271*^9, 
   3.500720188703435*^9, 3.501237098717702*^9, 3.501249431967148*^9, 
   3.501399267387126*^9, 3.5033886740726547`*^9}],

Cell[BoxData[
 FormBox["\<\"FormCalc 6.2\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778119597987003`*^9, 3.4778120637597*^9, 3.478434395661687*^9, 
   3.478435582118547*^9, 3.478435888622634*^9, 3.478436917398712*^9, 
   3.478438958877307*^9, 3.478439329598132*^9, 3.479117548181937*^9, 
   3.479122924582738*^9, 3.4791273434512*^9, 3.479547801779126*^9, 
   3.499668113681034*^9, {3.499668165596154*^9, 3.499668191248694*^9}, 
   3.500119791013183*^9, 3.500184828501986*^9, 3.500186836942271*^9, 
   3.500720188703435*^9, 3.501237098717702*^9, 3.501249431967148*^9, 
   3.501399267387126*^9, 3.503388674144681*^9}],

Cell[BoxData[
 FormBox["\<\"by Thomas Hahn\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778119597987003`*^9, 3.4778120637597*^9, 3.478434395661687*^9, 
   3.478435582118547*^9, 3.478435888622634*^9, 3.478436917398712*^9, 
   3.478438958877307*^9, 3.478439329598132*^9, 3.479117548181937*^9, 
   3.479122924582738*^9, 3.4791273434512*^9, 3.479547801779126*^9, 
   3.499668113681034*^9, {3.499668165596154*^9, 3.499668191248694*^9}, 
   3.500119791013183*^9, 3.500184828501986*^9, 3.500186836942271*^9, 
   3.500720188703435*^9, 3.501237098717702*^9, 3.501249431967148*^9, 
   3.501399267387126*^9, 3.5033886741525497`*^9}],

Cell[BoxData[
 FormBox["\<\"last revised 11 Aug 10\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778119597987003`*^9, 3.4778120637597*^9, 3.478434395661687*^9, 
   3.478435582118547*^9, 3.478435888622634*^9, 3.478436917398712*^9, 
   3.478438958877307*^9, 3.478439329598132*^9, 3.479117548181937*^9, 
   3.479122924582738*^9, 3.4791273434512*^9, 3.479547801779126*^9, 
   3.499668113681034*^9, {3.499668165596154*^9, 3.499668191248694*^9}, 
   3.500119791013183*^9, 3.500184828501986*^9, 3.500186836942271*^9, 
   3.500720188703435*^9, 3.501237098717702*^9, 3.501249431967148*^9, 
   3.501399267387126*^9, 3.503388674160263*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mgg", " ", "=", " ", 
   RowBox[{"CalcFeynAmp", "[", 
    RowBox[{"Amplgg", ",", 
     RowBox[{"FermionChains", "\[Rule]", "Chiral"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.4778119845017*^9, 3.4778120345607*^9}, {
   3.478435376938886*^9, 3.478435418868291*^9}, {3.478438964655293*^9, 
   3.478438969526842*^9}, 3.47954781796*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.478434402570528*^9, 3.478435422620416*^9, 3.478435588542779*^9, 
   3.478435896246393*^9, 3.478436924110362*^9, 3.478438969665351*^9, 
   3.478439333076723*^9, 3.479117552259757*^9, 3.479122928826005*^9, 
   3.479127346493529*^9, {3.47954780726633*^9, 3.479547818642441*^9}, 
   3.499668117837504*^9, 3.499668192781815*^9, 3.500119794018145*^9, 
   3.500184830337043*^9, 3.50018530137351*^9, 3.500186838923935*^9, 
   3.500720190059483*^9, 3.501237101716735*^9, 3.5012494334855556`*^9, 
   3.5013992687394533`*^9, 3.503388675703277*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc12.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc12.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.478434402570528*^9, 3.478435422620416*^9, 3.478435588542779*^9, 
   3.478435896246393*^9, 3.478436924110362*^9, 3.478438969665351*^9, 
   3.478439333076723*^9, 3.479117552259757*^9, 3.479122928826005*^9, 
   3.479127346493529*^9, {3.47954780726633*^9, 3.479547818642441*^9}, 
   3.499668117837504*^9, 3.499668192781815*^9, 3.500119794018145*^9, 
   3.500184830337043*^9, 3.50018530137351*^9, 3.500186838923935*^9, 
   3.500720190059483*^9, 3.501237101716735*^9, 3.5012494334855556`*^9, 
   3.5013992687394533`*^9, 3.503388675777027*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{
  3.478434402570528*^9, 3.478435422620416*^9, 3.478435588542779*^9, 
   3.478435896246393*^9, 3.478436924110362*^9, 3.478438969665351*^9, 
   3.478439333076723*^9, 3.479117552259757*^9, 3.479122928826005*^9, 
   3.479127346493529*^9, {3.47954780726633*^9, 3.479547818642441*^9}, 
   3.499668117837504*^9, 3.499668192781815*^9, 3.500119794018145*^9, 
   3.500184830337043*^9, 3.50018530137351*^9, 3.500186838923935*^9, 
   3.500720190059483*^9, 3.501237101716735*^9, 3.5012494334855556`*^9, 
   3.5013992687394533`*^9, 3.5033886760077057`*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.478434402570528*^9, 3.478435422620416*^9, 3.478435588542779*^9, 
   3.478435896246393*^9, 3.478436924110362*^9, 3.478438969665351*^9, 
   3.478439333076723*^9, 3.479117552259757*^9, 3.479122928826005*^9, 
   3.479127346493529*^9, {3.47954780726633*^9, 3.479547818642441*^9}, 
   3.499668117837504*^9, 3.499668192781815*^9, 3.500119794018145*^9, 
   3.500184830337043*^9, 3.50018530137351*^9, 3.500186838923935*^9, 
   3.500720190059483*^9, 3.501237101716735*^9, 3.5012494334855556`*^9, 
   3.5013992687394533`*^9, 3.503388676772092*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"col", "=", 
   RowBox[{"ColourME", "[", "Mgg", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.478434696113564*^9, 3.478434729084623*^9}, {
   3.478435197289632*^9, 3.478435232835993*^9}, {3.478436054623279*^9, 
   3.478436055525961*^9}, {3.478439375412303*^9, 3.478439375575861*^9}, 
   3.47954782272826*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"_Hel", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hel", "=", 
   RowBox[{"HelicityME", "[", "Mgg", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.478435272631223*^9, 3.478435280805309*^9}, {
   3.478435549596737*^9, 3.478435557227066*^9}, {3.478436067208497*^9, 
   3.478436071671449*^9}, {3.478436592499899*^9, 3.478436607261712*^9}, {
   3.478439379367485*^9, 3.478439379534112*^9}, 3.479547824572277*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "256", 
    "\[InvisibleSpace]", "\<\" helicity matrix elements\"\>"}],
   SequenceForm["> ", 256, " helicity matrix elements"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.478439379863814*^9, 3.479117581923581*^9, 
  3.479122941157755*^9, 3.479127401956545*^9, 3.479547825368561*^9, 
  3.4996681230126467`*^9, 3.499668196463399*^9, 3.5001198026540613`*^9, 
  3.5001848354441223`*^9, 3.500185308027774*^9, 3.50018684249712*^9, 
  3.500720192951681*^9, 3.501237107803631*^9, 3.501249435522855*^9, 
  3.501399271134717*^9, 3.503388681839294*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.478439379863814*^9, 3.479117581923581*^9, 
  3.479122941157755*^9, 3.479127401956545*^9, 3.479547825368561*^9, 
  3.4996681230126467`*^9, 3.499668196463399*^9, 3.5001198026540613`*^9, 
  3.5001848354441223`*^9, 3.500185308027774*^9, 3.50018684249712*^9, 
  3.500720192951681*^9, 3.501237107803631*^9, 3.501249435522855*^9, 
  3.501399271134717*^9, 3.503388681941927*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc12.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc12.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.478439379863814*^9, 3.479117581923581*^9, 
  3.479122941157755*^9, 3.479127401956545*^9, 3.479547825368561*^9, 
  3.4996681230126467`*^9, 3.499668196463399*^9, 3.5001198026540613`*^9, 
  3.5001848354441223`*^9, 3.500185308027774*^9, 3.50018684249712*^9, 
  3.500720192951681*^9, 3.501237107803631*^9, 3.501249435522855*^9, 
  3.501399271134717*^9, 3.503388681954525*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{3.478439379863814*^9, 3.479117581923581*^9, 
  3.479122941157755*^9, 3.479127401956545*^9, 3.479547825368561*^9, 
  3.4996681230126467`*^9, 3.499668196463399*^9, 3.5001198026540613`*^9, 
  3.5001848354441223`*^9, 3.500185308027774*^9, 3.50018684249712*^9, 
  3.500720192951681*^9, 3.501237107803631*^9, 3.501249435522855*^9, 
  3.501399271134717*^9, 3.5033886820772543`*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.478439379863814*^9, 3.479117581923581*^9, 
  3.479122941157755*^9, 3.479127401956545*^9, 3.479547825368561*^9, 
  3.4996681230126467`*^9, 3.499668196463399*^9, 3.5001198026540613`*^9, 
  3.5001848354441223`*^9, 3.500185308027774*^9, 3.50018684249712*^9, 
  3.500720192951681*^9, 3.501237107803631*^9, 3.501249435522855*^9, 
  3.501399271134717*^9, 3.5033886828197412`*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Mgg2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"SquaredME", "[", "Mgg", "]"}], "/.", "hel"}], "/.", "col"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.478436009927547*^9, 3.478436018997932*^9}, {
   3.478436082403898*^9, 3.478436090700395*^9}, {3.478436177508675*^9, 
   3.47843618204671*^9}, {3.478437003898071*^9, 3.47843701110685*^9}, {
   3.478437477803822*^9, 3.478437504302616*^9}, {3.478439384069483*^9, 
   3.478439384257797*^9}, {3.479118059131767*^9, 3.479118076021708*^9}, {
   3.479118109146226*^9, 3.479118116650997*^9}, {3.479118202216882*^9, 
   3.479118216760961*^9}, 3.479119017869164*^9, 3.479119745593796*^9, 
   3.479123731953217*^9, 3.479127413095424*^9, {3.479183735054553*^9, 
   3.479183738211356*^9}, 3.479184069931285*^9}],

Cell[CellGroupData[{

Cell["CtG", "Section",
 CellChangeTimes->{{3.500720327799191*^9, 3.500720328826457*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Mgg3", "=", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Mgg2", "/.", "M$FACouplings"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"CphiG", "->", "0"}], ",", 
          RowBox[{"CG", "\[Rule]", "0"}], ",", 
          RowBox[{"Lambda", "\[Rule]", 
           RowBox[{"1", "/", "Linv"}]}], ",", 
          RowBox[{
           RowBox[{"Conjugate", "[", "Lambda", "]"}], "->", 
           RowBox[{"1", "/", "Linv"}]}], ",", 
          RowBox[{
           RowBox[{"Conjugate", "[", "v", "]"}], "\[Rule]", "v"}]}], "}"}]}], 
       "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Linv", "^", "4"}], "\[Rule]", "0"}], ",", 
         RowBox[{
          RowBox[{"Linv", "^", "6"}], "\[Rule]", "0"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"Linv", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.500120264683782*^9, 3.500120270634116*^9}, {
  3.50012037229132*^9, 3.500120418987548*^9}, {3.5001206930421867`*^9, 
  3.500120721959036*^9}, {3.500120848018794*^9, 3.500120861852392*^9}, {
  3.5001209888233223`*^9, 3.5001209942671537`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mgg4", "=", 
   RowBox[{"PolarizationSum", "[", "Mgg3", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.479118824157723*^9, 3.479118845390859*^9}, 
   3.479184075522476*^9, 3.479184702412253*^9, {3.479184749867283*^9, 
   3.479184750460338*^9}, {3.479189331731915*^9, 3.479189334149471*^9}, 
   3.479189365494795*^9, {3.499668236444878*^9, 3.4996682500534763`*^9}, 
   3.4996812040209303`*^9, {3.500119934667719*^9, 3.500119939113467*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.50012517444248*^9, 3.5001848869617853`*^9, 3.5001853366222754`*^9, 
  3.500186870653371*^9, 3.500720226897994*^9, 3.501399413052071*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.50012517444248*^9, 3.5001848869617853`*^9, 3.5001853366222754`*^9, 
  3.500186870653371*^9, 3.500720226897994*^9, 3.501399413075502*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.50012517444248*^9, 3.5001848869617853`*^9, 3.5001853366222754`*^9, 
  3.500186870653371*^9, 3.500720226897994*^9, 3.5013994137712708`*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.50012517444248*^9, 3.5001848869617853`*^9, 3.5001853366222754`*^9, 
  3.500186870653371*^9, 3.500720226897994*^9, 3.501399416246995*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mgg5", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Normal", "[", 
       RowBox[{"Series", "[", 
        RowBox[{"Mgg4", ",", 
         RowBox[{"{", 
          RowBox[{"Linv", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}], "//.", 
      
      RowBox[{"Abbr", "[", "]"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Den", "[", 
        RowBox[{"a_", ",", "b_"}], "]"}], "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"a", "-", "b"}], ")"}]}]}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{"U", "\[Rule]", 
      RowBox[{
       RowBox[{"2", "MT2"}], "-", "S", "-", "T"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.500121033903965*^9, 3.500121114625811*^9}, {
   3.5001211824541607`*^9, 3.5001212364853497`*^9}, 3.500121270669372*^9, {
   3.5001215329435596`*^9, 3.5001215499458303`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"3", " ", "GS", " ", 
      SuperscriptBox["S", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"MT2", "-", "T"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}], "2"]}]], 
    RowBox[{"128", " ", "Alfas2", " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"9", " ", 
        SuperscriptBox["MT2", "2"]}], "-", 
       RowBox[{"9", " ", 
        RowBox[{"(", 
         RowBox[{"S", "+", 
          RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["S", "2"]}], "+", 
       RowBox[{"9", " ", 
        SuperscriptBox["T", "2"]}], "+", 
       RowBox[{"9", " ", "S", " ", "T"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"GS", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["MT2", "4"]}], "-", 
          RowBox[{"8", " ", "T", " ", 
           SuperscriptBox["MT2", "3"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["S", "2"]}], "+", 
             RowBox[{"4", " ", "T", " ", "S"}], "+", 
             RowBox[{"12", " ", 
              SuperscriptBox["T", "2"]}]}], ")"}], " ", 
           SuperscriptBox["MT2", "2"]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["S", "3"], "+", 
             RowBox[{"2", " ", "T", " ", 
              SuperscriptBox["S", "2"]}], "+", 
             RowBox[{"8", " ", 
              SuperscriptBox["T", "2"], " ", "S"}], "+", 
             RowBox[{"8", " ", 
              SuperscriptBox["T", "3"]}]}], ")"}], " ", "MT2"}], "+", 
          RowBox[{"T", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", "T"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["S", "2"], "+", 
             RowBox[{"2", " ", "T", " ", "S"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["T", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
       RowBox[{"8", " ", 
        SqrtBox["2"], " ", 
        SuperscriptBox["Linv", "2"], " ", "MT", " ", 
        SuperscriptBox["S", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"MT2", "-", "T"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}], " ", "v", " ", 
        RowBox[{"Re", "(", "CtG", ")"}]}]}], ")"}]}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.500121036185227*^9, 3.500121128547367*^9, 3.500121203492289*^9, {
   3.500121256618002*^9, 3.5001212748748693`*^9}, {3.500121542945138*^9, 
   3.500121555852314*^9}, 3.500125179787794*^9, 3.500184899087121*^9, 
   3.500185339312373*^9, 3.500186882665247*^9, 3.5007202357056837`*^9, 
   3.5013994211521673`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Coefficient", "[", 
      RowBox[{"Mgg5", ",", "Linv", ",", "2"}], "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Alfas2", "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"gS", "^", "2"}], "/", 
           RowBox[{"(", 
            RowBox[{"4", "\[Pi]"}], ")"}]}], ")"}], "^", "2"}]}], ",", 
       RowBox[{"GS", "\[Rule]", "gS"}]}], "}"}]}], "]"}], "/", "256"}], "*", 
  "4"}]], "Input",
 CellChangeTimes->{{3.50012203175807*^9, 3.500122085944367*^9}, {
  3.500186303411706*^9, 3.500186330919297*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    SqrtBox["2"], " ", 
    SuperscriptBox["gS", "3"], " ", "MT", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"9", " ", 
       SuperscriptBox["MT2", "2"]}], "-", 
      RowBox[{"9", " ", 
       RowBox[{"(", 
        RowBox[{"S", "+", 
         RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["S", "2"]}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["T", "2"]}], "+", 
      RowBox[{"9", " ", "S", " ", "T"}]}], ")"}], " ", "v", " ", 
    RowBox[{"Re", "(", "CtG", ")"}]}], 
   RowBox[{"3", " ", 
    RowBox[{"(", 
     RowBox[{"MT2", "-", "T"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}]}]], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.500122086278297*^9, 3.5001251802730503`*^9, 
  3.500184902946899*^9, 3.5001853459062643`*^9, 3.5001863317168818`*^9, 
  3.500186883040023*^9, 3.500720236206966*^9, 3.501399421477417*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    SqrtBox["2"], " ", 
    SuperscriptBox["gS", "3"], " ", "MT", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"9", " ", 
       SuperscriptBox["MT2", "2"]}], "-", 
      RowBox[{"9", " ", 
       RowBox[{"(", 
        RowBox[{"S", "+", 
         RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["S", "2"]}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["T", "2"]}], "+", 
      RowBox[{"9", " ", "S", " ", "T"}]}], ")"}], " ", "v", " ", 
    RowBox[{"Re", "(", "CtG", ")"}]}], 
   RowBox[{"3", " ", 
    RowBox[{"(", 
     RowBox[{"MT2", "-", "T"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}]}]], 
  TraditionalForm]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["CphiG", "Section",
 CellChangeTimes->{{3.500720336838606*^9, 3.50072036628692*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Mgg3phiG", "=", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Mgg2", "/.", "M$FACouplings"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Conjugate", "[", "CphiG", "]"}], "->", "CphiG"}], ",", 
          RowBox[{"CtG", "->", "0"}], ",", 
          RowBox[{"CG", "\[Rule]", "0"}], ",", 
          RowBox[{"Lambda", "\[Rule]", 
           RowBox[{"1", "/", "Linv"}]}], ",", 
          RowBox[{
           RowBox[{"Conjugate", "[", "Lambda", "]"}], "->", 
           RowBox[{"1", "/", "Linv"}]}], ",", 
          RowBox[{
           RowBox[{"Conjugate", "[", "v", "]"}], "\[Rule]", "v"}]}], "}"}]}], 
       "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Linv", "^", "4"}], "\[Rule]", "0"}], ",", 
         RowBox[{
          RowBox[{"Linv", "^", "6"}], "\[Rule]", "0"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"Linv", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.500120264683782*^9, 3.500120270634116*^9}, {
  3.50012037229132*^9, 3.500120418987548*^9}, {3.5001206930421867`*^9, 
  3.500120721959036*^9}, {3.500120848018794*^9, 3.500120861852392*^9}, {
  3.5001209888233223`*^9, 3.5001209942671537`*^9}, {3.500123028422268*^9, 
  3.500123032939645*^9}, {3.500125188809121*^9, 3.5001251953886423`*^9}, {
  3.500125229712288*^9, 3.500125249872898*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mgg4phiG", "=", 
   RowBox[{"PolarizationSum", "[", "Mgg3phiG", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.479118824157723*^9, 3.479118845390859*^9}, 
   3.479184075522476*^9, 3.479184702412253*^9, {3.479184749867283*^9, 
   3.479184750460338*^9}, {3.479189331731915*^9, 3.479189334149471*^9}, 
   3.479189365494795*^9, {3.499668236444878*^9, 3.4996682500534763`*^9}, 
   3.4996812040209303`*^9, {3.500119934667719*^9, 3.500119939113467*^9}, {
   3.5001231035869923`*^9, 3.5001231093806458`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.5001231134286337`*^9, 3.500125204793819*^9, 3.500125265844116*^9, 
  3.500184914061057*^9, 3.500185355437488*^9, 3.50018689154836*^9, 
  3.50072031655987*^9, 3.501237135345908*^9, 3.501250105097187*^9, 
  3.501399289415079*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.5001231134286337`*^9, 3.500125204793819*^9, 3.500125265844116*^9, 
  3.500184914061057*^9, 3.500185355437488*^9, 3.50018689154836*^9, 
  3.50072031655987*^9, 3.501237135345908*^9, 3.501250105097187*^9, 
  3.501399289431369*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.5001231134286337`*^9, 3.500125204793819*^9, 3.500125265844116*^9, 
  3.500184914061057*^9, 3.500185355437488*^9, 3.50018689154836*^9, 
  3.50072031655987*^9, 3.501237135345908*^9, 3.501250105097187*^9, 
  3.5013992896726913`*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.5001231134286337`*^9, 3.500125204793819*^9, 3.500125265844116*^9, 
  3.500184914061057*^9, 3.500185355437488*^9, 3.50018689154836*^9, 
  3.50072031655987*^9, 3.501237135345908*^9, 3.501250105097187*^9, 
  3.501399290099275*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mgg5phiG", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Normal", "[", 
       RowBox[{"Series", "[", 
        RowBox[{"Mgg4phiG", ",", 
         RowBox[{"{", 
          RowBox[{"Linv", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}], "//.", 
      
      RowBox[{"Abbr", "[", "]"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Den", "[", 
        RowBox[{"a_", ",", "b_"}], "]"}], "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"a", "-", "b"}], ")"}]}]}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{"U", "\[Rule]", 
      RowBox[{
       RowBox[{"2", "MT2"}], "-", "S", "-", "T"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.500121033903965*^9, 3.500121114625811*^9}, {
   3.5001211824541607`*^9, 3.5001212364853497`*^9}, 3.500121270669372*^9, {
   3.5001215329435596`*^9, 3.5001215499458303`*^9}, {3.500123112825931*^9, 
   3.500123116191039*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"16", " ", "\[Pi]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SqrtBox["2"], " ", "Alfas", " ", "CphiG", " ", 
        SuperscriptBox["Linv", "2"], " ", "MT", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "MT2"}], "-", "S"}], ")"}], " ", 
        SuperscriptBox["S", "4"], " ", 
        RowBox[{"(", 
         RowBox[{"MT2", "-", "T"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"MT2", "-", "S", "-", "T"}], ")"}], " ", "v", " ", 
        RowBox[{"Re", "(", "yt", ")"}]}], "-", 
       RowBox[{"8", " ", "Alfas2", " ", "\[Pi]", " ", 
        RowBox[{"(", 
         RowBox[{"MH2", "-", "S"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"9", " ", 
           SuperscriptBox["MT2", "2"]}], "-", 
          RowBox[{"9", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", 
             RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["S", "2"]}], "+", 
          RowBox[{"9", " ", 
           SuperscriptBox["T", "2"]}], "+", 
          RowBox[{"9", " ", "S", " ", "T"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["MT2", "4"]}], "-", 
          RowBox[{"8", " ", "T", " ", 
           SuperscriptBox["MT2", "3"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["S", "2"]}], "+", 
             RowBox[{"4", " ", "T", " ", "S"}], "+", 
             RowBox[{"12", " ", 
              SuperscriptBox["T", "2"]}]}], ")"}], " ", 
           SuperscriptBox["MT2", "2"]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["S", "3"], "+", 
             RowBox[{"2", " ", "T", " ", 
              SuperscriptBox["S", "2"]}], "+", 
             RowBox[{"8", " ", 
              SuperscriptBox["T", "2"], " ", "S"}], "+", 
             RowBox[{"8", " ", 
              SuperscriptBox["T", "3"]}]}], ")"}], " ", "MT2"}], "+", 
          RowBox[{"T", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", "T"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["S", "2"], "+", 
             RowBox[{"2", " ", "T", " ", "S"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["T", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
    ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{"MH2", "-", "S"}], ")"}], " ", 
     SuperscriptBox["S", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"MT2", "-", "T"}], ")"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}], "2"]}], ")"}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.500121036185227*^9, 3.500121128547367*^9, 3.500121203492289*^9, {
   3.500121256618002*^9, 3.5001212748748693`*^9}, {3.500121542945138*^9, 
   3.500121555852314*^9}, 3.50012423264614*^9, 3.5001252104076347`*^9, 
   3.500125376363772*^9, 3.500184918396678*^9, 3.500185363954321*^9, 
   3.500186900292087*^9, 3.500720377112378*^9, 3.501237143994937*^9, 
   3.501250111402198*^9, 3.501399297290761*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"FullSimplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"Mgg5phiG", ",", "Linv", ",", "2"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Alfas", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"gS", "^", "2"}], "/", 
              RowBox[{"(", 
               RowBox[{"4", "\[Pi]"}], ")"}]}], ")"}]}], ",", 
           RowBox[{"GS", "\[Rule]", "gS"}]}], "}"}]}], ",", 
        RowBox[{"Assumptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"yt", "\[Element]", "Reals"}], "}"}]}]}], "]"}], "/.", 
      RowBox[{"yt", "\[Rule]", 
       RowBox[{
        RowBox[{"MT", "/", "v"}], "*", 
        RowBox[{"Sqrt", "[", "2", "]"}]}]}]}], ")"}], "/", "256"}], "*", 
   "4"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"S", "+", "T"}], "\[Rule]", 
    RowBox[{
     RowBox[{"2", "MT2"}], "-", "U"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.50012203175807*^9, 3.500122085944367*^9}, 
   3.5001231183600893`*^9, {3.500125033132867*^9, 3.500125044530876*^9}, {
   3.5001251127394114`*^9, 3.5001251219076443`*^9}, {3.5001255153819227`*^9, 
   3.500125517885804*^9}, 3.500184925533991*^9, {3.500186199611189*^9, 
   3.50018621277183*^9}, {3.5007204866037827`*^9, 3.500720545215563*^9}, {
   3.500720651783415*^9, 3.50072065380229*^9}, {3.5007206971635923`*^9, 
   3.5007207185345707`*^9}, {3.501237203081002*^9, 3.501237203409219*^9}, {
   3.501250090925185*^9, 3.501250095113491*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"CphiG", " ", 
    SuperscriptBox["gS", "2"], " ", "MT2", " ", 
    SuperscriptBox["S", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"S", "-", 
      RowBox[{"4", " ", "MT2"}]}], ")"}]}], 
   RowBox[{"8", " ", 
    RowBox[{"(", 
     RowBox[{"MH2", "-", "S"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"MT2", "-", "T"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"MT2", "-", "U"}], ")"}]}]], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.500122086278297*^9, 3.500125008672204*^9, 3.5001250478116302`*^9, {
   3.500125106366685*^9, 3.500125113515643*^9}, 3.5001252130924463`*^9, 
   3.500125506697605*^9, 3.500125539060231*^9, {3.5001849226453257`*^9, 
   3.5001849259513893`*^9}, 3.500185367401535*^9, 3.500186213475864*^9, 
   3.500186902364727*^9, 3.500720381914975*^9, 3.500720506468848*^9, 
   3.500720545907434*^9, 3.500720654681629*^9, 3.50072071944659*^9, 
   3.501237146604053*^9, 3.501237204467822*^9, {3.501250095504642*^9, 
   3.501250111939377*^9}, 3.501399302265152*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["CG", "Section",
 CellChangeTimes->{{3.5007207391466703`*^9, 3.500720743283609*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Mgg3G", "=", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Mgg2", "/.", "M$FACouplings"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"CphiG", "\[Rule]", "0"}], ",", 
         RowBox[{"CtG", "->", "0"}], ",", 
         RowBox[{"Lambda", "\[Rule]", 
          RowBox[{"1", "/", "Linv"}]}], ",", 
         RowBox[{
          RowBox[{"Conjugate", "[", "Lambda", "]"}], "->", 
          RowBox[{"1", "/", "Linv"}]}], ",", 
         RowBox[{
          RowBox[{"Conjugate", "[", "v", "]"}], "\[Rule]", "v"}]}], "}"}]}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"Linv", ",", "0", ",", "4"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.500120264683782*^9, 3.500120270634116*^9}, {
  3.50012037229132*^9, 3.500120418987548*^9}, {3.5001206930421867`*^9, 
  3.500120721959036*^9}, {3.500120848018794*^9, 3.500120861852392*^9}, {
  3.5001209888233223`*^9, 3.5001209942671537`*^9}, {3.500123028422268*^9, 
  3.500123032939645*^9}, {3.500125188809121*^9, 3.5001251953886423`*^9}, {
  3.500125229712288*^9, 3.500125249872898*^9}, {3.500125316928153*^9, 
  3.500125331580917*^9}, {3.503388714519079*^9, 3.503388718252164*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mgg4G", "=", 
   RowBox[{"PolarizationSum", "[", "Mgg3G", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.479118824157723*^9, 3.479118845390859*^9}, 
   3.479184075522476*^9, 3.479184702412253*^9, {3.479184749867283*^9, 
   3.479184750460338*^9}, {3.479189331731915*^9, 3.479189334149471*^9}, 
   3.479189365494795*^9, {3.499668236444878*^9, 3.4996682500534763`*^9}, 
   3.4996812040209303`*^9, {3.500119934667719*^9, 3.500119939113467*^9}, {
   3.5001231035869923`*^9, 3.5001231093806458`*^9}, {3.5001253379428*^9, 
   3.500125341447617*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.5001231134286337`*^9, 3.500125204793819*^9, 3.500125265844116*^9, 
  3.5001255634304533`*^9, 3.500184943185277*^9, 3.500185549151003*^9, 
  3.5001869094329233`*^9, 3.500720752251639*^9, 3.501237425351446*^9, 
  3.5012494660795927`*^9, 3.501399511453821*^9, 3.503388726572712*^9, 
  3.503388789050849*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc12.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc12.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.5001231134286337`*^9, 3.500125204793819*^9, 3.500125265844116*^9, 
  3.5001255634304533`*^9, 3.500184943185277*^9, 3.500185549151003*^9, 
  3.5001869094329233`*^9, 3.500720752251639*^9, 3.501237425351446*^9, 
  3.5012494660795927`*^9, 3.501399511453821*^9, 3.503388726572712*^9, 
  3.503388789342754*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.5001231134286337`*^9, 3.500125204793819*^9, 3.500125265844116*^9, 
  3.5001255634304533`*^9, 3.500184943185277*^9, 3.500185549151003*^9, 
  3.5001869094329233`*^9, 3.500720752251639*^9, 3.501237425351446*^9, 
  3.5012494660795927`*^9, 3.501399511453821*^9, 3.503388726572712*^9, 
  3.503388789611949*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.5001231134286337`*^9, 3.500125204793819*^9, 3.500125265844116*^9, 
  3.5001255634304533`*^9, 3.500184943185277*^9, 3.500185549151003*^9, 
  3.5001869094329233`*^9, 3.500720752251639*^9, 3.501237425351446*^9, 
  3.5012494660795927`*^9, 3.501399511453821*^9, 3.503388726572712*^9, 
  3.503388789830514*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mgg5G", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Normal", "[", 
       RowBox[{"Series", "[", 
        RowBox[{"Mgg4G", ",", 
         RowBox[{"{", 
          RowBox[{"Linv", ",", "0", ",", "4"}], "}"}]}], "]"}], "]"}], "//.", 
      
      RowBox[{"Abbr", "[", "]"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Den", "[", 
        RowBox[{"a_", ",", "b_"}], "]"}], "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"a", "-", "b"}], ")"}]}]}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{"U", "\[Rule]", 
      RowBox[{
       RowBox[{"2", "MT2"}], "-", "S", "-", "T"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.500121033903965*^9, 3.500121114625811*^9}, {
   3.5001211824541607`*^9, 3.5001212364853497`*^9}, 3.500121270669372*^9, {
   3.5001215329435596`*^9, 3.5001215499458303`*^9}, {3.500123112825931*^9, 
   3.500123116191039*^9}, {3.5001253466558237`*^9, 3.500125350665881*^9}, 
   3.503388979575439*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"3", " ", 
      SuperscriptBox["S", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"MT2", "-", "T"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}], "2"]}]], 
    RowBox[{"32", " ", "\[Pi]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"27", " ", "Alfas", " ", 
        SuperscriptBox["Linv", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"MT2", "-", "T"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"MT2", "-", "S", "-", "T"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", "CG", " ", 
           SuperscriptBox["Linv", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"MT2", "-", "T"}], ")"}], "2"], " ", 
           SuperscriptBox["CG", "\[Conjugate]"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}], "2"]}], "+", 
          
          RowBox[{"GS", " ", "MT2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", "MT2"}], "+", "S", "+", 
              RowBox[{"2", " ", "T"}]}], ")"}], "2"], " ", 
           RowBox[{"Re", "(", "CG", ")"}]}]}], ")"}], " ", 
        SuperscriptBox["S", "2"]}], "+", 
       RowBox[{"4", " ", "Alfas2", " ", "\[Pi]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"9", " ", 
           SuperscriptBox["MT2", "2"]}], "-", 
          RowBox[{"9", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", 
             RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["S", "2"]}], "+", 
          RowBox[{"9", " ", 
           SuperscriptBox["T", "2"]}], "+", 
          RowBox[{"9", " ", "S", " ", "T"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["MT2", "4"]}], "-", 
          RowBox[{"8", " ", "T", " ", 
           SuperscriptBox["MT2", "3"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["S", "2"]}], "+", 
             RowBox[{"4", " ", "T", " ", "S"}], "+", 
             RowBox[{"12", " ", 
              SuperscriptBox["T", "2"]}]}], ")"}], " ", 
           SuperscriptBox["MT2", "2"]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["S", "3"], "+", 
             RowBox[{"2", " ", "T", " ", 
              SuperscriptBox["S", "2"]}], "+", 
             RowBox[{"8", " ", 
              SuperscriptBox["T", "2"], " ", "S"}], "+", 
             RowBox[{"8", " ", 
              SuperscriptBox["T", "3"]}]}], ")"}], " ", "MT2"}], "+", 
          RowBox[{"T", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", "T"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["S", "2"], "+", 
             RowBox[{"2", " ", "T", " ", "S"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["T", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}]}],
   TraditionalForm]], "Output",
 CellChangeTimes->{
  3.500121036185227*^9, 3.500121128547367*^9, 3.500121203492289*^9, {
   3.500121256618002*^9, 3.5001212748748693`*^9}, {3.500121542945138*^9, 
   3.500121555852314*^9}, 3.50012423264614*^9, 3.5001252104076347`*^9, 
   3.5001255716834993`*^9, 3.5001849487019444`*^9, 3.500185550528851*^9, 
   3.500185883191223*^9, 3.500186914156605*^9, 3.5007207642325373`*^9, 
   3.501237426507968*^9, 3.5012494772640543`*^9, 3.501399516736802*^9, 
   3.503388735100582*^9, 3.5033887928786716`*^9, 3.50338898522186*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"Mgg5G", ",", "Linv", ",", "2"}], "]"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Alfas", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"gS", "^", "2"}], "/", 
            RowBox[{"(", 
             RowBox[{"4", "\[Pi]"}], ")"}]}], ")"}]}], ",", 
         RowBox[{"GS", "\[Rule]", "gS"}]}], "}"}]}], "]"}], "/", "256"}], "*",
     "4"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], "MT2"}], "+", "S"}], "\[Rule]", 
      RowBox[{
       RowBox[{"-", "U"}], "-", "T"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "S"}], "-", "T"}], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], "MT2"}], "+", "U"}]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.50012203175807*^9, 3.500122085944367*^9}, 
   3.5001231183600893`*^9, {3.500125033132867*^9, 3.500125044530876*^9}, {
   3.5001251127394114`*^9, 3.5001251219076443`*^9}, 3.500125355223119*^9, 
   3.500125584230616*^9, {3.500185804733983*^9, 3.500185870357251*^9}, {
   3.500185961569396*^9, 3.500185997410247*^9}, {3.500186164189497*^9, 
   3.5001861644725027`*^9}, {3.5007207767060757`*^9, 
   3.5007207919195433`*^9}, {3.500720959484796*^9, 3.500721004358191*^9}, {
   3.501237438050063*^9, 3.5012374430075827`*^9}, {3.501237521809498*^9, 
   3.501237527829372*^9}, {3.5033890963305807`*^9, 3.503389100059205*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{"9", " ", 
     SuperscriptBox["gS", "3"], " ", "MT2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"T", "-", "U"}], ")"}], "2"], " ", 
     RowBox[{"Re", "(", "CG", ")"}]}], 
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{"MT2", "-", "T"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"U", "-", "MT2"}], ")"}]}]]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.500122086278297*^9, 3.500125008672204*^9, 3.5001250478116302`*^9, {
   3.500125106366685*^9, 3.500125113515643*^9}, 3.5001252130924463`*^9, {
   3.500125581322969*^9, 3.500125584601881*^9}, 3.500184948920966*^9, 
   3.500185552032819*^9, 3.50018580710303*^9, {3.5001858520447702`*^9, 
   3.500185888307157*^9}, {3.500185962513139*^9, 3.500185998047577*^9}, 
   3.500186165152343*^9, 3.50018691604774*^9, {3.500720778083675*^9, 
   3.500720792477729*^9}, 3.500721006661276*^9, {3.501237426769576*^9, 
   3.501237444717305*^9}, 3.501237528876062*^9, 3.501249489952922*^9, 
   3.501399516920298*^9, 3.5033887508779173`*^9, 3.503388795308276*^9, 
   3.503388990026944*^9, 3.503389101272532*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res4", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"Mgg5G", ",", "Linv", ",", "4"}], "]"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Alfas", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"gS", "^", "2"}], "/", 
            RowBox[{"(", 
             RowBox[{"4", "\[Pi]"}], ")"}]}], ")"}]}], ",", 
         RowBox[{"GS", "\[Rule]", "gS"}]}], "}"}]}], "]"}], "/", "256"}], "*",
     "4"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], "MT2"}], "+", "S"}], "\[Rule]", 
      RowBox[{
       RowBox[{"-", "U"}], "-", "T"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "S"}], "-", "T"}], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], "MT2"}], "+", "U"}]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{
  3.503388760496441*^9, {3.503389103914072*^9, 3.503389106612323*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["27", "4"]}], " ", "CG", " ", 
   SuperscriptBox["gS", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"MT2", "-", "T"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"U", "-", "MT2"}], ")"}], " ", 
   SuperscriptBox["CG", "\[Conjugate]"]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.5033887610279617`*^9, 3.503388798100388*^9, 
  3.503388993497251*^9, 3.503389107161573*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res0", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"Mgg5G", ",", "Linv", ",", "0"}], "]"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Alfas", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"gS", "^", "2"}], "/", 
            RowBox[{"(", 
             RowBox[{"4", "\[Pi]"}], ")"}]}], ")"}]}], ",", 
         RowBox[{"GS", "\[Rule]", "gS"}]}], "}"}]}], "]"}], "/", "256"}], "*",
     "4"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], "MT2"}], "+", "S"}], "\[Rule]", 
      RowBox[{
       RowBox[{"-", "U"}], "-", "T"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "S"}], "-", "T"}], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], "MT2"}], "+", "U"}]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.503389133505823*^9, 3.5033891361296177`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"3", " ", 
      SuperscriptBox["S", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"MT2", "-", "T"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}], "2"]}]], 
    RowBox[{"2", " ", "Alfas2", " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"18", " ", 
        SuperscriptBox["MT2", "6"]}], "-", 
       RowBox[{"18", " ", 
        RowBox[{"(", 
         RowBox[{"S", "+", 
          RowBox[{"6", " ", "T"}]}], ")"}], " ", 
        SuperscriptBox["MT2", "5"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"35", " ", 
           SuperscriptBox["S", "2"]}], "+", 
          RowBox[{"126", " ", "T", " ", "S"}], "+", 
          RowBox[{"270", " ", 
           SuperscriptBox["T", "2"]}]}], ")"}], " ", 
        SuperscriptBox["MT2", "4"]}], "-", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"9", " ", 
           SuperscriptBox["S", "3"]}], "+", 
          RowBox[{"35", " ", "T", " ", 
           SuperscriptBox["S", "2"]}], "+", 
          RowBox[{"81", " ", 
           SuperscriptBox["T", "2"], " ", "S"}], "+", 
          RowBox[{"90", " ", 
           SuperscriptBox["T", "3"]}]}], ")"}], " ", 
        SuperscriptBox["MT2", "3"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"21", " ", 
           SuperscriptBox["S", "4"]}], "+", 
          RowBox[{"88", " ", "T", " ", 
           SuperscriptBox["S", "3"]}], "+", 
          RowBox[{"246", " ", 
           SuperscriptBox["T", "2"], " ", 
           SuperscriptBox["S", "2"]}], "+", 
          RowBox[{"396", " ", 
           SuperscriptBox["T", "3"], " ", "S"}], "+", 
          RowBox[{"270", " ", 
           SuperscriptBox["T", "4"]}]}], ")"}], " ", 
        SuperscriptBox["MT2", "2"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["S", "5"]}], "+", 
          RowBox[{"13", " ", "T", " ", 
           SuperscriptBox["S", "4"]}], "+", 
          RowBox[{"52", " ", 
           SuperscriptBox["T", "2"], " ", 
           SuperscriptBox["S", "3"]}], "+", 
          RowBox[{"106", " ", 
           SuperscriptBox["T", "3"], " ", 
           SuperscriptBox["S", "2"]}], "+", 
          RowBox[{"117", " ", 
           SuperscriptBox["T", "4"], " ", "S"}], "+", 
          RowBox[{"54", " ", 
           SuperscriptBox["T", "5"]}]}], ")"}], " ", "MT2"}], "+", 
       RowBox[{"T", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["S", "5"]}], "+", 
          RowBox[{"21", " ", "T", " ", 
           SuperscriptBox["S", "4"]}], "+", 
          RowBox[{"52", " ", 
           SuperscriptBox["T", "2"], " ", 
           SuperscriptBox["S", "3"]}], "+", 
          RowBox[{"71", " ", 
           SuperscriptBox["T", "3"], " ", 
           SuperscriptBox["S", "2"]}], "+", 
          RowBox[{"54", " ", 
           SuperscriptBox["T", "4"], " ", "S"}], "+", 
          RowBox[{"18", " ", 
           SuperscriptBox["T", "5"]}]}], ")"}]}]}], ")"}]}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.503389136514138*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res02", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"res0", "/.", 
        RowBox[{"{", 
         RowBox[{"U", "\[Rule]", 
          RowBox[{
           RowBox[{"2", "MT2"}], "-", "S", "-", "T"}]}], "}"}]}], "/.", 
       RowBox[{"{", 
        RowBox[{"T", "\[Rule]", 
         RowBox[{"MT2", "-", 
          RowBox[{
           RowBox[{"S", "/", "2"}], 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"\[Beta]", " ", 
              RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ")"}]}]}]}], "}"}]}],
       ",", 
      RowBox[{"{", 
       RowBox[{"\[Beta]", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.503389198191732*^9, 3.503389337685768*^9}, {
  3.5033893958634043`*^9, 3.503389400878978*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"Alfas2", " ", 
    SuperscriptBox["\[Pi]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"7", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "32"}], " ", 
          SuperscriptBox["MT2", "2"]}], "+", 
         RowBox[{"8", " ", "S", " ", "MT2"}], "+", 
         SuperscriptBox["S", "2"]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"736", " ", 
          SuperscriptBox["MT2", "2"]}], "-", 
         RowBox[{"128", " ", "S", " ", "MT2"}], "-", 
         RowBox[{"23", " ", 
          SuperscriptBox["S", "2"]}]}], ")"}], " ", 
       SuperscriptBox["\[Beta]", "2"], " ", 
       RowBox[{
        SuperscriptBox["cos", "2"], "(", "\[Theta]", ")"}]}]}], ")"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["S", "2"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.503389274053987*^9, {3.503389306439292*^9, 3.503389322115734*^9}, 
   3.503389401803505*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res22", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"res2", "/.", 
        RowBox[{"{", 
         RowBox[{"U", "\[Rule]", 
          RowBox[{
           RowBox[{"2", "MT2"}], "-", "S", "-", "T"}]}], "}"}]}], "/.", 
       RowBox[{"{", 
        RowBox[{"T", "\[Rule]", 
         RowBox[{"MT2", "-", 
          RowBox[{
           RowBox[{"S", "/", "2"}], 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"\[Beta]", " ", 
              RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ")"}]}]}]}], "}"}]}],
       ",", 
      RowBox[{"{", 
       RowBox[{"\[Beta]", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.50338934844617*^9, 3.503389351498057*^9}, {
  3.5033894085701942`*^9, 3.5033894151400414`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["9", "2"], " ", 
   SuperscriptBox["gS", "3"], " ", "MT2", " ", 
   SuperscriptBox["\[Beta]", "2"], " ", 
   RowBox[{
    SuperscriptBox["cos", "2"], "(", "\[Theta]", ")"}], " ", 
   RowBox[{"Re", "(", "CG", ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.503389351876484*^9, 3.5033894157919207`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res42", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"res4", "/.", 
        RowBox[{"{", 
         RowBox[{"U", "\[Rule]", 
          RowBox[{
           RowBox[{"2", "MT2"}], "-", "S", "-", "T"}]}], "}"}]}], "/.", 
       RowBox[{"{", 
        RowBox[{"T", "\[Rule]", 
         RowBox[{"MT2", "-", 
          RowBox[{
           RowBox[{"S", "/", "2"}], 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"\[Beta]", " ", 
              RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ")"}]}]}]}], "}"}]}],
       ",", 
      RowBox[{"{", 
       RowBox[{"\[Beta]", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.503389360430931*^9, 3.503389362812591*^9}, {
  3.5033915499944487`*^9, 3.503391553861639*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["27", "32"]}], " ", "CG", " ", 
   SuperscriptBox["gS", "2"], " ", 
   SuperscriptBox["S", "2"], " ", 
   SuperscriptBox["CG", "\[Conjugate]"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"cos", "(", 
       RowBox[{"2", " ", "\[Theta]"}], ")"}], " ", 
      SuperscriptBox["\[Beta]", "2"]}], "+", 
     SuperscriptBox["\[Beta]", "2"], "-", "2"}], ")"}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.5033893637103643`*^9, 3.5033915547009697`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["gg->gg", "Subtitle",
 CellChangeTimes->{{3.4778117833757*^9, 3.4778117853882*^9}, {
  3.5002736899442463`*^9, 3.500273690293407*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.448968342513181*^9, 3.448968344880295*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\</home/degrande/eta/FeynProg/FeynArts-3.5\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "FeynArts`"}]}], "Input",
 CellChangeTimes->{3.4777456682883*^9, 3.47843887392115*^9, 
  3.499668009622912*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478438874714395*^9, 3.478439311157875*^9, 3.479117501605381*^9, 
   3.479122890293128*^9, 3.479127315286193*^9, 3.479547739644739*^9, 
   3.4996680105546*^9, 3.4996681813378477`*^9, 3.500119770747581*^9, 
   3.500184813621686*^9, 3.500186820640222*^9, 3.500273697449279*^9, 
   3.500273961063395*^9, 3.500274611069228*^9}],

Cell[BoxData[
 FormBox["\<\"FeynArts 3.5\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478438874714395*^9, 3.478439311157875*^9, 3.479117501605381*^9, 
   3.479122890293128*^9, 3.479127315286193*^9, 3.479547739644739*^9, 
   3.4996680105546*^9, 3.4996681813378477`*^9, 3.500119770747581*^9, 
   3.500184813621686*^9, 3.500186820640222*^9, 3.500273697449279*^9, 
   3.500273961063395*^9, 3.5002746110927563`*^9}],

Cell[BoxData[
 FormBox["\<\"by Hagen Eck, Sepp Kueblbeck, and Thomas Hahn\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478438874714395*^9, 3.478439311157875*^9, 3.479117501605381*^9, 
   3.479122890293128*^9, 3.479127315286193*^9, 3.479547739644739*^9, 
   3.4996680105546*^9, 3.4996681813378477`*^9, 3.500119770747581*^9, 
   3.500184813621686*^9, 3.500186820640222*^9, 3.500273697449279*^9, 
   3.500273961063395*^9, 3.500274611107834*^9}],

Cell[BoxData[
 FormBox["\<\"last revised 16 Apr 10\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478438874714395*^9, 3.478439311157875*^9, 3.479117501605381*^9, 
   3.479122890293128*^9, 3.479127315286193*^9, 3.479547739644739*^9, 
   3.4996680105546*^9, 3.4996681813378477`*^9, 3.500119770747581*^9, 
   3.500184813621686*^9, 3.500186820640222*^9, 3.500273697449279*^9, 
   3.500273961063395*^9, 3.500274611122332*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"topo", " ", "=", " ", 
   RowBox[{"CreateTopologies", "[", 
    RowBox[{"0", ",", 
     RowBox[{"2", "\[Rule]", "2"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.47548813810296*^9, 3.475488972088063*^9, {3.4777456120408*^9, 
   3.4777456332583*^9}, 3.4778098132447*^9, 3.4778110152581997`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Paint", "[", "topo", "]"}]], "Input",
 CellChangeTimes->{{3.4777456818157997`*^9, 3.4777456889958*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456900683002`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 2, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456901158*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 3, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456901233*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 4, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456902233*^9}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-9.094947017729282*^-12, 15.000000000003638`}, {
        9.999999999983629, 10.000000000007276`}}], 
       LineBox[{{-9.094947017729282*^-12, 4.999999999996362}, {
        9.999999999985448, 9.999999999989086}}], 
       LineBox[{{20.000000000009095`, 15.000000000003638`}, {
        10.000000000009095`, 10.000000000003638`}}], 
       LineBox[{{20., 5.}, {10., 10.}}], 
       {PointSize[0.04], PointBox[{10., 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 44}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], LineBox[{{5.999999999990206, 10.}, {13.999999999982222`, 
        10.}}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T2\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{6.139089236967266*^-12, 15.}, {10.000000000002046`, 
        14.000000000003638`}}], 
       LineBox[{{-7.503331289626658*^-12, 5.000000000003638}, {
        9.999999999988404, 6.}}], 
       LineBox[{{20.000000000002956`, 15.}, {10.000000000002956`, 14.}}], 
       LineBox[{{19.999999999997726`, 4.999999999996362}, {9.999999999997726, 
        5.999999999996362}}], 
       LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T3\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{6.139089236967266*^-12, 15.}, {10.000000000002046`, 
        14.000000000003638`}}], 
       LineBox[{{-7.503331289626658*^-12, 5.000000000003638}, {
        9.999999999988404, 6.}}], 
       LineBox[{{20.00000000000182, 15.}, {10., 6.}}], 
       LineBox[{{20.00000000000182, 5.}, {10., 14.}}], 
       LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T4\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 22}, {0, 0}, {22, 22}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"2\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {28.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[RightArrow]\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {33., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"2\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {37.5, 69.96}, {0, 0}]},
   AspectRatio->1.0999999999999999`,
   PlotRange->{{0, 66}, {0, 72.6}}], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456905458*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"FeynArtsGraphics", "(", 
    RowBox[{"2", "\[Rule]", "2"}], ")"}], "\[InvisibleApplication]", 
   RowBox[{"(", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T2\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T2", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T3\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T3", "]"],
           Editable->False],
          TraditionalForm]},
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T4\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T4", "]"],
           Editable->False],
          TraditionalForm], "Null", "Null"},
        {"Null", "Null", "Null"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.4777456905908003`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"INTopogg", " ", "=", " ", 
   RowBox[{"InsertFields", "[", 
    RowBox[{"topo", ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"V", "[", "5", "]"}], ",", 
        RowBox[{"V", "[", "5", "]"}]}], "}"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"V", "[", "5", "]"}], ",", 
        RowBox[{"V", "[", "5", "]"}]}], "}"}]}], ",", 
     RowBox[{"Model", "\[Rule]", "\"\<SMQCD\>\""}]}], "]"}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.500273709507674*^9, 3.5002737549383707`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.500273963410111*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
    "\[InvisibleSpace]", "\<\"generic\"\>", 
    "\[InvisibleSpace]", "\<\" model file \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/Lorentz.gen\"\>"}],
   
   SequenceForm[
   "", "loading ", "generic", " model file ", 
    "/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/Lorentz.gen"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.500273963447311*^9}],

Cell[BoxData[
 FormBox["\<\"> $SVMixing is OFF\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.500273963471134*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"generic model \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", "\<\"Lorentz\"\>", "}"}], 
    "\[InvisibleSpace]", "\<\" initialized\"\>"}],
   SequenceForm["generic model ", {"Lorentz"}, " initialized"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.500273963489868*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.500273963508074*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
    "\[InvisibleSpace]", "\<\"classes\"\>", 
    "\[InvisibleSpace]", "\<\" model file \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/SMQCD.mod\"\>"}],
   SequenceForm[
   "", "loading ", "classes", " model file ", 
    "/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/SMQCD.mod"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.500273963526723*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
    "\[InvisibleSpace]", "\<\"classes\"\>", 
    "\[InvisibleSpace]", "\<\" model file \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/SM.mod\"\>"}],
   SequenceForm[
   "  ", "loading ", "classes", " model file ", 
    "/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/SM.mod"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.5002739635450277`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "49", 
    "\[InvisibleSpace]", "\<\" particles (incl. antiparticles) in \"\>", 
    "\[InvisibleSpace]", "18", "\[InvisibleSpace]", "\<\" classes\"\>"}],
   SequenceForm[
   "> ", 49, " particles (incl. antiparticles) in ", 18, " classes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.5002739635627623`*^9}],

Cell[BoxData[
 FormBox["\<\"> $CounterTerms are ON\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.50027396373092*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "93", 
    "\[InvisibleSpace]", "\<\" vertices\"\>"}],
   SequenceForm["> ", 93, " vertices"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.500273964000469*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "120", 
    "\[InvisibleSpace]", "\<\" counter terms of order 1\"\>"}],
   SequenceForm["> ", 120, " counter terms of order 1"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.500273964015028*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "6", 
    "\[InvisibleSpace]", "\<\" counter terms of order 2\"\>"}],
   SequenceForm["> ", 6, " counter terms of order 2"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.500273964028825*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"classes model \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", "\<\"SMQCD\"\>", "}"}], 
    "\[InvisibleSpace]", "\<\" initialized\"\>"}],
   SequenceForm["classes model ", {"SMQCD"}, " initialized"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.500273964043117*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.500273964058158*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"Generic", ",", "Classes"}], "}"}]}],
   SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.500273964073674*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.500273964089271*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
   SequenceForm["> Top. ", 2, ": ", "1 Generic, 1 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.500273964104808*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
   SequenceForm["> Top. ", 3, ": ", "1 Generic, 1 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.500273964120309*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
   SequenceForm["> Top. ", 4, ": ", "1 Generic, 1 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.5002739641357822`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"in total: \"\>", 
    "\[InvisibleSpace]", "\<\"4 Generic, 4 Classes insertions\"\>"}],
   SequenceForm["in total: ", "4 Generic, 4 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.500273756379764*^9, 3.5002739641513767`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"INTopogg", " ", "=", " ", 
   RowBox[{"InsertFields", "[", 
    RowBox[{"topo", ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"V", "[", "4", "]"}], ",", 
        RowBox[{"V", "[", "4", "]"}]}], "}"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"V", "[", "4", "]"}], ",", 
        RowBox[{"V", "[", "4", "]"}]}], "}"}]}], ",", 
     RowBox[{"GenericModel", "\[Rule]", "\"\<TopEffTh_FA/TopEffTh_FA\>\""}], 
     ",", 
     RowBox[{"Model", "\[Rule]", "\"\<TopEffTh_FA/TopEffTh_FA\>\""}], ",", 
     RowBox[{"ExcludeParticles", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"V", "[", "1", "]"}], ",", 
        RowBox[{"V", "[", "2", "]"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.446963657162187*^9, {3.475488153382761*^9, 3.47548819550466*^9}, {
   3.475488277812788*^9, 3.47548833038444*^9}, {3.475488827421314*^9, 
   3.475488830123555*^9}, {3.4777458116422997`*^9, 3.4777459014372997`*^9}, {
   3.4777462405453*^9, 3.4777462574853*^9}, {3.4777462970928*^9, 
   3.4777463288428*^9}, {3.4777464988353*^9, 3.4777465257553*^9}, {
   3.4778060791882*^9, 3.4778060871157*^9}, 3.4778061256857*^9, {
   3.4778062251731997`*^9, 3.4778062269357*^9}, {3.4996680230902777`*^9, 
   3.4996680967055798`*^9}, 3.500185283170471*^9, 3.500274623084931*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500274625635035*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
    "\[InvisibleSpace]", "\<\"generic\"\>", 
    "\[InvisibleSpace]", "\<\" model file \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.gen\"\>"}],
   SequenceForm[
   "", "loading ", "generic", " model file ", 
    "/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.gen"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500274625782546*^9}],

Cell[BoxData[
 FormBox["\<\"> $SVMixing is OFF\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500274625797681*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"generic model \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", "\<\"TopEffTh_FA/TopEffTh_FA\"\>", "}"}], 
    "\[InvisibleSpace]", "\<\" initialized\"\>"}],
   SequenceForm[
   "generic model ", {"TopEffTh_FA/TopEffTh_FA"}, " initialized"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500274625809093*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.50027462582621*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
    "\[InvisibleSpace]", "\<\"classes\"\>", 
    "\[InvisibleSpace]", "\<\" model file \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.mod\"\>"}],
   SequenceForm[
   "", "loading ", "classes", " model file ", 
    "/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.mod"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500274625841065*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "51", 
    "\[InvisibleSpace]", "\<\" particles (incl. antiparticles) in \"\>", 
    "\[InvisibleSpace]", "30", "\[InvisibleSpace]", "\<\" classes\"\>"}],
   SequenceForm[
   "> ", 51, " particles (incl. antiparticles) in ", 30, " classes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.5002746258549633`*^9}],

Cell[BoxData[
 FormBox["\<\"> $CounterTerms are ON\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500274626412168*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "142", 
    "\[InvisibleSpace]", "\<\" vertices\"\>"}],
   SequenceForm["> ", 142, " vertices"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.5002746266019993`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"classes model \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", "\<\"TopEffTh_FA/TopEffTh_FA\"\>", "}"}], 
    "\[InvisibleSpace]", "\<\" initialized\"\>"}],
   SequenceForm[
   "classes model ", {"TopEffTh_FA/TopEffTh_FA"}, " initialized"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.50027462673534*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500274626861124*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Excluding \"\>", "\[InvisibleSpace]", "0", 
    "\[InvisibleSpace]", "\<\" Generic, \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" Classes, and \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" Particles fields\"\>"}],
   SequenceForm[
   "Excluding ", 0, " Generic, ", 2, " Classes, and ", 2, 
    " Particles fields"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500274626990119*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500274627123068*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"Generic", ",", "Classes"}], "}"}]}],
   SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500274627446045*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500274627604376*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"2 Generic, 2 Classes insertions\"\>"}],
   SequenceForm["> Top. ", 2, ": ", "2 Generic, 2 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500274627613366*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"2 Generic, 2 Classes insertions\"\>"}],
   SequenceForm["> Top. ", 3, ": ", "2 Generic, 2 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500274627622312*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"2 Generic, 2 Classes insertions\"\>"}],
   SequenceForm["> Top. ", 4, ": ", "2 Generic, 2 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500274627630674*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500274627777122*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Restoring \"\>", "\[InvisibleSpace]", "0", 
    "\[InvisibleSpace]", "\<\" Generic, \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" Classes, and \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" Particles fields\"\>"}],
   SequenceForm[
   "Restoring ", 0, " Generic, ", 2, " Classes, and ", 2, 
    " Particles fields"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500274627920373*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"in total: \"\>", 
    "\[InvisibleSpace]", "\<\"7 Generic, 7 Classes insertions\"\>"}],
   SequenceForm["in total: ", "7 Generic, 7 Classes insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777460426383*^9, 3.4777463299953003`*^9, 3.4777465282128*^9, 
   3.4778113116556997`*^9, 3.4778115941982*^9, 3.478438884409584*^9, 
   3.47911751340996*^9, 3.47912732465351*^9, 3.479547750863003*^9, {
   3.499668073492424*^9, 3.499668097473929*^9}, 3.4996681823196363`*^9, 
   3.50011977465934*^9, 3.500184815382636*^9, 3.500185285699235*^9, 
   3.5001868230308657`*^9, 3.500274628063608*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Paint", "[", "INTopogg", "]"}]], "Input",
 CellChangeTimes->{{3.4777460520773*^9, 3.4777460643283*^9}, {
  3.4777465398103*^9, 3.4777465399453*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"2 diagrams\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "2 diagrams"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777465408353*^9, 3.4778113180182*^9, 3.4778115983157*^9,
   3.47911751953127*^9, 3.47912291122788*^9, 3.479127333539017*^9, 
  3.499668102426846*^9, 3.49966818593785*^9, 3.500119781743864*^9, 
  3.500184820040362*^9, 3.500185289505512*^9, 3.500186826642324*^9, 
  3.500273765431819*^9, 3.500273968108659*^9, 3.500274630450416*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"4 diagrams\"\>"}],
   SequenceForm["> Top. ", 2, ": ", "4 diagrams"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777465408353*^9, 3.4778113180182*^9, 3.4778115983157*^9,
   3.47911751953127*^9, 3.47912291122788*^9, 3.479127333539017*^9, 
  3.499668102426846*^9, 3.49966818593785*^9, 3.500119781743864*^9, 
  3.500184820040362*^9, 3.500185289505512*^9, 3.500186826642324*^9, 
  3.500273765431819*^9, 3.500273968108659*^9, 3.500274630584344*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"4 diagrams\"\>"}],
   SequenceForm["> Top. ", 3, ": ", "4 diagrams"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777465408353*^9, 3.4778113180182*^9, 3.4778115983157*^9,
   3.47911751953127*^9, 3.47912291122788*^9, 3.479127333539017*^9, 
  3.499668102426846*^9, 3.49966818593785*^9, 3.500119781743864*^9, 
  3.500184820040362*^9, 3.500185289505512*^9, 3.500186826642324*^9, 
  3.500273765431819*^9, 3.500273968108659*^9, 3.500274630600852*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"4 diagrams\"\>"}],
   SequenceForm["> Top. ", 4, ": ", "4 diagrams"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777465408353*^9, 3.4778113180182*^9, 3.4778115983157*^9,
   3.47911751953127*^9, 3.47912291122788*^9, 3.479127333539017*^9, 
  3.499668102426846*^9, 3.49966818593785*^9, 3.500119781743864*^9, 
  3.500184820040362*^9, 3.500185289505512*^9, 3.500186826642324*^9, 
  3.500273765431819*^9, 3.500273968108659*^9, 3.5002746306194687`*^9}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwd1gtYzNkbB/BfN00os7oYJCPJVMpkUauYqaft4jah2lxSWVZqMek2pf0b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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.911618926975065, 11.718437853950132`}, \
{1, 1}], LineBox[CompressedData["
1:eJwt1wtUjFsbB/C3lO6dpDLdmAgVZVKS+GpyQsklSeaQYxRKoqI0Uceo0Dk6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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {5.088381073024935, 6.71843785395013}, \
{-1, 1}], LineBox[CompressedData["
1:eJwt13s8lFkYB/DJdYhSsankssRELklMFo1LGpKktiiV3EWlSHKJDTWhiYpm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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {14.911618926975065`, 13.281562146049868`}, \
{1, -1}], LineBox[CompressedData["
1:eJw91ws01GkfB/CpXEZuk4xGqCGFqCZNGipNJUVZRKVSTRelTBFiFZkSuaUh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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {15.088381073024935`, 8.28156214604987}, \
{-1, -1}], 
       {PointSize[0.04], PointBox[{10., 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 G1 N1\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 44}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwd1gtYzNkbB/BfN00os7oYJCPJVMpkUauYqaft4jah2lxSWVZqMek2pf0b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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.911618926975065, 11.718437853950132`}, \
{1, 1}], LineBox[CompressedData["
1:eJwt1wtUjFsbB/C3lO6dpDLdmAgVZVKS+GpyQsklSeaQYxRKoqI0Uceo0Dk6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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {5.088381073024935, 6.71843785395013}, \
{-1, 1}], LineBox[CompressedData["
1:eJwt13s8lFkYB/DJdYhSsankssRELklMFo1LGpKktiiV3EWlSHKJDTWhiYpm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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {14.911618926975065`, 13.281562146049868`}, \
{1, -1}], LineBox[CompressedData["
1:eJw91ws01GkfB/CpXEZuk4xGqCGFqCZNGipNJUVZRKVSTRelTBFiFZkSuaUh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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {15.088381073024935`, 8.28156214604987}, \
{-1, -1}], 
       {PointSize[0.04], PointBox[{10., 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 C1 N2\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwd1A9YzNkaB/CjJo22GClh+jOl2aLpmlYylOYXLaEYWlfSkkUlZcqqWCGV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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[CompressedData["
1:eJwV1gs01GkfB/AHzUTCuKyUMC6VS6JS2NT8u2iFWkUotQ25tNlFJVRoUMu8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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], LineBox[CompressedData["
1:eJwl1ns41PkeB/AJSSWXUmaRxiK3mWm0s3IyaWJiTimys7OWrpZ2ZIp9dDRH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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], LineBox[CompressedData["
1:eJwd1g00lGkbB/CnTVY2UanonSyyUShhNaV4qK3xNhhCaBKlmj7JahqVNeur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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], 
       {Dashing[{0.030000000000000002`, 0.030000000000000002`}], 
        LineBox[{{5.999999999990206, 10.}, {13.999999999982222`, 10.}}]}, 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"S\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.3048}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T2 G1 N3\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwd1A9YzNkaB/CjJo22GClh+jOl2aLpmlYylOYXLaEYWlfSkkUlZcqqWCGV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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[CompressedData["
1:eJwV1gs01GkfB/AHzUTCuKyUMC6VS6JS2NT8u2iFWkUotQ25tNlFJVRoUMu8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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], LineBox[CompressedData["
1:eJwl1ns41PkeB/AJSSWXUmaRxiK3mWm0s3IyaWJiTimys7OWrpZ2ZIp9dDRH
UxwkbEkod2eU2yq3OF02ucRGUo/DlGvlMolCtlKaRs77u+ePmd/zer6/7+f2
e37P72vmH+IdqEahUHLxI1eKFvmjcyka5GrBpchvGobrwOzfvTO3w9SVtSk2
cKXPbpc0YlnpSy9Yck3zx26YPhIliYEDQjSkyy25lGQe+1493BEcVeQKn9GO
GFRncCk5ikz3IJgyIJDugLWU2YJoOPZ9g04WLA40+T4J1mvivxqFVZyjorPw
rK/NXnsm6tP9jhcF58TkPA6HWUopXQTTRQMzNXCtcoXCDRZ9irk1TtY7DTNN
4dDny+JXrONSPHhLH/yJejUMD/Dt4fddLxhNFqSu1MMuMNWsIPECPKuza84N
9slU5AXDrbwL5zbDPSaL59zJ+n9b3BkwZ7HXFB2WKU626MOVllwfE1jLIMH4
DfKn2ecUGcIl+6kFLXC77bPf18CCo+afcuExU+UQm+T/sKn9KOx15HmHEKYJ
3e7vhGmrh4pjSbyvvj/GhKkVT1W1ZP+00HgVHH+18vUc7JNanLsIbh1j0reS
/rMHwzTgKPtyejJc+/DZuWVkP0uxbgC2KGkSmMM3vRvFa9eirz1hKVth8YHH
TDEcMN50OozMe655phTOGHR9fQWWzx9IGYQrFeuVE7DU1IC71IpL4frNnWGj
/9iPQbds4KhRD1YUmcfKETcnOPluwpaH8FiJW8tm2CO9IU6bhfn3WVZtgGsM
R4+xYN63kmUW8Gx5s+MuWPoyOVgTVjqpVR+GBx0/PSL5mYL5BadgQaR6xn9g
3pjjiYvwGV8r0WnY6PlUfT7MHhOp/whznl4vK4KnJ5ksBuxsfy+sEB7Q/nJR
E7adH4nLI/Gski+/xHziU4zzUsj9rApRJ7w2TFwaTRxkFN8K85t7HoTAoZSk
NQ/gJM1dPD9YdfD+7T64wGJlkBuJv9TO+yM8VcxOXQ97VdhtoSGf/7fDumaw
pK36BwG87ayX/gqYOzEzfB7OM70vWww7chh3n8BLluelLIQL+n0jaWSelrHS
RaTfpuFgMSypay7XhQ0u366/AQ9EprNMSTx2y615+NLnh/Ukv4mir36LNZfS
8NPjLg/Sj7nGiePwqMvry8Gw3LZEVQrfVHJYSTDlZ9fGRzCn7fSOari2sf7x
C/i6qupaL6zRkd7zBh6brFtEscf+jVspk/CX7pAZC1ij7R71GSxM62e7w63v
fCOaYdsZ97xAOP5j36d8+ORXGQ6RsKJO3CWBV12p3pgK+2THJG+H16b7W+eT
eNF7X5nA/CMOzSVwu5lf6Rv0d7eHY1IK87YlJdyDe577nS6E6SFG+gWwRsK+
/GxSn1eNNBFWyUZdz8INfldlx+G04SjpcbjAt1QugbU5v0T9DNdKliui4ZN7
LuV5wxntrRpZsPf1UJYzrFdeJ78DN+QrE+zgEo+DeydhC+OyV8awdKjH3Mqa
vG8NR/RIvQZMVhA85emptoTE4zgxq+C3bzOFi2Gu67UYFVz04VOvDrFxYAjf
Bv1bPL1mRKy20yYFdt6gWUeH2WZjat3w28S1yTw4bcf+OANb7N9RF3EAps6v
T+UTH1+SFg3TAl6F/wIr+QWNRXBozAAlCbZwE/7RDrNOqSfnwh1d57e/g2df
7DSSwe/TBpTU9Xiv91MZF+EsYXQMB2bxboxGwW798vLdsIJ6YvwAXLqRf1gC
y6yr+U6wVnfLcBJs/V14qC6sU1IT+m+YzUlcPIT6M+TUO7/B++uC+67BKUvu
XC+Dc/6xpPg0HL5p+sIVmHZbpucPJz6c7b1M1sfWHOPBA90erukw3SntKQsW
d8nb4kg+48ZOa5iuzL0YBkvDFu5jwBONkRN7Ya6/76wznBPpab6NxL/6UboH
jjXfmepA6mMOsONh0aJTcZbwxK/WfXfgL7IWGzKPWMvXxSpY7V9akbpw6Lmq
Iy7oL69Ctkub1FM+XXaGzGNQn0HWz3ibVPXAE1YVQrJf7mJSYW7HpbgYhrdZ
kfmpKl8dgtt0NjltIvdLPDuvwOxq9iofuJK3wFQBBzSkJhwjz8Nrclwf39nW
xDVJWaSeCEH7N+S7a/v1u3rYa2TBKB9marmKR4lTQibId1uQIpNpf4P4O20Y
HrAq4PhGe/g91y3RCTY9W/vBG6ZFfB1Kgw/5X6oOhTNWdDSrkP/QvvETCfDN
+5TOTviDfk92DtzsHGRbCMv7yy78Bguudv0aDgsuL3eqhFs3O9f/HX4SyC8k
9pg5JjEj+7cudLgCi+NqHCiw8J/qqTI4qiDWagzzEhVF5J2HWY9ilvXDekZ9
4kh4dnjIrg8OoDk5BsPJ1OsbRmGux2pvIdxT/4fnPBzx03IDF9Kvr+lnC8S/
q6PdsQ7O2ZrKFMLP7i1opME1vOc+5+GxhHzVSlhr9dOjcnh3b9VBPVhapm62
GvPgDN0o+su1BrdFcOIPvjRDmPOk9mQNnPSwd8ocnnZtKJwj83TvGnGAfT47
x2/BuaYvyy/BE25gZ9w+AZev9rM6DCsc45iVsMffXj9Igh032G3phpujBcJq
2MDsY/efDPLcGLG9ZF6SRNE8rEnObWzu/89xTO7/AKBMgXU=
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], LineBox[CompressedData["
1:eJwd1g00lGkbB/CnTVY2UanonSyyUShhNaV4qK3xNhhCaBKlmj7JahqVNeur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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], 
       {Dashing[{0.030000000000000002`, 0.030000000000000002`}], 
        LineBox[{{5.999999999990206, 10.}, {13.999999999982222`, 10.}}]}, 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"H\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.3048}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T2 C1 N4\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 22}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwd1A9YzNkaB/CjJo22GClh+jOl2aLpmlYylOYXLaEYWlfSkkUlZcqqWCGV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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[CompressedData["
1:eJwV1gs01GkfB/AHzUTCuKyUMC6VS6JS2NT8u2iFWkUotQ25tNlFJVRoUMu8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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], LineBox[CompressedData["
1:eJwl1ns41PkeB/AJSSWXUmaRxiK3mWm0s3IyaWJiTimys7OWrpZ2ZIp9dDRH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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], LineBox[CompressedData["
1:eJwd1g00lGkbB/CnTVY2UanonSyyUShhNaV4qK3xNhhCaBKlmj7JahqVNeur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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, {-1, -1}],\
 LineBox[CompressedData["
1:eJw9lG1QVFUYx8+KkQzjhyYZ3pfdPYc3hcHtFBRT+DBNCiq60Uy7IzXLLu1F
dBRzSYsSKNJsRlQQiIuYmYgrfKAALRxLAuVFTistTIOpRYysEDIyxlRQsT30
4dyZO3d+c+695zzP8///9fbCbMcyQsjLeC89J0d9eK0B8v/FIHSipfaGQF5x
bH5jAoPcryqP1qjIuVYS8QqDdd+VRtgUZEuwrakQ3zcuWhP5Egc22EsYiBR7
7oJvNRBwBJUcYLDvg+CV/QJ5+1s9q3Yx8G1+CLUq8tvuzsStDEx93r43FOSM
Y4vFsQyKpw8qnCMfL667t0ChKsDzq4Ygmy5unHFTaJrq8R8S8UBmv0lafoFC
TUb2F6dUZF1592gFhc0G8+AOBbms7pPeMgrVygNzCkce84btLKdgD+Db/Qhy
3MGivTUUvm0bjrgp4oD89bj3TAeFMpc4Xa8iWzIt2rsUorMtWkVBNk3megMY
eHP6u40ceVLTvOcZBgnta1r/9cVi/9Jic7YxuPhlwfyAQO6vKgwqYlA2/9KF
WhW5y5PwZimDKqPz6zwF2cV7/d9l4DdzYpWRL61rR2z5DC53dX2+6IvB/Sp+
friewcLZxReFQM4IONweyeBU86Nbqops6Wq8Pkuh52+2KV9BJrdn2q9TCE15
7tDTHNlVnf7DGQrn8i6Vawjy2jvxFR9TSB1NWu8W0UAO+x+4X0pB89G90XoV
2fX93icOURB/arPyFWSTfWrDSQrOPM8lzpGfrf5w+gqu330snhDk2Y6WYS+F
rcWNbUIwnOct6nkSz+eX9JqqIh/v05jTGGyKdMUoCvKspVVnY3DN75dAzpHX
/pE+vp9BnHtJfxTnl1o1iP1puKqbE4LK9aAmM9ZL5ffdV4fOKgqV/9cYcrI4
p3L/6on5H30+gzzfjDUxUwiDPH9541hbnWqQ9W0JCo91KAZZf/T0zU4jN8j+
XLZmvrfo08v+JTt63xkUetnfI5/91FGn6mX/u0NWYr16OR9HlOYK53o5v9rb
aa9riF7ON6t157Rb6OT83ZVHNjSoOqmPsYHOVwsUndTPyd9q/JO5TuqLTQ2b
lhGd1N+ce3dxgxol9blvfEsP51FSv5/ed3TdEFqpb8OwudemaKX+F5xq0rwv
UvqjrjPGVKlGSv/4z5kKVvNI6a+i89tOXxMR0n/O9v2PrEqE9Ge9M+f5f3zh
0r8ttt+fUtVw6W/SbNyTzMOl/7sf6EqGRZjMh5H3hyYKlTCZHysGUtcFkjCZ
L0eZH5xTQ2X+pC8nfS/wUJlPJOTO+IgIkfm1a/d5zw4lRObbzMiS/oJl/v0H
YYABMg==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"V\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T2 G2 N5\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 22}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwd1A9YzNkaB/CjJo22GClh+jOl2aLpmlYylOYXLaEYWlfSkkUlZcqqWCGV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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[CompressedData["
1:eJwV1gs01GkfB/AHzUTCuKyUMC6VS6JS2NT8u2iFWkUotQ25tNlFJVRoUMu8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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], LineBox[CompressedData["
1:eJwl1ns41PkeB/AJSSWXUmaRxiK3mWm0s3IyaWJiTimys7OWrpZ2ZIp9dDRH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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], LineBox[CompressedData["
1:eJwd1g00lGkbB/CnTVY2UanonSyyUShhNaV4qK3xNhhCaBKlmj7JahqVNeur
SdRQa3kXq87YpdAQpViJYUfk+218pS8xWxJFGSnv/37nnDnO79zzXNf/us49
zhjtCfHc9xVFUZl4k7/U1DRe5jT1/5cJTY3syfnItqCpYEECb3oZTQknfban
wzpGHxWjcGjSCt5zmLnW3EkBS2QuRd9Z0lQ/M36VFOY8YL0JhKts08oj4cbj
fswU2OuTg8gJVgazjcvgsU1VOZ+N8Rxn271WmH5U8VMJLN4oLu6DBRW65TyY
45ph/QQOL5hptBS2GqpQ74A1lj4O7zCiKXbYVGQlXLL5iW8yLHw+uDsbzvjh
0iofWGddj+I0fNnf4JMJOT9Qu3M7yXuv1n3aEH3vnbu4Ahbr3Vo7AD9t2LZ8
Bky9eGbeDdve1KzpxbxWTTFaPTBXS9VVCZ+RxJoqYd3w8Ut5cHh8iR2F+r62
IaVZMHv8pMAI5t7pPvc73OjocM+FmCXpyIe98tvP82G9Xnd5HSxzOLgyBzZx
slR7A1fUU21tsJV9eZoB8qQtaJFNwfKX8fP9YcNTxqGG2Mccu9nnM8k+6S0J
9nBwT2XlACxyW2HJhvPfRpjarKIpVkrIEAc+cq1cX0j8YsYACw59VfXiASw6
5dVoA2+I6hzSWY09cd78Mw/OSE9td4fzN88w6Ef/0Odx5+JgscC97Tp8pnXB
YSmsnJK+OkTySq94NsONzowby2CpQ2/OMzjRk1HUiX3Jsyu5g7BZ4UhBIjz1
eXgGOQ+9WHTMGdaoDM0nz2tse+Su+hZ5RsfflcDyxR4lp+GJsr1dKTCPW3ZQ
B5ZRQXcOwyzft6q7Buh/hjJ1JvllJSORsOQbWZseTA1qVvrDZn4+h95hXl+7
6BwPmM3ZH9FKzDcrD4Ingueyy2CrVsdhEawX921HLkzznYxk8NNXcSkSmPla
100b/Tt8muLy4aozipJ9sPJGqsF9mCfQXVAND3mErn8OW2znh2pjvtyEkO+0
kUdidpNlDwtcfK5ugfv1Iv8Jghs9P03Ew7abbw8IYcajLZpNcGygnmUqbGVx
rGSOFfb20m1JNrmvd/LW28AWcTPFmbDm7Z0OfnBoTC91gdzX2PHDkbBh8Cv+
cdi32Ckui3ja+hILnnuiK6QcTnMNjNeFq+Uqp3byvHPLrELk7+sxdn0JC9Qy
PE1g7mz15aOw0O5Bnxj70NHan/eBOD74a9VSmpovlX4eh5kRfO4euHeHY/Jb
Un8FN7CNgXr9ngv7YaqmaKsb7Bwwi98Bc9IbK7r/RVOFLheb78Nm3Mi807Do
6q6gAuL05Nm28IeaC1FpJM+oiXwWfGRpVEwseb7UK290CU2p79avCCP5b/s6
fYS/8LMDguHcKzyVLj6/0lAi8Id9+2yNWbCzac0Lb1h0mbEgCa5IrrffAYs3
3fJ6AvfyMhUBsI7aXx3rkHfAi117BJbbfW30Kxw/cKBeSBzZ9ccomU+zLOg/
ZL63pe83Yf7CwyYNZaTeYOmYCFYzE2v2wHqXk9ZUwIz5ThPTJN+JBKobZs90
c12+Bvc/e3XRE7jue0ExGxbERF1vgN1m1TQfhycexkdnwkv+0uVehnO9OSpv
2CFjpcVNWLlVY/ID8gSqWdMPYSt5aVQMvFzIa34GC3kXfpzGfPFO9h4j5HzL
yagQ+Fj36ZgJ2OxsraIT+5t6E3R0EqZvl36h4f3P7HZ/WEPut39sgT5N3Q27
MTxE6nW+rl0GZz1YOtIHU78cuJGrh/vl23CE9M8N2BFNwwE9r1LvwGWLfSTD
i2mKryosl8AjD1NOlsJ37U1txfBTiuGYCvclXvKOhFvabXWSYcHR/qCj5Dwo
oFUCd1OMiCBS381wazNc1bQu0R+W609ZaqFftbGLpx/ZR8+uQH9YaTiPDiD5
W1rVi/VIjr+jD5J5S91a5iJ/03XqyylY+kXd6jCsLvvMToGrjr/LvA9retj/
XUjyNhkp5mAf/1bqi5ph8aGRJSz4Fs8x4j3pV7ptTwh818B+t7418nskXYiC
qxO7Bh3hQPO6JD7Zp+fPd/bBI8PtYdvh/KSB6HOwcoOZcBFcph2geQ3Ona4x
If053xhsqIM1Js+99oZ1PersHsOd1dd2dWKeEfMs72E4NCe6iw2bpOswVTAd
KN9dhv24FWvXfYapvVw/w8Xk/6DFmilY1LrLN2ER9nnW690YrOMXpPi0kKai
f/SWKWGzgHJVBDzUwf2tE+asr3afDZeoPUuvhbN7K68U6NJU2w/HZhaRPBvH
ag7C0ub3lhmw2LvihCP85YR9mIjU28t0XQ0XJtGMkyTvNqGUCasvZnAPwoL5
2b1+8NVd3zMDSf118ycvwrGCHT9zYal1/UYFXKJlVx8AWzmzFpojjzC8eecB
ss8/G3bGw2wdlT2f9BctSn0Bc2Y6LDtP9i9Zbb0R8w41zIvLIf3GTeVJMLNy
zS8ycj6m8m2BYz1fcwbJvg3+EFHk/mX1JMyxwfcvQtmyBK6I+33CGlY+YF5j
wF+l/NfJD9YYW5unRu6zqlr7J5hVb3OxDfXuPn7JyIazFZTrWTjswr1NlXBV
n8aECTx2Y2WiAh4J1iouRF7++BW71zCvqCzWDE5bNiabIA7Psf6V7JP8fiP9
yO83Xfp/ZOSa4w==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lgs4lGkbxyeHJbW7KtZphnm972uxCn0S8dVtUaImQiTr1Mgh1iGKlEOs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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T2 C1 N6\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 22}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwl1gk41dkbB/CfpYjk2hr7nm5jTSlC95ZqZObfXCMtU5YoO0nKMuiSROst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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.84576923551745, 13.562492355174511`}, \
{0, 1}], LineBox[CompressedData["
1:eJwl1wk8VekbB/CT7OuNyDZcjKVQVxNF6h6iFKJSRMoexbhqhKL/TchIYwkz
o8ZcNFqIq9Fkq65lmFCZLEnUTSqlIku2hvm98/f59Hn7Oud93ud53nPeUzp+
4TsDRSiKuoc/ZOS+XsCPHk3996NKcxUkOm2aYNbU8/azy2jKmGEaEw+7dkZP
my6juT9tFExZwKNKW3SHVWjuaufeY691aSo96ExaE/y2tHPsPMzMTx2uU6Gp
6CTx07Zwe6+neT+sFeHImtShKW5QxV0VxC/Sc24rhSmxn7YcRvykpButETDf
T4TZjetWg6v0adgn+TJnhyrmTZmt1YA5+zwTupHvxqqEm4vJ9X/E9Par0dzO
yOFfZ5iIV3VqTAhPnDe0/QILr5o8cVdHHZOhG6RxvyDSwLsW/iW5MVeH5LPH
aE5Sg6Y6dYJesUk8/SMcSw2aa2FyxdEPTk95P74N3v2wtTER5pXEe1nDB4yL
LS+TfN7cMZaH0/42Km0g9QQ/Sa9HfKuj5iE9sGttto23Os29krlL7SVZ789I
55fIT1ZQNv6C3B/e3+OpRlOXt5q0dcDCaxUtLajvYOxX+pUwff9xuBXs1jxg
nkbm26xSK0d/quMXD+2Fmd+nVZnDTd6TLWok32uJyQ+wH3KDqxbaUX975Fgp
Fz4V95taPPHVjkWu8B8FzEUseHTk6YON2J/0uJIfarRx/fbZ285wrihnQRPm
iRxqOgEHBx8wSdFCvomPaOw3tS/oqYskLCjkiS/H+gYXygUXvsL9Nx4X58Gb
2oZvbYG5A97NTOzf9ZFcfXnYNWfG4Qpsd1yYM6KJ9ewUekxRv9vT9JXDMLfH
yOIaPOndzp+HWeOaPBX0k+srl2+A+e30XaMweGq4kbMf5kzslbwKn1HKq+XB
fJ3mviZ4j8rVrDewcPBBdyMsbTjbaoJ8uWGHHhXAdhWRjodg12dFHn4wWzfG
P5fU1yx/VhweYKirVsJM7dKZ88hHw33e/y653/dlIAPmejh9ex0W3jWLjEc9
WvXP+VyY8VHL4xPq32dYJ2tJ7g9rDgmAuWfbWh8jH9Ymi/sD6J/x2vC0AzBt
Vyx3FK5W9jftRL3CZZ1N6vDbV+xYK5h/O2PvM2WauiiRpfgTnlMfU+tyAbxr
fnhuDHkKo6M1G+AUz1sHd8Aci7L1r+CPzk57qpAnr1heXB/xCr8NcGCpkee5
a/AkbHTFcbIaeVOvol5+gGOleDLeMFNVdQzvI1VRMbagCgsTHluMwRrBz4dH
MLKe1ITE4Pfi9Tv/9wLmj7hbzJJ5tg2i72EfK/W8MKzT8kk3Wha/5zuq77kP
XxS6lW2E6boTGkvJfm2WyIyDWTvmZjbAot5i+xtIPoETXAe4MjRsQgrz+DWq
g6vhqD8Fxo4k/9/1xOcxuiTE657CKByaCS3BuJmj+EMRxna3Tm1bjMs9Cxfd
wsjaZh3RiLg5V7OXl5Hrq0tuWcLvG9WmU0m8SxnTV5B3Qlu9wAUW6H2dogbf
OJljM03ylV3gZ6I/i6y0f04m/bAu2qgB00OLV4iS/FWXWFSh38sH8sPCMU8w
JH4iAk70lqp8iPuYbUnpW+Dgq6dGV8DC5OKQDfC3M262ZzDyak+77MKoEiTT
8m4p8kvZ0E9+v7U1dJMXzLV9otgD/5mYU9uvhOsLB+PYiFOQaLrzGMxUrD5S
CSt4WE0bwhyVfd7WyMPMKnPnhCLe78nXSxvhVYbP857CvNZFGx2Qt4hyaHkf
zCqXu14Hl3c8E52EhWKuTcvRB/f9Mn1MxKOuZnQfh+OM1b/zIpZKO8CHawU+
dr/CjKh1bs3w9dYsh9cwy+mCzR34TXnUjhXI36fcxS8btlCtdw9cSt6XoAvb
4T01020ZMMtIxP8D1tcoHXl1jfjJ24xjcPF25aclxMXndEeR/8ECA41sMv+r
XqEPnBRwKcwPZtQrKrSj/sgjlouVYf62aFF7WE7T/Ggp8hnld7Q0oX8n71oW
mZF+zcoLvGB2hHVZAerlKD+gpUj/1wizxEm/7p3y6UAcSYGUvP8SrC9VfaMW
vt+3xvwOA/dfyDZqgsf70i20YB5LW3QEDp0/MLtEAft/2mZgDeLtbNvULCGP
fv3T1nsezjHd3GMgB08LK8SR3x7HbZLHZPEcrZwxOQMf/7uiZEYG8xXHHeRR
3yWXvV6/E+cV3swifmrflQ9Tc8rLldCflR5Jy+pgoYlzIzl/xu7OpUsjnuBh
SHg/+V66HT0eCXO8fIy1yHsQdcBpCubnT7vZkPegX8IpAfnQ2VlddrCTx30j
Bsm3lsU2gnvyNuf/AAt1DB+9J8/5zUzDCZhVeDA0m7xPuVtiLVBvO0fc3wB+
vfbFWmcFUp+ew2/IN6Umbv1qmFW7jqcKr8ybFxkg8Q6XppB671Rv7PSCuf17
/WbQn76oF3/ly5HvY7dnJMyKWHOjEvkKFUa1ReB4ndyey6iXk/117G/o94TR
s5+jpbFfzdPSAXDS7fRhcynU99BwjobnTy00D0sgn+pPLzfAR7pOnSsSx/Mo
bCjzhDMHkzyOiGG+iucv5LkaMlD39RTF/Qlb3YfhhDn/gODFOL81q5juWD80
SFr3kgjmx4ws7YCZE1snFGF6se8xD9TzUW9t8q1F6AdXTUoI99JDVRkw50PD
UT/UX+IXmJMHj360KuiBJfNsTvfAvNmor63Rvy+fm79fi3ij5kMJZ+Bkbktd
OSy8mZ/xB9nvDSe61yOf9oHCrCa4bZdn3j1iU7Nocr3bZ/Od7chfIOnVlQRn
PTJwuQszbf4ZJufdCvvEOAbqZVlmJXSQ71FqjbqlGDkP4297wNu3a6quJtfj
DzeRc6tUreDVZ8xnXbQ5R86baxGmZYmwj8hu3zLUL/1cLfI51qfnHTMMYHWX
/nkJmNnDlCLvLW+33xUx5M9gbpu0hwUp9bIvKJy3ee/CZ/Ae8i6X6W9dYFPp
3/hYt8AmCX4Nt76wKY7VX1nVMN0Vk2wwy6YETG3ZVnKubKmQLJ1iU+1OqUmz
cPL5z2cDJ9kU3WbjsBnxryzMdPmOY76Bkfp/50hak0LFJzbFXXIonon8hu5n
vAgeZVMM+bdyhWT/7mllKozg/iV1Rf+dyzUGh/Q/Ip77zvEyeF1q4mMZmOfa
XWlMvmsc5xg+zAjZbf0jLOycmfqM+fyAtxfJdy/Vq43uR3zeukxdQ/Tb44/m
p2+wPuP32LhNsJMm4/hi5Md8f2iMrUrOEV7Asgk25XpkOEITrlAqcZRBPenG
Rj/3kvXkf0z9CxZq216Mg2PvnPRd/5lNUd/s05CGndaFvNsFC2KyBhORb99t
KxEJmB9uXDSF+hqL7Du3Y/7oyfdZQcrk34G5K4yxHvNTskwv+qO6MMXJH0N+
ZpOGe2Fr1srQWuTvajd++B05N9kxu5Z9QDxGa+B5eN3b7/bbDyGfcw2BHrBP
07uhVS/RLyV7O2sl8l5L98j3oZ8nr6+nyXfIzF4w+zebYhV1P/Yn+xnPyRKv
Q74uJl8uKf3//x1c3m2KQf6ylP4XvI6Kzw==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {5.1542307644825485`, 4.562492355174517}, \
{0, 1}], LineBox[CompressedData["
1:eJwt1ws4VVkbB/ATJak4xYiSyyAnx+XkVhHtLgaRWyqZkCaDYcKQCM3OGaKL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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {14.84576923551745, 15.437507644825478`}, \
{0, -1}], LineBox[CompressedData["
1:eJwt1ws0lWkXB/AXoTHkcNwKuUxIKcelItIb0pUIqckUlRK5TI2SqENCis64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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {15.154230764482548`, 6.437507644825483}, \
{0, -1}], 
       {Dashing[{0.030000000000000002`, 0.030000000000000002`}], 
        LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}]}, 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"S\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.3048, 9.999999999999995}, {1, 0}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T3 G1 N7\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 0}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwl1gk41dkbB/CfpYjk2hr7nm5jTSlC95ZqZObfXCMtU5YoO0nKMuiSROst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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.84576923551745, 13.562492355174511`}, \
{0, 1}], LineBox[CompressedData["
1:eJwl1wk8VekbB/CT7OuNyDZcjKVQVxNF6h6iFKJSRMoexbhqhKL/TchIYwkz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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {5.1542307644825485`, 4.562492355174517}, \
{0, 1}], LineBox[CompressedData["
1:eJwt1ws4VVkbB/ATJak4xYiSyyAnx+XkVhHtLgaRWyqZkCaDYcKQCM3OGaKL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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {14.84576923551745, 15.437507644825478`}, \
{0, -1}], LineBox[CompressedData["
1:eJwt1ws0lWkXB/AXoTHkcNwKuUxIKcelItIb0pUIqckUlRK5TI2SqENCis64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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {15.154230764482548`, 6.437507644825483}, \
{0, -1}], 
       {Dashing[{0.030000000000000002`, 0.030000000000000002`}], 
        LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}]}, 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"H\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.3048, 9.999999999999995}, {1, 0}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T3 C1 N8\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 0}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwl1gk41dkbB/CfpYjk2hr7nm5jTSlC95ZqZObfXCMtU5YoO0nKMuiSROst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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.84576923551745, 13.562492355174511`}, \
{0, 1}], LineBox[CompressedData["
1:eJwl1wk8VekbB/CT7OuNyDZcjKVQVxNF6h6iFKJSRMoexbhqhKL/TchIYwkz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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {5.1542307644825485`, 4.562492355174517}, \
{0, 1}], LineBox[CompressedData["
1:eJwt1ws4VVkbB/ATJak4xYiSyyAnx+XkVhHtLgaRWyqZkCaDYcKQCM3OGaKL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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {14.84576923551745, 15.437507644825478`}, \
{0, -1}], LineBox[CompressedData["
1:eJwt1ws0lWkXB/AXoTHkcNwKuUxIKcelItIb0pUIqckUlRK5TI2SqENCis64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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {15.154230764482548`, 6.437507644825483}, \
{0, -1}], LineBox[CompressedData["
1:eJxFlA1QlEUYx/eUubIb+1CQFDyO3r17744jPhYts+RxmkHRGA6b4oIS7oxF
cAo/RyQFZzAGnfBr8LrXaMjEhGzyRsiJyepS+QgWwjskTBRz9DqHzBtsSkjv
WqrZduadnd/svu+7z7P//z/eUbaqaBpCKIc/U/O/A0PEP/OTgB7eN7HCgqHe
c9xbSjkXFqDYlzEYSkeuDzLOtmj7J2UYbEmo6wUyl7OmwVGJoSl7OhxTOENR
VOUODIkxi9M1aB6gtVvORb6FYdI3cLOMci7vb0/MxjAcHV/pY5yX7wtVyBgW
SKnrF5IYQPsrXDcmJbjQejdVUThbv1hxu1+C7zryn78f5hz8OimiRYI9V7eO
F9BYQLrqs8N1EpzQ5TeeZ5x3ut7v3CmBJSOnxEzmA7rmn7euWoJvNLL1gMLZ
+O7mjYckeLxRSZoIc773kP9ImwS2l2yddqrl9WTatFck6FhEPT2MszVQ6J+B
oSEt+xwhcYACqk/XL8DwyOTbFQ0KZ7REzs/D8K1+0DoN6QB1HyyL2ozh89lO
9ULC2eO1bKjCcHe8/dUSyrmZdKrfwfDa8feWNShT69pBezGGwNi6sX7G2Vp3
9U4GhpaI9DdUKJ73Z0Zt63wM5ctVZwjhbPM0dQQlyHp6poFSzujy7dYOCeQr
P7W5FM7N9UsvHJEgc2/ntl7GOXnEVLdbgr7azO2hMOda9Y5fqiRwo4H2FPIU
39+38YkaCW7lxMhFlLPVcWvZBxI4+66dcimcn63fNXZGArQ7MZMxzsG2Ez6/
BHF/TQyFw5zLL0ne2bw/q/OzCOH79nepcpdguBgYOEop56DtpM6O4aOvci8p
CufkP5Ze34pBvqj7nTHOuucO9vL+LP4zzMf/6z9aRjWEYPH+UGozrxeL75vm
Jr2uKFj833G06RRjWJxvVK02IaQX5w+Ve08Tohf1FafFZRVTvag/0n1j+LCi
F/3JUiVn9DO96F/yttPVKmQQ/W3btKgmjRhE/4ewfmUxNYj7cfvGeb0GcX81
7aEXGTOI+33lgefjUNgg7n/OnPrIFCILfRzL2/TlGioL/Wgey2hxKrLQl/W3
konvmSz0lz6ScPJBWBb6vLer+2wKMQr9uottWkqNQt8xN1njYcUo9O+97Iv9
gRmFP7akkrXTkUn4R7v919xniEn4K7A6t7eUmoT/mjescn+omIQ/22edVw8w
k/CvNs77swqZhb+jjDWUELPw/5qgv+tNahb5sMdxB5yKWeSHyhU9s5uZRb6M
FjoKJ8NmkT+WvFBBIkkQ+dQzVBVrpwkiv8bYgb2HlASRb5ZHP3P2MM7/5d99
1dRsgb8Benjw4g==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"V\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.0548, 9.999999999999995}, {1, 0}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T3 G2 N9\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 0}, {0, 0}, {22, 22}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"G\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {24., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"G\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {28.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[RightArrow]\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {33., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"G\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {37.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"G\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {42., 69.96}, {0, 0}]},
   AspectRatio->1.0999999999999999`,
   PlotRange->{{0, 66}, {0, 72.6}}], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777465408353*^9, 3.4778113180182*^9, 3.4778115983157*^9,
   3.47911751953127*^9, 3.47912291122788*^9, 3.479127333539017*^9, 
  3.499668102426846*^9, 3.49966818593785*^9, 3.500119781743864*^9, 
  3.500184820040362*^9, 3.500185289505512*^9, 3.500186826642324*^9, 
  3.500273765431819*^9, 3.500273968108659*^9, 3.5002746312511387`*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],

Cell[BoxData[
 FormBox[
  GraphicsBox[{InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwl1gk41dkbB/CfpYjk2hr7nm5jTSlC95ZqZObfXCMtU5YoO0nKMuiSROst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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.84576923551745, 13.562492355174511`}, \
{0, 1}], LineBox[CompressedData["
1:eJwl1wk8VekbB/CT7OuNyDZcjKVQVxNF6h6iFKJSRMoexbhqhKL/TchIYwkz
o8ZcNFqIq9Fkq65lmFCZLEnUTSqlIku2hvm98/f59Hn7Oud93ud53nPeUzp+
4TsDRSiKuoc/ZOS+XsCPHk3996NKcxUkOm2aYNbU8/azy2jKmGEaEw+7dkZP
my6juT9tFExZwKNKW3SHVWjuaufeY691aSo96ExaE/y2tHPsPMzMTx2uU6Gp
6CTx07Zwe6+neT+sFeHImtShKW5QxV0VxC/Sc24rhSmxn7YcRvykpButETDf
T4TZjetWg6v0adgn+TJnhyrmTZmt1YA5+zwTupHvxqqEm4vJ9X/E9Par0dzO
yOFfZ5iIV3VqTAhPnDe0/QILr5o8cVdHHZOhG6RxvyDSwLsW/iW5MVeH5LPH
aE5Sg6Y6dYJesUk8/SMcSw2aa2FyxdEPTk95P74N3v2wtTER5pXEe1nDB4yL
LS+TfN7cMZaH0/42Km0g9QQ/Sa9HfKuj5iE9sGttto23Os29krlL7SVZ789I
55fIT1ZQNv6C3B/e3+OpRlOXt5q0dcDCaxUtLajvYOxX+pUwff9xuBXs1jxg
nkbm26xSK0d/quMXD+2Fmd+nVZnDTd6TLWok32uJyQ+wH3KDqxbaUX975Fgp
Fz4V95taPPHVjkWu8B8FzEUseHTk6YON2J/0uJIfarRx/fbZ285wrihnQRPm
iRxqOgEHBx8wSdFCvomPaOw3tS/oqYskLCjkiS/H+gYXygUXvsL9Nx4X58Gb
2oZvbYG5A97NTOzf9ZFcfXnYNWfG4Qpsd1yYM6KJ9ewUekxRv9vT9JXDMLfH
yOIaPOndzp+HWeOaPBX0k+srl2+A+e30XaMweGq4kbMf5kzslbwKn1HKq+XB
fJ3mviZ4j8rVrDewcPBBdyMsbTjbaoJ8uWGHHhXAdhWRjodg12dFHn4wWzfG
P5fU1yx/VhweYKirVsJM7dKZ88hHw33e/y653/dlIAPmejh9ex0W3jWLjEc9
WvXP+VyY8VHL4xPq32dYJ2tJ7g9rDgmAuWfbWh8jH9Ymi/sD6J/x2vC0AzBt
Vyx3FK5W9jftRL3CZZ1N6vDbV+xYK5h/O2PvM2WauiiRpfgTnlMfU+tyAbxr
fnhuDHkKo6M1G+AUz1sHd8Aci7L1r+CPzk57qpAnr1heXB/xCr8NcGCpkee5
a/AkbHTFcbIaeVOvol5+gGOleDLeMFNVdQzvI1VRMbagCgsTHluMwRrBz4dH
MLKe1ITE4Pfi9Tv/9wLmj7hbzJJ5tg2i72EfK/W8MKzT8kk3Wha/5zuq77kP
XxS6lW2E6boTGkvJfm2WyIyDWTvmZjbAot5i+xtIPoETXAe4MjRsQgrz+DWq
g6vhqD8Fxo4k/9/1xOcxuiTE657CKByaCS3BuJmj+EMRxna3Tm1bjMs9Cxfd
wsjaZh3RiLg5V7OXl5Hrq0tuWcLvG9WmU0m8SxnTV5B3Qlu9wAUW6H2dogbf
OJljM03ylV3gZ6I/i6y0f04m/bAu2qgB00OLV4iS/FWXWFSh38sH8sPCMU8w
JH4iAk70lqp8iPuYbUnpW+Dgq6dGV8DC5OKQDfC3M262ZzDyak+77MKoEiTT
8m4p8kvZ0E9+v7U1dJMXzLV9otgD/5mYU9uvhOsLB+PYiFOQaLrzGMxUrD5S
CSt4WE0bwhyVfd7WyMPMKnPnhCLe78nXSxvhVYbP857CvNZFGx2Qt4hyaHkf
zCqXu14Hl3c8E52EhWKuTcvRB/f9Mn1MxKOuZnQfh+OM1b/zIpZKO8CHawU+
dr/CjKh1bs3w9dYsh9cwy+mCzR34TXnUjhXI36fcxS8btlCtdw9cSt6XoAvb
4T01020ZMMtIxP8D1tcoHXl1jfjJ24xjcPF25aclxMXndEeR/8ECA41sMv+r
XqEPnBRwKcwPZtQrKrSj/sgjlouVYf62aFF7WE7T/Ggp8hnld7Q0oX8n71oW
mZF+zcoLvGB2hHVZAerlKD+gpUj/1wizxEm/7p3y6UAcSYGUvP8SrC9VfaMW
vt+3xvwOA/dfyDZqgsf70i20YB5LW3QEDp0/MLtEAft/2mZgDeLtbNvULCGP
fv3T1nsezjHd3GMgB08LK8SR3x7HbZLHZPEcrZwxOQMf/7uiZEYG8xXHHeRR
3yWXvV6/E+cV3swifmrflQ9Tc8rLldCflR5Jy+pgoYlzIzl/xu7OpUsjnuBh
SHg/+V66HT0eCXO8fIy1yHsQdcBpCubnT7vZkPegX8IpAfnQ2VlddrCTx30j
Bsm3lsU2gnvyNuf/AAt1DB+9J8/5zUzDCZhVeDA0m7xPuVtiLVBvO0fc3wB+
vfbFWmcFUp+ew2/IN6Umbv1qmFW7jqcKr8ybFxkg8Q6XppB671Rv7PSCuf17
/WbQn76oF3/ly5HvY7dnJMyKWHOjEvkKFUa1ReB4ndyey6iXk/117G/o94TR
s5+jpbFfzdPSAXDS7fRhcynU99BwjobnTy00D0sgn+pPLzfAR7pOnSsSx/Mo
bCjzhDMHkzyOiGG+iucv5LkaMlD39RTF/Qlb3YfhhDn/gODFOL81q5juWD80
SFr3kgjmx4ws7YCZE1snFGF6se8xD9TzUW9t8q1F6AdXTUoI99JDVRkw50PD
UT/UX+IXmJMHj360KuiBJfNsTvfAvNmor63Rvy+fm79fi3ij5kMJZ+Bkbktd
OSy8mZ/xB9nvDSe61yOf9oHCrCa4bZdn3j1iU7Nocr3bZ/Od7chfIOnVlQRn
PTJwuQszbf4ZJufdCvvEOAbqZVlmJXSQ71FqjbqlGDkP4297wNu3a6quJtfj
DzeRc6tUreDVZ8xnXbQ5R86baxGmZYmwj8hu3zLUL/1cLfI51qfnHTMMYHWX
/nkJmNnDlCLvLW+33xUx5M9gbpu0hwUp9bIvKJy3ee/CZ/Ae8i6X6W9dYFPp
3/hYt8AmCX4Nt76wKY7VX1nVMN0Vk2wwy6YETG3ZVnKubKmQLJ1iU+1OqUmz
cPL5z2cDJ9kU3WbjsBnxryzMdPmOY76Bkfp/50hak0LFJzbFXXIonon8hu5n
vAgeZVMM+bdyhWT/7mllKozg/iV1Rf+dyzUGh/Q/Ip77zvEyeF1q4mMZmOfa
XWlMvmsc5xg+zAjZbf0jLOycmfqM+fyAtxfJdy/Vq43uR3zeukxdQ/Tb44/m
p2+wPuP32LhNsJMm4/hi5Md8f2iMrUrOEV7Asgk25XpkOEITrlAqcZRBPenG
Rj/3kvXkf0z9CxZq216Mg2PvnPRd/5lNUd/s05CGndaFvNsFC2KyBhORb99t
KxEJmB9uXDSF+hqL7Du3Y/7oyfdZQcrk34G5K4yxHvNTskwv+qO6MMXJH0N+
ZpOGe2Fr1srQWuTvajd++B05N9kxu5Z9QDxGa+B5eN3b7/bbDyGfcw2BHrBP
07uhVS/RLyV7O2sl8l5L98j3oZ8nr6+nyXfIzF4w+zebYhV1P/Yn+xnPyRKv
Q74uJl8uKf3//x1c3m2KQf6ylP4XvI6Kzw==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {5.1542307644825485`, 4.562492355174517}, \
{0, 1}], LineBox[CompressedData["
1:eJwt1ws4VVkbB/ATJak4xYiSyyAnx+XkVhHtLgaRWyqZkCaDYcKQCM3OGaKL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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {14.84576923551745, 15.437507644825478`}, \
{0, -1}], LineBox[CompressedData["
1:eJwt1ws0lWkXB/AXoTHkcNwKuUxIKcelItIb0pUIqckUlRK5TI2SqENCis64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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {15.154230764482548`, 6.437507644825483}, \
{0, -1}], LineBox[CompressedData["
1:eJxFlgs4VekaxzdyGTWNGo5LiL611t5Lipwm1/KaOBmV3DMSKnLpOKQRmxmX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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.0548, 9.999999999999995}, {1, 0}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T3 C1 N10\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 44}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwl1gk41dkbB/CfpYjk2hr7nm5jTSlC95ZqZObfXCMtU5YoO0nKMuiSROst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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.84576923551745, 13.562492355174511`}, \
{0, 1}], LineBox[CompressedData["
1:eJwl1wk8VekbB/CT7OuNyDZcjKVQVxNF6h6iFKJSRMoexbhqhKL/TchIYwkz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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {5.1542307644825485`, 4.562492355174517}, \
{0, 1}], LineBox[CompressedData["
1:eJwt2Hs8lGkbB/BJElKNw+SYU3KckMYhkWHFxCzalShEJElStFkkoXitonIK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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.937558817093933`, 13.081023536561338`}, \
{1, -1}], LineBox[CompressedData["
1:eJwt2Hk8VesaB/CN0jYkc5QiqUyZQnSonQoh6YSkbUiUHIkMudnJQZGEJHZF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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.562441182905612`, 8.08102353656179}, \
{-1, -1}], 
       {Dashing[{0.030000000000000002`, 0.030000000000000002`}], 
        LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}]}, 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"S\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.404800000000002, 9.999999999999995}, \
{1, 0}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T4 G1 N11\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwl1gk41dkbB/CfpYjk2hr7nm5jTSlC95ZqZObfXCMtU5YoO0nKMuiSROst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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.84576923551745, 13.562492355174511`}, \
{0, 1}], LineBox[CompressedData["
1:eJwl1wk8VekbB/CT7OuNyDZcjKVQVxNF6h6iFKJSRMoexbhqhKL/TchIYwkz
o8ZcNFqIq9Fkq65lmFCZLEnUTSqlIku2hvm98/f59Hn7Oud93ud53nPeUzp+
4TsDRSiKuoc/ZOS+XsCPHk3996NKcxUkOm2aYNbU8/azy2jKmGEaEw+7dkZP
my6juT9tFExZwKNKW3SHVWjuaufeY691aSo96ExaE/y2tHPsPMzMTx2uU6Gp
6CTx07Zwe6+neT+sFeHImtShKW5QxV0VxC/Sc24rhSmxn7YcRvykpButETDf
T4TZjetWg6v0adgn+TJnhyrmTZmt1YA5+zwTupHvxqqEm4vJ9X/E9Par0dzO
yOFfZ5iIV3VqTAhPnDe0/QILr5o8cVdHHZOhG6RxvyDSwLsW/iW5MVeH5LPH
aE5Sg6Y6dYJesUk8/SMcSw2aa2FyxdEPTk95P74N3v2wtTER5pXEe1nDB4yL
LS+TfN7cMZaH0/42Km0g9QQ/Sa9HfKuj5iE9sGttto23Os29krlL7SVZ789I
55fIT1ZQNv6C3B/e3+OpRlOXt5q0dcDCaxUtLajvYOxX+pUwff9xuBXs1jxg
nkbm26xSK0d/quMXD+2Fmd+nVZnDTd6TLWok32uJyQ+wH3KDqxbaUX975Fgp
Fz4V95taPPHVjkWu8B8FzEUseHTk6YON2J/0uJIfarRx/fbZ285wrihnQRPm
iRxqOgEHBx8wSdFCvomPaOw3tS/oqYskLCjkiS/H+gYXygUXvsL9Nx4X58Gb
2oZvbYG5A97NTOzf9ZFcfXnYNWfG4Qpsd1yYM6KJ9ewUekxRv9vT9JXDMLfH
yOIaPOndzp+HWeOaPBX0k+srl2+A+e30XaMweGq4kbMf5kzslbwKn1HKq+XB
fJ3mviZ4j8rVrDewcPBBdyMsbTjbaoJ8uWGHHhXAdhWRjodg12dFHn4wWzfG
P5fU1yx/VhweYKirVsJM7dKZ88hHw33e/y653/dlIAPmejh9ex0W3jWLjEc9
WvXP+VyY8VHL4xPq32dYJ2tJ7g9rDgmAuWfbWh8jH9Ymi/sD6J/x2vC0AzBt
Vyx3FK5W9jftRL3CZZ1N6vDbV+xYK5h/O2PvM2WauiiRpfgTnlMfU+tyAbxr
fnhuDHkKo6M1G+AUz1sHd8Aci7L1r+CPzk57qpAnr1heXB/xCr8NcGCpkee5
a/AkbHTFcbIaeVOvol5+gGOleDLeMFNVdQzvI1VRMbagCgsTHluMwRrBz4dH
MLKe1ITE4Pfi9Tv/9wLmj7hbzJJ5tg2i72EfK/W8MKzT8kk3Wha/5zuq77kP
XxS6lW2E6boTGkvJfm2WyIyDWTvmZjbAot5i+xtIPoETXAe4MjRsQgrz+DWq
g6vhqD8Fxo4k/9/1xOcxuiTE657CKByaCS3BuJmj+EMRxna3Tm1bjMs9Cxfd
wsjaZh3RiLg5V7OXl5Hrq0tuWcLvG9WmU0m8SxnTV5B3Qlu9wAUW6H2dogbf
OJljM03ylV3gZ6I/i6y0f04m/bAu2qgB00OLV4iS/FWXWFSh38sH8sPCMU8w
JH4iAk70lqp8iPuYbUnpW+Dgq6dGV8DC5OKQDfC3M262ZzDyak+77MKoEiTT
8m4p8kvZ0E9+v7U1dJMXzLV9otgD/5mYU9uvhOsLB+PYiFOQaLrzGMxUrD5S
CSt4WE0bwhyVfd7WyMPMKnPnhCLe78nXSxvhVYbP857CvNZFGx2Qt4hyaHkf
zCqXu14Hl3c8E52EhWKuTcvRB/f9Mn1MxKOuZnQfh+OM1b/zIpZKO8CHawU+
dr/CjKh1bs3w9dYsh9cwy+mCzR34TXnUjhXI36fcxS8btlCtdw9cSt6XoAvb
4T01020ZMMtIxP8D1tcoHXl1jfjJ24xjcPF25aclxMXndEeR/8ECA41sMv+r
XqEPnBRwKcwPZtQrKrSj/sgjlouVYf62aFF7WE7T/Ggp8hnld7Q0oX8n71oW
mZF+zcoLvGB2hHVZAerlKD+gpUj/1wizxEm/7p3y6UAcSYGUvP8SrC9VfaMW
vt+3xvwOA/dfyDZqgsf70i20YB5LW3QEDp0/MLtEAft/2mZgDeLtbNvULCGP
fv3T1nsezjHd3GMgB08LK8SR3x7HbZLHZPEcrZwxOQMf/7uiZEYG8xXHHeRR
3yWXvV6/E+cV3swifmrflQ9Tc8rLldCflR5Jy+pgoYlzIzl/xu7OpUsjnuBh
SHg/+V66HT0eCXO8fIy1yHsQdcBpCubnT7vZkPegX8IpAfnQ2VlddrCTx30j
Bsm3lsU2gnvyNuf/AAt1DB+9J8/5zUzDCZhVeDA0m7xPuVtiLVBvO0fc3wB+
vfbFWmcFUp+ew2/IN6Umbv1qmFW7jqcKr8ybFxkg8Q6XppB671Rv7PSCuf17
/WbQn76oF3/ly5HvY7dnJMyKWHOjEvkKFUa1ReB4ndyey6iXk/117G/o94TR
s5+jpbFfzdPSAXDS7fRhcynU99BwjobnTy00D0sgn+pPLzfAR7pOnSsSx/Mo
bCjzhDMHkzyOiGG+iucv5LkaMlD39RTF/Qlb3YfhhDn/gODFOL81q5juWD80
SFr3kgjmx4ws7YCZE1snFGF6se8xD9TzUW9t8q1F6AdXTUoI99JDVRkw50PD
UT/UX+IXmJMHj360KuiBJfNsTvfAvNmor63Rvy+fm79fi3ij5kMJZ+Bkbktd
OSy8mZ/xB9nvDSe61yOf9oHCrCa4bZdn3j1iU7Nocr3bZ/Od7chfIOnVlQRn
PTJwuQszbf4ZJufdCvvEOAbqZVlmJXSQ71FqjbqlGDkP4297wNu3a6quJtfj
DzeRc6tUreDVZ8xnXbQ5R86baxGmZYmwj8hu3zLUL/1cLfI51qfnHTMMYHWX
/nkJmNnDlCLvLW+33xUx5M9gbpu0hwUp9bIvKJy3ee/CZ/Ae8i6X6W9dYFPp
3/hYt8AmCX4Nt76wKY7VX1nVMN0Vk2wwy6YETG3ZVnKubKmQLJ1iU+1OqUmz
cPL5z2cDJ9kU3WbjsBnxryzMdPmOY76Bkfp/50hak0LFJzbFXXIonon8hu5n
vAgeZVMM+bdyhWT/7mllKozg/iV1Rf+dyzUGh/Q/Ip77zvEyeF1q4mMZmOfa
XWlMvmsc5xg+zAjZbf0jLOycmfqM+fyAtxfJdy/Vq43uR3zeukxdQ/Tb44/m
p2+wPuP32LhNsJMm4/hi5Md8f2iMrUrOEV7Asgk25XpkOEITrlAqcZRBPenG
Rj/3kvXkf0z9CxZq216Mg2PvnPRd/5lNUd/s05CGndaFvNsFC2KyBhORb99t
KxEJmB9uXDSF+hqL7Du3Y/7oyfdZQcrk34G5K4yxHvNTskwv+qO6MMXJH0N+
ZpOGe2Fr1srQWuTvajd++B05N9kxu5Z9QDxGa+B5eN3b7/bbDyGfcw2BHrBP
07uhVS/RLyV7O2sl8l5L98j3oZ8nr6+nyXfIzF4w+zebYhV1P/Yn+xnPyRKv
Q74uJl8uKf3//x1c3m2KQf6ylP4XvI6Kzw==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {5.1542307644825485`, 4.562492355174517}, \
{0, 1}], LineBox[CompressedData["
1:eJwt2Hs8lGkbB/BJElKNw+SYU3KckMYhkWHFxCzalShEJElStFkkoXitonIK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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.937558817093933`, 13.081023536561338`}, \
{1, -1}], LineBox[CompressedData["
1:eJwt2Hk8VesaB/CN0jYkc5QiqUyZQnSonQoh6YSkbUiUHIkMudnJQZGEJHZF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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.562441182905612`, 8.08102353656179}, \
{-1, -1}], 
       {Dashing[{0.030000000000000002`, 0.030000000000000002`}], 
        LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}]}, 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"H\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.404800000000002, 9.999999999999995}, \
{1, 0}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T4 C1 N12\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwl1gk41dkbB/CfpYjk2hr7nm5jTSlC95ZqZObfXCMtU5YoO0nKMuiSROst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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.84576923551745, 13.562492355174511`}, \
{0, 1}], LineBox[CompressedData["
1:eJwl1wk8VekbB/CT7OuNyDZcjKVQVxNF6h6iFKJSRMoexbhqhKL/TchIYwkz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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {5.1542307644825485`, 4.562492355174517}, \
{0, 1}], LineBox[CompressedData["
1:eJwt2Hs8lGkbB/BJElKNw+SYU3KckMYhkWHFxCzalShEJElStFkkoXitonIK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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.937558817093933`, 13.081023536561338`}, \
{1, -1}], LineBox[CompressedData["
1:eJwt2Hk8VesaB/CN0jYkc5QiqUyZQnSonQoh6YSkbUiUHIkMudnJQZGEJHZF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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.562441182905612`, 8.08102353656179}, \
{-1, -1}], LineBox[CompressedData["
1:eJxFlA1QlEUYx/eUubIb+1CQFDyO3r17744jPhYts+RxmkHRGA6b4oIS7oxF
cAo/RyQFZzAGnfBr8LrXaMjEhGzyRsiJyepS+QgWwjskTBRz9DqHzBtsSkjv
WqrZduadnd/svu+7z7P//z/eUbaqaBpCKIc/U/O/A0PEP/OTgB7eN7HCgqHe
c9xbSjkXFqDYlzEYSkeuDzLOtmj7J2UYbEmo6wUyl7OmwVGJoSl7OhxTOENR
VOUODIkxi9M1aB6gtVvORb6FYdI3cLOMci7vb0/MxjAcHV/pY5yX7wtVyBgW
SKnrF5IYQPsrXDcmJbjQejdVUThbv1hxu1+C7zryn78f5hz8OimiRYI9V7eO
F9BYQLrqs8N1EpzQ5TeeZ5x3ut7v3CmBJSOnxEzmA7rmn7euWoJvNLL1gMLZ
+O7mjYckeLxRSZoIc773kP9ImwS2l2yddqrl9WTatFck6FhEPT2MszVQ6J+B
oSEt+xwhcYACqk/XL8DwyOTbFQ0KZ7REzs/D8K1+0DoN6QB1HyyL2ozh89lO
9ULC2eO1bKjCcHe8/dUSyrmZdKrfwfDa8feWNShT69pBezGGwNi6sX7G2Vp3
9U4GhpaI9DdUKJ73Z0Zt63wM5ctVZwjhbPM0dQQlyHp6poFSzujy7dYOCeQr
P7W5FM7N9UsvHJEgc2/ntl7GOXnEVLdbgr7azO2hMOda9Y5fqiRwo4H2FPIU
39+38YkaCW7lxMhFlLPVcWvZBxI4+66dcimcn63fNXZGArQ7MZMxzsG2Ez6/
BHF/TQyFw5zLL0ne2bw/q/OzCOH79nepcpdguBgYOEop56DtpM6O4aOvci8p
CufkP5Ze34pBvqj7nTHOuucO9vL+LP4zzMf/6z9aRjWEYPH+UGozrxeL75vm
Jr2uKFj833G06RRjWJxvVK02IaQX5w+Ve08Tohf1FafFZRVTvag/0n1j+LCi
F/3JUiVn9DO96F/yttPVKmQQ/W3btKgmjRhE/4ewfmUxNYj7cfvGeb0GcX81
7aEXGTOI+33lgefjUNgg7n/OnPrIFCILfRzL2/TlGioL/Wgey2hxKrLQl/W3
konvmSz0lz6ScPJBWBb6vLer+2wKMQr9uottWkqNQt8xN1njYcUo9O+97Iv9
gRmFP7akkrXTkUn4R7v919xniEn4K7A6t7eUmoT/mjescn+omIQ/22edVw8w
k/CvNs77swqZhb+jjDWUELPw/5qgv+tNahb5sMdxB5yKWeSHyhU9s5uZRb6M
FjoKJ8NmkT+WvFBBIkkQ+dQzVBVrpwkiv8bYgb2HlASRb5ZHP3P2MM7/5d99
1dRsgb8Benjw4g==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"V\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.154800000000002, 9.999999999999995}, \
{1, 0}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T4 G2 N13\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 22}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwl1gk41dkbB/CfpYjk2hr7nm5jTSlC95ZqZObfXCMtU5YoO0nKMuiSROst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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.84576923551745, 13.562492355174511`}, \
{0, 1}], LineBox[CompressedData["
1:eJwl1wk8VekbB/CT7OuNyDZcjKVQVxNF6h6iFKJSRMoexbhqhKL/TchIYwkz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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {5.1542307644825485`, 4.562492355174517}, \
{0, 1}], LineBox[CompressedData["
1:eJwt2Hs8lGkbB/BJElKNw+SYU3KckMYhkWHFxCzalShEJElStFkkoXitonIK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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.937558817093933`, 13.081023536561338`}, \
{1, -1}], LineBox[CompressedData["
1:eJwt2Hk8VesaB/CN0jYkc5QiqUyZQnSonQoh6YSkbUiUHIkMudnJQZGEJHZF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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.562441182905612`, 8.08102353656179}, \
{-1, -1}], LineBox[CompressedData["
1:eJxFlgs4VekaxzdyGTWNGo5LiL611t5Lipwm1/KaOBmV3DMSKnLpOKQRmxmX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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.154800000000002, 9.999999999999995}, \
{1, 0}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T4 C1 N14\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 22}, {0, 0}, {22, 22}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"G\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {24., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"G\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {28.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[RightArrow]\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {33., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"G\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {37.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"G\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {42., 69.96}, {0, 0}]},
   AspectRatio->1.0999999999999999`,
   PlotRange->{{0, 66}, {0, 72.6}}], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777465408353*^9, 3.4778113180182*^9, 3.4778115983157*^9,
   3.47911751953127*^9, 3.47912291122788*^9, 3.479127333539017*^9, 
  3.499668102426846*^9, 3.49966818593785*^9, 3.500119781743864*^9, 
  3.500184820040362*^9, 3.500185289505512*^9, 3.500186826642324*^9, 
  3.500273765431819*^9, 3.500273968108659*^9, 3.500274631707769*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzt3QmYZUV1B/AH0z07izgsMiCb4IaiIiASF8RdCWCMouKwqCwKggpRTOKG
CaCICyQmJFHcUVFU4gIuCYjimj3GJITEbGQiwWgWs9/Ur+45t+9rXne/meme
GYa53zfT7913b9WpU6fO+Z9Tp6qOPvnc01901snnnvGCk/d+0stPPuf0M17w
ir2fePbLy61F2wwG29xY/v1g74HPzWCQ/9Xry/6LL1s/b/289fPWz1s/b/18
N/18v/pnUfM3f/M3zQ477FC/TY64t6T+v7z5wAc+0BxyyCHNgx70oObggw9u
Hv3oRze/8Ru/UYu87bbbGnZ2n3322bY56KCDShGHHnpoE1f5dudit63/79g8
4hGPaO55z3vms83DH/7wZrfddmu22WabZvXq1c2JJ55Y73/rW99ScvPgBz+4
2X///Ztjjz22+du//ds169SKlbUVqlDUAx7wgOYpT3lK8yd/8iczVT2qqJby
ZeNQPpgY8f43143/i+MeXquyNDpIWNL82Z/92RAJl156aW3Z7bffHi1e0i+r
Xtdcc02z9957e2+WjlncrF27tvnhD3/YvXfhhRc2T3rSk8ZleJL967/+65Xs
v//7v++K/vrXv9781m/9Vld0vLe+FI+qfhYmJ/POOuus2k977bVXs8cee9R+
8/mOO+7oirz3ve/d/N7v/V7vvbasYHp3781vfnPzsIc9rPnBD34QLR9uxv/+
7/9WcXvve987YzOSY3/xF3/R7LrrrvXb8zeQft9/93d/d6j8O9e57rSOQ8M3
5uqCyeYjH/lI88IXvrAvBB2Z//RP/9QsWbJkiM0/8RM/UfVPIa8bWr/4i79Y
Bezf/u3fotnDzXn3u9/dPOEJT8hum1WC/ud//qc5//zzm2c+85mDUYK+rnQv
GZPl49A4W93fmpnVbVETzTOe8Yzmt3/7t/O3UdQuj3tUro5tXxym9j//8z/r
WPzmN785K7UT8f9jH/vYKsz3u9/9mn/4h38YxdR1oHAcfo5L4QzVjsFK1o7E
/fmf//mU2mrH2u/8zu/Ub8vi3h/90R8197rXvUay8m1vextB6zpyLr3wnve8
p3nc4x5Xv43SC+tA3jiqYFzyZqh2Fj7myL3yyiubNWvWVAlOKo0EKGPKyi2r
9vlNb3pTpeTHP/5x84UvfKH5v//7v/r9ne98Z3PYYYfFCF5Z61m+fHll+p/+
6Z/2qa+f//u//7v5/Oc/3/zBH/yBehdF0+m8f/3Xf23y+sQnPtHst99+o8R1
HOr/7u/+rjN2N998c/OlL31pes1L1o/gyRG1B6sPCPIOP/zwDt5sW64KyBY3
z3/+85v+BfmUt5fWt7ZrrrrqKoys+Mqb8NsHP/jBjulPe9rTmvve9771N9Cv
dMqQ4QX/ilrqLEO/Df/xH/8BOjSrVq2qBCfXcRy71PnABz6w1nnTTTedsAEN
WV4bolBv3v/+92+e/OQnN9/5znemE7FkPWnPoRO11m8BNurzGwm97x2kGtE/
9VM/1ey8887NypUr61+kFQEevHWMZ2qZbZsGe9U/y6q0eu4tb3lL1b7Jhl/+
5V+urCoiOXjLOjxbb07261hUu/sXfuEX4lv7P409XP7cz/XLvnf8XnRH/b0A
qW609t+5ZMznRpUNDPr9X/7lXzqL/LGPfayKwvbbb18tVUERXR3jPj9XOy4b
ca++s3KYr9BR8uuyEffqOyv67yxtbrjhhma77bYb6sMf/ehHzdVXX92cdtpp
l473WF+SUjq1/qd/+qebXXbZpVmxYkUdRMbjpz71qU46Z3umX+ZMI2Gcz62C
br7xjW80l1xySfPKV76yecMb3tB89rOfrcx/W31q8Uy/13cPiJJ2aJ71rGdV
lnJLeKW088///M83j3zkI5svf7nWyNupJosBNdTAqfLc4Pzoknyu6WDXjlXr
bEDZo4p+TxC9qDYt77bjaKfmH//xHyvqPPPMM5vHPOYxFVmy4tS9yl/xilfU
3//6r/+6eoKXXXZZrfDII4+sz59wwgmE4kVRKBB1+eWXa0dnEFVx3HHH1W8r
4h5MFOTEsNvopLy35Uv+9NrXvrZ67tzmdgxOVrF86EMfWqEkF+Of//mfYwCv
aL773e82L3jBC5qTTjqpws3rr7++Fs0uclEe9ahHNSeffDIo1MEjCAM04rIX
5fLMqOb3f//3a+dytvy98cYbOxNDT1x88cX12z3vOqQGcxdHaTSqGsHXojoS
M/zVX/1VNexHH3109+j73//+Gts59dRT9fSiaAMB0NG/+qu/WgUAADjiiCNq
m7TNZ69873vf63Tsf/3Xf1WCP/e5z1XFVaDG4GkxzIUemHRXcdgr7Cn6OU0A
aEnWFHfPLaER7xvukOc973kVUkNfj3/84yfjNp0LZMJMRWqyieeee24VFmAh
H4VJjzrqqIqRykjOQfyVr3ylCsbXvva1GoniDbz4xS9uLrrooubVr351beLP
/dzPdUAbjZ7FkiuuuKI2qRSdvlMB0fU2MH1YcOSJT3xi5YTLawX+d6b7Na95
TXPBBRf0hsvdo63TuteIzqt8nojSbr311ub444+vt3/t137NKO6cdIT57fvf
/z6tmk2/5ZZbajv470W08rb41I477lhVUbGObSHLq9xTxddee219i1niQLgv
poJDBRVuG48XwaxanK392Z/92eaTn/xk8/KXv7yZnJysAMff0h+HBvlEnPPL
PMNAxR2JYTJRRyHDqZbC51VbGdEy4v3DgkHdu6j38jn5QXXz9V0FcyGt44c4
k3HiKq9kw2nCP/zDP6xIsFjqHD5UGpxZwGBnGERXgMZifQfJIGoNiWeccUZV
fU9/+tMrgyhZ6AUnttlmm0WaX4qYmJio48PLh9T/l9ZR+Su/8ivGdO0CWAjP
UfbVr351l7tfkz843NlUliAGoFgIzJZ/6EMfqhF5F7X10Y9+dJC/CdVlWIW3
z9osit/g/ac+9an1t29/+9vNS1/60u497mX65OQdok5ughHceFaugLJkW0Eo
NVw8VcyiquIyYSP5oL1xDQ6M55CCZQXNDJbGPdXecccd+nmw292eA1cNiwIw
DCm86lWvmlJTk1VZkB+WjEoqsHooagstcn4KsMhXPPozP/MzlRrKb82aNR0P
GDuBOdcpp5xCZ3bF0UlAKuRfpD/H1HOf+9zmM5/5TK29sD3de4JvAGDAtiMG
RMJUBP7SL/1S86IXvYintn8QIvog/nPOOedUVPybv/mb3dBMBenbvbayZzb2
fLgVoozxckSLrKKxg0aGj2HCaSujLJv6x3/8x7WJLmHKYtw6Njz72c82DVB/
O/300z3bjTAKDmddRmHhfvceVyQoqzq0oOLuN6gtjaX5p+Irdr9pLRjMwNL0
RaMPWk4srsPoJ3/yJ2uZus78XenlHKHnnXce5tRv+27+XGAGxEh7kGG+uRAi
sWv8hDpRkquvvrrTNXxyIIY3UkpJAgjbTTfdVAcMZfjv//7vXYNpQvxzkdli
3zrCRRHBJhfii+Xt+E7eYTXlFecqX1E7L83F+S38isj4ZK0mZnNrmPiNb3xj
p3ypAVbZtwdu2hamXhCz5TZqZSFjch5b+JG2K/eOn3gp1113XZ2+Tv4SNr4t
9VNcj7wtRq+RH//4xym1bIfsABW4fO6rFW3ec889aaMu9K+IUGwgdXWNC+zK
doiFMWlEj/SWnzuUC8zpFa/cfvvthyxoG/K3dCa0hffot/lvy0fbbrl/NIlr
QI+05bRvSANBP++wjN2kr8CYGihUAVp+9KMfBf9XVC4wZVQHH5UH5AJbhBzM
WhHn66+/PubrllU3g0xD0LvvvnuNK7EkZFvqzY9//OPBY+aHzPa37Tqw7sLG
+Sb36pa5h/dY/5KXvKSisIITk1kGK8cebnMx2vQ1BubcGN8B5WkWRMHjCqa3
sRtpUkyGCARMeNzoqlPXHnPMMTVK6VtORc1n9R9vGfC4eI3YEuUvfvGL3Uye
sMTrX//6qLy9B4OAoVRagms+jHd5ogXK5EjXrWG8BifEPd3Fa5pq1aRcjeq8
MnZRZYdk17O6Tww3jlV++9vf3pPJRRUfk8epe625NfsARGh4Ua5R62QVHhcl
S1j7iTWcNzpiqqWtk2egw35cTKhSffR3aCDfF89j1dNaTUuhYkoSFtUQGDez
5WRbPPDA2rikBxUQ0lXNycmMuFCQnQkxOJAjwrwmSuQVm1GUNVJGemo2rTN5
F9VPzmPNnxxutDGvtn6jqSQ8vO222zo1bZgccMABdfRR46orlGXtBryfxV88
Unqym3FElZ4t1mFwYr23ooI7IW8mlXPH1zTahAPMPS8gCZ+6s6y/9a05n9bK
ImVJSTI6inIpFsV+M5IKQNi9Pr6s3qJ+BBXMP0GsBi4fRAOLHEbDV9XsPakH
eXlXNErY07xNCOBCkHDtcMNpMLj2a1/7Wqc+DHKgtSjLom78v6gmH+mu73zn
O4M9g9d/+Zd/WanjmKlGPsPJUYYYUGb9zUe5n27JPiqKouOpfnMumXNFI9JX
hSFdlRBujId4bqKOHZk8SFy7dm3qaPgheDw4Je6Rlri6ubd5rOYzbaMeHz9R
A6lcs1G61IBvegpXn/F5+BwUZJGIeL7VeobFjTfeWEe1+EtqPSkc+O3bC+Je
L8I7WLnAdX62be4T4ifdrsmt7Lb34L+YhumqJgYxNut08mtf+9quai5bghtg
va/vlMXuF5ds8MK4B08BOv3mLlSdnxtuLu6Zier3rnl/eKz91lQFVzBsFRKX
4liAL33pS8vjZxqfWAo0kCMavfzN9E5anBtdEPEgp3JNTka8rmDEjVHzdcOC
bbKOoJVCO66bemHYppKaJ5t3vetdNYLHsafDilaO55dVSVGGMC8hLJCrKhg4
B9i84oorBqfGs+Ye3DNU2RBwWcz3Pve5Tx1gxbPohu5C0HF92/xUVmbg8bUw
cLB9vbe0QjYkKd5MlCIBVBq9jKP2sSW1G0xdPuQhD6mPipygjod2ehTFzrOW
pt0gvzQeTGHBr8vmr8bPt+1K25HCzuG+R703UT01ekAs95prrlkSt3GNFWK4
CjtSGT7nOc+p4uTbi4NOjGeRDEnz5JLoiZuJpXJvxQZX9MXhVogD4IdvmSLA
6qCj6TTg4tpak9JmsKQJEP+i6VLR4XpAzpCV2bPGnh3yZGwQDgqWZqJ1vKOr
qIxiDLtBuxHI+ugwc8wAcCT7zNEhqOtTAXxDHHxY0wN0exkhSQVbCN80nR0d
L+3tWfE+XEQNbyIyPjLMlFBl9duquMcD4TE3nT5dWt0zo8tcmJEGgvl84IEH
UlEJSzWMSVVTase5cvaSMSSH6d2EpExjDr0Y0bhBTiOTIN0iolEY16rZ7Sro
/vCHP8xNrfII0FE1nL3o7arEzj777DojaP4gqZor8TAZpLFxbUpygkmPiJ/e
+MY31p8KQO9iBBHXMjoHO9d7O9auZbxIHH8V3KDmxXQMdIzm1pmkENYwkv1O
KV533XXbR9HjZlDWqbk5FESOJYzNQbCJyA2mHhbdykgA3Pvssw9L3Mfmbuma
VTEcEsNzkPhTPjN4UFEpOcUcCmRj2tbduaePXQcdklLxspe9LBduBd/mjZxP
9vkxWbGAbFC9aVKnmMYO9aiFp9h0CnVJdc20gHBCNnrTjN4NN9zQLbyAnrhx
LmNF6AgEEGlKK9XPlT1mTCUyEZw0vkSpSJZ/ogH0Gaj6jne8o65Q2mEB6f3E
MAvFPXMGivos+LZzVcRWGW/fdorqPKPTXLQLZWhKo6iMThXz/SEUl45WvsA7
21WA13bx2Bypwk8ZU/FMRnFgrgxjww3joClBbX5BoXqHjd6AABqHRsU5JYsu
F9UhRUNHpdDyLnL5zU7xvwlfKMBwc9GgavM314JACjAQyMgdAGoymnL00UcD
hol+Z8ukTpaPq54yjv/pT3+6ucc97lFlsTQv/SViab1rQWjhFWzU1kzjvxkU
AyEvg4l6LpCzs1CyhqlxctVq0h3rbARTwA2ygpMzYhBD74TD8xE6bV73utfV
jC7UkseiCk8cIcaJzGjFWK1bu51GFF4go6osWjTU4AaTcUPLjJwH84tlq0Xj
dNqKFlJK08HNNngmGlDQwaDNl9qhdoncM0FIuZG6xyzCvvvuW30padv8UzbS
iDFZjGJZJydFuX2NlKECMxbpxO86D3VNazIhXbaszgJ1TaYfGA7ucjaZ+WLW
fEt7Laohv6+VpKaCa16V5wKcdm6l94kkzYAkRumU8TRGkmCApE+ywzyR8OVh
bjAnkY3UaVWmw4xT0zNhhn0sJA1utNlR4LWxSPyogoypy2PMvP1sDnHOkFQ+
B1Bw/gonBs8dYzD3QVlcC0ZPBDcS7+sNmK5fJQzoFZfRZ1omi1e0OAkZzOLJ
pF0FpsiYrHml4g9cOePh29/+dhfQGtXMharzuuHm9uOl2wePJBjgcK5zISk9
p4rcmdkx371kGkUmVSeimFTmWYxEhNtuuy0bbYIkp4g3Ts3Tmm5yOJ3wXPMN
I3habEVkgrlIAyd6Ji510UUXdaDJ5Ab8xehlbod8r8zrksBdvIWI5C2t95n9
vMT9pd/QhDfffPPyBSZjmqwLkLIB1sTsGBRCQ+ag8NTwol18Z+2Lv9Qaszaj
mewwVAybCxb76le/WrtIvL0oqtOiVP4ltZeztjIwNYwnVRTT8gWpfFrYUnxA
mlsRqE56BHlzdjRDbjC6ySyKpECEBB/4zgmkIAxYaI7rXCodnBGvmjMBjcD7
UnR2BVuWV9QYIHC9avtC266MRrP/Or/pjXwDi+UU3waP+0pSZFfkzbcMPvW9
337qnz4qgzIm+naoSMKghF9yjQO8DE24n1n0811/zPLdO7gzm0OfCUyxG0yw
uWWLcSAG68JdSQZZXeTbDJGlH3OvjGSt4Yrc973vfRWAFGw7eOQYdO0ZZRJa
XeZbjmnIhPBOLdNaOFpjprglZzxff6+oQi9buz7F0sWVdCPalSuMihuZKANo
iQTYLqDHJxpGI4vrPTAvhzNgXIbw4etA5R5RvA7gTDTdmF5oKodYOndwIBfz
CsxFeLtL0hHo5IxqJKRTYHJXhnCKRvAhd4l7Bl+GJ1PdQEGZtCYzpKC8kNC5
aUsmUqdxhapaONpicGfVc4UAkn1siRjIVD8vq51I0IUGWAiG0eAxCMRSDIBd
o0vhaDNljEyxwznu2B5ji9qiVoVoDh+TtGxCOFZB1IKSNo154zrzKasWp6l9
itI2eVHqCmNpgPlcTNPq4LSFyPLONCa3PGCgLZs4Yh3JSLJNqWe2+vINJ+PT
M0vUfvE6dcvXpQ1MaLLRuqVArw4dEOrYbKwzKxy4wOtDgQR6UQbew2asc2ku
Fa1ykXUKfRCD8n3xBlQbmYzZrX2Pe9+o3fAMHtesWNqcoMGjF198cdbOLyKb
vu0T95j2iOF0YSCuJzm3Drvw/eAZa17WZcFJXYO6bQ8F3vLzwaWCCDrfZj2r
H2r/nK53Gr9ePkztsL6JIFO33nprN85hu8xmyTRLTpcplaaHMTK1Npd5ytg6
eDyy7h2PCY3ttNNOVQhYqiQJeUWBzwdFwa8EVLM543tGYRSX5QBxbWsWM4JL
cIa88rQGZq1j458Q/jYZm7AXajrKAN+IgFZNVEz34OFjkJSMYgIEkgxkKkSc
QyjM98Ko+SAnGJUuE9eSGp5CassqEIYEuOl+w28DjCjzXkx57x/vC+Ihpfze
bQeka0kiTlIRPpd6KpIurjHQwVnOSzoZr94kkLE7Q5XrUWO0NR0mwUezp8xM
vik0wlmVUQ1xirMWHZRJ14SaT4cdInbMPcCEAI+CB8+J4vuAddH8Ff+xthHp
HXmMKfWtH6rOZQ8HRt/TUUSOKBtUYisZqO/teRhzZIv6qemditiQct/f5/1E
t/pbNWvXrk3KDe3IlR0cNIKS1I5AiSCB7ZmKs5FZ5gxcb135og0r9QP9obFs
aNGVZUdyVFwsnZEmFPuQKJ1my77vr8JWq00+XNTUcVG26PW01c8bXHaQ/+h4
xFigUQEDzvjExMSgXXI5UWdyDDv66Kqrrnpo1CSiQPysusyatDp1iOiSbOaj
Z6iicGm+qojGHBqtVgujAiQVBJKjFwFiS1gmzms67LDDDpuMNYP77bdfh6hb
2zu7S5uxfECe3BdB7RQF/Rpb09VgPNEro/sJmzuBwcgHBa91kxQm5oBimtqL
Y0WFIN6inOl+lkgAxDA3rw2i2whAaDIH8KilmgZLrC+PVo3n8C6PZ6EK/hqG
wY6Ca5kJJ8JvcDxqC2tPrG2/T/2zU7Xwkt4MDeTTaLkGRixKGA1+MY8m4uZ3
+QKe5dZqZrcmqQXvzGvxYLtYSl+95WrKBBNzedUrowyGgHgry/yFlhx6129C
rC5fHS0BX+1sIEoFulNpol4GNxMJnTHJNh4S5wReyAEgQ74o6ltuuSU9AmKw
dOnSoVV85sbUjimFcflof8+U/XqMmM1nz1k/e2gJU/v2oC2mJdE1tfe2hY9y
txoPCUkY8OZKkCqxWv+Ch5JzqEyiFktpalRN6JJ2lqNZlEJ/8wJI3axEepKK
1IbCta65REyyDlRauJfLaseNF+T8qM7ISb09t+C2fajtvlzAD8ZwwdTQZfqt
rLPHKgeDuUhAu3bggfly0BjEl0HVvTZRCeNICNRfcMEF2TSJQLYftR9BNs06
NVluuNZbWU0ic0NYkUGrXvI3+ijDDToBNn/ACEnOaCG7bvLft1V3s/ZGN5em
EUdJHJrGHQWAiK7mQTEsQaYedql0E9XppcFlIRYjkJIrOgSwmzvIpuVuQaKw
hea8zZTgnZSdUnG2yqYiER+slueSSy7pWmyGJRanVm7AEin0/TBQtpj6gzss
m9gxuvLu0t7AK4M2wcDbEH02h0BzVMU4OnvRLpjMfWuLFOZtaJelEUIrJiPJ
Q67wjyvW9HT7BvQ3vurtemS+3ayiy+iQD5i/QWoxTVfRGHluWztnHKtdPNGG
GWQz0mjCDLyyMkRWBlFmUXrcuHsy432dYIgQxNWZdyhLjOess87qBJrLRMOZ
1CvIIW9nLJM/VCSvv5tElgy3SdGevmnNNEZwqs2+w+dsXPEFulc0jHcldH3O
Oee0QGn2YF1uvCfRDzXaU4ZFpprzLILALgi8BTd7aGu+ySoVdJ2/SpKblgQJ
becmrcLAYo5JUH9nhN5OdtJM5RWPajZVZD4dQQXQ9vnKIoqdlhGZXYCgnEVd
c1ci9o5hBoPwGT0V0JRHlQSIMObqctjvpptu6ggA4RUrflecz3xFyI6QmMrQ
06X47hX6zIyxZXkFl5+9ySlohllh7aqIuYu3YpeYLFVMINLHaoS1SHZXqqRC
O2fQXuVzMl2yjk12bYXzqoWvor63bLhFpgiTTWy/tO6sLpObVBux7q46/pvx
aOKtsPd181tcpbRV+11SEW9Qwq/iC+TIBopHsiv27n3T+I/WGtpV8l0wWX/n
FOplI+7Vd9ppos3isKmtnzf+59xFaNThTjOcprWJTslKR1kSmOeBfRSZixp1
0smo+jL5Z4ZjyrKKUdXPF/mjfttk55NtN/bJar3D2wajTm87eG5xmuGssI14
BlimHPH04DmX8LEF/eOK0MwnrS3qn7Q2dBDYbKc6jUP3xIh7J64jvRuNvYuG
Dpg7bGa5GHWUWbZgYY8ka2eVxF1THq0AKxBqQ09SG/ckuPloyrhCsTmcBJe0
9k/AO3RmyeivPsqT1vLewp6c1mop01J5mYHdfffdZ5aMDTugbhQp69uEdZOI
TXNAXXZj/0C+Q2aWhL6D3jshbn2FYdxj3/rCwIsfQxgyVjXGAXVL55HScft8
HcibT0Zm+f3TAh8+c3ePOsWur5sW4mi6mUyCuO8MJiGZOcYheuMwc1xK17Wv
N/IZf1lW/zjDWfq6z/cRp+plaQt/Wl4/mN9HhRdccMFIVJjdMN7JhEuGTiac
VvVgPUnOHp52+6T1pHbheJtZfDOcyBia/75B6ciz/JbU+NUMpwB2Wxku8IF+
KSOZ7IkEkwii/s+bjfo5TiJcMeuRitOpWF/qU1ym3V+zAYQvOMf7kjPiWMmQ
nPrqRgqVzNdpiuM800aKF+ywxXV59qV9UubvTMZxn4vq5/vYxnGfm1b9Qp3s
uK7Pz8KVUYdAjrp33nC/znUm5Kh75/aLmK8jIsd87OzhQbmhh0iO80xUWSkJ
nfCa4Io5ABH6448/vv29xa6Ds+J3C/tk7ZsjyJkrAFO4jT0pHZImhlUVoOL8
Quv2VKxFHtkWmRt9+t3kkaXaWaSJct4lUgrcztsaIE1B6kQpMmuy527Otsl3
tV6jX1Nuzg06OE9AfkIWaR0aQM9cffe7380iPepMRZcZOQkRo+b8jjjiiHxF
No/la5WrhSUmw/pUzHEs59ODSKhTjoADNJNIiINNMXl8wgknZI0mZJIY0Y6T
Tz65M/BmGXMrNLyZOvlnomac5gYCvek3vlBsO1FXMhfnJfa9mvGw0DnOEn1r
tHzDjhE9Isg2BUjOJNF8//vf73MB2VLPee39qduYjOu6sbjcgwyekrFcFeVy
Tki+R1XF9oM1X9gsXXIP2YANg16MePYRhnuUh3/77bf3529jaVFsl7MgZ58u
4LGqcX7uYEGPVX1Yj7mMtvy24mtnf5DucLvvNNGsj2Nz4twEa2iimV8GCxx1
1FH9iWYDx0+kaSrZbaJyxvkdur94jP0QnohfGYadJ08gTQlfeOGF3faCm8F5
r5vR0bNxXvMmPHp237gtCpM6r5cZw73L45xNyJX2dYIlSzKPnlFL/xQrcmqh
OGE8//zzUyLEhaVqOvWkf1os+y8pYDIGK4fVYjYKHWXcdQ4r04rl5vIKWTtv
Or5twUf2hlBufkf23it+IxmxUVP93D+ZLxM5XAZ3wS+dwEr6jH0bKp6RnZkC
K+4gYCaOVuBTWi3jnrZjM3pp5ihyW8434KEH8IfIS2TRK3JJM9fMmDeRaJLD
fV1QMO7Omx2L766nIm83LPN3xZOCU5LBFnLoKlUlQSyXUI6FRtdee23SrmB0
OhagH8S361ABSFHqiqpPrAaTuw7diSWRei4ineY33x1wkn0DdZiOFgQEWPTN
ve/CHN567vTMbZ02gLas45bTsMoExG9QZM2aNUkLnAuR2NCisHOy1yDr8Kzx
KlgztRyFaD2lASneAQ8hSy487QbvcDvsnp0jSccZgaw/d8VGZhlM37JYvfWI
7/VnxPbDY3BLOO86UylMFoqb28cyYTNuGHaCYLKIp2a3llSfjQ/CvgNfIDbf
TBBjW+q1lBlnZUcN7f86B+SWrvCQLYiPW49Kn6nJOw4Pmi3hoPBd+geF19gO
1gEGivQ8MefaEHVgwX0xJP2NvaarNIviMV0uDFJ+e8wWxKSt58mvHwd2Gh4v
d/0D07dvFi1qDxqFc5lZfmIuVxEFxyYYHhZWe5xr+OQthgULcmb8vbayZzb2
tM5ht/R/sz1MftnQYfIYwZCyu/CVoSA35rmbezNGb4GSv+k0UBEuB2zAxLZD
F1eFaG7MRQLNchRhTV1rStMEq2+5Fd/dmwsh2bvGT6gz52mOMK2GKRO+D01b
SkkCjBkZ+sY9s0ayssFsGv65DL0ihR3hZsRiu9lKvGP8cvCDMgKLEdg4bdNS
lfyiTDieVqSkP6PqnE8BzKygzGPj1ZETtaJ4pvDTslOwuffcA7fs5rWufrc1
qriWvQ/7u+oQfvHmOGM7b4v3a2EcJZ2NsDYpNyX2mbbOivsHJLxsQWtM+4DF
ooLuZV6cIsJCVTAiQF78rOScCW3wzOCLc9e68AA0Twhiz/BDtoA2tDMmXZ4x
PyZPkkiazbOgG1rrdsWarJs3sVgqQIutc7On+zsevnp+im5fWVnjvmYzNZtO
5oXlkbuQvYif3w3K66+/Pre7FPUxMFFmR0zTgoCGAcohsxHbY+4ylLZhhdhL
u+1TiddclOJEpdKQDBWbrHQroqc92grZiiopqZdckB9rCVBmgq1AhfalUc4d
1VqRbPkhvCCExGBrP9/quE1XdetddjvO4nZsGt0FwsSaBb7kLL417vVI6kRa
aF9QzLdMLwB2+TI0fDqyeSwHT79g5hzFBCTgRZcbv8DV7N5v/NTO0YC+uBMX
gjQzK0RXGPfSWSjjr+YWyWmCgCZJf0AQqqXJ7Ba/xdGy1TQpv79cTkiEnpuL
GwtVZ7DmqKhMPE0w1DxdGdz9Y6tl2fq2W/TIbLnHLx3RkqyduxvbSHQGH5SM
vWJrsMjmo9kSwYtcmRzGouMKEKF10hrWbII6V/e5t7SibakOMIW4iTCOQSgc
edBBB+0W8jdOynRmfbKmw+ewtFpZ/5oQTTtID9j5nGphJ7WgtDgbJJrjZzMC
HrFVbXqlGmo4FLPbrQXayNXuMTxALSq20CQvoiZ6YuIxIiTRVXMnf7fnbyyv
ZbAvxCNPAkSW/vIb9VHw4e5BglushpCujD4OFKXJs9e9ZVzFAT0LUvSefYa0
m37louDcjX+utPNXxj2agw9VLEhR9f5vT0YgrLLv9oy+sjBRK4Q7kFP6Z3Dm
PJSx13BTervjd00ZN2U9AVQeBVuYOuifYBtDNlIyJ+rwlnmDfWvXrk0rAvBF
Pw3Omf8i9x5ucB/rj+q7c3vjIU8wyjxCokJPTQ3DNg2Jy85lZrmKpA3yiC/D
0zC0/RXUJBCcw9fCGn3m2ws3QZ37DLMFhMwNKXMNQn9hwCviXl+dJ4nAfmTc
dCQSOSn0LjnQsk6SxNirrf7GB+yrc2XRdF/5yle6o/M2Zp37DrNFokueYJkH
EsyxjGGUsc2cWI9A102nHRfXVAPy6kIJDVpMUp6QwhYapCKKRJqtK3/7UECg
if996iareb8+15bVSXbZE0YxM8UREUu0ZRXUJDG9DRrPvjxjFCvzBGTpKHDE
1O4Xk3W7ZLMfQmnU+aWXXhoMWFahlLEvnmncyFdVN/yK1iuuuGJw2kau7z4t
2xKvgDbW3skJAq1zmylmuzgQozDw9vEqdI7DqJCso+bcTrtogjxxLo8TNZHu
UaFLjRAgOH1hi99/uK3YJgJpDMuRtC6fkMnTKPeyrX3g087fTtQgAu1mquya
a67J3bcwnM1m5osrmqbAVtsk2LcXL0ip9x0WfvmMRhUlTaPSSIA5/lHaTgp5
XxRD2eNE0yn3dg9JKZNSUuQJx+lhqcMJRXgTIWuzY/+zNl5VO/cZsajCwzx7
88NxTzdjRJ8KvhJTI7JhWhWKKaMmqWDiYwVKd8zyOJD9zI1f5aphBpCCyAse
fCTucQ4FTppODy+t8MNIklRhVEGdPh944IH9k1HxkrWf2ql9brh91qapdhoj
+mffXh73+lgn0ycFpHSLmFa3p/N2dUJFNqold2RPnIZaESDIlV10pI1dpZaY
YExK54Llz968yAnG5Qnns422FNb+sZoXx3uCaxSwNf3W9stX5OP0z7rq6/k8
GZ20Mtb0u5AEpMQaiRDmDs0cbrOhwl/o8TulWZRqbk4/rgPxtGkcEEEcJU6L
Nh+So4MOWQetkAy3wDL25uo6ig2haWJj00opygocn6Wjlnb+EWeVb+szqwvm
dVtoL6qImFFrOkM3LILP2OAOmDdSVvcZO7eGySlrAw1cNAL8E9+h7GBdqz2l
910U76ve9Ha/zDu3aEl1rXWo9R2gGxGT01CAf9S7pMJYbriLMhDbBCmEQhMy
9v2n4zaY0wtDVwQcHz6iR0bpp8nodGjYajEjCVlgm5klvlKxKRf2ijM1UGqc
RZyXVDNEXly0baxerJuzprkShYLEXGSMzTbBxZYX0LldPDaHd/b0aY1an37Y
eNTuPNw74yqpnBuyBJzqJxSlh/pHo1k+LG7X5vQvrmvUhe7BQFWIBxR0lJ3W
R8wtG3aqSTaAVZzaWOGONvibG8kAXyAk/ZYntmdMTrZ80X/pPMzmCE7vtXY7
kfZ/6nd6r21icqd1W39QJZykNWOzyWrlaUzhGrLFohdDEX0zWZ9ltgA0MWwu
aBuM2LHO83mee2nNJR+STuRXkTt15C7RNp+Wuq5FBnAxSKeMORxWz0917ZRF
p+T7iiiP8TKjlhGXi+OeZV8oKd0VcasdavdIphfPtq5GV5llc5Aav9OSQHEI
uMCgk8aCYpmN47Z6j3moa6jJcw74BHUEFfyc4sKSqj6kNUvjJcT4ilrqf+ce
p6xpaN/w/4qaigGP5BLF9NLhERKMHFQXV7eLRM7FmVXzVF+7yX6Hd2cbVH28
G1dMHi+uyf2CKsuWLauK0PRsEc3UXn1wv10MKm6fAWVYx14PXWaDdR25Xjyr
NTAzQJrPQX9c+tKZsWfU+IZlY9AU8aXZ3LA7h7omK5xWjMugNpGZVaou9hLo
qiTqkUXbxWKtv+GB8LANc8s5RsUnF7rOocjkojoNmBkUM7Og3ShbT+RCeTCq
5xMTaXOyUl+WTKNSx09EMWlDshjV3HbbbTMzYqFrHmLH0prSIIabF79RPiAF
fPPNN49KO9g+mA34uMeDEVcqstylLoiHCmQ6TCuXHJooZJKBjkw6k+Kbqbyy
9orPNjIGu9B1TovDctrp40xlkPqvOi5lcc5GxWF3iFfBPpOuusMIpvN8h8CK
6W6tf7uQjLFgTll3FyhNj+ldEz5FfY7ixcLUNMSB9uROwJEXVZRWCh/bF1e3
v1UfaqVAmhqI4HV3OALHzCQyHfbDH/4wYZRu47YzePQTAydwUuiLCd0FreKA
/nhYVk2qAQeR5TJbyJ1H6b7NoN4ZgkSNAAGmSLhAfWUtyD8cTRqO0/TTxElW
GfSDMxao3Ji7zlPAZwsp5XwoYYHefOvvhE5o5Fm8eIyy7hvNMcYE+F16wbFd
SWak+g01p39idCp2KkkzHQsEWxX0M3jkZkBD5EnkSfPjBIP2iCqQnKfZvHQd
3j8g+ll39E+yj61qEvHAYLGAosNqfPRYXtSZCfeg2FQNsWnG4ZsdRUOsnjs8
lGym6uLqZhPnejfr6CO0JSEFYujcesyA1oq30pUhAIYBQi15PBzlEanTnQWC
5DKnVu7XS17ykpDmzZO2UCDJ0rlCRPkc3ZmsP2vMd7N5fYO3NGSR8Bh4wk4s
GuNuMBuUomAG5K4hSlwPk7WMYsE0GSthK411apVBERw8fPMlbRrjx43+5PMy
PXIp01nrWMao1raoqs3xFoaw9oki8LmY29UhjDZb439hSGwwW0GJFZJHbB5k
7DWzRO8X92Jvm/otTaCBJdgBZ58+4t37BGVJrXW3IBORKNA1oYuxGIewdOsb
hADCPesgjl3H7D8hv/hhG7e6SONO9vfjNPtGJ2TWroxWjhc9zW81My6IWKBK
x6T++/tFpUk1cAdeGRdckYsvvrizzfxYY8m3feIeGBYhvC7OKbpA3dhoo/Tx
wZum2iGmzRnpye1xhB532mmn6lyUQZ+yBolaVOjbaetS4tIOLpOVvkE2Cm69
9dZ+UCRTmDN9nVdtKrNpphJz2XWyklvLSBo9eLOjKJifKHe2QFJSxb0TbZQa
JmwAIRIPYlG+nzFGUVU6tpXpEF0GJVrSlHZX+khs2N+pFmQLMpdmdE3itsQO
/jW+V+BhhI83IQHB03SOILM849Alu5Ti1UWAok3W3hHPcp5oBKEcpk2XkQJD
i5cqCWb/IIdKRWL5vduznnTECXxVFfv8ve997/kLW/xQg4fdgFxa503bVFjj
VlTgW+NH87aCJtbFeM1CpqJMc+mMsWGAo1nAGMwCctHlUbDsxPkratfhdvQX
PWU7ZCUZANy88lqG2jLblJV8Q29YJtZMsTKFlEv1DgwRYhHIKhE0jIXrMne3
d0pYNxU63+Vu3291u0lQb5+rVNrERfAAfOht+UtrmfPS38zY1EraiUoAG8Gs
ld9za1j6gomxG03ST1XFKobBQSPYn1RAlqJV9sAvXfCM+S9yhz43Jus5VqNX
A894dGscjV1v8ydkLOYr7hMhDC6mMWkwLYTBOFiMWRrUfi+dGnJMy8bi+ySo
PgDFUE5yBh8S74MvORCTOsm8CLf/j4sROG4Byw5+PjoeoTkIsJCIeNO22247
mHlbo6ktq7zTO4qc/pSx4hJZKLito0J0P+dQxK6mDhNvx0TspVADPZdffnnX
N1pJCcKCxQhnJ1DXosK+PXeGVhTKoxUTtRXeYXoKiQ+NYmSI0TeoSUphvjQe
MqCs3Tl64auILjk02q0WwAPyL/i4fxqNwLGOt0zAbP1hhx1Wh0LRI/0NdFyC
v2gSlyg0Z/0KzbPGkTvlJk5O3wa9GsLsKHu85H7NZqCLcu3eU3VurS4M1d8Y
w4ATQSE3X//611M/cxEpBNsMP3UD2r3IgTw1QcTDLcidPZaW87OiAjT02rVr
O3MKUMThTjXnANHFjD1hcycwBOhB0R/Ek1KDf1jgqd1HV1Ss7y0ACOoAHCX8
MUjyisBbu8XxDRPDz7W/SD5nEx4RX8GW1KRQAIxLNR177LF5m+vCRhrIxxxz
TEqS7BOBBpcUM3gwfxMSkpPsYtrtLZFSlotFxIsLDM5XxN78RMvLboQpHrsR
mSRJK3YYi64fLxS5PJ7lloj8kSrurwmcTFe30Jf+f9QW1p7Y3awNCuxUcb9M
fXoT+ZRGLk42w8CgCFcx8uZN/C5D1LMCiZrZLSdv4w52uDzllFO6JOr+BiOO
nrSUvEuTnaiLjTBIAKZ412mG6FUpqSB6SjWIhrdgQ7fpabvtXx5Thi6zGfmb
ynLHFM6QaYnUue5T4y6GsrCpew/CyhMyzDnLszlsY/Fs9KYs6ZbNFftdGWXA
wvSmsnBs6ujNu3QTYrux1dEScRGOFsMo+MLompdiNWhAXrs4qo1SdTgX0NgB
P41JRvmWW25Jw2noOAuwvxWGxBW1Y0phXHt7Vec00AyyfpTkEZqA9PKDeQ8U
rtfNJidOgxjBBK4EZhTxSgqk89gPvr//ssfAtyKtHVX4x1LSycWO9R2U8Ixq
jgBj0d+lI3Jr6zgqJm7w4E3Mx+FNhlNA5oqyZzq2sydiCId53hJaEiJeR8G2
/V3mPWQSgYjJ2kCqpYfGiYiD5Gmdb8hyXl1mD3nvDLVFPEUA+rsCihbJhUhR
U6Q2FK4NiZqUbSGSwr0de4wm3LjA7EBc9CZditEYj9EiLtLe4LuMoqAIw0sZ
SY0wg8QsgCxrhl8sKqG6C9fyNt/VOKGieuCbTGfCLc2G53ttpkzMfZnGneLI
beFIdOZy7bkFt+0e7RjIvfW42nYZU0MHHlZWIVA5H5eMkBXtwAMiJ9JF3CyT
7GEOhEEM0PQFF1yQTQMWYA5bBWbTbFVvTQiuFX06CnNAzlMH4kxW4xjYvXbC
1LYnO1V4x/CqimYRsYm0gjqeQEab5ZhX4AqbeDWulEk5EesytlKT6G/hplNP
PbXrIHvvcCWLO9C1go0C6o2nMlx33UK4+oCooq9kc9qaT8gsN00mEtx92huD
pzTNIJdUrWli95xnCkHzeMDAXi5/6lbhTNR8bLjESqiC81IfmPcTO5QYk03L
7cilAxSa8za0iHeCGb1AFh82PdAIHHYttgIktnuq3OBi7RO/gTLGincxE3PT
/WLIaSXhbkwWK9FG6gTcYVZBn6nAWBurBdJkrxXDkn3HJOlpRw+tCum4q7Mw
tXF/mjOFhgri0QpF7Xi3bC8TA8B4uy8gdIJ5E7NoHRpsz93Is2+LTOZtKhqO
FHcpgLAfGs9oYOws0cVU+ocT9HZUJ+iyDl0UzJlnntm1VgwgZkIq4JpSCRM1
gCgYCP8UNZKqDeg1JnQYedeZUJPvDIVpeQIPt/U6U6BIEy03KR5FDg+9E1e3
tYogUI+BdzX+tdIy5xR1q1HbGUHr6ugWWFbcrWjplVuZMcWM7bqBZSou5SUh
C1/eLFmBKJ1C4McysqY2il+Vt3PTIeHcMnL7kyFZsujAlVde2TEiN4qexghz
HbKfRc6A17e//e3dKxomOGwepAyJg+MVjYMXKDAaibM2HTAgUC/pMerRyAKx
BAR9pxPLqMqYH2MEwJ133nndSm/3ojHdQobNnUWtpz17xkEujrdUDjXaUzTv
3bTZQ4chtbJFPvxVUv8EVllCeW6omR0RyzlmYM0MZrByerNZO6EjBB155JF9
vsKt1gcXpZVdgKBMN35U3MOFCKGGdVxSSxMWFV0WZ6FAEFvwQeCmu0gj19yV
iD1+WIr4i5loM/2MVxkhuRUi5376Ga+KhYF7qQ3miI0EkIA4l+K7V9g18MHO
TAUun72Vgm+eMdwZpjFEsFxGi82ss1TzRnl8RByw3JVqhSOHnx0tn7PbLdtx
PJHtul+1RVTx8mF+5bGcOoGJtSg+axIQAVDVGOlXXU0ALaXKoSud97rNurh2
58Nu4ZEADkSt5AIpkksmAyAxJ8C+aUEebVeId9lQ4s85uXzZmPfe3BZRe//L
7ed2efTss+31+TaNZHBy/TPelGa9+Zz+e3PPGvXfOSl+nyv8PuqdccOWc9VX
fz9puA19p7T+fmL/9zmRd5+dyf7Z4Ej/+X7Xbf289fPG/FwPeSjiLUrBN169
enWdFCbqQI+QeFFYu4z3WC7IEIkyy+rbrvNaw7tbsq+sf5ZVCOdMKD4EnWqU
yp8RibR8pmiz2FphvGezAeIparXEdJcFqiua8u6o0sy/BgsFpKmQpDxoO6xb
2zjXc9kEgQpT/zZFXTXPdbxrmHTBO+fdSqOZrdi5nqtkLsP48gNt6eBua6/G
LWDc56bRDzjmYU9pV4SA2CP/LLSTCLRqHZ/P5TdmNbxTfJV1LmNdn58mVSbI
I3u2y3ACQHCiy3BatS4Pp3yJ7tqESKN2XrDaZmlORRo1VjeqxKlfk2AeR27A
MYrgccubRlK/Y1aPuHfEmM99cLhYPhIRJv6rR9w7YsznphXLjwCT4OZ+Yous
tKY3guZ67uB5Li9GZOp1UxgUkMmI1J/yPm1JGjspdbp2nGcPWaByQxbSitpN
hydKby1evLgzXiIyPRs3x2OHzmtpQaL/NzXYGGzz/4rz9Yw=\
\>"]]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"FeynArtsGraphics", "(", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"G\"\>", ",", "\<\"G\"\>"}], "}"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\<\"G\"\>", ",", "\<\"G\"\>"}], "}"}]}], ")"}], 
   "\[InvisibleApplication]", 
   RowBox[{"(", 
    RowBox[{
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 G1 N1\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T1 G1 N1", "]"],
            Editable->False],
           TraditionalForm], 
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 C1 N2\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T1 C1 N2", "]"],
            Editable->False],
           TraditionalForm], 
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T2 G1 N3\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T2 G1 N3", "]"],
            Editable->False],
           TraditionalForm]},
         {
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T2 C1 N4\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T2 C1 N4", "]"],
            Editable->False],
           TraditionalForm], 
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T2 G2 N5\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T2 G2 N5", "]"],
            Editable->False],
           TraditionalForm], 
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T2 C1 N6\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T2 C1 N6", "]"],
            Editable->False],
           TraditionalForm]},
         {
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T3 G1 N7\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T3 G1 N7", "]"],
            Editable->False],
           TraditionalForm], 
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T3 C1 N8\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T3 C1 N8", "]"],
            Editable->False],
           TraditionalForm], 
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T3 G2 N9\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T3 G2 N9", "]"],
            Editable->False],
           TraditionalForm]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], ",", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T3 C1 N10\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T3 C1 N10", "]"],
            Editable->False],
           TraditionalForm], 
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T4 G1 N11\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T4 G1 N11", "]"],
            Editable->False],
           TraditionalForm], 
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T4 C1 N12\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T4 C1 N12", "]"],
            Editable->False],
           TraditionalForm]},
         {
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T4 G2 N13\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T4 G2 N13", "]"],
            Editable->False],
           TraditionalForm], 
          FormBox[
           InterpretationBox[
            
            RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T4 C1 N14\"\>", 
             "\[InvisibleSpace]", "\<\"]\"\>"}],
            SequenceForm["[", "T4 C1 N14", "]"],
            Editable->False],
           TraditionalForm], "Null"},
         {"Null", "Null", "Null"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.4777465415753*^9, 3.4778113186507*^9, 3.4778115990982*^9,
   3.479117520198227*^9, 3.479122912293442*^9, 3.479127334271197*^9, 
  3.499668102818342*^9, 3.499668186796363*^9, 3.500119782564604*^9, 
  3.5001848229144583`*^9, 3.500185290541686*^9, 3.5001868277615*^9, 
  3.500273768678034*^9, 3.500273969311803*^9, 3.5002746319087563`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Amplgg", " ", "=", " ", 
   RowBox[{"CreateFeynAmp", "[", "INTopogg", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.446964688702283*^9, 3.446964713617584*^9}, {
  3.4777465768328*^9, 3.4777465817878*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.475488889115984*^9, 3.475488991008407*^9, 
  3.4777463712427998`*^9, 3.4777465826103*^9, 3.4778116132157*^9, 
  3.478438895955342*^9, 3.478439318735629*^9, 3.47911752774856*^9, 
  3.479122919377945*^9, 3.479127339768536*^9, 3.479547793712118*^9, 
  3.499668106238887*^9, 3.499668187943857*^9, 3.500119787888959*^9, 
  3.500184824550815*^9, 3.500185297253456*^9, 3.500186835022079*^9, 
  3.5002737815456123`*^9, 3.5002739701885757`*^9, 3.500274637202075*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"Generic", ",", "Classes"}], "}"}]}],
   SequenceForm[
   "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.475488889115984*^9, 3.475488991008407*^9, 
  3.4777463712427998`*^9, 3.4777465826103*^9, 3.4778116132157*^9, 
  3.478438895955342*^9, 3.478439318735629*^9, 3.47911752774856*^9, 
  3.479122919377945*^9, 3.479127339768536*^9, 3.479547793712118*^9, 
  3.499668106238887*^9, 3.499668187943857*^9, 3.500119787888959*^9, 
  3.500184824550815*^9, 3.500185297253456*^9, 3.500186835022079*^9, 
  3.5002737815456123`*^9, 3.5002739701885757`*^9, 3.500274637313898*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes amplitudes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.475488889115984*^9, 3.475488991008407*^9, 
  3.4777463712427998`*^9, 3.4777465826103*^9, 3.4778116132157*^9, 
  3.478438895955342*^9, 3.478439318735629*^9, 3.47911752774856*^9, 
  3.479122919377945*^9, 3.479127339768536*^9, 3.479547793712118*^9, 
  3.499668106238887*^9, 3.499668187943857*^9, 3.500119787888959*^9, 
  3.500184824550815*^9, 3.500185297253456*^9, 3.500186835022079*^9, 
  3.5002737815456123`*^9, 3.5002739701885757`*^9, 3.500274637330522*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"2 Generic, 2 Classes amplitudes\"\>"}],
   SequenceForm["> Top. ", 2, ": ", "2 Generic, 2 Classes amplitudes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.475488889115984*^9, 3.475488991008407*^9, 
  3.4777463712427998`*^9, 3.4777465826103*^9, 3.4778116132157*^9, 
  3.478438895955342*^9, 3.478439318735629*^9, 3.47911752774856*^9, 
  3.479122919377945*^9, 3.479127339768536*^9, 3.479547793712118*^9, 
  3.499668106238887*^9, 3.499668187943857*^9, 3.500119787888959*^9, 
  3.500184824550815*^9, 3.500185297253456*^9, 3.500186835022079*^9, 
  3.5002737815456123`*^9, 3.5002739701885757`*^9, 3.500274637349189*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"2 Generic, 2 Classes amplitudes\"\>"}],
   SequenceForm["> Top. ", 3, ": ", "2 Generic, 2 Classes amplitudes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.475488889115984*^9, 3.475488991008407*^9, 
  3.4777463712427998`*^9, 3.4777465826103*^9, 3.4778116132157*^9, 
  3.478438895955342*^9, 3.478439318735629*^9, 3.47911752774856*^9, 
  3.479122919377945*^9, 3.479127339768536*^9, 3.479547793712118*^9, 
  3.499668106238887*^9, 3.499668187943857*^9, 3.500119787888959*^9, 
  3.500184824550815*^9, 3.500185297253456*^9, 3.500186835022079*^9, 
  3.5002737815456123`*^9, 3.5002739701885757`*^9, 3.500274637368438*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"2 Generic, 2 Classes amplitudes\"\>"}],
   SequenceForm["> Top. ", 4, ": ", "2 Generic, 2 Classes amplitudes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.475488889115984*^9, 3.475488991008407*^9, 
  3.4777463712427998`*^9, 3.4777465826103*^9, 3.4778116132157*^9, 
  3.478438895955342*^9, 3.478439318735629*^9, 3.47911752774856*^9, 
  3.479122919377945*^9, 3.479127339768536*^9, 3.479547793712118*^9, 
  3.499668106238887*^9, 3.499668187943857*^9, 3.500119787888959*^9, 
  3.500184824550815*^9, 3.500185297253456*^9, 3.500186835022079*^9, 
  3.5002737815456123`*^9, 3.5002739701885757`*^9, 3.500274637533515*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"in total: \"\>", 
    "\[InvisibleSpace]", "\<\"7 Generic, 7 Classes amplitudes\"\>"}],
   SequenceForm["in total: ", "7 Generic, 7 Classes amplitudes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.475488889115984*^9, 3.475488991008407*^9, 
  3.4777463712427998`*^9, 3.4777465826103*^9, 3.4778116132157*^9, 
  3.478438895955342*^9, 3.478439318735629*^9, 3.47911752774856*^9, 
  3.479122919377945*^9, 3.479127339768536*^9, 3.479547793712118*^9, 
  3.499668106238887*^9, 3.499668187943857*^9, 3.500119787888959*^9, 
  3.500184824550815*^9, 3.500185297253456*^9, 3.500186835022079*^9, 
  3.5002737815456123`*^9, 3.5002739701885757`*^9, 3.5002746376487827`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\</home/degrande/eta/FeynProg/FormCalc-6.2\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "FormCalc`"}]}], "Input",
 CellChangeTimes->{
  3.4777456682883*^9, {3.4778119018507*^9, 3.4778119054056997`*^9}, {
   3.4778119371527*^9, 3.4778119527257*^9}, {3.478434390853149*^9, 
   3.478434394596879*^9}, {3.499668112516885*^9, 3.499668113089447*^9}, {
   3.4996681644825993`*^9, 3.499668165126392*^9}, {3.5001868068055573`*^9, 
   3.500186807376361*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778119597987003`*^9, 3.4778120637597*^9, 3.478434395661687*^9, 
   3.478435582118547*^9, 3.478435888622634*^9, 3.478436917398712*^9, 
   3.478438958877307*^9, 3.478439329598132*^9, 3.479117548181937*^9, 
   3.479122924582738*^9, 3.4791273434512*^9, 3.479547801779126*^9, 
   3.499668113681034*^9, {3.499668165596154*^9, 3.499668191248694*^9}, 
   3.500119791013183*^9, 3.500184828501986*^9, 3.500186836942271*^9, 
   3.500273785282823*^9, 3.5002739717267857`*^9, 3.500274640365057*^9}],

Cell[BoxData[
 FormBox["\<\"FormCalc 6.2\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778119597987003`*^9, 3.4778120637597*^9, 3.478434395661687*^9, 
   3.478435582118547*^9, 3.478435888622634*^9, 3.478436917398712*^9, 
   3.478438958877307*^9, 3.478439329598132*^9, 3.479117548181937*^9, 
   3.479122924582738*^9, 3.4791273434512*^9, 3.479547801779126*^9, 
   3.499668113681034*^9, {3.499668165596154*^9, 3.499668191248694*^9}, 
   3.500119791013183*^9, 3.500184828501986*^9, 3.500186836942271*^9, 
   3.500273785282823*^9, 3.5002739717267857`*^9, 3.5002746404352093`*^9}],

Cell[BoxData[
 FormBox["\<\"by Thomas Hahn\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778119597987003`*^9, 3.4778120637597*^9, 3.478434395661687*^9, 
   3.478435582118547*^9, 3.478435888622634*^9, 3.478436917398712*^9, 
   3.478438958877307*^9, 3.478439329598132*^9, 3.479117548181937*^9, 
   3.479122924582738*^9, 3.4791273434512*^9, 3.479547801779126*^9, 
   3.499668113681034*^9, {3.499668165596154*^9, 3.499668191248694*^9}, 
   3.500119791013183*^9, 3.500184828501986*^9, 3.500186836942271*^9, 
   3.500273785282823*^9, 3.5002739717267857`*^9, 3.500274640446045*^9}],

Cell[BoxData[
 FormBox["\<\"last revised 11 Aug 10\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778119597987003`*^9, 3.4778120637597*^9, 3.478434395661687*^9, 
   3.478435582118547*^9, 3.478435888622634*^9, 3.478436917398712*^9, 
   3.478438958877307*^9, 3.478439329598132*^9, 3.479117548181937*^9, 
   3.479122924582738*^9, 3.4791273434512*^9, 3.479547801779126*^9, 
   3.499668113681034*^9, {3.499668165596154*^9, 3.499668191248694*^9}, 
   3.500119791013183*^9, 3.500184828501986*^9, 3.500186836942271*^9, 
   3.500273785282823*^9, 3.5002739717267857`*^9, 3.500274640456521*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mgg", " ", "=", " ", 
   RowBox[{"CalcFeynAmp", "[", 
    RowBox[{"Amplgg", ",", 
     RowBox[{"FermionChains", "\[Rule]", "Chiral"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.4778119845017*^9, 3.4778120345607*^9}, {
   3.478435376938886*^9, 3.478435418868291*^9}, {3.478438964655293*^9, 
   3.478438969526842*^9}, 3.47954781796*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.478434402570528*^9, 3.478435422620416*^9, 3.478435588542779*^9, 
   3.478435896246393*^9, 3.478436924110362*^9, 3.478438969665351*^9, 
   3.478439333076723*^9, 3.479117552259757*^9, 3.479122928826005*^9, 
   3.479127346493529*^9, {3.47954780726633*^9, 3.479547818642441*^9}, 
   3.499668117837504*^9, 3.499668192781815*^9, 3.500119794018145*^9, 
   3.500184830337043*^9, 3.50018530137351*^9, 3.500186838923935*^9, 
   3.500273788105007*^9, 3.5002739730631847`*^9, 3.5002746429690866`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.478434402570528*^9, 3.478435422620416*^9, 3.478435588542779*^9, 
   3.478435896246393*^9, 3.478436924110362*^9, 3.478438969665351*^9, 
   3.478439333076723*^9, 3.479117552259757*^9, 3.479122928826005*^9, 
   3.479127346493529*^9, {3.47954780726633*^9, 3.479547818642441*^9}, 
   3.499668117837504*^9, 3.499668192781815*^9, 3.500119794018145*^9, 
   3.500184830337043*^9, 3.50018530137351*^9, 3.500186838923935*^9, 
   3.500273788105007*^9, 3.5002739730631847`*^9, 3.500274642985282*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{
  3.478434402570528*^9, 3.478435422620416*^9, 3.478435588542779*^9, 
   3.478435896246393*^9, 3.478436924110362*^9, 3.478438969665351*^9, 
   3.478439333076723*^9, 3.479117552259757*^9, 3.479122928826005*^9, 
   3.479127346493529*^9, {3.47954780726633*^9, 3.479547818642441*^9}, 
   3.499668117837504*^9, 3.499668192781815*^9, 3.500119794018145*^9, 
   3.500184830337043*^9, 3.50018530137351*^9, 3.500186838923935*^9, 
   3.500273788105007*^9, 3.5002739730631847`*^9, 3.500274643203724*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.478434402570528*^9, 3.478435422620416*^9, 3.478435588542779*^9, 
   3.478435896246393*^9, 3.478436924110362*^9, 3.478438969665351*^9, 
   3.478439333076723*^9, 3.479117552259757*^9, 3.479122928826005*^9, 
   3.479127346493529*^9, {3.47954780726633*^9, 3.479547818642441*^9}, 
   3.499668117837504*^9, 3.499668192781815*^9, 3.500119794018145*^9, 
   3.500184830337043*^9, 3.50018530137351*^9, 3.500186838923935*^9, 
   3.500273788105007*^9, 3.5002739730631847`*^9, 3.500274643716317*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"col", "=", 
   RowBox[{"ColourME", "[", "Mgg", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.478434696113564*^9, 3.478434729084623*^9}, {
   3.478435197289632*^9, 3.478435232835993*^9}, {3.478436054623279*^9, 
   3.478436055525961*^9}, {3.478439375412303*^9, 3.478439375575861*^9}, 
   3.47954782272826*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Mgg2", "=", 
   RowBox[{
    RowBox[{"SquaredME", "[", "Mgg", "]"}], "/.", "col"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.478436009927547*^9, 3.478436018997932*^9}, {
   3.478436082403898*^9, 3.478436090700395*^9}, {3.478436177508675*^9, 
   3.47843618204671*^9}, {3.478437003898071*^9, 3.47843701110685*^9}, {
   3.478437477803822*^9, 3.478437504302616*^9}, {3.478439384069483*^9, 
   3.478439384257797*^9}, {3.479118059131767*^9, 3.479118076021708*^9}, {
   3.479118109146226*^9, 3.479118116650997*^9}, {3.479118202216882*^9, 
   3.479118216760961*^9}, 3.479119017869164*^9, 3.479119745593796*^9, 
   3.479123731953217*^9, 3.479127413095424*^9, {3.479183735054553*^9, 
   3.479183738211356*^9}, 3.479184069931285*^9, 3.500273802389577*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Mgg3", "=", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Mgg2", "/.", "M$FACouplings"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"CphiG", "->", "0"}], ",", 
          RowBox[{"CtG", "\[Rule]", "0"}], ",", 
          RowBox[{"Lambda", "\[Rule]", 
           RowBox[{"1", "/", "Linv"}]}], ",", 
          RowBox[{
           RowBox[{"Conjugate", "[", "Lambda", "]"}], "->", 
           RowBox[{"1", "/", "Linv"}]}], ",", 
          RowBox[{
           RowBox[{"Conjugate", "[", "v", "]"}], "\[Rule]", "v"}]}], "}"}]}], 
       "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Linv", "^", "4"}], "\[Rule]", "0"}], ",", 
         RowBox[{
          RowBox[{"Linv", "^", "6"}], "\[Rule]", "0"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"Linv", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.500120264683782*^9, 3.500120270634116*^9}, {
  3.50012037229132*^9, 3.500120418987548*^9}, {3.5001206930421867`*^9, 
  3.500120721959036*^9}, {3.500120848018794*^9, 3.500120861852392*^9}, {
  3.5001209888233223`*^9, 3.5001209942671537`*^9}, {3.500273808495722*^9, 
  3.5002738116933947`*^9}, {3.500274651415653*^9, 3.50027466911906*^9}}],

Cell[CellGroupData[{

Cell[BoxData["Mgg3"], "Input",
 CellChangeTimes->{{3.500274862624996*^9, 3.500274865291655*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["23", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "12"}], " ", "AbbSum2", " ", "CG", " ", "GS"}], "-",
             
            RowBox[{"12", " ", "AbbSum4", " ", "CG", " ", "GS"}], "-", 
            RowBox[{"12", " ", "AbbSum1", " ", "CG", " ", "S", " ", "GS"}], 
            "-", 
            RowBox[{"12", " ", "AbbSum3", " ", "CG", " ", "T", " ", "GS"}], 
            "-", 
            RowBox[{"48", " ", "AbbSum11", " ", "CG", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"48", " ", "AbbSum8", " ", "CG", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum10", " ", "CG", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"12", " ", "Abb15", " ", "CG", " ", "S", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum9", " ", "CG", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"12", " ", "Abb15", " ", "CG", " ", "S", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"48", " ", "AbbSum21", " ", "CG", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum20", " ", "CG", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum18", " ", "CG", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"12", " ", "Abb1", " ", "CG", " ", "S", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum19", " ", "CG", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"12", " ", "Abb1", " ", "CG", " ", "T", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "8"}], " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum1", "\[Conjugate]"]}], "-", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum3", "\[Conjugate]"]}], "-", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}]}], "-", 
            RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}]}], "-", 
            RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum16", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}]}], "-", 
            RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}]}], "-", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}]}], "-", 
            RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum26", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "8"}], " ", "Abb15", " ", "\[Pi]", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"16", " ", "Abb15", " ", "\[Pi]", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"32", " ", "AbbSum16", " ", "\[Pi]", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"16", " ", "Abb1", " ", "\[Pi]", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"8", " ", "Abb1", " ", "\[Pi]", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"32", " ", "AbbSum26", " ", "\[Pi]", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"8", " ", "AbbSum1", " ", "\[Pi]", " ", "Alfas"}], "-", 
            RowBox[{"8", " ", "AbbSum3", " ", "\[Pi]", " ", "Alfas"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "12"}], " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum1", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", 
             SuperscriptBox["AbbSum2", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum3", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", 
             SuperscriptBox["AbbSum4", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "T", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "U", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum10", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"48", " ", "GS", " ", 
             SuperscriptBox["AbbSum11", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"48", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum8", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum9", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "T", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "T", " ", "U", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum18", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum19", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum20", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"48", " ", "GS", " ", 
             SuperscriptBox["AbbSum21", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}]}], ")"}]}]}], ")"}]}], 
      "-", 
      RowBox[{
       FractionBox["4", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "12"}], " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum1", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", 
             SuperscriptBox["AbbSum2", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum3", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", 
             SuperscriptBox["AbbSum4", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "T", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "U", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum10", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"48", " ", "GS", " ", 
             SuperscriptBox["AbbSum11", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"48", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum8", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum9", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "T", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "T", " ", "U", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum18", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum19", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum20", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"48", " ", "GS", " ", 
             SuperscriptBox["AbbSum21", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", "Abb15", " ", "\[Pi]", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"16", " ", "Abb15", " ", "\[Pi]", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"32", " ", "AbbSum16", " ", "\[Pi]", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"32", " ", "AbbSum36", " ", "\[Pi]", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"8", " ", "AbbSum1", " ", "\[Pi]", " ", "Alfas"}], "-", 
            RowBox[{"8", " ", "AbbSum5", " ", "\[Pi]", " ", "Alfas"}]}], 
           ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "8"}], " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum1", "\[Conjugate]"]}], "-", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum3", "\[Conjugate]"]}], "-", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}]}], "-", 
            RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}]}], "-", 
            RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum16", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}]}], "-", 
            RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}]}], "-", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}]}], "-", 
            RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum26", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12", " ", "AbbSum2", " ", "CG", " ", "GS"}], "-", 
            RowBox[{"12", " ", "AbbSum6", " ", "CG", " ", "GS"}], "+", 
            RowBox[{"12", " ", "AbbSum1", " ", "CG", " ", "S", " ", "GS"}], 
            "-", 
            RowBox[{"12", " ", "AbbSum5", " ", "CG", " ", "U", " ", "GS"}], 
            "+", 
            RowBox[{"48", " ", "AbbSum11", " ", "CG", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"48", " ", "AbbSum8", " ", "CG", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum10", " ", "CG", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"12", " ", "Abb15", " ", "CG", " ", "S", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum9", " ", "CG", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"12", " ", "Abb15", " ", "CG", " ", "S", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"48", " ", "AbbSum31", " ", "CG", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum30", " ", "CG", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum29", " ", "CG", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum28", " ", "CG", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"12", " ", "Abb2", " ", "CG", " ", "S", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"12", " ", "Abb2", " ", "CG", " ", "T", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}]}], ")"}]}]}], 
        ")"}]}], "-", 
      RowBox[{
       FractionBox["4", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "12"}], " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum1", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", 
             SuperscriptBox["AbbSum2", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum3", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", 
             SuperscriptBox["AbbSum4", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "T", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "U", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum10", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"48", " ", "GS", " ", 
             SuperscriptBox["AbbSum11", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"48", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum8", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum9", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "T", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "T", " ", "U", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum18", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum19", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum20", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"48", " ", "GS", " ", 
             SuperscriptBox["AbbSum21", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", "Abb1", " ", "\[Pi]", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"8", " ", "Abb1", " ", "\[Pi]", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"32", " ", "AbbSum26", " ", "\[Pi]", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"32", " ", "AbbSum36", " ", "\[Pi]", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"8", " ", "AbbSum3", " ", "\[Pi]", " ", "Alfas"}], "+", 
            RowBox[{"8", " ", "AbbSum5", " ", "\[Pi]", " ", "Alfas"}]}], 
           ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "8"}], " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum1", "\[Conjugate]"]}], "-", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum3", "\[Conjugate]"]}], "-", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}]}], "-", 
            RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}]}], "-", 
            RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum16", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}]}], "-", 
            RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}]}], "-", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}]}], "-", 
            RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum26", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12", " ", "AbbSum4", " ", "CG", " ", "GS"}], "+", 
            RowBox[{"12", " ", "AbbSum6", " ", "CG", " ", "GS"}], "+", 
            RowBox[{"12", " ", "AbbSum3", " ", "CG", " ", "T", " ", "GS"}], 
            "+", 
            RowBox[{"12", " ", "AbbSum5", " ", "CG", " ", "U", " ", "GS"}], 
            "+", 
            RowBox[{"48", " ", "AbbSum21", " ", "CG", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum20", " ", "CG", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum18", " ", "CG", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"12", " ", "Abb1", " ", "CG", " ", "S", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum19", " ", "CG", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"12", " ", "Abb1", " ", "CG", " ", "T", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"48", " ", "AbbSum31", " ", "CG", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum30", " ", "CG", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum29", " ", "CG", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum28", " ", "CG", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"12", " ", "Abb2", " ", "CG", " ", "S", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"12", " ", "Abb2", " ", "CG", " ", "T", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}]}], ")"}]}]}], 
        ")"}]}], "-", 
      RowBox[{
       FractionBox["4", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "12"}], " ", "AbbSum2", " ", "CG", " ", "GS"}], "-",
             
            RowBox[{"12", " ", "AbbSum4", " ", "CG", " ", "GS"}], "-", 
            RowBox[{"12", " ", "AbbSum1", " ", "CG", " ", "S", " ", "GS"}], 
            "-", 
            RowBox[{"12", " ", "AbbSum3", " ", "CG", " ", "T", " ", "GS"}], 
            "-", 
            RowBox[{"48", " ", "AbbSum11", " ", "CG", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"48", " ", "AbbSum8", " ", "CG", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum10", " ", "CG", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"12", " ", "Abb15", " ", "CG", " ", "S", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum9", " ", "CG", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"12", " ", "Abb15", " ", "CG", " ", "S", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"48", " ", "AbbSum21", " ", "CG", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum20", " ", "CG", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum18", " ", "CG", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"12", " ", "Abb1", " ", "CG", " ", "S", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum19", " ", "CG", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"12", " ", "Abb1", " ", "CG", " ", "T", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum1", "\[Conjugate]"]}], "-", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum5", "\[Conjugate]"]}], "+", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}]}], "+", 
            RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}]}], "+", 
            RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum16", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}]}], "-", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}]}], "+", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}]}], "-", 
            RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum36", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "8"}], " ", "Abb15", " ", "\[Pi]", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"16", " ", "Abb15", " ", "\[Pi]", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"32", " ", "AbbSum16", " ", "\[Pi]", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"16", " ", "Abb1", " ", "\[Pi]", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"8", " ", "Abb1", " ", "\[Pi]", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"32", " ", "AbbSum26", " ", "\[Pi]", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"8", " ", "AbbSum1", " ", "\[Pi]", " ", "Alfas"}], "-", 
            RowBox[{"8", " ", "AbbSum3", " ", "\[Pi]", " ", "Alfas"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum1", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", 
             SuperscriptBox["AbbSum2", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum5", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", 
             SuperscriptBox["AbbSum6", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "T", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "U", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum10", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"48", " ", "GS", " ", 
             SuperscriptBox["AbbSum11", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"48", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum8", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum9", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "U", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "T", " ", "U", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum28", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum29", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum30", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"48", " ", "GS", " ", 
             SuperscriptBox["AbbSum31", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}]}], ")"}]}]}], ")"}]}], 
      "-", 
      RowBox[{
       FractionBox["4", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12", " ", "AbbSum4", " ", "CG", " ", "GS"}], "+", 
            RowBox[{"12", " ", "AbbSum6", " ", "CG", " ", "GS"}], "+", 
            RowBox[{"12", " ", "AbbSum3", " ", "CG", " ", "T", " ", "GS"}], 
            "+", 
            RowBox[{"12", " ", "AbbSum5", " ", "CG", " ", "U", " ", "GS"}], 
            "+", 
            RowBox[{"48", " ", "AbbSum21", " ", "CG", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum20", " ", "CG", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum18", " ", "CG", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"12", " ", "Abb1", " ", "CG", " ", "S", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum19", " ", "CG", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"12", " ", "Abb1", " ", "CG", " ", "T", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"48", " ", "AbbSum31", " ", "CG", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum30", " ", "CG", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum29", " ", "CG", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum28", " ", "CG", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"12", " ", "Abb2", " ", "CG", " ", "S", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"12", " ", "Abb2", " ", "CG", " ", "T", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum1", "\[Conjugate]"]}], "-", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum5", "\[Conjugate]"]}], "+", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}]}], "+", 
            RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}]}], "+", 
            RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum16", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}]}], "-", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}]}], "+", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}]}], "-", 
            RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum36", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", "Abb1", " ", "\[Pi]", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"8", " ", "Abb1", " ", "\[Pi]", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"32", " ", "AbbSum26", " ", "\[Pi]", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"32", " ", "AbbSum36", " ", "\[Pi]", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"8", " ", "AbbSum3", " ", "\[Pi]", " ", "Alfas"}], "+", 
            RowBox[{"8", " ", "AbbSum5", " ", "\[Pi]", " ", "Alfas"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum1", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", 
             SuperscriptBox["AbbSum2", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum5", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", 
             SuperscriptBox["AbbSum6", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "T", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "U", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum10", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"48", " ", "GS", " ", 
             SuperscriptBox["AbbSum11", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"48", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum8", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum9", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "U", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "T", " ", "U", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum28", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum29", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum30", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"48", " ", "GS", " ", 
             SuperscriptBox["AbbSum31", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{
       FractionBox["23", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12", " ", "AbbSum2", " ", "CG", " ", "GS"}], "-", 
            RowBox[{"12", " ", "AbbSum6", " ", "CG", " ", "GS"}], "+", 
            RowBox[{"12", " ", "AbbSum1", " ", "CG", " ", "S", " ", "GS"}], 
            "-", 
            RowBox[{"12", " ", "AbbSum5", " ", "CG", " ", "U", " ", "GS"}], 
            "+", 
            RowBox[{"48", " ", "AbbSum11", " ", "CG", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"48", " ", "AbbSum8", " ", "CG", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum10", " ", "CG", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"12", " ", "Abb15", " ", "CG", " ", "S", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum9", " ", "CG", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"12", " ", "Abb15", " ", "CG", " ", "S", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"48", " ", "AbbSum31", " ", "CG", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum30", " ", "CG", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum29", " ", "CG", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum28", " ", "CG", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"12", " ", "Abb2", " ", "CG", " ", "S", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"12", " ", "Abb2", " ", "CG", " ", "T", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum1", "\[Conjugate]"]}], "-", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum5", "\[Conjugate]"]}], "+", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}]}], "+", 
            RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}]}], "+", 
            RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum16", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}]}], "-", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}]}], "+", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}]}], "-", 
            RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum36", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", "Abb15", " ", "\[Pi]", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"16", " ", "Abb15", " ", "\[Pi]", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"32", " ", "AbbSum16", " ", "\[Pi]", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"32", " ", "AbbSum36", " ", "\[Pi]", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"8", " ", "AbbSum1", " ", "\[Pi]", " ", "Alfas"}], "-", 
            RowBox[{"8", " ", "AbbSum5", " ", "\[Pi]", " ", "Alfas"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum1", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", 
             SuperscriptBox["AbbSum2", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum5", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", 
             SuperscriptBox["AbbSum6", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "T", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "U", " ", 
             SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum10", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"48", " ", "GS", " ", 
             SuperscriptBox["AbbSum11", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"48", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum8", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum9", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "U", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "T", " ", "U", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum28", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum29", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"24", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum30", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"48", " ", "GS", " ", 
             SuperscriptBox["AbbSum31", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}]}], ")"}]}]}], ")"}]}], 
      "-", 
      RowBox[{
       FractionBox["4", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "12"}], " ", "AbbSum2", " ", "CG", " ", "GS"}], "-",
             
            RowBox[{"12", " ", "AbbSum4", " ", "CG", " ", "GS"}], "-", 
            RowBox[{"12", " ", "AbbSum1", " ", "CG", " ", "S", " ", "GS"}], 
            "-", 
            RowBox[{"12", " ", "AbbSum3", " ", "CG", " ", "T", " ", "GS"}], 
            "-", 
            RowBox[{"48", " ", "AbbSum11", " ", "CG", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"48", " ", "AbbSum8", " ", "CG", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum10", " ", "CG", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"12", " ", "Abb15", " ", "CG", " ", "S", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum9", " ", "CG", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"12", " ", "Abb15", " ", "CG", " ", "S", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"48", " ", "AbbSum21", " ", "CG", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum20", " ", "CG", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum18", " ", "CG", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"12", " ", "Abb1", " ", "CG", " ", "S", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum19", " ", "CG", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"12", " ", "Abb1", " ", "CG", " ", "T", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum3", "\[Conjugate]"]}], "+", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum5", "\[Conjugate]"]}], "+", 
            RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}]}], "+", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}]}], "+", 
            RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum26", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}]}], "+", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}]}], "-", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}]}], "+", 
            RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum36", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "8"}], " ", "Abb15", " ", "\[Pi]", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"16", " ", "Abb15", " ", "\[Pi]", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"32", " ", "AbbSum16", " ", "\[Pi]", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"16", " ", "Abb1", " ", "\[Pi]", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"8", " ", "Abb1", " ", "\[Pi]", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"32", " ", "AbbSum26", " ", "\[Pi]", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"8", " ", "AbbSum1", " ", "\[Pi]", " ", "Alfas"}], "-", 
            RowBox[{"8", " ", "AbbSum3", " ", "\[Pi]", " ", "Alfas"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum3", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", 
             SuperscriptBox["AbbSum4", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum5", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", 
             SuperscriptBox["AbbSum6", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "T", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "T", " ", "U", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum18", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum19", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum20", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"48", " ", "GS", " ", 
             SuperscriptBox["AbbSum21", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "U", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "T", " ", "U", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum28", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum29", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum30", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"48", " ", "GS", " ", 
             SuperscriptBox["AbbSum31", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{
       FractionBox["23", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12", " ", "AbbSum4", " ", "CG", " ", "GS"}], "+", 
            RowBox[{"12", " ", "AbbSum6", " ", "CG", " ", "GS"}], "+", 
            RowBox[{"12", " ", "AbbSum3", " ", "CG", " ", "T", " ", "GS"}], 
            "+", 
            RowBox[{"12", " ", "AbbSum5", " ", "CG", " ", "U", " ", "GS"}], 
            "+", 
            RowBox[{"48", " ", "AbbSum21", " ", "CG", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum20", " ", "CG", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum18", " ", "CG", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"12", " ", "Abb1", " ", "CG", " ", "S", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum19", " ", "CG", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"12", " ", "Abb1", " ", "CG", " ", "T", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"48", " ", "AbbSum31", " ", "CG", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum30", " ", "CG", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum29", " ", "CG", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum28", " ", "CG", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"12", " ", "Abb2", " ", "CG", " ", "S", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"12", " ", "Abb2", " ", "CG", " ", "T", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum3", "\[Conjugate]"]}], "+", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum5", "\[Conjugate]"]}], "+", 
            RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}]}], "+", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}]}], "+", 
            RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum26", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}]}], "+", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}]}], "-", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}]}], "+", 
            RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum36", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", "Abb1", " ", "\[Pi]", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"8", " ", "Abb1", " ", "\[Pi]", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"32", " ", "AbbSum26", " ", "\[Pi]", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"32", " ", "AbbSum36", " ", "\[Pi]", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"8", " ", "AbbSum3", " ", "\[Pi]", " ", "Alfas"}], "+", 
            RowBox[{"8", " ", "AbbSum5", " ", "\[Pi]", " ", "Alfas"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum3", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", 
             SuperscriptBox["AbbSum4", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum5", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", 
             SuperscriptBox["AbbSum6", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "T", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "T", " ", "U", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum18", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum19", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum20", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"48", " ", "GS", " ", 
             SuperscriptBox["AbbSum21", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "U", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "T", " ", "U", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum28", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum29", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum30", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"48", " ", "GS", " ", 
             SuperscriptBox["AbbSum31", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}]}], ")"}]}]}], ")"}]}], 
      "-", 
      RowBox[{
       FractionBox["4", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12", " ", "AbbSum2", " ", "CG", " ", "GS"}], "-", 
            RowBox[{"12", " ", "AbbSum6", " ", "CG", " ", "GS"}], "+", 
            RowBox[{"12", " ", "AbbSum1", " ", "CG", " ", "S", " ", "GS"}], 
            "-", 
            RowBox[{"12", " ", "AbbSum5", " ", "CG", " ", "U", " ", "GS"}], 
            "+", 
            RowBox[{"48", " ", "AbbSum11", " ", "CG", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"48", " ", "AbbSum8", " ", "CG", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum10", " ", "CG", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"12", " ", "Abb15", " ", "CG", " ", "S", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"24", " ", "AbbSum9", " ", "CG", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"12", " ", "Abb15", " ", "CG", " ", "S", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"48", " ", "AbbSum31", " ", "CG", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum30", " ", "CG", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum29", " ", "CG", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"24", " ", "AbbSum28", " ", "CG", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "+", 
            RowBox[{"12", " ", "Abb2", " ", "CG", " ", "S", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}], "-", 
            RowBox[{"12", " ", "Abb2", " ", "CG", " ", "T", " ", "U", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "GS"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum3", "\[Conjugate]"]}], "+", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum5", "\[Conjugate]"]}], "+", 
            RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}]}], "+", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}]}], "+", 
            RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum26", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}]}], "+", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}]}], "-", 
            RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}]}], "+", 
            RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
             SuperscriptBox["AbbSum36", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", "Abb15", " ", "\[Pi]", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"16", " ", "Abb15", " ", "\[Pi]", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"32", " ", "AbbSum16", " ", "\[Pi]", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "S", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "T", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
            RowBox[{"32", " ", "AbbSum36", " ", "\[Pi]", " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
            RowBox[{"8", " ", "AbbSum1", " ", "\[Pi]", " ", "Alfas"}], "-", 
            RowBox[{"8", " ", "AbbSum5", " ", "\[Pi]", " ", "Alfas"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum3", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", 
             SuperscriptBox["AbbSum4", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum5", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", 
             SuperscriptBox["AbbSum6", "\[Conjugate]"], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "T", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "T", " ", "U", " ", 
             SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum18", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum19", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum20", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"48", " ", "GS", " ", 
             SuperscriptBox["AbbSum21", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"T", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"12", " ", "GS", " ", "S", " ", "U", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"12", " ", "GS", " ", "T", " ", "U", " ", 
             SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "U", " ", 
             SuperscriptBox["AbbSum28", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "T", " ", 
             SuperscriptBox["AbbSum29", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "-", 
            RowBox[{"24", " ", "GS", " ", "S", " ", 
             SuperscriptBox["AbbSum30", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}], "+", 
            RowBox[{"48", " ", "GS", " ", 
             SuperscriptBox["AbbSum31", "\[Conjugate]"], " ", 
             RowBox[{"Den", "(", 
              RowBox[{"U", ",", "0"}], ")"}], " ", 
             SuperscriptBox["CG", "\[Conjugate]"]}]}], ")"}]}]}], ")"}]}]}], 
     ")"}], " ", 
    SuperscriptBox["Linv", "2"]}], "+", 
   RowBox[{
    FractionBox["23", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "8"}], " ", "Abb15", " ", "\[Pi]", " ", "S", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"16", " ", "Abb15", " ", "\[Pi]", " ", "T", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"32", " ", "AbbSum16", " ", "\[Pi]", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"16", " ", "Abb1", " ", "\[Pi]", " ", "S", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"8", " ", "Abb1", " ", "\[Pi]", " ", "T", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"32", " ", "AbbSum26", " ", "\[Pi]", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"8", " ", "AbbSum1", " ", "\[Pi]", " ", "Alfas"}], "-", 
      RowBox[{"8", " ", "AbbSum3", " ", "\[Pi]", " ", "Alfas"}]}], ")"}], " ",
     
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "8"}], " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum1", "\[Conjugate]"]}], "-", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum3", "\[Conjugate]"]}], "-", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
       SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}]}], "-", 
      RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
       SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}]}], "-", 
      RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum16", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}]}], "-", 
      RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
       SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}]}], "-", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
       SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}]}], "-", 
      RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum26", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}]}]}], ")"}]}], "-", 
   RowBox[{
    FractionBox["4", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "8"}], " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum1", "\[Conjugate]"]}], "-", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum3", "\[Conjugate]"]}], "-", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
       SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}]}], "-", 
      RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
       SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}]}], "-", 
      RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum16", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}]}], "-", 
      RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
       SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}]}], "-", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
       SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}]}], "-", 
      RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum26", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"16", " ", "Abb1", " ", "\[Pi]", " ", "S", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"8", " ", "Abb1", " ", "\[Pi]", " ", "T", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"32", " ", "AbbSum26", " ", "\[Pi]", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "S", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "T", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"32", " ", "AbbSum36", " ", "\[Pi]", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"8", " ", "AbbSum3", " ", "\[Pi]", " ", "Alfas"}], "+", 
      RowBox[{"8", " ", "AbbSum5", " ", "\[Pi]", " ", "Alfas"}]}], ")"}]}], 
   "-", 
   RowBox[{
    FractionBox["4", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "8"}], " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum1", "\[Conjugate]"]}], "-", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum3", "\[Conjugate]"]}], "-", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
       SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}]}], "-", 
      RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
       SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}]}], "-", 
      RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum16", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}]}], "-", 
      RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
       SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}]}], "-", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
       SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}]}], "-", 
      RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum26", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", "Abb15", " ", "\[Pi]", " ", "S", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"16", " ", "Abb15", " ", "\[Pi]", " ", "T", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"32", " ", "AbbSum16", " ", "\[Pi]", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "S", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "T", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"32", " ", "AbbSum36", " ", "\[Pi]", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"8", " ", "AbbSum1", " ", "\[Pi]", " ", "Alfas"}], "-", 
      RowBox[{"8", " ", "AbbSum5", " ", "\[Pi]", " ", "Alfas"}]}], ")"}]}], 
   "-", 
   RowBox[{
    FractionBox["4", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "8"}], " ", "Abb15", " ", "\[Pi]", " ", "S", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"16", " ", "Abb15", " ", "\[Pi]", " ", "T", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"32", " ", "AbbSum16", " ", "\[Pi]", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"16", " ", "Abb1", " ", "\[Pi]", " ", "S", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"8", " ", "Abb1", " ", "\[Pi]", " ", "T", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"32", " ", "AbbSum26", " ", "\[Pi]", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"8", " ", "AbbSum1", " ", "\[Pi]", " ", "Alfas"}], "-", 
      RowBox[{"8", " ", "AbbSum3", " ", "\[Pi]", " ", "Alfas"}]}], ")"}], " ",
     
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum1", "\[Conjugate]"]}], "-", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum5", "\[Conjugate]"]}], "+", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
       SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}]}], "+", 
      RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
       SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}]}], "+", 
      RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum16", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}]}], "-", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
       SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}]}], "+", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
       SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}]}], "-", 
      RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum36", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}]}]}], ")"}]}], "-", 
   RowBox[{
    FractionBox["4", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"16", " ", "Abb1", " ", "\[Pi]", " ", "S", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"8", " ", "Abb1", " ", "\[Pi]", " ", "T", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"32", " ", "AbbSum26", " ", "\[Pi]", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "S", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "T", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"32", " ", "AbbSum36", " ", "\[Pi]", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"8", " ", "AbbSum3", " ", "\[Pi]", " ", "Alfas"}], "+", 
      RowBox[{"8", " ", "AbbSum5", " ", "\[Pi]", " ", "Alfas"}]}], ")"}], " ",
     
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum1", "\[Conjugate]"]}], "-", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum5", "\[Conjugate]"]}], "+", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
       SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}]}], "+", 
      RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
       SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}]}], "+", 
      RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum16", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}]}], "-", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
       SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}]}], "+", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
       SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}]}], "-", 
      RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum36", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}]}]}], ")"}]}], "+", 
   RowBox[{
    FractionBox["23", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", "Abb15", " ", "\[Pi]", " ", "S", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"16", " ", "Abb15", " ", "\[Pi]", " ", "T", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"32", " ", "AbbSum16", " ", "\[Pi]", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "S", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "T", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"32", " ", "AbbSum36", " ", "\[Pi]", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"8", " ", "AbbSum1", " ", "\[Pi]", " ", "Alfas"}], "-", 
      RowBox[{"8", " ", "AbbSum5", " ", "\[Pi]", " ", "Alfas"}]}], ")"}], " ",
     
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum1", "\[Conjugate]"]}], "-", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum5", "\[Conjugate]"]}], "+", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
       SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}]}], "+", 
      RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
       SuperscriptBox["Abb15", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}]}], "+", 
      RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum16", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}]}], "-", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
       SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}]}], "+", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
       SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}]}], "-", 
      RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum36", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}]}]}], ")"}]}], "-", 
   RowBox[{
    FractionBox["4", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "8"}], " ", "Abb15", " ", "\[Pi]", " ", "S", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"16", " ", "Abb15", " ", "\[Pi]", " ", "T", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"32", " ", "AbbSum16", " ", "\[Pi]", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"16", " ", "Abb1", " ", "\[Pi]", " ", "S", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"8", " ", "Abb1", " ", "\[Pi]", " ", "T", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"32", " ", "AbbSum26", " ", "\[Pi]", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"8", " ", "AbbSum1", " ", "\[Pi]", " ", "Alfas"}], "-", 
      RowBox[{"8", " ", "AbbSum3", " ", "\[Pi]", " ", "Alfas"}]}], ")"}], " ",
     
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum3", "\[Conjugate]"]}], "+", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum5", "\[Conjugate]"]}], "+", 
      RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
       SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}]}], "+", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
       SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}]}], "+", 
      RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum26", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}]}], "+", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
       SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}]}], "-", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
       SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}]}], "+", 
      RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum36", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}]}]}], ")"}]}], "+", 
   RowBox[{
    FractionBox["23", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"16", " ", "Abb1", " ", "\[Pi]", " ", "S", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"8", " ", "Abb1", " ", "\[Pi]", " ", "T", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"32", " ", "AbbSum26", " ", "\[Pi]", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "S", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "T", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"32", " ", "AbbSum36", " ", "\[Pi]", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"8", " ", "AbbSum3", " ", "\[Pi]", " ", "Alfas"}], "+", 
      RowBox[{"8", " ", "AbbSum5", " ", "\[Pi]", " ", "Alfas"}]}], ")"}], " ",
     
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum3", "\[Conjugate]"]}], "+", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum5", "\[Conjugate]"]}], "+", 
      RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
       SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}]}], "+", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
       SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}]}], "+", 
      RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum26", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}]}], "+", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
       SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}]}], "-", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
       SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}]}], "+", 
      RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum36", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}]}]}], ")"}]}], "-", 
   RowBox[{
    FractionBox["4", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", "Abb15", " ", "\[Pi]", " ", "S", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"16", " ", "Abb15", " ", "\[Pi]", " ", "T", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"32", " ", "AbbSum16", " ", "\[Pi]", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"S", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "S", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"8", " ", "Abb2", " ", "\[Pi]", " ", "T", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "-", 
      RowBox[{"32", " ", "AbbSum36", " ", "\[Pi]", " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}], " ", "Alfas"}], "+", 
      RowBox[{"8", " ", "AbbSum1", " ", "\[Pi]", " ", "Alfas"}], "-", 
      RowBox[{"8", " ", "AbbSum5", " ", "\[Pi]", " ", "Alfas"}]}], ")"}], " ",
     
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum3", "\[Conjugate]"]}], "+", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum5", "\[Conjugate]"]}], "+", 
      RowBox[{"16", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
       SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}]}], "+", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
       SuperscriptBox["Abb1", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}]}], "+", 
      RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum26", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "0"}], ")"}]}], "+", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "S", " ", 
       SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}]}], "-", 
      RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", "T", " ", 
       SuperscriptBox["Abb2", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}]}], "+", 
      RowBox[{"32", " ", "Alfas", " ", "\[Pi]", " ", 
       SuperscriptBox["AbbSum36", "\[Conjugate]"], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"U", ",", "0"}], ")"}]}]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.500274866220201*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mgg4", "=", 
   RowBox[{"PolarizationSum", "[", "Mgg3", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.479118824157723*^9, 3.479118845390859*^9}, 
   3.479184075522476*^9, 3.479184702412253*^9, {3.479184749867283*^9, 
   3.479184750460338*^9}, {3.479189331731915*^9, 3.479189334149471*^9}, 
   3.479189365494795*^9, {3.499668236444878*^9, 3.4996682500534763`*^9}, 
   3.4996812040209303`*^9, {3.500119934667719*^9, 3.500119939113467*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.50012517444248*^9, 3.5001848869617853`*^9, 3.5001853366222754`*^9, 
  3.500186870653371*^9, 3.500273821073915*^9, 3.500273979388956*^9, 
  3.500274683433713*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.50012517444248*^9, 3.5001848869617853`*^9, 3.5001853366222754`*^9, 
  3.500186870653371*^9, 3.500273821073915*^9, 3.500273979388956*^9, 
  3.500274683448681*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.50012517444248*^9, 3.5001848869617853`*^9, 3.5001853366222754`*^9, 
  3.500186870653371*^9, 3.500273821073915*^9, 3.500273979388956*^9, 
  3.500274683735224*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.50012517444248*^9, 3.5001848869617853`*^9, 3.5001853366222754`*^9, 
  3.500186870653371*^9, 3.500273821073915*^9, 3.500273979388956*^9, 
  3.50027471677721*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Mgg4", "//.", 
      RowBox[{"Abbr", "[", "]"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Den", "[", 
        RowBox[{"a_", ",", "b_"}], "]"}], "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"a", "-", "b"}], ")"}]}]}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{"U", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "S"}], "-", "T"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.500273982633992*^9, 3.500274012624769*^9}, {
  3.500274256966009*^9, 3.500274288723185*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"18432", " ", "Alfas2", " ", 
    SuperscriptBox["\[Pi]", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["S", "2"], "+", 
       RowBox[{"T", " ", "S"}], "+", 
       SuperscriptBox["T", "2"]}], ")"}], "3"]}], 
   RowBox[{
    SuperscriptBox["S", "2"], " ", 
    SuperscriptBox["T", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"S", "+", "T"}], ")"}], "2"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.500273985213876*^9, 3.500274078112899*^9, {3.5002743205709133`*^9, 
   3.50027432452804*^9}, 3.5002748049675627`*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"18432", " ", "Alfas2", " ", 
    SuperscriptBox["\[Pi]", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["S", "2"], "+", 
       RowBox[{"T", " ", "S"}], "+", 
       SuperscriptBox["T", "2"]}], ")"}], "3"]}], 
   RowBox[{
    SuperscriptBox["S", "2"], " ", 
    SuperscriptBox["T", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"S", "+", "T"}], ")"}], "2"]}]], TraditionalForm]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mgg5", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Normal", "[", 
      RowBox[{"Series", "[", 
       RowBox[{"Mgg4", ",", 
        RowBox[{"{", 
         RowBox[{"Linv", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}], "//.", 
     RowBox[{"Abbr", "[", "]"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Den", "[", 
       RowBox[{"a_", ",", "b_"}], "]"}], "\[Rule]", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "-", "b"}], ")"}]}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.500121033903965*^9, 3.500121114625811*^9}, {
   3.5001211824541607`*^9, 3.5001212364853497`*^9}, 3.500121270669372*^9, {
   3.5001215329435596`*^9, 3.5001215499458303`*^9}, 3.5002738378357897`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"3", " ", "GS", " ", 
      SuperscriptBox["S", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"MT2", "-", "T"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}], "2"]}]], 
    RowBox[{"128", " ", "Alfas2", " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"9", " ", 
        SuperscriptBox["MT2", "2"]}], "-", 
       RowBox[{"9", " ", 
        RowBox[{"(", 
         RowBox[{"S", "+", 
          RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["S", "2"]}], "+", 
       RowBox[{"9", " ", 
        SuperscriptBox["T", "2"]}], "+", 
       RowBox[{"9", " ", "S", " ", "T"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"GS", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["MT2", "4"]}], "-", 
          RowBox[{"8", " ", "T", " ", 
           SuperscriptBox["MT2", "3"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["S", "2"]}], "+", 
             RowBox[{"4", " ", "T", " ", "S"}], "+", 
             RowBox[{"12", " ", 
              SuperscriptBox["T", "2"]}]}], ")"}], " ", 
           SuperscriptBox["MT2", "2"]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["S", "3"], "+", 
             RowBox[{"2", " ", "T", " ", 
              SuperscriptBox["S", "2"]}], "+", 
             RowBox[{"8", " ", 
              SuperscriptBox["T", "2"], " ", "S"}], "+", 
             RowBox[{"8", " ", 
              SuperscriptBox["T", "3"]}]}], ")"}], " ", "MT2"}], "+", 
          RowBox[{"T", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", "T"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["S", "2"], "+", 
             RowBox[{"2", " ", "T", " ", "S"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["T", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
       RowBox[{"4", " ", 
        SqrtBox["2"], " ", 
        SuperscriptBox["Linv", "2"], " ", "MT", " ", 
        SuperscriptBox["S", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"MT2", "-", "T"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}], " ", "v", " ", 
        RowBox[{"Re", "(", "CtG", ")"}]}]}], ")"}]}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.500121036185227*^9, 3.500121128547367*^9, 3.500121203492289*^9, {
   3.500121256618002*^9, 3.5001212748748693`*^9}, {3.500121542945138*^9, 
   3.500121555852314*^9}, 3.500125179787794*^9, 3.500184899087121*^9, 
   3.500185339312373*^9, 3.500186882665247*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Coefficient", "[", 
      RowBox[{"Mgg5", ",", "Linv", ",", "2"}], "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Alfas2", "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"gS", "^", "2"}], "/", 
           RowBox[{"(", 
            RowBox[{"4", "\[Pi]"}], ")"}]}], ")"}], "^", "2"}]}], ",", 
       RowBox[{"GS", "\[Rule]", "gS"}]}], "}"}]}], "]"}], "/", "256"}], "*", 
  "4"}]], "Input",
 CellChangeTimes->{{3.50012203175807*^9, 3.500122085944367*^9}, {
  3.500186303411706*^9, 3.500186330919297*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    SuperscriptBox["gS", "3"], " ", "MT", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"9", " ", 
       SuperscriptBox["MT2", "2"]}], "-", 
      RowBox[{"9", " ", 
       RowBox[{"(", 
        RowBox[{"S", "+", 
         RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["S", "2"]}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["T", "2"]}], "+", 
      RowBox[{"9", " ", "S", " ", "T"}]}], ")"}], " ", "v", " ", 
    RowBox[{"Re", "(", "CtG", ")"}]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    RowBox[{"(", 
     RowBox[{"MT2", "-", "T"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}]}]], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.500122086278297*^9, 3.5001251802730503`*^9, 
  3.500184902946899*^9, 3.5001853459062643`*^9, 3.5001863317168818`*^9, 
  3.500186883040023*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Mgg3phiG", "=", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Mgg2", "/.", "M$FACouplings"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Conjugate", "[", "CphiG", "]"}], "->", "CphiG"}], ",", 
          RowBox[{"CtG", "->", "0"}], ",", 
          RowBox[{"CG", "\[Rule]", "0"}], ",", 
          RowBox[{"Lambda", "\[Rule]", 
           RowBox[{"1", "/", "Linv"}]}], ",", 
          RowBox[{
           RowBox[{"Conjugate", "[", "Lambda", "]"}], "->", 
           RowBox[{"1", "/", "Linv"}]}], ",", 
          RowBox[{
           RowBox[{"Conjugate", "[", "v", "]"}], "\[Rule]", "v"}]}], "}"}]}], 
       "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Linv", "^", "4"}], "\[Rule]", "0"}], ",", 
         RowBox[{
          RowBox[{"Linv", "^", "6"}], "\[Rule]", "0"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"Linv", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.500120264683782*^9, 3.500120270634116*^9}, {
  3.50012037229132*^9, 3.500120418987548*^9}, {3.5001206930421867`*^9, 
  3.500120721959036*^9}, {3.500120848018794*^9, 3.500120861852392*^9}, {
  3.5001209888233223`*^9, 3.5001209942671537`*^9}, {3.500123028422268*^9, 
  3.500123032939645*^9}, {3.500125188809121*^9, 3.5001251953886423`*^9}, {
  3.500125229712288*^9, 3.500125249872898*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mgg4phiG", "=", 
   RowBox[{"PolarizationSum", "[", "Mgg3phiG", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.479118824157723*^9, 3.479118845390859*^9}, 
   3.479184075522476*^9, 3.479184702412253*^9, {3.479184749867283*^9, 
   3.479184750460338*^9}, {3.479189331731915*^9, 3.479189334149471*^9}, 
   3.479189365494795*^9, {3.499668236444878*^9, 3.4996682500534763`*^9}, 
   3.4996812040209303`*^9, {3.500119934667719*^9, 3.500119939113467*^9}, {
   3.5001231035869923`*^9, 3.5001231093806458`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.5001231134286337`*^9, 3.500125204793819*^9, 3.500125265844116*^9, 
  3.500184914061057*^9, 3.500185355437488*^9, 3.50018689154836*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc10.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc10.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.5001231134286337`*^9, 3.500125204793819*^9, 3.500125265844116*^9, 
  3.500184914061057*^9, 3.500185355437488*^9, 3.500186891569847*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.5001231134286337`*^9, 3.500125204793819*^9, 3.500125265844116*^9, 
  3.500184914061057*^9, 3.500185355437488*^9, 3.5001868918217487`*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.5001231134286337`*^9, 3.500125204793819*^9, 3.500125265844116*^9, 
  3.500184914061057*^9, 3.500185355437488*^9, 3.5001868921228857`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mgg5phiG", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Normal", "[", 
       RowBox[{"Series", "[", 
        RowBox[{"Mgg4phiG", ",", 
         RowBox[{"{", 
          RowBox[{"Linv", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}], "//.", 
      
      RowBox[{"Abbr", "[", "]"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Den", "[", 
        RowBox[{"a_", ",", "b_"}], "]"}], "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"a", "-", "b"}], ")"}]}]}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{"U", "\[Rule]", 
      RowBox[{
       RowBox[{"2", "MT2"}], "-", "S", "-", "T"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.500121033903965*^9, 3.500121114625811*^9}, {
   3.5001211824541607`*^9, 3.5001212364853497`*^9}, 3.500121270669372*^9, {
   3.5001215329435596`*^9, 3.5001215499458303`*^9}, {3.500123112825931*^9, 
   3.500123116191039*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"32", " ", "\[Pi]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SqrtBox["2"], " ", "Alfas", " ", "CphiG", " ", 
        SuperscriptBox["Linv", "2"], " ", "MT", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "MT2"}], "-", "S"}], ")"}], " ", 
        SuperscriptBox["S", "4"], " ", 
        RowBox[{"(", 
         RowBox[{"MT2", "-", "T"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"MT2", "-", "S", "-", "T"}], ")"}], " ", "v", " ", 
        RowBox[{"Re", "(", "yt", ")"}]}], "-", 
       RowBox[{"4", " ", "Alfas2", " ", "\[Pi]", " ", 
        RowBox[{"(", 
         RowBox[{"MH2", "-", "S"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"9", " ", 
           SuperscriptBox["MT2", "2"]}], "-", 
          RowBox[{"9", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", 
             RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["S", "2"]}], "+", 
          RowBox[{"9", " ", 
           SuperscriptBox["T", "2"]}], "+", 
          RowBox[{"9", " ", "S", " ", "T"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["MT2", "4"]}], "-", 
          RowBox[{"8", " ", "T", " ", 
           SuperscriptBox["MT2", "3"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["S", "2"]}], "+", 
             RowBox[{"4", " ", "T", " ", "S"}], "+", 
             RowBox[{"12", " ", 
              SuperscriptBox["T", "2"]}]}], ")"}], " ", 
           SuperscriptBox["MT2", "2"]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["S", "3"], "+", 
             RowBox[{"2", " ", "T", " ", 
              SuperscriptBox["S", "2"]}], "+", 
             RowBox[{"8", " ", 
              SuperscriptBox["T", "2"], " ", "S"}], "+", 
             RowBox[{"8", " ", 
              SuperscriptBox["T", "3"]}]}], ")"}], " ", "MT2"}], "+", 
          RowBox[{"T", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", "T"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["S", "2"], "+", 
             RowBox[{"2", " ", "T", " ", "S"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["T", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
    ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{"MH2", "-", "S"}], ")"}], " ", 
     SuperscriptBox["S", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"MT2", "-", "T"}], ")"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}], "2"]}], ")"}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.500121036185227*^9, 3.500121128547367*^9, 3.500121203492289*^9, {
   3.500121256618002*^9, 3.5001212748748693`*^9}, {3.500121542945138*^9, 
   3.500121555852314*^9}, 3.50012423264614*^9, 3.5001252104076347`*^9, 
   3.500125376363772*^9, 3.500184918396678*^9, 3.500185363954321*^9, 
   3.500186900292087*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"Coefficient", "[", 
      RowBox[{"Mgg5phiG", ",", "Linv", ",", "2"}], "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Alfas", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"gS", "^", "2"}], "/", 
          RowBox[{"(", 
           RowBox[{"4", "\[Pi]"}], ")"}]}], ")"}]}], ",", 
       RowBox[{"GS", "\[Rule]", "gS"}]}], "}"}]}], "]"}], "/", "256"}], "*", 
  "4"}]], "Input",
 CellChangeTimes->{{3.50012203175807*^9, 3.500122085944367*^9}, 
   3.5001231183600893`*^9, {3.500125033132867*^9, 3.500125044530876*^9}, {
   3.5001251127394114`*^9, 3.5001251219076443`*^9}, {3.5001255153819227`*^9, 
   3.500125517885804*^9}, 3.500184925533991*^9, {3.500186199611189*^9, 
   3.50018621277183*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"CphiG", " ", 
    SuperscriptBox["gS", "2"], " ", "MT", " ", 
    SuperscriptBox["S", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"S", "-", 
      RowBox[{"4", " ", "MT2"}]}], ")"}], " ", "v", " ", 
    RowBox[{"Re", "(", "yt", ")"}]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"], " ", 
    RowBox[{"(", 
     RowBox[{"MH2", "-", "S"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"MT2", "-", "T"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}]}]], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.500122086278297*^9, 3.500125008672204*^9, 3.5001250478116302`*^9, {
   3.500125106366685*^9, 3.500125113515643*^9}, 3.5001252130924463`*^9, 
   3.500125506697605*^9, 3.500125539060231*^9, {3.5001849226453257`*^9, 
   3.5001849259513893`*^9}, 3.500185367401535*^9, 3.500186213475864*^9, 
   3.500186902364727*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Mgg3G", "=", 
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Mgg2", "/.", "M$FACouplings"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"CphiG", "\[Rule]", "0"}], ",", 
          RowBox[{"CtG", "->", "0"}], ",", 
          RowBox[{"Lambda", "\[Rule]", 
           RowBox[{"1", "/", "Linv"}]}], ",", 
          RowBox[{
           RowBox[{"Conjugate", "[", "Lambda", "]"}], "->", 
           RowBox[{"1", "/", "Linv"}]}], ",", 
          RowBox[{
           RowBox[{"Conjugate", "[", "v", "]"}], "\[Rule]", "v"}]}], "}"}]}], 
       "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Linv", "^", "4"}], "\[Rule]", "0"}], ",", 
         RowBox[{
          RowBox[{"Linv", "^", "6"}], "\[Rule]", "0"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"Linv", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.500120264683782*^9, 3.500120270634116*^9}, {
  3.50012037229132*^9, 3.500120418987548*^9}, {3.5001206930421867`*^9, 
  3.500120721959036*^9}, {3.500120848018794*^9, 3.500120861852392*^9}, {
  3.5001209888233223`*^9, 3.5001209942671537`*^9}, {3.500123028422268*^9, 
  3.500123032939645*^9}, {3.500125188809121*^9, 3.5001251953886423`*^9}, {
  3.500125229712288*^9, 3.500125249872898*^9}, {3.500125316928153*^9, 
  3.500125331580917*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mgg4G", "=", 
   RowBox[{"PolarizationSum", "[", "Mgg3G", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.479118824157723*^9, 3.479118845390859*^9}, 
   3.479184075522476*^9, 3.479184702412253*^9, {3.479184749867283*^9, 
   3.479184750460338*^9}, {3.479189331731915*^9, 3.479189334149471*^9}, 
   3.479189365494795*^9, {3.499668236444878*^9, 3.4996682500534763`*^9}, 
   3.4996812040209303`*^9, {3.500119934667719*^9, 3.500119939113467*^9}, {
   3.5001231035869923`*^9, 3.5001231093806458`*^9}, {3.5001253379428*^9, 
   3.500125341447617*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.5001231134286337`*^9, 3.500125204793819*^9, 3.500125265844116*^9, 
  3.5001255634304533`*^9, 3.500184943185277*^9, 3.500185549151003*^9, 
  3.5001869094329233`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc10.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc10.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.5001231134286337`*^9, 3.500125204793819*^9, 3.500125265844116*^9, 
  3.5001255634304533`*^9, 3.500184943185277*^9, 3.500185549151003*^9, 
  3.50018690945656*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.5001231134286337`*^9, 3.500125204793819*^9, 3.500125265844116*^9, 
  3.5001255634304533`*^9, 3.500184943185277*^9, 3.500185549151003*^9, 
  3.500186909765386*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4996682770892963`*^9, 3.500121011369549*^9, 
  3.5001231134286337`*^9, 3.500125204793819*^9, 3.500125265844116*^9, 
  3.5001255634304533`*^9, 3.500184943185277*^9, 3.500185549151003*^9, 
  3.500186911201947*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mgg5G", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Normal", "[", 
       RowBox[{"Series", "[", 
        RowBox[{"Mgg4G", ",", 
         RowBox[{"{", 
          RowBox[{"Linv", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}], "//.", 
      
      RowBox[{"Abbr", "[", "]"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Den", "[", 
        RowBox[{"a_", ",", "b_"}], "]"}], "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"a", "-", "b"}], ")"}]}]}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{"U", "\[Rule]", 
      RowBox[{
       RowBox[{"2", "MT2"}], "-", "S", "-", "T"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.500121033903965*^9, 3.500121114625811*^9}, {
   3.5001211824541607`*^9, 3.5001212364853497`*^9}, 3.500121270669372*^9, {
   3.5001215329435596`*^9, 3.5001215499458303`*^9}, {3.500123112825931*^9, 
   3.500123116191039*^9}, {3.5001253466558237`*^9, 3.500125350665881*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"3", " ", 
      SuperscriptBox["S", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"MT2", "-", "T"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "MT2"}], "+", "S", "+", "T"}], ")"}], "2"]}]], 
    RowBox[{"32", " ", "\[Pi]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"27", " ", "Alfas", " ", "GS", " ", 
        SuperscriptBox["Linv", "2"], " ", "MT2", " ", 
        SuperscriptBox["S", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"MT2", "-", "T"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"MT2", "-", "S", "-", "T"}], ")"}], " ", 
        RowBox[{"Re", "(", "CG", ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "MT2"}], "+", "S", "+", 
           RowBox[{"2", " ", "T"}]}], ")"}], "2"]}], "+", 
       RowBox[{"4", " ", "Alfas2", " ", "\[Pi]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"9", " ", 
           SuperscriptBox["MT2", "2"]}], "-", 
          RowBox[{"9", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", 
             RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["S", "2"]}], "+", 
          RowBox[{"9", " ", 
           SuperscriptBox["T", "2"]}], "+", 
          RowBox[{"9", " ", "S", " ", "T"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["MT2", "4"]}], "-", 
          RowBox[{"8", " ", "T", " ", 
           SuperscriptBox["MT2", "3"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["S", "2"]}], "+", 
             RowBox[{"4", " ", "T", " ", "S"}], "+", 
             RowBox[{"12", " ", 
              SuperscriptBox["T", "2"]}]}], ")"}], " ", 
           SuperscriptBox["MT2", "2"]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["S", "3"], "+", 
             RowBox[{"2", " ", "T", " ", 
              SuperscriptBox["S", "2"]}], "+", 
             RowBox[{"8", " ", 
              SuperscriptBox["T", "2"], " ", "S"}], "+", 
             RowBox[{"8", " ", 
              SuperscriptBox["T", "3"]}]}], ")"}], " ", "MT2"}], "+", 
          RowBox[{"T", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", "T"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["S", "2"], "+", 
             RowBox[{"2", " ", "T", " ", "S"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["T", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}]}],
   TraditionalForm]], "Output",
 CellChangeTimes->{
  3.500121036185227*^9, 3.500121128547367*^9, 3.500121203492289*^9, {
   3.500121256618002*^9, 3.5001212748748693`*^9}, {3.500121542945138*^9, 
   3.500121555852314*^9}, 3.50012423264614*^9, 3.5001252104076347`*^9, 
   3.5001255716834993`*^9, 3.5001849487019444`*^9, 3.500185550528851*^9, 
   3.500185883191223*^9, 3.500186914156605*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Coefficient", "[", 
      RowBox[{"Mgg5G", ",", "Linv", ",", "2"}], "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Alfas", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"gS", "^", "2"}], "/", 
          RowBox[{"(", 
           RowBox[{"4", "\[Pi]"}], ")"}]}], ")"}]}], ",", 
       RowBox[{"GS", "\[Rule]", "gS"}]}], "}"}]}], "]"}], "/", "256"}], "*", 
  "4"}]], "Input",
 CellChangeTimes->{{3.50012203175807*^9, 3.500122085944367*^9}, 
   3.5001231183600893`*^9, {3.500125033132867*^9, 3.500125044530876*^9}, {
   3.5001251127394114`*^9, 3.5001251219076443`*^9}, 3.500125355223119*^9, 
   3.500125584230616*^9, {3.500185804733983*^9, 3.500185870357251*^9}, {
   3.500185961569396*^9, 3.500185997410247*^9}, {3.500186164189497*^9, 
   3.5001861644725027`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{"9", " ", 
     SuperscriptBox["gS", "3"], " ", "MT2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "MT2"}], "+", "S", "+", 
        RowBox[{"2", " ", "T"}]}], ")"}], "2"], " ", 
     RowBox[{"Re", "(", "CG", ")"}]}], 
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{"MT2", "-", "T"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"MT2", "-", "S", "-", "T"}], ")"}]}]]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.500122086278297*^9, 3.500125008672204*^9, 3.5001250478116302`*^9, {
   3.500125106366685*^9, 3.500125113515643*^9}, 3.5001252130924463`*^9, {
   3.500125581322969*^9, 3.500125584601881*^9}, 3.500184948920966*^9, 
   3.500185552032819*^9, 3.50018580710303*^9, {3.5001858520447702`*^9, 
   3.500185888307157*^9}, {3.500185962513139*^9, 3.500185998047577*^9}, 
   3.500186165152343*^9, 3.50018691604774*^9}]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
WindowSize->{1269, 941},
WindowMargins->{{0, Automatic}, {Automatic, 27}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{611.25, 789.5625},
"PostScriptOutputFile"->"/nfs/home/0/d/degrande/Generic/test.nb.ps"},
ShowSelection->True,
Magnification->1.25,
FrontEndVersion->"6.0 for Linux x86 (64-bit) (June 19, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 100, 1, 104, "Title"],
Cell[693, 26, 193, 2, 37, "Text"],
Cell[CellGroupData[{
Cell[911, 32, 143, 2, 65, "Subtitle"],
Cell[1057, 36, 118, 2, 38, "Input"],
Cell[CellGroupData[{
Cell[1200, 42, 353, 8, 64, "Input"],
Cell[CellGroupData[{
Cell[1578, 54, 496, 7, 30, "Print"],
Cell[2077, 63, 510, 7, 30, "Print"],
Cell[2590, 72, 546, 8, 30, "Print"],
Cell[3139, 82, 518, 7, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[3684, 93, 525, 12, 38, "Input"],
Cell[CellGroupData[{
Cell[4234, 109, 178, 3, 38, "Input"],
Cell[CellGroupData[{
Cell[4437, 116, 395, 9, 30, "Print"],
Cell[4835, 127, 392, 9, 30, "Print"],
Cell[5230, 138, 393, 9, 30, "Print"],
Cell[5626, 149, 4045, 98, 505, "Print"]
}, Open  ]],
Cell[9686, 250, 1838, 50, 79, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[11561, 305, 1830, 40, 56, "Input"],
Cell[CellGroupData[{
Cell[13416, 349, 418, 6, 30, "Print"],
Cell[13837, 357, 889, 18, 30, "Print"],
Cell[14729, 377, 434, 6, 30, "Print"],
Cell[15166, 385, 701, 13, 30, "Print"],
Cell[15870, 400, 416, 6, 30, "Print"],
Cell[16289, 408, 886, 18, 30, "Print"],
Cell[17178, 428, 735, 13, 30, "Print"],
Cell[17916, 443, 438, 6, 30, "Print"],
Cell[18357, 451, 590, 11, 30, "Print"],
Cell[18950, 464, 701, 13, 30, "Print"],
Cell[19654, 479, 416, 6, 30, "Print"],
Cell[20073, 487, 817, 15, 30, "Print"],
Cell[20893, 504, 416, 6, 30, "Print"],
Cell[21312, 512, 654, 12, 30, "Print"],
Cell[21969, 526, 686, 12, 30, "Print"],
Cell[22658, 540, 686, 12, 30, "Print"],
Cell[23347, 554, 686, 12, 30, "Print"],
Cell[24036, 568, 416, 6, 30, "Print"],
Cell[24455, 576, 817, 15, 30, "Print"],
Cell[25275, 593, 617, 11, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25941, 610, 225, 4, 38, "Input"],
Cell[CellGroupData[{
Cell[26191, 618, 626, 12, 30, "Print"],
Cell[26820, 632, 30971, 674, 505, "Print"]
}, Open  ]],
Cell[57806, 1309, 3258, 85, 79, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61101, 1399, 318, 6, 38, "Input"],
Cell[CellGroupData[{
Cell[61444, 1409, 603, 10, 30, "Print"],
Cell[62050, 1421, 863, 17, 30, "Print"],
Cell[62916, 1440, 871, 16, 30, "Print"],
Cell[63790, 1458, 802, 15, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[64641, 1479, 431, 9, 64, "Input"],
Cell[CellGroupData[{
Cell[65097, 1492, 431, 7, 30, "Print"],
Cell[65531, 1501, 443, 7, 30, "Print"],
Cell[65977, 1510, 444, 7, 30, "Print"],
Cell[66424, 1519, 452, 7, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[66925, 1532, 334, 8, 38, "Input"],
Cell[CellGroupData[{
Cell[67284, 1544, 404, 6, 30, "Print"],
Cell[67691, 1552, 692, 14, 30, "Print"],
Cell[68386, 1568, 375, 5, 30, "Print"],
Cell[68764, 1575, 406, 6, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[69219, 1587, 252, 5, 38, "Input"],
Cell[69474, 1594, 922, 22, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70433, 1621, 420, 9, 64, "Input"],
Cell[CellGroupData[{
Cell[70878, 1634, 632, 12, 30, "Print"],
Cell[71513, 1648, 426, 7, 30, "Print"],
Cell[71942, 1657, 712, 15, 30, "Print"],
Cell[72657, 1674, 397, 6, 30, "Print"],
Cell[73057, 1682, 428, 7, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[73534, 1695, 2111, 47, 114, "Input"],
Cell[75648, 1744, 15673, 405, 641, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[91358, 2154, 2655, 64, 189, "Input"],
Cell[94016, 2220, 2837, 73, 114, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[96890, 2298, 621, 19, 38, "Input"],
Cell[97514, 2319, 369, 9, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[97920, 2333, 623, 19, 38, "Input"],
Cell[98546, 2354, 413, 12, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98996, 2371, 156, 3, 38, "Input"],
Cell[99155, 2376, 411, 13, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99603, 2394, 2143, 56, 189, "Input"],
Cell[101749, 2452, 4185, 115, 149, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[105971, 2572, 257, 5, 38, "Input"],
Cell[106231, 2579, 359, 11, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[106627, 2595, 182, 4, 38, "Input"],
Cell[106812, 2601, 284, 9, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[107133, 2615, 307, 6, 38, "Input"],
Cell[107443, 2623, 409, 11, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[107889, 2639, 230, 5, 38, "Input"],
Cell[108122, 2646, 327, 10, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[108486, 2661, 183, 4, 38, "Input"],
Cell[108672, 2667, 254, 8, 61, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[108975, 2681, 145, 2, 65, "Subtitle"],
Cell[109123, 2685, 118, 2, 38, "Input"],
Cell[CellGroupData[{
Cell[109266, 2691, 353, 8, 64, "Input"],
Cell[CellGroupData[{
Cell[109644, 2703, 473, 7, 30, "Print"],
Cell[110120, 2712, 486, 7, 30, "Print"],
Cell[110609, 2721, 522, 8, 30, "Print"],
Cell[111134, 2731, 496, 7, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[111657, 2742, 525, 12, 38, "Input"],
Cell[CellGroupData[{
Cell[112207, 2758, 178, 3, 38, "Input"],
Cell[CellGroupData[{
Cell[112410, 2765, 395, 9, 30, "Print"],
Cell[112808, 2776, 392, 9, 30, "Print"],
Cell[113203, 2787, 393, 9, 30, "Print"],
Cell[113599, 2798, 4045, 98, 505, "Print"]
}, Open  ]],
Cell[117659, 2899, 1838, 50, 79, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[119534, 2954, 1830, 40, 56, "Input"],
Cell[CellGroupData[{
Cell[121389, 2998, 414, 6, 30, "Print"],
Cell[121806, 3006, 885, 18, 30, "Print"],
Cell[122694, 3026, 432, 6, 30, "Print"],
Cell[123129, 3034, 701, 13, 30, "Print"],
Cell[123833, 3049, 414, 6, 30, "Print"],
Cell[124250, 3057, 885, 18, 30, "Print"],
Cell[125138, 3077, 733, 13, 30, "Print"],
Cell[125874, 3092, 436, 6, 30, "Print"],
Cell[126313, 3100, 588, 11, 30, "Print"],
Cell[126904, 3113, 701, 13, 30, "Print"],
Cell[127608, 3128, 416, 6, 30, "Print"],
Cell[128027, 3136, 815, 15, 30, "Print"],
Cell[128845, 3153, 416, 6, 30, "Print"],
Cell[129264, 3161, 653, 12, 30, "Print"],
Cell[129920, 3175, 686, 12, 30, "Print"],
Cell[130609, 3189, 684, 12, 30, "Print"],
Cell[131296, 3203, 686, 12, 30, "Print"],
Cell[131985, 3217, 414, 6, 30, "Print"],
Cell[132402, 3225, 815, 15, 30, "Print"],
Cell[133220, 3242, 615, 11, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[133884, 3259, 225, 4, 38, "Input"],
Cell[CellGroupData[{
Cell[134134, 3267, 606, 12, 30, "Print"],
Cell[134743, 3281, 26305, 573, 505, "Print"]
}, Open  ]],
Cell[161063, 3857, 2960, 77, 79, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[164060, 3939, 318, 6, 38, "Input"],
Cell[CellGroupData[{
Cell[164403, 3949, 577, 9, 30, "Print"],
Cell[164983, 3960, 838, 16, 30, "Print"],
Cell[165824, 3978, 847, 15, 30, "Print"],
Cell[166674, 3995, 778, 14, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[167501, 4015, 431, 9, 64, "Input"],
Cell[CellGroupData[{
Cell[167957, 4028, 401, 6, 30, "Print"],
Cell[168361, 4036, 414, 6, 30, "Print"],
Cell[168778, 4044, 415, 6, 30, "Print"],
Cell[169196, 4052, 424, 6, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[169669, 4064, 334, 8, 38, "Input"],
Cell[CellGroupData[{
Cell[170028, 4076, 384, 6, 30, "Print"],
Cell[170415, 4084, 670, 14, 30, "Print"],
Cell[171088, 4100, 355, 5, 30, "Print"],
Cell[171446, 4107, 384, 6, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[171879, 4119, 252, 5, 38, "Input"],
Cell[172134, 4126, 903, 22, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[173074, 4153, 420, 9, 64, "Input"],
Cell[CellGroupData[{
Cell[173519, 4166, 606, 11, 30, "Print"],
Cell[174128, 4179, 403, 6, 30, "Print"],
Cell[174534, 4187, 689, 14, 30, "Print"],
Cell[175226, 4203, 374, 5, 30, "Print"],
Cell[175603, 4210, 405, 6, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[176057, 4222, 1854, 43, 114, "Input"],
Cell[177914, 4267, 7644, 220, 357, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[185595, 4492, 2469, 60, 189, "Input"],
Cell[188067, 4554, 2530, 67, 86, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[190634, 4626, 621, 19, 38, "Input"],
Cell[191258, 4647, 369, 9, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[191664, 4661, 623, 19, 38, "Input"],
Cell[192290, 4682, 413, 12, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[192740, 4699, 156, 3, 38, "Input"],
Cell[192899, 4704, 411, 13, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[193347, 4722, 2143, 56, 189, "Input"],
Cell[195493, 4780, 3736, 115, 113, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[199266, 4900, 170, 3, 38, "Input"],
Cell[199439, 4905, 427, 12, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[199903, 4922, 220, 4, 38, "Input"],
Cell[200126, 4928, 478, 13, 61, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[200653, 4947, 88, 1, 65, "Subtitle"],
Cell[200744, 4950, 118, 2, 38, "Input"],
Cell[CellGroupData[{
Cell[200887, 4956, 284, 7, 64, "Input"],
Cell[CellGroupData[{
Cell[201196, 4967, 665, 11, 30, "Print"],
Cell[201864, 4980, 679, 11, 30, "Print"],
Cell[202546, 4993, 713, 12, 30, "Print"],
Cell[203262, 5007, 686, 11, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[203975, 5022, 337, 8, 38, "Input"],
Cell[CellGroupData[{
Cell[204337, 5034, 127, 2, 38, "Input"],
Cell[CellGroupData[{
Cell[204489, 5040, 332, 8, 51, "Print"],
Cell[204824, 5050, 328, 8, 51, "Print"],
Cell[205155, 5060, 328, 8, 51, "Print"],
Cell[205486, 5070, 328, 8, 51, "Print"],
Cell[205817, 5080, 4855, 117, 985, "Print"]
}, Open  ]],
Cell[210687, 5200, 1976, 56, 141, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[212700, 5261, 1365, 31, 56, "Input"],
Cell[CellGroupData[{
Cell[214090, 5296, 572, 9, 30, "Print"],
Cell[214665, 5307, 1045, 21, 30, "Print"],
Cell[215713, 5330, 590, 9, 30, "Print"],
Cell[216306, 5341, 857, 16, 30, "Print"],
Cell[217166, 5359, 572, 9, 30, "Print"],
Cell[217741, 5370, 1043, 21, 30, "Print"],
Cell[218787, 5393, 891, 16, 30, "Print"],
Cell[219681, 5411, 593, 9, 30, "Print"],
Cell[220277, 5422, 746, 14, 30, "Print"],
Cell[221026, 5438, 857, 16, 30, "Print"],
Cell[221886, 5456, 574, 9, 30, "Print"],
Cell[222463, 5467, 973, 18, 30, "Print"],
Cell[223439, 5487, 572, 9, 30, "Print"],
Cell[224014, 5498, 810, 15, 30, "Print"],
Cell[224827, 5515, 844, 15, 30, "Print"],
Cell[225674, 5532, 844, 15, 30, "Print"],
Cell[226521, 5549, 842, 15, 30, "Print"],
Cell[227366, 5566, 842, 15, 30, "Print"],
Cell[228211, 5583, 572, 9, 30, "Print"],
Cell[228786, 5594, 973, 18, 30, "Print"],
Cell[229762, 5614, 773, 14, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[230584, 5634, 172, 3, 38, "Input"],
Cell[CellGroupData[{
Cell[230781, 5641, 696, 13, 30, "Print"],
Cell[231480, 5656, 694, 13, 30, "Print"],
Cell[232177, 5671, 694, 13, 30, "Print"],
Cell[232874, 5686, 694, 13, 30, "Print"],
Cell[233571, 5701, 109167, 2032, 505, 89058, 1701, "CachedBoxData", \
"BoxData", "Print"],
Cell[342741, 7735, 11833, 236, 505, "Print"]
}, Open  ]],
Cell[354589, 7974, 5030, 135, 79, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[359656, 8114, 292, 6, 38, "Input"],
Cell[CellGroupData[{
Cell[359973, 8124, 585, 9, 30, "Print"],
Cell[360561, 8135, 849, 16, 30, "Print"],
Cell[361413, 8153, 856, 15, 30, "Print"],
Cell[362272, 8170, 858, 15, 30, "Print"],
Cell[363133, 8187, 856, 15, 30, "Print"],
Cell[363992, 8204, 858, 15, 30, "Print"],
Cell[364853, 8221, 787, 14, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[365689, 8241, 533, 11, 64, "Input"],
Cell[CellGroupData[{
Cell[366247, 8256, 621, 10, 30, "Print"],
Cell[366871, 8268, 631, 10, 30, "Print"],
Cell[367505, 8280, 635, 10, 30, "Print"],
Cell[368143, 8292, 641, 10, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[368833, 8308, 380, 9, 38, "Input"],
Cell[CellGroupData[{
Cell[369238, 8321, 623, 10, 30, "Print"],
Cell[369864, 8333, 909, 18, 30, "Print"],
Cell[370776, 8353, 596, 9, 30, "Print"],
Cell[371375, 8364, 625, 10, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[372027, 8378, 344, 7, 38, "Input"],
Cell[CellGroupData[{
Cell[372396, 8389, 466, 9, 64, "Input"],
Cell[CellGroupData[{
Cell[372887, 8402, 660, 12, 30, "Print"],
Cell[373550, 8416, 454, 7, 30, "Print"],
Cell[374007, 8425, 740, 15, 30, "Print"],
Cell[374750, 8442, 427, 6, 30, "Print"],
Cell[375180, 8450, 458, 7, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[375665, 8461, 789, 15, 38, "Input"],
Cell[CellGroupData[{
Cell[376479, 8480, 88, 1, 89, "Section"],
Cell[376570, 8483, 1246, 33, 139, "Input"],
Cell[CellGroupData[{
Cell[377841, 8520, 474, 8, 38, "Input"],
Cell[CellGroupData[{
Cell[378340, 8532, 269, 4, 30, "Print"],
Cell[378612, 8538, 555, 12, 30, "Print"],
Cell[379170, 8552, 242, 3, 30, "Print"],
Cell[379415, 8557, 271, 4, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[379735, 8567, 919, 27, 38, "Input"],
Cell[380657, 8596, 2995, 82, 118, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[383689, 8683, 652, 19, 38, "Input"],
Cell[384344, 8704, 1013, 29, 66, "Output"]
}, Open  ]],
Cell[385372, 8736, 804, 26, 75, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[386213, 8767, 89, 1, 51, "Section"],
Cell[386305, 8770, 1489, 37, 139, "Input"],
Cell[CellGroupData[{
Cell[387819, 8811, 536, 9, 38, "Input"],
Cell[CellGroupData[{
Cell[388380, 8824, 360, 6, 30, "Print"],
Cell[388743, 8832, 646, 14, 30, "Print"],
Cell[389392, 8848, 333, 5, 30, "Print"],
Cell[389728, 8855, 362, 6, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[390139, 8867, 977, 28, 64, "Input"],
Cell[391119, 8897, 3343, 89, 97, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[394499, 8991, 1606, 40, 64, "Input"],
Cell[396108, 9033, 1043, 24, 62, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[397200, 9063, 89, 1, 51, "Section"],
Cell[397292, 9066, 1250, 29, 114, "Input"],
Cell[CellGroupData[{
Cell[398567, 9099, 578, 10, 38, "Input"],
Cell[CellGroupData[{
Cell[399170, 9113, 437, 7, 30, "Print"],
Cell[399610, 9122, 723, 15, 30, "Print"],
Cell[400336, 9139, 408, 6, 30, "Print"],
Cell[400747, 9147, 439, 7, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[401235, 9160, 1045, 29, 38, "Input"],
Cell[402283, 9191, 3874, 101, 144, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[406194, 9297, 1589, 41, 64, "Input"],
Cell[407786, 9340, 1156, 25, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[408979, 9370, 1041, 34, 64, "Input"],
Cell[410023, 9406, 441, 12, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[410501, 9423, 1018, 33, 64, "Input"],
Cell[411522, 9458, 3379, 96, 117, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[414938, 9559, 884, 26, 38, "Input"],
Cell[415825, 9587, 1006, 30, 63, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[416868, 9622, 885, 26, 38, "Input"],
Cell[417756, 9650, 361, 9, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[418154, 9664, 884, 26, 38, "Input"],
Cell[419041, 9692, 544, 16, 56, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[419646, 9715, 139, 2, 65, "Subtitle"],
Cell[419788, 9719, 118, 2, 38, "Input"],
Cell[CellGroupData[{
Cell[419931, 9725, 284, 7, 64, "Input"],
Cell[CellGroupData[{
Cell[420240, 9736, 615, 10, 30, "Print"],
Cell[420858, 9748, 629, 10, 30, "Print"],
Cell[421490, 9760, 663, 11, 30, "Print"],
Cell[422156, 9773, 637, 10, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[422820, 9787, 337, 8, 38, "Input"],
Cell[CellGroupData[{
Cell[423182, 9799, 127, 2, 38, "Input"],
Cell[CellGroupData[{
Cell[423334, 9805, 332, 8, 51, "Print"],
Cell[423669, 9815, 328, 8, 51, "Print"],
Cell[424000, 9825, 328, 8, 51, "Print"],
Cell[424331, 9835, 328, 8, 51, "Print"],
Cell[424662, 9845, 4855, 117, 985, "Print"]
}, Open  ]],
Cell[429532, 9965, 1976, 56, 141, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[431545, 10026, 558, 16, 30, "Input"],
Cell[CellGroupData[{
Cell[432128, 10046, 126, 2, 30, "Print"],
Cell[432257, 10050, 565, 13, 30, "Print"],
Cell[432825, 10065, 144, 2, 30, "Print"],
Cell[432972, 10069, 375, 8, 30, "Print"],
Cell[433350, 10079, 126, 2, 30, "Print"],
Cell[433479, 10083, 557, 12, 30, "Print"],
Cell[434039, 10097, 557, 12, 30, "Print"],
Cell[434599, 10111, 447, 9, 30, "Print"],
Cell[435049, 10122, 147, 2, 30, "Print"],
Cell[435199, 10126, 298, 7, 30, "Print"],
Cell[435500, 10135, 332, 7, 30, "Print"],
Cell[435835, 10144, 328, 7, 30, "Print"],
Cell[436166, 10153, 371, 8, 30, "Print"],
Cell[436540, 10163, 126, 2, 30, "Print"],
Cell[436669, 10167, 365, 8, 30, "Print"],
Cell[437037, 10177, 396, 8, 30, "Print"],
Cell[437436, 10187, 396, 8, 30, "Print"],
Cell[437835, 10197, 396, 8, 30, "Print"],
Cell[438234, 10207, 398, 8, 30, "Print"],
Cell[438635, 10217, 329, 7, 30, "Print"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[439013, 10230, 1362, 30, 56, "Input"],
Cell[CellGroupData[{
Cell[440400, 10264, 480, 8, 30, "Print"],
Cell[440883, 10274, 951, 20, 30, "Print"],
Cell[441837, 10296, 498, 8, 30, "Print"],
Cell[442338, 10306, 765, 15, 30, "Print"],
Cell[443106, 10323, 479, 8, 30, "Print"],
Cell[443588, 10333, 951, 20, 30, "Print"],
Cell[444542, 10355, 801, 15, 30, "Print"],
Cell[445346, 10372, 502, 8, 30, "Print"],
Cell[445851, 10382, 656, 13, 30, "Print"],
Cell[446510, 10397, 764, 15, 30, "Print"],
Cell[447277, 10414, 480, 8, 30, "Print"],
Cell[447760, 10424, 881, 17, 30, "Print"],
Cell[448644, 10443, 480, 8, 30, "Print"],
Cell[449127, 10453, 719, 14, 30, "Print"],
Cell[449849, 10469, 750, 14, 30, "Print"],
Cell[450602, 10485, 750, 14, 30, "Print"],
Cell[451355, 10501, 750, 14, 30, "Print"],
Cell[452108, 10517, 750, 14, 30, "Print"],
Cell[452861, 10533, 480, 8, 30, "Print"],
Cell[453344, 10543, 881, 17, 30, "Print"],
Cell[454228, 10562, 681, 13, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[454958, 10581, 172, 3, 38, "Input"],
Cell[CellGroupData[{
Cell[455155, 10588, 643, 12, 30, "Print"],
Cell[455801, 10602, 643, 12, 30, "Print"],
Cell[456447, 10616, 643, 12, 30, "Print"],
Cell[457093, 10630, 645, 12, 30, "Print"],
Cell[457741, 10644, 167849, 3015, 505, 144556, 2632, "CachedBoxData", \
"BoxData", "Print"],
Cell[625593, 13661, 118887, 2106, 505, 99273, 1784, "CachedBoxData", \
"BoxData", "Print"]
}, Open  ]],
Cell[744495, 15770, 6133, 166, 79, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[750665, 15941, 241, 5, 38, "Input"],
Cell[CellGroupData[{
Cell[750931, 15950, 541, 8, 30, "Print"],
Cell[751475, 15960, 804, 15, 30, "Print"],
Cell[752282, 15977, 811, 14, 30, "Print"],
Cell[753096, 15993, 811, 14, 30, "Print"],
Cell[753910, 16009, 811, 14, 30, "Print"],
Cell[754724, 16025, 811, 14, 30, "Print"],
Cell[755538, 16041, 744, 13, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[756331, 16060, 533, 11, 64, "Input"],
Cell[CellGroupData[{
Cell[756889, 16075, 573, 9, 30, "Print"],
Cell[757465, 16086, 587, 9, 30, "Print"],
Cell[758055, 16097, 587, 9, 30, "Print"],
Cell[758645, 16108, 595, 9, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[759289, 16123, 380, 9, 38, "Input"],
Cell[CellGroupData[{
Cell[759694, 16136, 575, 9, 30, "Print"],
Cell[760272, 16147, 859, 17, 30, "Print"],
Cell[761134, 16166, 544, 8, 30, "Print"],
Cell[761681, 16176, 575, 9, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[762283, 16189, 344, 7, 38, "Input"],
Cell[762630, 16198, 779, 13, 38, "Input"],
Cell[763412, 16213, 1343, 34, 139, "Input"],
Cell[CellGroupData[{
Cell[764780, 16251, 96, 1, 38, "Input"],
Cell[764879, 16254, 106909, 2126, 11636, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[871825, 18385, 474, 8, 30, "Input"],
Cell[CellGroupData[{
Cell[872324, 18397, 294, 5, 30, "Print"],
Cell[872621, 18404, 580, 13, 30, "Print"],
Cell[873204, 18419, 265, 4, 30, "Print"],
Cell[873472, 18425, 295, 5, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[873816, 18436, 643, 19, 38, "Input"],
Cell[874462, 18457, 642, 19, 67, "Output"]
}, Open  ]],
Cell[875119, 18479, 499, 16, 74, "Input"],
Cell[CellGroupData[{
Cell[875643, 18499, 773, 20, 38, "Input"],
Cell[876419, 18521, 2943, 81, 118, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[879399, 18607, 652, 19, 38, "Input"],
Cell[880054, 18628, 969, 29, 68, "Output"]
}, Open  ]],
Cell[881038, 18660, 1489, 37, 139, "Input"],
Cell[CellGroupData[{
Cell[882552, 18701, 536, 9, 38, "Input"],
Cell[CellGroupData[{
Cell[883113, 18714, 267, 4, 30, "Print"],
Cell[883383, 18720, 554, 12, 30, "Print"],
Cell[883940, 18734, 241, 3, 30, "Print"],
Cell[884184, 18739, 272, 4, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[884505, 18749, 977, 28, 64, "Input"],
Cell[885485, 18779, 3251, 88, 97, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[888773, 18872, 827, 21, 38, "Input"],
Cell[889603, 18895, 920, 25, 66, "Output"]
}, Open  ]],
Cell[890538, 18923, 1443, 36, 139, "Input"],
Cell[CellGroupData[{
Cell[892006, 18963, 578, 10, 38, "Input"],
Cell[CellGroupData[{
Cell[892609, 18977, 297, 5, 30, "Print"],
Cell[892909, 18984, 580, 13, 30, "Print"],
Cell[893492, 18999, 266, 4, 30, "Print"],
Cell[893761, 19005, 297, 5, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[894107, 19016, 1019, 28, 38, "Input"],
Cell[895129, 19046, 3198, 85, 117, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[898364, 19136, 893, 22, 38, "Input"],
Cell[899260, 19160, 978, 25, 62, "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
