(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    367712,       8867]
NotebookOptionsPosition[    357526,       8538]
NotebookOutlinePosition[    358115,       8560]
CellTagsIndexPosition[    358072,       8557]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Single top", "Title",
 CellChangeTimes->{{3.4778117188657*^9, 3.4778117348357*^9}, {
  3.500627855916004*^9, 3.5006278594432592`*^9}}],

Cell["test the two amplitudes computed before", "Text",
 CellChangeTimes->{{3.478438848916302*^9, 3.478438849192754*^9}, {
  3.479546643579921*^9, 3.479546660109585*^9}}],

Cell[CellGroupData[{

Cell["udbar->tbbar", "Subtitle",
 CellChangeTimes->{{3.4778117420706997`*^9, 3.4778117447507*^9}, {
  3.497862048812056*^9, 3.497862055502046*^9}, {3.499496596319121*^9, 
  3.4994966035710382`*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.448968342513181*^9, 3.448968344880295*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\</home/degrande/eta/FeynProg/FeynArts-3.5\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "FeynArts`"}]}], "Input",
 CellChangeTimes->{
  3.4777456682883*^9, 3.478434363232997*^9, {3.4978572265868073`*^9, 
   3.4978572271791267`*^9}, {3.5007183220647497`*^9, 3.500718325226549*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478434366177163*^9, 3.478435570663394*^9, 3.478435703141808*^9, 
   3.478436820027009*^9, {3.479038946238288*^9, 3.479038952669886*^9}, 
   3.47909796405005*^9, 3.479099042060194*^9, 3.479099989966432*^9, 
   3.479106322136636*^9, 3.479546671218491*^9, 3.47954731586526*^9, 
   3.479547695541888*^9, 3.497857241645294*^9, 3.4978620645824203`*^9, 
   3.497862527772278*^9, 3.497871404570545*^9, 3.4979424788339853`*^9, 
   3.498391193496977*^9, 3.499508864100067*^9, 3.499521741782934*^9, 
   3.4995831578974943`*^9, {3.499584268361443*^9, 3.499584295560235*^9}, 
   3.499584333899542*^9, 3.4995857048002872`*^9, 3.4995936758763742`*^9, 
   3.49966327757331*^9, 3.499663670437725*^9, 3.500627884791136*^9, 
   3.50071832631478*^9, 3.500980537666299*^9}],

Cell[BoxData[
 FormBox["\<\"FeynArts 3.5\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478434366177163*^9, 3.478435570663394*^9, 3.478435703141808*^9, 
   3.478436820027009*^9, {3.479038946238288*^9, 3.479038952669886*^9}, 
   3.47909796405005*^9, 3.479099042060194*^9, 3.479099989966432*^9, 
   3.479106322136636*^9, 3.479546671218491*^9, 3.47954731586526*^9, 
   3.479547695541888*^9, 3.497857241645294*^9, 3.4978620645824203`*^9, 
   3.497862527772278*^9, 3.497871404570545*^9, 3.4979424788339853`*^9, 
   3.498391193496977*^9, 3.499508864100067*^9, 3.499521741782934*^9, 
   3.4995831578974943`*^9, {3.499584268361443*^9, 3.499584295560235*^9}, 
   3.499584333899542*^9, 3.4995857048002872`*^9, 3.4995936758763742`*^9, 
   3.49966327757331*^9, 3.499663670437725*^9, 3.500627884791136*^9, 
   3.50071832631478*^9, 3.5009805377438173`*^9}],

Cell[BoxData[
 FormBox["\<\"by Hagen Eck, Sepp Kueblbeck, and Thomas Hahn\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478434366177163*^9, 3.478435570663394*^9, 3.478435703141808*^9, 
   3.478436820027009*^9, {3.479038946238288*^9, 3.479038952669886*^9}, 
   3.47909796405005*^9, 3.479099042060194*^9, 3.479099989966432*^9, 
   3.479106322136636*^9, 3.479546671218491*^9, 3.47954731586526*^9, 
   3.479547695541888*^9, 3.497857241645294*^9, 3.4978620645824203`*^9, 
   3.497862527772278*^9, 3.497871404570545*^9, 3.4979424788339853`*^9, 
   3.498391193496977*^9, 3.499508864100067*^9, 3.499521741782934*^9, 
   3.4995831578974943`*^9, {3.499584268361443*^9, 3.499584295560235*^9}, 
   3.499584333899542*^9, 3.4995857048002872`*^9, 3.4995936758763742`*^9, 
   3.49966327757331*^9, 3.499663670437725*^9, 3.500627884791136*^9, 
   3.50071832631478*^9, 3.500980537755413*^9}],

Cell[BoxData[
 FormBox["\<\"last revised 16 Apr 10\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478434366177163*^9, 3.478435570663394*^9, 3.478435703141808*^9, 
   3.478436820027009*^9, {3.479038946238288*^9, 3.479038952669886*^9}, 
   3.47909796405005*^9, 3.479099042060194*^9, 3.479099989966432*^9, 
   3.479106322136636*^9, 3.479546671218491*^9, 3.47954731586526*^9, 
   3.479547695541888*^9, 3.497857241645294*^9, 3.4978620645824203`*^9, 
   3.497862527772278*^9, 3.497871404570545*^9, 3.4979424788339853`*^9, 
   3.498391193496977*^9, 3.499508864100067*^9, 3.499521741782934*^9, 
   3.4995831578974943`*^9, {3.499584268361443*^9, 3.499584295560235*^9}, 
   3.499584333899542*^9, 3.4995857048002872`*^9, 3.4995936758763742`*^9, 
   3.49966327757331*^9, 3.499663670437725*^9, 3.500627884791136*^9, 
   3.50071832631478*^9, 3.500980537766425*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"topo", " ", "=", " ", 
   RowBox[{"CreateTopologies", "[", 
    RowBox[{"0", ",", 
     RowBox[{"2", "\[Rule]", "2"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.47548813810296*^9, 3.475488972088063*^9, {3.4777456120408*^9, 
   3.4777456332583*^9}, 3.4778098132447*^9, 3.4778110152581997`*^9, {
   3.497857235135571*^9, 3.497857237590866*^9}, {3.499496482154114*^9, 
   3.499496485211625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Paint", "[", "topo", "]"}]], "Input",
 CellChangeTimes->{{3.4777456818157997`*^9, 3.4777456889958*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456900683002`*^9, 3.478435704755388*^9, 
  3.500980546374898*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 2, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456900683002`*^9, 3.478435704755388*^9, 
  3.500980546395657*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 3, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456900683002`*^9, 3.478435704755388*^9, 
  3.500980546671124*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 4, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456900683002`*^9, 3.478435704755388*^9, 
  3.500980546678403*^9}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-9.094947017729282*^-12, 15.000000000003638`}, {
        9.999999999983629, 10.000000000007276`}}], 
       LineBox[{{-9.094947017729282*^-12, 4.999999999996362}, {
        9.999999999985448, 9.999999999989086}}], 
       LineBox[{{20.000000000009095`, 15.000000000003638`}, {
        10.000000000009095`, 10.000000000003638`}}], 
       LineBox[{{20., 5.}, {10., 10.}}], 
       {PointSize[0.04], PointBox[{10., 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 44}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], LineBox[{{5.999999999990206, 10.}, {13.999999999982222`, 
        10.}}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T2\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{6.139089236967266*^-12, 15.}, {10.000000000002046`, 
        14.000000000003638`}}], 
       LineBox[{{-7.503331289626658*^-12, 5.000000000003638}, {
        9.999999999988404, 6.}}], 
       LineBox[{{20.000000000002956`, 15.}, {10.000000000002956`, 14.}}], 
       LineBox[{{19.999999999997726`, 4.999999999996362}, {9.999999999997726, 
        5.999999999996362}}], 
       LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T3\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{6.139089236967266*^-12, 15.}, {10.000000000002046`, 
        14.000000000003638`}}], 
       LineBox[{{-7.503331289626658*^-12, 5.000000000003638}, {
        9.999999999988404, 6.}}], 
       LineBox[{{20.00000000000182, 15.}, {10., 6.}}], 
       LineBox[{{20.00000000000182, 5.}, {10., 14.}}], 
       LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T4\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 22}, {0, 0}, {22, 22}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"2\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {28.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[RightArrow]\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {33., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"2\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {37.5, 69.96}, {0, 0}]},
   AspectRatio->1.0999999999999999`,
   PlotRange->{{0, 66}, {0, 72.6}}], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456900683002`*^9, 3.478435704755388*^9, 
  3.500980548715958*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"FeynArtsGraphics", "(", 
    RowBox[{"2", "\[Rule]", "2"}], ")"}], "\[InvisibleApplication]", 
   RowBox[{"(", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T2\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T2", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T3\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T3", "]"],
           Editable->False],
          TraditionalForm]},
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T4\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T4", "]"],
           Editable->False],
          TraditionalForm], "Null", "Null"},
        {"Null", "Null", "Null"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.4777456905908003`*^9, 3.478435705207405*^9, 
  3.500980548865032*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"INTopo", "=", " ", 
   RowBox[{"InsertFields", "[", 
    RowBox[{"topo", ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"F", "[", "7", "]"}], ",", 
        RowBox[{"-", 
         RowBox[{"F", "[", "10", "]"}]}]}], "}"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"F", "[", "9", "]"}], ",", 
        RowBox[{"-", 
         RowBox[{"F", "[", "12", "]"}]}]}], "}"}]}], ",", 
     RowBox[{"GenericModel", "\[Rule]", "\"\<TopEffTh_FA/TopEffTh_FA\>\""}], 
     ",", 
     RowBox[{"Model", "\[Rule]", "\"\<TopEffTh_FA/TopEffTh_FA\>\""}], ",", 
     RowBox[{"InsertionLevel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Generic", ",", " ", "Classes", ",", "Particles"}], "}"}]}]}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4778060034077*^9, 3.4778060172207003`*^9}, {
   3.4778061181482*^9, 3.4778062060957003`*^9}, {3.4778064622107*^9, 
   3.4778064974032*^9}, {3.4778096875622*^9, 3.4778097175422*^9}, {
   3.4778099067622004`*^9, 3.4778099081296997`*^9}, {3.4778111168007*^9, 
   3.4778111226157*^9}, {3.4778115172907*^9, 3.4778115174282*^9}, 
   3.478437845209915*^9, {3.479546689667869*^9, 3.479546718821388*^9}, {
   3.479546793843457*^9, 3.47954680051448*^9}, {3.497857256699514*^9, 
   3.497857324742622*^9}, {3.497857383657874*^9, 3.497857387157604*^9}, {
   3.49785741944608*^9, 3.497857431156871*^9}, {3.497862502940681*^9, 
   3.497862507492491*^9}, {3.4983901274683743`*^9, 3.498390130073097*^9}, {
   3.499495582368535*^9, 3.499495584937093*^9}, {3.4994965044618607`*^9, 
   3.499496568155007*^9}, {3.499586356510202*^9, 3.499586373514152*^9}, 
   3.499586422762087*^9, {3.499663692970071*^9, 3.499663696270081*^9}, {
   3.50062790280877*^9, 3.500627907682124*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4996637030439568`*^9, {3.500627887943892*^9, 3.500627908818776*^9}, 
   3.500718328802799*^9, 3.500980549183696*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
    "\[InvisibleSpace]", "\<\"generic\"\>", 
    "\[InvisibleSpace]", "\<\" model file \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.gen\"\>"}],
   SequenceForm[
   "", "loading ", "generic", " model file ", 
    "/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.gen"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4996637030439568`*^9, {3.500627887943892*^9, 3.500627908818776*^9}, 
   3.500718328802799*^9, 3.500980549290071*^9}],

Cell[BoxData[
 FormBox["\<\"> $SVMixing is OFF\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4996637030439568`*^9, {3.500627887943892*^9, 3.500627908818776*^9}, 
   3.500718328802799*^9, 3.500980549605673*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"generic model \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", "\<\"TopEffTh_FA/TopEffTh_FA\"\>", "}"}], 
    "\[InvisibleSpace]", "\<\" initialized\"\>"}],
   SequenceForm[
   "generic model ", {"TopEffTh_FA/TopEffTh_FA"}, " initialized"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4996637030439568`*^9, {3.500627887943892*^9, 3.500627908818776*^9}, 
   3.500718328802799*^9, 3.500980549806919*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4996637030439568`*^9, {3.500627887943892*^9, 3.500627908818776*^9}, 
   3.500718328802799*^9, 3.5009805499973288`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
    "\[InvisibleSpace]", "\<\"classes\"\>", 
    "\[InvisibleSpace]", "\<\" model file \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.mod\"\>"}],
   SequenceForm[
   "", "loading ", "classes", " model file ", 
    "/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.mod"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4996637030439568`*^9, {3.500627887943892*^9, 3.500627908818776*^9}, 
   3.500718328802799*^9, 3.500980550121307*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "51", 
    "\[InvisibleSpace]", "\<\" particles (incl. antiparticles) in \"\>", 
    "\[InvisibleSpace]", "30", "\[InvisibleSpace]", "\<\" classes\"\>"}],
   SequenceForm[
   "> ", 51, " particles (incl. antiparticles) in ", 30, " classes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4996637030439568`*^9, {3.500627887943892*^9, 3.500627908818776*^9}, 
   3.500718328802799*^9, 3.5009805502517757`*^9}],

Cell[BoxData[
 FormBox["\<\"> $CounterTerms are ON\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4996637030439568`*^9, {3.500627887943892*^9, 3.500627908818776*^9}, 
   3.500718328802799*^9, 3.500980550385854*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "142", 
    "\[InvisibleSpace]", "\<\" vertices\"\>"}],
   SequenceForm["> ", 142, " vertices"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4996637030439568`*^9, {3.500627887943892*^9, 3.500627908818776*^9}, 
   3.500718328802799*^9, 3.500980550653281*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"classes model \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", "\<\"TopEffTh_FA/TopEffTh_FA\"\>", "}"}], 
    "\[InvisibleSpace]", "\<\" initialized\"\>"}],
   SequenceForm[
   "classes model ", {"TopEffTh_FA/TopEffTh_FA"}, " initialized"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4996637030439568`*^9, {3.500627887943892*^9, 3.500627908818776*^9}, 
   3.500718328802799*^9, 3.500980550800826*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4996637030439568`*^9, {3.500627887943892*^9, 3.500627908818776*^9}, 
   3.500718328802799*^9, 3.500980550945402*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"Generic", ",", "Classes", ",", "Particles"}], "}"}]}],
   SequenceForm[
   "inserting at level(s) ", {Generic, FeynArts`Classes, FeynArts`Particles}],
   
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4996637030439568`*^9, {3.500627887943892*^9, 3.500627908818776*^9}, 
   3.500718328802799*^9, 3.500980551099969*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes, 0 Particles \
insertions\"\>"}],
   SequenceForm[
   "> Top. ", 1, ": ", "0 Generic, 0 Classes, 0 Particles insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4996637030439568`*^9, {3.500627887943892*^9, 3.500627908818776*^9}, 
   3.500718328802799*^9, 3.5009805512532883`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 3 Classes, 3 Particles \
insertions\"\>"}],
   SequenceForm[
   "> Top. ", 2, ": ", "1 Generic, 3 Classes, 3 Particles insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4996637030439568`*^9, {3.500627887943892*^9, 3.500627908818776*^9}, 
   3.500718328802799*^9, 3.500980551886359*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes, 0 Particles \
insertions\"\>"}],
   SequenceForm[
   "> Top. ", 3, ": ", "0 Generic, 0 Classes, 0 Particles insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4996637030439568`*^9, {3.500627887943892*^9, 3.500627908818776*^9}, 
   3.500718328802799*^9, 3.5009805520428457`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes, 0 Particles \
insertions\"\>"}],
   SequenceForm[
   "> Top. ", 4, ": ", "0 Generic, 0 Classes, 0 Particles insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4996637030439568`*^9, {3.500627887943892*^9, 3.500627908818776*^9}, 
   3.500718328802799*^9, 3.500980552050892*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"in total: \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 3 Classes, 3 Particles \
insertions\"\>"}],
   SequenceForm["in total: ", "1 Generic, 3 Classes, 3 Particles insertions"],
   
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4996637030439568`*^9, {3.500627887943892*^9, 3.500627908818776*^9}, 
   3.500718328802799*^9, 3.500980552059318*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Paint", "[", "INTopo", "]"}]], "Input",
 CellChangeTimes->{{3.4778063315682*^9, 3.4778063464357*^9}, {
   3.4778115474231997`*^9, 3.4778115475632*^9}, 3.478437858916929*^9, 
   3.479546810801527*^9, {3.4994965729354*^9, 3.499496573154107*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"7 diagrams\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "7 diagrams"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.499584341801282*^9, 3.4995857119234962`*^9, 
  3.499593684804886*^9, 3.499663284150272*^9, 3.4996637055393248`*^9, 
  3.500627910830654*^9, 3.500718332397193*^9}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       PolygonBox[{{3.4609327677584254`, 12.115889360201312`}, {
        2.2829934723757828`, 12.576822127959737`}, {2.7951409921073664`, 
        13.191399151637638`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"u\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{2.5390672322415746`, 7.1158893602013125`}, {
        3.7170065276242177`, 7.576822127959738}, {3.2048590078926336`, 
        8.191399151637638}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"d\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"b\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lG1QVFUYx8+KkQzjhyYZ3pfdPYc3hcHtFBRT+DBNCiq60Uy7IzXLLu1F
dBRzSYsSKNJsRlQQiIuYmYgrfKAALRxLAuVFTistTIOpRYysEDIyxlRQsT30
4dyZO3d+c+695zzP8///9fbCbMcyQsjLeC89J0d9eK0B8v/FIHSipfaGQF5x
bH5jAoPcryqP1qjIuVYS8QqDdd+VRtgUZEuwrakQ3zcuWhP5Egc22EsYiBR7
7oJvNRBwBJUcYLDvg+CV/QJ5+1s9q3Yx8G1+CLUq8tvuzsStDEx93r43FOSM
Y4vFsQyKpw8qnCMfL667t0ChKsDzq4Ygmy5unHFTaJrq8R8S8UBmv0lafoFC
TUb2F6dUZF1592gFhc0G8+AOBbms7pPeMgrVygNzCkce84btLKdgD+Db/Qhy
3MGivTUUvm0bjrgp4oD89bj3TAeFMpc4Xa8iWzIt2rsUorMtWkVBNk3megMY
eHP6u40ceVLTvOcZBgnta1r/9cVi/9Jic7YxuPhlwfyAQO6vKgwqYlA2/9KF
WhW5y5PwZimDKqPz6zwF2cV7/d9l4DdzYpWRL61rR2z5DC53dX2+6IvB/Sp+
friewcLZxReFQM4IONweyeBU86Nbqops6Wq8Pkuh52+2KV9BJrdn2q9TCE15
7tDTHNlVnf7DGQrn8i6Vawjy2jvxFR9TSB1NWu8W0UAO+x+4X0pB89G90XoV
2fX93icOURB/arPyFWSTfWrDSQrOPM8lzpGfrf5w+gqu330snhDk2Y6WYS+F
rcWNbUIwnOct6nkSz+eX9JqqIh/v05jTGGyKdMUoCvKspVVnY3DN75dAzpHX
/pE+vp9BnHtJfxTnl1o1iP1puKqbE4LK9aAmM9ZL5ffdV4fOKgqV/9cYcrI4
p3L/6on5H30+gzzfjDUxUwiDPH9541hbnWqQ9W0JCo91KAZZf/T0zU4jN8j+
XLZmvrfo08v+JTt63xkUetnfI5/91FGn6mX/u0NWYr16OR9HlOYK53o5v9rb
aa9riF7ON6t157Rb6OT83ZVHNjSoOqmPsYHOVwsUndTPyd9q/JO5TuqLTQ2b
lhGd1N+ce3dxgxol9blvfEsP51FSv5/ed3TdEFqpb8OwudemaKX+F5xq0rwv
UvqjrjPGVKlGSv/4z5kKVvNI6a+i89tOXxMR0n/O9v2PrEqE9Ge9M+f5f3zh
0r8ttt+fUtVw6W/SbNyTzMOl/7sf6EqGRZjMh5H3hyYKlTCZHysGUtcFkjCZ
L0eZH5xTQ2X+pC8nfS/wUJlPJOTO+IgIkfm1a/d5zw4lRObbzMiS/oJl/v0H
YYABMg==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"V\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 G1 N1\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 44}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       PolygonBox[{{3.4609327677584254`, 12.115889360201312`}, {
        2.2829934723757828`, 12.576822127959737`}, {2.7951409921073664`, 
        13.191399151637638`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"u\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{2.5390672322415746`, 7.1158893602013125`}, {
        3.7170065276242177`, 7.576822127959738}, {3.2048590078926336`, 
        8.191399151637638}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"d\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"b\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lG1QVFUYx8+KkQzjhyYZ3pfdPYc3hcHtFBRT+DBNCiq60Uy7IzXLLu1F
dBRzSYsSKNJsRlQQiIuYmYgrfKAALRxLAuVFTistTIOpRYysEDIyxlRQsT30
4dyZO3d+c+695zzP8///9fbCbMcyQsjLeC89J0d9eK0B8v/FIHSipfaGQF5x
bH5jAoPcryqP1qjIuVYS8QqDdd+VRtgUZEuwrakQ3zcuWhP5Egc22EsYiBR7
7oJvNRBwBJUcYLDvg+CV/QJ5+1s9q3Yx8G1+CLUq8tvuzsStDEx93r43FOSM
Y4vFsQyKpw8qnCMfL667t0ChKsDzq4Ygmy5unHFTaJrq8R8S8UBmv0lafoFC
TUb2F6dUZF1592gFhc0G8+AOBbms7pPeMgrVygNzCkce84btLKdgD+Db/Qhy
3MGivTUUvm0bjrgp4oD89bj3TAeFMpc4Xa8iWzIt2rsUorMtWkVBNk3megMY
eHP6u40ceVLTvOcZBgnta1r/9cVi/9Jic7YxuPhlwfyAQO6vKgwqYlA2/9KF
WhW5y5PwZimDKqPz6zwF2cV7/d9l4DdzYpWRL61rR2z5DC53dX2+6IvB/Sp+
friewcLZxReFQM4IONweyeBU86Nbqops6Wq8Pkuh52+2KV9BJrdn2q9TCE15
7tDTHNlVnf7DGQrn8i6Vawjy2jvxFR9TSB1NWu8W0UAO+x+4X0pB89G90XoV
2fX93icOURB/arPyFWSTfWrDSQrOPM8lzpGfrf5w+gqu330snhDk2Y6WYS+F
rcWNbUIwnOct6nkSz+eX9JqqIh/v05jTGGyKdMUoCvKspVVnY3DN75dAzpHX
/pE+vp9BnHtJfxTnl1o1iP1puKqbE4LK9aAmM9ZL5ffdV4fOKgqV/9cYcrI4
p3L/6on5H30+gzzfjDUxUwiDPH9541hbnWqQ9W0JCo91KAZZf/T0zU4jN8j+
XLZmvrfo08v+JTt63xkUetnfI5/91FGn6mX/u0NWYr16OR9HlOYK53o5v9rb
aa9riF7ON6t157Rb6OT83ZVHNjSoOqmPsYHOVwsUndTPyd9q/JO5TuqLTQ2b
lhGd1N+ce3dxgxol9blvfEsP51FSv5/ed3TdEFqpb8OwudemaKX+F5xq0rwv
UvqjrjPGVKlGSv/4z5kKVvNI6a+i89tOXxMR0n/O9v2PrEqE9Ge9M+f5f3zh
0r8ttt+fUtVw6W/SbNyTzMOl/7sf6EqGRZjMh5H3hyYKlTCZHysGUtcFkjCZ
L0eZH5xTQ2X+pC8nfS/wUJlPJOTO+IgIkfm1a/d5zw4lRObbzMiS/oJl/v0H
YYABMg==
        "]], 
       PolygonBox[{{10.599999999999994`, 10.}, {9.399999999999995, 9.6}, {
        9.399999999999995, 10.4}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"W\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 C1 N2\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       PolygonBox[{{3.4609327677584254`, 12.115889360201312`}, {
        2.2829934723757828`, 12.576822127959737`}, {2.7951409921073664`, 
        13.191399151637638`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"u\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{2.5390672322415746`, 7.1158893602013125`}, {
        3.7170065276242177`, 7.576822127959738}, {3.2048590078926336`, 
        8.191399151637638}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"d\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"b\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lG1QVFUYx8+KkQzjhyYZ3pfdPYc3hcHtFBRT+DBNCiq60Uy7IzXLLu1F
dBRzSYsSKNJsRlQQiIuYmYgrfKAALRxLAuVFTistTIOpRYysEDIyxlRQsT30
4dyZO3d+c+695zzP8///9fbCbMcyQsjLeC89J0d9eK0B8v/FIHSipfaGQF5x
bH5jAoPcryqP1qjIuVYS8QqDdd+VRtgUZEuwrakQ3zcuWhP5Egc22EsYiBR7
7oJvNRBwBJUcYLDvg+CV/QJ5+1s9q3Yx8G1+CLUq8tvuzsStDEx93r43FOSM
Y4vFsQyKpw8qnCMfL667t0ChKsDzq4Ygmy5unHFTaJrq8R8S8UBmv0lafoFC
TUb2F6dUZF1592gFhc0G8+AOBbms7pPeMgrVygNzCkce84btLKdgD+Db/Qhy
3MGivTUUvm0bjrgp4oD89bj3TAeFMpc4Xa8iWzIt2rsUorMtWkVBNk3megMY
eHP6u40ceVLTvOcZBgnta1r/9cVi/9Jic7YxuPhlwfyAQO6vKgwqYlA2/9KF
WhW5y5PwZimDKqPz6zwF2cV7/d9l4DdzYpWRL61rR2z5DC53dX2+6IvB/Sp+
friewcLZxReFQM4IONweyeBU86Nbqops6Wq8Pkuh52+2KV9BJrdn2q9TCE15
7tDTHNlVnf7DGQrn8i6Vawjy2jvxFR9TSB1NWu8W0UAO+x+4X0pB89G90XoV
2fX93icOURB/arPyFWSTfWrDSQrOPM8lzpGfrf5w+gqu330snhDk2Y6WYS+F
rcWNbUIwnOct6nkSz+eX9JqqIh/v05jTGGyKdMUoCvKspVVnY3DN75dAzpHX
/pE+vp9BnHtJfxTnl1o1iP1puKqbE4LK9aAmM9ZL5ffdV4fOKgqV/9cYcrI4
p3L/6on5H30+gzzfjDUxUwiDPH9541hbnWqQ9W0JCo91KAZZf/T0zU4jN8j+
XLZmvrfo08v+JTt63xkUetnfI5/91FGn6mX/u0NWYr16OR9HlOYK53o5v9rb
aa9riF7ON6t157Rb6OT83ZVHNjSoOqmPsYHOVwsUndTPyd9q/JO5TuqLTQ2b
lhGd1N+ce3dxgxol9blvfEsP51FSv5/ed3TdEFqpb8OwudemaKX+F5xq0rwv
UvqjrjPGVKlGSv/4z5kKVvNI6a+i89tOXxMR0n/O9v2PrEqE9Ge9M+f5f3zh
0r8ttt+fUtVw6W/SbNyTzMOl/7sf6EqGRZjMh5H3hyYKlTCZHysGUtcFkjCZ
L0eZH5xTQ2X+pC8nfS/wUJlPJOTO+IgIkfm1a/d5zw4lRObbzMiS/oJl/v0H
YYABMg==
        "]], 
       PolygonBox[{{10.599999999999994`, 10.}, {9.399999999999995, 9.6}, {
        9.399999999999995, 10.4}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"W\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 P1 N3\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       PolygonBox[{{3.4609327677584254`, 12.115889360201312`}, {
        2.2829934723757828`, 12.576822127959737`}, {2.7951409921073664`, 
        13.191399151637638`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"u\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{2.5390672322415746`, 7.1158893602013125`}, {
        3.7170065276242177`, 7.576822127959738}, {3.2048590078926336`, 
        8.191399151637638}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"d\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"b\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lG1QVFUYx8+KkQzjhyYZ3pfdPYc3hcHtFBRT+DBNCiq60Uy7IzXLLu1F
dBRzSYsSKNJsRlQQiIuYmYgrfKAALRxLAuVFTistTIOpRYysEDIyxlRQsT30
4dyZO3d+c+695zzP8///9fbCbMcyQsjLeC89J0d9eK0B8v/FIHSipfaGQF5x
bH5jAoPcryqP1qjIuVYS8QqDdd+VRtgUZEuwrakQ3zcuWhP5Egc22EsYiBR7
7oJvNRBwBJUcYLDvg+CV/QJ5+1s9q3Yx8G1+CLUq8tvuzsStDEx93r43FOSM
Y4vFsQyKpw8qnCMfL667t0ChKsDzq4Ygmy5unHFTaJrq8R8S8UBmv0lafoFC
TUb2F6dUZF1592gFhc0G8+AOBbms7pPeMgrVygNzCkce84btLKdgD+Db/Qhy
3MGivTUUvm0bjrgp4oD89bj3TAeFMpc4Xa8iWzIt2rsUorMtWkVBNk3megMY
eHP6u40ceVLTvOcZBgnta1r/9cVi/9Jic7YxuPhlwfyAQO6vKgwqYlA2/9KF
WhW5y5PwZimDKqPz6zwF2cV7/d9l4DdzYpWRL61rR2z5DC53dX2+6IvB/Sp+
friewcLZxReFQM4IONweyeBU86Nbqops6Wq8Pkuh52+2KV9BJrdn2q9TCE15
7tDTHNlVnf7DGQrn8i6Vawjy2jvxFR9TSB1NWu8W0UAO+x+4X0pB89G90XoV
2fX93icOURB/arPyFWSTfWrDSQrOPM8lzpGfrf5w+gqu330snhDk2Y6WYS+F
rcWNbUIwnOct6nkSz+eX9JqqIh/v05jTGGyKdMUoCvKspVVnY3DN75dAzpHX
/pE+vp9BnHtJfxTnl1o1iP1puKqbE4LK9aAmM9ZL5ffdV4fOKgqV/9cYcrI4
p3L/6on5H30+gzzfjDUxUwiDPH9541hbnWqQ9W0JCo91KAZZf/T0zU4jN8j+
XLZmvrfo08v+JTt63xkUetnfI5/91FGn6mX/u0NWYr16OR9HlOYK53o5v9rb
aa9riF7ON6t157Rb6OT83ZVHNjSoOqmPsYHOVwsUndTPyd9q/JO5TuqLTQ2b
lhGd1N+ce3dxgxol9blvfEsP51FSv5/ed3TdEFqpb8OwudemaKX+F5xq0rwv
UvqjrjPGVKlGSv/4z5kKVvNI6a+i89tOXxMR0n/O9v2PrEqE9Ge9M+f5f3zh
0r8ttt+fUtVw6W/SbNyTzMOl/7sf6EqGRZjMh5H3hyYKlTCZHysGUtcFkjCZ
L0eZH5xTQ2X+pC8nfS/wUJlPJOTO+IgIkfm1a/d5zw4lRObbzMiS/oJl/v0H
YYABMg==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"Tri\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 C2 N4\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 22}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       PolygonBox[{{3.4609327677584254`, 12.115889360201312`}, {
        2.2829934723757828`, 12.576822127959737`}, {2.7951409921073664`, 
        13.191399151637638`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"u\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{2.5390672322415746`, 7.1158893602013125`}, {
        3.7170065276242177`, 7.576822127959738}, {3.2048590078926336`, 
        8.191399151637638}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"d\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"b\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lG1QVFUYx8+KkQzjhyYZ3pfdPYc3hcHtFBRT+DBNCiq60Uy7IzXLLu1F
dBRzSYsSKNJsRlQQiIuYmYgrfKAALRxLAuVFTistTIOpRYysEDIyxlRQsT30
4dyZO3d+c+695zzP8///9fbCbMcyQsjLeC89J0d9eK0B8v/FIHSipfaGQF5x
bH5jAoPcryqP1qjIuVYS8QqDdd+VRtgUZEuwrakQ3zcuWhP5Egc22EsYiBR7
7oJvNRBwBJUcYLDvg+CV/QJ5+1s9q3Yx8G1+CLUq8tvuzsStDEx93r43FOSM
Y4vFsQyKpw8qnCMfL667t0ChKsDzq4Ygmy5unHFTaJrq8R8S8UBmv0lafoFC
TUb2F6dUZF1592gFhc0G8+AOBbms7pPeMgrVygNzCkce84btLKdgD+Db/Qhy
3MGivTUUvm0bjrgp4oD89bj3TAeFMpc4Xa8iWzIt2rsUorMtWkVBNk3megMY
eHP6u40ceVLTvOcZBgnta1r/9cVi/9Jic7YxuPhlwfyAQO6vKgwqYlA2/9KF
WhW5y5PwZimDKqPz6zwF2cV7/d9l4DdzYpWRL61rR2z5DC53dX2+6IvB/Sp+
friewcLZxReFQM4IONweyeBU86Nbqops6Wq8Pkuh52+2KV9BJrdn2q9TCE15
7tDTHNlVnf7DGQrn8i6Vawjy2jvxFR9TSB1NWu8W0UAO+x+4X0pB89G90XoV
2fX93icOURB/arPyFWSTfWrDSQrOPM8lzpGfrf5w+gqu330snhDk2Y6WYS+F
rcWNbUIwnOct6nkSz+eX9JqqIh/v05jTGGyKdMUoCvKspVVnY3DN75dAzpHX
/pE+vp9BnHtJfxTnl1o1iP1puKqbE4LK9aAmM9ZL5ffdV4fOKgqV/9cYcrI4
p3L/6on5H30+gzzfjDUxUwiDPH9541hbnWqQ9W0JCo91KAZZf/T0zU4jN8j+
XLZmvrfo08v+JTt63xkUetnfI5/91FGn6mX/u0NWYr16OR9HlOYK53o5v9rb
aa9riF7ON6t157Rb6OT83ZVHNjSoOqmPsYHOVwsUndTPyd9q/JO5TuqLTQ2b
lhGd1N+ce3dxgxol9blvfEsP51FSv5/ed3TdEFqpb8OwudemaKX+F5xq0rwv
UvqjrjPGVKlGSv/4z5kKVvNI6a+i89tOXxMR0n/O9v2PrEqE9Ge9M+f5f3zh
0r8ttt+fUtVw6W/SbNyTzMOl/7sf6EqGRZjMh5H3hyYKlTCZHysGUtcFkjCZ
L0eZH5xTQ2X+pC8nfS/wUJlPJOTO+IgIkfm1a/d5zw4lRObbzMiS/oJl/v0H
YYABMg==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"Tri\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 P1 N5\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 22}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       PolygonBox[{{3.4609327677584254`, 12.115889360201312`}, {
        2.2829934723757828`, 12.576822127959737`}, {2.7951409921073664`, 
        13.191399151637638`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"u\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{2.5390672322415746`, 7.1158893602013125`}, {
        3.7170065276242177`, 7.576822127959738}, {3.2048590078926336`, 
        8.191399151637638}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"d\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"b\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lG1QVFUYx8+KkQzjhyYZ3pfdPYc3hcHtFBRT+DBNCiq60Uy7IzXLLu1F
dBRzSYsSKNJsRlQQiIuYmYgrfKAALRxLAuVFTistTIOpRYysEDIyxlRQsT30
4dyZO3d+c+695zzP8///9fbCbMcyQsjLeC89J0d9eK0B8v/FIHSipfaGQF5x
bH5jAoPcryqP1qjIuVYS8QqDdd+VRtgUZEuwrakQ3zcuWhP5Egc22EsYiBR7
7oJvNRBwBJUcYLDvg+CV/QJ5+1s9q3Yx8G1+CLUq8tvuzsStDEx93r43FOSM
Y4vFsQyKpw8qnCMfL667t0ChKsDzq4Ygmy5unHFTaJrq8R8S8UBmv0lafoFC
TUb2F6dUZF1592gFhc0G8+AOBbms7pPeMgrVygNzCkce84btLKdgD+Db/Qhy
3MGivTUUvm0bjrgp4oD89bj3TAeFMpc4Xa8iWzIt2rsUorMtWkVBNk3megMY
eHP6u40ceVLTvOcZBgnta1r/9cVi/9Jic7YxuPhlwfyAQO6vKgwqYlA2/9KF
WhW5y5PwZimDKqPz6zwF2cV7/d9l4DdzYpWRL61rR2z5DC53dX2+6IvB/Sp+
friewcLZxReFQM4IONweyeBU86Nbqops6Wq8Pkuh52+2KV9BJrdn2q9TCE15
7tDTHNlVnf7DGQrn8i6Vawjy2jvxFR9TSB1NWu8W0UAO+x+4X0pB89G90XoV
2fX93icOURB/arPyFWSTfWrDSQrOPM8lzpGfrf5w+gqu330snhDk2Y6WYS+F
rcWNbUIwnOct6nkSz+eX9JqqIh/v05jTGGyKdMUoCvKspVVnY3DN75dAzpHX
/pE+vp9BnHtJfxTnl1o1iP1puKqbE4LK9aAmM9ZL5ffdV4fOKgqV/9cYcrI4
p3L/6on5H30+gzzfjDUxUwiDPH9541hbnWqQ9W0JCo91KAZZf/T0zU4jN8j+
XLZmvrfo08v+JTt63xkUetnfI5/91FGn6mX/u0NWYr16OR9HlOYK53o5v9rb
aa9riF7ON6t157Rb6OT83ZVHNjSoOqmPsYHOVwsUndTPyd9q/JO5TuqLTQ2b
lhGd1N+ce3dxgxol9blvfEsP51FSv5/ed3TdEFqpb8OwudemaKX+F5xq0rwv
UvqjrjPGVKlGSv/4z5kKVvNI6a+i89tOXxMR0n/O9v2PrEqE9Ge9M+f5f3zh
0r8ttt+fUtVw6W/SbNyTzMOl/7sf6EqGRZjMh5H3hyYKlTCZHysGUtcFkjCZ
L0eZH5xTQ2X+pC8nfS/wUJlPJOTO+IgIkfm1a/d5zw4lRObbzMiS/oJl/v0H
YYABMg==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"Tri8\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 C3 N6\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 22}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       PolygonBox[{{3.4609327677584254`, 12.115889360201312`}, {
        2.2829934723757828`, 12.576822127959737`}, {2.7951409921073664`, 
        13.191399151637638`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"u\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{2.5390672322415746`, 7.1158893602013125`}, {
        3.7170065276242177`, 7.576822127959738}, {3.2048590078926336`, 
        8.191399151637638}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"d\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"b\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[CompressedData["
1:eJw9lG1QVFUYx8+KkQzjhyYZ3pfdPYc3hcHtFBRT+DBNCiq60Uy7IzXLLu1F
dBRzSYsSKNJsRlQQiIuYmYgrfKAALRxLAuVFTistTIOpRYysEDIyxlRQsT30
4dyZO3d+c+695zzP8///9fbCbMcyQsjLeC89J0d9eK0B8v/FIHSipfaGQF5x
bH5jAoPcryqP1qjIuVYS8QqDdd+VRtgUZEuwrakQ3zcuWhP5Egc22EsYiBR7
7oJvNRBwBJUcYLDvg+CV/QJ5+1s9q3Yx8G1+CLUq8tvuzsStDEx93r43FOSM
Y4vFsQyKpw8qnCMfL667t0ChKsDzq4Ygmy5unHFTaJrq8R8S8UBmv0lafoFC
TUb2F6dUZF1592gFhc0G8+AOBbms7pPeMgrVygNzCkce84btLKdgD+Db/Qhy
3MGivTUUvm0bjrgp4oD89bj3TAeFMpc4Xa8iWzIt2rsUorMtWkVBNk3megMY
eHP6u40ceVLTvOcZBgnta1r/9cVi/9Jic7YxuPhlwfyAQO6vKgwqYlA2/9KF
WhW5y5PwZimDKqPz6zwF2cV7/d9l4DdzYpWRL61rR2z5DC53dX2+6IvB/Sp+
friewcLZxReFQM4IONweyeBU86Nbqops6Wq8Pkuh52+2KV9BJrdn2q9TCE15
7tDTHNlVnf7DGQrn8i6Vawjy2jvxFR9TSB1NWu8W0UAO+x+4X0pB89G90XoV
2fX93icOURB/arPyFWSTfWrDSQrOPM8lzpGfrf5w+gqu330snhDk2Y6WYS+F
rcWNbUIwnOct6nkSz+eX9JqqIh/v05jTGGyKdMUoCvKspVVnY3DN75dAzpHX
/pE+vp9BnHtJfxTnl1o1iP1puKqbE4LK9aAmM9ZL5ffdV4fOKgqV/9cYcrI4
p3L/6on5H30+gzzfjDUxUwiDPH9541hbnWqQ9W0JCo91KAZZf/T0zU4jN8j+
XLZmvrfo08v+JTt63xkUetnfI5/91FGn6mX/u0NWYr16OR9HlOYK53o5v9rb
aa9riF7ON6t157Rb6OT83ZVHNjSoOqmPsYHOVwsUndTPyd9q/JO5TuqLTQ2b
lhGd1N+ce3dxgxol9blvfEsP51FSv5/ed3TdEFqpb8OwudemaKX+F5xq0rwv
UvqjrjPGVKlGSv/4z5kKVvNI6a+i89tOXxMR0n/O9v2PrEqE9Ge9M+f5f3zh
0r8ttt+fUtVw6W/SbNyTzMOl/7sf6EqGRZjMh5H3hyYKlTCZHysGUtcFkjCZ
L0eZH5xTQ2X+pC8nfS/wUJlPJOTO+IgIkfm1a/d5zw4lRObbzMiS/oJl/v0H
YYABMg==
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"Tri8\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 P1 N7\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 0}, {0, 0}, {22, 22}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"u\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {24., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"d\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {28.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[RightArrow]\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {33., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"t\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {37.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"b\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {42., 69.96}, {0, 0}]},
   AspectRatio->1.0999999999999999`,
   PlotRange->{{0, 66}, {0, 72.6}}], TraditionalForm]], "Print",
 CellChangeTimes->{3.499584341801282*^9, 3.4995857119234962`*^9, 
  3.499593684804886*^9, 3.499663284150272*^9, 3.4996637055393248`*^9, 
  3.500627910830654*^9, 3.5007183350984697`*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"FeynArtsGraphics", "(", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"u\"\>", ",", "\<\"d\"\>"}], "}"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\<\"t\"\>", ",", "\<\"b\"\>"}], "}"}]}], ")"}], 
   "\[InvisibleApplication]", 
   RowBox[{"(", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 G1 N1\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 G1 N1", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 C1 N2\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 C1 N2", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 P1 N3\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 P1 N3", "]"],
           Editable->False],
          TraditionalForm]},
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 C2 N4\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 C2 N4", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 P1 N5\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 P1 N5", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 C3 N6\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 C3 N6", "]"],
           Editable->False],
          TraditionalForm]},
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 P1 N7\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 P1 N7", "]"],
           Editable->False],
          TraditionalForm], "Null", "Null"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.4778063475407*^9, 3.4778065254607*^9, 3.4778099157272*^9, 
   3.4778115492682*^9, 3.47843686984159*^9, 3.478436906375371*^9, {
   3.478437853618226*^9, 3.478437860811162*^9}, 3.479099999826127*^9, 
   3.479106333796554*^9, {3.479546806741183*^9, 3.479546812623714*^9}, 
   3.4978620779952097`*^9, 3.497862535136364*^9, 3.497871415799543*^9, 
   3.4979424893430643`*^9, 3.498391202919662*^9, 3.499521753363945*^9, 
   3.499583162685727*^9, 3.499584300111794*^9, 3.499584342363058*^9, 
   3.499585712241136*^9, 3.499593685059499*^9, 3.4996632844405613`*^9, 
   3.4996637058472843`*^9, 3.500627911255908*^9, 3.5007183352932796`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Ampl", " ", "=", " ", 
   RowBox[{"CreateFeynAmp", "[", "INTopo", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4778062370957003`*^9, 3.4778062399307003`*^9}, {
   3.4778115657332*^9, 3.4778115658507*^9}, {3.4778120221097*^9, 
   3.4778120222467003`*^9}, 3.479547360479462*^9, {3.4994965783939333`*^9, 
   3.4994965820750732`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.499584340167673*^9, 3.4995847701347446`*^9, 
  3.499585713493058*^9, 3.499663287327167*^9, 3.499663706858138*^9, 
  3.5006279157832413`*^9, 3.5007183383866777`*^9, 3.500980559226266*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"Generic", ",", "Classes", ",", "Particles"}], "}"}]}],
   SequenceForm[
   "creating amplitudes at level(s) ", {
    Generic, FeynArts`Classes, FeynArts`Particles}],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.499584340167673*^9, 3.4995847701347446`*^9, 
  3.499585713493058*^9, 3.499663287327167*^9, 3.499663706858138*^9, 
  3.5006279157832413`*^9, 3.5007183383866777`*^9, 3.500980559289074*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 3 Classes, 3 Particles \
amplitudes\"\>"}],
   SequenceForm[
   "> Top. ", 1, ": ", "1 Generic, 3 Classes, 3 Particles amplitudes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.499584340167673*^9, 3.4995847701347446`*^9, 
  3.499585713493058*^9, 3.499663287327167*^9, 3.499663706858138*^9, 
  3.5006279157832413`*^9, 3.5007183383866777`*^9, 3.500980559456772*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"in total: \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 3 Classes, 3 Particles \
amplitudes\"\>"}],
   SequenceForm["in total: ", "1 Generic, 3 Classes, 3 Particles amplitudes"],
   
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.499584340167673*^9, 3.4995847701347446`*^9, 
  3.499585713493058*^9, 3.499663287327167*^9, 3.499663706858138*^9, 
  3.5006279157832413`*^9, 3.5007183383866777`*^9, 3.50098055946246*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\</home/degrande/eta/FeynProg/FormCalc-6.2\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "FormCalc`"}]}], "Input",
 CellChangeTimes->{
  3.4777456682883*^9, {3.4778119018507*^9, 3.4778119054056997`*^9}, {
   3.4778119371527*^9, 3.4778119527257*^9}, {3.478434390853149*^9, 
   3.478434394596879*^9}, {3.498391209209569*^9, 3.4983912097170353`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.497862097715542*^9, 3.497862541299556*^9, 3.497871425757481*^9, 
  3.497942493923506*^9, 3.4983912102183523`*^9, 3.499521768705014*^9, 
  3.499583165670874*^9, 3.4995847733890743`*^9, 3.499585716589773*^9, 
  3.499663290399749*^9, 3.4996637154724083`*^9, 3.500627918425613*^9, 
  3.5007183404884157`*^9, 3.5009805606926622`*^9}],

Cell[BoxData[
 FormBox["\<\"FormCalc 6.2\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.497862097715542*^9, 3.497862541299556*^9, 3.497871425757481*^9, 
  3.497942493923506*^9, 3.4983912102183523`*^9, 3.499521768705014*^9, 
  3.499583165670874*^9, 3.4995847733890743`*^9, 3.499585716589773*^9, 
  3.499663290399749*^9, 3.4996637154724083`*^9, 3.500627918425613*^9, 
  3.5007183404884157`*^9, 3.500980560759437*^9}],

Cell[BoxData[
 FormBox["\<\"by Thomas Hahn\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.497862097715542*^9, 3.497862541299556*^9, 3.497871425757481*^9, 
  3.497942493923506*^9, 3.4983912102183523`*^9, 3.499521768705014*^9, 
  3.499583165670874*^9, 3.4995847733890743`*^9, 3.499585716589773*^9, 
  3.499663290399749*^9, 3.4996637154724083`*^9, 3.500627918425613*^9, 
  3.5007183404884157`*^9, 3.500980560924983*^9}],

Cell[BoxData[
 FormBox["\<\"last revised 11 Aug 10\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.497862097715542*^9, 3.497862541299556*^9, 3.497871425757481*^9, 
  3.497942493923506*^9, 3.4983912102183523`*^9, 3.499521768705014*^9, 
  3.499583165670874*^9, 3.4995847733890743`*^9, 3.499585716589773*^9, 
  3.499663290399749*^9, 3.4996637154724083`*^9, 3.500627918425613*^9, 
  3.5007183404884157`*^9, 3.5009805610658083`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"M", "=", " ", 
   RowBox[{"CalcFeynAmp", "[", 
    RowBox[{"Ampl", ",", 
     RowBox[{"FermionChains", "\[Rule]", "Chiral"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.4778119845017*^9, 3.4778120345607*^9}, {
   3.478435376938886*^9, 3.478435418868291*^9}, 3.479547358194307*^9, {
   3.499496616117415*^9, 3.499496619479166*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.478434402570528*^9, 3.478435422620416*^9, 
  3.478435588542779*^9, 3.478435896246393*^9, 3.478436924110362*^9, 
  3.479100051862622*^9, 3.479106355014496*^9, 3.479546852661124*^9, 
  3.479547334202314*^9, 3.479547712295999*^9, 3.497862102150838*^9, 
  3.49786254240231*^9, 3.497871427141417*^9, 3.497942495239724*^9, 
  3.498391212528688*^9, 3.499521771092147*^9, 3.4995831672080717`*^9, 
  3.49958477566978*^9, 3.499585723941321*^9, 3.4996632922912827`*^9, 
  3.499663716825395*^9, 3.500627920707939*^9, 3.500718342265451*^9, 
  3.500980562325152*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.478434402570528*^9, 3.478435422620416*^9, 
  3.478435588542779*^9, 3.478435896246393*^9, 3.478436924110362*^9, 
  3.479100051862622*^9, 3.479106355014496*^9, 3.479546852661124*^9, 
  3.479547334202314*^9, 3.479547712295999*^9, 3.497862102150838*^9, 
  3.49786254240231*^9, 3.497871427141417*^9, 3.497942495239724*^9, 
  3.498391212528688*^9, 3.499521771092147*^9, 3.4995831672080717`*^9, 
  3.49958477566978*^9, 3.499585723941321*^9, 3.4996632922912827`*^9, 
  3.499663716825395*^9, 3.500627920707939*^9, 3.500718342265451*^9, 
  3.500980562393785*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{3.478434402570528*^9, 3.478435422620416*^9, 
  3.478435588542779*^9, 3.478435896246393*^9, 3.478436924110362*^9, 
  3.479100051862622*^9, 3.479106355014496*^9, 3.479546852661124*^9, 
  3.479547334202314*^9, 3.479547712295999*^9, 3.497862102150838*^9, 
  3.49786254240231*^9, 3.497871427141417*^9, 3.497942495239724*^9, 
  3.498391212528688*^9, 3.499521771092147*^9, 3.4995831672080717`*^9, 
  3.49958477566978*^9, 3.499585723941321*^9, 3.4996632922912827`*^9, 
  3.499663716825395*^9, 3.500627920707939*^9, 3.500718342265451*^9, 
  3.500980562819409*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.478434402570528*^9, 3.478435422620416*^9, 
  3.478435588542779*^9, 3.478435896246393*^9, 3.478436924110362*^9, 
  3.479100051862622*^9, 3.479106355014496*^9, 3.479546852661124*^9, 
  3.479547334202314*^9, 3.479547712295999*^9, 3.497862102150838*^9, 
  3.49786254240231*^9, 3.497871427141417*^9, 3.497942495239724*^9, 
  3.498391212528688*^9, 3.499521771092147*^9, 3.4995831672080717`*^9, 
  3.49958477566978*^9, 3.499585723941321*^9, 3.4996632922912827`*^9, 
  3.499663716825395*^9, 3.500627920707939*^9, 3.500718342265451*^9, 
  3.500980562962872*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"col", "=", 
  RowBox[{"ColourME", "[", "M", "]"}]}]], "Input",
 CellChangeTimes->{{3.478434696113564*^9, 3.478434729084623*^9}, {
  3.478435197289632*^9, 3.478435232835993*^9}, {3.478436054623279*^9, 
  3.478436055525961*^9}, {3.499521787338925*^9, 3.4995217875817633`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Mat", "(", 
      RowBox[{"SUN1", ",", "SUN2"}], ")"}], "\[Rule]", "3"}], ",", 
    RowBox[{
     RowBox[{"Mat", "(", 
      RowBox[{"SUN1", ",", "SUN1"}], ")"}], "\[Rule]", "9"}], ",", 
    RowBox[{
     RowBox[{"Mat", "(", 
      RowBox[{"SUN2", ",", "SUN2"}], ")"}], "\[Rule]", "9"}], ",", 
    RowBox[{
     RowBox[{"Mat", "(", 
      RowBox[{"SUN2", ",", "SUN1"}], ")"}], "\[Rule]", "3"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.478434730426236*^9, 3.478435200749498*^9, 3.478435233950212*^9, 
   3.478435426393788*^9, 3.478435591077346*^9, 3.478435927320691*^9, 
   3.478436057790335*^9, 3.478436928353135*^9, 3.479100063362775*^9, 
   3.479106358816292*^9, 3.479546864822269*^9, 3.479547348022377*^9, 
   3.479547714372858*^9, 3.497862106256465*^9, 3.4978625437919207`*^9, 
   3.497871428686603*^9, 3.497942496752326*^9, 3.498391216132546*^9, {
   3.4995217752940617`*^9, 3.499521788279874*^9}, 3.499583168961454*^9, 
   3.499584777637652*^9, 3.4995857253323097`*^9, 3.499663294228547*^9, 
   3.499663719271462*^9, 3.500627923555628*^9, 3.500718343963676*^9, 
   3.5009805643292217`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"_Hel", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hel", "=", 
   RowBox[{"HelicityME", "[", "M", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.478435272631223*^9, 3.478435280805309*^9}, {
   3.478435549596737*^9, 3.478435557227066*^9}, {3.478436067208497*^9, 
   3.478436071671449*^9}, {3.478436592499899*^9, 3.478436607261712*^9}, 
   3.479547354402557*^9, {3.499521790978319*^9, 3.499521791276463*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "25", 
    "\[InvisibleSpace]", "\<\" helicity matrix elements\"\>"}],
   SequenceForm["> ", 25, " helicity matrix elements"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.499521791849257*^9, 3.4995831697897243`*^9, 
  3.499584780324565*^9, 3.499585726563333*^9, 3.4996632953146973`*^9, 
  3.4996637203987007`*^9, 3.500627928184684*^9, 3.500718345225178*^9, 
  3.500980564974576*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.499521791849257*^9, 3.4995831697897243`*^9, 
  3.499584780324565*^9, 3.499585726563333*^9, 3.4996632953146973`*^9, 
  3.4996637203987007`*^9, 3.500627928184684*^9, 3.500718345225178*^9, 
  3.5009805650678368`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.499521791849257*^9, 3.4995831697897243`*^9, 
  3.499584780324565*^9, 3.499585726563333*^9, 3.4996632953146973`*^9, 
  3.4996637203987007`*^9, 3.500627928184684*^9, 3.500718345225178*^9, 
  3.500980565232149*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{3.499521791849257*^9, 3.4995831697897243`*^9, 
  3.499584780324565*^9, 3.499585726563333*^9, 3.4996632953146973`*^9, 
  3.4996637203987007`*^9, 3.500627928184684*^9, 3.500718345225178*^9, 
  3.5009805653713493`*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.499521791849257*^9, 3.4995831697897243`*^9, 
  3.499584780324565*^9, 3.499585726563333*^9, 3.4996632953146973`*^9, 
  3.4996637203987007`*^9, 3.500627928184684*^9, 3.500718345225178*^9, 
  3.500980566254579*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"M2", "=", 
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"SquaredME", "[", "M", "]"}], "/.", "col"}], "/.", "hel"}], 
        "/.", "M$FACouplings"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Me", "\[Rule]", "0"}], ",", 
         RowBox[{"MB2", "\[Rule]", "0"}], ",", 
         RowBox[{"MU2", "\[Rule]", "0"}], ",", 
         RowBox[{"MD2", "\[Rule]", "0"}]}], "}"}]}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"v", "\[Element]", "Reals"}], ",", 
         RowBox[{"Lambda", "\[Element]", "Reals"}], ",", 
         RowBox[{"sw", "\[Element]", "Reals"}], ",", 
         RowBox[{"CKM33", "\[Element]", "Reals"}], ",", 
         RowBox[{"MTri", "\[Element]", "Reals"}]}], "}"}]}]}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Den", "[", 
       RowBox[{"a_", ",", "b_"}], "]"}], "\[Rule]", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "-", "b"}], ")"}]}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.478436009927547*^9, 3.478436018997932*^9}, {
   3.478436082403898*^9, 3.478436090700395*^9}, {3.478436177508675*^9, 
   3.47843618204671*^9}, {3.478437003898071*^9, 3.47843701110685*^9}, {
   3.478437477803822*^9, 3.478437504302616*^9}, {3.479106936214095*^9, 
   3.479106948049022*^9}, {3.479107333470424*^9, 3.479107353663611*^9}, 
   3.497862123314191*^9, {3.497862166292612*^9, 3.4978621787574587`*^9}, {
   3.4978624132489767`*^9, 3.497862416365185*^9}, {3.497862613296958*^9, 
   3.4978626363483677`*^9}, {3.4978627990282288`*^9, 3.497862817305622*^9}, {
   3.4994966280769463`*^9, 3.499496630940941*^9}, {3.499522073425353*^9, 
   3.499522099311701*^9}, {3.499522162407353*^9, 3.499522175295724*^9}, {
   3.499522628018228*^9, 3.4995226310463467`*^9}, {3.499580340522955*^9, 
   3.499580351425118*^9}, 3.500627939698078*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M2bis", " ", "=", " ", 
  RowBox[{
   RowBox[{"Normal", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"M2", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Conjugate", "[", "MTri", "]"}], "\[Rule]", "Lambda"}], 
          ",", 
          RowBox[{
           RowBox[{"Conjugate", "[", "MTri8", "]"}], "\[Rule]", "Lambda"}], 
          ",", 
          RowBox[{"MTri", "\[Rule]", "Lambda"}], ",", 
          RowBox[{"MTri8", "->", "Lambda"}]}], "}"}]}], ")"}], ",", 
      RowBox[{"{", 
       RowBox[{"Lambda", ",", "\[Infinity]", ",", "2"}], "}"}]}], "]"}], 
    "]"}], "*", 
   RowBox[{"4", "/", "9"}]}]}]], "Input",
 CellChangeTimes->{{3.500628083133654*^9, 3.500628139146862*^9}, {
   3.5006281702669773`*^9, 3.500628172301248*^9}, 3.500628257309023*^9, {
   3.500628403783983*^9, 3.5006284048492317`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["4", "9"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"9", " ", "U", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Alfa2", " ", "CKM11", " ", 
          SuperscriptBox["CKM33", "2"], " ", 
          SuperscriptBox["\[Pi]", "2"], " ", "U", " ", 
          SuperscriptBox["CKM11", "\[Conjugate]"]}], "-", 
         RowBox[{"Alfa2", " ", "CKM11", " ", 
          SuperscriptBox["CKM33", "2"], " ", "MT2", " ", 
          SuperscriptBox["\[Pi]", "2"], " ", 
          SuperscriptBox["CKM11", "\[Conjugate]"]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"MW2", "-", "S"}], ")"}], "2"], " ", 
       SuperscriptBox["sw", "4"]}]], "+", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", " ", "Alfa", " ", 
        SuperscriptBox["Lambda", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"MW2", "-", "S"}], ")"}], "2"], " ", 
        SuperscriptBox["sw", "4"]}]], 
      RowBox[{"9", " ", "U", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
         "2", " ", "Alfa2", " ", "CKM11", " ", "CKM33", " ", "gT", " ", "gTl",
           " ", "MT2", " ", "\[Pi]", " ", "S", " ", 
          SuperscriptBox["sw", "2"]}], "-", 
         RowBox[{
         "2", " ", "Alfa2", " ", "CKM11", " ", "CKM33", " ", "gT", " ", "gTl",
           " ", "\[Pi]", " ", "S", " ", "U", " ", 
          SuperscriptBox["sw", "2"]}], "+", 
         RowBox[{
         "2", " ", "Alfa2", " ", "CKM11", " ", "CKM33", " ", "gT", " ", "gTl",
           " ", "MW2", " ", "\[Pi]", " ", "U", " ", 
          SuperscriptBox["sw", "2"]}], "+", 
         RowBox[{
         "2", " ", "Alfa2", " ", "CKM33", " ", "MT2", " ", "\[Pi]", " ", "S", 
          " ", 
          SuperscriptBox["CKM11", "\[Conjugate]"], " ", 
          SuperscriptBox["gT", "\[Conjugate]"], " ", 
          SuperscriptBox["gTl", "\[Conjugate]"], " ", 
          SuperscriptBox["sw", "2"]}], "-", 
         RowBox[{
         "2", " ", "Alfa2", " ", "CKM33", " ", "\[Pi]", " ", "S", " ", "U", 
          " ", 
          SuperscriptBox["CKM11", "\[Conjugate]"], " ", 
          SuperscriptBox["gT", "\[Conjugate]"], " ", 
          SuperscriptBox["gTl", "\[Conjugate]"], " ", 
          SuperscriptBox["sw", "2"]}], "+", 
         RowBox[{
         "2", " ", "Alfa2", " ", "CKM33", " ", "MW2", " ", "\[Pi]", " ", "U", 
          " ", 
          SuperscriptBox["CKM11", "\[Conjugate]"], " ", 
          SuperscriptBox["gT", "\[Conjugate]"], " ", 
          SuperscriptBox["gTl", "\[Conjugate]"], " ", 
          SuperscriptBox["sw", "2"]}], "-", 
         RowBox[{
         "2", " ", "Alfa2", " ", "CKM33", " ", "MT2", " ", "MW2", " ", 
          "\[Pi]", " ", 
          SuperscriptBox["CKM11", "\[Conjugate]"], " ", 
          SuperscriptBox["gT", "\[Conjugate]"], " ", 
          SuperscriptBox["gTl", "\[Conjugate]"], " ", 
          SuperscriptBox["sw", "2"]}], "-", 
         RowBox[{
         "2", " ", "Alfa2", " ", "CKM11", " ", "CKM33", " ", "gT", " ", "gTl",
           " ", "MT2", " ", "MW2", " ", "\[Pi]", " ", 
          SuperscriptBox["sw", "2"]}], "+", 
         RowBox[{
          SqrtBox["2"], " ", "Alfa2", " ", "CKM11", " ", "CKM33", " ", "CtW", 
          " ", "EL", " ", "MT", " ", "\[Pi]", " ", "T", " ", "v", " ", 
          SuperscriptBox["CKM11", "\[Conjugate]"], " ", "sw"}], "+", 
         RowBox[{
          SqrtBox["2"], " ", "Alfa2", " ", "CKM11", " ", "CKM33", " ", "CtW", 
          " ", "EL", " ", "MT", " ", "\[Pi]", " ", "U", " ", "v", " ", 
          SuperscriptBox["CKM11", "\[Conjugate]"], " ", "sw"}], "-", 
         RowBox[{
          SqrtBox["2"], " ", "Alfa2", " ", "CKM11", " ", "CKM33", " ", "CtW", 
          " ", "EL", " ", "MT", " ", "MT2", " ", "\[Pi]", " ", "v", " ", 
          SuperscriptBox["CKM11", "\[Conjugate]"], " ", "sw"}], "+", 
         RowBox[{
          SqrtBox["2"], " ", "Alfa2", " ", "CKM11", " ", "CKM33", " ", "EL", 
          " ", "MT", " ", "\[Pi]", " ", "T", " ", "v", " ", 
          SuperscriptBox["CKM11", "\[Conjugate]"], " ", 
          SuperscriptBox["CtW", "\[Conjugate]"], " ", "sw"}], "+", 
         RowBox[{
          SqrtBox["2"], " ", "Alfa2", " ", "CKM11", " ", "CKM33", " ", "EL", 
          " ", "MT", " ", "\[Pi]", " ", "U", " ", "v", " ", 
          SuperscriptBox["CKM11", "\[Conjugate]"], " ", 
          SuperscriptBox["CtW", "\[Conjugate]"], " ", "sw"}], "-", 
         RowBox[{
          SqrtBox["2"], " ", "Alfa2", " ", "CKM11", " ", "CKM33", " ", "EL", 
          " ", "MT", " ", "MT2", " ", "\[Pi]", " ", "v", " ", 
          SuperscriptBox["CKM11", "\[Conjugate]"], " ", 
          SuperscriptBox["CtW", "\[Conjugate]"], " ", "sw"}], "+", 
         RowBox[{
         "2", " ", "Alfa", " ", "Alfa2", " ", "C3phiq", " ", "CKM11", " ", 
          "CKM33", " ", 
          SuperscriptBox["\[Pi]", "2"], " ", "U", " ", 
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["CKM11", "\[Conjugate]"]}], "-", 
         RowBox[{
         "2", " ", "Alfa", " ", "Alfa2", " ", "C3phiq", " ", "CKM11", " ", 
          "CKM33", " ", "MT2", " ", 
          SuperscriptBox["\[Pi]", "2"], " ", 
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["CKM11", "\[Conjugate]"]}], "+", 
         RowBox[{
         "2", " ", "Alfa", " ", "Alfa2", " ", "CKM11", " ", "CKM33", " ", 
          SuperscriptBox["\[Pi]", "2"], " ", "U", " ", 
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["C3phiq", "\[Conjugate]"], " ", 
          SuperscriptBox["CKM11", "\[Conjugate]"]}], "-", 
         RowBox[{
         "2", " ", "Alfa", " ", "Alfa2", " ", "CKM11", " ", "CKM33", " ", 
          "MT2", " ", 
          SuperscriptBox["\[Pi]", "2"], " ", 
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["C3phiq", "\[Conjugate]"], " ", 
          SuperscriptBox["CKM11", "\[Conjugate]"]}]}], ")"}]}]}]}], ")"}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.500628131074225*^9, 3.50062814789496*^9}, 
   3.5006282578676033`*^9, 3.5006284094744377`*^9, 3.5007183689198303`*^9, 
   3.500980604751898*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SM", "=", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Coefficient", "[", 
      RowBox[{
       RowBox[{"M2bis", "/.", 
        RowBox[{"Lambda", "\[Rule]", 
         RowBox[{"1", "/", "Lrep"}]}]}], ",", "Lrep", ",", "0"}], "]"}], "/.",
      
     RowBox[{"Lrep", "\[Rule]", 
      RowBox[{"1", "/", "Lambda"}]}]}], "]"}], "/.", 
   RowBox[{"Alfa2", "\[Rule]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"g", "^", "2"}], "*", 
       RowBox[{
        RowBox[{
         RowBox[{"sw", "^", "2"}], "/", "4"}], "/", "\[Pi]"}]}], ")"}], "^", 
     "2"}]}]}]}]], "Input",
 CellChangeTimes->{{3.479107390301893*^9, 3.479107487977641*^9}, {
   3.497862153269348*^9, 3.4978621630633917`*^9}, {3.497862211884811*^9, 
   3.497862355442546*^9}, {3.497871464219926*^9, 3.4978714701498127`*^9}, {
   3.497872139341824*^9, 3.497872173963148*^9}, 3.497872208436336*^9, {
   3.499496633870757*^9, 3.499496634114503*^9}, {3.499522120118948*^9, 
   3.4995221502054234`*^9}, {3.4995831777997723`*^9, 3.499583178257844*^9}, {
   3.5006280214343977`*^9, 3.5006280541734324`*^9}, {3.500628277028809*^9, 
   3.500628299856646*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"CKM11", " ", 
    SuperscriptBox["CKM33", "2"], " ", 
    SuperscriptBox["g", "4"], " ", "U", " ", 
    RowBox[{"(", 
     RowBox[{"U", "-", "MT2"}], ")"}], " ", 
    SuperscriptBox["CKM11", "\[Conjugate]"]}], 
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"MW2", "-", "S"}], ")"}], "2"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.479107432084265*^9, {3.479107479011856*^9, 3.47910748870907*^9}, 
   3.479546898992261*^9, 3.479547373602786*^9, 3.47954772133109*^9, {
   3.49786218934586*^9, 3.4978622417535763`*^9}, {3.497862328456608*^9, 
   3.497862356340589*^9}, 3.4978624247687893`*^9, 3.497862548456053*^9, 
   3.497862603630416*^9, 3.497862643361876*^9, 3.497862823146008*^9, 
   3.497871437274989*^9, 3.497871470884967*^9, 3.497872174954796*^9, 
   3.497872208727311*^9, 3.4979425037893133`*^9, 3.4983912314140177`*^9, 
   3.4995220355488*^9, 3.499522109861052*^9, 3.49952218368876*^9, 
   3.4995226445155478`*^9, 3.499580356527287*^9, 3.49958318032283*^9, 
   3.49958480327499*^9, 3.499585736439041*^9, 3.499663316352057*^9, 
   3.4996637258165617`*^9, 3.50062797430942*^9, 3.5006283011304283`*^9, 
   3.500628412527124*^9, 3.5006284538642387`*^9, 3.50071837178924*^9, {
   3.5009805988717947`*^9, 3.500980608655898*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I3phiq", "=", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{
         RowBox[{"M2bis", "/.", 
          RowBox[{"Lambda", "\[Rule]", 
           RowBox[{"1", "/", "Lrep"}]}]}], ",", "Lrep", ",", "2"}], "]"}], "/.",
        
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Lrep", "\[Rule]", 
          RowBox[{"1", "/", "Lambda"}]}], ",", 
         RowBox[{"CtW", "\[Rule]", "0"}], ",", 
         RowBox[{"gT", "\[Rule]", "0"}]}], "}"}]}], "/.", 
      RowBox[{"Alfa2", "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"g", "^", "2"}], "*", 
          RowBox[{
           RowBox[{
            RowBox[{"sw", "^", "2"}], "/", "4"}], "/", "\[Pi]"}]}], ")"}], 
        "^", "2"}]}]}], "/.", 
     RowBox[{"Alfa2", "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"g", "^", "2"}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"sw", "^", "2"}], "/", "4"}], "/", "\[Pi]"}]}], ")"}], "^",
        "2"}]}]}], "]"}], "/", 
   RowBox[{"Lambda", "^", "2"}]}]}]], "Input",
 CellChangeTimes->{
  3.497862652569742*^9, {3.497871477077907*^9, 3.497871482621311*^9}, {
   3.4978715422628403`*^9, 3.497871560455545*^9}, 3.497872247138032*^9, {
   3.499496636684917*^9, 3.4994966368992357`*^9}, {3.499522288618387*^9, 
   3.499522294251347*^9}, {3.499583183124159*^9, 3.4995831877077637`*^9}, 
   3.499663783981332*^9, {3.5006283191598053`*^9, 3.5006283795487347`*^9}, 
   3.500628463732111*^9, {3.500628500729075*^9, 3.5006285055746393`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{"CKM11", " ", "CKM33", " ", 
     SuperscriptBox["g", "4"], " ", 
     RowBox[{"(", 
      RowBox[{"MT2", "-", "U"}], ")"}], " ", "U", " ", 
     SuperscriptBox["v", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"C3phiq", "+", 
       SuperscriptBox["C3phiq", "\[Conjugate]"]}], ")"}], " ", 
     SuperscriptBox["CKM11", "\[Conjugate]"]}], 
    RowBox[{"4", " ", 
     SuperscriptBox["Lambda", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"MW2", "-", "S"}], ")"}], "2"]}]]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.4978626530863867`*^9, 3.497862825140256*^9, 3.497871484101454*^9, 
   3.49787152665973*^9, 3.497871560798565*^9, 3.497872248273581*^9, 
   3.4979425057500362`*^9, 3.498391234071066*^9, 3.499522295018914*^9, 
   3.499522646017418*^9, 3.4995803707362967`*^9, 3.499583189303553*^9, 
   3.499584806506563*^9, 3.499585738378695*^9, 3.499663319640636*^9, 
   3.499663728451006*^9, 3.499663784906847*^9, {3.50062832825768*^9, 
   3.5006283804491034`*^9}, 3.500628417747555*^9, {3.500628457826354*^9, 
   3.500628464641365*^9}, 3.50062850587543*^9, 3.500718375563972*^9, 
   3.500980610668749*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"I3phiq", "/", "SM"}], "]"}]], "Input",
 CellChangeTimes->{{3.499583191528366*^9, 3.499583201664501*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    SuperscriptBox["v", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"C3phiq", "+", 
      SuperscriptBox["C3phiq", "\[Conjugate]"]}], ")"}]}], 
   RowBox[{"CKM33", " ", 
    SuperscriptBox["Lambda", "2"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.4995832034091187`*^9, 3.4995848104919643`*^9, 3.499585740418158*^9, 
   3.499663321515193*^9, 3.499663730772831*^9, 3.499663789395797*^9, {
   3.500628493218745*^9, 3.500628507609191*^9}, 3.500718391481359*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Coefficient", "[", 
      RowBox[{
       RowBox[{"M2bis", "/.", 
        RowBox[{"Lambda", "\[Rule]", 
         RowBox[{"1", "/", "Lrep"}]}]}], ",", "Lrep", ",", "2"}], "]"}], "/.",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Lrep", "\[Rule]", 
        RowBox[{"1", "/", "Lambda"}]}], ",", 
       RowBox[{"C3phiq", "\[Rule]", "0"}], ",", 
       RowBox[{"gT", "\[Rule]", "0"}]}], "}"}]}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Alfa2", "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"g", "^", "2"}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"sw", "^", "2"}], "/", "4"}], "/", "\[Pi]"}]}], ")"}], "^",
        "2"}]}], ",", 
     RowBox[{"Alfa", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"g", "^", "2"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"sw", "^", "2"}], "/", "4"}], "/", "\[Pi]"}]}], ")"}]}]}], 
    "}"}]}], "/.", 
  RowBox[{"v", "\[Rule]", 
   RowBox[{"2", "MW", " ", 
    RowBox[{"sw", "/", "EL"}]}]}]}]], "Input",
 CellChangeTimes->{{3.497871610887577*^9, 3.497871617629863*^9}, {
  3.497872251640006*^9, 3.49787227096323*^9}, {3.4978725133447638`*^9, 
  3.497872535294683*^9}, {3.499496640008424*^9, 3.4994966402456207`*^9}, {
  3.4995223189020023`*^9, 3.4995223246360807`*^9}, {3.500628518469676*^9, 
  3.500628560043779*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SqrtBox["2"], " ", "CKM11", " ", "CKM33", " ", 
     SuperscriptBox["g", "2"], " ", "MT", " ", "MW", " ", 
     RowBox[{"(", 
      RowBox[{"MT2", "-", "T", "-", "U"}], ")"}], " ", "U", " ", 
     SuperscriptBox["CKM11", "\[Conjugate]"], " ", 
     RowBox[{"(", 
      RowBox[{"CtW", "+", 
       SuperscriptBox["CtW", "\[Conjugate]"]}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"MW2", "-", "S"}], ")"}], "2"]]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.497871619084063*^9, {3.497872252601283*^9, 3.4978722716892776`*^9}, 
   3.497872536191465*^9, 3.49794250746635*^9, 3.498391237200657*^9, 
   3.49952232746139*^9, 3.499522647391*^9, 3.499580423160551*^9, 
   3.499584816191203*^9, 3.499585742588132*^9, 3.499663391307857*^9, {
   3.500628528569908*^9, 3.500628561563349*^9}, 3.500718399647006*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{
         RowBox[{"M2bis", "/.", 
          RowBox[{"Lambda", "\[Rule]", 
           RowBox[{"1", "/", "Lrep"}]}]}], ",", "Lrep", ",", "2"}], "]"}], "/.",
        
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Lrep", "\[Rule]", 
          RowBox[{"1", "/", "Lambda"}]}], ",", 
         RowBox[{"C3phiq", "\[Rule]", "0"}], ",", 
         RowBox[{"CtW", "\[Rule]", "0"}]}], "}"}]}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"gT", "\[Element]", "Reals"}], ",", 
         RowBox[{"gTl", "\[Element]", "Reals"}], ",", 
         RowBox[{"CKM11", "\[Element]", "Reals"}]}], "}"}]}]}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Alfa2", "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"g", "^", "2"}], "*", 
          RowBox[{
           RowBox[{
            RowBox[{"sw", "^", "2"}], "/", "4"}], "/", "\[Pi]"}]}], ")"}], 
        "^", "2"}]}], ",", 
      RowBox[{"Alfa", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"g", "^", "2"}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"sw", "^", "2"}], "/", "4"}], "/", "\[Pi]"}]}], ")"}]}]}], 
     "}"}]}], "/.", 
   RowBox[{"v", "\[Rule]", 
    RowBox[{"2", "MW", " ", 
     RowBox[{"sw", "/", "EL"}]}]}]}], "/.", 
  RowBox[{"gTl", "\[Rule]", 
   RowBox[{"C13qq", "/", "gT"}]}]}]], "Input",
 CellChangeTimes->{{3.4995224524460087`*^9, 3.499522509872376*^9}, 
   3.499522653969439*^9, {3.500628592789551*^9, 3.50062869561724*^9}, {
   3.50062875629522*^9, 3.500628765832335*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", "C13qq", " ", "CKM11", " ", "CKM33", " ", 
     SuperscriptBox["g", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"MT2", "-", "U"}], ")"}], " ", "U"}], 
    RowBox[{"MW2", "-", "S"}]]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.499522461582746*^9, 3.499522511298319*^9}, {
   3.499522648806151*^9, 3.499522654474715*^9}, 3.4995848197254868`*^9, 
   3.499585745130802*^9, {3.4996634003402653`*^9, 3.499663423638483*^9}, {
   3.500628600936021*^9, 3.5006286284218073`*^9}, {3.500628669721744*^9, 
   3.5006286966319227`*^9}, 3.5006287670234623`*^9, 3.500718494132983*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Normal", "[", 
       RowBox[{"Series", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"M2", "/.", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"Conjugate", "[", "MTri", "]"}], "\[Rule]", "Lambda"}], 
             ",", 
             RowBox[{
              RowBox[{"Conjugate", "[", "MTri8", "]"}], "\[Rule]", "Lambda"}],
              ",", 
             RowBox[{"MTri", "\[Rule]", "Lambda"}], ",", 
             RowBox[{"MTri8", "->", "Lambda"}]}], "}"}]}], ")"}], ",", 
         RowBox[{"{", 
          RowBox[{"Lambda", ",", "\[Infinity]", ",", "4"}], "}"}]}], "]"}], 
       "]"}], "*", 
      RowBox[{"4", "/", "9"}]}], "-", "M2bis"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"gT8", "\[Rule]", "0"}], ",", 
      RowBox[{"CtW", "\[Rule]", "0"}], ",", 
      RowBox[{"gT", "\[Rule]", "0"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.50098061601186*^9, 3.500980715844986*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"4", " ", "Alfa2", " ", "C3phiq", " ", "CKM11", " ", 
    SuperscriptBox["\[Pi]", "2"], " ", "U", " ", 
    RowBox[{"(", 
     RowBox[{"U", "-", "MT2"}], ")"}], " ", 
    SuperscriptBox["v", "4"], " ", 
    SuperscriptBox["C3phiq", "\[Conjugate]"], " ", 
    SuperscriptBox["CKM11", "\[Conjugate]"]}], 
   RowBox[{
    SuperscriptBox["Lambda", "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"MW2", "-", "S"}], ")"}], "2"], " ", 
    SuperscriptBox["sw", "4"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{3.500980737442081*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["g b->t W", "Subtitle",
 CellChangeTimes->{{3.4778117420706997`*^9, 3.4778117447507*^9}, {
  3.497862048812056*^9, 3.497862055502046*^9}, {3.499496596319121*^9, 
  3.4994966035710382`*^9}, {3.499600295559596*^9, 3.499600302010282*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.448968342513181*^9, 3.448968344880295*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\</home/degrande/eta/FeynProg/FeynArts-3.5\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "FeynArts`"}]}], "Input",
 CellChangeTimes->{
  3.4777456682883*^9, 3.478434363232997*^9, {3.4978572265868073`*^9, 
   3.4978572271791267`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478434366177163*^9, 3.478435570663394*^9, 3.478435703141808*^9, 
   3.478436820027009*^9, {3.479038946238288*^9, 3.479038952669886*^9}, 
   3.47909796405005*^9, 3.479099042060194*^9, 3.479099989966432*^9, 
   3.479106322136636*^9, 3.479546671218491*^9, 3.47954731586526*^9, 
   3.479547695541888*^9, 3.497857241645294*^9, 3.4978620645824203`*^9, 
   3.497862527772278*^9, 3.497871404570545*^9, 3.4979424788339853`*^9, 
   3.498391193496977*^9, 3.499508864100067*^9, 3.499521741782934*^9, 
   3.4995831578974943`*^9, {3.499584268361443*^9, 3.499584295560235*^9}, 
   3.499584333899542*^9, 3.4995857048002872`*^9, 3.4995936758763742`*^9, 
   3.499600375952565*^9, 3.499664661934032*^9, 3.499665377631999*^9, {
   3.499666608507955*^9, 3.499666620942053*^9}, 3.5001872197849092`*^9, 
   3.500187672662253*^9, 3.5003855154195833`*^9, 3.5006170786628447`*^9, 
   3.500617540935507*^9, 3.5006179767633047`*^9, 3.500618280374544*^9, 
   3.500620018874608*^9, 3.50062757473238*^9, 3.500718527335946*^9}],

Cell[BoxData[
 FormBox["\<\"FeynArts 3.5\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478434366177163*^9, 3.478435570663394*^9, 3.478435703141808*^9, 
   3.478436820027009*^9, {3.479038946238288*^9, 3.479038952669886*^9}, 
   3.47909796405005*^9, 3.479099042060194*^9, 3.479099989966432*^9, 
   3.479106322136636*^9, 3.479546671218491*^9, 3.47954731586526*^9, 
   3.479547695541888*^9, 3.497857241645294*^9, 3.4978620645824203`*^9, 
   3.497862527772278*^9, 3.497871404570545*^9, 3.4979424788339853`*^9, 
   3.498391193496977*^9, 3.499508864100067*^9, 3.499521741782934*^9, 
   3.4995831578974943`*^9, {3.499584268361443*^9, 3.499584295560235*^9}, 
   3.499584333899542*^9, 3.4995857048002872`*^9, 3.4995936758763742`*^9, 
   3.499600375952565*^9, 3.499664661934032*^9, 3.499665377631999*^9, {
   3.499666608507955*^9, 3.499666620942053*^9}, 3.5001872197849092`*^9, 
   3.500187672662253*^9, 3.5003855154195833`*^9, 3.5006170786628447`*^9, 
   3.500617540935507*^9, 3.5006179767633047`*^9, 3.500618280374544*^9, 
   3.500620018874608*^9, 3.50062757473238*^9, 3.5007185274091454`*^9}],

Cell[BoxData[
 FormBox["\<\"by Hagen Eck, Sepp Kueblbeck, and Thomas Hahn\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478434366177163*^9, 3.478435570663394*^9, 3.478435703141808*^9, 
   3.478436820027009*^9, {3.479038946238288*^9, 3.479038952669886*^9}, 
   3.47909796405005*^9, 3.479099042060194*^9, 3.479099989966432*^9, 
   3.479106322136636*^9, 3.479546671218491*^9, 3.47954731586526*^9, 
   3.479547695541888*^9, 3.497857241645294*^9, 3.4978620645824203`*^9, 
   3.497862527772278*^9, 3.497871404570545*^9, 3.4979424788339853`*^9, 
   3.498391193496977*^9, 3.499508864100067*^9, 3.499521741782934*^9, 
   3.4995831578974943`*^9, {3.499584268361443*^9, 3.499584295560235*^9}, 
   3.499584333899542*^9, 3.4995857048002872`*^9, 3.4995936758763742`*^9, 
   3.499600375952565*^9, 3.499664661934032*^9, 3.499665377631999*^9, {
   3.499666608507955*^9, 3.499666620942053*^9}, 3.5001872197849092`*^9, 
   3.500187672662253*^9, 3.5003855154195833`*^9, 3.5006170786628447`*^9, 
   3.500617540935507*^9, 3.5006179767633047`*^9, 3.500618280374544*^9, 
   3.500620018874608*^9, 3.50062757473238*^9, 3.500718527451728*^9}],

Cell[BoxData[
 FormBox["\<\"last revised 16 Apr 10\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478434366177163*^9, 3.478435570663394*^9, 3.478435703141808*^9, 
   3.478436820027009*^9, {3.479038946238288*^9, 3.479038952669886*^9}, 
   3.47909796405005*^9, 3.479099042060194*^9, 3.479099989966432*^9, 
   3.479106322136636*^9, 3.479546671218491*^9, 3.47954731586526*^9, 
   3.479547695541888*^9, 3.497857241645294*^9, 3.4978620645824203`*^9, 
   3.497862527772278*^9, 3.497871404570545*^9, 3.4979424788339853`*^9, 
   3.498391193496977*^9, 3.499508864100067*^9, 3.499521741782934*^9, 
   3.4995831578974943`*^9, {3.499584268361443*^9, 3.499584295560235*^9}, 
   3.499584333899542*^9, 3.4995857048002872`*^9, 3.4995936758763742`*^9, 
   3.499600375952565*^9, 3.499664661934032*^9, 3.499665377631999*^9, {
   3.499666608507955*^9, 3.499666620942053*^9}, 3.5001872197849092`*^9, 
   3.500187672662253*^9, 3.5003855154195833`*^9, 3.5006170786628447`*^9, 
   3.500617540935507*^9, 3.5006179767633047`*^9, 3.500618280374544*^9, 
   3.500620018874608*^9, 3.50062757473238*^9, 3.500718527492084*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"topo", " ", "=", " ", 
   RowBox[{"CreateTopologies", "[", 
    RowBox[{"0", ",", 
     RowBox[{"2", "\[Rule]", "2"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.47548813810296*^9, 3.475488972088063*^9, {3.4777456120408*^9, 
   3.4777456332583*^9}, 3.4778098132447*^9, 3.4778110152581997`*^9, {
   3.497857235135571*^9, 3.497857237590866*^9}, {3.499496482154114*^9, 
   3.499496485211625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Paint", "[", "topo", "]"}]], "Input",
 CellChangeTimes->{{3.4777456818157997`*^9, 3.4777456889958*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456900683002`*^9, 3.478435704755388*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 2, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456900683002`*^9, 3.47843570476089*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 3, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456900683002`*^9, 3.47843570476613*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 4, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456900683002`*^9, 3.478435704771953*^9}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-9.094947017729282*^-12, 15.000000000003638`}, {
        9.999999999983629, 10.000000000007276`}}], 
       LineBox[{{-9.094947017729282*^-12, 4.999999999996362}, {
        9.999999999985448, 9.999999999989086}}], 
       LineBox[{{20.000000000009095`, 15.000000000003638`}, {
        10.000000000009095`, 10.000000000003638`}}], 
       LineBox[{{20., 5.}, {10., 10.}}], 
       {PointSize[0.04], PointBox[{10., 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 44}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], LineBox[{{5.999999999990206, 10.}, {13.999999999982224`, 
        10.}}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T2\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{6.139089236967266*^-12, 15.}, {10.000000000002046`, 
        14.000000000003638`}}], 
       LineBox[{{-7.503331289626658*^-12, 5.000000000003638}, {
        9.999999999988404, 6.}}], 
       LineBox[{{20.000000000002956`, 15.}, {10.000000000002956`, 14.}}], 
       LineBox[{{19.999999999997726`, 4.999999999996362}, {9.999999999997726, 
        5.999999999996362}}], 
       LineBox[{{10., 14.000000000000902`}, {10., 6.000000000000003}}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T3\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{6.139089236967266*^-12, 15.}, {10.000000000002046`, 
        14.000000000003638`}}], 
       LineBox[{{-7.503331289626658*^-12, 5.000000000003638}, {
        9.999999999988404, 6.}}], 
       LineBox[{{20.00000000000182, 15.}, {10., 6.}}], 
       LineBox[{{20.00000000000182, 5.}, {10., 14.}}], 
       LineBox[{{10., 14.000000000000902`}, {10., 6.000000000000003}}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T4\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 22}, {0, 0}, {22, 22}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"2\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {28.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[RightArrow]\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {33., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"2\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {37.5, 69.96}, {0, 0}]},
   AspectRatio->1.0999999999999999`,
   PlotRange->{{0, 66}, {0, 72.6}}], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456900683002`*^9, 3.478435705080669*^9}]
}, Closed]],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"FeynArtsGraphics", "(", 
    RowBox[{"2", "\[Rule]", "2"}], ")"}], "\[InvisibleApplication]", 
   RowBox[{"(", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T2\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T2", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T3\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T3", "]"],
           Editable->False],
          TraditionalForm]},
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T4\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T4", "]"],
           Editable->False],
          TraditionalForm], "Null", "Null"},
        {"Null", "Null", "Null"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.4777456905908003`*^9, 3.478435705207405*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"INTopo", "=", " ", 
   RowBox[{"InsertFields", "[", 
    RowBox[{"topo", ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"V", "[", "4", "]"}], ",", 
        RowBox[{"F", "[", "12", "]"}]}], "}"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"F", "[", "9", "]"}], ",", 
        RowBox[{"-", 
         RowBox[{"V", "[", "3", "]"}]}]}], "}"}]}], ",", 
     RowBox[{"GenericModel", "\[Rule]", "\"\<TopEffTh_FA/TopEffTh_FA\>\""}], 
     ",", 
     RowBox[{"Model", "\[Rule]", "\"\<TopEffTh_FA/TopEffTh_FA\>\""}], ",", 
     RowBox[{"InsertionLevel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Generic", ",", " ", "Classes", ",", "Particles"}], "}"}]}]}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4778060034077*^9, 3.4778060172207003`*^9}, {
   3.4778061181482*^9, 3.4778062060957003`*^9}, {3.4778064622107*^9, 
   3.4778064974032*^9}, {3.4778096875622*^9, 3.4778097175422*^9}, {
   3.4778099067622004`*^9, 3.4778099081296997`*^9}, {3.4778111168007*^9, 
   3.4778111226157*^9}, {3.4778115172907*^9, 3.4778115174282*^9}, 
   3.478437845209915*^9, {3.479546689667869*^9, 3.479546718821388*^9}, {
   3.479546793843457*^9, 3.47954680051448*^9}, {3.497857256699514*^9, 
   3.497857324742622*^9}, {3.497857383657874*^9, 3.497857387157604*^9}, {
   3.49785741944608*^9, 3.497857431156871*^9}, {3.497862502940681*^9, 
   3.497862507492491*^9}, {3.4983901274683743`*^9, 3.498390130073097*^9}, {
   3.499495582368535*^9, 3.499495584937093*^9}, {3.4994965044618607`*^9, 
   3.499496568155007*^9}, {3.499586356510202*^9, 3.499586373514152*^9}, 
   3.499586422762087*^9, {3.499600313523304*^9, 3.499600353271706*^9}, 
   3.499600405049478*^9, {3.499664538612829*^9, 3.499664569069028*^9}, {
   3.499664609164019*^9, 3.499664612307405*^9}, {3.500620000108306*^9, 
   3.500620004318939*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.4995088656056767`*^9, 3.499521746764072*^9, 
   3.499583159566346*^9, {3.4995842740010223`*^9, 3.499584335761942*^9}, 
   3.49958570691823*^9, 3.499586382125351*^9, 3.49959367732262*^9, {
   3.499600377315133*^9, 3.499600405834758*^9}, 3.4996645702709084`*^9, 
   3.499665384827684*^9, 3.4996666256151323`*^9, 3.500187224122608*^9, 
   3.500618288639703*^9, 3.500620019732819*^9, 3.500627575533286*^9, 
   3.500718528925969*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
    "\[InvisibleSpace]", "\<\"generic\"\>", 
    "\[InvisibleSpace]", "\<\" model file \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.gen\"\>"}],
   SequenceForm[
   "", "loading ", "generic", " model file ", 
    "/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.gen"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.4995088656056767`*^9, 3.499521746764072*^9, 
   3.499583159566346*^9, {3.4995842740010223`*^9, 3.499584335761942*^9}, 
   3.49958570691823*^9, 3.499586382125351*^9, 3.49959367732262*^9, {
   3.499600377315133*^9, 3.499600405834758*^9}, 3.4996645702709084`*^9, 
   3.499665384827684*^9, 3.4996666256151323`*^9, 3.500187224122608*^9, 
   3.500618288639703*^9, 3.500620019732819*^9, 3.500627575533286*^9, 
   3.5007185291286983`*^9}],

Cell[BoxData[
 FormBox["\<\"> $SVMixing is OFF\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.4995088656056767`*^9, 3.499521746764072*^9, 
   3.499583159566346*^9, {3.4995842740010223`*^9, 3.499584335761942*^9}, 
   3.49958570691823*^9, 3.499586382125351*^9, 3.49959367732262*^9, {
   3.499600377315133*^9, 3.499600405834758*^9}, 3.4996645702709084`*^9, 
   3.499665384827684*^9, 3.4996666256151323`*^9, 3.500187224122608*^9, 
   3.500618288639703*^9, 3.500620019732819*^9, 3.500627575533286*^9, 
   3.50071852914955*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"generic model \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", "\<\"TopEffTh_FA/TopEffTh_FA\"\>", "}"}], 
    "\[InvisibleSpace]", "\<\" initialized\"\>"}],
   SequenceForm[
   "generic model ", {"TopEffTh_FA/TopEffTh_FA"}, " initialized"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.4995088656056767`*^9, 3.499521746764072*^9, 
   3.499583159566346*^9, {3.4995842740010223`*^9, 3.499584335761942*^9}, 
   3.49958570691823*^9, 3.499586382125351*^9, 3.49959367732262*^9, {
   3.499600377315133*^9, 3.499600405834758*^9}, 3.4996645702709084`*^9, 
   3.499665384827684*^9, 3.4996666256151323`*^9, 3.500187224122608*^9, 
   3.500618288639703*^9, 3.500620019732819*^9, 3.500627575533286*^9, 
   3.5007185291801662`*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.4995088656056767`*^9, 3.499521746764072*^9, 
   3.499583159566346*^9, {3.4995842740010223`*^9, 3.499584335761942*^9}, 
   3.49958570691823*^9, 3.499586382125351*^9, 3.49959367732262*^9, {
   3.499600377315133*^9, 3.499600405834758*^9}, 3.4996645702709084`*^9, 
   3.499665384827684*^9, 3.4996666256151323`*^9, 3.500187224122608*^9, 
   3.500618288639703*^9, 3.500620019732819*^9, 3.500627575533286*^9, 
   3.5007185292155323`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
    "\[InvisibleSpace]", "\<\"classes\"\>", 
    "\[InvisibleSpace]", "\<\" model file \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.mod\"\>"}],
   SequenceForm[
   "", "loading ", "classes", " model file ", 
    "/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.mod"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.4995088656056767`*^9, 3.499521746764072*^9, 
   3.499583159566346*^9, {3.4995842740010223`*^9, 3.499584335761942*^9}, 
   3.49958570691823*^9, 3.499586382125351*^9, 3.49959367732262*^9, {
   3.499600377315133*^9, 3.499600405834758*^9}, 3.4996645702709084`*^9, 
   3.499665384827684*^9, 3.4996666256151323`*^9, 3.500187224122608*^9, 
   3.500618288639703*^9, 3.500620019732819*^9, 3.500627575533286*^9, 
   3.500718529244811*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "51", 
    "\[InvisibleSpace]", "\<\" particles (incl. antiparticles) in \"\>", 
    "\[InvisibleSpace]", "30", "\[InvisibleSpace]", "\<\" classes\"\>"}],
   SequenceForm[
   "> ", 51, " particles (incl. antiparticles) in ", 30, " classes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.4995088656056767`*^9, 3.499521746764072*^9, 
   3.499583159566346*^9, {3.4995842740010223`*^9, 3.499584335761942*^9}, 
   3.49958570691823*^9, 3.499586382125351*^9, 3.49959367732262*^9, {
   3.499600377315133*^9, 3.499600405834758*^9}, 3.4996645702709084`*^9, 
   3.499665384827684*^9, 3.4996666256151323`*^9, 3.500187224122608*^9, 
   3.500618288639703*^9, 3.500620019732819*^9, 3.500627575533286*^9, 
   3.500718529273018*^9}],

Cell[BoxData[
 FormBox["\<\"> $CounterTerms are ON\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.4995088656056767`*^9, 3.499521746764072*^9, 
   3.499583159566346*^9, {3.4995842740010223`*^9, 3.499584335761942*^9}, 
   3.49958570691823*^9, 3.499586382125351*^9, 3.49959367732262*^9, {
   3.499600377315133*^9, 3.499600405834758*^9}, 3.4996645702709084`*^9, 
   3.499665384827684*^9, 3.4996666256151323`*^9, 3.500187224122608*^9, 
   3.500618288639703*^9, 3.500620019732819*^9, 3.500627575533286*^9, 
   3.500718530276218*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "142", 
    "\[InvisibleSpace]", "\<\" vertices\"\>"}],
   SequenceForm["> ", 142, " vertices"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.4995088656056767`*^9, 3.499521746764072*^9, 
   3.499583159566346*^9, {3.4995842740010223`*^9, 3.499584335761942*^9}, 
   3.49958570691823*^9, 3.499586382125351*^9, 3.49959367732262*^9, {
   3.499600377315133*^9, 3.499600405834758*^9}, 3.4996645702709084`*^9, 
   3.499665384827684*^9, 3.4996666256151323`*^9, 3.500187224122608*^9, 
   3.500618288639703*^9, 3.500620019732819*^9, 3.500627575533286*^9, 
   3.50071853055928*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"classes model \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", "\<\"TopEffTh_FA/TopEffTh_FA\"\>", "}"}], 
    "\[InvisibleSpace]", "\<\" initialized\"\>"}],
   SequenceForm[
   "classes model ", {"TopEffTh_FA/TopEffTh_FA"}, " initialized"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.4995088656056767`*^9, 3.499521746764072*^9, 
   3.499583159566346*^9, {3.4995842740010223`*^9, 3.499584335761942*^9}, 
   3.49958570691823*^9, 3.499586382125351*^9, 3.49959367732262*^9, {
   3.499600377315133*^9, 3.499600405834758*^9}, 3.4996645702709084`*^9, 
   3.499665384827684*^9, 3.4996666256151323`*^9, 3.500187224122608*^9, 
   3.500618288639703*^9, 3.500620019732819*^9, 3.500627575533286*^9, 
   3.5007185314027357`*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.4995088656056767`*^9, 3.499521746764072*^9, 
   3.499583159566346*^9, {3.4995842740010223`*^9, 3.499584335761942*^9}, 
   3.49958570691823*^9, 3.499586382125351*^9, 3.49959367732262*^9, {
   3.499600377315133*^9, 3.499600405834758*^9}, 3.4996645702709084`*^9, 
   3.499665384827684*^9, 3.4996666256151323`*^9, 3.500187224122608*^9, 
   3.500618288639703*^9, 3.500620019732819*^9, 3.500627575533286*^9, 
   3.5007185316415854`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"Generic", ",", "Classes", ",", "Particles"}], "}"}]}],
   SequenceForm[
   "inserting at level(s) ", {Generic, FeynArts`Classes, FeynArts`Particles}],
   
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.4995088656056767`*^9, 3.499521746764072*^9, 
   3.499583159566346*^9, {3.4995842740010223`*^9, 3.499584335761942*^9}, 
   3.49958570691823*^9, 3.499586382125351*^9, 3.49959367732262*^9, {
   3.499600377315133*^9, 3.499600405834758*^9}, 3.4996645702709084`*^9, 
   3.499665384827684*^9, 3.4996666256151323`*^9, 3.500187224122608*^9, 
   3.500618288639703*^9, 3.500620019732819*^9, 3.500627575533286*^9, 
   3.5007185318610573`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes, 0 Particles \
insertions\"\>"}],
   SequenceForm[
   "> Top. ", 1, ": ", "0 Generic, 0 Classes, 0 Particles insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.4995088656056767`*^9, 3.499521746764072*^9, 
   3.499583159566346*^9, {3.4995842740010223`*^9, 3.499584335761942*^9}, 
   3.49958570691823*^9, 3.499586382125351*^9, 3.49959367732262*^9, {
   3.499600377315133*^9, 3.499600405834758*^9}, 3.4996645702709084`*^9, 
   3.499665384827684*^9, 3.4996666256151323`*^9, 3.500187224122608*^9, 
   3.500618288639703*^9, 3.500620019732819*^9, 3.500627575533286*^9, 
   3.500718531992338*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes, 1 Particles \
insertions\"\>"}],
   SequenceForm[
   "> Top. ", 2, ": ", "1 Generic, 1 Classes, 1 Particles insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.4995088656056767`*^9, 3.499521746764072*^9, 
   3.499583159566346*^9, {3.4995842740010223`*^9, 3.499584335761942*^9}, 
   3.49958570691823*^9, 3.499586382125351*^9, 3.49959367732262*^9, {
   3.499600377315133*^9, 3.499600405834758*^9}, 3.4996645702709084`*^9, 
   3.499665384827684*^9, 3.4996666256151323`*^9, 3.500187224122608*^9, 
   3.500618288639703*^9, 3.500620019732819*^9, 3.500627575533286*^9, 
   3.500718532131946*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes, 1 Particles \
insertions\"\>"}],
   SequenceForm[
   "> Top. ", 3, ": ", "1 Generic, 1 Classes, 1 Particles insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.4995088656056767`*^9, 3.499521746764072*^9, 
   3.499583159566346*^9, {3.4995842740010223`*^9, 3.499584335761942*^9}, 
   3.49958570691823*^9, 3.499586382125351*^9, 3.49959367732262*^9, {
   3.499600377315133*^9, 3.499600405834758*^9}, 3.4996645702709084`*^9, 
   3.499665384827684*^9, 3.4996666256151323`*^9, 3.500187224122608*^9, 
   3.500618288639703*^9, 3.500620019732819*^9, 3.500627575533286*^9, 
   3.5007185323994226`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes, 0 Particles \
insertions\"\>"}],
   SequenceForm[
   "> Top. ", 4, ": ", "0 Generic, 0 Classes, 0 Particles insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.4995088656056767`*^9, 3.499521746764072*^9, 
   3.499583159566346*^9, {3.4995842740010223`*^9, 3.499584335761942*^9}, 
   3.49958570691823*^9, 3.499586382125351*^9, 3.49959367732262*^9, {
   3.499600377315133*^9, 3.499600405834758*^9}, 3.4996645702709084`*^9, 
   3.499665384827684*^9, 3.4996666256151323`*^9, 3.500187224122608*^9, 
   3.500618288639703*^9, 3.500620019732819*^9, 3.500627575533286*^9, 
   3.500718532540248*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"in total: \"\>", 
    "\[InvisibleSpace]", "\<\"2 Generic, 2 Classes, 2 Particles \
insertions\"\>"}],
   SequenceForm["in total: ", "2 Generic, 2 Classes, 2 Particles insertions"],
   
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.4995088656056767`*^9, 3.499521746764072*^9, 
   3.499583159566346*^9, {3.4995842740010223`*^9, 3.499584335761942*^9}, 
   3.49958570691823*^9, 3.499586382125351*^9, 3.49959367732262*^9, {
   3.499600377315133*^9, 3.499600405834758*^9}, 3.4996645702709084`*^9, 
   3.499665384827684*^9, 3.4996666256151323`*^9, 3.500187224122608*^9, 
   3.500618288639703*^9, 3.500620019732819*^9, 3.500627575533286*^9, 
   3.500718532682918*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Paint", "[", "INTopo", "]"}]], "Input",
 CellChangeTimes->{{3.4778063315682*^9, 3.4778063464357*^9}, {
   3.4778115474231997`*^9, 3.4778115475632*^9}, 3.478437858916929*^9, 
   3.479546810801527*^9, {3.4994965729354*^9, 3.499496573154107*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"3 diagrams\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "3 diagrams"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.499584341801282*^9, 3.4995857119234962`*^9, 
  3.499593684804886*^9, 3.4996004100852423`*^9, 3.4996647003076563`*^9, 
  3.499665389095975*^9, 3.499666628636258*^9, 3.500187227713748*^9, 
  3.500187682372513*^9, 3.500385527563612*^9, 3.500617091467664*^9, 
  3.500619897374362*^9, 3.50062002320868*^9, 3.500627580982242*^9, 
  3.500718533381872*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"3 diagrams\"\>"}],
   SequenceForm["> Top. ", 2, ": ", "3 diagrams"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.499584341801282*^9, 3.4995857119234962`*^9, 
  3.499593684804886*^9, 3.4996004100852423`*^9, 3.4996647003076563`*^9, 
  3.499665389095975*^9, 3.499666628636258*^9, 3.500187227713748*^9, 
  3.500187682372513*^9, 3.500385527563612*^9, 3.500617091467664*^9, 
  3.500619897374362*^9, 3.50062002320868*^9, 3.500627580982242*^9, 
  3.500718533425235*^9}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwd1A9YzNkaB/CjJo22GClh+jOl2aLpmlYylOYXLaEYWlfSkkUlZcqqWCGV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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{3.4609327677584254`, 7.8841106397986875`}, {
        2.7951409921073664`, 6.808600848362362}, {2.2829934723757823`, 
        7.423177872040262}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"b\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], LineBox[CompressedData["
1:eJwd1AtU01UcB/B/KhzqjEUwZQHqcCR6xAHCZASzPy8P6BB5KDMWj4GwPDTm
mCeqJTjDR8DZEptTqJbHYEDJI8KlOAgJE5DHjsk6gQ6O4ABD4pgMG9h33XPu
+Z/Pvfd/f/f+7v9/vYUFSYdXEQSRgGp/EraXKNtI4v/iQxK6ap+c1/xIwszV
Z7QzYcYdJR229lHjPoWDWZTe7fBnl/c07IZTxvrFPFjHiUzzhPP1ntpj8Lz2
jZ9sm0jifJiCUQdzOkbEMzCZ6Jw2aZ//V+HlCbidRtP4bieJ76uVFLtVCROp
+XB0KfPjR3Awt/h2Iywv+zd5Etb4ZZFz8JrFgxwzTJsUd/mwEGcptmIYFjiJ
+Ikw7UTYUpt9/Dr1oUJYcrG7WQk3NTNLyuD51VK1AA73cB2ugoNLLW4MWHTw
Fr8W9omaMo55kwTll/ruZjg6SMq9BOcPBD02wHrD1PQh+Bl5g22EGfHjKwy4
nx+SOAdT7jleWWAgT3/262j+JOESZvliCNareJEx8PmOvMHrsPnzpcbjsOBB
0XeNcOfRUbYBNm1Y6GuAjYYQKhGA9Up6++vhFtrLtQxY5MfS1MIzA7LNXNir
yRT9FSzJZtUcgG0pb9lOw1pP2rgI/s025ZwLr1zYVvQh3PpXi40D23R3S0/C
uvSOew5w0Yu0RSVsjToaWrsR/exBh29gOvlBSgJME+qtTbDFfSLRAVZn7Kns
tvffWBVxawNJUJNOlZnggI/a/1bAKqG74AlsOkF5FAFbh1deJwKRL+ZtHgFT
yisMbrBqcaTKsB7rKpTu94WtTilZcjh3puH623BThEgUCgucVYp9cOwOt0Cr
F9rrmAvZsMiQPGuAhVrubjnMkdw/XQkb2UkhF+zxuB6NMjj9SWZ5CzyU/2pb
KmyNfpbaB3cWVChZMG+8uvghLHEsZT71xP6uRQvnYC3flq+GVc3LP1phjTWz
3xfmP8X57EDevpyeq/fAuPeNckc4oGq2ZivcvdHgSYU1yi63q29iPn9TDx2m
+271joA9etijvrAuYX3GNJ0k6i13XMNhy9nCsHr43c36vANw06l3dCfhcouY
WQjHDgiCpTBVn/dPJdwZWasqgMVnxja1waYr/pJCuH3nJ10jMPF7XY0M7lmT
vfwcdmGUZB6BOTFkvGsQSZR4/cCLh6+KZI1b7Hbae44O7zTc7wmF558fl/a6
k0RO3M3HMbA+iqXIgaWjRso+eMvXWbLZdcin1662ZJj8o0qeC7eqj1zjw6rD
Y+89WIv/OGH1i3TY3DoUI4DTja67RDBnMO6ShYb3qBcfHoMl88vms/C5Bv+6
M/D+msnJKJin+PZnLezCVoa7w+aIieKbcOfCoN8r8GjgzN0xe/zSvc42N3zv
9vsNdrLfbzTyP8Yez1w=
        "]], 
       PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"W\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[{{5.999999999990206, 10.}, {13.999999999982222`, 10.}}], 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"F\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.3048}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 G1 N1\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 44}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwd1A9YzNkaB/CjJo22GClh+jOl2aLpmlYylOYXLaEYWlfSkkUlZcqqWCGV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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{3.4609327677584254`, 7.8841106397986875`}, {
        2.7951409921073664`, 6.808600848362362}, {2.2829934723757823`, 
        7.423177872040262}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"b\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], LineBox[CompressedData["
1:eJwd1AtU01UcB/B/KhzqjEUwZQHqcCR6xAHCZASzPy8P6BB5KDMWj4GwPDTm
mCeqJTjDR8DZEptTqJbHYEDJI8KlOAgJE5DHjsk6gQ6O4ABD4pgMG9h33XPu
+Z/Pvfd/f/f+7v9/vYUFSYdXEQSRgGp/EraXKNtI4v/iQxK6ap+c1/xIwszV
Z7QzYcYdJR229lHjPoWDWZTe7fBnl/c07IZTxvrFPFjHiUzzhPP1ntpj8Lz2
jZ9sm0jifJiCUQdzOkbEMzCZ6Jw2aZ//V+HlCbidRtP4bieJ76uVFLtVCROp
+XB0KfPjR3Awt/h2Iywv+zd5Etb4ZZFz8JrFgxwzTJsUd/mwEGcptmIYFjiJ
+Ikw7UTYUpt9/Dr1oUJYcrG7WQk3NTNLyuD51VK1AA73cB2ugoNLLW4MWHTw
Fr8W9omaMo55kwTll/ruZjg6SMq9BOcPBD02wHrD1PQh+Bl5g22EGfHjKwy4
nx+SOAdT7jleWWAgT3/262j+JOESZvliCNareJEx8PmOvMHrsPnzpcbjsOBB
0XeNcOfRUbYBNm1Y6GuAjYYQKhGA9Up6++vhFtrLtQxY5MfS1MIzA7LNXNir
yRT9FSzJZtUcgG0pb9lOw1pP2rgI/s025ZwLr1zYVvQh3PpXi40D23R3S0/C
uvSOew5w0Yu0RSVsjToaWrsR/exBh29gOvlBSgJME+qtTbDFfSLRAVZn7Kns
tvffWBVxawNJUJNOlZnggI/a/1bAKqG74AlsOkF5FAFbh1deJwKRL+ZtHgFT
yisMbrBqcaTKsB7rKpTu94WtTilZcjh3puH623BThEgUCgucVYp9cOwOt0Cr
F9rrmAvZsMiQPGuAhVrubjnMkdw/XQkb2UkhF+zxuB6NMjj9SWZ5CzyU/2pb
KmyNfpbaB3cWVChZMG+8uvghLHEsZT71xP6uRQvnYC3flq+GVc3LP1phjTWz
3xfmP8X57EDevpyeq/fAuPeNckc4oGq2ZivcvdHgSYU1yi63q29iPn9TDx2m
+271joA9etijvrAuYX3GNJ0k6i13XMNhy9nCsHr43c36vANw06l3dCfhcouY
WQjHDgiCpTBVn/dPJdwZWasqgMVnxja1waYr/pJCuH3nJ10jMPF7XY0M7lmT
vfwcdmGUZB6BOTFkvGsQSZR4/cCLh6+KZI1b7Hbae44O7zTc7wmF558fl/a6
k0RO3M3HMbA+iqXIgaWjRso+eMvXWbLZdcin1662ZJj8o0qeC7eqj1zjw6rD
Y+89WIv/OGH1i3TY3DoUI4DTja67RDBnMO6ShYb3qBcfHoMl88vms/C5Bv+6
M/D+msnJKJin+PZnLezCVoa7w+aIieKbcOfCoN8r8GjgzN0xe/zSvc42N3zv
9vsNdrLfbzTyP8Yez1w=
        "]], 
       PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"W\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[{{5.999999999990206, 10.}, {13.999999999982222`, 10.}}], 
       PolygonBox[{{10.599999999999994`, 10.}, {9.399999999999995, 9.6}, {
        9.399999999999995, 10.4}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"b\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 C1 N2\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwd1A9YzNkaB/CjJo22GClh+jOl2aLpmlYylOYXLaEYWlfSkkUlZcqqWCGV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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {2.6125141805200567`, 11.914057016624067`}, \
{1, 1}], LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       PolygonBox[{{3.4609327677584254`, 7.8841106397986875`}, {
        2.7951409921073664`, 6.808600848362362}, {2.2829934723757823`, 
        7.423177872040262}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"b\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {3.387485819479944, 6.914057016624067}, \
{-1, 1}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       PolygonBox[{{17.46093276775842, 12.884110639798687`}, {
        16.282993472375775`, 12.423177872040263`}, {16.79514099210736, 
        11.808600848362362`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.61251418052005, 13.085942983375933`}, \
{1, -1}], LineBox[CompressedData["
1:eJwd1AtU01UcB/B/KhzqjEUwZQHqcCR6xAHCZASzPy8P6BB5KDMWj4GwPDTm
mCeqJTjDR8DZEptTqJbHYEDJI8KlOAgJE5DHjsk6gQ6O4ABD4pgMG9h33XPu
+Z/Pvfd/f/f+7v9/vYUFSYdXEQSRgGp/EraXKNtI4v/iQxK6ap+c1/xIwszV
Z7QzYcYdJR229lHjPoWDWZTe7fBnl/c07IZTxvrFPFjHiUzzhPP1ntpj8Lz2
jZ9sm0jifJiCUQdzOkbEMzCZ6Jw2aZ//V+HlCbidRtP4bieJ76uVFLtVCROp
+XB0KfPjR3Awt/h2Iywv+zd5Etb4ZZFz8JrFgxwzTJsUd/mwEGcptmIYFjiJ
+Ikw7UTYUpt9/Dr1oUJYcrG7WQk3NTNLyuD51VK1AA73cB2ugoNLLW4MWHTw
Fr8W9omaMo55kwTll/ruZjg6SMq9BOcPBD02wHrD1PQh+Bl5g22EGfHjKwy4
nx+SOAdT7jleWWAgT3/262j+JOESZvliCNareJEx8PmOvMHrsPnzpcbjsOBB
0XeNcOfRUbYBNm1Y6GuAjYYQKhGA9Up6++vhFtrLtQxY5MfS1MIzA7LNXNir
yRT9FSzJZtUcgG0pb9lOw1pP2rgI/s025ZwLr1zYVvQh3PpXi40D23R3S0/C
uvSOew5w0Yu0RSVsjToaWrsR/exBh29gOvlBSgJME+qtTbDFfSLRAVZn7Kns
tvffWBVxawNJUJNOlZnggI/a/1bAKqG74AlsOkF5FAFbh1deJwKRL+ZtHgFT
yisMbrBqcaTKsB7rKpTu94WtTilZcjh3puH623BThEgUCgucVYp9cOwOt0Cr
F9rrmAvZsMiQPGuAhVrubjnMkdw/XQkb2UkhF+zxuB6NMjj9SWZ5CzyU/2pb
KmyNfpbaB3cWVChZMG+8uvghLHEsZT71xP6uRQvnYC3flq+GVc3LP1phjTWz
3xfmP8X57EDevpyeq/fAuPeNckc4oGq2ZivcvdHgSYU1yi63q29iPn9TDx2m
+271joA9etijvrAuYX3GNJ0k6i13XMNhy9nCsHr43c36vANw06l3dCfhcouY
WQjHDgiCpTBVn/dPJdwZWasqgMVnxja1waYr/pJCuH3nJ10jMPF7XY0M7lmT
vfwcdmGUZB6BOTFkvGsQSZR4/cCLh6+KZI1b7Hbae44O7zTc7wmF558fl/a6
k0RO3M3HMbA+iqXIgaWjRso+eMvXWbLZdcin1662ZJj8o0qeC7eqj1zjw6rD
Y+89WIv/OGH1i3TY3DoUI4DTja67RDBnMO6ShYb3qBcfHoMl88vms/C5Bv+6
M/D+msnJKJin+PZnLezCVoa7w+aIieKbcOfCoN8r8GjgzN0xe/zSvc42N3zv
9vsNdrLfbzTyP8Yez1w=
        "]], 
       PolygonBox[{{16.539067232241567`, 7.8841106397986875`}, {
        17.71700652762421, 7.423177872040263}, {17.204859007892626`, 
        6.808600848362362}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"W\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {17.387485819479934`, 8.085942983375933}, \
{-1, -1}], LineBox[{{5.999999999990206, 10.}, {13.999999999982222`, 10.}}], 
       PolygonBox[{{10.599999999999994`, 10.}, {9.399999999999995, 9.6}, {
        9.399999999999995, 10.4}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"b\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.999999999999995, 9.0548}, {0, 1}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 P1 N3\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwl1gk41dkbB/CfpYjk2hr7nm5jTSlC95ZqZObfXCMtU5YoO0nKMuiSROst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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.84576923551745, 13.562492355174511`}, \
{0, 1}], LineBox[{{-7.503331289626658*^-12, 5.000000000003638}, {
        9.999999999988404, 6.}}], 
       PolygonBox[{{5.597022314125994, 5.559702231412599}, {4.442779173482406,
         5.042282892503405}, {4.363176198265607, 5.838312644671396}}], 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"b\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {5.1542307644825485`, 4.562492355174517}, \
{0, 1}], LineBox[{{20.000000000002956`, 15.}, {10.000000000002956`, 14.}}], 
       PolygonBox[{{15.597022314125994`, 14.559702231412594`}, {
        14.363176198265606`, 14.83831264467139}, {14.442779173482407`, 
        14.0422828925034}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {14.84576923551745, 15.437507644825478`}, \
{0, -1}], LineBox[CompressedData["
1:eJwt1QtMU1cYB/A7FZTnykqBRlHwASLPUlQQHQchDBAtFhRRwPJWHqNDURRw
qOs2deUtTkGKiI/MIlWxihNXh4JsBHkPRQYIBWaYFEWKAmH/m6xJc/PL/zvf
/c45TWoekcSPnkdRVDS+9JOansNnBaFU9NOYZPYmpQ7ZrSSUUMwUS+DNeua8
MJjaJ9rmA0fXPpNmwc27zrlrwiZznjsUsMxjw9IeI5IZus/38HtY9d2NMy1w
oteQ4epVhOoTDd4agJdok/lhsGLxuBMD691yfxkrgB0aHlzwh9texe9vpOt3
uX1ebEyoFCfm2HwLQvlXzyaNIA8fbZjdAMuqJ49Zm5BM9lST2TcwSR0zCTEh
VLiH99wVWKjp5nsArjeoj3kBqxZGmSfCdkfIdh1LvP+HZAsfrC+RPFG6wozN
nP3ayKfT/j4QT+drHFfew/u0yy3jLsACr+65IMxTaGDr0wDLeu/oqLGf3mxO
wRQsrNEUlxgRyjG16PHq1YQy65yuC0L+qktpsxtm1LD7rZDP6/5NR0zbI0eP
jXyL+ErsY1iw2U7LAm45JF+ihoWLgxZsgxtiVD22VoTKSVKpT2P98Gn+l9Ew
Mf0ppB25u+mLmmJYWCuyM8N8w1FNXW0wY22tWRTm73x7zVh7Dc7TOfBlIfK3
rwtN3WCG9zj7Fuxcwa5KpnMT4cWbqM/Yuq61HDYbdbudBfdPnyjpgBUlA6GB
tD3vxGtYY32a1IS+/2slI5VOsEApXVaBeXYKYtSRcM7VhLhAuN4upC0f7vsY
w18IP+1Y/vQJTH4/9f45C+enJV+lpvNcsftdeKj9rpa1DfrbaXTdh/eMZ1kK
YP+X1z60swi1O5bdfhamJqxcZuCZ5dfX/0nb16veFP3TNV1q5mBBj8+0Lc7r
WGFZJNcW909dfmQDj8g682LgvmXrOMthjYku6XmYZHZPs+A3yt6ORtj/1Ng7
bTi72HURZYf1rtfLKVgd6bWRS3ujfuok3u9w6OqRGLi00UTzX8zLGdKtOw83
38xVDMJVxWS2EZbNLWl7ifrXv9rXzNHmKwvq4dCVzy9y7GEfnaEyeMh3fWkE
rPi4oicB3tNxODifzqW9Szl0P6u4S09oy49+TyHnBSSuUMNC+dqUEUOi0O8s
LWA5YK4of+lbQ0KCQ+15DrC/JzfHgEXIaMVAwRa4Wc/C1hcOeL5gVSwsVLrF
ZsGVlwflJ+DSo/rKVlj80HNBCSwTsSp16ft1+dByH1YZ8350NCIKz63fTrbC
1MmUqU1GhOSFHA8bhRlv9D9ZI5dYJehrcPB7GJe5zaJfhOZxc1OYUSHSkbOI
4ufstXVOMJlsKglFvndgv7MfLPRM5s9i/vJK0weRcKl22gEJ9rfVI+NMGtx3
K11jG3JDGXcgn67f0p5tYEioiHXDw1LYLFjMVjFJZkJY2Y06uv6DS/Iokyge
Bd626of9GzV7NFCvtnD5agYWnKuzdEb/f74I7zR2xDwpM2vS0T+xt6mIS/tg
zuVnhiRzSlSxgwcLDvr5MTGvDT+jNg5W6SlYfFjrXnWFCKZOFwWl476MrL4e
lcDN9Xv/OoP7eiB/F18N9/3BF2WgXrTI3b4VZpDoF9uRS3hFvDdwpr3hU13Y
rzX742dc7G/jtOtdzHPp+p1YNpzjTsIDMY8woqrbAWa8q0+ewP7Gc/MKvWEq
YzJPwiQUp0zVLKDzgNtnw3AeoRNhVUdgWcunifVMQsa9hDvzaSuqdO3hyCRr
eQUsCOiv8sD65nbLh89ov/b2SoYXBm/fNAg3s3W0qtBvlv7f4P7//8Ek/wEs
SGzt
        "]], 
       PolygonBox[{{14.402977685874006`, 5.559702231412599}, {
        15.636823801734392`, 5.838312644671396}, {15.557220826517593`, 
        5.042282892503405}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"W\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {15.154230764482548`, 6.437507644825483}, \
{0, -1}], LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}], 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"F\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.3048, 9.999999999999995}, {1, 0}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T2 G1 N4\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 22}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwl1gk41dkbB/CfpYjk2hr7nm5jTSlC95ZqZObfXCMtU5YoO0nKMuiSROst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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.84576923551745, 13.562492355174511`}, \
{0, 1}], LineBox[{{-7.503331289626658*^-12, 5.000000000003638}, {
        9.999999999988404, 6.}}], 
       PolygonBox[{{5.597022314125994, 5.559702231412599}, {4.442779173482406,
         5.042282892503405}, {4.363176198265607, 5.838312644671396}}], 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"b\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          
          9.996694214876035]& ], {5.1542307644825485`, 4.562492355174517}, \
{0, 1}], LineBox[{{20.000000000002956`, 15.}, {10.000000000002956`, 14.}}], 
       PolygonBox[{{15.597022314125994`, 14.559702231412594`}, {
        14.363176198265606`, 14.83831264467139}, {14.442779173482407`, 
        14.0422828925034}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {14.84576923551745, 15.437507644825478`}, \
{0, -1}], LineBox[CompressedData["
1:eJwt1QtMU1cYB/A7FZTnykqBRlHwASLPUlQQHQchDBAtFhRRwPJWHqNDURRw
qOs2deUtTkGKiI/MIlWxihNXh4JsBHkPRQYIBWaYFEWKAmH/m6xJc/PL/zvf
/c45TWoekcSPnkdRVDS+9JOansNnBaFU9NOYZPYmpQ7ZrSSUUMwUS+DNeua8
MJjaJ9rmA0fXPpNmwc27zrlrwiZznjsUsMxjw9IeI5IZus/38HtY9d2NMy1w
oteQ4epVhOoTDd4agJdok/lhsGLxuBMD691yfxkrgB0aHlzwh9texe9vpOt3
uX1ebEyoFCfm2HwLQvlXzyaNIA8fbZjdAMuqJ49Zm5BM9lST2TcwSR0zCTEh
VLiH99wVWKjp5nsArjeoj3kBqxZGmSfCdkfIdh1LvP+HZAsfrC+RPFG6wozN
nP3ayKfT/j4QT+drHFfew/u0yy3jLsACr+65IMxTaGDr0wDLeu/oqLGf3mxO
wRQsrNEUlxgRyjG16PHq1YQy65yuC0L+qktpsxtm1LD7rZDP6/5NR0zbI0eP
jXyL+ErsY1iw2U7LAm45JF+ihoWLgxZsgxtiVD22VoTKSVKpT2P98Gn+l9Ew
Mf0ppB25u+mLmmJYWCuyM8N8w1FNXW0wY22tWRTm73x7zVh7Dc7TOfBlIfK3
rwtN3WCG9zj7Fuxcwa5KpnMT4cWbqM/Yuq61HDYbdbudBfdPnyjpgBUlA6GB
tD3vxGtYY32a1IS+/2slI5VOsEApXVaBeXYKYtSRcM7VhLhAuN4upC0f7vsY
w18IP+1Y/vQJTH4/9f45C+enJV+lpvNcsftdeKj9rpa1DfrbaXTdh/eMZ1kK
YP+X1z60swi1O5bdfhamJqxcZuCZ5dfX/0nb16veFP3TNV1q5mBBj8+0Lc7r
WGFZJNcW909dfmQDj8g682LgvmXrOMthjYku6XmYZHZPs+A3yt6ORtj/1Ng7
bTi72HURZYf1rtfLKVgd6bWRS3ujfuok3u9w6OqRGLi00UTzX8zLGdKtOw83
38xVDMJVxWS2EZbNLWl7ifrXv9rXzNHmKwvq4dCVzy9y7GEfnaEyeMh3fWkE
rPi4oicB3tNxODifzqW9Szl0P6u4S09oy49+TyHnBSSuUMNC+dqUEUOi0O8s
LWA5YK4of+lbQ0KCQ+15DrC/JzfHgEXIaMVAwRa4Wc/C1hcOeL5gVSwsVLrF
ZsGVlwflJ+DSo/rKVlj80HNBCSwTsSp16ft1+dByH1YZ8350NCIKz63fTrbC
1MmUqU1GhOSFHA8bhRlv9D9ZI5dYJehrcPB7GJe5zaJfhOZxc1OYUSHSkbOI
4ufstXVOMJlsKglFvndgv7MfLPRM5s9i/vJK0weRcKl22gEJ9rfVI+NMGtx3
K11jG3JDGXcgn67f0p5tYEioiHXDw1LYLFjMVjFJZkJY2Y06uv6DS/Iokyge
Bd626of9GzV7NFCvtnD5agYWnKuzdEb/f74I7zR2xDwpM2vS0T+xt6mIS/tg
zuVnhiRzSlSxgwcLDvr5MTGvDT+jNg5W6SlYfFjrXnWFCKZOFwWl476MrL4e
lcDN9Xv/OoP7eiB/F18N9/3BF2WgXrTI3b4VZpDoF9uRS3hFvDdwpr3hU13Y
rzX742dc7G/jtOtdzHPp+p1YNpzjTsIDMY8woqrbAWa8q0+ewP7Gc/MKvWEq
YzJPwiQUp0zVLKDzgNtnw3AeoRNhVUdgWcunifVMQsa9hDvzaSuqdO3hyCRr
eQUsCOiv8sD65nbLh89ov/b2SoYXBm/fNAg3s3W0qtBvlv7f4P7//8Ek/wEs
SGzt
        "]], 
       PolygonBox[{{14.402977685874006`, 5.559702231412599}, {
        15.636823801734392`, 5.838312644671396}, {15.557220826517593`, 
        5.042282892503405}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"W\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {15.154230764482548`, 6.437507644825483}, \
{0, -1}], LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}], 
       PolygonBox[{{10., 10.599999999999994`}, {9.6, 9.399999999999995}, {
        10.4, 9.399999999999995}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.0548, 9.999999999999995}, {1, 0}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T2 C1 N5\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 22}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], LineBox[CompressedData["
1:eJwl1gk41dkbB/CfpYjk2hr7nm5jTSlC95ZqZObfXCMtU5YoO0nKMuiSROst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        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"G\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.84576923551745, 13.562492355174511`}, \
{0, 1}], LineBox[{{-7.503331289626658*^-12, 5.000000000003638}, {
        9.999999999988404, 6.}}], 
       PolygonBox[{{5.597022314125994, 5.559702231412599}, {4.442779173482406,
         5.042282892503405}, {4.363176198265607, 5.838312644671396}}], 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"b\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {5.1542307644825485`, 4.562492355174517}, \
{0, 1}], LineBox[{{20.000000000002956`, 15.}, {10.000000000002956`, 14.}}], 
       PolygonBox[{{15.597022314125994`, 14.559702231412594`}, {
        14.363176198265606`, 14.83831264467139}, {14.442779173482407`, 
        14.0422828925034}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {14.84576923551745, 15.437507644825478`}, \
{0, -1}], LineBox[CompressedData["
1:eJwt1QtMU1cYB/A7FZTnykqBRlHwASLPUlQQHQchDBAtFhRRwPJWHqNDURRw
qOs2deUtTkGKiI/MIlWxihNXh4JsBHkPRQYIBWaYFEWKAmH/m6xJc/PL/zvf
/c45TWoekcSPnkdRVDS+9JOansNnBaFU9NOYZPYmpQ7ZrSSUUMwUS+DNeua8
MJjaJ9rmA0fXPpNmwc27zrlrwiZznjsUsMxjw9IeI5IZus/38HtY9d2NMy1w
oteQ4epVhOoTDd4agJdok/lhsGLxuBMD691yfxkrgB0aHlzwh9texe9vpOt3
uX1ebEyoFCfm2HwLQvlXzyaNIA8fbZjdAMuqJ49Zm5BM9lST2TcwSR0zCTEh
VLiH99wVWKjp5nsArjeoj3kBqxZGmSfCdkfIdh1LvP+HZAsfrC+RPFG6wozN
nP3ayKfT/j4QT+drHFfew/u0yy3jLsACr+65IMxTaGDr0wDLeu/oqLGf3mxO
wRQsrNEUlxgRyjG16PHq1YQy65yuC0L+qktpsxtm1LD7rZDP6/5NR0zbI0eP
jXyL+ErsY1iw2U7LAm45JF+ihoWLgxZsgxtiVD22VoTKSVKpT2P98Gn+l9Ew
Mf0ppB25u+mLmmJYWCuyM8N8w1FNXW0wY22tWRTm73x7zVh7Dc7TOfBlIfK3
rwtN3WCG9zj7Fuxcwa5KpnMT4cWbqM/Yuq61HDYbdbudBfdPnyjpgBUlA6GB
tD3vxGtYY32a1IS+/2slI5VOsEApXVaBeXYKYtSRcM7VhLhAuN4upC0f7vsY
w18IP+1Y/vQJTH4/9f45C+enJV+lpvNcsftdeKj9rpa1DfrbaXTdh/eMZ1kK
YP+X1z60swi1O5bdfhamJqxcZuCZ5dfX/0nb16veFP3TNV1q5mBBj8+0Lc7r
WGFZJNcW909dfmQDj8g682LgvmXrOMthjYku6XmYZHZPs+A3yt6ORtj/1Ng7
bTi72HURZYf1rtfLKVgd6bWRS3ujfuok3u9w6OqRGLi00UTzX8zLGdKtOw83
38xVDMJVxWS2EZbNLWl7ifrXv9rXzNHmKwvq4dCVzy9y7GEfnaEyeMh3fWkE
rPi4oicB3tNxODifzqW9Szl0P6u4S09oy49+TyHnBSSuUMNC+dqUEUOi0O8s
LWA5YK4of+lbQ0KCQ+15DrC/JzfHgEXIaMVAwRa4Wc/C1hcOeL5gVSwsVLrF
ZsGVlwflJ+DSo/rKVlj80HNBCSwTsSp16ft1+dByH1YZ8350NCIKz63fTrbC
1MmUqU1GhOSFHA8bhRlv9D9ZI5dYJehrcPB7GJe5zaJfhOZxc1OYUSHSkbOI
4ufstXVOMJlsKglFvndgv7MfLPRM5s9i/vJK0weRcKl22gEJ9rfVI+NMGtx3
K11jG3JDGXcgn67f0p5tYEioiHXDw1LYLFjMVjFJZkJY2Y06uv6DS/Iokyge
Bd626of9GzV7NFCvtnD5agYWnKuzdEb/f74I7zR2xDwpM2vS0T+xt6mIS/tg
zuVnhiRzSlSxgwcLDvr5MTGvDT+jNg5W6SlYfFjrXnWFCKZOFwWl476MrL4e
lcDN9Xv/OoP7eiB/F18N9/3BF2WgXrTI3b4VZpDoF9uRS3hFvDdwpr3hU13Y
rzX742dc7G/jtOtdzHPp+p1YNpzjTsIDMY8woqrbAWa8q0+ewP7Gc/MKvWEq
YzJPwiQUp0zVLKDzgNtnw3AeoRNhVUdgWcunifVMQsa9hDvzaSuqdO3hyCRr
eQUsCOiv8sD65nbLh89ov/b2SoYXBm/fNAg3s3W0qtBvlv7f4P7//8Ek/wEs
SGzt
        "]], 
       PolygonBox[{{14.402977685874006`, 5.559702231412599}, {
        15.636823801734392`, 5.838312644671396}, {15.557220826517593`, 
        5.042282892503405}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"W\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {15.154230764482548`, 6.437507644825483}, \
{0, -1}], LineBox[{{10., 14.000000000000902`}, {10., 6.0000000000000036`}}], 
       PolygonBox[{{10., 10.599999999999994`}, {9.6, 9.399999999999995}, {
        10.4, 9.399999999999995}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {9.0548, 9.999999999999995}, {1, 0}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T2 P1 N6\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 22}, {0, 0}, {22, 22}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"G\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {24., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"b\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {28.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[RightArrow]\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {33., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"t\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {37.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"W\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {42., 69.96}, {0, 0}]},
   AspectRatio->1.0999999999999999`,
   PlotRange->{{0, 66}, {0, 72.6}}], TraditionalForm]], "Print",
 CellChangeTimes->{3.499584341801282*^9, 3.4995857119234962`*^9, 
  3.499593684804886*^9, 3.4996004100852423`*^9, 3.4996647003076563`*^9, 
  3.499665389095975*^9, 3.499666628636258*^9, 3.500187227713748*^9, 
  3.500187682372513*^9, 3.500385527563612*^9, 3.500617091467664*^9, 
  3.500619897374362*^9, 3.50062002320868*^9, 3.500627580982242*^9, 
  3.500718533824037*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"FeynArtsGraphics", "(", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"G\"\>", ",", "\<\"b\"\>"}], "}"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\<\"t\"\>", ",", "\<\"W\"\>"}], "}"}]}], ")"}], 
   "\[InvisibleApplication]", 
   RowBox[{"(", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 G1 N1\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 G1 N1", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 C1 N2\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 C1 N2", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 P1 N3\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 P1 N3", "]"],
           Editable->False],
          TraditionalForm]},
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T2 G1 N4\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T2 G1 N4", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T2 C1 N5\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T2 C1 N5", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T2 P1 N6\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T2 P1 N6", "]"],
           Editable->False],
          TraditionalForm]},
        {"Null", "Null", "Null"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.4778063475407*^9, 3.4778065254607*^9, 3.4778099157272*^9, 
   3.4778115492682*^9, 3.47843686984159*^9, 3.478436906375371*^9, {
   3.478437853618226*^9, 3.478437860811162*^9}, 3.479099999826127*^9, 
   3.479106333796554*^9, {3.479546806741183*^9, 3.479546812623714*^9}, 
   3.4978620779952097`*^9, 3.497862535136364*^9, 3.497871415799543*^9, 
   3.4979424893430643`*^9, 3.498391202919662*^9, 3.499521753363945*^9, 
   3.499583162685727*^9, 3.499584300111794*^9, 3.499584342363058*^9, 
   3.499585712241136*^9, 3.499593685059499*^9, 3.499600413060239*^9, 
   3.499664700901778*^9, 3.499665389497528*^9, 3.499666631502326*^9, 
   3.5001872283521233`*^9, 3.5001876828878593`*^9, 3.500385531152835*^9, 
   3.5006170941515408`*^9, 3.50061989822535*^9, 3.500620023903152*^9, 
   3.500627583254354*^9, 3.50071853398035*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Ampl", " ", "=", " ", 
   RowBox[{"CreateFeynAmp", "[", "INTopo", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4778062370957003`*^9, 3.4778062399307003`*^9}, {
   3.4778115657332*^9, 3.4778115658507*^9}, {3.4778120221097*^9, 
   3.4778120222467003`*^9}, 3.479547360479462*^9, {3.4994965783939333`*^9, 
   3.4994965820750732`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.499584340167673*^9, 3.4995847701347446`*^9, 
  3.499585713493058*^9, 3.499600447726274*^9, 3.499664717688789*^9, 
  3.499665393986065*^9, 3.4996666345650787`*^9, 3.5001872300441647`*^9, 
  3.500187687339259*^9, 3.500385535637699*^9, 3.500617095235181*^9, 
  3.500617310599989*^9, 3.500617994141314*^9, 3.500618295522369*^9, 
  3.500620025945036*^9, 3.500627587306531*^9, 3.500718536296962*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"Generic", ",", "Classes", ",", "Particles"}], "}"}]}],
   SequenceForm[
   "creating amplitudes at level(s) ", {
    Generic, FeynArts`Classes, FeynArts`Particles}],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.499584340167673*^9, 3.4995847701347446`*^9, 
  3.499585713493058*^9, 3.499600447726274*^9, 3.499664717688789*^9, 
  3.499665393986065*^9, 3.4996666345650787`*^9, 3.5001872300441647`*^9, 
  3.500187687339259*^9, 3.500385535637699*^9, 3.500617095235181*^9, 
  3.500617310599989*^9, 3.500617994141314*^9, 3.500618295522369*^9, 
  3.500620025945036*^9, 3.500627587306531*^9, 3.50071853637636*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes, 1 Particles \
amplitudes\"\>"}],
   SequenceForm[
   "> Top. ", 1, ": ", "1 Generic, 1 Classes, 1 Particles amplitudes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.499584340167673*^9, 3.4995847701347446`*^9, 
  3.499585713493058*^9, 3.499600447726274*^9, 3.499664717688789*^9, 
  3.499665393986065*^9, 3.4996666345650787`*^9, 3.5001872300441647`*^9, 
  3.500187687339259*^9, 3.500385535637699*^9, 3.500617095235181*^9, 
  3.500617310599989*^9, 3.500617994141314*^9, 3.500618295522369*^9, 
  3.500620025945036*^9, 3.500627587306531*^9, 3.500718537151823*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes, 1 Particles \
amplitudes\"\>"}],
   SequenceForm[
   "> Top. ", 2, ": ", "1 Generic, 1 Classes, 1 Particles amplitudes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.499584340167673*^9, 3.4995847701347446`*^9, 
  3.499585713493058*^9, 3.499600447726274*^9, 3.499664717688789*^9, 
  3.499665393986065*^9, 3.4996666345650787`*^9, 3.5001872300441647`*^9, 
  3.500187687339259*^9, 3.500385535637699*^9, 3.500617095235181*^9, 
  3.500617310599989*^9, 3.500617994141314*^9, 3.500618295522369*^9, 
  3.500620025945036*^9, 3.500627587306531*^9, 3.50071853726552*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"in total: \"\>", 
    "\[InvisibleSpace]", "\<\"2 Generic, 2 Classes, 2 Particles \
amplitudes\"\>"}],
   SequenceForm["in total: ", "2 Generic, 2 Classes, 2 Particles amplitudes"],
   
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.499584340167673*^9, 3.4995847701347446`*^9, 
  3.499585713493058*^9, 3.499600447726274*^9, 3.499664717688789*^9, 
  3.499665393986065*^9, 3.4996666345650787`*^9, 3.5001872300441647`*^9, 
  3.500187687339259*^9, 3.500385535637699*^9, 3.500617095235181*^9, 
  3.500617310599989*^9, 3.500617994141314*^9, 3.500618295522369*^9, 
  3.500620025945036*^9, 3.500627587306531*^9, 3.500718537361721*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\</home/degrande/eta/FeynProg/FormCalc-7.0\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "FormCalc`"}]}], "Input",
 CellChangeTimes->{
  3.4777456682883*^9, {3.4778119018507*^9, 3.4778119054056997`*^9}, {
   3.4778119371527*^9, 3.4778119527257*^9}, {3.478434390853149*^9, 
   3.478434394596879*^9}, {3.498391209209569*^9, 3.4983912097170353`*^9}, {
   3.500187690209734*^9, 3.5001876907943487`*^9}, {3.50038553962167*^9, 
   3.500385540072044*^9}, {3.5006171005362043`*^9, 3.500617101236773*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.497862097715542*^9, 3.497862541299556*^9, 3.497871425757481*^9, 
  3.497942493923506*^9, 3.4983912102183523`*^9, 3.499521768705014*^9, 
  3.499583165670874*^9, 3.4995847733890743`*^9, 3.499585716589773*^9, 
  3.499600450106303*^9, 3.4996647241691923`*^9, 3.49966540172666*^9, 
  3.499666636676647*^9, 3.500187232208699*^9, 3.500187691217064*^9, 
  3.500385540427013*^9, 3.50061710167595*^9, 3.500617543453004*^9, 
  3.500618000119952*^9, 3.5006182994959106`*^9, 3.500620027480061*^9, 
  3.500627590335835*^9, 3.50071853842925*^9}],

Cell[BoxData[
 FormBox["\<\"FormCalc 7.0\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.497862097715542*^9, 3.497862541299556*^9, 3.497871425757481*^9, 
  3.497942493923506*^9, 3.4983912102183523`*^9, 3.499521768705014*^9, 
  3.499583165670874*^9, 3.4995847733890743`*^9, 3.499585716589773*^9, 
  3.499600450106303*^9, 3.4996647241691923`*^9, 3.49966540172666*^9, 
  3.499666636676647*^9, 3.500187232208699*^9, 3.500187691217064*^9, 
  3.500385540427013*^9, 3.50061710167595*^9, 3.500617543453004*^9, 
  3.500618000119952*^9, 3.5006182994959106`*^9, 3.500620027480061*^9, 
  3.500627590335835*^9, 3.5007185385016823`*^9}],

Cell[BoxData[
 FormBox["\<\"by Thomas Hahn\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.497862097715542*^9, 3.497862541299556*^9, 3.497871425757481*^9, 
  3.497942493923506*^9, 3.4983912102183523`*^9, 3.499521768705014*^9, 
  3.499583165670874*^9, 3.4995847733890743`*^9, 3.499585716589773*^9, 
  3.499600450106303*^9, 3.4996647241691923`*^9, 3.49966540172666*^9, 
  3.499666636676647*^9, 3.500187232208699*^9, 3.500187691217064*^9, 
  3.500385540427013*^9, 3.50061710167595*^9, 3.500617543453004*^9, 
  3.500618000119952*^9, 3.5006182994959106`*^9, 3.500620027480061*^9, 
  3.500627590335835*^9, 3.500718538620577*^9}],

Cell[BoxData[
 FormBox["\<\"last revised 6 Dec 10\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.497862097715542*^9, 3.497862541299556*^9, 3.497871425757481*^9, 
  3.497942493923506*^9, 3.4983912102183523`*^9, 3.499521768705014*^9, 
  3.499583165670874*^9, 3.4995847733890743`*^9, 3.499585716589773*^9, 
  3.499600450106303*^9, 3.4996647241691923`*^9, 3.49966540172666*^9, 
  3.499666636676647*^9, 3.500187232208699*^9, 3.500187691217064*^9, 
  3.500385540427013*^9, 3.50061710167595*^9, 3.500617543453004*^9, 
  3.500618000119952*^9, 3.5006182994959106`*^9, 3.500620027480061*^9, 
  3.500627590335835*^9, 3.50071853873779*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"M", "=", " ", 
   RowBox[{"CalcFeynAmp", "[", 
    RowBox[{"Ampl", ",", 
     RowBox[{"FermionChains", "\[Rule]", "Chiral"}], ",", 
     RowBox[{"Antisymmetrize", "\[Rule]", "False"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.4778119845017*^9, 3.4778120345607*^9}, {
   3.478435376938886*^9, 3.478435418868291*^9}, 3.479547358194307*^9, {
   3.499496616117415*^9, 3.499496619479166*^9}, {3.500617294078361*^9, 
   3.500617302768305*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.499665403396031*^9, 3.499666638474655*^9, 
  3.500187234016674*^9, 3.50018769518933*^9, 3.500385544056026*^9, 
  3.500617104503936*^9, 3.500617315004862*^9, 3.500618001893064*^9, 
  3.500618302145114*^9, 3.5006200291050243`*^9, 3.500627594025572*^9, 
  3.500718541335517*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-7.0/fc4.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-7.0/fc4.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.499665403396031*^9, 3.499666638474655*^9, 
  3.500187234016674*^9, 3.50018769518933*^9, 3.500385544056026*^9, 
  3.500617104503936*^9, 3.500617315004862*^9, 3.500618001893064*^9, 
  3.500618302145114*^9, 3.5006200291050243`*^9, 3.500627594025572*^9, 
  3.500718541395986*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{3.499665403396031*^9, 3.499666638474655*^9, 
  3.500187234016674*^9, 3.50018769518933*^9, 3.500385544056026*^9, 
  3.500617104503936*^9, 3.500617315004862*^9, 3.500618001893064*^9, 
  3.500618302145114*^9, 3.5006200291050243`*^9, 3.500627594025572*^9, 
  3.500718541675099*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.499665403396031*^9, 3.499666638474655*^9, 
  3.500187234016674*^9, 3.50018769518933*^9, 3.500385544056026*^9, 
  3.500617104503936*^9, 3.500617315004862*^9, 3.500618001893064*^9, 
  3.500618302145114*^9, 3.5006200291050243`*^9, 3.500627594025572*^9, 
  3.500718542442258*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"col", "=", 
  RowBox[{"ColourME", "[", "M", "]"}]}]], "Input",
 CellChangeTimes->{{3.478434696113564*^9, 3.478434729084623*^9}, {
  3.478435197289632*^9, 3.478435232835993*^9}, {3.478436054623279*^9, 
  3.478436055525961*^9}, {3.499521787338925*^9, 3.4995217875817633`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Mat", "(", 
     RowBox[{"SUN1", ",", "SUN1"}], ")"}], "\[Rule]", "4"}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.478434730426236*^9, 3.478435200749498*^9, 3.478435233950212*^9, 
   3.478435426393788*^9, 3.478435591077346*^9, 3.478435927320691*^9, 
   3.478436057790335*^9, 3.478436928353135*^9, 3.479100063362775*^9, 
   3.479106358816292*^9, 3.479546864822269*^9, 3.479547348022377*^9, 
   3.479547714372858*^9, 3.497862106256465*^9, 3.4978625437919207`*^9, 
   3.497871428686603*^9, 3.497942496752326*^9, 3.498391216132546*^9, {
   3.4995217752940617`*^9, 3.499521788279874*^9}, 3.499583168961454*^9, 
   3.499584777637652*^9, 3.4995857253323097`*^9, 3.499600453946761*^9, 
   3.4996647275040703`*^9, 3.499665405020383*^9, 3.499666640131784*^9, 
   3.5001872359898577`*^9, 3.5001876986530027`*^9, 3.500385547281986*^9, 
   3.500617107597248*^9, 3.500617318151655*^9, 3.50061800609056*^9, 
   3.500618304758301*^9, 3.5006200310594683`*^9, 3.500627597813884*^9, 
   3.500718543854879*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"_Hel", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hel", "=", 
   RowBox[{"HelicityME", "[", "M", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.478435272631223*^9, 3.478435280805309*^9}, {
   3.478435549596737*^9, 3.478435557227066*^9}, {3.478436067208497*^9, 
   3.478436071671449*^9}, {3.478436592499899*^9, 3.478436607261712*^9}, 
   3.479547354402557*^9, {3.499521790978319*^9, 3.499521791276463*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "225", 
    "\[InvisibleSpace]", "\<\" helicity matrix elements\"\>"}],
   SequenceForm["> ", 225, " helicity matrix elements"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.499521791849257*^9, 3.4995831697897243`*^9, 
  3.499584780324565*^9, 3.499585726563333*^9, 3.499600455102046*^9, 
  3.4996647290314198`*^9, 3.4996654063820353`*^9, 3.4996666428474894`*^9, 
  3.50018723722863*^9, 3.500187699473218*^9, 3.500385551191485*^9, 
  3.500617109930581*^9, 3.500617320123604*^9, 3.500618007927311*^9, 
  3.500618307137023*^9, 3.500620031997764*^9, 3.500627600851355*^9, 
  3.5007185451058292`*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.499521791849257*^9, 3.4995831697897243`*^9, 
  3.499584780324565*^9, 3.499585726563333*^9, 3.499600455102046*^9, 
  3.4996647290314198`*^9, 3.4996654063820353`*^9, 3.4996666428474894`*^9, 
  3.50018723722863*^9, 3.500187699473218*^9, 3.500385551191485*^9, 
  3.500617109930581*^9, 3.500617320123604*^9, 3.500618007927311*^9, 
  3.500618307137023*^9, 3.500620031997764*^9, 3.500627600851355*^9, 
  3.5007185451955338`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-7.0/fc4.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-7.0/fc4.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.499521791849257*^9, 3.4995831697897243`*^9, 
  3.499584780324565*^9, 3.499585726563333*^9, 3.499600455102046*^9, 
  3.4996647290314198`*^9, 3.4996654063820353`*^9, 3.4996666428474894`*^9, 
  3.50018723722863*^9, 3.500187699473218*^9, 3.500385551191485*^9, 
  3.500617109930581*^9, 3.500617320123604*^9, 3.500618007927311*^9, 
  3.500618307137023*^9, 3.500620031997764*^9, 3.500627600851355*^9, 
  3.5007185453584633`*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{3.499521791849257*^9, 3.4995831697897243`*^9, 
  3.499584780324565*^9, 3.499585726563333*^9, 3.499600455102046*^9, 
  3.4996647290314198`*^9, 3.4996654063820353`*^9, 3.4996666428474894`*^9, 
  3.50018723722863*^9, 3.500187699473218*^9, 3.500385551191485*^9, 
  3.500617109930581*^9, 3.500617320123604*^9, 3.500618007927311*^9, 
  3.500618307137023*^9, 3.500620031997764*^9, 3.500627600851355*^9, 
  3.5007185455441713`*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.499521791849257*^9, 3.4995831697897243`*^9, 
  3.499584780324565*^9, 3.499585726563333*^9, 3.499600455102046*^9, 
  3.4996647290314198`*^9, 3.4996654063820353`*^9, 3.4996666428474894`*^9, 
  3.50018723722863*^9, 3.500187699473218*^9, 3.500385551191485*^9, 
  3.500617109930581*^9, 3.500617320123604*^9, 3.500618007927311*^9, 
  3.500618307137023*^9, 3.500620031997764*^9, 3.500627600851355*^9, 
  3.500718546188694*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CtG", "Section",
 CellChangeTimes->{{3.500627469515484*^9, 3.500627483217723*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"M2", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"SquaredME", "[", "M", "]"}], "/.", "col"}], "/.", "hel"}], "/.",
       "M$FACouplings"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Conjugate", "[", "Lambda", "]"}], "\[Rule]", 
        RowBox[{"1", "/", "Linv"}]}], ",", 
       RowBox[{"Lambda", "\[Rule]", 
        RowBox[{"1", "/", "Linv"}]}]}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"C3phiq", "\[Rule]", "0"}], ",", 
      RowBox[{"CtW", "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"Conjugate", "[", "v", "]"}], "\[Rule]", "v"}], ",", 
      RowBox[{
       RowBox[{"Conjugate", "[", "sw", "]"}], "\[Rule]", "sw"}]}], "}"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.499600531002454*^9, 3.4996005524542828`*^9}, {
   3.499600635515656*^9, 3.499600641632725*^9}, 3.499664804800191*^9, 
   3.499665470133533*^9, {3.499665526806489*^9, 3.499665533691248*^9}, {
   3.499666501659967*^9, 3.499666513416099*^9}, {3.500187709292647*^9, 
   3.500187712600173*^9}, 3.500385558768992*^9, 3.500617380485931*^9, {
   3.5006183149253798`*^9, 3.5006183179069633`*^9}, {3.5006184825135202`*^9, 
   3.500618538907811*^9}, {3.5006189819188757`*^9, 3.500618986819117*^9}, 
   3.5006190655537767`*^9, {3.500619108945569*^9, 3.500619160312779*^9}, {
   3.5006192176593237`*^9, 3.500619270466074*^9}, 3.500718875932481*^9, {
   3.500718992305853*^9, 3.500718996428258*^9}, {3.500719048513307*^9, 
   3.500719063627002*^9}}],

Cell[CellGroupData[{

Cell[BoxData["M2"], "Input",
 CellChangeTimes->{{3.500718835823985*^9, 3.500718836179378*^9}, 
   3.500718961787221*^9, 3.500719000302812*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{
    "256", " ", "Alfa", " ", "CKM33", " ", "CtG", " ", "Pair6", " ", "\[Pi]", 
     " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "4"]}], " ", 
        RowBox[{"(", 
         RowBox[{"MB2", "-", "S"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"MT2", "-", "T"}], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", "AbbSum22", " ", 
        RowBox[{"(", 
         RowBox[{"T", "-", "MT2"}], ")"}]}]}], ")"}], " ", 
     SuperscriptBox["v", "2"], " ", 
     SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
     SuperscriptBox["CtG", "\[Conjugate]"], " ", 
     SuperscriptBox["Pair6", "\[Conjugate]"], " ", 
     SuperscriptBox[
      RowBox[{"Den", "(", 
       RowBox[{"T", ",", "MT2"}], ")"}], "2"], " ", 
     SuperscriptBox["Linv", "4"]}], 
    SuperscriptBox["sw", "2"]], "+", 
   RowBox[{
    FractionBox["1", "sw"], 
    RowBox[{"16", " ", "CKM33", " ", "EL", " ", "Pair6", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["AbbSum28", "2"]}], "+", 
       FractionBox[
        RowBox[{"AbbSum25", " ", "MB2"}], "2"], "+", 
       FractionBox[
        RowBox[{"AbbSum35", " ", "MT2"}], "4"], "-", 
       FractionBox[
        RowBox[{"AbbSum26", " ", "S"}], "4"], "-", 
       FractionBox[
        RowBox[{"AbbSum20", " ", "T"}], "4"], "-", 
       FractionBox[
        RowBox[{"AbbSum27", " ", "U"}], "4"]}], ")"}], " ", "v", " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", "CtG", " ", "EL", " ", 
         SuperscriptBox["Linv", "2"], " ", "MT2", " ", "v", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"]}], "sw"], "-", 
       FractionBox[
        RowBox[{"2", " ", "CtG", " ", "EL", " ", 
         SuperscriptBox["Linv", "2"], " ", "T", " ", "v", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
     SuperscriptBox["CtG", "\[Conjugate]"], " ", 
     SuperscriptBox[
      RowBox[{"Den", "(", 
       RowBox[{"T", ",", "MT2"}], ")"}], "2"], " ", 
     SuperscriptBox["Linv", "2"]}]}], "+", 
   RowBox[{
    FractionBox["1", "sw"], 
    RowBox[{"16", " ", "CKM33", " ", "EL", " ", "Pair6", " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["Eps15", "2"], "+", 
       FractionBox[
        RowBox[{"AbbSum17", " ", "MB2"}], "2"], "-", 
       RowBox[{
        FractionBox["1", "4"], " ", "AbbSum13", " ", 
        RowBox[{"(", 
         RowBox[{"S", "-", "MT2"}], ")"}]}], "-", 
       FractionBox[
        RowBox[{"Pair1", " ", "T"}], "4"], "-", 
       FractionBox[
        RowBox[{"Pair4", " ", "U"}], "4"]}], ")"}], " ", "v", " ", 
     SuperscriptBox["CtG", "\[Conjugate]"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"4", " ", "CtG", " ", "EL", " ", "MT2", " ", "v", " ", 
          SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
          SuperscriptBox["Pair5", "\[Conjugate]"], " ", 
          SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
       FractionBox[
        RowBox[{"8", " ", "CtG", " ", "EL", " ", "v", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["AbbSum1", "\[Conjugate]"], "-", 
           FractionBox[
            RowBox[{"T", " ", 
             SuperscriptBox["Pair5", "\[Conjugate]"]}], "2"]}], ")"}], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"Den", "(", 
       RowBox[{"T", ",", "MT2"}], ")"}], "2"], " ", 
     SuperscriptBox["Linv", "2"]}]}], "+", 
   RowBox[{
    FractionBox["1", "sw"], 
    RowBox[{"16", " ", "CtG", " ", "EL", " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["AbbSum103", "2"], "+", 
       FractionBox[
        RowBox[{"AbbSum102", " ", "MB2"}], "2"], "+", 
       FractionBox[
        RowBox[{"AbbSum56", " ", "MT2"}], "4"], "-", 
       FractionBox[
        RowBox[{"AbbSum91", " ", "S"}], "4"], "+", 
       FractionBox[
        RowBox[{"AbbSum59", " ", "T"}], "4"], "-", 
       FractionBox[
        RowBox[{"AbbSum58", " ", "U"}], "4"]}], ")"}], " ", "v", " ", 
     SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", "CKM33", " ", "EL", " ", 
         SuperscriptBox["Linv", "2"], " ", "MT2", " ", "v", " ", 
         SuperscriptBox["CtG", "\[Conjugate]"]}], "sw"], "-", 
       FractionBox[
        RowBox[{"2", " ", "CKM33", " ", "EL", " ", 
         SuperscriptBox["Linv", "2"], " ", "T", " ", "v", " ", 
         SuperscriptBox["CtG", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
     SuperscriptBox["Pair6", "\[Conjugate]"], " ", 
     SuperscriptBox[
      RowBox[{"Den", "(", 
       RowBox[{"T", ",", "MT2"}], ")"}], "2"], " ", 
     SuperscriptBox["Linv", "2"]}]}], "+", 
   RowBox[{
    FractionBox["1", "sw"], 
    RowBox[{"16", " ", "CtG", " ", "EL", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["Eps11", "2"]}], "+", 
       FractionBox[
        RowBox[{"AbbSum30", " ", "MB2"}], "2"], "-", 
       RowBox[{
        FractionBox["1", "4"], " ", "AbbSum31", " ", 
        RowBox[{"(", 
         RowBox[{"S", "-", "MT2"}], ")"}]}], "-", 
       FractionBox[
        RowBox[{"Pair12", " ", "T"}], "4"], "-", 
       FractionBox[
        RowBox[{"Pair11", " ", "U"}], "4"]}], ")"}], " ", "v", " ", 
     SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"8", " ", "CKM33", " ", "EL", " ", 
          RowBox[{"(", 
           RowBox[{"AbbSum1", "-", 
            FractionBox[
             RowBox[{"Pair5", " ", "T"}], "2"]}], ")"}], " ", "v", " ", 
          SuperscriptBox["CtG", "\[Conjugate]"], " ", 
          SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
       FractionBox[
        RowBox[{
        "4", " ", "CKM33", " ", "EL", " ", "MT2", " ", "Pair5", " ", "v", " ",
          
         SuperscriptBox["CtG", "\[Conjugate]"], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], ")"}], " ", 
     SuperscriptBox["Pair6", "\[Conjugate]"], " ", 
     SuperscriptBox[
      RowBox[{"Den", "(", 
       RowBox[{"T", ",", "MT2"}], ")"}], "2"], " ", 
     SuperscriptBox["Linv", "2"]}]}], "-", 
   FractionBox[
    RowBox[{"64", " ", 
     SqrtBox["2"], " ", "Alfa", " ", "CKM33", " ", "GS", " ", "Pair6", " ", 
     "\[Pi]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["1", "4"], " ", "MT", " ", "Pair14", " ", 
        RowBox[{"(", 
         RowBox[{"S", "-", "MB2"}], ")"}]}], "-", 
       FractionBox[
        RowBox[{"AbbSum21", " ", "MT"}], "2"]}], ")"}], " ", "v", " ", 
     SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
     SuperscriptBox["CtG", "\[Conjugate]"], " ", 
     SuperscriptBox["Pair4", "\[Conjugate]"], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"S", ",", "MB2"}], ")"}], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"T", ",", "MT2"}], ")"}], " ", 
     SuperscriptBox["Linv", "2"]}], 
    SuperscriptBox["sw", "2"]], "-", 
   FractionBox[
    RowBox[{"64", " ", 
     SqrtBox["2"], " ", "Alfa", " ", "CKM33", " ", "CtG", " ", "GS", " ", 
     "Pair4", " ", "\[Pi]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["1", "4"], " ", "MT", " ", "Pair10", " ", 
        RowBox[{"(", 
         RowBox[{"S", "-", "MB2"}], ")"}]}], "-", 
       FractionBox[
        RowBox[{"AbbSum85", " ", "MT"}], "2"]}], ")"}], " ", "v", " ", 
     SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
     SuperscriptBox["Pair6", "\[Conjugate]"], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"S", ",", "MB2"}], ")"}], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"T", ",", "MT2"}], ")"}], " ", 
     SuperscriptBox["Linv", "2"]}], 
    SuperscriptBox["sw", "2"]], "+", 
   FractionBox[
    RowBox[{"16", " ", "CtG", " ", "EL", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"AbbSum22", " ", "MT"}], "2"]}], "-", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{"S", "-", "MB2"}], ")"}], " ", "MT"}]}], ")"}], " ", "v", 
     " ", 
     SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
     SuperscriptBox["Pair6", "\[Conjugate]"], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"T", ",", "MT2"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair3", " ",
           
          RowBox[{"Den", "(", 
           RowBox[{"S", ",", "MB2"}], ")"}]}], "sw"]}], "-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair6", " ", 
         
         RowBox[{"Den", "(", 
          RowBox[{"T", ",", "MT2"}], ")"}]}], "sw"]}], ")"}], " ", 
     SuperscriptBox["Linv", "2"]}], "sw"], "+", 
   FractionBox[
    RowBox[{"16", " ", "CKM33", " ", "EL", " ", "Pair6", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"AbbSum22", " ", "MT"}], "2"]}], "-", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{"S", "-", "MB2"}], ")"}], " ", "MT"}]}], ")"}], " ", "v", 
     " ", 
     SuperscriptBox["CtG", "\[Conjugate]"], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"T", ",", "MT2"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SqrtBox["2"], " ", "EL", " ", "GS", " ", 
          SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
          SuperscriptBox["Pair3", "\[Conjugate]"], " ", 
          RowBox[{"Den", "(", 
           RowBox[{"S", ",", "MB2"}], ")"}]}], "sw"]}], "-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "EL", " ", "GS", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         SuperscriptBox["Pair6", "\[Conjugate]"], " ", 
         RowBox[{"Den", "(", 
          RowBox[{"T", ",", "MT2"}], ")"}]}], "sw"]}], ")"}], " ", 
     SuperscriptBox["Linv", "2"]}], "sw"], "+", 
   FractionBox[
    RowBox[{
    "128", " ", "Alfa", " ", "Alfas", " ", "CKM33", " ", "Pair4", " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["AbbSum80", "2"], "+", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "MW2"}], "+", "S", "+", "T"}], ")"}]}]}], ")"}], " ", 
     SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
     SuperscriptBox["Pair4", "\[Conjugate]"], " ", 
     SuperscriptBox[
      RowBox[{"Den", "(", 
       RowBox[{"S", ",", "MB2"}], ")"}], "2"]}], 
    SuperscriptBox["sw", "2"]], "+", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"AbbSum37", " ", "MT"}], "2"]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "Pair13", " ", 
       RowBox[{"(", 
        RowBox[{"S", "-", "MB2"}], ")"}], " ", "MT"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "CtG", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "MT2", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"]}], "sw"], "-", 
      FractionBox[
       RowBox[{"2", " ", "CtG", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "T", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
        "4", " ", "CKM33", " ", "CtG", " ", "EL", " ", "MT", " ", "Pair5", 
         " ", "v", " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
       "4", " ", "CKM33", " ", "EL", " ", "MT", " ", "Pair5", " ", "v", " ", 
        SuperscriptBox["CtG", "\[Conjugate]"], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair5"}], 
       "sw"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Den", "(", 
      RowBox[{"T", ",", "MT2"}], ")"}], "2"]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["AbbSum98", "2"], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "AbbSum54", " ", 
       RowBox[{"(", 
        RowBox[{"MW2", "-", "S", "-", "T"}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "CtG", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "MT2", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"]}], "sw"], "-", 
      FractionBox[
       RowBox[{"2", " ", "CtG", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "T", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "CKM33", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "MT2", " ", "v", " ", 
        SuperscriptBox["CtG", "\[Conjugate]"]}], "sw"], "-", 
      FractionBox[
       RowBox[{"2", " ", "CKM33", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "T", " ", "v", " ", 
        SuperscriptBox["CtG", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Den", "(", 
      RowBox[{"T", ",", "MT2"}], ")"}], "2"]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["AbbSum79", "2"], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "Pair13", " ", 
       RowBox[{"(", 
        RowBox[{"MW2", "-", "S", "-", "T"}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "CtG", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "MT2", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"]}], "sw"], "-", 
      FractionBox[
       RowBox[{"2", " ", "CtG", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "T", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"8", " ", "CKM33", " ", "EL", " ", 
         RowBox[{"(", 
          RowBox[{"AbbSum1", "-", 
           FractionBox[
            RowBox[{"Pair5", " ", "T"}], "2"]}], ")"}], " ", "v", " ", 
         SuperscriptBox["CtG", "\[Conjugate]"], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
       "4", " ", "CKM33", " ", "EL", " ", "MT2", " ", "Pair5", " ", "v", " ", 
        
        SuperscriptBox["CtG", "\[Conjugate]"], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Den", "(", 
      RowBox[{"T", ",", "MT2"}], ")"}], "2"]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"MB2", "-", "S"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"MT2", "-", "T"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
        "4", " ", "CKM33", " ", "CtG", " ", "EL", " ", "MT", " ", "Pair5", 
         " ", "v", " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
       "4", " ", "CKM33", " ", "EL", " ", "MT", " ", "Pair5", " ", "v", " ", 
        SuperscriptBox["CtG", "\[Conjugate]"], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair5"}], 
       "sw"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", " ", "CtG", " ", "EL", " ", "MT", " ", "v", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         SuperscriptBox["Pair5", "\[Conjugate]"], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{"4", " ", "EL", " ", "MT", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        SuperscriptBox["CtG", "\[Conjugate]"], " ", 
        SuperscriptBox["Pair5", "\[Conjugate]"], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "EL", " ", "GS", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        SuperscriptBox["Pair5", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Den", "(", 
      RowBox[{"T", ",", "MT2"}], ")"}], "2"]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"AbbSum95", " ", "MT"}], "2"]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "Pair5", " ", 
       RowBox[{"(", 
        RowBox[{"S", "-", "MB2"}], ")"}], " ", "MT"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "CKM33", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "MT2", " ", "v", " ", 
        SuperscriptBox["CtG", "\[Conjugate]"]}], "sw"], "-", 
      FractionBox[
       RowBox[{"2", " ", "CKM33", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "T", " ", "v", " ", 
        SuperscriptBox["CtG", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", " ", "CtG", " ", "EL", " ", "MT", " ", "v", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         SuperscriptBox["Pair5", "\[Conjugate]"], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{"4", " ", "EL", " ", "MT", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        SuperscriptBox["CtG", "\[Conjugate]"], " ", 
        SuperscriptBox["Pair5", "\[Conjugate]"], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "EL", " ", "GS", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        SuperscriptBox["Pair5", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Den", "(", 
      RowBox[{"T", ",", "MT2"}], ")"}], "2"]}], "-", 
   RowBox[{"MT", " ", 
    RowBox[{"(", 
     RowBox[{"S", "-", "MB2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"8", " ", "CKM33", " ", "EL", " ", 
         RowBox[{"(", 
          RowBox[{"AbbSum1", "-", 
           FractionBox[
            RowBox[{"Pair5", " ", "T"}], "2"]}], ")"}], " ", "v", " ", 
         SuperscriptBox["CtG", "\[Conjugate]"], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
       "4", " ", "CKM33", " ", "EL", " ", "MT2", " ", "Pair5", " ", "v", " ", 
        
        SuperscriptBox["CtG", "\[Conjugate]"], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", " ", "CtG", " ", "EL", " ", "MT", " ", "v", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         SuperscriptBox["Pair5", "\[Conjugate]"], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{"4", " ", "EL", " ", "MT", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        SuperscriptBox["CtG", "\[Conjugate]"], " ", 
        SuperscriptBox["Pair5", "\[Conjugate]"], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "EL", " ", "GS", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        SuperscriptBox["Pair5", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Den", "(", 
      RowBox[{"T", ",", "MT2"}], ")"}], "2"]}], "-", 
   RowBox[{"MT", " ", 
    RowBox[{"(", 
     RowBox[{"S", "-", "MB2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
        "4", " ", "CKM33", " ", "CtG", " ", "EL", " ", "MT", " ", "Pair5", 
         " ", "v", " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
       "4", " ", "CKM33", " ", "EL", " ", "MT", " ", "Pair5", " ", "v", " ", 
        SuperscriptBox["CtG", "\[Conjugate]"], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair5"}], 
       "sw"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", " ", "CtG", " ", "EL", " ", "MT2", " ", "v", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         SuperscriptBox["Pair5", "\[Conjugate]"], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{"8", " ", "CtG", " ", "EL", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["AbbSum1", "\[Conjugate]"], "-", 
          FractionBox[
           RowBox[{"T", " ", 
            SuperscriptBox["Pair5", "\[Conjugate]"]}], "2"]}], ")"}], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Den", "(", 
      RowBox[{"T", ",", "MT2"}], ")"}], "2"]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["AbbSum89", "2"], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "Pair5", " ", 
       RowBox[{"(", 
        RowBox[{"MW2", "-", "S", "-", "T"}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "CKM33", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "MT2", " ", "v", " ", 
        SuperscriptBox["CtG", "\[Conjugate]"]}], "sw"], "-", 
      FractionBox[
       RowBox[{"2", " ", "CKM33", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "T", " ", "v", " ", 
        SuperscriptBox["CtG", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", " ", "CtG", " ", "EL", " ", "MT2", " ", "v", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         SuperscriptBox["Pair5", "\[Conjugate]"], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{"8", " ", "CtG", " ", "EL", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["AbbSum1", "\[Conjugate]"], "-", 
          FractionBox[
           RowBox[{"T", " ", 
            SuperscriptBox["Pair5", "\[Conjugate]"]}], "2"]}], ")"}], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Den", "(", 
      RowBox[{"T", ",", "MT2"}], ")"}], "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "MW2"}], "+", "S", "+", "T"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"8", " ", "CKM33", " ", "EL", " ", 
         RowBox[{"(", 
          RowBox[{"AbbSum1", "-", 
           FractionBox[
            RowBox[{"Pair5", " ", "T"}], "2"]}], ")"}], " ", "v", " ", 
         SuperscriptBox["CtG", "\[Conjugate]"], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
       "4", " ", "CKM33", " ", "EL", " ", "MT2", " ", "Pair5", " ", "v", " ", 
        
        SuperscriptBox["CtG", "\[Conjugate]"], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", " ", "CtG", " ", "EL", " ", "MT2", " ", "v", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         SuperscriptBox["Pair5", "\[Conjugate]"], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{"8", " ", "CtG", " ", "EL", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["AbbSum1", "\[Conjugate]"], "-", 
          FractionBox[
           RowBox[{"T", " ", 
            SuperscriptBox["Pair5", "\[Conjugate]"]}], "2"]}], ")"}], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Den", "(", 
      RowBox[{"T", ",", "MT2"}], ")"}], "2"]}], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SqrtBox["2"], " ", "AbbSum84", " ", "CKM33", " ", "EL", " ", "GS", " ", 
     "MT", " ", "Pair4", " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", "CtG", " ", "EL", " ", 
         SuperscriptBox["Linv", "2"], " ", "MT2", " ", "v", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"]}], "sw"], "-", 
       FractionBox[
        RowBox[{"2", " ", "CtG", " ", "EL", " ", 
         SuperscriptBox["Linv", "2"], " ", "T", " ", "v", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"S", ",", "MB2"}], ")"}], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"T", ",", "MT2"}], ")"}]}], "sw"], "-", 
   RowBox[{
    FractionBox["1", "sw"], 
    RowBox[{"4", " ", 
     SqrtBox["2"], " ", "EL", " ", "GS", " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["Eps25", "2"], "+", 
       RowBox[{
        FractionBox["1", "4"], " ", "Pair8", " ", 
        RowBox[{"(", 
         RowBox[{"S", "-", "MB2"}], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "4"], " ", "Pair9", " ", 
        RowBox[{"(", 
         RowBox[{"T", "-", "MT2"}], ")"}]}]}], ")"}], " ", 
     SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
         "4", " ", "CKM33", " ", "CtG", " ", "EL", " ", "MT", " ", "Pair5", 
          " ", "v", " ", 
          SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
       FractionBox[
        RowBox[{
        "4", " ", "CKM33", " ", "EL", " ", "MT", " ", "Pair5", " ", "v", " ", 
         
         SuperscriptBox["CtG", "\[Conjugate]"], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"], "-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair5"}], 
        "sw"]}], ")"}], " ", 
     SuperscriptBox["Pair4", "\[Conjugate]"], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"S", ",", "MB2"}], ")"}], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"T", ",", "MT2"}], ")"}]}]}], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SqrtBox["2"], " ", "AbbSum93", " ", "EL", " ", "GS", " ", "MT", " ", 
     SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", "CKM33", " ", "EL", " ", 
         SuperscriptBox["Linv", "2"], " ", "MT2", " ", "v", " ", 
         SuperscriptBox["CtG", "\[Conjugate]"]}], "sw"], "-", 
       FractionBox[
        RowBox[{"2", " ", "CKM33", " ", "EL", " ", 
         SuperscriptBox["Linv", "2"], " ", "T", " ", "v", " ", 
         SuperscriptBox["CtG", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
     SuperscriptBox["Pair4", "\[Conjugate]"], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"S", ",", "MB2"}], ")"}], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"T", ",", "MT2"}], ")"}]}], "sw"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SqrtBox["2"], " ", "EL", " ", "GS", " ", "MT", " ", "Pair9", " ", 
     SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"8", " ", "CKM33", " ", "EL", " ", 
          RowBox[{"(", 
           RowBox[{"AbbSum1", "-", 
            FractionBox[
             RowBox[{"Pair5", " ", "T"}], "2"]}], ")"}], " ", "v", " ", 
          SuperscriptBox["CtG", "\[Conjugate]"], " ", 
          SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
       FractionBox[
        RowBox[{
        "4", " ", "CKM33", " ", "EL", " ", "MT2", " ", "Pair5", " ", "v", " ",
          
         SuperscriptBox["CtG", "\[Conjugate]"], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], ")"}], " ", 
     SuperscriptBox["Pair4", "\[Conjugate]"], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"S", ",", "MB2"}], ")"}], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"T", ",", "MT2"}], ")"}]}], "sw"], "-", 
   RowBox[{
    FractionBox["1", "sw"], 
    RowBox[{"4", " ", 
     SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair4", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["Eps3", "2"]}], "+", 
       RowBox[{
        FractionBox["1", "4"], " ", "Pair6", " ", 
        RowBox[{"(", 
         RowBox[{"S", "-", "MB2"}], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "4"], " ", "Pair3", " ", 
        RowBox[{"(", 
         RowBox[{"T", "-", "MT2"}], ")"}]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"4", " ", "CtG", " ", "EL", " ", "MT", " ", "v", " ", 
          SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
          SuperscriptBox["Pair5", "\[Conjugate]"], " ", 
          SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
       FractionBox[
        RowBox[{"4", " ", "EL", " ", "MT", " ", "v", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         SuperscriptBox["CtG", "\[Conjugate]"], " ", 
         SuperscriptBox["Pair5", "\[Conjugate]"], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"], "-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "EL", " ", "GS", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         SuperscriptBox["Pair5", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"S", ",", "MB2"}], ")"}], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"T", ",", "MT2"}], ")"}]}]}], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "MT", " ", 
     "Pair3", " ", "Pair4", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"4", " ", "CtG", " ", "EL", " ", "MT2", " ", "v", " ", 
          SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
          SuperscriptBox["Pair5", "\[Conjugate]"], " ", 
          SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
       FractionBox[
        RowBox[{"8", " ", "CtG", " ", "EL", " ", "v", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["AbbSum1", "\[Conjugate]"], "-", 
           FractionBox[
            RowBox[{"T", " ", 
             SuperscriptBox["Pair5", "\[Conjugate]"]}], "2"]}], ")"}], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], ")"}], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"S", ",", "MB2"}], ")"}], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"T", ",", "MT2"}], ")"}]}], "sw"], "-", 
   FractionBox[
    RowBox[{"4", " ", 
     SqrtBox["2"], " ", "EL", " ", "GS", " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["AbbSum14", "2"], "+", 
       RowBox[{
        FractionBox["1", "4"], " ", "Pair14", " ", 
        RowBox[{"(", 
         RowBox[{"MW2", "-", "S", "-", "T"}], ")"}]}]}], ")"}], " ", 
     SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
     SuperscriptBox["Pair4", "\[Conjugate]"], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"S", ",", "MB2"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair3", " ",
           
          RowBox[{"Den", "(", 
           RowBox[{"S", ",", "MB2"}], ")"}]}], "sw"]}], "-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair6", " ", 
         
         RowBox[{"Den", "(", 
          RowBox[{"T", ",", "MT2"}], ")"}]}], "sw"]}], ")"}]}], "sw"], "-", 
   RowBox[{"2", " ", "AbbSum20", " ", "MT", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "CtG", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "MT2", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"]}], "sw"], "-", 
      FractionBox[
       RowBox[{"2", " ", "CtG", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "T", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
    RowBox[{"Den", "(", 
     RowBox[{"T", ",", "MT2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair3", " ", 
         
         RowBox[{"Den", "(", 
          RowBox[{"S", ",", "MB2"}], ")"}]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair6", " ", 
        RowBox[{"Den", "(", 
         RowBox[{"T", ",", "MT2"}], ")"}]}], "sw"]}], ")"}]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["Eps15", "2"]}], "-", 
      FractionBox[
       RowBox[{"AbbSum17", " ", "MB2"}], "2"], "-", 
      FractionBox[
       RowBox[{"AbbSum16", " ", "MT2"}], "4"], "+", 
      FractionBox[
       RowBox[{"AbbSum13", " ", "S"}], "4"], "-", 
      FractionBox[
       RowBox[{"Pair1", " ", "T"}], "4"], "+", 
      FractionBox[
       RowBox[{"Pair4", " ", "U"}], "4"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", " ", "CtG", " ", "EL", " ", "MT", " ", "v", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         SuperscriptBox["Pair5", "\[Conjugate]"], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{"4", " ", "EL", " ", "MT", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        SuperscriptBox["CtG", "\[Conjugate]"], " ", 
        SuperscriptBox["Pair5", "\[Conjugate]"], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "EL", " ", "GS", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        SuperscriptBox["Pair5", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
    RowBox[{"Den", "(", 
     RowBox[{"T", ",", "MT2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair3", " ", 
         
         RowBox[{"Den", "(", 
          RowBox[{"S", ",", "MB2"}], ")"}]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair6", " ", 
        RowBox[{"Den", "(", 
         RowBox[{"T", ",", "MT2"}], ")"}]}], "sw"]}], ")"}]}], "-", 
   RowBox[{"2", " ", "MT", " ", "Pair1", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", " ", "CtG", " ", "EL", " ", "MT2", " ", "v", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         SuperscriptBox["Pair5", "\[Conjugate]"], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{"8", " ", "CtG", " ", "EL", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["AbbSum1", "\[Conjugate]"], "-", 
          FractionBox[
           RowBox[{"T", " ", 
            SuperscriptBox["Pair5", "\[Conjugate]"]}], "2"]}], ")"}], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"]}], ")"}], " ", 
    RowBox[{"Den", "(", 
     RowBox[{"T", ",", "MT2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair3", " ", 
         
         RowBox[{"Den", "(", 
          RowBox[{"S", ",", "MB2"}], ")"}]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair6", " ", 
        RowBox[{"Den", "(", 
         RowBox[{"T", ",", "MT2"}], ")"}]}], "sw"]}], ")"}]}], "-", 
   RowBox[{
    FractionBox["1", "sw"], 
    RowBox[{"4", " ", 
     SqrtBox["2"], " ", "EL", " ", "GS", " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["AbbSum109", "2"], "-", 
       FractionBox[
        RowBox[{"AbbSum108", " ", "MB2"}], "4"], "+", 
       FractionBox[
        RowBox[{"AbbSum107", " ", "MT2"}], "4"], "+", 
       FractionBox[
        RowBox[{"AbbSum69", " ", "S"}], "4"], "-", 
       FractionBox[
        RowBox[{"AbbSum67", " ", "T"}], "4"], "-", 
       FractionBox[
        RowBox[{"AbbSum106", " ", "U"}], "4"]}], ")"}], " ", 
     SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
     SuperscriptBox["Pair4", "\[Conjugate]"], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"S", ",", "MB2"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{"CKM33", " ", "EL", " ", "GS", " ", 
         RowBox[{"Den", "(", 
          RowBox[{"S", ",", "MB2"}], ")"}]}], 
        RowBox[{
         SqrtBox["2"], " ", "sw"}]], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{
           "2", " ", "CKM33", " ", "CtG", " ", "EL", " ", "MT", " ", "v", " ",
             
            SuperscriptBox["Linv", "2"]}], "sw"], "+", 
          FractionBox[
           RowBox[{"2", " ", "CKM33", " ", "EL", " ", "MT", " ", "v", " ", 
            SuperscriptBox["CtG", "\[Conjugate]"], " ", 
            SuperscriptBox["Linv", "2"]}], "sw"], "+", 
          FractionBox[
           RowBox[{"CKM33", " ", "EL", " ", "GS"}], 
           RowBox[{
            SqrtBox["2"], " ", "sw"}]]}], ")"}], " ", 
        RowBox[{"Den", "(", 
         RowBox[{"T", ",", "MT2"}], ")"}]}]}], ")"}]}]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"AbbSum105", " ", "MT"}], "2"]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "AbbSum54", " ", 
       RowBox[{"(", 
        RowBox[{"S", "-", "MB2"}], ")"}], " ", "MT"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "CtG", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "MT2", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"]}], "sw"], "-", 
      FractionBox[
       RowBox[{"2", " ", "CtG", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "T", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
    RowBox[{"Den", "(", 
     RowBox[{"T", ",", "MT2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"CKM33", " ", "EL", " ", "GS", " ", 
        RowBox[{"Den", "(", 
         RowBox[{"S", ",", "MB2"}], ")"}]}], 
       RowBox[{
        SqrtBox["2"], " ", "sw"}]], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
          "2", " ", "CKM33", " ", "CtG", " ", "EL", " ", "MT", " ", "v", " ", 
           
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"2", " ", "CKM33", " ", "EL", " ", "MT", " ", "v", " ", 
           SuperscriptBox["CtG", "\[Conjugate]"], " ", 
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"CKM33", " ", "EL", " ", "GS"}], 
          RowBox[{
           SqrtBox["2"], " ", "sw"}]]}], ")"}], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "MT2"}], ")"}]}]}], ")"}]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", "Pair5", " ", 
       RowBox[{"(", 
        RowBox[{"MB2", "-", "S"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"MT2", "-", "T"}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "AbbSum95", " ", 
       RowBox[{"(", 
        RowBox[{"T", "-", "MT2"}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", " ", "CtG", " ", "EL", " ", "MT", " ", "v", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         SuperscriptBox["Pair5", "\[Conjugate]"], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{"4", " ", "EL", " ", "MT", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        SuperscriptBox["CtG", "\[Conjugate]"], " ", 
        SuperscriptBox["Pair5", "\[Conjugate]"], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "EL", " ", "GS", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        SuperscriptBox["Pair5", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
    RowBox[{"Den", "(", 
     RowBox[{"T", ",", "MT2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"CKM33", " ", "EL", " ", "GS", " ", 
        RowBox[{"Den", "(", 
         RowBox[{"S", ",", "MB2"}], ")"}]}], 
       RowBox[{
        SqrtBox["2"], " ", "sw"}]], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
          "2", " ", "CKM33", " ", "CtG", " ", "EL", " ", "MT", " ", "v", " ", 
           
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"2", " ", "CKM33", " ", "EL", " ", "MT", " ", "v", " ", 
           SuperscriptBox["CtG", "\[Conjugate]"], " ", 
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"CKM33", " ", "EL", " ", "GS"}], 
          RowBox[{
           SqrtBox["2"], " ", "sw"}]]}], ")"}], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "MT2"}], ")"}]}]}], ")"}]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"AbbSum95", " ", "MT"}], "2"]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "Pair5", " ", 
       RowBox[{"(", 
        RowBox[{"S", "-", "MB2"}], ")"}], " ", "MT"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", " ", "CtG", " ", "EL", " ", "MT2", " ", "v", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         SuperscriptBox["Pair5", "\[Conjugate]"], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{"8", " ", "CtG", " ", "EL", " ", "v", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["AbbSum1", "\[Conjugate]"], "-", 
          FractionBox[
           RowBox[{"T", " ", 
            SuperscriptBox["Pair5", "\[Conjugate]"]}], "2"]}], ")"}], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"]}], ")"}], " ", 
    RowBox[{"Den", "(", 
     RowBox[{"T", ",", "MT2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"CKM33", " ", "EL", " ", "GS", " ", 
        RowBox[{"Den", "(", 
         RowBox[{"S", ",", "MB2"}], ")"}]}], 
       RowBox[{
        SqrtBox["2"], " ", "sw"}]], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
          "2", " ", "CKM33", " ", "CtG", " ", "EL", " ", "MT", " ", "v", " ", 
           
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"2", " ", "CKM33", " ", "EL", " ", "MT", " ", "v", " ", 
           SuperscriptBox["CtG", "\[Conjugate]"], " ", 
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"CKM33", " ", "EL", " ", "GS"}], 
          RowBox[{
           SqrtBox["2"], " ", "sw"}]]}], ")"}], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "MT2"}], ")"}]}]}], ")"}]}], "-", 
   RowBox[{
    FractionBox["1", "sw"], 
    RowBox[{"4", " ", 
     SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair4", " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["AbbSum88", "2"], "+", 
       FractionBox[
        RowBox[{"AbbSum10", " ", "MB2"}], "4"], "+", 
       FractionBox[
        RowBox[{"AbbSum87", " ", "MT2"}], "4"], "-", 
       FractionBox[
        RowBox[{"AbbSum9", " ", "S"}], "4"], "-", 
       FractionBox[
        RowBox[{"AbbSum84", " ", "T"}], "4"], "-", 
       FractionBox[
        RowBox[{"Pair11", " ", "U"}], "4"]}], ")"}], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"S", ",", "MB2"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{"EL", " ", "GS", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         RowBox[{"Den", "(", 
          RowBox[{"S", ",", "MB2"}], ")"}]}], 
        RowBox[{
         SqrtBox["2"], " ", "sw"}]], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"2", " ", "CtG", " ", "EL", " ", "MT", " ", "v", " ", 
            SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
            SuperscriptBox["Linv", "2"]}], "sw"], "+", 
          FractionBox[
           RowBox[{"2", " ", "EL", " ", "MT", " ", "v", " ", 
            SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
            SuperscriptBox["CtG", "\[Conjugate]"], " ", 
            SuperscriptBox["Linv", "2"]}], "sw"], "+", 
          FractionBox[
           RowBox[{"EL", " ", "GS", " ", 
            SuperscriptBox["CKM33", "\[Conjugate]"]}], 
           RowBox[{
            SqrtBox["2"], " ", "sw"}]]}], ")"}], " ", 
        RowBox[{"Den", "(", 
         RowBox[{"T", ",", "MT2"}], ")"}]}]}], ")"}]}]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", "Pair13", " ", 
       RowBox[{"(", 
        RowBox[{"MB2", "-", "S"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"MT2", "-", "T"}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "AbbSum37", " ", 
       RowBox[{"(", 
        RowBox[{"T", "-", "MT2"}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
        "4", " ", "CKM33", " ", "CtG", " ", "EL", " ", "MT", " ", "Pair5", 
         " ", "v", " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
       "4", " ", "CKM33", " ", "EL", " ", "MT", " ", "Pair5", " ", "v", " ", 
        SuperscriptBox["CtG", "\[Conjugate]"], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair5"}], 
       "sw"]}], ")"}], " ", 
    RowBox[{"Den", "(", 
     RowBox[{"T", ",", "MT2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"EL", " ", "GS", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        RowBox[{"Den", "(", 
         RowBox[{"S", ",", "MB2"}], ")"}]}], 
       RowBox[{
        SqrtBox["2"], " ", "sw"}]], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", "CtG", " ", "EL", " ", "MT", " ", "v", " ", 
           SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"2", " ", "EL", " ", "MT", " ", "v", " ", 
           SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
           SuperscriptBox["CtG", "\[Conjugate]"], " ", 
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"EL", " ", "GS", " ", 
           SuperscriptBox["CKM33", "\[Conjugate]"]}], 
          RowBox[{
           SqrtBox["2"], " ", "sw"}]]}], ")"}], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "MT2"}], ")"}]}]}], ")"}]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"AbbSum105", " ", "MT"}], "2"]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "AbbSum54", " ", 
       RowBox[{"(", 
        RowBox[{"S", "-", "MB2"}], ")"}], " ", "MT"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "CKM33", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "MT2", " ", "v", " ", 
        SuperscriptBox["CtG", "\[Conjugate]"]}], "sw"], "-", 
      FractionBox[
       RowBox[{"2", " ", "CKM33", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "T", " ", "v", " ", 
        SuperscriptBox["CtG", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
    RowBox[{"Den", "(", 
     RowBox[{"T", ",", "MT2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"EL", " ", "GS", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        RowBox[{"Den", "(", 
         RowBox[{"S", ",", "MB2"}], ")"}]}], 
       RowBox[{
        SqrtBox["2"], " ", "sw"}]], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", "CtG", " ", "EL", " ", "MT", " ", "v", " ", 
           SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"2", " ", "EL", " ", "MT", " ", "v", " ", 
           SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
           SuperscriptBox["CtG", "\[Conjugate]"], " ", 
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"EL", " ", "GS", " ", 
           SuperscriptBox["CKM33", "\[Conjugate]"]}], 
          RowBox[{
           SqrtBox["2"], " ", "sw"}]]}], ")"}], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "MT2"}], ")"}]}]}], ")"}]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"AbbSum37", " ", "MT"}], "2"]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "Pair13", " ", 
       RowBox[{"(", 
        RowBox[{"S", "-", "MB2"}], ")"}], " ", "MT"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"8", " ", "CKM33", " ", "EL", " ", 
         RowBox[{"(", 
          RowBox[{"AbbSum1", "-", 
           FractionBox[
            RowBox[{"Pair5", " ", "T"}], "2"]}], ")"}], " ", "v", " ", 
         SuperscriptBox["CtG", "\[Conjugate]"], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
       "4", " ", "CKM33", " ", "EL", " ", "MT2", " ", "Pair5", " ", "v", " ", 
        
        SuperscriptBox["CtG", "\[Conjugate]"], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"]}], ")"}], " ", 
    RowBox[{"Den", "(", 
     RowBox[{"T", ",", "MT2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"EL", " ", "GS", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        RowBox[{"Den", "(", 
         RowBox[{"S", ",", "MB2"}], ")"}]}], 
       RowBox[{
        SqrtBox["2"], " ", "sw"}]], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", "CtG", " ", "EL", " ", "MT", " ", "v", " ", 
           SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"2", " ", "EL", " ", "MT", " ", "v", " ", 
           SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
           SuperscriptBox["CtG", "\[Conjugate]"], " ", 
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"EL", " ", "GS", " ", 
           SuperscriptBox["CKM33", "\[Conjugate]"]}], 
          RowBox[{
           SqrtBox["2"], " ", "sw"}]]}], ")"}], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "MT2"}], ")"}]}]}], ")"}]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["AbbSum28", "2"], "-", 
      FractionBox[
       RowBox[{"AbbSum25", " ", "MB2"}], "2"], "-", 
      FractionBox[
       RowBox[{"AbbSum24", " ", "MT2"}], "4"], "+", 
      FractionBox[
       RowBox[{"AbbSum26", " ", "S"}], "4"], "-", 
      FractionBox[
       RowBox[{"AbbSum20", " ", "T"}], "4"], "+", 
      FractionBox[
       RowBox[{"AbbSum27", " ", "U"}], "4"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair3", " ", 
         
         RowBox[{"Den", "(", 
          RowBox[{"S", ",", "MB2"}], ")"}]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair6", " ", 
        RowBox[{"Den", "(", 
         RowBox[{"T", ",", "MT2"}], ")"}]}], "sw"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"EL", " ", "GS", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        RowBox[{"Den", "(", 
         RowBox[{"S", ",", "MB2"}], ")"}]}], 
       RowBox[{
        SqrtBox["2"], " ", "sw"}]], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", "CtG", " ", "EL", " ", "MT", " ", "v", " ", 
           SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"2", " ", "EL", " ", "MT", " ", "v", " ", 
           SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
           SuperscriptBox["CtG", "\[Conjugate]"], " ", 
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"EL", " ", "GS", " ", 
           SuperscriptBox["CKM33", "\[Conjugate]"]}], 
          RowBox[{
           SqrtBox["2"], " ", "sw"}]]}], ")"}], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "MT2"}], ")"}]}]}], ")"}]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", "AbbSum54", " ", 
       RowBox[{"(", 
        RowBox[{"MB2", "-", "S"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"MT2", "-", "T"}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "AbbSum105", " ", 
       RowBox[{"(", 
        RowBox[{"T", "-", "MT2"}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"CKM33", " ", "EL", " ", "GS", " ", 
        RowBox[{"Den", "(", 
         RowBox[{"S", ",", "MB2"}], ")"}]}], 
       RowBox[{
        SqrtBox["2"], " ", "sw"}]], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
          "2", " ", "CKM33", " ", "CtG", " ", "EL", " ", "MT", " ", "v", " ", 
           
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"2", " ", "CKM33", " ", "EL", " ", "MT", " ", "v", " ", 
           SuperscriptBox["CtG", "\[Conjugate]"], " ", 
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"CKM33", " ", "EL", " ", "GS"}], 
          RowBox[{
           SqrtBox["2"], " ", "sw"}]]}], ")"}], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "MT2"}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"EL", " ", "GS", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        RowBox[{"Den", "(", 
         RowBox[{"S", ",", "MB2"}], ")"}]}], 
       RowBox[{
        SqrtBox["2"], " ", "sw"}]], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", "CtG", " ", "EL", " ", "MT", " ", "v", " ", 
           SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"2", " ", "EL", " ", "MT", " ", "v", " ", 
           SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
           SuperscriptBox["CtG", "\[Conjugate]"], " ", 
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"EL", " ", "GS", " ", 
           SuperscriptBox["CKM33", "\[Conjugate]"]}], 
          RowBox[{
           SqrtBox["2"], " ", "sw"}]]}], ")"}], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "MT2"}], ")"}]}]}], ")"}]}], "-", 
   FractionBox[
    RowBox[{"4", " ", 
     SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair4", " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["AbbSum81", "2"], "+", 
       RowBox[{
        FractionBox["1", "4"], " ", "Pair10", " ", 
        RowBox[{"(", 
         RowBox[{"MW2", "-", "S", "-", "T"}], ")"}]}]}], ")"}], " ", 
     RowBox[{"Den", "(", 
      RowBox[{"S", ",", "MB2"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SqrtBox["2"], " ", "EL", " ", "GS", " ", 
          SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
          SuperscriptBox["Pair3", "\[Conjugate]"], " ", 
          RowBox[{"Den", "(", 
           RowBox[{"S", ",", "MB2"}], ")"}]}], "sw"]}], "-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "EL", " ", "GS", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         SuperscriptBox["Pair6", "\[Conjugate]"], " ", 
         RowBox[{"Den", "(", 
          RowBox[{"T", ",", "MT2"}], ")"}]}], "sw"]}], ")"}]}], "sw"], "+", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["Eps11", "2"], "-", 
      FractionBox[
       RowBox[{"AbbSum30", " ", "MB2"}], "2"], "-", 
      FractionBox[
       RowBox[{"AbbSum29", " ", "MT2"}], "4"], "+", 
      FractionBox[
       RowBox[{"AbbSum31", " ", "S"}], "4"], "-", 
      FractionBox[
       RowBox[{"Pair12", " ", "T"}], "4"], "+", 
      FractionBox[
       RowBox[{"Pair11", " ", "U"}], "4"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
        "4", " ", "CKM33", " ", "CtG", " ", "EL", " ", "MT", " ", "Pair5", 
         " ", "v", " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
       "4", " ", "CKM33", " ", "EL", " ", "MT", " ", "Pair5", " ", "v", " ", 
        SuperscriptBox["CtG", "\[Conjugate]"], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair5"}], 
       "sw"]}], ")"}], " ", 
    RowBox[{"Den", "(", 
     RowBox[{"T", ",", "MT2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "EL", " ", "GS", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         SuperscriptBox["Pair3", "\[Conjugate]"], " ", 
         RowBox[{"Den", "(", 
          RowBox[{"S", ",", "MB2"}], ")"}]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "EL", " ", "GS", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        SuperscriptBox["Pair6", "\[Conjugate]"], " ", 
        RowBox[{"Den", "(", 
         RowBox[{"T", ",", "MT2"}], ")"}]}], "sw"]}], ")"}]}], "+", 
   RowBox[{"2", " ", "AbbSum94", " ", "MT", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "CKM33", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "MT2", " ", "v", " ", 
        SuperscriptBox["CtG", "\[Conjugate]"]}], "sw"], "-", 
      FractionBox[
       RowBox[{"2", " ", "CKM33", " ", "EL", " ", 
        SuperscriptBox["Linv", "2"], " ", "T", " ", "v", " ", 
        SuperscriptBox["CtG", "\[Conjugate]"]}], "sw"]}], ")"}], " ", 
    RowBox[{"Den", "(", 
     RowBox[{"T", ",", "MT2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "EL", " ", "GS", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         SuperscriptBox["Pair3", "\[Conjugate]"], " ", 
         RowBox[{"Den", "(", 
          RowBox[{"S", ",", "MB2"}], ")"}]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "EL", " ", "GS", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        SuperscriptBox["Pair6", "\[Conjugate]"], " ", 
        RowBox[{"Den", "(", 
         RowBox[{"T", ",", "MT2"}], ")"}]}], "sw"]}], ")"}]}], "-", 
   RowBox[{"2", " ", "MT", " ", "Pair12", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"8", " ", "CKM33", " ", "EL", " ", 
         RowBox[{"(", 
          RowBox[{"AbbSum1", "-", 
           FractionBox[
            RowBox[{"Pair5", " ", "T"}], "2"]}], ")"}], " ", "v", " ", 
         SuperscriptBox["CtG", "\[Conjugate]"], " ", 
         SuperscriptBox["Linv", "2"]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
       "4", " ", "CKM33", " ", "EL", " ", "MT2", " ", "Pair5", " ", "v", " ", 
        
        SuperscriptBox["CtG", "\[Conjugate]"], " ", 
        SuperscriptBox["Linv", "2"]}], "sw"]}], ")"}], " ", 
    RowBox[{"Den", "(", 
     RowBox[{"T", ",", "MT2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "EL", " ", "GS", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         SuperscriptBox["Pair3", "\[Conjugate]"], " ", 
         RowBox[{"Den", "(", 
          RowBox[{"S", ",", "MB2"}], ")"}]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "EL", " ", "GS", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        SuperscriptBox["Pair6", "\[Conjugate]"], " ", 
        RowBox[{"Den", "(", 
         RowBox[{"T", ",", "MT2"}], ")"}]}], "sw"]}], ")"}]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["AbbSum15", "2"], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "MW2"}], "+", "S", "+", "T"}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair3", " ", 
         
         RowBox[{"Den", "(", 
          RowBox[{"S", ",", "MB2"}], ")"}]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "GS", " ", "Pair6", " ", 
        RowBox[{"Den", "(", 
         RowBox[{"T", ",", "MT2"}], ")"}]}], "sw"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "EL", " ", "GS", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         SuperscriptBox["Pair3", "\[Conjugate]"], " ", 
         RowBox[{"Den", "(", 
          RowBox[{"S", ",", "MB2"}], ")"}]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "EL", " ", "GS", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        SuperscriptBox["Pair6", "\[Conjugate]"], " ", 
        RowBox[{"Den", "(", 
         RowBox[{"T", ",", "MT2"}], ")"}]}], "sw"]}], ")"}]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["AbbSum112", "2"]}], "-", 
      FractionBox[
       RowBox[{"AbbSum110", " ", "MB2"}], "2"], "-", 
      FractionBox[
       RowBox[{"AbbSum111", " ", "MT2"}], "4"], "+", 
      FractionBox[
       RowBox[{"AbbSum73", " ", "S"}], "4"], "+", 
      FractionBox[
       RowBox[{"AbbSum59", " ", "T"}], "4"], "+", 
      FractionBox[
       RowBox[{"AbbSum97", " ", "U"}], "4"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"CKM33", " ", "EL", " ", "GS", " ", 
        RowBox[{"Den", "(", 
         RowBox[{"S", ",", "MB2"}], ")"}]}], 
       RowBox[{
        SqrtBox["2"], " ", "sw"}]], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
          "2", " ", "CKM33", " ", "CtG", " ", "EL", " ", "MT", " ", "v", " ", 
           
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"2", " ", "CKM33", " ", "EL", " ", "MT", " ", "v", " ", 
           SuperscriptBox["CtG", "\[Conjugate]"], " ", 
           SuperscriptBox["Linv", "2"]}], "sw"], "+", 
         FractionBox[
          RowBox[{"CKM33", " ", "EL", " ", "GS"}], 
          RowBox[{
           SqrtBox["2"], " ", "sw"}]]}], ")"}], " ", 
       RowBox[{"Den", "(", 
        RowBox[{"T", ",", "MT2"}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "EL", " ", "GS", " ", 
         SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
         SuperscriptBox["Pair3", "\[Conjugate]"], " ", 
         RowBox[{"Den", "(", 
          RowBox[{"S", ",", "MB2"}], ")"}]}], "sw"]}], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "EL", " ", "GS", " ", 
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        SuperscriptBox["Pair6", "\[Conjugate]"], " ", 
        RowBox[{"Den", "(", 
         RowBox[{"T", ",", "MT2"}], ")"}]}], "sw"]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.500718843537882*^9, 3.50071888023175*^9, 
  3.500718962531796*^9, 3.50071900070191*^9, 3.5007190730172997`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"M3", "=", 
   RowBox[{"PolarizationSum", "[", "M2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.49966507338302*^9, {3.499665479244595*^9, 3.499665508978133*^9}, {
   3.499666915703204*^9, 3.499666925813794*^9}, {3.500618089746357*^9, 
   3.500618099391782*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.499600589590599*^9, {3.499600654562523*^9, 3.4996006662132063`*^9}, 
   3.4996647320023203`*^9, 3.499664809869158*^9, 3.499665423953055*^9, 
   3.499666927140604*^9, 3.500187295333789*^9, 3.5001877245136967`*^9, 
   3.500385582328672*^9, 3.5006171283874817`*^9, 3.500617337208673*^9, 
   3.5006173955899076`*^9, 3.5006180272919273`*^9, {3.500618090755332*^9, 
   3.500618100419582*^9}, 3.5006183273770437`*^9, 3.5006185525869417`*^9, 
   3.500619309117373*^9, 3.500620038495502*^9, 3.5006276112185087`*^9, 
   3.5007185546686687`*^9, 3.5007190901932173`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-7.0/fc4.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-7.0/fc4.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.499600589590599*^9, {3.499600654562523*^9, 3.4996006662132063`*^9}, 
   3.4996647320023203`*^9, 3.499664809869158*^9, 3.499665423953055*^9, 
   3.499666927140604*^9, 3.500187295333789*^9, 3.5001877245136967`*^9, 
   3.500385582328672*^9, 3.5006171283874817`*^9, 3.500617337208673*^9, 
   3.5006173955899076`*^9, 3.5006180272919273`*^9, {3.500618090755332*^9, 
   3.500618100419582*^9}, 3.5006183273770437`*^9, 3.5006185525869417`*^9, 
   3.500619309117373*^9, 3.500620038495502*^9, 3.5006276112185087`*^9, 
   3.5007185546686687`*^9, 3.500719090213043*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{
  3.499600589590599*^9, {3.499600654562523*^9, 3.4996006662132063`*^9}, 
   3.4996647320023203`*^9, 3.499664809869158*^9, 3.499665423953055*^9, 
   3.499666927140604*^9, 3.500187295333789*^9, 3.5001877245136967`*^9, 
   3.500385582328672*^9, 3.5006171283874817`*^9, 3.500617337208673*^9, 
   3.5006173955899076`*^9, 3.5006180272919273`*^9, {3.500618090755332*^9, 
   3.500618100419582*^9}, 3.5006183273770437`*^9, 3.5006185525869417`*^9, 
   3.500619309117373*^9, 3.500620038495502*^9, 3.5006276112185087`*^9, 
   3.5007185546686687`*^9, 3.500719090587638*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.499600589590599*^9, {3.499600654562523*^9, 3.4996006662132063`*^9}, 
   3.4996647320023203`*^9, 3.499664809869158*^9, 3.499665423953055*^9, 
   3.499666927140604*^9, 3.500187295333789*^9, 3.5001877245136967`*^9, 
   3.500385582328672*^9, 3.5006171283874817`*^9, 3.500617337208673*^9, 
   3.5006173955899076`*^9, 3.5006180272919273`*^9, {3.500618090755332*^9, 
   3.500618100419582*^9}, 3.5006183273770437`*^9, 3.5006185525869417`*^9, 
   3.500619309117373*^9, 3.500620038495502*^9, 3.5006276112185087`*^9, 
   3.5007185546686687`*^9, 3.500719092213472*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M4", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Normal", "[", 
       RowBox[{"Series", "[", 
        RowBox[{"M3", ",", 
         RowBox[{"{", 
          RowBox[{"Linv", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}], "//.", 
      
      RowBox[{"Abbr", "[", "]"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Den", "[", 
        RowBox[{"a_", ",", "b_"}], "]"}], "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"a", "-", "b"}], ")"}]}]}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{"U", "\[Rule]", 
      RowBox[{"MT2", "+", "MW2", "+", "MB2", "-", "S", "-", "T"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.4996648609705343`*^9, 3.49966486381705*^9}, {
  3.499664897114004*^9, 3.4996649050225286`*^9}, {3.4996649968834343`*^9, 
  3.4996650162489157`*^9}, {3.500187384138556*^9, 3.500187385860238*^9}, {
  3.5001874741497707`*^9, 3.500187475289146*^9}, {3.5003856142464657`*^9, 
  3.500385660569497*^9}, {3.5003856940596933`*^9, 3.50038571227074*^9}, {
  3.50038580404515*^9, 3.500385805944021*^9}, {3.500617355905836*^9, 
  3.5006173850556173`*^9}, {3.500618104014385*^9, 3.500618138789729*^9}, {
  3.500619354866448*^9, 3.500619394664554*^9}, {3.500620119494914*^9, 
  3.5006201203887033`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"MW2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"MB2", "-", "S"}], ")"}], "2"], " ", 
      SuperscriptBox["sw", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"MT2", "-", "T"}], ")"}], "2"]}]], 
    RowBox[{"16", " ", "Alfa", " ", "CKM33", " ", "\[Pi]", " ", 
     SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SqrtBox["2"], " ", "GS", " ", "MT", " ", 
        RowBox[{"(", 
         RowBox[{"MB2", "-", "S"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"MT2", "-", "T"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["MB2", "3"], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"MT2", "+", "MW2", "-", "S", "-", "T"}], ")"}], " ", 
           SuperscriptBox["MB2", "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["MT2", "2"], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"MW2", "+", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{"S", "+", "T"}], ")"}]}]}], ")"}], " ", "MT2"}], 
             "+", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}], "2"], "+", 
             RowBox[{"MW2", " ", 
              RowBox[{"(", 
               RowBox[{"T", "-", 
                RowBox[{"4", " ", "S"}]}], ")"}]}]}], ")"}], " ", "MB2"}], 
          "+", 
          RowBox[{"MW2", " ", "S", " ", 
           RowBox[{"(", 
            RowBox[{"MT2", "+", 
             RowBox[{"2", " ", "S"}], "-", "T"}], ")"}]}]}], ")"}], " ", "v", 
        " ", 
        RowBox[{"Re", "(", "CtG", ")"}], " ", 
        SuperscriptBox["Linv", "2"]}], "+", 
       RowBox[{"Alfas", " ", "\[Pi]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", "MT2"}], "-", "T"}], ")"}], " ", 
           SuperscriptBox["MB2", "4"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["MT2", "2"], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "MW2"}], "-", 
                RowBox[{"5", " ", "S"}], "-", 
                RowBox[{"7", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
             RowBox[{"T", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", 
                RowBox[{"2", " ", "T"}]}], ")"}]}]}], ")"}], " ", 
           SuperscriptBox["MB2", "3"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["MT2", "3"], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"8", " ", "MW2"}], "-", 
                RowBox[{"3", " ", 
                 RowBox[{"(", 
                  RowBox[{"S", "+", "T"}], ")"}]}]}], ")"}], " ", 
              SuperscriptBox["MT2", "2"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "6"}], " ", 
                 SuperscriptBox["MW2", "2"]}], "-", 
                RowBox[{"6", " ", 
                 RowBox[{"(", 
                  RowBox[{"S", "+", "T"}], ")"}], " ", "MW2"}], "+", 
                RowBox[{"3", " ", 
                 SuperscriptBox["S", "2"]}], "+", 
                RowBox[{"5", " ", 
                 SuperscriptBox["T", "2"]}], "+", 
                RowBox[{"13", " ", "S", " ", "T"}]}], ")"}], " ", "MT2"}], 
             "-", 
             RowBox[{"T", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", 
                 SuperscriptBox["MW2", "2"]}], "-", 
                RowBox[{"2", " ", "S", " ", "MW2"}], "+", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"S", "+", "T"}], ")"}], "2"]}], ")"}]}]}], ")"}], 
           " ", 
           SuperscriptBox["MB2", "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["MT2", "4"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "MW2"}], "-", 
                RowBox[{"7", " ", "S"}], "-", 
                RowBox[{"5", " ", "T"}]}], ")"}], " ", 
              SuperscriptBox["MT2", "3"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "6"}], " ", 
                 SuperscriptBox["MW2", "2"]}], "-", 
                RowBox[{"6", " ", 
                 RowBox[{"(", 
                  RowBox[{"S", "+", "T"}], ")"}], " ", "MW2"}], "+", 
                RowBox[{"5", " ", 
                 SuperscriptBox["S", "2"]}], "+", 
                RowBox[{"3", " ", 
                 SuperscriptBox["T", "2"]}], "+", 
                RowBox[{"13", " ", "S", " ", "T"}]}], ")"}], " ", 
              SuperscriptBox["MT2", "2"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", 
                 SuperscriptBox["MW2", "3"]}], "+", 
                RowBox[{"6", " ", 
                 RowBox[{"(", 
                  RowBox[{"S", "+", "T"}], ")"}], " ", 
                 SuperscriptBox["MW2", "2"]}], "+", 
                RowBox[{"6", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["S", "2"], "+", 
                   SuperscriptBox["T", "2"]}], ")"}], " ", "MW2"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"S", "+", "T"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["S", "2"], "+", 
                   RowBox[{"10", " ", "T", " ", "S"}], "+", 
                   SuperscriptBox["T", "2"]}], ")"}]}]}], ")"}], " ", "MT2"}],
              "+", 
             RowBox[{"T", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "4"}], " ", 
                 SuperscriptBox["MW2", "3"]}], "+", 
                RowBox[{"2", " ", "S", " ", 
                 SuperscriptBox["MW2", "2"]}], "-", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", 
                    SuperscriptBox["S", "2"]}], "-", 
                   RowBox[{"T", " ", "S"}], "+", 
                   SuperscriptBox["T", "2"]}], ")"}], " ", "MW2"}], "+", 
                RowBox[{"S", " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"S", "+", "T"}], ")"}], "2"]}]}], ")"}]}]}], ")"}],
            " ", "MB2"}], "+", 
          RowBox[{"S", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["MT2", "4"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "S"}], "+", "T"}], ")"}], " ", 
              SuperscriptBox["MT2", "3"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 SuperscriptBox["MW2", "2"]}], "+", 
                RowBox[{"2", " ", "T", " ", "MW2"}], "-", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"S", "+", "T"}], ")"}], "2"]}], ")"}], " ", 
              SuperscriptBox["MT2", "2"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "4"}], " ", 
                 SuperscriptBox["MW2", "3"]}], "+", 
                RowBox[{"2", " ", "T", " ", 
                 SuperscriptBox["MW2", "2"]}], "-", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["S", "2"], "-", 
                   RowBox[{"T", " ", "S"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["T", "2"]}]}], ")"}], " ", "MW2"}], "+", 
                RowBox[{"T", " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"S", "+", "T"}], ")"}], "2"]}]}], ")"}], " ", 
              "MT2"}], "+", 
             RowBox[{"2", " ", "MW2", " ", "T", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 SuperscriptBox["MW2", "2"]}], "-", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{"S", "+", "T"}], ")"}], " ", "MW2"}], "+", 
                SuperscriptBox["S", "2"], "+", 
                SuperscriptBox["T", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
      ")"}]}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.500619397528989*^9, 3.500620045018338*^9, 
  3.500620139625103*^9, 3.50062763345022*^9, 3.5007185619835873`*^9, 
  3.500719111789125*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"M5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"2", "*", 
      RowBox[{
       RowBox[{
        RowBox[{"M4", "/", "8"}], "/", "2"}], "/", "3"}]}], "/.", 
     RowBox[{"MB2", "\[Rule]", "0"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.500619408652945*^9, 3.500619444131513*^9}, {
  3.500620186564165*^9, 3.50062022207979*^9}}],

Cell[CellGroupData[{

Cell[BoxData["M5"], "Input",
 CellChangeTimes->{{3.5006194476506643`*^9, 3.5006194497548857`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"3", " ", "MW2", " ", "S", " ", 
     SuperscriptBox["sw", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"MT2", "-", "T"}], ")"}], "2"]}]], 
   RowBox[{"2", " ", "Alfa", " ", "CKM33", " ", "\[Pi]", " ", 
    SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SqrtBox["2"], " ", "GS", " ", "MT", " ", "MW2", " ", "S", " ", 
       RowBox[{"(", 
        RowBox[{"MT2", "-", "T"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"MT2", "+", 
         RowBox[{"2", " ", "S"}], "-", "T"}], ")"}], " ", "v", " ", 
       RowBox[{"Re", "(", "CtG", ")"}], " ", 
       SuperscriptBox["Linv", "2"]}], "+", 
      RowBox[{"Alfas", " ", "\[Pi]", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["MT2", "4"], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "S"}], "+", "T"}], ")"}], " ", 
          SuperscriptBox["MT2", "3"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["MW2", "2"]}], "-", 
            RowBox[{"2", " ", "T", " ", "MW2"}], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}], "2"]}], ")"}], " ", 
          SuperscriptBox["MT2", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["MW2", "3"]}], "-", 
            RowBox[{"2", " ", "T", " ", 
             SuperscriptBox["MW2", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["S", "2"], "-", 
               RowBox[{"T", " ", "S"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["T", "2"]}]}], ")"}], " ", "MW2"}], "-", 
            RowBox[{"T", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}], "2"]}]}], ")"}], " ", "MT2"}], 
         "-", 
         RowBox[{"2", " ", "MW2", " ", "T", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["MW2", "2"]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}], " ", "MW2"}], "+", 
            SuperscriptBox["S", "2"], "+", 
            SuperscriptBox["T", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.5006194501200047`*^9, 3.5006200855107203`*^9, 
  3.500620149404791*^9, 3.500620225331334*^9, 3.5006276344674587`*^9, 
  3.500718562964075*^9, 3.5007191251541843`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{"M5", ",", "Linv", ",", "2"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Alfas", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"gS", "^", "2"}], "/", "4"}], "/", "\[Pi]"}], ")"}]}], ",", 
     RowBox[{"Alfa", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"gw", "^", "2"}], "/", "4"}], "/", "\[Pi]"}], "*", 
        RowBox[{"sw", "^", "2"}]}], ")"}]}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.500619459070675*^9, 3.500619488358326*^9}, 
   3.500620475539863*^9}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"CKM33", " ", "GS", " ", 
    SuperscriptBox["gw", "2"], " ", "MT", " ", 
    RowBox[{"(", 
     RowBox[{"MT2", "+", 
      RowBox[{"2", " ", "S"}], "-", "T"}], ")"}], " ", "v", " ", 
    SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
    RowBox[{"Re", "(", "CtG", ")"}]}], 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    RowBox[{"(", 
     RowBox[{"MT2", "-", "T"}], ")"}]}]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.500619477651209*^9, 3.50061948909485*^9}, 
   3.500620152398573*^9, 3.500620228585659*^9, 3.500620476249527*^9, 
   3.500627640375634*^9, 3.500718567848819*^9, 3.500719128206544*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{"M5", ",", "Linv", ",", "0"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Alfas", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"gS", "^", "2"}], "/", "4"}], "/", "\[Pi]"}], ")"}]}], ",", 
     RowBox[{"Alfa", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"gw", "^", "2"}], "/", "4"}], "/", "\[Pi]"}], "*", 
        RowBox[{"sw", "^", "2"}]}], ")"}]}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.500619500185069*^9, {3.5006197010843678`*^9, 3.500619785186995*^9}, {
   3.500619828187114*^9, 3.5006198610219193`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"24", " ", "MW2", " ", "S", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"MT2", "-", "T"}], ")"}], "2"]}]], 
   RowBox[{"CKM33", " ", 
    SuperscriptBox["gS", "2"], " ", 
    SuperscriptBox["gw", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["MT2", "4"], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "S"}], "+", "T"}], ")"}], " ", 
       SuperscriptBox["MT2", "3"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["MW2", "2"]}], "-", 
         RowBox[{"2", " ", "T", " ", "MW2"}], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"S", "+", "T"}], ")"}], "2"]}], ")"}], " ", 
       SuperscriptBox["MT2", "2"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["MW2", "3"]}], "-", 
         RowBox[{"2", " ", "T", " ", 
          SuperscriptBox["MW2", "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["S", "2"], "-", 
            RowBox[{"T", " ", "S"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["T", "2"]}]}], ")"}], " ", "MW2"}], "-", 
         RowBox[{"T", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"S", "+", "T"}], ")"}], "2"]}]}], ")"}], " ", "MT2"}], 
      "-", 
      RowBox[{"2", " ", "MW2", " ", "T", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["MW2", "2"]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"S", "+", "T"}], ")"}], " ", "MW2"}], "+", 
         SuperscriptBox["S", "2"], "+", 
         SuperscriptBox["T", "2"]}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox["CKM33", "\[Conjugate]"]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.500619500548152*^9, {3.500619775655306*^9, 3.500619785860127*^9}, 
   3.500619862900193*^9, 3.500620155066042*^9, 3.5006202308318977`*^9, 
   3.5006276413570843`*^9, 3.500718605297653*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CtW", "Section",
 CellChangeTimes->{{3.5006274944509287`*^9, 3.500627498658805*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"M2", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"SquaredME", "[", "M", "]"}], "/.", "col"}], "/.", "hel"}], "/.",
       "M$FACouplings"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Conjugate", "[", "Lambda", "]"}], "\[Rule]", 
        RowBox[{"1", "/", "Linv"}]}], ",", 
       RowBox[{"Lambda", "\[Rule]", 
        RowBox[{"1", "/", "Linv"}]}]}], "}"}]}], "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Linv", "^", "4"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"Linv", "^", "6"}], "\[Rule]", "0"}], ",", 
      RowBox[{"CtG", "\[Rule]", "0"}], ",", 
      RowBox[{"C3phiq", "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"Conjugate", "[", "v", "]"}], "\[Rule]", "v"}], ",", 
      RowBox[{
       RowBox[{"Conjugate", "[", "sw", "]"}], "\[Rule]", "sw"}]}], "}"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.499600531002454*^9, 3.4996005524542828`*^9}, {
   3.499600635515656*^9, 3.499600641632725*^9}, 3.499664804800191*^9, 
   3.499665470133533*^9, {3.499665526806489*^9, 3.499665533691248*^9}, {
   3.499666501659967*^9, 3.499666513416099*^9}, {3.500187709292647*^9, 
   3.500187712600173*^9}, 3.500385558768992*^9, 3.500617380485931*^9, {
   3.5006183149253798`*^9, 3.5006183179069633`*^9}, {3.5006184825135202`*^9, 
   3.500618538907811*^9}, {3.5006189819188757`*^9, 3.500618986819117*^9}, 
   3.5006190655537767`*^9, {3.500619108945569*^9, 3.500619160312779*^9}, {
   3.5006192176593237`*^9, 3.500619270466074*^9}, {3.5006206564134502`*^9, 
   3.500620658185376*^9}, {3.5006208996006527`*^9, 3.5006209088479643`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"M3", "=", 
   RowBox[{"PolarizationSum", "[", "M2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.49966507338302*^9, {3.499665479244595*^9, 3.499665508978133*^9}, {
   3.499666915703204*^9, 3.499666925813794*^9}, {3.500618089746357*^9, 
   3.500618099391782*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.499600589590599*^9, {3.499600654562523*^9, 3.4996006662132063`*^9}, 
   3.4996647320023203`*^9, 3.499664809869158*^9, 3.499665423953055*^9, 
   3.499666927140604*^9, 3.500187295333789*^9, 3.5001877245136967`*^9, 
   3.500385582328672*^9, 3.5006171283874817`*^9, 3.500617337208673*^9, 
   3.5006173955899076`*^9, 3.5006180272919273`*^9, {3.500618090755332*^9, 
   3.500618100419582*^9}, 3.5006183273770437`*^9, 3.5006185525869417`*^9, 
   3.500619309117373*^9, 3.500620038495502*^9, 3.500620672921929*^9, 
   3.500620927911113*^9, 3.50062765944853*^9, 3.500718630460891*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-7.0/fc4.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-7.0/fc4.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.499600589590599*^9, {3.499600654562523*^9, 3.4996006662132063`*^9}, 
   3.4996647320023203`*^9, 3.499664809869158*^9, 3.499665423953055*^9, 
   3.499666927140604*^9, 3.500187295333789*^9, 3.5001877245136967`*^9, 
   3.500385582328672*^9, 3.5006171283874817`*^9, 3.500617337208673*^9, 
   3.5006173955899076`*^9, 3.5006180272919273`*^9, {3.500618090755332*^9, 
   3.500618100419582*^9}, 3.5006183273770437`*^9, 3.5006185525869417`*^9, 
   3.500619309117373*^9, 3.500620038495502*^9, 3.500620672921929*^9, 
   3.500620927911113*^9, 3.50062765944853*^9, 3.500718630477837*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{
  3.499600589590599*^9, {3.499600654562523*^9, 3.4996006662132063`*^9}, 
   3.4996647320023203`*^9, 3.499664809869158*^9, 3.499665423953055*^9, 
   3.499666927140604*^9, 3.500187295333789*^9, 3.5001877245136967`*^9, 
   3.500385582328672*^9, 3.5006171283874817`*^9, 3.500617337208673*^9, 
   3.5006173955899076`*^9, 3.5006180272919273`*^9, {3.500618090755332*^9, 
   3.500618100419582*^9}, 3.5006183273770437`*^9, 3.5006185525869417`*^9, 
   3.500619309117373*^9, 3.500620038495502*^9, 3.500620672921929*^9, 
   3.500620927911113*^9, 3.50062765944853*^9, 3.500718630877677*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.499600589590599*^9, {3.499600654562523*^9, 3.4996006662132063`*^9}, 
   3.4996647320023203`*^9, 3.499664809869158*^9, 3.499665423953055*^9, 
   3.499666927140604*^9, 3.500187295333789*^9, 3.5001877245136967`*^9, 
   3.500385582328672*^9, 3.5006171283874817`*^9, 3.500617337208673*^9, 
   3.5006173955899076`*^9, 3.5006180272919273`*^9, {3.500618090755332*^9, 
   3.500618100419582*^9}, 3.5006183273770437`*^9, 3.5006185525869417`*^9, 
   3.500619309117373*^9, 3.500620038495502*^9, 3.500620672921929*^9, 
   3.500620927911113*^9, 3.50062765944853*^9, 3.500718636296775*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M4", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Normal", "[", 
       RowBox[{"Series", "[", 
        RowBox[{"M3", ",", 
         RowBox[{"{", 
          RowBox[{"Linv", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}], "//.", 
      
      RowBox[{"Abbr", "[", "]"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Den", "[", 
        RowBox[{"a_", ",", "b_"}], "]"}], "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"a", "-", "b"}], ")"}]}]}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{"U", "\[Rule]", 
      RowBox[{"MT2", "+", "MW2", "+", "MB2", "-", "S", "-", "T"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.4996648609705343`*^9, 3.49966486381705*^9}, {
  3.499664897114004*^9, 3.4996649050225286`*^9}, {3.4996649968834343`*^9, 
  3.4996650162489157`*^9}, {3.500187384138556*^9, 3.500187385860238*^9}, {
  3.5001874741497707`*^9, 3.500187475289146*^9}, {3.5003856142464657`*^9, 
  3.500385660569497*^9}, {3.5003856940596933`*^9, 3.50038571227074*^9}, {
  3.50038580404515*^9, 3.500385805944021*^9}, {3.500617355905836*^9, 
  3.5006173850556173`*^9}, {3.500618104014385*^9, 3.500618138789729*^9}, {
  3.500619354866448*^9, 3.500619394664554*^9}, {3.500620119494914*^9, 
  3.5006201203887033`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"MW2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"MB2", "-", "S"}], ")"}], "2"], " ", 
      SuperscriptBox["sw", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"MT2", "-", "T"}], ")"}], "2"]}]], 
    RowBox[{"8", " ", "Alfas", " ", "\[Pi]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SqrtBox["2"], " ", "CKM33", " ", "CtW", " ", "EL", " ", "MT", " ", 
        "MW2", " ", "sw", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"T", "-", 
             RowBox[{"7", " ", "MT2"}]}], ")"}], " ", 
           SuperscriptBox["MB2", "3"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["MT2", "2"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"9", " ", "S"}], "+", 
                RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
             RowBox[{"T", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "6"}], " ", "MW2"}], "+", 
                RowBox[{"3", " ", "S"}], "+", 
                RowBox[{"2", " ", "T"}]}], ")"}]}]}], ")"}], " ", 
           SuperscriptBox["MB2", "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"9", " ", 
              SuperscriptBox["MT2", "3"]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"12", " ", "MW2"}], "+", 
                RowBox[{"10", " ", "S"}], "+", 
                RowBox[{"15", " ", "T"}]}], ")"}], " ", 
              SuperscriptBox["MT2", "2"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"6", " ", 
                 SuperscriptBox["MW2", "2"]}], "+", 
                RowBox[{"12", " ", "T", " ", "MW2"}], "-", 
                RowBox[{"3", " ", 
                 SuperscriptBox["S", "2"]}], "+", 
                RowBox[{"9", " ", 
                 SuperscriptBox["T", "2"]}], "+", 
                RowBox[{"8", " ", "S", " ", "T"}]}], ")"}], " ", "MT2"}], "-",
              
             RowBox[{"T", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"6", " ", 
                 SuperscriptBox["MW2", "2"]}], "-", 
                RowBox[{"12", " ", "S", " ", "MW2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "S"}], "+", "T"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"S", "+", 
                   RowBox[{"3", " ", "T"}]}], ")"}]}]}], ")"}]}]}], ")"}], 
           " ", "MB2"}], "+", 
          RowBox[{"S", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", 
              SuperscriptBox["MT2", "3"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"6", " ", "MW2"}], "+", 
                RowBox[{"2", " ", "S"}], "+", 
                RowBox[{"3", " ", "T"}]}], ")"}], " ", 
              SuperscriptBox["MT2", "2"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"S", "-", "T"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"S", "+", 
                   RowBox[{"3", " ", "T"}]}], ")"}]}], "-", 
                RowBox[{"6", " ", 
                 SuperscriptBox["MW2", "2"]}]}], ")"}], " ", "MT2"}], "+", 
             RowBox[{"T", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"6", " ", 
                 SuperscriptBox["MW2", "2"]}], "-", 
                RowBox[{"6", " ", 
                 RowBox[{"(", 
                  RowBox[{"S", "+", "T"}], ")"}], " ", "MW2"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"S", "-", 
                   RowBox[{"3", " ", "T"}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"S", "+", "T"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
         ")"}], " ", "v", " ", 
        SuperscriptBox["Linv", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SqrtBox["2"], " ", "EL", " ", "MT", " ", "MW2", " ", "sw", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"T", "-", 
                RowBox[{"7", " ", "MT2"}]}], ")"}], " ", 
              SuperscriptBox["MB2", "3"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 SuperscriptBox["MT2", "2"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"9", " ", "S"}], "+", 
                   RowBox[{"2", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
                RowBox[{"T", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "6"}], " ", "MW2"}], "+", 
                   RowBox[{"3", " ", "S"}], "+", 
                   RowBox[{"2", " ", "T"}]}], ")"}]}]}], ")"}], " ", 
              SuperscriptBox["MB2", "2"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"9", " ", 
                 SuperscriptBox["MT2", "3"]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"12", " ", "MW2"}], "+", 
                   RowBox[{"10", " ", "S"}], "+", 
                   RowBox[{"15", " ", "T"}]}], ")"}], " ", 
                 SuperscriptBox["MT2", "2"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"6", " ", 
                    SuperscriptBox["MW2", "2"]}], "+", 
                   RowBox[{"12", " ", "T", " ", "MW2"}], "-", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["S", "2"]}], "+", 
                   RowBox[{"9", " ", 
                    SuperscriptBox["T", "2"]}], "+", 
                   RowBox[{"8", " ", "S", " ", "T"}]}], ")"}], " ", "MT2"}], 
                "-", 
                RowBox[{"T", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"6", " ", 
                    SuperscriptBox["MW2", "2"]}], "-", 
                   RowBox[{"12", " ", "S", " ", "MW2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"3", " ", "S"}], "+", "T"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"S", "+", 
                    RowBox[{"3", " ", "T"}]}], ")"}]}]}], ")"}]}]}], ")"}], 
              " ", "MB2"}], "+", 
             RowBox[{"S", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], " ", 
                 SuperscriptBox["MT2", "3"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"6", " ", "MW2"}], "+", 
                   RowBox[{"2", " ", "S"}], "+", 
                   RowBox[{"3", " ", "T"}]}], ")"}], " ", 
                 SuperscriptBox["MT2", "2"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"S", "-", "T"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"S", "+", 
                    RowBox[{"3", " ", "T"}]}], ")"}]}], "-", 
                   RowBox[{"6", " ", 
                    SuperscriptBox["MW2", "2"]}]}], ")"}], " ", "MT2"}], "+", 
                
                RowBox[{"T", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"6", " ", 
                    SuperscriptBox["MW2", "2"]}], "-", 
                   RowBox[{"6", " ", 
                    RowBox[{"(", 
                    RowBox[{"S", "+", "T"}], ")"}], " ", "MW2"}], "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"S", "-", 
                    RowBox[{"3", " ", "T"}]}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"S", "+", "T"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
            ")"}], " ", "v", " ", 
           SuperscriptBox["CtW", "\[Conjugate]"], " ", 
           SuperscriptBox["Linv", "2"]}], "+", 
          RowBox[{"2", " ", "Alfa", " ", "CKM33", " ", "\[Pi]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"3", " ", "MT2"}], "-", "T"}], ")"}], " ", 
              SuperscriptBox["MB2", "4"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["MT2", "2"], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "MW2"}], "-", 
                   RowBox[{"5", " ", "S"}], "-", 
                   RowBox[{"7", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
                RowBox[{"T", " ", 
                 RowBox[{"(", 
                  RowBox[{"S", "+", 
                   RowBox[{"2", " ", "T"}]}], ")"}]}]}], ")"}], " ", 
              SuperscriptBox["MB2", "3"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["MT2", "3"], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"8", " ", "MW2"}], "-", 
                   RowBox[{"3", " ", 
                    RowBox[{"(", 
                    RowBox[{"S", "+", "T"}], ")"}]}]}], ")"}], " ", 
                 SuperscriptBox["MT2", "2"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "6"}], " ", 
                    SuperscriptBox["MW2", "2"]}], "-", 
                   RowBox[{"6", " ", 
                    RowBox[{"(", 
                    RowBox[{"S", "+", "T"}], ")"}], " ", "MW2"}], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["S", "2"]}], "+", 
                   RowBox[{"5", " ", 
                    SuperscriptBox["T", "2"]}], "+", 
                   RowBox[{"13", " ", "S", " ", "T"}]}], ")"}], " ", "MT2"}], 
                "-", 
                RowBox[{"T", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["MW2", "2"]}], "-", 
                   RowBox[{"2", " ", "S", " ", "MW2"}], "+", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"S", "+", "T"}], ")"}], "2"]}], ")"}]}]}], ")"}], 
              " ", 
              SuperscriptBox["MB2", "2"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"3", " ", 
                 SuperscriptBox["MT2", "4"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "MW2"}], "-", 
                   RowBox[{"7", " ", "S"}], "-", 
                   RowBox[{"5", " ", "T"}]}], ")"}], " ", 
                 SuperscriptBox["MT2", "3"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "6"}], " ", 
                    SuperscriptBox["MW2", "2"]}], "-", 
                   RowBox[{"6", " ", 
                    RowBox[{"(", 
                    RowBox[{"S", "+", "T"}], ")"}], " ", "MW2"}], "+", 
                   RowBox[{"5", " ", 
                    SuperscriptBox["S", "2"]}], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["T", "2"]}], "+", 
                   RowBox[{"13", " ", "S", " ", "T"}]}], ")"}], " ", 
                 SuperscriptBox["MT2", "2"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"4", " ", 
                    SuperscriptBox["MW2", "3"]}], "+", 
                   RowBox[{"6", " ", 
                    RowBox[{"(", 
                    RowBox[{"S", "+", "T"}], ")"}], " ", 
                    SuperscriptBox["MW2", "2"]}], "+", 
                   RowBox[{"6", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["S", "2"], "+", 
                    SuperscriptBox["T", "2"]}], ")"}], " ", "MW2"}], "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"S", "+", "T"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["S", "2"], "+", 
                    RowBox[{"10", " ", "T", " ", "S"}], "+", 
                    SuperscriptBox["T", "2"]}], ")"}]}]}], ")"}], " ", 
                 "MT2"}], "+", 
                RowBox[{"T", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "4"}], " ", 
                    SuperscriptBox["MW2", "3"]}], "+", 
                   RowBox[{"2", " ", "S", " ", 
                    SuperscriptBox["MW2", "2"]}], "-", 
                   RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["S", "2"]}], "-", 
                    RowBox[{"T", " ", "S"}], "+", 
                    SuperscriptBox["T", "2"]}], ")"}], " ", "MW2"}], "+", 
                   RowBox[{"S", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"S", "+", "T"}], ")"}], "2"]}]}], ")"}]}]}], 
               ")"}], " ", "MB2"}], "+", 
             RowBox[{"S", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["MT2", "4"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "S"}], "+", "T"}], ")"}], " ", 
                 SuperscriptBox["MT2", "3"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", 
                    SuperscriptBox["MW2", "2"]}], "+", 
                   RowBox[{"2", " ", "T", " ", "MW2"}], "-", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"S", "+", "T"}], ")"}], "2"]}], ")"}], " ", 
                 SuperscriptBox["MT2", "2"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "4"}], " ", 
                    SuperscriptBox["MW2", "3"]}], "+", 
                   RowBox[{"2", " ", "T", " ", 
                    SuperscriptBox["MW2", "2"]}], "-", 
                   RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["S", "2"], "-", 
                    RowBox[{"T", " ", "S"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["T", "2"]}]}], ")"}], " ", "MW2"}], "+", 
                   RowBox[{"T", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"S", "+", "T"}], ")"}], "2"]}]}], ")"}], " ", 
                 "MT2"}], "+", 
                RowBox[{"2", " ", "MW2", " ", "T", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", 
                    SuperscriptBox["MW2", "2"]}], "-", 
                   RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"S", "+", "T"}], ")"}], " ", "MW2"}], "+", 
                   SuperscriptBox["S", "2"], "+", 
                   SuperscriptBox["T", "2"]}], ")"}]}]}], ")"}]}]}], 
            ")"}]}]}], ")"}]}]}], ")"}]}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.500619397528989*^9, 3.500620045018338*^9, 
  3.500620139625103*^9, 3.50062070430739*^9, 3.500620958310176*^9, 
  3.5006276891287193`*^9, 3.500718661692122*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"M5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"2", "*", 
      RowBox[{
       RowBox[{
        RowBox[{"M4", "/", "8"}], "/", "2"}], "/", "3"}]}], "/.", 
     RowBox[{"MB2", "\[Rule]", "0"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.500619408652945*^9, 3.500619444131513*^9}, {
  3.500620186564165*^9, 3.50062022207979*^9}}],

Cell[CellGroupData[{

Cell[BoxData["M5"], "Input",
 CellChangeTimes->{{3.5006194476506643`*^9, 3.5006194497548857`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"3", " ", "MW2", " ", 
      SuperscriptBox["S", "2"], " ", 
      SuperscriptBox["sw", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"MT2", "-", "T"}], ")"}], "2"]}]], 
    RowBox[{"Alfas", " ", "\[Pi]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SqrtBox["2"], " ", "CKM33", " ", "CtW", " ", "EL", " ", "MT", " ", 
        "MW2", " ", "S", " ", "sw", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["MT2", "3"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"6", " ", "MW2"}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}], ")"}], " ", 
           SuperscriptBox["MT2", "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"S", "-", "T"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", 
                RowBox[{"3", " ", "T"}]}], ")"}]}], "-", 
             RowBox[{"6", " ", 
              SuperscriptBox["MW2", "2"]}]}], ")"}], " ", "MT2"}], "+", 
          RowBox[{"T", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"6", " ", 
              SuperscriptBox["MW2", "2"]}], "-", 
             RowBox[{"6", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}], " ", "MW2"}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"S", "-", 
                RowBox[{"3", " ", "T"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}], ")"}]}]}], ")"}], " ", "v",
         " ", 
        SuperscriptBox["Linv", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["CKM33", "\[Conjugate]"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SqrtBox["2"], " ", "EL", " ", "MT", " ", "MW2", " ", "S", " ", 
           "sw", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", 
              SuperscriptBox["MT2", "3"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"6", " ", "MW2"}], "+", 
                RowBox[{"2", " ", "S"}], "+", 
                RowBox[{"3", " ", "T"}]}], ")"}], " ", 
              SuperscriptBox["MT2", "2"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"S", "-", "T"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"S", "+", 
                   RowBox[{"3", " ", "T"}]}], ")"}]}], "-", 
                RowBox[{"6", " ", 
                 SuperscriptBox["MW2", "2"]}]}], ")"}], " ", "MT2"}], "+", 
             RowBox[{"T", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"6", " ", 
                 SuperscriptBox["MW2", "2"]}], "-", 
                RowBox[{"6", " ", 
                 RowBox[{"(", 
                  RowBox[{"S", "+", "T"}], ")"}], " ", "MW2"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"S", "-", 
                   RowBox[{"3", " ", "T"}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"S", "+", "T"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           "v", " ", 
           SuperscriptBox["CtW", "\[Conjugate]"], " ", 
           SuperscriptBox["Linv", "2"]}], "+", 
          RowBox[{
          "2", " ", "Alfa", " ", "CKM33", " ", "\[Pi]", " ", "S", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["MT2", "4"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "S"}], "+", "T"}], ")"}], " ", 
              SuperscriptBox["MT2", "3"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 SuperscriptBox["MW2", "2"]}], "+", 
                RowBox[{"2", " ", "T", " ", "MW2"}], "-", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"S", "+", "T"}], ")"}], "2"]}], ")"}], " ", 
              SuperscriptBox["MT2", "2"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "4"}], " ", 
                 SuperscriptBox["MW2", "3"]}], "+", 
                RowBox[{"2", " ", "T", " ", 
                 SuperscriptBox["MW2", "2"]}], "-", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["S", "2"], "-", 
                   RowBox[{"T", " ", "S"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["T", "2"]}]}], ")"}], " ", "MW2"}], "+", 
                RowBox[{"T", " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"S", "+", "T"}], ")"}], "2"]}]}], ")"}], " ", 
              "MT2"}], "+", 
             RowBox[{"2", " ", "MW2", " ", "T", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 SuperscriptBox["MW2", "2"]}], "-", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{"S", "+", "T"}], ")"}], " ", "MW2"}], "+", 
                SuperscriptBox["S", "2"], "+", 
                SuperscriptBox["T", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
      ")"}]}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.5006194501200047`*^9, 3.5006200855107203`*^9, 
  3.500620149404791*^9, 3.500620225331334*^9, 3.5006207051194983`*^9, 
  3.500620959722974*^9, 3.500627690119762*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Coefficient", "[", 
     RowBox[{"M5", ",", "Linv", ",", "2"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Alfas", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"gS", "^", "2"}], "/", "4"}], "/", "\[Pi]"}], ")"}]}], ",", 
      
      RowBox[{"Alfa", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"gw", "^", "2"}], "/", "4"}], "/", "\[Pi]"}], "*", 
         RowBox[{"sw", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"v", "\[Rule]", 
       RowBox[{"2", "*", "sw", "*", 
        RowBox[{"MW", "/", "EL"}]}]}]}], "}"}]}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"CKM33", "\[Element]", "Reals"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.500619459070675*^9, 3.500619488358326*^9}, 
   3.500620475539863*^9, {3.500627680877668*^9, 3.500627742378986*^9}, {
   3.500718673779214*^9, 3.500718712330826*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    SqrtBox["2"], " ", "CKM33", " ", 
    SuperscriptBox["gS", "2"], " ", "MT", " ", "MW", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["MT2", "3"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", "MW2"}], "+", 
         RowBox[{"2", " ", "S"}], "+", 
         RowBox[{"3", " ", "T"}]}], ")"}], " ", 
       SuperscriptBox["MT2", "2"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["MW2", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"S", "-", "T"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"S", "+", 
            RowBox[{"3", " ", "T"}]}], ")"}]}]}], ")"}], " ", "MT2"}], "+", 
      RowBox[{"T", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "6"}], " ", 
          SuperscriptBox["MW2", "2"]}], "+", 
         RowBox[{"6", " ", 
          RowBox[{"(", 
           RowBox[{"S", "+", "T"}], ")"}], " ", "MW2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"S", "-", 
            RowBox[{"3", " ", "T"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"S", "+", "T"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"Re", "(", "CtW", ")"}]}], 
   RowBox[{"3", " ", "S", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"MT2", "-", "T"}], ")"}], "2"]}]], TraditionalForm]], "Output",
 CellChangeTimes->{3.500627711568761*^9, 3.500627744389079*^9, 
  3.500718722641972*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["C3phiq", "Section",
 CellChangeTimes->{{3.5006275137192793`*^9, 3.5006275166533833`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"M2", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"SquaredME", "[", "M", "]"}], "/.", "col"}], "/.", "hel"}], "/.",
       "M$FACouplings"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Conjugate", "[", "Lambda", "]"}], "\[Rule]", 
        RowBox[{"1", "/", "Linv"}]}], ",", 
       RowBox[{"Lambda", "\[Rule]", 
        RowBox[{"1", "/", "Linv"}]}]}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Linv", "^", "4"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"Linv", "^", "6"}], "\[Rule]", "0"}], ",", 
      RowBox[{"CtG", "\[Rule]", "0"}], ",", 
      RowBox[{"CtW", "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"Conjugate", "[", "v", "]"}], "\[Rule]", "v"}], ",", 
      RowBox[{
       RowBox[{"Conjugate", "[", "sw", "]"}], "\[Rule]", "sw"}], ",", 
      RowBox[{
       RowBox[{"Conjugate", "[", "CKM33", "]"}], "\[Rule]", "CKM33"}]}], 
     "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.500622168785104*^9, 3.500622172111658*^9}, 
   3.500622329885127*^9, 3.5006226252333603`*^9, 3.500626903716991*^9, 
   3.500627404903899*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"M3", "=", 
   RowBox[{"PolarizationSum", "[", "M2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.49966507338302*^9, {3.499665479244595*^9, 3.499665508978133*^9}, {
   3.499666915703204*^9, 3.499666925813794*^9}, {3.500618089746357*^9, 
   3.500618099391782*^9}, {3.500626920284443*^9, 3.50062692049039*^9}, 
   3.5006277969133472`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.499600589590599*^9, {3.499600654562523*^9, 3.4996006662132063`*^9}, 
   3.4996647320023203`*^9, 3.499664809869158*^9, 3.499665423953055*^9, 
   3.499666927140604*^9, 3.500187295333789*^9, 3.5001877245136967`*^9, 
   3.500385582328672*^9, 3.5006171283874817`*^9, 3.500617337208673*^9, 
   3.5006173955899076`*^9, 3.5006180272919273`*^9, {3.500618090755332*^9, 
   3.500618100419582*^9}, 3.5006183273770437`*^9, 3.5006185525869417`*^9, 
   3.500619309117373*^9, 3.500620038495502*^9, 3.50062159324461*^9, 
   3.500621894402315*^9, 3.5006220490952044`*^9, 3.500622114713565*^9, 
   3.50062692166899*^9, {3.500627786753311*^9, 3.500627797639176*^9}, 
   3.5007187756723957`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-7.0/fc4.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-7.0/fc4.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.499600589590599*^9, {3.499600654562523*^9, 3.4996006662132063`*^9}, 
   3.4996647320023203`*^9, 3.499664809869158*^9, 3.499665423953055*^9, 
   3.499666927140604*^9, 3.500187295333789*^9, 3.5001877245136967`*^9, 
   3.500385582328672*^9, 3.5006171283874817`*^9, 3.500617337208673*^9, 
   3.5006173955899076`*^9, 3.5006180272919273`*^9, {3.500618090755332*^9, 
   3.500618100419582*^9}, 3.5006183273770437`*^9, 3.5006185525869417`*^9, 
   3.500619309117373*^9, 3.500620038495502*^9, 3.50062159324461*^9, 
   3.500621894402315*^9, 3.5006220490952044`*^9, 3.500622114713565*^9, 
   3.50062692166899*^9, {3.500627786753311*^9, 3.500627797639176*^9}, 
   3.500718775689188*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{
  3.499600589590599*^9, {3.499600654562523*^9, 3.4996006662132063`*^9}, 
   3.4996647320023203`*^9, 3.499664809869158*^9, 3.499665423953055*^9, 
   3.499666927140604*^9, 3.500187295333789*^9, 3.5001877245136967`*^9, 
   3.500385582328672*^9, 3.5006171283874817`*^9, 3.500617337208673*^9, 
   3.5006173955899076`*^9, 3.5006180272919273`*^9, {3.500618090755332*^9, 
   3.500618100419582*^9}, 3.5006183273770437`*^9, 3.5006185525869417`*^9, 
   3.500619309117373*^9, 3.500620038495502*^9, 3.50062159324461*^9, 
   3.500621894402315*^9, 3.5006220490952044`*^9, 3.500622114713565*^9, 
   3.50062692166899*^9, {3.500627786753311*^9, 3.500627797639176*^9}, 
   3.5007187759569387`*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.499600589590599*^9, {3.499600654562523*^9, 3.4996006662132063`*^9}, 
   3.4996647320023203`*^9, 3.499664809869158*^9, 3.499665423953055*^9, 
   3.499666927140604*^9, 3.500187295333789*^9, 3.5001877245136967`*^9, 
   3.500385582328672*^9, 3.5006171283874817`*^9, 3.500617337208673*^9, 
   3.5006173955899076`*^9, 3.5006180272919273`*^9, {3.500618090755332*^9, 
   3.500618100419582*^9}, 3.5006183273770437`*^9, 3.5006185525869417`*^9, 
   3.500619309117373*^9, 3.500620038495502*^9, 3.50062159324461*^9, 
   3.500621894402315*^9, 3.5006220490952044`*^9, 3.500622114713565*^9, 
   3.50062692166899*^9, {3.500627786753311*^9, 3.500627797639176*^9}, 
   3.500718776973324*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M4", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Normal", "[", 
       RowBox[{"Series", "[", 
        RowBox[{"M3", ",", 
         RowBox[{"{", 
          RowBox[{"Linv", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}], "//.", 
      
      RowBox[{"Abbr", "[", "]"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Den", "[", 
        RowBox[{"a_", ",", "b_"}], "]"}], "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"a", "-", "b"}], ")"}]}]}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{"U", "\[Rule]", 
      RowBox[{"MT2", "+", "MW2", "+", "MB2", "-", "S", "-", "T"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.4996648609705343`*^9, 3.49966486381705*^9}, {
  3.499664897114004*^9, 3.4996649050225286`*^9}, {3.4996649968834343`*^9, 
  3.4996650162489157`*^9}, {3.500187384138556*^9, 3.500187385860238*^9}, {
  3.5001874741497707`*^9, 3.500187475289146*^9}, {3.5003856142464657`*^9, 
  3.500385660569497*^9}, {3.5003856940596933`*^9, 3.50038571227074*^9}, {
  3.50038580404515*^9, 3.500385805944021*^9}, {3.500617355905836*^9, 
  3.5006173850556173`*^9}, {3.500618104014385*^9, 3.500618138789729*^9}, {
  3.500619354866448*^9, 3.500619394664554*^9}, {3.500620119494914*^9, 
  3.5006201203887033`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"MW2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"MB2", "-", "S"}], ")"}], "2"], " ", 
      SuperscriptBox["sw", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"MT2", "-", "T"}], ")"}], "2"]}]], 
    RowBox[{"16", " ", "Alfa", " ", "Alfas", " ", "CKM33", " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "MT2"}], "-", "T"}], ")"}], " ", 
        SuperscriptBox["MB2", "4"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["MT2", "2"], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "MW2"}], "-", 
             RowBox[{"5", " ", "S"}], "-", 
             RowBox[{"7", " ", "T"}]}], ")"}], " ", "MT2"}], "+", 
          RowBox[{"T", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", 
             RowBox[{"2", " ", "T"}]}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox["MB2", "3"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["MT2", "3"], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"8", " ", "MW2"}], "-", 
             RowBox[{"3", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}], ")"}], " ", 
           SuperscriptBox["MT2", "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "6"}], " ", 
              SuperscriptBox["MW2", "2"]}], "-", 
             RowBox[{"6", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}], " ", "MW2"}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["S", "2"]}], "+", 
             RowBox[{"5", " ", 
              SuperscriptBox["T", "2"]}], "+", 
             RowBox[{"13", " ", "S", " ", "T"}]}], ")"}], " ", "MT2"}], "-", 
          RowBox[{"T", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["MW2", "2"]}], "-", 
             RowBox[{"2", " ", "S", " ", "MW2"}], "+", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}], "2"]}], ")"}]}]}], ")"}], " ", 
        
        SuperscriptBox["MB2", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["MT2", "4"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "MW2"}], "-", 
             RowBox[{"7", " ", "S"}], "-", 
             RowBox[{"5", " ", "T"}]}], ")"}], " ", 
           SuperscriptBox["MT2", "3"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "6"}], " ", 
              SuperscriptBox["MW2", "2"]}], "-", 
             RowBox[{"6", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}], " ", "MW2"}], "+", 
             RowBox[{"5", " ", 
              SuperscriptBox["S", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["T", "2"]}], "+", 
             RowBox[{"13", " ", "S", " ", "T"}]}], ")"}], " ", 
           SuperscriptBox["MT2", "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SuperscriptBox["MW2", "3"]}], "+", 
             RowBox[{"6", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}], " ", 
              SuperscriptBox["MW2", "2"]}], "+", 
             RowBox[{"6", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["S", "2"], "+", 
                SuperscriptBox["T", "2"]}], ")"}], " ", "MW2"}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["S", "2"], "+", 
                RowBox[{"10", " ", "T", " ", "S"}], "+", 
                SuperscriptBox["T", "2"]}], ")"}]}]}], ")"}], " ", "MT2"}], 
          "+", 
          RowBox[{"T", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4"}], " ", 
              SuperscriptBox["MW2", "3"]}], "+", 
             RowBox[{"2", " ", "S", " ", 
              SuperscriptBox["MW2", "2"]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 SuperscriptBox["S", "2"]}], "-", 
                RowBox[{"T", " ", "S"}], "+", 
                SuperscriptBox["T", "2"]}], ")"}], " ", "MW2"}], "+", 
             RowBox[{"S", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"S", "+", "T"}], ")"}], "2"]}]}], ")"}]}]}], ")"}], 
        " ", "MB2"}], "+", 
       RowBox[{"S", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["MT2", "4"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "S"}], "+", "T"}], ")"}], " ", 
           SuperscriptBox["MT2", "3"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["MW2", "2"]}], "+", 
             RowBox[{"2", " ", "T", " ", "MW2"}], "-", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}], "2"]}], ")"}], " ", 
           SuperscriptBox["MT2", "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4"}], " ", 
              SuperscriptBox["MW2", "3"]}], "+", 
             RowBox[{"2", " ", "T", " ", 
              SuperscriptBox["MW2", "2"]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["S", "2"], "-", 
                RowBox[{"T", " ", "S"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["T", "2"]}]}], ")"}], " ", "MW2"}], "+", 
             RowBox[{"T", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"S", "+", "T"}], ")"}], "2"]}]}], ")"}], " ", "MT2"}],
           "+", 
          RowBox[{"2", " ", "MW2", " ", "T", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["MW2", "2"]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}], " ", "MW2"}], "+", 
             SuperscriptBox["S", "2"], "+", 
             SuperscriptBox["T", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["Linv", "2"], " ", 
        RowBox[{"Re", "(", "C3phiq", ")"}], " ", 
        SuperscriptBox["v", "2"]}], "+", "CKM33"}], ")"}]}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.500619397528989*^9, 3.500620045018338*^9, 
  3.500620139625103*^9, 3.5006215990387907`*^9, 3.5006219585093946`*^9, 
  3.500622052109432*^9, 3.500622118219303*^9, 3.500626952351755*^9, 
  3.500627787429153*^9, 3.500627821656193*^9, 3.500718793529174*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"M5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{
        RowBox[{
         RowBox[{"M4", "/", "8"}], "/", "2"}], "/", "3"}]}], "/.", 
      RowBox[{"MB2", "\[Rule]", "0"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Alfas", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"gS", "^", "2"}], "/", "4"}], "/", "\[Pi]"}], ")"}]}], ",",
        
       RowBox[{"Alfa", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"gw", "^", "2"}], "/", "4"}], "/", "\[Pi]"}], "*", 
          RowBox[{"sw", "^", "2"}]}], ")"}]}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.500619408652945*^9, 3.500619444131513*^9}, {
   3.500620186564165*^9, 3.50062022207979*^9}, 3.500627033279106*^9, 
   3.500718801130889*^9}],

Cell[CellGroupData[{

Cell[BoxData["M5"], "Input",
 CellChangeTimes->{{3.5006194476506643`*^9, 3.5006194497548857`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"24", " ", "MW2", " ", "S", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"MT2", "-", "T"}], ")"}], "2"]}]], 
   RowBox[{"CKM33", " ", 
    SuperscriptBox["gS", "2"], " ", 
    SuperscriptBox["gw", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["MT2", "4"], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "S"}], "+", "T"}], ")"}], " ", 
       SuperscriptBox["MT2", "3"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["MW2", "2"]}], "-", 
         RowBox[{"2", " ", "T", " ", "MW2"}], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"S", "+", "T"}], ")"}], "2"]}], ")"}], " ", 
       SuperscriptBox["MT2", "2"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["MW2", "3"]}], "-", 
         RowBox[{"2", " ", "T", " ", 
          SuperscriptBox["MW2", "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["S", "2"], "-", 
            RowBox[{"T", " ", "S"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["T", "2"]}]}], ")"}], " ", "MW2"}], "-", 
         RowBox[{"T", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"S", "+", "T"}], ")"}], "2"]}]}], ")"}], " ", "MT2"}], 
      "-", 
      RowBox[{"2", " ", "MW2", " ", "T", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["MW2", "2"]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"S", "+", "T"}], ")"}], " ", "MW2"}], "+", 
         SuperscriptBox["S", "2"], "+", 
         SuperscriptBox["T", "2"]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["Linv", "2"], " ", 
       RowBox[{"Re", "(", "C3phiq", ")"}], " ", 
       SuperscriptBox["v", "2"]}], "+", "CKM33"}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.5006194501200047`*^9, 3.5006200855107203`*^9, 
  3.500620149404791*^9, 3.500620225331334*^9, 3.500621612904705*^9, 
  3.500621974504005*^9, 3.500622057317657*^9, 3.500626960207111*^9, 
  3.500627037683268*^9, 3.500627822112309*^9, 3.50071880673446*^9}]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1269, 941},
WindowMargins->{{0, Automatic}, {Automatic, 27}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{594.25, 840.5},
"PostScriptOutputFile"->"/nfs/home/0/d/degrande/Generic/test.nb.ps"},
ShowSelection->True,
Magnification->1.25,
FrontEndVersion->"6.0 for Linux x86 (64-bit) (June 19, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 140, 2, 104, "Title"],
Cell[733, 27, 170, 2, 37, "Text"],
Cell[CellGroupData[{
Cell[928, 33, 198, 3, 65, "Subtitle"],
Cell[1129, 38, 118, 2, 38, "Input"],
Cell[CellGroupData[{
Cell[1272, 44, 365, 8, 64, "Input"],
Cell[CellGroupData[{
Cell[1662, 56, 1045, 16, 30, "Print"],
Cell[2710, 74, 1059, 16, 30, "Print"],
Cell[3772, 92, 1093, 17, 30, "Print"],
Cell[4868, 111, 1067, 16, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[5962, 131, 437, 10, 38, "Input"],
Cell[CellGroupData[{
Cell[6424, 145, 127, 2, 38, "Input"],
Cell[CellGroupData[{
Cell[6576, 151, 379, 9, 30, "Print"],
Cell[6958, 162, 379, 9, 30, "Print"],
Cell[7340, 173, 379, 9, 30, "Print"],
Cell[7722, 184, 379, 9, 30, "Print"],
Cell[8104, 195, 4906, 118, 505, "Print"]
}, Open  ]],
Cell[13025, 316, 2023, 57, 79, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[15085, 378, 1769, 36, 56, "Input"],
Cell[CellGroupData[{
Cell[16879, 418, 203, 4, 30, "Print"],
Cell[17085, 424, 674, 16, 30, "Print"],
Cell[17762, 442, 221, 4, 30, "Print"],
Cell[17986, 448, 488, 11, 30, "Print"],
Cell[18477, 461, 205, 4, 30, "Print"],
Cell[18685, 467, 674, 16, 30, "Print"],
Cell[19362, 485, 524, 11, 30, "Print"],
Cell[19889, 498, 225, 4, 30, "Print"],
Cell[20117, 504, 377, 9, 30, "Print"],
Cell[20497, 515, 488, 11, 30, "Print"],
Cell[20988, 528, 203, 4, 30, "Print"],
Cell[21194, 534, 488, 12, 30, "Print"],
Cell[21685, 548, 507, 12, 30, "Print"],
Cell[22195, 562, 505, 12, 30, "Print"],
Cell[22703, 576, 507, 12, 30, "Print"],
Cell[23213, 590, 505, 12, 30, "Print"],
Cell[23721, 604, 436, 11, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24206, 621, 267, 4, 38, "Input"],
Cell[CellGroupData[{
Cell[24498, 629, 474, 10, 30, "Print"],
Cell[24975, 641, 34406, 756, 505, "Print"]
}, Open  ]],
Cell[59396, 1400, 3610, 94, 79, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63043, 1499, 368, 7, 38, "Input"],
Cell[CellGroupData[{
Cell[63436, 1510, 270, 4, 30, "Print"],
Cell[63709, 1516, 576, 12, 30, "Print"],
Cell[64288, 1530, 572, 12, 30, "Print"],
Cell[64863, 1544, 502, 11, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[65414, 1561, 431, 9, 64, "Input"],
Cell[CellGroupData[{
Cell[65870, 1574, 666, 10, 30, "Print"],
Cell[66539, 1586, 676, 10, 30, "Print"],
Cell[67218, 1598, 678, 10, 30, "Print"],
Cell[67899, 1610, 688, 10, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[68636, 1626, 375, 9, 38, "Input"],
Cell[CellGroupData[{
Cell[69036, 1639, 636, 10, 30, "Print"],
Cell[69675, 1651, 922, 18, 30, "Print"],
Cell[70600, 1671, 607, 9, 30, "Print"],
Cell[71210, 1682, 638, 10, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[71897, 1698, 298, 5, 38, "Input"],
Cell[72198, 1705, 1199, 27, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73434, 1737, 464, 9, 64, "Input"],
Cell[CellGroupData[{
Cell[73923, 1750, 499, 10, 30, "Print"],
Cell[74425, 1762, 297, 5, 30, "Print"],
Cell[74725, 1769, 581, 13, 30, "Print"],
Cell[75309, 1784, 268, 4, 30, "Print"],
Cell[75580, 1790, 297, 5, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[75904, 1799, 1988, 44, 64, "Input"],
Cell[CellGroupData[{
Cell[77917, 1847, 907, 24, 89, "Input"],
Cell[78827, 1873, 6147, 133, 309, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85011, 2011, 1176, 29, 38, "Input"],
Cell[86190, 2042, 1323, 26, 64, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87550, 2073, 1631, 44, 89, "Input"],
Cell[89184, 2119, 1211, 28, 66, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[90432, 2152, 156, 3, 38, "Input"],
Cell[90591, 2157, 521, 13, 63, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[91149, 2175, 1462, 43, 64, "Input"],
Cell[92614, 2220, 908, 21, 68, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[93559, 2246, 1742, 51, 89, "Input"],
Cell[95304, 2299, 656, 13, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[95997, 2317, 1088, 30, 114, "Input"],
Cell[97088, 2349, 601, 16, 64, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[97738, 2371, 240, 3, 65, "Subtitle"],
Cell[97981, 2376, 118, 2, 38, "Input"],
Cell[CellGroupData[{
Cell[98124, 2382, 317, 8, 64, "Input"],
Cell[CellGroupData[{
Cell[98466, 2394, 1288, 19, 30, "Print"],
Cell[99757, 2415, 1302, 19, 30, "Print"],
Cell[101062, 2436, 1336, 20, 30, "Print"],
Cell[102401, 2458, 1310, 19, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[103738, 2481, 437, 10, 38, "Input"],
Cell[CellGroupData[{
Cell[104200, 2495, 127, 2, 38, "Input"],
Cell[CellGroupData[{
Cell[104352, 2501, 354, 8, 71, "Print"],
Cell[104709, 2511, 353, 8, 71, "Print"],
Cell[105065, 2521, 353, 8, 71, "Print"],
Cell[105421, 2531, 354, 8, 71, "Print"],
Cell[105778, 2541, 4877, 117, 1231, "Print"]
}, Closed]],
Cell[110670, 2661, 1998, 56, 187, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[112705, 2722, 1866, 37, 56, "Input"],
Cell[CellGroupData[{
Cell[114596, 2763, 1173, 18, 30, "Print"],
Cell[115772, 2783, 1646, 30, 30, "Print"],
Cell[117421, 2815, 1190, 18, 30, "Print"],
Cell[118614, 2835, 1460, 25, 30, "Print"],
Cell[120077, 2862, 1175, 18, 30, "Print"],
Cell[121255, 2882, 1644, 30, 30, "Print"],
Cell[122902, 2914, 1492, 25, 30, "Print"],
Cell[124397, 2941, 1195, 18, 30, "Print"],
Cell[125595, 2961, 1346, 23, 30, "Print"],
Cell[126944, 2986, 1460, 25, 30, "Print"],
Cell[128407, 3013, 1175, 18, 30, "Print"],
Cell[129585, 3033, 1460, 26, 30, "Print"],
Cell[131048, 3061, 1475, 26, 30, "Print"],
Cell[132526, 3089, 1475, 26, 30, "Print"],
Cell[134004, 3117, 1477, 26, 30, "Print"],
Cell[135484, 3145, 1475, 26, 30, "Print"],
Cell[136962, 3173, 1406, 25, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[138417, 3204, 267, 4, 38, "Input"],
Cell[CellGroupData[{
Cell[138709, 3212, 660, 13, 30, "Print"],
Cell[139372, 3227, 660, 13, 30, "Print"],
Cell[140035, 3242, 60305, 1158, 505, 48498, 963, "CachedBoxData", "BoxData", \
"Print"]
}, Open  ]],
Cell[200355, 4403, 3518, 89, 79, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[203910, 4497, 368, 7, 38, "Input"],
Cell[CellGroupData[{
Cell[204303, 4508, 477, 7, 30, "Print"],
Cell[204783, 4517, 782, 15, 30, "Print"],
Cell[205568, 4534, 779, 15, 30, "Print"],
Cell[206350, 4551, 778, 15, 30, "Print"],
Cell[207131, 4568, 710, 14, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[207890, 4588, 580, 11, 64, "Input"],
Cell[CellGroupData[{
Cell[208495, 4603, 868, 13, 30, "Print"],
Cell[209366, 4618, 883, 13, 30, "Print"],
Cell[210252, 4633, 883, 13, 30, "Print"],
Cell[211138, 4648, 889, 13, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[212076, 4667, 484, 11, 38, "Input"],
Cell[CellGroupData[{
Cell[212585, 4682, 359, 6, 30, "Print"],
Cell[212947, 4690, 643, 14, 30, "Print"],
Cell[213593, 4706, 330, 5, 30, "Print"],
Cell[213926, 4713, 361, 6, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[214336, 4725, 298, 5, 38, "Input"],
Cell[214637, 4732, 1076, 20, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[215750, 4757, 464, 9, 64, "Input"],
Cell[CellGroupData[{
Cell[216239, 4770, 711, 13, 30, "Print"],
Cell[216953, 4785, 505, 8, 30, "Print"],
Cell[217461, 4795, 789, 16, 30, "Print"],
Cell[218253, 4813, 476, 7, 30, "Print"],
Cell[218732, 4822, 505, 8, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[219286, 4836, 88, 1, 89, "Section"],
Cell[219377, 4839, 1570, 36, 64, "Input"],
Cell[CellGroupData[{
Cell[220972, 4879, 142, 2, 38, "Input"],
Cell[221117, 4883, 65072, 1760, 5144, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[286226, 6648, 302, 7, 30, "Input"],
Cell[CellGroupData[{
Cell[286553, 6659, 645, 10, 30, "Print"],
Cell[287201, 6671, 927, 18, 30, "Print"],
Cell[288131, 6691, 614, 9, 30, "Print"],
Cell[288748, 6702, 645, 10, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[289442, 6718, 1331, 32, 38, "Input"],
Cell[290776, 6752, 9217, 241, 253, "Output"]
}, Open  ]],
Cell[300008, 6996, 389, 11, 38, "Input"],
Cell[CellGroupData[{
Cell[300422, 7011, 98, 1, 38, "Input"],
Cell[300523, 7014, 2758, 74, 118, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[303318, 7093, 674, 20, 38, "Input"],
Cell[303995, 7115, 664, 16, 66, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[304696, 7136, 727, 21, 38, "Input"],
Cell[305426, 7159, 2186, 63, 90, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[307661, 7228, 90, 1, 89, "Section"],
Cell[307754, 7231, 1699, 39, 64, "Input"],
Cell[CellGroupData[{
Cell[309478, 7274, 302, 7, 38, "Input"],
Cell[CellGroupData[{
Cell[309805, 7285, 660, 10, 30, "Print"],
Cell[310468, 7297, 944, 18, 30, "Print"],
Cell[311415, 7317, 631, 9, 30, "Print"],
Cell[312049, 7328, 662, 10, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[312760, 7344, 1331, 32, 38, "Input"],
Cell[314094, 7378, 16776, 418, 389, "Output"]
}, Open  ]],
Cell[330885, 7799, 389, 11, 38, "Input"],
Cell[CellGroupData[{
Cell[331299, 7814, 98, 1, 38, "Input"],
Cell[331400, 7817, 5959, 157, 172, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[337396, 7979, 1042, 29, 64, "Input"],
Cell[338441, 8010, 1598, 49, 68, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[340088, 8065, 95, 1, 51, "Section"],
Cell[340186, 8068, 1216, 34, 64, "Input"],
Cell[CellGroupData[{
Cell[341427, 8106, 375, 8, 38, "Input"],
Cell[CellGroupData[{
Cell[341827, 8118, 761, 12, 30, "Print"],
Cell[342591, 8132, 1043, 20, 30, "Print"],
Cell[343637, 8154, 732, 11, 30, "Print"],
Cell[344372, 8167, 761, 12, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[345182, 8185, 1331, 32, 38, "Input"],
Cell[346516, 8219, 7478, 205, 198, "Output"]
}, Open  ]],
Cell[354009, 8427, 928, 29, 38, "Input"],
Cell[CellGroupData[{
Cell[354962, 8460, 98, 1, 38, "Input"],
Cell[355063, 8463, 2411, 69, 117, "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
