(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     88876,       2087]
NotebookOptionsPosition[     84558,       1944]
NotebookOutlinePosition[     85150,       1966]
CellTagsIndexPosition[     85107,       1963]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["FeynArts and FormCalc", "Title",
 CellChangeTimes->{{3.4778117188657*^9, 3.4778117348357*^9}}],

Cell["test the two amplitudes computed before", "Text",
 CellChangeTimes->{{3.478438848916302*^9, 3.478438849192754*^9}, {
  3.479546643579921*^9, 3.479546660109585*^9}}],

Cell[CellGroupData[{

Cell["t->evb", "Subtitle",
 CellChangeTimes->{{3.4778117420706997`*^9, 3.4778117447507*^9}, {
  3.497862048812056*^9, 3.497862055502046*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.448968342513181*^9, 3.448968344880295*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\</home/degrande/eta/FeynProg/FeynArts-3.5\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "FeynArts`"}]}], "Input",
 CellChangeTimes->{
  3.4777456682883*^9, 3.478434363232997*^9, {3.4978572265868073`*^9, 
   3.4978572271791267`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478434366177163*^9, 3.478435570663394*^9, 3.478435703141808*^9, 
   3.478436820027009*^9, {3.479038946238288*^9, 3.479038952669886*^9}, 
   3.47909796405005*^9, 3.479099042060194*^9, 3.479099989966432*^9, 
   3.479106322136636*^9, 3.479546671218491*^9, 3.47954731586526*^9, 
   3.479547695541888*^9, 3.497857241645294*^9, 3.4978620645824203`*^9, 
   3.497862527772278*^9, 3.497871404570545*^9, 3.4979424788339853`*^9, 
   3.498391193496977*^9, 3.499497274187397*^9, 3.4995193408702707`*^9, 
   3.499581276936945*^9, 3.499585029981333*^9, 3.499585781904087*^9, 
   3.499663879992983*^9, 3.500719348299573*^9}],

Cell[BoxData[
 FormBox["\<\"FeynArts 3.5\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478434366177163*^9, 3.478435570663394*^9, 3.478435703141808*^9, 
   3.478436820027009*^9, {3.479038946238288*^9, 3.479038952669886*^9}, 
   3.47909796405005*^9, 3.479099042060194*^9, 3.479099989966432*^9, 
   3.479106322136636*^9, 3.479546671218491*^9, 3.47954731586526*^9, 
   3.479547695541888*^9, 3.497857241645294*^9, 3.4978620645824203`*^9, 
   3.497862527772278*^9, 3.497871404570545*^9, 3.4979424788339853`*^9, 
   3.498391193496977*^9, 3.499497274187397*^9, 3.4995193408702707`*^9, 
   3.499581276936945*^9, 3.499585029981333*^9, 3.499585781904087*^9, 
   3.499663879992983*^9, 3.500719348323988*^9}],

Cell[BoxData[
 FormBox["\<\"by Hagen Eck, Sepp Kueblbeck, and Thomas Hahn\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478434366177163*^9, 3.478435570663394*^9, 3.478435703141808*^9, 
   3.478436820027009*^9, {3.479038946238288*^9, 3.479038952669886*^9}, 
   3.47909796405005*^9, 3.479099042060194*^9, 3.479099989966432*^9, 
   3.479106322136636*^9, 3.479546671218491*^9, 3.47954731586526*^9, 
   3.479547695541888*^9, 3.497857241645294*^9, 3.4978620645824203`*^9, 
   3.497862527772278*^9, 3.497871404570545*^9, 3.4979424788339853`*^9, 
   3.498391193496977*^9, 3.499497274187397*^9, 3.4995193408702707`*^9, 
   3.499581276936945*^9, 3.499585029981333*^9, 3.499585781904087*^9, 
   3.499663879992983*^9, 3.500719348342605*^9}],

Cell[BoxData[
 FormBox["\<\"last revised 16 Apr 10\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4777456743583*^9, 3.4777482804298*^9, 3.4778056214987*^9, 
   3.4778059164856997`*^9, 3.4778086978662*^9, {3.4778087847572002`*^9, 
   3.4778088073171997`*^9}, 3.4778108541047*^9, 3.4778115299907*^9, 
   3.478434366177163*^9, 3.478435570663394*^9, 3.478435703141808*^9, 
   3.478436820027009*^9, {3.479038946238288*^9, 3.479038952669886*^9}, 
   3.47909796405005*^9, 3.479099042060194*^9, 3.479099989966432*^9, 
   3.479106322136636*^9, 3.479546671218491*^9, 3.47954731586526*^9, 
   3.479547695541888*^9, 3.497857241645294*^9, 3.4978620645824203`*^9, 
   3.497862527772278*^9, 3.497871404570545*^9, 3.4979424788339853`*^9, 
   3.498391193496977*^9, 3.499497274187397*^9, 3.4995193408702707`*^9, 
   3.499581276936945*^9, 3.499585029981333*^9, 3.499585781904087*^9, 
   3.499663879992983*^9, 3.500719348356265*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"topo", " ", "=", " ", 
   RowBox[{"CreateTopologies", "[", 
    RowBox[{"0", ",", 
     RowBox[{"1", "\[Rule]", "3"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.47548813810296*^9, 3.475488972088063*^9, {3.4777456120408*^9, 
   3.4777456332583*^9}, 3.4778098132447*^9, 3.4778110152581997`*^9, {
   3.497857235135571*^9, 3.497857237590866*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Paint", "[", "topo", "]"}]], "Input",
 CellChangeTimes->{{3.4777456818157997`*^9, 3.4777456889958*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456900683002`*^9, 3.478435704755388*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 2, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456900683002`*^9, 3.47843570476089*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 3, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456900683002`*^9, 3.47843570476613*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 diagram\"\>"}],
   SequenceForm["> Top. ", 4, ": ", "1 diagram"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456900683002`*^9, 3.478435704771953*^9}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-9.094947017729282*^-12, 15.000000000003638`}, {
        9.999999999983629, 10.000000000007276`}}], 
       LineBox[{{-9.094947017729282*^-12, 4.999999999996362}, {
        9.999999999985448, 9.999999999989086}}], 
       LineBox[{{20.000000000009095`, 15.000000000003638`}, {
        10.000000000009095`, 10.000000000003638`}}], 
       LineBox[{{20., 5.}, {10., 10.}}], 
       {PointSize[0.04], PointBox[{10., 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 44}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-5.4569682106375694`*^-12, 15.000000000005457`}, {
        5.999999999996362, 10.000000000001819`}}], 
       LineBox[{{-9.094947017729282*^-12, 4.999999999992724}, {
        5.999999999994543, 9.999999999994543}}], 
       LineBox[{{20.000000000005457`, 15.000000000003638`}, {
        14.000000000003638`, 10.000000000001819`}}], 
       LineBox[{{19.99999999999818, 5.000000000001819}, {13.999999999998181`, 
        10.}}], LineBox[{{5.999999999990206, 10.}, {13.999999999982224`, 
        10.}}], 
       {PointSize[0.04], PointBox[{6., 10.}], 
        PointBox[{13.99999999999999, 10.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T2\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{6.139089236967266*^-12, 15.}, {10.000000000002046`, 
        14.000000000003638`}}], 
       LineBox[{{-7.503331289626658*^-12, 5.000000000003638}, {
        9.999999999988404, 6.}}], 
       LineBox[{{20.000000000002956`, 15.}, {10.000000000002956`, 14.}}], 
       LineBox[{{19.999999999997726`, 4.999999999996362}, {9.999999999997726, 
        5.999999999996362}}], 
       LineBox[{{10., 14.000000000000902`}, {10., 6.000000000000003}}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T3\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{6.139089236967266*^-12, 15.}, {10.000000000002046`, 
        14.000000000003638`}}], 
       LineBox[{{-7.503331289626658*^-12, 5.000000000003638}, {
        9.999999999988404, 6.}}], 
       LineBox[{{20.00000000000182, 15.}, {10., 6.}}], 
       LineBox[{{20.00000000000182, 5.}, {10., 14.}}], 
       LineBox[{{10., 14.000000000000902`}, {10., 6.000000000000003}}], 
       {PointSize[0.04], PointBox[{10., 13.99999999999999}], 
        PointBox[{10., 6.}]}, InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T4\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 22}, {0, 0}, {22, 22}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"2\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {28.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[RightArrow]\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {33., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"2\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {37.5, 69.96}, {0, 0}]},
   AspectRatio->1.0999999999999999`,
   PlotRange->{{0, 66}, {0, 72.6}}], TraditionalForm]], "Print",
 CellChangeTimes->{3.4777456900683002`*^9, 3.478435705080669*^9}]
}, Closed]],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"FeynArtsGraphics", "(", 
    RowBox[{"2", "\[Rule]", "2"}], ")"}], "\[InvisibleApplication]", 
   RowBox[{"(", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T2\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T2", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T3\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T3", "]"],
           Editable->False],
          TraditionalForm]},
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T4\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T4", "]"],
           Editable->False],
          TraditionalForm], "Null", "Null"},
        {"Null", "Null", "Null"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.4777456905908003`*^9, 3.478435705207405*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"INTopoqq", " ", "=", " ", 
   RowBox[{"InsertFields", "[", 
    RowBox[{"topo", ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"F", "[", "9", "]"}], "}"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"F", "[", "12", "]"}], ",", 
        RowBox[{"F", "[", "1", "]"}], ",", 
        RowBox[{"-", 
         RowBox[{"F", "[", "4", "]"}]}]}], "}"}]}], ",", 
     RowBox[{"GenericModel", "\[Rule]", "\"\<TopEffTh_FA/TopEffTh_FA\>\""}], 
     ",", 
     RowBox[{"Model", "\[Rule]", "\"\<TopEffTh_FA/TopEffTh_FA\>\""}], ",", 
     RowBox[{"ExcludeParticles", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"V", "[", "1", "]"}], ",", 
        RowBox[{"V", "[", "2", "]"}], ",", 
        RowBox[{"S", "[", "1", "]"}]}], "}"}]}], ",", 
     RowBox[{"InsertionLevel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Generic", ",", " ", "Classes", ",", "Particles"}], "}"}]}]}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4778060034077*^9, 3.4778060172207003`*^9}, {
   3.4778061181482*^9, 3.4778062060957003`*^9}, {3.4778064622107*^9, 
   3.4778064974032*^9}, {3.4778096875622*^9, 3.4778097175422*^9}, {
   3.4778099067622004`*^9, 3.4778099081296997`*^9}, {3.4778111168007*^9, 
   3.4778111226157*^9}, {3.4778115172907*^9, 3.4778115174282*^9}, 
   3.478437845209915*^9, {3.479546689667869*^9, 3.479546718821388*^9}, {
   3.479546793843457*^9, 3.47954680051448*^9}, {3.497857256699514*^9, 
   3.497857324742622*^9}, {3.497857383657874*^9, 3.497857387157604*^9}, {
   3.49785741944608*^9, 3.497857431156871*^9}, {3.497862502940681*^9, 
   3.497862507492491*^9}, {3.4983901274683743`*^9, 3.498390130073097*^9}, {
   3.499495582368535*^9, 3.499495584937093*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.500719354904389*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
    "\[InvisibleSpace]", "\<\"generic\"\>", 
    "\[InvisibleSpace]", "\<\" model file \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.gen\"\>"}],
   SequenceForm[
   "", "loading ", "generic", " model file ", 
    "/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.gen"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.5007193550409403`*^9}],

Cell[BoxData[
 FormBox["\<\"> $SVMixing is OFF\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.5007193550464907`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"generic model \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", "\<\"TopEffTh_FA/TopEffTh_FA\"\>", "}"}], 
    "\[InvisibleSpace]", "\<\" initialized\"\>"}],
   SequenceForm[
   "generic model ", {"TopEffTh_FA/TopEffTh_FA"}, " initialized"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.500719355057899*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.500719355069853*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
    "\[InvisibleSpace]", "\<\"classes\"\>", 
    "\[InvisibleSpace]", "\<\" model file \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.mod\"\>"}],
   SequenceForm[
   "", "loading ", "classes", " model file ", 
    "/nfs/home/d/degrande/eta/FeynProg/FeynArts-3.5/Models/TopEffTh_FA/\
TopEffTh_FA.mod"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.500719355076499*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "51", 
    "\[InvisibleSpace]", "\<\" particles (incl. antiparticles) in \"\>", 
    "\[InvisibleSpace]", "30", "\[InvisibleSpace]", "\<\" classes\"\>"}],
   SequenceForm[
   "> ", 51, " particles (incl. antiparticles) in ", 30, " classes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.500719355324739*^9}],

Cell[BoxData[
 FormBox["\<\"> $CounterTerms are ON\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.500719355761036*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "142", 
    "\[InvisibleSpace]", "\<\" vertices\"\>"}],
   SequenceForm["> ", 142, " vertices"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.5007193559665737`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"classes model \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", "\<\"TopEffTh_FA/TopEffTh_FA\"\>", "}"}], 
    "\[InvisibleSpace]", "\<\" initialized\"\>"}],
   SequenceForm[
   "classes model ", {"TopEffTh_FA/TopEffTh_FA"}, " initialized"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.500719356099678*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.500719356235753*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Excluding \"\>", "\[InvisibleSpace]", "0", 
    "\[InvisibleSpace]", "\<\" Generic, \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" Classes, and \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" Particles fields\"\>"}],
   SequenceForm[
   "Excluding ", 0, " Generic, ", 3, " Classes, and ", 3, 
    " Particles fields"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.5007193563722467`*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.5007193566466417`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"Generic", ",", "Classes", ",", "Particles"}], "}"}]}],
   SequenceForm[
   "inserting at level(s) ", {Generic, FeynArts`Classes, FeynArts`Particles}],
   
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.5007193567906437`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes, 0 Particles \
insertions\"\>"}],
   SequenceForm[
   "> Top. ", 1, ": ", "0 Generic, 0 Classes, 0 Particles insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.500719356936816*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes, 1 Particles \
insertions\"\>"}],
   SequenceForm[
   "> Top. ", 2, ": ", "1 Generic, 1 Classes, 1 Particles insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.5007193570863256`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes, 0 Particles \
insertions\"\>"}],
   SequenceForm[
   "> Top. ", 3, ": ", "0 Generic, 0 Classes, 0 Particles insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.500719357237802*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes, 0 Particles \
insertions\"\>"}],
   SequenceForm[
   "> Top. ", 4, ": ", "0 Generic, 0 Classes, 0 Particles insertions"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.50071935753611*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.500719357683814*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Restoring \"\>", "\[InvisibleSpace]", "0", 
    "\[InvisibleSpace]", "\<\" Generic, \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" Classes, and \"\>", "\[InvisibleSpace]", "3", 
    "\[InvisibleSpace]", "\<\" Particles fields\"\>"}],
   SequenceForm[
   "Restoring ", 0, " Generic, ", 3, " Classes, and ", 3, 
    " Particles fields"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.5007193578306313`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"in total: \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes, 1 Particles \
insertions\"\>"}],
   SequenceForm["in total: ", "1 Generic, 1 Classes, 1 Particles insertions"],
   
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778108948522*^9, 3.4778111234856997`*^9, 3.4778115364932003`*^9, 
   3.478434374488394*^9, 3.478435572203797*^9, 3.478435706296789*^9, 
   3.478437845951703*^9, {3.479038967870449*^9, 3.479038992642903*^9}, 
   3.47903962671351*^9, 3.479097981627183*^9, {3.479099047114438*^9, 
   3.479099051629787*^9}, 3.479099992849716*^9, 3.479106329174947*^9, {
   3.47954670376287*^9, 3.479546719449662*^9}, 3.479546801451241*^9, 
   3.479547320037069*^9, 3.479547699448203*^9, 3.497857326630136*^9, 
   3.497857387945911*^9, 3.497857431956799*^9, 3.497862067374255*^9, 
   3.497862531309819*^9, 3.497871410991981*^9, 3.497942482657105*^9, 
   3.498391196890265*^9, 3.499497277822806*^9, 3.499519344544788*^9, 
   3.4995812793018417`*^9, 3.499585031620029*^9, 3.499585783613077*^9, 
   3.499663882012418*^9, 3.500719357978938*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Paint", "[", "INTopoqq", "]"}]], "Input",
 CellChangeTimes->{{3.4778063315682*^9, 3.4778063464357*^9}, {
   3.4778115474231997`*^9, 3.4778115475632*^9}, 3.478437858916929*^9, 
   3.479546810801527*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"3 diagrams\"\>"}],
   SequenceForm["> Top. ", 1, ": ", "3 diagrams"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.479546811928915*^9, 3.49786207652789*^9, 
  3.4978625348613377`*^9, 3.497871415519409*^9, 3.49794248658965*^9, 
  3.498391202615528*^9, 3.499497282540414*^9, 3.499519347854422*^9, 
  3.499581284453961*^9, 3.499585035072423*^9, 3.499663885448338*^9, 
  3.500719358956658*^9}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-1.0913936421275139`*^-11, 9.999999999996362}, {
        8.999999999983629, 11.999999999996362`}}], 
       PolygonBox[{{5.085712236110371, 11.130158274691194`}, {
        4.001059947017091, 10.479366901235226`}, {3.827515580762166, 
        11.260316549382388`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.163757790381083, 11.908289943285126`}, \
{0, -1}], 
       LineBox[{{20.000000000009095`, 17.000000000003638`}, {
        9.000000000009095, 12.000000000007276`}}], 
       PolygonBox[{{15.046219886477562`, 14.74828176658071}, {
        13.788258935801963`, 14.615864824404332`}, {14.11930129124291, 
        13.887571642434247`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"b\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {14.463405436333165`, 15.306268040067037`}, \
{1, -1}], 
       LineBox[{{19.999999999996362`, 10.}, {13.499999999996362`, 
        6.499999999996362}}], 
       PolygonBox[{{17.278282659953305`, 8.53445989382101}, {
        16.032077410832688`, 8.31772854614786}, {16.4113572692607, 
        7.61335166621012}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"ve\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.619945274295723`, 9.009930204879371}, \
{1, -1}], LineBox[{{20., 3.}, {13.5, 6.5}}], 
       PolygonBox[{{16.221717340046695`, 5.03445989382101}, {
        17.467922589167312`, 4.81772854614786}, {17.0886427307393, 
        4.11335166621012}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"e\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.880054725704277`, 5.509930204879372}, \
{-1, -1}], LineBox[CompressedData["
1:eJwV1AtMU1cYB/DDqzajCbDB1gyEimV2KFsXBwMs4y6OrWgh1RWkSHDDMutg
irMjQBoftKhE4tioAR8bjOBSTSvVGQR5CKQyxkDJVl4Kod3GQ3Q6BKHFO7r/
ucnNye+e7zvfedycdTkHd+Z6EkKkeGlLnG48kQzhU7zOEHuXcNFnI0PUS6fF
Z2B1QMkUdca5sfKXgxmi7XZ0rSC+d+DV23p4djJuswMWPJdmTsLWLS9FNNP+
/leqBSEMGU/re3oMVpPSy9tgi8kVnggXebbl7oWzloqXlt9E/p0j6YdhU8yR
4muwM2nycz3M6+ipPQRLW+cUdbBGKfokAWbWKjbeo+Nzr119DS5Yk+QOWsuQ
trS4Ug/YMtwuLITtvz14xyXCeC05rsdwQfQXSyvwbB03VRPKkHx5n4bGf9qk
zfYKY4jEUW7gwJ1jHeJKmCsJ0njD5Pju77gChnzI7lIsIV905VF8Ilx5YiZ9
DFapRS37YWvS4r8muEBadeEkzMvw9jhM6+WP7j8PB07769+m85k4tu8SPPhu
x/OZDQw5tRAVYIbH7zdq6uHA6CF1E9zAyxxQwRd5YVE9sC208dvNcIg2NdhO
82N8cgJg7dAhJWcdQ2SScd3qGwxp3p0qiIOtfHbYCbcpjl4vpP6qNpKFxd6b
6lth4XT6lCfy83PzMr3CsY6y7CkOLCdDw1I4diK5kPb7b9Xnn4RJW1X0PPLJ
A35ZKzz7pax7EK70KHjrL5ht2hfyI2y5UqNehUe9OhtUsPGHexF+67G+0Lvt
YTRfqWf5cK95NXg0AnFRF6oFsG3nekcVbLflvYiEydfWnzJgfldnmwSW9fV8
HwmHZMqSlbBJeXzaF9aXp2SXwmrd6S2sEPOq/rP7Jqz9poZ1wibzvHwZ5i2a
q/+DHw9+sD0BbXNcAuON/AbLtgU9bOgsHuHA4n+kH/8KM75nHG60/rtG+nzw
XZsj/+wRLEw0xr8HS1ICi36BjXvf98uCbxjPWgzwqR3iWxpYcXHrwzSYde0x
6GB2Ru7wg0Xip0crYC5zoqQX8/LfcFlmoHU9zw+UwYPG+OVa2HrrSXQKLL6j
cvwM95c+Kwmn635yIPwPuELaFLuGrntuh68bNqUerF3BvttN7HwM9pnxelHl
gvUVC9uL4Fhz6iY3PZfF0MDbcEWtUuND6+vu59FzV7nLszj0XOr9spPhcY86
E4v4/pHfL+lgxfRd29+wLP2A8jrMf1igbYdFiqA9NrjG7LxJ/xNNM1szB99o
uTrxEa3X+KxrGWbpfYP/jkfvGxHzP9Ayqng=
        "]], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"V\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {10.655166186234853`, 8.873281425101244}, \
{1, 1}], 
       {PointSize[0.04], PointBox[{9., 12.}], PointBox[{13.5, 6.5}]}, 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 G1 N1\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {0, 44}, {0, 0}, {22, 22}], InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-1.0913936421275139`*^-11, 9.999999999996362}, {
        8.999999999983629, 11.999999999996362`}}], 
       PolygonBox[{{5.085712236110371, 11.130158274691194`}, {
        4.001059947017091, 10.479366901235226`}, {3.827515580762166, 
        11.260316549382388`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.163757790381083, 11.908289943285126`}, \
{0, -1}], 
       LineBox[{{20.000000000009095`, 17.000000000003638`}, {
        9.000000000009095, 12.000000000007276`}}], 
       PolygonBox[{{15.046219886477562`, 14.74828176658071}, {
        13.788258935801963`, 14.615864824404332`}, {14.11930129124291, 
        13.887571642434247`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"b\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {14.463405436333165`, 15.306268040067037`}, \
{1, -1}], 
       LineBox[{{19.999999999996362`, 10.}, {13.499999999996362`, 
        6.499999999996362}}], 
       PolygonBox[{{17.278282659953305`, 8.53445989382101}, {
        16.032077410832688`, 8.31772854614786}, {16.4113572692607, 
        7.61335166621012}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"ve\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.619945274295723`, 9.009930204879371}, \
{1, -1}], LineBox[{{20., 3.}, {13.5, 6.5}}], 
       PolygonBox[{{16.221717340046695`, 5.03445989382101}, {
        17.467922589167312`, 4.81772854614786}, {17.0886427307393, 
        4.11335166621012}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"e\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.880054725704277`, 5.509930204879372}, \
{-1, -1}], LineBox[CompressedData["
1:eJwV1AtMU1cYB/DDqzajCbDB1gyEimV2KFsXBwMs4y6OrWgh1RWkSHDDMutg
irMjQBoftKhE4tioAR8bjOBSTSvVGQR5CKQyxkDJVl4Kod3GQ3Q6BKHFO7r/
ucnNye+e7zvfedycdTkHd+Z6EkKkeGlLnG48kQzhU7zOEHuXcNFnI0PUS6fF
Z2B1QMkUdca5sfKXgxmi7XZ0rSC+d+DV23p4djJuswMWPJdmTsLWLS9FNNP+
/leqBSEMGU/re3oMVpPSy9tgi8kVnggXebbl7oWzloqXlt9E/p0j6YdhU8yR
4muwM2nycz3M6+ipPQRLW+cUdbBGKfokAWbWKjbeo+Nzr119DS5Yk+QOWsuQ
trS4Ug/YMtwuLITtvz14xyXCeC05rsdwQfQXSyvwbB03VRPKkHx5n4bGf9qk
zfYKY4jEUW7gwJ1jHeJKmCsJ0njD5Pju77gChnzI7lIsIV905VF8Ilx5YiZ9
DFapRS37YWvS4r8muEBadeEkzMvw9jhM6+WP7j8PB07769+m85k4tu8SPPhu
x/OZDQw5tRAVYIbH7zdq6uHA6CF1E9zAyxxQwRd5YVE9sC208dvNcIg2NdhO
82N8cgJg7dAhJWcdQ2SScd3qGwxp3p0qiIOtfHbYCbcpjl4vpP6qNpKFxd6b
6lth4XT6lCfy83PzMr3CsY6y7CkOLCdDw1I4diK5kPb7b9Xnn4RJW1X0PPLJ
A35ZKzz7pax7EK70KHjrL5ht2hfyI2y5UqNehUe9OhtUsPGHexF+67G+0Lvt
YTRfqWf5cK95NXg0AnFRF6oFsG3nekcVbLflvYiEydfWnzJgfldnmwSW9fV8
HwmHZMqSlbBJeXzaF9aXp2SXwmrd6S2sEPOq/rP7Jqz9poZ1wibzvHwZ5i2a
q/+DHw9+sD0BbXNcAuON/AbLtgU9bOgsHuHA4n+kH/8KM75nHG60/rtG+nzw
XZsj/+wRLEw0xr8HS1ICi36BjXvf98uCbxjPWgzwqR3iWxpYcXHrwzSYde0x
6GB2Ru7wg0Xip0crYC5zoqQX8/LfcFlmoHU9zw+UwYPG+OVa2HrrSXQKLL6j
cvwM95c+Kwmn635yIPwPuELaFLuGrntuh68bNqUerF3BvttN7HwM9pnxelHl
gvUVC9uL4Fhz6iY3PZfF0MDbcEWtUuND6+vu59FzV7nLszj0XOr9spPhcY86
E4v4/pHfL+lgxfRd29+wLP2A8jrMf1igbYdFiqA9NrjG7LxJ/xNNM1szB99o
uTrxEa3X+KxrGWbpfYP/jkfvGxHzP9Ayqng=
        "]], 
       PolygonBox[{{11.629942674154357`, 8.785625620478008}, {
        10.560474406164314`, 9.461079263419087}, {11.17964024552697, 
        9.967669495624898}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"W\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {10.655166186234853`, 8.873281425101244}, \
{1, 1}], 
       {PointSize[0.04], PointBox[{9., 12.}], PointBox[{13.5, 6.5}]}, 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 C1 N2\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {22, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     GraphicsBox[
      {Thickness[0.005], 
       LineBox[{{-1.0913936421275139`*^-11, 9.999999999996362}, {
        8.999999999983629, 11.999999999996362`}}], 
       PolygonBox[{{5.085712236110371, 11.130158274691194`}, {
        4.001059947017091, 10.479366901235226`}, {3.827515580762166, 
        11.260316549382388`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"t\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {4.163757790381083, 11.908289943285126`}, \
{0, -1}], 
       LineBox[{{20.000000000009095`, 17.000000000003638`}, {
        9.000000000009095, 12.000000000007276`}}], 
       PolygonBox[{{15.046219886477562`, 14.74828176658071}, {
        13.788258935801963`, 14.615864824404332`}, {14.11930129124291, 
        13.887571642434247`}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"b\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {14.463405436333165`, 15.306268040067037`}, \
{1, -1}], 
       LineBox[{{19.999999999996362`, 10.}, {13.499999999996362`, 
        6.499999999996362}}], 
       PolygonBox[{{17.278282659953305`, 8.53445989382101}, {
        16.032077410832688`, 8.31772854614786}, {16.4113572692607, 
        7.61335166621012}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"ve\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.619945274295723`, 9.009930204879371}, \
{1, -1}], LineBox[{{20., 3.}, {13.5, 6.5}}], 
       PolygonBox[{{16.221717340046695`, 5.03445989382101}, {
        17.467922589167312`, 4.81772854614786}, {17.0886427307393, 
        4.11335166621012}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"e\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {16.880054725704277`, 5.509930204879372}, \
{-1, -1}], LineBox[CompressedData["
1:eJwV1AtMU1cYB/DDqzajCbDB1gyEimV2KFsXBwMs4y6OrWgh1RWkSHDDMutg
irMjQBoftKhE4tioAR8bjOBSTSvVGQR5CKQyxkDJVl4Kod3GQ3Q6BKHFO7r/
ucnNye+e7zvfedycdTkHd+Z6EkKkeGlLnG48kQzhU7zOEHuXcNFnI0PUS6fF
Z2B1QMkUdca5sfKXgxmi7XZ0rSC+d+DV23p4djJuswMWPJdmTsLWLS9FNNP+
/leqBSEMGU/re3oMVpPSy9tgi8kVnggXebbl7oWzloqXlt9E/p0j6YdhU8yR
4muwM2nycz3M6+ipPQRLW+cUdbBGKfokAWbWKjbeo+Nzr119DS5Yk+QOWsuQ
trS4Ug/YMtwuLITtvz14xyXCeC05rsdwQfQXSyvwbB03VRPKkHx5n4bGf9qk
zfYKY4jEUW7gwJ1jHeJKmCsJ0njD5Pju77gChnzI7lIsIV905VF8Ilx5YiZ9
DFapRS37YWvS4r8muEBadeEkzMvw9jhM6+WP7j8PB07769+m85k4tu8SPPhu
x/OZDQw5tRAVYIbH7zdq6uHA6CF1E9zAyxxQwRd5YVE9sC208dvNcIg2NdhO
82N8cgJg7dAhJWcdQ2SScd3qGwxp3p0qiIOtfHbYCbcpjl4vpP6qNpKFxd6b
6lth4XT6lCfy83PzMr3CsY6y7CkOLCdDw1I4diK5kPb7b9Xnn4RJW1X0PPLJ
A35ZKzz7pax7EK70KHjrL5ht2hfyI2y5UqNehUe9OhtUsPGHexF+67G+0Lvt
YTRfqWf5cK95NXg0AnFRF6oFsG3nekcVbLflvYiEydfWnzJgfldnmwSW9fV8
HwmHZMqSlbBJeXzaF9aXp2SXwmrd6S2sEPOq/rP7Jqz9poZ1wibzvHwZ5i2a
q/+DHw9+sD0BbXNcAuON/AbLtgU9bOgsHuHA4n+kH/8KM75nHG60/rtG+nzw
XZsj/+wRLEw0xr8HS1ICi36BjXvf98uCbxjPWgzwqR3iWxpYcXHrwzSYde0x
6GB2Ru7wg0Xip0crYC5zoqQX8/LfcFlmoHU9zw+UwYPG+OVa2HrrSXQKLL6j
cvwM95c+Kwmn635yIPwPuELaFLuGrntuh68bNqUerF3BvttN7HwM9pnxelHl
gvUVC9uL4Fhz6iY3PZfF0MDbcEWtUuND6+vu59FzV7nLszj0XOr9spPhcY86
E4v4/pHfL+lgxfRd29+wLP2A8jrMf1igbYdFiqA9NrjG7LxJ/xNNM1szB99o
uTrxEa3X+KxrGWbpfYP/jkfvGxHzP9Ayqng=
        "]], 
       PolygonBox[{{11.629942674154357`, 8.785625620478008}, {
        10.560474406164314`, 9.461079263419087}, {11.17964024552697, 
        9.967669495624898}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"W\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->9.996694214876035],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          9.996694214876035]& ], {10.655166186234853`, 8.873281425101244}, \
{1, 1}], 
       {PointSize[0.04], PointBox[{9., 12.}], PointBox[{13.5, 6.5}]}, 
       InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"T1 P1 N3\"\>",
           DisplayForm],
          FontFamily->"Helvetica",
          FontSize->7.997355371900828],
         StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
          7.997355371900828]& ], {10., -0.5}, {0, -1}]},
      AspectRatio->1,
      PlotRange->{{-1, 21}, {-1, 21}}], {44, 44}, {0, 0}, {22, 22}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"t\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {24., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[RightArrow]\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {28.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"b\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {33., 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"ve\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {37.5, 69.96}, {0, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"e\"\>",
        DisplayForm],
       FontFamily->"Helvetica",
       FontSize->11.99603305785124],
      StyleForm[#, FontFamily -> "Helvetica", FontSize -> 
       11.99603305785124]& ], {42., 69.96}, {0, 0}]},
   AspectRatio->1.0999999999999999`,
   PlotRange->{{0, 66}, {0, 72.6}}], TraditionalForm]], "Print",
 CellChangeTimes->{3.479546811928915*^9, 3.49786207652789*^9, 
  3.4978625348613377`*^9, 3.497871415519409*^9, 3.49794248658965*^9, 
  3.498391202615528*^9, 3.499497282540414*^9, 3.499519347854422*^9, 
  3.499581284453961*^9, 3.499585035072423*^9, 3.499663885448338*^9, 
  3.500719360943664*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"FeynArtsGraphics", "(", 
    RowBox[{
     RowBox[{"{", "\<\"t\"\>", "}"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"ve\"\>", ",", "\<\"e\"\>"}], "}"}]}], 
    ")"}], "\[InvisibleApplication]", 
   RowBox[{"(", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 G1 N1\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 G1 N1", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 C1 N2\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 C1 N2", "]"],
           Editable->False],
          TraditionalForm], 
         FormBox[
          InterpretationBox[
           
           RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", "\<\"T1 P1 N3\"\>", 
            "\[InvisibleSpace]", "\<\"]\"\>"}],
           SequenceForm["[", "T1 P1 N3", "]"],
           Editable->False],
          TraditionalForm]},
        {"Null", "Null", "Null"},
        {"Null", "Null", "Null"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ")"}]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.4778063475407*^9, 3.4778065254607*^9, 3.4778099157272*^9, 
   3.4778115492682*^9, 3.47843686984159*^9, 3.478436906375371*^9, {
   3.478437853618226*^9, 3.478437860811162*^9}, 3.479099999826127*^9, 
   3.479106333796554*^9, {3.479546806741183*^9, 3.479546812623714*^9}, 
   3.4978620779952097`*^9, 3.497862535136364*^9, 3.497871415799543*^9, 
   3.4979424893430643`*^9, 3.498391202919662*^9, 3.499497285005741*^9, 
   3.49951935066346*^9, 3.499581286681391*^9, 3.499585035291901*^9, 
   3.499663885673908*^9, 3.500719361065125*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Amplqq", " ", "=", " ", 
   RowBox[{"CreateFeynAmp", "[", "INTopoqq", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4778062370957003`*^9, 3.4778062399307003`*^9}, {
   3.4778115657332*^9, 3.4778115658507*^9}, {3.4778120221097*^9, 
   3.4778120222467003`*^9}, 3.479547360479462*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778115712007*^9, {3.4778120234797*^9, 3.4778120430657*^9}, 
   3.478434383755428*^9, 3.478435578790159*^9, 3.478435879919781*^9, 
   3.478436801285664*^9, 3.478436912149393*^9, 3.479546827897663*^9, 
   3.479547326278256*^9, 3.479547708182675*^9, 3.4978620943988867`*^9, 
   3.497862539864615*^9, 3.49787142159265*^9, 3.49794249187234*^9, 
   3.498391203987452*^9, 3.4994972935936937`*^9, 3.499519352311137*^9, 
   3.499581288167224*^9, 3.4995850366485233`*^9, 3.499585789386694*^9, 
   3.499663888450828*^9, 3.500719361311668*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{"Generic", ",", "Classes", ",", "Particles"}], "}"}]}],
   SequenceForm[
   "creating amplitudes at level(s) ", {
    Generic, FeynArts`Classes, FeynArts`Particles}],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778115712007*^9, {3.4778120234797*^9, 3.4778120430657*^9}, 
   3.478434383755428*^9, 3.478435578790159*^9, 3.478435879919781*^9, 
   3.478436801285664*^9, 3.478436912149393*^9, 3.479546827897663*^9, 
   3.479547326278256*^9, 3.479547708182675*^9, 3.4978620943988867`*^9, 
   3.497862539864615*^9, 3.49787142159265*^9, 3.49794249187234*^9, 
   3.498391203987452*^9, 3.4994972935936937`*^9, 3.499519352311137*^9, 
   3.499581288167224*^9, 3.4995850366485233`*^9, 3.499585789386694*^9, 
   3.499663888450828*^9, 3.500719361362303*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
    "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes, 1 Particles \
amplitudes\"\>"}],
   SequenceForm[
   "> Top. ", 1, ": ", "1 Generic, 1 Classes, 1 Particles amplitudes"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778115712007*^9, {3.4778120234797*^9, 3.4778120430657*^9}, 
   3.478434383755428*^9, 3.478435578790159*^9, 3.478435879919781*^9, 
   3.478436801285664*^9, 3.478436912149393*^9, 3.479546827897663*^9, 
   3.479547326278256*^9, 3.479547708182675*^9, 3.4978620943988867`*^9, 
   3.497862539864615*^9, 3.49787142159265*^9, 3.49794249187234*^9, 
   3.498391203987452*^9, 3.4994972935936937`*^9, 3.499519352311137*^9, 
   3.499581288167224*^9, 3.4995850366485233`*^9, 3.499585789386694*^9, 
   3.499663888450828*^9, 3.500719361468334*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"in total: \"\>", 
    "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes, 1 Particles \
amplitudes\"\>"}],
   SequenceForm["in total: ", "1 Generic, 1 Classes, 1 Particles amplitudes"],
   
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.4778115712007*^9, {3.4778120234797*^9, 3.4778120430657*^9}, 
   3.478434383755428*^9, 3.478435578790159*^9, 3.478435879919781*^9, 
   3.478436801285664*^9, 3.478436912149393*^9, 3.479546827897663*^9, 
   3.479547326278256*^9, 3.479547708182675*^9, 3.4978620943988867`*^9, 
   3.497862539864615*^9, 3.49787142159265*^9, 3.49794249187234*^9, 
   3.498391203987452*^9, 3.4994972935936937`*^9, 3.499519352311137*^9, 
   3.499581288167224*^9, 3.4995850366485233`*^9, 3.499585789386694*^9, 
   3.499663888450828*^9, 3.500719361667344*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\</home/degrande/eta/FeynProg/FormCalc-6.2\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "FormCalc`"}]}], "Input",
 CellChangeTimes->{
  3.4777456682883*^9, {3.4778119018507*^9, 3.4778119054056997`*^9}, {
   3.4778119371527*^9, 3.4778119527257*^9}, {3.478434390853149*^9, 
   3.478434394596879*^9}, {3.498391209209569*^9, 3.4983912097170353`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.497862097715542*^9, 3.497862541299556*^9, 3.497871425757481*^9, 
  3.497942493923506*^9, 3.4983912102183523`*^9, 3.4994973038535957`*^9, 
  3.4995193551430483`*^9, 3.4995812984336*^9, 3.499585038838491*^9, 
  3.499585791759503*^9, 3.499663892956696*^9, 3.5007193633356047`*^9}],

Cell[BoxData[
 FormBox["\<\"FormCalc 6.2\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.497862097715542*^9, 3.497862541299556*^9, 3.497871425757481*^9, 
  3.497942493923506*^9, 3.4983912102183523`*^9, 3.4994973038535957`*^9, 
  3.4995193551430483`*^9, 3.4995812984336*^9, 3.499585038838491*^9, 
  3.499585791759503*^9, 3.499663892956696*^9, 3.500719363418564*^9}],

Cell[BoxData[
 FormBox["\<\"by Thomas Hahn\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.497862097715542*^9, 3.497862541299556*^9, 3.497871425757481*^9, 
  3.497942493923506*^9, 3.4983912102183523`*^9, 3.4994973038535957`*^9, 
  3.4995193551430483`*^9, 3.4995812984336*^9, 3.499585038838491*^9, 
  3.499585791759503*^9, 3.499663892956696*^9, 3.500719363578381*^9}],

Cell[BoxData[
 FormBox["\<\"last revised 11 Aug 10\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.4778119597987003`*^9, 3.4778120637597*^9, 
  3.478434395661687*^9, 3.478435582118547*^9, 3.478435888622634*^9, 
  3.478436917398712*^9, 3.479100039759344*^9, 3.479106351470136*^9, 
  3.479546849379882*^9, 3.479547331470876*^9, 3.479547710446361*^9, 
  3.497862097715542*^9, 3.497862541299556*^9, 3.497871425757481*^9, 
  3.497942493923506*^9, 3.4983912102183523`*^9, 3.4994973038535957`*^9, 
  3.4995193551430483`*^9, 3.4995812984336*^9, 3.499585038838491*^9, 
  3.499585791759503*^9, 3.499663892956696*^9, 3.500719363692773*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mqq", " ", "=", " ", 
   RowBox[{"CalcFeynAmp", "[", 
    RowBox[{"Amplqq", ",", 
     RowBox[{"FermionChains", "\[Rule]", "Chiral"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.4778119845017*^9, 3.4778120345607*^9}, {
   3.478435376938886*^9, 3.478435418868291*^9}, 3.479547358194307*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.478434402570528*^9, 3.478435422620416*^9, 
  3.478435588542779*^9, 3.478435896246393*^9, 3.478436924110362*^9, 
  3.479100051862622*^9, 3.479106355014496*^9, 3.479546852661124*^9, 
  3.479547334202314*^9, 3.479547712295999*^9, 3.497862102150838*^9, 
  3.49786254240231*^9, 3.497871427141417*^9, 3.497942495239724*^9, 
  3.498391212528688*^9, 3.499497305225618*^9, 3.49951935697228*^9, 
  3.499581300960306*^9, 3.499585040104176*^9, 3.4995857929924583`*^9, 
  3.499663894419057*^9, 3.500719364755843*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.478434402570528*^9, 3.478435422620416*^9, 
  3.478435588542779*^9, 3.478435896246393*^9, 3.478436924110362*^9, 
  3.479100051862622*^9, 3.479106355014496*^9, 3.479546852661124*^9, 
  3.479547334202314*^9, 3.479547712295999*^9, 3.497862102150838*^9, 
  3.49786254240231*^9, 3.497871427141417*^9, 3.497942495239724*^9, 
  3.498391212528688*^9, 3.499497305225618*^9, 3.49951935697228*^9, 
  3.499581300960306*^9, 3.499585040104176*^9, 3.4995857929924583`*^9, 
  3.499663894419057*^9, 3.500719364816538*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{3.478434402570528*^9, 3.478435422620416*^9, 
  3.478435588542779*^9, 3.478435896246393*^9, 3.478436924110362*^9, 
  3.479100051862622*^9, 3.479106355014496*^9, 3.479546852661124*^9, 
  3.479547334202314*^9, 3.479547712295999*^9, 3.497862102150838*^9, 
  3.49786254240231*^9, 3.497871427141417*^9, 3.497942495239724*^9, 
  3.498391212528688*^9, 3.499497305225618*^9, 3.49951935697228*^9, 
  3.499581300960306*^9, 3.499585040104176*^9, 3.4995857929924583`*^9, 
  3.499663894419057*^9, 3.500719364974832*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.478434402570528*^9, 3.478435422620416*^9, 
  3.478435588542779*^9, 3.478435896246393*^9, 3.478436924110362*^9, 
  3.479100051862622*^9, 3.479106355014496*^9, 3.479546852661124*^9, 
  3.479547334202314*^9, 3.479547712295999*^9, 3.497862102150838*^9, 
  3.49786254240231*^9, 3.497871427141417*^9, 3.497942495239724*^9, 
  3.498391212528688*^9, 3.499497305225618*^9, 3.49951935697228*^9, 
  3.499581300960306*^9, 3.499585040104176*^9, 3.4995857929924583`*^9, 
  3.499663894419057*^9, 3.500719365231838*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"col", "=", 
  RowBox[{"ColourME", "[", "Mqq", "]"}]}]], "Input",
 CellChangeTimes->{{3.478434696113564*^9, 3.478434729084623*^9}, {
  3.478435197289632*^9, 3.478435232835993*^9}, {3.478436054623279*^9, 
  3.478436055525961*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Mat", "(", 
     RowBox[{"SUN1", ",", "SUN1"}], ")"}], "\[Rule]", "3"}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.478434730426236*^9, 3.478435200749498*^9, 
  3.478435233950212*^9, 3.478435426393788*^9, 3.478435591077346*^9, 
  3.478435927320691*^9, 3.478436057790335*^9, 3.478436928353135*^9, 
  3.479100063362775*^9, 3.479106358816292*^9, 3.479546864822269*^9, 
  3.479547348022377*^9, 3.479547714372858*^9, 3.497862106256465*^9, 
  3.4978625437919207`*^9, 3.497871428686603*^9, 3.497942496752326*^9, 
  3.498391216132546*^9, 3.499497307229356*^9, 3.499519358244811*^9, 
  3.4995813029142036`*^9, 3.49958504138914*^9, 3.499585794240782*^9, 
  3.499663896091028*^9, 3.500719366287694*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"_Hel", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hel", "=", 
   RowBox[{"HelicityME", "[", "Mqq", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.478435272631223*^9, 3.478435280805309*^9}, {
   3.478435549596737*^9, 3.478435557227066*^9}, {3.478436067208497*^9, 
   3.478436071671449*^9}, {3.478436592499899*^9, 3.478436607261712*^9}, 
   3.479547354402557*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "16", 
    "\[InvisibleSpace]", "\<\" helicity matrix elements\"\>"}],
   SequenceForm["> ", 16, " helicity matrix elements"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.478435541414897*^9, 3.478435592470004*^9, 
  3.478435933573625*^9, 3.478436072748205*^9, 3.478436610903903*^9, 
  3.478436931796526*^9, 3.47910006737685*^9, 3.479106361221098*^9, 
  3.479546867343088*^9, 3.479547349361385*^9, 3.479547716089566*^9, 
  3.4978621091115437`*^9, 3.4978625446088333`*^9, 3.497871429631003*^9, 
  3.4979424987232637`*^9, 3.498391219502906*^9, 3.4994973084050283`*^9, 
  3.499519359488524*^9, 3.499581304124205*^9, 3.499585042245976*^9, 
  3.4995857953352222`*^9, 3.4996638973463507`*^9, 3.500719367222206*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.478435541414897*^9, 3.478435592470004*^9, 
  3.478435933573625*^9, 3.478436072748205*^9, 3.478436610903903*^9, 
  3.478436931796526*^9, 3.47910006737685*^9, 3.479106361221098*^9, 
  3.479546867343088*^9, 3.479547349361385*^9, 3.479547716089566*^9, 
  3.4978621091115437`*^9, 3.4978625446088333`*^9, 3.497871429631003*^9, 
  3.4979424987232637`*^9, 3.498391219502906*^9, 3.4994973084050283`*^9, 
  3.499519359488524*^9, 3.499581304124205*^9, 3.499585042245976*^9, 
  3.4995857953352222`*^9, 3.4996638973463507`*^9, 3.500719367314177*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"preparing FORM code in \"\>", 
    "\[InvisibleSpace]", \
"\<\"/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm\"\>"}],
   SequenceForm[
   "preparing FORM code in ", 
    "/nfs/home/d/degrande/eta/FeynProg/FormCalc-6.2/fc11.frm"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.478435541414897*^9, 3.478435592470004*^9, 
  3.478435933573625*^9, 3.478436072748205*^9, 3.478436610903903*^9, 
  3.478436931796526*^9, 3.47910006737685*^9, 3.479106361221098*^9, 
  3.479546867343088*^9, 3.479547349361385*^9, 3.479547716089566*^9, 
  3.4978621091115437`*^9, 3.4978625446088333`*^9, 3.497871429631003*^9, 
  3.4979424987232637`*^9, 3.498391219502906*^9, 3.4994973084050283`*^9, 
  3.499519359488524*^9, 3.499581304124205*^9, 3.499585042245976*^9, 
  3.4995857953352222`*^9, 3.4996638973463507`*^9, 3.500719367452753*^9}],

Cell["running FORM... ", "Print",
 CellChangeTimes->{3.478435541414897*^9, 3.478435592470004*^9, 
  3.478435933573625*^9, 3.478436072748205*^9, 3.478436610903903*^9, 
  3.478436931796526*^9, 3.47910006737685*^9, 3.479106361221098*^9, 
  3.479546867343088*^9, 3.479547349361385*^9, 3.479547716089566*^9, 
  3.4978621091115437`*^9, 3.4978625446088333`*^9, 3.497871429631003*^9, 
  3.4979424987232637`*^9, 3.498391219502906*^9, 3.4994973084050283`*^9, 
  3.499519359488524*^9, 3.499581304124205*^9, 3.499585042245976*^9, 
  3.4995857953352222`*^9, 3.4996638973463507`*^9, 3.500719367593958*^9}],

Cell[BoxData[
 FormBox["\<\"ok\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.478435541414897*^9, 3.478435592470004*^9, 
  3.478435933573625*^9, 3.478436072748205*^9, 3.478436610903903*^9, 
  3.478436931796526*^9, 3.47910006737685*^9, 3.479106361221098*^9, 
  3.479546867343088*^9, 3.479547349361385*^9, 3.479547716089566*^9, 
  3.4978621091115437`*^9, 3.4978625446088333`*^9, 3.497871429631003*^9, 
  3.4979424987232637`*^9, 3.498391219502906*^9, 3.4994973084050283`*^9, 
  3.499519359488524*^9, 3.499581304124205*^9, 3.499585042245976*^9, 
  3.4995857953352222`*^9, 3.4996638973463507`*^9, 3.5007193677242413`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mqq2", "=", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"SquaredME", "[", "Mqq", "]"}], "/.", "col"}], "/.", 
         "hel"}], "/.", "M$FACouplings"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Me", "\[Rule]", "0"}], ",", 
         RowBox[{"MB2", "\[Rule]", "0"}]}], "}"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Den", "[", 
         RowBox[{"a_", ",", "b_"}], "]"}], "\[Rule]", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"v", "\[Element]", "Reals"}], ",", 
        RowBox[{"Lambda", "\[Element]", "Reals"}], ",", 
        RowBox[{"sw", "\[Element]", "Reals"}], ",", 
        RowBox[{"CKM33", "\[Element]", "Reals"}]}], "}"}]}]}], "]"}], "*", 
   RowBox[{"8", "/", "3"}]}]}]], "Input",
 CellChangeTimes->{{3.478436009927547*^9, 3.478436018997932*^9}, {
   3.478436082403898*^9, 3.478436090700395*^9}, {3.478436177508675*^9, 
   3.47843618204671*^9}, {3.478437003898071*^9, 3.47843701110685*^9}, {
   3.478437477803822*^9, 3.478437504302616*^9}, {3.479106936214095*^9, 
   3.479106948049022*^9}, {3.479107333470424*^9, 3.479107353663611*^9}, 
   3.497862123314191*^9, {3.497862166292612*^9, 3.4978621787574587`*^9}, {
   3.4978624132489767`*^9, 3.497862416365185*^9}, {3.497862613296958*^9, 
   3.4978626363483677`*^9}, {3.4978627990282288`*^9, 3.497862817305622*^9}, {
   3.500719448087429*^9, 3.500719562030737*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["Lambda", "4"], " ", 
      SuperscriptBox["sw", "4"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"MW2", "-", "T12"}], ")"}], "2"]}]], 
    RowBox[{"4", " ", "Alfa", " ", "\[Pi]", " ", "S23", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["C3phiq", "\[Conjugate]"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SqrtBox["2"], " ", "EL", " ", "MT", " ", "sw", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "MT2"}], "+", "S23", "+", "T"}], ")"}], " ", "v", 
           " ", 
           SuperscriptBox["CtW", "\[Conjugate]"]}], "-", 
          RowBox[{"2", " ", "Alfa", " ", "\[Pi]", " ", 
           RowBox[{"(", 
            RowBox[{"MT2", "-", "S23"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"CKM33", " ", 
              SuperscriptBox["Lambda", "2"]}], "+", 
             RowBox[{"C3phiq", " ", 
              SuperscriptBox["v", "2"]}]}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox["v", "2"]}], "-", 
       RowBox[{"sw", " ", 
        RowBox[{"(", 
         RowBox[{"MT2", "-", "S23", "-", "T"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SqrtBox["2"], " ", "CKM33", " ", "EL", " ", "MT", " ", 
           SuperscriptBox["Lambda", "2"]}], "+", 
          RowBox[{"4", " ", "CtW", " ", "sw", " ", 
           RowBox[{"(", 
            RowBox[{"MT2", "-", "T"}], ")"}], " ", "v"}]}], ")"}], " ", 
        SuperscriptBox["CtW", "\[Conjugate]"], " ", "v"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "Alfa", " ", "CKM33", " ", "\[Pi]", " ", 
           RowBox[{"(", 
            RowBox[{"MT2", "-", "S23"}], ")"}], " ", 
           SuperscriptBox["Lambda", "2"]}], "+", 
          RowBox[{
           SqrtBox["2"], " ", "CtW", " ", "EL", " ", "MT", " ", "sw", " ", 
           RowBox[{"(", 
            RowBox[{"MT2", "-", "S23", "-", "T"}], ")"}], " ", "v"}]}], ")"}],
         " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"CKM33", " ", 
           SuperscriptBox["Lambda", "2"]}], "+", 
          RowBox[{"C3phiq", " ", 
           SuperscriptBox["v", "2"]}]}], ")"}]}]}], ")"}]}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.5007195379021997`*^9, 3.500719563018862*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SM", " ", "=", " ", 
  RowBox[{
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"Coefficient", "[", 
      RowBox[{
       RowBox[{"Mqq2", "/.", 
        RowBox[{"Lambda", "\[Rule]", 
         RowBox[{"1", "/", "Lrep"}]}]}], ",", "Lrep", ",", "0"}], "]"}], "/.",
      
     RowBox[{"Lrep", "\[Rule]", 
      RowBox[{"1", "/", "Lambda"}]}]}], "]"}], "/.", 
   RowBox[{"Alfa2", "\[Rule]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"g", "^", "2"}], "*", 
       RowBox[{
        RowBox[{
         RowBox[{"sw", "^", "2"}], "/", "4"}], "/", "\[Pi]"}]}], ")"}], "^", 
     "2"}]}]}]}]], "Input",
 CellChangeTimes->{{3.479107390301893*^9, 3.479107487977641*^9}, {
   3.497862153269348*^9, 3.4978621630633917`*^9}, {3.497862211884811*^9, 
   3.497862355442546*^9}, {3.497871464219926*^9, 3.4978714701498127`*^9}, {
   3.497872139341824*^9, 3.497872173963148*^9}, 3.497872208436336*^9, {
   3.499583028425418*^9, 3.499583029963398*^9}, {3.500719599612225*^9, 
   3.500719600555066*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    SuperscriptBox["CKM33", "2"], " ", 
    SuperscriptBox["g", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"MT2", "-", "S23"}], ")"}], " ", "S23"}], 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"MW2", "-", "T12"}], ")"}], "2"]}]], TraditionalForm]], "Output",\

 CellChangeTimes->{
  3.479107432084265*^9, {3.479107479011856*^9, 3.47910748870907*^9}, 
   3.479546898992261*^9, 3.479547373602786*^9, 3.47954772133109*^9, {
   3.49786218934586*^9, 3.4978622417535763`*^9}, {3.497862328456608*^9, 
   3.497862356340589*^9}, 3.4978624247687893`*^9, 3.497862548456053*^9, 
   3.497862603630416*^9, 3.497862643361876*^9, 3.497862823146008*^9, 
   3.497871437274989*^9, 3.497871470884967*^9, 3.497872174954796*^9, 
   3.497872208727311*^9, 3.4979425037893133`*^9, 3.4983912314140177`*^9, 
   3.4995193847168407`*^9, 3.499583030817844*^9, 3.499585057259459*^9, 
   3.499585801294929*^9, 3.4996639072089167`*^9, 3.500719374289571*^9, 
   3.500719465100717*^9, {3.500719540518568*^9, 3.50071956559111*^9}, 
   3.500719601171135*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I3phiq", "=", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Coefficient", "[", 
      RowBox[{
       RowBox[{"Mqq2", "/.", 
        RowBox[{"Lambda", "\[Rule]", 
         RowBox[{"1", "/", "Lrep"}]}]}], ",", "Lrep", ",", "2"}], "]"}], "/.",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Lrep", "\[Rule]", 
        RowBox[{"1", "/", "Lambda"}]}], ",", 
       RowBox[{"CtW", "\[Rule]", "0"}]}], "}"}]}], "]"}], "/.", 
   RowBox[{"Alfa2", "\[Rule]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"g", "^", "2"}], "*", 
       RowBox[{
        RowBox[{
         RowBox[{"sw", "^", "2"}], "/", "4"}], "/", "\[Pi]"}]}], ")"}], "^", 
     "2"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.497862652569742*^9, {3.497871477077907*^9, 3.497871482621311*^9}, {
   3.4978715422628403`*^9, 3.497871560455545*^9}, 3.497872247138032*^9, {
   3.499583044715734*^9, 3.499583062852566*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"CKM33", " ", 
    SuperscriptBox["g", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"MT2", "-", "S23"}], ")"}], " ", "S23", " ", 
    SuperscriptBox["v", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"C3phiq", "+", 
      SuperscriptBox["C3phiq", "\[Conjugate]"]}], ")"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"MW2", "-", "T12"}], ")"}], "2"]}]], TraditionalForm]], "Output",\

 CellChangeTimes->{3.4978626530863867`*^9, 3.497862825140256*^9, 
  3.497871484101454*^9, 3.49787152665973*^9, 3.497871560798565*^9, 
  3.497872248273581*^9, 3.4979425057500362`*^9, 3.498391234071066*^9, 
  3.499519394231093*^9, 3.4995830634001207`*^9, 3.4995850606342154`*^9, 
  3.4995858041433764`*^9, 3.4996639129696493`*^9, 3.500719376158753*^9, 
  3.500719587933814*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"I3phiq", "/", "SM"}], "]"}]], "Input",
 CellChangeTimes->{{3.499583066599391*^9, 3.49958307954329*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    SuperscriptBox["v", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"C3phiq", "+", 
      SuperscriptBox["C3phiq", "\[Conjugate]"]}], ")"}]}], "CKM33"], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.499583081627861*^9, 3.499585063949625*^9, 
  3.499585805876174*^9, 3.4996639162425528`*^9, 3.500719377583383*^9, 
  3.500719605979908*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ItW", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"Mqq2", "/.", 
         RowBox[{"Lambda", "\[Rule]", 
          RowBox[{"1", "/", "Lrep"}]}]}], ",", "Lrep", ",", "2"}], "]"}], "/.",
       
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Lrep", "\[Rule]", 
         RowBox[{"1", "/", "Lambda"}]}], ",", 
        RowBox[{"C3phiq", "\[Rule]", "0"}]}], "}"}]}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Alfa2", "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"g", "^", "2"}], "*", 
          RowBox[{
           RowBox[{
            RowBox[{"sw", "^", "2"}], "/", "4"}], "/", "\[Pi]"}]}], ")"}], 
        "^", "2"}]}], ",", 
      RowBox[{"Alfa", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"g", "^", "2"}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"sw", "^", "2"}], "/", "4"}], "/", "\[Pi]"}]}], ")"}]}]}], 
     "}"}]}], "/.", 
   RowBox[{"v", "\[Rule]", 
    RowBox[{"2", "MW", " ", 
     RowBox[{"sw", "/", "EL"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.497871610887577*^9, 3.497871617629863*^9}, {
  3.497872251640006*^9, 3.49787227096323*^9}, {3.4978725133447638`*^9, 
  3.497872535294683*^9}, {3.499663979418893*^9, 3.499663988427759*^9}, {
  3.500719691758853*^9, 3.500719693379096*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{"4", " ", 
     SqrtBox["2"], " ", "CKM33", " ", 
     SuperscriptBox["g", "2"], " ", "MT", " ", "MW", " ", "S23", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "MT2"}], "+", "S23", "+", "T"}], ")"}], " ", 
     RowBox[{"Re", "(", "CtW", ")"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"MW2", "-", "T12"}], ")"}], "2"]]}], TraditionalForm]], "Output",\

 CellChangeTimes->{
  3.497871619084063*^9, {3.497872252601283*^9, 3.4978722716892776`*^9}, 
   3.497872536191465*^9, 3.49794250746635*^9, 3.498391237200657*^9, 
   3.499519423782421*^9, 3.499585068734769*^9, 3.499585808060615*^9, 
   3.4996639310888157`*^9, 3.499663989282805*^9, 3.500719383943447*^9, 
   3.500719609754578*^9, 3.500719694107739*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1269, 941},
WindowMargins->{{0, Automatic}, {Automatic, 27}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{611.25, 789.5625},
"PostScriptOutputFile"->"/nfs/home/0/d/degrande/Generic/test.nb.ps"},
ShowSelection->True,
Magnification->1.25,
FrontEndVersion->"6.0 for Linux x86 (64-bit) (June 19, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 100, 1, 104, "Title"],
Cell[693, 26, 170, 2, 37, "Text"],
Cell[CellGroupData[{
Cell[888, 32, 141, 2, 65, "Subtitle"],
Cell[1032, 36, 118, 2, 38, "Input"],
Cell[CellGroupData[{
Cell[1175, 42, 317, 8, 64, "Input"],
Cell[CellGroupData[{
Cell[1517, 54, 901, 14, 30, "Print"],
Cell[2421, 70, 913, 14, 30, "Print"],
Cell[3337, 86, 949, 15, 30, "Print"],
Cell[4289, 103, 923, 14, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[5239, 121, 387, 9, 38, "Input"],
Cell[CellGroupData[{
Cell[5651, 134, 127, 2, 38, "Input"],
Cell[CellGroupData[{
Cell[5803, 140, 354, 8, 71, "Print"],
Cell[6160, 150, 353, 8, 71, "Print"],
Cell[6516, 160, 353, 8, 71, "Print"],
Cell[6872, 170, 354, 8, 71, "Print"],
Cell[7229, 180, 4877, 117, 1231, "Print"]
}, Closed]],
Cell[12121, 300, 1998, 56, 187, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[14156, 361, 1736, 37, 81, "Input"],
Cell[CellGroupData[{
Cell[15917, 402, 907, 14, 30, "Print"],
Cell[16827, 418, 1380, 26, 30, "Print"],
Cell[18210, 446, 927, 14, 30, "Print"],
Cell[19140, 462, 1192, 21, 30, "Print"],
Cell[20335, 485, 907, 14, 30, "Print"],
Cell[21245, 501, 1378, 26, 30, "Print"],
Cell[22626, 529, 1226, 21, 30, "Print"],
Cell[23855, 552, 929, 14, 30, "Print"],
Cell[24787, 568, 1083, 19, 30, "Print"],
Cell[25873, 589, 1192, 21, 30, "Print"],
Cell[27068, 612, 907, 14, 30, "Print"],
Cell[27978, 628, 1310, 23, 30, "Print"],
Cell[29291, 653, 909, 14, 30, "Print"],
Cell[30203, 669, 1194, 22, 30, "Print"],
Cell[31400, 693, 1209, 22, 30, "Print"],
Cell[32612, 717, 1211, 22, 30, "Print"],
Cell[33826, 741, 1209, 22, 30, "Print"],
Cell[35038, 765, 1208, 22, 30, "Print"],
Cell[36249, 789, 907, 14, 30, "Print"],
Cell[37159, 805, 1310, 23, 30, "Print"],
Cell[38472, 830, 1140, 21, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39661, 857, 225, 4, 38, "Input"],
Cell[CellGroupData[{
Cell[39911, 865, 586, 12, 30, "Print"],
Cell[40500, 879, 15706, 357, 505, "Print"]
}, Open  ]],
Cell[56221, 1239, 2384, 60, 79, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58642, 1304, 318, 6, 38, "Input"],
Cell[CellGroupData[{
Cell[58985, 1314, 619, 10, 30, "Print"],
Cell[59607, 1326, 925, 18, 30, "Print"],
Cell[60535, 1346, 921, 18, 30, "Print"],
Cell[61459, 1366, 852, 17, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[62360, 1389, 431, 9, 64, "Input"],
Cell[CellGroupData[{
Cell[62816, 1402, 615, 9, 30, "Print"],
Cell[63434, 1413, 625, 9, 30, "Print"],
Cell[64062, 1424, 627, 9, 30, "Print"],
Cell[64692, 1435, 635, 9, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[65376, 1450, 334, 8, 38, "Input"],
Cell[CellGroupData[{
Cell[65735, 1462, 587, 9, 30, "Print"],
Cell[66325, 1473, 873, 17, 30, "Print"],
Cell[67201, 1492, 558, 8, 30, "Print"],
Cell[67762, 1502, 589, 9, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[68400, 1517, 252, 5, 38, "Input"],
Cell[68655, 1524, 773, 15, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69465, 1544, 420, 9, 64, "Input"],
Cell[CellGroupData[{
Cell[69910, 1557, 824, 14, 30, "Print"],
Cell[70737, 1573, 620, 9, 30, "Print"],
Cell[71360, 1584, 906, 17, 30, "Print"],
Cell[72269, 1603, 591, 8, 30, "Print"],
Cell[72863, 1613, 624, 9, 30, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[73536, 1628, 1655, 39, 64, "Input"],
Cell[75194, 1669, 2464, 66, 120, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[77695, 1740, 1035, 27, 38, "Input"],
Cell[78733, 1769, 1104, 24, 64, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[79874, 1798, 945, 28, 64, "Input"],
Cell[80822, 1828, 839, 21, 66, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81698, 1854, 155, 3, 38, "Input"],
Cell[81856, 1859, 394, 11, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82287, 1875, 1426, 42, 64, "Input"],
Cell[83716, 1919, 802, 20, 67, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
