(* ::Package:: *)

(*
run
math -initfile bnv_mediator.m
having set
$Path = Join[{ToFileName[$HomeDirectory, ".../feynrules-current"]}, $Path]
$FeynRulesPath = ToFileName[$HomeDirectory, ".../feynrules-current"]
in ~/.Mathematica/Kernel/init.m
*)


<<FeynRules`
LoadModel[ ToFileName[$FeynRulesPath,"Models/SM/SM.fr"],"bnv_mediator.fr"];
LoadRestriction[
	ToFileName[$FeynRulesPath,"Models/SM/Massless.rst"],
	ToFileName[$FeynRulesPath,"Models/SM/DiagonalCKM.rst"]
	];


SetOptions[FeynmanRules,ConservedQuantumNumbers->False];
SetOptions[WriteUFO,ConservedQuantumNumbers->False];

WriteUFO[LBNV+LSM,
	Output->"../bnv_mediator_ufo",
	FlavorExpand->True];
	
Exit[];
