(**************************************************************)
(*	This is the FeynRules mod-file for			*)
(*		an ad-hoc scalar model generating		*)
(*		B-violating operators satisfying SM symmetries*)
(*								*)
(*	! heavy scalar mass fixed to 1 * 10^(6) GeV		*)
(**************************************************************)

M$ModelName = "bnv_mediator";
M$Information = 
{
	Authors -> {"Gauthier Durieux"},
	Version -> "1.1",
	Date -> "2022-01-21",
	Institutions -> {"CERN"},
	Emails -> {"gauthier.durieux@cern.ch"},
	URLs -> "https://feynrules.irmp.ucl.ac.be/wiki/TopBNV"
};

(****************  Parameters *************)

M$Parameters = {
	Lambda	==	{
		ParameterType -> External,
		ComplexParameter -> False,
		BlockName	->	BNV,
		Value 		-> 1000.
	},
	aaa ==	{
		ParameterType -> External,
		ComplexParameter -> False,
		InteractionOrder -> {BNV, 1},
		BlockName	->	BNVaaa,
		Indices	->	{Index[Generation], Index[Generation]},
		Value		->	{aaa[i_?NumericQ, j_?NumericQ]->0}
	},
	bbb ==	{
		ParameterType -> External,
		ComplexParameter -> False,
		InteractionOrder -> {BNV, 1},
		BlockName	->	BNVbbb,
		Indices	->	{Index[Generation], Index[Generation]},
		Value		->	{bbb[i_?NumericQ, j_?NumericQ]->0}
	},
	ccc	==	{
		ParameterType -> External,
		ComplexParameter -> False,
		InteractionOrder -> {BNV, 1},
		BlockName	->	BNVccc,
		Indices	->	{Index[Generation], Index[Generation]},
		Value		->	{ccc[i_?NumericQ, j_?NumericQ]->0}
	},
	ddd	==	{
		ParameterType -> External,
		ComplexParameter -> False,
		InteractionOrder -> {BNV, 1},
		BlockName	->	BNVddd,
		Indices	->	{Index[Generation], Index[Generation]},
		Value		->	{ddd[i_?NumericQ, j_?NumericQ]->0}
	},
	aaaprime	==	{
		ParameterType -> External,
		ComplexParameter -> False,
		InteractionOrder -> {BNV, 1},
		BlockName	->	BNVaaaprime,
		Indices	->	{Index[Generation], Index[Generation]},
		Value		->	{aaaprime[i_?NumericQ, j_?NumericQ]->0}
	},
	bbbprime	==	{
        	ParameterType -> External,
		ComplexParameter -> False,
		InteractionOrder -> {BNV, 1},
		BlockName	->	BNVbbbprime,
		Indices	->	{Index[Generation], Index[Generation]},
		Value		->	{bbbprime[i_?NumericQ, j_?NumericQ]->0}
	},
	cccprime	==	{
		ParameterType -> External,
		ComplexParameter -> False,
		InteractionOrder -> {BNV, 1},
		BlockName	->	BNVcccprime,
		Indices	->	{Index[Generation], Index[Generation]},
		Value		->	{cccprime[i_?NumericQ, j_?NumericQ]->0}
	},
	dddprime	==	{
		ParameterType -> External,
		ComplexParameter -> False,
		InteractionOrder -> {BNV, 1},
		BlockName	->	BNVdddprime,
		Indices	->	{Index[Generation], Index[Generation]},
		Value		->	{dddprime[i_?NumericQ, j_?NumericQ]->0}
	}
}

(********* Particle Classes **********)
M$ClassesDescription = {
	(* Q = 1/3 scalar *) 
	S[4] ==	{
		ClassName	->	X,
		SelfConjugate	->	False,
		Indices	->	{Index[Colour]},
		Mass		->	{MX, 10^(6)},
		Width		->	0,
		QuantumNumbers	->	{Q	->	-1/3},
		PropagatorType	->	ScalarDash,
		PropagatorArrow ->	True,
		PDG		->	{1011},
		FullName	->	"Q = -1/3 scalar"
	}
}

(********* Lagrangian **********)

(* The fermionic currents *)
J[gamma_ ]	:=	Module[ {ss, cc, alpha, beta},
	(aaa[3,cc]*CC[ left[uqbar[ss, 3, alpha]]].left[ dq[ss, cc, beta]] + 
	 bbb[3,cc]*CC[right[uqbar[ss, 3, alpha]]].right[dq[ss, cc, beta]] )*
	Eps[alpha, beta, gamma] *
	MX / Lambda
];
JStar[gamma_ ]	:=	Module[ {s, aa, b},
	(ccc[aa, bb]*CC[ left[uqbar[ss, aa, gamma]]].left[ l[ss, bb]] +
	 ddd[aa, bb]*CC[right[uqbar[ss, aa, gamma]]].right[l[ss, bb]] )*
	MX / Lambda
];


K[alpha_ ]	:=	Module[ {s, c},
	(aaaprime[3,cc]*CC[ left[uqbar[ss, 3, alpha]]].left[ l[ss, cc]]  + 
	 bbbprime[3,cc]*CC[right[uqbar[ss, 3, alpha]]].right[l[ss, cc]]  )*
	MX / Lambda
];
KStar[alpha_ ]	:=	Module[ {s, aa, b, beta, gamma},
	(cccprime[aa, bb]*CC[ left[uqbar[ss, aa, beta]]].left[ dq[ss, bb, gamma]] +
	 dddprime[aa, bb]*CC[right[uqbar[ss, aa, beta]]].right[dq[ss, bb, gamma]] )*
	Eps[alpha, beta, gamma] *
	MX / Lambda
];


(* The interaction Lagrangian *)
Lyuk:=	X[gamma]		J[gamma]+
	HC[X[gamma]]		JStar[gamma]+
	HC[X[alpha]]		K[alpha]+
	X[alpha]		KStar[alpha] ;

(*********Total Lagrangian*******)	 	
LBNV := Lyuk+HC[Lyuk];
