(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    120062,       2432]
NotebookOptionsPosition[    106369,       2221]
NotebookOutlinePosition[    106747,       2238]
CellTagsIndexPosition[    106704,       2235]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.4921467751527157`*^9, 3.492146776183146*^9}, {
  3.569655655299555*^9, 
  3.569655656468893*^9}},ExpressionUUID->"9a9eddcf-a65b-48d3-9c0a-\
530dbabf8851"],

Cell[CellGroupData[{

Cell["Setting a Path", "Subsubsection",
 CellChangeTimes->{{3.578382355069495*^9, 3.578382356090843*^9}, {
  3.675606814001116*^9, 3.675606817526205*^9}, {3.740986929612624*^9, 
  3.7409869325222063`*^9}},ExpressionUUID->"2236e9e3-ce4b-4c63-8b1d-\
8fe1e0b7052f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$FeynRulesPath", "=", 
  RowBox[{
  "SetDirectory", "[", "\"\</Users/Han/feynrules-current_2\>\"", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
  3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
  3.4234163227881193`*^9}, {3.569593920256028*^9, 3.5695939561647587`*^9}, {
  3.57353128307874*^9, 3.573531291530204*^9}, {3.57353134365405*^9, 
  3.573531385685854*^9}, {3.5735317694380817`*^9, 3.573531782019915*^9}, {
  3.5922113808532763`*^9, 3.592211412881894*^9}, {3.5925564077909718`*^9, 
  3.5925564136209*^9}, {3.675605754576425*^9, 3.675605758128098*^9}, {
  3.740983025238201*^9, 
  3.7409830370296097`*^9}},ExpressionUUID->"34783483-4100-4d33-a9bf-\
6009fae692b7"],

Cell[BoxData["\<\"/Users/Han/feynrules-current_2\"\>"], "Output",
 CellChangeTimes->{
  3.573879501788704*^9, 3.57831355008143*^9, 3.5783154778528423`*^9, 
   3.578354969924489*^9, 3.578355753610523*^9, 3.5783598444520607`*^9, 
   3.578360252968184*^9, 3.578360606299459*^9, 3.578360713623214*^9, 
   3.578364021530334*^9, 3.578364260637825*^9, 3.578364529925997*^9, 
   3.5783648962760153`*^9, 3.57836590304775*^9, 3.5783661548486443`*^9, 
   3.578366380142478*^9, 3.578366822472226*^9, 3.578367028922147*^9, 
   3.578367834950704*^9, 3.578368066611207*^9, 3.578368487953837*^9, 
   3.578369158254409*^9, {3.578369381256175*^9, 3.578369392223258*^9}, 
   3.5783707067486973`*^9, 3.578370983523628*^9, 3.578371129165917*^9, 
   3.578371462179497*^9, 3.578371928307959*^9, 3.578375921097824*^9, 
   3.5783765882508287`*^9, 3.578376793329894*^9, 3.578377050928402*^9, 
   3.578377334206471*^9, 3.5783778537935038`*^9, {3.578378365139114*^9, 
   3.578378372679097*^9}, 3.578379331600116*^9, 3.578381988099574*^9, 
   3.578382361579468*^9, 3.578383500794579*^9, 3.5783906893387537`*^9, 
   3.578393158114304*^9, 3.5783932232729692`*^9, 3.5783937158882227`*^9, 
   3.578393828066988*^9, 3.5783940061134443`*^9, 3.578394100151807*^9, 
   3.578394222932344*^9, 3.578394319767742*^9, 3.578394382443565*^9, 
   3.578396444375806*^9, 3.5783966429222107`*^9, 3.57839710375823*^9, 
   3.578454764957678*^9, 3.578454881021104*^9, 3.5800026737639637`*^9, {
   3.5800027076309566`*^9, 3.580002721746533*^9}, 3.580002941831051*^9, 
   3.580003099494595*^9, 3.5800032055253277`*^9, 3.580003245754045*^9, 
   3.580003307687833*^9, 3.580003380724359*^9, 3.5800034378354*^9, 
   3.580003804230142*^9, 3.580003965312114*^9, 3.5800040979542933`*^9, 
   3.5800102233884*^9, 3.580010400498232*^9, 3.580010783339333*^9, 
   3.580010845088707*^9, 3.580010931657948*^9, 3.580011026602125*^9, 
   3.5800111264199133`*^9, 3.5800111660119963`*^9, 3.580011212370987*^9, 
   3.580011273248681*^9, 3.580012164958866*^9, 3.58001269186436*^9, 
   3.5800129496321774`*^9, 3.590450512307303*^9, 3.590450767108445*^9, 
   3.590716845944804*^9, 3.590717936569585*^9, 3.590718434251587*^9, 
   3.590718668469211*^9, 3.590719202662074*^9, 3.590734312660626*^9, 
   3.590735886977797*^9, 3.590736211635819*^9, 3.5907376780570908`*^9, 
   3.590746494627097*^9, 3.590812523905909*^9, 3.591482326578474*^9, 
   3.5914831169381647`*^9, 3.5914831596298037`*^9, 3.591495126722907*^9, {
   3.592211406450739*^9, 3.5922114136647243`*^9}, 3.592218649458314*^9, 
   3.592296522510178*^9, 3.592467218040882*^9, 3.59247860620679*^9, 
   3.592556421020809*^9, 3.594025367921008*^9, {3.60100927030669*^9, 
   3.601009291117422*^9}, 3.601014824083036*^9, {3.601420185267074*^9, 
   3.6014202180180893`*^9}, 3.6014203447787027`*^9, 3.60145468380961*^9, 
   3.601454929584209*^9, 3.601454974926536*^9, 3.601455132046113*^9, 
   3.6014552191851597`*^9, 3.6017866169614697`*^9, 3.6017870259542828`*^9, 
   3.6063946086887712`*^9, 3.606395657596521*^9, 3.644794158715912*^9, 
   3.644794942644308*^9, 3.644796887272855*^9, 3.675605760940153*^9, 
   3.675606836334063*^9, {3.740983009870482*^9, 3.740983041225761*^9}, 
   3.740984573599008*^9, 3.7409849219772043`*^9, 3.740985662368744*^9, 
   3.7409860316535873`*^9, 
   3.740989056609584*^9},ExpressionUUID->"34ce306e-d9c2-4e3e-afdc-\
4faee60d93da"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "FeynRules`"}]], "Input",ExpressionUUID->"6c55d96c-63b8-4f9e-9cde-0ae49829d043"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{3.7409830430822563`*^9, 3.7409845742452602`*^9, 
  3.74098492247499*^9, 3.740985663612544*^9, 3.740986031770698*^9, 
  3.740989057160656*^9},ExpressionUUID->"2fc5e2ef-ddc7-4024-b0d9-\
7c5707952857"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.22\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"04 May 2016\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.22", " (" "04 May 2016", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7409830430822563`*^9, 3.7409845742452602`*^9, 
  3.74098492247499*^9, 3.740985663612544*^9, 3.740986031770698*^9, 
  3.740989057170556*^9},ExpressionUUID->"31ee9abb-3028-4b85-bc29-\
6f8e19dd5fea"],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{3.7409830430822563`*^9, 3.7409845742452602`*^9, 
  3.74098492247499*^9, 3.740985663612544*^9, 3.740986031770698*^9, 
  3.740989057180182*^9},ExpressionUUID->"c121ac54-2ac0-450e-b803-\
ccbbe041a760"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.7409830430822563`*^9, 3.7409845742452602`*^9, 
  3.74098492247499*^9, 3.740985663612544*^9, 3.740986031770698*^9, 
  3.740989057190007*^9},ExpressionUUID->"c8a9f754-7215-4a57-8fd5-\
a0fd87034c4a"],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{3.7409830430822563`*^9, 3.7409845742452602`*^9, 
  3.74098492247499*^9, 3.740985663612544*^9, 3.740986031770698*^9, 
  3.740989057199719*^9},ExpressionUUID->"7d3ef03f-45bd-4afa-943d-\
34f3c17bd2dd"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{3.7409830430822563`*^9, 3.7409845742452602`*^9, 
  3.74098492247499*^9, 3.740985663612544*^9, 3.740986031770698*^9, 
  3.740989057209261*^9},ExpressionUUID->"9a028a0f-ea3c-473b-9437-\
484b205c9b95"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{3.7409830430822563`*^9, 3.7409845742452602`*^9, 
  3.74098492247499*^9, 3.740985663612544*^9, 3.740986031770698*^9, 
  3.740989057218957*^9},ExpressionUUID->"0e3b617a-81c6-495c-8834-\
e9c840805c44"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.7409830430822563`*^9, 3.7409845742452602`*^9, 
  3.74098492247499*^9, 3.740985663612544*^9, 3.740986031770698*^9, 
  3.74098905722861*^9},ExpressionUUID->"f4031b3f-736f-469c-834d-1aeebb72e386"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{3.7409830430822563`*^9, 3.7409845742452602`*^9, 
  3.74098492247499*^9, 3.740985663612544*^9, 3.740986031770698*^9, 
  3.740989057238248*^9},ExpressionUUID->"af075ea8-5aa8-41d8-985e-\
b71e52d97c4b"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.7409830430822563`*^9, 3.7409845742452602`*^9, 
  3.74098492247499*^9, 3.740985663612544*^9, 3.740986031770698*^9, 
  3.7409890572477007`*^9},ExpressionUUID->"44550818-0329-4d44-9ce1-\
81a037fa2976"],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{3.7409830430822563`*^9, 3.7409845742452602`*^9, 
  3.74098492247499*^9, 3.740985663612544*^9, 3.740986031770698*^9, 
  3.7409890572577763`*^9},ExpressionUUID->"9d0292fc-cd24-4c26-9d7d-\
c33e41202317"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/Top_Philic\>\""}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.419073170860696*^9, 3.419073182827229*^9}, {
   3.5695939666521587`*^9, 3.569593975189637*^9}, {3.571998624557815*^9, 
   3.571998628157531*^9}, {3.5722426658955507`*^9, 3.5722426665661163`*^9}, {
   3.573879374917307*^9, 3.573879376357258*^9}, {3.578313558977684*^9, 
   3.578313577671748*^9}, {3.5783958510376463`*^9, 3.578395852019607*^9}, {
   3.57845474229674*^9, 3.57845474238172*^9}, {3.580002678626459*^9, 
   3.58000268068469*^9}, {3.58001269859027*^9, 3.580012698716407*^9}, {
   3.580012953536817*^9, 3.580012954384448*^9}, {3.590450576207986*^9, 
   3.590450580073546*^9}, 3.5914823222094383`*^9, {3.591495102494793*^9, 
   3.5914951043532743`*^9}, {3.591502813763657*^9, 3.5915028139718447`*^9}, {
   3.592211456187504*^9, 3.592211456681547*^9}, {3.601009303079486*^9, 
   3.601009308809808*^9}, {3.6014546991792994`*^9, 3.601454701850648*^9}, {
   3.644794475707807*^9, 3.644794476878982*^9}, {3.644794950026976*^9, 
   3.644794955044138*^9}},ExpressionUUID->"5a8df67e-cb24-4d05-8d54-\
a0955363ae47"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Model", "Title",
 CellChangeTimes->{{3.569657484010581*^9, 3.5696574842398787`*^9}, {
  3.675606226913138*^9, 
  3.6756062277029867`*^9}},ExpressionUUID->"2af559c6-f0b3-41c3-bdab-\
f227e6962e9c"],

Cell[TextData[StyleBox["Based on arXiv:1604.07421",
 FontWeight->"Bold",
 FontColor->RGBColor[1, 0, 0]]], "Text",
 CellChangeTimes->{{3.740986942357329*^9, 
  3.74098694809825*^9}},ExpressionUUID->"a8b3c9c0-90bb-4471-ae50-\
acebbac792c6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadModel", "[", 
  RowBox[{"\"\<SM.fr\>\"", ",", "\"\<Top_Philic.fr\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.5914823628501673`*^9, 3.5914823648460817`*^9}, {
   3.591483062085964*^9, 3.591483080533391*^9}, {3.591483137199366*^9, 
   3.5914831528553057`*^9}, {3.591495112219393*^9, 3.591495114242382*^9}, {
   3.5915028172845383`*^9, 3.591502817395191*^9}, {3.592138550162439*^9, 
   3.5921385515508413`*^9}, {3.59221155842371*^9, 3.592211558735021*^9}, 
   3.592218659046937*^9, {3.5924672329863853`*^9, 3.592467243914006*^9}, {
   3.601014731996669*^9, 3.601014735058919*^9}, 3.601420231831354*^9, {
   3.601454713322173*^9, 3.601454720635404*^9}, {3.606394619637165*^9, 
   3.606394620164872*^9}, {3.64479497404101*^9, 3.6447949895066833`*^9}, {
   3.6447967889582443`*^9, 3.644796818852543*^9}, {3.6756058298610697`*^9, 
   3.67560583280477*^9}, 3.675606823592696*^9, 
   3.740984587976025*^9},ExpressionUUID->"3fa72bc5-b536-41d7-93cb-\
c58c2299ca2d"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{
  3.60145516248629*^9, 3.6014552492063713`*^9, 3.601786657559167*^9, 
   3.601787055416771*^9, 3.6063946400865517`*^9, 3.606395682141714*^9, 
   3.644794187954862*^9, 3.644794991447109*^9, {3.644796873429204*^9, 
   3.6447968991720467`*^9}, 3.675605833929427*^9, {3.67560682744254*^9, 
   3.6756068420846653`*^9}, 3.7409830693146772`*^9, 3.740984588914421*^9, 
   3.740984931208309*^9, 3.740985670513588*^9, 3.740986038373316*^9, 
   3.7409890647218323`*^9},ExpressionUUID->"888052b3-b002-4c10-9559-\
83bb9f262f81"],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{
  3.60145516248629*^9, 3.6014552492063713`*^9, 3.601786657559167*^9, 
   3.601787055416771*^9, 3.6063946400865517`*^9, 3.606395682141714*^9, 
   3.644794187954862*^9, 3.644794991447109*^9, {3.644796873429204*^9, 
   3.6447968991720467`*^9}, 3.675605833929427*^9, {3.67560682744254*^9, 
   3.6756068420846653`*^9}, 3.7409830693146772`*^9, 3.740984588914421*^9, 
   3.740984931208309*^9, 3.740985670513588*^9, 3.740986038373316*^9, 
   3.74098906473146*^9},ExpressionUUID->"03fdbfa7-e1dc-464f-8f64-\
6530995bd30f"],

Cell[BoxData["\<\"Jeong Han Kim\"\>"], "Print",
 CellChangeTimes->{
  3.60145516248629*^9, 3.6014552492063713`*^9, 3.601786657559167*^9, 
   3.601787055416771*^9, 3.6063946400865517`*^9, 3.606395682141714*^9, 
   3.644794187954862*^9, 3.644794991447109*^9, {3.644796873429204*^9, 
   3.6447968991720467`*^9}, 3.675605833929427*^9, {3.67560682744254*^9, 
   3.6756068420846653`*^9}, 3.7409830693146772`*^9, 3.740984588914421*^9, 
   3.740984931208309*^9, 3.740985670513588*^9, 3.740986038373316*^9, 
   3.740989064741556*^9},ExpressionUUID->"4ac7dfae-1db3-494a-8280-\
74efc7eb5fc0"],

Cell[BoxData["\<\"G. Mohlabeng\"\>"], "Print",
 CellChangeTimes->{
  3.60145516248629*^9, 3.6014552492063713`*^9, 3.601786657559167*^9, 
   3.601787055416771*^9, 3.6063946400865517`*^9, 3.606395682141714*^9, 
   3.644794187954862*^9, 3.644794991447109*^9, {3.644796873429204*^9, 
   3.6447968991720467`*^9}, 3.675605833929427*^9, {3.67560682744254*^9, 
   3.6756068420846653`*^9}, 3.7409830693146772`*^9, 3.740984588914421*^9, 
   3.740984931208309*^9, 3.740985670513588*^9, 3.740986038373316*^9, 
   3.7409890647530813`*^9},ExpressionUUID->"71be5579-bde9-40f7-bbdf-\
b4fc5088c301"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0.0\"\>"}],
  SequenceForm["Model Version: ", "1.0.0"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.60145516248629*^9, 3.6014552492063713`*^9, 3.601786657559167*^9, 
   3.601787055416771*^9, 3.6063946400865517`*^9, 3.606395682141714*^9, 
   3.644794187954862*^9, 3.644794991447109*^9, {3.644796873429204*^9, 
   3.6447968991720467`*^9}, 3.675605833929427*^9, {3.67560682744254*^9, 
   3.6756068420846653`*^9}, 3.7409830693146772`*^9, 3.740984588914421*^9, 
   3.740984931208309*^9, 3.740985670513588*^9, 3.740986038373316*^9, 
   3.740989064762763*^9},ExpressionUUID->"508bf887-0572-415a-ba12-\
30ca09d1104e"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{
  3.60145516248629*^9, 3.6014552492063713`*^9, 3.601786657559167*^9, 
   3.601787055416771*^9, 3.6063946400865517`*^9, 3.606395682141714*^9, 
   3.644794187954862*^9, 3.644794991447109*^9, {3.644796873429204*^9, 
   3.6447968991720467`*^9}, 3.675605833929427*^9, {3.67560682744254*^9, 
   3.6756068420846653`*^9}, 3.7409830693146772`*^9, 3.740984588914421*^9, 
   3.740984931208309*^9, 3.740985670513588*^9, 3.740986038373316*^9, 
   3.740989064773342*^9},ExpressionUUID->"444fa0cc-9ef8-479e-9049-\
2054e1b7f8a3"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.60145516248629*^9, 3.6014552492063713`*^9, 3.601786657559167*^9, 
   3.601787055416771*^9, 3.6063946400865517`*^9, 3.606395682141714*^9, 
   3.644794187954862*^9, 3.644794991447109*^9, {3.644796873429204*^9, 
   3.6447968991720467`*^9}, 3.675605833929427*^9, {3.67560682744254*^9, 
   3.6756068420846653`*^9}, 3.7409830693146772`*^9, 3.740984588914421*^9, 
   3.740984931208309*^9, 3.740985670513588*^9, 3.740986038373316*^9, 
   3.7409890647830467`*^9},ExpressionUUID->"a37ba8f7-7b39-4f48-88ea-\
92a91ab34835"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{
  3.60145516248629*^9, 3.6014552492063713`*^9, 3.601786657559167*^9, 
   3.601787055416771*^9, 3.6063946400865517`*^9, 3.606395682141714*^9, 
   3.644794187954862*^9, 3.644794991447109*^9, {3.644796873429204*^9, 
   3.6447968991720467`*^9}, 3.675605833929427*^9, {3.67560682744254*^9, 
   3.6756068420846653`*^9}, 3.7409830693146772`*^9, 3.740984588914421*^9, 
   3.740984931208309*^9, 3.740985670513588*^9, 3.740986038373316*^9, 
   3.740989064792671*^9},ExpressionUUID->"6bc8a473-59ab-47c9-9a26-\
1d7d4a01b0fd"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{
  3.60145516248629*^9, 3.6014552492063713`*^9, 3.601786657559167*^9, 
   3.601787055416771*^9, 3.6063946400865517`*^9, 3.606395682141714*^9, 
   3.644794187954862*^9, 3.644794991447109*^9, {3.644796873429204*^9, 
   3.6447968991720467`*^9}, 3.675605833929427*^9, {3.67560682744254*^9, 
   3.6756068420846653`*^9}, 3.7409830693146772`*^9, 3.740984588914421*^9, 
   3.740984931208309*^9, 3.740985670513588*^9, 3.740986038373316*^9, 
   3.740989064841514*^9},ExpressionUUID->"fc5bbc4e-c88e-458a-86d3-\
bd588d322a74"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{
  3.60145516248629*^9, 3.6014552492063713`*^9, 3.601786657559167*^9, 
   3.601787055416771*^9, 3.6063946400865517`*^9, 3.606395682141714*^9, 
   3.644794187954862*^9, 3.644794991447109*^9, {3.644796873429204*^9, 
   3.6447968991720467`*^9}, 3.675605833929427*^9, {3.67560682744254*^9, 
   3.6756068420846653`*^9}, 3.7409830693146772`*^9, 3.740984588914421*^9, 
   3.740984931208309*^9, 3.740985670513588*^9, 3.740986038373316*^9, 
   3.740989064851119*^9},ExpressionUUID->"62624519-56c8-4b49-ac46-\
caa044b25786"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"Top_Philic\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "Top_Philic", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.60145516248629*^9, 3.6014552492063713`*^9, 3.601786657559167*^9, 
   3.601787055416771*^9, 3.6063946400865517`*^9, 3.606395682141714*^9, 
   3.644794187954862*^9, 3.644794991447109*^9, {3.644796873429204*^9, 
   3.6447968991720467`*^9}, 3.675605833929427*^9, {3.67560682744254*^9, 
   3.6756068420846653`*^9}, 3.7409830693146772`*^9, 3.740984588914421*^9, 
   3.740984931208309*^9, 3.740985670513588*^9, 3.740986038373316*^9, 
   3.740989064948797*^9},ExpressionUUID->"8ee1dc0d-932f-473a-ac75-\
09ec41442531"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"LoadRestriction", "[", 
   RowBox[{
   "\"\<Cabibbo.rst\>\"", ",", "\"\<Massless.rst\>\"", ",", 
    "\"\<DiagonalCKM.rst\>\""}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.453790588503598*^9, 3.4537906008856297`*^9}, {
  3.569594098070581*^9, 3.5695941074665422`*^9}, {3.592556510623576*^9, 
  3.5925565158875637`*^9}},ExpressionUUID->"96babad4-4f4b-4299-ae95-\
5951d9b123d5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"Cabibbo.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{7., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "6"}],
  SequenceForm["Loading restrictions from ", "Cabibbo.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 6],
  Editable->False]], "Print",
 CellChangeTimes->{3.601455292860381*^9, 3.6017866994433126`*^9, 
  3.601787095326725*^9, 3.606394660238613*^9, 3.6063956986661043`*^9, 
  3.644794234728908*^9, 3.6447949974988117`*^9, 3.644796904757834*^9, 
  3.675605839085737*^9, 3.6756068460398903`*^9, 3.740983072676756*^9, 
  3.7409845931558228`*^9, 3.740985673152114*^9, 3.7409860410242033`*^9, 
  3.7409890672471647`*^9},ExpressionUUID->"bdd4e6d3-9da6-4eed-9427-\
61f43051f7c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"Massless.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{7., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18"}],
  SequenceForm["Loading restrictions from ", "Massless.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{3.601455292860381*^9, 3.6017866994433126`*^9, 
  3.601787095326725*^9, 3.606394660238613*^9, 3.6063956986661043`*^9, 
  3.644794234728908*^9, 3.6447949974988117`*^9, 3.644796904757834*^9, 
  3.675605839085737*^9, 3.6756068460398903`*^9, 3.740983072676756*^9, 
  3.7409845931558228`*^9, 3.740985673152114*^9, 3.7409860410242033`*^9, 
  3.7409890674422092`*^9},ExpressionUUID->"6fe3aa28-331b-4fe1-9e33-\
1a125e37dba1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"DiagonalCKM.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{7., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["Loading restrictions from ", "DiagonalCKM.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.601455292860381*^9, 3.6017866994433126`*^9, 
  3.601787095326725*^9, 3.606394660238613*^9, 3.6063956986661043`*^9, 
  3.644794234728908*^9, 3.6447949974988117`*^9, 3.644796904757834*^9, 
  3.675605839085737*^9, 3.6756068460398903`*^9, 3.740983072676756*^9, 
  3.7409845931558228`*^9, 3.740985673152114*^9, 3.7409860410242033`*^9, 
  3.740989067672357*^9},ExpressionUUID->"1e74d853-90c7-40e7-98e3-\
a6ef96fbff74"],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{3.601455292860381*^9, 3.6017866994433126`*^9, 
  3.601787095326725*^9, 3.606394660238613*^9, 3.6063956986661043`*^9, 
  3.644794234728908*^9, 3.6447949974988117`*^9, 3.644796904757834*^9, 
  3.675605839085737*^9, 3.6756068460398903`*^9, 3.740983072676756*^9, 
  3.7409845931558228`*^9, 3.740985673152114*^9, 3.7409860410242033`*^9, 
  3.740989067747057*^9},ExpressionUUID->"b9ce3dc4-46cf-4701-a3c5-\
3d750a0f014f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.304811`", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{3.601455438490341*^9, 3.601786844925991*^9, 
  3.601787238482038*^9, 3.6063947078559237`*^9, 3.6063957468698874`*^9, 
  3.6447942840487623`*^9, 3.644794997882559*^9, 3.6447969049961843`*^9, 
  3.675605839390239*^9, 3.6756068463606567`*^9, 3.740983073217482*^9, 
  3.740984593687017*^9, 3.740985673705535*^9, 3.740986041575634*^9, 
  3.740989067756805*^9},ExpressionUUID->"057e0f5a-7f38-435f-b450-\
2b6540762a00"]
}, Open  ]],

Cell[TextData[StyleBox["Print the Lagrangian",
 FontWeight->"Bold",
 FontColor->RGBColor[1, 0, 0]]], "Text",
 CellChangeTimes->{{3.740986942357329*^9, 
  3.7409869761299057`*^9}},ExpressionUUID->"0db0d3e5-0289-4717-bee3-\
87e98e7d09f1"],

Cell[CellGroupData[{

Cell[BoxData["Lv1"], "Input",
 CellChangeTimes->{{3.6756058676459093`*^9, 
  3.675605867647004*^9}},ExpressionUUID->"76d8349c-eabf-4c01-9d24-\
0c01e627caf9"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["C", "t1"], " ", 
  RowBox[{
   OverscriptBox["t", "\<\"-\"\>"], ".", 
   TemplateBox[{"\[Gamma]","mu"},
    "Superscript"], ".", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["P", "\<\"-\"\>"], " ", 
      RowBox[{"Cos", "[", 
       SubscriptBox["\[Theta]", "1"], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["P", "\<\"+\"\>"], " ", 
      RowBox[{"Sin", "[", 
       SubscriptBox["\[Theta]", "1"], "]"}]}]}], ")"}], ".", "t"}], " ", 
  SubscriptBox["v1", "mu"]}]], "Output",
 CellChangeTimes->{
  3.675605868177342*^9, 3.67560685831286*^9, 3.7409845952542467`*^9, {
   3.7409856756971493`*^9, 3.7409856864473133`*^9}, 
   3.740986043249672*^9},ExpressionUUID->"86bf899e-9183-4c2f-a279-\
d13b2e3c8c3a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checking the Lagrangian (arXiv:1604.07421)", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, 
   3.56965763460078*^9, {3.7409858130582237`*^9, 3.740985844015819*^9}, {
   3.740986902500684*^9, 
   3.7409869057236223`*^9}},ExpressionUUID->"487ca974-4a6c-48db-9635-\
b02ddbf0d1cb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", " ", "=", " ", "False"}], ";"}]], "Input",
 CellChangeTimes->{{3.5406575402120543`*^9, 
  3.540657546439702*^9}},ExpressionUUID->"d4a7fcb3-091a-43f9-8fe8-\
352c3053145b"],

Cell[CellGroupData[{

Cell["Checking hermiticity", "Subsection",
 CellChangeTimes->{{3.4234156831783743`*^9, 
  3.423415689540821*^9}},ExpressionUUID->"ca127d09-0b43-4447-ab0b-\
a0c7020d5ed8"],

Cell["The hermiticity of the Lagrangian can be checked via", "Text",
 CellChangeTimes->{{3.423415694323595*^9, 
  3.423415707867804*^9}},ExpressionUUID->"b040f9d0-2e7b-4627-8bd5-\
4ec881d2a6fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "Lv1", "]"}]], "Input",
 CellChangeTimes->{{3.414763473002973*^9, 3.4147634845507174`*^9}, {
   3.5884182415538187`*^9, 3.5884182416874647`*^9}, {3.645272619452579*^9, 
   3.645272624344407*^9}, {3.648474506052671*^9, 3.6484745091236353`*^9}, {
   3.648577278499804*^9, 3.648577280807659*^9}, {3.648946651210244*^9, 
   3.648946682020995*^9}, {3.649000607211097*^9, 3.649000610495351*^9}, {
   3.649078837157568*^9, 3.649078845450428*^9}, {3.667491761324419*^9, 
   3.667491767595119*^9}, {3.672683680296179*^9, 3.672683680358691*^9}, {
   3.673873929927452*^9, 3.67387393099113*^9}, {3.673874494179491*^9, 
   3.6738744958029423`*^9}, {3.673876131252974*^9, 3.673876131666979*^9}, {
   3.673881346926963*^9, 3.673881348725006*^9}, {3.673883389758706*^9, 
   3.6738833933322067`*^9}, {3.673884991690379*^9, 3.673884993753655*^9}, {
   3.673885128643969*^9, 3.673885129010468*^9}, 
   3.675605945451625*^9},ExpressionUUID->"0b7086a8-5057-41cd-9eee-\
31f0a57e89f8"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{
  3.644773168592648*^9, 3.6452726274292727`*^9, 3.645707638159724*^9, 
   3.6483124003901653`*^9, 3.6483821293672333`*^9, 3.6484745120137444`*^9, 
   3.6485772848282127`*^9, 3.64894669749399*^9, 3.649000625446762*^9, 
   3.649078849877396*^9, 3.652705720637269*^9, 3.654342079336636*^9, 
   3.667491771033383*^9, 3.669112012567482*^9, 3.669339578328498*^9, 
   3.6726836835120373`*^9, 3.672684447528275*^9, 3.672739851682497*^9, 
   3.672764444816256*^9, 3.672765027904311*^9, 3.672765183002973*^9, 
   3.672778000637538*^9, 3.67282264717301*^9, 3.673175620280954*^9, 
   3.673873933854293*^9, 3.673874173247109*^9, 3.673874569722929*^9, {
   3.6738761233818827`*^9, 3.6738761336449757`*^9}, 3.67388134911267*^9, {
   3.6738833949354963`*^9, 3.673883400192733*^9}, 3.673884994745006*^9, 
   3.673885285521969*^9, 3.673885525946775*^9, 3.6756059460299177`*^9, 
   3.675606868337083*^9, 
   3.740985695085124*^9},ExpressionUUID->"7b5269d8-81a5-4baa-b1c6-\
e99e07437a26"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{
  3.644773168592648*^9, 3.6452726274292727`*^9, 3.645707638159724*^9, 
   3.6483124003901653`*^9, 3.6483821293672333`*^9, 3.6484745120137444`*^9, 
   3.6485772848282127`*^9, 3.64894669749399*^9, 3.649000625446762*^9, 
   3.649078849877396*^9, 3.652705720637269*^9, 3.654342079336636*^9, 
   3.667491771033383*^9, 3.669112012567482*^9, 3.669339578328498*^9, 
   3.6726836835120373`*^9, 3.672684447528275*^9, 3.672739851682497*^9, 
   3.672764444816256*^9, 3.672765027904311*^9, 3.672765183002973*^9, 
   3.672778000637538*^9, 3.67282264717301*^9, 3.673175620280954*^9, 
   3.673873933854293*^9, 3.673874173247109*^9, 3.673874569722929*^9, {
   3.6738761233818827`*^9, 3.6738761336449757`*^9}, 3.67388134911267*^9, {
   3.6738833949354963`*^9, 3.673883400192733*^9}, 3.673884994745006*^9, 
   3.673885285521969*^9, 3.673885525946775*^9, 3.6756059460299177`*^9, 
   3.675606868337083*^9, 
   3.740985695094656*^9},ExpressionUUID->"4c779a80-7dc2-4038-bd1e-\
95dccb1f55ab"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.644773168592648*^9, 3.6452726274292727`*^9, 3.645707638159724*^9, 
   3.6483124003901653`*^9, 3.6483821293672333`*^9, 3.6484745120137444`*^9, 
   3.6485772848282127`*^9, 3.64894669749399*^9, 3.649000625446762*^9, 
   3.649078849877396*^9, 3.652705720637269*^9, 3.654342079336636*^9, 
   3.667491771033383*^9, 3.669112012567482*^9, 3.669339578328498*^9, 
   3.6726836835120373`*^9, 3.672684447528275*^9, 3.672739851682497*^9, 
   3.672764444816256*^9, 3.672765027904311*^9, 3.672765183002973*^9, 
   3.672778000637538*^9, 3.67282264717301*^9, 3.673175620280954*^9, 
   3.673873933854293*^9, 3.673874173247109*^9, 3.673874569722929*^9, {
   3.6738761233818827`*^9, 3.6738761336449757`*^9}, 3.67388134911267*^9, {
   3.6738833949354963`*^9, 3.673883400192733*^9}, 3.673884994745006*^9, 
   3.673885285521969*^9, 3.673885525946775*^9, 3.6756059460299177`*^9, 
   3.675606868337083*^9, 
   3.740985695195629*^9},ExpressionUUID->"6f24f8fe-2a40-4b88-bfaf-\
fb2207371c35"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.644773168592648*^9, 3.6452726274292727`*^9, 3.645707638159724*^9, 
   3.6483124003901653`*^9, 3.6483821293672333`*^9, 3.6484745120137444`*^9, 
   3.6485772848282127`*^9, 3.64894669749399*^9, 3.649000625446762*^9, 
   3.649078849877396*^9, 3.652705720637269*^9, 3.654342079336636*^9, 
   3.667491771033383*^9, 3.669112012567482*^9, 3.669339578328498*^9, 
   3.6726836835120373`*^9, 3.672684447528275*^9, 3.672739851682497*^9, 
   3.672764444816256*^9, 3.672765027904311*^9, 3.672765183002973*^9, 
   3.672778000637538*^9, 3.67282264717301*^9, 3.673175620280954*^9, 
   3.673873933854293*^9, 3.673874173247109*^9, 3.673874569722929*^9, {
   3.6738761233818827`*^9, 3.6738761336449757`*^9}, 3.67388134911267*^9, {
   3.6738833949354963`*^9, 3.673883400192733*^9}, 3.673884994745006*^9, 
   3.673885285521969*^9, 3.673885525946775*^9, 3.6756059460299177`*^9, 
   3.675606868337083*^9, 
   3.740985695206471*^9},ExpressionUUID->"3c5ee63f-ed00-4b32-bcd7-\
9fd484c3689a"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{
  3.644773168592648*^9, 3.6452726274292727`*^9, 3.645707638159724*^9, 
   3.6483124003901653`*^9, 3.6483821293672333`*^9, 3.6484745120137444`*^9, 
   3.6485772848282127`*^9, 3.64894669749399*^9, 3.649000625446762*^9, 
   3.649078849877396*^9, 3.652705720637269*^9, 3.654342079336636*^9, 
   3.667491771033383*^9, 3.669112012567482*^9, 3.669339578328498*^9, 
   3.6726836835120373`*^9, 3.672684447528275*^9, 3.672739851682497*^9, 
   3.672764444816256*^9, 3.672765027904311*^9, 3.672765183002973*^9, 
   3.672778000637538*^9, 3.67282264717301*^9, 3.673175620280954*^9, 
   3.673873933854293*^9, 3.673874173247109*^9, 3.673874569722929*^9, {
   3.6738761233818827`*^9, 3.6738761336449757`*^9}, 3.67388134911267*^9, {
   3.6738833949354963`*^9, 3.673883400192733*^9}, 3.673884994745006*^9, 
   3.673885285521969*^9, 3.673885525946775*^9, 3.6756059460299177`*^9, 
   3.675606868337083*^9, 
   3.7409856952161283`*^9},ExpressionUUID->"6542c0fa-fb3c-425f-9f42-\
2d9937322a04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.644773168592648*^9, 3.6452726274292727`*^9, 3.645707638159724*^9, 
   3.6483124003901653`*^9, 3.6483821293672333`*^9, 3.6484745120137444`*^9, 
   3.6485772848282127`*^9, 3.64894669749399*^9, 3.649000625446762*^9, 
   3.649078849877396*^9, 3.652705720637269*^9, 3.654342079336636*^9, 
   3.667491771033383*^9, 3.669112012567482*^9, 3.669339578328498*^9, 
   3.6726836835120373`*^9, 3.672684447528275*^9, 3.672739851682497*^9, 
   3.672764444816256*^9, 3.672765027904311*^9, 3.672765183002973*^9, 
   3.672778000637538*^9, 3.67282264717301*^9, 3.673175620280954*^9, 
   3.673873933854293*^9, 3.673874173247109*^9, 3.673874569722929*^9, {
   3.6738761233818827`*^9, 3.6738761336449757`*^9}, 3.67388134911267*^9, {
   3.6738833949354963`*^9, 3.673883400192733*^9}, 3.673884994745006*^9, 
   3.673885285521969*^9, 3.673885525946775*^9, 3.6756059460299177`*^9, 
   3.675606868337083*^9, 
   3.740985695225507*^9},ExpressionUUID->"43603478-6059-499a-bbc9-\
d0143bb51874"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{
  3.644773168592648*^9, 3.6452726274292727`*^9, 3.645707638159724*^9, 
   3.6483124003901653`*^9, 3.6483821293672333`*^9, 3.6484745120137444`*^9, 
   3.6485772848282127`*^9, 3.64894669749399*^9, 3.649000625446762*^9, 
   3.649078849877396*^9, 3.652705720637269*^9, 3.654342079336636*^9, 
   3.667491771033383*^9, 3.669112012567482*^9, 3.669339578328498*^9, 
   3.6726836835120373`*^9, 3.672684447528275*^9, 3.672739851682497*^9, 
   3.672764444816256*^9, 3.672765027904311*^9, 3.672765183002973*^9, 
   3.672778000637538*^9, 3.67282264717301*^9, 3.673175620280954*^9, 
   3.673873933854293*^9, 3.673874173247109*^9, 3.673874569722929*^9, {
   3.6738761233818827`*^9, 3.6738761336449757`*^9}, 3.67388134911267*^9, {
   3.6738833949354963`*^9, 3.673883400192733*^9}, 3.673884994745006*^9, 
   3.673885285521969*^9, 3.673885525946775*^9, 3.6756059460299177`*^9, 
   3.675606868337083*^9, 
   3.74098569523495*^9},ExpressionUUID->"144182f3-4a7e-465e-add3-\
f4d6d5cf0f4a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.644773185013188*^9, 3.645272637942464*^9, 3.645707650931437*^9, 
   3.648312426650044*^9, 3.6483821405918207`*^9, 3.648474526163392*^9, 
   3.64857729951048*^9, 3.6489467142411423`*^9, 3.649000641143311*^9, 
   3.649078867540442*^9, 3.652705731014285*^9, 3.654342091121242*^9, 
   3.667491778761985*^9, 3.6691120205860767`*^9, 3.669339594021774*^9, 
   3.672683691647408*^9, 3.672684455722678*^9, 3.6727398601704903`*^9, 
   3.672764453198152*^9, 3.672765036017075*^9, 3.672765190940927*^9, 
   3.672778008577319*^9, 3.672822654776629*^9, 3.673175628520755*^9, 
   3.673873942323084*^9, 3.673874205437208*^9, 3.673874570417692*^9, {
   3.673876124084189*^9, 3.6738761341914454`*^9}, 3.673881349208651*^9, {
   3.6738833954579973`*^9, 3.673883400835807*^9}, 3.673884999429962*^9, 
   3.673885286674212*^9, 3.67388599096632*^9, 3.6756059462939663`*^9, 
   3.675606868488936*^9, 
   3.740985695245943*^9},ExpressionUUID->"09f9645b-47bb-47fa-9e13-\
d6a26c34bc83"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checking the kinetic terms", "Subsection",
 CellChangeTimes->{{3.423415843532096*^9, 
  3.42341584850035*^9}},ExpressionUUID->"2bbaad75-62b6-4ca1-a629-\
469f22a36c50"],

Cell["\<\
In the same way, FeynRules can check whether all kinetic terms are correctly \
normalized :\
\>", "Text",
 CellChangeTimes->{{3.423415798800013*^9, 
  3.423415817964087*^9}},ExpressionUUID->"685d0054-0d81-4c9e-a668-\
844d8781408e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckKineticTermNormalisation", "[", 
  RowBox[{"LSM", "+", "Lv1"}], "]"}]], "Input",
 CellChangeTimes->{{3.4147636651636972`*^9, 3.414763667250185*^9}, {
   3.645272718117766*^9, 3.645272720699003*^9}, {3.667491813720992*^9, 
   3.6674918147292128`*^9}, 
   3.675606077446086*^9},ExpressionUUID->"57f7eee1-829b-46fd-a13c-\
a9d69680626b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.644773279452509*^9, 3.645272726409737*^9, 
  3.64570772418742*^9, 3.667491834615438*^9, 3.66933965146412*^9, 
  3.675606082920841*^9, 3.675606889111458*^9, 
  3.740985733713356*^9},ExpressionUUID->"cf11a547-f99b-4a77-9b42-\
3e67a610bb70"],

Cell[BoxData["\<\"All kinetic terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{3.644773279452509*^9, 3.645272726409737*^9, 
  3.64570772418742*^9, 3.667491834615438*^9, 3.66933965146412*^9, 
  3.675606082920841*^9, 3.675606889111458*^9, 
  3.740985733819943*^9},ExpressionUUID->"04a5a3f4-468c-4dde-95aa-\
73964742ebe1"],

Cell[BoxData["\<\"All kinetic terms are correctly normalized.\"\>"], "Print",
 CellChangeTimes->{3.644773279452509*^9, 3.645272726409737*^9, 
  3.64570772418742*^9, 3.667491834615438*^9, 3.66933965146412*^9, 
  3.675606082920841*^9, 3.675606889111458*^9, 
  3.740985736444448*^9},ExpressionUUID->"91fc0445-7051-4614-9982-\
3d5cc275973f"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.74098573645601*^9},ExpressionUUID->"1954bc59-4a88-414e-91e2-10bc96c9e50f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Decay Width", "Subsection",
 CellChangeTimes->{{3.6756062696623507`*^9, 
  3.6756062743170633`*^9}},ExpressionUUID->"67459bf3-fe05-407c-8d2e-\
524f1f025cd0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "Lv1", "]"}]], "Input",
 CellChangeTimes->{{3.649007514564241*^9, 3.6490075892578297`*^9}, 
   3.649078997877944*^9, {3.667491845401843*^9, 3.667491850351368*^9}, {
   3.672764508200699*^9, 3.672764509174398*^9}, {3.672765426086227*^9, 
   3.672765433978984*^9}, {3.673175681395782*^9, 3.673175686841549*^9}, 
   3.6756062865361767`*^9},ExpressionUUID->"78e49f55-97ee-464c-bc9c-\
c544f46f5b00"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.649007590804017*^9, 3.652705781840035*^9, 
  3.667491851437766*^9, 3.669113407434478*^9, 3.6727645098394823`*^9, 
  3.6727650635425797`*^9, 3.672765240990141*^9, 3.672765435244398*^9, 
  3.6727780416576633`*^9, 3.6728226717351103`*^9, 3.673175688299732*^9, 
  3.673881400163583*^9, 3.67560628694026*^9, 3.740985744338359*^9, 
  3.740986051684906*^9},ExpressionUUID->"9f3ef338-3ada-46fb-999e-\
f792d47a3079"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.649007590804017*^9, 3.652705781840035*^9, 
  3.667491851437766*^9, 3.669113407434478*^9, 3.6727645098394823`*^9, 
  3.6727650635425797`*^9, 3.672765240990141*^9, 3.672765435244398*^9, 
  3.6727780416576633`*^9, 3.6728226717351103`*^9, 3.673175688299732*^9, 
  3.673881400163583*^9, 3.67560628694026*^9, 3.740985744338359*^9, 
  3.7409860516943808`*^9},ExpressionUUID->"f72aa08f-895d-4dcc-8f77-\
957127362dc3"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.649007590804017*^9, 3.652705781840035*^9, 
  3.667491851437766*^9, 3.669113407434478*^9, 3.6727645098394823`*^9, 
  3.6727650635425797`*^9, 3.672765240990141*^9, 3.672765435244398*^9, 
  3.6727780416576633`*^9, 3.6728226717351103`*^9, 3.673175688299732*^9, 
  3.673881400163583*^9, 3.67560628694026*^9, 3.740985744338359*^9, 
  3.7409860517456923`*^9},ExpressionUUID->"bfe0ba49-b9ed-4d2e-b53e-\
fa827076d237"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{108., {3., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.649007590804017*^9, 3.652705781840035*^9, 
  3.667491851437766*^9, 3.669113407434478*^9, 3.6727645098394823`*^9, 
  3.6727650635425797`*^9, 3.672765240990141*^9, 3.672765435244398*^9, 
  3.6727780416576633`*^9, 3.6728226717351103`*^9, 3.673175688299732*^9, 
  3.673881400163583*^9, 3.67560628694026*^9, 3.740985744338359*^9, 
  3.7409860517582493`*^9},ExpressionUUID->"8481b4ea-6bd5-4756-a4b5-\
3418a81a963b"],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->{3.649007590804017*^9, 3.652705781840035*^9, 
  3.667491851437766*^9, 3.669113407434478*^9, 3.6727645098394823`*^9, 
  3.6727650635425797`*^9, 3.672765240990141*^9, 3.672765435244398*^9, 
  3.6727780416576633`*^9, 3.6728226717351103`*^9, 3.673175688299732*^9, 
  3.673881400163583*^9, 3.67560628694026*^9, 3.740985744338359*^9, 
  3.740986051768338*^9},ExpressionUUID->"a7105e2b-1a73-4e89-b07a-\
ce50c68fc160"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        OverscriptBox["t", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"v1", ",", "3"}], "}"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["C", "t1"], " ", 
      RowBox[{"Cos", "[", 
       SubscriptBox["\[Theta]", "1"], "]"}], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
      SubscriptBox[
       RowBox[{
        TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
         "Superscript"], ".", 
        SubscriptBox["P", "\<\"-\"\>"]}], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["C", "t1"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
      RowBox[{"Sin", "[", 
       SubscriptBox["\[Theta]", "1"], "]"}], " ", 
      SubscriptBox[
       RowBox[{
        TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
         "Superscript"], ".", 
        SubscriptBox["P", "\<\"+\"\>"]}], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.649007591171782*^9, 3.652705782286191*^9, 
  3.667491851489443*^9, 3.669113407604361*^9, 3.6727645099677963`*^9, 
  3.672765063730905*^9, 3.672765241130969*^9, 3.672765435491198*^9, 
  3.672778041925177*^9, 3.672822672043209*^9, 3.673175688472657*^9, 
  3.673881400212654*^9, 3.6756062870678043`*^9, 3.740985744439678*^9, 
  3.7409860517822533`*^9},ExpressionUUID->"c91c4e66-debf-4ceb-a2d3-\
5190266b9308"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"vertexes", "=", 
   RowBox[{"FeynmanRules", "[", "Lv1", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6490076051090517`*^9, 3.649007640414425*^9}, {
   3.649079007961914*^9, 3.649079008536003*^9}, {3.66749186407227*^9, 
   3.667491867349753*^9}, {3.67276452984871*^9, 3.6727645299332333`*^9}, {
   3.672765451484128*^9, 3.6727654543625097`*^9}, {3.6731756944659033`*^9, 
   3.673175694953231*^9}, 
   3.675606292280395*^9},ExpressionUUID->"ae7d9451-537a-40e3-97e0-\
5c70eca46be1"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.6490082499584923`*^9, 3.649079024654687*^9, 3.649091014379156*^9, 
   3.652705790512706*^9, 3.6674918679744053`*^9, 3.669113423867724*^9, 
   3.672764530685598*^9, 3.672765116782412*^9, 3.672765251334023*^9, 
   3.672765455747913*^9, 3.672778044124208*^9, 3.6728226721673193`*^9, 
   3.673175695995907*^9, 3.673881407481183*^9, 3.6756062929793243`*^9, 
   3.7409857510428677`*^9, {3.740986023707655*^9, 
   3.740986053334502*^9}},ExpressionUUID->"2d28abac-fa46-4ff7-a1a3-\
326799043523"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.6490082499584923`*^9, 3.649079024654687*^9, 3.649091014379156*^9, 
   3.652705790512706*^9, 3.6674918679744053`*^9, 3.669113423867724*^9, 
   3.672764530685598*^9, 3.672765116782412*^9, 3.672765251334023*^9, 
   3.672765455747913*^9, 3.672778044124208*^9, 3.6728226721673193`*^9, 
   3.673175695995907*^9, 3.673881407481183*^9, 3.6756062929793243`*^9, 
   3.7409857510428677`*^9, {3.740986023707655*^9, 
   3.740986053344449*^9}},ExpressionUUID->"f0a10ef7-7ac7-483c-b814-\
c2c38227f22d"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.6490082499584923`*^9, 3.649079024654687*^9, 3.649091014379156*^9, 
   3.652705790512706*^9, 3.6674918679744053`*^9, 3.669113423867724*^9, 
   3.672764530685598*^9, 3.672765116782412*^9, 3.672765251334023*^9, 
   3.672765455747913*^9, 3.672778044124208*^9, 3.6728226721673193`*^9, 
   3.673175695995907*^9, 3.673881407481183*^9, 3.6756062929793243`*^9, 
   3.7409857510428677`*^9, {3.740986023707655*^9, 
   3.74098605335422*^9}},ExpressionUUID->"235e569b-5470-4498-9f1a-\
2b8df0de1554"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{7., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6490082499584923`*^9, 3.649079024654687*^9, 3.649091014379156*^9, 
   3.652705790512706*^9, 3.6674918679744053`*^9, 3.669113423867724*^9, 
   3.672764530685598*^9, 3.672765116782412*^9, 3.672765251334023*^9, 
   3.672765455747913*^9, 3.672778044124208*^9, 3.6728226721673193`*^9, 
   3.673175695995907*^9, 3.673881407481183*^9, 3.6756062929793243`*^9, 
   3.7409857510428677`*^9, {3.740986023707655*^9, 
   3.740986053364599*^9}},ExpressionUUID->"5df597bb-732c-43d9-94b7-\
18f17c64ee99"],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->{
  3.6490082499584923`*^9, 3.649079024654687*^9, 3.649091014379156*^9, 
   3.652705790512706*^9, 3.6674918679744053`*^9, 3.669113423867724*^9, 
   3.672764530685598*^9, 3.672765116782412*^9, 3.672765251334023*^9, 
   3.672765455747913*^9, 3.672778044124208*^9, 3.6728226721673193`*^9, 
   3.673175695995907*^9, 3.673881407481183*^9, 3.6756062929793243`*^9, 
   3.7409857510428677`*^9, {3.740986023707655*^9, 
   3.7409860533747377`*^9}},ExpressionUUID->"6640a85a-3c0c-421f-8f12-\
46a83d8d1ac3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"decays", "=", 
  RowBox[{"ComputeWidths", "[", "vertexes", "]"}]}]], "Input",
 CellChangeTimes->{{3.649007654243157*^9, 
  3.649007667006296*^9}},ExpressionUUID->"3e297325-bb4f-4017-a537-\
c138f6f2e251"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.649007667872319*^9, 3.649008252619555*^9, 3.649079029355054*^9, 
   3.649091018699396*^9, 3.6527057954499807`*^9, 3.6674918813898287`*^9, {
   3.667492489965334*^9, 3.667492510263709*^9}, 3.669113425719366*^9, 
   3.672764538062931*^9, 3.672765118885231*^9, 3.672765253070011*^9, 
   3.672765459457488*^9, 3.672778048086872*^9, 3.672822675864388*^9, 
   3.6731757144200068`*^9, 3.673881410446287*^9, 3.6756062988173313`*^9, 
   3.740985753399325*^9, {3.740986018741704*^9, 3.740986025486402*^9}, 
   3.740986055659212*^9},ExpressionUUID->"791ce2e8-05f0-47ae-9403-\
5f9115cddc16"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.649007667872319*^9, 3.649008252619555*^9, 3.649079029355054*^9, 
   3.649091018699396*^9, 3.6527057954499807`*^9, 3.6674918813898287`*^9, {
   3.667492489965334*^9, 3.667492510263709*^9}, 3.669113425719366*^9, 
   3.672764538062931*^9, 3.672765118885231*^9, 3.672765253070011*^9, 
   3.672765459457488*^9, 3.672778048086872*^9, 3.672822675864388*^9, 
   3.6731757144200068`*^9, 3.673881410446287*^9, 3.6756062988173313`*^9, 
   3.740985753399325*^9, {3.740986018741704*^9, 3.740986025486402*^9}, 
   3.740986055693122*^9},ExpressionUUID->"71984a10-f11d-4cf2-935d-\
d8f94ad62873"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.649007667872319*^9, 3.649008252619555*^9, 3.649079029355054*^9, 
   3.649091018699396*^9, 3.6527057954499807`*^9, 3.6674918813898287`*^9, {
   3.667492489965334*^9, 3.667492510263709*^9}, 3.669113425719366*^9, 
   3.672764538062931*^9, 3.672765118885231*^9, 3.672765253070011*^9, 
   3.672765459457488*^9, 3.672778048086872*^9, 3.672822675864388*^9, 
   3.6731757144200068`*^9, 3.673881410446287*^9, 3.6756062988173313`*^9, 
   3.740985753399325*^9, {3.740986018741704*^9, 3.740986025486402*^9}, 
   3.740986055704536*^9},ExpressionUUID->"0e51bde3-8115-4873-8ec1-\
7d87d51eaf2f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"v1", ",", "t", ",", 
      OverscriptBox["t", "\<\"-\"\>"]}], "}"}], ",", 
    FractionBox[
     RowBox[{
      SubsuperscriptBox["C", "t1", "2"], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox["MT", "2"], " ", 
         SuperscriptBox["Mv1", "2"]}], "+", 
        SuperscriptBox["Mv1", "4"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["MT", "2"]}], "+", 
        SuperscriptBox["Mv1", "2"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["MT", "2"], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", " ", 
           SubscriptBox["\[Theta]", "1"]}], "]"}]}]}], ")"}]}], 
     RowBox[{"8", " ", "\[Pi]", " ", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "Mv1", "]"}], "3"]}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.667491881487854*^9, {3.667492490029159*^9, 3.667492510316111*^9}, 
   3.6691134259028997`*^9, 3.672764538167389*^9, 3.672765119052307*^9, 
   3.672765253187193*^9, 3.672765459686406*^9, 3.672778048348898*^9, 
   3.672822676132321*^9, 3.673175714548808*^9, 3.673881410557761*^9, 
   3.6756062989970303`*^9, 3.7409857535199137`*^9, {3.7409860188432503`*^9, 
   3.740986025592284*^9}, 
   3.740986055759667*^9},ExpressionUUID->"44ccb184-70fa-497b-862d-\
bb95f069740f"]
}, Open  ]],

Cell[TextData[StyleBox["Eq.(2.2) in arXiv:1604.07421",
 FontWeight->"Bold",
 FontColor->RGBColor[1, 0, 0]]], "Text",
 CellChangeTimes->{{3.7409866048447313`*^9, 
  3.7409866145251713`*^9}},ExpressionUUID->"749014d9-cf45-49ab-af20-\
41d0854d3d8e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"width", "=", 
  RowBox[{"decays", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6674924998447943`*^9, 3.66749250172573*^9}, {
  3.740986013636043*^9, 3.740986014299575*^9}, {3.7409860600446863`*^9, 
  3.740986072641944*^9}},ExpressionUUID->"84471270-b49a-4e84-a93f-\
9b35059d5eb6"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SubsuperscriptBox["C", "t1", "2"], " ", 
   SqrtBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["MT", "2"], " ", 
      SuperscriptBox["Mv1", "2"]}], "+", 
     SuperscriptBox["Mv1", "4"]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["MT", "2"]}], "+", 
     SuperscriptBox["Mv1", "2"], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["MT", "2"], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", 
        SubscriptBox["\[Theta]", "1"]}], "]"}]}]}], ")"}]}], 
  RowBox[{"8", " ", "\[Pi]", " ", 
   SuperscriptBox[
    RowBox[{"Abs", "[", "Mv1", "]"}], "3"]}]]], "Output",
 CellChangeTimes->{{3.6674924838870173`*^9, 3.667492515533375*^9}, 
   3.673175740723462*^9, 3.675606306134489*^9, 3.7409857584072733`*^9, 
   3.740986014721623*^9, {3.740986060574749*^9, 
   3.740986073372387*^9}},ExpressionUUID->"36e1489d-1055-4482-8c2a-\
b10a706a02ff"]
}, Open  ]],

Cell[TextData[StyleBox["Numerical value",
 FontWeight->"Bold",
 FontColor->RGBColor[1, 0, 0]]], "Text",
 CellChangeTimes->{{3.7409866048447313`*^9, 
  3.74098664541048*^9}},ExpressionUUID->"163c73c4-af94-4249-9f6d-\
004cdafad0b9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"width", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ct1", "\[Rule]", " ", "1.0"}], ",", 
    RowBox[{
     FormBox["Mv1",
      TraditionalForm], "\[Rule]", " ", "1000"}], ",", 
    RowBox[{
     FormBox["MT",
      TraditionalForm], "\[Rule]", " ", "172"}], ",", 
    RowBox[{"theta1", "\[Rule]", " ", 
     RowBox[{"\[Pi]", "/", "2"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.667492345267787*^9, 3.667492467862061*^9}, {
  3.667492519747223*^9, 3.667492523573892*^9}, {3.7409857646428556`*^9, 
  3.7409857648101597`*^9}},ExpressionUUID->"f027b521-66dd-4400-8b53-\
a4d1d5446d43"],

Cell[BoxData["36.25514470192431`"], "Output",
 CellChangeTimes->{3.649007668396553*^9, 3.6490082529700327`*^9, 
  3.649079030103982*^9, 3.649091019597814*^9, 3.65270579611791*^9, 
  3.667492370205737*^9, 3.667492469805489*^9, 3.667492524582057*^9, 
  3.740985766959201*^9},ExpressionUUID->"09b0a6f4-daab-4861-a330-\
226d6e2adfea"]
}, Open  ]],

Cell[TextData[StyleBox["I checked this value with the numerical result of \
MadGraph, i.e. simply typing\n \[OpenCurlyDoubleQuote]set param_card Wv1 Auto\
\[CloseCurlyDoubleQuote].\n ",
 FontWeight->"Bold",
 FontColor->RGBColor[1, 0, 0]]], "Text",
 CellChangeTimes->{{3.740986735058714*^9, 
  3.740986856156866*^9}},ExpressionUUID->"7c647911-84e5-482d-8c4d-\
973d8011026f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Writing UFO", "Section",
 CellChangeTimes->{{3.6756062445581427`*^9, 
  3.6756062513742332`*^9}},ExpressionUUID->"2c5ac4fc-05bc-4cee-af9c-\
983f2b88ca76"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"WriteUFO", "[", 
   RowBox[{"LSM", ",", "Lv1"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.573734532526009*^9, 3.5737345482721024`*^9}, {
   3.573879369501131*^9, 3.5738793702602386`*^9}, {3.578315571404697*^9, 
   3.578315576024173*^9}, {3.591483721426413*^9, 3.591483726434258*^9}, 
   3.592218676777197*^9, {3.644795071205782*^9, 3.644795102145712*^9}, {
   3.644796936865158*^9, 3.64479695694236*^9}, {3.6756063882931423`*^9, 
   3.6756063924311666`*^9}},ExpressionUUID->"13b25c41-890d-4c26-a7ef-\
d58263aa84b2"],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYMzCrFw6M21tZS2rbc41t7Z6yy8uobA5Nm94aaNEawna
IHWglC4oSzTNRcgizVhYQ9QszFu2pmlaRtbUmlPoP3OBYsFKep4Ph9/HA+ew
ci4ma9fRaDQ1RJiRmW5posiQTHMptJUi84FX8sJArrCqeT/od76UHgMalPXS
g2D4ZU4RKihPMvJAMTvIhxbfDdvOBxsDu0SoTTFWgEYQbyX6WadcRJnPlXQB
WGWIl6O3vZoa1CLOakNdtT1nYsG0E0IDuvK1w4SmRm2yoY+zA36iEeaQ2Tgw
qLBCIALNCk4SOqd/nY922D9VoyzNu/eo8nrAlsNgUt+yCXV3qyfF4GrtQ/94
ULe4uQatWH+IIcOeUr1CDko00050oyTXjc7s5NOOgcZTkWa0d9CRnQ6e9R0t
QK8WeMWnrbDPykAyWnhuRIeKptj1aHtuYg8a3s+YQI3bZHPoU1W1VgkG71n9
gDoSbKEpYELWgzh0X11Ln6yXIk1/tcPokdjirleg4fu4vBfk942XoOpIeiNa
3j3lRBtsN2V2MHprit9bcEi/yEUZEp0LlbcX8UbBOyfZxUvgn90yrqgffuBt
eCkFOcfNjs4BivDkP8qGwdSFDBd7kCJrpi++RPBJiI4f+oYiUfdvMEs+UsQ+
ei+TO0mRvcGPDkjBb26HzwmqfvlipkEvd9dS8wxFrv025beA1gvWTne0h4yz
xnbMg5XCZf8FsEzV0Naa4yH/pl6402Y95JlnxZIO5tWtjaDMW2QiE/wPF3Zw
xw==
  "],ExpressionUUID->"00ca5c88-c8b5-414b-9e30-2a2569f083b0"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYMzCrDQvmba2spbVNuea2lZv2gdNKGyOTad4aaPE1RK0
QepIKV1QkmiaixAjzVhYQ9QsbF6yNU3TMlpNLZ1C/y0XOCxYSc/z4fD7eOAc
Rv7FdOU6Go0mg/CzcxStLRQZEckvhXRQZNH/SmEoyObXtO0Hfc6X02NAraQx
8SAYfplVgvIq03QcUMgM8KKld0O3c8Fm/14BakqdUKMRxF2NflZJXGjYcwmd
B9Zo48Xobbe8Dm0V5nai8/X9Z2LBrCS+FvV87dajmVGbTOjjPL+faIQhaC4O
DCiu4glAQyorDV3QvC5Cuy2falGG/N17VHLDb8thMG1gRY86+mTTQnC1/qFv
PKhyba5Dq9YfChZhT7kmVQwmyGfs6MaEAgc6u5NLOwbqTkUaUPOwNU8BnvUe
VaPX1G7haSPs4xlKR4vPjalQgY3ZiHYVpPSj4YPBU6hum2gBfSqtVUrAwD2r
H1BrsikkA0zOfRCH7mtoHxCZKdLyVzmKHokt7X0Far9Pis0gd2CyDJVF0pvR
yj6bHW0y3RJZwOitGT5vwRGNi40GJ6jmUXFXCWccvHOSWboM/tktYgsG4QfO
hpeJIOu4wdozRBGO+EfFKJi5lD3PHKbImv6LNwV8EqTihryhSNT9m2FlHyli
Gb+Xw56myN7ARwcSwW8Oq9cOSn95Y2ZAN3vXctssRa7/1he1g8YLxh5HtJNM
MiZ2LILV/BXfJbBC2tTZke8k/2wvHFlzTvLM6WlVgIUNa2PoVe6JqRzwPxg1
cNQ=
  "],ExpressionUUID->"63a5eefb-eb7d-4973-9ee6-f9b2aaf4b1df"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYMzCrFxTM81mWctqm3PN2VZv2QfXoLA5Ni/DS44SLRO0
QepAKV1QkmiaixAjbbGwhqhZ2LxkNk3TMlpNrTmF/lsucFiwkp7nw+H38cA5
0bmXUvPX0Wg0JYSfpc5sa6XIiFh1mWmkyGLg1YJQkM2vbd8P+l2ooMeBWnlT
0kEw/EpMKcqrkuk4oJAV5EPL7oZu54Itgb0C1CydLEIjiKcG/ayRu9Gw53I6
D6zVJkrQ2x5VPdomzO5EHQ39Z+PBjBN8Ler92q1H06M2mdHHOQE/0QhDyHwC
GFRSzROABmmMDF0ofl2Ido9+qkOjVe/eo/IbAVsOg7KBFT3q7FPOCMHVhof+
iaDGvbkerV5/iCHGnopiqQQUqWbt6EZRnhOd28mlHQN1pyMNqGXYmpMJnvMd
LUKvFXmEZ0ywj3coFS05P65BBTZWE9qVl9KPhg8yplHdNvEC+lRRly8Hg/es
fkCtyWZmGpic/SAB3dfYMSC2UKT1b/4YeiS+rPcVqP0+JbGA3IGpclQZSW9B
q/psdrTZfEs8CsZuTfN7C44Uu9koQ6RxoJKuUs4EeOcUq2wZ/LNbzBYMwg+c
DS+TwJjjBmvPEEU4kh+VY2D6UpaDNUyRNf0XXwr4JETDZb6hSNT9m2HlHyky
OnFPzZ6hyN7gRweSwG9Oq88OKn754mZBD3vXcvscRa7/1hd2gKaLph5nrItM
RU/uWARr+Cv+S2ClornTmOsi/2wvnBnzLvLM5W3LBAsa18bREuPJaTX4HxsF
cT0=
  "],ExpressionUUID->"7b52a900-f33c-4126-a07b-65584a4b4191"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYGhhVi4vmWazrGW1zbnm1lZvSeAaFDZl8zK8tFHiygRt
kDpQSheUJJrmImSRZiysIWoWNi/ZmqbNMlpNLZ1C/y0XKBaspOf5cPh9PHBO
bP6lNNU6Go0mh3BzlNnGVoqMiBSXwzooshB0tTAcZHJr2/aDfhcqAhNAraxJ
eBCMvBJXinKqpDoWyGcE+9Cyu+Hb2WBLUC8PNUsmNGgU8dagn9UyDxrxXBbI
AWu1yWL0tldRjxr5uZ3oXEP/2UQw6wRXi6587dajmTGbzOjjvICfaJQhdDYJ
DC6p5vBAgyROis4Xvy5Cu62f6tBYxbv3qOxGwJbDoHRgWY+6+uRTfHC14aF/
Mqj2bK5Hq9cfoouwp6JYIgYFimknulFQ4EJndrJpx0Dd6WgDahm25WWD53xH
Neg1jZd/xgT7rAyloSXnx9Qoz8FoQrsKUvvRyEH6JKrbJppHn2bUqWRgyJ7V
D6gtxRyWDqbkPkhC9zW2D4gsFGn9qxpFjySW9b4Ctd/tYgvIHrCXo/LowBa0
qs/hRJvNt0RWMH5rut9bcKTYw0TpAvUcKu4qZY2Dd04xypbAP7tFTN4g/MDa
8FIIxh032HqGKMIS/6gcBTMXc+YYwxRZ03/xpYJPQtXssDcUibl/M6L8I0Ws
4/eUzCmK7A15dEAIfnPZfE4w45cvYRr0Mncttc1Q5PpvfVE7aLpo6nHFu4k9
dmLHAljDXfZfBCszmjs78t3kn+OFK2vWTZ65V4zZYGHj2hjq4Z6cVIL/ARuo
cUM=
  "],ExpressionUUID->"d6557ab2-fca0-4bd8-9f64-2fa20264b705"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYMzCrNSpmba2spbVpnNN11Zv+cU1KGyK0zm8tFGiZYJr
kBdQSheUJJqXRcgkzVhYQ9QszFu2pmmzjCwvNafQf8sFDgtW0vN8OPw+HjiH
mXslRb2JRqOlQ/hZKqWxlSJjYsVVRidFlv2v54eCHH5N+yHQ51IZPQbUyRtF
R8Dwa+wSNLZSVsEFhawAL6ptDt3FA1v8+wSoWTpViEYQdzX6WSN3oWHP5fRY
sEaXIEHvuhV1qFGY3YXa6wfOx4GZp/k61PO1R49mRG0zo49z/H6iEYagxXgw
oLgqVgAapGwZulT0ugDtsXyqRZmKd+9R+S2/HcdA2dCaHnX0p88IwfX6h74J
oMa1vQ6t2nw0WIw9ZUVSCZiomJ9DtybmOdCFPTzaSbDibKQBHRy15ijBC94T
heiNQrfwnAn28YykoMUXJzSoYJbViHbnJQ+g4cPB02hFiHgJfZpWq5aDgfvX
P6DWJDMjFUzKbotHDzZ0DIkHKdL6Vz2OHo/T9r0Cdd9tkkGQN2QrRdMj6S1o
Zf/sHNpkviO2gNE7U33egmNFLg4anKixo5LuEu4keO8MS7sK/tkn5giG4Qfu
lpcikH3KYO0doQhX8qN8HMxYybKzRimyof/iTQafBGl4jDcUiXpwO6z0I0Us
k/dVnBmKHAh8dFgEfnNYvXNg2i9vzDzo5uxdbV+gyM3f+oIO0HTZ1OuIdhIb
c2r3MljNX/NdAcvTmro6c53k3+wLR+aikzxzeoxKML9hYwINaW6bVoH/ARnp
cS8=
  "],ExpressionUUID->"641a66d4-7766-49c4-8273-8c1ea2da3cd2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "27", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{7., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "27", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  27, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 27, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYGhhVpqXTFtbWctqm3PNra3eEsI1KGyK8zK8tFHiygTX
IHWglC4oSTQvi5CFmrGwhqhZmFOzNU2bZWR5KZ1C/5kLHBaspOf5cPh9PHAO
PfdKsmoDjUZLg/CylJmmZooMixVXQ9spshhwPT8MZPGqWg+CPpdK/WNBnbxe
dBiMuMYsRrnlMj0bFDACvai2MWwnB2wK6OGjFum4Bo0k7kr0s1q+jIY/l/tz
wSpdggS961bUoCZBdgc6X9t3Pg7MOMXToZ6vXQY0PXqLBX2c4/cTjTQGz8WD
gUUVXD5olDJl6ELh6wK0y/apGqUr3r1H5bf8th0FZdZVA+rsTZsUgGu1Lb4J
oHp5aw1asfFIiBh7SgulElComJlGNwvznOjsbg7tBKg/G2VE+4fsOZngBe9x
DXpD4xacM8M+nsFktOjiqBrlTzHq0c68pD40YiBkAtXvEC+gT1OrVXIwaN/a
B9SeaAlNAROzH8ajB+rarOJ+ijT/VY2gx+K0Pa9A3XeHpB/kWB0laFqUfxNa
3js1jTZY7ohtYMz2FJ+34HDhMgsNEarnUUlnMXsMvHeGoV0B/+wVs/gD8AN7
00sRyDxptHcPUoQt+VE2AqYvZc0zhiiybvjiTQKfBKs5oW8oEv3gdnjJR4rY
xu4rWZMU2R/06JAI/Oa0e6fB1F/e2BnQzdqz0jpLkZu/DQVtoPmyudsZ4yIO
+viuRbCSt+q7BJalNnS057rIv6kXzow5F3nm8pgywfy69VG093TLhBL8DxzX
cYM=
  "],ExpressionUUID->"a91dcea0-4ae5-40a0-a5ce-ffd30be1452c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"25", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[25, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0V1I02EYBfClYGhhVi4/Ms1mWctq07nmbKu3vNFGhc2x6Rx+tFHiagmu
QepAKV1QkmiaixBDzVhYQ9QsbFMzm6ZpWa2mlk6h/8wFDgtW0vNcHH6XB86J
zruUrlxHo9GkEE62Qt7cRJEhgexySDtFFgKuFoSCTE5V637Q50KpfxyoE9cn
HwTDr8QUo/HlIj0L5DECvaj2buh2NtgY0MNFzWnjajSCuCvRzyrxEhr2TOwf
D1bpkoTobbesBm3m5XSgc7V9ZxPArBMcHer52mVAM6M2mdFHuX4/0Qhj8Gwi
GFhUEc8FjWkxInRe86oQ7Rr+WI1Gy96+Q8U3/LYcBkXWFQPq7JVO8cDV2hbf
JFC1tLkGrVh/iC7AnlJNmhDky6Yd6EZ+vhOd2cmmHQP1pyONqGXQlisHz3mP
qtFrajfvjAn28Qyko0XnR1Uo186oRzvzU/vQ8H76JKrfJphHn0iqlWIwaM/q
e9SWYg7JAFNyHiSi++rarAILRZr+KkfQIwnanpeg7vuE0AKyrRMlqDTSvxEt
77U70AbzLcEwGLs1w+cNOKRZYqJ0vmoOFXYWs8bAOycZ2mXwz24Bk9sPP7A2
vEgGY44bbd0DFGEJf5SNgJmL2XOMQYqsGb54U8HHwSp2yGuKRN2/GVbygSLD
Y/cUzCmK7A16eCAZ/Oa0eR2g5Jc3bhp0M3ctt85Q5PpvQ2EbaLpo6nbGushE
9PiOBbCSs+K7CJZJGjra81zkn/25M2vWRZ66PM1ysKBubRQ91fJpUgH+Bx01
cac=
  "],ExpressionUUID->"29aae52c-2717-44f5-8cab-580bf9da5c2e"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYGhhVpqXTFtbWctq07nm1lZv+UUbFDbF6RxecpRoLUEb
pA6U0gUlieZlEbJIMxbWEDWL5dTMpmmzrKypNafQf8sFDg1W0vN8OPw+HjiH
nnc5tWADjUbLgHCzFXJ9G0VGRLIroZ0UWQy4VhgGsri17QdBn4sV/rGgWtok
PAxGXGWWonFVEg0b5DMCvWhZS9hODtga0MdDjSmTxWgkcdegX5RSFxr+XOof
B9aqE8XoHbesHtXzc7pQe4PpXDyYdYqrRj3ferRoZvQWI/o41+8XGqkLnk8A
A0uq43igLoUpQRdUr4vQntFPdShd9u49Kr3pt+0oKDGvaFFHf8Y0H1xteOib
CCpdW+vR6o1HQkTYU6FKEYMC2awN3SzId6Bzuzm0E6DmTJQOHRi25MrB897j
xej1Yjf/rAH28QyloiUXxpUob4bRhHbnJ5vQiMGQKVSzQ7SAPk2vK5CCQftW
P6CWJGNoGpiU8yABPdDYYRYNUKTtb8EYeiy+rO8VqP5hFQ+AHLO1HM2I8m9F
q/pnbGiz8bZoFIzZnubzFhxRuVhoiEBpR8XdpewJ8O5pRtky+GeviMUbhB/Y
m14KQeZJnaV3iCJs8c/KMTBzKdvOGKbIuvarNxl8EqzkhL6hSPT9W+HlHyky
OnFPwZqmyP6gR4eE4HeHxWsD0397Y2dBN2vPcvscRW6saYs6QMMlQ68jxkms
9Mldi2ANd8V3CaxMb+7qzHOSfzMvHFnzTvLM6dHLwcLG9XHUtPZ5SgH+ByLz
cmk=
  "],ExpressionUUID->"8e43020a-7859-4374-8b84-c51c4cef6e32"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYMzCrFxTM81mWctqm3NN11Zv2QdNKGwOp3N4aaPE1RJc
g9SBUrqgJNE0FyFGmrGwhqhZmLdsTdNmGa68lE6h/5YLFBNW0vN8OPw+Hjgn
MvdKqmoDjUZLh/CzlIqmRooMieVXma0UWfC/nh8MsvmVzQdBn0sl9BhQL60T
HQZDr0UVobyyFAMHFLICvKjufvBOLtjg3yVALcljGjSMeCrQSbXUjYa8lNJ5
YKU+XoLe9cir0SZhdhs6V9NzPhbMPMXXoyvfOoxoRsQWC/o0x+8XGmYKmo0D
AwrLeQLQlByVgs5r3xagHdYvVWik/MNHVHrLb9tRMKVv2Yg6u9MnhOBqzWPf
eFDt3lqNlm88whBjT4k2WQImyKen0M0JeU50ZjeXdgI0nA03ob2DthwFeMF7
XIPe0HiE58ywz8pAKlp4cUSNChysOrQ9L6kHDe1njKOGHeJ59LmsSiUFA/et
fkJtiRZmGpiY/SgOPVDb0ifupUjjX9UweixW1/UG1P+wS3pBbp+9GE0Ppzeg
Zd2OKbTeckdsBaO3p/m8B4e0bjbKSFDPoZL2Is4oeO8MS7cEru0VswX98ANn
02sRGHXSZOscoAhH8rN0GMxYzJpjDVJk3fjVmwQ+C1Jzme8oEvHwdkjxZ4pY
Rx8o2RMU2R/45JAI/O60eadA2W9vzDToYe9Zap6hyM0/xoIW0HzZ3OmMdhF7
5NiuBbCCv+y7CJbK6ttac13kn+OVM3PWRV64VpoUYH7t+gi6dnpyXAn+Bx/r
cfI=
  "],ExpressionUUID->"234449ec-8d77-46e8-86a8-e3943c6fb03e"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYMzCrLSpmbZmWctq07mmttVbfnENCptj0zm85ChxZYJr
kDpQShekJJrmImSRZiysIWoWNi/ZmqZpGa28lE6h/8wFDgtWo+f5cPh9PHAO
M+9yesEGGo0mh/CyVUpTK0VGhIorjA6KLAVeKwwD2byatoOg38Vyehyokzal
HAYjrsaUovGVEj0HFLCCvKj2bthOLtgS2MtHLeIJDRpJ3NXoZ7V0BQ1/LqXH
gzW6JBF6262oR02CnE50oaH/XAKYdYqnQz1fuw1oZvQWC/o4N+AnGmkMmU8E
g0qq4vmgURwjQReLXxeh3bZPdShT8e49Kr0ZsO0oKBlYM6DOPvm0AFxveOif
BKpXttajVRuPhAqxp7xYLAKTFbMz6ObkfCc6t5tLOwHqz0QZUeuwPVcJnvce
16DXNW7BWTPs4xlKR0sujKlRvoPVhHblp/WjEYOhU6h+h3ARfSqrK5CCwfvW
P6D2VAsjA0zNeZCIHmhsHxBaKdL6t2AUPZag7X0F6r5Piqwgd2CyDJVH0VvQ
yj7HDNpsqRXawNjtGX5vwZHiFTYamqxeQEVdpZxx8M5plnYV/LNXyOYPwg+c
TS9TwJiTRnvPEEU4oh8Vo2DmcvYCa5giPsMXbxr4JETNZbyhSPT9W+FlHyli
G7+nYk9TZH/wo0Mp4Den3TsDyn5542ZBN3vPatscRW78NhS1g+ZL5h5nrItM
Mid2LYHVvDX/ZbBC1tzZkeci/xwvnFnzLvLM5TEpwcJG3xjqq3VMqcD/IiBy
Qg==
  "],ExpressionUUID->"947d5291-2e79-4300-aa13-1cea15c425e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{7., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYMzCrLSpmWZbWctqm3NN11Zv+UUbFDbH5g0vbZS4WoI2
yAsopQtKEs3LImSRZiysIWoWtqnZmqbNMlp5KZ1C/5kLHBaspOf5cPh9PHBO
TP7lNNUGGo2mgPCzc7KMbRQZESuvMDopshh4rTAMZPNr2w+CfhfL6XGgTtYk
OgxGXGWVoLwqaSUHFDKDfGhpS9hOLtga2CdAzakTGjSSeGrQz2rZMhr+XEbn
gbW6RAl6x6OsR43C3C50vmHgXDyYeYqvQ71fe/RoRvQWM/o4L+AnGmkImUsA
g4qreQLQkMqSogva10Voj+1THRqjfPceld0M2HYUlFpX9airXzElBNcaHvon
gurlrfVo9cYjoWLsKdemSsAk5cw0ujmpwIXO7ubSToCVZ6IMqGXYnpcFnvcd
16DXNR7hWRPs4x1KQ4svjKlRgZPZhHYXpAygEYOhk2jlDvEC+lRep5KBwfvW
PqD2ZDMjHUzOfZCAHmjssIotFGn7qxpFj8WX9r0Cdd8dEgvItTrKUEUUvRWt
6ndOo83m22IbGLs93e8tOKJdZqOhSep5VNJdwhkH755mlq6Af/aK2YJB+IGz
6aUIZJ002HuHKMKR/KgYBTOWsueZwxRZ13/xpYBPQtRcxhuKRN+/FV72kSK2
8Xs57CmK7A9+dEgEfnPZfdOg/Jcvbgb0sPestM9S5MZvfVEHaLpk6nXFuokj
ZmLXIljDX/VfAivkzV2d+W7yz/nClTnnJs/cXmMWWNi4PoZWuZyTOeB/IJpy
HA==
  "],ExpressionUUID->"439f8ebf-c030-473d-af0f-7afa5c877ae0"],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYGhhVi4vmba2spblpnPNra3e8os2KGwO5w0vbZS4WoJr
kDpQSheUJJrmJGSRZiysIWoW5i2zadoso9nU0in033KBYsFKep4Ph9/HA+cw
8q+kKjfRaLR0CC87J8vUQpERseJqSDtFlgKuF4aCbF5162HQ51KZfwyokzWI
joLh11glaFyFVM8BBcxAL6q9H7qbCzYF9PBRS8qkGo0gnir0i0rmRsNeyPzj
wGpdogS961HUoiZBbge6UNd3Ph7MPM3ToWtfuwxoRtQ2C/okz+8nGmEMnk8A
A4sr4/igMYUlRRc1b4rQrtHPNShD8f4DKrvlt+MYKB1YNaDO3vRpAbhe98g3
EVS5t9eilZtj6WLsKdOkSEChYtaBbhUWONG5vVzaSVB/NtKI9g9b87LAC94T
avSG2iM4Z4Z91oZS0eKL4yqUb2c2oJ0FyX1o+CB9CtXvEi+iz+Q1ShkYdGD9
I2pNsoSkgUm5DxPQQ/VtA+J+irT8VY6hx+O1Pa9B3XebpB/kDthK0fRI/ya0
otfuQBstd8SjYPTONJ934IjGzUbpQtUCKuks4UyA984wtSvgn/1iNn8QfuBs
eSUCWaeM1u4hinAkP8rHwIzl7AXmMEU2DDPeZPBpsIob8pYiUQ9uh5V+osjo
RHMOe5oiB4MeHxGB35xWrwOU//LGzIIe9r6V1jmK3PxtKGoDzZfN3c5oF7Ex
JvcsgVW8Vd9lsFze2NGe7yL/7C+dmfMu8ty1ZsoCC+s3xtHm2JmpHPA/HH1x
gg==
  "],ExpressionUUID->"b3750a4a-0071-4f76-b069-2aaf7db7502d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "26"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 26],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYMzCrFxeMm1tZS2rbc41ta3e8otLKGwOp1O8tFHiygTX
IC+glC4oSTTNRcgizTCsIWoWNi/ZnKZtZbTyUjqF/lsucFiwkp7nw+H38cA5
zPzLaaoNNBotAyLIzlEaWykyKlZcCe2gyFLgtcIwkCOobTsI+l0sp8eCOllT
0mEw4iq7FOVXpVZyQREryIdq74Xt5IEtgX1C1CSd0qCRxFODflbL3Gj4Cxmd
D9bqEiToHY+iHjWKcrvQhYaBc3Fg1imBDvV+7dGjmdFbTOiTvICfaKQhZD4e
DCqp5gtBg5Sdii4WvylCeyyf6lCm4t17VHYzYNtRMHVwVY86+zOmReBawyP/
BFDt3lqPVm88whBjT3mxVAImKmZn0M2JBU50bjePdgKsPBNlQM0j1jwleN53
XINe13hEZzthH+9wGlpyYUKNCh2sJrS7IGUAjRhi2NHKHeJF9Jm8TiUDg/et
fUCtyabQdDA592E8eqCxfVBspkjrX9U4eixO2/ca1H23Scwgb9BWhmZE0VvQ
qn7HDNpsui22gDHb0/3GwNFiNwdlJKoXUEl3KXcSvHuapV0B/+wVc4RD8AN3
06skkH3SYO0dpghX8qNiHMxczl5gjVBkXf/FlwI+DVHzQt9SJPrBrfCyjxSx
TN7P4UxTZH/w40NJ4Den1TcDyn/5YmdBD2fPStscRW781he1g52XOnudMS5i
Y07tWgJrBKv+y2CFvLmrI99F/jleOrPmXeS5y2tUgoWN6xOofcxtzwH/AyLP
cmQ=
  "],ExpressionUUID->"1b0d4642-01e9-4a29-90d2-cb718d93eb31"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYGhhVq6pmWazrGW16VxzttVbfnEJhs2x6Rxe2ijRWoJr
kDpQSheUJN4XIUaasbCGqFmYt2xN08yMrKk1p9B/ywUOC1bS83w4/D4eOCcq
70q6ahONRpNBuNlKRVsrRcaE8quMToosB1wvCAFZ3Or2w6DPpTL/WFAnaUw6
CoZdiy5B4ypS9WyQzwz0otrmkN0csCWgj4eaxVNFaDhxV6Gf1RIXGvpc4h8H
VusSRehdt7wWbePndKH2uoHz8WDWGa4O9XztMaCZkdvM6ONcv59ouDF4MQEM
LK6M44FGcXQquqR5XYj2WD7VoFHyd+9RyS2/HcfB1KE1A+rol83ywfW6h76J
oNq1vRat3HyMLsSeMo1YBArk8zZ0qyDfgS7s5dBOgfq0CCM6OGrNVYAXvCeL
0BtFbv45E+zjGUlHiy9OqFHeHLMR7c5PGUDDhukfUP0u4RL6VFqjkoBBB9Zn
UGuymZEBJuc8SEAP1XcMCQcp0vpXNY6eiNf2vQJ136dFgyBnaLoUlUX4t6AV
/XM2tMl8R2gBY3Zm+LwFxzQuFkoXqO2oqLuEPQk2nGVqV8E/+4Us3jD8wN7y
MgmMPm209o5QhC36UT4OZq5k25mjFNkwfPGmgE+C1RzGG4pE3r8dWvqRIpbJ
e0rWLEUOBj06kgR+c1i9NlD6yxs7D7pZ+1bbFyhy87ehsAM0XTb1OmKcZDpq
as8yWMVd810By6VNXZ15TvJv7oUja9FJnjk9bQqwoH5jAm1Ii5xRgv8BGNBw
4g==
  "],ExpressionUUID->"352aa278-7178-4a99-93dc-59c8164f9ff3"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYMzCrFxTM5dtZS2rbc41t7Z6yw+5BoXN4bwML22UaJmg
DVIHSumCkkTTXIQs0oyFNUTNwuYls2mamZHlpeYU+s9c4LBgJT3Ph8Pv44Fz
orIvJenW0Wi0FIgwQ5tuaaLIoExzmdlKkYXAq7mhIFdY1bwf9LtQSo8BDap6
6UEw/AqnCBWUK408UMwO8qHFd0O388HGwC4RalOM5aMRxFOJftarltCw5yq6
AKwyxMvR2x5NDWoRZ7ahztqes7Fg2gmhAfV+7TChqaxNNvRxVsBPNMIcMhcH
BhVWCESgWcFRovMFr/PQjqFP1WiU5t17VHUjYMthUNm7YkJd3SmTYnC19qF/
PKhf2lyDVqw/xJBhT2mBQg5KNDPT6EZJjgud3cmnHQONpyPNqH3AkZUOnvMd
zUev5XvEZ6ywj7c/CS08P6JHRVPserQ9J7EHDe9jfECN22Tz6FN1tU4FBu9Z
nUAdCTZmMpiQ+SAO3VfX0iuzU6Tpr24YPRJb3PUKNHwfl9tBfu94CZoSSW9E
y7unptEG2y3ZEBi9NdnvLThYsMRFGRK9E5W3F/FGwTun2MXL4J/dMq6oD37g
bXgpBTnHzY7Oforw5D/KhsHUxQwne4Aia6YvvkTwSYiez3xDEdb9m2ElHyky
NHpPy52kyN7gRwek4DeXwzcNqn/5YmZAD3fXcvMsRa7/NuW1gNaL1k5XtJuM
R43tWAArhSv+i2CZuqGtNdtN/k29cKXNuckzt9eSDubWrY2gJ5tZE1rwPxjB
cOs=
  "],ExpressionUUID->"fa03a6fc-ed2c-45a4-9e48-04a23093e65f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "26"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 26],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYGhhVpqXzGWzrGW1zbnm1lZv+UUTCpvD6RxecpRoLcE1
SB0opQtKEs3LImSVZhjWEDUL29RsTdPMjFZTa06h/5YLFCtW0vN8OPw+Hjgn
Ou9iWsE6Go2WAeFmK+SGVoqMiGSXQjsoshBwpTAMZHJr2vaDPufL/eNAjaRR
eBCMuBxTinIqU7UskM8I9KLq5rDtbLAloI+HGlMmitFI4qlGPyklbjT8mcSf
A9ZoEsXoLY+sDjXwc7pQR/3AmXgw6wRXg6586dGhmfRNRvRRrt8PNFIfPJcA
BpZUcXigPiUmFZ1XvSpCeywfa9Fo2dt3qOS635bDYKp5WYc6+zOm+eBq/QPf
RFDp3lyHVq0/FCLCnnJVihgUyGbs6EZBvhOd3cmmHQO1p6L0qGnYmisHz3qP
FqNXiz38052wz8pQGlpybkyJ8myMRrQ7P3kAjRgMeY9qt4nm0SfS2gIJGLRn
dQq1JhlD08GknHsJ6L6GdrPIRJHWvwWj6JF4dd9LUPNtUmwC2ebJMjQjyr8F
rey32dEm402RBYzdmu7zBhxRuZloiEDpQMXdpaxx8PZJhnoJ/L1bxOQNwg+s
DS+EYMxxvbV3iCIs8feKUTBzMdvBGKbImu6zNxl8HKxkh76mCP3ujfCyDxSx
jN9RMKcpsjfo4QEh+NVp9dpB6U9v3AzoYe5aapulyLVfuqJ2sPNCZ68z1kUm
oyd2LIDV3GXfRbBC2tTVkeci/2zPnVlzLvLUtWKQg4UNa2Po/T/0KQX4Hx3m
cZo=
  "],ExpressionUUID->"d7d9b21e-11a6-41aa-a4bc-66633ebeb527"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "0.728404`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 0.728404, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0V1I02EYBfClYMzErFxTM81mWctq07nm1lZveeMSCpvD6Rx+tFGitQRt
kDpQSheUJJofixAjzViYQ9QszKnZmqaZGVlTa06h/8wFDgtW0vNcHH6XB86J
yr2Sqt5Eo9HSIbwslbK1hSKjYsVVZgdFlvyv54eAbF512yHQ51IZPRbUyRpE
R8Cwa9HFaFxFip4DCliBXrSkKWQXF2z27+OjZulkIRpO3FXoZ41sBQ19LqPH
gdW6RAl6162oRVsF2Z2oo27gfDyYeZqnQz1fewxoRuRWM/okx+8nGm4MXkgA
A4sq4/igURqdgi5qXxegPdZPNWiU4t17VHbLb/sxMMWyZkCd/ekzAnC97pFv
IqhZ2VaLVm4+yhBjT5lWKgGFijk7GiDMc6Lze7i0k6D+bIQRHRyx5SjBC94T
heiNQrfgnAn28QynokUXxzUof5bVgHbnJQ+gYUOMD6h+p3gRfSavUcvAoP3r
06gtycxMA5OyHyagB+vbLeJBirT8VY+hx+NL+l6Buu9TkkGQa5kqRdMj6M1o
Rf+sHW003xFbwZgdaT5vwVHtChtlCDUOVNJdzJkA751hlayCf/aJ2fwh+IGz
5aUIjD5ltPUOU4Qj+VE+BmYsZzlYIxTZMHzxJoNPgzVc5huKRD64HVr6kSLW
ifsq9gxFDgQ9PiwCvzltXjso/+WNnQPd7L2rbfMUufnbUNAOmi6bep0xLjIV
Nbl7Cazirfkug+Xyxs6OXBf5N/vCmbngIl0uT6sSzK/fGEcDuvjTKvA/F7hw
0Q==
  "],ExpressionUUID->"e25cf684-db20-417c-88d9-6458702ed57e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.004869`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 0.004869, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYGhhVi4vmWazrGW1zTnn1lZv+cU1KGwO52V4aaPE1RJc
g9SBUrqgJNG8LEKMNMOwhqhZmLdsTdPMlFZTa06h/8wFDgtW0vN8OPw+Hjgn
Ou9KqmoTjUZLh3CzlVktzRQZFSmuhrRTZCngekEoyORWtR4GfS6V+seBelm9
8CgYfi2mGOWUSw0skM8I9KK6xtDdbLApoJeHmiWTGjSCuCvRz2rZChr2QubP
Aav0SWL0rltRg7bwczpRR23/+Xgw8zRXj3q+dhvRjKhtZvRJrt9PNMIUvJAA
BhZVcHigSRIjRRe1bwrRbstsNRqteP8Bld3y25EISgfXjKizL32GD67XPvJN
AtUr22vQis3H6CLsKdVKxKBAMWdHtwrynej8XjbtJGg4G2lCB0asuVngBe8J
DXpD4+af64B9PMOpaNHFcTXKszHq0a78lH40fIj+ETXsEi2iz+TVKhkYdGB9
GrUmm0PSwOSchwnoobq2QdEARZr/qsbQ4/G63teg/vuUeABkD06VoOmR/k1o
eZ/NjjaY74gsYOzONJ934Kh2hYnSBWoHKu4qZk2A984wdKvgn/0iJm8IfmBt
eSUEY06ZrD3DFGGJf5SNgRnL2Q7GCEU2jF+8KeDTYDU75C1Foh7cDiv5RBHL
xH0lc4YiB4MeHxGC35xWrx2U//LGzYFu5r7V1nmK3PxtLGwDOy539DhjXWQq
enLPEljJXfNdBsvkDZ3teS7yz/bSmbngIs9dnpYssKBuYxyd9UmcVoL/ARlF
cO0=
  "],ExpressionUUID->"73d3eb53-fdac-41d5-99b9-b3f4a9b94b7a"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYMzCrFxTM822spbVNuecsy3f8osmFDrHpnN4yVHiagmu
QepAKV1QkmiaixAjzTCsIWoWNi/ZmqYtM7K81JxC/5kLFAtW0vN8OPw+Hjgn
Mu9SWsEmGo2mgAiy1aqWZoqMSJSXme0UWfS/WhgMcgTVrYdBnwtl9GjQIGtI
OAqGXmGXoPyKVCMXFLECvKj+bvBuHtjk3ytELSkTWjSMeKrQzxrZMhryXEbn
g9WGeCl626OsRVtEOZ2os64/PQbMOiUwoGtfu01oZsQ2C/o41+8nGmYOmo8F
A4or+ULQnMJORRd0r4vQbtunGjRS+e49KrvhtyMOTB1YNaGuPsWUCFyve+gb
D2qWt9eilZuPMSTYU6ZLkYJi5ewMulWc70Ln9vJoiaDxTLgZtQ7bc1XgOe8J
LXpN6xGd7YB91obS0OLzYxpUOM1qQLvyk/vR0EHGB9S4S7KAPpXXFMjAwAPr
k6g9ycLMAJNyHsSih+rbBiRWijT/LRhFj8foe1+Bhu8OqRXkDThKUUU4vQmt
6JueQRsttyQ2MGpnhs9bcES3zEEZYo0TlXaVcMfBO6dZ+hXwz34JRzgIP3C3
vEwA2SfN9p4hinClP8pHwcylbCdrmCIbpi/eZPBJkIbHfEORiPs3Q0o/UsQ2
fk/NmaLIwcBHRxLAby67dwaU//JGz4Iezr6V1jmKXP9tKmoDOy529Lii3MQR
ObFnEawSrPougeXyxs72PDf5N/3ClTXvJs/cay0qsLB+YwxNTI+bVIP/ARbM
cKg=
  "],ExpressionUUID->"22a57518-acd8-4c3a-8be4-0f6e7a1df825"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->CompressedData["
1:eJwV0V9Ik3EYBeClYMzCrFxTM23NspbVpnNNbatfeeMSCpvidA7/tFHiagna
IHWglC4oSTTNScgizVhYY6hZ2KZmNk1bZmRNrTmFvpkLFAtW0vteHJ7LA+ew
Ci6nKzfQaLQsCD9XITe2UWRYJLvC7KTIQuC1olCQw69tPwj6Xaygx4JaaVPy
YTD8anQpGleVpuOCQnaQDy27F7qTB7YE9gpQs2RCjUYQbw36WSVdQsOeS+lx
YK02UYze8crqUaMwrwt1NfSfiwdzTvG16OrXbj2aHbXFjD7OD/iJRhhC5hLA
oJLqOAFokESnofOa18Vo98inOpQle/celd4M2HYUTLOt6FF3X9aUEFxreOif
CKqWttaj1RuPMETYU6GRiMEk2YwT3ZxU6EZnd/NoJ0DdmUgDah2y58vB877j
avS62is8a4J9VgfT0ZILYypUMM1uQi2Fqf1o+ADjA6rbIZpHn2bWKaVg8L61
SdSeYmZmgCl5DxLQA40dNpGVIm1/laPosfiy3leg9rtDbAV5Nkc5mhVJb0Gr
+qadaLP5tmgEjNme4fcWHNYscVBGksqFii2l3HHw7ml22TL4Z6+IIxiAH7ib
XiaD0ScN9p5BinDFPypHwezFXBd7iCLr+i++VPBJiIrHfEORqPu3wso/UmRk
vFXBmaLI/uBHh5LBb267zwlm/vLFzoBezp7l9lmK3PitL+4ATZdMPe4YD3Gw
JnYtgDX8Ff9FsDKzuauzwEP+Tb9w58x5yDPPqlEOFjWuj6GWVuGkAvwPHHFx
Zg==
  "],ExpressionUUID->"a1a12d95-6317-4e7f-a6d4-2c75cea66afb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 4, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYMzCrFxTM822spbVpnPNra3e8otrUNgczsvw0kaJlgmu
QepAKV1QkmiaixAjzVhYQ9QszFu2prnMjFZeSqfRf8sFDgtW0vN8OPw+Hjgn
OvdiimYdjUZLg/Cz1JktzRQZkaguMdspshh4JT8U5PCrW/eDfufL6LGgXtEg
PgiGX2aXoHEVcgMXFLKCfKjuTuh2HtgU2CNALTJ7IRpBPFXoJ63CjYY9U9Dj
wGp9ohS95VHVoi3C7A50vq7vTDyYcYKvR71fuoxoetQmC/ooJ+AnGmEKmUsA
g4or4wSgScaWowtFrwrQLuvHGjRa9fYdqrgesOUwKB9YMaLO3rQpIbha98A/
EdS6N9eilesPMSTYU1Ykk4Ii1cw0ulGU50Rnd/Jox0DDqUgT2j9sy8kEz/qO
FqJXCz3C02bYxzuUghafG9OiAgerAe3MS+5DwwcZ71HDNskC+kRZo1GAwXtW
J1FbkoWZCiZl309A99W3DUj6KdL8VzOKHonX9bwE9d8mpP0gb2CiFE2LpDeh
Fb2OabTRclNiBWO2pvq9AUeK3ByUIdLOo9LOEu44ePskS7cM/tkt4QgG4Qfu
hhdikH3cZOseoghX+qN8FExfyppnDVNkzfjZlww+DtHymK8pEnXvRljpB4pY
x++qOVMU2Rv88IAY/Oq0+aZB5S9f7Azo4exabp2lyLXfxoI20HzB3O2McZGJ
aPuORbCKv+K/BJYrGzvac13kn+O5M2PORZ66vC2ZYH792hhq/y6cVIP/AR9W
ccw=
  "],ExpressionUUID->"5a72bc03-8efd-4fac-bf06-602cec27fc87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "42", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 42, " ."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0V1I02EYBfClYMzCrNSpmWZbWctq07nm1lZveTMbFDbF+TH8aKPElQna
IHWglC4oSTTNRcgizVhYQ9QszKnZmqYtM7Kmlk6h/5YLHBaspOe5OPwuD5wT
W3ApTbWBRqNlQni5yhxjG0VGxYrLjE6KLAVeLQoH2by69gOg34VKejyolTeL
DoGRV1hlaEK1TMcBBcwgH1p+N3wHF2wN7OOj5tRJDRpFPLXoZ7XcjUY8l9MT
wDptsgS97VE0oEZBXhe60DhwNhHMPsnTot6vPXo0K2aLGX2cH/ATjTKEzCeB
QaU1CXzQkMqSoYslr4vRHuunejRW8e49Kr8RsO0IKLOs6lFnf+a0AFxrfOif
DKrdWxvQmo2HQ8XYU1mSKgGFilkHullY6ETndnFpx0Hd6WgDOjhiy88Bz/mO
adBrGo/gjAn28Q6noaXnx9Uof4bZjHYXSgfQyKHQD6guTLyIPs2oV8nB4L1r
U6gtxcxIB1PyHiSh+5s6LOJBirT9VY2hRxPL+16B2u92ySDItdgr0Mxoeita
3T/jQFvMt8RWMG57ut9bcLTEzUZDheoFVNJdxpkA75xilq+Af/aI2fwh+IGz
6aUIZJ0w2HqHKcKR/KgaA7OWcxeYIxRZ13/xScEnIWou4w1FYu7fjKj4SBHr
xD0le5oi+4IfHRSB35w2nwPM+OWLnwU97N0r7XMUuf5bX9wBmi6aep1xLmKP
ndy5BNbyVv2XwaqMlq7OAhf5N/PCmT3vIs9cXmMOWNS0Po6GKaRTSvA/FhJw
lg==
  "],ExpressionUUID->"b25f6639-59b7-4c5e-a509-32938176bf0a"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYMzCrFxeMm1tZS2rTeea2lZvSuAaFDZl84aXNkq0TNAG
qQOldEVJomkuQhZpxsIaomZhm5qtaZqZ0Wpq6RT6b7nAYcFKep4Ph9/HA+cw
8y+mKtfRaDQ5hJ+dk6Vvo8iISHEpuJMii/5XCkNADr+ufT/oc76SHg2qZc2J
B8Gwy+wyNKZaquGCQlaAFy2/G7KdB7b69wlQo2SiGA0n7lr0s0rmQkOfy+gx
YJ06XozedisaUL0wtwudbxw4EwtmJvHVqOdrjxbNiNxkRB/n+f1Ew3VBc3Fg
QGlNjADUSdhSdKHkdRHaY/lUjzIV796jsut+Ww6DUvOKFnX0y6eF4GrjQ994
UOXa3IDWrD/EEGFPZYlEDCYoZuzoxoQCBzq7k0c7BmpORehQ07A1Lws86z1a
jF4tdgtPG2Afz1AqWnpuTIUKbKxmtLsgZQANG2R8QDXbRAvo0/R6pQwM3LM6
hVqTjcFpYHLugzh0X1OHWWSiSNtf5Sh6JLa87xWo/j4pNoE882QFKo+gt6LV
/TY72mK8JbKAUVvTfN6CIyUuDspIUM2j4u4y7jh45ySrfBn8s1vEEQzCD9wN
LxNB9nGdtXeIIlzxj6pRMGMpe541TJE17RdvCvgkSMULfkORyPs3Qys+UsQy
fi+HM02RvYGPDiSC3xxWrx1M/+WNngHdnF3L7bMUufZbW9QBGi4Yeh1RTjLJ
nNixCNbyV3yXwKr0lq7OfCf5Z3vhyJxzkmdOjz4LLGxaG0NP3JBM5YD/ARj2
cPk=
  "],ExpressionUUID->"88c4bbac-32f2-4288-b66b-1bd5e3349a93"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0WtI02EYBfClYMzCrDQvmba2spbVNueaW1u96ReXVNhcTqd4yVHiygRt
kDpQyi0oSTTNRcgizVhYQ9QszKmZTdPMjCwvNafQf8sFDgtW0vN8OPw+HjiH
kXspJX8djUZLg/Azs1SmZooMSZSXQ9oosuh/tSAUZPP1LftBnwvl9BhQK28Q
HwTDr7BKUF5lso4DCpkBXrT0buh2Ltjk3y1ALbJxDRpB3NXoZ7XchYY9l9N5
oF4bL0Vvu5W1qEmY3Y7a63rPxIIZCXwt6vnaaUDTozZZ0Mc5fj/RCGPQfBwY
UFzFE4BGGSsZXSh6XYh2Dn+qQRnKd+9R+Q2/LYfBZOuKAXX0pE0JwdW6h77x
oNq1uRatWn8oWII95UUyKShSzs6gG0V5DnRuJ5d2DNSdijSifYO2HBV4zntU
g17TuIWnzbCPZyAFLT4/qkYF08wGtCMvqRcN7w/+gOq2SRbQp4qafDkYuGd1
ErUlWkJSwcTsB3HovvpWq6SPIs1/80fQI7Gl3a9A7fcJaR/ItU6UoWmR9Ca0
smd6Bm203JIMg9FbU33egkNFLjYaLFLbUWlHCWcMvHOCWboM/tktYQv64QfO
hpdikHXcaOsaoAhH+qNiBExfyrQzBymyZvjiTQKfBKm5IW8oEnX/ZljZR4oM
j93LYk9RZG/gowNi8JvD5p0BFb+8MbOgm71ruWWOItd/GwpbQfNFc5cj2kkm
GOM7FsFq/orvElihaGxvy3WSf9MvHBnzTvLM6TGpwIL6tVH0rP7kZBb4HxmB
cQs=
  "],ExpressionUUID->"7514fd48-eddf-4028-9c88-4c5e347ed963"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8.313997`", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{3.6014216956335487`*^9, 3.60145563777833*^9, 
  3.601786977403122*^9, 3.6017874025691843`*^9, 3.6063948248249283`*^9, 
  3.606395835690023*^9, 3.644794390592321*^9, 3.6447951605843*^9, 
  3.6447969633395023`*^9, 3.675606409980679*^9, 3.7409830861646767`*^9, 
  3.740984607729792*^9, 3.740984946005069*^9, 
  3.740989082466289*^9},ExpressionUUID->"87fb2e22-e938-41d6-9f56-\
cb0204ea2eff"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Example process ( p p \[LongRightArrow] ",
 StyleBox["t",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["t", "_"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "2631158b-18d5-4d7d-9244-4412ce944d31"],
 " ",
 StyleBox["t",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["t", "_"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d6190bd0-d9d9-46e0-8aa4-020d4b05deeb"],
 " )"
}], "Section",
 CellChangeTimes->{{3.740987096103485*^9, 3.740987104722731*^9}, {
  3.740987503462904*^9, 
  3.7409875501466637`*^9}},ExpressionUUID->"453420bb-6e87-4437-856c-\
5580ffe18b46"],

Cell[CellGroupData[{

Cell["Just type \[OpenCurlyDoubleQuote]Shift+Enter\[CloseCurlyDoubleQuote] to \
generate the script", "Subsection",
 CellChangeTimes->{{3.655625479682742*^9, 3.655625482385438*^9}, {
  3.656726499362267*^9, 3.656726502226275*^9}, {3.656805968752857*^9, 
  3.656805969623584*^9}, {3.658668423397647*^9, 3.6586684244836273`*^9}, {
  3.667459412871728*^9, 3.667459417433291*^9}, {3.740987235092021*^9, 
  3.740987279369536*^9}},ExpressionUUID->"a8d18927-77b6-4fc7-9377-\
6c801f220599"],

Cell[BoxData[
 RowBox[{
  RowBox[{"processname", "=", 
   RowBox[{"ToString", "[", "\"\<Top_Philic_example\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6496384352329617`*^9, 3.649638437980591*^9}, {
   3.649638563109305*^9, 3.649638564797917*^9}, 3.649638978119852*^9, 
   3.656825419822209*^9, {3.657035140257846*^9, 3.657035140727289*^9}, {
   3.658668384306283*^9, 3.658668387732682*^9}, {3.658668428187173*^9, 
   3.658668431541951*^9}, {3.667550775057249*^9, 3.667550775180711*^9}, {
   3.667578934398881*^9, 3.6675789560688763`*^9}, 3.6675793848996468`*^9, {
   3.740987112895705*^9, 
   3.7409871167021513`*^9}},ExpressionUUID->"16e3bca2-bc8e-4ccb-a81e-\
64a055dfe52d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"head", "=", 
   RowBox[{
   "\"\<import model Top_Philic_UFO\ngenerate p p > t t~ v1/v1 , v1 > t t~\n\
output \>\"", " ", "<>", "processname", "<>", "\"\<\\n\>\""}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.591608644389022*^9, 3.5916086821046257`*^9}, 
   3.591608738988839*^9, {3.591608832925962*^9, 3.591608865190431*^9}, {
   3.591608908138093*^9, 3.591608914652011*^9}, {3.5917385629265738`*^9, 
   3.5917385834266024`*^9}, {3.592115176525766*^9, 3.592115177820568*^9}, {
   3.592115217382238*^9, 3.5921152319682636`*^9}, 3.592115277707544*^9, {
   3.5921153100464005`*^9, 3.5921153402792535`*^9}, {3.5921154158613863`*^9, 
   3.5921154405562296`*^9}, {3.592115588600092*^9, 3.5921155964937057`*^9}, {
   3.59211572729994*^9, 3.59211574419477*^9}, {3.592489037122981*^9, 
   3.592489040122985*^9}, {3.592489273237321*^9, 3.5924894200475264`*^9}, {
   3.592489450167568*^9, 3.592489462617586*^9}, {3.5924895025276413`*^9, 
   3.5924895140576577`*^9}, {3.592489555407716*^9, 3.59248955880772*^9}, {
   3.592489594687771*^9, 3.5924896246378126`*^9}, {3.5925340525796127`*^9, 
   3.5925340622828293`*^9}, {3.592534693818739*^9, 3.5925347445812273`*^9}, {
   3.5925349443739796`*^9, 3.592535034448538*^9}, {3.592535069314599*^9, 
   3.5925350739946074`*^9}, {3.5925351057562633`*^9, 3.592535154085148*^9}, {
   3.5925351921492147`*^9, 3.5925352097616463`*^9}, {3.592631827406259*^9, 
   3.592631834516737*^9}, {3.592631875701412*^9, 3.5926318819313717`*^9}, {
   3.59331580019188*^9, 3.5933158022354836`*^9}, {3.593315904275263*^9, 
   3.593315969296177*^9}, {3.593316002321435*^9, 3.5933161081676207`*^9}, {
   3.59331788753334*^9, 3.5933178908233447`*^9}, {3.593317926753395*^9, 
   3.593317946353422*^9}, {3.5933180048335047`*^9, 3.5933180260035343`*^9}, 
   3.593318100543638*^9, {3.5933181447637005`*^9, 3.5933181976737742`*^9}, {
   3.5933182586338596`*^9, 3.593318268463873*^9}, 3.5933352991933603`*^9, {
   3.593335334153022*^9, 3.5933353411418343`*^9}, {3.5933797560551863`*^9, 
   3.5933797675992064`*^9}, {3.5933798006712646`*^9, 3.5933798325733204`*^9}, 
   3.593379899934239*^9, {3.5933989248850307`*^9, 3.593398950325066*^9}, {
   3.593399785706236*^9, 3.5933997899862413`*^9}, {3.5933998470163217`*^9, 
   3.593399865876348*^9}, {3.593400000286536*^9, 3.593400035286585*^9}, {
   3.593400077586644*^9, 3.593400112276693*^9}, {3.5934001963868103`*^9, 
   3.593400196776811*^9}, {3.593424597046548*^9, 3.593424597546549*^9}, {
   3.5934246802666645`*^9, 3.5934246830866685`*^9}, {3.593424715716714*^9, 
   3.5934248067368417`*^9}, {3.593425196547387*^9, 3.5934252025773954`*^9}, {
   3.593425274387496*^9, 3.5934253794676433`*^9}, {3.5934254425377316`*^9, 
   3.593425452777746*^9}, 3.5936699574002557`*^9, {3.5936719075809913`*^9, 
   3.5936719260910172`*^9}, {3.5936719600910645`*^9, 3.593672015731143*^9}, {
   3.593672080071233*^9, 3.5936720842312384`*^9}, {3.5937442630529857`*^9, 
   3.593744281851019*^9}, {3.5937690582606063`*^9, 3.5937690686106205`*^9}, {
   3.594553827701724*^9, 3.5945538277329245`*^9}, {3.5945542534144726`*^9, 
   3.594554271900505*^9}, {3.594555498955861*^9, 3.5945555049150715`*^9}, 
   3.594556912599144*^9, {3.5946187595660725`*^9, 3.5946187629200783`*^9}, {
   3.5946200070378633`*^9, 3.594620037005516*^9}, {3.5946200679715705`*^9, 
   3.594620132040883*^9}, {3.5946202816071453`*^9, 3.594620286411954*^9}, {
   3.594620568179649*^9, 3.5946205917512903`*^9}, {3.594620681045847*^9, 
   3.5946206831362505`*^9}, {3.594620726551127*^9, 3.5946207284699306`*^9}, 
   3.594694394282547*^9, {3.601456046786872*^9, 3.6014561827723103`*^9}, {
   3.601456301304119*^9, 3.601456383812664*^9}, 3.601456727762068*^9, {
   3.604839989651716*^9, 3.604840067849715*^9}, {3.604840291811432*^9, 
   3.604840304034184*^9}, {3.644805814248506*^9, 3.644805836168743*^9}, {
   3.644806474975388*^9, 3.644806500410037*^9}, {3.6448068544319887`*^9, 
   3.644806872642951*^9}, 3.64480707254172*^9, {3.644808633627316*^9, 
   3.644808647754312*^9}, {3.6448094040445004`*^9, 3.644809404930126*^9}, {
   3.6448095949446487`*^9, 3.6448095966783524`*^9}, 3.648641396469462*^9, {
   3.64921778109228*^9, 3.6492177811410227`*^9}, {3.652765102975128*^9, 
   3.6527651117823677`*^9}, {3.655625053633609*^9, 3.65562510242038*^9}, {
   3.655625186167478*^9, 3.655625223574005*^9}, {3.65562525904158*^9, 
   3.655625280647654*^9}, {3.655625328257716*^9, 3.655625399079811*^9}, {
   3.655625718554661*^9, 3.655625729732356*^9}, {3.6556491606126547`*^9, 
   3.655649180142568*^9}, {3.6568256341283693`*^9, 3.656825641878642*^9}, 
   3.657035133032629*^9, {3.658668442880075*^9, 3.658668443390081*^9}, {
   3.65986999514287*^9, 3.659869999597781*^9}, {3.6675507797512913`*^9, 
   3.667550786748271*^9}, {3.6675510092461*^9, 3.667551010515251*^9}, {
   3.6675789665060177`*^9, 3.6675789774893503`*^9}, {3.7409871284985123`*^9, 
   3.740987139261211*^9}},ExpressionUUID->"d112b89e-a0ac-4edd-b5ea-\
0e85aa7edfca"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Launchftn", "[", 
   RowBox[{"M_", ",", "ct_", ",", "ag_"}], "]"}], ":=", 
  RowBox[{"\"\<launch -n \>\"", "<>", 
   RowBox[{"ToString", "[", "M", "]"}], "<>", "\"\<_\>\"", "<>", 
   RowBox[{"ToString", "[", "ct", "]"}], "<>", "\"\<_\>\"", "<>", 
   RowBox[{"ToString", "[", "ag", "]"}], "<>", 
   "\"\<\n0\nset run_card nevents 10000\nset run_card ebeam1 6500\nset \
run_card ebeam2 6500\nset run_card ptj 15\nset run_card ptb 15\nset run_card \
etaj 5\nset run_card etab 5\nset param_card Wv1 Auto\nset param_card Mv1 \
\>\"", "<>", 
   RowBox[{"ToString", "[", "M", "]"}], "<>", "\"\<\nset param_card ct1 \>\"",
    "<>", 
   RowBox[{"ToString", "[", "ct", "]"}], "<>", 
   "\"\<\nset param_card theta1 \>\"", "<>", 
   RowBox[{"ToString", "[", "ag", "]"}], "<>", "\"\<\\n\>\""}]}]], "Input",
 CellChangeTimes->{{3.591608881413459*^9, 3.5916089426185093`*^9}, {
   3.5916089764139442`*^9, 3.591608984181841*^9}, {3.5916094388366985`*^9, 
   3.5916094397267*^9}, {3.5924898696861663`*^9, 3.5924898771961765`*^9}, {
   3.5924899118462253`*^9, 3.592489934626257*^9}, {3.5924900410264063`*^9, 
   3.5924900684864445`*^9}, {3.5924903368668203`*^9, 
   3.5924903370868206`*^9}, {3.5924903950069017`*^9, 3.592490395526902*^9}, {
   3.5924904815770226`*^9, 3.5924904879770317`*^9}, 3.5924905816071625`*^9, {
   3.592490691181323*^9, 3.5924906949913282`*^9}, {3.5924907461514*^9, 
   3.5924907548914127`*^9}, {3.592490808271487*^9, 3.5924908085314875`*^9}, {
   3.59249111735192*^9, 3.5924911228019276`*^9}, {3.592492070463254*^9, 
   3.5924921037333007`*^9}, {3.5925490547752657`*^9, 3.592549116161374*^9}, {
   3.592549150965035*^9, 3.5925492492608075`*^9}, {3.5925493854970474`*^9, 
   3.592549608000238*^9}, {3.5925496712115493`*^9, 3.5925497197276344`*^9}, {
   3.592631807235079*^9, 3.592631807999572*^9}, {3.5945565840469666`*^9, 
   3.5945566115654154`*^9}, {3.6014564049351015`*^9, 3.60145641557432*^9}, {
   3.60145647273282*^9, 3.6014565970338383`*^9}, {3.604840120710033*^9, 
   3.604840128202614*^9}, {3.604840192275465*^9, 3.604840261579953*^9}, {
   3.6448065146758738`*^9, 3.64480652213912*^9}, {3.6448066669892807`*^9, 
   3.6448067326908216`*^9}, {3.6448085431161203`*^9, 
   3.6448085494172087`*^9}, {3.6448086048836412`*^9, 3.644808620979801*^9}, {
   3.644808712809244*^9, 3.644808713111957*^9}, {3.644808927860618*^9, 
   3.6448089334662437`*^9}, {3.64864144795794*^9, 3.648641454935459*^9}, {
   3.64864156194562*^9, 3.648641565652988*^9}, {3.6486416145941467`*^9, 
   3.648641616249875*^9}, {3.652765133457983*^9, 3.652765164930368*^9}, {
   3.655625814990261*^9, 3.655625815270228*^9}, {3.655718988650882*^9, 
   3.6557190007311707`*^9}, {3.655719210918*^9, 3.655719212118081*^9}, {
   3.655719274309569*^9, 3.65571927563074*^9}, {3.656805972584817*^9, 
   3.656805975024791*^9}, {3.6568138802647333`*^9, 3.656813880792889*^9}, 
   3.6568139180003366`*^9, {3.656826022790547*^9, 3.656826023765188*^9}, {
   3.65682608821697*^9, 3.656826112594905*^9}, {3.656827376499395*^9, 
   3.6568273784659157`*^9}, 3.657035260525297*^9, {3.65703586362428*^9, 
   3.65703587630442*^9}, {3.6604879250594263`*^9, 3.6604879256509523`*^9}, {
   3.6675507965644608`*^9, 3.6675508142993793`*^9}, {3.667578997204494*^9, 
   3.66757900473116*^9}, {3.667579102167099*^9, 3.667579102958521*^9}, 
   3.667579174196974*^9, {3.740987144981882*^9, 3.740987225389525*^9}, {
   3.740987478678368*^9, 
   3.740987478932995*^9}},ExpressionUUID->"8d270e46-08cf-4e1f-a179-\
6341b22618b8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Launchftn", "[", 
  RowBox[{"1000", ",", "1", ",", 
   RowBox[{
    RowBox[{"N", "[", "Pi", "]"}], "/", "2"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"StringJoin", "@@", "%"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"head", "<>", "%"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"processname", "<>", "\"\<.ms\>\""}], ",", "%", ",", 
   "\"\<text\>\""}], "]"}]}], "Input",
 CellChangeTimes->{{3.740987422051646*^9, 3.740987466420822*^9}, {
  3.740987708592598*^9, 
  3.740987708718474*^9}},ExpressionUUID->"490c7969-1e86-453a-9f69-\
1f4222133c80"],

Cell[BoxData["\<\"launch -n 1000_1_1.5708\\n0\\nset run_card nevents \
10000\\nset run_card ebeam1 6500\\nset run_card ebeam2 6500\\nset run_card \
ptj 15\\nset run_card ptb 15\\nset run_card etaj 5\\nset run_card etab \
5\\nset param_card Wv1 Auto\\nset param_card Mv1 1000\\nset param_card ct1 \
1\\nset param_card theta1 1.5708\\n\"\>"], "Output",
 CellChangeTimes->{{3.740987424804735*^9, 3.740987480748589*^9}, 
   3.740987714842636*^9},ExpressionUUID->"17912cc0-d9a6-4413-b2d8-\
ab4a6332f8ea"],

Cell[BoxData["\<\"Top_Philic_example.ms\"\>"], "Output",
 CellChangeTimes->{{3.740987424804735*^9, 3.740987480748589*^9}, 
   3.740987714856367*^9},ExpressionUUID->"9987c56e-b6af-428b-b7bf-\
5b7aff3c6884"]
}, Open  ]]
}, Open  ]],

Cell["\<\
Put this script into MadGraph.
Run MadGraph with the following command:
./bin/mg5_aMC -f Top_Philic_example.ms\
\>", "Subsection",
 CellChangeTimes->{{3.7409876144497137`*^9, 
  3.740987650151738*^9}},ExpressionUUID->"d72b00bc-6465-4d9f-962b-\
bbc3b2370125"],

Cell[CellGroupData[{

Cell["Just type \[OpenCurlyDoubleQuote]Shift+Enter\[CloseCurlyDoubleQuote] to \
generate the script", "Subsection",
 CellChangeTimes->{{3.655625479682742*^9, 3.655625482385438*^9}, {
  3.656726499362267*^9, 3.656726502226275*^9}, {3.656805968752857*^9, 
  3.656805969623584*^9}, {3.658668423397647*^9, 3.6586684244836273`*^9}, {
  3.667459412871728*^9, 3.667459417433291*^9}, {3.740987235092021*^9, 
  3.740987279369536*^9}},ExpressionUUID->"6bf16db4-2fdd-49ce-bb36-\
bc6782990c37"],

Cell[BoxData[
 RowBox[{
  RowBox[{"processname", "=", 
   RowBox[{"ToString", "[", "\"\<Top_Philic_example\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6496384352329617`*^9, 3.649638437980591*^9}, {
   3.649638563109305*^9, 3.649638564797917*^9}, 3.649638978119852*^9, 
   3.656825419822209*^9, {3.657035140257846*^9, 3.657035140727289*^9}, {
   3.658668384306283*^9, 3.658668387732682*^9}, {3.658668428187173*^9, 
   3.658668431541951*^9}, {3.667550775057249*^9, 3.667550775180711*^9}, {
   3.667578934398881*^9, 3.6675789560688763`*^9}, 3.6675793848996468`*^9, {
   3.740987112895705*^9, 
   3.7409871167021513`*^9}},ExpressionUUID->"32d07b75-f552-4f7a-93e5-\
3d0d24010863"],

Cell[BoxData[
 RowBox[{
  RowBox[{"head", "=", 
   RowBox[{
   "\"\<import model Top_Philic_UFO\ngenerate p p > t t~ v1/v1 , v1 > t t~\n\
output \>\"", " ", "<>", "processname", "<>", "\"\<\\n\>\""}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.591608644389022*^9, 3.5916086821046257`*^9}, 
   3.591608738988839*^9, {3.591608832925962*^9, 3.591608865190431*^9}, {
   3.591608908138093*^9, 3.591608914652011*^9}, {3.5917385629265738`*^9, 
   3.5917385834266024`*^9}, {3.592115176525766*^9, 3.592115177820568*^9}, {
   3.592115217382238*^9, 3.5921152319682636`*^9}, 3.592115277707544*^9, {
   3.5921153100464005`*^9, 3.5921153402792535`*^9}, {3.5921154158613863`*^9, 
   3.5921154405562296`*^9}, {3.592115588600092*^9, 3.5921155964937057`*^9}, {
   3.59211572729994*^9, 3.59211574419477*^9}, {3.592489037122981*^9, 
   3.592489040122985*^9}, {3.592489273237321*^9, 3.5924894200475264`*^9}, {
   3.592489450167568*^9, 3.592489462617586*^9}, {3.5924895025276413`*^9, 
   3.5924895140576577`*^9}, {3.592489555407716*^9, 3.59248955880772*^9}, {
   3.592489594687771*^9, 3.5924896246378126`*^9}, {3.5925340525796127`*^9, 
   3.5925340622828293`*^9}, {3.592534693818739*^9, 3.5925347445812273`*^9}, {
   3.5925349443739796`*^9, 3.592535034448538*^9}, {3.592535069314599*^9, 
   3.5925350739946074`*^9}, {3.5925351057562633`*^9, 3.592535154085148*^9}, {
   3.5925351921492147`*^9, 3.5925352097616463`*^9}, {3.592631827406259*^9, 
   3.592631834516737*^9}, {3.592631875701412*^9, 3.5926318819313717`*^9}, {
   3.59331580019188*^9, 3.5933158022354836`*^9}, {3.593315904275263*^9, 
   3.593315969296177*^9}, {3.593316002321435*^9, 3.5933161081676207`*^9}, {
   3.59331788753334*^9, 3.5933178908233447`*^9}, {3.593317926753395*^9, 
   3.593317946353422*^9}, {3.5933180048335047`*^9, 3.5933180260035343`*^9}, 
   3.593318100543638*^9, {3.5933181447637005`*^9, 3.5933181976737742`*^9}, {
   3.5933182586338596`*^9, 3.593318268463873*^9}, 3.5933352991933603`*^9, {
   3.593335334153022*^9, 3.5933353411418343`*^9}, {3.5933797560551863`*^9, 
   3.5933797675992064`*^9}, {3.5933798006712646`*^9, 3.5933798325733204`*^9}, 
   3.593379899934239*^9, {3.5933989248850307`*^9, 3.593398950325066*^9}, {
   3.593399785706236*^9, 3.5933997899862413`*^9}, {3.5933998470163217`*^9, 
   3.593399865876348*^9}, {3.593400000286536*^9, 3.593400035286585*^9}, {
   3.593400077586644*^9, 3.593400112276693*^9}, {3.5934001963868103`*^9, 
   3.593400196776811*^9}, {3.593424597046548*^9, 3.593424597546549*^9}, {
   3.5934246802666645`*^9, 3.5934246830866685`*^9}, {3.593424715716714*^9, 
   3.5934248067368417`*^9}, {3.593425196547387*^9, 3.5934252025773954`*^9}, {
   3.593425274387496*^9, 3.5934253794676433`*^9}, {3.5934254425377316`*^9, 
   3.593425452777746*^9}, 3.5936699574002557`*^9, {3.5936719075809913`*^9, 
   3.5936719260910172`*^9}, {3.5936719600910645`*^9, 3.593672015731143*^9}, {
   3.593672080071233*^9, 3.5936720842312384`*^9}, {3.5937442630529857`*^9, 
   3.593744281851019*^9}, {3.5937690582606063`*^9, 3.5937690686106205`*^9}, {
   3.594553827701724*^9, 3.5945538277329245`*^9}, {3.5945542534144726`*^9, 
   3.594554271900505*^9}, {3.594555498955861*^9, 3.5945555049150715`*^9}, 
   3.594556912599144*^9, {3.5946187595660725`*^9, 3.5946187629200783`*^9}, {
   3.5946200070378633`*^9, 3.594620037005516*^9}, {3.5946200679715705`*^9, 
   3.594620132040883*^9}, {3.5946202816071453`*^9, 3.594620286411954*^9}, {
   3.594620568179649*^9, 3.5946205917512903`*^9}, {3.594620681045847*^9, 
   3.5946206831362505`*^9}, {3.594620726551127*^9, 3.5946207284699306`*^9}, 
   3.594694394282547*^9, {3.601456046786872*^9, 3.6014561827723103`*^9}, {
   3.601456301304119*^9, 3.601456383812664*^9}, 3.601456727762068*^9, {
   3.604839989651716*^9, 3.604840067849715*^9}, {3.604840291811432*^9, 
   3.604840304034184*^9}, {3.644805814248506*^9, 3.644805836168743*^9}, {
   3.644806474975388*^9, 3.644806500410037*^9}, {3.6448068544319887`*^9, 
   3.644806872642951*^9}, 3.64480707254172*^9, {3.644808633627316*^9, 
   3.644808647754312*^9}, {3.6448094040445004`*^9, 3.644809404930126*^9}, {
   3.6448095949446487`*^9, 3.6448095966783524`*^9}, 3.648641396469462*^9, {
   3.64921778109228*^9, 3.6492177811410227`*^9}, {3.652765102975128*^9, 
   3.6527651117823677`*^9}, {3.655625053633609*^9, 3.65562510242038*^9}, {
   3.655625186167478*^9, 3.655625223574005*^9}, {3.65562525904158*^9, 
   3.655625280647654*^9}, {3.655625328257716*^9, 3.655625399079811*^9}, {
   3.655625718554661*^9, 3.655625729732356*^9}, {3.6556491606126547`*^9, 
   3.655649180142568*^9}, {3.6568256341283693`*^9, 3.656825641878642*^9}, 
   3.657035133032629*^9, {3.658668442880075*^9, 3.658668443390081*^9}, {
   3.65986999514287*^9, 3.659869999597781*^9}, {3.6675507797512913`*^9, 
   3.667550786748271*^9}, {3.6675510092461*^9, 3.667551010515251*^9}, {
   3.6675789665060177`*^9, 3.6675789774893503`*^9}, {3.7409871284985123`*^9, 
   3.740987139261211*^9}},ExpressionUUID->"5224b1a8-e755-4d92-82c2-\
71bf84a525ee"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Launchftn", "[", 
   RowBox[{"M_", ",", "ct_", ",", "ag_"}], "]"}], ":=", 
  RowBox[{"\"\<launch -n \>\"", "<>", 
   RowBox[{"ToString", "[", "M", "]"}], "<>", "\"\<_\>\"", "<>", 
   RowBox[{"ToString", "[", "ct", "]"}], "<>", "\"\<_\>\"", "<>", 
   RowBox[{"ToString", "[", "ag", "]"}], "<>", 
   "\"\<\n0\nset run_card nevents 10000\nset run_card ebeam1 6500\nset \
run_card ebeam2 6500\nset run_card ptj 15\nset run_card ptb 15\nset run_card \
etaj 5\nset run_card etab 5\nset param_card Wv1 Auto\nset param_card Mv1 \
\>\"", "<>", 
   RowBox[{"ToString", "[", "M", "]"}], "<>", "\"\<\nset param_card ct1 \>\"",
    "<>", 
   RowBox[{"ToString", "[", "ct", "]"}], "<>", 
   "\"\<\nset param_card theta1 \>\"", "<>", 
   RowBox[{"ToString", "[", "ag", "]"}], "<>", "\"\<\\n\>\""}]}]], "Input",
 CellChangeTimes->{{3.591608881413459*^9, 3.5916089426185093`*^9}, {
   3.5916089764139442`*^9, 3.591608984181841*^9}, {3.5916094388366985`*^9, 
   3.5916094397267*^9}, {3.5924898696861663`*^9, 3.5924898771961765`*^9}, {
   3.5924899118462253`*^9, 3.592489934626257*^9}, {3.5924900410264063`*^9, 
   3.5924900684864445`*^9}, {3.5924903368668203`*^9, 
   3.5924903370868206`*^9}, {3.5924903950069017`*^9, 3.592490395526902*^9}, {
   3.5924904815770226`*^9, 3.5924904879770317`*^9}, 3.5924905816071625`*^9, {
   3.592490691181323*^9, 3.5924906949913282`*^9}, {3.5924907461514*^9, 
   3.5924907548914127`*^9}, {3.592490808271487*^9, 3.5924908085314875`*^9}, {
   3.59249111735192*^9, 3.5924911228019276`*^9}, {3.592492070463254*^9, 
   3.5924921037333007`*^9}, {3.5925490547752657`*^9, 3.592549116161374*^9}, {
   3.592549150965035*^9, 3.5925492492608075`*^9}, {3.5925493854970474`*^9, 
   3.592549608000238*^9}, {3.5925496712115493`*^9, 3.5925497197276344`*^9}, {
   3.592631807235079*^9, 3.592631807999572*^9}, {3.5945565840469666`*^9, 
   3.5945566115654154`*^9}, {3.6014564049351015`*^9, 3.60145641557432*^9}, {
   3.60145647273282*^9, 3.6014565970338383`*^9}, {3.604840120710033*^9, 
   3.604840128202614*^9}, {3.604840192275465*^9, 3.604840261579953*^9}, {
   3.6448065146758738`*^9, 3.64480652213912*^9}, {3.6448066669892807`*^9, 
   3.6448067326908216`*^9}, {3.6448085431161203`*^9, 
   3.6448085494172087`*^9}, {3.6448086048836412`*^9, 3.644808620979801*^9}, {
   3.644808712809244*^9, 3.644808713111957*^9}, {3.644808927860618*^9, 
   3.6448089334662437`*^9}, {3.64864144795794*^9, 3.648641454935459*^9}, {
   3.64864156194562*^9, 3.648641565652988*^9}, {3.6486416145941467`*^9, 
   3.648641616249875*^9}, {3.652765133457983*^9, 3.652765164930368*^9}, {
   3.655625814990261*^9, 3.655625815270228*^9}, {3.655718988650882*^9, 
   3.6557190007311707`*^9}, {3.655719210918*^9, 3.655719212118081*^9}, {
   3.655719274309569*^9, 3.65571927563074*^9}, {3.656805972584817*^9, 
   3.656805975024791*^9}, {3.6568138802647333`*^9, 3.656813880792889*^9}, 
   3.6568139180003366`*^9, {3.656826022790547*^9, 3.656826023765188*^9}, {
   3.65682608821697*^9, 3.656826112594905*^9}, {3.656827376499395*^9, 
   3.6568273784659157`*^9}, 3.657035260525297*^9, {3.65703586362428*^9, 
   3.65703587630442*^9}, {3.6604879250594263`*^9, 3.6604879256509523`*^9}, {
   3.6675507965644608`*^9, 3.6675508142993793`*^9}, {3.667578997204494*^9, 
   3.66757900473116*^9}, {3.667579102167099*^9, 3.667579102958521*^9}, 
   3.667579174196974*^9, {3.740987144981882*^9, 3.740987225389525*^9}, {
   3.740987478678368*^9, 
   3.740987478932995*^9}},ExpressionUUID->"5ccc317a-9e64-48f6-b8d2-\
9954b0f4e020"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Launchftn", "[", 
  RowBox[{"1000", ",", "1", ",", 
   RowBox[{
    RowBox[{"N", "[", "Pi", "]"}], "/", "2"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"StringJoin", "@@", "%"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"head", "<>", "%"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"processname", "<>", "\"\<.ms\>\""}], ",", "%", ",", 
   "\"\<text\>\""}], "]"}]}], "Input",
 CellChangeTimes->{{3.740987422051646*^9, 3.740987466420822*^9}, {
  3.740987708592598*^9, 
  3.740987708718474*^9}},ExpressionUUID->"71a7d2cf-9f8a-4c68-b795-\
5f90e6d73a24"],

Cell[BoxData["\<\"launch -n 1000_1_1.5708\\n0\\nset run_card nevents \
10000\\nset run_card ebeam1 6500\\nset run_card ebeam2 6500\\nset run_card \
ptj 15\\nset run_card ptb 15\\nset run_card etaj 5\\nset run_card etab \
5\\nset param_card Wv1 Auto\\nset param_card Mv1 1000\\nset param_card ct1 \
1\\nset param_card theta1 1.5708\\n\"\>"], "Output",
 CellChangeTimes->{{3.740987424804735*^9, 3.740987480748589*^9}, 
   3.740987714842636*^9},ExpressionUUID->"9e529c91-2d43-4eed-89cd-\
9fa4b539043f"],

Cell[BoxData["\<\"Top_Philic_example.ms\"\>"], "Output",
 CellChangeTimes->{{3.740987424804735*^9, 3.740987480748589*^9}, 
   3.740987714856367*^9},ExpressionUUID->"d30fe0db-9f62-4d12-94b2-\
865dcde1a81d"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{979, 801},
WindowMargins->{{1, Automatic}, {Automatic, 0}},
ShowSelection->True,
FrontEndVersion->"11.2 for Mac OS X x86 (32-bit, 64-bit Kernel) (September \
10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 229, 5, 30, "Input",ExpressionUUID->"9a9eddcf-a65b-48d3-9c0a-530dbabf8851"],
Cell[CellGroupData[{
Cell[799, 29, 262, 4, 45, "Subsubsection",ExpressionUUID->"2236e9e3-ce4b-4c63-8b1d-8fe1e0b7052f"],
Cell[CellGroupData[{
Cell[1086, 37, 761, 14, 30, "Input",ExpressionUUID->"34783483-4100-4d33-a9bf-6009fae692b7"],
Cell[1850, 53, 3338, 48, 34, "Output",ExpressionUUID->"34ce306e-d9c2-4e3e-afdc-4faee60d93da"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5225, 106, 109, 1, 30, "Input",ExpressionUUID->"6c55d96c-63b8-4f9e-9cde-0ae49829d043"],
Cell[CellGroupData[{
Cell[5359, 111, 267, 4, 24, "Print",ExpressionUUID->"2fc5e2ef-ddc7-4024-b0d9-7c5707952857"],
Cell[5629, 117, 538, 11, 24, "Print",ExpressionUUID->"31ee9abb-3028-4b85-bc29-6f8e19dd5fea"],
Cell[6170, 130, 319, 5, 24, "Print",ExpressionUUID->"c121ac54-2ac0-450e-b803-ccbbe041a760"],
Cell[6492, 137, 253, 4, 24, "Print",ExpressionUUID->"c8a9f754-7215-4a57-8fd5-a0fd87034c4a"],
Cell[6748, 143, 264, 4, 24, "Print",ExpressionUUID->"7d3ef03f-45bd-4afa-943d-34f3c17bd2dd"],
Cell[7015, 149, 316, 5, 24, "Print",ExpressionUUID->"9a028a0f-ea3c-473b-9437-484b205c9b95"],
Cell[7334, 156, 316, 5, 24, "Print",ExpressionUUID->"0e3b617a-81c6-495c-8834-e9c840805c44"],
Cell[7653, 163, 250, 3, 24, "Print",ExpressionUUID->"f4031b3f-736f-469c-834d-1aeebb72e386"],
Cell[7906, 168, 283, 4, 24, "Print",ExpressionUUID->"af075ea8-5aa8-41d8-985e-b71e52d97c4b"],
Cell[8192, 174, 255, 4, 24, "Print",ExpressionUUID->"44550818-0329-4d44-9ce1-81a037fa2976"],
Cell[8450, 180, 322, 5, 24, "Print",ExpressionUUID->"9d0292fc-cd24-4c26-9d7d-c33e41202317"]
}, Open  ]]
}, Open  ]],
Cell[8799, 189, 1186, 19, 30, "Input",ExpressionUUID->"5a8df67e-cb24-4d05-8d54-a0955363ae47"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10022, 213, 205, 4, 98, "Title",ExpressionUUID->"2af559c6-f0b3-41c3-bdab-f227e6962e9c"],
Cell[10230, 219, 238, 5, 35, "Text",ExpressionUUID->"a8b3c9c0-90bb-4471-ae50-acebbac792c6"],
Cell[CellGroupData[{
Cell[10493, 228, 985, 15, 30, "Input",ExpressionUUID->"3fa72bc5-b536-41d7-93cb-c58c2299ca2d"],
Cell[CellGroupData[{
Cell[11503, 247, 592, 9, 24, "Print",ExpressionUUID->"888052b3-b002-4c10-9559-83bb9f262f81"],
Cell[12098, 258, 607, 9, 24, "Print",ExpressionUUID->"03fdbfa7-e1dc-464f-8f64-6530995bd30f"],
Cell[12708, 269, 581, 9, 24, "Print",ExpressionUUID->"4ac7dfae-1db3-494a-8280-74efc7eb5fc0"],
Cell[13292, 280, 582, 9, 24, "Print",ExpressionUUID->"71be5579-bde9-40f7-bbdf-b4fc5088c301"],
Cell[13877, 291, 718, 13, 24, "Print",ExpressionUUID->"508bf887-0572-415a-ba12-30ca09d1104e"],
Cell[14598, 306, 616, 10, 24, "Print",ExpressionUUID->"444fa0cc-9ef8-479e-9049-2054e1b7f8a3"],
Cell[15217, 318, 570, 9, 24, "Print",ExpressionUUID->"a37ba8f7-7b39-4f48-88ea-92a91ab34835"],
Cell[15790, 329, 598, 9, 24, "Print",ExpressionUUID->"6bc8a473-59ab-47c9-9a26-1d7d4a01b0fd"],
Cell[16391, 340, 601, 9, 24, "Print",ExpressionUUID->"fc5bbc4e-c88e-458a-86d3-bd588d322a74"],
Cell[16995, 351, 599, 9, 24, "Print",ExpressionUUID->"62624519-56c8-4b49-ac46-caa044b25786"],
Cell[17597, 362, 772, 14, 44, "Print",ExpressionUUID->"8ee1dc0d-932f-473a-ac75-09ec41442531"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18418, 382, 430, 9, 30, "Input",ExpressionUUID->"96babad4-4f4b-4299-ae95-5951d9b123d5"],
Cell[CellGroupData[{
Cell[18873, 395, 952, 17, 24, "Print",ExpressionUUID->"bdd4e6d3-9da6-4eed-9427-61f43051f7c6"],
Cell[19828, 414, 956, 17, 24, "Print",ExpressionUUID->"6fe3aa28-331b-4fe1-9e33-1a125e37dba1"],
Cell[20787, 433, 958, 17, 24, "Print",ExpressionUUID->"1e74d853-90c7-40e7-98e3-a6ef96fbff74"],
Cell[21748, 452, 488, 7, 24, "Print",ExpressionUUID->"b9ce3dc4-46cf-4701-a3c5-3d750a0f014f"]
}, Open  ]],
Cell[22251, 462, 516, 9, 34, "Output",ExpressionUUID->"057e0f5a-7f38-435f-b450-2b6540762a00"]
}, Open  ]],
Cell[22782, 474, 236, 5, 35, "Text",ExpressionUUID->"0db0d3e5-0289-4717-bee3-87e98e7d09f1"],
Cell[CellGroupData[{
Cell[23043, 483, 157, 3, 30, "Input",ExpressionUUID->"76d8349c-eabf-4c01-9d24-0c01e627caf9"],
Cell[23203, 488, 764, 22, 39, "Output",ExpressionUUID->"86bf899e-9183-4c2f-a279-d13b2e3c8c3a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24004, 515, 313, 5, 67, "Section",ExpressionUUID->"487ca974-4a6c-48db-9635-b02ddbf0d1cb"],
Cell[24320, 522, 220, 5, 30, "Input",ExpressionUUID->"d4a7fcb3-091a-43f9-8fe8-352c3053145b"],
Cell[CellGroupData[{
Cell[24565, 531, 170, 3, 54, "Subsection",ExpressionUUID->"ca127d09-0b43-4447-ab0b-a0c7020d5ed8"],
Cell[24738, 536, 194, 3, 35, "Text",ExpressionUUID->"b040f9d0-2e7b-4627-8bd5-4ec881d2a6fa"],
Cell[CellGroupData[{
Cell[24957, 543, 1011, 15, 30, "Input",ExpressionUUID->"0b7086a8-5057-41cd-9eee-31f0a57e89f8"],
Cell[CellGroupData[{
Cell[25993, 562, 1104, 17, 24, "Print",ExpressionUUID->"7b5269d8-81a5-4baa-b1c6-e99e07437a26"],
Cell[27100, 581, 1100, 17, 24, "Print",ExpressionUUID->"4c779a80-7dc2-4038-bd1e-95dccb1f55ab"],
Cell[28203, 600, 1295, 24, 24, "Print",ExpressionUUID->"6f24f8fe-2a40-4b88-bfaf-fb2207371c35"],
Cell[29501, 626, 1050, 16, 24, "Print",ExpressionUUID->"3c5ee63f-ed00-4b32-bcd7-9fd484c3689a"],
Cell[30554, 644, 1043, 16, 24, "Print",ExpressionUUID->"6542c0fa-fb3c-425f-9f42-2d9937322a04"],
Cell[31600, 662, 1163, 20, 24, "Print",ExpressionUUID->"43603478-6059-499a-bbc9-d0143bb51874"],
Cell[32766, 684, 1050, 16, 24, "Print",ExpressionUUID->"144182f3-4a7e-465e-add3-f4d6d5cf0f4a"]
}, Open  ]],
Cell[33831, 703, 1029, 17, 34, "Output",ExpressionUUID->"09f9645b-47bb-47fa-9e13-d6a26c34bc83"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34909, 726, 173, 3, 54, "Subsection",ExpressionUUID->"2bbaad75-62b6-4ca1-a629-469f22a36c50"],
Cell[35085, 731, 241, 6, 35, "Text",ExpressionUUID->"685d0054-0d81-4c9e-a668-844d8781408e"],
Cell[CellGroupData[{
Cell[35351, 741, 362, 7, 30, "Input",ExpressionUUID->"57f7eee1-829b-46fd-a13c-a9d69680626b"],
Cell[CellGroupData[{
Cell[35738, 752, 545, 11, 24, "Print",ExpressionUUID->"cf11a547-f99b-4a77-9b42-3e67a610bb70"],
Cell[36286, 765, 325, 5, 24, "Print",ExpressionUUID->"04a5a3f4-468c-4dde-95aa-73964742ebe1"],
Cell[36614, 772, 337, 5, 24, "Print",ExpressionUUID->"91fc0445-7051-4614-9982-3d5cc275973f"]
}, Open  ]],
Cell[36966, 780, 130, 2, 34, "Output",ExpressionUUID->"1954bc59-4a88-414e-91e2-10bc96c9e50f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37145, 788, 163, 3, 54, "Subsection",ExpressionUUID->"67459bf3-fe05-407c-8d2e-524f1f025cd0"],
Cell[CellGroupData[{
Cell[37333, 795, 438, 7, 30, "Input",ExpressionUUID->"78e49f55-97ee-464c-bc9c-c544f46f5b00"],
Cell[CellGroupData[{
Cell[37796, 806, 735, 15, 24, "Print",ExpressionUUID->"9f3ef338-3ada-46fb-999e-f792d47a3079"],
Cell[38534, 823, 492, 7, 24, "Print",ExpressionUUID->"f72aa08f-895d-4dcc-8f77-957127362dc3"],
Cell[39029, 832, 525, 8, 24, "Print",ExpressionUUID->"bfe0ba49-b9ed-4d2e-b53e-fa827076d237"],
Cell[39557, 842, 1003, 19, 24, "Print",ExpressionUUID->"8481b4ea-6bd5-4756-a4b5-3418a81a963b"],
Cell[40563, 863, 481, 7, 24, "Print",ExpressionUUID->"a7105e2b-1a73-4e89-b07a-ce50c68fc160"]
}, Open  ]],
Cell[41059, 873, 1958, 52, 45, "Output",ExpressionUUID->"c91c4e66-debf-4ceb-a2d3-5190266b9308"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43054, 930, 517, 10, 30, "Input",ExpressionUUID->"ae7d9451-537a-40e3-97e0-5c70eca46be1"],
Cell[CellGroupData[{
Cell[43596, 944, 818, 17, 24, "Print",ExpressionUUID->"2d28abac-fa46-4ff7-a1a3-326799043523"],
Cell[44417, 963, 573, 9, 24, "Print",ExpressionUUID->"f0a10ef7-7ac7-483c-b814-c2c38227f22d"],
Cell[44993, 974, 605, 10, 24, "Print",ExpressionUUID->"235e569b-5470-4498-9f1a-2b8df0de1554"],
Cell[45601, 986, 1082, 21, 24, "Print",ExpressionUUID->"5df597bb-732c-43d9-94b7-18f17c64ee99"],
Cell[46686, 1009, 566, 9, 24, "Print",ExpressionUUID->"6640a85a-3c0c-421f-8f12-46a83d8d1ac3"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47301, 1024, 227, 5, 30, "Input",ExpressionUUID->"3e297325-bb4f-4017-a537-c138f6f2e251"],
Cell[CellGroupData[{
Cell[47553, 1033, 1007, 18, 24, "Print",ExpressionUUID->"791ce2e8-05f0-47ae-9403-5f9115cddc16"],
Cell[48563, 1053, 946, 19, 24, "Print",ExpressionUUID->"71984a10-f11d-4cf2-935d-d8f94ad62873"],
Cell[49512, 1074, 914, 18, 24, "Print",ExpressionUUID->"0e51bde3-8115-4873-8ec1-7d87d51eaf2f"]
}, Open  ]],
Cell[50441, 1095, 1420, 38, 66, "Output",ExpressionUUID->"44ccb184-70fa-497b-862d-bb95f069740f"]
}, Open  ]],
Cell[51876, 1136, 246, 5, 35, "Text",ExpressionUUID->"749014d9-cf45-49ab-af20-41d0854d3d8e"],
Cell[CellGroupData[{
Cell[52147, 1145, 359, 8, 30, "Input",ExpressionUUID->"84471270-b49a-4e84-a93f-9b35059d5eb6"],
Cell[52509, 1155, 968, 28, 66, "Output",ExpressionUUID->"36e1489d-1055-4482-8c2a-b10a706a02ff"]
}, Open  ]],
Cell[53492, 1186, 230, 5, 35, "Text",ExpressionUUID->"163c73c4-af94-4249-9f6d-004cdafad0b9"],
Cell[CellGroupData[{
Cell[53747, 1195, 613, 16, 30, "Input",ExpressionUUID->"f027b521-66dd-4400-8b53-a4d1d5446d43"],
Cell[54363, 1213, 330, 5, 34, "Output",ExpressionUUID->"09b0a6f4-daab-4861-a330-226d6e2adfea"]
}, Open  ]],
Cell[54708, 1221, 373, 7, 81, "Text",ExpressionUUID->"7c647911-84e5-482d-8c4d-973d8011026f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[55130, 1234, 160, 3, 67, "Section",ExpressionUUID->"2c5ac4fc-05bc-4cee-af9c-983f2b88ca76"],
Cell[CellGroupData[{
Cell[55315, 1241, 570, 10, 30, "Input",ExpressionUUID->"13b25c41-890d-4c26-a7ef-d58263aa84b2"],
Cell[CellGroupData[{
Cell[55910, 1255, 979, 17, 24, "Print",ExpressionUUID->"00ca5c88-c8b5-414b-9e30-2a2569f083b0"],
Cell[56892, 1274, 1202, 24, 24, "Print",ExpressionUUID->"63a5eefb-eb7d-4973-9ee6-f9b2aaf4b1df"],
Cell[58097, 1300, 957, 16, 24, "Print",ExpressionUUID->"7b52a900-f33c-4126-a07b-65584a4b4191"],
Cell[59057, 1318, 1139, 21, 24, "Print",ExpressionUUID->"d6557ab2-fca0-4bd8-9f64-2fa20264b705"],
Cell[60199, 1341, 990, 17, 24, "Print",ExpressionUUID->"641a66d4-7766-49c4-8273-8c1ea2da3cd2"],
Cell[61192, 1360, 1470, 28, 24, "Print",ExpressionUUID->"a91dcea0-4ae5-40a0-a5ce-ffd30be1452c"],
Cell[62665, 1390, 1072, 20, 24, "Print",ExpressionUUID->"29aae52c-2717-44f5-8cab-580bf9da5c2e"],
Cell[63740, 1412, 1202, 24, 24, "Print",ExpressionUUID->"8e43020a-7859-4374-8b84-c51c4cef6e32"],
Cell[64945, 1438, 957, 16, 24, "Print",ExpressionUUID->"234449ec-8d77-46e8-86a8-e3943c6fb03e"],
Cell[65905, 1456, 990, 17, 24, "Print",ExpressionUUID->"947d5291-2e79-4300-aa13-1cea15c425e2"],
Cell[66898, 1475, 1466, 28, 24, "Print",ExpressionUUID->"439f8ebf-c030-473d-af0f-7afa5c877ae0"],
Cell[68367, 1505, 948, 16, 24, "Print",ExpressionUUID->"b3750a4a-0071-4f76-b069-2aaf7db7502d"],
Cell[69318, 1523, 1301, 24, 24, "Print",ExpressionUUID->"1b0d4642-01e9-4a29-90d2-cb718d93eb31"],
Cell[70622, 1549, 971, 16, 24, "Print",ExpressionUUID->"352aa278-7178-4a99-93dc-59c8164f9ff3"],
Cell[71596, 1567, 1238, 25, 24, "Print",ExpressionUUID->"fa03a6fc-ed2c-45a4-9e48-04a23093e65f"],
Cell[72837, 1594, 1208, 24, 24, "Print",ExpressionUUID->"d7d9b21e-11a6-41aa-a4bc-66633ebeb527"],
Cell[74048, 1620, 1170, 21, 24, "Print",ExpressionUUID->"e25cf684-db20-417c-88d9-6458702ed57e"],
Cell[75221, 1643, 1156, 21, 24, "Print",ExpressionUUID->"73d3eb53-fdac-41d5-99b9-b3f4a9b94b7a"],
Cell[76380, 1666, 954, 16, 24, "Print",ExpressionUUID->"22a57518-acd8-4c3a-8be4-0f6e7a1df825"],
Cell[77337, 1684, 978, 17, 24, "Print",ExpressionUUID->"a1a12d95-6317-4e7f-a6d4-2c75cea66afb"],
Cell[78318, 1703, 1169, 21, 24, "Print",ExpressionUUID->"5a72bc03-8efd-4fac-bf06-602cec27fc87"],
Cell[79490, 1726, 1326, 24, 24, "Print",ExpressionUUID->"b25f6639-59b7-4c5e-a509-32938176bf0a"],
Cell[80819, 1752, 950, 16, 24, "Print",ExpressionUUID->"88c4bbac-32f2-4288-b66b-1bd5e3349a93"],
Cell[81772, 1770, 935, 16, 24, "Print",ExpressionUUID->"7514fd48-eddf-4028-9c88-4c5e347ed963"]
}, Open  ]],
Cell[82722, 1789, 491, 9, 34, "Output",ExpressionUUID->"87fb2e22-e938-41d6-9f56-cb0204ea2eff"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[83262, 1804, 684, 24, 68, "Section",ExpressionUUID->"453420bb-6e87-4437-856c-5580ffe18b46"],
Cell[CellGroupData[{
Cell[83971, 1832, 482, 7, 54, "Subsection",ExpressionUUID->"a8d18927-77b6-4fc7-9377-6c801f220599"],
Cell[84456, 1841, 688, 13, 30, "Input",ExpressionUUID->"16e3bca2-bc8e-4ccb-a81e-64a055dfe52d"],
Cell[85147, 1856, 4957, 70, 73, "Input",ExpressionUUID->"d112b89e-a0ac-4edd-b5ea-0e85aa7edfca"],
Cell[90107, 1928, 3509, 54, 283, "Input",ExpressionUUID->"8d270e46-08cf-4e1f-a179-6341b22618b8"],
Cell[CellGroupData[{
Cell[93641, 1986, 633, 16, 94, "Input",ExpressionUUID->"490c7969-1e86-453a-9f69-1f4222133c80"],
Cell[94277, 2004, 499, 7, 308, "Output",ExpressionUUID->"17912cc0-d9a6-4413-b2d8-ab4a6332f8ea"],
Cell[94779, 2013, 205, 3, 34, "Output",ExpressionUUID->"9987c56e-b6af-428b-b7bf-5b7aff3c6884"]
}, Open  ]]
}, Open  ]],
Cell[95011, 2020, 268, 7, 108, "Subsection",ExpressionUUID->"d72b00bc-6465-4d9f-962b-bbc3b2370125"],
Cell[CellGroupData[{
Cell[95304, 2031, 482, 7, 38, "Subsection",ExpressionUUID->"6bf16db4-2fdd-49ce-bb36-bc6782990c37"],
Cell[95789, 2040, 688, 13, 30, "Input",ExpressionUUID->"32d07b75-f552-4f7a-93e5-3d0d24010863"],
Cell[96480, 2055, 4957, 70, 73, "Input",ExpressionUUID->"5224b1a8-e755-4d92-82c2-71bf84a525ee"],
Cell[101440, 2127, 3509, 54, 283, "Input",ExpressionUUID->"5ccc317a-9e64-48f6-b8d2-9954b0f4e020"],
Cell[CellGroupData[{
Cell[104974, 2185, 633, 16, 94, "Input",ExpressionUUID->"71a7d2cf-9f8a-4c68-b795-5f90e6d73a24"],
Cell[105610, 2203, 499, 7, 308, "Output",ExpressionUUID->"9e529c91-2d43-4eed-89cd-9fa4b539043f"],
Cell[106112, 2212, 205, 3, 34, "Output",ExpressionUUID->"d30fe0db-9f62-4d12-94b2-865dcde1a81d"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

