(***************************************************************)
(******    This is the FR file for Top-philic resonance   ******)
(******                                                   ******)
(******    Authors: G.Mohlabeng                           ******)
(******                                                   ******)
(****** Choose whether Feynman gauge is desired.          ******)
(****** If set to False, unitary gauge is assumed.          ****)
(****** Feynman gauge is especially useful for            ******)
(****** CalcHEP/CompHEP where the calculation is 10-100   ******)
(****** times faster.                                     ******)
(****** Feynman gauge is not supported in MadGraph and Sherpa.**)
(***************************************************************)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "Top_Philic";

M$Information = {
  Authors      -> {"Jeong Han Kim","G. Mohlabeng"},
  Version      -> "1.0.0",
  Date         -> "04. 01. 2016",
  Institutions -> {"University of Kansas"},
  Emails       -> {"jeonghan.kim@ku.edu", "gopolang.mohlabeng@ku.edu"}
};

FeynmanGauge = False;


(* ************************** *)
(* *****  Change  log   ***** *)
(* ************************** *)

(* v1.0: initial version      *)


(* ************************** *)
(* *** Interaction orders *** *)
(* ***  (as used by mg5)  *** *)
(* ************************** *)

M$InteractionOrderHierarchy = {
  {Qv1, 8}

};

(* ************************** *)
(* *****    Indices     ***** *)
(* ************************** *)


(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)
M$ClassesDescription = {

(* Vector Fields *)

  V[7] == { 
    ClassName       -> v1, 
    SelfConjugate   -> True, 
    Mass            -> {Mv1, 1000},  
    Width           -> {Wv1, 1.0},  
    ParticleName    -> "v1", 
    PDG             -> 6000055, 
    PropagatorLabel -> "v1", 
    PropagatorType  -> Sine, 
    PropagatorArrow -> None,
    FullName        -> "v1 vector singlet"
  }
};


(* ************************** *)
(* *****     Gauge      ***** *)
(* *****   Parameters   ***** *)
(* *****   (FeynArts)   ***** *)
(* ************************** *)



(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {


(* Couplings with the vector color singlet *)

  ct1 == { 
    ParameterType    -> External,
    ParameterName    -> ct1,
    BlockName        -> v0PARAMS, 
    Value            -> 1.0,
    InteractionOrder -> {Qv1, 1},  
    TeX              -> Subscript[C,t1], 
    Description      -> "v1 singlet vector-Fermion coupling"
  },
  theta1 == { 
    ParameterType    -> External,
    ParameterName    -> theta1,
    BlockName        -> v1PARAMS, 
    Value            -> 1.5708,
    InteractionOrder -> {Qv1, 1},  
    TeX              -> Subscript[\[Theta], 1], 
    Description      -> "Vector Singlet chirality angle"
  }

};

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)

(*----------------------*)
(*      Vectors         *)
(*----------------------*)
(* PL = ProjM, PR = ProjP  *)
(* Color Singlet vector *)

Lv1 := ct1 tbar.Ga[mu].(Cos[theta1] ProjM + Sin[theta1] ProjP).t v1[mu];










