
(* This is the model file for (N)MWT Unitary gauge *)

M$ModelName = "MWT";

M$Information = {Authors -> "M. Jarvinen",
                 Date -> "30. 10. 2010",
                 Version -> 1.0
                 };


(* Index definition *)

IndexRange[ Index[Generation] ] = Range[3]

IndexRange[ Index[Colour] ] = NoUnfold[Range[3]]

IndexRange[ Index[Gluon] ] = NoUnfold[Range[8]]


IndexRange[ Index[FixedChargedVector] ] = Range[3]
IndexRange[ Index[ChargedVector] ] = Range[3]
IndexRange[ Index[FixedNeutralVector] ] = Range[4]
IndexRange[ Index[NeutralVector] ] = Range[4]
IndexRange[ Index[SU2Index] ] = Range[2]
IndexRange[ Index[SU2Adjoint] ] = Range[3]


IndexFormat[ChargedVector, f]
IndexFormat[NeutralVector, f]
IndexFormat[SU2Index, i]
IndexFormat[SU2Adjoint, k]
IndexStyle[Colour, i]
IndexStyle[Generation, f]
IndexStyle[Gluon ,a]



(* Parameter list *)

M$Parameters = {

  \[Alpha]S == {
        ParameterType -> External,
        BlockName -> SMInput,
        TeX -> Subscript[\[Alpha], s],
        ParameterName -> aS,
        InteractionOrder -> {QCD, 2},
        Value -> 0.118,
        Description -> "Strong coupling constant at the Z pole"},


  EE == {
     InteractionOrder -> {QED, 1},
     ParameterType -> External,
     Value -> 0.313429,
     TeX -> e,
     BlockName        -> SMInput,
     Description -> "Electron charge"
  },


  GF == {
     InteractionOrder -> {QED, 2},
     ParameterType -> External,
     Value -> 0.0000116637,
     TeX -> Subscript[G, F],
     BlockName        -> SMInput,
     Description -> "Fermi coupling constant"
  },

  MZ == {
     ParameterType -> External,
     Value -> 91.1876,
     TeX -> Subscript[M, Z],
     BlockName        -> SMInput,
     Description -> "Z Mass"
  },


  gt == {
     InteractionOrder -> {QED, 1},
     ParameterType -> External,
     Value -> 2,
     TeX -> Subscript[g, t],
     BlockName        -> TCInput,
     Description -> "g^tilde"
  },

  MA == {
     ParameterType -> External,
     Value -> 750,
     TeX ->  Subscript[M, A],
     BlockName        -> TCInput,
     Description -> "mass of the axial"
  },

  PS == {
     ParameterType -> External,
     Value -> 0.3,
     BlockName        -> TCInput,
     Description -> "S parameter"
  },

  rs == {
     ParameterType -> External,
     Value -> 0.,
     TeX -> Subscript[r, s],
     BlockName        -> TCInput,
     Description -> "C-M parameter"
  },

  MH == {
     ParameterType -> External,
     Value -> 200,
     TeX -> Subscript[M, H],
     BlockName        -> TCInput,
     Description -> "Higgs Mass"
  },

  MC == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 1.3,
        OrderBlock -> {4},
        Description -> "Charm quark mass"},

  MB == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 4.2,
        OrderBlock -> {5},
        Description -> "Bottom quark mass"},

  MT == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 172,
        OrderBlock -> {6},
        Description -> "Top quark mass"},

  MTA == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 1.777,
        OrderBlock -> {15},
        Description -> "Tau lepton mass"},


  gs == {
     InteractionOrder -> {QCD, 1},
     ParameterType -> Internal,
     Value -> Sqrt[4 Pi \[Alpha]S],
     TeX -> Subscript[g, s],
     ParameterName -> G,
     BlockName -> Constr,
     Description -> "Strong coupling constant (Z point)"
  },
   
  v == {
     ParameterType -> Internal, 
     Value -> Sqrt[gt^2*(2*Sqrt[2]*Pi - GF*MA^2*PS) - 4*GF*MA^2*(-4*Pi + Sqrt[2*Pi]*Sqrt[8*Pi - gt^2*PS])]/(2*Sqrt[GF*gt^2]*Sqrt[Pi]),
     BlockName        -> Constr,
     InteractionOrder -> {QED, -1},
     Description -> "SM VEV"
  },

  r3 == {
     ParameterType -> Internal, 
     Value -> (-4*GF*MA^2*(-4*Pi + Sqrt[2*Pi]*Sqrt[8*Pi - gt^2*PS]))/(gt^2*(2*Sqrt[2]*Pi - GF*MA^2*PS) - 4*GF*MA^2*(-4*Pi + Sqrt[2*Pi]*Sqrt[8*Pi - gt^2*PS])),
     TeX -> Subscript[r,3],
     BlockName        -> Constr,
     Description -> "C-M parameter"
  },

  r2 == {
     ParameterType -> Internal, 
     Value -> r3-1,
     TeX -> Subscript[r,2],
     BlockName        -> Constr,
     Description -> "C-M parameter"
  },
   
  f  ==  {
     ParameterType -> Internal, 
     Value -> Sqrt[(16*GF*MA^2*Pi + gt^2*(2*Sqrt[2]*Pi - GF*MA^2*PS))/(GF*gt^2)]/(2*Sqrt[Pi]),
     BlockName     -> Constr,
     Description -> "Vector meson mass scale"
  },

  MV == {
     ParameterType -> Internal, 
     Value -> Sqrt[gt^2/(2*Sqrt[2]*GF) + MA^2*(1 - (gt^2*PS)/(8*Pi))],
     BlockName        -> IntConstr,
     Description -> "Strong vector meson mass"
  },

  FV == {
     ParameterType -> Internal, 
     Value -> Sqrt[2]*MV/gt,
     BlockName        -> IntConstr,
     Description -> "Strong vector decay constant"
  },

  FPi == {
     ParameterType -> Internal, 
     Value -> 1/Sqrt[Sqrt[2]*GF],
     BlockName        -> IntConstr,
     Description -> "Strong pion decay constant"
  },

  FA == {
     ParameterType -> Internal, 
     Value -> Sqrt[FV^2-FPi^2],
     BlockName        -> IntConstr,
     Description -> "Strong axial decay constant"
  },


  ZM == {
     ParameterType -> Internal, 
     Value -> MZ,
     BlockName        -> InternalMasses,
     Description -> "Z mass"
  },

  g2 == {
     InteractionOrder -> {QED, 1},
     ParameterType -> Internal, 
     Value-> Sqrt[2]/Sqrt[EE^(-2) - 2/gt^2 + Sqrt[MZ^2*(MA^2 - MZ^2)*(MV^2 - MZ^2)*(FV^2 + (EE^(-2) - 2/gt^2)*(MV^2 - MZ^2))*(FA^2*MA^2 + (MA^2 - MZ^2)*(-FV^2 + MZ^2/EE^2 - (2*MZ^2)/gt^2))]/(MZ^2*(MA^2 - MZ^2)*(-MV^2 + MZ^2))],
     TeX -> Subscript[g,2],
     BlockName        -> Constr,
     Description -> "Electroweak SU2L gauge coupling"
  },
 
  g1 == {
     InteractionOrder -> {QED, 1},
     ParameterType -> Internal, 
     Value-> 1/Sqrt[1/EE^2 - 1/g2^2 - 2/gt^2],
     TeX -> Subscript[g,1],
     BlockName        -> Constr,
     Description -> "Electroweak U1Y gauge coupling"
  },


  M1N == {
     ParameterType -> Internal, 
     Value -> Sqrt[(FV^2*(g1^2 + g2^2) + 2*(MA^2 + MV^2))*MZ^2 - 2*MZ^4 - Sqrt[-16*FPi^2*MA^2*(FV^2*g1^2*g2^2 + (g1^2 + g2^2)*MV^2)*MZ^2 + 4*MZ^4*(FV^2*(g1^2 + g2^2) + 2*(MA^2 + MV^2 - MZ^2))^2]/2]/(2*MZ),
     BlockName        -> InternalMasses,
     Description -> "Neutral heavy vector meson R1 mass"
  },

  M2N == {
     ParameterType -> Internal, 
     Value -> Sqrt[(FV^2*(g1^2 + g2^2) + 2*(MA^2 + MV^2))*MZ^2 - 2*MZ^4 + Sqrt[-16*FPi^2*MA^2*(FV^2*g1^2*g2^2 + (g1^2 + g2^2)*MV^2)*MZ^2 + 4*MZ^4*(FV^2*(g1^2 + g2^2) + 2*(MA^2 + MV^2 - MZ^2))^2]/2]/(2*MZ),
     BlockName        -> InternalMasses,
     Description -> "Neutral heavy vector meson R2 mass"
  },

  ThetaC == {
     ParameterType -> Internal, 
     Value -> ArcCos[(2*FV^6*g2^6 + 3*FV^4*g2^4*(MA^2 + MV^2) + 2*(MA^2 - 2*MV^2)*(-9*FPi^2*g2^2*MA^2 + 8*MA^4 + 4*MA^2*MV^2 - 4*MV^4) + 3*FV^2*g2^2*(-3*FPi^2*g2^2*MA^2 + 2*(MA^4 - 4*MA^2*MV^2 + MV^4)))/ (2*(FV^4*g2^4 - 3*FPi^2*g2^2*MA^2 + FV^2*g2^2*(MA^2 + MV^2) + 4*(MA^4 - MA^2*MV^2 + MV^4))^(3/2))],
     BlockName        -> IntConstr,
     Description -> "Charged vector meson mass angle"  
  },

  MW == {
     ParameterType -> Internal, 
     Value -> Sqrt[((FV^2*g2^2)/2 + MA^2 + MV^2)/3 - (Sqrt[FV^4*g2^4 + 3*FA^2*g2^2*MA^2 + FV^2*g2^2*(-2*MA^2 + MV^2) + 4*(MA^4 - MA^2*MV^2 + MV^4)]*Sin[Pi/6 + ThetaC/3])/3],
     BlockName        -> InternalMasses,
     Description -> "W mass"
  },


  M1C == {
     ParameterType -> Internal, 
     Value -> Sqrt[((FV^2*g2^2)/2 + MA^2 + MV^2)/3 - (Sqrt[FV^4*g2^4 + 3*FA^2*g2^2*MA^2 + FV^2*g2^2*(-2*MA^2 + MV^2) + 4*(MA^4 - MA^2*MV^2 + MV^4)]*Sin[Pi/6 - ThetaC/3])/3],
     BlockName        -> InternalMasses,
     Description -> "Charged heavy vector meson R1 mass"
  },

  M2C == {
     ParameterType -> Internal, 
     Value -> Sqrt[((FV^2*g2^2)/2 + MA^2 + MV^2)/3 + (Sqrt[FV^4*g2^4 + 3*FA^2*g2^2*MA^2 + FV^2*g2^2*(-2*MA^2 + MV^2) + 4*(MA^4 - MA^2*MV^2 + MV^4)]*Cos[ThetaC/3])/3],
     BlockName        -> InternalMasses,
     Description -> "Charged heavy vector meson R2 mass"
  },

  HM == {
     ParameterType -> Internal, 
     Value -> MH,
     BlockName        -> InternalMasses,
     Description -> "Higgs Mass"     
  },

  CM == {
        ParameterType -> Internal,
        BlockName -> InternalMasses,
        Value -> MC,
        Description -> "Charm mass"},

  BM == {
        ParameterType -> Internal,
        BlockName -> InternalMasses,
        Value -> MB,
        Description -> "Bottom mass"},

  TM == {
        ParameterType -> Internal,
        BlockName -> InternalMasses,
        Value -> MT,
        Description -> "Top mass"},

  TAM == {
        ParameterType -> Internal,
        BlockName -> InternalMasses,
        Value -> MTA,
        Description -> "Tau mass"},

  VC11 == { 
     ParameterType -> Internal,
     Value -> g2^2*FV^2/2,
     BlockName -> Mixing
  },

  VC12 == { 
     ParameterType -> Internal,
     Value -> -g2*FA*MA/2,
     BlockName -> Mixing
  },

  VC13 == { 
     ParameterType -> Internal,
     Value -> -g2*FV*MV/2,
     BlockName -> Mixing
  },

  VC21 == { 
     ParameterType -> Internal,
     Value -> VC12,
     BlockName -> Mixing
  },

  VC22 == { 
     ParameterType -> Internal,
     Value -> MA^2,
     BlockName -> Mixing
  },

  VC23 == { 
     ParameterType -> Internal,
     Value -> 0,
     BlockName -> Mixing
  },

  VC31 == { 
     ParameterType -> Internal,
     Value -> VC13,
     BlockName -> Mixing
  },

  VC32 == { 
     ParameterType -> Internal,
     Value -> 0,
     BlockName -> Mixing
  },

  VC33 == { 
     ParameterType -> Internal,
     Value -> MV^2,
     BlockName -> Mixing  
  },

  VN11 == {
     ParameterType -> Internal,
     Value -> g1^2*FV^2/2  ,
     BlockName -> Mixing
  },

  VN12 == {
     ParameterType -> Internal,
     Value -> 0  ,
     BlockName -> Mixing
  },

  VN13 == {
     ParameterType -> Internal,
     Value -> g1*FA*MA/2,
     BlockName -> Mixing
  },

  VN14 == {
     ParameterType -> Internal,
     Value -> -g1*FV*MV/2,
     BlockName -> Mixing  
  },

  VN21 == {
     ParameterType -> Internal,
     Value -> 0,
     BlockName -> Mixing
  },

  VN22 == {
     ParameterType -> Internal,
     Value -> g2^2*FV^2/2,
     BlockName -> Mixing
  },

  VN23 == {
     ParameterType -> Internal,
     Value -> -g2*FA*MA/2,
     BlockName -> Mixing
  },

  VN24 == {
     ParameterType -> Internal,
     Value -> -g2*FV*MV/2,
     BlockName -> Mixing
  }, 

  VN31 == {
     ParameterType -> Internal,
     Value -> VN13,
     BlockName -> Mixing
  },

  VN32 == {
     ParameterType -> Internal,
     Value -> VN23,
     BlockName -> Mixing
  },

  VN33 == {
     ParameterType -> Internal,
     Value -> MA^2,
     BlockName -> Mixing
  },

  VN34 == {
     ParameterType -> Internal,
     Value -> 0,
     BlockName -> Mixing
  },

  VN41 == {
     ParameterType -> Internal,
     Value -> VN14,
     BlockName -> Mixing
  },

  VN42 == {
     ParameterType -> Internal,
     Value -> VN24,
     BlockName -> Mixing
  },

  VN43 == {
     ParameterType -> Internal,
     Value -> 0,
     BlockName -> Mixing
  },

  VN44 == {
     ParameterType -> Internal,
     Value -> MV^2,
     BlockName -> Mixing
  },


  CN1 == {
     ParameterType -> Internal, 
     Description -> "Charged vector meson normalization factor",
     Value -> 1/Sqrt[(-MW^2 + VC22)^2*VC13^2 + VC12^2*(MW^2 - VC33)^2 + (-MW^2 + VC22)^2*(MW^2 - VC33)^2],
     BlockName -> Mixing
  },

  CN2 == {
     ParameterType -> Internal, 
     Description -> "Charged vector meson normalization factor",
     Value -> 1/Sqrt[(-M1C^2 + VC22)^2*VC13^2 + VC12^2*(M1C^2 - VC33)^2 + (-M1C^2 + VC22)^2*(M1C^2 - VC33)^2],
     BlockName -> Mixing
  },

  CN3 == {
     ParameterType -> Internal, 
     Description -> "Charged vector meson normalization factor",
     Value -> 1/Sqrt[(-M2C^2 + VC22)^2*VC13^2 + VC12^2*(M2C^2 - VC33)^2 + (-M2C^2 + VC22)^2*(M2C^2 - VC33)^2],
     BlockName -> Mixing
  },
  

  C11 == {
     ParameterType -> Internal, 
     Description -> "Charged vector meson mixing matrix element in VA base",
     Value -> (-MW^2 + VC22)*(-MW^2 + VC33)*CN1,
     BlockName -> Mixing
  },

  C12 == {
     ParameterType -> Internal, 
     Description -> "Charged vector meson mixing matrix element in VA base",
     Value -> (-M1C^2 + VC22)*(-M1C^2 + VC33)*CN2,
     BlockName -> Mixing
  },

  C13 == {
     ParameterType -> Internal, 
     Description -> "Charged vector meson mixing matrix element in VA base",
     Value -> (-M2C^2 + VC22)*(-M2C^2 + VC33)*CN3,
     BlockName -> Mixing
  },

  C21 == {
     ParameterType -> Internal, 
     Description -> "Charged vector meson mixing matrix element in VA base",
     Value -> VC12*(MW^2 - VC33)*CN1,
     BlockName -> Mixing
  },

  C22 == {
     ParameterType -> Internal, 
     Description -> "Charged vector meson mixing matrix element in VA base",
     Value -> VC12*(M1C^2 - VC33)*CN2,
     BlockName -> Mixing
  },

  C23 == {
     ParameterType -> Internal, 
     Description -> "Charged vector meson mixing matrix element in VA base",
     Value -> VC12*(M2C^2 - VC33)*CN3,
     BlockName -> Mixing
  },

  C31 == {
     ParameterType -> Internal, 
     Description -> "Charged vector meson mixing matrix element in VA base",
     Value -> (MW^2 - VC22)*VC13*CN1,
     BlockName -> Mixing
  },

  C32 == {
     ParameterType -> Internal, 
     Description -> "Charged vector meson mixing matrix element in VA base",
     Value -> (M1C^2 - VC22)*VC13*CN2,
     BlockName -> Mixing
  },

  C33 == {
     ParameterType -> Internal, 
     Description -> "Charged vector meson mixing matrix element in VA base",
     Value -> (M2C^2 - VC22)*VC13*CN3,
     BlockName -> Mixing
  },

  NN2 == {
     ParameterType -> Internal, 
     Description -> "Neutral vector meson normalization factor",
     Value -> 1/Sqrt[(g1 - g2)^2*(g1 + g2)^2*gt^2*(MZ^2 - VN33)^2*VN24^2 + g1^2*g2^2*(MZ^2 - VN33)^2*(Sqrt[2]*g2*VN24 + gt*(MZ^2 - VN44))^2 + g2^2*(MZ^2 - VN33)^2*(Sqrt[2]*g1^2*VN24 + g2*gt*(MZ^2 - VN44))^2 + VN23^2*(2*Sqrt[2]*g1^2*g2*VN24 + (g1^2 + g2^2)*gt*(MZ^2 - VN44))^2],
     BlockName -> Mixing
  },

  NN3 == {
     ParameterType -> Internal, 
     Description -> "Neutral vector meson normalization factor",
     Value -> 1/Sqrt[(g1 - g2)^2*(g1 + g2)^2*gt^2*(M1N^2 - VN33)^2*VN24^2 + g1^2*g2^2*(M1N^2 - VN33)^2*(Sqrt[2]*g2*VN24 + gt*(M1N^2 - VN44))^2 + g2^2*(M1N^2 - VN33)^2*(Sqrt[2]*g1^2*VN24 + g2*gt*(M1N^2 - VN44))^2 + VN23^2*(2*Sqrt[2]*g1^2*g2*VN24 + (g1^2 + g2^2)*gt*(M1N^2 - VN44))^2],
     BlockName -> Mixing
  },

  NN4 == {
     ParameterType -> Internal, 
     Description -> "Neutral vector meson normalization factor",
     Value -> 1/Sqrt[(g1 - g2)^2*(g1 + g2)^2*gt^2*(M2N^2 - VN33)^2*VN24^2 + g1^2*g2^2*(M2N^2 - VN33)^2*(Sqrt[2]*g2*VN24 + gt*(M2N^2 - VN44))^2 +  g2^2*(M2N^2 - VN33)^2*(Sqrt[2]*g1^2*VN24 + g2*gt*(M2N^2 - VN44))^2 + VN23^2*(2*Sqrt[2]*g1^2*g2*VN24 + (g1^2 + g2^2)*gt*(M2N^2 - VN44))^2],
     BlockName -> Mixing
  },


  N11 == {
     ParameterType -> Internal, 
     Description -> "Neutral vector meson mixing matrix element in VA base",
     Value -> EE/g1,
     BlockName -> Mixing
  },

  N12 == {
     ParameterType -> Internal, 
     Description -> "Neutral vector meson mixing matrix element in VA base",
     Value -> g1*g2*(-MZ^2 + VN33)*(Sqrt[2]*g2*VN24 + gt*(MZ^2 - VN44))*NN2,
     BlockName -> Mixing
  },

  N13 == {
     ParameterType -> Internal, 
     Description -> "Neutral vector meson mixing matrix element in VA base",
     Value -> g1*g2*(-M1N^2 + VN33)*(Sqrt[2]*g2*VN24 + gt*(M1N^2 - VN44))*NN3,
     BlockName -> Mixing
  },

  N14 == {
     ParameterType -> Internal, 
     Description -> "Neutral vector meson mixing matrix element in VA base",
     Value -> g1*g2*(-M2N^2 + VN33)*(Sqrt[2]*g2*VN24 + gt*(M2N^2 - VN44))*NN4,
     BlockName -> Mixing
  },

  N21 == {
     ParameterType -> Internal, 
     Description -> "Neutral vector meson mixing matrix element in VA base",
     Value -> EE/g2,
     BlockName -> Mixing
  },

  N22 == {
     ParameterType -> Internal, 
     Description -> "Neutral vector meson mixing matrix element in VA base",
     Value -> -(g2*(-MZ^2 + VN33)*(Sqrt[2]*g1^2*VN24 + g2*gt*(MZ^2 - VN44)))*NN2,
     BlockName -> Mixing
  },

  N23 == {
     ParameterType -> Internal, 
     Description -> "Neutral vector meson mixing matrix element in VA base",
     Value -> -(g2*(-M1N^2 + VN33)*(Sqrt[2]*g1^2*VN24 + g2*gt*(M1N^2 - VN44)))*NN3,
     BlockName -> Mixing
  },

  N24 == {
     ParameterType -> Internal, 
     Description -> "Neutral vector meson mixing matrix element in VA base",
     Value -> -(g2*(-M2N^2 + VN33)*(Sqrt[2]*g1^2*VN24 + g2*gt*(M2N^2 - VN44)))*NN4,
     BlockName -> Mixing
  },

  N31 == {
     ParameterType -> Internal, 
     Description -> "Neutral vector meson mixing matrix element in VA base",
     Value -> 0,
     BlockName -> Mixing
  },

  N32 == {
     ParameterType -> Internal, 
     Description -> "Neutral vector meson mixing matrix element in VA base",
     Value -> VN23*(2*Sqrt[2]*g1^2*g2*VN24 + (g1^2 + g2^2)*gt*(MZ^2 - VN44))*NN2,
     BlockName -> Mixing
  },

  N33 == {
     ParameterType -> Internal, 
     Description -> "Neutral vector meson mixing matrix element in VA base",
     Value -> VN23*(2*Sqrt[2]*g1^2*g2*VN24 + (g1^2 + g2^2)*gt*(M1N^2 - VN44))*NN3,
     BlockName -> Mixing
  },

  N34 == {
     ParameterType -> Internal, 
     Description -> "Neutral vector meson mixing matrix element in VA base",
     Value -> VN23*(2*Sqrt[2]*g1^2*g2*VN24 + (g1^2 + g2^2)*gt*(M2N^2 - VN44))*NN4,
     BlockName -> Mixing
  },

  N41 == {
     ParameterType -> Internal, 
     Description -> "Neutral vector meson mixing matrix element in VA base",
     Value -> Sqrt[2]*EE/gt,
     BlockName -> Mixing
  },

  N42 == {
     ParameterType -> Internal, 
     Description -> "Neutral vector meson mixing matrix element in VA base",
     Value -> (g1^2 - g2^2)*gt*(-MZ^2 + VN33)*VN24*NN2,
     BlockName -> Mixing
  },

  N43 == {
     ParameterType -> Internal, 
     Description -> "Neutral vector meson mixing matrix element in VA base",
     Value -> (g1^2 - g2^2)*gt*(-M1N^2 + VN33)*VN24*NN3,
     BlockName -> Mixing
  },

  N44 == {
     ParameterType -> Internal, 
     Description -> "Neutral vector meson mixing matrix element in VA base",
     Value -> (g1^2 - g2^2)*gt*(-M2N^2 + VN33)*VN24*NN4,
     BlockName -> Mixing
  },




   yl == {
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        Value -> {yl[1] -> 0, yl[2] -> 0, yl[3] -> Sqrt[2] MTA / v},
        ParameterName -> {yl[1] -> ye, yl[2] -> ymu, yl[3] -> yta},
        InteractionOrder -> {QED, 1},
        ComplexParameter -> False,
        Definitions -> {yl[1] -> 0, yl[2] ->0},
        Description -> "Lepton Yukawa coupling"},

   yu == {
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        Value -> {yu[1] -> 0, yu[2] -> Sqrt[2] MC / v, yu[3] -> Sqrt[2] MT / v},
        ParameterName -> {yu[1] -> yu, yu[2] -> yc, yu[3] -> yt},
        InteractionOrder -> {QED, 1},
        ComplexParameter -> False,
        Definitions -> {yu[1] -> 0},
        Description -> "U-quark Yukawa coupling"},

   yd == {
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        Value -> {yd[1] -> 0, yd[2] -> 0, yd[3] -> Sqrt[2] MB / v},
        ParameterName -> {yd[1] -> yd, yd[2] -> ys, yd[3] -> yb},
        InteractionOrder -> {QED, 1},
        ComplexParameter -> False,
        Definitions -> {yd[1] -> 0, yd[2] -> 0},
        Description -> "D-quark Yukawa coupling"},

   cabi == {
        TeX -> Subscript[\[Theta], c],
        ParameterType -> External,
        BlockName -> CKMBLOCK,
        OrderBlock -> {1},
        Value -> 0.227736,
        Description -> "Cabibbo angle"},

  CKM == {
       Indices -> {Index[Generation], Index[Generation]},
       TensorClass -> CKM,
       Unitary -> True,
       Definitions -> {CKM[3, 3] -> 1,
                       CKM[i_, 3] :> 0 /; i != 3,
                       CKM[3, i_] :> 0 /; i != 3},
       Value -> {CKM[1,2] -> Sin[cabi],
                   CKM[1,1] -> Cos[cabi],
                   CKM[2,1] -> -Sin[cabi],
                   CKM[2,2] -> Cos[cabi]},
       Description -> "CKM-Matrix"},

  CKMT == {
       Indices -> {Index[Generation], Index[Generation]},
       TensorClass -> CKM,
       Unitary -> True,
       Definitions -> {CKMT[3, 3] -> 1,
                       CKMT[i_, 3] :> 0 /; i != 3,
                       CKMT[3, i_] :> 0 /; i != 3},
       Value -> {CKMT[1,2] -> -Sin[cabi],
                   CKMT[1,1] -> Cos[cabi],
                   CKMT[2,1] -> Sin[cabi],
                   CKMT[2,2] -> Cos[cabi]},
       Description -> "Hermitean conjugate of CKM-Matrix"}

}


(* Gauge group list *)

M$GaugeGroups = {

  U1Y == {
        Abelian -> True,
        GaugeBoson -> B,
        Charge -> Y,
        CouplingConstant -> g1},

  SU2L == {
        Abelian -> False,
        GaugeBoson -> Wi,
        StructureConstant -> Eps,
        CouplingConstant -> g2
  },

  SU3C == {
        Abelian -> False,
        GaugeBoson -> G,
        StructureConstant -> f,
        SymmetricTensor -> dSUN,
        Representations -> {T, Colour},
        CouplingConstant -> gs}

}


Wind=1;ACind=2;VCind=3;
Aind=1;Zind=2;ANind=3;VNind=4;

CM[1,1] = C11; CM[1,2] = C12;CM[1,3] = C13; CM[2,1] = C21;CM[2,2] = C22;CM[2,3] = C23;CM[3,1] = C31;CM[3,2] = C32;CM[3,3] = C33;
NM[1,1] = N11; NM[1,2] = N12; NM[1,3] = N13; NM[1,4] = N14; NM[2,1] = N21; NM[2,2] = N22; NM[2,3] = N23; NM[2,4] = N24; NM[3,1] = N31; NM[3,2] = N32; NM[3,3] = N33; NM[3,4] = N34; NM[4,1] = N41; NM[4,2] = N42; NM[4,3] = N43; NM[4,4] = N44;

(* Particle classes list *)

M$ClassesDescription = {

  S[1] == {
      ClassName -> H,
      SelfConjugate -> True,
      Mass -> {HM,Internal},
      PDG -> 25, 
      Width -> {wH,1.},
      FullName -> "Composite Higgs boson"
  },

  V[1] == {
      ClassName -> VN,
      ClassMembers -> {A,Z,R1N,R2N},
      SelfConjugate -> True,
      Indices -> {Index[NeutralVector]},
      FlavorIndex -> NeutralVector,
      ParticleName -> {"A","Z","R1","R2"},
      PropagatorType -> C,
      PropagatorArrow -> None,
      PDG -> {22,23,50,51}, 
      Mass -> {0,{ZM,Internal},{M1N,Internal},{M2N,Internal}},
      Width -> {0,{wZ,2.4952},{w1N,1.},{w2N,1.}},
      FullName -> {"Photon", "Z boson", "Neutral R1", "Neutral R2" }
  },


  V[2] == {
      ClassName -> VC,
      ClassMembers -> {W,R1C,R2C},
      SelfConjugate -> False,
      Indices -> {Index[ChargedVector]},
      FlavorIndex -> ChargedVector,
      ParticleName -> {"W+","R1+","R2+"},
      AntiParticleName -> {"W-","R1-","R2-"},
      QuantumNumbers -> {Q -> 1},
      PropagatorType -> C,
      PropagatorArrow -> None,
      PDG -> {24,52,53}, 
      Mass -> {{MW,Internal},{M1C,Internal},{M2C,Internal}},
      Width -> {{wW,2.141},{w1C,1.},{w2C,1.}},
      FullName -> {"W boson", "Charged R1", "Charged R2" }
  },

 
  V[3] == {
        ClassName -> B,
        Unphysical -> True,
	SelfConjugate -> True,
        Definitions -> {B[mu_] -> Sum[NM[Aind,f] VN[mu,f],{f,4}]},
	Indices -> {},
	Mass -> 0,
        FullName -> "U1Y B gauge field"
  },

  V[4] == {
        ClassName -> VCt,
        Unphysical -> True,
	SelfConjugate -> False,
        Definitions -> Table[VCt[mu_,k] -> Sum[CM[k,f] VC[mu,f],{f,3}],{k,3}],
        Indices -> {Index[ChargedVector]},
	Mass -> 0 ,
        FullName -> "Charged vector strong and weak eigenstates"
  },

  V[5] == {
        ClassName -> Wi,
        Unphysical -> True,
        Definitions -> {Wi[mu_, 1] -> (VCt[mu,Wind] + VCtbar[mu,Wind])/Sqrt[2],
                        Wi[mu_, 2] -> (VCtbar[mu,Wind] - VCt[mu,Wind])/Sqrt[2]/I,
                        Wi[mu_, 3] -> Sum[NM[Zind,f] VN[mu,f],{f,4}]},
        SelfConjugate -> True,
        Indices -> {Index[SU2Adjoint]},
        FlavorIndex -> SU2Adjoint,
        Mass -> 0,
        PDG -> {1,2,3},
        FullName -> "SU2L W gauge field"
  },

  V[6] == {
      ClassName -> VV,
      Unphysical -> True,
      SelfConjugate -> True,
      Indices -> {Index[SU2Adjoint]},
      FlavorIndex -> SU2Adjoint,
      Definitions->{VV[mu_,1]->(VCt[mu,VCind]+VCtbar[mu,VCind])/Sqrt[2],VV[mu_,2]->(VCtbar[mu,VCind]-VCt[mu,VCind])/Sqrt[2]/I,VV[mu_,3]-> Sum[(NM[VNind,f]) VN[mu,f],{f,4}]},
      Mass -> 0,
      FullName -> "Strong vector state"
  },       

  V[7] == {
      ClassName -> AV,
      Unphysical -> True,
      SelfConjugate -> True,
      Indices -> {Index[SU2Adjoint]},
      FlavorIndex -> SU2Adjoint,
      Definitions->{AV[mu_,1]->(VCt[mu,ACind]+VCtbar[mu,ACind])/Sqrt[2],AV[mu_,2]->(VCtbar[mu,ACind]-VCt[mu,ACind])/Sqrt[2]/I,AV[mu_,3] ->Sum[(NM[ANind,f]) VN[mu,f],{f,4}]},
      Mass -> 0,
      FullName -> "Strong axial state"
  },       

  V[8] ==  {
      ClassName -> AL,
      Unphysical -> True,
      SelfConjugate -> True,
      Indices -> {Index[SU2Adjoint]},
      FlavorIndex -> SU2Adjoint,
      Definitions->{AL[mu_,k_]->(VV[mu,k]+AV[mu,k])/Sqrt[2]},
      Mass -> 0,
      FullName -> "Left handed strong vector"
  },

  V[9] ==  {
      ClassName -> AR,
      Unphysical -> True,
      SelfConjugate -> True,
      Indices -> {Index[SU2Adjoint]},
      FlavorIndex -> SU2Adjoint,
      Definitions->{AR[mu_,k_]->(VV[mu,k]-AV[mu,k])/Sqrt[2]},
      Mass -> 0,
      FullName -> "Right handed strong vector"
  },

  V[10] == {
        ClassName -> G,
	SelfConjugate -> True,
	Indices -> {Index[Gluon]},
	Mass -> 0,
        Width -> 0,
        PropagatorLabel -> G,
	PropagatorType -> C,
	PropagatorArrow -> None,
        PDG -> 21,
        FullName -> "Gluon" },

  F[1] == {
        ClassName -> vl,
        ClassMembers -> {ve,vm,vt},
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation]},
        Mass -> 0,
        Width -> 0,
	QuantumNumbers -> {LeptonNumber -> 1},
	PropagatorLabel -> {"v", "ve", "vm", "vt"} ,
	PropagatorType -> S,
	PropagatorArrow -> Forward,
        PDG -> {12,14,16},
        FullName -> {"Neutrino", "Mu-neutrino", "Tau-neutrino"} },

	(* Leptons (electron): I_3 = -1/2, Q = -1 *)
  F[2] == {
        ClassName -> l,
        ClassMembers -> {e, mu, ta},
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation]},
	Mass -> {Ml, {ME, 0}, {MMU, 0}, {TAM, Internal}},
        Width -> 0,
	QuantumNumbers -> {Q -> -1, LeptonNumber -> 1},
	PropagatorLabel -> {"l", "e", "mu", "ta"},
	PropagatorType -> Straight,
        ParticleName -> {"e-", "mu-", "ta-"},
        AntiParticleName -> {"e+", "mu+", "ta+"},
	PropagatorArrow -> Forward,
        PDG -> {11, 13, 15},
        FullName -> {"Electron", "Muon", "Tau"} },

	(* Quarks (u): I_3 = +1/2, Q = +2/3 *)
  F[3] == {
        ClassMembers -> {u, c, t},
        ClassName -> uq,
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation], Index[Colour]},
	Mass -> {Mu, {MU, 0}, {CM, Internal}, {TM, Internal}},
        Width -> {0, 0, {wT, 1.50833649}},
	QuantumNumbers -> {Q -> 2/3},
	PropagatorLabel -> {"uq", "u", "c", "t"},
	PropagatorType -> Straight,
	PropagatorArrow -> Forward,
        PDG -> {2, 4, 6}, 
        FullName -> {"u-quark", "c-quark", "t-quark"}},

	(* Quarks (d): I_3 = -1/2, Q = -1/3 *) 
  F[4] == {
        ClassMembers -> {d, s, b},
        ClassName -> dq,
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation], Index[Colour]},
	Mass -> {Md, {MD, 0}, {MS, 0}, {BM, Internal}},
        Width -> 0,
	QuantumNumbers -> {Q -> -1/3},
	PropagatorLabel -> {"dq", "d", "s", "b"},
	PropagatorType -> Straight, 
	PropagatorArrow -> Forward,
        PDG -> {1,3,5},
        FullName -> {"d-quark", "s-quark", "b-quark"} },

 	U[1] == {
       ClassName -> ghG,
       SelfConjugate -> False,
       Indices -> {Index[Gluon]},
       Ghost -> G,
       Mass -> 0,
       QuantumNumbers -> {GhostNumber -> 1},
       PropagatorLabel -> uG,
       PropagatorType -> GhostDash,
       PropagatorArrow -> Forward}

}



(************* Lagrangian *************)

SM = {{(v+H)/Sqrt[2],0},{0,(v+H)/Sqrt[2]}};
SMbar = {{(v+H)/Sqrt[2],0},{0,(v+H)/Sqrt[2]}};

WMX[mu_]={{Wi[mu,3]/2,(Wi[mu,1]-I Wi[mu,2])/2},{(Wi[mu,1]+I Wi[mu,2])/2,-Wi[mu,3]/2}};
BMX[mu_]={{B[mu]/2,0}, {0,-B[mu]/2}};

DSM[mu_] = del[SM, mu] - I g2 WMX[mu].SM + I g1 SM.BMX[mu]

DSMbar[mu_] = del[SMbar, mu]  + I g2 SMbar.WMX[mu] - I g1 BMX[mu].SMbar

AMXL[mu_] = {{AL[mu,3]/2,(AL[mu,1]-I AL[mu,2])/2}, {(AL[mu,1]+I AL[mu,2])/2,-AL[mu,3]/2}};

AMXR[mu_] = {{AR[mu,3]/2,(AR[mu,1]-I AR[mu,2])/2}, {(AR[mu,1]+I AR[mu,2])/2,-AR[mu,3]/2}};

CL[mu_] = AMXL[mu]-g2/gt WMX[mu];
CR[mu_] = AMXR[mu]-g1/gt BMX[mu];

FTB[mu_,nu_] = del[ BMX[nu],mu] -del[BMX[mu],nu]
FTW[mu_,nu_] = del[ WMX[nu],mu] -del[WMX[mu],nu] - I g2 WMX[mu].WMX[nu] + I g2  WMX[nu].WMX[mu];  
FTL[mu_,nu_] = del[ AMXL[nu],mu] -del[AMXL[mu],nu] -I gt AMXL[mu].AMXL[nu] + I gt  AMXL[nu].AMXL[mu];  
FTR[mu_,nu_] = del[ AMXR[nu],mu] -del[AMXR[mu],nu] -I gt AMXR[mu].AMXR[nu] + I gt  AMXR[nu].AMXR[mu];  	     


Lkin = -1/2 Tr[FTB[mu,nu].FTB[mu,nu]+FTW[mu,nu].FTW[mu,nu]+FTL[mu,nu].FTL[mu,nu]+FTR[mu,nu].FTR[mu,nu]]+ 1/2 Tr[DSM[mu].DSMbar[mu]]

LHiggs = MH^2/4*Tr[SM.SM] -MH^2/v^2/8*Tr[SM.SM]^2;

LMV = gt^2*f^2/4*Tr[CL[mu].CL[mu]+CR[mu].CR[mu]];

LRT = 1/4 gt^2 rs Tr[CL[mu].CL[mu] + CR[mu].CR[mu]]*(Tr[SM.SMbar]-v*v) - gt^2 r2 Tr[CL[mu].SM.CR[mu].SMbar] - I/4 gt r3 Tr[CL[mu].(SM.DSMbar[mu] - DSM[mu].SMbar) + CR[mu].(SMbar.DSM[mu] - DSMbar[mu].SM)];

(* LGA = -2 rg/v^2 Tr[FTL[mu,nu].SM.FTR[mu,nu].SMbar]; *)

(* SM coupling: Copied from sm.fr *)

LQCD = - 1/4 (del[G[nu, a1], mu] - del[G[mu, a1], nu] + gs f[a1, a2, a3] G[mu, a2] G[nu, a3])*(del[G[nu, a1], mu] - del[G[mu, a1], nu] + gs f[a1, a4, a5] G[mu, a4] G[nu, a5])+gs (uqbar.Ga[mu].T[a].uq + dqbar.Ga[mu].T[a].dq)G[mu, a];

Lkinferm = I uqbar.Ga[mu].del[uq, mu] + 
    	I dqbar.Ga[mu].del[dq, mu] + 
    	I lbar.Ga[mu].del[l, mu] + 
    	I vlbar.Ga[mu].del[vl, mu];


    LBright = 
     -2 g1 B[mu]/2 lbar.Ga[mu].ProjP.l +           (*Y_lR=-2*)
    	4 g1/3 B[mu]/2 uqbar.Ga[mu].ProjP.uq -       (*Y_uR=4/3*)
    	2 g1/3 B[mu]/2 dqbar.Ga[mu].ProjP.dq;        (*Y_dR=-2/3*)

    LBleft = 
     - g1 B[mu]/2 vlbar.Ga[mu].ProjM.vl -          (*Y_LL=-1*)
    	g1 B[mu]/2 lbar.Ga[mu].ProjM.l  +           (*Y_LL=-1*)
    	g1/3 B[mu]/2 uqbar.Ga[mu].ProjM.uq +        (*Y_QL=1/3*)
    	g1/3 B[mu]/2 dqbar.Ga[mu].ProjM.dq ;        (*Y_QL=1/3*)
	
     LWleft = g2/2(
	   vlbar.Ga[mu].ProjM.vl Wi[mu, 3] -              (*sigma3 = ( 1   0 )*)
    	lbar.Ga[mu].ProjM.l Wi[mu, 3] +                (*         ( 0  -1 )*)
    	
    	Sqrt[2] vlbar.Ga[mu].ProjM.l VCt[mu,Wind] +
    	Sqrt[2] lbar.Ga[mu].ProjM.vl VCtbar[mu,Wind]+
    	
    	uqbar.Ga[mu].ProjM.uq Wi[mu, 3] -              (*sigma3 = ( 1   0 )*)
    	dqbar.Ga[mu].ProjM.dq Wi[mu, 3] +              (*         ( 0  -1 )*)
    	
    	Sqrt[2] uqbar.Ga[mu].ProjM.CKM.dq VCt[mu,Wind] +
    	Sqrt[2] dqbar.Ga[mu].ProjM.CKMT.uq VCtbar[mu,Wind]
    	);

LYuk =     Module[{s,n,m,i},                                           -
	      yd[n]              dqbar[s,n,i].dq[s,n,i] (v+H)/Sqrt[2]  -
	      yu[n]              uqbar[s,n,i].uq[s,n,i] (v+H)/Sqrt[2]  -
	      yl[n]               lbar[s,n].l[s,n]      (v+H)/Sqrt[2]
           ];

LGhost := Block[{dBRSTG},
	dBRSTG[mu_,a_] :=  Module[{a2, a3}, del[ghG[a], mu] + gs f[a,a2,a3] G[mu,a2] ghG[a3]];
		- ghGbar[a].del[dBRSTG[mu,a],mu]
           ];



LMWT =  Lkin + LHiggs + LMV + LRT (*+ LGA*) + LQCD + Lkinferm + LBright + LBleft + LWleft + LYuk + LGhost;
