(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     94658,       1704]
NotebookOptionsPosition[     91303,       1602]
NotebookOutlinePosition[     91640,       1617]
CellTagsIndexPosition[     91597,       1614]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
NMWT unitary
\
\>", "Section",
 CellChangeTimes->{
  3.445242980634373*^9, {3.445243144155546*^9, 3.445243158570893*^9}, {
   3.44587971025315*^9, 3.445879713172297*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.480337101043145*^9, 3.480337102223115*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", 
    "\"\</home/mjarvine/tyo/mathematica/FeynRules1.4.10\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{"<<", "FeynRules`"}], "\n", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/NMWT\>\""}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4126590568924417`*^9, 3.412659075768538*^9}, {
  3.423416384793591*^9, 3.423416395796236*^9}, {3.4234174151520243`*^9, 
  3.423417420076274*^9}, {3.444997930489234*^9, 3.444997941732589*^9}, {
  3.445529811323807*^9, 3.445529830232614*^9}, {3.480094134990833*^9, 
  3.480094156327805*^9}, {3.480150658326394*^9, 3.48015065943001*^9}, {
  3.491288833374482*^9, 3.49128883414081*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{
  3.445529814787496*^9, 3.445533025293488*^9, 3.445535198536064*^9, 
   3.445546049937073*^9, 3.445548797753678*^9, 3.445549098311731*^9, 
   3.445588383990693*^9, 3.445627806754886*^9, 3.445627984946419*^9, 
   3.445628053839826*^9, 3.445628666487432*^9, 3.445630662691926*^9, 
   3.445631760047992*^9, 3.445631865651937*^9, 3.445631962504141*^9, {
   3.4457531303929*^9, 3.445753158762741*^9}, 3.445879730990545*^9, 
   3.445879793985706*^9, 3.445883397164449*^9, 3.445972311319879*^9, 
   3.445974227771637*^9, 3.446292149633505*^9, 3.446292462398337*^9, 
   3.446292548128168*^9, 3.4462926976046*^9, 3.476195969575441*^9, 
   3.478338790840331*^9, 3.478343868536508*^9, 3.478344047983948*^9, {
   3.480094146350314*^9, 3.480094157103242*^9}, 3.480137908531589*^9, 
   3.480148255369634*^9, 3.480150718618345*^9, 3.480162727366457*^9, 
   3.480334913979917*^9, 3.480337138121744*^9, 3.480415435023273*^9, 
   3.480416213916008*^9, 3.480495431488316*^9, 3.480495619819866*^9, 
   3.481447065900251*^9, 3.481447351599817*^9, 3.481644755751576*^9, 
   3.481644790207347*^9, 3.481645055032385*^9, 3.481645156232592*^9, 
   3.481645260311283*^9, 3.481645727809657*^9, 3.481647353819152*^9, 
   3.481647456396417*^9, 3.481647548996483*^9, 3.4816482572837*^9, 
   3.481654602881448*^9, 3.483022096104306*^9, 3.483441447414538*^9, 
   3.483444030258551*^9, 3.483696294277061*^9, 3.483696441365173*^9, 
   3.488889159485963*^9, 3.490428344051142*^9, 3.490428455030256*^9, 
   3.490605344462699*^9, 3.490814693294052*^9, 3.491288863779177*^9, 
   3.491303801941978*^9, 3.491303991476303*^9, 3.491304652911572*^9, 
   3.491306279669183*^9, 3.491306866172633*^9, 3.492965609545695*^9, 
   3.493013335844268*^9, 3.493014170320645*^9, 3.493014785979743*^9, 
   3.493036083229056*^9, 3.493110303258415*^9, 3.493110611544669*^9, 
   3.493111966094203*^9, 3.493113074239531*^9, 3.493114294066177*^9, 
   3.493115256325878*^9, 3.493116751986789*^9, 3.493118863880127*^9, 
   3.493119332295832*^9, 3.493120893711637*^9, 3.493122001074701*^9, 
   3.493122919104534*^9, 3.493123645202591*^9, 3.493124171634506*^9, 
   3.493124448709216*^9, 3.493124515182798*^9, 3.493124951298302*^9, 
   3.493125415906132*^9, 3.493125666843701*^9, 3.493126236797454*^9, 
   3.493174542238378*^9, 3.493183554988619*^9, {3.496650852981347*^9, 
   3.496650873355477*^9}, 3.497006568309196*^9, {3.497007161969832*^9, 
   3.497007187289688*^9}, 3.497007235644422*^9, 3.497007758741729*^9, 
   3.497012400154595*^9, 3.497080174514282*^9, 3.497081056897665*^9, 
   3.497082460970443*^9, 3.497084362991616*^9, 3.497084401553769*^9, 
   3.497169827305061*^9, 3.49717158973341*^9, 3.497171758102639*^9, 
   3.497172093869636*^9, 3.497174991192086*^9, 3.497185769567561*^9, 
   3.497186256252353*^9, 3.49718749369645*^9, 3.497254256770513*^9, 
   3.49728209743195*^9, 3.497345781360556*^9, 3.497449290544097*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"1.4.10\"\>"}],
  SequenceForm["Version: ", "1.4.10"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.445529814787496*^9, 3.445533025293488*^9, 3.445535198536064*^9, 
   3.445546049937073*^9, 3.445548797753678*^9, 3.445549098311731*^9, 
   3.445588383990693*^9, 3.445627806754886*^9, 3.445627984946419*^9, 
   3.445628053839826*^9, 3.445628666487432*^9, 3.445630662691926*^9, 
   3.445631760047992*^9, 3.445631865651937*^9, 3.445631962504141*^9, {
   3.4457531303929*^9, 3.445753158762741*^9}, 3.445879730990545*^9, 
   3.445879793985706*^9, 3.445883397164449*^9, 3.445972311319879*^9, 
   3.445974227771637*^9, 3.446292149633505*^9, 3.446292462398337*^9, 
   3.446292548128168*^9, 3.4462926976046*^9, 3.476195969575441*^9, 
   3.478338790840331*^9, 3.478343868536508*^9, 3.478344047983948*^9, {
   3.480094146350314*^9, 3.480094157103242*^9}, 3.480137908531589*^9, 
   3.480148255369634*^9, 3.480150718618345*^9, 3.480162727366457*^9, 
   3.480334913979917*^9, 3.480337138121744*^9, 3.480415435023273*^9, 
   3.480416213916008*^9, 3.480495431488316*^9, 3.480495619819866*^9, 
   3.481447065900251*^9, 3.481447351599817*^9, 3.481644755751576*^9, 
   3.481644790207347*^9, 3.481645055032385*^9, 3.481645156232592*^9, 
   3.481645260311283*^9, 3.481645727809657*^9, 3.481647353819152*^9, 
   3.481647456396417*^9, 3.481647548996483*^9, 3.4816482572837*^9, 
   3.481654602881448*^9, 3.483022096104306*^9, 3.483441447414538*^9, 
   3.483444030258551*^9, 3.483696294277061*^9, 3.483696441365173*^9, 
   3.488889159485963*^9, 3.490428344051142*^9, 3.490428455030256*^9, 
   3.490605344462699*^9, 3.490814693294052*^9, 3.491288863779177*^9, 
   3.491303801941978*^9, 3.491303991476303*^9, 3.491304652911572*^9, 
   3.491306279669183*^9, 3.491306866172633*^9, 3.492965609545695*^9, 
   3.493013335844268*^9, 3.493014170320645*^9, 3.493014785979743*^9, 
   3.493036083229056*^9, 3.493110303258415*^9, 3.493110611544669*^9, 
   3.493111966094203*^9, 3.493113074239531*^9, 3.493114294066177*^9, 
   3.493115256325878*^9, 3.493116751986789*^9, 3.493118863880127*^9, 
   3.493119332295832*^9, 3.493120893711637*^9, 3.493122001074701*^9, 
   3.493122919104534*^9, 3.493123645202591*^9, 3.493124171634506*^9, 
   3.493124448709216*^9, 3.493124515182798*^9, 3.493124951298302*^9, 
   3.493125415906132*^9, 3.493125666843701*^9, 3.493126236797454*^9, 
   3.493174542238378*^9, 3.493183554988619*^9, {3.496650852981347*^9, 
   3.496650873355477*^9}, 3.497006568309196*^9, {3.497007161969832*^9, 
   3.497007187289688*^9}, 3.497007235644422*^9, 3.497007758741729*^9, 
   3.497012400154595*^9, 3.497080174514282*^9, 3.497081056897665*^9, 
   3.497082460970443*^9, 3.497084362991616*^9, 3.497084401553769*^9, 
   3.497169827305061*^9, 3.49717158973341*^9, 3.497171758102639*^9, 
   3.497172093869636*^9, 3.497174991192086*^9, 3.497185769567561*^9, 
   3.497186256252353*^9, 3.49718749369645*^9, 3.497254256770513*^9, 
   3.49728209743195*^9, 3.497345781360556*^9, 3.497449290686975*^9}],

Cell[BoxData["\<\"Authors: C. Duhr, N. Christensen, B. Fuks\"\>"], "Print",
 CellChangeTimes->{
  3.445529814787496*^9, 3.445533025293488*^9, 3.445535198536064*^9, 
   3.445546049937073*^9, 3.445548797753678*^9, 3.445549098311731*^9, 
   3.445588383990693*^9, 3.445627806754886*^9, 3.445627984946419*^9, 
   3.445628053839826*^9, 3.445628666487432*^9, 3.445630662691926*^9, 
   3.445631760047992*^9, 3.445631865651937*^9, 3.445631962504141*^9, {
   3.4457531303929*^9, 3.445753158762741*^9}, 3.445879730990545*^9, 
   3.445879793985706*^9, 3.445883397164449*^9, 3.445972311319879*^9, 
   3.445974227771637*^9, 3.446292149633505*^9, 3.446292462398337*^9, 
   3.446292548128168*^9, 3.4462926976046*^9, 3.476195969575441*^9, 
   3.478338790840331*^9, 3.478343868536508*^9, 3.478344047983948*^9, {
   3.480094146350314*^9, 3.480094157103242*^9}, 3.480137908531589*^9, 
   3.480148255369634*^9, 3.480150718618345*^9, 3.480162727366457*^9, 
   3.480334913979917*^9, 3.480337138121744*^9, 3.480415435023273*^9, 
   3.480416213916008*^9, 3.480495431488316*^9, 3.480495619819866*^9, 
   3.481447065900251*^9, 3.481447351599817*^9, 3.481644755751576*^9, 
   3.481644790207347*^9, 3.481645055032385*^9, 3.481645156232592*^9, 
   3.481645260311283*^9, 3.481645727809657*^9, 3.481647353819152*^9, 
   3.481647456396417*^9, 3.481647548996483*^9, 3.4816482572837*^9, 
   3.481654602881448*^9, 3.483022096104306*^9, 3.483441447414538*^9, 
   3.483444030258551*^9, 3.483696294277061*^9, 3.483696441365173*^9, 
   3.488889159485963*^9, 3.490428344051142*^9, 3.490428455030256*^9, 
   3.490605344462699*^9, 3.490814693294052*^9, 3.491288863779177*^9, 
   3.491303801941978*^9, 3.491303991476303*^9, 3.491304652911572*^9, 
   3.491306279669183*^9, 3.491306866172633*^9, 3.492965609545695*^9, 
   3.493013335844268*^9, 3.493014170320645*^9, 3.493014785979743*^9, 
   3.493036083229056*^9, 3.493110303258415*^9, 3.493110611544669*^9, 
   3.493111966094203*^9, 3.493113074239531*^9, 3.493114294066177*^9, 
   3.493115256325878*^9, 3.493116751986789*^9, 3.493118863880127*^9, 
   3.493119332295832*^9, 3.493120893711637*^9, 3.493122001074701*^9, 
   3.493122919104534*^9, 3.493123645202591*^9, 3.493124171634506*^9, 
   3.493124448709216*^9, 3.493124515182798*^9, 3.493124951298302*^9, 
   3.493125415906132*^9, 3.493125666843701*^9, 3.493126236797454*^9, 
   3.493174542238378*^9, 3.493183554988619*^9, {3.496650852981347*^9, 
   3.496650873355477*^9}, 3.497006568309196*^9, {3.497007161969832*^9, 
   3.497007187289688*^9}, 3.497007235644422*^9, 3.497007758741729*^9, 
   3.497012400154595*^9, 3.497080174514282*^9, 3.497081056897665*^9, 
   3.497082460970443*^9, 3.497084362991616*^9, 3.497084401553769*^9, 
   3.497169827305061*^9, 3.49717158973341*^9, 3.497171758102639*^9, 
   3.497172093869636*^9, 3.497174991192086*^9, 3.497185769567561*^9, 
   3.497186256252353*^9, 3.49718749369645*^9, 3.497254256770513*^9, 
   3.49728209743195*^9, 3.497345781360556*^9, 3.497449290697447*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.445529814787496*^9, 3.445533025293488*^9, 3.445535198536064*^9, 
   3.445546049937073*^9, 3.445548797753678*^9, 3.445549098311731*^9, 
   3.445588383990693*^9, 3.445627806754886*^9, 3.445627984946419*^9, 
   3.445628053839826*^9, 3.445628666487432*^9, 3.445630662691926*^9, 
   3.445631760047992*^9, 3.445631865651937*^9, 3.445631962504141*^9, {
   3.4457531303929*^9, 3.445753158762741*^9}, 3.445879730990545*^9, 
   3.445879793985706*^9, 3.445883397164449*^9, 3.445972311319879*^9, 
   3.445974227771637*^9, 3.446292149633505*^9, 3.446292462398337*^9, 
   3.446292548128168*^9, 3.4462926976046*^9, 3.476195969575441*^9, 
   3.478338790840331*^9, 3.478343868536508*^9, 3.478344047983948*^9, {
   3.480094146350314*^9, 3.480094157103242*^9}, 3.480137908531589*^9, 
   3.480148255369634*^9, 3.480150718618345*^9, 3.480162727366457*^9, 
   3.480334913979917*^9, 3.480337138121744*^9, 3.480415435023273*^9, 
   3.480416213916008*^9, 3.480495431488316*^9, 3.480495619819866*^9, 
   3.481447065900251*^9, 3.481447351599817*^9, 3.481644755751576*^9, 
   3.481644790207347*^9, 3.481645055032385*^9, 3.481645156232592*^9, 
   3.481645260311283*^9, 3.481645727809657*^9, 3.481647353819152*^9, 
   3.481647456396417*^9, 3.481647548996483*^9, 3.4816482572837*^9, 
   3.481654602881448*^9, 3.483022096104306*^9, 3.483441447414538*^9, 
   3.483444030258551*^9, 3.483696294277061*^9, 3.483696441365173*^9, 
   3.488889159485963*^9, 3.490428344051142*^9, 3.490428455030256*^9, 
   3.490605344462699*^9, 3.490814693294052*^9, 3.491288863779177*^9, 
   3.491303801941978*^9, 3.491303991476303*^9, 3.491304652911572*^9, 
   3.491306279669183*^9, 3.491306866172633*^9, 3.492965609545695*^9, 
   3.493013335844268*^9, 3.493014170320645*^9, 3.493014785979743*^9, 
   3.493036083229056*^9, 3.493110303258415*^9, 3.493110611544669*^9, 
   3.493111966094203*^9, 3.493113074239531*^9, 3.493114294066177*^9, 
   3.493115256325878*^9, 3.493116751986789*^9, 3.493118863880127*^9, 
   3.493119332295832*^9, 3.493120893711637*^9, 3.493122001074701*^9, 
   3.493122919104534*^9, 3.493123645202591*^9, 3.493124171634506*^9, 
   3.493124448709216*^9, 3.493124515182798*^9, 3.493124951298302*^9, 
   3.493125415906132*^9, 3.493125666843701*^9, 3.493126236797454*^9, 
   3.493174542238378*^9, 3.493183554988619*^9, {3.496650852981347*^9, 
   3.496650873355477*^9}, 3.497006568309196*^9, {3.497007161969832*^9, 
   3.497007187289688*^9}, 3.497007235644422*^9, 3.497007758741729*^9, 
   3.497012400154595*^9, 3.497080174514282*^9, 3.497081056897665*^9, 
   3.497082460970443*^9, 3.497084362991616*^9, 3.497084401553769*^9, 
   3.497169827305061*^9, 3.49717158973341*^9, 3.497171758102639*^9, 
   3.497172093869636*^9, 3.497174991192086*^9, 3.497185769567561*^9, 
   3.497186256252353*^9, 3.49718749369645*^9, 3.497254256770513*^9, 
   3.49728209743195*^9, 3.497345781360556*^9, 3.497449290713821*^9}],

Cell[BoxData["\<\"Please cite: arXiv:0806.4194\"\>"], "Print",
 CellChangeTimes->{
  3.445529814787496*^9, 3.445533025293488*^9, 3.445535198536064*^9, 
   3.445546049937073*^9, 3.445548797753678*^9, 3.445549098311731*^9, 
   3.445588383990693*^9, 3.445627806754886*^9, 3.445627984946419*^9, 
   3.445628053839826*^9, 3.445628666487432*^9, 3.445630662691926*^9, 
   3.445631760047992*^9, 3.445631865651937*^9, 3.445631962504141*^9, {
   3.4457531303929*^9, 3.445753158762741*^9}, 3.445879730990545*^9, 
   3.445879793985706*^9, 3.445883397164449*^9, 3.445972311319879*^9, 
   3.445974227771637*^9, 3.446292149633505*^9, 3.446292462398337*^9, 
   3.446292548128168*^9, 3.4462926976046*^9, 3.476195969575441*^9, 
   3.478338790840331*^9, 3.478343868536508*^9, 3.478344047983948*^9, {
   3.480094146350314*^9, 3.480094157103242*^9}, 3.480137908531589*^9, 
   3.480148255369634*^9, 3.480150718618345*^9, 3.480162727366457*^9, 
   3.480334913979917*^9, 3.480337138121744*^9, 3.480415435023273*^9, 
   3.480416213916008*^9, 3.480495431488316*^9, 3.480495619819866*^9, 
   3.481447065900251*^9, 3.481447351599817*^9, 3.481644755751576*^9, 
   3.481644790207347*^9, 3.481645055032385*^9, 3.481645156232592*^9, 
   3.481645260311283*^9, 3.481645727809657*^9, 3.481647353819152*^9, 
   3.481647456396417*^9, 3.481647548996483*^9, 3.4816482572837*^9, 
   3.481654602881448*^9, 3.483022096104306*^9, 3.483441447414538*^9, 
   3.483444030258551*^9, 3.483696294277061*^9, 3.483696441365173*^9, 
   3.488889159485963*^9, 3.490428344051142*^9, 3.490428455030256*^9, 
   3.490605344462699*^9, 3.490814693294052*^9, 3.491288863779177*^9, 
   3.491303801941978*^9, 3.491303991476303*^9, 3.491304652911572*^9, 
   3.491306279669183*^9, 3.491306866172633*^9, 3.492965609545695*^9, 
   3.493013335844268*^9, 3.493014170320645*^9, 3.493014785979743*^9, 
   3.493036083229056*^9, 3.493110303258415*^9, 3.493110611544669*^9, 
   3.493111966094203*^9, 3.493113074239531*^9, 3.493114294066177*^9, 
   3.493115256325878*^9, 3.493116751986789*^9, 3.493118863880127*^9, 
   3.493119332295832*^9, 3.493120893711637*^9, 3.493122001074701*^9, 
   3.493122919104534*^9, 3.493123645202591*^9, 3.493124171634506*^9, 
   3.493124448709216*^9, 3.493124515182798*^9, 3.493124951298302*^9, 
   3.493125415906132*^9, 3.493125666843701*^9, 3.493126236797454*^9, 
   3.493174542238378*^9, 3.493183554988619*^9, {3.496650852981347*^9, 
   3.496650873355477*^9}, 3.497006568309196*^9, {3.497007161969832*^9, 
   3.497007187289688*^9}, 3.497007235644422*^9, 3.497007758741729*^9, 
   3.497012400154595*^9, 3.497080174514282*^9, 3.497081056897665*^9, 
   3.497082460970443*^9, 3.497084362991616*^9, 3.497084401553769*^9, 
   3.497169827305061*^9, 3.49717158973341*^9, 3.497171758102639*^9, 
   3.497172093869636*^9, 3.497174991192086*^9, 3.497185769567561*^9, 
   3.497186256252353*^9, 3.49718749369645*^9, 3.497254256770513*^9, 
   3.49728209743195*^9, 3.497345781360556*^9, 3.497449290739288*^9}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{
  3.445529814787496*^9, 3.445533025293488*^9, 3.445535198536064*^9, 
   3.445546049937073*^9, 3.445548797753678*^9, 3.445549098311731*^9, 
   3.445588383990693*^9, 3.445627806754886*^9, 3.445627984946419*^9, 
   3.445628053839826*^9, 3.445628666487432*^9, 3.445630662691926*^9, 
   3.445631760047992*^9, 3.445631865651937*^9, 3.445631962504141*^9, {
   3.4457531303929*^9, 3.445753158762741*^9}, 3.445879730990545*^9, 
   3.445879793985706*^9, 3.445883397164449*^9, 3.445972311319879*^9, 
   3.445974227771637*^9, 3.446292149633505*^9, 3.446292462398337*^9, 
   3.446292548128168*^9, 3.4462926976046*^9, 3.476195969575441*^9, 
   3.478338790840331*^9, 3.478343868536508*^9, 3.478344047983948*^9, {
   3.480094146350314*^9, 3.480094157103242*^9}, 3.480137908531589*^9, 
   3.480148255369634*^9, 3.480150718618345*^9, 3.480162727366457*^9, 
   3.480334913979917*^9, 3.480337138121744*^9, 3.480415435023273*^9, 
   3.480416213916008*^9, 3.480495431488316*^9, 3.480495619819866*^9, 
   3.481447065900251*^9, 3.481447351599817*^9, 3.481644755751576*^9, 
   3.481644790207347*^9, 3.481645055032385*^9, 3.481645156232592*^9, 
   3.481645260311283*^9, 3.481645727809657*^9, 3.481647353819152*^9, 
   3.481647456396417*^9, 3.481647548996483*^9, 3.4816482572837*^9, 
   3.481654602881448*^9, 3.483022096104306*^9, 3.483441447414538*^9, 
   3.483444030258551*^9, 3.483696294277061*^9, 3.483696441365173*^9, 
   3.488889159485963*^9, 3.490428344051142*^9, 3.490428455030256*^9, 
   3.490605344462699*^9, 3.490814693294052*^9, 3.491288863779177*^9, 
   3.491303801941978*^9, 3.491303991476303*^9, 3.491304652911572*^9, 
   3.491306279669183*^9, 3.491306866172633*^9, 3.492965609545695*^9, 
   3.493013335844268*^9, 3.493014170320645*^9, 3.493014785979743*^9, 
   3.493036083229056*^9, 3.493110303258415*^9, 3.493110611544669*^9, 
   3.493111966094203*^9, 3.493113074239531*^9, 3.493114294066177*^9, 
   3.493115256325878*^9, 3.493116751986789*^9, 3.493118863880127*^9, 
   3.493119332295832*^9, 3.493120893711637*^9, 3.493122001074701*^9, 
   3.493122919104534*^9, 3.493123645202591*^9, 3.493124171634506*^9, 
   3.493124448709216*^9, 3.493124515182798*^9, 3.493124951298302*^9, 
   3.493125415906132*^9, 3.493125666843701*^9, 3.493126236797454*^9, 
   3.493174542238378*^9, 3.493183554988619*^9, {3.496650852981347*^9, 
   3.496650873355477*^9}, 3.497006568309196*^9, {3.497007161969832*^9, 
   3.497007187289688*^9}, 3.497007235644422*^9, 3.497007758741729*^9, 
   3.497012400154595*^9, 3.497080174514282*^9, 3.497081056897665*^9, 
   3.497082460970443*^9, 3.497084362991616*^9, 3.497084401553769*^9, 
   3.497169827305061*^9, 3.49717158973341*^9, 3.497171758102639*^9, 
   3.497172093869636*^9, 3.497174991192086*^9, 3.497185769567561*^9, 
   3.497186256252353*^9, 3.49718749369645*^9, 3.497254256770513*^9, 
   3.49728209743195*^9, 3.497345781360556*^9, 3.497449290758172*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.445529814787496*^9, 3.445533025293488*^9, 3.445535198536064*^9, 
   3.445546049937073*^9, 3.445548797753678*^9, 3.445549098311731*^9, 
   3.445588383990693*^9, 3.445627806754886*^9, 3.445627984946419*^9, 
   3.445628053839826*^9, 3.445628666487432*^9, 3.445630662691926*^9, 
   3.445631760047992*^9, 3.445631865651937*^9, 3.445631962504141*^9, {
   3.4457531303929*^9, 3.445753158762741*^9}, 3.445879730990545*^9, 
   3.445879793985706*^9, 3.445883397164449*^9, 3.445972311319879*^9, 
   3.445974227771637*^9, 3.446292149633505*^9, 3.446292462398337*^9, 
   3.446292548128168*^9, 3.4462926976046*^9, 3.476195969575441*^9, 
   3.478338790840331*^9, 3.478343868536508*^9, 3.478344047983948*^9, {
   3.480094146350314*^9, 3.480094157103242*^9}, 3.480137908531589*^9, 
   3.480148255369634*^9, 3.480150718618345*^9, 3.480162727366457*^9, 
   3.480334913979917*^9, 3.480337138121744*^9, 3.480415435023273*^9, 
   3.480416213916008*^9, 3.480495431488316*^9, 3.480495619819866*^9, 
   3.481447065900251*^9, 3.481447351599817*^9, 3.481644755751576*^9, 
   3.481644790207347*^9, 3.481645055032385*^9, 3.481645156232592*^9, 
   3.481645260311283*^9, 3.481645727809657*^9, 3.481647353819152*^9, 
   3.481647456396417*^9, 3.481647548996483*^9, 3.4816482572837*^9, 
   3.481654602881448*^9, 3.483022096104306*^9, 3.483441447414538*^9, 
   3.483444030258551*^9, 3.483696294277061*^9, 3.483696441365173*^9, 
   3.488889159485963*^9, 3.490428344051142*^9, 3.490428455030256*^9, 
   3.490605344462699*^9, 3.490814693294052*^9, 3.491288863779177*^9, 
   3.491303801941978*^9, 3.491303991476303*^9, 3.491304652911572*^9, 
   3.491306279669183*^9, 3.491306866172633*^9, 3.492965609545695*^9, 
   3.493013335844268*^9, 3.493014170320645*^9, 3.493014785979743*^9, 
   3.493036083229056*^9, 3.493110303258415*^9, 3.493110611544669*^9, 
   3.493111966094203*^9, 3.493113074239531*^9, 3.493114294066177*^9, 
   3.493115256325878*^9, 3.493116751986789*^9, 3.493118863880127*^9, 
   3.493119332295832*^9, 3.493120893711637*^9, 3.493122001074701*^9, 
   3.493122919104534*^9, 3.493123645202591*^9, 3.493124171634506*^9, 
   3.493124448709216*^9, 3.493124515182798*^9, 3.493124951298302*^9, 
   3.493125415906132*^9, 3.493125666843701*^9, 3.493126236797454*^9, 
   3.493174542238378*^9, 3.493183554988619*^9, {3.496650852981347*^9, 
   3.496650873355477*^9}, 3.497006568309196*^9, {3.497007161969832*^9, 
   3.497007187289688*^9}, 3.497007235644422*^9, 3.497007758741729*^9, 
   3.497012400154595*^9, 3.497080174514282*^9, 3.497081056897665*^9, 
   3.497082460970443*^9, 3.497084362991616*^9, 3.497084401553769*^9, 
   3.497169827305061*^9, 3.49717158973341*^9, 3.497171758102639*^9, 
   3.497172093869636*^9, 3.497174991192086*^9, 3.497185769567561*^9, 
   3.497186256252353*^9, 3.49718749369645*^9, 3.497254256770513*^9, 
   3.49728209743195*^9, 3.497345781360556*^9, 3.497449290772636*^9}],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{
  3.445529814787496*^9, 3.445533025293488*^9, 3.445535198536064*^9, 
   3.445546049937073*^9, 3.445548797753678*^9, 3.445549098311731*^9, 
   3.445588383990693*^9, 3.445627806754886*^9, 3.445627984946419*^9, 
   3.445628053839826*^9, 3.445628666487432*^9, 3.445630662691926*^9, 
   3.445631760047992*^9, 3.445631865651937*^9, 3.445631962504141*^9, {
   3.4457531303929*^9, 3.445753158762741*^9}, 3.445879730990545*^9, 
   3.445879793985706*^9, 3.445883397164449*^9, 3.445972311319879*^9, 
   3.445974227771637*^9, 3.446292149633505*^9, 3.446292462398337*^9, 
   3.446292548128168*^9, 3.4462926976046*^9, 3.476195969575441*^9, 
   3.478338790840331*^9, 3.478343868536508*^9, 3.478344047983948*^9, {
   3.480094146350314*^9, 3.480094157103242*^9}, 3.480137908531589*^9, 
   3.480148255369634*^9, 3.480150718618345*^9, 3.480162727366457*^9, 
   3.480334913979917*^9, 3.480337138121744*^9, 3.480415435023273*^9, 
   3.480416213916008*^9, 3.480495431488316*^9, 3.480495619819866*^9, 
   3.481447065900251*^9, 3.481447351599817*^9, 3.481644755751576*^9, 
   3.481644790207347*^9, 3.481645055032385*^9, 3.481645156232592*^9, 
   3.481645260311283*^9, 3.481645727809657*^9, 3.481647353819152*^9, 
   3.481647456396417*^9, 3.481647548996483*^9, 3.4816482572837*^9, 
   3.481654602881448*^9, 3.483022096104306*^9, 3.483441447414538*^9, 
   3.483444030258551*^9, 3.483696294277061*^9, 3.483696441365173*^9, 
   3.488889159485963*^9, 3.490428344051142*^9, 3.490428455030256*^9, 
   3.490605344462699*^9, 3.490814693294052*^9, 3.491288863779177*^9, 
   3.491303801941978*^9, 3.491303991476303*^9, 3.491304652911572*^9, 
   3.491306279669183*^9, 3.491306866172633*^9, 3.492965609545695*^9, 
   3.493013335844268*^9, 3.493014170320645*^9, 3.493014785979743*^9, 
   3.493036083229056*^9, 3.493110303258415*^9, 3.493110611544669*^9, 
   3.493111966094203*^9, 3.493113074239531*^9, 3.493114294066177*^9, 
   3.493115256325878*^9, 3.493116751986789*^9, 3.493118863880127*^9, 
   3.493119332295832*^9, 3.493120893711637*^9, 3.493122001074701*^9, 
   3.493122919104534*^9, 3.493123645202591*^9, 3.493124171634506*^9, 
   3.493124448709216*^9, 3.493124515182798*^9, 3.493124951298302*^9, 
   3.493125415906132*^9, 3.493125666843701*^9, 3.493126236797454*^9, 
   3.493174542238378*^9, 3.493183554988619*^9, {3.496650852981347*^9, 
   3.496650873355477*^9}, 3.497006568309196*^9, {3.497007161969832*^9, 
   3.497007187289688*^9}, 3.497007235644422*^9, 3.497007758741729*^9, 
   3.497012400154595*^9, 3.497080174514282*^9, 3.497081056897665*^9, 
   3.497082460970443*^9, 3.497084362991616*^9, 3.497084401553769*^9, 
   3.497169827305061*^9, 3.49717158973341*^9, 3.497171758102639*^9, 
   3.497172093869636*^9, 3.497174991192086*^9, 3.497185769567561*^9, 
   3.497186256252353*^9, 3.49718749369645*^9, 3.497254256770513*^9, 
   3.49728209743195*^9, 3.497345781360556*^9, 3.49744929079196*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadModel", "[", "\"\<MWT_101030.fr\>\"", "]"}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQBGIQrXRsjSTD6peOd8rEpUC0YtanV+5AeuPvz2DaeOrF
rjIgfYPxGpi+meGTxLrmpaP+tBow3fboS0kdkLY08SoF0bsmTpm1BkgvVtgJ
potvZe51X/vS0dZjNpje99NQIuvVS8fd09vA9N0jJp5m7146npFMBtOx/k+v
bf3w0nGCY811EM3z7f/k+V9eOt4q1JwCovO41qq3/3vpyHTVXgNENzpM3FrG
+Mrx8G7NbSD6Q3fMQynmV45H+arAtOpebXclIG2n6ACmk/aUzPFle+V4kXUx
mL4QVPo6BUivnLodTMd8/vB/O5Ce3MPIsANIM/Xl8obyvnIMmlAJppnjLdiY
+V458j+xAtOVZ5evUQPSi3+sB9N6/5cKRwPpbY0rwXR2c9e6aiAdpjUZTC/v
4IhbAaSP2UuC6abGfc9vAWkvl9NgGgCeUMdq
  "]],

Cell[CellGroupData[{

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{
  3.446292151836282*^9, 3.446292465119467*^9, 3.446292551370256*^9, 
   3.446292699837127*^9, 3.476195973935181*^9, 3.478338795152881*^9, 
   3.47834387678723*^9, {3.478344035617289*^9, 3.478344050493314*^9}, 
   3.480094160097415*^9, 3.480137911342136*^9, 3.480148256776046*^9, 
   3.480150725804023*^9, 3.480162729503479*^9, 3.480334923749774*^9, 
   3.480337147713022*^9, 3.480415437673998*^9, 3.480416217032306*^9, 
   3.480495434712065*^9, 3.480495623564114*^9, 3.481447357838562*^9, 
   3.481644793273505*^9, 3.481645056979512*^9, 3.481645157399932*^9, 
   3.481645262398251*^9, 3.481645730744913*^9, 3.481647356240671*^9, 
   3.481647458607816*^9, 3.481647550988115*^9, 3.481648259208128*^9, 
   3.481654605713771*^9, 3.483022100354922*^9, 3.483441490545062*^9, 
   3.483444031322598*^9, 3.483696298050903*^9, 3.483696442455252*^9, 
   3.488889168919401*^9, 3.490428346206765*^9, 3.490428456804011*^9, 
   3.490605346502275*^9, 3.490814696518682*^9, 3.491288884470282*^9, 
   3.491303804739013*^9, 3.491303994664745*^9, 3.491304654049004*^9, 
   3.491306281002745*^9, 3.491306867564154*^9, 3.492965614039865*^9, 
   3.493013343070584*^9, 3.493014171206565*^9, 3.49301478681043*^9, 
   3.493036085853047*^9, 3.493110613671768*^9, 3.493111968143056*^9, 
   3.493113076380066*^9, 3.493114296482063*^9, 3.49311525826945*^9, 
   3.49311675400041*^9, 3.493118865849079*^9, 3.493119334679893*^9, 
   3.493120895254715*^9, 3.493122002675458*^9, 3.493122921559642*^9, 
   3.493123648880871*^9, 3.493124174499801*^9, 3.493124519401172*^9, 
   3.493124954443937*^9, 3.493125418467556*^9, 3.493125669458642*^9, 
   3.493126242200436*^9, 3.493174543448708*^9, 3.493183556934246*^9, {
   3.496650854980759*^9, 3.496650875690516*^9}, 3.49700657182268*^9, 
   3.497007189764868*^9, 3.497007238051462*^9, 3.497007792440126*^9, 
   3.497012406759518*^9, 3.497080176321776*^9, 3.497081061593162*^9, 
   3.497082463125398*^9, 3.497084365810432*^9, 3.497084403660704*^9, 
   3.497169828960106*^9, 3.497171590975637*^9, 3.497171760215849*^9, 
   3.497172096137148*^9, 3.497174992794543*^9, 3.497185771587546*^9, 
   3.497186258321594*^9, 3.497187496719994*^9, 3.497254261347176*^9, 
   3.497282099400604*^9, 3.49734578467326*^9, 3.497449295293721*^9}],

Cell[BoxData["\<\"M. Jarvinen\"\>"], "Print",
 CellChangeTimes->{
  3.446292151836282*^9, 3.446292465119467*^9, 3.446292551370256*^9, 
   3.446292699837127*^9, 3.476195973935181*^9, 3.478338795152881*^9, 
   3.47834387678723*^9, {3.478344035617289*^9, 3.478344050493314*^9}, 
   3.480094160097415*^9, 3.480137911342136*^9, 3.480148256776046*^9, 
   3.480150725804023*^9, 3.480162729503479*^9, 3.480334923749774*^9, 
   3.480337147713022*^9, 3.480415437673998*^9, 3.480416217032306*^9, 
   3.480495434712065*^9, 3.480495623564114*^9, 3.481447357838562*^9, 
   3.481644793273505*^9, 3.481645056979512*^9, 3.481645157399932*^9, 
   3.481645262398251*^9, 3.481645730744913*^9, 3.481647356240671*^9, 
   3.481647458607816*^9, 3.481647550988115*^9, 3.481648259208128*^9, 
   3.481654605713771*^9, 3.483022100354922*^9, 3.483441490545062*^9, 
   3.483444031322598*^9, 3.483696298050903*^9, 3.483696442455252*^9, 
   3.488889168919401*^9, 3.490428346206765*^9, 3.490428456804011*^9, 
   3.490605346502275*^9, 3.490814696518682*^9, 3.491288884470282*^9, 
   3.491303804739013*^9, 3.491303994664745*^9, 3.491304654049004*^9, 
   3.491306281002745*^9, 3.491306867564154*^9, 3.492965614039865*^9, 
   3.493013343070584*^9, 3.493014171206565*^9, 3.49301478681043*^9, 
   3.493036085853047*^9, 3.493110613671768*^9, 3.493111968143056*^9, 
   3.493113076380066*^9, 3.493114296482063*^9, 3.49311525826945*^9, 
   3.49311675400041*^9, 3.493118865849079*^9, 3.493119334679893*^9, 
   3.493120895254715*^9, 3.493122002675458*^9, 3.493122921559642*^9, 
   3.493123648880871*^9, 3.493124174499801*^9, 3.493124519401172*^9, 
   3.493124954443937*^9, 3.493125418467556*^9, 3.493125669458642*^9, 
   3.493126242200436*^9, 3.493174543448708*^9, 3.493183556934246*^9, {
   3.496650854980759*^9, 3.496650875690516*^9}, 3.49700657182268*^9, 
   3.497007189764868*^9, 3.497007238051462*^9, 3.497007792440126*^9, 
   3.497012406759518*^9, 3.497080176321776*^9, 3.497081061593162*^9, 
   3.497082463125398*^9, 3.497084365810432*^9, 3.497084403660704*^9, 
   3.497169828960106*^9, 3.497171590975637*^9, 3.497171760215849*^9, 
   3.497172096137148*^9, 3.497174992794543*^9, 3.497185771587546*^9, 
   3.497186258321594*^9, 3.497187496719994*^9, 3.497254261347176*^9, 
   3.497282099400604*^9, 3.49734578467326*^9, 3.497449295414796*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.\"\>"}],
  SequenceForm["Model Version: ", "1."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.446292151836282*^9, 3.446292465119467*^9, 3.446292551370256*^9, 
   3.446292699837127*^9, 3.476195973935181*^9, 3.478338795152881*^9, 
   3.47834387678723*^9, {3.478344035617289*^9, 3.478344050493314*^9}, 
   3.480094160097415*^9, 3.480137911342136*^9, 3.480148256776046*^9, 
   3.480150725804023*^9, 3.480162729503479*^9, 3.480334923749774*^9, 
   3.480337147713022*^9, 3.480415437673998*^9, 3.480416217032306*^9, 
   3.480495434712065*^9, 3.480495623564114*^9, 3.481447357838562*^9, 
   3.481644793273505*^9, 3.481645056979512*^9, 3.481645157399932*^9, 
   3.481645262398251*^9, 3.481645730744913*^9, 3.481647356240671*^9, 
   3.481647458607816*^9, 3.481647550988115*^9, 3.481648259208128*^9, 
   3.481654605713771*^9, 3.483022100354922*^9, 3.483441490545062*^9, 
   3.483444031322598*^9, 3.483696298050903*^9, 3.483696442455252*^9, 
   3.488889168919401*^9, 3.490428346206765*^9, 3.490428456804011*^9, 
   3.490605346502275*^9, 3.490814696518682*^9, 3.491288884470282*^9, 
   3.491303804739013*^9, 3.491303994664745*^9, 3.491304654049004*^9, 
   3.491306281002745*^9, 3.491306867564154*^9, 3.492965614039865*^9, 
   3.493013343070584*^9, 3.493014171206565*^9, 3.49301478681043*^9, 
   3.493036085853047*^9, 3.493110613671768*^9, 3.493111968143056*^9, 
   3.493113076380066*^9, 3.493114296482063*^9, 3.49311525826945*^9, 
   3.49311675400041*^9, 3.493118865849079*^9, 3.493119334679893*^9, 
   3.493120895254715*^9, 3.493122002675458*^9, 3.493122921559642*^9, 
   3.493123648880871*^9, 3.493124174499801*^9, 3.493124519401172*^9, 
   3.493124954443937*^9, 3.493125418467556*^9, 3.493125669458642*^9, 
   3.493126242200436*^9, 3.493174543448708*^9, 3.493183556934246*^9, {
   3.496650854980759*^9, 3.496650875690516*^9}, 3.49700657182268*^9, 
   3.497007189764868*^9, 3.497007238051462*^9, 3.497007792440126*^9, 
   3.497012406759518*^9, 3.497080176321776*^9, 3.497081061593162*^9, 
   3.497082463125398*^9, 3.497084365810432*^9, 3.497084403660704*^9, 
   3.497169828960106*^9, 3.497171590975637*^9, 3.497171760215849*^9, 
   3.497172096137148*^9, 3.497174992794543*^9, 3.497185771587546*^9, 
   3.497186258321594*^9, 3.497187496719994*^9, 3.497254261347176*^9, 
   3.497282099400604*^9, 3.49734578467326*^9, 3.497449295432538*^9}],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{
  3.446292151836282*^9, 3.446292465119467*^9, 3.446292551370256*^9, 
   3.446292699837127*^9, 3.476195973935181*^9, 3.478338795152881*^9, 
   3.47834387678723*^9, {3.478344035617289*^9, 3.478344050493314*^9}, 
   3.480094160097415*^9, 3.480137911342136*^9, 3.480148256776046*^9, 
   3.480150725804023*^9, 3.480162729503479*^9, 3.480334923749774*^9, 
   3.480337147713022*^9, 3.480415437673998*^9, 3.480416217032306*^9, 
   3.480495434712065*^9, 3.480495623564114*^9, 3.481447357838562*^9, 
   3.481644793273505*^9, 3.481645056979512*^9, 3.481645157399932*^9, 
   3.481645262398251*^9, 3.481645730744913*^9, 3.481647356240671*^9, 
   3.481647458607816*^9, 3.481647550988115*^9, 3.481648259208128*^9, 
   3.481654605713771*^9, 3.483022100354922*^9, 3.483441490545062*^9, 
   3.483444031322598*^9, 3.483696298050903*^9, 3.483696442455252*^9, 
   3.488889168919401*^9, 3.490428346206765*^9, 3.490428456804011*^9, 
   3.490605346502275*^9, 3.490814696518682*^9, 3.491288884470282*^9, 
   3.491303804739013*^9, 3.491303994664745*^9, 3.491304654049004*^9, 
   3.491306281002745*^9, 3.491306867564154*^9, 3.492965614039865*^9, 
   3.493013343070584*^9, 3.493014171206565*^9, 3.49301478681043*^9, 
   3.493036085853047*^9, 3.493110613671768*^9, 3.493111968143056*^9, 
   3.493113076380066*^9, 3.493114296482063*^9, 3.49311525826945*^9, 
   3.49311675400041*^9, 3.493118865849079*^9, 3.493119334679893*^9, 
   3.493120895254715*^9, 3.493122002675458*^9, 3.493122921559642*^9, 
   3.493123648880871*^9, 3.493124174499801*^9, 3.493124519401172*^9, 
   3.493124954443937*^9, 3.493125418467556*^9, 3.493125669458642*^9, 
   3.493126242200436*^9, 3.493174543448708*^9, 3.493183556934246*^9, {
   3.496650854980759*^9, 3.496650875690516*^9}, 3.49700657182268*^9, 
   3.497007189764868*^9, 3.497007238051462*^9, 3.497007792440126*^9, 
   3.497012406759518*^9, 3.497080176321776*^9, 3.497081061593162*^9, 
   3.497082463125398*^9, 3.497084365810432*^9, 3.497084403660704*^9, 
   3.497169828960106*^9, 3.497171590975637*^9, 3.497171760215849*^9, 
   3.497172096137148*^9, 3.497174992794543*^9, 3.497185771587546*^9, 
   3.497186258321594*^9, 3.497187496719994*^9, 3.497254261347176*^9, 
   3.497282099400604*^9, 3.49734578467326*^9, 3.497449295451504*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.446292151836282*^9, 3.446292465119467*^9, 3.446292551370256*^9, 
   3.446292699837127*^9, 3.476195973935181*^9, 3.478338795152881*^9, 
   3.47834387678723*^9, {3.478344035617289*^9, 3.478344050493314*^9}, 
   3.480094160097415*^9, 3.480137911342136*^9, 3.480148256776046*^9, 
   3.480150725804023*^9, 3.480162729503479*^9, 3.480334923749774*^9, 
   3.480337147713022*^9, 3.480415437673998*^9, 3.480416217032306*^9, 
   3.480495434712065*^9, 3.480495623564114*^9, 3.481447357838562*^9, 
   3.481644793273505*^9, 3.481645056979512*^9, 3.481645157399932*^9, 
   3.481645262398251*^9, 3.481645730744913*^9, 3.481647356240671*^9, 
   3.481647458607816*^9, 3.481647550988115*^9, 3.481648259208128*^9, 
   3.481654605713771*^9, 3.483022100354922*^9, 3.483441490545062*^9, 
   3.483444031322598*^9, 3.483696298050903*^9, 3.483696442455252*^9, 
   3.488889168919401*^9, 3.490428346206765*^9, 3.490428456804011*^9, 
   3.490605346502275*^9, 3.490814696518682*^9, 3.491288884470282*^9, 
   3.491303804739013*^9, 3.491303994664745*^9, 3.491304654049004*^9, 
   3.491306281002745*^9, 3.491306867564154*^9, 3.492965614039865*^9, 
   3.493013343070584*^9, 3.493014171206565*^9, 3.49301478681043*^9, 
   3.493036085853047*^9, 3.493110613671768*^9, 3.493111968143056*^9, 
   3.493113076380066*^9, 3.493114296482063*^9, 3.49311525826945*^9, 
   3.49311675400041*^9, 3.493118865849079*^9, 3.493119334679893*^9, 
   3.493120895254715*^9, 3.493122002675458*^9, 3.493122921559642*^9, 
   3.493123648880871*^9, 3.493124174499801*^9, 3.493124519401172*^9, 
   3.493124954443937*^9, 3.493125418467556*^9, 3.493125669458642*^9, 
   3.493126242200436*^9, 3.493174543448708*^9, 3.493183556934246*^9, {
   3.496650854980759*^9, 3.496650875690516*^9}, 3.49700657182268*^9, 
   3.497007189764868*^9, 3.497007238051462*^9, 3.497007792440126*^9, 
   3.497012406759518*^9, 3.497080176321776*^9, 3.497081061593162*^9, 
   3.497082463125398*^9, 3.497084365810432*^9, 3.497084403660704*^9, 
   3.497169828960106*^9, 3.497171590975637*^9, 3.497171760215849*^9, 
   3.497172096137148*^9, 3.497174992794543*^9, 3.497185771587546*^9, 
   3.497186258321594*^9, 3.497187496719994*^9, 3.497254261347176*^9, 
   3.497282099400604*^9, 3.49734578467326*^9, 3.497449295469092*^9}],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{
  3.446292151836282*^9, 3.446292465119467*^9, 3.446292551370256*^9, 
   3.446292699837127*^9, 3.476195973935181*^9, 3.478338795152881*^9, 
   3.47834387678723*^9, {3.478344035617289*^9, 3.478344050493314*^9}, 
   3.480094160097415*^9, 3.480137911342136*^9, 3.480148256776046*^9, 
   3.480150725804023*^9, 3.480162729503479*^9, 3.480334923749774*^9, 
   3.480337147713022*^9, 3.480415437673998*^9, 3.480416217032306*^9, 
   3.480495434712065*^9, 3.480495623564114*^9, 3.481447357838562*^9, 
   3.481644793273505*^9, 3.481645056979512*^9, 3.481645157399932*^9, 
   3.481645262398251*^9, 3.481645730744913*^9, 3.481647356240671*^9, 
   3.481647458607816*^9, 3.481647550988115*^9, 3.481648259208128*^9, 
   3.481654605713771*^9, 3.483022100354922*^9, 3.483441490545062*^9, 
   3.483444031322598*^9, 3.483696298050903*^9, 3.483696442455252*^9, 
   3.488889168919401*^9, 3.490428346206765*^9, 3.490428456804011*^9, 
   3.490605346502275*^9, 3.490814696518682*^9, 3.491288884470282*^9, 
   3.491303804739013*^9, 3.491303994664745*^9, 3.491304654049004*^9, 
   3.491306281002745*^9, 3.491306867564154*^9, 3.492965614039865*^9, 
   3.493013343070584*^9, 3.493014171206565*^9, 3.49301478681043*^9, 
   3.493036085853047*^9, 3.493110613671768*^9, 3.493111968143056*^9, 
   3.493113076380066*^9, 3.493114296482063*^9, 3.49311525826945*^9, 
   3.49311675400041*^9, 3.493118865849079*^9, 3.493119334679893*^9, 
   3.493120895254715*^9, 3.493122002675458*^9, 3.493122921559642*^9, 
   3.493123648880871*^9, 3.493124174499801*^9, 3.493124519401172*^9, 
   3.493124954443937*^9, 3.493125418467556*^9, 3.493125669458642*^9, 
   3.493126242200436*^9, 3.493174543448708*^9, 3.493183556934246*^9, {
   3.496650854980759*^9, 3.496650875690516*^9}, 3.49700657182268*^9, 
   3.497007189764868*^9, 3.497007238051462*^9, 3.497007792440126*^9, 
   3.497012406759518*^9, 3.497080176321776*^9, 3.497081061593162*^9, 
   3.497082463125398*^9, 3.497084365810432*^9, 3.497084403660704*^9, 
   3.497169828960106*^9, 3.497171590975637*^9, 3.497171760215849*^9, 
   3.497172096137148*^9, 3.497174992794543*^9, 3.497185771587546*^9, 
   3.497186258321594*^9, 3.497187496719994*^9, 3.497254261347176*^9, 
   3.497282099400604*^9, 3.49734578467326*^9, 3.497449295486467*^9}],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{
  3.446292151836282*^9, 3.446292465119467*^9, 3.446292551370256*^9, 
   3.446292699837127*^9, 3.476195973935181*^9, 3.478338795152881*^9, 
   3.47834387678723*^9, {3.478344035617289*^9, 3.478344050493314*^9}, 
   3.480094160097415*^9, 3.480137911342136*^9, 3.480148256776046*^9, 
   3.480150725804023*^9, 3.480162729503479*^9, 3.480334923749774*^9, 
   3.480337147713022*^9, 3.480415437673998*^9, 3.480416217032306*^9, 
   3.480495434712065*^9, 3.480495623564114*^9, 3.481447357838562*^9, 
   3.481644793273505*^9, 3.481645056979512*^9, 3.481645157399932*^9, 
   3.481645262398251*^9, 3.481645730744913*^9, 3.481647356240671*^9, 
   3.481647458607816*^9, 3.481647550988115*^9, 3.481648259208128*^9, 
   3.481654605713771*^9, 3.483022100354922*^9, 3.483441490545062*^9, 
   3.483444031322598*^9, 3.483696298050903*^9, 3.483696442455252*^9, 
   3.488889168919401*^9, 3.490428346206765*^9, 3.490428456804011*^9, 
   3.490605346502275*^9, 3.490814696518682*^9, 3.491288884470282*^9, 
   3.491303804739013*^9, 3.491303994664745*^9, 3.491304654049004*^9, 
   3.491306281002745*^9, 3.491306867564154*^9, 3.492965614039865*^9, 
   3.493013343070584*^9, 3.493014171206565*^9, 3.49301478681043*^9, 
   3.493036085853047*^9, 3.493110613671768*^9, 3.493111968143056*^9, 
   3.493113076380066*^9, 3.493114296482063*^9, 3.49311525826945*^9, 
   3.49311675400041*^9, 3.493118865849079*^9, 3.493119334679893*^9, 
   3.493120895254715*^9, 3.493122002675458*^9, 3.493122921559642*^9, 
   3.493123648880871*^9, 3.493124174499801*^9, 3.493124519401172*^9, 
   3.493124954443937*^9, 3.493125418467556*^9, 3.493125669458642*^9, 
   3.493126242200436*^9, 3.493174543448708*^9, 3.493183556934246*^9, {
   3.496650854980759*^9, 3.496650875690516*^9}, 3.49700657182268*^9, 
   3.497007189764868*^9, 3.497007238051462*^9, 3.497007792440126*^9, 
   3.497012406759518*^9, 3.497080176321776*^9, 3.497081061593162*^9, 
   3.497082463125398*^9, 3.497084365810432*^9, 3.497084403660704*^9, 
   3.497169828960106*^9, 3.497171590975637*^9, 3.497171760215849*^9, 
   3.497172096137148*^9, 3.497174992794543*^9, 3.497185771587546*^9, 
   3.497186258321594*^9, 3.497187496719994*^9, 3.497254261347176*^9, 
   3.497282099400604*^9, 3.49734578467326*^9, 3.497449295897243*^9}],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{
  3.446292151836282*^9, 3.446292465119467*^9, 3.446292551370256*^9, 
   3.446292699837127*^9, 3.476195973935181*^9, 3.478338795152881*^9, 
   3.47834387678723*^9, {3.478344035617289*^9, 3.478344050493314*^9}, 
   3.480094160097415*^9, 3.480137911342136*^9, 3.480148256776046*^9, 
   3.480150725804023*^9, 3.480162729503479*^9, 3.480334923749774*^9, 
   3.480337147713022*^9, 3.480415437673998*^9, 3.480416217032306*^9, 
   3.480495434712065*^9, 3.480495623564114*^9, 3.481447357838562*^9, 
   3.481644793273505*^9, 3.481645056979512*^9, 3.481645157399932*^9, 
   3.481645262398251*^9, 3.481645730744913*^9, 3.481647356240671*^9, 
   3.481647458607816*^9, 3.481647550988115*^9, 3.481648259208128*^9, 
   3.481654605713771*^9, 3.483022100354922*^9, 3.483441490545062*^9, 
   3.483444031322598*^9, 3.483696298050903*^9, 3.483696442455252*^9, 
   3.488889168919401*^9, 3.490428346206765*^9, 3.490428456804011*^9, 
   3.490605346502275*^9, 3.490814696518682*^9, 3.491288884470282*^9, 
   3.491303804739013*^9, 3.491303994664745*^9, 3.491304654049004*^9, 
   3.491306281002745*^9, 3.491306867564154*^9, 3.492965614039865*^9, 
   3.493013343070584*^9, 3.493014171206565*^9, 3.49301478681043*^9, 
   3.493036085853047*^9, 3.493110613671768*^9, 3.493111968143056*^9, 
   3.493113076380066*^9, 3.493114296482063*^9, 3.49311525826945*^9, 
   3.49311675400041*^9, 3.493118865849079*^9, 3.493119334679893*^9, 
   3.493120895254715*^9, 3.493122002675458*^9, 3.493122921559642*^9, 
   3.493123648880871*^9, 3.493124174499801*^9, 3.493124519401172*^9, 
   3.493124954443937*^9, 3.493125418467556*^9, 3.493125669458642*^9, 
   3.493126242200436*^9, 3.493174543448708*^9, 3.493183556934246*^9, {
   3.496650854980759*^9, 3.496650875690516*^9}, 3.49700657182268*^9, 
   3.497007189764868*^9, 3.497007238051462*^9, 3.497007792440126*^9, 
   3.497012406759518*^9, 3.497080176321776*^9, 3.497081061593162*^9, 
   3.497082463125398*^9, 3.497084365810432*^9, 3.497084403660704*^9, 
   3.497169828960106*^9, 3.497171590975637*^9, 3.497171760215849*^9, 
   3.497172096137148*^9, 3.497174992794543*^9, 3.497185771587546*^9, 
   3.497186258321594*^9, 3.497187496719994*^9, 3.497254261347176*^9, 
   3.497282099400604*^9, 3.49734578467326*^9, 3.497449296132055*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"MWT\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "MWT", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.446292151836282*^9, 3.446292465119467*^9, 3.446292551370256*^9, 
   3.446292699837127*^9, 3.476195973935181*^9, 3.478338795152881*^9, 
   3.47834387678723*^9, {3.478344035617289*^9, 3.478344050493314*^9}, 
   3.480094160097415*^9, 3.480137911342136*^9, 3.480148256776046*^9, 
   3.480150725804023*^9, 3.480162729503479*^9, 3.480334923749774*^9, 
   3.480337147713022*^9, 3.480415437673998*^9, 3.480416217032306*^9, 
   3.480495434712065*^9, 3.480495623564114*^9, 3.481447357838562*^9, 
   3.481644793273505*^9, 3.481645056979512*^9, 3.481645157399932*^9, 
   3.481645262398251*^9, 3.481645730744913*^9, 3.481647356240671*^9, 
   3.481647458607816*^9, 3.481647550988115*^9, 3.481648259208128*^9, 
   3.481654605713771*^9, 3.483022100354922*^9, 3.483441490545062*^9, 
   3.483444031322598*^9, 3.483696298050903*^9, 3.483696442455252*^9, 
   3.488889168919401*^9, 3.490428346206765*^9, 3.490428456804011*^9, 
   3.490605346502275*^9, 3.490814696518682*^9, 3.491288884470282*^9, 
   3.491303804739013*^9, 3.491303994664745*^9, 3.491304654049004*^9, 
   3.491306281002745*^9, 3.491306867564154*^9, 3.492965614039865*^9, 
   3.493013343070584*^9, 3.493014171206565*^9, 3.49301478681043*^9, 
   3.493036085853047*^9, 3.493110613671768*^9, 3.493111968143056*^9, 
   3.493113076380066*^9, 3.493114296482063*^9, 3.49311525826945*^9, 
   3.49311675400041*^9, 3.493118865849079*^9, 3.493119334679893*^9, 
   3.493120895254715*^9, 3.493122002675458*^9, 3.493122921559642*^9, 
   3.493123648880871*^9, 3.493124174499801*^9, 3.493124519401172*^9, 
   3.493124954443937*^9, 3.493125418467556*^9, 3.493125669458642*^9, 
   3.493126242200436*^9, 3.493174543448708*^9, 3.493183556934246*^9, {
   3.496650854980759*^9, 3.496650875690516*^9}, 3.49700657182268*^9, 
   3.497007189764868*^9, 3.497007238051462*^9, 3.497007792440126*^9, 
   3.497012406759518*^9, 3.497080176321776*^9, 3.497081061593162*^9, 
   3.497082463125398*^9, 3.497084365810432*^9, 3.497084403660704*^9, 
   3.497169828960106*^9, 3.497171590975637*^9, 3.497171760215849*^9, 
   3.497172096137148*^9, 3.497174992794543*^9, 3.497185771587546*^9, 
   3.497186258321594*^9, 3.497187496719994*^9, 3.497254261347176*^9, 
   3.497282099400604*^9, 3.49734578467326*^9, 3.497449296370306*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Writing CalcHEP and Madgraph output", "Section",
 CellChangeTimes->{{3.493183368341105*^9, 3.493183373693058*^9}, {
  3.493183442612217*^9, 3.493183450956239*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/NMWT\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"WriteCHOutput", "[", 
  RowBox[{"LMWT", ",", 
   RowBox[{"MaxExpressionLength", "\[Rule]", "450"}], ",", 
   RowBox[{"ModelNumber", "\[Rule]", "88"}], ",", 
   RowBox[{"CHAutoWidths", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.446292959394525*^9, 3.446292959729409*^9}, {
   3.490614118324001*^9, 3.490614119413694*^9}, {3.49296571229781*^9, 
   3.492965718088624*^9}, {3.493014840488783*^9, 3.493014841952615*^9}, {
   3.493014883236043*^9, 3.493014889019404*^9}, {3.493110311601744*^9, 
   3.493110315478863*^9}, 3.4931127941746492`*^9, {3.493122166303744*^9, 
   3.493122166757158*^9}, {3.493183541582391*^9, 3.493183543804889*^9}, {
   3.497082522287651*^9, 3.497082544186772*^9}, {3.49708512700536*^9, 
   3.49708512793025*^9}, {3.497169854995356*^9, 3.49716985705921*^9}, 
   3.497348335987636*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - - - FeynRules interface to CalcHep - - -\"\>"], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497449403753361*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nAuthors:\"\>",
    StripOnInput->False,
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" N. Christensen, C. Duhr\"\>"}],
  SequenceForm[
   Style["\nAuthors:", 
    RGBColor[0, 0, 1]], " N. Christensen, C. Duhr"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497449403778441*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" files to \
/home/mjarvine/tyo/mathematica/FeynRules1.4.10/Models/NMWT/MWT-CH.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], 
   " files to \
/home/mjarvine/tyo/mathematica/FeynRules1.4.10/Models/NMWT/MWT-CH."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497449403787871*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" particles file 'prtcls88.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " particles file 'prtcls88.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497449403797923*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" external parameter file 'vars88.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " external parameter file 'vars88.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497449403949348*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" internal parameter file 'func88.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " internal parameter file 'func88.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497449403959136*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497449404244025*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating Feynman rules for \"\>", 
   "\[InvisibleSpace]", "\<\"L1\"\>"}],
  SequenceForm["Calculating Feynman rules for ", "L1"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497449404371266*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Starting Feynman rule calculation for \"\>", 
   "\[InvisibleSpace]", "\<\"L1\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["Starting Feynman rule calculation for ", "L1", "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497449404492633*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"4\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "4", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497449404847654*^9}],

Cell[BoxData["\<\"Expanding indices...\"\>"], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497449405257864*^9}],

Cell[BoxData["\<\"Expanding flavors...\"\>"], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497449931858947*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex...\"\>"], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497450033584669*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Found \"\>", "\[InvisibleSpace]", "\<\"311\"\>", 
   "\[InvisibleSpace]", "\<\" possible non zero vertices.\"\>"}],
  SequenceForm["Found ", "311", " possible non zero vertices."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497450058941506*^9}],

Cell[BoxData["\<\"Start calculating vertices...\"\>"], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497450059228164*^9}],

Cell[BoxData[
 ProgressIndicatorBox[Dynamic[PRIVATE`progress$1563]]], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497450059258654*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"311", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[311, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497450334347425*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" Vertices file 'lgrng88.mdl'\\nand appending \
variable file 'func88.mdl', particle file 'prtcls88.mdl' and variable file \
'vars88.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], 
   " Vertices file 'lgrng88.mdl'\nand appending variable file 'func88.mdl', \
particle file 'prtcls88.mdl' and variable file 'vars88.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497450338806273*^9}],

Cell[BoxData[
 ProgressIndicatorBox[Dynamic[PRIVATE`progress$1562]]], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497450338978624*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nDone\"\>",
    StripOnInput->False,
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" in 16.12min!\"\>"}],
  SequenceForm[
   Style["\nDone", 
    RGBColor[0, 0, 1]], " in 16.12min!"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.446292907996139*^9, 3.44629296104838*^9, 3.481654687909356*^9, 
   3.48302215165878*^9, 3.490614123036291*^9, 3.491288926159837*^9, 
   3.491304008117056*^9, 3.49130483150747*^9, 3.491306886317478*^9, 
   3.492965738742788*^9, 3.493013378705444*^9, 3.493014182758041*^9, 
   3.493014674582026*^9, 3.49301479235775*^9, 3.493014843690932*^9, 
   3.49301490891264*^9, 3.493015125443943*^9, 3.493110317185548*^9, 
   3.49311062857091*^9, 3.493111978806705*^9, 3.493113090933237*^9, 
   3.493114311667342*^9, 3.493115264303874*^9, 3.493116763145146*^9, 
   3.493118875682029*^9, 3.493119341513989*^9, 3.493120910896039*^9, 
   3.49312200719124*^9, 3.49318356593186*^9, 3.497007820881249*^9, {
   3.497082524233794*^9, 3.497082547638068*^9}, 3.497084383456744*^9, 
   3.497085217454343*^9, 3.497170007960374*^9, 3.497172163806739*^9, 
   3.497187076787708*^9, 3.497254342380151*^9, {3.497348317247969*^9, 
   3.49734833763166*^9}, 3.497450370668972*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/NMWT\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"WriteMGOutput", "[", "LMWT", "]"}]}], "Input",
 CellChangeTimes->{{3.480150833994943*^9, 3.4801508357869*^9}, {
  3.497172871464657*^9, 3.497172879075942*^9}, {3.497282113562158*^9, 
  3.497282121028371*^9}, {3.497345823668093*^9, 3.497345827588054*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - - - FeynRules interface to MadGraph - - -\"\>"], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450370923425*^9}],

Cell[BoxData["\<\"       C. Duhr, M. Herquet, 2008\"\>"], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450370934693*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Creating Directory \"\>", 
   "\[InvisibleSpace]", "\<\"MWT_MG\"\>"}],
  SequenceForm["Creating Directory ", "MWT_MG"],
  Editable->False]], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450370965301*^9}],

Cell[BoxData["\<\"Checking particle list...\"\>"], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450370977777*^9}],

Cell[BoxData["\<\"Ghost fields will be ignored.\"\>"], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450370989715*^9}],

Cell[BoxData["\<\"Checking parameter list...\"\>"], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450371002614*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nCalculating Feynman rules for Lagrangian number \"\>", 
   "\[InvisibleSpace]", "1"}],
  SequenceForm["\nCalculating Feynman rules for Lagrangian number ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450371014126*^9}],

Cell[BoxData["\<\"Starting Feynman rule calculation.\"\>"], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450371027483*^9}],

Cell[BoxData["\<\"Expanding indices...\"\>"], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450371280629*^9}],

Cell[BoxData["\<\"Expanding flavors...\"\>"], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450687242696*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex...\"\>"], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450749401048*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Found \"\>", "\[InvisibleSpace]", "\<\"311\"\>", 
   "\[InvisibleSpace]", "\<\" possible non zero vertices.\"\>"}],
  SequenceForm["Found ", "311", " possible non zero vertices."],
  Editable->False]], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450767933279*^9}],

Cell[BoxData["\<\"Start calculating vertices...\"\>"], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450768080877*^9}],

Cell[BoxData[
 ProgressIndicatorBox[Dynamic[PRIVATE`progress$22564]]], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450768093285*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"311", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[311, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450956730362*^9}],

Cell[BoxData["\<\"Merging vertices...\"\>"], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450956999759*^9}],

Cell[BoxData["\<\"\\n    Converting vertices to MG format\"\>"], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450958743942*^9}],

Cell[BoxData["\<\"Getting color structures.\"\>"], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450962342908*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Getting HELAS structures: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`$helasprogress, StandardForm],
    ImageSizeCache->{21., {0., 7.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "311", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    Getting HELAS structures: ", 
   Dynamic[PRIVATE`$helasprogress], "/", 311, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450962607172*^9}],

Cell[BoxData[
 ProgressIndicatorBox[Dynamic[PRIVATE`progbarvar]]], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450962778018*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    MG Output obtained for \"\>", 
   "\[InvisibleSpace]", "\<\"MWT\"\>"}],
  SequenceForm["    MG Output obtained for ", "MWT"],
  Editable->False]], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450975539271*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"MG / ME output written on \"\>", 
   "\[InvisibleSpace]", "\<\"MWT_MG\"\>"}],
  SequenceForm["MG / ME output written on ", "MWT_MG"],
  Editable->False]], "Print",
 CellChangeTimes->{3.480150836547464*^9, 3.481645396689522*^9, 
  3.481655438676566*^9, 3.481657656339318*^9, 3.483441503962289*^9, 
  3.483444044987062*^9, 3.483696322020876*^9, 3.483696448809014*^9, 
  3.488889216118467*^9, 3.490428494142*^9, 3.490814745502506*^9, 
  3.491289392841104*^9, 3.492966274634835*^9, 3.493013871306241*^9, 
  3.493015719648661*^9, 3.493036101054435*^9, 3.493184030210892*^9, 
  3.497083319439262*^9, 3.497084418884118*^9, 3.497172904439881*^9, 
  3.497175030334094*^9, 3.497185799177232*^9, 3.497186269257707*^9, 
  3.497254798268524*^9, 3.497282144973822*^9, 3.497345830361127*^9, 
  3.497450976653184*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "WriteMGOutput", "]"}]], "Input",
 CellChangeTimes->{{3.497283235250244*^9, 3.497283243891961*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Output", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"DecomposeGluonVertex", "\[Rule]", "True"}], ",", 
   RowBox[{"Exclude4Scalars", "\[Rule]", "False"}], ",", 
   RowBox[{"Debug", "\[Rule]", "False"}], ",", 
   RowBox[{"DialogBox", "\[Rule]", "On"}], ",", 
   RowBox[{"MaxVertices", "\[Rule]", "50"}], ",", 
   RowBox[{"IndexExpand", "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.497283244595506*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1274, 722},
WindowMargins->{{0, Automatic}, {Automatic, 25}},
FrontEndVersion->"7.0 for Linux x86 (32-bit) (February 25, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 180, 6, 99, "Section"],
Cell[750, 30, 118, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[893, 36, 757, 17, 72, "Input"],
Cell[CellGroupData[{
Cell[1675, 57, 2937, 42, 24, "Print"],
Cell[4615, 101, 3062, 46, 24, "Print"],
Cell[7680, 149, 2963, 42, 24, "Print"],
Cell[10646, 193, 2923, 42, 24, "Print"],
Cell[13572, 237, 2950, 42, 24, "Print"],
Cell[16525, 281, 2953, 42, 24, "Print"],
Cell[19481, 325, 2923, 42, 24, "Print"],
Cell[22407, 369, 2989, 43, 24, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25445, 418, 589, 11, 31, "Input"],
Cell[CellGroupData[{
Cell[26059, 433, 2331, 33, 24, "Print"],
Cell[28393, 468, 2302, 33, 24, "Print"],
Cell[30698, 503, 2435, 37, 24, "Print"],
Cell[33136, 542, 2339, 34, 24, "Print"],
Cell[35478, 578, 2291, 33, 24, "Print"],
Cell[37772, 613, 2321, 33, 24, "Print"],
Cell[40096, 648, 2324, 33, 24, "Print"],
Cell[42423, 683, 2322, 33, 24, "Print"],
Cell[44748, 718, 2481, 38, 45, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47290, 763, 169, 2, 72, "Section"],
Cell[CellGroupData[{
Cell[47484, 769, 1075, 20, 72, "Input"],
Cell[CellGroupData[{
Cell[48584, 793, 1049, 15, 24, "Print"],
Cell[49636, 810, 1412, 28, 45, "Print"],
Cell[51051, 840, 1522, 31, 45, "Print"],
Cell[52576, 873, 1424, 28, 45, "Print"],
Cell[54003, 903, 1438, 28, 45, "Print"],
Cell[55444, 933, 1438, 28, 45, "Print"],
Cell[56885, 963, 1006, 15, 24, "Print"],
Cell[57894, 980, 1184, 20, 24, "Print"],
Cell[59081, 1002, 1239, 20, 24, "Print"],
Cell[60323, 1024, 1257, 21, 24, "Print"],
Cell[61583, 1047, 1026, 15, 24, "Print"],
Cell[62612, 1064, 1026, 15, 24, "Print"],
Cell[63641, 1081, 1068, 16, 24, "Print"],
Cell[64712, 1099, 1231, 20, 24, "Print"],
Cell[65946, 1121, 1035, 15, 24, "Print"],
Cell[66984, 1138, 1050, 16, 26, "Print"],
Cell[68037, 1156, 1150, 19, 24, "Print"],
Cell[69190, 1177, 1637, 32, 65, "Print"],
Cell[70830, 1211, 1050, 16, 26, "Print"],
Cell[71883, 1229, 1382, 28, 45, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[73314, 1263, 423, 8, 52, "Input"],
Cell[CellGroupData[{
Cell[73762, 1275, 716, 10, 24, "Print"],
Cell[74481, 1287, 704, 10, 24, "Print"],
Cell[75188, 1299, 836, 15, 24, "Print"],
Cell[76027, 1316, 697, 10, 24, "Print"],
Cell[76727, 1328, 701, 10, 24, "Print"],
Cell[77431, 1340, 698, 10, 24, "Print"],
Cell[78132, 1352, 879, 15, 45, "Print"],
Cell[79014, 1369, 706, 10, 24, "Print"],
Cell[79723, 1381, 692, 10, 24, "Print"],
Cell[80418, 1393, 692, 10, 24, "Print"],
Cell[81113, 1405, 734, 11, 24, "Print"],
Cell[81850, 1418, 897, 15, 24, "Print"],
Cell[82750, 1435, 701, 10, 24, "Print"],
Cell[83454, 1447, 717, 11, 26, "Print"],
Cell[84174, 1460, 816, 14, 24, "Print"],
Cell[84993, 1476, 691, 10, 24, "Print"],
Cell[85687, 1488, 711, 10, 45, "Print"],
Cell[86401, 1500, 697, 10, 24, "Print"],
Cell[87101, 1512, 1080, 18, 24, "Print"],
Cell[88184, 1532, 713, 11, 26, "Print"],
Cell[88900, 1545, 846, 15, 24, "Print"],
Cell[89749, 1562, 850, 15, 24, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[90648, 1583, 138, 2, 31, "Input"],
Cell[90789, 1587, 486, 11, 31, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
