(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    173251,       4927]
NotebookOptionsPosition[    167471,       4747]
NotebookOutlinePosition[    167855,       4764]
CellTagsIndexPosition[    167812,       4761]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Loading the Model", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.5747635829149995`*^9, 3.57476358536814*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell["FeynRules", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}, {
  3.5745083801218367`*^9, 3.5745083815726395`*^9}, {3.5747636519029455`*^9, 
  3.574763653096014*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Development", " ", "version", " ", "of", " ", "FeynRules"}], 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Please", " ", "provide", " ", "the", " ", "proper", " ", "path", " ", 
    "to", " ", "FeynRules", " ", "2.0"}], " ", "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{"$FeynRulesPath", "=", 
    RowBox[{
    "SetDirectory", "[", 
     "\"\<D:\\Logiciels\\Mathematica\\AddOns\\Applications\\FeynRules2.0\>\"",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"<<", "FeynRules`"}]}]}]], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
   3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
   3.4234163227881193`*^9}, {3.511089776533998*^9, 3.511089890304998*^9}, {
   3.570344357677924*^9, 3.5703443578229322`*^9}, {3.570344512008752*^9, 
   3.5703445121387587`*^9}, 3.5703446555509615`*^9, {3.570344736530594*^9, 
   3.570344736711604*^9}, {3.570344822226495*^9, 3.5703448224985104`*^9}, {
   3.570344870967283*^9, 3.5703448712172976`*^9}, {3.570344942914398*^9, 
   3.57034494452749*^9}, 3.570345090188822*^9, 3.570345194557791*^9, 
   3.570345250109968*^9, {3.5703453456004305`*^9, 3.5703453706358624`*^9}, 
   3.570345439946827*^9, {3.5703454920498066`*^9, 3.5703454921988153`*^9}, {
   3.570346138690792*^9, 3.5703461395958443`*^9}, 3.5703463179550457`*^9, 
   3.5704279554332037`*^9, 3.5704315647245255`*^9, 3.570431832892078*^9, 
   3.570432419915621*^9, 3.5704339108589463`*^9, 3.5704393993113914`*^9, {
   3.570441431289675*^9, 3.5704414314956865`*^9}, 3.5704588277894716`*^9, 
   3.5705147301564636`*^9, 3.5705157733421307`*^9, 3.5705194500223126`*^9, 
   3.5705210964258795`*^9, 3.5705224186222773`*^9, 3.570637608174341*^9, {
   3.5718105955684996`*^9, 3.5718105958850393`*^9}, {3.5719846095556064`*^9, 
   3.5719846097111263`*^9}, {3.572196586126171*^9, 3.572196589630116*^9}, {
   3.572198016392996*^9, 3.572198020120469*^9}, {3.5721988385443954`*^9, 
   3.572198838699915*^9}, {3.5730668032312374`*^9, 3.573066839596855*^9}, {
   3.57431159696554*^9, 3.574311618353177*^9}, {3.574311650212433*^9, 
   3.5743116507116337`*^9}, {3.574311696185714*^9, 3.574311836982362*^9}, {
   3.574311868541217*^9, 3.574311869570819*^9}, {3.574763410843158*^9, 
   3.5747634367356386`*^9}, 3.575089230788249*^9, 3.5750920968561935`*^9, {
   3.5751899699742503`*^9, 3.5751899744723215`*^9}, {3.580459597334463*^9, 
   3.5804596004018526`*^9}, {3.597985205509063*^9, 3.5979852057980995`*^9}, {
   3.5979852685860724`*^9, 3.597985283346447*^9}},
 EmphasizeSyntaxErrors->True,
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"D:\\\\Logiciels\\\\Mathematica\\\\AddOns\\\\Applications\\\\\
FeynRules2.0\"\>", TraditionalForm]], "Output",
 CellChangeTimes->{
  3.5730666912455173`*^9, {3.573066734017948*^9, 3.573066757883479*^9}, 
   3.573066843316828*^9, {3.5743116119259663`*^9, 3.5743116225183845`*^9}, 
   3.574311656452444*^9, {3.574311702924926*^9, 3.5743118723320236`*^9}, 
   3.5743119211977096`*^9, 3.574506187694845*^9, 3.574506359525549*^9, 
   3.57450671996922*^9, 3.57450680096904*^9, 3.5745069969483643`*^9, 
   3.5745070275088177`*^9, 3.5745071110937653`*^9, 3.574507150858235*^9, 
   3.5745081530312376`*^9, 3.574763442671978*^9, 3.5747648311793966`*^9, 
   3.575086126206517*^9, 3.5750862345922804`*^9, 3.5750863815544424`*^9, 
   3.575086561645811*^9, 3.5750871134913864`*^9, 3.5750872267162642`*^9, 
   3.575092102509411*^9, 3.5751812131354384`*^9, 3.5751846905558243`*^9, 
   3.5751848375214868`*^9, 3.5751892208091183`*^9, 3.5751894338566723`*^9, 
   3.575189493254715*^9, 3.580459649920641*^9, {3.5806127064531755`*^9, 
   3.5806127285694838`*^9}, {3.5979852169220123`*^9, 3.597985243098336*^9}, 
   3.5979853512765727`*^9, 3.597985400275295*^9, {3.597985559167472*^9, 
   3.5979855662078657`*^9}, 3.5979863760742054`*^9, 3.5979869234402122`*^9, {
   3.5979869673382864`*^9, 3.5979869858621387`*^9}, 3.597987050704373*^9, 
   3.5979872287304792`*^9, 3.597987262568776*^9, 3.5979873072479496`*^9, 
   3.597987356823245*^9, 3.5979874010153565`*^9, 3.5979874518323097`*^9, 
   3.5979875992020235`*^9, 3.597988017008578*^9, {3.597988131838159*^9, 
   3.5979881410448284`*^9}},
 FontSize->7],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\" - FeynRules - \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.574311872347624*^9, 3.5743119211977096`*^9, 3.5745061877104454`*^9, 
   3.574506359525549*^9, 3.57450671996922*^9, 3.57450680096904*^9, 
   3.5745069969483643`*^9, 3.5745070275088177`*^9, 3.574507111109365*^9, 
   3.574507150858235*^9, 3.5745081530312376`*^9, 3.5747634426929793`*^9, 
   3.5747648311823964`*^9, 3.575086126210518*^9, 3.575086234596781*^9, 
   3.575086381558943*^9, 3.5750865616498117`*^9, 3.5750871135293913`*^9, 
   3.575087226721265*^9, 3.5750921025134115`*^9, 3.5751812133514657`*^9, 
   3.5751846906598377`*^9, 3.575184837529988*^9, 3.575189220834622*^9, 
   3.5751894339006777`*^9, 3.5751894932607155`*^9, 3.5804596500676594`*^9, {
   3.5806127065551887`*^9, 3.5806127285734844`*^9}, {3.5979852169900208`*^9, 
   3.5979852431238394`*^9}, 3.5979853512810736`*^9, 3.5979854002787952`*^9, {
   3.597985559207977*^9, 3.597985566209866*^9}, 3.597986376076706*^9, 
   3.5979869234447126`*^9, {3.5979869673427873`*^9, 3.597986985865139*^9}, 
   3.5979870507098737`*^9, 3.5979872287349796`*^9, 3.5979872625737767`*^9, 
   3.59798730725145*^9, 3.5979873568277454`*^9, 3.597987401019357*^9, 
   3.59798745183531*^9, 3.597987599213024*^9, 3.5979880170120783`*^9, {
   3.5979881318471603`*^9, 3.5979881410478287`*^9}},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.0.6\"\>", 
    "\[InvisibleSpace]", 
    RowBox[{"\<\" (\"\>", " ", "\<\"26 November 2013\"\>"}], 
    "\[InvisibleSpace]", "\<\").\"\>"}],
   SequenceForm["Version: ", "2.0.6", " (" "26 November 2013", ")."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.574311872347624*^9, 3.5743119211977096`*^9, 3.5745061877104454`*^9, 
   3.574506359525549*^9, 3.57450671996922*^9, 3.57450680096904*^9, 
   3.5745069969483643`*^9, 3.5745070275088177`*^9, 3.574507111109365*^9, 
   3.574507150858235*^9, 3.5745081530312376`*^9, 3.5747634426929793`*^9, 
   3.5747648311823964`*^9, 3.575086126210518*^9, 3.575086234596781*^9, 
   3.575086381558943*^9, 3.5750865616498117`*^9, 3.5750871135293913`*^9, 
   3.575087226721265*^9, 3.5750921025134115`*^9, 3.5751812133514657`*^9, 
   3.5751846906598377`*^9, 3.575184837529988*^9, 3.575189220834622*^9, 
   3.5751894339006777`*^9, 3.5751894932607155`*^9, 3.5804596500676594`*^9, {
   3.5806127065551887`*^9, 3.5806127285734844`*^9}, {3.5979852169900208`*^9, 
   3.5979852431238394`*^9}, 3.5979853512810736`*^9, 3.5979854002787952`*^9, {
   3.597985559207977*^9, 3.597985566209866*^9}, 3.597986376076706*^9, 
   3.5979869234447126`*^9, {3.5979869673427873`*^9, 3.597986985865139*^9}, 
   3.5979870507098737`*^9, 3.5979872287349796`*^9, 3.5979872625737767`*^9, 
   3.59798730725145*^9, 3.5979873568277454`*^9, 3.597987401019357*^9, 
   3.59798745183531*^9, 3.597987599213024*^9, 3.5979880170120783`*^9, {
   3.5979881318471603`*^9, 3.597988141050829*^9}},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, B. \
Fuks\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.574311872347624*^9, 3.5743119211977096`*^9, 3.5745061877104454`*^9, 
   3.574506359525549*^9, 3.57450671996922*^9, 3.57450680096904*^9, 
   3.5745069969483643`*^9, 3.5745070275088177`*^9, 3.574507111109365*^9, 
   3.574507150858235*^9, 3.5745081530312376`*^9, 3.5747634426929793`*^9, 
   3.5747648311823964`*^9, 3.575086126210518*^9, 3.575086234596781*^9, 
   3.575086381558943*^9, 3.5750865616498117`*^9, 3.5750871135293913`*^9, 
   3.575087226721265*^9, 3.5750921025134115`*^9, 3.5751812133514657`*^9, 
   3.5751846906598377`*^9, 3.575184837529988*^9, 3.575189220834622*^9, 
   3.5751894339006777`*^9, 3.5751894932607155`*^9, 3.5804596500676594`*^9, {
   3.5806127065551887`*^9, 3.5806127285734844`*^9}, {3.5979852169900208`*^9, 
   3.5979852431238394`*^9}, 3.5979853512810736`*^9, 3.5979854002787952`*^9, {
   3.597985559207977*^9, 3.597985566209866*^9}, 3.597986376076706*^9, 
   3.5979869234447126`*^9, {3.5979869673427873`*^9, 3.597986985865139*^9}, 
   3.5979870507098737`*^9, 3.5979872287349796`*^9, 3.5979872625737767`*^9, 
   3.59798730725145*^9, 3.5979873568277454`*^9, 3.597987401019357*^9, 
   3.59798745183531*^9, 3.597987599213024*^9, 3.5979880170120783`*^9, {
   3.5979881318471603`*^9, 3.5979881410538297`*^9}},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\" \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.574311872347624*^9, 3.5743119211977096`*^9, 3.5745061877104454`*^9, 
   3.574506359525549*^9, 3.57450671996922*^9, 3.57450680096904*^9, 
   3.5745069969483643`*^9, 3.5745070275088177`*^9, 3.574507111109365*^9, 
   3.574507150858235*^9, 3.5745081530312376`*^9, 3.5747634426929793`*^9, 
   3.5747648311823964`*^9, 3.575086126210518*^9, 3.575086234596781*^9, 
   3.575086381558943*^9, 3.5750865616498117`*^9, 3.5750871135293913`*^9, 
   3.575087226721265*^9, 3.5750921025134115`*^9, 3.5751812133514657`*^9, 
   3.5751846906598377`*^9, 3.575184837529988*^9, 3.575189220834622*^9, 
   3.5751894339006777`*^9, 3.5751894932607155`*^9, 3.5804596500676594`*^9, {
   3.5806127065551887`*^9, 3.5806127285734844`*^9}, {3.5979852169900208`*^9, 
   3.5979852431238394`*^9}, 3.5979853512810736`*^9, 3.5979854002787952`*^9, {
   3.597985559207977*^9, 3.597985566209866*^9}, 3.597986376076706*^9, 
   3.5979869234447126`*^9, {3.5979869673427873`*^9, 3.597986985865139*^9}, 
   3.5979870507098737`*^9, 3.5979872287349796`*^9, 3.5979872625737767`*^9, 
   3.59798730725145*^9, 3.5979873568277454`*^9, 3.597987401019357*^9, 
   3.59798745183531*^9, 3.597987599213024*^9, 3.5979880170120783`*^9, {
   3.5979881318471603`*^9, 3.5979881410563297`*^9}},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Please cite:\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.574311872347624*^9, 3.5743119211977096`*^9, 3.5745061877104454`*^9, 
   3.574506359525549*^9, 3.57450671996922*^9, 3.57450680096904*^9, 
   3.5745069969483643`*^9, 3.5745070275088177`*^9, 3.574507111109365*^9, 
   3.574507150858235*^9, 3.5745081530312376`*^9, 3.5747634426929793`*^9, 
   3.5747648311823964`*^9, 3.575086126210518*^9, 3.575086234596781*^9, 
   3.575086381558943*^9, 3.5750865616498117`*^9, 3.5750871135293913`*^9, 
   3.575087226721265*^9, 3.5750921025134115`*^9, 3.5751812133514657`*^9, 
   3.5751846906598377`*^9, 3.575184837529988*^9, 3.575189220834622*^9, 
   3.5751894339006777`*^9, 3.5751894932607155`*^9, 3.5804596500676594`*^9, {
   3.5806127065551887`*^9, 3.5806127285734844`*^9}, {3.5979852169900208`*^9, 
   3.5979852431238394`*^9}, 3.5979853512810736`*^9, 3.5979854002787952`*^9, {
   3.597985559207977*^9, 3.597985566209866*^9}, 3.597986376076706*^9, 
   3.5979869234447126`*^9, {3.5979869673427873`*^9, 3.597986985865139*^9}, 
   3.5979870507098737`*^9, 3.5979872287349796`*^9, 3.5979872625737767`*^9, 
   3.59798730725145*^9, 3.5979873568277454`*^9, 3.597987401019357*^9, 
   3.59798745183531*^9, 3.597987599213024*^9, 3.5979880170120783`*^9, {
   3.5979881318471603`*^9, 3.5979881410588303`*^9}},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"    - arXiv:1310.1921;\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.574311872347624*^9, 3.5743119211977096`*^9, 3.5745061877104454`*^9, 
   3.574506359525549*^9, 3.57450671996922*^9, 3.57450680096904*^9, 
   3.5745069969483643`*^9, 3.5745070275088177`*^9, 3.574507111109365*^9, 
   3.574507150858235*^9, 3.5745081530312376`*^9, 3.5747634426929793`*^9, 
   3.5747648311823964`*^9, 3.575086126210518*^9, 3.575086234596781*^9, 
   3.575086381558943*^9, 3.5750865616498117`*^9, 3.5750871135293913`*^9, 
   3.575087226721265*^9, 3.5750921025134115`*^9, 3.5751812133514657`*^9, 
   3.5751846906598377`*^9, 3.575184837529988*^9, 3.575189220834622*^9, 
   3.5751894339006777`*^9, 3.5751894932607155`*^9, 3.5804596500676594`*^9, {
   3.5806127065551887`*^9, 3.5806127285734844`*^9}, {3.5979852169900208`*^9, 
   3.5979852431238394`*^9}, 3.5979853512810736`*^9, 3.5979854002787952`*^9, {
   3.597985559207977*^9, 3.597985566209866*^9}, 3.597986376076706*^9, 
   3.5979869234447126`*^9, {3.5979869673427873`*^9, 3.597986985865139*^9}, 
   3.5979870507098737`*^9, 3.5979872287349796`*^9, 3.5979872625737767`*^9, 
   3.59798730725145*^9, 3.5979873568277454`*^9, 3.597987401019357*^9, 
   3.59798745183531*^9, 3.597987599213024*^9, 3.5979880170120783`*^9, {
   3.5979881318471603`*^9, 3.5979881410613303`*^9}},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.574311872347624*^9, 3.5743119211977096`*^9, 3.5745061877104454`*^9, 
   3.574506359525549*^9, 3.57450671996922*^9, 3.57450680096904*^9, 
   3.5745069969483643`*^9, 3.5745070275088177`*^9, 3.574507111109365*^9, 
   3.574507150858235*^9, 3.5745081530312376`*^9, 3.5747634426929793`*^9, 
   3.5747648311823964`*^9, 3.575086126210518*^9, 3.575086234596781*^9, 
   3.575086381558943*^9, 3.5750865616498117`*^9, 3.5750871135293913`*^9, 
   3.575087226721265*^9, 3.5750921025134115`*^9, 3.5751812133514657`*^9, 
   3.5751846906598377`*^9, 3.575184837529988*^9, 3.575189220834622*^9, 
   3.5751894339006777`*^9, 3.5751894932607155`*^9, 3.5804596500676594`*^9, {
   3.5806127065551887`*^9, 3.5806127285734844`*^9}, {3.5979852169900208`*^9, 
   3.5979852431238394`*^9}, 3.5979853512810736`*^9, 3.5979854002787952`*^9, {
   3.597985559207977*^9, 3.597985566209866*^9}, 3.597986376076706*^9, 
   3.5979869234447126`*^9, {3.5979869673427873`*^9, 3.597986985865139*^9}, 
   3.5979870507098737`*^9, 3.5979872287349796`*^9, 3.5979872625737767`*^9, 
   3.59798730725145*^9, 3.5979873568277454`*^9, 3.597987401019357*^9, 
   3.59798745183531*^9, 3.597987599213024*^9, 3.5979880170120783`*^9, {
   3.5979881318471603`*^9, 3.597988141064831*^9}},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\" \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.574311872347624*^9, 3.5743119211977096`*^9, 3.5745061877104454`*^9, 
   3.574506359525549*^9, 3.57450671996922*^9, 3.57450680096904*^9, 
   3.5745069969483643`*^9, 3.5745070275088177`*^9, 3.574507111109365*^9, 
   3.574507150858235*^9, 3.5745081530312376`*^9, 3.5747634426929793`*^9, 
   3.5747648311823964`*^9, 3.575086126210518*^9, 3.575086234596781*^9, 
   3.575086381558943*^9, 3.5750865616498117`*^9, 3.5750871135293913`*^9, 
   3.575087226721265*^9, 3.5750921025134115`*^9, 3.5751812133514657`*^9, 
   3.5751846906598377`*^9, 3.575184837529988*^9, 3.575189220834622*^9, 
   3.5751894339006777`*^9, 3.5751894932607155`*^9, 3.5804596500676594`*^9, {
   3.5806127065551887`*^9, 3.5806127285734844`*^9}, {3.5979852169900208`*^9, 
   3.5979852431238394`*^9}, 3.5979853512810736`*^9, 3.5979854002787952`*^9, {
   3.597985559207977*^9, 3.597985566209866*^9}, 3.597986376076706*^9, 
   3.5979869234447126`*^9, {3.5979869673427873`*^9, 3.597986985865139*^9}, 
   3.5979870507098737`*^9, 3.5979872287349796`*^9, 3.5979872625737767`*^9, 
   3.59798730725145*^9, 3.5979873568277454`*^9, 3.597987401019357*^9, 
   3.59798745183531*^9, 3.597987599213024*^9, 3.5979880170120783`*^9, {
   3.5979881318471603`*^9, 3.5979881410673313`*^9}},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"http://feynrules.phys.ucl.ac.be\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{
  3.574311872347624*^9, 3.5743119211977096`*^9, 3.5745061877104454`*^9, 
   3.574506359525549*^9, 3.57450671996922*^9, 3.57450680096904*^9, 
   3.5745069969483643`*^9, 3.5745070275088177`*^9, 3.574507111109365*^9, 
   3.574507150858235*^9, 3.5745081530312376`*^9, 3.5747634426929793`*^9, 
   3.5747648311823964`*^9, 3.575086126210518*^9, 3.575086234596781*^9, 
   3.575086381558943*^9, 3.5750865616498117`*^9, 3.5750871135293913`*^9, 
   3.575087226721265*^9, 3.5750921025134115`*^9, 3.5751812133514657`*^9, 
   3.5751846906598377`*^9, 3.575184837529988*^9, 3.575189220834622*^9, 
   3.5751894339006777`*^9, 3.5751894932607155`*^9, 3.5804596500676594`*^9, {
   3.5806127065551887`*^9, 3.5806127285734844`*^9}, {3.5979852169900208`*^9, 
   3.5979852431238394`*^9}, 3.5979853512810736`*^9, 3.5979854002787952`*^9, {
   3.597985559207977*^9, 3.597985566209866*^9}, 3.597986376076706*^9, 
   3.5979869234447126`*^9, {3.5979869673427873`*^9, 3.597986985865139*^9}, 
   3.5979870507098737`*^9, 3.5979872287349796`*^9, 3.5979872625737767`*^9, 
   3.59798730725145*^9, 3.5979873568277454`*^9, 3.597987401019357*^9, 
   3.59798745183531*^9, 3.597987599213024*^9, 3.5979880170120783`*^9, {
   3.5979881318471603`*^9, 3.597988141069832*^9}},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\" \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.574311872347624*^9, 3.5743119211977096`*^9, 3.5745061877104454`*^9, 
   3.574506359525549*^9, 3.57450671996922*^9, 3.57450680096904*^9, 
   3.5745069969483643`*^9, 3.5745070275088177`*^9, 3.574507111109365*^9, 
   3.574507150858235*^9, 3.5745081530312376`*^9, 3.5747634426929793`*^9, 
   3.5747648311823964`*^9, 3.575086126210518*^9, 3.575086234596781*^9, 
   3.575086381558943*^9, 3.5750865616498117`*^9, 3.5750871135293913`*^9, 
   3.575087226721265*^9, 3.5750921025134115`*^9, 3.5751812133514657`*^9, 
   3.5751846906598377`*^9, 3.575184837529988*^9, 3.575189220834622*^9, 
   3.5751894339006777`*^9, 3.5751894932607155`*^9, 3.5804596500676594`*^9, {
   3.5806127065551887`*^9, 3.5806127285734844`*^9}, {3.5979852169900208`*^9, 
   3.5979852431238394`*^9}, 3.5979853512810736`*^9, 3.5979854002787952`*^9, {
   3.597985559207977*^9, 3.597985566209866*^9}, 3.597986376076706*^9, 
   3.5979869234447126`*^9, {3.5979869673427873`*^9, 3.597986985865139*^9}, 
   3.5979870507098737`*^9, 3.5979872287349796`*^9, 3.5979872625737767`*^9, 
   3.59798730725145*^9, 3.5979873568277454`*^9, 3.597987401019357*^9, 
   3.59798745183531*^9, 3.597987599213024*^9, 3.5979880170120783`*^9, {
   3.5979881318471603`*^9, 3.597988141072332*^9}},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.574311872347624*^9, 3.5743119211977096`*^9, 3.5745061877104454`*^9, 
   3.574506359525549*^9, 3.57450671996922*^9, 3.57450680096904*^9, 
   3.5745069969483643`*^9, 3.5745070275088177`*^9, 3.574507111109365*^9, 
   3.574507150858235*^9, 3.5745081530312376`*^9, 3.5747634426929793`*^9, 
   3.5747648311823964`*^9, 3.575086126210518*^9, 3.575086234596781*^9, 
   3.575086381558943*^9, 3.5750865616498117`*^9, 3.5750871135293913`*^9, 
   3.575087226721265*^9, 3.5750921025134115`*^9, 3.5751812133514657`*^9, 
   3.5751846906598377`*^9, 3.575184837529988*^9, 3.575189220834622*^9, 
   3.5751894339006777`*^9, 3.5751894932607155`*^9, 3.5804596500676594`*^9, {
   3.5806127065551887`*^9, 3.5806127285734844`*^9}, {3.5979852169900208`*^9, 
   3.5979852431238394`*^9}, 3.5979853512810736`*^9, 3.5979854002787952`*^9, {
   3.597985559207977*^9, 3.597985566209866*^9}, 3.597986376076706*^9, 
   3.5979869234447126`*^9, {3.5979869673427873`*^9, 3.597986985865139*^9}, 
   3.5979870507098737`*^9, 3.5979872287349796`*^9, 3.5979872625737767`*^9, 
   3.59798730725145*^9, 3.5979873568277454`*^9, 3.597987401019357*^9, 
   3.59798745183531*^9, 3.597987599213024*^9, 3.5979880170120783`*^9, {
   3.5979881318471603`*^9, 3.5979881410758324`*^9}},
 FontSize->7]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Loading TFCNC.fr", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}, {
  3.5745083801218367`*^9, 3.5745083815726395`*^9}, {3.5747636603284273`*^9, 
  3.5747636618625154`*^9}, {3.5751899838405113`*^9, 3.575189994177824*^9}, {
  3.5806126746616387`*^9, 3.580612677003936*^9}, {3.597985291998046*^9, 
  3.5979852972937183`*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Please", " ", "provide", " ", "the", " ", "proper", " ", "path", " ", 
    "to", " ", "the", " ", 
    RowBox[{"TFCNC", ".", "fr"}], " ", "file"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Standard", " ", "Model", " ", "is", " ", "loaded", " ", "by", " ", 
    "default"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM\>\""}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"LoadModel", "[", "\"\<SM.fr\>\"", "]"}]}], "\[IndentingNewLine]",
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SameSignTops\>\""}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"LoadModel", "[", "\"\<TFCNC.fr\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{"LoadRestriction", "[", "\"\<Massless.rst\>\"", "]"}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"ModelInformation", "[", "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
      "The", " ", "massless", " ", "restriction", " ", "ensures", " ", 
       "appropriate", " ", "definitions", " ", "for", " ", "the", " ", 
       "PDF"}], " ", "&"}], " ", "light", " ", "quarks"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"LoadRestriction", "[", "\"\<Cabibbo.rst\>\"", "]"}], 
     "\[IndentingNewLine]", 
     RowBox[{"LoadRestriction", "[", "\"\<DiagonalCKM.rst\>\"", "]"}]}], 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.574506706301206*^9, 3.5745067318765955`*^9}, {
   3.5747636000559797`*^9, 3.574763622303252*^9}, {3.575089695153716*^9, 
   3.575089721000498*^9}, {3.5751899988184133`*^9, 3.575190006169347*^9}, {
   3.580612668625372*^9, 3.580612669898034*^9}, {3.580612718474702*^9, 
   3.580612718624221*^9}, {3.597985261607686*^9, 3.597985263777462*^9}, {
   3.5979853033704896`*^9, 3.59798531699872*^9}, {3.5979867302871847`*^9, 
   3.597986738798766*^9}, {3.597986930485607*^9, 3.597986959751323*^9}, 
   3.5979872254085574`*^9, 3.5979873967318125`*^9, {3.597987434771143*^9, 
   3.597987446925186*^9}, 3.597988014362742*^9, 3.59798812877177*^9},
 FontSize->8],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"This model implementation was created by\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5979881456349115`*^9}],

Cell[BoxData[
 FormBox["\<\"M. Buchkremer\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5979881456374116`*^9}],

Cell[BoxData[
 FormBox["\<\"G. Cacciapaglia\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5979881456404123`*^9}],

Cell[BoxData[
 FormBox["\<\"A. Deandrea\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5979881456434126`*^9}],

Cell[BoxData[
 FormBox["\<\"L. Panizzi\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.597988145645913*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"2.0\"\>"}],
   SequenceForm["Model Version: ", "2.0"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5979881456489134`*^9}],

Cell[BoxData[
 FormBox["\<\"For more information, type ModelInformation[].\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5979881456519136`*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5979881456544137`*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading particle classes.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{3.597988145656414*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading gauge group classes.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5979881458049326`*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading parameter classes.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{3.5979881458164344`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"TFCNC\"\>", 
    "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
   SequenceForm["\nModel ", "TFCNC", " loaded."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.597988145886443*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Model name: \"\>", "\[InvisibleSpace]", "\<\"TFCNC\"\>"}],
   SequenceForm["Model name: ", "TFCNC"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5979881458969445`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Model version: \"\>", "\[InvisibleSpace]", "\<\"2.0\"\>"}],
   SequenceForm["Model version: ", "2.0"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.597988145900445*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Date: \"\>", "\[InvisibleSpace]", "\<\"24. 12. 2013\"\>"}],
   SequenceForm["Date: ", "24. 12. 2013"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5979881459029455`*^9}],

Cell[BoxData[
 FormBox["\<\"Authors: \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.597988145905946*^9}],

Cell[BoxData[
 FormBox["\<\"   M. Buchkremer\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.597988145908946*^9}],

Cell[BoxData[
 FormBox["\<\"   G. Cacciapaglia\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5979881459114466`*^9}],

Cell[BoxData[
 FormBox["\<\"   A. Deandrea\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.597988145914447*^9}],

Cell[BoxData[
 FormBox["\<\"   L. Panizzi\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5979881459169474`*^9}],

Cell[BoxData[
 FormBox["\<\"Institutions: \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5979881459194474`*^9}],

Cell[BoxData[
 FormBox["\<\"   Universite catholique de Louvain (CP3)\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5979881459224477`*^9}],

Cell[BoxData[
 FormBox["\<\"   Universite de Lyon (CNRS/IN2P3)\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5979881459249477`*^9}],

Cell[BoxData[
 FormBox["\<\"   University of Southampton (School of Physics and \
Astronomy)\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5979881459269485`*^9}],

Cell[BoxData[
 FormBox["\<\"Emails: \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.597988145929449*^9}],

Cell[BoxData[
 FormBox["\<\"   mathieu.buchkremer@uclouvain.be\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5979881459319487`*^9}],

Cell[BoxData[
 FormBox["\<\"   g.cacciapaglia@ipnl.in2p3.fr\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{3.5979881459339495`*^9}],

Cell[BoxData[
 FormBox["\<\"   deandrea@ipnl.in2p3.fr\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5979881459369497`*^9}],

Cell[BoxData[
 FormBox["\<\"   l.panizzi@soton.ac.uk\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5979881459394503`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Outputs and interfaces", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell["FeynmanGauge", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}, {
  3.5745083801218367`*^9, 3.5745083815726395`*^9}, {3.5979875521835527`*^9, 
  3.597987553864766*^9}},
 FontSize->9],

Cell["The FeynRules output for the SM can be obtained via", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911062212926*^9, 3.4119110634765463`*^9}, {3.5745083846458445`*^9, 
  3.5745083861746473`*^9}},
 FontSize->9],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", " ", "=", " ", "False"}], ";"}]], "Input",
 CellChangeTimes->{{3.5705189929967775`*^9, 3.570519000011668*^9}, 
   3.5705192098938203`*^9, {3.5705192814649086`*^9, 3.570519281656433*^9}, {
   3.5705193273207316`*^9, 3.570519333615531*^9}, {3.570521451647987*^9, 
   3.570521531465122*^9}, {3.571326951698388*^9, 3.5713269550678167`*^9}, {
   3.5743121975149927`*^9, 3.574312200204996*^9}, 3.5745073225521364`*^9, 
   3.597985656043273*^9},
 FontSize->8]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Displaying the Feynman Rules for the VLQ lagrangian\
\>", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}, {
  3.5745083801218367`*^9, 3.5745083815726395`*^9}, {3.5747636723761168`*^9, 
  3.5747636850628424`*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "L", "]"}]], "Input",
 CellChangeTimes->{
  3.5806127500132074`*^9, {3.580612848144668*^9, 3.580612863560626*^9}, 
   3.5806129092014217`*^9},
 FontSize->7],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  StyleBox["\<\"Starting Feynman rule calculation.\"\>",
   StripOnInput->False,
   LineColor->RGBColor[1, 0.5, 0],
   FrontFaceColor->RGBColor[1, 0.5, 0],
   BackFaceColor->RGBColor[1, 0.5, 0],
   GraphicsColor->RGBColor[1, 0.5, 0],
   FontWeight->Bold,
   FontColor->RGBColor[1, 0.5, 0]], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.5719846736677475`*^9, 3.5721967373743773`*^9, 3.5730660940666847`*^9, 
   3.573066860069955*^9, 3.5743119552681694`*^9, 3.5745071808726873`*^9, 
   3.574508189441702*^9, 3.574763456091746*^9, 3.5747648368577213`*^9, 
   3.5750861401467876`*^9, 3.575086246151248*^9, 3.57508639531619*^9, 
   3.5750865675570617`*^9, 3.575181221513502*^9, 3.575184839116189*^9, 
   3.5751892227703676`*^9, 3.575189494963432*^9, 3.5804596895486727`*^9, 
   3.5806127510563393`*^9, {3.58061284863173*^9, 3.580612863806657*^9}, 
   3.580612909535964*^9, 3.5979856047302575`*^9, 3.597985660094288*^9, 
   3.597986414163042*^9, 3.5979876023144183`*^9, 3.597988152627799*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Expanding the Lagrangian...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.5719846736677475`*^9, 3.5721967373743773`*^9, 3.5730660940666847`*^9, 
   3.573066860069955*^9, 3.5743119552681694`*^9, 3.5745071808726873`*^9, 
   3.574508189441702*^9, 3.574763456091746*^9, 3.5747648368577213`*^9, 
   3.5750861401467876`*^9, 3.575086246151248*^9, 3.57508639531619*^9, 
   3.5750865675570617`*^9, 3.575181221513502*^9, 3.575184839116189*^9, 
   3.5751892227703676`*^9, 3.575189494963432*^9, 3.5804596895486727`*^9, 
   3.5806127510563393`*^9, {3.58061284863173*^9, 3.580612863806657*^9}, 
   3.580612909535964*^9, 3.5979856047302575`*^9, 3.597985660094288*^9, 
   3.597986414163042*^9, 3.5979876023144183`*^9, 3.5979881526298*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Expanding indices over \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" cores\"\>"}],
   SequenceForm["Expanding indices over ", 2, " cores"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.5719846736677475`*^9, 3.5721967373743773`*^9, 3.5730660940666847`*^9, 
   3.573066860069955*^9, 3.5743119552681694`*^9, 3.5745071808726873`*^9, 
   3.574508189441702*^9, 3.574763456091746*^9, 3.5747648368577213`*^9, 
   3.5750861401467876`*^9, 3.575086246151248*^9, 3.57508639531619*^9, 
   3.5750865675570617`*^9, 3.575181221513502*^9, 3.575184839116189*^9, 
   3.5751892227703676`*^9, 3.575189494963432*^9, 3.5804596895486727`*^9, 
   3.5806127510563393`*^9, {3.58061284863173*^9, 3.580612863806657*^9}, 
   3.580612909535964*^9, 3.5979856047302575`*^9, 3.597985660094288*^9, 
   3.597986414163042*^9, 3.5979876023144183`*^9, 3.5979881526328*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the vertex.\"\>",
   TraditionalForm]], "Print",
 CellChangeTimes->{
  3.5719846736677475`*^9, 3.5721967373743773`*^9, 3.5730660940666847`*^9, 
   3.573066860069955*^9, 3.5743119552681694`*^9, 3.5745071808726873`*^9, 
   3.574508189441702*^9, 3.574763456091746*^9, 3.5747648368577213`*^9, 
   3.5750861401467876`*^9, 3.575086246151248*^9, 3.57508639531619*^9, 
   3.5750865675570617`*^9, 3.575181221513502*^9, 3.575184839116189*^9, 
   3.5751892227703676`*^9, 3.575189494963432*^9, 3.5804596895486727`*^9, 
   3.5806127510563393`*^9, {3.58061284863173*^9, 3.580612863806657*^9}, 
   3.580612909535964*^9, 3.5979856047302575`*^9, 3.597985660094288*^9, 
   3.597986414163042*^9, 3.5979876023144183`*^9, 3.597988154234003*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
   "36", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
    DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, TraditionalForm],
     ImageSizeCache->{12., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
    "\[InvisibleSpace]", "36", "\[InvisibleSpace]", "\<\".\"\>"}],
   SequenceForm[
   36, " possible non-zero vertices have been found -> starting the \
computation: ", 
    Dynamic[FeynRules`FR$FeynmanRules], " / ", 36, "."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.5719846736677475`*^9, 3.5721967373743773`*^9, 3.5730660940666847`*^9, 
   3.573066860069955*^9, 3.5743119552681694`*^9, 3.5745071808726873`*^9, 
   3.574508189441702*^9, 3.574763456091746*^9, 3.5747648368577213`*^9, 
   3.5750861401467876`*^9, 3.575086246151248*^9, 3.57508639531619*^9, 
   3.5750865675570617`*^9, 3.575181221513502*^9, 3.575184839116189*^9, 
   3.5751892227703676`*^9, 3.575189494963432*^9, 3.5804596895486727`*^9, 
   3.5806127510563393`*^9, {3.58061284863173*^9, 3.580612863806657*^9}, 
   3.580612909535964*^9, 3.5979856047302575`*^9, 3.597985660094288*^9, 
   3.597986414163042*^9, 3.5979876023144183`*^9, 3.5979881542690077`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"35", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
   SequenceForm[35, " vertices obtained."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.5719846736677475`*^9, 3.5721967373743773`*^9, 3.5730660940666847`*^9, 
   3.573066860069955*^9, 3.5743119552681694`*^9, 3.5745071808726873`*^9, 
   3.574508189441702*^9, 3.574763456091746*^9, 3.5747648368577213`*^9, 
   3.5750861401467876`*^9, 3.575086246151248*^9, 3.57508639531619*^9, 
   3.5750865675570617`*^9, 3.575181221513502*^9, 3.575184839116189*^9, 
   3.5751892227703676`*^9, 3.575189494963432*^9, 3.5804596895486727`*^9, 
   3.5806127510563393`*^9, {3.58061284863173*^9, 3.580612863806657*^9}, 
   3.580612909535964*^9, 3.5979856047302575`*^9, 3.597985660094288*^9, 
   3.597986414163042*^9, 3.5979876023144183`*^9, 3.5979881562907643`*^9},
 FontSize->7]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"H", "1"},
         {"H", "2"},
         {"H", "3"},
         {"H", "4"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "\[Lambda]"}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"H", "1"},
         {"H", "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "v", " ", "\[Lambda]"}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           SuperscriptBox["ghG", "\[Dagger]"],
           TraditionalForm], "1"},
         {"ghG", "2"},
         {"G", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "2", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "3"],
           TraditionalForm]],
         TraditionalForm]}], "+", 
       RowBox[{
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "3", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "3"],
           TraditionalForm]],
         TraditionalForm]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"G", "2"},
         {"G", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "1", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "3"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "2", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "3"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "1", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "2"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "3", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "2"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "2", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "1"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{
        FormBox[
         SubscriptBox["g", "s"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "3", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "1"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"G", "1"},
         {"G", "2"},
         {"G", "3"},
         {"G", "4"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "3"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["f", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"a\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"a\"\>", "4"],
            TraditionalForm], ",", 
           FormBox["Gluon$1",
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "s"],
          TraditionalForm], "2"]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["c", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"t", "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KtcH", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["t", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"c", "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KtcH", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["t", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"u", "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KtuH", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["u", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"t", "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", "KtuH", " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["dq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"dq", "2"},
         {"G", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", 
       FormBox[
        SubscriptBox["g", "s"],
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["\[Gamma]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"f\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"f\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["T", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"a\"\>", "3"],
          TraditionalForm]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["uq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"uq", "2"},
         {"G", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"\[ImaginaryI]", " ", 
       FormBox[
        SubscriptBox["g", "s"],
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["\[Gamma]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"f\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"f\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["T", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"a\"\>", "3"],
          TraditionalForm]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"A", "1"},
         {"W", "2"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        FormBox[
         SubscriptBox["g", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["s", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "1", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "3"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["s", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "2", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "3"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["s", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "1", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "2"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["s", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "3", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "2"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["s", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "2", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "1"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["g", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["s", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "3", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "1"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"H", "1"},
         {"H", "2"},
         {"W", "3"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "4"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox[
         FormBox["e",
          TraditionalForm], "2"], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], "2"]}]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"H", "1"},
         {"W", "2"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox[
         FormBox["e",
          TraditionalForm], "2"], " ", "v", " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], "2"]}]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"A", "1"},
         {"A", "2"},
         {"W", "3"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "4"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "w"],
          TraditionalForm], "2"], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "w"],
          TraditionalForm], "2"], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], "2"]}], "-", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "w"],
          TraditionalForm], "2"], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], "2"]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"W", "1"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        FormBox[
         SubscriptBox["c", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["g", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "1", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "3"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["c", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["g", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "2", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "3"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["c", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["g", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "1", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "2"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["c", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["g", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "3", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "2"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["c", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["g", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "2", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "1"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["c", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["g", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubsuperscriptBox["\<\"p\"\>", "3", 
          FormBox[
           SubscriptBox["\<\"\[Mu]\"\>", "1"],
           TraditionalForm]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"W", "1"},
         {"W", "2"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "3"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "4"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "w"],
          TraditionalForm], "2"]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "w"],
          TraditionalForm], "2"]}], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "w"],
          TraditionalForm], "2"]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["dq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"dq", "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"f\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"f\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           TemplateBox[{"y","d"},
            "Superscript"], 
           FormBox[
            SubscriptBox["\<\"f\"\>", "1"],
            TraditionalForm]],
          TraditionalForm]}], 
        SqrtBox["2"]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["l", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"l", "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"f\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"f\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           TemplateBox[{"y","l"},
            "Superscript"], 
           FormBox[
            SubscriptBox["\<\"f\"\>", "1"],
            TraditionalForm]],
          TraditionalForm]}], 
        SqrtBox["2"]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["uq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"uq", "2"},
         {"H", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"f\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"f\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           TemplateBox[{"y","u"},
            "Superscript"], 
           FormBox[
            SubscriptBox["\<\"f\"\>", "1"],
            TraditionalForm]],
          TraditionalForm]}], 
        SqrtBox["2"]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"A", "1"},
         {"W", "2"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "3"},
         {"Z", "4"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["c", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["s", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "w"],
          TraditionalForm], "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["c", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["s", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "w"],
          TraditionalForm], "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["c", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["s", "w"],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "w"],
          TraditionalForm], "2"]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"H", "1"},
         {"H", "2"},
         {"Z", "3"},
         {"Z", "4"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox[
          FormBox[
           SubscriptBox["s", "w"],
           TraditionalForm], "2"], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "4"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         SuperscriptBox[
          FormBox["e",
           TraditionalForm], "2"]}], 
        RowBox[{"2", " ", 
         SuperscriptBox[
          FormBox[
           SubscriptBox["c", "w"],
           TraditionalForm], "2"]}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox[
          FormBox[
           SubscriptBox["c", "w"],
           TraditionalForm], "2"], " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "4"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         SuperscriptBox[
          FormBox["e",
           TraditionalForm], "2"]}], 
        RowBox[{"2", " ", 
         SuperscriptBox[
          FormBox[
           SubscriptBox["s", "w"],
           TraditionalForm], "2"]}]], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox["e",
          TraditionalForm], "2"]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"H", "1"},
         {"Z", "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox[
          FormBox[
           SubscriptBox["s", "w"],
           TraditionalForm], "2"], " ", "v", " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         SuperscriptBox[
          FormBox["e",
           TraditionalForm], "2"]}], 
        RowBox[{"2", " ", 
         SuperscriptBox[
          FormBox[
           SubscriptBox["c", "w"],
           TraditionalForm], "2"]}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox[
          FormBox[
           SubscriptBox["c", "w"],
           TraditionalForm], "2"], " ", "v", " ", 
         FormBox[
          SubscriptBox["\[Eta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "2"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"\[Mu]\"\>", "3"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         SuperscriptBox[
          FormBox["e",
           TraditionalForm], "2"]}], 
        RowBox[{"2", " ", 
         SuperscriptBox[
          FormBox[
           SubscriptBox["s", "w"],
           TraditionalForm], "2"]}]], "+", 
       RowBox[{"\[ImaginaryI]", " ", "v", " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox["e",
          TraditionalForm], "2"]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"W", "1"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "2"},
         {"Z", "3"},
         {"Z", "4"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm], "2"], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "w"],
          TraditionalForm], "2"]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm], "2"], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "w"],
          TraditionalForm], "2"]}], "-", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm], "2"], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Eta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "3"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"\[Mu]\"\>", "4"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["g", "w"],
          TraditionalForm], "2"]}]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["dq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"dq", "2"},
         {"A", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "3"]}], " ", "\[ImaginaryI]", " ", 
       FormBox["e",
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["\[Gamma]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"f\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"f\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["dq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"dq", "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          FormBox["e",
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["s", "w"],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["\[Delta]", 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"i\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"i\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["\[Delta]", 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"f\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"f\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}], 
         RowBox[{"6", " ", 
          FormBox[
           SubscriptBox["c", "w"],
           TraditionalForm]}]]}], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm], " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"f\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"f\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox[
               SubscriptBox["\<\"\[Mu]\"\>", "3"],
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm]}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"f\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"f\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox[
               SubscriptBox["\<\"\[Mu]\"\>", "3"],
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"+\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"3", " ", 
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm]}]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["l", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"l", "2"},
         {"A", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       FormBox["e",
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["\[Gamma]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"f\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"f\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["l", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"l", "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"f\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"f\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox[
               SubscriptBox["\<\"\[Mu]\"\>", "3"],
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm]}]], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm], " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"f\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"f\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox[
               SubscriptBox["\<\"\[Mu]\"\>", "3"],
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm]}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"f\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"f\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox[
               SubscriptBox["\<\"\[Mu]\"\>", "3"],
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"+\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        FormBox[
         SubscriptBox["c", "w"],
         TraditionalForm]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["uq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"uq", "2"},
         {"A", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", 
       FormBox["e",
        TraditionalForm], " ", 
       FormBox[
        SubsuperscriptBox["\[Gamma]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"s\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"s\"\>", "2"],
           TraditionalForm]}], 
         FormBox[
          SubscriptBox["\<\"\[Mu]\"\>", "3"],
          TraditionalForm]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"i\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"i\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm], " ", 
       FormBox[
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           SubscriptBox["\<\"f\"\>", "1"],
           TraditionalForm], ",", 
          FormBox[
           SubscriptBox["\<\"f\"\>", "2"],
           TraditionalForm]}]],
        TraditionalForm]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["uq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"uq", "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          FormBox["e",
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["s", "w"],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["\[Delta]", 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"i\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"i\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["\[Delta]", 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"f\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"f\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox[
            RowBox[{
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox[
                SubscriptBox["\<\"\[Mu]\"\>", "3"],
                TraditionalForm]],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm]}], 
            RowBox[{
             FormBox[
              SubscriptBox["\<\"s\"\>", "1"],
              TraditionalForm], ",", 
             FormBox[
              SubscriptBox["\<\"s\"\>", "2"],
              TraditionalForm]}]],
           TraditionalForm]}], 
         RowBox[{"6", " ", 
          FormBox[
           SubscriptBox["c", "w"],
           TraditionalForm]}]]}], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm], " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"f\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"f\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox[
               SubscriptBox["\<\"\[Mu]\"\>", "3"],
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm]}]], "-", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"i\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"i\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"f\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"f\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox[
               SubscriptBox["\<\"\[Mu]\"\>", "3"],
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"+\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"3", " ", 
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm]}]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["vl", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"vl", "2"},
         {"Z", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"f\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"f\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox[
               SubscriptBox["\<\"\[Mu]\"\>", "3"],
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm]}]], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         FormBox[
          SubscriptBox["c", "w"],
          TraditionalForm], " ", 
         FormBox["e",
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox["\[Delta]", 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"f\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"f\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm], " ", 
         FormBox[
          SubscriptBox[
           RowBox[{
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox[
               SubscriptBox["\<\"\[Mu]\"\>", "3"],
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm]}], 
           RowBox[{
            FormBox[
             SubscriptBox["\<\"s\"\>", "1"],
             TraditionalForm], ",", 
            FormBox[
             SubscriptBox["\<\"s\"\>", "2"],
             TraditionalForm]}]],
          TraditionalForm]}], 
        RowBox[{"2", " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm]}]]}]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["vl", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"l", "2"},
         {"W", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox["e",
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"f\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"f\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            SuperscriptBox["\[Gamma]", 
             FormBox[
              SubscriptBox["\<\"\[Mu]\"\>", "3"],
              TraditionalForm]],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], 
       RowBox[{
        SqrtBox["2"], " ", 
        FormBox[
         SubscriptBox["s", "w"],
         TraditionalForm]}]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["uq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"dq", "2"},
         {"W", "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox["e",
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["CKM", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"f\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"f\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"i\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"i\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            SuperscriptBox["\[Gamma]", 
             FormBox[
              SubscriptBox["\<\"\[Mu]\"\>", "3"],
              TraditionalForm]],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], 
       RowBox[{
        SqrtBox["2"], " ", 
        FormBox[
         SubscriptBox["s", "w"],
         TraditionalForm]}]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["l", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"vl", "2"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox["e",
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"f\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"f\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            SuperscriptBox["\[Gamma]", 
             FormBox[
              SubscriptBox["\<\"\[Mu]\"\>", "3"],
              TraditionalForm]],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], 
       RowBox[{
        SqrtBox["2"], " ", 
        FormBox[
         SubscriptBox["s", "w"],
         TraditionalForm]}]]},
     {
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FormBox[
           OverscriptBox["dq", "\<\"-\"\>"],
           TraditionalForm], "1"},
         {"uq", "2"},
         {
          FormBox[
           SuperscriptBox["W", "\[Dagger]"],
           TraditionalForm], "3"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        FormBox["e",
         TraditionalForm], " ", 
        TemplateBox[{FormBox[
           SubscriptBox["CKM", 
            RowBox[{
              FormBox[
               SubscriptBox["\"f\"", "2"], TraditionalForm], ",", 
              FormBox[
               SubscriptBox["\"f\"", "1"], TraditionalForm]}]], 
           TraditionalForm]},
         "Conjugate"], " ", 
        FormBox[
         SubscriptBox["\[Delta]", 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"i\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"i\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm], " ", 
        FormBox[
         SubscriptBox[
          RowBox[{
           FormBox[
            SuperscriptBox["\[Gamma]", 
             FormBox[
              SubscriptBox["\<\"\[Mu]\"\>", "3"],
              TraditionalForm]],
            TraditionalForm], ".", 
           FormBox[
            SubscriptBox["P", "\<\"-\"\>"],
            TraditionalForm]}], 
          RowBox[{
           FormBox[
            SubscriptBox["\<\"s\"\>", "1"],
            TraditionalForm], ",", 
           FormBox[
            SubscriptBox["\<\"s\"\>", "2"],
            TraditionalForm]}]],
         TraditionalForm]}], 
       RowBox[{
        SqrtBox["2"], " ", 
        FormBox[
         SubscriptBox["s", "w"],
         TraditionalForm]}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.5719846783263392`*^9, 3.572196742032469*^9, 3.573066098764782*^9, 
   3.573066864447011*^9, 3.5743119602757783`*^9, 3.574507185256295*^9, 
   3.5745081944181104`*^9, 3.574763460545*^9, 3.574764841684997*^9, 
   3.5750861448613863`*^9, 3.575086250920354*^9, 3.5750863999917836`*^9, 
   3.5750865728462334`*^9, 3.5751812254304996`*^9, 3.5751848443258505`*^9, 
   3.575189233808769*^9, 3.575189503004953*^9, 3.5804597011606474`*^9, 
   3.5806127551598606`*^9, {3.5806128505999804`*^9, 3.580612868505254*^9}, 
   3.580612916288821*^9, 3.5979856133538523`*^9, 3.5979856642158113`*^9, 
   3.5979864183630753`*^9, 3.597987606144905*^9, 3.597988156396278*^9},
 FontSize->7]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sanity checks", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.5747635829149995`*^9, 3.57476358536814*^9}, {3.574763724599104*^9, 
   3.574763728890349*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell["Hermiticity", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}, {
  3.5745083801218367`*^9, 3.5745083815726395`*^9}, {3.574763732028528*^9, 
  3.574763733336603*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "L", "]"}]], "Input",
 CellChangeTimes->{{3.570637941239635*^9, 3.5706379431033716`*^9}, 
   3.580612763565928*^9},
 FontSize->7],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.5804597319285545`*^9, 3.580612764267517*^9, 3.580612890154003*^9, 
  3.597985621674909*^9, 3.597985666687625*^9, 3.5979864184810905`*^9, 
  3.5979876063504305`*^9, 3.5979881565197935`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.5804597319285545`*^9, 3.580612764267517*^9, 3.580612890154003*^9, 
  3.597985621674909*^9, 3.597985666687625*^9, 3.5979864184810905`*^9, 
  3.5979876063504305`*^9, 3.597988156521794*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  StyleBox["\<\"Starting Feynman rule calculation.\"\>",
   StripOnInput->False,
   LineColor->RGBColor[1, 0.5, 0],
   FrontFaceColor->RGBColor[1, 0.5, 0],
   BackFaceColor->RGBColor[1, 0.5, 0],
   GraphicsColor->RGBColor[1, 0.5, 0],
   FontWeight->Bold,
   FontColor->RGBColor[1, 0.5, 0]], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.5804597319285545`*^9, 3.580612764267517*^9, 3.580612890154003*^9, 
  3.597985621674909*^9, 3.597985666687625*^9, 3.5979864184810905`*^9, 
  3.5979876063504305`*^9, 3.5979881650218735`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Expanding the Lagrangian...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.5804597319285545`*^9, 3.580612764267517*^9, 3.580612890154003*^9, 
  3.597985621674909*^9, 3.597985666687625*^9, 3.5979864184810905`*^9, 
  3.5979876063504305`*^9, 3.5979881650248737`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the vertex.\"\>",
   TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.5804597319285545`*^9, 3.580612764267517*^9, 3.580612890154003*^9, 
  3.597985621674909*^9, 3.597985666687625*^9, 3.5979864184810905`*^9, 
  3.5979876063504305`*^9, 3.5979881653824186`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"No vertices found.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.5804597319285545`*^9, 3.580612764267517*^9, 3.580612890154003*^9, 
  3.597985621674909*^9, 3.597985666687625*^9, 3.5979864184810905`*^9, 
  3.5979876063504305`*^9, 3.597988165400421*^9},
 FontSize->7],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
   SequenceForm[0, " vertices obtained."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.5804597319285545`*^9, 3.580612764267517*^9, 3.580612890154003*^9, 
  3.597985621674909*^9, 3.597985666687625*^9, 3.5979864184810905`*^9, 
  3.5979876063504305`*^9, 3.5979881654034214`*^9},
 FontSize->7],

Cell[BoxData[
 FormBox["\<\"The lagrangian is hermitian.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5719847195865784`*^9, 3.572196749486415*^9, 
  3.573066117226626*^9, 3.573066881174635*^9, 3.574311976609007*^9, 
  3.574507243194797*^9, 3.574508199191719*^9, 3.5747634944839416`*^9, 
  3.5747648418500066`*^9, 3.5750865732427835`*^9, 3.575181226308111*^9, 
  3.575184844562381*^9, 3.575189234187318*^9, 3.57518950329749*^9, 
  3.5804597319285545`*^9, 3.580612764267517*^9, 3.580612890154003*^9, 
  3.597985621674909*^9, 3.597985666687625*^9, 3.5979864184810905`*^9, 
  3.5979876063504305`*^9, 3.5979881654064217`*^9},
 FontSize->7]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{"{", "}"}], TraditionalForm]], "Output",
 CellChangeTimes->{3.571984733741376*^9, 3.5721967642922955`*^9, 
  3.5730661334836903`*^9, 3.5730668970701537`*^9, 3.5743119935818367`*^9, 
  3.574507259933626*^9, 3.574508216164549*^9, 3.5747635121739535`*^9, 
  3.574764858812977*^9, 3.575086592161686*^9, 3.575181243760827*^9, 
  3.575184862126611*^9, 3.575189256080598*^9, 3.5751895218418446`*^9, 
  3.580459749959844*^9, 3.5806127733886757`*^9, 3.5806128980245023`*^9, 
  3.597985635328643*^9, 3.5979856757947817`*^9, 3.5979864277652693`*^9, 
  3.5979876156446114`*^9, 3.597988165408922*^9},
 FontSize->7]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Check if the quadratic parts are diagonal\
\>", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}, {
  3.5745083801218367`*^9, 3.5745083815726395`*^9}, {3.574763732028528*^9, 
  3.574763733336603*^9}, {3.5747640154917417`*^9, 3.574764021864106*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"CheckDiagonalQuadraticTerms", "[", "L", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"CheckDiagonalKineticTerms", "[", "L", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"CheckDiagonalMassTerms", "[", "L", "]"}]}], "Input",
 CellChangeTimes->{{3.57476402298317*^9, 3.574764081076493*^9}, {
   3.5747641281091833`*^9, 3.574764128265192*^9}, 3.5747641693945446`*^9, {
   3.5806127821382866`*^9, 3.580612785486212*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Neglecting all terms with more than \"\>", 
    "\[InvisibleSpace]", "\<\"2\"\>", 
    "\[InvisibleSpace]", "\<\" particles.\"\>"}],
   SequenceForm["Neglecting all terms with more than ", "2", " particles."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.5747640598952813`*^9, 3.574764083165612*^9}, 
   3.5747641311033545`*^9, 3.5747641716836753`*^9, 3.5747648707966623`*^9, 
   3.5750866054493732`*^9, 3.5751812497370863`*^9, 3.5751848706191893`*^9, 
   3.5751892626399307`*^9, 3.575189527638081*^9, 3.580612785954771*^9, 
   3.580612926446111*^9, 3.597985641007864*^9, 3.597985682014571*^9, 
   3.59798643028709*^9, 3.597987618273445*^9, 3.597988168022754*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Neglecting all terms with less than \"\>", 
    "\[InvisibleSpace]", "\<\"2\"\>", 
    "\[InvisibleSpace]", "\<\" particles.\"\>"}],
   SequenceForm["Neglecting all terms with less than ", "2", " particles."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.5747640598952813`*^9, 3.574764083165612*^9}, 
   3.5747641311033545`*^9, 3.5747641716836753`*^9, 3.5747648707966623`*^9, 
   3.5750866054493732`*^9, 3.5751812497370863`*^9, 3.5751848706191893`*^9, 
   3.5751892626399307`*^9, 3.575189527638081*^9, 3.580612785954771*^9, 
   3.580612926446111*^9, 3.597985641007864*^9, 3.597985682014571*^9, 
   3.59798643028709*^9, 3.597987618273445*^9, 3.597988168169273*^9}],

Cell[BoxData[
 FormBox["\<\"All quadratic terms are diagonal.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{{3.5747640598952813`*^9, 3.574764083165612*^9}, 
   3.5747641311033545`*^9, 3.5747641716836753`*^9, 3.5747648707966623`*^9, 
   3.5750866054493732`*^9, 3.5751812497370863`*^9, 3.5751848706191893`*^9, 
   3.5751892626399307`*^9, 3.575189527638081*^9, 3.580612785954771*^9, 
   3.580612926446111*^9, 3.597985641007864*^9, 3.597985682014571*^9, 
   3.59798643028709*^9, 3.597987618273445*^9, 3.597988168218779*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox["True", TraditionalForm]], "Output",
 CellChangeTimes->{{3.574764059942284*^9, 3.574764083212615*^9}, 
   3.574764131147357*^9, 3.5747641717246776`*^9, 3.5747648708396645`*^9, 
   3.575086605480377*^9, 3.575181249837099*^9, 3.575184870733204*^9, 
   3.575189262769447*^9, 3.575189527747095*^9, 3.5806127860077777`*^9, 
   3.580612926837661*^9, 3.597985641425917*^9, 3.5979856820170717`*^9, 
   3.5979864307731514`*^9, 3.5979876185099745`*^9, 3.5979881682237797`*^9}],

Cell[BoxData[
 FormBox["\<\"All kinetic terms are diagonal.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{{3.5747640598952813`*^9, 3.574764083165612*^9}, 
   3.5747641311033545`*^9, 3.5747641716836753`*^9, 3.5747648707966623`*^9, 
   3.5750866054493732`*^9, 3.5751812497370863`*^9, 3.5751848706191893`*^9, 
   3.5751892626399307`*^9, 3.575189527638081*^9, 3.580612785954771*^9, 
   3.580612926446111*^9, 3.597985641007864*^9, 3.597985682014571*^9, 
   3.59798643028709*^9, 3.597987618273445*^9, 3.5979881707956066`*^9}],

Cell[BoxData[
 FormBox["True", TraditionalForm]], "Output",
 CellChangeTimes->{{3.574764059942284*^9, 3.574764083212615*^9}, 
   3.574764131147357*^9, 3.5747641717246776`*^9, 3.5747648708396645`*^9, 
   3.575086605480377*^9, 3.575181249837099*^9, 3.575184870733204*^9, 
   3.575189262769447*^9, 3.575189527747095*^9, 3.5806127860077777`*^9, 
   3.580612926837661*^9, 3.597985641425917*^9, 3.5979856820170717`*^9, 
   3.5979864307731514`*^9, 3.5979876185099745`*^9, 3.5979881707976065`*^9}],

Cell[BoxData[
 FormBox["\<\"All mass terms are diagonal.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.5747640598952813`*^9, 3.574764083165612*^9}, 
   3.5747641311033545`*^9, 3.5747641716836753`*^9, 3.5747648707966623`*^9, 
   3.5750866054493732`*^9, 3.5751812497370863`*^9, 3.5751848706191893`*^9, 
   3.5751892626399307`*^9, 3.575189527638081*^9, 3.580612785954771*^9, 
   3.580612926446111*^9, 3.597985641007864*^9, 3.597985682014571*^9, 
   3.59798643028709*^9, 3.597987618273445*^9, 3.5979881733864355`*^9}],

Cell[BoxData[
 FormBox["True", TraditionalForm]], "Output",
 CellChangeTimes->{{3.574764059942284*^9, 3.574764083212615*^9}, 
   3.574764131147357*^9, 3.5747641717246776`*^9, 3.5747648708396645`*^9, 
   3.575086605480377*^9, 3.575181249837099*^9, 3.575184870733204*^9, 
   3.575189262769447*^9, 3.575189527747095*^9, 3.5806127860077777`*^9, 
   3.580612926837661*^9, 3.597985641425917*^9, 3.5979856820170717`*^9, 
   3.5979864307731514`*^9, 3.5979876185099745`*^9, 3.5979881733889356`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Check normalisation & mass spectrum\
\>", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}, {
  3.5745083801218367`*^9, 3.5745083815726395`*^9}, {3.574763732028528*^9, 
  3.574763733336603*^9}, {3.5747640154917417`*^9, 3.574764021864106*^9}, {
  3.574764161644101*^9, 3.5747641663523703`*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"CheckKineticTermNormalisation", "[", "L", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"CheckMassSpectrum", "[", "L", "]"}]}], "Input",
 CellChangeTimes->{{3.5747641591359577`*^9, 3.574764186922547*^9}, {
  3.5806127915934873`*^9, 3.5806127930441713`*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Neglecting all terms with more than \"\>", 
    "\[InvisibleSpace]", "\<\"2\"\>", 
    "\[InvisibleSpace]", "\<\" particles.\"\>"}],
   SequenceForm["Neglecting all terms with more than ", "2", " particles."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.58061279351023*^9, 
  3.5806129306076393`*^9, 3.5979856912052383`*^9, 3.597986438135086*^9, 
  3.59798762681903*^9, 3.597988175852248*^9}],

Cell[BoxData[
 FormBox["\<\"All kinetic terms are diagonal.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.58061279351023*^9, 
  3.5806129306076393`*^9, 3.5979856912052383`*^9, 3.597986438135086*^9, 
  3.59798762681903*^9, 3.597988176030271*^9}],

Cell[BoxData[
 FormBox["\<\"All kinetic terms are correctly normalized.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.58061279351023*^9, 
  3.5806129306076393`*^9, 3.5979856912052383`*^9, 3.597986438135086*^9, 
  3.59798762681903*^9, 3.5979881786035976`*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox["True", TraditionalForm]], "Output",
 CellChangeTimes->{3.5747641905887566`*^9, 3.5747648783860965`*^9, 
  3.575086613315872*^9, 3.5751812506111975`*^9, 3.5751848715123034`*^9, 
  3.575189263681563*^9, 3.575189528881239*^9, 3.5806127935822396`*^9, 
  3.580612932727909*^9, 3.5979856939925923`*^9, 3.5979864411939745`*^9, 
  3.597987629780906*^9, 3.597988178607098*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Neglecting all terms with more than \"\>", 
    "\[InvisibleSpace]", "\<\"2\"\>", 
    "\[InvisibleSpace]", "\<\" particles.\"\>"}],
   SequenceForm["Neglecting all terms with more than ", "2", " particles."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.58061279351023*^9, 
  3.5806129306076393`*^9, 3.5979856912052383`*^9, 3.597986438135086*^9, 
  3.59798762681903*^9, 3.5979881812629356`*^9}],

Cell[BoxData[
 FormBox["\<\"All mass terms are diagonal.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.58061279351023*^9, 
  3.5806129306076393`*^9, 3.5979856912052383`*^9, 3.597986438135086*^9, 
  3.59798762681903*^9, 3.5979881812909393`*^9}],

Cell[BoxData[
 FormBox["\<\"Getting mass spectrum.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.58061279351023*^9, 
  3.5806129306076393`*^9, 3.5979856912052383`*^9, 3.597986438135086*^9, 
  3.59798762681903*^9, 3.5979881838687663`*^9}],

Cell[BoxData[
 FormBox["\<\"Checking for less then 0.1% agreement with model file values.\"\
\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5747641888936596`*^9, 3.5747648765139894`*^9, 
  3.575086611198103*^9, 3.575181250364666*^9, 3.5751848712357683`*^9, 
  3.575189263378024*^9, 3.5751895282581596`*^9, 3.58061279351023*^9, 
  3.5806129306076393`*^9, 3.5979856912052383`*^9, 3.597986438135086*^9, 
  3.59798762681903*^9, 3.597988183871767*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  InterpretationBox[GridBox[{
     {"\<\"Particle\"\>", "\<\"Analytic value\"\>", "\<\"Numerical \
value\"\>", "\<\"Model-file value\"\>", "\<\"\"\>"},
     {"H", 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        RowBox[{
         FractionBox[
          RowBox[{"3", " ", "\[Lambda]", " ", 
           SuperscriptBox["v", "2"]}], "2"], "-", 
         FractionBox[
          SuperscriptBox[
           FormBox["\[Mu]",
            TraditionalForm], "2"], "2"]}]]}], "120.00000000000003`", 
      "120.`", "\<\"\"\>"},
     {"W", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox[
           FormBox["e",
            TraditionalForm], "2"], " ", 
          SuperscriptBox["v", "2"]}], 
         SuperscriptBox[
          FormBox[
           SubscriptBox["s", "w"],
           TraditionalForm], "2"]]]}], "79.82435974619786`", 
      "79.82435974619784`", "\<\"\"\>"},
     {"d", 
      FractionBox[
       RowBox[{"v", " ", 
        FormBox[
         SubscriptBox[
          TemplateBox[{"y","d"},
           "Superscript"], 
          FormBox["1",
           TraditionalForm]],
         TraditionalForm]}], 
       SqrtBox["2"]], "0.005040000000000001`", "0.00504`", "\<\"\"\>"},
     {"s", 
      FractionBox[
       RowBox[{"v", " ", 
        FormBox[
         SubscriptBox[
          TemplateBox[{"y","d"},
           "Superscript"], 
          FormBox["2",
           TraditionalForm]],
         TraditionalForm]}], 
       SqrtBox["2"]], "0.10100000000000002`", "0.101`", "\<\"\"\>"},
     {"b", 
      FractionBox[
       RowBox[{"v", " ", 
        FormBox[
         SubscriptBox[
          TemplateBox[{"y","d"},
           "Superscript"], 
          FormBox["3",
           TraditionalForm]],
         TraditionalForm]}], 
       SqrtBox["2"]], "4.700000000000001`", "4.7`", "\<\"\"\>"},
     {"e", 
      FractionBox[
       RowBox[{"v", " ", 
        FormBox[
         SubscriptBox[
          TemplateBox[{"y","l"},
           "Superscript"], 
          FormBox["1",
           TraditionalForm]],
         TraditionalForm]}], 
       SqrtBox["2"]], "0.0005110000000000001`", 
      "0.0005110000000000001`", "\<\"\"\>"},
     {"m", 
      FractionBox[
       RowBox[{"v", " ", 
        FormBox[
         SubscriptBox[
          TemplateBox[{"y","l"},
           "Superscript"], 
          FormBox["2",
           TraditionalForm]],
         TraditionalForm]}], 
       SqrtBox["2"]], "0.10566000000000002`", "0.10566`", "\<\"\"\>"},
     {"tt", 
      FractionBox[
       RowBox[{"v", " ", 
        FormBox[
         SubscriptBox[
          TemplateBox[{"y","l"},
           "Superscript"], 
          FormBox["3",
           TraditionalForm]],
         TraditionalForm]}], 
       SqrtBox["2"]], "1.7770000000000004`", "1.777`", "\<\"\"\>"},
     {"u", 
      FractionBox[
       RowBox[{"v", " ", 
        FormBox[
         SubscriptBox[
          TemplateBox[{"y","u"},
           "Superscript"], 
          FormBox["1",
           TraditionalForm]],
         TraditionalForm]}], 
       SqrtBox["2"]], "0.0025499999999999997`", 
      "0.0025499999999999997`", "\<\"\"\>"},
     {"c", 
      FractionBox[
       RowBox[{"v", " ", 
        FormBox[
         SubscriptBox[
          TemplateBox[{"y","u"},
           "Superscript"], 
          FormBox["2",
           TraditionalForm]],
         TraditionalForm]}], 
       SqrtBox["2"]], "1.2700000000000002`", "1.42`", 
      TagBox[
       StyleBox["\<\"Discrepency!\"\>",
        FontColor->RGBColor[1, 0, 0]],
       StyleForm[#, FontColor -> RGBColor[1, 0, 0]]& ]},
     {"t", 
      FractionBox[
       RowBox[{"v", " ", 
        FormBox[
         SubscriptBox[
          TemplateBox[{"y","u"},
           "Superscript"], 
          FormBox["3",
           TraditionalForm]],
         TraditionalForm]}], 
       SqrtBox["2"]], "172.00000000000003`", "172.`", "\<\"\"\>"},
     {"Z", 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox[
            FormBox["e",
             TraditionalForm], "2"], " ", 
           SuperscriptBox["v", "2"], " ", 
           SuperscriptBox[
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm], "2"]}], 
          RowBox[{"8", " ", 
           SuperscriptBox[
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm], "2"]}]], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox[
            FormBox["e",
             TraditionalForm], "2"], " ", 
           SuperscriptBox["v", "2"], " ", 
           SuperscriptBox[
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm], "2"]}], 
          RowBox[{"8", " ", 
           SuperscriptBox[
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm], "2"]}]], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox[
            FormBox["e",
             TraditionalForm], "2"], " ", 
           SuperscriptBox["v", "2"]}], "4"]}]]}], "91.18760000000003`", 
      "91.1876`", "\<\"\"\>"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   TableForm[{{
     "Particle", "Analytic value", "Numerical value", "Model-file value"}, {
     FeynRules`H, 
      2^Rational[1, 2] (Rational[-1, 2] $CellContext`muH^2 + 
        Rational[3, 2] FeynRules`v^2 $CellContext`\[Lambda])^Rational[1, 2], 
      120.00000000000003`, 120.}, {
     FeynRules`W, 
      Rational[1, 2] (FeynRules`ee^2 $CellContext`sw^(-2) FeynRules`v^2)^
       Rational[1, 2], 79.82435974619786, 79.82435974619784}, {
     FeynRules`d, 2^Rational[-1, 2] FeynRules`v $CellContext`yd[
        FeynRules`Index[$CellContext`Generation, 1]], 0.005040000000000001, 
      0.00504}, {FeynRules`s, 2^Rational[-1, 2] FeynRules`v $CellContext`yd[
        FeynRules`Index[$CellContext`Generation, 2]], 0.10100000000000002`, 
      0.101}, {FeynRules`b, 2^Rational[-1, 2] FeynRules`v $CellContext`yd[
        FeynRules`Index[$CellContext`Generation, 3]], 4.700000000000001, 
      4.7}, {FeynRules`e, 2^Rational[-1, 2] FeynRules`v $CellContext`yl[
        FeynRules`Index[$CellContext`Generation, 1]], 0.0005110000000000001, 
      0.0005110000000000001}, {
     FeynRules`m, 2^Rational[-1, 2] FeynRules`v $CellContext`yl[
        FeynRules`Index[$CellContext`Generation, 2]], 0.10566000000000002`, 
      0.10566}, {$CellContext`tt, 2^Rational[-1, 2] 
      FeynRules`v $CellContext`yl[
        FeynRules`Index[$CellContext`Generation, 3]], 1.7770000000000004`, 
      1.777}, {FeynRules`u, 2^Rational[-1, 2] FeynRules`v $CellContext`yu[
        FeynRules`Index[$CellContext`Generation, 1]], 0.0025499999999999997`, 
      0.0025499999999999997`}, {
     FeynRules`c, 2^Rational[-1, 2] FeynRules`v $CellContext`yu[
        FeynRules`Index[$CellContext`Generation, 2]], 1.2700000000000002`, 
      1.42, 
      StyleForm["Discrepency!", FontColor -> RGBColor[1, 0, 0]]}, {
     FeynRules`t, 2^Rational[-1, 2] FeynRules`v $CellContext`yu[
        FeynRules`Index[$CellContext`Generation, 3]], 172.00000000000003`, 
      172.}, {$CellContext`Z, 
      2^Rational[1, 2] (Rational[1, 4] FeynRules`ee^2 FeynRules`v^2 + 
        Rational[1, 8] $CellContext`cw^2 FeynRules`ee^2 $CellContext`sw^(-2) 
         FeynRules`v^2 + 
        Rational[1, 8] $CellContext`cw^(-2) FeynRules`ee^2 $CellContext`sw^2 
         FeynRules`v^2)^Rational[1, 2], 91.18760000000003, 91.1876}}]], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.5747641905887566`*^9, 3.5747648783860965`*^9, 
  3.575086613315872*^9, 3.5751812506111975`*^9, 3.5751848715123034`*^9, 
  3.575189263681563*^9, 3.575189528881239*^9, 3.5806127935822396`*^9, 
  3.580612932727909*^9, 3.5979856939925923`*^9, 3.5979864411939745`*^9, 
  3.597987629780906*^9, 3.597988183921773*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MadGraph output (UFO model)", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}, {
  3.5745083801218367`*^9, 3.5745083815726395`*^9}, {3.574763732028528*^9, 
  3.574763733336603*^9}, {3.5747640154917417`*^9, 3.574764021864106*^9}, {
  3.574764161644101*^9, 3.5747641663523703`*^9}, {3.5979857100216274`*^9, 
  3.5979857176816006`*^9}},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteUFO", "[", "L", "]"}]], "Input",
 CellChangeTimes->{
  3.597985719008269*^9, {3.5979863634291*^9, 3.5979863662179537`*^9}, 
   3.5979875366535807`*^9},
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.5979881840002832`*^9},
 FontSize->9],

Cell[BoxData[
 FormBox[
  StyleBox["\<\"Starting Feynman rule calculation.\"\>",
   StripOnInput->False,
   LineColor->RGBColor[1, 0.5, 0],
   FrontFaceColor->RGBColor[1, 0.5, 0],
   BackFaceColor->RGBColor[1, 0.5, 0],
   GraphicsColor->RGBColor[1, 0.5, 0],
   FontWeight->Bold,
   FontColor->RGBColor[1, 0.5, 0]], TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.5979881842193108`*^9},
 FontSize->9],

Cell[BoxData[
 FormBox["\<\"Expanding the Lagrangian...\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.597988184234313*^9},
 FontSize->9],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Expanding indices over \"\>", "\[InvisibleSpace]", "2", 
    "\[InvisibleSpace]", "\<\" cores\"\>"}],
   SequenceForm["Expanding indices over ", 2, " cores"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.597988184235813*^9},
 FontSize->9],

Cell[BoxData[
 FormBox["\<\"Collecting the different structures that enter the vertex.\"\>",
   TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.597988185856019*^9},
 FontSize->9],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
   "36", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
    DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, TraditionalForm],
     ImageSizeCache->{14., {0., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
    "\[InvisibleSpace]", "36", "\[InvisibleSpace]", "\<\".\"\>"}],
   SequenceForm[
   36, " possible non-zero vertices have been found -> starting the \
computation: ", 
    Dynamic[FeynRules`FR$FeynmanRules], " / ", 36, "."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.597988185889023*^9},
 FontSize->9],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"35", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
   SequenceForm[35, " vertices obtained."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.5979881878602734`*^9},
 FontSize->9],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
    
    DynamicBox[ToBoxes[FeynRules`FR$Count1, TraditionalForm],
     ImageSizeCache->{14., {0., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
    "\[InvisibleSpace]", "35"}],
   SequenceForm["Flavor expansion of the vertices: ", 
    Dynamic[FeynRules`FR$Count1], " / ", 35],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.5979881883698378`*^9},
 FontSize->9],

Cell[BoxData[
 FormBox["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.5979881904486017`*^9},
 FontSize->9],

Cell[BoxData[
 FormBox[
  StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
   StripOnInput->False,
   LineColor->RGBColor[1, 0.5, 0],
   FrontFaceColor->RGBColor[1, 0.5, 0],
   BackFaceColor->RGBColor[1, 0.5, 0],
   GraphicsColor->RGBColor[1, 0.5, 0],
   FontWeight->Bold,
   FontColor->RGBColor[1, 0.5, 0]], TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.5979881904701047`*^9},
 FontSize->9],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    DynamicBox[ToBoxes[PRIVATE`mycounter, TraditionalForm],
     ImageSizeCache->{14., {0., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
    "\[InvisibleSpace]", "52"}],
   SequenceForm[
    Dynamic[PRIVATE`mycounter], " / ", 52],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.5979881904796057`*^9},
 FontSize->9],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
    "0.4840000000001003`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
   SequenceForm[
   "Squared matrix elent compute in ", 0.4840000000001003, " seconds."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.597988192890912*^9},
 FontSize->9],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    DynamicBox[ToBoxes[PRIVATE`mycounter, TraditionalForm],
     ImageSizeCache->{14., {0., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
    "\[InvisibleSpace]", "65"}],
   SequenceForm[
    Dynamic[PRIVATE`mycounter], " / ", 65],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.597988192897913*^9},
 FontSize->9],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
    "0.14000000000001467`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
   SequenceForm[
   "Decay widths computed in ", 0.14000000000001467`, " seconds."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.597988193404477*^9},
 FontSize->9],

Cell[BoxData[
 FormBox["\<\"Preparing Python output.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.5979881934124784`*^9},
 FontSize->9],

Cell[BoxData[
 FormBox["\<\"    - Splitting vertices into building blocks.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.597988193527993*^9},
 FontSize->9],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
    "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
   SequenceForm["Splitting of vertices distributed over ", 2, " kernels."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.5979881935484953`*^9},
 FontSize->9],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
    DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, TraditionalForm],
     ImageSizeCache->{14., {0., 10.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
    "\[InvisibleSpace]", "79", "\[InvisibleSpace]", "\<\" .\"\>"}],
   SequenceForm["    - Optimizing: ", 
    Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 79, " ."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.597988193990552*^9},
 FontSize->9],

Cell[BoxData[
 FormBox["\<\"    - Writing files.\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.597988194091564*^9},
 FontSize->9],

Cell[BoxData[
 FormBox["\<\"Done!\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.597985726436212*^9, 3.5979864462236137`*^9, 
  3.59798763571916*^9, 3.597988194309092*^9},
 FontSize->9]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{667, 690},
WindowMargins->{{Automatic, 0}, {0, Automatic}},
ShowSelection->True,
Magnification->1.5,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 192, 4, 86, "Section"],
Cell[CellGroupData[{
Cell[784, 30, 215, 4, 46, "Subsection"],
Cell[CellGroupData[{
Cell[1024, 38, 2650, 45, 145, "Input"],
Cell[3677, 85, 1608, 24, 36, "Output"],
Cell[CellGroupData[{
Cell[5310, 113, 1344, 20, 26, "Print"],
Cell[6657, 135, 1628, 27, 26, "Print"],
Cell[8288, 164, 1396, 21, 26, "Print"],
Cell[9687, 187, 1330, 20, 26, "Print"],
Cell[11020, 209, 1341, 20, 26, "Print"],
Cell[12364, 231, 1351, 20, 26, "Print"],
Cell[13718, 253, 1391, 21, 26, "Print"],
Cell[15112, 276, 1330, 20, 26, "Print"],
Cell[16445, 298, 1360, 21, 26, "Print"],
Cell[17808, 321, 1328, 20, 26, "Print"],
Cell[19139, 343, 1397, 21, 26, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20597, 371, 374, 6, 46, "Subsection"],
Cell[CellGroupData[{
Cell[20996, 381, 2410, 52, 359, "Input"],
Cell[CellGroupData[{
Cell[23431, 437, 149, 3, 32, "Print"],
Cell[23583, 442, 119, 2, 32, "Print"],
Cell[23705, 446, 121, 2, 32, "Print"],
Cell[23829, 450, 117, 2, 32, "Print"],
Cell[23949, 454, 114, 2, 32, "Print"],
Cell[24066, 458, 256, 6, 32, "Print"],
Cell[24325, 466, 155, 3, 32, "Print"],
Cell[24483, 471, 106, 2, 32, "Print"],
Cell[24592, 475, 136, 3, 32, "Print"],
Cell[24731, 480, 142, 3, 32, "Print"],
Cell[24876, 485, 139, 3, 32, "Print"],
Cell[25018, 490, 303, 7, 58, "Print"],
Cell[25324, 499, 254, 6, 32, "Print"],
Cell[25581, 507, 254, 6, 32, "Print"],
Cell[25838, 515, 256, 6, 32, "Print"],
Cell[26097, 523, 113, 2, 32, "Print"],
Cell[26213, 527, 120, 2, 32, "Print"],
Cell[26336, 531, 124, 2, 32, "Print"],
Cell[26463, 535, 118, 2, 32, "Print"],
Cell[26584, 539, 119, 2, 32, "Print"],
Cell[26706, 543, 120, 2, 32, "Print"],
Cell[26829, 547, 150, 3, 32, "Print"],
Cell[26982, 552, 143, 3, 32, "Print"],
Cell[27128, 557, 170, 3, 32, "Print"],
Cell[27301, 562, 112, 2, 32, "Print"],
Cell[27416, 566, 143, 3, 32, "Print"],
Cell[27562, 571, 139, 3, 32, "Print"],
Cell[27704, 576, 131, 2, 32, "Print"],
Cell[27838, 580, 130, 2, 32, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28041, 590, 146, 3, 86, "Section"],
Cell[CellGroupData[{
Cell[28212, 597, 218, 4, 46, "Subsection"],
Cell[28433, 603, 253, 4, 37, "Text"],
Cell[28689, 609, 502, 9, 38, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29228, 623, 267, 6, 46, "Subsection"],
Cell[CellGroupData[{
Cell[29520, 633, 200, 5, 36, "Input"],
Cell[CellGroupData[{
Cell[29745, 642, 1031, 20, 25, "Print"],
Cell[30779, 664, 776, 12, 26, "Print"],
Cell[31558, 678, 955, 17, 26, "Print"],
Cell[32516, 697, 812, 13, 26, "Print"],
Cell[33331, 712, 1307, 24, 26, "Print"],
Cell[34641, 738, 899, 16, 26, "Print"]
}, Open  ]],
Cell[35555, 757, 98019, 3136, 1828, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[133635, 3900, 238, 5, 86, "Section"],
Cell[CellGroupData[{
Cell[133898, 3909, 215, 4, 46, "Subsection"],
Cell[CellGroupData[{
Cell[134138, 3917, 177, 4, 36, "Input"],
Cell[CellGroupData[{
Cell[134340, 3925, 697, 11, 26, "Print"],
Cell[135040, 3938, 691, 11, 26, "Print"],
Cell[135734, 3951, 896, 18, 25, "Print"],
Cell[136633, 3971, 643, 10, 26, "Print"],
Cell[137279, 3983, 677, 11, 26, "Print"],
Cell[137959, 3996, 632, 10, 26, "Print"],
Cell[138594, 4008, 760, 14, 26, "Print"],
Cell[139357, 4024, 644, 10, 26, "Print"]
}, Open  ]],
Cell[140016, 4037, 635, 11, 36, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[140700, 4054, 301, 6, 46, "Subsection"],
Cell[CellGroupData[{
Cell[141026, 4064, 450, 9, 79, "Input"],
Cell[CellGroupData[{
Cell[141501, 4077, 750, 13, 32, "Print"],
Cell[142254, 4092, 750, 13, 32, "Print"],
Cell[143007, 4107, 529, 8, 32, "Print"]
}, Open  ]],
Cell[143551, 4118, 489, 7, 42, "Output"],
Cell[144043, 4127, 528, 8, 32, "Print"],
Cell[144574, 4137, 489, 7, 42, "Output"],
Cell[145066, 4146, 523, 7, 32, "Print"],
Cell[145592, 4155, 489, 7, 42, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[146130, 4168, 346, 7, 46, "Subsection"],
Cell[CellGroupData[{
Cell[146501, 4179, 293, 6, 59, "Input"],
Cell[CellGroupData[{
Cell[146819, 4189, 647, 12, 32, "Print"],
Cell[147469, 4203, 423, 7, 32, "Print"],
Cell[147895, 4212, 438, 7, 32, "Print"]
}, Open  ]],
Cell[148348, 4222, 391, 6, 42, "Output"],
Cell[CellGroupData[{
Cell[148764, 4232, 649, 12, 32, "Print"],
Cell[149416, 4246, 420, 6, 32, "Print"],
Cell[149839, 4254, 414, 6, 32, "Print"],
Cell[150256, 4262, 453, 7, 32, "Print"]
}, Open  ]],
Cell[150724, 4272, 8286, 234, 666, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[159059, 4512, 383, 6, 46, "Subsection"],
Cell[CellGroupData[{
Cell[159467, 4522, 194, 5, 38, "Input"],
Cell[CellGroupData[{
Cell[159686, 4531, 240, 5, 28, "Print"],
Cell[159929, 4538, 470, 12, 29, "Print"],
Cell[160402, 4552, 215, 4, 28, "Print"],
Cell[160620, 4558, 394, 9, 28, "Print"],
Cell[161017, 4569, 249, 5, 28, "Print"],
Cell[161269, 4576, 743, 16, 28, "Print"],
Cell[162015, 4594, 336, 8, 28, "Print"],
Cell[162354, 4604, 578, 13, 28, "Print"],
Cell[162935, 4619, 234, 5, 28, "Print"],
Cell[163172, 4626, 506, 13, 29, "Print"],
Cell[163681, 4641, 464, 12, 28, "Print"],
Cell[164148, 4655, 457, 10, 28, "Print"],
Cell[164608, 4667, 462, 12, 28, "Print"],
Cell[165073, 4681, 446, 10, 28, "Print"],
Cell[165522, 4693, 214, 4, 28, "Print"],
Cell[165739, 4699, 237, 5, 28, "Print"],
Cell[165979, 4706, 434, 9, 28, "Print"],
Cell[166416, 4717, 596, 12, 28, "Print"],
Cell[167015, 4731, 208, 4, 28, "Print"],
Cell[167226, 4737, 193, 4, 28, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
