(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      4764,        143]
NotebookOptionsPosition[      3928,        110]
NotebookOutlinePosition[      4306,        127]
CellTagsIndexPosition[      4263,        124]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"$FeynRulesPath", " ", "=", " ", 
   RowBox[{"SetDirectory", "[", "\"\<< address of the package>\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.413720861194676*^9, 3.4137208893794117`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.402202361365851*^9, 3.402202371944139*^9}, {
   3.402202561319804*^9, 3.402202569273497*^9}, 3.402745522459828*^9, 
   3.402746608214861*^9, {3.402747929860508*^9, 3.402747943827011*^9}, {
   3.403533007403466*^9, 3.403533008807395*^9}, {3.404106695164184*^9, 
   3.404106695449581*^9}, {3.405053642054455*^9, 3.4050536456262903`*^9}, 
   3.4119181919913683`*^9, {3.4137208986527243`*^9, 3.4137208996123943`*^9}, {
   3.4137242759980097`*^9, 3.413724294268169*^9}, 3.508569204008209*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</../models/SMscalars\>\""}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.508569210987895*^9, 3.508569240366075*^9}}],

Cell[CellGroupData[{

Cell["The Standard Model + Scalars", "Title",
 CellChangeTimes->{{3.411915778286763*^9, 3.4119157817267313`*^9}, {
  3.413720856398858*^9, 3.413720856723679*^9}}],

Cell[BoxData[
 RowBox[{"LoadModel", "[", 
  RowBox[{
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM/SM.fr\>\""}], ",", 
   "\"\<SMScalars.fr\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.4022069973481913`*^9, 3.402207011768662*^9}, 
   3.4022081212072697`*^9, {3.402208250379383*^9, 3.402208254043104*^9}, 
   3.4027466057480917`*^9, {3.403240270135737*^9, 3.403240277228945*^9}, 
   3.403266503388291*^9, {3.403267649630335*^9, 3.40326765417397*^9}, {
   3.403269919787421*^9, 3.403269921965273*^9}, {3.403347551273425*^9, 
   3.403347555049163*^9}, 3.403533015351287*^9, {3.40505363437746*^9, 
   3.40505363645761*^9}, {3.411912382149088*^9, 3.4119123969228477`*^9}, {
   3.50856924516405*^9, 3.5085692957646017`*^9}}],

Cell[CellGroupData[{

Cell["The lagrangian", "Section",
 CellChangeTimes->{{3.411915790793332*^9, 3.411915793199389*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "False"}], ";"}]], "Input",
 CellChangeTimes->{{3.411915017675109*^9, 3.411915022272778*^9}, 
   3.411915800951993*^9, {3.5085697915596943`*^9, 3.508569793189657*^9}}],

Cell["\<\
The lagrangian for the SM is the same as in SM.fr.

The new sector is\
\>", "Text",
 CellChangeTimes->{{3.411915802313404*^9, 3.411915827110655*^9}}],

Cell[BoxData["LScalar"], "Input",
 CellChangeTimes->{{3.4119143176932583`*^9, 3.411914319401045*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Feynman rules for the new sector", "Section",
 CellChangeTimes->{{3.411915866249317*^9, 3.4119158716988153`*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LScalar", "]"}]], "Input",
 CellChangeTimes->{{3.411915883502528*^9, 3.411915928653887*^9}, {
   3.4137211614912577`*^9, 3.4137211708030777`*^9}, 3.508569350492257*^9}],

Cell["Or in a flavor expanded form", "Text",
 CellChangeTimes->{{3.411915937803143*^9, 3.4119159434558887`*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LScalar", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.411915883502528*^9, 3.411915958983838*^9}, {
  3.508569657623721*^9, 3.508569668869379*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1272, 681},
WindowMargins->{{0, Automatic}, {Automatic, 25}},
ShowSelection->True,
Magnification->1.5,
FrontEndVersion->"7.0 for Linux x86 (64-bit) (November 11, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 233, 5, 46, "Input"],
Cell[781, 27, 626, 10, 107, "Input"],
Cell[1410, 39, 217, 5, 46, "Input"],
Cell[CellGroupData[{
Cell[1652, 48, 162, 2, 126, "Title"],
Cell[1817, 52, 725, 12, 46, "Input"],
Cell[CellGroupData[{
Cell[2567, 68, 99, 1, 108, "Section"],
Cell[2669, 71, 222, 4, 46, "Input"],
Cell[2894, 77, 159, 5, 99, "Text"],
Cell[3056, 84, 101, 1, 46, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3194, 90, 119, 1, 108, "Section"],
Cell[3316, 93, 213, 3, 46, "Input"],
Cell[3532, 98, 112, 1, 44, "Text"],
Cell[3647, 101, 253, 5, 46, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
