(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    294732,       7244]
NotebookOptionsPosition[    282370,       6860]
NotebookOutlinePosition[    282779,       6876]
CellTagsIndexPosition[    282736,       6873]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["FeynRules: Resonance + MET", "Title",
 CellChangeTimes->{{3.569143846510152*^9, 3.5691438492382927`*^9}, {
  3.589193147948735*^9, 3.5891931487714453`*^9}, {3.647152530595695*^9, 
  3.647152530928742*^9}, {3.6478500953071623`*^9, 3.647850095462895*^9}, {
  3.654588730255045*^9, 3.654588745664485*^9}}],

Cell[TextData[StyleBox["Open Issues:\n * Replace Eps(*) with 1 to fix the \
CalcHEP output of the triplet.\n * CalcHEP output of the sextet is broken.\n \
* Correct hyperlinks in the model files: Hyperlink[string] does not work with \
CalcHEP output.",
 FontWeight->"Bold"]], "Text",
 CellChangeTimes->{{3.664890428069512*^9, 3.664890464302844*^9}, 
   3.665141616047606*^9, {3.666010758856793*^9, 3.666010770171732*^9}, {
   3.666010990518064*^9, 3.6660110120402737`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.551418340255722*^9, 3.551418341644471*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "These", " ", "variables", " ", "define", " ", "some", " ", "locations", 
    " ", "to", " ", "be", " ", "used", " ", "throughout", " ", "the", " ", 
    "notebook"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Set", " ", "this", " ", "to", " ", "your", " ", "FeynRules", " ", 
    "installation"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
    "locFR", "=", 
     "\"\</home/maikel/.Mathematica/Applications/FeynRules-2.3.18\>\""}], 
    ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Set", " ", "this", " ", "to", " ", "the", " ", "location", " ", "of", 
     " ", "your", " ", "model", " ", "files"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"FR", " ", "files", " ", "will", " ", "be", " ", "read", " ", 
      RowBox[{"from", " ", "/", "fr_files"}]}], ",", " ", 
     RowBox[{"UFO", " ", "be", " ", "written", " ", 
      RowBox[{"to", " ", "/", "ufo_models"}], " ", "and", " ", "CalcHEP", " ", 
      RowBox[{"to", " ", "/", "calchep_models"}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"locMF", "=", 
     RowBox[{"NotebookDirectory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{
    "Set", " ", "this", " ", "to", " ", "the", " ", "model", " ", "file"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"locModelFile", ":=", "\"\<so_met.fr\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"AutoUFOModel", ":=", "False"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"AutoCalcHEPModel", ":=", "False"}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.569406540763906*^9, 3.569406559776763*^9}, {
   3.569406857994039*^9, 3.569406869986185*^9}, {3.569419347340068*^9, 
   3.569419369454303*^9}, {3.569565056264391*^9, 3.569565056867136*^9}, {
   3.570187792484337*^9, 3.570187794075346*^9}, {3.6545888372809343`*^9, 
   3.654588846797003*^9}, 3.654588922302568*^9, {3.654589393899436*^9, 
   3.654589407662459*^9}, {3.654589447191774*^9, 3.654589469636098*^9}, {
   3.654591120927465*^9, 3.6545911211426687`*^9}, {3.655027452709317*^9, 
   3.655027454776533*^9}, {3.6550284621851*^9, 3.6550284792255583`*^9}, {
   3.6550292276540613`*^9, 3.655029252987687*^9}, {3.655036847895422*^9, 
   3.655036848466227*^9}, {3.655038010593357*^9, 3.655038010993222*^9}, {
   3.655039769086577*^9, 3.655039769248328*^9}, {3.655099935316441*^9, 
   3.655099935796103*^9}, {3.655197983839984*^9, 3.655197983930814*^9}, {
   3.655446254756845*^9, 3.6554462551236973`*^9}, {3.655449335092258*^9, 
   3.655449335651366*^9}, 3.655450387917495*^9, {3.6555327418546553`*^9, 
   3.655532743597848*^9}, {3.655533216958404*^9, 3.655533217347363*^9}, {
   3.65553338992785*^9, 3.655533391085634*^9}, {3.655534467088269*^9, 
   3.655534467567574*^9}, {3.655534890796055*^9, 3.655534892071989*^9}, {
   3.65553522175287*^9, 3.65553522234205*^9}, {3.655535254309112*^9, 
   3.655535257104176*^9}, {3.655535290137826*^9, 3.655535291416156*^9}, {
   3.655556040151299*^9, 3.65555604068427*^9}, 3.655556145088284*^9, {
   3.6555566207206497`*^9, 3.6555566210846577`*^9}, {3.65555732764847*^9, 
   3.6555573281254396`*^9}, {3.655557365042304*^9, 3.655557365201128*^9}, {
   3.65555796670607*^9, 3.655557968529813*^9}, 3.655558200979195*^9, {
   3.6556173409797688`*^9, 3.6556173452751837`*^9}, {3.655620583172147*^9, 
   3.655620583332061*^9}, {3.6556214188551826`*^9, 3.655621419731557*^9}, {
   3.655622813403935*^9, 3.6556228383195868`*^9}, {3.655623007929421*^9, 
   3.6556230083122673`*^9}, {3.655624040978141*^9, 3.6556240430338097`*^9}, 
   3.655632964615163*^9, 3.655703733779904*^9, {3.6557078109002132`*^9, 
   3.655707811393764*^9}, {3.6557094800553493`*^9, 3.6557094805989227`*^9}, {
   3.655709524375369*^9, 3.655709526591319*^9}, 3.655709584783605*^9, {
   3.65570973911966*^9, 3.655709739527367*^9}, {3.655715768087955*^9, 
   3.655715768770681*^9}, {3.6557949081164227`*^9, 3.6557949372225447`*^9}, {
   3.655795027354828*^9, 3.65579502981057*^9}, {3.655797859936355*^9, 
   3.655797860220392*^9}, {3.655803351667573*^9, 3.655803353691201*^9}, {
   3.655804088604362*^9, 3.655804091151464*^9}, {3.6558120627321177`*^9, 
   3.655812062817086*^9}, {3.65581620367349*^9, 3.655816224096175*^9}, {
   3.6558163806831427`*^9, 3.655816380861312*^9}, {3.655816994080559*^9, 
   3.655816995127808*^9}, {3.655817188119372*^9, 3.65581718828636*^9}, {
   3.655818659183668*^9, 3.655818661616737*^9}, {3.6560565997739162`*^9, 
   3.656056602857093*^9}, {3.656060437148609*^9, 3.656060439181603*^9}, {
   3.656061459935535*^9, 3.656061460011529*^9}, {3.656064532627367*^9, 
   3.656064576589561*^9}, 3.65606463032162*^9, {3.656069610456698*^9, 
   3.656069611076746*^9}, 3.656159487677631*^9, {3.65616142263264*^9, 
   3.6561614252840633`*^9}, {3.656161713317032*^9, 3.656161714199567*^9}, {
   3.6561617793128967`*^9, 3.6561617794715157`*^9}, {3.656161830032014*^9, 
   3.656161830556261*^9}, {3.656162950202009*^9, 3.656162997039976*^9}, {
   3.656236398256637*^9, 3.656236400718914*^9}, {3.656316286519558*^9, 
   3.656316287598679*^9}, 3.656320658816787*^9, {3.656322149963526*^9, 
   3.656322150122623*^9}, {3.657023447258524*^9, 3.657023451236718*^9}, {
   3.657023731777852*^9, 3.657023732372614*^9}, {3.657023994498004*^9, 
   3.6570239951608667`*^9}, 3.657024207338923*^9, {3.657272906190036*^9, 
   3.6572729121867743`*^9}, {3.6578660067551937`*^9, 3.657866007190104*^9}, {
   3.657951476913571*^9, 3.657951478223328*^9}, 3.657956869609685*^9, {
   3.658036718079955*^9, 3.658036718492959*^9}, {3.658647617727352*^9, 
   3.6586476181101437`*^9}, {3.6586488892258263`*^9, 3.658648891879355*^9}, {
   3.658649165464017*^9, 3.6586491656155376`*^9}, {3.6586495477073927`*^9, 
   3.6586495482178917`*^9}, 3.658651919243453*^9, {3.6586555936433363`*^9, 
   3.658655599521728*^9}, {3.658732096285277*^9, 3.6587320966478367`*^9}, {
   3.6587321398031387`*^9, 3.65873214047922*^9}, {3.658817666915462*^9, 
   3.6588176670753107`*^9}, {3.658828705483552*^9, 3.6588287076911716`*^9}, 
   3.658830564490472*^9, {3.658836864076172*^9, 3.658836866035008*^9}, {
   3.6588397581846733`*^9, 3.658839758845303*^9}, {3.658839822089666*^9, 
   3.6588398246389427`*^9}, {3.658840073630131*^9, 3.658840074008239*^9}, {
   3.6588402683562202`*^9, 3.658840268824729*^9}, 3.65884032413636*^9, 
   3.6590738427835293`*^9, {3.6590741146439123`*^9, 3.659074115159678*^9}, {
   3.659074661012761*^9, 3.65907466143554*^9}, {3.6590753256774693`*^9, 
   3.659075328746636*^9}, {3.659078208483286*^9, 3.659078209259025*^9}, 
   3.659094615052861*^9, {3.659098635485347*^9, 3.65909863564533*^9}, {
   3.659172018331938*^9, 3.659172020311899*^9}, {3.664616542893653*^9, 
   3.664616546318933*^9}, {3.664617615036969*^9, 3.664617615517116*^9}, {
   3.664618047909181*^9, 3.6646180491075907`*^9}, 3.6646183317379627`*^9, {
   3.6646185584010973`*^9, 3.664618558759858*^9}, {3.66461870137668*^9, 
   3.664618703824625*^9}, {3.664620666653984*^9, 3.6646206675825987`*^9}, {
   3.664621730067371*^9, 3.664621730594266*^9}, {3.664626785085891*^9, 
   3.6646267855671453`*^9}, {3.664692803811021*^9, 3.664692808702776*^9}, {
   3.664707516421959*^9, 3.66470751744547*^9}, {3.6647076977579823`*^9, 
   3.664707697912722*^9}, {3.664708492126959*^9, 3.664708492598796*^9}, {
   3.6647863210720673`*^9, 3.66478632123421*^9}, {3.664787970041991*^9, 
   3.664787970816103*^9}, {3.6647891401075897`*^9, 3.664789142657419*^9}, {
   3.664789294459279*^9, 3.664789294561571*^9}, {3.66478935286236*^9, 
   3.664789354390448*^9}, 3.664789416267861*^9, 3.664862000551353*^9, {
   3.665137687689713*^9, 3.665137690512755*^9}, {3.665396569602062*^9, 
   3.665396573010116*^9}, 3.665397059606575*^9, {3.665401212779483*^9, 
   3.665401215538053*^9}, 3.665402980553475*^9, {3.66547106688719*^9, 
   3.665471068338367*^9}, {3.665472379250383*^9, 3.665472446366167*^9}, {
   3.6654725374437647`*^9, 3.66547260077087*^9}, {3.666010125842783*^9, 
   3.666010128375224*^9}, {3.666010251093719*^9, 3.666010251627577*^9}, {
   3.666010493747345*^9, 3.666010494190557*^9}, {3.66601062208661*^9, 
   3.666010622334317*^9}, {3.6660108855485783`*^9, 3.666010886163355*^9}, 
   3.66601096279809*^9, {3.6660110212336187`*^9, 3.666011021599*^9}, {
   3.6660110693327208`*^9, 3.666011072234083*^9}}],

Cell[CellGroupData[{

Cell["Load Model", "Section",
 CellChangeTimes->{{3.5514194743215218`*^9, 3.5514194790813303`*^9}, {
  3.569143880069605*^9, 3.5691438813657913`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Set", " ", "the", " ", "numbers", " ", "of", " ", "kernels", " ", "to", 
    " ", "use"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"FR$Parallel", "=", "False"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FR$KernelNumber", "=", "1"}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.591531602576215*^9, 3.591531618218998*^9}, 
   3.591533506458474*^9, 3.634536764502748*^9, 3.634539537312375*^9, 
   3.647577791829467*^9, {3.6475779958693037`*^9, 3.64757799682448*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Load", " ", "Feynrules", " ", "package"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"$FeynRulesPath", "=", 
     RowBox[{"SetDirectory", "[", "locFR", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"<<", "FeynRules`"}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.566887984405558*^9, 3.566888004233726*^9}, 
   3.5668882488640413`*^9, 3.5691439511092987`*^9, {3.569144013099992*^9, 
   3.569144043833107*^9}, {3.569144389713841*^9, 3.56914440046568*^9}, {
   3.591531977558329*^9, 3.5915320156354837`*^9}, {3.591533518211247*^9, 
   3.59153355636287*^9}, {3.591533664205855*^9, 3.59153367141982*^9}, 
   3.656064554342082*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{3.6660104471084642`*^9, 3.666010501869619*^9, 
  3.6660106273913*^9, 3.666010827128105*^9, 3.666010891998673*^9, 
  3.666010969289906*^9, 3.666011029479732*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.18\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"23 February 2016\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.18", " (" "23 February 2016", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104471084642`*^9, 3.666010501869619*^9, 
  3.6660106273913*^9, 3.666010827128105*^9, 3.666010891998673*^9, 
  3.666010969289906*^9, 3.666011029480749*^9}],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{3.6660104471084642`*^9, 3.666010501869619*^9, 
  3.6660106273913*^9, 3.666010827128105*^9, 3.666010891998673*^9, 
  3.666010969289906*^9, 3.6660110294815483`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.6660104471084642`*^9, 3.666010501869619*^9, 
  3.6660106273913*^9, 3.666010827128105*^9, 3.666010891998673*^9, 
  3.666010969289906*^9, 3.666011029482225*^9}],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{3.6660104471084642`*^9, 3.666010501869619*^9, 
  3.6660106273913*^9, 3.666010827128105*^9, 3.666010891998673*^9, 
  3.666010969289906*^9, 3.6660110294828997`*^9}],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{3.6660104471084642`*^9, 3.666010501869619*^9, 
  3.6660106273913*^9, 3.666010827128105*^9, 3.666010891998673*^9, 
  3.666010969289906*^9, 3.666011029483979*^9}],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{3.6660104471084642`*^9, 3.666010501869619*^9, 
  3.6660106273913*^9, 3.666010827128105*^9, 3.666010891998673*^9, 
  3.666010969289906*^9, 3.666011029484947*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.6660104471084642`*^9, 3.666010501869619*^9, 
  3.6660106273913*^9, 3.666010827128105*^9, 3.666010891998673*^9, 
  3.666010969289906*^9, 3.666011029485733*^9}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{3.6660104471084642`*^9, 3.666010501869619*^9, 
  3.6660106273913*^9, 3.666010827128105*^9, 3.666010891998673*^9, 
  3.666010969289906*^9, 3.66601102948661*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.6660104471084642`*^9, 3.666010501869619*^9, 
  3.6660106273913*^9, 3.666010827128105*^9, 3.666010891998673*^9, 
  3.666010969289906*^9, 3.666011029487605*^9}],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{3.6660104471084642`*^9, 3.666010501869619*^9, 
  3.6660106273913*^9, 3.666010827128105*^9, 3.666010891998673*^9, 
  3.666010969289906*^9, 3.666011029488406*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Set", " ", "directory", " ", "to", " ", "model", " ", "file"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"locMF", "<>", "\"\<fr_files\>\""}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Load", " ", "the", " ", "model"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LoadModel", "[", 
     RowBox[{"\"\<SM.fr\>\"", ",", "locModelFile"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Reset", " ", "the", " ", "directory"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "locMF", "]"}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.538490636342494*^9, 3.538490643734316*^9}, {
   3.541479631815613*^9, 3.541479632599341*^9}, {3.541483713628701*^9, 
   3.54148371406596*^9}, {3.541483897879717*^9, 3.5414838983827047`*^9}, 
   3.541484290596036*^9, {3.541484830537643*^9, 3.5414848306710577`*^9}, {
   3.5414849678866262`*^9, 3.541484968172381*^9}, 3.54789862696729*^9, {
   3.5514215471116858`*^9, 3.55142155386973*^9}, {3.567840265926762*^9, 
   3.567840270050302*^9}, {3.567850699751855*^9, 3.567850708093032*^9}, {
   3.567851013721712*^9, 3.567851015393116*^9}, {3.5678511221605463`*^9, 
   3.567851130053293*^9}, {3.568455156113002*^9, 3.568455162838105*^9}, {
   3.568455924600046*^9, 3.56845593111707*^9}, {3.569138216429874*^9, 
   3.569138220213174*^9}, {3.569144423911316*^9, 3.569144435416916*^9}, {
   3.569565111389081*^9, 3.569565118890169*^9}, 3.570339255241012*^9, {
   3.589193279989728*^9, 3.5891932869771442`*^9}, {3.589193690515671*^9, 
   3.589193694347581*^9}, {3.591532175678632*^9, 3.591532175795117*^9}, {
   3.591532209454689*^9, 3.591532209643866*^9}, {3.591532675409931*^9, 
   3.591532677615961*^9}, {3.646997228586138*^9, 3.646997229921729*^9}, {
   3.64715256231214*^9, 3.64715256616389*^9}, {3.6471527581420527`*^9, 
   3.6471527584407578`*^9}, {3.647851672567918*^9, 3.647851672802229*^9}, 
   3.654588827415395*^9, 3.654588983055668*^9, {3.655099816440139*^9, 
   3.655099830358569*^9}, {3.655099908057152*^9, 3.655099927779963*^9}, {
   3.655100101197085*^9, 3.6551001290562477`*^9}, 3.656064570798112*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{3.666010447280376*^9, 3.666010502142578*^9, 
  3.6660106276576977`*^9, 3.666010827401376*^9, 3.666010892259314*^9, 
  3.66601096954318*^9, 3.666011029758407*^9}],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.666010447280376*^9, 3.666010502142578*^9, 
  3.6660106276576977`*^9, 3.666010827401376*^9, 3.666010892259314*^9, 
  3.66601096954318*^9, 3.666011029793791*^9}],

Cell[BoxData["\<\"A. Kaminska\"\>"], "Print",
 CellChangeTimes->{3.666010447280376*^9, 3.666010502142578*^9, 
  3.6660106276576977`*^9, 3.666010827401376*^9, 3.666010892259314*^9, 
  3.66601096954318*^9, 3.666011029794952*^9}],

Cell[BoxData["\<\"M. de Vries\"\>"], "Print",
 CellChangeTimes->{3.666010447280376*^9, 3.666010502142578*^9, 
  3.6660106276576977`*^9, 3.666010827401376*^9, 3.666010892259314*^9, 
  3.66601096954318*^9, 3.666011029796089*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
  SequenceForm["Model Version: ", "1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.666010447280376*^9, 3.666010502142578*^9, 
  3.6660106276576977`*^9, 3.666010827401376*^9, 3.666010892259314*^9, 
  3.66601096954318*^9, 3.666011029797121*^9}],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{3.666010447280376*^9, 3.666010502142578*^9, 
  3.6660106276576977`*^9, 3.666010827401376*^9, 3.666010892259314*^9, 
  3.66601096954318*^9, 3.666011029798236*^9}],

Cell[BoxData["\<\"http://arxiv.org/abs/1510.03434\"\>"], "Print",
 CellChangeTimes->{3.666010447280376*^9, 3.666010502142578*^9, 
  3.6660106276576977`*^9, 3.666010827401376*^9, 3.666010892259314*^9, 
  3.66601096954318*^9, 3.666011029799365*^9}],

Cell[BoxData["\<\"http://feynrules.irmp.ucl.ac.be/wiki/SimplifiedDM\"\>"], \
"Print",
 CellChangeTimes->{3.666010447280376*^9, 3.666010502142578*^9, 
  3.6660106276576977`*^9, 3.666010827401376*^9, 3.666010892259314*^9, 
  3.66601096954318*^9, 3.6660110298005*^9}],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.666010447280376*^9, 3.666010502142578*^9, 
  3.6660106276576977`*^9, 3.666010827401376*^9, 3.666010892259314*^9, 
  3.66601096954318*^9, 3.666011029801697*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.666010447280376*^9, 3.666010502142578*^9, 
  3.6660106276576977`*^9, 3.666010827401376*^9, 3.666010892259314*^9, 
  3.66601096954318*^9, 3.666011029802904*^9}],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.666010447280376*^9, 3.666010502142578*^9, 
  3.6660106276576977`*^9, 3.666010827401376*^9, 3.666010892259314*^9, 
  3.66601096954318*^9, 3.666011029804069*^9}],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.666010447280376*^9, 3.666010502142578*^9, 
  3.6660106276576977`*^9, 3.666010827401376*^9, 3.666010892259314*^9, 
  3.66601096954318*^9, 3.666011029921513*^9}],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.666010447280376*^9, 3.666010502142578*^9, 
  3.6660106276576977`*^9, 3.666010827401376*^9, 3.666010892259314*^9, 
  3.66601096954318*^9, 3.6660110299598923`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", 
   "\[InvisibleSpace]", "\<\"Resonance + MET: Scalar Octet\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "Resonance + MET: Scalar Octet", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.666010447280376*^9, 3.666010502142578*^9, 
  3.6660106276576977`*^9, 3.666010827401376*^9, 3.666010892259314*^9, 
  3.66601096954318*^9, 3.666011030061633*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ModelInformation", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.665399643551157*^9, 3.665399646794608*^9}, 
   3.6654746438885736`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model name: \"\>", 
   "\[InvisibleSpace]", "\<\"Resonance + MET: Diquark (Triplet)\"\>"}],
  SequenceForm["Model name: ", "Resonance + MET: Diquark (Triplet)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6654876724795523`*^9, 3.666010477027104*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
  SequenceForm["Model version: ", "1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6654876724795523`*^9, 3.666010477027856*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Date: \"\>", "\[InvisibleSpace]", "\<\"March 2016\"\>"}],
  SequenceForm["Date: ", "March 2016"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6654876724795523`*^9, 3.666010477028578*^9}],

Cell[BoxData["\<\"Authors: \"\>"], "Print",
 CellChangeTimes->{3.6654876724795523`*^9, 3.666010477029273*^9}],

Cell[BoxData["\<\"   A. Kaminska\"\>"], "Print",
 CellChangeTimes->{3.6654876724795523`*^9, 3.666010477029868*^9}],

Cell[BoxData["\<\"   M. de Vries\"\>"], "Print",
 CellChangeTimes->{3.6654876724795523`*^9, 3.666010477030424*^9}],

Cell[BoxData["\<\"Institutions: \"\>"], "Print",
 CellChangeTimes->{3.6654876724795523`*^9, 3.666010477030982*^9}],

Cell[BoxData["\<\"   MITP, Mainz\"\>"], "Print",
 CellChangeTimes->{3.6654876724795523`*^9, 3.666010477031537*^9}],

Cell[BoxData["\<\"Emails: \"\>"], "Print",
 CellChangeTimes->{3.6654876724795523`*^9, 3.666010477032092*^9}],

Cell[BoxData["\<\"   akaminsk@uni-mainz.de\"\>"], "Print",
 CellChangeTimes->{3.6654876724795523`*^9, 3.6660104770326977`*^9}],

Cell[BoxData["\<\"   mdevrie@uni-mainz.de\"\>"], "Print",
 CellChangeTimes->{3.6654876724795523`*^9, 3.666010477033287*^9}],

Cell[BoxData["\<\"References: \"\>"], "Print",
 CellChangeTimes->{3.6654876724795523`*^9, 3.6660104770338783`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"StringJoin", "::", "string"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"String expected at position \
\[NoBreak]\\!\\(\\*RowBox[{\\\"2\\\"}]\\)\[NoBreak] in \
\[NoBreak]\\!\\(\\*RowBox[{\\\"\\\\\\\"   \\\\\\\"\\\", \\\"<>\\\", \
TagBox[ButtonBox[PaneSelectorBox[{False -> \
\\\"\\\\\\\"http://arxiv.org/abs/1510.03434\\\\\\\"\\\", Rule[True, StyleBox[\
\\\"\\\\\\\"http://arxiv.org/abs/1510.03434\\\\\\\"\\\", \
List[\\\"HyperlinkActive\\\"]]]}, Dynamic[CurrentValue[\\\"MouseOver\\\"]], \
Rule[BaseStyle, List[\\\"Hyperlink\\\"]], Rule[FrameMargins, 0], \
Rule[ImageSize, Automatic]], Rule[BaseStyle, \\\"Hyperlink\\\"], \
Rule[ButtonData, List[URL[\\\"http://arxiv.org/abs/1510.03434\\\"], None]], \
Rule[ButtonNote, \\\"http://arxiv.org/abs/1510.03434\\\"]], \
Function[Annotation[Slot[1], \\\"http://arxiv.org/abs/1510.03434\\\", \
\\\"Hyperlink\\\"]]]}]\\)\[NoBreak]. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/StringJoin\\\", ButtonNote -> \
\\\"StringJoin::string\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.666010477080987*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\<\"   \"\>", "<>", 
  TagBox[
   ButtonBox[
    PaneSelectorBox[{False->"\<\"http://arxiv.org/abs/1510.03434\"\>", True->
     StyleBox["\<\"http://arxiv.org/abs/1510.03434\"\>", "HyperlinkActive"]}, 
     Dynamic[
      CurrentValue["MouseOver"]],
     BaseStyle->{"Hyperlink"},
     FrameMargins->0,
     ImageSize->Automatic],
    BaseStyle->"Hyperlink",
    ButtonData->{
      URL["http://arxiv.org/abs/1510.03434"], None},
    ButtonNote->"http://arxiv.org/abs/1510.03434"],
   Annotation[#, "http://arxiv.org/abs/1510.03434", 
    "Hyperlink"]& ]}]], "Print",
 CellChangeTimes->{3.6654876724795523`*^9, 3.666010477082321*^9}],

Cell[BoxData["\<\"URL's: \"\>"], "Print",
 CellChangeTimes->{3.6654876724795523`*^9, 3.666010477083047*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"StringJoin", "::", "string"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"String expected at position \
\[NoBreak]\\!\\(\\*RowBox[{\\\"2\\\"}]\\)\[NoBreak] in \
\[NoBreak]\\!\\(\\*RowBox[{\\\"\\\\\\\"   \\\\\\\"\\\", \\\"<>\\\", \
TagBox[ButtonBox[PaneSelectorBox[{False -> \
\\\"\\\\\\\"http://feynrules.irmp.ucl.ac.be/wiki/SimplifiedDM\\\\\\\"\\\", \
Rule[True, \
StyleBox[\\\"\\\\\\\"http://feynrules.irmp.ucl.ac.be/wiki/SimplifiedDM\\\\\\\"\
\\\", List[\\\"HyperlinkActive\\\"]]]}, \
Dynamic[CurrentValue[\\\"MouseOver\\\"]], Rule[BaseStyle, \
List[\\\"Hyperlink\\\"]], Rule[FrameMargins, 0], Rule[ImageSize, Automatic]], \
Rule[BaseStyle, \\\"Hyperlink\\\"], Rule[ButtonData, \
List[URL[\\\"http://feynrules.irmp.ucl.ac.be/wiki/SimplifiedDM\\\"], None]], \
Rule[ButtonNote, \\\"http://feynrules.irmp.ucl.ac.be/wiki/SimplifiedDM\\\"]], \
Function[Annotation[Slot[1], \
\\\"http://feynrules.irmp.ucl.ac.be/wiki/SimplifiedDM\\\", \
\\\"Hyperlink\\\"]]]}]\\)\[NoBreak]. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/StringJoin\\\", ButtonNote -> \
\\\"StringJoin::string\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.666010477137003*^9}],

Cell[BoxData[
 RowBox[{"\<\"   \"\>", "<>", 
  TagBox[
   ButtonBox[
    PaneSelectorBox[{
     False->"\<\"http://feynrules.irmp.ucl.ac.be/wiki/SimplifiedDM\"\>", True->
     
     StyleBox["\<\"http://feynrules.irmp.ucl.ac.be/wiki/SimplifiedDM\"\>", 
      "HyperlinkActive"]}, Dynamic[
      CurrentValue["MouseOver"]],
     BaseStyle->{"Hyperlink"},
     FrameMargins->0,
     ImageSize->Automatic],
    BaseStyle->"Hyperlink",
    ButtonData->{
      URL["http://feynrules.irmp.ucl.ac.be/wiki/SimplifiedDM"], None},
    ButtonNote->"http://feynrules.irmp.ucl.ac.be/wiki/SimplifiedDM"],
   Annotation[#, "http://feynrules.irmp.ucl.ac.be/wiki/SimplifiedDM", 
    "Hyperlink"]& ]}]], "Print",
 CellChangeTimes->{3.6654876724795523`*^9, 3.666010477138538*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Lagrangian & Vertices", "Section",
 CellChangeTimes->{{3.634887228523443*^9, 3.634887238238522*^9}}],

Cell[CellGroupData[{

Cell["Lagrangian", "Subsection",
 CellChangeTimes->{{3.6348872639011497`*^9, 3.6348872656833563`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LRM"], "Input",
 CellChangeTimes->{{3.647152575960599*^9, 3.647152581317754*^9}, {
  3.6478517285774527`*^9, 3.647851728938452*^9}, {3.654589051505088*^9, 
  3.654589051846423*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   SubscriptBox["M", "DM"], " ", 
   RowBox[{
    OverscriptBox["DM", "\<\"-\"\>"], ".", "DM"}]}], "-", 
  RowBox[{
   SubscriptBox["M", "X"], " ", 
   RowBox[{
    OverscriptBox["XUP", "\<\"-\"\>"], ".", "XUP"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   RowBox[{
    OverscriptBox["DM", "\<\"-\"\>"], ".", 
    TemplateBox[{"\[Gamma]","mu"},
     "Superscript"], ".", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "DM", "]"}]}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{
    OverscriptBox["XUP", "\<\"-\"\>"], ".", 
    TemplateBox[{"\[Gamma]","mu"},
     "Superscript"], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", 
       SubscriptBox["g", "1"], " ", "XUP", " ", 
       SubscriptBox["B", "mu"]}], "+", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "XUP", "]"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "s"], " ", 
       RowBox[{
        SuperscriptBox["T", "a$724"], ".", "XUP"}], " ", 
       SubscriptBox["G", 
        RowBox[{"mu", ",", "a$724"}]]}]}], ")"}]}]}], "-", 
  RowBox[{
   SubscriptBox["y", "D"], " ", 
   RowBox[{
    SubscriptBox[
     OverscriptBox["XUP", "\<\"-\"\>"], 
     RowBox[{"s1", ",", "c1"}]], ".", 
    SubscriptBox["DM", "s1"]}], " ", 
   SubscriptBox["MUP", "c1"]}], "-", 
  RowBox[{
   SubscriptBox["y", "D"], " ", 
   RowBox[{
    SubscriptBox["DM", "r$729"], ".", 
    SubscriptBox["XUP", 
     RowBox[{"r$729", ",", "c1"}]]}], " ", 
   SubsuperscriptBox["MUP", "c1", "\[Dagger]"]}], "-", 
  RowBox[{
   SubsuperscriptBox["M", "M", "2"], " ", 
   SubscriptBox["MUP", "c1"], " ", 
   SubsuperscriptBox["MUP", "c1", "\[Dagger]"]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubsuperscriptBox["MUP", "c1", "\[Dagger]"], "]"}], "-", 
     RowBox[{
      FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", 
      SubscriptBox["g", "1"], " ", 
      SubscriptBox["B", "mu"], " ", 
      SubsuperscriptBox["MUP", "c1", "\[Dagger]"]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      SubscriptBox["G", 
       RowBox[{"mu", ",", "a$725"}]], " ", 
      SubsuperscriptBox["MUP", "i$725", "\[Dagger]"], " ", 
      SubsuperscriptBox["T", 
       RowBox[{"i$725", ",", "c1"}], "a$725"]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["MUP", "c1"], "]"}], "+", 
     RowBox[{
      FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", 
      SubscriptBox["g", "1"], " ", 
      SubscriptBox["B", "mu"], " ", 
      SubscriptBox["MUP", "c1"]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      SubscriptBox["G", 
       RowBox[{"mu", ",", "a$726"}]], " ", 
      SubscriptBox["MUP", "i$726"], " ", 
      SubsuperscriptBox["T", 
       RowBox[{"c1", ",", "i$726"}], "a$726"]}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{
    SubscriptBox[
     OverscriptBox["dq", "\<\"-\"\>"], 
     RowBox[{"s1", ",", "f1", ",", "c1"}]], ".", 
    SubsuperscriptBox["uq", 
     RowBox[{"s2", ",", "f2", ",", "c2"}], "C"]}], " ", 
   SubscriptBox["\[Epsilon]", 
    RowBox[{"c3", ",", "c1", ",", "c2"}]], " ", 
   SubsuperscriptBox["MUP", "c3", "\[Dagger]"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox[
       SubscriptBox["P", "\<\"-\"\>"], 
       RowBox[{"s1", ",", "s2"}]], " ", 
      SubscriptBox[
       TemplateBox[{"y","ud","L"},
        "Subsuperscript"], 
       RowBox[{"f1", ",", "f2"}]]}], "+", 
     RowBox[{
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{"s1", ",", "s2"}]], " ", 
      SubscriptBox[
       TemplateBox[{"y","ud","R"},
        "Subsuperscript"], 
       RowBox[{"f1", ",", "f2"}]]}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox[
     OverscriptBox["uq", "\<\"-\"\>"], 
     RowBox[{"r$727", ",", "f2", ",", "c2"}], "C"], ".", 
    SubscriptBox["dq", 
     RowBox[{"r$728", ",", "f1", ",", "c1"}]]}], " ", 
   SubscriptBox["\[Epsilon]", 
    RowBox[{"c3", ",", "c1", ",", "c2"}]], " ", 
   TemplateBox[{SubscriptBox["\[Gamma]", 
      RowBox[{"r$727", ",", "s2"}]],"0"},
    "Superscript"], " ", 
   TemplateBox[{SubscriptBox["\[Gamma]", 
      RowBox[{"s1", ",", "r$728"}]],"0"},
    "Superscript"], " ", 
   SubscriptBox["MUP", "c3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox[
       SubscriptBox["P", "\<\"-\"\>"], 
       RowBox[{"s2", ",", "s1"}]], " ", 
      SubscriptBox[
       TemplateBox[{"y","ud","L"},
        "Subsuperscript"], 
       RowBox[{"f1", ",", "f2"}]]}], "+", 
     RowBox[{
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{"s2", ",", "s1"}]], " ", 
      SubscriptBox[
       TemplateBox[{"y","ud","R"},
        "Subsuperscript"], 
       RowBox[{"f1", ",", "f2"}]]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.634887272586668*^9, 3.634889448116353*^9, 3.63497319087674*^9, 
   3.6351400442774143`*^9, 3.64699786239185*^9, {3.6470011465226*^9, 
   3.6470011515620337`*^9}, 3.647152716830233*^9, 3.647577721463813*^9, 
   3.6475778062255917`*^9, 3.6475781936746902`*^9, 3.64767989900603*^9, 
   3.647851730518477*^9, 3.647854436166458*^9, 3.654589265206051*^9, 
   3.65502749403767*^9, 3.6550278615813637`*^9, {3.655101571087282*^9, 
   3.6551015943640537`*^9}, 3.655101724768732*^9, 3.655102932249732*^9, 
   3.655556268000334*^9, 3.6555566669403553`*^9, 3.6556193230706987`*^9, 
   3.664620734355229*^9, 3.664620855160906*^9, 3.664621145640909*^9, 
   3.66462213660122*^9, 3.664622877794105*^9, 3.6647868376789827`*^9, 
   3.664787361044084*^9, 3.665472647572235*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetInteractionTerms", "[", "LRM", "]"}]], "Input",
 CellChangeTimes->{{3.634888529552161*^9, 3.634888533850655*^9}, {
   3.6349858166457453`*^9, 3.634985825428479*^9}, 3.647152585834934*^9, 
   3.647851741273836*^9, 3.654589269627035*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with less than \"\>", 
   "\[InvisibleSpace]", "\<\"3\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with less than ", "3", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.655027497806857*^9, 3.655027866693696*^9, 
  3.655101569511312*^9, 3.655101726138344*^9, 3.655102191432921*^9, 
  3.655102319513343*^9, 3.6551023818225527`*^9, 3.655102933695201*^9, 
  3.6551047240040073`*^9, 3.6551979938454847`*^9, 3.655556277827148*^9, 
  3.6555566685046167`*^9, 3.655617498888996*^9, 3.655619328745755*^9, 
  3.655630680926243*^9, 3.655812151645296*^9, 3.6558122541746902`*^9, 
  3.655812286800385*^9, 3.655812649275105*^9, 3.6558129213558283`*^9, 
  3.655812989610148*^9, 3.6558160734970903`*^9, 3.664622881228438*^9, 
  3.664787392961952*^9, 3.6654726484116087`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "3"]}], " ", "e", " ", 
   SubscriptBox["A", "mu"], " ", 
   RowBox[{
    SubscriptBox[
     OverscriptBox["X", "\<\"-\"\>"], 
     RowBox[{"i$746", ",", "i1$748"}]], ".", 
    SubscriptBox["X", 
     RowBox[{"j$746", ",", "i1$748"}]]}], " ", 
   TemplateBox[{SubscriptBox["\[Gamma]", 
      RowBox[{"i$746", ",", "j$746"}]],"mu"},
    "Superscript"]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
    SubsuperscriptBox["M", "c1", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["M", "c1"]}], "-", 
  RowBox[{
   SubscriptBox["y", "D"], " ", 
   RowBox[{
    SubscriptBox[
     OverscriptBox["X", "\<\"-\"\>"], 
     RowBox[{"s1", ",", "c1"}]], ".", 
    SubscriptBox["DM", "s1"]}], " ", 
   SubscriptBox["M", "c1"]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
   SubscriptBox["A", "mu"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
    SubscriptBox["M", "c1"], "]"}], " ", 
   SubsuperscriptBox["M", "c1", "\[Dagger]"]}], "-", 
  RowBox[{
   SubscriptBox["y", "D"], " ", 
   RowBox[{
    SubscriptBox["DM", "r$739"], ".", 
    SubscriptBox["X", 
     RowBox[{"r$739", ",", "c1"}]]}], " ", 
   SubsuperscriptBox["M", "c1", "\[Dagger]"]}], "+", 
  RowBox[{
   FractionBox["1", "9"], " ", 
   SuperscriptBox["e", "2"], " ", 
   SubsuperscriptBox["A", "mu", "2"], " ", 
   SubscriptBox["M", "c1"], " ", 
   SubsuperscriptBox["M", "c1", "\[Dagger]"]}], "+", 
  RowBox[{
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox[
     OverscriptBox["X", "\<\"-\"\>"], 
     RowBox[{"i$751", ",", "i$750"}]], ".", 
    SubscriptBox["X", 
     RowBox[{"j$751", ",", "j$750"}]]}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu", ",", "a$734"}]], " ", 
   TemplateBox[{SubscriptBox["\[Gamma]", 
      RowBox[{"i$751", ",", "j$751"}]],"mu"},
    "Superscript"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$750", ",", "j$750"}], "a$734"]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
    SubscriptBox["M", "c1"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu", ",", "a$735"}]], " ", 
   SubsuperscriptBox["M", "i$735", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$735", ",", "c1"}], "a$735"]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu", ",", "a$735"}]], " ", 
   SubscriptBox["M", "c1"], " ", 
   SubsuperscriptBox["M", "i$735", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$735", ",", "c1"}], "a$735"]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
    SubsuperscriptBox["M", "c1", "\[Dagger]"], "]"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu", ",", "a$736"}]], " ", 
   SubscriptBox["M", "i$736"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"c1", ",", "i$736"}], "a$736"]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", "e", " ", 
   SubscriptBox["g", "s"], " ", 
   SubscriptBox["A", "mu"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu", ",", "a$736"}]], " ", 
   SubscriptBox["M", "i$736"], " ", 
   SubsuperscriptBox["M", "c1", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"c1", ",", "i$736"}], "a$736"]}], "+", 
  RowBox[{
   SubsuperscriptBox["g", "s", "2"], " ", 
   SubscriptBox["G", 
    RowBox[{"mu", ",", "a$735"}]], " ", 
   SubscriptBox["G", 
    RowBox[{"mu", ",", "a$736"}]], " ", 
   SubscriptBox["M", "i$736"], " ", 
   SubsuperscriptBox["M", "i$735", "\[Dagger]"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"i$735", ",", "c1"}], "a$735"], " ", 
   SubsuperscriptBox["T", 
    RowBox[{"c1", ",", "i$736"}], "a$736"]}], "+", 
  RowBox[{
   RowBox[{
    SubscriptBox[
     OverscriptBox["d", "\<\"-\"\>"], 
     RowBox[{"s1", ",", "c1"}]], ".", 
    SubsuperscriptBox["u", 
     RowBox[{"s2", ",", "c2"}], "C"]}], " ", 
   SubscriptBox["\[Epsilon]", 
    RowBox[{"c3", ",", "c1", ",", "c2"}]], " ", 
   SubsuperscriptBox["M", "c3", "\[Dagger]"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"s1", ",", "s2"}]], " ", 
   SubscriptBox[
    TemplateBox[{"y","ud","L"},
     "Subsuperscript"], 
    RowBox[{"1", ",", "1"}]]}], "+", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox[
     OverscriptBox["d", "\<\"-\"\>"], 
     RowBox[{"r$738", ",", "c1"}], "C"], ".", 
    SubscriptBox["u", 
     RowBox[{"r$737", ",", "c2"}]]}], " ", 
   SubscriptBox["\[Epsilon]", 
    RowBox[{"c3", ",", "c1", ",", "c2"}]], " ", 
   SubscriptBox["M", "c3"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"+\"\>"], 
    RowBox[{"r$738", ",", "r$737"}]], " ", 
   SubscriptBox[
    TemplateBox[{"y","ud","L"},
     "Subsuperscript"], 
    RowBox[{"1", ",", "1"}]]}], "+", 
  RowBox[{
   RowBox[{
    SubscriptBox[
     OverscriptBox["c", "\<\"-\"\>"], 
     RowBox[{"s2", ",", "c2"}]], ".", 
    SubsuperscriptBox["s", 
     RowBox[{"s1", ",", "c1"}], "C"]}], " ", 
   SubscriptBox["\[Epsilon]", 
    RowBox[{"c3", ",", "c1", ",", "c2"}]], " ", 
   SubsuperscriptBox["M", "c3", "\[Dagger]"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"s2", ",", "s1"}]], " ", 
   SubscriptBox[
    TemplateBox[{"y","ud","L"},
     "Subsuperscript"], 
    RowBox[{"2", ",", "2"}]]}], "+", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox[
     OverscriptBox["c", "\<\"-\"\>"], 
     RowBox[{"r$737", ",", "c2"}], "C"], ".", 
    SubscriptBox["s", 
     RowBox[{"r$738", ",", "c1"}]]}], " ", 
   SubscriptBox["\[Epsilon]", 
    RowBox[{"c3", ",", "c1", ",", "c2"}]], " ", 
   SubscriptBox["M", "c3"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"+\"\>"], 
    RowBox[{"r$737", ",", "r$738"}]], " ", 
   SubscriptBox[
    TemplateBox[{"y","ud","L"},
     "Subsuperscript"], 
    RowBox[{"2", ",", "2"}]]}], "+", 
  RowBox[{
   RowBox[{
    SubscriptBox[
     OverscriptBox["b", "\<\"-\"\>"], 
     RowBox[{"s1", ",", "c1"}]], ".", 
    SubsuperscriptBox["t", 
     RowBox[{"s2", ",", "c2"}], "C"]}], " ", 
   SubscriptBox["\[Epsilon]", 
    RowBox[{"c3", ",", "c1", ",", "c2"}]], " ", 
   SubsuperscriptBox["M", "c3", "\[Dagger]"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"s1", ",", "s2"}]], " ", 
   SubscriptBox[
    TemplateBox[{"y","ud","L"},
     "Subsuperscript"], 
    RowBox[{"3", ",", "3"}]]}], "+", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox[
     OverscriptBox["b", "\<\"-\"\>"], 
     RowBox[{"r$738", ",", "c1"}], "C"], ".", 
    SubscriptBox["t", 
     RowBox[{"r$737", ",", "c2"}]]}], " ", 
   SubscriptBox["\[Epsilon]", 
    RowBox[{"c3", ",", "c1", ",", "c2"}]], " ", 
   SubscriptBox["M", "c3"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"+\"\>"], 
    RowBox[{"r$738", ",", "r$737"}]], " ", 
   SubscriptBox[
    TemplateBox[{"y","ud","L"},
     "Subsuperscript"], 
    RowBox[{"3", ",", "3"}]]}], "+", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox[
     OverscriptBox["d", "\<\"-\"\>"], 
     RowBox[{"r$738", ",", "c1"}], "C"], ".", 
    SubscriptBox["u", 
     RowBox[{"r$737", ",", "c2"}]]}], " ", 
   SubscriptBox["\[Epsilon]", 
    RowBox[{"c3", ",", "c1", ",", "c2"}]], " ", 
   SubscriptBox["M", "c3"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"r$738", ",", "r$737"}]], " ", 
   SubscriptBox[
    TemplateBox[{"y","ud","R"},
     "Subsuperscript"], 
    RowBox[{"1", ",", "1"}]]}], "+", 
  RowBox[{
   RowBox[{
    SubscriptBox[
     OverscriptBox["d", "\<\"-\"\>"], 
     RowBox[{"s1", ",", "c1"}]], ".", 
    SubsuperscriptBox["u", 
     RowBox[{"s2", ",", "c2"}], "C"]}], " ", 
   SubscriptBox["\[Epsilon]", 
    RowBox[{"c3", ",", "c1", ",", "c2"}]], " ", 
   SubsuperscriptBox["M", "c3", "\[Dagger]"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"+\"\>"], 
    RowBox[{"s1", ",", "s2"}]], " ", 
   SubscriptBox[
    TemplateBox[{"y","ud","R"},
     "Subsuperscript"], 
    RowBox[{"1", ",", "1"}]]}], "+", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox[
     OverscriptBox["c", "\<\"-\"\>"], 
     RowBox[{"r$737", ",", "c2"}], "C"], ".", 
    SubscriptBox["s", 
     RowBox[{"r$738", ",", "c1"}]]}], " ", 
   SubscriptBox["\[Epsilon]", 
    RowBox[{"c3", ",", "c1", ",", "c2"}]], " ", 
   SubscriptBox["M", "c3"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"r$737", ",", "r$738"}]], " ", 
   SubscriptBox[
    TemplateBox[{"y","ud","R"},
     "Subsuperscript"], 
    RowBox[{"2", ",", "2"}]]}], "+", 
  RowBox[{
   RowBox[{
    SubscriptBox[
     OverscriptBox["c", "\<\"-\"\>"], 
     RowBox[{"s2", ",", "c2"}]], ".", 
    SubsuperscriptBox["s", 
     RowBox[{"s1", ",", "c1"}], "C"]}], " ", 
   SubscriptBox["\[Epsilon]", 
    RowBox[{"c3", ",", "c1", ",", "c2"}]], " ", 
   SubsuperscriptBox["M", "c3", "\[Dagger]"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"+\"\>"], 
    RowBox[{"s2", ",", "s1"}]], " ", 
   SubscriptBox[
    TemplateBox[{"y","ud","R"},
     "Subsuperscript"], 
    RowBox[{"2", ",", "2"}]]}], "+", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox[
     OverscriptBox["b", "\<\"-\"\>"], 
     RowBox[{"r$738", ",", "c1"}], "C"], ".", 
    SubscriptBox["t", 
     RowBox[{"r$737", ",", "c2"}]]}], " ", 
   SubscriptBox["\[Epsilon]", 
    RowBox[{"c3", ",", "c1", ",", "c2"}]], " ", 
   SubscriptBox["M", "c3"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"r$738", ",", "r$737"}]], " ", 
   SubscriptBox[
    TemplateBox[{"y","ud","R"},
     "Subsuperscript"], 
    RowBox[{"3", ",", "3"}]]}], "+", 
  RowBox[{
   RowBox[{
    SubscriptBox[
     OverscriptBox["b", "\<\"-\"\>"], 
     RowBox[{"s1", ",", "c1"}]], ".", 
    SubsuperscriptBox["t", 
     RowBox[{"s2", ",", "c2"}], "C"]}], " ", 
   SubscriptBox["\[Epsilon]", 
    RowBox[{"c3", ",", "c1", ",", "c2"}]], " ", 
   SubsuperscriptBox["M", "c3", "\[Dagger]"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"+\"\>"], 
    RowBox[{"s1", ",", "s2"}]], " ", 
   SubscriptBox[
    TemplateBox[{"y","ud","R"},
     "Subsuperscript"], 
    RowBox[{"3", ",", "3"}]]}], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["X", "\<\"-\"\>"], 
      RowBox[{"i$753", ",", "i1$755"}]], ".", 
     SubscriptBox["X", 
      RowBox[{"j$753", ",", "i1$755"}]]}], " ", 
    TemplateBox[{SubscriptBox["\[Gamma]", 
       RowBox[{"i$753", ",", "j$753"}]],"mu"},
     "Superscript"], " ", 
    SubscriptBox["Z", "mu"]}], 
   RowBox[{"3", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
     SubsuperscriptBox["M", "c1", "\[Dagger]"], "]"}], " ", 
    SubscriptBox["M", "c1"], " ", 
    SubscriptBox["Z", "mu"]}], 
   RowBox[{"3", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "e", " ", 
    SubscriptBox["s", "w"], " ", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
     SubscriptBox["M", "c1"], "]"}], " ", 
    SubsuperscriptBox["M", "c1", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu"]}], 
   RowBox[{"3", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["e", "2"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["A", "mu"], " ", 
    SubscriptBox["M", "c1"], " ", 
    SubsuperscriptBox["M", "c1", "\[Dagger]"], " ", 
    SubscriptBox["Z", "mu"]}], 
   RowBox[{"9", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu", ",", "a$735"}]], " ", 
    SubscriptBox["M", "c1"], " ", 
    SubsuperscriptBox["M", "i$735", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"i$735", ",", "c1"}], "a$735"], " ", 
    SubscriptBox["Z", "mu"]}], 
   RowBox[{"3", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["g", "s"], " ", 
    SubscriptBox["s", "w"], " ", 
    SubscriptBox["G", 
     RowBox[{"mu", ",", "a$736"}]], " ", 
    SubscriptBox["M", "i$736"], " ", 
    SubsuperscriptBox["M", "c1", "\[Dagger]"], " ", 
    SubsuperscriptBox["T", 
     RowBox[{"c1", ",", "i$736"}], "a$736"], " ", 
    SubscriptBox["Z", "mu"]}], 
   RowBox[{"3", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SubsuperscriptBox["s", "w", "2"], " ", 
    SubscriptBox["M", "c1"], " ", 
    SubsuperscriptBox["M", "c1", "\[Dagger]"], " ", 
    SubsuperscriptBox["Z", "mu", "2"]}], 
   RowBox[{"9", " ", 
    SubsuperscriptBox["c", "w", "2"]}]]}]], "Output",
 CellChangeTimes->{3.6551021914346323`*^9, 3.6551023195337563`*^9, 
  3.6551023818442583`*^9, 3.655102933730535*^9, 3.655104724030767*^9, 
  3.655197993959311*^9, 3.655556277917386*^9, 3.655556668541196*^9, 
  3.655617498991755*^9, 3.65561932885756*^9, 3.655630680974527*^9, 
  3.6558121517338333`*^9, 3.655812254287847*^9, 3.6558122869067783`*^9, 
  3.6558126493413363`*^9, 3.6558129215049973`*^9, 3.655812989778638*^9, 
  3.6558160736110907`*^9, 3.6646228812832747`*^9, 3.664787393035345*^9, 
  3.665472648437392*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Vertices", "Subsection",
 CellChangeTimes->{{3.634887278373604*^9, 3.634887279656496*^9}, {
  3.655715914718471*^9, 3.65571591631217*^9}, {3.656054770832323*^9, 
  3.65605477254349*^9}, {3.6573430377300158`*^9, 3.657343038941719*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Calculate", " ", "the", " ", "Feynman", " ", "rules", " ", "for", " ", 
    "the", " ", "vertices", " ", "in", " ", "LSM"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Unprotect", "[", "verticesSM", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", "verticesSM", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"verticesSM", "=", 
     RowBox[{"FeynmanRules", "[", 
      RowBox[{"LSM", ",", 
       RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Protect", "[", "verticesSM", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.63514608024297*^9, 3.635146091846805*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxVsoA1AYAOCRtJFoos0kkxaxWrGxue1sSshkG0nbzOySCFkiEVvLXhRS
KLeSB4UUoglPLHN7sYZCQ2k5kVvNJpf/PHx9bF2b3BBCoVAEQOV5Wu2Lw4i+
6xJZ4LRPQYQNfrPeNZLdVxd2MgeZmIOwod3LssP3Af78Ijw8Ze5agsPLhU4y
L8R0TR6XJBsYmRiJ7XOLZKWi+IC8z6xTM2FJOkWQAJt+paUsWGP0a8m2ElmF
Hm71u8eNcFAcXJmEu5ept1lcjFweX2Q27Hn1ppOPbnrk5NBjei+ZwcwY4cOZ
lqpYAfwT5w8rhGfZnzlqeKjmu8AA75m3NshPZxEzDjhJ+M7ahp2pqUfky+n4
Z7Kb00R38DAaKPtrGRNh9DLXYWzKw2hC96HLyccoUZbQoIV3TqIOm+EYl+zV
B6es0f40BRit37RS3UUYKfy+xnMxRrr+bVqVBCN957yUK4Vt1oXNCox+E88C
4TKMLF+K0epKjN7rc5W18M5ppIkc/aB9VMH/hezMsg==
  "]],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxVsoA1AYAOBNWjYpTWS2ZJLIlGKbjbGzKSETm0saZnZJhCyRiK1lLwop
lMtKHlZIISI8sWwuL9ZQCA9aO5FbzSaX/zx8fVxtZ5WeSqFQBEDt9a8NxmLE
3HeJzXDap4Bhhd8sDy1kz/WljZyKjKwRWN91z7bBj0H+ogMemzX1LsO0MpGT
nEU13pCnZEn6eB5GUpvdQVYpi47Ih6z6BhYsS6cIEmDjr7yEDTcaAhqytVhR
roM7Ap4pAxyShlZn4L6ViLvsTIxcXl9kDux9vU8nu2/7q8hhJ8wBcjwrY5wP
88yVMQL4JzYQXgAvcD+FDfBozbdEDx+YtjfJ/nPG/A6cKHpn78LOlBQ3+Wou
7pnsSW1l7mRhNFz61z4pxujF3m1ozcNoWvuhFeZjxFEkNGvgvdOo4zY42qV4
9cHJ6/S/RglGG7cdEZ5CjJQBX8uFFCPt0C69UoaRrmdRnimHrZalrXKMfjnn
QZoCI/OXcqK6AqP3plxVHbx3Fmkk1/o1T2r4H4hdzQE=
  "]],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxVsow1EcAOCRhKU0kW2SSYtstZpt7nY2JWSajaSN2WxLhEgkYlr2opBC
uZU8KKQQTeMJ2VxerKHQeNByIkb9mWx+5+Hr4+g7qo1hNBpNDDSel83BBIwY
B848C5zxJY6xwh8jjway+/baRuYiM3MUNnZ62Tb46Ue0vAqPz3X3rsGRFbkn
ZEGY+Y48LUs1JvEwktqWVslqVckx+YhZr2XCskyamAWbg/IyNtxgonRka6mi
shlup9zTJjggDWzMwn3rUQ9CPkZOj4+eDXvevZlk131/NTn8jDFATmJmTYhg
nkUZL4b/EqiIIniR8yXRwmO1v4VG+LB7b4f8chmzYIdTcv3sffgkPd1FvplP
fCW7uS0MuwCj4fJQ21QeRm9LXaaWfIxm9J96SQFGyQpWkw52nMeetsJxTsW7
D07big41FGK0fd8e5S7GSEX5DFdSjPRD+9FKGUbNPctyvhy2jqzsVmIUTL78
iVRgZPlWTdZUYeRvzFHXwY4Lupks5NqfNfA/g/fMcg==
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "98", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{16., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "98", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  98, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 98, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxVsoA1AYAOBNWrOlNE2bSSYtQq3YMMbOpoRMDEnMjG0tQqRJxNayF4XU
KJeVPCikEFnIAzK3F2soEx60diKX1Vwy/vPw9fG1HZU6KoVCEYN6j391gI0R
a9clMcPJATHDCr9ZHprJ7psrG1mADNxhWNd5z7PBj1+i+UV4dLrbtATTSnOO
yEKq4ZZslyfoOGkYyWyORXKVqvCQfMCta+DC8hSKOBY2hBTFPFitD2rI1iJl
WQvcHnTb9fC37HtlCu5dpt9lpGPk8viYmbDn9T6FfOLtqySHnbL6yRxu6pgI
TjNXRIvhX3YwPB+e4weyGuCRmh+pDt7r3tog+y8Ys9twfM47zwkfJSWdkK9n
Yp7JboGRtS3EaKjkr21CgtGLo0tvzMVoUvuhzcrDKE4Z26SBd84ij1vhKJfy
1QcnrkX8qaUYrXvb6e4CjFRBX/OlDCPtoDOiQo5RS8+8Il0BWy0Lm2UYheIu
vmhKjMyfqvHqcozeG7OrauGdc6aBvG9yPtXD/4qczVE=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"93", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[93, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxVsoA1AYAOBNLLOUJtotIYlQio2NsbMpIRNDEsOuiZAlErG17EUhhWKU
PCikEFnjiWVzebGGMo0Xy4ncakzMfx6+viRVd42WSqFQBKDJ87Q5HIcR88Ap
MsJpn4IoM/xmuleT3TdXFnIq0rPHYG2Pj2uBH775y6vwxLyhfw2mVQgd5Gyq
/pY8I03UsjIxkliWVsm1ipJj8hG7sZkNS9MpAg6s/5OVcWGlLtBKNpfKKzVw
V8A9o4ODkuDGHDywHnmXk4WR0+Nn5MKeV1862eUdrCGHnTKHyCx2xiQfzjRW
xwrg37hAeBG8mPSZ1wyP1/+ItfChYW+H/HQRZd2HE4TvXBvsSElxka8X4p/J
7tR25n42RqPloc5pEUYvS7269gKMZlUfqrxCjHhyTlsrbD+LPumAY5zyVz+c
vEUPKcUYbXu7It3FGCkCfvWlBCPViI1eLcVI07csy5LBZtPKbiVGf7yLb5oc
I+OXYqquCqP3lvzaBth+ztCTG60Rj03wP4Q9zF0=
  "]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Calculate", " ", "the", " ", "Feynman", " ", "rules", " ", "for", " ", 
    "the", " ", "vertices", " ", "in", " ", "LRM"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Unprotect", "[", "verticesRM", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", "verticesRM", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"verticesRM", "=", 
     RowBox[{"FeynmanRules", "[", 
      RowBox[{"LRM", ",", 
       RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Protect", "[", "verticesRM", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.63488730159483*^9, 3.634887337694689*^9}, {
  3.6348873868673763`*^9, 3.634887402192567*^9}, {3.64715258923396*^9, 
  3.647152617038875*^9}, {3.647851752819191*^9, 3.647851765395403*^9}, {
  3.654589277185772*^9, 3.6545892919498*^9}, {3.655533407895679*^9, 
  3.6555334079781723`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0FkoRGEYxvGxJGsNLpBcTCNKiRQp6zeEKQ6mccGFZTCmbImoIXsYFJI1
ZZ1kjXBClsnYcyEmlCgi8slSkxg5x/tePP1un/4iRbEs10wgEITDtlLXudZQ
Sqyy9co2ML/Wphvd16sX0DdNyQcqyVK5toM1N56+6Fe4cR5VT0s3UWOh8gzt
tGyiHeBsRt3REuhetvKANlSeja+AMrOZDbTXZNCsgV6m471n0P/T+xItdZx8
Ql05i0/Uuvr1Fz1kdOIX0OlblIPeac9L0HQj5dD4fmc/CnLK4D50Ipfy6WGU
FKUyDxlgRUjYbhaoX898RJsc7OIUoO1+kFs2qNIND62C7WMOGzfgFWe5fAue
rAbYGCIoMUkWc84jKblgPWJ/wQNzoegPHImO3OHBVsOkzovAj45m22QJ9COB
73JwWz4qVYOng/cMyrSwjhNgff1w+RTICsdm5sEYVryJKk4uT9G2qq1r9IkP
0oiiKBkaHFhDffL6pWJQNieU+4BFjapoX9ClNO0nCXzntS7JoD2J1bIJlBQM
jJisGErKe/iulERK/gGYXQKN
  "]],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0H8o3HEcx/HzI/lZx/5Ayx/XLUrJUqSM+RyNK77muv3BH34czpWNRFsd
bfMjcyiWmh9Tfl7CpgnfEHbt5tfyh7hQsiKyfMTUtezk+/V6//Hq8e+rp8pQ
oStxUygUSdhyzoLU8oQzryK7sRWWvffpJFft5m/kpaXyL6kpNIW0wXeHj6LI
f0nOSdI8rl0ina+M22SHZxNvh1/y6zam4cPq2ROyoWZ7eBbq3CYWyU8uh2Ue
hrt+rfyBj68j9siqwNEzMkTyuCa9317ckuuCTX0Og25UxeSRdaeSzHNyiczo
fhDNoWSM7yJHSricl8hZeY5wkg/fJCT+LIT2hYJTsinAL90AfVfjQougydbf
NwfbhgIWD+G+5DnzG27Oxfg4nnLm0kwV7yRztiuGpd3CNXel6g4OpCb/kGGL
Y9QWzvCj/YNvtgb9WOyVHn7XD2rNcKv3WCCFZjFwBNbX978eg6JyaGISPhPV
S6Rhc2+LbK1dPiDP5DiLKoWzvt6eeTKytFurhrqvSn0kLG80pUbB4Krc/8/h
lWwNzob+LM0qZnL2smfA5SWgx2f544sszu4BmfcCwQ==
  "]],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0Fsog3EcxvE5JKfVcIHkYk2UEilSjv8RVrxYc8GFwzArp0TUyDkMRZRT
CmPJMcIbcljmnAuxUCJE5C+HWmLyzu938fS5ffoK5SXSPAsejxcB20xb49rC
KLHJ0SvawYI6ux50T6+aR9/UpR+oOFvp1gHWXnv5oV8RxjlUNSXZQI1FilO0
y7qZdoIzmfWHi6BH+fID2lh1OrYMSi2m19Fek0G9CnqbjnafwYBPnwu0zGni
CXXjrD5R25rXX/SA0YleQOdvYS56pz0rRTOMlEMT+l38KcgpQvrQ8Txqzgin
pDiNecgEK0PDd7JB/VrWI9rMd4iXg/Z7we45oFI3PLQCdmj469fgJWe9dAMe
rwTaGSIpMYkXcs+iKDlnPeN+wX1LgfAPHImJ2jaDbYYJnTeBH50t9ili6EeC
3mXglmxUogJPBu8ZlGllncbBhobhikmQFWim58BYVrSByo8vTtD26s0r9Mkc
rBZGUzI0OLCK+ub3S0SgdFYg8wWLm5QxfqBrWfpPMvhu1rqmgI4kTssmUlI4
MGKyYSjR3PK7U5Mo+QeWIwIT
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "16", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{8., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "16", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  16, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 16, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0G8o3HEcB/Az0jA584C19uA6nVIiNSl/vzfNrvjhOg944M/hXDESbXUT
w7IdyqL8S/l7yd8IvxB27fzPA3GNWlZbZO0rf+oSJ7/b+/Pg3evp+/1W6Mu1
RW4ymSweWc1akppiOfMssBmaYclHr3Zyw2aaJi/MFVekOt8Y1AJrj4PDyJt4
xxRpGtOskI63hn3yq0cjb4UTuXXbs/B51fwJ2fBhf2geat3Gl8kOp928CFXO
nfW/MOI65JCs9B85I4Mk92vycc35PbklWJX/4NNbRSH523JQQeY4uESmdAWE
cygZojvJ4SLuyonjrCxLOMmF72Pi1vKhbSnvlGz09Xmjh94bUc8KoNHa17sA
WwZ9l4/hkeQx9wvuLkR62RM4c6pnCg8SOfshvki+h5uP5IoH2J+U+N0Fm+wj
VhVDj9bP3hlq/MdeXurgN92AxgT3ev4IpPBF9B+G9fV970ahKB8cn4KvReUK
qd893CObq1d/kmeuKLPiFWe9Pd2LZGhxl0YJtZNyXSgs+2RMCoOBldl36fDS
ZQnMgE9YskVM5ay0u9/pKWCHyq8tM42z/5JpAYU=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"16", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[16, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwV0Gkow3Ecx/E5kjlqeIDkwZooJVKWcv5GWPHHmgc8cAyzciWiRu4wFFGu
lHPJGeGfybHMnQdioUQRkZ8ctcTkP9/vg0+vp5/eQkWpLN+Kx+NFwrbS17n2
cErscg3KDrCwnt+L7hvUi+ibpuwDleSoPDrBuhufAPQr0rSAqmekm6ipWHmG
dtu20C5wLqvhaBn0qlh9QJuqzyZWQZnV7AbaZzZqdKCv+XjvGQz69LtEy12m
nlAPzuYTta99/UUPGb3oBXT9Fuahd9rzMjTTRDk0ccAtkIKcMrQfncynlswI
SkrSmYcssCosYjcHNKxnP6Itzo4JCtBhX+yZC6r0I8NrYOe488YNeMXZrtyC
J2vBfGMUJWbJUt55NCUXrHf8L3hgLRD+gaOx0TsWsN04pfcl8KOr1SFVAv1I
yLsc3JaPSdXg6dA9gzJtrMsk2Ng4UjkNsoLx2QUwjhVtooqTy1O0o2brGn2y
iDXCGEqGhwZ1qH/BgFQEyuYFcn+wpFkVGwC6l2f8pIDvFq17KuhE4rVsEiVF
g6NmO4aSSurZk5ZMyT+VWAH+
  "]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", "verticesRM", "]"}], "//", "Grid"}]], "Input",
 CellChangeTimes->{{3.634974029798752*^9, 3.6349740308702307`*^9}, {
   3.6351404638971977`*^9, 3.635140498097554*^9}, {3.6351419493699903`*^9, 
   3.635141993301669*^9}, {3.647152608065353*^9, 3.647152608362949*^9}, 
   3.647851768057683*^9, 3.6545892971068287`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["X", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"X", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "3"]}], " ", "\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]],SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}]]}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"M", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["M", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "3"]}], " ", "\[ImaginaryI]", " ", "e", " ", 
      RowBox[{"(", 
       RowBox[{
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"]], "-", 
        SubsuperscriptBox["\<\"p\"\>", "3", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"]]}], ")"}], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "2"], ",", 
        SubscriptBox["\<\"m\"\>", "3"]}]]}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["X", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"DM", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"M", ",", "3"}], "}"}]}], "}"}], 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      SubscriptBox["y", "D"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "3"]}]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]]}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"DM", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"X", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["M", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      SubscriptBox["y", "D"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "2"], ",", 
        SubscriptBox["\<\"m\"\>", "3"]}]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]]}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"M", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["M", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], 
     RowBox[{
      FractionBox["2", "9"], " ", "\[ImaginaryI]", " ", 
      SuperscriptBox["e", "2"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "3"], ",", 
        SubscriptBox["\<\"m\"\>", "4"]}]], " ", 
      SubscriptBox["\[Eta]", 
       RowBox[{
        SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["X", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"X", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      TemplateBox[{SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]],SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "3"]]}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"M", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["M", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"]], "-", 
        SubsuperscriptBox["\<\"p\"\>", "3", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"]]}], ")"}], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "3"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "1"]]}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"M", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["M", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], 
     RowBox[{
      RowBox[{"-", 
       FractionBox["2", "3"]}], " ", "\[ImaginaryI]", " ", "e", " ", 
      SubscriptBox["g", "s"], " ", 
      SubscriptBox["\[Eta]", 
       RowBox[{
        SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "4"], ",", 
        SubscriptBox["\<\"m\"\>", "3"]}], 
       SubscriptBox["\<\"a\"\>", "2"]]}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"M", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["M", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], 
     RowBox[{"\[ImaginaryI]", " ", 
      SubsuperscriptBox["g", "s", "2"], " ", 
      SubscriptBox["\[Eta]", 
       RowBox[{
        SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "4"], ",", "Colour$1"}], 
          SubscriptBox["\<\"a\"\>", "1"]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{"Colour$1", ",", 
           SubscriptBox["\<\"m\"\>", "3"]}], 
          SubscriptBox["\<\"a\"\>", "2"]]}], "+", 
        RowBox[{
         SubsuperscriptBox["T", 
          RowBox[{"Colour$1", ",", 
           SubscriptBox["\<\"m\"\>", "3"]}], 
          SubscriptBox["\<\"a\"\>", "1"]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "4"], ",", "Colour$1"}], 
          SubscriptBox["\<\"a\"\>", "2"]]}]}], ")"}]}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["M", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["\[Epsilon]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"], ",", 
        SubscriptBox["\<\"m\"\>", "3"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"y","ud","L"},
           "Subsuperscript"], 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]]}], "+", 
        RowBox[{
         SubscriptBox[
          SubscriptBox["P", "\<\"+\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"y","ud","R"},
           "Subsuperscript"], 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]]}]}], ")"}]}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"dq", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"M", ",", "3"}], "}"}]}], "}"}], 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["\[Epsilon]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"], ",", 
        SubscriptBox["\<\"m\"\>", "3"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox[
          SubscriptBox["P", "\<\"+\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"y","ud","L"},
           "Subsuperscript"], 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]]}], "+", 
        RowBox[{
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"y","ud","R"},
           "Subsuperscript"], 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]]}]}], ")"}]}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["X", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"X", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["s", "w"], " ", 
       TemplateBox[{SubscriptBox["\[Gamma]", 
          RowBox[{
            SubscriptBox["\"s\"", "1"], ",", 
            SubscriptBox["\"s\"", "2"]}]],SubscriptBox["\"\[Mu]\"", "3"]},
        "Superscript"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]]}], 
      RowBox[{"3", " ", 
       SubscriptBox["c", "w"]}]]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"M", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["M", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["s", "w"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox["\<\"p\"\>", "1", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], "-", 
         SubsuperscriptBox["\<\"p\"\>", "2", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], ")"}], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]]}], 
      RowBox[{"3", " ", 
       SubscriptBox["c", "w"]}]]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"M", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["M", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "2"], ",", 
          SubscriptBox["\<\"m\"\>", "3"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"9", " ", 
        SubscriptBox["c", "w"]}]]}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"M", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["M", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], 
     FractionBox[
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "3"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}], 
        SubscriptBox["\<\"a\"\>", "1"]]}], 
      RowBox[{"3", " ", 
       SubscriptBox["c", "w"]}]]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"M", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["M", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], 
     FractionBox[
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "w", "2"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"9", " ", 
       SubsuperscriptBox["c", "w", "2"]}]]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.6551022304833097`*^9, 3.655102234350469*^9}, 
   3.65510233860131*^9, 3.655102391460032*^9, 3.6551029135424833`*^9, 
   3.655102964924403*^9, 3.655104728317984*^9, 3.655104813928438*^9, 
   3.655105029793626*^9, 3.655105075287498*^9, 3.655446286041634*^9, 
   3.655449373903075*^9, 3.655449612663732*^9, 3.655533227577836*^9, 
   3.6555333312986593`*^9, 3.655533412617752*^9, 3.6555560523085747`*^9, 
   3.655556291025036*^9, 3.655556901251822*^9, 3.655617512591721*^9, 
   3.655619337522871*^9, {3.6556204261656017`*^9, 3.6556204301840887`*^9}, 
   3.655620474744467*^9, 3.655620599771541*^9, 3.6556214334004908`*^9, 
   3.655622022449513*^9, 3.65562253355896*^9, 3.6556228547099733`*^9, 
   3.655623019985259*^9, 3.655624343338215*^9, 3.655630686635502*^9, 
   3.655704142462492*^9, 3.655704360676942*^9, 3.6557079361241627`*^9, {
   3.655708130301948*^9, 3.655708135161607*^9}, 3.6557159240323887`*^9, 
   3.655812801555945*^9, 3.6558129327041893`*^9, 3.655813006081242*^9, 
   3.6558130930598392`*^9, 3.655813315957605*^9, 3.655815976553174*^9, 
   3.65581608349868*^9, 3.655817211540636*^9, 3.655817596639309*^9, {
   3.655818422761902*^9, 3.6558184289626637`*^9}, 3.656054786529993*^9, 
   3.6560566138084917`*^9, 3.6560604519396*^9, 3.65606071705588*^9, 
   3.6560615100439672`*^9, 3.656063181372514*^9, 3.656322327210442*^9, 
   3.657343052842894*^9, 3.6578660245875874`*^9, 3.657947708267151*^9, 
   3.657951498449732*^9, 3.657956884310305*^9, 3.6580367447517357`*^9, 
   3.658647639335425*^9, 3.6586556126665173`*^9, 3.6587321125678263`*^9, 
   3.658732153267976*^9, 3.658817681804722*^9, 3.658828726938612*^9, 
   3.658839393591278*^9, {3.6588395260567017`*^9, 3.658839532016695*^9}, 
   3.658839689861779*^9, 3.658839778247656*^9, 3.659074636792632*^9, 
   3.659075025291634*^9, 3.6590782226578693`*^9, 3.6590926425258017`*^9, 
   3.6590986625524073`*^9, 3.659171790002907*^9, 3.659172032185773*^9, 
   3.664622893284832*^9, 3.665472657059266*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Decay Widths", "Subsection",
 CellChangeTimes->{{3.634887352050088*^9, 3.634887354446849*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Calculate", " ", "the", " ", "decay", " ", "width", " ", "of", " ", "the",
     " ", "unstable", " ", "particles", " ", "in", " ", "LRM"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Unprotect", "[", "decaysRM", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", "decaysRM", "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"decaysRM", "=", 
     RowBox[{"ComputeWidths", "[", "verticesRM", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Protect", "[", "decaysRM", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.634887365329575*^9, 3.634887375269136*^9}, {
  3.6348874053259277`*^9, 3.634887441982473*^9}, {3.647152787033535*^9, 
  3.647152798731292*^9}, {3.647851785864225*^9, 3.647851797329191*^9}, {
  3.6545893015839977`*^9, 3.654589312100254*^9}, {3.6555334764500303`*^9, 
  3.655533476530281*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{16., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "16"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 16],
  Editable->False]], "Print",
 CellChangeTimes->{3.66478741636724*^9, 3.665472657478385*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.66478741636724*^9, 3.665472657674056*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{16., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "10"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 10],
  Editable->False]], "Print",
 CellChangeTimes->{3.66478741636724*^9, 3.665472657675715*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{"decaysRM", "/.", 
    RowBox[{"Abbreviations", "[", "]"}]}], "]"}], "//", "Grid"}]], "Input",
 CellChangeTimes->{{3.646997934911028*^9, 3.6469979404702463`*^9}, {
   3.647152804359887*^9, 3.647152804776997*^9}, 3.6478517911297493`*^9, 
   3.654589316302215*^9, {3.656064168107107*^9, 3.656064168511942*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"{", 
      RowBox[{"M", ",", "X", ",", 
       OverscriptBox["DM", "\<\"-\"\>"]}], "}"}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["M", "DM"], "-", 
          SubscriptBox["M", "M"], "+", 
          SubscriptBox["M", "X"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["M", "DM"], "+", 
          SubscriptBox["M", "M"], "+", 
          SubscriptBox["M", "X"]}], ")"}], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "DM"], "-", 
            SubscriptBox["M", "M"], "-", 
            SubscriptBox["M", "X"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "DM"], "+", 
            SubscriptBox["M", "M"], "-", 
            SubscriptBox["M", "X"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "DM"], "-", 
            SubscriptBox["M", "M"], "+", 
            SubscriptBox["M", "X"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "DM"], "+", 
            SubscriptBox["M", "M"], "+", 
            SubscriptBox["M", "X"]}], ")"}]}]], " ", 
        SubsuperscriptBox["y", "D", "2"]}], 
       RowBox[{"8", " ", "\[Pi]", " ", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          SubscriptBox["M", "M"], "]"}], "3"]}]]}]},
    {
     RowBox[{"{", 
      RowBox[{"DM", ",", 
       SuperscriptBox["M", "\[Dagger]"], ",", "X"}], "}"}], 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["M", "DM"], "-", 
         SubscriptBox["M", "M"], "+", 
         SubscriptBox["M", "X"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["M", "DM"], "+", 
         SubscriptBox["M", "M"], "+", 
         SubscriptBox["M", "X"]}], ")"}], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["M", "DM"], "-", 
           SubscriptBox["M", "M"], "-", 
           SubscriptBox["M", "X"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["M", "DM"], "+", 
           SubscriptBox["M", "M"], "-", 
           SubscriptBox["M", "X"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["M", "DM"], "-", 
           SubscriptBox["M", "M"], "+", 
           SubscriptBox["M", "X"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["M", "DM"], "+", 
           SubscriptBox["M", "M"], "+", 
           SubscriptBox["M", "X"]}], ")"}]}]], " ", 
       SubsuperscriptBox["y", "D", "2"]}], 
      RowBox[{"16", " ", "\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         SubscriptBox["M", "DM"], "]"}], "3"]}]]},
    {
     RowBox[{"{", 
      RowBox[{"DM", ",", "M", ",", 
       OverscriptBox["X", "\<\"-\"\>"]}], "}"}], 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["M", "DM"], "-", 
         SubscriptBox["M", "M"], "+", 
         SubscriptBox["M", "X"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["M", "DM"], "+", 
         SubscriptBox["M", "M"], "+", 
         SubscriptBox["M", "X"]}], ")"}], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["M", "DM"], "-", 
           SubscriptBox["M", "M"], "-", 
           SubscriptBox["M", "X"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["M", "DM"], "+", 
           SubscriptBox["M", "M"], "-", 
           SubscriptBox["M", "X"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["M", "DM"], "-", 
           SubscriptBox["M", "M"], "+", 
           SubscriptBox["M", "X"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["M", "DM"], "+", 
           SubscriptBox["M", "M"], "+", 
           SubscriptBox["M", "X"]}], ")"}]}]], " ", 
       SubsuperscriptBox["y", "D", "2"]}], 
      RowBox[{"16", " ", "\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         SubscriptBox["M", "DM"], "]"}], "3"]}]]},
    {
     RowBox[{"{", 
      RowBox[{"X", ",", "M", ",", 
       OverscriptBox["DM", "\<\"-\"\>"]}], "}"}], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["M", "DM"], "-", 
         SubscriptBox["M", "M"], "+", 
         SubscriptBox["M", "X"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["M", "DM"], "+", 
         SubscriptBox["M", "M"], "+", 
         SubscriptBox["M", "X"]}], ")"}], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["M", "DM"], "-", 
           SubscriptBox["M", "M"], "-", 
           SubscriptBox["M", "X"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["M", "DM"], "+", 
           SubscriptBox["M", "M"], "-", 
           SubscriptBox["M", "X"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["M", "DM"], "-", 
           SubscriptBox["M", "M"], "+", 
           SubscriptBox["M", "X"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["M", "DM"], "+", 
           SubscriptBox["M", "M"], "+", 
           SubscriptBox["M", "X"]}], ")"}]}]], " ", 
       SubsuperscriptBox["y", "D", "2"]}], 
      RowBox[{"16", " ", "\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         SubscriptBox["M", "X"], "]"}], "3"]}]]},
    {
     RowBox[{"{", 
      RowBox[{"M", ",", 
       OverscriptBox["d", "\<\"-\"\>"], ",", 
       OverscriptBox["u", "\<\"-\"\>"]}], "}"}], 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"MD", "-", 
           SubscriptBox["M", "M"], "-", "MU"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MD", "+", 
           SubscriptBox["M", "M"], "-", "MU"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MD", "-", 
           SubscriptBox["M", "M"], "+", "MU"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MD", "+", 
           SubscriptBox["M", "M"], "+", "MU"}], ")"}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", "MD", " ", "MU", " ", "yudL1x1", " ", 
          "yudR1x1"}], "-", 
         RowBox[{
          SuperscriptBox["MD", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["yudL1x1", "2"], "+", 
            SuperscriptBox["yudR1x1", "2"]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "M"], "-", "MU"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "M"], "+", "MU"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["yudL1x1", "2"], "+", 
            SuperscriptBox["yudR1x1", "2"]}], ")"}]}]}], ")"}]}], 
      RowBox[{"8", " ", "\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         SubscriptBox["M", "M"], "]"}], "3"]}]]},
    {
     RowBox[{"{", 
      RowBox[{"d", ",", 
       SuperscriptBox["M", "\[Dagger]"], ",", 
       OverscriptBox["u", "\<\"-\"\>"]}], "}"}], 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"MD", "-", 
           SubscriptBox["M", "M"], "-", "MU"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MD", "+", 
           SubscriptBox["M", "M"], "-", "MU"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MD", "-", 
           SubscriptBox["M", "M"], "+", "MU"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MD", "+", 
           SubscriptBox["M", "M"], "+", "MU"}], ")"}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "MD", " ", "MU", " ", "yudL1x1", " ", "yudR1x1"}], 
         "+", 
         RowBox[{
          SuperscriptBox["MD", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["yudL1x1", "2"], "+", 
            SuperscriptBox["yudR1x1", "2"]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "M"], "-", "MU"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "M"], "+", "MU"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["yudL1x1", "2"], "+", 
            SuperscriptBox["yudR1x1", "2"]}], ")"}]}]}], ")"}]}], 
      RowBox[{"16", " ", "\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", "MD", "]"}], "3"]}]]},
    {
     RowBox[{"{", 
      RowBox[{"u", ",", 
       SuperscriptBox["M", "\[Dagger]"], ",", 
       OverscriptBox["d", "\<\"-\"\>"]}], "}"}], 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"MD", "-", 
           SubscriptBox["M", "M"], "-", "MU"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MD", "+", 
           SubscriptBox["M", "M"], "-", "MU"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MD", "-", 
           SubscriptBox["M", "M"], "+", "MU"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MD", "+", 
           SubscriptBox["M", "M"], "+", "MU"}], ")"}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "MD", " ", "MU", " ", "yudL1x1", " ", "yudR1x1"}], 
         "+", 
         RowBox[{
          SuperscriptBox["MD", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["yudL1x1", "2"], "+", 
            SuperscriptBox["yudR1x1", "2"]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "M"], "-", "MU"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "M"], "+", "MU"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["yudL1x1", "2"], "+", 
            SuperscriptBox["yudR1x1", "2"]}], ")"}]}]}], ")"}]}], 
      RowBox[{"16", " ", "\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", "MU", "]"}], "3"]}]]},
    {
     RowBox[{"{", 
      RowBox[{"M", ",", 
       OverscriptBox["s", "\<\"-\"\>"], ",", 
       OverscriptBox["c", "\<\"-\"\>"]}], "}"}], 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"MC", "-", 
           SubscriptBox["M", "M"], "-", "MS"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MC", "+", 
           SubscriptBox["M", "M"], "-", "MS"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MC", "-", 
           SubscriptBox["M", "M"], "+", "MS"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MC", "+", 
           SubscriptBox["M", "M"], "+", "MS"}], ")"}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", "MC", " ", "MS", " ", "yudL2x2", " ", 
          "yudR2x2"}], "-", 
         RowBox[{
          SuperscriptBox["MC", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["yudL2x2", "2"], "+", 
            SuperscriptBox["yudR2x2", "2"]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "M"], "-", "MS"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "M"], "+", "MS"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["yudL2x2", "2"], "+", 
            SuperscriptBox["yudR2x2", "2"]}], ")"}]}]}], ")"}]}], 
      RowBox[{"8", " ", "\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         SubscriptBox["M", "M"], "]"}], "3"]}]]},
    {
     RowBox[{"{", 
      RowBox[{"s", ",", 
       SuperscriptBox["M", "\[Dagger]"], ",", 
       OverscriptBox["c", "\<\"-\"\>"]}], "}"}], 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"MC", "-", 
           SubscriptBox["M", "M"], "-", "MS"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MC", "+", 
           SubscriptBox["M", "M"], "-", "MS"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MC", "-", 
           SubscriptBox["M", "M"], "+", "MS"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MC", "+", 
           SubscriptBox["M", "M"], "+", "MS"}], ")"}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "MC", " ", "MS", " ", "yudL2x2", " ", "yudR2x2"}], 
         "+", 
         RowBox[{
          SuperscriptBox["MC", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["yudL2x2", "2"], "+", 
            SuperscriptBox["yudR2x2", "2"]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "M"], "-", "MS"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "M"], "+", "MS"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["yudL2x2", "2"], "+", 
            SuperscriptBox["yudR2x2", "2"]}], ")"}]}]}], ")"}]}], 
      RowBox[{"16", " ", "\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", "MS", "]"}], "3"]}]]},
    {
     RowBox[{"{", 
      RowBox[{"c", ",", 
       SuperscriptBox["M", "\[Dagger]"], ",", 
       OverscriptBox["s", "\<\"-\"\>"]}], "}"}], 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"MC", "-", 
           SubscriptBox["M", "M"], "-", "MS"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MC", "+", 
           SubscriptBox["M", "M"], "-", "MS"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MC", "-", 
           SubscriptBox["M", "M"], "+", "MS"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MC", "+", 
           SubscriptBox["M", "M"], "+", "MS"}], ")"}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "MC", " ", "MS", " ", "yudL2x2", " ", "yudR2x2"}], 
         "+", 
         RowBox[{
          SuperscriptBox["MC", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["yudL2x2", "2"], "+", 
            SuperscriptBox["yudR2x2", "2"]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "M"], "-", "MS"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "M"], "+", "MS"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["yudL2x2", "2"], "+", 
            SuperscriptBox["yudR2x2", "2"]}], ")"}]}]}], ")"}]}], 
      RowBox[{"16", " ", "\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", "MC", "]"}], "3"]}]]},
    {
     RowBox[{"{", 
      RowBox[{"M", ",", 
       OverscriptBox["b", "\<\"-\"\>"], ",", 
       OverscriptBox["t", "\<\"-\"\>"]}], "}"}], 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"MB", "-", 
           SubscriptBox["M", "M"], "-", "MT"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MB", "+", 
           SubscriptBox["M", "M"], "-", "MT"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MB", "-", 
           SubscriptBox["M", "M"], "+", "MT"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MB", "+", 
           SubscriptBox["M", "M"], "+", "MT"}], ")"}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", "MB", " ", "MT", " ", "yudL3x3", " ", 
          "yudR3x3"}], "-", 
         RowBox[{
          SuperscriptBox["MB", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["yudL3x3", "2"], "+", 
            SuperscriptBox["yudR3x3", "2"]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "M"], "-", "MT"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "M"], "+", "MT"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["yudL3x3", "2"], "+", 
            SuperscriptBox["yudR3x3", "2"]}], ")"}]}]}], ")"}]}], 
      RowBox[{"8", " ", "\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         SubscriptBox["M", "M"], "]"}], "3"]}]]},
    {
     RowBox[{"{", 
      RowBox[{"b", ",", 
       SuperscriptBox["M", "\[Dagger]"], ",", 
       OverscriptBox["t", "\<\"-\"\>"]}], "}"}], 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"MB", "-", 
           SubscriptBox["M", "M"], "-", "MT"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MB", "+", 
           SubscriptBox["M", "M"], "-", "MT"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MB", "-", 
           SubscriptBox["M", "M"], "+", "MT"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MB", "+", 
           SubscriptBox["M", "M"], "+", "MT"}], ")"}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "MB", " ", "MT", " ", "yudL3x3", " ", "yudR3x3"}], 
         "+", 
         RowBox[{
          SuperscriptBox["MB", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["yudL3x3", "2"], "+", 
            SuperscriptBox["yudR3x3", "2"]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "M"], "-", "MT"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "M"], "+", "MT"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["yudL3x3", "2"], "+", 
            SuperscriptBox["yudR3x3", "2"]}], ")"}]}]}], ")"}]}], 
      RowBox[{"16", " ", "\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", "MB", "]"}], "3"]}]]},
    {
     RowBox[{"{", 
      RowBox[{"t", ",", 
       SuperscriptBox["M", "\[Dagger]"], ",", 
       OverscriptBox["b", "\<\"-\"\>"]}], "}"}], 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"MB", "-", 
           SubscriptBox["M", "M"], "-", "MT"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MB", "+", 
           SubscriptBox["M", "M"], "-", "MT"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MB", "-", 
           SubscriptBox["M", "M"], "+", "MT"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"MB", "+", 
           SubscriptBox["M", "M"], "+", "MT"}], ")"}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "MB", " ", "MT", " ", "yudL3x3", " ", "yudR3x3"}], 
         "+", 
         RowBox[{
          SuperscriptBox["MB", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["yudL3x3", "2"], "+", 
            SuperscriptBox["yudR3x3", "2"]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "M"], "-", "MT"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["M", "M"], "+", "MT"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["yudL3x3", "2"], "+", 
            SuperscriptBox["yudR3x3", "2"]}], ")"}]}]}], ")"}]}], 
      RowBox[{"16", " ", "\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", "MT", "]"}], "3"]}]]},
    {
     RowBox[{"{", 
      RowBox[{"Z", ",", "X", ",", 
       OverscriptBox["X", "\<\"-\"\>"]}], "}"}], 
     FractionBox[
      RowBox[{
       SuperscriptBox["e", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubsuperscriptBox["M", "X", "2"]}], "+", 
         SuperscriptBox["MZ", "2"]}], ")"}], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SubsuperscriptBox["M", "X", "2"], " ", 
          SuperscriptBox["MZ", "2"]}], "+", 
         SuperscriptBox["MZ", "4"]}]], " ", 
       SubsuperscriptBox["s", "w", "2"]}], 
      RowBox[{"36", " ", 
       SubsuperscriptBox["c", "w", "2"], " ", "\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", "MZ", "]"}], "3"]}]]},
    {
     RowBox[{"{", 
      RowBox[{"Z", ",", 
       SuperscriptBox["M", "\[Dagger]"], ",", "M"}], "}"}], 
     FractionBox[
      RowBox[{
       SuperscriptBox["e", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SubsuperscriptBox["M", "M", "2"]}], "+", 
         SuperscriptBox["MZ", "2"]}], ")"}], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SubsuperscriptBox["M", "M", "2"], " ", 
          SuperscriptBox["MZ", "2"]}], "+", 
         SuperscriptBox["MZ", "4"]}]], " ", 
       SubsuperscriptBox["s", "w", "2"]}], 
      RowBox[{"144", " ", 
       SubsuperscriptBox["c", "w", "2"], " ", "\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", "MZ", "]"}], "3"]}]]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.6469979466420183`*^9, 3.6469981615787582`*^9, 3.6469993310647793`*^9, 
   3.647152882610259*^9, 3.647157468086732*^9, 3.647260105830471*^9, 
   3.647662591398302*^9, 3.647679972943307*^9, 3.647851814441338*^9, 
   3.647852793850731*^9, 3.647854185699677*^9, 3.647854464993498*^9, 
   3.6494235325451727`*^9, 3.654589317327335*^9, 3.655446290740034*^9, 
   3.65544937614914*^9, 3.655449618184126*^9, 3.655533482302704*^9, 
   3.655556315390766*^9, 3.655556778118195*^9, 3.655619361735424*^9, 
   3.655624353316327*^9, 3.655704149426552*^9, 3.6557043671362247`*^9, 
   3.6557079537536573`*^9, 3.65570814877055*^9, {3.655715932822236*^9, 
   3.655715941331767*^9}, 3.656054768778968*^9, 3.6560548099234867`*^9, 
   3.6560566676161947`*^9, 3.65606153851024*^9, 3.656063200979767*^9, 
   3.656064181238352*^9, 3.6579477426667128`*^9, 3.659092649291644*^9, 
   3.664708016083547*^9, 3.66470877363202*^9, 3.664787424156801*^9, 
   3.665472661112625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Update", " ", "numerical", " ", "value", " ", "of", " ", "the", " ", 
    "decay", " ", "widths", " ", "for", " ", "exporting"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"UpdateWidths", "[", "decaysRM", "]"}], ";"}]}]], "Input",
 CellChangeTimes->{{3.6348874498942823`*^9, 3.6348874791110573`*^9}, {
   3.647152887128039*^9, 3.647152887501431*^9}, {3.647851791858705*^9, 
   3.647851794155671*^9}, 3.654589320646587*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WM\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"1.35511\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  
  SequenceForm["WM", " = ", "1.35511", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.655446300839047*^9, 3.65544939144866*^9, 
  3.655533486827869*^9, 3.655556328472986*^9, 3.6556193619270144`*^9, 
  3.655624369988203*^9, 3.664708016363504*^9, 3.6647087329903717`*^9, 
  3.665472661252338*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WT\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"0.\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["WT", " = ", "0.", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.655446300839047*^9, 3.65544939144866*^9, 
  3.655533486827869*^9, 3.655556328472986*^9, 3.6556193619270144`*^9, 
  3.655624369988203*^9, 3.664708016363504*^9, 3.6647087329903717`*^9, 
  3.6654726612533503`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WX\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"0.\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["WX", " = ", "0.", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.655446300839047*^9, 3.65544939144866*^9, 
  3.655533486827869*^9, 3.655556328472986*^9, 3.6556193619270144`*^9, 
  3.655624369988203*^9, 3.664708016363504*^9, 3.6647087329903717`*^9, 
  3.665472661254203*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WZ\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"0.\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["WZ", " = ", "0.", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.655446300839047*^9, 3.65544939144866*^9, 
  3.655533486827869*^9, 3.655556328472986*^9, 3.6556193619270144`*^9, 
  3.655624369988203*^9, 3.664708016363504*^9, 3.6647087329903717`*^9, 
  3.665472661255*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Model Checks", "Section",
 CellChangeTimes->{{3.567840472517931*^9, 3.567840476915874*^9}, 
   3.569143886101358*^9, {3.569144637753002*^9, 3.569144639920857*^9}}],

Cell[CellGroupData[{

Cell["FeynRules", "Subsection",
 CellChangeTimes->{{3.635147235628291*^9, 3.6351472373202047`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ckHermiticity", "=", 
  RowBox[{"CheckHermiticity", "[", "LRM", "]"}]}]], "Input",
 CellChangeTimes->{{3.591533262999765*^9, 3.5915332787035627`*^9}, {
  3.647152900383806*^9, 3.647152900901503*^9}, {3.6478520536726017`*^9, 
  3.647852054190529*^9}, {3.654589354949257*^9, 3.654589356248331*^9}, {
  3.6555574429753838`*^9, 3.655557470020114*^9}, {3.665472726507923*^9, 
  3.665472728359558*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{{3.591533273004673*^9, 3.5915332856951637`*^9}, 
   3.591533561655061*^9, 3.633869848888072*^9, 3.634536999318646*^9, 
   3.634539531887285*^9, 3.6346202051419573`*^9, 3.6346230581832943`*^9, 
   3.634888828137855*^9, 3.647152901500868*^9, 3.6471567895433083`*^9, 
   3.647662595597868*^9, 3.6476799741364717`*^9, {3.647852048006851*^9, 
   3.6478520645292883`*^9}, 3.647852795593541*^9, 3.647854186856101*^9, 
   3.647854466357691*^9, 3.654589356822373*^9, 3.655028378750617*^9, 
   3.655028577246876*^9, 3.655037583423194*^9, 3.655102973076272*^9, 
   3.65544634545502*^9, 3.655449414238866*^9, 3.655449622293036*^9, 
   3.655462476706792*^9, 3.6555335086337976`*^9, 3.6555344834779673`*^9, 
   3.655534911524283*^9, 3.655556059471313*^9, 3.655556781596931*^9, 
   3.655556869117268*^9, 3.655557349804068*^9, 3.655557392918631*^9, {
   3.6555574525248623`*^9, 3.6555574822659388`*^9}, 3.655557986823586*^9, 
   3.6556175555437813`*^9, 3.65561936292833*^9, 3.655620488496245*^9, {
   3.6556209160926037`*^9, 3.655620918116496*^9}, 3.655621082613207*^9, 
   3.655622543335374*^9, 3.655623028474568*^9, 3.65562396054049*^9, 
   3.655624374749901*^9, 3.65563076308259*^9, 3.655708004668676*^9, {
   3.655708152368512*^9, 3.655708158848946*^9}, 3.65571580176877*^9, 
   3.6557980132932568`*^9, 3.655812076596881*^9, 3.6558122892667093`*^9, 
   3.65581258633183*^9, 3.6558159868414507`*^9, 3.6558160875957813`*^9, 
   3.6558170368488903`*^9, 3.65581721571278*^9, 3.6558184368726788`*^9, 
   3.6560547321601677`*^9, 3.656061473063294*^9, 3.656159607713993*^9, 
   3.656236581512001*^9, 3.65702360853976*^9, 3.6570239302869473`*^9, 
   3.657024187587659*^9, 3.6570242710993834`*^9, 3.65727292298584*^9, 
   3.658647644315083*^9, 3.6588393570778503`*^9, {3.658839700141542*^9, 
   3.6588397047397747`*^9}, 3.659073734002513*^9, 3.659073877167561*^9, 
   3.6590741596853533`*^9, 3.6590750413569508`*^9, 3.664617208834557*^9, 
   3.664617517513187*^9, 3.664786745817892*^9, 3.664787148926609*^9, 
   3.664787443494069*^9, 3.6647883023338823`*^9, 3.665472711170321*^9, 
   3.665472989261056*^9, 3.6654730601892242`*^9, 3.665474650135085*^9, 
   3.665474697385952*^9, 3.665474802983583*^9, 3.665474882146521*^9, 
   3.665474984519306*^9, 3.665478245171199*^9, 3.665478571393928*^9, 
   3.665486659345977*^9, {3.665486801678507*^9, 3.665486815691154*^9}}],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{{3.591533273004673*^9, 3.5915332856951637`*^9}, 
   3.591533561655061*^9, 3.633869848888072*^9, 3.634536999318646*^9, 
   3.634539531887285*^9, 3.6346202051419573`*^9, 3.6346230581832943`*^9, 
   3.634888828137855*^9, 3.647152901500868*^9, 3.6471567895433083`*^9, 
   3.647662595597868*^9, 3.6476799741364717`*^9, {3.647852048006851*^9, 
   3.6478520645292883`*^9}, 3.647852795593541*^9, 3.647854186856101*^9, 
   3.647854466357691*^9, 3.654589356822373*^9, 3.655028378750617*^9, 
   3.655028577246876*^9, 3.655037583423194*^9, 3.655102973076272*^9, 
   3.65544634545502*^9, 3.655449414238866*^9, 3.655449622293036*^9, 
   3.655462476706792*^9, 3.6555335086337976`*^9, 3.6555344834779673`*^9, 
   3.655534911524283*^9, 3.655556059471313*^9, 3.655556781596931*^9, 
   3.655556869117268*^9, 3.655557349804068*^9, 3.655557392918631*^9, {
   3.6555574525248623`*^9, 3.6555574822659388`*^9}, 3.655557986823586*^9, 
   3.6556175555437813`*^9, 3.65561936292833*^9, 3.655620488496245*^9, {
   3.6556209160926037`*^9, 3.655620918116496*^9}, 3.655621082613207*^9, 
   3.655622543335374*^9, 3.655623028474568*^9, 3.65562396054049*^9, 
   3.655624374749901*^9, 3.65563076308259*^9, 3.655708004668676*^9, {
   3.655708152368512*^9, 3.655708158848946*^9}, 3.65571580176877*^9, 
   3.6557980132932568`*^9, 3.655812076596881*^9, 3.6558122892667093`*^9, 
   3.65581258633183*^9, 3.6558159868414507`*^9, 3.6558160875957813`*^9, 
   3.6558170368488903`*^9, 3.65581721571278*^9, 3.6558184368726788`*^9, 
   3.6560547321601677`*^9, 3.656061473063294*^9, 3.656159607713993*^9, 
   3.656236581512001*^9, 3.65702360853976*^9, 3.6570239302869473`*^9, 
   3.657024187587659*^9, 3.6570242710993834`*^9, 3.65727292298584*^9, 
   3.658647644315083*^9, 3.6588393570778503`*^9, {3.658839700141542*^9, 
   3.6588397047397747`*^9}, 3.659073734002513*^9, 3.659073877167561*^9, 
   3.6590741596853533`*^9, 3.6590750413569508`*^9, 3.664617208834557*^9, 
   3.664617517513187*^9, 3.664786745817892*^9, 3.664787148926609*^9, 
   3.664787443494069*^9, 3.6647883023338823`*^9, 3.665472711170321*^9, 
   3.665472989261056*^9, 3.6654730601892242`*^9, 3.665474650135085*^9, 
   3.665474697385952*^9, 3.665474802983583*^9, 3.665474882146521*^9, 
   3.665474984519306*^9, 3.665478245171199*^9, 3.665478571393928*^9, 
   3.665486659345977*^9, {3.665486801678507*^9, 3.6654868156919823`*^9}}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.591533273004673*^9, 3.5915332856951637`*^9}, 
   3.591533561655061*^9, 3.633869848888072*^9, 3.634536999318646*^9, 
   3.634539531887285*^9, 3.6346202051419573`*^9, 3.6346230581832943`*^9, 
   3.634888828137855*^9, 3.647152901500868*^9, 3.6471567895433083`*^9, 
   3.647662595597868*^9, 3.6476799741364717`*^9, {3.647852048006851*^9, 
   3.6478520645292883`*^9}, 3.647852795593541*^9, 3.647854186856101*^9, 
   3.647854466357691*^9, 3.654589356822373*^9, 3.655028378750617*^9, 
   3.655028577246876*^9, 3.655037583423194*^9, 3.655102973076272*^9, 
   3.65544634545502*^9, 3.655449414238866*^9, 3.655449622293036*^9, 
   3.655462476706792*^9, 3.6555335086337976`*^9, 3.6555344834779673`*^9, 
   3.655534911524283*^9, 3.655556059471313*^9, 3.655556781596931*^9, 
   3.655556869117268*^9, 3.655557349804068*^9, 3.655557392918631*^9, {
   3.6555574525248623`*^9, 3.6555574822659388`*^9}, 3.655557986823586*^9, 
   3.6556175555437813`*^9, 3.65561936292833*^9, 3.655620488496245*^9, {
   3.6556209160926037`*^9, 3.655620918116496*^9}, 3.655621082613207*^9, 
   3.655622543335374*^9, 3.655623028474568*^9, 3.65562396054049*^9, 
   3.655624374749901*^9, 3.65563076308259*^9, 3.655708004668676*^9, {
   3.655708152368512*^9, 3.655708158848946*^9}, 3.65571580176877*^9, 
   3.6557980132932568`*^9, 3.655812076596881*^9, 3.6558122892667093`*^9, 
   3.65581258633183*^9, 3.6558159868414507`*^9, 3.6558160875957813`*^9, 
   3.6558170368488903`*^9, 3.65581721571278*^9, 3.6558184368726788`*^9, 
   3.6560547321601677`*^9, 3.656061473063294*^9, 3.656159607713993*^9, 
   3.656236581512001*^9, 3.65702360853976*^9, 3.6570239302869473`*^9, 
   3.657024187587659*^9, 3.6570242710993834`*^9, 3.65727292298584*^9, 
   3.658647644315083*^9, 3.6588393570778503`*^9, {3.658839700141542*^9, 
   3.6588397047397747`*^9}, 3.659073734002513*^9, 3.659073877167561*^9, 
   3.6590741596853533`*^9, 3.6590750413569508`*^9, 3.664617208834557*^9, 
   3.664617517513187*^9, 3.664786745817892*^9, 3.664787148926609*^9, 
   3.664787443494069*^9, 3.6647883023338823`*^9, 3.665472711170321*^9, 
   3.665472989261056*^9, 3.6654730601892242`*^9, 3.665474650135085*^9, 
   3.665474697385952*^9, 3.665474802983583*^9, 3.665474882146521*^9, 
   3.665474984519306*^9, 3.665478245171199*^9, 3.665478571393928*^9, 
   3.665486659345977*^9, {3.665486801678507*^9, 3.665486817389517*^9}}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.591533273004673*^9, 3.5915332856951637`*^9}, 
   3.591533561655061*^9, 3.633869848888072*^9, 3.634536999318646*^9, 
   3.634539531887285*^9, 3.6346202051419573`*^9, 3.6346230581832943`*^9, 
   3.634888828137855*^9, 3.647152901500868*^9, 3.6471567895433083`*^9, 
   3.647662595597868*^9, 3.6476799741364717`*^9, {3.647852048006851*^9, 
   3.6478520645292883`*^9}, 3.647852795593541*^9, 3.647854186856101*^9, 
   3.647854466357691*^9, 3.654589356822373*^9, 3.655028378750617*^9, 
   3.655028577246876*^9, 3.655037583423194*^9, 3.655102973076272*^9, 
   3.65544634545502*^9, 3.655449414238866*^9, 3.655449622293036*^9, 
   3.655462476706792*^9, 3.6555335086337976`*^9, 3.6555344834779673`*^9, 
   3.655534911524283*^9, 3.655556059471313*^9, 3.655556781596931*^9, 
   3.655556869117268*^9, 3.655557349804068*^9, 3.655557392918631*^9, {
   3.6555574525248623`*^9, 3.6555574822659388`*^9}, 3.655557986823586*^9, 
   3.6556175555437813`*^9, 3.65561936292833*^9, 3.655620488496245*^9, {
   3.6556209160926037`*^9, 3.655620918116496*^9}, 3.655621082613207*^9, 
   3.655622543335374*^9, 3.655623028474568*^9, 3.65562396054049*^9, 
   3.655624374749901*^9, 3.65563076308259*^9, 3.655708004668676*^9, {
   3.655708152368512*^9, 3.655708158848946*^9}, 3.65571580176877*^9, 
   3.6557980132932568`*^9, 3.655812076596881*^9, 3.6558122892667093`*^9, 
   3.65581258633183*^9, 3.6558159868414507`*^9, 3.6558160875957813`*^9, 
   3.6558170368488903`*^9, 3.65581721571278*^9, 3.6558184368726788`*^9, 
   3.6560547321601677`*^9, 3.656061473063294*^9, 3.656159607713993*^9, 
   3.656236581512001*^9, 3.65702360853976*^9, 3.6570239302869473`*^9, 
   3.657024187587659*^9, 3.6570242710993834`*^9, 3.65727292298584*^9, 
   3.658647644315083*^9, 3.6588393570778503`*^9, {3.658839700141542*^9, 
   3.6588397047397747`*^9}, 3.659073734002513*^9, 3.659073877167561*^9, 
   3.6590741596853533`*^9, 3.6590750413569508`*^9, 3.664617208834557*^9, 
   3.664617517513187*^9, 3.664786745817892*^9, 3.664787148926609*^9, 
   3.664787443494069*^9, 3.6647883023338823`*^9, 3.665472711170321*^9, 
   3.665472989261056*^9, 3.6654730601892242`*^9, 3.665474650135085*^9, 
   3.665474697385952*^9, 3.665474802983583*^9, 3.665474882146521*^9, 
   3.665474984519306*^9, 3.665478245171199*^9, 3.665478571393928*^9, 
   3.665486659345977*^9, {3.665486801678507*^9, 3.665486817390684*^9}}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.591533273004673*^9, 3.5915332856951637`*^9}, 
   3.591533561655061*^9, 3.633869848888072*^9, 3.634536999318646*^9, 
   3.634539531887285*^9, 3.6346202051419573`*^9, 3.6346230581832943`*^9, 
   3.634888828137855*^9, 3.647152901500868*^9, 3.6471567895433083`*^9, 
   3.647662595597868*^9, 3.6476799741364717`*^9, {3.647852048006851*^9, 
   3.6478520645292883`*^9}, 3.647852795593541*^9, 3.647854186856101*^9, 
   3.647854466357691*^9, 3.654589356822373*^9, 3.655028378750617*^9, 
   3.655028577246876*^9, 3.655037583423194*^9, 3.655102973076272*^9, 
   3.65544634545502*^9, 3.655449414238866*^9, 3.655449622293036*^9, 
   3.655462476706792*^9, 3.6555335086337976`*^9, 3.6555344834779673`*^9, 
   3.655534911524283*^9, 3.655556059471313*^9, 3.655556781596931*^9, 
   3.655556869117268*^9, 3.655557349804068*^9, 3.655557392918631*^9, {
   3.6555574525248623`*^9, 3.6555574822659388`*^9}, 3.655557986823586*^9, 
   3.6556175555437813`*^9, 3.65561936292833*^9, 3.655620488496245*^9, {
   3.6556209160926037`*^9, 3.655620918116496*^9}, 3.655621082613207*^9, 
   3.655622543335374*^9, 3.655623028474568*^9, 3.65562396054049*^9, 
   3.655624374749901*^9, 3.65563076308259*^9, 3.655708004668676*^9, {
   3.655708152368512*^9, 3.655708158848946*^9}, 3.65571580176877*^9, 
   3.6557980132932568`*^9, 3.655812076596881*^9, 3.6558122892667093`*^9, 
   3.65581258633183*^9, 3.6558159868414507`*^9, 3.6558160875957813`*^9, 
   3.6558170368488903`*^9, 3.65581721571278*^9, 3.6558184368726788`*^9, 
   3.6560547321601677`*^9, 3.656061473063294*^9, 3.656159607713993*^9, 
   3.656236581512001*^9, 3.65702360853976*^9, 3.6570239302869473`*^9, 
   3.657024187587659*^9, 3.6570242710993834`*^9, 3.65727292298584*^9, 
   3.658647644315083*^9, 3.6588393570778503`*^9, {3.658839700141542*^9, 
   3.6588397047397747`*^9}, 3.659073734002513*^9, 3.659073877167561*^9, 
   3.6590741596853533`*^9, 3.6590750413569508`*^9, 3.664617208834557*^9, 
   3.664617517513187*^9, 3.664786745817892*^9, 3.664787148926609*^9, 
   3.664787443494069*^9, 3.6647883023338823`*^9, 3.665472711170321*^9, 
   3.665472989261056*^9, 3.6654730601892242`*^9, 3.665474650135085*^9, 
   3.665474697385952*^9, 3.665474802983583*^9, 3.665474882146521*^9, 
   3.665474984519306*^9, 3.665478245171199*^9, 3.665478571393928*^9, 
   3.665486659345977*^9, {3.665486801678507*^9, 3.665486817457335*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{24., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  1, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 1, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.591533273004673*^9, 3.5915332856951637`*^9}, 
   3.591533561655061*^9, 3.633869848888072*^9, 3.634536999318646*^9, 
   3.634539531887285*^9, 3.6346202051419573`*^9, 3.6346230581832943`*^9, 
   3.634888828137855*^9, 3.647152901500868*^9, 3.6471567895433083`*^9, 
   3.647662595597868*^9, 3.6476799741364717`*^9, {3.647852048006851*^9, 
   3.6478520645292883`*^9}, 3.647852795593541*^9, 3.647854186856101*^9, 
   3.647854466357691*^9, 3.654589356822373*^9, 3.655028378750617*^9, 
   3.655028577246876*^9, 3.655037583423194*^9, 3.655102973076272*^9, 
   3.65544634545502*^9, 3.655449414238866*^9, 3.655449622293036*^9, 
   3.655462476706792*^9, 3.6555335086337976`*^9, 3.6555344834779673`*^9, 
   3.655534911524283*^9, 3.655556059471313*^9, 3.655556781596931*^9, 
   3.655556869117268*^9, 3.655557349804068*^9, 3.655557392918631*^9, {
   3.6555574525248623`*^9, 3.6555574822659388`*^9}, 3.655557986823586*^9, 
   3.6556175555437813`*^9, 3.65561936292833*^9, 3.655620488496245*^9, {
   3.6556209160926037`*^9, 3.655620918116496*^9}, 3.655621082613207*^9, 
   3.655622543335374*^9, 3.655623028474568*^9, 3.65562396054049*^9, 
   3.655624374749901*^9, 3.65563076308259*^9, 3.655708004668676*^9, {
   3.655708152368512*^9, 3.655708158848946*^9}, 3.65571580176877*^9, 
   3.6557980132932568`*^9, 3.655812076596881*^9, 3.6558122892667093`*^9, 
   3.65581258633183*^9, 3.6558159868414507`*^9, 3.6558160875957813`*^9, 
   3.6558170368488903`*^9, 3.65581721571278*^9, 3.6558184368726788`*^9, 
   3.6560547321601677`*^9, 3.656061473063294*^9, 3.656159607713993*^9, 
   3.656236581512001*^9, 3.65702360853976*^9, 3.6570239302869473`*^9, 
   3.657024187587659*^9, 3.6570242710993834`*^9, 3.65727292298584*^9, 
   3.658647644315083*^9, 3.6588393570778503`*^9, {3.658839700141542*^9, 
   3.6588397047397747`*^9}, 3.659073734002513*^9, 3.659073877167561*^9, 
   3.6590741596853533`*^9, 3.6590750413569508`*^9, 3.664617208834557*^9, 
   3.664617517513187*^9, 3.664786745817892*^9, 3.664787148926609*^9, 
   3.664787443494069*^9, 3.6647883023338823`*^9, 3.665472711170321*^9, 
   3.665472989261056*^9, 3.6654730601892242`*^9, 3.665474650135085*^9, 
   3.665474697385952*^9, 3.665474802983583*^9, 3.665474882146521*^9, 
   3.665474984519306*^9, 3.665478245171199*^9, 3.665478571393928*^9, 
   3.665486659345977*^9, {3.665486801678507*^9, 3.6654868174584846`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.591533273004673*^9, 3.5915332856951637`*^9}, 
   3.591533561655061*^9, 3.633869848888072*^9, 3.634536999318646*^9, 
   3.634539531887285*^9, 3.6346202051419573`*^9, 3.6346230581832943`*^9, 
   3.634888828137855*^9, 3.647152901500868*^9, 3.6471567895433083`*^9, 
   3.647662595597868*^9, 3.6476799741364717`*^9, {3.647852048006851*^9, 
   3.6478520645292883`*^9}, 3.647852795593541*^9, 3.647854186856101*^9, 
   3.647854466357691*^9, 3.654589356822373*^9, 3.655028378750617*^9, 
   3.655028577246876*^9, 3.655037583423194*^9, 3.655102973076272*^9, 
   3.65544634545502*^9, 3.655449414238866*^9, 3.655449622293036*^9, 
   3.655462476706792*^9, 3.6555335086337976`*^9, 3.6555344834779673`*^9, 
   3.655534911524283*^9, 3.655556059471313*^9, 3.655556781596931*^9, 
   3.655556869117268*^9, 3.655557349804068*^9, 3.655557392918631*^9, {
   3.6555574525248623`*^9, 3.6555574822659388`*^9}, 3.655557986823586*^9, 
   3.6556175555437813`*^9, 3.65561936292833*^9, 3.655620488496245*^9, {
   3.6556209160926037`*^9, 3.655620918116496*^9}, 3.655621082613207*^9, 
   3.655622543335374*^9, 3.655623028474568*^9, 3.65562396054049*^9, 
   3.655624374749901*^9, 3.65563076308259*^9, 3.655708004668676*^9, {
   3.655708152368512*^9, 3.655708158848946*^9}, 3.65571580176877*^9, 
   3.6557980132932568`*^9, 3.655812076596881*^9, 3.6558122892667093`*^9, 
   3.65581258633183*^9, 3.6558159868414507`*^9, 3.6558160875957813`*^9, 
   3.6558170368488903`*^9, 3.65581721571278*^9, 3.6558184368726788`*^9, 
   3.6560547321601677`*^9, 3.656061473063294*^9, 3.656159607713993*^9, 
   3.656236581512001*^9, 3.65702360853976*^9, 3.6570239302869473`*^9, 
   3.657024187587659*^9, 3.6570242710993834`*^9, 3.65727292298584*^9, 
   3.658647644315083*^9, 3.6588393570778503`*^9, {3.658839700141542*^9, 
   3.6588397047397747`*^9}, 3.659073734002513*^9, 3.659073877167561*^9, 
   3.6590741596853533`*^9, 3.6590750413569508`*^9, 3.664617208834557*^9, 
   3.664617517513187*^9, 3.664786745817892*^9, 3.664787148926609*^9, 
   3.664787443494069*^9, 3.6647883023338823`*^9, 3.665472711170321*^9, 
   3.665472989261056*^9, 3.6654730601892242`*^9, 3.665474650135085*^9, 
   3.665474697385952*^9, 3.665474802983583*^9, 3.665474882146521*^9, 
   3.665474984519306*^9, 3.665478245171199*^9, 3.665478571393928*^9, 
   3.665486659345977*^9, {3.665486801678507*^9, 3.6654868175175858`*^9}}],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{{3.591533273004673*^9, 3.5915332856951637`*^9}, 
   3.591533561655061*^9, 3.633869848888072*^9, 3.634536999318646*^9, 
   3.634539531887285*^9, 3.6346202051419573`*^9, 3.6346230581832943`*^9, 
   3.634888828137855*^9, 3.647152901500868*^9, 3.6471567895433083`*^9, 
   3.647662595597868*^9, 3.6476799741364717`*^9, {3.647852048006851*^9, 
   3.6478520645292883`*^9}, 3.647852795593541*^9, 3.647854186856101*^9, 
   3.647854466357691*^9, 3.654589356822373*^9, 3.655028378750617*^9, 
   3.655028577246876*^9, 3.655037583423194*^9, 3.655102973076272*^9, 
   3.65544634545502*^9, 3.655449414238866*^9, 3.655449622293036*^9, 
   3.655462476706792*^9, 3.6555335086337976`*^9, 3.6555344834779673`*^9, 
   3.655534911524283*^9, 3.655556059471313*^9, 3.655556781596931*^9, 
   3.655556869117268*^9, 3.655557349804068*^9, 3.655557392918631*^9, {
   3.6555574525248623`*^9, 3.6555574822659388`*^9}, 3.655557986823586*^9, 
   3.6556175555437813`*^9, 3.65561936292833*^9, 3.655620488496245*^9, {
   3.6556209160926037`*^9, 3.655620918116496*^9}, 3.655621082613207*^9, 
   3.655622543335374*^9, 3.655623028474568*^9, 3.65562396054049*^9, 
   3.655624374749901*^9, 3.65563076308259*^9, 3.655708004668676*^9, {
   3.655708152368512*^9, 3.655708158848946*^9}, 3.65571580176877*^9, 
   3.6557980132932568`*^9, 3.655812076596881*^9, 3.6558122892667093`*^9, 
   3.65581258633183*^9, 3.6558159868414507`*^9, 3.6558160875957813`*^9, 
   3.6558170368488903`*^9, 3.65581721571278*^9, 3.6558184368726788`*^9, 
   3.6560547321601677`*^9, 3.656061473063294*^9, 3.656159607713993*^9, 
   3.656236581512001*^9, 3.65702360853976*^9, 3.6570239302869473`*^9, 
   3.657024187587659*^9, 3.6570242710993834`*^9, 3.65727292298584*^9, 
   3.658647644315083*^9, 3.6588393570778503`*^9, {3.658839700141542*^9, 
   3.6588397047397747`*^9}, 3.659073734002513*^9, 3.659073877167561*^9, 
   3.6590741596853533`*^9, 3.6590750413569508`*^9, 3.664617208834557*^9, 
   3.664617517513187*^9, 3.664786745817892*^9, 3.664787148926609*^9, 
   3.664787443494069*^9, 3.6647883023338823`*^9, 3.665472711170321*^9, 
   3.665472989261056*^9, 3.6654730601892242`*^9, 3.665474650135085*^9, 
   3.665474697385952*^9, 3.665474802983583*^9, 3.665474882146521*^9, 
   3.665474984519306*^9, 3.665478245171199*^9, 3.665478571393928*^9, 
   3.665486659345977*^9, {3.665486801678507*^9, 3.665486817518598*^9}}]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.591533283040056*^9, 3.591533295476935*^9}, 
   3.59153357192179*^9, 3.633869859578429*^9, 3.634537009978821*^9, 
   3.6345395429106216`*^9, 3.634620217019496*^9, 3.634623070071436*^9, 
   3.634888840302128*^9, 3.647152911135297*^9, 3.6471567992002*^9, 
   3.647662615895679*^9, 3.647679994578714*^9, {3.6478520480745487`*^9, 
   3.6478520683779907`*^9}, 3.647852799153767*^9, 3.64785419090386*^9, 
   3.647854470034789*^9, 3.654589356838451*^9, 3.655028382612157*^9, 
   3.65502858105962*^9, 3.655037587314472*^9, 3.655102973547595*^9, 
   3.6554463459599733`*^9, 3.65544941496069*^9, 3.655449622867977*^9, 
   3.6554624805591393`*^9, 3.655533509881298*^9, 3.655534487428575*^9, 
   3.655534912180141*^9, 3.655556060797079*^9, 3.655556782192253*^9, 
   3.655556869673991*^9, 3.6555573503033648`*^9, 3.6555573969117537`*^9, {
   3.655557456449244*^9, 3.655557486374288*^9}, 3.65555798965685*^9, 
   3.655617559469203*^9, 3.655619367045573*^9, 3.655620492458544*^9, {
   3.655620916650175*^9, 3.6556209187559347`*^9}, 3.655621083164143*^9, 
   3.6556225462963943`*^9, 3.655623029018733*^9, 3.655623961071417*^9, 
   3.655624376011156*^9, 3.655630764504943*^9, 3.655708005675871*^9, {
   3.655708153419808*^9, 3.655708159964082*^9}, 3.655715802316148*^9, 
   3.655798014841055*^9, 3.65581208233632*^9, 3.655812294301346*^9, 
   3.6558125900854397`*^9, 3.6558159915835657`*^9, 3.65581609214128*^9, 
   3.6558170381290092`*^9, 3.655817220338429*^9, 3.655818441526115*^9, 
   3.6560547368846188`*^9, 3.6560614769227*^9, 3.6561596102364893`*^9, 
   3.656236586280949*^9, 3.657023612343821*^9, 3.657023934874998*^9, 
   3.657024189426931*^9, 3.657024272364956*^9, 3.6572729267919483`*^9, 
   3.658647648926399*^9, 3.6588393604969673`*^9, {3.6588397037206306`*^9, 
   3.658839708227395*^9}, 3.659073735326663*^9, 3.659073879099579*^9, 
   3.659074163196884*^9, 3.659075044737995*^9, 3.664617212396185*^9, 
   3.6646175210469646`*^9, 3.66478674948958*^9, 3.664787152562687*^9, 
   3.664787446993149*^9, 3.664788305776926*^9, 3.66547271309063*^9, 
   3.6654729914508343`*^9, 3.6654730621880283`*^9, 3.66547465206083*^9, 
   3.6654746996072063`*^9, 3.665474804861062*^9, 3.665474884070969*^9, 
   3.665474986720435*^9, 3.6654782473080273`*^9, 3.6654785732181683`*^9, 
   3.665486661083262*^9, {3.665486803592098*^9, 3.665486817519742*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ckQuantumNumbers", "=", 
  RowBox[{"CheckQuantumNumbers", "[", "LRM", "]"}]}]], "Input",
 CellChangeTimes->{{3.655556560624447*^9, 3.655556568039588*^9}, {
  3.655557461075137*^9, 3.655557467718701*^9}}],

Cell[BoxData["\<\"All quantum numbers are conserved.\"\>"], "Print",
 CellChangeTimes->{
  3.65555656973392*^9, 3.6555567828141193`*^9, 3.655556870024482*^9, 
   3.655557350731496*^9, 3.655557399355894*^9, 3.655557488682089*^9, 
   3.655557990877342*^9, 3.655617561966374*^9, 3.6556193696150503`*^9, 
   3.655620494861127*^9, 3.655620919212823*^9, 3.6556210836727467`*^9, 
   3.655622547670369*^9, 3.6556230295239973`*^9, 3.655623961567198*^9, 
   3.6556243765560503`*^9, 3.655630765110804*^9, 3.655708006154704*^9, 
   3.655708160746683*^9, 3.6557158028174343`*^9, 3.6558120840647917`*^9, 
   3.655815993904903*^9, 3.6558160941939793`*^9, 3.6558172224156446`*^9, 
   3.655818444219852*^9, 3.656054739612062*^9, 3.656061479410858*^9, 
   3.656159611279595*^9, 3.656236590361738*^9, 3.657023614736661*^9, 
   3.657023937445738*^9, 3.657024190296426*^9, 3.657024272965096*^9, 
   3.657272929421646*^9, 3.658647651596225*^9, 3.658839362904902*^9, 
   3.6588397103818903`*^9, 3.6590737359080057`*^9, 3.659073879983635*^9, 
   3.659074165485581*^9, 3.6590750469816732`*^9, 3.664617214554124*^9, 
   3.664617523308095*^9, 3.6647867517207937`*^9, 3.6647871548918047`*^9, 
   3.664787449273033*^9, 3.664788307954232*^9, 3.665473063018564*^9, 
   3.665486666610084*^9, {3.665486805683716*^9, 3.665486818294454*^9}}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.665486805684328*^9, 3.6654868182955*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ckDiagonalKineticTerms", "=", 
  RowBox[{"CheckDiagonalKineticTerms", "[", "LRM", "]"}]}]], "Input",
 CellChangeTimes->{{3.634888579839384*^9, 3.6348885808384333`*^9}, 
   3.6348886269306993`*^9, {3.647152905417927*^9, 3.6471529057758427`*^9}, 
   3.6478520566558847`*^9, 3.6545893602010393`*^9, {3.6555574737393427`*^9, 
   3.655557478773703*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.63488863760299*^9, 3.63488884361946*^9, 3.647152915156876*^9, 
   3.647156803124836*^9, 3.647662624547717*^9, 3.647680003047727*^9, {
   3.647852050146554*^9, 3.647852070746361*^9}, 3.647854193380438*^9, 
   3.647854472315157*^9, 3.654589367379467*^9, 3.655028385095449*^9, 
   3.655037589689776*^9, 3.655102976969412*^9, 3.6554463480196667`*^9, 
   3.6554494166595507`*^9, 3.655449624416093*^9, 3.655462482854165*^9, 
   3.655533510555356*^9, 3.655534489927485*^9, 3.65553491247956*^9, 
   3.655556061523958*^9, 3.6555567830787907`*^9, 3.655556870343343*^9, 
   3.6555573511558323`*^9, 3.655557401856991*^9, 3.6555574909705343`*^9, 
   3.655557992107485*^9, 3.65561756431448*^9, 3.655619372238656*^9, 
   3.655620497233121*^9, 3.6556209194893637`*^9, 3.6556210840084953`*^9, 
   3.65562254892262*^9, 3.655623029848941*^9, 3.65562396185143*^9, 
   3.65562437703279*^9, 3.655630765647863*^9, 3.6557080064700727`*^9, 
   3.655708161439475*^9, 3.6557158031344976`*^9, 3.655812086274322*^9, 
   3.655815995882653*^9, 3.655816096294796*^9, 3.655817224416876*^9, 
   3.6558184467550373`*^9, 3.656054742273526*^9, 3.6560614819127407`*^9, 
   3.656159612394012*^9, 3.6562365951838093`*^9, 3.657023617113926*^9, 
   3.657023940045124*^9, 3.657024191034038*^9, 3.657024273528281*^9, 
   3.657272931817512*^9, 3.658647654269309*^9, 3.658839365035342*^9, 
   3.658839712520583*^9, 3.6590737364434834`*^9, 3.659073880817934*^9, 
   3.6590741677050047`*^9, 3.6590750491965237`*^9, 3.664617216700522*^9, 
   3.66461752556073*^9, 3.6647867538798923`*^9, 3.664787157101528*^9, 
   3.6647874515462227`*^9, 3.6647883101671743`*^9, 3.6654730637881117`*^9, 
   3.665486819024516*^9}],

Cell[BoxData["\<\"All kinetic terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{
  3.63488863760299*^9, 3.63488884361946*^9, 3.647152915156876*^9, 
   3.647156803124836*^9, 3.647662624547717*^9, 3.647680003047727*^9, {
   3.647852050146554*^9, 3.647852070746361*^9}, 3.647854193380438*^9, 
   3.647854472315157*^9, 3.654589367379467*^9, 3.655028385095449*^9, 
   3.655037589689776*^9, 3.655102976969412*^9, 3.6554463480196667`*^9, 
   3.6554494166595507`*^9, 3.655449624416093*^9, 3.655462482854165*^9, 
   3.655533510555356*^9, 3.655534489927485*^9, 3.65553491247956*^9, 
   3.655556061523958*^9, 3.6555567830787907`*^9, 3.655556870343343*^9, 
   3.6555573511558323`*^9, 3.655557401856991*^9, 3.6555574909705343`*^9, 
   3.655557992107485*^9, 3.65561756431448*^9, 3.655619372238656*^9, 
   3.655620497233121*^9, 3.6556209194893637`*^9, 3.6556210840084953`*^9, 
   3.65562254892262*^9, 3.655623029848941*^9, 3.65562396185143*^9, 
   3.65562437703279*^9, 3.655630765647863*^9, 3.6557080064700727`*^9, 
   3.655708161439475*^9, 3.6557158031344976`*^9, 3.655812086274322*^9, 
   3.655815995882653*^9, 3.655816096294796*^9, 3.655817224416876*^9, 
   3.6558184467550373`*^9, 3.656054742273526*^9, 3.6560614819127407`*^9, 
   3.656159612394012*^9, 3.6562365951838093`*^9, 3.657023617113926*^9, 
   3.657023940045124*^9, 3.657024191034038*^9, 3.657024273528281*^9, 
   3.657272931817512*^9, 3.658647654269309*^9, 3.658839365035342*^9, 
   3.658839712520583*^9, 3.6590737364434834`*^9, 3.659073880817934*^9, 
   3.6590741677050047`*^9, 3.6590750491965237`*^9, 3.664617216700522*^9, 
   3.66461752556073*^9, 3.6647867538798923`*^9, 3.664787157101528*^9, 
   3.6647874515462227`*^9, 3.6647883101671743`*^9, 3.6654730637881117`*^9, 
   3.6654868190792637`*^9}]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->CompressedData["
1:eJwVzGkow3EYwPGJRm4vTKTEWCKbcmyZYz/iHbKSlBz/zGbOQtGkZi+EsSi0
iBw5Smq5olZeuLeUzNSSkOX4ZTFHLOF5Xnz7vPtGMk1SmRuLxRJje9GWWjEl
1qVNaSPoYY+QDILbavVjSjolXGNwrRDU9vhr0MmNsuMM0PvprL0STFNK3lCO
KjC2CmRcBlUd+DJye47aX8zXqDXMHl4P6m7TuWhcSAUf9f52b0B5Gq2mF1Tw
+2R94LsizometLzy+sHnfbUYnRubcqKrXka+Fn954lm0lEZdoOzu9Q8dmDpx
urwONusFO2iNUqbaAn9DTV0PoJ9Pl/wJdF75tKLJiQFuFMxes+nR6aNDV3kG
Jff6rFwGfCgZEAyDrj/5/iZoWuYGirIoae1Qi1AaflOCTjwnMuidotNsAMff
TL5F2ZTUJ8wsroCcnyALOiT0D43MoWReGBaPOsY+C9AkKc+IbrRxrlfzKRn9
MrDXQN1C5iK7gJKDtHkb6jhr+UM9RIdKT7A6xrVbXEjJpZ7pLAP/AbEb6RI=

  "]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ckDiagonalMassTerms", "=", 
  RowBox[{"CheckDiagonalMassTerms", "[", "LRM", "]"}]}]], "Input",
 CellChangeTimes->{{3.634888586936668*^9, 3.634888589829256*^9}, 
   3.634888629585513*^9, {3.6471529083178883`*^9, 3.64715290897139*^9}, 
   3.647852057622191*^9, 3.654589361621069*^9, {3.655557652092018*^9, 
   3.6555576651398582`*^9}}],

Cell[BoxData["\<\"All mass terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{
  3.634888644224197*^9, 3.634888847033965*^9, 3.6471529192354307`*^9, 
   3.6471568071127977`*^9, 3.6476626331560802`*^9, 3.647680011387031*^9, {
   3.6478520518749447`*^9, 3.6478520731398*^9}, 3.647854195910007*^9, 
   3.647854474615224*^9, 3.654589368380753*^9, 3.655028388852507*^9, 
   3.655037592100333*^9, 3.655102978590848*^9, 3.6554463498210793`*^9, 
   3.655449419356674*^9, 3.655449625893476*^9, 3.655462485177459*^9, 
   3.65553351117023*^9, 3.655534492478117*^9, 3.655534912810627*^9, 
   3.655556062176011*^9, 3.6555567834576473`*^9, 3.655556870632485*^9, 
   3.655557351582183*^9, 3.655557404284288*^9, 3.655557705632101*^9, 
   3.655557993310985*^9, 3.655617566804093*^9, 3.655619374799411*^9, 
   3.655620499741922*^9, 3.655620919769578*^9, 3.6556210843021097`*^9, 
   3.655622550245267*^9, 3.655623030150145*^9, 3.6556239621653137`*^9, 
   3.655624378091559*^9, 3.655630766383383*^9, 3.6557080069078703`*^9, 
   3.655708162238461*^9, 3.655715803413362*^9, 3.655812088051293*^9, 
   3.655815997944862*^9, 3.6558160984048643`*^9, 3.655817226528779*^9, 
   3.6558184493745604`*^9, 3.656054744964986*^9, 3.6560614844145393`*^9, 
   3.6561596134940042`*^9, 3.6562366024386272`*^9, 3.657023619469287*^9, 
   3.657023942665588*^9, 3.657024191894055*^9, 3.657024274108255*^9, 
   3.657272934236431*^9, 3.6586476570525417`*^9, 3.658839367625189*^9, 
   3.658839714777515*^9, 3.6590737370960484`*^9, 3.659073881757358*^9, 
   3.659074169911694*^9, 3.659075051377399*^9, 3.66461721888301*^9, 
   3.6646175279514914`*^9, 3.664786756076312*^9, 3.6647871595677958`*^9, 
   3.664787454104536*^9, 3.6647883124549303`*^9, 3.665473064618227*^9, 
   3.6654868198104277`*^9}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->CompressedData["
1:eJwVy2kow3EYwPGNHOVokhdqZEREKGS1Db//zNGYmRwvllghzfVCOUvxxpyl
SI5XwtIiV6Lcx0q80cZGtJTzV8OfZSI8z4tvn1dfgaZeVcHlcDgiaLtw3FQt
oqRb4lpQB5a8qNIGwFv5xlOSmBJ1g7Y6GTybFHehQyvTxxIwqumuuQzcLRp8
R1lnYGQ5qNAftmlBi8FuRv1kJht6PMPya8C5EF0YyjCJ2ejwb1Qt2rhj7dKB
bxPWih78jppYtH/WGdELVi7pRKjy1siiEecHsX3gq1I2hX46mAv0S37iGASz
Aq4Nq/jrM3dQD6a2bR38MXA7HsH49K2qZ9D+ndOIurwruRTku8WMoQPPwd+l
EkrO5f0yDfhmXogbAqU8hXEN5HvV84SplOypzELUNvVTjHp3SDWoZdR4soiu
CXzyGUqcnh/6ebDnocSECoPCAgVSSoIzhNHoVaIkDw3l12yiKQq1bTmXkvvW
X/cVMLy5U++uoMSUwF6iN+X7f2jaiK/WA7Se+h8W5lEi/mxpV4P/+5/qfw==

  "]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ckDiagonalQuadraticTerms", "=", 
  RowBox[{"CheckDiagonalQuadraticTerms", "[", "LRM", "]"}]}]], "Input",
 CellChangeTimes->{{3.634888597073275*^9, 3.634888597988344*^9}, 
   3.634888630399523*^9, {3.6471529139372997`*^9, 3.64715291428071*^9}, 
   3.6478520591871643`*^9, 3.654589362723795*^9, {3.655557655112711*^9, 
   3.655557663885045*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with less than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with less than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVtIk3EcxvF38zAvEkJLNAw0NSWXQRC5Tcm/YvSGa0wxDHSs5aZrWkJD
hQUj8iadm6aiGCEdLjopaR7SCswY5Vop9Io0k4YIuf5eNCO0RtTzu3j43H2f
dNPlcrNMEIRSzD/6Y+ffHs4GGsUEYS9nPuPFC7VKzu501YoW6OtUnaw5zFlm
5pU5M9y1YPdOw3eJ/o8zUN86FCb94ayWHjVnTZMhyarhzDWvq7gER7Y7itzw
aFkodKyAs7dDw9bjUBQd10mDZ8dXCI1dkVYjbE8N/CQXbx3IOQ/frAcdNpgj
bS+RUZHVIPnymrC/ASYnLWWQZq9TJE3vdY3kmHiw7QbsXcm2tMOWGO8WOdgv
z+6AG48HNGSxLbxFlsikPBcM5JXfIzeD55bJtLi1Xx6o/Lz5ZAJO/a2ZJYsm
HY5pmBWb79yAFoW8/ju0fuq2k+qMPhmHboNzkHRJzRFDIWf2zkCpCQ6/lo7c
hNXRXxamYIP2xe78E+jvO6Qi/8wmV5F1UoWJLKhK/DAKyzzN8fpidO+rHo7A
5/F3JfK2qElJL+HsVJ8+l3T3tOnIpLmnr8job4+Cz7Sc/Y45rRiH9V/nH8Se
4WxmVb1CynMTBAVM01baSOtZpbdSh7+x7qvV8D8CNQzv
  "]],

Cell[BoxData["\<\"All quadratic terms are diagonal.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzFtIk2Ecx/F38zAvFEJTNAo0NSWXQSC5TclHMXrDNaYYCjrWctM1rcCh
woIReZPOzTRJjJAOF52UrDxWYMYo18rAV6KZNFLI9XjRjNAaUb//xZfP3TfD
dK7SLBMEoRz5x35s/9vJ2WCLmCgkc+YznjndoOTsZm+DaIG+HtXR+gOcZWW1
zplh/ILdOw3fJPnfz0B9x3CY9Iez2/vVnJ2fCElWDWeueV3VWTi61V3ihocq
QqGCIs5eD49YD0NRdFwiDZ5tXzE09kY6jLBrd+An+eH63txT8NVa0GGDudLW
EhkVWQmSzy8Ke5phaspSJmn2OkXS9FbXQj4W93VehleXcyxdsD3Gu0kOXZPn
dMP1B4MastQW3iTLZFK+CwbyK2+TG8Haj2R63NdfHqj8tPFwHE7+rZ8lSyYc
jmmYHVvoXIcWhbzpO7QuXrGT6swBGYdug3OIdEltEUMxZ/aeQLkJjryUDvbB
uujPC5OwWftsR+ER/HftV5F/ZlNryEapykQW1SS9G4MVnrYEfSm+d1T3RuFU
wi2JvCFq0jLKODs2oM8j3f2dOjJl7tELMvrb/eATLWe/Y44rnsKmL/N3Y09w
NrOiXibleYmCAqZrq22k9aTSW63jjK32XaiD/wEDOg0W
  "]]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->CompressedData["
1:eJwVz2kow3EYB/D/plgrR+QsRVuznOWI2Rx/V+QYM9dIrBxrWEphWyxXYa7V
Ul6pvaFGLSRXKfFikheM2GJNuX5ljiRRPM+Lp8+77/f7RMpVkhYGRVFCOGcp
OVcICZ04V17ZBXLd+uxpcPHs6SlFRGildFWRCuplmmFUO/9tzQDNhb99TSD7
6voDNXdz+M0gz8elUYIs+5cNzXPcONHTLyq8AxxgXnBQV+JQEdpzK+5E/St4
I+PgwV1U6wRYH3z0ju5IPaImwczyBSH61//2jvJebfF6UDolMaGeH3WXaE2Q
63MGnL13mzdwr2/jPrqVr9VsgeIHweAj/hPObH8GrddzPWhgi5FBwF21bgGt
tPf9NGYQeqzAkS8H1WpbggEMC3GcboJc9a5fWhahjw3RAjRPFlqL8kVSOSpY
CjixgDpVr3dFDqFz2tOXV8EJo+kcfTGJQiNzIVdQFYM+RoyKUVabZQ/N5qw4
10qhr6TYax1MnrYueZYROlYlsqOWJH/KC2TPVivRbUbcYZWY0OvEoG0A/wHe
juGi
  "]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ckKineticTermNormalisation", "=", 
  RowBox[{"CheckKineticTermNormalisation", "[", "LRM", "]"}]}]], "Input",
 CellChangeTimes->{{3.634888605375029*^9, 3.634888631228882*^9}, {
   3.647152918581677*^9, 3.6471529188737307`*^9}, 3.647852059881651*^9, 
   3.654589364537632*^9, {3.655557659398533*^9, 3.655557662082596*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBwBeJPLrE//4u8diwx2iTEIPraMebOi+QUndeOAcuee6YB
6ey5Lu6xuq8dNarqDqcC6RP6B4/uBNIN3rLndwHpEt8XH0G0X5JL+WSr145n
Wc2vZlq/dhQrnxecB6Q3SW126APSNvelX5navHZcNuF9pjmQlp90shlEm+y0
P20LpLOTuSoTgPSUTKUvILokQEsjEUj/eP+hOhtI631iuAaieUpfPQDRfmJc
sjlAuvK7sgqIvrTrtCeI7jlXkwuiC+cWtnQC6e/rStO6gPS29UKfQfQzWy71
bpA9Txdag2geRqnPILoj/YFeD5BeZxC9GEyH518H0bts/37tB9KzVP+s2Qqk
m+3LDoDoe8eaq3cCaYWY/PoXQDrutGPGKyDN8PZyCYiuXHCd8TVIX/61WSD6
7qbzv+NsXzvOO6frlgSkr+TzGEwC0jKK2he2A+lPWmyCFvavHc8drLME0fPu
GUeA6EvqaUkguisj5uxGIO2w+DRvoNNrx19ralauA9J6k15fAdEqc/0lFZ2B
/v1SoA2i11w84w+ilR5/2wuiY7w+P9js+9px7evp7FuA9KezAivZ/ID+mN9y
G0Qvs4xnYAfST6VmZ4NoH0vXo6H+wHiLXlMTA6QB6/YPlg==
  "]],

Cell[BoxData["\<\"All kinetic terms are diagonal.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBwBeJPLrE//4u8diwx2iTEIPraMebOi+QUndeOAcuee6YB
6ey5Lu6xuq8dNarqDqcC6RP6B4/uBNIN3rLndwHpEt8XH0G0X5JL+WSr145n
Wc2vZlq/dhQrnxecB6Q3SW126APSNvelX5navHZcNuF9pjmQlp90shlEm+y0
P20LpLOTuSoTgPSUTKUvILokQEsjEUj/eP+hOhtI631iuAaieUpfPQDRfmJc
sjlAuvK7sgqIvrTrtCeI7jlXkwuiC+cWtnQC6e/rStO6gPS29UKfQfQzWy71
bpA9Txdag2geRqnPILoj/YFeD5BeZxC9GEyH518H0bts/37tB9KzVP+s2Qqk
m+3LDoDoe8eaq3cCaYWY/PoXQDrutGPGKyDN8PZyCYiuXHCd8TVIX/61WSD6
7qbzv+NsXzvOO6frlgSkr+TzGEwC0jKK2he2A+lPWmyCFvavHc8drLME0fPu
GUeA6EvqaUkguisj5uxGIO2w+DRvoNNrx19ralauA9J6k15fAdEqc/0lFZ2B
/v1SoA2i11w84w+ilR5/2wuiY7w+P9js+9px7evp7FuA9KezAivZ/ID+mN9y
G0Qvs4xnYAfST6VmZ4NoH0vXo6H+wHh0XFsTA6QB6hYPVw==
  "]],

Cell[BoxData["\<\"All kinetic terms are correctly normalized.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwdz11Ik3EYBfB3FymMBSUmNBWbGormFD/QpWP+cxaWblpIga9WU5dj1psw
leXQYF6USckMAmWrEAbCnDRT2UBwyKKYm2mmF6kNRB37E9Zm2Sf6PF0cfleH
wxGpuMvNPIZhyiFhef2vg1hKdLmOGOYEJexasLHpDCXV1p0KNag1yy/UZ1GS
fq97rhl8m+32OMH7lxIXXKCuKvgNVajknYNnKfEdKfyoKaYkrtNy5Q7oEE6U
PgZLPseHCkoosQ7sagrBJNM7I5rvlHmloLaRr78BPtUk76G66oz0m+DP3a9d
WlAcZlZQQXsogCri+ImtoH4/JRVdcnkr0H6/4TbaZm7rfQju29vVfeDUeEwE
3Zby0x7hztbLYlTAE0bQB7cC4n7QnlM38t+r3Crqkv77/gQcOv3XNgkaZR2z
6MYbY5cTPMVyPUGwwUtaQiDz5YMO1b9Y5VHscStD6Lpj4U+DlBKLP+u8Clzm
BDkmMEGU+X4aDGdEHS+SUeJ3d0tQy0beNXQpTa1C+1pY3yuwdMR7tOYcJb9t
hlE7KDbRZTTVrDwpKoO/e3czUdvivBJN3vwxg7IXI4GJKkrG6LPo12DYd2w0
SgE/nvd+Qq2S60w0uCUc1qKVknJPrZKSDo/bwIKH8SoQTw==
  "]]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.655816104279544*^9, 3.655817232654749*^9, 
  3.6558184564237747`*^9, 3.656054752192738*^9, 3.6560614909306383`*^9, 
  3.656159617310993*^9, 3.656236675056547*^9, 3.65702362559877*^9, 
  3.657023949661059*^9, 3.657024194288419*^9, 3.657024275598772*^9, 
  3.657272940261656*^9, 3.658647663985179*^9, 3.6588393730660343`*^9, 
  3.658839720599745*^9, 3.659073738917429*^9, 3.659073884234521*^9, 
  3.659074175656254*^9, 3.659075056893663*^9, 3.6646172248676577`*^9, 
  3.664617534020952*^9, 3.6647867617373447`*^9, 3.664787165383065*^9, 
  3.664787460330158*^9, 3.664788318052705*^9, 3.665473066866181*^9, 
  3.665486822056654*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ckMassSpectrum", "=", 
  RowBox[{"CheckMassSpectrum", "[", "LRM", "]"}]}]], "Input",
 CellChangeTimes->{{3.634888622211748*^9, 3.634888632248946*^9}, {
   3.647152922842223*^9, 3.647152923225006*^9}, 3.6478520606930017`*^9, 
   3.654589365667865*^9, {3.655557688936022*^9, 3.655557693221458*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwdzl1I02EYxuH/PNAZUoiGKRYuJLNmqBTaPpzvRFuDptmCnDV0brbZ0oiM
DRdGSdnMZmZYKRIlxQYKtpkZIpVMD+acYLNooE5Dlu+Q2Mzog9bzeHBznd38
OKqGcg2LYZhSWNftnN+RREr0xhsJzE5Kvmb71WouJcb7K9JakMfwjp/LoiQt
55JTA37ZIZ4cBWP2ZaW9BdWuYxJU9n2XHL0a2+tB4+z1ITQ9s9zwgEfJ8jOH
V8enRPSRrKJPupPk9SBbstfYAHacL+hAM38FC++Bns7BYtS/eN06BmYonGtH
BJRUr6fU5YFcG6sFXb9ldwlBtoFrrAIDSb0bqO3R0f3VoHImwXQBNKfGz2/Z
/GcJlean7taDnyd70tFZY4wEnZ6ZuoguTH1ruQMuKkO1ZvCloj2MRpmTM9pA
TuMrPjoe0IbRUO6PQ3fBU27dc9QjsHxCD2g5mxZQ8y9+YBhsffr4HdrX2tU0
CgY/uJoDoEL3WruGfWFpI9reVhFFwcMr6h50xKH4qxRS0s0aKFGBuXxZdie4
9HBodgQMvp+bRycuNwnfgAUvrsXni+C3OJa3ZaTmDNo/fFOFVrnn3EOgLa9s
+0kxJSUTq9ZBUCuq9KIp1JDMKaJELu4/iC7/FJShyoracXTBUuO3n6CkbnMb
2wEyYyZrtIySyqINHxpn8zIx4LQvWo9GCq84T5dSkrjHZzoL/geq+TRH
  "]],

Cell[BoxData["\<\"All mass terms are diagonal.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwdzl9Ik2EYhvFvHrgZUgwLUwxcSGbNUCm0uTnfibYGTbMFOWvo3GyzpREZ
Gy4Mk7KZzcywUiRKig0UzJlZIpVMD+acYLNooE5Dlu+Q2MzoD63n8eDmd3Zz
8dR1pVoWwzDFsM5bmb8jOykxmJrimF2UfM3wazR8Skz3VmTVoIARHD+XTkly
5iWnFvyyQzI5CrL3pSe/ATWuY1JU/n23Ar0a0+NBY4dqQ2hKWqnxvoCS5acO
rz6XEvFHsoo+7opX1IIc6V5THdh+Pq8dTfsVzL8LejoGClH/4nXbGJiqdK4d
EVJSuZ5Ykw3y7axmdP3mkEsEcox8UwUYiO/ZQO0Pj+6vBFUzceYLoCWJO79l
458lVJaTtMcAfp7sTkFnTWwpOj0zdRFdmPrWfBtcVIWqLeALZVsYjbIkpLaC
vPqXueh4QBdGQ1k/Dt0BT7n1z1CP0PoJPaDjbVpB7T9u/zDY8uTRO7S3pbNh
FAx+cDUGQKX+lW4N+8KyerSttSyKgodXNN3oiEP5VyWipIvVX6QGs3LlGR3g
0oPB2REw+H5uHp243CB6DeY9v8bNEcNvYYxgy0jVGbRv+IYarXDPuQdBe3bJ
9pMSSoomVm0DoE5c7kUTqTGBV0CJQtJ3EF3+KSxBVWXV4+iCtco/dIKSms1t
HAfIjJlt0XJKygs2fGis3cuwwWlftAGN5F9xni6mpOmtz3wW/A+ytDVS
  "]],

Cell[BoxData["\<\"Getting mass spectrum.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwdzl9Ik2EYhvFvHrgZUgwLUwxcSGbNUClm23S+E20NmmYLctbSua3NlkZk
bLgwSspmNjPDSpEoKTZQsM3MEKlkejDnBJtFgjoNWb4iMs3oD63n8eDmd3Zz
8TQ1JToWwzBFsLY7mb8jOykxWW7GMbso+ZYR1Gr5lFgeLMr1oJARHj+XTkly
5mWPDvy6Qzo6CLL3pSe/A7XeYzJUsbZbiV6L6fSjsa7qMJqSVmJ+KKRk4bk7
YBRRIvlEltCn7fHKapAj22upAVsu5Lagab9W8u6D/tbeAjQ4d8MxBKaqPMtH
xJRUrCZWCUC+k9WArt52eXNAjplvKQdD8Z0bqPPx0f0VoHoiznoRtCVxp7es
/zOPyrOT9pjAL6MdKeikhS1DxyfGLqGzY98b7oJz6rDeBr5SNa+jUbaE1CaQ
V/tahA6HDOtoOOvHoXvgKZ/xBeoX2z+jBwy8TTuo+8ft6Qcbnz15j3Y1ttUN
gisfvfUhUGV8Y1jGvnV5LdrcVBpFwcOL2g50wK36q86hpJ3VU6gBs0SKjFZw
/lHf5AC48mFqGh25UpfzFsx9eZ2bLYHfghjhlpHKM2h3/y0NWu6b8vWBTkHx
9pNSSgpHlhy9oEFSFkATqTmBl0+JUtp9EF34KS5G1aX6YXTWXhl0naCkanMb
xw0yQ1ZHtIKSsvyNGTTWGWDY4PhMtAmN5F31nC6iRHB+zXoW/A+uVjTA
  "]],

Cell[BoxData["\<\"Checking for less then 0.1% agreement with model file \
values.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwdzl1I02EYxuH/PHAzpBgWphi4kMyaoVJo+1DfibYGTbMFOWvo3OZmSyMy
NlwYJWUzm5lhpUiUFBso2GZmiFQyPZhTwWaRoE5Dlu8Q2czog9bzeHBznd38
eOq6Ui2LYZhiWMedzN+R3ZQYzTfjmD2UfMvwazR8SswPVmQ6UMAITl5IpyQ5
87JbC37dJRkfBtkH0pPfgRrPCSkq39irQK/FdE+jsc7aEJqSVmp6KKBk+bnL
ZxBSkveJrKJPO+MVtSBHut9cB7ZV57ahab+C+ffB6fb+QtS/eMM+AqYq3WvH
RJRUrifWZIN8B6sJXb/t9IhBjolvrgAD8d2bqOPx8YOVoGoqznIRtCZx57Zt
/LOEynKS9hnBL+NdKeiMmS1FJ6cmLqELE9+b7oKLqpDOCr5StobRKGtCagvI
q38tREcD+jAayvpx5B54xmt4gU6LbJ/RQ3relg3U/uP2DYLNz568R3uaOxqG
weBHT2MAVBre6NewLyyrR1tbyqIoeHRF04UOuZR/VWJKOll9RWowSyjPaAeX
Hg3MDIHBD7Nz6NiVBvFbMPfldW5OHvwWxgi2jVSdQ3sHb6nRCu+sdwB0ZJfs
PC2hpGhs1d4P6vPKfWgiNSXwCihRSHoPo8s/RSWoqkw3ii7YqvzOU5TUbO3g
uEBmxGKPllNSXrA5j8Y6fAwbnJyPNqKR/Kvus8WUjFdvWM6D/wGzBjVX
  "]]
}, Open  ]],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Particle\"\>", "\<\"Analytic value\"\>", "\<\"Numerical value\"\>", \
"\<\"Model-file value\"\>"},
    {"DM", 
     SubscriptBox["M", "DM"], "800.`", "800.`"},
    {"X", 
     SubscriptBox["M", "X"], "880.`", "880.`"},
    {"M", 
     SqrtBox[
      SubsuperscriptBox["M", "M", "2"]], "600.`", "600.`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGCwAOKID2wt5javHS1uPTptC6RrdlhXJgBpny2nvoBokQ32
GolA+lWMYk02kN6lK34NRP9nZXoIov8tVZLNAdIhkqdVQLTcJRMPEH3z/Otc
EG01Wbq1E0jX2iqmd4HUr9z9GUQr7FdU7wbS21h3WoNou5ruzyD6Z+ZvvR4g
fV6oYDGIzvk29zqInrbW4Fs/kK62k1u7FUiXbFl6AETbnJ9VvRNI9938Uv8C
SAe4vs94BaQ3aTaWgujbJn1Mr0H23Zk5G0S3zJ74J872teOl3ttuSUC680ie
wSQgfabo1YXtQLo9ju86iP7FtNV2B5BeXrFa0MIeaK+SvRWIzllUFQGita5P
SALRxvFs5zYCafmMdr5AJ6C5p3hWrQPSUStbr4Lof4c6JBWdge4U2aUNoqMu
JQeA6FVBPftAtFHFpIebfV87NvWbcGwB0h07V6xk83vtaDtL5g6I/r6QgZEd
SCdx6OeA6JBvPUdD/V87+hV9qIkB0gAq1dtG
  "]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Combine", " ", "the", " ", "results", " ", "of", " ", "all", " ", 
    "checks"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
     "ckHermiticity", "&&", "ckQuantumNumbers", "&&", 
      "ckDiagonalKineticTerms", "&&", "ckDiagonalMassTerms", "&&", 
      "ckDiagonalQuadraticTerms", "&&", "ckKineticTermNormalisation", "&&", 
      RowBox[{"FreeQ", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", 
            RowBox[{"#", "[", 
             RowBox[{"[", "4", "]"}], "]"}]}], ")"}], "&"}], "/@", 
         RowBox[{"Drop", "[", 
          RowBox[{
           RowBox[{"ckMassSpectrum", "//", "First"}], ",", "1"}], "]"}]}], 
        ",", "False"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"Style", "[", 
       RowBox[{
       "\"\<All FeynRules checks have succeeded.\>\"", ",", "Orange", ",", 
        "Bold"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"Style", "[", 
       RowBox[{
       "\"\<Some FeynRules checks have failed.\>\"", ",", "Red", ",", 
        "Bold"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"Style", "[", 
       RowBox[{
       "\"\<Some FeynRules checks have failed.\>\"", ",", "Red", ",", 
        "Bold"}], "]"}], "]"}]}], "\[IndentingNewLine]", "]"}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.655557489479282*^9, 3.65555763719306*^9}, {
   3.6555576740579*^9, 3.655557686442938*^9}, {3.6555579349741383`*^9, 
   3.6555579357716846`*^9}, 3.66547305494538*^9, {3.665486810475178*^9, 
   3.665486810721043*^9}}],

Cell[BoxData[
 StyleBox["\<\"All FeynRules checks have succeeded.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.65555763858834*^9, {3.655557699900114*^9, 3.655557714422707*^9}, 
   3.6555579368053083`*^9, 3.6555579995146313`*^9, 3.655617577130252*^9, 
   3.6556193853549967`*^9, 3.655620510177223*^9, 3.655620921185185*^9, 
   3.655621086125058*^9, 3.655622556705308*^9, 3.655623031961874*^9, 
   3.655623963657867*^9, 3.6556243810180798`*^9, 3.655630769869128*^9, 
   3.655708009110869*^9, 3.655708165516589*^9, 3.655715805190654*^9, 
   3.6558120958829737`*^9, 3.655816007655499*^9, 3.655816108329937*^9, 
   3.655817236714216*^9, 3.6558184610730352`*^9, 3.65605475683356*^9, 
   3.656061495207274*^9, 3.656159619754793*^9, 3.657023629573357*^9, 
   3.657023954189279*^9, 3.6570241960812597`*^9, 3.657024276781888*^9, 
   3.6572729444337797`*^9, 3.658647668499201*^9, 3.658839376685717*^9, 
   3.658839724510497*^9, 3.659073740544881*^9, 3.659073886139926*^9, 
   3.659074179461953*^9, 3.659075060698118*^9, 3.664617228772047*^9, 
   3.6646175378752537`*^9, 3.6647867655264053`*^9, 3.664787169175674*^9, 
   3.664787464324778*^9, 3.6647883217039423`*^9, 3.665473068527873*^9, {
   3.665486811937519*^9, 3.665486823655128*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Decay Widths", "Subsection",
 CellChangeTimes->{{3.6557158211451597`*^9, 3.6557158258725767`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{
    RowBox[{"MM", "\[Element]", "Reals"}], "&&", 
    RowBox[{"MM", ">", "0"}], "&&", 
    RowBox[{"\[CapitalDelta]", "\[Element]", "Reals"}], "&&", 
    RowBox[{"\[CapitalDelta]", ">", "0"}], "&&", 
    RowBox[{"\[Tau]", "\[Element]", "Reals"}], "&&", 
    RowBox[{"\[Tau]", ">", "0"}], "&&", 
    RowBox[{"\[Tau]SM", "\[Element]", "Reals"}], "&&", 
    RowBox[{"\[Tau]SM", ">", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Unprotect", "[", 
   RowBox[{"verticesRM", ",", "decaysRM"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"verticesRM", ",", "decaysRM"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"verticesRM", "=", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{"LRM", ",", 
     RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"decaysRM", "=", 
   RowBox[{"ComputeWidths", "[", "verticesRM", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"verticesRM", ",", "decaysRM"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.656316345406905*^9, 3.656316372596243*^9}, {
  3.66462115607552*^9, 3.664621156651512*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.656316373329444*^9, 3.656320672372623*^9, 
  3.6563221580463333`*^9, 3.657272945459958*^9, 3.65794774385843*^9, 
  3.657955430927693*^9, 3.658035722530676*^9, 3.658037548801907*^9, 
  3.6588397255521097`*^9, 3.659073758192252*^9, 3.659073959188405*^9, 
  3.659074251176793*^9, 3.659075066935491*^9, 3.659092663010632*^9, 
  3.6590946265709476`*^9, 3.659171290866943*^9, 3.659172107014064*^9, 
  3.664618711075767*^9, 3.664620710785681*^9, 3.664620867789566*^9, 
  3.6646211598559313`*^9, 3.664622148542858*^9, 3.664626822306036*^9, 
  3.6647075291340437`*^9, 3.664707724667346*^9, 3.6647085238433313`*^9, 
  3.664787537413168*^9, 3.664788322747801*^9, 3.6652930172729883`*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.656316373329444*^9, 3.656320672372623*^9, 
  3.6563221580463333`*^9, 3.657272945459958*^9, 3.65794774385843*^9, 
  3.657955430927693*^9, 3.658035722530676*^9, 3.658037548801907*^9, 
  3.6588397255521097`*^9, 3.659073758192252*^9, 3.659073959188405*^9, 
  3.659074251176793*^9, 3.659075066935491*^9, 3.659092663010632*^9, 
  3.6590946265709476`*^9, 3.659171290866943*^9, 3.659172107014064*^9, 
  3.664618711075767*^9, 3.664620710785681*^9, 3.664620867789566*^9, 
  3.6646211598559313`*^9, 3.664622148542858*^9, 3.664626822306036*^9, 
  3.6647075291340437`*^9, 3.664707724667346*^9, 3.6647085238433313`*^9, 
  3.664787537413168*^9, 3.664788322747801*^9, 3.665293017274901*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.656316373329444*^9, 3.656320672372623*^9, 
  3.6563221580463333`*^9, 3.657272945459958*^9, 3.65794774385843*^9, 
  3.657955430927693*^9, 3.658035722530676*^9, 3.658037548801907*^9, 
  3.6588397255521097`*^9, 3.659073758192252*^9, 3.659073959188405*^9, 
  3.659074251176793*^9, 3.659075066935491*^9, 3.659092663010632*^9, 
  3.6590946265709476`*^9, 3.659171290866943*^9, 3.659172107014064*^9, 
  3.664618711075767*^9, 3.664620710785681*^9, 3.664620867789566*^9, 
  3.6646211598559313`*^9, 3.664622148542858*^9, 3.664626822306036*^9, 
  3.6647075291340437`*^9, 3.664707724667346*^9, 3.6647085238433313`*^9, 
  3.664787537413168*^9, 3.664788322747801*^9, 3.665293017719219*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "16", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{121., {2., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "16", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  16, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 16, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656316373329444*^9, 3.656320672372623*^9, 
  3.6563221580463333`*^9, 3.657272945459958*^9, 3.65794774385843*^9, 
  3.657955430927693*^9, 3.658035722530676*^9, 3.658037548801907*^9, 
  3.6588397255521097`*^9, 3.659073758192252*^9, 3.659073959188405*^9, 
  3.659074251176793*^9, 3.659075066935491*^9, 3.659092663010632*^9, 
  3.6590946265709476`*^9, 3.659171290866943*^9, 3.659172107014064*^9, 
  3.664618711075767*^9, 3.664620710785681*^9, 3.664620867789566*^9, 
  3.6646211598559313`*^9, 3.664622148542858*^9, 3.664626822306036*^9, 
  3.6647075291340437`*^9, 3.664707724667346*^9, 3.6647085238433313`*^9, 
  3.664787537413168*^9, 3.664788322747801*^9, 3.6652930177586184`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"16", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[16, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656316373329444*^9, 3.656320672372623*^9, 
  3.6563221580463333`*^9, 3.657272945459958*^9, 3.65794774385843*^9, 
  3.657955430927693*^9, 3.658035722530676*^9, 3.658037548801907*^9, 
  3.6588397255521097`*^9, 3.659073758192252*^9, 3.659073959188405*^9, 
  3.659074251176793*^9, 3.659075066935491*^9, 3.659092663010632*^9, 
  3.6590946265709476`*^9, 3.659171290866943*^9, 3.659172107014064*^9, 
  3.664618711075767*^9, 3.664620710785681*^9, 3.664620867789566*^9, 
  3.6646211598559313`*^9, 3.664622148542858*^9, 3.664626822306036*^9, 
  3.6647075291340437`*^9, 3.664707724667346*^9, 3.6647085238433313`*^9, 
  3.664787537413168*^9, 3.664788322747801*^9, 3.665293018134523*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{73., {2., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "16"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 16],
  Editable->False]], "Print",
 CellChangeTimes->{3.656316373329444*^9, 3.656320672372623*^9, 
  3.6563221580463333`*^9, 3.657272945459958*^9, 3.65794774385843*^9, 
  3.657955430927693*^9, 3.658035722530676*^9, 3.658037548801907*^9, 
  3.6588397255521097`*^9, 3.659073758192252*^9, 3.659073959188405*^9, 
  3.659074251176793*^9, 3.659075066935491*^9, 3.659092663010632*^9, 
  3.6590946265709476`*^9, 3.659171290866943*^9, 3.659172107014064*^9, 
  3.664618711075767*^9, 3.664620710785681*^9, 3.664620867789566*^9, 
  3.6646211598559313`*^9, 3.664622148542858*^9, 3.664626822306036*^9, 
  3.6647075291340437`*^9, 3.664707724667346*^9, 3.6647085238433313`*^9, 
  3.664787537413168*^9, 3.664788322747801*^9, 3.6652930184743643`*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.656316373329444*^9, 3.656320672372623*^9, 
  3.6563221580463333`*^9, 3.657272945459958*^9, 3.65794774385843*^9, 
  3.657955430927693*^9, 3.658035722530676*^9, 3.658037548801907*^9, 
  3.6588397255521097`*^9, 3.659073758192252*^9, 3.659073959188405*^9, 
  3.659074251176793*^9, 3.659075066935491*^9, 3.659092663010632*^9, 
  3.6590946265709476`*^9, 3.659171290866943*^9, 3.659172107014064*^9, 
  3.664618711075767*^9, 3.664620710785681*^9, 3.664620867789566*^9, 
  3.6646211598559313`*^9, 3.664622148542858*^9, 3.664626822306036*^9, 
  3.6647075291340437`*^9, 3.664707724667346*^9, 3.6647085238433313`*^9, 
  3.664787537413168*^9, 3.664788322747801*^9, 3.6652930186694183`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{122., {2., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "10"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 10],
  Editable->False]], "Print",
 CellChangeTimes->{3.656316373329444*^9, 3.656320672372623*^9, 
  3.6563221580463333`*^9, 3.657272945459958*^9, 3.65794774385843*^9, 
  3.657955430927693*^9, 3.658035722530676*^9, 3.658037548801907*^9, 
  3.6588397255521097`*^9, 3.659073758192252*^9, 3.659073959188405*^9, 
  3.659074251176793*^9, 3.659075066935491*^9, 3.659092663010632*^9, 
  3.6590946265709476`*^9, 3.659171290866943*^9, 3.659172107014064*^9, 
  3.664618711075767*^9, 3.664620710785681*^9, 3.664620867789566*^9, 
  3.6646211598559313`*^9, 3.664622148542858*^9, 3.664626822306036*^9, 
  3.6647075291340437`*^9, 3.664707724667346*^9, 3.6647085238433313`*^9, 
  3.664787537413168*^9, 3.664788322747801*^9, 3.665293018670682*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Leptoquark", "Subsubsection",
 CellChangeTimes->{{3.6557158422943287`*^9, 3.655715852225478*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"ModelFile", "\[Equal]", "\"\<model_lq_met.fr\>\""}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ClearAll", "[", 
      RowBox[{
      "\[CapitalGamma]M1toDMX1", ",", "\[CapitalGamma]M2toDMX2", ",", 
       "\[CapitalGamma]M1toue", ",", "\[CapitalGamma]M2tode"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]M1toDMX1", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Cases", "[", 
           RowBox[{"decaysRM", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{"M1", ",", "X1", ",", "DMbar"}], "}"}], "|", 
               RowBox[{"{", 
                RowBox[{"M1", ",", "DMbar", ",", "X1"}], "}"}]}], ",", "_"}], 
             "}"}]}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"MX1", "\[Rule]", "MX"}], ",", 
           RowBox[{"MX2", "\[Rule]", "MX"}], ",", 
           RowBox[{"MM1", "\[Rule]", "MM"}], ",", 
           RowBox[{"MM2", "\[Rule]", "MM"}]}], "}"}]}], ")"}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]M2toDMX2", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Cases", "[", 
           RowBox[{"decaysRM", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{"M2", ",", "X2", ",", "DMbar"}], "}"}], "|", 
               RowBox[{"{", 
                RowBox[{"M2", ",", "DMbar", ",", "X2"}], "}"}]}], ",", "_"}], 
             "}"}]}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"MX1", "\[Rule]", "MX"}], ",", 
           RowBox[{"MX2", "\[Rule]", "MX"}], ",", 
           RowBox[{"MM1", "\[Rule]", "MM"}], ",", 
           RowBox[{"MM2", "\[Rule]", "MM"}]}], "}"}]}], ")"}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]M1toue", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Cases", "[", 
           RowBox[{"decaysRM", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{"M1", ",", "u", ",", "ebar"}], "}"}], "|", 
               RowBox[{"{", 
                RowBox[{"M1", ",", "ebar", ",", "u"}], "}"}]}], ",", "_"}], 
             "}"}]}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"MX1", "\[Rule]", "MX"}], ",", 
           RowBox[{"MX2", "\[Rule]", "MX"}], ",", 
           RowBox[{"MM1", "\[Rule]", "MM"}], ",", 
           RowBox[{"MM2", "\[Rule]", "MM"}]}], "}"}]}], ")"}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]M2tode", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Cases", "[", 
           RowBox[{"decaysRM", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{"M2", ",", "d", ",", "ebar"}], "}"}], "|", 
               RowBox[{"{", 
                RowBox[{"M2", ",", "ebar", ",", "d"}], "}"}]}], ",", "_"}], 
             "}"}]}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"MX1", "\[Rule]", "MX"}], ",", 
           RowBox[{"MX2", "\[Rule]", "MX"}], ",", 
           RowBox[{"MM1", "\[Rule]", "MM"}], ",", 
           RowBox[{"MM2", "\[Rule]", "MM"}]}], "}"}]}], ")"}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]M2tou\[Nu]", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Cases", "[", 
           RowBox[{"decaysRM", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{"M2", ",", "u", ",", "vebar"}], "}"}], "|", 
               RowBox[{"{", 
                RowBox[{"M2", ",", "vebar", ",", "u"}], "}"}]}], ",", "_"}], 
             "}"}]}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"MX1", "\[Rule]", "MX"}], ",", 
           RowBox[{"MX2", "\[Rule]", "MX"}], ",", 
           RowBox[{"MM1", "\[Rule]", "MM"}], ",", 
           RowBox[{"MM2", "\[Rule]", "MM"}]}], "}"}]}], ")"}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     
     RowBox[{"\[CapitalGamma]M1toDMX1", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[CapitalGamma]M1toDMX1", "/.", 
            RowBox[{"{", 
             RowBox[{"MX", "\[Rule]", 
              RowBox[{"MDM", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[CapitalDelta]"}], ")"}]}]}], "}"}]}], "//",
            "FullSimplify"}], ")"}], "/.", 
         RowBox[{"MDM", "\[Rule]", 
          SqrtBox[
           RowBox[{"\[Tau]", "*", 
            SuperscriptBox["MM", "2"]}]]}]}], ")"}], "//", "FullSimplify"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]M2toDMX2", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[CapitalGamma]M2toDMX2", "/.", 
            RowBox[{"{", 
             RowBox[{"MX", "\[Rule]", 
              RowBox[{"MDM", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[CapitalDelta]"}], ")"}]}]}], "}"}]}], "//",
            "FullSimplify"}], ")"}], "/.", 
         RowBox[{"MDM", "\[Rule]", 
          SqrtBox[
           RowBox[{"\[Tau]", "*", 
            SuperscriptBox["MM", "2"]}]]}]}], ")"}], "//", "FullSimplify"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]M1toue", "=", 
      RowBox[{
       RowBox[{"\[CapitalGamma]M1toue", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"MU", "\[Rule]", 
           SqrtBox[
            RowBox[{
             SubscriptBox["\[Tau]", "u"], "*", 
             SuperscriptBox["MM", "2"]}]]}], ",", 
          RowBox[{"Me", "\[Rule]", "0"}]}], "}"}]}], "//", "FullSimplify"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]M2tode", "=", 
      RowBox[{
       RowBox[{"\[CapitalGamma]M2tode", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"MD", "\[Rule]", 
           SqrtBox[
            RowBox[{
             SubscriptBox["\[Tau]", "d"], "*", 
             SuperscriptBox["MM", "2"]}]]}], ",", 
          RowBox[{"Me", "\[Rule]", "0"}]}], "}"}]}], "//", "FullSimplify"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]M2tou\[Nu]", "=", 
      RowBox[{
       RowBox[{"\[CapitalGamma]M2tou\[Nu]", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"MU", "\[Rule]", 
           SqrtBox[
            RowBox[{
             SubscriptBox["\[Tau]", "u"], "*", 
             SuperscriptBox["MM", "2"]}]]}], ",", 
          RowBox[{"Me", "\[Rule]", "0"}]}], "}"}]}], "//", "FullSimplify"}]}],
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\[CapitalGamma]M1toDMX1 = \>\"", ",", "\[CapitalGamma]M1toDMX1"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\[CapitalGamma]M2toDMX2 = \>\"", ",", "\[CapitalGamma]M2toDMX2"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\[CapitalGamma]M1toue = \>\"", ",", "\[CapitalGamma]M1toue"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\[CapitalGamma]M2tode = \>\"", ",", "\[CapitalGamma]M2tode"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\[CapitalGamma]M2tou\[Nu] = \>\"", ",", 
       "\[CapitalGamma]M2tou\[Nu]"}], "]"}], ";"}]}], "\[IndentingNewLine]", 
   "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.6563162141476107`*^9, 3.656316252063292*^9}, {
   3.6563163079747877`*^9, 3.6563163137517853`*^9}, {3.656316381871518*^9, 
   3.656316384771652*^9}, {3.656316420359488*^9, 3.656316453631982*^9}, {
   3.656318939898245*^9, 3.65631894685436*^9}, 3.6563206515527*^9, {
   3.656320683219551*^9, 3.656320730889275*^9}, 3.65632076728203*^9, {
   3.656320806729951*^9, 3.656320810681159*^9}, {3.656322099443153*^9, 
   3.656322099954748*^9}, {3.656322139690195*^9, 3.656322312083233*^9}, {
   3.6563223510144033`*^9, 3.6563223939158287`*^9}, {3.656322474059771*^9, 
   3.6563225345246563`*^9}, {3.656322636052237*^9, 3.656322708708234*^9}, {
   3.659171262415204*^9, 3.659171300792068*^9}, {3.659171526367646*^9, 
   3.6591716087777023`*^9}, {3.659171719846974*^9, 3.6591717615108356`*^9}, {
   3.65917182439965*^9, 3.659171846101592*^9}, {3.65917187909525*^9, 
   3.659171897972974*^9}, {3.659171941191195*^9, 3.6591719598565693`*^9}, {
   3.664622183903256*^9, 3.664622197770788*^9}, {3.664623832621648*^9, 
   3.664623849223935*^9}, {3.66462408767135*^9, 3.664624094187992*^9}, {
   3.664624394785861*^9, 3.664624396173077*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[CapitalGamma]M1toDMX1 = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"MM", " ", 
      SubsuperscriptBox["y", "D", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"2", "+", "\[CapitalDelta]"}], ")"}], "2"], " ", 
         "\[Tau]"}]}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           SuperscriptBox["\[CapitalDelta]", "2"], " ", "\[Tau]"}]}], ")"}], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"2", "+", "\[CapitalDelta]"}], ")"}], "2"], " ", 
           "\[Tau]"}]}], ")"}]}]]}], 
     RowBox[{"8", " ", "\[Pi]"}]]}]}],
  SequenceForm[
  "\[CapitalGamma]M1toDMX1 = ", Rational[-1, 8] $CellContext`MM 
   Pi^(-1) $CellContext`yD^2 (-1 + (
       2 + $CellContext`\[CapitalDelta])^2 $CellContext`\[Tau]) ((-1 + \
$CellContext`\[CapitalDelta]^2 $CellContext`\[Tau]) (-1 + (
         2 + $CellContext`\[CapitalDelta])^2 $CellContext`\[Tau]))^
    Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.65917173771987*^9, {3.6591718837170057`*^9, 3.65917189897104*^9}, 
   3.659171960521044*^9, 3.664622219888534*^9, 3.664622921560031*^9, {
   3.664623837673608*^9, 3.664623850097834*^9}, 3.664624094950416*^9, 
   3.664624397530715*^9, 3.664624544187099*^9, {3.6647085199321823`*^9, 
   3.6647085299825563`*^9}, {3.664788329007606*^9, 3.664788330597349*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[CapitalGamma]M2toDMX2 = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"MM", " ", 
      SubsuperscriptBox["y", "D", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"2", "+", "\[CapitalDelta]"}], ")"}], "2"], " ", 
         "\[Tau]"}]}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           SuperscriptBox["\[CapitalDelta]", "2"], " ", "\[Tau]"}]}], ")"}], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"2", "+", "\[CapitalDelta]"}], ")"}], "2"], " ", 
           "\[Tau]"}]}], ")"}]}]]}], 
     RowBox[{"8", " ", "\[Pi]"}]]}]}],
  SequenceForm[
  "\[CapitalGamma]M2toDMX2 = ", Rational[-1, 8] $CellContext`MM 
   Pi^(-1) $CellContext`yD^2 (-1 + (
       2 + $CellContext`\[CapitalDelta])^2 $CellContext`\[Tau]) ((-1 + \
$CellContext`\[CapitalDelta]^2 $CellContext`\[Tau]) (-1 + (
         2 + $CellContext`\[CapitalDelta])^2 $CellContext`\[Tau]))^
    Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.65917173771987*^9, {3.6591718837170057`*^9, 3.65917189897104*^9}, 
   3.659171960521044*^9, 3.664622219888534*^9, 3.664622921560031*^9, {
   3.664623837673608*^9, 3.664623850097834*^9}, 3.664624094950416*^9, 
   3.664624397530715*^9, 3.664624544187099*^9, {3.6647085199321823`*^9, 
   3.6647085299825563`*^9}, {3.664788329007606*^9, 3.664788330598588*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[CapitalGamma]M1toue = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"MM", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["yLu1x1", "2"], "+", 
        SuperscriptBox["yQl1x1", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SubscriptBox["\[Tau]", "u"]}], ")"}], " ", 
      SqrtBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SubscriptBox["\[Tau]", "u"]}], ")"}], "2"]]}], 
     RowBox[{"16", " ", "\[Pi]"}]]}]}],
  SequenceForm[
  "\[CapitalGamma]M1toue = ", Rational[-1, 16] $CellContext`MM 
   Pi^(-1) ($CellContext`yLu1x1^2 + $CellContext`yQl1x1^2) (-1 + 
    Subscript[$CellContext`\[Tau], FeynRules`u]) ((-1 + 
      Subscript[$CellContext`\[Tau], FeynRules`u])^2)^Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.65917173771987*^9, {3.6591718837170057`*^9, 3.65917189897104*^9}, 
   3.659171960521044*^9, 3.664622219888534*^9, 3.664622921560031*^9, {
   3.664623837673608*^9, 3.664623850097834*^9}, 3.664624094950416*^9, 
   3.664624397530715*^9, 3.664624544187099*^9, {3.6647085199321823`*^9, 
   3.6647085299825563`*^9}, {3.664788329007606*^9, 3.664788330599719*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[CapitalGamma]M2tode = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"MM", " ", 
      SuperscriptBox["yQl1x1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SubscriptBox["\[Tau]", "d"]}], ")"}], " ", 
      SqrtBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SubscriptBox["\[Tau]", "d"]}], ")"}], "2"]]}], 
     RowBox[{"16", " ", "\[Pi]"}]]}]}],
  SequenceForm[
  "\[CapitalGamma]M2tode = ", Rational[-1, 16] $CellContext`MM 
   Pi^(-1) $CellContext`yQl1x1^2 (-1 + 
    Subscript[$CellContext`\[Tau], FeynRules`d]) ((-1 + 
      Subscript[$CellContext`\[Tau], FeynRules`d])^2)^Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.65917173771987*^9, {3.6591718837170057`*^9, 3.65917189897104*^9}, 
   3.659171960521044*^9, 3.664622219888534*^9, 3.664622921560031*^9, {
   3.664623837673608*^9, 3.664623850097834*^9}, 3.664624094950416*^9, 
   3.664624397530715*^9, 3.664624544187099*^9, {3.6647085199321823`*^9, 
   3.6647085299825563`*^9}, {3.664788329007606*^9, 3.6647883306010513`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[CapitalGamma]M2tou\[Nu] = \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"MM", " ", 
     SuperscriptBox["yLu1x1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SubscriptBox["\[Tau]", "u"]}], ")"}], "2"]}], 
    RowBox[{"16", " ", "\[Pi]"}]]}],
  SequenceForm[
  "\[CapitalGamma]M2tou\[Nu] = ", Rational[1, 16] $CellContext`MM 
   Pi^(-1) $CellContext`yLu1x1^2 (-1 + 
     Subscript[$CellContext`\[Tau], FeynRules`u])^2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.65917173771987*^9, {3.6591718837170057`*^9, 3.65917189897104*^9}, 
   3.659171960521044*^9, 3.664622219888534*^9, 3.664622921560031*^9, {
   3.664623837673608*^9, 3.664623850097834*^9}, 3.664624094950416*^9, 
   3.664624397530715*^9, 3.664624544187099*^9, {3.6647085199321823`*^9, 
   3.6647085299825563`*^9}, {3.664788329007606*^9, 3.664788330602023*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Triplet Diquark", "Subsubsection",
 CellChangeTimes->{{3.65571583385673*^9, 3.655715838406135*^9}, {
  3.659094628764142*^9, 3.6590946305659037`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"ModelFile", "\[Equal]", "\"\<model_dq3_met.fr\>\""}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ClearAll", "[", 
      RowBox[{"\[CapitalGamma]MtoDMX", ",", "\[CapitalGamma]Mtoud"}], "]"}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]MtoDMX", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Cases", "[", 
           RowBox[{"decaysRM", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{"M", ",", "X", ",", "DMbar"}], "}"}], "|", 
               RowBox[{"{", 
                RowBox[{"M", ",", "DMbar", ",", "X"}], "}"}]}], ",", "_"}], 
             "}"}]}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"MX1", "\[Rule]", "MX"}], ",", 
           RowBox[{"MX2", "\[Rule]", "MX"}], ",", 
           RowBox[{"MM1", "\[Rule]", "MM"}], ",", 
           RowBox[{"MM2", "\[Rule]", "MM"}]}], "}"}]}], ")"}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]Mtoud", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Cases", "[", 
           RowBox[{"decaysRM", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{"M", ",", "dbar", ",", "ubar"}], "}"}], "|", 
               RowBox[{"{", 
                RowBox[{"M", ",", "ubar", ",", "dbar"}], "}"}]}], ",", "_"}], 
             "}"}]}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"MX1", "\[Rule]", "MX"}], ",", 
           RowBox[{"MX2", "\[Rule]", "MX"}], ",", 
           RowBox[{"MM1", "\[Rule]", "MM"}], ",", 
           RowBox[{"MM2", "\[Rule]", "MM"}]}], "}"}]}], ")"}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]Mtotb", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Cases", "[", 
           RowBox[{"decaysRM", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{"M", ",", "bbar", ",", "tbar"}], "}"}], "|", 
               RowBox[{"{", 
                RowBox[{"M", ",", "tbar", ",", "bbar"}], "}"}]}], ",", "_"}], 
             "}"}]}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"MX1", "\[Rule]", "MX"}], ",", 
           RowBox[{"MX2", "\[Rule]", "MX"}], ",", 
           RowBox[{"MM1", "\[Rule]", "MM"}], ",", 
           RowBox[{"MM2", "\[Rule]", "MM"}]}], "}"}]}], ")"}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]MtoDMX", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[CapitalGamma]MtoDMX", "/.", 
            RowBox[{"{", 
             RowBox[{"MX", "\[Rule]", 
              RowBox[{"MDM", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[CapitalDelta]"}], ")"}]}]}], "}"}]}], "//",
            "FullSimplify"}], ")"}], "/.", 
         RowBox[{"MDM", "\[Rule]", 
          SqrtBox[
           RowBox[{"\[Tau]", "*", 
            SuperscriptBox["MM", "2"]}]]}]}], ")"}], "//", "FullSimplify"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]Mtoud", "=", 
      RowBox[{
       RowBox[{"\[CapitalGamma]Mtoud", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"MU", "\[Rule]", "0"}], ",", 
          RowBox[{"MD", "\[Rule]", "0"}]}], "}"}]}], "//", "FullSimplify"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]Mtotb", "=", 
      RowBox[{
       RowBox[{"\[CapitalGamma]Mtotb", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"MT", "\[Rule]", 
           SqrtBox[
            RowBox[{
             SubscriptBox["\[Tau]", "t"], "*", 
             SuperscriptBox["MM", "2"]}]]}], ",", 
          RowBox[{"MB", "\[Rule]", 
           SqrtBox[
            RowBox[{
             SubscriptBox["\[Tau]", "b"], "*", 
             SuperscriptBox["MM", "2"]}]]}]}], "}"}]}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\[CapitalGamma]MtoDMX = \>\"", ",", "\[CapitalGamma]MtoDMX"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\[CapitalGamma]Mtoud = \>\"", ",", "\[CapitalGamma]Mtoud"}], "]"}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\[CapitalGamma]Mtotb = \>\"", ",", "\[CapitalGamma]Mtotb"}], "]"}],
      ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.6563162141476107`*^9, 3.656316252063292*^9}, {
   3.6563163079747877`*^9, 3.6563163137517853`*^9}, {3.656316381871518*^9, 
   3.656316384771652*^9}, {3.656316420359488*^9, 3.656316453631982*^9}, {
   3.656318939898245*^9, 3.65631894685436*^9}, 3.6563206515527*^9, {
   3.656320683219551*^9, 3.656320730889275*^9}, 3.65632076728203*^9, {
   3.656320806729951*^9, 3.656320810681159*^9}, {3.659094654790265*^9, 
   3.659094710019134*^9}, {3.6590947754012003`*^9, 3.659094845260149*^9}, {
   3.6590948977094584`*^9, 3.6590949000331984`*^9}, {3.659094954978931*^9, 
   3.659094985236114*^9}, {3.664622165329677*^9, 3.664622174476706*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[CapitalGamma]MtoDMX = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SubscriptBox["M", "M"], " ", 
      SubsuperscriptBox["y", "D", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"2", "+", "\[CapitalDelta]"}], ")"}], "2"], " ", 
         "\[Tau]"}]}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           SuperscriptBox["\[CapitalDelta]", "2"], " ", "\[Tau]"}]}], ")"}], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"2", "+", "\[CapitalDelta]"}], ")"}], "2"], " ", 
           "\[Tau]"}]}], ")"}]}]]}], 
     RowBox[{"8", " ", "\[Pi]"}]]}]}],
  SequenceForm[
  "\[CapitalGamma]MtoDMX = ", Rational[-1, 8] $CellContext`MM 
   Pi^(-1) $CellContext`yD^2 (-1 + (
       2 + $CellContext`\[CapitalDelta])^2 $CellContext`\[Tau]) ((-1 + \
$CellContext`\[CapitalDelta]^2 $CellContext`\[Tau]) (-1 + (
         2 + $CellContext`\[CapitalDelta])^2 $CellContext`\[Tau]))^
    Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.665293012828898*^9, 3.6652930232058783`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[CapitalGamma]Mtoud = \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SubscriptBox["M", "M"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["yudL1x1", "2"], "+", 
       SuperscriptBox["yudR1x1", "2"]}], ")"}]}], 
    RowBox[{"8", " ", "\[Pi]"}]]}],
  SequenceForm[
  "\[CapitalGamma]Mtoud = ", Rational[1, 8] $CellContext`MM 
   Pi^(-1) ($CellContext`yudL1x1^2 + $CellContext`yudR1x1^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.665293012828898*^9, 3.665293023207079*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[CapitalGamma]Mtotb = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SubscriptBox["M", "M"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["yudL3x3", "2"], "+", 
           SuperscriptBox["yudR3x3", "2"]}], ")"}], " ", 
         SubscriptBox["\[Tau]", "b"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["yudL3x3", "2"], "+", 
           SuperscriptBox["yudR3x3", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SubscriptBox["\[Tau]", "t"]}], ")"}]}], "+", 
        RowBox[{"4", " ", "yudL3x3", " ", "yudR3x3", " ", 
         SqrtBox[
          SubscriptBox["\[Tau]", "b"]], " ", 
         SqrtBox[
          SubscriptBox["\[Tau]", "t"]]}]}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        SubsuperscriptBox["\[Tau]", "b", "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SubscriptBox["\[Tau]", "t"]}], ")"}], "2"], "-", 
        RowBox[{"2", " ", 
         SubscriptBox["\[Tau]", "b"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SubscriptBox["\[Tau]", "t"]}], ")"}]}]}]]}], 
     RowBox[{"8", " ", "\[Pi]"}]]}]}],
  SequenceForm[
  "\[CapitalGamma]Mtotb = ", Rational[-1, 8] $CellContext`MM 
   Pi^(-1) (($CellContext`yudL3x3^2 + $CellContext`yudR3x3^2) 
     Subscript[$CellContext`\[Tau], 
       FeynRules`b] + ($CellContext`yudL3x3^2 + $CellContext`yudR3x3^2) (-1 + 
      Subscript[$CellContext`\[Tau], FeynRules`t]) + 
    4 $CellContext`yudL3x3 $CellContext`yudR3x3 
     Subscript[$CellContext`\[Tau], FeynRules`b]^Rational[1, 2] 
     Subscript[$CellContext`\[Tau], FeynRules`t]^Rational[1, 2]) (
     Subscript[$CellContext`\[Tau], FeynRules`b]^2 + (-1 + 
       Subscript[$CellContext`\[Tau], FeynRules`t])^2 - 2 
     Subscript[$CellContext`\[Tau], FeynRules`b] (1 + 
      Subscript[$CellContext`\[Tau], FeynRules`t]))^Rational[1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.665293012828898*^9, 3.665293023208539*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "\[CapitalGamma]", "]"}], "\[IndentingNewLine]", 
 RowBox[{"a", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"\[CapitalGamma]", "==", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[CapitalGamma]MtoDMX", "+", "\[CapitalGamma]Mtoud"}], ")"}],
        "/", "MM"}], ")"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"yD", "\[Rule]", 
       RowBox[{"A", " ", "yud"}]}], ",", 
      RowBox[{"yudL1x1", "\[Rule]", "yud"}], ",", 
      RowBox[{"yudR1x1", "\[Rule]", "yud"}]}], "}"}]}], "//", 
   "FullSimplify"}]}]}], "Input",
 CellChangeTimes->{{3.665293308244151*^9, 3.6652933450414124`*^9}, {
  3.665294337510703*^9, 3.665294338949916*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"8", " ", "\[Pi]", " ", "\[CapitalGamma]"}], "+", 
   RowBox[{
    SuperscriptBox["yud", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{
       SuperscriptBox["A", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"2", "+", "\[CapitalDelta]"}], ")"}], "2"], " ", 
          "\[Tau]"}]}], ")"}], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            SuperscriptBox["\[CapitalDelta]", "2"], " ", "\[Tau]"}]}], ")"}], 
         " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"2", "+", "\[CapitalDelta]"}], ")"}], "2"], " ", 
            "\[Tau]"}]}], ")"}]}]]}]}], ")"}]}]}], "\[Equal]", 
  "0"}]], "Output",
 CellChangeTimes->{{3.6652933366526947`*^9, 3.665293345530409*^9}, 
   3.665294341118595*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"a", ",", "yud"}], "]"}]], "Input",
 CellChangeTimes->{{3.665293077573393*^9, 3.6652931985230007`*^9}, {
   3.6652932381004543`*^9, 3.665293268868552*^9}, 3.665293350439989*^9, {
   3.665293581062896*^9, 3.6652935817527647`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"yud", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SqrtBox[
         RowBox[{"2", " ", "\[Pi]"}]], " ", 
        SqrtBox["\[CapitalGamma]"]}], 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "2"}], "-", 
         RowBox[{
          SuperscriptBox["A", "2"], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{
               SuperscriptBox["\[CapitalDelta]", "2"], " ", "\[Tau]"}]}], 
             ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"2", "+", "\[CapitalDelta]"}], ")"}], "2"], " ", 
               "\[Tau]"}]}], ")"}]}]]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["A", "2"], " ", "\[Tau]", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{
               SuperscriptBox["\[CapitalDelta]", "2"], " ", "\[Tau]"}]}], 
             ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"2", "+", "\[CapitalDelta]"}], ")"}], "2"], " ", 
               "\[Tau]"}]}], ")"}]}]]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["A", "2"], " ", "\[CapitalDelta]", " ", "\[Tau]", 
          " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{
               SuperscriptBox["\[CapitalDelta]", "2"], " ", "\[Tau]"}]}], 
             ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"2", "+", "\[CapitalDelta]"}], ")"}], "2"], " ", 
               "\[Tau]"}]}], ")"}]}]]}], "+", 
         RowBox[{
          SuperscriptBox["A", "2"], " ", 
          SuperscriptBox["\[CapitalDelta]", "2"], " ", "\[Tau]", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{
               SuperscriptBox["\[CapitalDelta]", "2"], " ", "\[Tau]"}]}], 
             ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"2", "+", "\[CapitalDelta]"}], ")"}], "2"], " ", 
               "\[Tau]"}]}], ")"}]}]]}]}]]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"yud", "\[Rule]", 
     FractionBox[
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox[
        RowBox[{"2", " ", "\[Pi]"}]], " ", 
       SqrtBox["\[CapitalGamma]"]}], 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "2"}], "-", 
        RowBox[{
         SuperscriptBox["A", "2"], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              SuperscriptBox["\[CapitalDelta]", "2"], " ", "\[Tau]"}]}], 
            ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"2", "+", "\[CapitalDelta]"}], ")"}], "2"], " ", 
              "\[Tau]"}]}], ")"}]}]]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["A", "2"], " ", "\[Tau]", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              SuperscriptBox["\[CapitalDelta]", "2"], " ", "\[Tau]"}]}], 
            ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"2", "+", "\[CapitalDelta]"}], ")"}], "2"], " ", 
              "\[Tau]"}]}], ")"}]}]]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["A", "2"], " ", "\[CapitalDelta]", " ", "\[Tau]", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              SuperscriptBox["\[CapitalDelta]", "2"], " ", "\[Tau]"}]}], 
            ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"2", "+", "\[CapitalDelta]"}], ")"}], "2"], " ", 
              "\[Tau]"}]}], ")"}]}]]}], "+", 
        RowBox[{
         SuperscriptBox["A", "2"], " ", 
         SuperscriptBox["\[CapitalDelta]", "2"], " ", "\[Tau]", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              SuperscriptBox["\[CapitalDelta]", "2"], " ", "\[Tau]"}]}], 
            ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"2", "+", "\[CapitalDelta]"}], ")"}], "2"], " ", 
              "\[Tau]"}]}], ")"}]}]]}]}]]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.665293136717402*^9, 3.665293199251474*^9}, {
   3.665293238694652*^9, 3.665293270511054*^9}, 3.6652933515167522`*^9, 
   3.665293582083909*^9, 3.665294350134954*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sextet Diquark", "Subsubsection",
 CellChangeTimes->{{3.655715861161312*^9, 3.6557158708947163`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"ModelFile", "\[Equal]", "\"\<model_dq6_met.fr\>\""}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[CapitalGamma]MtoDMX", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Cases", "[", 
           RowBox[{"decaysRM", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{"M", ",", "X", ",", "DMbar"}], "}"}], "|", 
               RowBox[{"{", 
                RowBox[{"M", ",", "DMbar", ",", "X"}], "}"}]}], ",", "_"}], 
             "}"}]}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"MX1", "\[Rule]", "MX"}], ",", 
           RowBox[{"MX2", "\[Rule]", "MX"}], ",", 
           RowBox[{"MM1", "\[Rule]", "MM"}], ",", 
           RowBox[{"MM2", "\[Rule]", "MM"}]}], "}"}]}], ")"}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]Mtouu", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Cases", "[", 
           RowBox[{"decaysRM", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"M", ",", "u", ",", "u"}], "}"}], ",", "_"}], "}"}]}], 
           "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"MX1", "\[Rule]", "MX"}], ",", 
           RowBox[{"MX2", "\[Rule]", "MX"}], ",", 
           RowBox[{"MM1", "\[Rule]", "MM"}], ",", 
           RowBox[{"MM2", "\[Rule]", "MM"}]}], "}"}]}], ")"}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]Mtott", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Cases", "[", 
           RowBox[{"decaysRM", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"M", ",", "t", ",", "t"}], "}"}], ",", "_"}], "}"}]}], 
           "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"MX1", "\[Rule]", "MX"}], ",", 
           RowBox[{"MX2", "\[Rule]", "MX"}], ",", 
           RowBox[{"MM1", "\[Rule]", "MM"}], ",", 
           RowBox[{"MM2", "\[Rule]", "MM"}]}], "}"}]}], ")"}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     
     RowBox[{"\[CapitalGamma]MtoDMX", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[CapitalGamma]MtoDMX", "/.", 
            RowBox[{"{", 
             RowBox[{"MX", "\[Rule]", 
              RowBox[{"MDM", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[CapitalDelta]"}], ")"}]}]}], "}"}]}], "//",
            "FullSimplify"}], ")"}], "/.", 
         RowBox[{"MDM", "\[Rule]", 
          SqrtBox[
           RowBox[{"\[Tau]", "*", 
            SuperscriptBox["MM", "2"]}]]}]}], ")"}], "//", "FullSimplify"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]Mtouu", "=", 
      RowBox[{
       RowBox[{"\[CapitalGamma]Mtouu", "/.", 
        RowBox[{"MU", "\[Rule]", "0"}]}], "//", "FullSimplify"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]Mtott", "=", 
      RowBox[{
       RowBox[{"\[CapitalGamma]Mtott", "/.", 
        RowBox[{"MT", "\[Rule]", 
         SqrtBox[
          RowBox[{"\[Tau]", "*", 
           SuperscriptBox["MM", "2"]}]]}]}], "//", "FullSimplify"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\[CapitalGamma]MtoDMX = \>\"", ",", "\[CapitalGamma]MtoDMX"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\[CapitalGamma]Mtouu = \>\"", ",", "\[CapitalGamma]Mtouu"}], "]"}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\[CapitalGamma]Mtott = \>\"", ",", "\[CapitalGamma]Mtott"}], "]"}],
      ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.6563162141476107`*^9, 3.656316252063292*^9}, {
  3.6563163079747877`*^9, 3.6563163137517853`*^9}, {3.656316381871518*^9, 
  3.656316384771652*^9}, {3.656316420359488*^9, 3.656316453631982*^9}, {
  3.656318939898245*^9, 3.65631894685436*^9}, {3.656320773601902*^9, 
  3.656320773857177*^9}, {3.659093008707863*^9, 3.65909308745947*^9}, {
  3.659094580450487*^9, 3.659094599342922*^9}, {3.659094688618895*^9, 
  3.659094690158331*^9}, {3.664622206262047*^9, 3.6646222149895487`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Scalar Octet", "Subsubsection",
 CellChangeTimes->{{3.6557158736783953`*^9, 3.6557158761906977`*^9}, {
  3.6579477363473377`*^9, 3.657947738167746*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"ModelFile", "\[Equal]", "\"\<model_so_met.fr\>\""}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[CapitalGamma]M1toDMX1", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Cases", "[", 
           RowBox[{"decaysRM", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{"M1", ",", "DMbar", ",", "X1"}], "}"}], "|", 
               RowBox[{"{", 
                RowBox[{"M1", ",", "X1", ",", "DMbar"}], "}"}]}], ",", "_"}], 
             "}"}]}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"MX1", "\[Rule]", "MX"}], ",", 
           RowBox[{"MX2", "\[Rule]", "MX"}], ",", 
           RowBox[{"MM1", "\[Rule]", "MM"}], ",", 
           RowBox[{"MM2", "\[Rule]", "MM"}]}], "}"}]}], ")"}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]M2toDMX2", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Cases", "[", 
           RowBox[{"decaysRM", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{"M2", ",", "DMbar", ",", "X2"}], "}"}], "|", 
               RowBox[{"{", 
                RowBox[{"M2", ",", "X2", ",", "DMbar"}], "}"}]}], ",", "_"}], 
             "}"}]}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"MX1", "\[Rule]", "MX"}], ",", 
           RowBox[{"MX2", "\[Rule]", "MX"}], ",", 
           RowBox[{"MM1", "\[Rule]", "MM"}], ",", 
           RowBox[{"MM2", "\[Rule]", "MM"}]}], "}"}]}], ")"}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]M1toud", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"PartialWidth", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"M1", ",", "u", ",", "dbar"}], "}"}], ",", "decaysRM"}], 
          "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"MX1", "\[Rule]", "MX"}], ",", 
           RowBox[{"MX2", "\[Rule]", "MX"}], ",", 
           RowBox[{"MM1", "\[Rule]", "MM"}], ",", 
           RowBox[{"MM2", "\[Rule]", "MM"}]}], "}"}]}], ")"}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]M1todu", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"PartialWidth", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"M1bar", ",", "d", ",", "ubar"}], "}"}], ",", 
           "decaysRM"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"MX1", "\[Rule]", "MX"}], ",", 
           RowBox[{"MX2", "\[Rule]", "MX"}], ",", 
           RowBox[{"MM1", "\[Rule]", "MM"}], ",", 
           RowBox[{"MM2", "\[Rule]", "MM"}]}], "}"}]}], ")"}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]M2touu", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"PartialWidth", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"M2", ",", "u", ",", "ubar"}], "}"}], ",", "decaysRM"}], 
          "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"MX1", "\[Rule]", "MX"}], ",", 
           RowBox[{"MX2", "\[Rule]", "MX"}], ",", 
           RowBox[{"MM1", "\[Rule]", "MM"}], ",", 
           RowBox[{"MM2", "\[Rule]", "MM"}]}], "}"}]}], ")"}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]M2todd", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"PartialWidth", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"M2", ",", "d", ",", "dbar"}], "}"}], ",", "decaysRM"}], 
          "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"MX1", "\[Rule]", "MX"}], ",", 
           RowBox[{"MX2", "\[Rule]", "MX"}], ",", 
           RowBox[{"MM1", "\[Rule]", "MM"}], ",", 
           RowBox[{"MM2", "\[Rule]", "MM"}]}], "}"}]}], ")"}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     
     RowBox[{"\[CapitalGamma]M1toDMX1", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[CapitalGamma]M1toDMX1", "/.", 
            RowBox[{"{", 
             RowBox[{"MX", "\[Rule]", 
              RowBox[{"MDM", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[CapitalDelta]"}], ")"}]}]}], "}"}]}], "//",
            "FullSimplify"}], ")"}], "/.", 
         RowBox[{"MDM", "\[Rule]", 
          SqrtBox[
           RowBox[{"\[Tau]", "*", 
            SuperscriptBox["MM", "2"]}]]}]}], ")"}], "//", "FullSimplify"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]M2toDMX2", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[CapitalGamma]M2toDMX2", "/.", 
            RowBox[{"{", 
             RowBox[{"MX", "\[Rule]", 
              RowBox[{"MDM", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[CapitalDelta]"}], ")"}]}]}], "}"}]}], "//",
            "FullSimplify"}], ")"}], "/.", 
         RowBox[{"MDM", "\[Rule]", 
          SqrtBox[
           RowBox[{"\[Tau]", "*", 
            SuperscriptBox["MM", "2"]}]]}]}], ")"}], "//", "FullSimplify"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]M1toud", "=", 
      RowBox[{
       RowBox[{"\[CapitalGamma]M1toud", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"MU", "\[Rule]", 
           SqrtBox[
            RowBox[{
             SubscriptBox["\[Tau]", "u"], "*", 
             SuperscriptBox["MM", "2"]}]]}], ",", 
          RowBox[{"MD", "\[Rule]", 
           SqrtBox[
            RowBox[{
             SubscriptBox["\[Tau]", "d"], "*", 
             SuperscriptBox["MM", "2"]}]]}]}], "}"}]}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]M1todu", "=", 
      RowBox[{
       RowBox[{"\[CapitalGamma]M1todu", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"MU", "\[Rule]", 
           SqrtBox[
            RowBox[{
             SubscriptBox["\[Tau]", "u"], "*", 
             SuperscriptBox["MM", "2"]}]]}], ",", 
          RowBox[{"MD", "\[Rule]", 
           SqrtBox[
            RowBox[{
             SubscriptBox["\[Tau]", "d"], "*", 
             SuperscriptBox["MM", "2"]}]]}]}], "}"}]}], "//", 
       "FullSimplify"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]M2touu", "=", 
      RowBox[{
       RowBox[{"\[CapitalGamma]M2touu", "/.", 
        RowBox[{"MU", "\[Rule]", 
         SqrtBox[
          RowBox[{
           SubscriptBox["\[Tau]", "u"], "*", 
           SuperscriptBox["MM", "2"]}]]}]}], "//", "FullSimplify"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]M2todd", "=", 
      RowBox[{
       RowBox[{"\[CapitalGamma]M2todd", "/.", 
        RowBox[{"MD", "\[Rule]", 
         SqrtBox[
          RowBox[{
           SubscriptBox["\[Tau]", "d"], "*", 
           SuperscriptBox["MM", "2"]}]]}]}], "//", "FullSimplify"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\[CapitalGamma]M1toDMX1 = \>\"", ",", "\[CapitalGamma]M1toDMX1"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\[CapitalGamma]M2toDMX2 = \>\"", ",", "\[CapitalGamma]M2toDMX2"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\[CapitalGamma]M1toud = \>\"", ",", "\[CapitalGamma]M1toud"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\[CapitalGamma]M1todu = \>\"", ",", "\[CapitalGamma]M1todu"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\[CapitalGamma]M2touu = \>\"", ",", "\[CapitalGamma]M2touu"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\[CapitalGamma]M2todd = \>\"", ",", "\[CapitalGamma]M2todd"}], 
      "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.655716018724807*^9, 3.655716120523252*^9}, {
   3.6560547487229967`*^9, 3.656054749450899*^9}, {3.6560552999300013`*^9, 
   3.6560553040706797`*^9}, 3.656055334590026*^9, {3.65605538867177*^9, 
   3.656055399454732*^9}, {3.656055651504087*^9, 3.656055655938649*^9}, {
   3.6560560987138853`*^9, 3.656056101662571*^9}, {3.656238242347684*^9, 
   3.656238263688817*^9}, {3.6562383282479963`*^9, 3.6562384436370687`*^9}, {
   3.6563143587409077`*^9, 3.656314379732489*^9}, {3.656314453685234*^9, 
   3.656314467689438*^9}, {3.656314509716537*^9, 3.6563145103301687`*^9}, {
   3.656314819993676*^9, 3.6563148385720043`*^9}, {3.656314957622014*^9, 
   3.656314962786087*^9}, {3.65631515210318*^9, 3.656315164086924*^9}, {
   3.656315476942833*^9, 3.65631547958818*^9}, {3.656315520929064*^9, 
   3.65631559397738*^9}, {3.656315631842208*^9, 3.6563156467953987`*^9}, {
   3.6563156910386877`*^9, 3.656315728959673*^9}, {3.656315772048379*^9, 
   3.6563158010399218`*^9}, {3.656315992505109*^9, 3.656316075373012*^9}, {
   3.6563161241954937`*^9, 3.656316175244944*^9}, 3.656316217912088*^9, {
   3.65632227724676*^9, 3.656322277823208*^9}, {3.659172072016172*^9, 
   3.659172128691863*^9}, {3.6591721826920547`*^9, 3.659172197624856*^9}, {
   3.659172301609161*^9, 3.6591723383529997`*^9}, {3.66461874308453*^9, 
   3.6646187700023193`*^9}, {3.66462042517548*^9, 3.6646204404301147`*^9}, {
   3.664707960968961*^9, 3.664707965126953*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Alternative Lagrangian Formulation", "Subsection",
 CellChangeTimes->{{3.6588287354820013`*^9, 3.658828756381763*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Print", " ", "Lagrangians", " ", "for", " ", "both", " ", "formulations", 
    " ", "of", " ", "the", " ", "visible", " ", "sector"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"LVIS", "\[IndentingNewLine]", "LVISALT"}]}]], "Input",
 CellChangeTimes->{{3.658828845990535*^9, 3.658828905826378*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox[
     OverscriptBox["uq", "\<\"-\"\>"], 
     RowBox[{"r$5446", ",", "f2", ",", "c1"}]], ".", 
    SubscriptBox["l", 
     RowBox[{"r$5447", ",", "f1"}]]}], " ", 
   SubscriptBox["M1", "c1"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"r$5446", ",", "r$5447"}]], " ", 
   SubscriptBox[
    SubscriptBox["y", "Lu"], 
    RowBox[{"f1", ",", "f2"}]]}], "-", 
  RowBox[{
   RowBox[{
    SubscriptBox[
     OverscriptBox["uq", "\<\"-\"\>"], 
     RowBox[{"r$5448", ",", "f2", ",", "c1"}]], ".", 
    SubscriptBox["vl", 
     RowBox[{"r$5449", ",", "f1"}]]}], " ", 
   SubscriptBox["M2", "c1"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"r$5448", ",", "r$5449"}]], " ", 
   SubscriptBox[
    SubscriptBox["y", "Lu"], 
    RowBox[{"f1", ",", "f2"}]]}], "+", 
  RowBox[{
   RowBox[{
    SubscriptBox[
     OverscriptBox["l", "\<\"-\"\>"], 
     RowBox[{"sp2$5442", ",", "f1"}]], ".", 
    SubscriptBox["uq", 
     RowBox[{"sp2$5439", ",", "f2", ",", "c1"}]]}], " ", 
   SubsuperscriptBox["M1", "c1", "\[Dagger]"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"+\"\>"], 
    RowBox[{"sp2$5442", ",", "sp2$5439"}]], " ", 
   SubscriptBox[
    SubscriptBox["y", "Lu"], 
    RowBox[{"f1", ",", "f2"}]]}], "-", 
  RowBox[{
   RowBox[{
    SubscriptBox[
     OverscriptBox["vl", "\<\"-\"\>"], 
     RowBox[{"sp2$5443", ",", "f1"}]], ".", 
    SubscriptBox["uq", 
     RowBox[{"sp2$5439", ",", "f2", ",", "c1"}]]}], " ", 
   SubsuperscriptBox["M2", "c1", "\[Dagger]"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"+\"\>"], 
    RowBox[{"sp2$5443", ",", "sp2$5439"}]], " ", 
   SubscriptBox[
    SubscriptBox["y", "Lu"], 
    RowBox[{"f1", ",", "f2"}]]}], "-", 
  RowBox[{
   RowBox[{
    SubscriptBox[
     OverscriptBox["l", "\<\"-\"\>"], 
     RowBox[{"r$5450", ",", "f2"}]], ".", 
    SubscriptBox["uq", 
     RowBox[{"r$5451", ",", "f1", ",", "c1"}]]}], " ", 
   SubsuperscriptBox["M1", "c1", "\[Dagger]"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"r$5450", ",", "r$5451"}]], " ", 
   SubscriptBox[
    SubscriptBox["y", "Ql"], 
    RowBox[{"f1", ",", "f2"}]]}], "-", 
  RowBox[{
   RowBox[{
    SubscriptBox[
     OverscriptBox["l", "\<\"-\"\>"], 
     RowBox[{"r$5452", ",", "f2"}]], ".", 
    SubscriptBox["dq", 
     RowBox[{"r$5453", ",", "f1", ",", "c1"}]]}], " ", 
   SubsuperscriptBox["M2", "c1", "\[Dagger]"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"-\"\>"], 
    RowBox[{"r$5452", ",", "r$5453"}]], " ", 
   SubscriptBox[
    SubscriptBox["y", "Ql"], 
    RowBox[{"f1", ",", "f2"}]]}], "-", 
  RowBox[{
   RowBox[{
    SubscriptBox[
     OverscriptBox["uq", "\<\"-\"\>"], 
     RowBox[{"sp2$5444", ",", "f1", ",", "c1"}]], ".", 
    SubscriptBox["l", 
     RowBox[{"sp2$5440", ",", "f2"}]]}], " ", 
   SubscriptBox["M1", "c1"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"+\"\>"], 
    RowBox[{"sp2$5444", ",", "sp2$5440"}]], " ", 
   SubscriptBox[
    SubscriptBox["y", "Ql"], 
    RowBox[{"f1", ",", "f2"}]]}], "-", 
  RowBox[{
   RowBox[{
    SubscriptBox[
     OverscriptBox["dq", "\<\"-\"\>"], 
     RowBox[{"sp2$5445", ",", "f1", ",", "c1"}]], ".", 
    SubscriptBox["l", 
     RowBox[{"sp2$5440", ",", "f2"}]]}], " ", 
   SubscriptBox["M2", "c1"], " ", 
   SubscriptBox[
    SubscriptBox["P", "\<\"+\"\>"], 
    RowBox[{"sp2$5445", ",", "sp2$5440"}]], " ", 
   SubscriptBox[
    SubscriptBox["y", "Ql"], 
    RowBox[{"f1", ",", "f2"}]]}]}]], "Output",
 CellChangeTimes->{{3.6588288477045927`*^9, 3.658828874741753*^9}, 
   3.658828906542986*^9, 3.658830578608135*^9, 3.6588309615825443`*^9, 
   3.658831115236299*^9, 3.658831746371768*^9, 3.658831853902232*^9, 
   3.658834807218061*^9, 3.6588368784710913`*^9, 3.6588369517813673`*^9, 
   3.658837382177593*^9, 3.658837434880604*^9, 3.6588375035363703`*^9, 
   3.6588376439753017`*^9, 3.658837874157946*^9, 3.658838010694272*^9, 
   3.65883810802812*^9, 3.658838176257037*^9, 3.6588397319631042`*^9, 
   3.6590738080838223`*^9, 3.659073977711132*^9, 3.664788329580967*^9}],

Cell[BoxData["LVISALT"], "Output",
 CellChangeTimes->{{3.6588288477045927`*^9, 3.658828874741753*^9}, 
   3.658828906542986*^9, 3.658830578608135*^9, 3.6588309615825443`*^9, 
   3.658831115236299*^9, 3.658831746371768*^9, 3.658831853902232*^9, 
   3.658834807218061*^9, 3.6588368784710913`*^9, 3.6588369517813673`*^9, 
   3.658837382177593*^9, 3.658837434880604*^9, 3.6588375035363703`*^9, 
   3.6588376439753017`*^9, 3.658837874157946*^9, 3.658838010694272*^9, 
   3.65883810802812*^9, 3.658838176257037*^9, 3.6588397319631042`*^9, 
   3.6590738080838223`*^9, 3.659073977711132*^9, 3.664788329581625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Print", " ", "Feynman", " ", "Rules", " ", "for", " ", "both", " ", 
    "formulations", " ", "of", " ", "the", " ", "visible", " ", "sector"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Unprotect", "[", 
     RowBox[{"verticesVIS", ",", "verticesVISALT"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{"verticesVIS", ",", "verticesVISALT"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"verCKMReplacement", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"CKM", "[", 
        RowBox[{"f1_", ",", "f2_"}], "]"}], "\[Rule]", 
       RowBox[{"IndexDelta", "[", 
        RowBox[{"f1", ",", "f2"}], "]"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"verticesVIS", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"FeynmanRules", "[", 
       RowBox[{"LVIS", ",", 
        RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"verticesVISALT", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"FeynmanRules", "[", 
       RowBox[{"LVISALT", ",", 
        RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Protect", "[", 
     RowBox[{"verticesVIS", ",", "verticesVISALT"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"Style", "[", 
      RowBox[{
      "\"\<Comparison of formulations of the visible sector Lagrangian:\>\"", 
       ",", "Orange", ",", "Bold"}], "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"verticesVIS", "//", "Grid"}], "\[IndentingNewLine]", 
   RowBox[{"verticesVISALT", "//", "Grid"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"Style", "[", 
      RowBox[{
      "\"\<Comparison of formulations of the visible sector Lagrangian \
(\!\(\*SubscriptBox[\(V\), \(CKM\)]\) = 1):\>\"", ",", "Orange", ",", 
       "Bold"}], "]"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"verticesVIS", "/.", "verCKMReplacement"}], "//", "Grid"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"verticesVISALT", "/.", "verCKMReplacement"}], "//", "Grid"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Test", " ", "if", " ", "both", " ", "formulations", " ", "are", " ", 
     "the", " ", "same"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"verticesVIS", "/.", "verCKMReplacement"}], ")"}], "\[Equal]", 
       RowBox[{"(", 
        RowBox[{"verticesVISALT", "/.", "verCKMReplacement"}], ")"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<Both formulations of the visible sector Lagrangian are the same.\
\>\"", ",", "Orange", ",", "Bold"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<Both formulations of the visible sector Lagrangian are not the \
same.\>\"", ",", "Red", ",", "Bold"}], "]"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<Both formulations of the visible sector Lagrangian are not the \
same.\>\"", ",", "Red", ",", "Bold"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
     "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.658828878678491*^9, 3.658828940104253*^9}, {
   3.658829185360814*^9, 3.658829360031673*^9}, {3.6588309764547167`*^9, 
   3.658830976956971*^9}, {3.658835032711529*^9, 3.658835102922944*^9}, {
   3.658835139737928*^9, 3.6588351950431213`*^9}, 3.6588352758670893`*^9, {
   3.6588357905234756`*^9, 3.6588358021883287`*^9}, {3.658835860954773*^9, 
   3.6588359210013123`*^9}, {3.658836416554944*^9, 3.65883650074811*^9}, {
   3.658838241818507*^9, 3.658838247025799*^9}, {3.659074000685298*^9, 
   3.6590740041411533`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.658828928724717*^9, 3.658828940466073*^9}, {
   3.658829245775367*^9, 3.658829275359365*^9}, 3.658829305926353*^9, {
   3.658829343658095*^9, 3.658829361640295*^9}, 3.658830580389295*^9, {
   3.658830963434209*^9, 3.658830990077829*^9}, 3.658831116111267*^9, 
   3.658831747764428*^9, 3.658831854858107*^9, 3.658834808279861*^9, {
   3.6588350771889277`*^9, 3.658835103572028*^9}, {3.6588351847215567`*^9, 
   3.658835195675692*^9}, 3.6588352765361767`*^9, 3.6588358027723637`*^9, 
   3.6588358807530003`*^9, {3.6588359109498167`*^9, 3.6588359222211733`*^9}, {
   3.65883642972532*^9, 3.658836454718008*^9}, {3.658836491411438*^9, 
   3.658836501448748*^9}, 3.658836885026032*^9, 3.6588369539771223`*^9, 
   3.6588373900725307`*^9, 3.65883743701831*^9, 3.6588375064132233`*^9, 
   3.658837646311397*^9, 3.658837876292055*^9, 3.658838013100665*^9, 
   3.658838110098091*^9, 3.658838177545555*^9, 3.658838247959958*^9, 
   3.6588386666850767`*^9, 3.6588397321192904`*^9, 3.65907381393369*^9, {
   3.659073978803946*^9, 3.659074004704434*^9}, 3.664788329856463*^9, 
   3.66478948658888*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.658828928724717*^9, 3.658828940466073*^9}, {
   3.658829245775367*^9, 3.658829275359365*^9}, 3.658829305926353*^9, {
   3.658829343658095*^9, 3.658829361640295*^9}, 3.658830580389295*^9, {
   3.658830963434209*^9, 3.658830990077829*^9}, 3.658831116111267*^9, 
   3.658831747764428*^9, 3.658831854858107*^9, 3.658834808279861*^9, {
   3.6588350771889277`*^9, 3.658835103572028*^9}, {3.6588351847215567`*^9, 
   3.658835195675692*^9}, 3.6588352765361767`*^9, 3.6588358027723637`*^9, 
   3.6588358807530003`*^9, {3.6588359109498167`*^9, 3.6588359222211733`*^9}, {
   3.65883642972532*^9, 3.658836454718008*^9}, {3.658836491411438*^9, 
   3.658836501448748*^9}, 3.658836885026032*^9, 3.6588369539771223`*^9, 
   3.6588373900725307`*^9, 3.65883743701831*^9, 3.6588375064132233`*^9, 
   3.658837646311397*^9, 3.658837876292055*^9, 3.658838013100665*^9, 
   3.658838110098091*^9, 3.658838177545555*^9, 3.658838247959958*^9, 
   3.6588386666850767`*^9, 3.6588397321192904`*^9, 3.65907381393369*^9, {
   3.659073978803946*^9, 3.659074004704434*^9}, 3.664788329856463*^9, 
   3.664789486590448*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.658828928724717*^9, 3.658828940466073*^9}, {
   3.658829245775367*^9, 3.658829275359365*^9}, 3.658829305926353*^9, {
   3.658829343658095*^9, 3.658829361640295*^9}, 3.658830580389295*^9, {
   3.658830963434209*^9, 3.658830990077829*^9}, 3.658831116111267*^9, 
   3.658831747764428*^9, 3.658831854858107*^9, 3.658834808279861*^9, {
   3.6588350771889277`*^9, 3.658835103572028*^9}, {3.6588351847215567`*^9, 
   3.658835195675692*^9}, 3.6588352765361767`*^9, 3.6588358027723637`*^9, 
   3.6588358807530003`*^9, {3.6588359109498167`*^9, 3.6588359222211733`*^9}, {
   3.65883642972532*^9, 3.658836454718008*^9}, {3.658836491411438*^9, 
   3.658836501448748*^9}, 3.658836885026032*^9, 3.6588369539771223`*^9, 
   3.6588373900725307`*^9, 3.65883743701831*^9, 3.6588375064132233`*^9, 
   3.658837646311397*^9, 3.658837876292055*^9, 3.658838013100665*^9, 
   3.658838110098091*^9, 3.658838177545555*^9, 3.658838247959958*^9, 
   3.6588386666850767`*^9, 3.6588397321192904`*^9, 3.65907381393369*^9, {
   3.659073978803946*^9, 3.659074004704434*^9}, 3.664788329856463*^9, 
   3.6647894867120733`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{121., {2., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  2, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 2, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.658828928724717*^9, 3.658828940466073*^9}, {
   3.658829245775367*^9, 3.658829275359365*^9}, 3.658829305926353*^9, {
   3.658829343658095*^9, 3.658829361640295*^9}, 3.658830580389295*^9, {
   3.658830963434209*^9, 3.658830990077829*^9}, 3.658831116111267*^9, 
   3.658831747764428*^9, 3.658831854858107*^9, 3.658834808279861*^9, {
   3.6588350771889277`*^9, 3.658835103572028*^9}, {3.6588351847215567`*^9, 
   3.658835195675692*^9}, 3.6588352765361767`*^9, 3.6588358027723637`*^9, 
   3.6588358807530003`*^9, {3.6588359109498167`*^9, 3.6588359222211733`*^9}, {
   3.65883642972532*^9, 3.658836454718008*^9}, {3.658836491411438*^9, 
   3.658836501448748*^9}, 3.658836885026032*^9, 3.6588369539771223`*^9, 
   3.6588373900725307`*^9, 3.65883743701831*^9, 3.6588375064132233`*^9, 
   3.658837646311397*^9, 3.658837876292055*^9, 3.658838013100665*^9, 
   3.658838110098091*^9, 3.658838177545555*^9, 3.658838247959958*^9, 
   3.6588386666850767`*^9, 3.6588397321192904`*^9, 3.65907381393369*^9, {
   3.659073978803946*^9, 3.659074004704434*^9}, 3.664788329856463*^9, 
   3.664789486714518*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[2, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.658828928724717*^9, 3.658828940466073*^9}, {
   3.658829245775367*^9, 3.658829275359365*^9}, 3.658829305926353*^9, {
   3.658829343658095*^9, 3.658829361640295*^9}, 3.658830580389295*^9, {
   3.658830963434209*^9, 3.658830990077829*^9}, 3.658831116111267*^9, 
   3.658831747764428*^9, 3.658831854858107*^9, 3.658834808279861*^9, {
   3.6588350771889277`*^9, 3.658835103572028*^9}, {3.6588351847215567`*^9, 
   3.658835195675692*^9}, 3.6588352765361767`*^9, 3.6588358027723637`*^9, 
   3.6588358807530003`*^9, {3.6588359109498167`*^9, 3.6588359222211733`*^9}, {
   3.65883642972532*^9, 3.658836454718008*^9}, {3.658836491411438*^9, 
   3.658836501448748*^9}, 3.658836885026032*^9, 3.6588369539771223`*^9, 
   3.6588373900725307`*^9, 3.65883743701831*^9, 3.6588375064132233`*^9, 
   3.658837646311397*^9, 3.658837876292055*^9, 3.658838013100665*^9, 
   3.658838110098091*^9, 3.658838177545555*^9, 3.658838247959958*^9, 
   3.6588386666850767`*^9, 3.6588397321192904`*^9, 3.65907381393369*^9, {
   3.659073978803946*^9, 3.659074004704434*^9}, 3.664788329856463*^9, 
   3.664789486762969*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.658828928724717*^9, 3.658828940466073*^9}, {
   3.658829245775367*^9, 3.658829275359365*^9}, 3.658829305926353*^9, {
   3.658829343658095*^9, 3.658829361640295*^9}, 3.658830580389295*^9, {
   3.658830963434209*^9, 3.658830990077829*^9}, 3.658831116111267*^9, 
   3.658831747764428*^9, 3.658831854858107*^9, 3.658834808279861*^9, {
   3.6588350771889277`*^9, 3.658835103572028*^9}, {3.6588351847215567`*^9, 
   3.658835195675692*^9}, 3.6588352765361767`*^9, 3.6588358027723637`*^9, 
   3.6588358807530003`*^9, {3.6588359109498167`*^9, 3.6588359222211733`*^9}, {
   3.65883642972532*^9, 3.658836454718008*^9}, {3.658836491411438*^9, 
   3.658836501448748*^9}, 3.658836885026032*^9, 3.6588369539771223`*^9, 
   3.6588373900725307`*^9, 3.65883743701831*^9, 3.6588375064132233`*^9, 
   3.658837646311397*^9, 3.658837876292055*^9, 3.658838013100665*^9, 
   3.658838110098091*^9, 3.658838177545555*^9, 3.658838247959958*^9, 
   3.6588386666850767`*^9, 3.6588397321192904`*^9, 3.65907381393369*^9, {
   3.659073978803946*^9, 3.659074004704434*^9}, 3.664788329856463*^9, 
   3.664789486811192*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.658828928724717*^9, 3.658828940466073*^9}, {
   3.658829245775367*^9, 3.658829275359365*^9}, 3.658829305926353*^9, {
   3.658829343658095*^9, 3.658829361640295*^9}, 3.658830580389295*^9, {
   3.658830963434209*^9, 3.658830990077829*^9}, 3.658831116111267*^9, 
   3.658831747764428*^9, 3.658831854858107*^9, 3.658834808279861*^9, {
   3.6588350771889277`*^9, 3.658835103572028*^9}, {3.6588351847215567`*^9, 
   3.658835195675692*^9}, 3.6588352765361767`*^9, 3.6588358027723637`*^9, 
   3.6588358807530003`*^9, {3.6588359109498167`*^9, 3.6588359222211733`*^9}, {
   3.65883642972532*^9, 3.658836454718008*^9}, {3.658836491411438*^9, 
   3.658836501448748*^9}, 3.658836885026032*^9, 3.6588369539771223`*^9, 
   3.6588373900725307`*^9, 3.65883743701831*^9, 3.6588375064132233`*^9, 
   3.658837646311397*^9, 3.658837876292055*^9, 3.658838013100665*^9, 
   3.658838110098091*^9, 3.658838177545555*^9, 3.658838247959958*^9, 
   3.6588386666850767`*^9, 3.6588397321192904`*^9, 3.65907381393369*^9, {
   3.659073978803946*^9, 3.659074004704434*^9}, 3.664788329856463*^9, 
   3.664789486813018*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.658828928724717*^9, 3.658828940466073*^9}, {
   3.658829245775367*^9, 3.658829275359365*^9}, 3.658829305926353*^9, {
   3.658829343658095*^9, 3.658829361640295*^9}, 3.658830580389295*^9, {
   3.658830963434209*^9, 3.658830990077829*^9}, 3.658831116111267*^9, 
   3.658831747764428*^9, 3.658831854858107*^9, 3.658834808279861*^9, {
   3.6588350771889277`*^9, 3.658835103572028*^9}, {3.6588351847215567`*^9, 
   3.658835195675692*^9}, 3.6588352765361767`*^9, 3.6588358027723637`*^9, 
   3.6588358807530003`*^9, {3.6588359109498167`*^9, 3.6588359222211733`*^9}, {
   3.65883642972532*^9, 3.658836454718008*^9}, {3.658836491411438*^9, 
   3.658836501448748*^9}, 3.658836885026032*^9, 3.6588369539771223`*^9, 
   3.6588373900725307`*^9, 3.65883743701831*^9, 3.6588375064132233`*^9, 
   3.658837646311397*^9, 3.658837876292055*^9, 3.658838013100665*^9, 
   3.658838110098091*^9, 3.658838177545555*^9, 3.658838247959958*^9, 
   3.6588386666850767`*^9, 3.6588397321192904`*^9, 3.65907381393369*^9, {
   3.659073978803946*^9, 3.659074004704434*^9}, 3.664788329856463*^9, 
   3.6647894869142513`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{121., {2., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  2, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 2, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.658828928724717*^9, 3.658828940466073*^9}, {
   3.658829245775367*^9, 3.658829275359365*^9}, 3.658829305926353*^9, {
   3.658829343658095*^9, 3.658829361640295*^9}, 3.658830580389295*^9, {
   3.658830963434209*^9, 3.658830990077829*^9}, 3.658831116111267*^9, 
   3.658831747764428*^9, 3.658831854858107*^9, 3.658834808279861*^9, {
   3.6588350771889277`*^9, 3.658835103572028*^9}, {3.6588351847215567`*^9, 
   3.658835195675692*^9}, 3.6588352765361767`*^9, 3.6588358027723637`*^9, 
   3.6588358807530003`*^9, {3.6588359109498167`*^9, 3.6588359222211733`*^9}, {
   3.65883642972532*^9, 3.658836454718008*^9}, {3.658836491411438*^9, 
   3.658836501448748*^9}, 3.658836885026032*^9, 3.6588369539771223`*^9, 
   3.6588373900725307`*^9, 3.65883743701831*^9, 3.6588375064132233`*^9, 
   3.658837646311397*^9, 3.658837876292055*^9, 3.658838013100665*^9, 
   3.658838110098091*^9, 3.658838177545555*^9, 3.658838247959958*^9, 
   3.6588386666850767`*^9, 3.6588397321192904`*^9, 3.65907381393369*^9, {
   3.659073978803946*^9, 3.659074004704434*^9}, 3.664788329856463*^9, 
   3.664789486916654*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[2, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.658828928724717*^9, 3.658828940466073*^9}, {
   3.658829245775367*^9, 3.658829275359365*^9}, 3.658829305926353*^9, {
   3.658829343658095*^9, 3.658829361640295*^9}, 3.658830580389295*^9, {
   3.658830963434209*^9, 3.658830990077829*^9}, 3.658831116111267*^9, 
   3.658831747764428*^9, 3.658831854858107*^9, 3.658834808279861*^9, {
   3.6588350771889277`*^9, 3.658835103572028*^9}, {3.6588351847215567`*^9, 
   3.658835195675692*^9}, 3.6588352765361767`*^9, 3.6588358027723637`*^9, 
   3.6588358807530003`*^9, {3.6588359109498167`*^9, 3.6588359222211733`*^9}, {
   3.65883642972532*^9, 3.658836454718008*^9}, {3.658836491411438*^9, 
   3.658836501448748*^9}, 3.658836885026032*^9, 3.6588369539771223`*^9, 
   3.6588373900725307`*^9, 3.65883743701831*^9, 3.6588375064132233`*^9, 
   3.658837646311397*^9, 3.658837876292055*^9, 3.658838013100665*^9, 
   3.658838110098091*^9, 3.658838177545555*^9, 3.658838247959958*^9, 
   3.6588386666850767`*^9, 3.6588397321192904`*^9, 3.65907381393369*^9, {
   3.659073978803946*^9, 3.659074004704434*^9}, 3.664788329856463*^9, 
   3.664789486978685*^9}],

Cell[BoxData[
 StyleBox["\<\"Comparison of formulations of the visible sector Lagrangian:\"\
\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.658828928724717*^9, 3.658828940466073*^9}, {
   3.658829245775367*^9, 3.658829275359365*^9}, 3.658829305926353*^9, {
   3.658829343658095*^9, 3.658829361640295*^9}, 3.658830580389295*^9, {
   3.658830963434209*^9, 3.658830990077829*^9}, 3.658831116111267*^9, 
   3.658831747764428*^9, 3.658831854858107*^9, 3.658834808279861*^9, {
   3.6588350771889277`*^9, 3.658835103572028*^9}, {3.6588351847215567`*^9, 
   3.658835195675692*^9}, 3.6588352765361767`*^9, 3.6588358027723637`*^9, 
   3.6588358807530003`*^9, {3.6588359109498167`*^9, 3.6588359222211733`*^9}, {
   3.65883642972532*^9, 3.658836454718008*^9}, {3.658836491411438*^9, 
   3.658836501448748*^9}, 3.658836885026032*^9, 3.6588369539771223`*^9, 
   3.6588373900725307`*^9, 3.65883743701831*^9, 3.6588375064132233`*^9, 
   3.658837646311397*^9, 3.658837876292055*^9, 3.658838013100665*^9, 
   3.658838110098091*^9, 3.658838177545555*^9, 3.658838247959958*^9, 
   3.6588386666850767`*^9, 3.6588397321192904`*^9, 3.65907381393369*^9, {
   3.659073978803946*^9, 3.659074004704434*^9}, 3.664788329856463*^9, 
   3.664789486980769*^9}]
}, Open  ]],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"M", ",", "3"}], "}"}]}], "}"}], 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"K6bar", "[", 
       RowBox[{
        SubscriptBox["\<\"u\"\>", "3"], ",", 
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}], "]"}], " ", 
      SubscriptBox[
       SubscriptBox["P", "\<\"-\"\>"], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox[
         SubscriptBox["y", "uu"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], "+", 
        SubscriptBox[
         SubscriptBox["y", "uu"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "2"], ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]]}], ")"}]}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"uq", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["M", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"K6", "[", 
       RowBox[{
        SubscriptBox["\<\"u\"\>", "3"], ",", 
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}], "]"}], " ", 
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox[
         SubscriptBox["y", "uu"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], "+", 
        SubscriptBox[
         SubscriptBox["y", "uu"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "2"], ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]]}], ")"}]}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.658828929388466*^9, 3.6588289405927134`*^9}, {
   3.6588292458990183`*^9, 3.6588292756170893`*^9}, 3.658829306241588*^9, {
   3.658829343906008*^9, 3.658829361893661*^9}, 3.65883058088054*^9, {
   3.658830963991094*^9, 3.658830990530305*^9}, 3.658831117058692*^9, 
   3.65883174865269*^9, 3.658831855766267*^9, 3.65883480920494*^9, {
   3.658835077949621*^9, 3.658835104274259*^9}, {3.6588351854940567`*^9, 
   3.658835196371154*^9}, 3.658835277288666*^9, 3.6588358034982157`*^9, 
   3.658835881454269*^9, {3.6588359117204037`*^9, 3.658835922949085*^9}, {
   3.658836430455709*^9, 3.658836455453952*^9}, {3.65883649214063*^9, 
   3.6588365021208477`*^9}, 3.658836885830587*^9, 3.658836954793541*^9, 
   3.6588373909977493`*^9, 3.658837438509239*^9, 3.658837507691697*^9, 
   3.6588376474401712`*^9, 3.658837877431534*^9, 3.658838014203144*^9, 
   3.6588381111811237`*^9, 3.658838178866693*^9, 3.65883824889666*^9, 
   3.658838667802725*^9, 3.6588397332096443`*^9, 3.659073814281481*^9, {
   3.659073979769518*^9, 3.659074005475844*^9}, 3.664788330262216*^9, 
   3.664789487049065*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"M", ",", "3"}], "}"}]}], "}"}], 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"K6bar", "[", 
       RowBox[{
        SubscriptBox["\<\"u\"\>", "3"], ",", 
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}], "]"}], " ", 
      SubscriptBox[
       SubscriptBox["P", "\<\"-\"\>"], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox[
         SubscriptBox["y", "uu"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], "+", 
        SubscriptBox[
         SubscriptBox["y", "uu"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "2"], ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]]}], ")"}]}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"uq", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["M", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"K6", "[", 
       RowBox[{
        SubscriptBox["\<\"u\"\>", "3"], ",", 
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}], "]"}], " ", 
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox[
         SubscriptBox["y", "uu"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], "+", 
        SubscriptBox[
         SubscriptBox["y", "uu"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "2"], ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]]}], ")"}]}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.658828929388466*^9, 3.6588289405927134`*^9}, {
   3.6588292458990183`*^9, 3.6588292756170893`*^9}, 3.658829306241588*^9, {
   3.658829343906008*^9, 3.658829361893661*^9}, 3.65883058088054*^9, {
   3.658830963991094*^9, 3.658830990530305*^9}, 3.658831117058692*^9, 
   3.65883174865269*^9, 3.658831855766267*^9, 3.65883480920494*^9, {
   3.658835077949621*^9, 3.658835104274259*^9}, {3.6588351854940567`*^9, 
   3.658835196371154*^9}, 3.658835277288666*^9, 3.6588358034982157`*^9, 
   3.658835881454269*^9, {3.6588359117204037`*^9, 3.658835922949085*^9}, {
   3.658836430455709*^9, 3.658836455453952*^9}, {3.65883649214063*^9, 
   3.6588365021208477`*^9}, 3.658836885830587*^9, 3.658836954793541*^9, 
   3.6588373909977493`*^9, 3.658837438509239*^9, 3.658837507691697*^9, 
   3.6588376474401712`*^9, 3.658837877431534*^9, 3.658838014203144*^9, 
   3.6588381111811237`*^9, 3.658838178866693*^9, 3.65883824889666*^9, 
   3.658838667802725*^9, 3.6588397332096443`*^9, 3.659073814281481*^9, {
   3.659073979769518*^9, 3.659074005475844*^9}, 3.664788330262216*^9, 
   3.664789487053743*^9}],

Cell[BoxData[
 StyleBox["\<\"Comparison of formulations of the visible sector Lagrangian \
(\\!\\(\\*SubscriptBox[\\(V\\), \\(CKM\\)]\\) = 1):\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.658828928724717*^9, 3.658828940466073*^9}, {
   3.658829245775367*^9, 3.658829275359365*^9}, 3.658829305926353*^9, {
   3.658829343658095*^9, 3.658829361640295*^9}, 3.658830580389295*^9, {
   3.658830963434209*^9, 3.658830990077829*^9}, 3.658831116111267*^9, 
   3.658831747764428*^9, 3.658831854858107*^9, 3.658834808279861*^9, {
   3.6588350771889277`*^9, 3.658835103572028*^9}, {3.6588351847215567`*^9, 
   3.658835195675692*^9}, 3.6588352765361767`*^9, 3.6588358027723637`*^9, 
   3.6588358807530003`*^9, {3.6588359109498167`*^9, 3.6588359222211733`*^9}, {
   3.65883642972532*^9, 3.658836454718008*^9}, {3.658836491411438*^9, 
   3.658836501448748*^9}, 3.658836885026032*^9, 3.6588369539771223`*^9, 
   3.6588373900725307`*^9, 3.65883743701831*^9, 3.6588375064132233`*^9, 
   3.658837646311397*^9, 3.658837876292055*^9, 3.658838013100665*^9, 
   3.658838110098091*^9, 3.658838177545555*^9, 3.658838247959958*^9, 
   3.6588386666850767`*^9, 3.6588397321192904`*^9, 3.65907381393369*^9, {
   3.659073978803946*^9, 3.659074004704434*^9}, 3.664788329856463*^9, 
   3.66478948705626*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"M", ",", "3"}], "}"}]}], "}"}], 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"K6bar", "[", 
       RowBox[{
        SubscriptBox["\<\"u\"\>", "3"], ",", 
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}], "]"}], " ", 
      SubscriptBox[
       SubscriptBox["P", "\<\"-\"\>"], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox[
         SubscriptBox["y", "uu"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], "+", 
        SubscriptBox[
         SubscriptBox["y", "uu"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "2"], ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]]}], ")"}]}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"uq", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["M", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"K6", "[", 
       RowBox[{
        SubscriptBox["\<\"u\"\>", "3"], ",", 
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}], "]"}], " ", 
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox[
         SubscriptBox["y", "uu"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], "+", 
        SubscriptBox[
         SubscriptBox["y", "uu"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "2"], ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]]}], ")"}]}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.658828929388466*^9, 3.6588289405927134`*^9}, {
   3.6588292458990183`*^9, 3.6588292756170893`*^9}, 3.658829306241588*^9, {
   3.658829343906008*^9, 3.658829361893661*^9}, 3.65883058088054*^9, {
   3.658830963991094*^9, 3.658830990530305*^9}, 3.658831117058692*^9, 
   3.65883174865269*^9, 3.658831855766267*^9, 3.65883480920494*^9, {
   3.658835077949621*^9, 3.658835104274259*^9}, {3.6588351854940567`*^9, 
   3.658835196371154*^9}, 3.658835277288666*^9, 3.6588358034982157`*^9, 
   3.658835881454269*^9, {3.6588359117204037`*^9, 3.658835922949085*^9}, {
   3.658836430455709*^9, 3.658836455453952*^9}, {3.65883649214063*^9, 
   3.6588365021208477`*^9}, 3.658836885830587*^9, 3.658836954793541*^9, 
   3.6588373909977493`*^9, 3.658837438509239*^9, 3.658837507691697*^9, 
   3.6588376474401712`*^9, 3.658837877431534*^9, 3.658838014203144*^9, 
   3.6588381111811237`*^9, 3.658838178866693*^9, 3.65883824889666*^9, 
   3.658838667802725*^9, 3.6588397332096443`*^9, 3.659073814281481*^9, {
   3.659073979769518*^9, 3.659074005475844*^9}, 3.664788330262216*^9, 
   3.664789487058927*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"M", ",", "3"}], "}"}]}], "}"}], 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"K6bar", "[", 
       RowBox[{
        SubscriptBox["\<\"u\"\>", "3"], ",", 
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}], "]"}], " ", 
      SubscriptBox[
       SubscriptBox["P", "\<\"-\"\>"], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox[
         SubscriptBox["y", "uu"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], "+", 
        SubscriptBox[
         SubscriptBox["y", "uu"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "2"], ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]]}], ")"}]}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"uq", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["M", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"K6", "[", 
       RowBox[{
        SubscriptBox["\<\"u\"\>", "3"], ",", 
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}], "]"}], " ", 
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox[
         SubscriptBox["y", "uu"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], "+", 
        SubscriptBox[
         SubscriptBox["y", "uu"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "2"], ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]]}], ")"}]}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.658828929388466*^9, 3.6588289405927134`*^9}, {
   3.6588292458990183`*^9, 3.6588292756170893`*^9}, 3.658829306241588*^9, {
   3.658829343906008*^9, 3.658829361893661*^9}, 3.65883058088054*^9, {
   3.658830963991094*^9, 3.658830990530305*^9}, 3.658831117058692*^9, 
   3.65883174865269*^9, 3.658831855766267*^9, 3.65883480920494*^9, {
   3.658835077949621*^9, 3.658835104274259*^9}, {3.6588351854940567`*^9, 
   3.658835196371154*^9}, 3.658835277288666*^9, 3.6588358034982157`*^9, 
   3.658835881454269*^9, {3.6588359117204037`*^9, 3.658835922949085*^9}, {
   3.658836430455709*^9, 3.658836455453952*^9}, {3.65883649214063*^9, 
   3.6588365021208477`*^9}, 3.658836885830587*^9, 3.658836954793541*^9, 
   3.6588373909977493`*^9, 3.658837438509239*^9, 3.658837507691697*^9, 
   3.6588376474401712`*^9, 3.658837877431534*^9, 3.658838014203144*^9, 
   3.6588381111811237`*^9, 3.658838178866693*^9, 3.65883824889666*^9, 
   3.658838667802725*^9, 3.6588397332096443`*^9, 3.659073814281481*^9, {
   3.659073979769518*^9, 3.659074005475844*^9}, 3.664788330262216*^9, 
   3.6647894870617647`*^9}],

Cell[BoxData[
 StyleBox["\<\"Both formulations of the visible sector Lagrangian are the \
same.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.658828928724717*^9, 3.658828940466073*^9}, {
   3.658829245775367*^9, 3.658829275359365*^9}, 3.658829305926353*^9, {
   3.658829343658095*^9, 3.658829361640295*^9}, 3.658830580389295*^9, {
   3.658830963434209*^9, 3.658830990077829*^9}, 3.658831116111267*^9, 
   3.658831747764428*^9, 3.658831854858107*^9, 3.658834808279861*^9, {
   3.6588350771889277`*^9, 3.658835103572028*^9}, {3.6588351847215567`*^9, 
   3.658835195675692*^9}, 3.6588352765361767`*^9, 3.6588358027723637`*^9, 
   3.6588358807530003`*^9, {3.6588359109498167`*^9, 3.6588359222211733`*^9}, {
   3.65883642972532*^9, 3.658836454718008*^9}, {3.658836491411438*^9, 
   3.658836501448748*^9}, 3.658836885026032*^9, 3.6588369539771223`*^9, 
   3.6588373900725307`*^9, 3.65883743701831*^9, 3.6588375064132233`*^9, 
   3.658837646311397*^9, 3.658837876292055*^9, 3.658838013100665*^9, 
   3.658838110098091*^9, 3.658838177545555*^9, 3.658838247959958*^9, 
   3.6588386666850767`*^9, 3.6588397321192904`*^9, 3.65907381393369*^9, {
   3.659073978803946*^9, 3.659074004704434*^9}, 3.664788329856463*^9, 
   3.6647894870636597`*^9}]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Model Output", "Section",
 CellChangeTimes->{{3.647001018344447*^9, 3.647001020415841*^9}}],

Cell[CellGroupData[{

Cell["UFO Model", "Subsection",
 CellChangeTimes->{{3.6557916852095203`*^9, 3.655791687722753*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Write", " ", "UFO", " ", "output", " ", "to", " ", "model", " ", 
    "location"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"locMF", "<>", "\"\<ufo_models\>\""}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"WriteUFO", "[", 
     RowBox[{
      RowBox[{"LSM", "+", "LRM"}], ",", 
      RowBox[{"Output", "\[Rule]", "M$ModelOutputDir"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "locMF", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.655029219205811*^9, 3.655029219429003*^9}, {
   3.655099968666996*^9, 3.655099968971363*^9}, {3.655100028265877*^9, 
   3.655100054332181*^9}, {3.65864769375811*^9, 3.65864769804309*^9}, 
   3.6647875830952997`*^9}],

Cell[CellGroupData[{

Cell["Automatic UFO Generation", "Subsubsection",
 CellChangeTimes->{{3.6550291912685833`*^9, 3.6550292010528383`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Write", " ", "UFO", " ", "output", " ", "to", " ", "model", " ", 
    "location"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{"AutoUFOModel", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SetDirectory", "[", 
       RowBox[{"locMF", "<>", "\"\<ufo_models\>\""}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"WriteUFO", "[", 
       RowBox[{
        RowBox[{"LSM", "+", "LRM"}], ",", 
        RowBox[{"Output", "\[Rule]", "M$ModelOutputDir"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetDirectory", "[", "locMF", "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.568453683169607*^9, 3.568454805562674*^9, 3.568456848711566*^9, {
   3.56845919783318*^9, 3.56845920260916*^9}, {3.569144511912423*^9, 
   3.569144535690543*^9}, {3.569144619417001*^9, 3.569144621394456*^9}, {
   3.5691446563698177`*^9, 3.569144660482048*^9}, {3.5891942212739477`*^9, 
   3.589194233231311*^9}, {3.591532239477763*^9, 3.591532242306498*^9}, {
   3.591533301228033*^9, 3.591533303306046*^9}, {3.646997438053999*^9, 
   3.6469974384664793`*^9}, 3.646998382133109*^9, {3.6471537783067303`*^9, 
   3.6471537806873007`*^9}, {3.647851677551371*^9, 3.647851712588777*^9}, {
   3.654589381470702*^9, 3.654589381810511*^9}, {3.654589477825758*^9, 
   3.6545894786868353`*^9}, {3.654591075366694*^9, 3.654591077786544*^9}, {
   3.655029203989643*^9, 3.655029212819235*^9}, 3.655029256772698*^9, {
   3.6550999541463823`*^9, 3.655099962078816*^9}, 3.6551000752018967`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{3.666010402943145*^9, 3.66601044973637*^9, 
  3.6660105055971813`*^9, 3.6660106308027554`*^9, 3.66601083063031*^9, 
  3.66601089451433*^9, 3.666010971819778*^9, 3.6660110328943*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.666010402943145*^9, 3.66601044973637*^9, 
  3.6660105055971813`*^9, 3.6660106308027554`*^9, 3.66601083063031*^9, 
  3.66601089451433*^9, 3.666010971819778*^9, 3.666011033199007*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.666010402943145*^9, 3.66601044973637*^9, 
  3.6660105055971813`*^9, 3.6660106308027554`*^9, 3.66601083063031*^9, 
  3.66601089451433*^9, 3.666010971819778*^9, 3.666011033200243*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.666010402943145*^9, 3.66601044973637*^9, 
  3.6660105055971813`*^9, 3.6660106308027554`*^9, 3.66601083063031*^9, 
  3.66601089451433*^9, 3.666010971819778*^9, 3.666011036861393*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "140", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{24., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "140", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  140, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 140, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.666010402943145*^9, 3.66601044973637*^9, 
  3.6660105055971813`*^9, 3.6660106308027554`*^9, 3.66601083063031*^9, 
  3.66601089451433*^9, 3.666010971819778*^9, 3.666011036952406*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"134", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[134, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.666010402943145*^9, 3.66601044973637*^9, 
  3.6660105055971813`*^9, 3.6660106308027554`*^9, 3.66601083063031*^9, 
  3.66601089451433*^9, 3.666010971819778*^9, 3.6660110402377987`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{24., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "134"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 134],
  Editable->False]], "Print",
 CellChangeTimes->{3.666010402943145*^9, 3.66601044973637*^9, 
  3.6660105055971813`*^9, 3.6660106308027554`*^9, 3.66601083063031*^9, 
  3.66601089451433*^9, 3.666010971819778*^9, 3.6660110432455397`*^9}],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{3.666010402943145*^9, 3.66601044973637*^9, 
  3.6660105055971813`*^9, 3.6660106308027554`*^9, 3.66601083063031*^9, 
  3.66601089451433*^9, 3.666010971819778*^9, 3.666011045102*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.666010402943145*^9, 3.66601044973637*^9, 
  3.6660105055971813`*^9, 3.6660106308027554`*^9, 3.66601083063031*^9, 
  3.66601089451433*^9, 3.666010971819778*^9, 3.6660110451954117`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{16., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "78"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 78],
  Editable->False]], "Print",
 CellChangeTimes->{3.666010402943145*^9, 3.66601044973637*^9, 
  3.6660105055971813`*^9, 3.6660106308027554`*^9, 3.66601083063031*^9, 
  3.66601089451433*^9, 3.666010971819778*^9, 3.666011045196587*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "1.655748`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 1.655748, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.666010402943145*^9, 3.66601044973637*^9, 
  3.6660105055971813`*^9, 3.6660106308027554`*^9, 3.66601083063031*^9, 
  3.66601089451433*^9, 3.666010971819778*^9, 3.666011046801394*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.044284`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 0.044284, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.666010402943145*^9, 3.66601044973637*^9, 
  3.6660105055971813`*^9, 3.6660106308027554`*^9, 3.66601083063031*^9, 
  3.66601089451433*^9, 3.666010971819778*^9, 3.6660110468930063`*^9}],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{3.666010402943145*^9, 3.66601044973637*^9, 
  3.6660105055971813`*^9, 3.6660106308027554`*^9, 3.66601083063031*^9, 
  3.66601089451433*^9, 3.666010971819778*^9, 3.6660110468939734`*^9}],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{3.666010402943145*^9, 3.66601044973637*^9, 
  3.6660105055971813`*^9, 3.6660106308027554`*^9, 3.66601083063031*^9, 
  3.66601089451433*^9, 3.666010971819778*^9, 3.666011047045968*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{24., {0., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "216", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 216, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{3.666010402943145*^9, 3.66601044973637*^9, 
  3.6660105055971813`*^9, 3.6660106308027554`*^9, 3.66601083063031*^9, 
  3.66601089451433*^9, 3.666010971819778*^9, 3.666011047301505*^9}],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{3.666010402943145*^9, 3.66601044973637*^9, 
  3.6660105055971813`*^9, 3.6660106308027554`*^9, 3.66601083063031*^9, 
  3.66601089451433*^9, 3.666010971819778*^9, 3.666011047521305*^9}],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{3.666010402943145*^9, 3.66601044973637*^9, 
  3.6660105055971813`*^9, 3.6660106308027554`*^9, 3.66601083063031*^9, 
  3.66601089451433*^9, 3.666010971819778*^9, 3.666011047842762*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CalcHEP Model", "Subsection",
 CellChangeTimes->{{3.655791705146821*^9, 3.655791708962453*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Write", " ", "CalcHEP", " ", "output", " ", "to", " ", "model", " ", 
    "location"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"locMF", "<>", "\"\<calchep_models\>\""}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"WriteCHOutput", "[", 
     RowBox[{
      RowBox[{"LSM", "+", "LRM"}], " ", ",", 
      RowBox[{"Output", "\[Rule]", "M$ModelOutputDir"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "locMF", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.655791847448575*^9, 3.655791899022543*^9}}],

Cell[CellGroupData[{

Cell["Automatic CalcHEP Generation", "Subsubsection",
 CellChangeTimes->{{3.6550291912685833`*^9, 3.6550292010528383`*^9}, {
  3.6557949766701183`*^9, 3.6557949780381002`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Write", " ", "UFO", " ", "output", " ", "to", " ", "model", " ", 
    "location"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{"AutoCalcHEPModel", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SetDirectory", "[", 
       RowBox[{"locMF", "<>", "\"\<calchep_models\>\""}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"WriteCHOutput", "[", 
       RowBox[{
        RowBox[{"LSM", "+", "LRM"}], " ", ",", 
        RowBox[{"Output", "\[Rule]", "M$ModelOutputDir"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetDirectory", "[", "locMF", "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.568453683169607*^9, 3.568454805562674*^9, 3.568456848711566*^9, {
   3.56845919783318*^9, 3.56845920260916*^9}, {3.569144511912423*^9, 
   3.569144535690543*^9}, {3.569144619417001*^9, 3.569144621394456*^9}, {
   3.5691446563698177`*^9, 3.569144660482048*^9}, {3.5891942212739477`*^9, 
   3.589194233231311*^9}, {3.591532239477763*^9, 3.591532242306498*^9}, {
   3.591533301228033*^9, 3.591533303306046*^9}, {3.646997438053999*^9, 
   3.6469974384664793`*^9}, 3.646998382133109*^9, {3.6471537783067303`*^9, 
   3.6471537806873007`*^9}, {3.647851677551371*^9, 3.647851712588777*^9}, {
   3.654589381470702*^9, 3.654589381810511*^9}, {3.654589477825758*^9, 
   3.6545894786868353`*^9}, {3.654591075366694*^9, 3.654591077786544*^9}, {
   3.655029203989643*^9, 3.655029212819235*^9}, 3.655029256772698*^9, {
   3.6550999541463823`*^9, 3.655099962078816*^9}, 3.6551000752018967`*^9, {
   3.655794962219224*^9, 3.655794974014209*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - - - FeynRules interface to CalcHep/CompHEP\"\>"], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.6660110509896173`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" - - - \"\>", "\[InvisibleSpace]", 
   StyleBox["\<\"Authors:\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" N. Christensen, C. Duhr\"\>"}],
  SequenceForm[" - - - ", 
   Style["Authors:", 
    RGBColor[0, 0, 1]], " N. Christensen, C. Duhr"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.66601105099072*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" - - - \"\>", "\[InvisibleSpace]", 
   StyleBox["\<\"Please cite:\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" arXiv:0906.2474\"\>"}],
  SequenceForm[" - - - ", 
   Style["Please cite:", 
    RGBColor[0, 0, 1]], " arXiv:0906.2474"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.6660110509916153`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" files to \
/home/maikel/physics/dijet_met/physics/resonance_met_models/calchep_models/so_\
met.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], 
   " files to \
/home/maikel/physics/dijet_met/physics/resonance_met_models/calchep_models/so_\
met."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011050992223*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" particles file 'prtcls1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " particles file 'prtcls1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.6660110509928427`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\tWarning!\"\>",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], 
   "\[InvisibleSpace]", "\<\"  I notice you have more than one color octet.\"\
\>"}],
  SequenceForm[
   Style["\tWarning!", 
    RGBColor[1, 0, 0]], "  I notice you have more than one color octet."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011051031261*^9}],

Cell[BoxData["\<\"\\t\\tIn CH, 4-point color octet vertices are \
nontrivial,\\n\\t\\t and must be added with an auxilliary field.\"\>"], \
"Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.66601105103199*^9}],

Cell[BoxData["\<\"\\t\\tPlease refer to the CH manual for these \
vertices.\"\>"], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011051032568*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" external parameter file 'vars1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " external parameter file 'vars1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011051033099*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" internal parameter file 'func1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " internal parameter file 'func1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011051033618*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" external library file 'extlib1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " external library file 'extlib1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.6660110510861597`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011051086886*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011051242559*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.66601105124347*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"4\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "4", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011051244018*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011055137629*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "140", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{24., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "140", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  140, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 140, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.6660110551934233`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"134", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[134, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011058553886*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{24., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "134"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 134],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011061503996*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" vertices file 'lgrng1.mdl'\\nand appending \
variable file 'func1.mdl', particle file 'prtcls1.mdl' and variable file \
'vars1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], 
   " vertices file 'lgrng1.mdl'\nand appending variable file 'func1.mdl', \
particle file 'prtcls1.mdl' and variable file 'vars1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011063396703*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\tWarning!\"\>",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], 
   "\[InvisibleSpace]", "\<\"  The following vertex is not implemented in \
FeynRules->CH yet.\"\>"}],
  SequenceForm[
   Style["\tWarning!", 
    RGBColor[1, 0, 0]], 
   "  The following vertex is not implemented in FeynRules->CH yet."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011063603578*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\t\\t\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"g\"\>", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"g\"\>", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"M1\"\>", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"M1~\"\>", ",", "4"}], "}"}]}], "}"}]}],
  SequenceForm["\t\t", {{"g", 1}, {"g", 2}, {"M1", 3}, {"M1~", 4}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011063604657*^9}],

Cell[BoxData["\<\"\\t\\tYou can add this vertex by hand after importing into \
CalcHEP.\"\>"], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.6660110636062803`*^9}],

Cell[BoxData["\<\"\\t\\tYou may also wish to help implement it in \
FeynRules->CH.\"\>"], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011063606896*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\tWarning!\"\>",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], 
   "\[InvisibleSpace]", "\<\"  The following vertex is not implemented in \
FeynRules->CH yet.\"\>"}],
  SequenceForm[
   Style["\tWarning!", 
    RGBColor[1, 0, 0]], 
   "  The following vertex is not implemented in FeynRules->CH yet."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011063662875*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\t\\t\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"g\"\>", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"g\"\>", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"M2\"\>", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"M2~\"\>", ",", "4"}], "}"}]}], "}"}]}],
  SequenceForm["\t\t", {{"g", 1}, {"g", 2}, {"M2", 3}, {"M2~", 4}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011063663945*^9}],

Cell[BoxData["\<\"\\t\\tYou can add this vertex by hand after importing into \
CalcHEP.\"\>"], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011063664558*^9}],

Cell[BoxData["\<\"\\t\\tYou may also wish to help implement it in \
FeynRules->CH.\"\>"], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011063665098*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nFinishing\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" vertices file 'lgrng1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nFinishing", 
    RGBColor[0, 0, 1]], " vertices file 'lgrng1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.6660110650097017`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"Finishing\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" internal parameter file 'func1.mdl'.\"\>"}],
  SequenceForm[
   Style["Finishing", 
    RGBColor[0, 0, 1]], " internal parameter file 'func1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011065066032*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nDone\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" in 0.23min!\"\>"}],
  SequenceForm[
   Style["\nDone", 
    RGBColor[0, 0, 1]], " in 0.23min!"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6660104175094013`*^9, 3.666010464621735*^9, 
  3.666010524631405*^9, 3.666010650239482*^9, 3.666010849525848*^9, 
  3.666010909830435*^9, 3.666010986417746*^9, 3.666011065067363*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1855, 1176},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"10.3 for Linux x86 (64-bit) (December 10, 2015)",
StyleDefinitions->FrontEnd`FileName[{"Report"}, "StandardReport.nb", 
  CharacterEncoding -> "UTF-8"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 308, 4, 91, "Title"],
Cell[890, 28, 473, 7, 91, "Text"],
Cell[1366, 37, 136, 3, 41, "Input"],
Cell[1505, 42, 8451, 136, 240, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[9981, 182, 150, 2, 67, "Section"],
Cell[10134, 186, 598, 14, 86, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[10757, 204, 765, 18, 86, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[11547, 226, 229, 3, 23, "Print"],
Cell[11779, 231, 510, 10, 23, "Print"],
Cell[12292, 243, 283, 4, 23, "Print"],
Cell[12578, 249, 215, 3, 23, "Print"],
Cell[12796, 254, 228, 3, 23, "Print"],
Cell[13027, 259, 278, 4, 23, "Print"],
Cell[13308, 265, 278, 4, 23, "Print"],
Cell[13589, 271, 215, 3, 23, "Print"],
Cell[13807, 276, 244, 3, 23, "Print"],
Cell[14054, 281, 215, 3, 23, "Print"],
Cell[14272, 286, 282, 4, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14603, 296, 2319, 43, 152, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[16947, 343, 237, 3, 23, "Print"],
Cell[17187, 348, 255, 3, 23, "Print"],
Cell[17445, 353, 226, 3, 23, "Print"],
Cell[17674, 358, 226, 3, 23, "Print"],
Cell[17903, 363, 361, 7, 23, "Print"],
Cell[18267, 372, 226, 3, 23, "Print"],
Cell[18496, 377, 246, 3, 23, "Print"],
Cell[18745, 382, 264, 4, 23, "Print"],
Cell[19012, 388, 263, 4, 23, "Print"],
Cell[19278, 394, 215, 3, 23, "Print"],
Cell[19496, 399, 245, 3, 23, "Print"],
Cell[19744, 404, 248, 3, 23, "Print"],
Cell[19995, 409, 248, 3, 23, "Print"],
Cell[20246, 414, 461, 9, 43, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20756, 429, 176, 4, 41, "Input"],
Cell[CellGroupData[{
Cell[20957, 437, 306, 6, 23, "Print"],
Cell[21266, 445, 246, 5, 23, "Print"],
Cell[21515, 452, 242, 5, 23, "Print"],
Cell[21760, 459, 109, 1, 23, "Print"],
Cell[21872, 462, 114, 1, 23, "Print"],
Cell[21989, 465, 114, 1, 23, "Print"],
Cell[22106, 468, 114, 1, 23, "Print"],
Cell[22223, 471, 114, 1, 23, "Print"],
Cell[22340, 474, 108, 1, 23, "Print"],
Cell[22451, 477, 126, 1, 23, "Print"],
Cell[22580, 480, 123, 1, 23, "Print"],
Cell[22706, 483, 114, 1, 23, "Print"]
}, Open  ]],
Cell[22835, 487, 1180, 21, 23, "Message"],
Cell[CellGroupData[{
Cell[24040, 512, 657, 17, 23, "Print"],
Cell[24700, 531, 107, 1, 23, "Print"]
}, Open  ]],
Cell[24822, 535, 1276, 24, 23, "Message"],
Cell[26101, 561, 760, 19, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26910, 586, 106, 1, 67, "Section"],
Cell[CellGroupData[{
Cell[27041, 591, 102, 1, 33, "Subsection"],
Cell[CellGroupData[{
Cell[27168, 596, 195, 3, 41, "Input"],
Cell[27366, 601, 5872, 166, 130, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33275, 772, 262, 4, 41, "Input"],
Cell[33540, 778, 895, 15, 23, "Print"],
Cell[34438, 795, 13474, 408, 310, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47961, 1209, 240, 3, 32, "Subsection"],
Cell[CellGroupData[{
Cell[48226, 1216, 784, 22, 130, "Input"],
Cell[CellGroupData[{
Cell[49035, 1242, 882, 19, 23, "Print"],
Cell[49920, 1263, 637, 11, 23, "Print"],
Cell[50560, 1276, 670, 12, 23, "Print"],
Cell[51233, 1290, 1151, 23, 23, "Print"],
Cell[52387, 1315, 748, 15, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53184, 1336, 1027, 26, 130, "Input"],
Cell[CellGroupData[{
Cell[54236, 1366, 923, 20, 23, "Print"],
Cell[55162, 1388, 698, 12, 23, "Print"],
Cell[55863, 1402, 711, 13, 23, "Print"],
Cell[56577, 1417, 1207, 24, 23, "Print"],
Cell[57787, 1443, 793, 16, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58629, 1465, 369, 6, 41, "Input"],
Cell[59001, 1473, 16472, 465, 532, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[75522, 1944, 100, 1, 33, "Subsection"],
Cell[CellGroupData[{
Cell[75647, 1949, 968, 23, 130, "Input"],
Cell[CellGroupData[{
Cell[76640, 1976, 468, 9, 23, "Print"],
Cell[77111, 1987, 405, 10, 23, "Print"],
Cell[77519, 1999, 375, 9, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[77943, 2014, 375, 7, 41, "Input"],
Cell[78321, 2023, 22271, 653, 649, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100629, 2681, 504, 11, 64, "Input"],
Cell[CellGroupData[{
Cell[101158, 2696, 481, 10, 23, "Print"],
Cell[101642, 2708, 470, 9, 23, "Print"],
Cell[102115, 2719, 468, 9, 23, "Print"],
Cell[102586, 2730, 465, 9, 23, "Print"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[103124, 2747, 169, 2, 67, "Section"],
Cell[CellGroupData[{
Cell[103318, 2753, 99, 1, 33, "Subsection"],
Cell[CellGroupData[{
Cell[103442, 2758, 420, 7, 41, "Input"],
Cell[CellGroupData[{
Cell[103887, 2769, 2478, 34, 23, "Print"],
Cell[106368, 2805, 2476, 34, 23, "Print"],
Cell[108847, 2841, 2669, 41, 23, "Print"],
Cell[111519, 2884, 2424, 33, 23, "Print"],
Cell[113946, 2919, 2457, 34, 23, "Print"],
Cell[116406, 2955, 2936, 45, 23, "Print"],
Cell[119345, 3002, 2539, 37, 23, "Print"],
Cell[121887, 3041, 2425, 33, 23, "Print"]
}, Open  ]],
Cell[124327, 3077, 2381, 33, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[126745, 3115, 227, 4, 41, "Input"],
Cell[126975, 3121, 1306, 18, 23, "Print"],
Cell[128284, 3141, 95, 1, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[128416, 3147, 372, 6, 41, "Input"],
Cell[CellGroupData[{
Cell[128813, 3157, 1972, 31, 23, "Print"],
Cell[130788, 3190, 1754, 25, 23, "Print"]
}, Open  ]],
Cell[132557, 3218, 624, 12, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133218, 3235, 357, 6, 41, "Input"],
Cell[133578, 3243, 1755, 25, 23, "Print"],
Cell[135336, 3270, 624, 12, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[135997, 3287, 367, 6, 41, "Input"],
Cell[CellGroupData[{
Cell[136389, 3297, 983, 19, 23, "Print"],
Cell[137375, 3318, 765, 13, 23, "Print"]
}, Open  ]],
Cell[138155, 3334, 628, 12, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[138820, 3351, 344, 5, 41, "Input"],
Cell[CellGroupData[{
Cell[139189, 3360, 987, 19, 23, "Print"],
Cell[140179, 3381, 767, 13, 23, "Print"],
Cell[140949, 3396, 779, 13, 23, "Print"]
}, Open  ]],
Cell[141743, 3412, 681, 10, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[142461, 3427, 320, 5, 41, "Input"],
Cell[CellGroupData[{
Cell[142806, 3436, 1056, 20, 23, "Print"],
Cell[143865, 3458, 833, 14, 23, "Print"],
Cell[144701, 3474, 827, 14, 23, "Print"],
Cell[145531, 3490, 868, 15, 23, "Print"]
}, Open  ]],
Cell[146414, 3508, 1384, 34, 104, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[147835, 3547, 1826, 46, 174, "Input"],
Cell[149664, 3595, 1449, 25, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[151162, 3626, 104, 1, 33, "Subsection"],
Cell[CellGroupData[{
Cell[151291, 3631, 1279, 34, 152, "Input"],
Cell[CellGroupData[{
Cell[152595, 3669, 1004, 18, 23, "Print"],
Cell[153602, 3689, 757, 10, 23, "Print"],
Cell[154362, 3701, 790, 11, 23, "Print"],
Cell[155155, 3714, 1274, 22, 23, "Print"],
Cell[156432, 3738, 872, 14, 23, "Print"],
Cell[157307, 3754, 1103, 18, 23, "Print"],
Cell[158413, 3774, 1040, 19, 23, "Print"],
Cell[159456, 3795, 1009, 18, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[160514, 3819, 103, 1, 31, "Subsubsection"],
Cell[CellGroupData[{
Cell[160642, 3824, 9548, 241, 596, "Input"],
Cell[CellGroupData[{
Cell[170215, 4069, 1714, 45, 53, "Print"],
Cell[171932, 4116, 1714, 45, 53, "Print"],
Cell[173649, 4163, 1314, 32, 54, "Print"],
Cell[174966, 4197, 1198, 29, 53, "Print"],
Cell[176167, 4228, 958, 22, 46, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[177186, 4257, 156, 2, 31, "Subsubsection"],
Cell[CellGroupData[{
Cell[177367, 4263, 5707, 145, 374, "Input"],
Cell[CellGroupData[{
Cell[183099, 4412, 1422, 41, 53, "Print"],
Cell[184524, 4455, 566, 15, 48, "Print"],
Cell[185093, 4472, 2230, 57, 53, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[187372, 4535, 713, 19, 64, "Input"],
Cell[188088, 4556, 1143, 37, 72, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[189268, 4598, 277, 5, 41, "Input"],
Cell[189548, 4605, 5916, 173, 179, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[195513, 4784, 107, 1, 31, "Subsubsection"],
Cell[195623, 4787, 4800, 123, 367, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[200460, 4915, 158, 2, 31, "Subsubsection"],
Cell[200621, 4919, 9976, 249, 643, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[210646, 5174, 124, 1, 33, "Subsection"],
Cell[CellGroupData[{
Cell[210795, 5179, 368, 8, 86, "Input"],
Cell[211166, 5189, 4107, 121, 79, "Output"],
Cell[215276, 5312, 605, 8, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[215918, 5325, 4125, 102, 438, "Input"],
Cell[CellGroupData[{
Cell[220068, 5431, 1416, 24, 23, "Print"],
Cell[221487, 5457, 1172, 16, 23, "Print"],
Cell[222662, 5475, 1207, 17, 23, "Print"],
Cell[223872, 5494, 1683, 28, 23, "Print"],
Cell[225558, 5524, 1285, 20, 23, "Print"],
Cell[226846, 5546, 1417, 24, 23, "Print"],
Cell[228266, 5572, 1172, 16, 23, "Print"],
Cell[229441, 5590, 1207, 17, 23, "Print"],
Cell[230651, 5609, 1683, 28, 23, "Print"],
Cell[232337, 5639, 1285, 20, 23, "Print"],
Cell[233625, 5661, 1445, 25, 23, "Print"]
}, Open  ]],
Cell[235085, 5689, 3447, 88, 73, "Output"],
Cell[238535, 5779, 3447, 88, 73, "Output"],
Cell[241985, 5869, 1495, 25, 23, "Print"],
Cell[243483, 5896, 3447, 88, 73, "Output"],
Cell[246933, 5986, 3449, 88, 73, "Output"],
Cell[250385, 6076, 1451, 25, 23, "Print"]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[251897, 6108, 97, 1, 67, "Section"],
Cell[CellGroupData[{
Cell[252019, 6113, 99, 1, 32, "Subsection"],
Cell[252121, 6116, 851, 22, 108, "Input"],
Cell[CellGroupData[{
Cell[252997, 6142, 119, 1, 31, "Subsubsection"],
Cell[CellGroupData[{
Cell[253141, 6147, 1659, 33, 152, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[254825, 6184, 284, 4, 23, "Print"],
Cell[255112, 6190, 509, 11, 23, "Print"],
Cell[255624, 6203, 264, 3, 23, "Print"],
Cell[255891, 6208, 297, 4, 23, "Print"],
Cell[256191, 6214, 782, 15, 23, "Print"],
Cell[256976, 6231, 383, 7, 23, "Print"],
Cell[257362, 6240, 612, 11, 23, "Print"],
Cell[257977, 6253, 275, 3, 23, "Print"],
Cell[258255, 6258, 547, 12, 23, "Print"],
Cell[258805, 6272, 515, 11, 23, "Print"],
Cell[259323, 6285, 477, 8, 23, "Print"],
Cell[259803, 6295, 465, 8, 23, "Print"],
Cell[260271, 6305, 263, 3, 23, "Print"],
Cell[260537, 6310, 285, 4, 23, "Print"],
Cell[260825, 6316, 635, 11, 23, "Print"],
Cell[261463, 6329, 257, 3, 23, "Print"],
Cell[261723, 6334, 242, 3, 23, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[262038, 6345, 101, 1, 32, "Subsection"],
Cell[262142, 6348, 697, 19, 108, "Input"],
Cell[CellGroupData[{
Cell[262864, 6371, 176, 2, 31, "Subsubsection"],
Cell[CellGroupData[{
Cell[263065, 6377, 1727, 34, 152, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[264817, 6415, 285, 3, 23, "Print"],
Cell[265105, 6420, 723, 17, 23, "Print"],
Cell[265831, 6439, 718, 17, 23, "Print"],
Cell[266552, 6458, 824, 22, 43, "Print"],
Cell[267379, 6482, 690, 17, 43, "Print"],
Cell[268072, 6501, 724, 18, 23, "Print"],
Cell[268799, 6521, 351, 5, 43, "Print"],
Cell[269153, 6528, 295, 4, 23, "Print"],
Cell[269451, 6534, 702, 17, 43, "Print"],
Cell[270156, 6553, 702, 17, 43, "Print"],
Cell[270861, 6572, 704, 17, 43, "Print"],
Cell[271568, 6591, 238, 3, 23, "Print"],
Cell[271809, 6596, 510, 11, 23, "Print"],
Cell[272322, 6609, 264, 3, 23, "Print"],
Cell[272589, 6614, 489, 9, 23, "Print"],
Cell[273081, 6625, 298, 4, 23, "Print"],
Cell[273382, 6631, 785, 15, 23, "Print"],
Cell[274170, 6648, 382, 7, 23, "Print"],
Cell[274555, 6657, 611, 11, 23, "Print"],
Cell[275169, 6670, 895, 21, 62, "Print"],
Cell[276067, 6693, 762, 19, 23, "Print"],
Cell[276832, 6714, 708, 17, 23, "Print"],
Cell[277543, 6733, 309, 4, 23, "Print"],
Cell[277855, 6739, 302, 4, 23, "Print"],
Cell[278160, 6745, 762, 19, 23, "Print"],
Cell[278925, 6766, 708, 17, 23, "Print"],
Cell[279636, 6785, 307, 4, 23, "Print"],
Cell[279946, 6791, 302, 4, 23, "Print"],
Cell[280251, 6797, 690, 17, 43, "Print"],
Cell[280944, 6816, 701, 17, 23, "Print"],
Cell[281648, 6835, 646, 17, 43, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
